/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.text.DateFormat;
import org.catacombae.jparted.lib.fs.FSAttributes;

/**
 *
 * @author  Erik
 */
public class DateSummaryPanel extends javax.swing.JPanel implements ChainedPanel {

    /** Creates new form DateSummaryPanel */
    public DateSummaryPanel(FSAttributes attributes) {
        initComponents();
        
        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM);
        if(attributes.hasCreateDate())
            createField.setText(df.format(attributes.getCreateDate()));
        else {
            //createLabel.setVisible(false);
            createField.setText("<not available>");
        }
            
        if(attributes.hasModifyDate())
            contentModField.setText(df.format(attributes.getModifyDate()));
        else {
            //contentModLabel.setVisible(false);
            contentModField.setText("<not available>");
        }
            
        if(attributes.hasAttributeModifyDate())
            attributeModField.setText(df.format(attributes.getAttributeModifyDate()));
        else {
            //attributeModLabel.setVisible(false);
            attributeModField.setText("<not available>");
        }
            
        if(attributes.hasAccessDate())
            accessField.setText(df.format(attributes.getAccessDate()));
        else {
            //accessLabel.setVisible(false);
            accessField.setText("<not available>");
        }
            
        if(attributes.hasBackupDate())
            backupField.setText(df.format(attributes.getBackupDate()));
        else {
            //backupLabel.setVisible(false);
            backupField.setText("<not available>");
        }
                    
        //if(attributes.hasDate())
        //    createField.setText(attributes.getDate().toString());
    }
    
    @Override
    public void setChainedContents(Component c) {
        chainedContentsPanel.removeAll();
        chainedContentsPanel.add(c);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        createLabel = new javax.swing.JLabel();
        contentModLabel = new javax.swing.JLabel();
        attributeModLabel = new javax.swing.JLabel();
        accessLabel = new javax.swing.JLabel();
        backupLabel = new javax.swing.JLabel();
        createField = new javax.swing.JTextField();
        contentModField = new javax.swing.JTextField();
        attributeModField = new javax.swing.JTextField();
        accessField = new javax.swing.JTextField();
        backupField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        chainedContentsPanel = new javax.swing.JPanel();

        createLabel.setText("Created:");

        contentModLabel.setText("Contents modified:");

        attributeModLabel.setText("Attributes modified:");

        accessLabel.setText("Last accessed:");

        backupLabel.setText("Last backuped:");

        createField.setEditable(false);
        createField.setText("jTextField1");
        createField.setBorder(null);
        createField.setOpaque(false);

        contentModField.setEditable(false);
        contentModField.setText("jTextField2");
        contentModField.setBorder(null);
        contentModField.setOpaque(false);

        attributeModField.setEditable(false);
        attributeModField.setText("jTextField5");
        attributeModField.setBorder(null);
        attributeModField.setOpaque(false);

        accessField.setEditable(false);
        accessField.setText("jTextField3");
        accessField.setBorder(null);
        accessField.setOpaque(false);

        backupField.setEditable(false);
        backupField.setText("jTextField4");
        backupField.setBorder(null);
        backupField.setOpaque(false);

        chainedContentsPanel.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(attributeModLabel)
                    .add(contentModLabel)
                    .add(accessLabel)
                    .add(backupLabel)
                    .add(createLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(createField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                    .add(backupField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                    .add(accessField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, contentModField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                    .add(attributeModField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)))
            .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 270, Short.MAX_VALUE)
            .add(chainedContentsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 270, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(createLabel)
                    .add(createField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(contentModLabel)
                    .add(contentModField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(attributeModLabel)
                    .add(attributeModField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(accessLabel)
                    .add(accessField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(backupLabel)
                    .add(backupField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(chainedContentsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 10, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField accessField;
    private javax.swing.JLabel accessLabel;
    private javax.swing.JTextField attributeModField;
    private javax.swing.JLabel attributeModLabel;
    private javax.swing.JTextField backupField;
    private javax.swing.JLabel backupLabel;
    private javax.swing.JPanel chainedContentsPanel;
    private javax.swing.JTextField contentModField;
    private javax.swing.JLabel contentModLabel;
    private javax.swing.JTextField createField;
    private javax.swing.JLabel createLabel;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

}
