/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.apm;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.ApplePartitionMap;
import org.catacombae.hfsexplorer.partitioning.DriverDescriptorRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.StandardPartition;

public class APMHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public APMHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        ApplePartitionMap apm = this.readPartitionMap();
        return apm.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        ApplePartitionMap apm = this.readPartitionMap();
        Partition[] result = new Partition[apm.getUsedPartitionCount()];
        org.catacombae.hfsexplorer.partitioning.Partition[] apmParts = apm.getUsedPartitionEntries();
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StandardPartition(apmParts[i].getStartOffset(), apmParts[i].getLength(), apmParts[i].getType());
        }
        return result;
    }

    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplePartitionMap readPartitionMap() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            DriverDescriptorRecord ddr = new DriverDescriptorRecord(firstBlock, 0);
            if (ddr.isValid()) {
                int blockSize = Util.unsign(ddr.getSbBlkSize());
                ApplePartitionMap apm = new ApplePartitionMap(llf, (long)(blockSize * 1), blockSize);
                if (apm.getPartitionCount() > 0) {
                    ApplePartitionMap applePartitionMap = apm;
                    return applePartitionMap;
                }
                ApplePartitionMap applePartitionMap = null;
                return applePartitionMap;
            }
            ApplePartitionMap applePartitionMap = null;
            return applePartitionMap;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

