// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetServiceIDReader is a Reader for the GetServiceID structure.
type GetServiceIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetServiceIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetServiceIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetServiceIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /service/{id}] GetServiceID", response, response.Code())
	}
}

// NewGetServiceIDOK creates a GetServiceIDOK with default headers values
func NewGetServiceIDOK() *GetServiceIDOK {
	return &GetServiceIDOK{}
}

/*
GetServiceIDOK describes a response with status code 200, with default header values.

Success
*/
type GetServiceIDOK struct {
	Payload *models.Service
}

// IsSuccess returns true when this get service Id o k response has a 2xx status code
func (o *GetServiceIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get service Id o k response has a 3xx status code
func (o *GetServiceIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get service Id o k response has a 4xx status code
func (o *GetServiceIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get service Id o k response has a 5xx status code
func (o *GetServiceIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get service Id o k response a status code equal to that given
func (o *GetServiceIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get service Id o k response
func (o *GetServiceIDOK) Code() int {
	return 200
}

func (o *GetServiceIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /service/{id}][%d] getServiceIdOK %s", 200, payload)
}

func (o *GetServiceIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /service/{id}][%d] getServiceIdOK %s", 200, payload)
}

func (o *GetServiceIDOK) GetPayload() *models.Service {
	return o.Payload
}

func (o *GetServiceIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Service)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetServiceIDNotFound creates a GetServiceIDNotFound with default headers values
func NewGetServiceIDNotFound() *GetServiceIDNotFound {
	return &GetServiceIDNotFound{}
}

/*
GetServiceIDNotFound describes a response with status code 404, with default header values.

Service not found
*/
type GetServiceIDNotFound struct {
}

// IsSuccess returns true when this get service Id not found response has a 2xx status code
func (o *GetServiceIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get service Id not found response has a 3xx status code
func (o *GetServiceIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get service Id not found response has a 4xx status code
func (o *GetServiceIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get service Id not found response has a 5xx status code
func (o *GetServiceIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get service Id not found response a status code equal to that given
func (o *GetServiceIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get service Id not found response
func (o *GetServiceIDNotFound) Code() int {
	return 404
}

func (o *GetServiceIDNotFound) Error() string {
	return fmt.Sprintf("[GET /service/{id}][%d] getServiceIdNotFound", 404)
}

func (o *GetServiceIDNotFound) String() string {
	return fmt.Sprintf("[GET /service/{id}][%d] getServiceIdNotFound", 404)
}

func (o *GetServiceIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
