lib1305 is a microlibrary for the
Poly1305 one-time authenticator.

lib1305 has a very simple stateless [API](api.html)
based on the SUPERCOP API,
with wire-format inputs and outputs,
providing a function
`poly1305` to generate an authenticator
and a function
`poly1305_verify` to verify an authenticator.

Internally,
lib1305 includes implementations designed to work portably across CPUs,
and implementations designed for [higher performance](speed.html)
on Intel/AMD CPUs with BMI2 instructions.
lib1305 includes automatic run-time selection of implementations.

lib1305 is intended to be
called by larger multi-function libraries
(such as traditional cryptographic libraries),
including libraries in other languages via FFI.
The idea is that lib1305 takes responsibility
for the details of Poly1305 computation,
including optimization, timing-attack protection, and (planned) verification,
freeing up the calling libraries to concentrate on
application-specific needs such as protocol integration.
Applications can also call lib1305 directly.

Latest release: [20250407](download.html).
