# -*- coding: binary -*-

require 'spec_helper'

RSpec.describe Rex::Proto::X11::Connect do
  subject do
    mod = ::Msf::Exploit.new
    mod.extend described_class

    mod.send(:initialize)
    mod
  end

  let(:conn_request) do
    "\x6c\x00\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00"
  end

  let(:conn_error) do
    "\x00\x40\x0b\x00\x00\x00\x10\x00Authorization required, but no authorization protocol specified\x0a"
  end

  let(:conn_resp) do
    "\x01\x00\x0b\x00\x00\x00\x57\x09\x8c\xa5\xb8\x00\x00\x00\x00\x01" \
    "\xff\xff\x1f\x00\x00\x01\x00\x00\x14\x00\xff\xff\x01\x07\x00\x00" \
    "\x20\x20\x08\xff\x00\x00\x00\x00\x54\x68\x65\x20\x58\x2e\x4f\x72" \
    "\x67\x20\x46\x6f\x75\x6e\x64\x61\x74\x69\x6f\x6e\x01\x01\x20\x00" \
    "\x00\x00\x00\x00\x04\x08\x20\x00\x00\x00\x00\x00\x08\x08\x20\x00" \
    "\x00\x00\x00\x00\x0f\x10\x20\x00\x00\x00\x00\x00\x10\x10\x20\x00" \
    "\x00\x00\x00\x00\x18\x20\x20\x00\x00\x00\x00\x00\x20\x20\x20\x00" \
    "\x00\x00\x00\x00\x28\x05\x00\x00\x20\x00\x00\x00\xff\xff\xff\x00" \
    "\x00\x00\x00\x00\x33\x00\xda\x00\x00\x04\x00\x03\x0e\x01\xcb\x00" \
    "\x01\x00\x01\x00\x21\x00\x00\x00\x01\x00\x18\x07\x18\x00\x68\x01" \
    "\x00\x00\x00\x00\x21\x00\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xaa\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xab\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xac\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xad\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xae\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xaf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xba\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbe\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xca\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xcc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xce\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xda\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xdc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xde\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xea\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xeb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xec\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xed\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xee\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xef\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfa\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xff\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x01\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x02\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x03\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x04\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x05\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x06\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x07\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x09\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x10\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x11\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x12\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x13\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x14\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x15\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x16\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x17\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x18\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x19\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x20\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x21\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x22\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x23\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x24\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x25\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x26\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x27\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x28\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x29\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x30\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x31\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x32\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x33\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x34\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x35\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x36\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x37\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x38\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x39\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x40\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x41\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x42\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x43\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x44\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x45\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x46\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x47\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x48\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x49\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x50\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x51\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x52\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x53\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x54\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x55\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x56\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x57\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x58\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x59\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x60\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x61\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x62\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x63\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x64\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x65\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x66\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x67\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x68\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x69\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x70\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x71\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x72\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x73\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x74\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x75\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x76\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x77\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x78\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x79\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x80\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x81\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x82\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x83\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x84\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x85\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x86\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x87\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x88\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x89\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x90\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x91\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x92\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x93\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x94\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x95\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x96\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x97\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x98\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x99\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xaa\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xab\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xac\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xad\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xae\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xaf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xba\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbe\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xca\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xcc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xce\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xda\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xdc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xde\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xea\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xeb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xec\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xed\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xee\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xef\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfa\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfe\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xff\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x01\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x02\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x03\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x04\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x05\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x06\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x07\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x09\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00" \
    "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x20\x00\x1e\x00" \
    "\x00\x00\x00\x00\x5b\x00\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0a\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0b\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0c\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0d\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0e\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0f\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x10\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x11\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x12\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x13\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x14\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x15\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x16\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x17\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x18\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x19\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1a\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1b\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1c\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1d\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1e\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1f\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x20\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x21\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x22\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x23\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x24\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x25\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x26\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00"
  end

  let(:conn_resp2) do
    "\x01\x00\x0b\x00\x00\x00\x57\x09\x8c\xa5\xb8\x00\x00\x00\x20\x03" \
    "\xff\xff\x1f\x00\x00\x01\x00\x00\x14\x00\xff\xff\x01\x07\x00\x00" \
    "\x20\x20\x08\xff\x00\x00\x00\x00\x54\x68\x65\x20\x58\x2e\x4f\x72" \
    "\x67\x20\x46\x6f\x75\x6e\x64\x61\x74\x69\x6f\x6e\x01\x01\x20\x00" \
    "\x00\x00\x00\x00\x04\x08\x20\x00\x00\x00\x00\x00\x08\x08\x20\x00" \
    "\x00\x00\x00\x00\x0f\x10\x20\x00\x00\x00\x00\x00\x10\x10\x20\x00" \
    "\x00\x00\x00\x00\x18\x20\x20\x00\x00\x00\x00\x00\x20\x20\x20\x00" \
    "\x00\x00\x00\x00\x28\x05\x00\x00\x20\x00\x00\x00\xff\xff\xff\x00" \
    "\x00\x00\x00\x00\x33\x00\xda\x00\xbe\x03\x40\x03\xfd\x00\xdc\x00" \
    "\x01\x00\x01\x00\x21\x00\x00\x00\x01\x00\x18\x07\x18\x00\x68\x01" \
    "\x00\x00\x00\x00\x21\x00\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x22\x00\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xaa\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xab\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xac\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xad\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xae\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xaf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xba\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbe\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xca\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xcc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xce\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xda\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xdc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xde\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdf\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xea\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xeb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xec\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xed\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xee\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xef\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf0\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf1\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf2\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf3\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf4\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf5\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf6\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf7\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf8\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf9\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfa\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfb\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfc\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfd\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfe\x03\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xff\x03\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x01\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x02\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x03\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x04\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x05\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x06\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x07\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x09\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x10\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x11\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x12\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x13\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x14\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x15\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x16\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x17\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x18\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x19\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x20\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x21\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x22\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x23\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x24\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x25\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x26\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x27\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x28\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x29\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x2e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x2f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x30\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x31\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x32\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x33\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x34\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x35\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x36\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x37\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x38\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x39\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x3e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x3f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x40\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x41\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x42\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x43\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x44\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x45\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x46\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x47\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x48\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x49\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4a\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4b\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4c\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4d\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x4e\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x4f\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x50\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x51\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x52\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x53\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x54\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x55\x04\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x56\x04\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x57\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x58\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x59\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x5e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x5f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x60\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x61\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x62\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x63\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x64\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x65\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x66\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x67\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x68\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x69\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x6e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x6f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x70\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x71\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x72\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x73\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x74\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x75\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x76\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x77\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x78\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x79\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x7e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x7f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x80\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x81\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x82\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x83\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x84\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x85\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x86\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x87\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x88\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x89\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x8e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x8f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x90\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x91\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x92\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x93\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x94\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x95\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x96\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x97\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x98\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x99\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9a\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9b\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9c\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9d\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x9e\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x9f\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xa8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xa9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xaa\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xab\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xac\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xad\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xae\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xaf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xb8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xb9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xba\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xbe\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xbf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xc8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xc9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xca\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xcc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xce\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xcf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xd8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xd9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xda\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xdc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xde\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xdf\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xe8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xe9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xea\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xeb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xec\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xed\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xee\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xef\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf0\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf1\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf2\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf3\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf4\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf5\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf6\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf7\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xf8\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xf9\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfa\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfb\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfc\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xfd\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\xfe\x04\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\xff\x04\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x01\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x02\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x03\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x04\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x05\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x06\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x07\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x05\x00\x00\x05\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x09\x05\x00\x00" \
    "\x05\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00" \
    "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00" \
    "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x20\x00\x1e\x00" \
    "\x00\x00\x00\x00\x5b\x00\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0a\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0b\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0c\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0d\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x0e\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x0f\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x10\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x11\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x12\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x13\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x14\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x15\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x16\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x17\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x18\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x19\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1a\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1b\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1c\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1d\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x1e\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x1f\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x20\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x21\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x22\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x23\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x24\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00\x25\x05\x00\x00\x04\x08\x00\x01\x00\x00\xff\x00" \
    "\x00\xff\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x26\x05\x00\x00" \
    "\x04\x08\x00\x01\x00\x00\xff\x00\x00\xff\x00\x00\xff\x00\x00\x00" \
    "\x00\x00\x00\x00"
  end

  describe 'X11ConnectionRequest' do
    context '#read' do
      it do
        request = Rex::Proto::X11::X11ConnectionRequest.read(conn_request)
        expect(request.to_binary_s).to eq(conn_request)
      end
    end
    context '#initialize' do
      it do
        request = Rex::Proto::X11::X11ConnectionRequest.new
        expect(request.to_binary_s).to eq(conn_request)
      end
    end
  end

  describe 'X11Connection' do
    context '#read Error Response' do
      it do
        request = Rex::Proto::X11::X11Connection.read(conn_error)
        expect(request.body.reason).to eq("Authorization required, but no authorization protocol specified\n")
        expect(request.to_binary_s).to eq(conn_error)
      end
    end

    context '#read Success Response' do
      it do
        response = Rex::Proto::X11::X11Connection.read(conn_resp)
        expect(response.header.success).to eq(1)
        expect(response.body.resource_id_base).to eq(16777216)
        expect(response.body.vendor).to eq('The X.Org Foundation')
        expect(response.body.screen_width_in_pixels).to eq(1024)
        expect(response.body.screen_height_in_pixels).to eq(768)
      end
    end

    context '#read Success Response 2' do
      it do
        response = Rex::Proto::X11::X11Connection.read(conn_resp2)
        expect(response.header.success).to eq(1)
        expect(response.body.resource_id_base).to eq(52428800)
        expect(response.body.vendor).to eq('The X.Org Foundation')
        expect(response.body.screen_width_in_pixels).to eq(958)
        expect(response.body.screen_height_in_pixels).to eq(832)
      end
    end
  end
end
