#!/usr/bin/env python3

import asyncio
import typing
from pathlib import Path

from mitmproxy.proxy.mode_specs import ReverseMode

here = Path(__file__).parent.absolute()

filename = here / "../src/js/backends/consts.ts"


async def make() -> str:
    data = {
        "protocols": typing.get_args(typing.get_type_hints(ReverseMode)["scheme"]),
    }

    protocols = ",\n    ".join(
        f'{protocol.upper()} = "{protocol.lower()}"' for protocol in data["protocols"]
    )

    # language=TypeScript
    content = (
        "/** Auto-generated by web/gen/backend_consts.py */\n"
        "export enum ReverseProxyProtocols {\n"
        f"    {protocols},\n"
        "}\n"
    )

    return content


if __name__ == "__main__":
    filename.write_bytes(asyncio.run(make()).encode())
