/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.RunData;

public class SecurityCheck {
    private String message;
    private String failScreen;
    private RunData data = null;

    public boolean hasRole(Role role) throws Exception {
        boolean value = false;
        if (this.data.getACL() == null || !this.data.getACL().hasRole(role)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasRole(String role) throws Exception {
        return this.hasRole(TurbineSecurity.getRole(role));
    }

    public boolean hasPermission(Permission permission) throws Exception {
        boolean value = false;
        if (this.data.getACL() == null || !this.data.getACL().hasPermission(permission)) {
            this.data.setScreen(this.failScreen);
            this.data.setMessage(this.message);
        } else {
            value = true;
        }
        return value;
    }

    public boolean hasPermission(String permission) throws Exception {
        return this.hasPermission(TurbineSecurity.getPermission(permission));
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailScreen() {
        return this.failScreen;
    }

    public SecurityCheck(RunData data, String message, String failedScreen) {
        this.data = data;
        this.message = message;
        this.failScreen = failedScreen;
    }
}

