#ifndef TUI_H
#define TUI_H

#include <ncurses.h>

#include "pw/node.h"
#include "lib/pollen/pollen.h"

enum tui_tab {
    TUI_TAB_FIRST,
    PLAYBACK = TUI_TAB_FIRST,
    RECORDING,
    INPUT_DEVICES,
    OUTPUT_DEVICES,
    TUI_TAB_LAST = OUTPUT_DEVICES,
    TUI_TAB_COUNT,
};

struct tui_menu;
struct tui_menu_item;

typedef void (*tui_menu_callback_t)(struct tui_menu *menu, struct tui_menu_item *pick);

struct tui_menu_item {
    struct string str;

    union {
        void *ptr;
        uintptr_t uint;
    } data;
};

struct tui_menu {
    WINDOW *win;
    int x, y, w, h;
    struct string header;
    tui_menu_callback_t callback;

    union {
        void *ptr;
        uintptr_t uint;
    } data;

    unsigned int n_items;
    unsigned int selected;
    struct tui_menu_item items[];
};

struct tui {
    int term_height, term_width;

    WINDOW *bar_win;
    WINDOW *pad_win;

    bool menu_active;
    struct tui_menu *menu;

    enum tui_tab tab;
    struct {
        LIST_HEAD items;
        struct tui_tab_item *focused;
        int scroll_pos;
        bool user_changed_focus;
    } tabs[TUI_TAB_COUNT];
};

enum tui_tab_item_change_mask {
    TUI_TAB_ITEM_CHANGE_NOTHING = 0,
    TUI_TAB_ITEM_CHANGE_FOCUS = 1 << 0,
    TUI_TAB_ITEM_CHANGE_CHANNEL_LOCK = 1 << 1,
    TUI_TAB_ITEM_CHANGE_INFO = 1 << 2,
    TUI_TAB_ITEM_CHANGE_MUTE = 1 << 3,
    TUI_TAB_ITEM_CHANGE_VOLUME = 1 << 4,
    TUI_TAB_ITEM_CHANGE_SIZE = 1 << 5,
    TUI_TAB_ITEM_CHANGE_PORT = 1 << 6,
    TUI_TAB_ITEM_CHANGE_EVERYTHING = ~0,
};

struct tui_tab_item {
    const struct node *node;

    int pos, height;
    bool focused;
    enum tui_tab_item_change_mask change;

    bool unlocked_channels;
    uint32_t focused_channel;

    LIST_ENTRY link;
};

extern struct tui tui;

int tui_init(void);
int tui_cleanup(void);

int tui_handle_resize(struct pollen_callback *item, int signal, void *data);
int tui_handle_keyboard(struct pollen_callback *item, int fd, uint32_t events, void *data);

void tui_notify_node_new(const struct node *node);
void tui_notify_node_change(const struct node *node);
void tui_notify_node_remove(const struct node *node);

void tui_notify_device_change(const struct device *device);

/* binds */
union tui_bind_data;
typedef void (*tui_bind_func_t)(union tui_bind_data data);

enum tui_direction { UP, DOWN };
void tui_bind_change_focus(union tui_bind_data data);
void tui_bind_change_volume(union tui_bind_data data);
void tui_bind_change_tab(union tui_bind_data data);

void tui_bind_set_volume(union tui_bind_data data);
void tui_bind_set_tab(union tui_bind_data data);

enum tui_change_mode { ENABLE, DISABLE, TOGGLE };
void tui_bind_change_mute(union tui_bind_data data);
void tui_bind_change_channel_lock(union tui_bind_data data);

enum tui_nothing { NOTHING };
/* TODO: find a more sane way to do this lol */
#define TUI_BIND_QUIT ((tui_bind_func_t)0xDEAD)
void tui_bind_focus_first(union tui_bind_data data);
void tui_bind_focus_last(union tui_bind_data data);

void tui_bind_select_port(union tui_bind_data data);
void tui_bind_confirm_selection(union tui_bind_data data);
void tui_bind_cancel_selection(union tui_bind_data data);

union tui_bind_data {
    enum tui_direction direction;
    enum tui_change_mode change_mode;
    enum tui_tab tab;
    enum tui_nothing nothing;
    float volume;
};

struct tui_bind {
    union tui_bind_data data;
    tui_bind_func_t func;

    HASHMAP_ENTRY hash;
};

#endif /* #ifndef TUI_H */

