# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dnsresolver import DnsResolverManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsResolverManagementInboundEndpointsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsResolverManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.inbound_endpoints.begin_create_or_update(
            resource_group_name=resource_group.name,
            dns_resolver_name="str",
            inbound_endpoint_name="str",
            parameters={
                "ipConfigurations": [
                    {"subnet": {"id": "str"}, "privateIpAddress": "str", "privateIpAllocationMethod": "Dynamic"}
                ],
                "location": "str",
                "etag": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "resourceGuid": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2023-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.inbound_endpoints.begin_update(
            resource_group_name=resource_group.name,
            dns_resolver_name="str",
            inbound_endpoint_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2023-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.inbound_endpoints.begin_delete(
            resource_group_name=resource_group.name,
            dns_resolver_name="str",
            inbound_endpoint_name="str",
            api_version="2023-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.inbound_endpoints.get(
            resource_group_name=resource_group.name,
            dns_resolver_name="str",
            inbound_endpoint_name="str",
            api_version="2023-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.inbound_endpoints.list(
            resource_group_name=resource_group.name,
            dns_resolver_name="str",
            api_version="2023-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
