# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import DataBaseType, SourceType

if TYPE_CHECKING:
    from .. import models as _models


class ActivationLinks(_Model):
    """Activation Links model.

    :ivar new_cloud_account_activation_link: New Cloud Account Activation Link.
    :vartype new_cloud_account_activation_link: str
    :ivar existing_cloud_account_activation_link: Existing Cloud Account Activation Link.
    :vartype existing_cloud_account_activation_link: str
    """

    new_cloud_account_activation_link: Optional[str] = rest_field(
        name="newCloudAccountActivationLink", visibility=["read"]
    )
    """New Cloud Account Activation Link."""
    existing_cloud_account_activation_link: Optional[str] = rest_field(
        name="existingCloudAccountActivationLink", visibility=["read"]
    )
    """Existing Cloud Account Activation Link."""


class AddRemoveDbNode(_Model):
    """Add/Remove (Virtual Machine) DbNode model.

    :ivar db_servers: Db servers ocids. Required.
    :vartype db_servers: list[str]
    """

    db_servers: List[str] = rest_field(name="dbServers", visibility=["read", "create", "update", "delete", "query"])
    """Db servers ocids. Required."""

    @overload
    def __init__(
        self,
        *,
        db_servers: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AllConnectionStringType(_Model):
    """The connection string profile to allow clients to group, filter and select connection string
    values based on structured metadata.

    :ivar high: The High database service provides the highest level of resources to each SQL
     statement resulting in the highest performance, but supports the fewest number of concurrent
     SQL statements.
    :vartype high: str
    :ivar low: The Low database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype low: str
    :ivar medium: The Medium database service provides a lower level of resources to each SQL
     statement potentially resulting a lower level of performance, but supports more concurrent SQL
     statements.
    :vartype medium: str
    """

    high: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The High database service provides the highest level of resources to each SQL statement
     resulting in the highest performance, but supports the fewest number of concurrent SQL
     statements."""
    low: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Low database service provides the least level of resources to each SQL statement, but
     supports the most number of concurrent SQL statements."""
    medium: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Medium database service provides a lower level of resources to each SQL statement
     potentially resulting a lower level of performance, but supports more concurrent SQL
     statements."""

    @overload
    def __init__(
        self,
        *,
        high: Optional[str] = None,
        low: Optional[str] = None,
        medium: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApexDetailsType(_Model):
    """Information about Oracle APEX Application Development.

    :ivar apex_version: The Oracle APEX Application Development version.
    :vartype apex_version: str
    :ivar ords_version: The Oracle REST Data Services (ORDS) version.
    :vartype ords_version: str
    """

    apex_version: Optional[str] = rest_field(
        name="apexVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Oracle APEX Application Development version."""
    ords_version: Optional[str] = rest_field(
        name="ordsVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Oracle REST Data Services (ORDS) version."""

    @overload
    def __init__(
        self,
        *,
        apex_version: Optional[str] = None,
        ords_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabase(TrackedResource):
    """Autonomous Database  resource model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBaseProperties
    """

    properties: Optional["_models.AutonomousDatabaseBaseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AutonomousDatabaseBaseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    """


class AutonomousDatabaseBackup(ProxyResource):
    """AutonomousDatabaseBackup resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupProperties
    """

    properties: Optional["_models.AutonomousDatabaseBackupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutonomousDatabaseBackupProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseBackupProperties(_Model):
    """AutonomousDatabaseBackup resource model.

    :ivar autonomous_database_ocid: The OCID of the Autonomous Database.
    :vartype autonomous_database_ocid: str
    :ivar database_size_in_tbs: The size of the database in terabytes at the time the backup was
     taken.
    :vartype database_size_in_tbs: float
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar display_name: The user-friendly name for the backup. The name does not have to be unique.
    :vartype display_name: str
    :ivar ocid: The OCID of the Autonomous Database backup.
    :vartype ocid: str
    :ivar is_automatic: Indicates whether the backup is user-initiated or automatic.
    :vartype is_automatic: bool
    :ivar is_restorable: Indicates whether the backup can be used to restore the associated
     Autonomous Database.
    :vartype is_restorable: bool
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: The current state of the backup. Known values are: "Creating", "Active",
     "Deleting", "Failed", and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupLifecycleState
    :ivar retention_period_in_days: Retention period, in days.
    :vartype retention_period_in_days: int
    :ivar size_in_tbs: The backup size in terabytes (TB).
    :vartype size_in_tbs: float
    :ivar time_available_til: Timestamp until when the backup will be available.
    :vartype time_available_til: ~datetime.datetime
    :ivar time_started: The date and time the backup started.
    :vartype time_started: str
    :ivar time_ended: The date and time the backup completed.
    :vartype time_ended: str
    :ivar backup_type: The type of backup. Known values are: "Incremental", "Full", and "LongTerm".
    :vartype backup_type: str or ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupType
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    """

    autonomous_database_ocid: Optional[str] = rest_field(name="autonomousDatabaseOcid", visibility=["read"])
    """The OCID of the Autonomous Database."""
    database_size_in_tbs: Optional[float] = rest_field(name="databaseSizeInTbs", visibility=["read"])
    """The size of the database in terabytes at the time the backup was taken."""
    db_version: Optional[str] = rest_field(name="dbVersion", visibility=["read"])
    """A valid Oracle Database version for Autonomous Database."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read", "create"])
    """The user-friendly name for the backup. The name does not have to be unique."""
    ocid: Optional[str] = rest_field(visibility=["read"])
    """The OCID of the Autonomous Database backup."""
    is_automatic: Optional[bool] = rest_field(name="isAutomatic", visibility=["read"])
    """Indicates whether the backup is user-initiated or automatic."""
    is_restorable: Optional[bool] = rest_field(name="isRestorable", visibility=["read"])
    """Indicates whether the backup can be used to restore the associated Autonomous Database."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    lifecycle_state: Optional[Union[str, "_models.AutonomousDatabaseBackupLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """The current state of the backup. Known values are: \"Creating\", \"Active\", \"Deleting\",
     \"Failed\", and \"Updating\"."""
    retention_period_in_days: Optional[int] = rest_field(
        name="retentionPeriodInDays", visibility=["read", "create", "update"]
    )
    """Retention period, in days."""
    size_in_tbs: Optional[float] = rest_field(name="sizeInTbs", visibility=["read"])
    """The backup size in terabytes (TB)."""
    time_available_til: Optional[datetime.datetime] = rest_field(
        name="timeAvailableTil", visibility=["read"], format="rfc3339"
    )
    """Timestamp until when the backup will be available."""
    time_started: Optional[str] = rest_field(name="timeStarted", visibility=["read"])
    """The date and time the backup started."""
    time_ended: Optional[str] = rest_field(name="timeEnded", visibility=["read"])
    """The date and time the backup completed."""
    backup_type: Optional[Union[str, "_models.AutonomousDatabaseBackupType"]] = rest_field(
        name="backupType", visibility=["read"]
    )
    """The type of backup. Known values are: \"Incremental\", \"Full\", and \"LongTerm\"."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Provisioning\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        retention_period_in_days: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseBackupUpdate(_Model):
    """The type used for update operations of the AutonomousDatabaseBackup.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseBackupUpdateProperties
    """

    properties: Optional["_models.AutonomousDatabaseBackupUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutonomousDatabaseBackupUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseBackupUpdateProperties(_Model):
    """The updatable properties of the AutonomousDatabaseBackup.

    :ivar retention_period_in_days: Retention period, in days.
    :vartype retention_period_in_days: int
    """

    retention_period_in_days: Optional[int] = rest_field(
        name="retentionPeriodInDays", visibility=["read", "create", "update"]
    )
    """Retention period, in days."""

    @overload
    def __init__(
        self,
        *,
        retention_period_in_days: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseBaseProperties(_Model):
    """Autonomous Database base resource model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutonomousDatabaseCloneProperties, AutonomousDatabaseFromBackupTimestampProperties,
    AutonomousDatabaseCrossRegionDisasterRecoveryProperties, AutonomousDatabaseProperties

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar data_base_type: Database type to be created. Required. Known values are: "Regular",
     "Clone", "CloneFromBackupTimestamp", and "CrossRegionDisasterRecovery".
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.DataBaseType
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of Azure resource IDs of standby databases located in Autonomous
     Data Guard remote regions that are associated with the source database. Note that for
     Autonomous Database Serverless instances, standby databases located in the same region as the
     source primary database do not have Azure IDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: ~datetime.datetime
    :ivar remote_disaster_recovery_configuration: Indicates remote disaster recovery configuration.
    :vartype remote_disaster_recovery_configuration:
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryConfigurationDetails
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    """

    __mapping__: Dict[str, _Model] = {}
    admin_password: Optional[str] = rest_field(name="adminPassword", visibility=["create", "update"])
    """Admin password."""
    data_base_type: str = rest_discriminator(name="dataBaseType", visibility=["create"])
    """Database type to be created. Required. Known values are: \"Regular\", \"Clone\",
     \"CloneFromBackupTimestamp\", and \"CrossRegionDisasterRecovery\"."""
    autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = (
        rest_field(name="autonomousMaintenanceScheduleType", visibility=["read", "create", "update"])
    )
    """The maintenance schedule type of the Autonomous Database Serverless. Known values are:
     \"Early\" and \"Regular\"."""
    character_set: Optional[str] = rest_field(name="characterSet", visibility=["read", "create"])
    """The character set for the autonomous database."""
    compute_count: Optional[float] = rest_field(name="computeCount", visibility=["read", "create", "update"])
    """The compute amount (CPUs) available to the database."""
    compute_model: Optional[Union[str, "_models.ComputeModel"]] = rest_field(
        name="computeModel", visibility=["read", "create"]
    )
    """The compute model of the Autonomous Database. Known values are: \"ECPU\" and \"OCPU\"."""
    cpu_core_count: Optional[int] = rest_field(name="cpuCoreCount", visibility=["read", "create", "update"])
    """The number of CPU cores to be made available to the database."""
    customer_contacts: Optional[List["_models.CustomerContact"]] = rest_field(
        name="customerContacts", visibility=["read", "create", "update"]
    )
    """Customer Contacts."""
    data_storage_size_in_tbs: Optional[int] = rest_field(
        name="dataStorageSizeInTbs", visibility=["read", "create", "update"]
    )
    """The quantity of data in the database, in terabytes."""
    data_storage_size_in_gbs: Optional[int] = rest_field(
        name="dataStorageSizeInGbs", visibility=["read", "create", "update"]
    )
    """The size, in gigabytes, of the data volume that will be created and attached to the database."""
    db_version: Optional[str] = rest_field(name="dbVersion", visibility=["read", "create"])
    """A valid Oracle Database version for Autonomous Database."""
    db_workload: Optional[Union[str, "_models.WorkloadType"]] = rest_field(
        name="dbWorkload", visibility=["read", "create"]
    )
    """The Autonomous Database workload type. Known values are: \"OLTP\", \"DW\", \"AJD\", and
     \"APEX\"."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read", "create", "update"])
    """The user-friendly name for the Autonomous Database."""
    is_auto_scaling_enabled: Optional[bool] = rest_field(
        name="isAutoScalingEnabled", visibility=["read", "create", "update"]
    )
    """Indicates if auto scaling is enabled for the Autonomous Database CPU core count."""
    is_auto_scaling_for_storage_enabled: Optional[bool] = rest_field(
        name="isAutoScalingForStorageEnabled", visibility=["read", "create", "update"]
    )
    """Indicates if auto scaling is enabled for the Autonomous Database storage."""
    peer_db_ids: Optional[List[str]] = rest_field(name="peerDbIds", visibility=["read"])
    """The list of Azure resource IDs of standby databases located in Autonomous Data Guard remote
     regions that are associated with the source database. Note that for Autonomous Database
     Serverless instances, standby databases located in the same region as the source primary
     database do not have Azure IDs."""
    peer_db_id: Optional[str] = rest_field(name="peerDbId", visibility=["update"])
    """The Azure resource ID of the Disaster Recovery peer database, which is located in a different
     region from the current peer database."""
    is_local_data_guard_enabled: Optional[bool] = rest_field(
        name="isLocalDataGuardEnabled", visibility=["read", "create", "update"]
    )
    """Indicates whether the Autonomous Database has local or called in-region Data Guard enabled."""
    is_remote_data_guard_enabled: Optional[bool] = rest_field(name="isRemoteDataGuardEnabled", visibility=["read"])
    """Indicates whether the Autonomous Database has Cross Region Data Guard enabled."""
    local_disaster_recovery_type: Optional[Union[str, "_models.DisasterRecoveryType"]] = rest_field(
        name="localDisasterRecoveryType", visibility=["read"]
    )
    """Indicates the local disaster recovery (DR) type of the Autonomous Database Serverless
     instance.Autonomous Data Guard (ADG) DR type provides business critical DR with a faster
     recovery time objective (RTO) during failover or switchover.Backup-based DR type provides lower
     cost DR with a slower RTO during failover or switchover. Known values are: \"Adg\" and
     \"BackupBased\"."""
    time_disaster_recovery_role_changed: Optional[datetime.datetime] = rest_field(
        name="timeDisasterRecoveryRoleChanged", visibility=["read"], format="rfc3339"
    )
    """The date and time the Disaster Recovery role was switched for the standby Autonomous Database."""
    remote_disaster_recovery_configuration: Optional["_models.DisasterRecoveryConfigurationDetails"] = rest_field(
        name="remoteDisasterRecoveryConfiguration", visibility=["read"]
    )
    """Indicates remote disaster recovery configuration."""
    local_standby_db: Optional["_models.AutonomousDatabaseStandbySummary"] = rest_field(
        name="localStandbyDb", visibility=["read"]
    )
    """Local Autonomous Disaster Recovery standby database details."""
    failed_data_recovery_in_seconds: Optional[int] = rest_field(name="failedDataRecoveryInSeconds", visibility=["read"])
    """Indicates the number of seconds of data loss for a Data Guard failover."""
    is_mtls_connection_required: Optional[bool] = rest_field(
        name="isMtlsConnectionRequired", visibility=["read", "create", "update"]
    )
    """Specifies if the Autonomous Database requires mTLS connections."""
    is_preview_version_with_service_terms_accepted: Optional[bool] = rest_field(
        name="isPreviewVersionWithServiceTermsAccepted", visibility=["create"]
    )
    """Specifies if the Autonomous Database preview version is being provisioned."""
    license_model: Optional[Union[str, "_models.LicenseModel"]] = rest_field(
        name="licenseModel", visibility=["read", "create", "update"]
    )
    """The Oracle license model that applies to the Oracle Autonomous Database. The default is
     LICENSE_INCLUDED. Known values are: \"LicenseIncluded\" and \"BringYourOwnLicense\"."""
    ncharacter_set: Optional[str] = rest_field(name="ncharacterSet", visibility=["read", "create"])
    """The character set for the Autonomous Database."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.AutonomousDatabaseLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """Views lifecycleState. Known values are: \"Provisioning\", \"Available\", \"Stopping\",
     \"Stopped\", \"Starting\", \"Terminating\", \"Terminated\", \"Unavailable\",
     \"RestoreInProgress\", \"RestoreFailed\", \"BackupInProgress\", \"ScaleInProgress\",
     \"AvailableNeedsAttention\", \"Updating\", \"MaintenanceInProgress\", \"Restarting\",
     \"Recreating\", \"RoleChangeInProgress\", \"Upgrading\", \"Inaccessible\", and \"Standby\"."""
    scheduled_operations: Optional["_models.ScheduledOperationsType"] = rest_field(
        name="scheduledOperations", visibility=["read", "create", "update"]
    )
    """The list of scheduled operations."""
    private_endpoint_ip: Optional[str] = rest_field(name="privateEndpointIp", visibility=["read", "create"])
    """The private endpoint Ip address for the resource."""
    private_endpoint_label: Optional[str] = rest_field(name="privateEndpointLabel", visibility=["read", "create"])
    """The resource's private endpoint label."""
    oci_url: Optional[str] = rest_field(name="ociUrl", visibility=["read"])
    """HTTPS link to OCI resources exposed to Azure Customer via Azure Interface."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create"])
    """Client subnet."""
    vnet_id: Optional[str] = rest_field(name="vnetId", visibility=["read", "create"])
    """VNET for network connectivity."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """The date and time that the database was created."""
    time_maintenance_begin: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceBegin", visibility=["read"], format="rfc3339"
    )
    """The date and time when maintenance will begin."""
    time_maintenance_end: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceEnd", visibility=["read"], format="rfc3339"
    )
    """The date and time when maintenance will end."""
    actual_used_data_storage_size_in_tbs: Optional[float] = rest_field(
        name="actualUsedDataStorageSizeInTbs", visibility=["read"]
    )
    """The current amount of storage in use for user and system data, in terabytes (TB)."""
    allocated_storage_size_in_tbs: Optional[float] = rest_field(name="allocatedStorageSizeInTbs", visibility=["read"])
    """The amount of storage currently allocated for the database tables and billed for, rounded up."""
    apex_details: Optional["_models.ApexDetailsType"] = rest_field(name="apexDetails", visibility=["read"])
    """Information about Oracle APEX Application Development."""
    available_upgrade_versions: Optional[List[str]] = rest_field(name="availableUpgradeVersions", visibility=["read"])
    """List of Oracle Database versions available for a database upgrade. If there are no version
     upgrades available, this list is empty."""
    connection_strings: Optional["_models.ConnectionStringType"] = rest_field(
        name="connectionStrings", visibility=["read"]
    )
    """The connection string used to connect to the Autonomous Database."""
    connection_urls: Optional["_models.ConnectionUrlType"] = rest_field(name="connectionUrls", visibility=["read"])
    """The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser
     from a Compute instance within your VCN or that has a direct connection to your VCN."""
    data_safe_status: Optional[Union[str, "_models.DataSafeStatusType"]] = rest_field(
        name="dataSafeStatus", visibility=["read"]
    )
    """Status of the Data Safe registration for this Autonomous Database. Known values are:
     \"Registering\", \"Registered\", \"Deregistering\", \"NotRegistered\", and \"Failed\"."""
    database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = rest_field(
        name="databaseEdition", visibility=["read", "create", "update"]
    )
    """The Oracle Database Edition that applies to the Autonomous databases. Known values are:
     \"StandardEdition\" and \"EnterpriseEdition\"."""
    autonomous_database_id: Optional[str] = rest_field(name="autonomousDatabaseId", visibility=["read", "create"])
    """Autonomous Database ID."""
    in_memory_area_in_gbs: Optional[int] = rest_field(name="inMemoryAreaInGbs", visibility=["read"])
    """The area assigned to In-Memory tables in Autonomous Database."""
    next_long_term_backup_time_stamp: Optional[datetime.datetime] = rest_field(
        name="nextLongTermBackupTimeStamp", visibility=["read"], format="rfc3339"
    )
    """The date and time when the next long-term backup would be created."""
    long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = rest_field(
        name="longTermBackupSchedule", visibility=["read", "update"]
    )
    """Details for the long-term backup schedule."""
    is_preview: Optional[bool] = rest_field(name="isPreview", visibility=["read"])
    """Indicates if the Autonomous Database version is a preview version."""
    local_adg_auto_failover_max_data_loss_limit: Optional[int] = rest_field(
        name="localAdgAutoFailoverMaxDataLossLimit", visibility=["read", "update"]
    )
    """Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to
     which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard."""
    memory_per_oracle_compute_unit_in_gbs: Optional[int] = rest_field(
        name="memoryPerOracleComputeUnitInGbs", visibility=["read"]
    )
    """The amount of memory (in GBs) enabled per ECPU or OCPU."""
    open_mode: Optional[Union[str, "_models.OpenModeType"]] = rest_field(name="openMode", visibility=["read", "update"])
    """Indicates the Autonomous Database mode. Known values are: \"ReadOnly\" and \"ReadWrite\"."""
    operations_insights_status: Optional[Union[str, "_models.OperationsInsightsStatusType"]] = rest_field(
        name="operationsInsightsStatus", visibility=["read"]
    )
    """Status of Operations Insights for this Autonomous Database. Known values are: \"Enabling\",
     \"Enabled\", \"Disabling\", \"NotEnabled\", \"FailedEnabling\", and \"FailedDisabling\"."""
    permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = rest_field(
        name="permissionLevel", visibility=["read", "update"]
    )
    """The Autonomous Database permission level. Known values are: \"Restricted\" and
     \"Unrestricted\"."""
    private_endpoint: Optional[str] = rest_field(name="privateEndpoint", visibility=["read"])
    """The private endpoint for the resource."""
    provisionable_cpus: Optional[List[int]] = rest_field(name="provisionableCpus", visibility=["read"])
    """An array of CPU values that an Autonomous Database can be scaled to."""
    role: Optional[Union[str, "_models.RoleType"]] = rest_field(visibility=["read", "update"])
    """The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous
     Data Guard is enabled. Known values are: \"Primary\", \"Standby\", \"DisabledStandby\",
     \"BackupCopy\", and \"SnapshotStandby\"."""
    service_console_url: Optional[str] = rest_field(name="serviceConsoleUrl", visibility=["read"])
    """The URL of the Service Console for the Autonomous Database."""
    sql_web_developer_url: Optional[str] = rest_field(name="sqlWebDeveloperUrl", visibility=["read"])
    """The SQL Web Developer URL for the Oracle Autonomous Database."""
    supported_regions_to_clone_to: Optional[List[str]] = rest_field(
        name="supportedRegionsToCloneTo", visibility=["read"]
    )
    """The list of regions that support the creation of an Autonomous Database clone or an Autonomous
     Data Guard standby database."""
    time_data_guard_role_changed: Optional[str] = rest_field(name="timeDataGuardRoleChanged", visibility=["read"])
    """The date and time the Autonomous Data Guard role was switched for the Autonomous Database."""
    time_deletion_of_free_autonomous_database: Optional[str] = rest_field(
        name="timeDeletionOfFreeAutonomousDatabase", visibility=["read"]
    )
    """The date and time the Always Free database will be automatically deleted because of inactivity."""
    time_local_data_guard_enabled: Optional[str] = rest_field(name="timeLocalDataGuardEnabled", visibility=["read"])
    """The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the
     standby was provisioned in the same region as the primary database."""
    time_of_last_failover: Optional[str] = rest_field(name="timeOfLastFailover", visibility=["read"])
    """The timestamp of the last failover operation."""
    time_of_last_refresh: Optional[str] = rest_field(name="timeOfLastRefresh", visibility=["read"])
    """The date and time when last refresh happened."""
    time_of_last_refresh_point: Optional[str] = rest_field(name="timeOfLastRefreshPoint", visibility=["read"])
    """The refresh point timestamp (UTC)."""
    time_of_last_switchover: Optional[str] = rest_field(name="timeOfLastSwitchover", visibility=["read"])
    """The timestamp of the last switchover operation for the Autonomous Database."""
    time_reclamation_of_free_autonomous_database: Optional[str] = rest_field(
        name="timeReclamationOfFreeAutonomousDatabase", visibility=["read"]
    )
    """The date and time the Always Free database will be stopped because of inactivity."""
    used_data_storage_size_in_gbs: Optional[int] = rest_field(name="usedDataStorageSizeInGbs", visibility=["read"])
    """The storage space consumed by Autonomous Database in GBs."""
    used_data_storage_size_in_tbs: Optional[int] = rest_field(name="usedDataStorageSizeInTbs", visibility=["read"])
    """The amount of storage that has been used, in terabytes."""
    ocid: Optional[str] = rest_field(visibility=["read"])
    """Database ocid."""
    backup_retention_period_in_days: Optional[int] = rest_field(
        name="backupRetentionPeriodInDays", visibility=["read", "create", "update"]
    )
    """Retention period, in days, for long-term backups."""
    whitelisted_ips: Optional[List[str]] = rest_field(name="whitelistedIps", visibility=["read", "create", "update"])
    """The client IP access control list (ACL). This is an array of CIDR notations and/or IP
     addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25']."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        data_base_type: str,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseCharacterSet(ProxyResource):
    """AutonomousDatabaseCharacterSets resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseCharacterSetProperties
    """

    properties: Optional["_models.AutonomousDatabaseCharacterSetProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutonomousDatabaseCharacterSetProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseCharacterSetProperties(_Model):
    """AutonomousDatabaseCharacterSet resource model.

    :ivar character_set: The Oracle Autonomous Database supported character sets. Required.
    :vartype character_set: str
    """

    character_set: str = rest_field(name="characterSet", visibility=["read", "create", "update", "delete", "query"])
    """The Oracle Autonomous Database supported character sets. Required."""

    @overload
    def __init__(
        self,
        *,
        character_set: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseCloneProperties(AutonomousDatabaseBaseProperties, discriminator="Clone"):
    """Autonomous Database clone resource model.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of Azure resource IDs of standby databases located in Autonomous
     Data Guard remote regions that are associated with the source database. Note that for
     Autonomous Database Serverless instances, standby databases located in the same region as the
     source primary database do not have Azure IDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: ~datetime.datetime
    :ivar remote_disaster_recovery_configuration: Indicates remote disaster recovery configuration.
    :vartype remote_disaster_recovery_configuration:
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryConfigurationDetails
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    :ivar data_base_type: Database type to be created. Required. Clone DB
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.CLONE
    :ivar source: The source of the database. Known values are: "None", "Database", "BackupFromId",
     "BackupFromTimestamp", "CloneToRefreshable", "CrossRegionDataguard", and
     "CrossRegionDisasterRecovery".
    :vartype source: str or ~azure.mgmt.oracledatabase.models.SourceType
    :ivar source_id: The Azure resource ID of the Autonomous Database that was cloned to create the
     current Autonomous Database. Required.
    :vartype source_id: str
    :ivar clone_type: The Autonomous Database clone type. Required. Known values are: "Full" and
     "Metadata".
    :vartype clone_type: str or ~azure.mgmt.oracledatabase.models.CloneType
    :ivar is_reconnect_clone_enabled: Indicates if the refreshable clone can be reconnected to its
     source database.
    :vartype is_reconnect_clone_enabled: bool
    :ivar is_refreshable_clone: Indicates if the Autonomous Database is a refreshable clone.
    :vartype is_refreshable_clone: bool
    :ivar refreshable_model: The refresh mode of the clone. Known values are: "Automatic" and
     "Manual".
    :vartype refreshable_model: str or ~azure.mgmt.oracledatabase.models.RefreshableModelType
    :ivar refreshable_status: The refresh status of the clone. Known values are: "Refreshing" and
     "NotRefreshing".
    :vartype refreshable_status: str or ~azure.mgmt.oracledatabase.models.RefreshableStatusType
    :ivar time_until_reconnect_clone_enabled: The time and date as an RFC3339 formatted string,
     e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to
     its source database.
    :vartype time_until_reconnect_clone_enabled: str
    """

    data_base_type: Literal[DataBaseType.CLONE] = rest_discriminator(name="dataBaseType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Database type to be created. Required. Clone DB"""
    source: Optional[Union[str, "_models.SourceType"]] = rest_field(visibility=["create"])
    """The source of the database. Known values are: \"None\", \"Database\", \"BackupFromId\",
     \"BackupFromTimestamp\", \"CloneToRefreshable\", \"CrossRegionDataguard\", and
     \"CrossRegionDisasterRecovery\"."""
    source_id: str = rest_field(name="sourceId", visibility=["read", "create"])
    """The Azure resource ID of the Autonomous Database that was cloned to create the current
     Autonomous Database. Required."""
    clone_type: Union[str, "_models.CloneType"] = rest_field(name="cloneType", visibility=["create"])
    """The Autonomous Database clone type. Required. Known values are: \"Full\" and \"Metadata\"."""
    is_reconnect_clone_enabled: Optional[bool] = rest_field(name="isReconnectCloneEnabled", visibility=["read"])
    """Indicates if the refreshable clone can be reconnected to its source database."""
    is_refreshable_clone: Optional[bool] = rest_field(name="isRefreshableClone", visibility=["read"])
    """Indicates if the Autonomous Database is a refreshable clone."""
    refreshable_model: Optional[Union[str, "_models.RefreshableModelType"]] = rest_field(
        name="refreshableModel", visibility=["create"]
    )
    """The refresh mode of the clone. Known values are: \"Automatic\" and \"Manual\"."""
    refreshable_status: Optional[Union[str, "_models.RefreshableStatusType"]] = rest_field(
        name="refreshableStatus", visibility=["read"]
    )
    """The refresh status of the clone. Known values are: \"Refreshing\" and \"NotRefreshing\"."""
    time_until_reconnect_clone_enabled: Optional[str] = rest_field(
        name="timeUntilReconnectCloneEnabled", visibility=["read", "update"]
    )
    """The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the
     limit for a refreshable clone to be reconnected to its source database."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        source_id: str,
        clone_type: Union[str, "_models.CloneType"],
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        source: Optional[Union[str, "_models.SourceType"]] = None,
        refreshable_model: Optional[Union[str, "_models.RefreshableModelType"]] = None,
        time_until_reconnect_clone_enabled: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_base_type=DataBaseType.CLONE, **kwargs)


class AutonomousDatabaseCrossRegionDisasterRecoveryProperties(
    AutonomousDatabaseBaseProperties, discriminator="CrossRegionDisasterRecovery"
):  # pylint: disable=name-too-long
    """Autonomous Database Cross Region Disaster Recovery resource model.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of Azure resource IDs of standby databases located in Autonomous
     Data Guard remote regions that are associated with the source database. Note that for
     Autonomous Database Serverless instances, standby databases located in the same region as the
     source primary database do not have Azure IDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: ~datetime.datetime
    :ivar remote_disaster_recovery_configuration: Indicates remote disaster recovery configuration.
    :vartype remote_disaster_recovery_configuration:
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryConfigurationDetails
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    :ivar data_base_type: Database type to be created. Required. Cross Region Disaster Recovery
    :vartype data_base_type: str or
     ~azure.mgmt.oracledatabase.models.CROSS_REGION_DISASTER_RECOVERY
    :ivar source: The source of the database. Required. cross region disaster recovery source
    :vartype source: str or ~azure.mgmt.oracledatabase.models.CROSS_REGION_DISASTER_RECOVERY
    :ivar source_id: The Azure ID of the source Autonomous Database that will be used to create a
     new peer database for the DR association. Required.
    :vartype source_id: str
    :ivar source_location: The name of the region where source Autonomous Database exists.
    :vartype source_location: str
    :ivar source_ocid: The source database ocid.
    :vartype source_ocid: str
    :ivar remote_disaster_recovery_type: Indicates the cross-region disaster recovery (DR) type of
     the standby Autonomous Database Serverless instance. Autonomous Data Guard (ADG) DR type
     provides business critical DR with a faster recovery time objective (RTO) during failover or
     switchover. Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Required. Known values are: "Adg" and "BackupBased".
    :vartype remote_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across
     regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the
     backups taken on the Primary are not replicated to the Standby database.
    :vartype is_replicate_automatic_backups: bool
    """

    data_base_type: Literal[DataBaseType.CROSS_REGION_DISASTER_RECOVERY] = rest_discriminator(name="dataBaseType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Database type to be created. Required. Cross Region Disaster Recovery"""
    source: Literal[SourceType.CROSS_REGION_DISASTER_RECOVERY] = rest_field(visibility=["create"])
    """The source of the database. Required. cross region disaster recovery source"""
    source_id: str = rest_field(name="sourceId", visibility=["read", "create"])
    """The Azure ID of the source Autonomous Database that will be used to create a new peer database
     for the DR association. Required."""
    source_location: Optional[str] = rest_field(name="sourceLocation", visibility=["create"])
    """The name of the region where source Autonomous Database exists."""
    source_ocid: Optional[str] = rest_field(name="sourceOcid", visibility=["create"])
    """The source database ocid."""
    remote_disaster_recovery_type: Union[str, "_models.DisasterRecoveryType"] = rest_field(
        name="remoteDisasterRecoveryType", visibility=["read", "create"]
    )
    """Indicates the cross-region disaster recovery (DR) type of the standby Autonomous Database
     Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR with a
     faster recovery time objective (RTO) during failover or switchover. Backup-based DR type
     provides lower cost DR with a slower RTO during failover or switchover. Required. Known values
     are: \"Adg\" and \"BackupBased\"."""
    is_replicate_automatic_backups: Optional[bool] = rest_field(
        name="isReplicateAutomaticBackups", visibility=["read", "create"]
    )
    """If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or
     Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not
     replicated to the Standby database."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        source: Literal[SourceType.CROSS_REGION_DISASTER_RECOVERY],
        source_id: str,
        remote_disaster_recovery_type: Union[str, "_models.DisasterRecoveryType"],
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        source_location: Optional[str] = None,
        source_ocid: Optional[str] = None,
        is_replicate_automatic_backups: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_base_type=DataBaseType.CROSS_REGION_DISASTER_RECOVERY, **kwargs)


class AutonomousDatabaseFromBackupTimestampProperties(
    AutonomousDatabaseBaseProperties, discriminator="CloneFromBackupTimestamp"
):  # pylint: disable=name-too-long
    """Autonomous Database From Backup Timestamp resource model.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of Azure resource IDs of standby databases located in Autonomous
     Data Guard remote regions that are associated with the source database. Note that for
     Autonomous Database Serverless instances, standby databases located in the same region as the
     source primary database do not have Azure IDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: ~datetime.datetime
    :ivar remote_disaster_recovery_configuration: Indicates remote disaster recovery configuration.
    :vartype remote_disaster_recovery_configuration:
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryConfigurationDetails
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    :ivar data_base_type: Database type to be created. Required. Clone DB from backup timestamp
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.CLONE_FROM_BACKUP_TIMESTAMP
    :ivar source: The source of the database. Required. Backup from timestamp source
    :vartype source: str or ~azure.mgmt.oracledatabase.models.BACKUP_FROM_TIMESTAMP
    :ivar source_id: The ID of the source Autonomous Database that you will clone to create a new
     Autonomous Database. Required.
    :vartype source_id: str
    :ivar clone_type: The Autonomous Database clone type. Required. Known values are: "Full" and
     "Metadata".
    :vartype clone_type: str or ~azure.mgmt.oracledatabase.models.CloneType
    :ivar timestamp: The timestamp specified for the point-in-time clone of the source Autonomous
     Database. The timestamp must be in the past.
    :vartype timestamp: ~datetime.datetime
    :ivar use_latest_available_backup_time_stamp: Clone from latest available backup timestamp.
    :vartype use_latest_available_backup_time_stamp: bool
    """

    data_base_type: Literal[DataBaseType.CLONE_FROM_BACKUP_TIMESTAMP] = rest_discriminator(name="dataBaseType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Database type to be created. Required. Clone DB from backup timestamp"""
    source: Literal[SourceType.BACKUP_FROM_TIMESTAMP] = rest_field(visibility=["create"])
    """The source of the database. Required. Backup from timestamp source"""
    source_id: str = rest_field(name="sourceId", visibility=["read", "create"])
    """The ID of the source Autonomous Database that you will clone to create a new Autonomous
     Database. Required."""
    clone_type: Union[str, "_models.CloneType"] = rest_field(name="cloneType", visibility=["create"])
    """The Autonomous Database clone type. Required. Known values are: \"Full\" and \"Metadata\"."""
    timestamp: Optional[datetime.datetime] = rest_field(visibility=["create"], format="rfc3339")
    """The timestamp specified for the point-in-time clone of the source Autonomous Database. The
     timestamp must be in the past."""
    use_latest_available_backup_time_stamp: Optional[bool] = rest_field(
        name="useLatestAvailableBackupTimeStamp", visibility=["create"]
    )
    """Clone from latest available backup timestamp."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        source: Literal[SourceType.BACKUP_FROM_TIMESTAMP],
        source_id: str,
        clone_type: Union[str, "_models.CloneType"],
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
        timestamp: Optional[datetime.datetime] = None,
        use_latest_available_backup_time_stamp: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_base_type=DataBaseType.CLONE_FROM_BACKUP_TIMESTAMP, **kwargs)


class AutonomousDatabaseNationalCharacterSet(ProxyResource):
    """AutonomousDatabaseNationalCharacterSets resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseNationalCharacterSetProperties
    """

    properties: Optional["_models.AutonomousDatabaseNationalCharacterSetProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutonomousDatabaseNationalCharacterSetProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseNationalCharacterSetProperties(_Model):  # pylint: disable=name-too-long
    """AutonomousDatabaseNationalCharacterSet resource model.

    :ivar character_set: The Oracle Autonomous Database supported national character sets.
     Required.
    :vartype character_set: str
    """

    character_set: str = rest_field(name="characterSet", visibility=["read", "create", "update", "delete", "query"])
    """The Oracle Autonomous Database supported national character sets. Required."""

    @overload
    def __init__(
        self,
        *,
        character_set: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseProperties(AutonomousDatabaseBaseProperties, discriminator="Regular"):
    """Autonomous Database resource model.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar character_set: The character set for the autonomous database.
    :vartype character_set: str
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar compute_model: The compute model of the Autonomous Database. Known values are: "ECPU" and
     "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar db_version: A valid Oracle Database version for Autonomous Database.
    :vartype db_version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_ids: The list of Azure resource IDs of standby databases located in Autonomous
     Data Guard remote regions that are associated with the source database. Note that for
     Autonomous Database Serverless instances, standby databases located in the same region as the
     source primary database do not have Azure IDs.
    :vartype peer_db_ids: list[str]
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_remote_data_guard_enabled: Indicates whether the Autonomous Database has Cross Region
     Data Guard enabled.
    :vartype is_remote_data_guard_enabled: bool
    :ivar local_disaster_recovery_type: Indicates the local disaster recovery (DR) type of the
     Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business
     critical DR with a faster recovery time objective (RTO) during failover or
     switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or
     switchover. Known values are: "Adg" and "BackupBased".
    :vartype local_disaster_recovery_type: str or
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: ~datetime.datetime
    :ivar remote_disaster_recovery_configuration: Indicates remote disaster recovery configuration.
    :vartype remote_disaster_recovery_configuration:
     ~azure.mgmt.oracledatabase.models.DisasterRecoveryConfigurationDetails
    :ivar local_standby_db: Local Autonomous Disaster Recovery standby database details.
    :vartype local_standby_db: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseStandbySummary
    :ivar failed_data_recovery_in_seconds: Indicates the number of seconds of data loss for a Data
     Guard failover.
    :vartype failed_data_recovery_in_seconds: int
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar is_preview_version_with_service_terms_accepted: Specifies if the Autonomous Database
     preview version is being provisioned.
    :vartype is_preview_version_with_service_terms_accepted: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar ncharacter_set: The character set for the Autonomous Database.
    :vartype ncharacter_set: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Views lifecycleState. Known values are: "Provisioning", "Available",
     "Stopping", "Stopped", "Starting", "Terminating", "Terminated", "Unavailable",
     "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsType
    :ivar private_endpoint_ip: The private endpoint Ip address for the resource.
    :vartype private_endpoint_ip: str
    :ivar private_endpoint_label: The resource's private endpoint label.
    :vartype private_endpoint_label: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar subnet_id: Client subnet.
    :vartype subnet_id: str
    :ivar vnet_id: VNET for network connectivity.
    :vartype vnet_id: str
    :ivar time_created: The date and time that the database was created.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_begin: The date and time when maintenance will begin.
    :vartype time_maintenance_begin: ~datetime.datetime
    :ivar time_maintenance_end: The date and time when maintenance will end.
    :vartype time_maintenance_end: ~datetime.datetime
    :ivar actual_used_data_storage_size_in_tbs: The current amount of storage in use for user and
     system data, in terabytes (TB).
    :vartype actual_used_data_storage_size_in_tbs: float
    :ivar allocated_storage_size_in_tbs: The amount of storage currently allocated for the database
     tables and billed for, rounded up.
    :vartype allocated_storage_size_in_tbs: float
    :ivar apex_details: Information about Oracle APEX Application Development.
    :vartype apex_details: ~azure.mgmt.oracledatabase.models.ApexDetailsType
    :ivar available_upgrade_versions: List of Oracle Database versions available for a database
     upgrade. If there are no version upgrades available, this list is empty.
    :vartype available_upgrade_versions: list[str]
    :ivar connection_strings: The connection string used to connect to the Autonomous Database.
    :vartype connection_strings: ~azure.mgmt.oracledatabase.models.ConnectionStringType
    :ivar connection_urls: The URLs for accessing Oracle Application Express (APEX) and SQL
     Developer Web with a browser from a Compute instance within your VCN or that has a direct
     connection to your VCN.
    :vartype connection_urls: ~azure.mgmt.oracledatabase.models.ConnectionUrlType
    :ivar data_safe_status: Status of the Data Safe registration for this Autonomous Database.
     Known values are: "Registering", "Registered", "Deregistering", "NotRegistered", and "Failed".
    :vartype data_safe_status: str or ~azure.mgmt.oracledatabase.models.DataSafeStatusType
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar autonomous_database_id: Autonomous Database ID.
    :vartype autonomous_database_id: str
    :ivar in_memory_area_in_gbs: The area assigned to In-Memory tables in Autonomous Database.
    :vartype in_memory_area_in_gbs: int
    :ivar next_long_term_backup_time_stamp: The date and time when the next long-term backup would
     be created.
    :vartype next_long_term_backup_time_stamp: ~datetime.datetime
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar is_preview: Indicates if the Autonomous Database version is a preview version.
    :vartype is_preview: bool
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) enabled per ECPU or
     OCPU.
    :vartype memory_per_oracle_compute_unit_in_gbs: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar operations_insights_status: Status of Operations Insights for this Autonomous Database.
     Known values are: "Enabling", "Enabled", "Disabling", "NotEnabled", "FailedEnabling", and
     "FailedDisabling".
    :vartype operations_insights_status: str or
     ~azure.mgmt.oracledatabase.models.OperationsInsightsStatusType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar private_endpoint: The private endpoint for the resource.
    :vartype private_endpoint: str
    :ivar provisionable_cpus: An array of CPU values that an Autonomous Database can be scaled to.
    :vartype provisionable_cpus: list[int]
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar service_console_url: The URL of the Service Console for the Autonomous Database.
    :vartype service_console_url: str
    :ivar sql_web_developer_url: The SQL Web Developer URL for the Oracle Autonomous Database.
    :vartype sql_web_developer_url: str
    :ivar supported_regions_to_clone_to: The list of regions that support the creation of an
     Autonomous Database clone or an Autonomous Data Guard standby database.
    :vartype supported_regions_to_clone_to: list[str]
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_deletion_of_free_autonomous_database: The date and time the Always Free database
     will be automatically deleted because of inactivity.
    :vartype time_deletion_of_free_autonomous_database: str
    :ivar time_local_data_guard_enabled: The date and time that Autonomous Data Guard was enabled
     for an Autonomous Database where the standby was provisioned in the same region as the primary
     database.
    :vartype time_local_data_guard_enabled: str
    :ivar time_of_last_failover: The timestamp of the last failover operation.
    :vartype time_of_last_failover: str
    :ivar time_of_last_refresh: The date and time when last refresh happened.
    :vartype time_of_last_refresh: str
    :ivar time_of_last_refresh_point: The refresh point timestamp (UTC).
    :vartype time_of_last_refresh_point: str
    :ivar time_of_last_switchover: The timestamp of the last switchover operation for the
     Autonomous Database.
    :vartype time_of_last_switchover: str
    :ivar time_reclamation_of_free_autonomous_database: The date and time the Always Free database
     will be stopped because of inactivity.
    :vartype time_reclamation_of_free_autonomous_database: str
    :ivar used_data_storage_size_in_gbs: The storage space consumed by Autonomous Database in GBs.
    :vartype used_data_storage_size_in_gbs: int
    :ivar used_data_storage_size_in_tbs: The amount of storage that has been used, in terabytes.
    :vartype used_data_storage_size_in_tbs: int
    :ivar ocid: Database ocid.
    :vartype ocid: str
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    :ivar data_base_type: Database type to be created. Required. Regular DB
    :vartype data_base_type: str or ~azure.mgmt.oracledatabase.models.REGULAR
    """

    data_base_type: Literal[DataBaseType.REGULAR] = rest_discriminator(name="dataBaseType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Database type to be created. Required. Regular DB"""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        character_set: Optional[str] = None,
        compute_count: Optional[float] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        db_version: Optional[str] = None,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        is_preview_version_with_service_terms_accepted: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        ncharacter_set: Optional[str] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsType"] = None,
        private_endpoint_ip: Optional[str] = None,
        private_endpoint_label: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_id: Optional[str] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        autonomous_database_id: Optional[str] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, data_base_type=DataBaseType.REGULAR, **kwargs)


class AutonomousDatabaseStandbySummary(_Model):
    """Autonomous Disaster Recovery standby database details.

    :ivar lag_time_in_seconds: The amount of time, in seconds, that the data of the standby
     database lags the data of the primary database. Can be used to determine the potential data
     loss in the event of a failover.
    :vartype lag_time_in_seconds: int
    :ivar lifecycle_state: The current state of the Autonomous Database. Known values are:
     "Provisioning", "Available", "Stopping", "Stopped", "Starting", "Terminating", "Terminated",
     "Unavailable", "RestoreInProgress", "RestoreFailed", "BackupInProgress", "ScaleInProgress",
     "AvailableNeedsAttention", "Updating", "MaintenanceInProgress", "Restarting", "Recreating",
     "RoleChangeInProgress", "Upgrading", "Inaccessible", and "Standby".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.AutonomousDatabaseLifecycleState
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar time_data_guard_role_changed: The date and time the Autonomous Data Guard role was
     switched for the standby Autonomous Database.
    :vartype time_data_guard_role_changed: str
    :ivar time_disaster_recovery_role_changed: The date and time the Disaster Recovery role was
     switched for the standby Autonomous Database.
    :vartype time_disaster_recovery_role_changed: str
    """

    lag_time_in_seconds: Optional[int] = rest_field(
        name="lagTimeInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time, in seconds, that the data of the standby database lags the data of the
     primary database. Can be used to determine the potential data loss in the event of a failover."""
    lifecycle_state: Optional[Union[str, "_models.AutonomousDatabaseLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the Autonomous Database. Known values are: \"Provisioning\",
     \"Available\", \"Stopping\", \"Stopped\", \"Starting\", \"Terminating\", \"Terminated\",
     \"Unavailable\", \"RestoreInProgress\", \"RestoreFailed\", \"BackupInProgress\",
     \"ScaleInProgress\", \"AvailableNeedsAttention\", \"Updating\", \"MaintenanceInProgress\",
     \"Restarting\", \"Recreating\", \"RoleChangeInProgress\", \"Upgrading\", \"Inaccessible\", and
     \"Standby\"."""
    lifecycle_details: Optional[str] = rest_field(
        name="lifecycleDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information about the current lifecycle state."""
    time_data_guard_role_changed: Optional[str] = rest_field(
        name="timeDataGuardRoleChanged", visibility=["read", "create", "update", "delete", "query"]
    )
    """The date and time the Autonomous Data Guard role was switched for the standby Autonomous
     Database."""
    time_disaster_recovery_role_changed: Optional[str] = rest_field(
        name="timeDisasterRecoveryRoleChanged", visibility=["read", "create", "update", "delete", "query"]
    )
    """The date and time the Disaster Recovery role was switched for the standby Autonomous Database."""

    @overload
    def __init__(
        self,
        *,
        lag_time_in_seconds: Optional[int] = None,
        lifecycle_state: Optional[Union[str, "_models.AutonomousDatabaseLifecycleState"]] = None,
        lifecycle_details: Optional[str] = None,
        time_data_guard_role_changed: Optional[str] = None,
        time_disaster_recovery_role_changed: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseUpdate(_Model):
    """The type used for update operations of the AutonomousDatabase.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDatabaseUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.AutonomousDatabaseUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AutonomousDatabaseUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseUpdateProperties(_Model):
    """The updatable properties of the AutonomousDatabase.

    :ivar admin_password: Admin password.
    :vartype admin_password: str
    :ivar autonomous_maintenance_schedule_type: The maintenance schedule type of the Autonomous
     Database Serverless. Known values are: "Early" and "Regular".
    :vartype autonomous_maintenance_schedule_type: str or
     ~azure.mgmt.oracledatabase.models.AutonomousMaintenanceScheduleType
    :ivar compute_count: The compute amount (CPUs) available to the database.
    :vartype compute_count: float
    :ivar cpu_core_count: The number of CPU cores to be made available to the database.
    :vartype cpu_core_count: int
    :ivar customer_contacts: Customer Contacts.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: int
    :ivar data_storage_size_in_gbs: The size, in gigabytes, of the data volume that will be created
     and attached to the database.
    :vartype data_storage_size_in_gbs: int
    :ivar display_name: The user-friendly name for the Autonomous Database.
    :vartype display_name: str
    :ivar is_auto_scaling_enabled: Indicates if auto scaling is enabled for the Autonomous Database
     CPU core count.
    :vartype is_auto_scaling_enabled: bool
    :ivar is_auto_scaling_for_storage_enabled: Indicates if auto scaling is enabled for the
     Autonomous Database storage.
    :vartype is_auto_scaling_for_storage_enabled: bool
    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar is_local_data_guard_enabled: Indicates whether the Autonomous Database has local or
     called in-region Data Guard enabled.
    :vartype is_local_data_guard_enabled: bool
    :ivar is_mtls_connection_required: Specifies if the Autonomous Database requires mTLS
     connections.
    :vartype is_mtls_connection_required: bool
    :ivar license_model: The Oracle license model that applies to the Oracle Autonomous Database.
     The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar scheduled_operations: The list of scheduled operations.
    :vartype scheduled_operations: ~azure.mgmt.oracledatabase.models.ScheduledOperationsTypeUpdate
    :ivar database_edition: The Oracle Database Edition that applies to the Autonomous databases.
     Known values are: "StandardEdition" and "EnterpriseEdition".
    :vartype database_edition: str or ~azure.mgmt.oracledatabase.models.DatabaseEditionType
    :ivar long_term_backup_schedule: Details for the long-term backup schedule.
    :vartype long_term_backup_schedule:
     ~azure.mgmt.oracledatabase.models.LongTermBackUpScheduleDetails
    :ivar local_adg_auto_failover_max_data_loss_limit: Parameter that allows users to select an
     acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered
     when necessary for a Local Autonomous Data Guard.
    :vartype local_adg_auto_failover_max_data_loss_limit: int
    :ivar open_mode: Indicates the Autonomous Database mode. Known values are: "ReadOnly" and
     "ReadWrite".
    :vartype open_mode: str or ~azure.mgmt.oracledatabase.models.OpenModeType
    :ivar permission_level: The Autonomous Database permission level. Known values are:
     "Restricted" and "Unrestricted".
    :vartype permission_level: str or ~azure.mgmt.oracledatabase.models.PermissionLevelType
    :ivar role: The Data Guard role of the Autonomous Container Database or Autonomous Database, if
     Autonomous Data Guard is enabled. Known values are: "Primary", "Standby", "DisabledStandby",
     "BackupCopy", and "SnapshotStandby".
    :vartype role: str or ~azure.mgmt.oracledatabase.models.RoleType
    :ivar backup_retention_period_in_days: Retention period, in days, for long-term backups.
    :vartype backup_retention_period_in_days: int
    :ivar whitelisted_ips: The client IP access control list (ACL). This is an array of CIDR
     notations and/or IP addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25'].
    :vartype whitelisted_ips: list[str]
    """

    admin_password: Optional[str] = rest_field(name="adminPassword", visibility=["create", "update"])
    """Admin password."""
    autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = (
        rest_field(name="autonomousMaintenanceScheduleType", visibility=["read", "create", "update"])
    )
    """The maintenance schedule type of the Autonomous Database Serverless. Known values are:
     \"Early\" and \"Regular\"."""
    compute_count: Optional[float] = rest_field(name="computeCount", visibility=["read", "create", "update"])
    """The compute amount (CPUs) available to the database."""
    cpu_core_count: Optional[int] = rest_field(name="cpuCoreCount", visibility=["read", "create", "update"])
    """The number of CPU cores to be made available to the database."""
    customer_contacts: Optional[List["_models.CustomerContact"]] = rest_field(
        name="customerContacts", visibility=["read", "create", "update"]
    )
    """Customer Contacts."""
    data_storage_size_in_tbs: Optional[int] = rest_field(
        name="dataStorageSizeInTbs", visibility=["read", "create", "update"]
    )
    """The quantity of data in the database, in terabytes."""
    data_storage_size_in_gbs: Optional[int] = rest_field(
        name="dataStorageSizeInGbs", visibility=["read", "create", "update"]
    )
    """The size, in gigabytes, of the data volume that will be created and attached to the database."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read", "create", "update"])
    """The user-friendly name for the Autonomous Database."""
    is_auto_scaling_enabled: Optional[bool] = rest_field(
        name="isAutoScalingEnabled", visibility=["read", "create", "update"]
    )
    """Indicates if auto scaling is enabled for the Autonomous Database CPU core count."""
    is_auto_scaling_for_storage_enabled: Optional[bool] = rest_field(
        name="isAutoScalingForStorageEnabled", visibility=["read", "create", "update"]
    )
    """Indicates if auto scaling is enabled for the Autonomous Database storage."""
    peer_db_id: Optional[str] = rest_field(name="peerDbId", visibility=["update"])
    """The Azure resource ID of the Disaster Recovery peer database, which is located in a different
     region from the current peer database."""
    is_local_data_guard_enabled: Optional[bool] = rest_field(
        name="isLocalDataGuardEnabled", visibility=["read", "create", "update"]
    )
    """Indicates whether the Autonomous Database has local or called in-region Data Guard enabled."""
    is_mtls_connection_required: Optional[bool] = rest_field(
        name="isMtlsConnectionRequired", visibility=["read", "create", "update"]
    )
    """Specifies if the Autonomous Database requires mTLS connections."""
    license_model: Optional[Union[str, "_models.LicenseModel"]] = rest_field(
        name="licenseModel", visibility=["read", "create", "update"]
    )
    """The Oracle license model that applies to the Oracle Autonomous Database. The default is
     LICENSE_INCLUDED. Known values are: \"LicenseIncluded\" and \"BringYourOwnLicense\"."""
    scheduled_operations: Optional["_models.ScheduledOperationsTypeUpdate"] = rest_field(
        name="scheduledOperations", visibility=["read", "create", "update"]
    )
    """The list of scheduled operations."""
    database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = rest_field(
        name="databaseEdition", visibility=["read", "create", "update"]
    )
    """The Oracle Database Edition that applies to the Autonomous databases. Known values are:
     \"StandardEdition\" and \"EnterpriseEdition\"."""
    long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = rest_field(
        name="longTermBackupSchedule", visibility=["read", "update"]
    )
    """Details for the long-term backup schedule."""
    local_adg_auto_failover_max_data_loss_limit: Optional[int] = rest_field(
        name="localAdgAutoFailoverMaxDataLossLimit", visibility=["read", "update"]
    )
    """Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to
     which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard."""
    open_mode: Optional[Union[str, "_models.OpenModeType"]] = rest_field(name="openMode", visibility=["read", "update"])
    """Indicates the Autonomous Database mode. Known values are: \"ReadOnly\" and \"ReadWrite\"."""
    permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = rest_field(
        name="permissionLevel", visibility=["read", "update"]
    )
    """The Autonomous Database permission level. Known values are: \"Restricted\" and
     \"Unrestricted\"."""
    role: Optional[Union[str, "_models.RoleType"]] = rest_field(visibility=["read", "update"])
    """The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous
     Data Guard is enabled. Known values are: \"Primary\", \"Standby\", \"DisabledStandby\",
     \"BackupCopy\", and \"SnapshotStandby\"."""
    backup_retention_period_in_days: Optional[int] = rest_field(
        name="backupRetentionPeriodInDays", visibility=["read", "create", "update"]
    )
    """Retention period, in days, for long-term backups."""
    whitelisted_ips: Optional[List[str]] = rest_field(name="whitelistedIps", visibility=["read", "create", "update"])
    """The client IP access control list (ACL). This is an array of CIDR notations and/or IP
     addresses. Values should be separate strings, separated by commas. Example:
     ['1.1.1.1','1.1.1.0/24','1.1.2.25']."""

    @overload
    def __init__(
        self,
        *,
        admin_password: Optional[str] = None,
        autonomous_maintenance_schedule_type: Optional[Union[str, "_models.AutonomousMaintenanceScheduleType"]] = None,
        compute_count: Optional[float] = None,
        cpu_core_count: Optional[int] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        data_storage_size_in_tbs: Optional[int] = None,
        data_storage_size_in_gbs: Optional[int] = None,
        display_name: Optional[str] = None,
        is_auto_scaling_enabled: Optional[bool] = None,
        is_auto_scaling_for_storage_enabled: Optional[bool] = None,
        peer_db_id: Optional[str] = None,
        is_local_data_guard_enabled: Optional[bool] = None,
        is_mtls_connection_required: Optional[bool] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        scheduled_operations: Optional["_models.ScheduledOperationsTypeUpdate"] = None,
        database_edition: Optional[Union[str, "_models.DatabaseEditionType"]] = None,
        long_term_backup_schedule: Optional["_models.LongTermBackUpScheduleDetails"] = None,
        local_adg_auto_failover_max_data_loss_limit: Optional[int] = None,
        open_mode: Optional[Union[str, "_models.OpenModeType"]] = None,
        permission_level: Optional[Union[str, "_models.PermissionLevelType"]] = None,
        role: Optional[Union[str, "_models.RoleType"]] = None,
        backup_retention_period_in_days: Optional[int] = None,
        whitelisted_ips: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDatabaseWalletFile(_Model):
    """Autonomous Database Wallet File resource model.

    :ivar wallet_files: The base64 encoded wallet files. Required.
    :vartype wallet_files: str
    """

    wallet_files: str = rest_field(name="walletFiles", visibility=["read", "create", "update", "delete", "query"])
    """The base64 encoded wallet files. Required."""

    @overload
    def __init__(
        self,
        *,
        wallet_files: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDbVersion(ProxyResource):
    """AutonomousDbVersion resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.AutonomousDbVersionProperties
    """

    properties: Optional["_models.AutonomousDbVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutonomousDbVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutonomousDbVersionProperties(_Model):
    """AutonomousDbVersion resource model.

    :ivar version: Supported Autonomous Db versions. Required.
    :vartype version: str
    :ivar db_workload: The Autonomous Database workload type. Known values are: "OLTP", "DW",
     "AJD", and "APEX".
    :vartype db_workload: str or ~azure.mgmt.oracledatabase.models.WorkloadType
    :ivar is_default_for_free: True if this version of the Oracle Database software's default is
     free.
    :vartype is_default_for_free: bool
    :ivar is_default_for_paid: True if this version of the Oracle Database software's default is
     paid.
    :vartype is_default_for_paid: bool
    :ivar is_free_tier_enabled: True if this version of the Oracle Database software can be used
     for Always-Free Autonomous Databases.
    :vartype is_free_tier_enabled: bool
    :ivar is_paid_enabled: True if this version of the Oracle Database software has payments
     enabled.
    :vartype is_paid_enabled: bool
    """

    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Supported Autonomous Db versions. Required."""
    db_workload: Optional[Union[str, "_models.WorkloadType"]] = rest_field(
        name="dbWorkload", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Autonomous Database workload type. Known values are: \"OLTP\", \"DW\", \"AJD\", and
     \"APEX\"."""
    is_default_for_free: Optional[bool] = rest_field(
        name="isDefaultForFree", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if this version of the Oracle Database software's default is free."""
    is_default_for_paid: Optional[bool] = rest_field(
        name="isDefaultForPaid", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if this version of the Oracle Database software's default is paid."""
    is_free_tier_enabled: Optional[bool] = rest_field(
        name="isFreeTierEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if this version of the Oracle Database software can be used for Always-Free Autonomous
     Databases."""
    is_paid_enabled: Optional[bool] = rest_field(
        name="isPaidEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """True if this version of the Oracle Database software has payments enabled."""

    @overload
    def __init__(
        self,
        *,
        version: str,
        db_workload: Optional[Union[str, "_models.WorkloadType"]] = None,
        is_default_for_free: Optional[bool] = None,
        is_default_for_paid: Optional[bool] = None,
        is_free_tier_enabled: Optional[bool] = None,
        is_paid_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureSubscriptions(_Model):
    """Azure Subscriptions model.

    :ivar azure_subscription_ids: Azure Subscription Ids to be updated. Required.
    :vartype azure_subscription_ids: list[str]
    """

    azure_subscription_ids: List[str] = rest_field(
        name="azureSubscriptionIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Subscription Ids to be updated. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_subscription_ids: List[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudAccountDetails(_Model):
    """Cloud Account Details model.

    :ivar cloud_account_name: Cloud Account name.
    :vartype cloud_account_name: str
    :ivar cloud_account_home_region: Cloud Account Home region.
    :vartype cloud_account_home_region: str
    """

    cloud_account_name: Optional[str] = rest_field(name="cloudAccountName", visibility=["read"])
    """Cloud Account name."""
    cloud_account_home_region: Optional[str] = rest_field(name="cloudAccountHomeRegion", visibility=["read"])
    """Cloud Account Home region."""


class CloudExadataInfrastructure(TrackedResource):
    """CloudExadataInfrastructure resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureProperties
    :ivar zones: CloudExadataInfrastructure zones. Required.
    :vartype zones: list[str]
    """

    properties: Optional["_models.CloudExadataInfrastructureProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    zones: List[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CloudExadataInfrastructure zones. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        zones: List[str],
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudExadataInfrastructureProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudExadataInfrastructureProperties(_Model):
    """CloudExadataInfrastructure resource model.

    :ivar defined_file_system_configuration: Defined file system configurations.
    :vartype defined_file_system_configuration:
     list[~azure.mgmt.oracledatabase.models.DefinedFileSystemConfiguration]
    :ivar ocid: Exadata infra ocid.
    :vartype ocid: str
    :ivar compute_count: The number of compute servers for the cloud Exadata infrastructure.
    :vartype compute_count: int
    :ivar storage_count: The number of storage servers for the cloud Exadata infrastructure.
    :vartype storage_count: int
    :ivar total_storage_size_in_gbs: The total storage allocated to the cloud Exadata
     infrastructure resource, in gigabytes (GB).
    :vartype total_storage_size_in_gbs: int
    :ivar available_storage_size_in_gbs: The available storage can be allocated to the cloud
     Exadata infrastructure resource, in gigabytes (GB).
    :vartype available_storage_size_in_gbs: int
    :ivar time_created: The date and time the cloud Exadata infrastructure resource was created.
    :vartype time_created: str
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar maintenance_window: maintenanceWindow property.
    :vartype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
    :ivar estimated_patching_time: The estimated total time required in minutes for all patching
     operations (database server, storage server, and network switch patching).
    :vartype estimated_patching_time: ~azure.mgmt.oracledatabase.models.EstimatedPatchingTime
    :ivar customer_contacts: The list of customer email addresses that receive information from
     Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
     send notifications about planned and unplanned software maintenance updates, information about
     system hardware, and other information needed by administrators. Up to 10 email addresses can
     be added to the customer contacts for a cloud Exadata infrastructure instance.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar provisioning_state: CloudExadataInfrastructure provisioning state. Known values are:
     "Succeeded", "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: CloudExadataInfrastructure lifecycle state. Known values are:
     "Provisioning", "Available", "Updating", "Terminating", "Terminated", "MaintenanceInProgress",
     and "Failed".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureLifecycleState
    :ivar shape: The model name of the cloud Exadata infrastructure resource. Required.
    :vartype shape: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar cpu_count: The total number of CPU cores allocated.
    :vartype cpu_count: int
    :ivar max_cpu_count: The total number of CPU cores available.
    :vartype max_cpu_count: int
    :ivar memory_size_in_gbs: The memory allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar max_memory_in_gbs: The total memory available in GBs.
    :vartype max_memory_in_gbs: int
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar max_db_node_storage_size_in_gbs: The total local node storage available in GBs.
    :vartype max_db_node_storage_size_in_gbs: int
    :ivar data_storage_size_in_tbs: The quantity of data in the database, in terabytes.
    :vartype data_storage_size_in_tbs: float
    :ivar max_data_storage_in_tbs: The total available DATA disk group size.
    :vartype max_data_storage_in_tbs: float
    :ivar db_server_version: The software version of the database servers (dom0) in the Exadata
     infrastructure.
    :vartype db_server_version: str
    :ivar storage_server_version: The software version of the storage servers (cells) in the
     Exadata infrastructure.
    :vartype storage_server_version: str
    :ivar activated_storage_count: The requested number of additional storage servers activated for
     the Exadata infrastructure.
    :vartype activated_storage_count: int
    :ivar additional_storage_count: The requested number of additional storage servers for the
     Exadata infrastructure.
    :vartype additional_storage_count: int
    :ivar display_name: The name for the Exadata infrastructure. Required.
    :vartype display_name: str
    :ivar last_maintenance_run_id: The OCID of the last maintenance run.
    :vartype last_maintenance_run_id: str
    :ivar next_maintenance_run_id: The OCID of the next maintenance run.
    :vartype next_maintenance_run_id: str
    :ivar monthly_db_server_version: Monthly Db Server version.
    :vartype monthly_db_server_version: str
    :ivar monthly_storage_server_version: Monthly Storage Server version.
    :vartype monthly_storage_server_version: str
    :ivar database_server_type: The database server model type of the cloud Exadata infrastructure
     resource.
    :vartype database_server_type: str
    :ivar storage_server_type: The storage server model type of the cloud Exadata infrastructure
     resource.
    :vartype storage_server_type: str
    :ivar compute_model: The compute model of the Exadata Infrastructure. Known values are: "ECPU"
     and "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    """

    defined_file_system_configuration: Optional[List["_models.DefinedFileSystemConfiguration"]] = rest_field(
        name="definedFileSystemConfiguration", visibility=["read"]
    )
    """Defined file system configurations."""
    ocid: Optional[str] = rest_field(visibility=["read"])
    """Exadata infra ocid."""
    compute_count: Optional[int] = rest_field(name="computeCount", visibility=["read", "create", "update"])
    """The number of compute servers for the cloud Exadata infrastructure."""
    storage_count: Optional[int] = rest_field(name="storageCount", visibility=["read", "create", "update"])
    """The number of storage servers for the cloud Exadata infrastructure."""
    total_storage_size_in_gbs: Optional[int] = rest_field(name="totalStorageSizeInGbs", visibility=["read"])
    """The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB)."""
    available_storage_size_in_gbs: Optional[int] = rest_field(name="availableStorageSizeInGbs", visibility=["read"])
    """The available storage can be allocated to the cloud Exadata infrastructure resource, in
     gigabytes (GB)."""
    time_created: Optional[str] = rest_field(name="timeCreated", visibility=["read"])
    """The date and time the cloud Exadata infrastructure resource was created."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    maintenance_window: Optional["_models.MaintenanceWindow"] = rest_field(
        name="maintenanceWindow", visibility=["read", "create", "update"]
    )
    """maintenanceWindow property."""
    estimated_patching_time: Optional["_models.EstimatedPatchingTime"] = rest_field(
        name="estimatedPatchingTime", visibility=["read"]
    )
    """The estimated total time required in minutes for all patching operations (database server,
     storage server, and network switch patching)."""
    customer_contacts: Optional[List["_models.CustomerContact"]] = rest_field(
        name="customerContacts", visibility=["read", "create", "update"]
    )
    """The list of customer email addresses that receive information from Oracle about the specified
     OCI Database service resource. Oracle uses these email addresses to send notifications about
     planned and unplanned software maintenance updates, information about system hardware, and
     other information needed by administrators. Up to 10 email addresses can be added to the
     customer contacts for a cloud Exadata infrastructure instance."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """CloudExadataInfrastructure provisioning state. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.CloudExadataInfrastructureLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """CloudExadataInfrastructure lifecycle state. Known values are: \"Provisioning\", \"Available\",
     \"Updating\", \"Terminating\", \"Terminated\", \"MaintenanceInProgress\", and \"Failed\"."""
    shape: str = rest_field(visibility=["read", "create"])
    """The model name of the cloud Exadata infrastructure resource. Required."""
    oci_url: Optional[str] = rest_field(name="ociUrl", visibility=["read"])
    """HTTPS link to OCI resources exposed to Azure Customer via Azure Interface."""
    cpu_count: Optional[int] = rest_field(name="cpuCount", visibility=["read"])
    """The total number of CPU cores allocated."""
    max_cpu_count: Optional[int] = rest_field(name="maxCpuCount", visibility=["read"])
    """The total number of CPU cores available."""
    memory_size_in_gbs: Optional[int] = rest_field(name="memorySizeInGbs", visibility=["read"])
    """The memory allocated in GBs."""
    max_memory_in_gbs: Optional[int] = rest_field(name="maxMemoryInGbs", visibility=["read"])
    """The total memory available in GBs."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(name="dbNodeStorageSizeInGbs", visibility=["read"])
    """The local node storage to be allocated in GBs."""
    max_db_node_storage_size_in_gbs: Optional[int] = rest_field(name="maxDbNodeStorageSizeInGbs", visibility=["read"])
    """The total local node storage available in GBs."""
    data_storage_size_in_tbs: Optional[float] = rest_field(name="dataStorageSizeInTbs", visibility=["read"])
    """The quantity of data in the database, in terabytes."""
    max_data_storage_in_tbs: Optional[float] = rest_field(name="maxDataStorageInTbs", visibility=["read"])
    """The total available DATA disk group size."""
    db_server_version: Optional[str] = rest_field(name="dbServerVersion", visibility=["read"])
    """The software version of the database servers (dom0) in the Exadata infrastructure."""
    storage_server_version: Optional[str] = rest_field(name="storageServerVersion", visibility=["read"])
    """The software version of the storage servers (cells) in the Exadata infrastructure."""
    activated_storage_count: Optional[int] = rest_field(name="activatedStorageCount", visibility=["read"])
    """The requested number of additional storage servers activated for the Exadata infrastructure."""
    additional_storage_count: Optional[int] = rest_field(name="additionalStorageCount", visibility=["read"])
    """The requested number of additional storage servers for the Exadata infrastructure."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update"])
    """The name for the Exadata infrastructure. Required."""
    last_maintenance_run_id: Optional[str] = rest_field(name="lastMaintenanceRunId", visibility=["read"])
    """The OCID of the last maintenance run."""
    next_maintenance_run_id: Optional[str] = rest_field(name="nextMaintenanceRunId", visibility=["read"])
    """The OCID of the next maintenance run."""
    monthly_db_server_version: Optional[str] = rest_field(name="monthlyDbServerVersion", visibility=["read"])
    """Monthly Db Server version."""
    monthly_storage_server_version: Optional[str] = rest_field(name="monthlyStorageServerVersion", visibility=["read"])
    """Monthly Storage Server version."""
    database_server_type: Optional[str] = rest_field(name="databaseServerType", visibility=["read", "create"])
    """The database server model type of the cloud Exadata infrastructure resource."""
    storage_server_type: Optional[str] = rest_field(name="storageServerType", visibility=["read", "create"])
    """The storage server model type of the cloud Exadata infrastructure resource."""
    compute_model: Optional[Union[str, "_models.ComputeModel"]] = rest_field(name="computeModel", visibility=["read"])
    """The compute model of the Exadata Infrastructure. Known values are: \"ECPU\" and \"OCPU\"."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        shape: str,
        display_name: str,
        compute_count: Optional[int] = None,
        storage_count: Optional[int] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        database_server_type: Optional[str] = None,
        storage_server_type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudExadataInfrastructureUpdate(_Model):
    """The type used for update operations of the CloudExadataInfrastructure.

    :ivar zones: CloudExadataInfrastructure zones.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.oracledatabase.models.CloudExadataInfrastructureUpdateProperties
    """

    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """CloudExadataInfrastructure zones."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.CloudExadataInfrastructureUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudExadataInfrastructureUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudExadataInfrastructureUpdateProperties(_Model):  # pylint: disable=name-too-long
    """The updatable properties of the CloudExadataInfrastructure.

    :ivar compute_count: The number of compute servers for the cloud Exadata infrastructure.
    :vartype compute_count: int
    :ivar storage_count: The number of storage servers for the cloud Exadata infrastructure.
    :vartype storage_count: int
    :ivar maintenance_window: maintenanceWindow property.
    :vartype maintenance_window: ~azure.mgmt.oracledatabase.models.MaintenanceWindow
    :ivar customer_contacts: The list of customer email addresses that receive information from
     Oracle about the specified OCI Database service resource. Oracle uses these email addresses to
     send notifications about planned and unplanned software maintenance updates, information about
     system hardware, and other information needed by administrators. Up to 10 email addresses can
     be added to the customer contacts for a cloud Exadata infrastructure instance.
    :vartype customer_contacts: list[~azure.mgmt.oracledatabase.models.CustomerContact]
    :ivar display_name: The name for the Exadata infrastructure.
    :vartype display_name: str
    """

    compute_count: Optional[int] = rest_field(name="computeCount", visibility=["read", "create", "update"])
    """The number of compute servers for the cloud Exadata infrastructure."""
    storage_count: Optional[int] = rest_field(name="storageCount", visibility=["read", "create", "update"])
    """The number of storage servers for the cloud Exadata infrastructure."""
    maintenance_window: Optional["_models.MaintenanceWindow"] = rest_field(
        name="maintenanceWindow", visibility=["read", "create", "update"]
    )
    """maintenanceWindow property."""
    customer_contacts: Optional[List["_models.CustomerContact"]] = rest_field(
        name="customerContacts", visibility=["read", "create", "update"]
    )
    """The list of customer email addresses that receive information from Oracle about the specified
     OCI Database service resource. Oracle uses these email addresses to send notifications about
     planned and unplanned software maintenance updates, information about system hardware, and
     other information needed by administrators. Up to 10 email addresses can be added to the
     customer contacts for a cloud Exadata infrastructure instance."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read", "create", "update"])
    """The name for the Exadata infrastructure."""

    @overload
    def __init__(
        self,
        *,
        compute_count: Optional[int] = None,
        storage_count: Optional[int] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        customer_contacts: Optional[List["_models.CustomerContact"]] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudVmCluster(TrackedResource):
    """CloudVmCluster resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterProperties
    """

    properties: Optional["_models.CloudVmClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudVmClusterProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudVmClusterProperties(_Model):
    """CloudVmCluster resource model.

    :ivar ocid: Cloud VM Cluster ocid.
    :vartype ocid: str
    :ivar listener_port: The port number configured for the listener on the cloud VM cluster.
    :vartype listener_port: int
    :ivar node_count: The number of nodes in the cloud VM cluster.
    :vartype node_count: int
    :ivar storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
    :vartype storage_size_in_gbs: int
    :ivar file_system_configuration_details: Array of mount path and size.
    :vartype file_system_configuration_details:
     list[~azure.mgmt.oracledatabase.models.FileSystemConfigurationDetails]
    :ivar data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
    :vartype data_storage_size_in_tbs: float
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar memory_size_in_gbs: The memory to be allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar time_created: The date and time that the cloud VM cluster was created.
    :vartype time_created: ~datetime.datetime
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar time_zone: The time zone of the cloud VM cluster. For details, see `Exadata
     Infrastructure Time Zones </Content/Database/References/timezones.htm>`_.
    :vartype time_zone: str
    :ivar zone_id: The OCID of the zone the cloud VM cluster is associated with.
    :vartype zone_id: str
    :ivar hostname: The hostname for the cloud VM cluster. Required.
    :vartype hostname: str
    :ivar domain: The domain name for the cloud VM cluster.
    :vartype domain: str
    :ivar cpu_core_count: The number of CPU cores enabled on the cloud VM cluster. Required.
    :vartype cpu_core_count: int
    :ivar ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
     place is allowed for the fractional part.
    :vartype ocpu_count: float
    :ivar cluster_name: The cluster name for cloud VM cluster. The cluster name must begin with an
     alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The
     cluster name can be no longer than 11 characters and is not case sensitive.
    :vartype cluster_name: str
    :ivar data_storage_percentage: The percentage assigned to DATA storage (user data and database
     files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs,
     and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent
     assigned to DATA storage. See `Storage Configuration
     </Content/Database/Concepts/exaoverview.htm#Exadata>`_ in the Exadata documentation for details
     on the impact of the configuration settings on storage.
    :vartype data_storage_percentage: int
    :ivar is_local_backup_enabled: If true, database backup on local Exadata storage is configured
     for the cloud VM cluster. If false, database backup on local Exadata storage is not available
     in the cloud VM cluster.
    :vartype is_local_backup_enabled: bool
    :ivar cloud_exadata_infrastructure_id: Cloud Exadata Infrastructure ID. Required.
    :vartype cloud_exadata_infrastructure_id: str
    :ivar is_sparse_diskgroup_enabled: If true, sparse disk group is configured for the cloud VM
     cluster. If false, sparse disk group is not created.
    :vartype is_sparse_diskgroup_enabled: bool
    :ivar system_version: Operating system version of the image.
    :vartype system_version: str
    :ivar ssh_public_keys: The public key portion of one or more key pairs used for SSH access to
     the cloud VM cluster. Required.
    :vartype ssh_public_keys: list[str]
    :ivar license_model: The Oracle license model that applies to the cloud VM cluster. The default
     is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar disk_redundancy: The type of redundancy configured for the cloud Vm cluster. NORMAL is
     2-way redundancy. HIGH is 3-way redundancy. Known values are: "High" and "Normal".
    :vartype disk_redundancy: str or ~azure.mgmt.oracledatabase.models.DiskRedundancy
    :ivar scan_ip_ids: The Single Client Access Name (SCAN) IP addresses associated with the cloud
     VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any
     interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
     **Note:** For a single-node DB system, this list is empty.
    :vartype scan_ip_ids: list[str]
    :ivar vip_ids: The virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster
     Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud
     Service instance to enable failover. If one node fails, the VIP is reassigned to another active
     node in the cluster. **Note:** For a single-node DB system, this list is empty.
    :vartype vip_ids: list[str]
    :ivar scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated
     with the cloud VM cluster.
    :vartype scan_dns_name: str
    :ivar scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port
     is 1521.
    :vartype scan_listener_port_tcp: int
    :ivar scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default
     port is 2484.
    :vartype scan_listener_port_tcp_ssl: int
    :ivar scan_dns_record_id: The OCID of the DNS record for the SCAN IP addresses that are
     associated with the cloud VM cluster.
    :vartype scan_dns_record_id: str
    :ivar shape: The model name of the Exadata hardware running the cloud VM cluster.
    :vartype shape: str
    :ivar provisioning_state: CloudVmCluster provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: CloudVmCluster lifecycle state. Known values are: "Provisioning",
     "Available", "Updating", "Terminating", "Terminated", "MaintenanceInProgress", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.CloudVmClusterLifecycleState
    :ivar vnet_id: VNET for network connectivity. Required.
    :vartype vnet_id: str
    :ivar gi_version: Oracle Grid Infrastructure (GI) software version. Required.
    :vartype gi_version: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar nsg_url: HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure
     Interface.
    :vartype nsg_url: str
    :ivar subnet_id: Client subnet. Required.
    :vartype subnet_id: str
    :ivar backup_subnet_cidr: Client OCI backup subnet CIDR, default is 192.168.252.0/22.
    :vartype backup_subnet_cidr: str
    :ivar nsg_cidrs: CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision
     the VM Cluster will be added by default.
    :vartype nsg_cidrs: list[~azure.mgmt.oracledatabase.models.NsgCidr]
    :ivar data_collection_options: Indicates user preferences for the various diagnostic collection
     options for the VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
    :ivar display_name: Display Name. Required.
    :vartype display_name: str
    :ivar compute_nodes: The list of compute servers to be added to the cloud VM cluster.
    :vartype compute_nodes: list[str]
    :ivar iorm_config_cache: iormConfigCache details for cloud VM cluster.
    :vartype iorm_config_cache: ~azure.mgmt.oracledatabase.models.ExadataIormConfig
    :ivar last_update_history_entry_id: The OCID of the last maintenance update history entry.
    :vartype last_update_history_entry_id: str
    :ivar db_servers: The list of DB servers.
    :vartype db_servers: list[str]
    :ivar compartment_id: Cluster compartmentId.
    :vartype compartment_id: str
    :ivar subnet_ocid: Cluster subnet ocid.
    :vartype subnet_ocid: str
    :ivar compute_model: The compute model of the VM Cluster. Known values are: "ECPU" and "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    """

    ocid: Optional[str] = rest_field(visibility=["read"])
    """Cloud VM Cluster ocid."""
    listener_port: Optional[int] = rest_field(name="listenerPort", visibility=["read"])
    """The port number configured for the listener on the cloud VM cluster."""
    node_count: Optional[int] = rest_field(name="nodeCount", visibility=["read"])
    """The number of nodes in the cloud VM cluster."""
    storage_size_in_gbs: Optional[int] = rest_field(name="storageSizeInGbs", visibility=["read", "update"])
    """The data disk group size to be allocated in GBs per VM."""
    file_system_configuration_details: Optional[List["_models.FileSystemConfigurationDetails"]] = rest_field(
        name="fileSystemConfigurationDetails", visibility=["read", "update"]
    )
    """Array of mount path and size."""
    data_storage_size_in_tbs: Optional[float] = rest_field(
        name="dataStorageSizeInTbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data disk group size to be allocated in TBs."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(
        name="dbNodeStorageSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The local node storage to be allocated in GBs."""
    memory_size_in_gbs: Optional[int] = rest_field(
        name="memorySizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The memory to be allocated in GBs."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """The date and time that the cloud VM cluster was created."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create"])
    """The time zone of the cloud VM cluster. For details, see `Exadata Infrastructure Time Zones
     </Content/Database/References/timezones.htm>`_."""
    zone_id: Optional[str] = rest_field(name="zoneId", visibility=["read", "create"])
    """The OCID of the zone the cloud VM cluster is associated with."""
    hostname: str = rest_field(visibility=["read", "create"])
    """The hostname for the cloud VM cluster. Required."""
    domain: Optional[str] = rest_field(visibility=["read", "create"])
    """The domain name for the cloud VM cluster."""
    cpu_core_count: int = rest_field(name="cpuCoreCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of CPU cores enabled on the cloud VM cluster. Required."""
    ocpu_count: Optional[float] = rest_field(
        name="ocpuCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for
     the fractional part."""
    cluster_name: Optional[str] = rest_field(name="clusterName", visibility=["read", "create"])
    """The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic
     character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can
     be no longer than 11 characters and is not case sensitive."""
    data_storage_percentage: Optional[int] = rest_field(name="dataStoragePercentage", visibility=["read", "create"])
    """The percentage assigned to DATA storage (user data and database files). The remaining
     percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager
     backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA
     storage. See `Storage Configuration </Content/Database/Concepts/exaoverview.htm#Exadata>`_ in
     the Exadata documentation for details on the impact of the configuration settings on storage."""
    is_local_backup_enabled: Optional[bool] = rest_field(name="isLocalBackupEnabled", visibility=["read", "create"])
    """If true, database backup on local Exadata storage is configured for the cloud VM cluster. If
     false, database backup on local Exadata storage is not available in the cloud VM cluster."""
    cloud_exadata_infrastructure_id: str = rest_field(
        name="cloudExadataInfrastructureId", visibility=["read", "create"]
    )
    """Cloud Exadata Infrastructure ID. Required."""
    is_sparse_diskgroup_enabled: Optional[bool] = rest_field(
        name="isSparseDiskgroupEnabled", visibility=["read", "create"]
    )
    """If true, sparse disk group is configured for the cloud VM cluster. If false, sparse disk group
     is not created."""
    system_version: Optional[str] = rest_field(name="systemVersion", visibility=["read", "create"])
    """Operating system version of the image."""
    ssh_public_keys: List[str] = rest_field(
        name="sshPublicKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The public key portion of one or more key pairs used for SSH access to the cloud VM cluster.
     Required."""
    license_model: Optional[Union[str, "_models.LicenseModel"]] = rest_field(
        name="licenseModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED.
     Known values are: \"LicenseIncluded\" and \"BringYourOwnLicense\"."""
    disk_redundancy: Optional[Union[str, "_models.DiskRedundancy"]] = rest_field(
        name="diskRedundancy", visibility=["read"]
    )
    """The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is
     3-way redundancy. Known values are: \"High\" and \"Normal\"."""
    scan_ip_ids: Optional[List[str]] = rest_field(name="scanIpIds", visibility=["read"])
    """The Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP
     addresses are typically used for load balancing and are not assigned to any interface. Oracle
     Clusterware directs the requests to the appropriate nodes in the cluster. **Note:** For a
     single-node DB system, this list is empty."""
    vip_ids: Optional[List[str]] = rest_field(name="vipIds", visibility=["read"])
    """The virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services
     (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance
     to enable failover. If one node fails, the VIP is reassigned to another active node in the
     cluster. **Note:** For a single-node DB system, this list is empty."""
    scan_dns_name: Optional[str] = rest_field(name="scanDnsName", visibility=["read"])
    """The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM
     cluster."""
    scan_listener_port_tcp: Optional[int] = rest_field(name="scanListenerPortTcp", visibility=["read", "create"])
    """The TCP Single Client Access Name (SCAN) port. The default port is 1521."""
    scan_listener_port_tcp_ssl: Optional[int] = rest_field(name="scanListenerPortTcpSsl", visibility=["read", "create"])
    """The TCPS Single Client Access Name (SCAN) port. The default port is 2484."""
    scan_dns_record_id: Optional[str] = rest_field(name="scanDnsRecordId", visibility=["read"])
    """The OCID of the DNS record for the SCAN IP addresses that are associated with the cloud VM
     cluster."""
    shape: Optional[str] = rest_field(visibility=["read"])
    """The model name of the Exadata hardware running the cloud VM cluster."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """CloudVmCluster provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.CloudVmClusterLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """CloudVmCluster lifecycle state. Known values are: \"Provisioning\", \"Available\",
     \"Updating\", \"Terminating\", \"Terminated\", \"MaintenanceInProgress\", and \"Failed\"."""
    vnet_id: str = rest_field(name="vnetId", visibility=["read", "create"])
    """VNET for network connectivity. Required."""
    gi_version: str = rest_field(name="giVersion", visibility=["read", "create"])
    """Oracle Grid Infrastructure (GI) software version. Required."""
    oci_url: Optional[str] = rest_field(name="ociUrl", visibility=["read"])
    """HTTPS link to OCI resources exposed to Azure Customer via Azure Interface."""
    nsg_url: Optional[str] = rest_field(name="nsgUrl", visibility=["read"])
    """HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure Interface."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create"])
    """Client subnet. Required."""
    backup_subnet_cidr: Optional[str] = rest_field(name="backupSubnetCidr", visibility=["read", "create"])
    """Client OCI backup subnet CIDR, default is 192.168.252.0/22."""
    nsg_cidrs: Optional[List["_models.NsgCidr"]] = rest_field(name="nsgCidrs", visibility=["read", "create"])
    """CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision the VM Cluster
     will be added by default."""
    data_collection_options: Optional["_models.DataCollectionOptions"] = rest_field(
        name="dataCollectionOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates user preferences for the various diagnostic collection options for the VM
     cluster/Cloud VM cluster/VMBM DBCS."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """Display Name. Required."""
    compute_nodes: Optional[List[str]] = rest_field(name="computeNodes", visibility=["update"])
    """The list of compute servers to be added to the cloud VM cluster."""
    iorm_config_cache: Optional["_models.ExadataIormConfig"] = rest_field(name="iormConfigCache", visibility=["read"])
    """iormConfigCache details for cloud VM cluster."""
    last_update_history_entry_id: Optional[str] = rest_field(name="lastUpdateHistoryEntryId", visibility=["read"])
    """The OCID of the last maintenance update history entry."""
    db_servers: Optional[List[str]] = rest_field(name="dbServers", visibility=["read", "create"])
    """The list of DB servers."""
    compartment_id: Optional[str] = rest_field(name="compartmentId", visibility=["read"])
    """Cluster compartmentId."""
    subnet_ocid: Optional[str] = rest_field(name="subnetOcid", visibility=["read"])
    """Cluster subnet ocid."""
    compute_model: Optional[Union[str, "_models.ComputeModel"]] = rest_field(name="computeModel", visibility=["read"])
    """The compute model of the VM Cluster. Known values are: \"ECPU\" and \"OCPU\"."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        hostname: str,
        cpu_core_count: int,
        cloud_exadata_infrastructure_id: str,
        ssh_public_keys: List[str],
        vnet_id: str,
        gi_version: str,
        subnet_id: str,
        display_name: str,
        storage_size_in_gbs: Optional[int] = None,
        file_system_configuration_details: Optional[List["_models.FileSystemConfigurationDetails"]] = None,
        data_storage_size_in_tbs: Optional[float] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        memory_size_in_gbs: Optional[int] = None,
        time_zone: Optional[str] = None,
        zone_id: Optional[str] = None,
        domain: Optional[str] = None,
        ocpu_count: Optional[float] = None,
        cluster_name: Optional[str] = None,
        data_storage_percentage: Optional[int] = None,
        is_local_backup_enabled: Optional[bool] = None,
        is_sparse_diskgroup_enabled: Optional[bool] = None,
        system_version: Optional[str] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        scan_listener_port_tcp: Optional[int] = None,
        scan_listener_port_tcp_ssl: Optional[int] = None,
        backup_subnet_cidr: Optional[str] = None,
        nsg_cidrs: Optional[List["_models.NsgCidr"]] = None,
        data_collection_options: Optional["_models.DataCollectionOptions"] = None,
        compute_nodes: Optional[List[str]] = None,
        db_servers: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudVmClusterUpdate(_Model):
    """The type used for update operations of the CloudVmCluster.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.CloudVmClusterUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.CloudVmClusterUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudVmClusterUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudVmClusterUpdateProperties(_Model):
    """The updatable properties of the CloudVmCluster.

    :ivar storage_size_in_gbs: The data disk group size to be allocated in GBs per VM.
    :vartype storage_size_in_gbs: int
    :ivar file_system_configuration_details: Array of mount path and size.
    :vartype file_system_configuration_details:
     list[~azure.mgmt.oracledatabase.models.FileSystemConfigurationDetails]
    :ivar data_storage_size_in_tbs: The data disk group size to be allocated in TBs.
    :vartype data_storage_size_in_tbs: float
    :ivar db_node_storage_size_in_gbs: The local node storage to be allocated in GBs.
    :vartype db_node_storage_size_in_gbs: int
    :ivar memory_size_in_gbs: The memory to be allocated in GBs.
    :vartype memory_size_in_gbs: int
    :ivar cpu_core_count: The number of CPU cores enabled on the cloud VM cluster.
    :vartype cpu_core_count: int
    :ivar ocpu_count: The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal
     place is allowed for the fractional part.
    :vartype ocpu_count: float
    :ivar ssh_public_keys: The public key portion of one or more key pairs used for SSH access to
     the cloud VM cluster.
    :vartype ssh_public_keys: list[str]
    :ivar license_model: The Oracle license model that applies to the cloud VM cluster. The default
     is LICENSE_INCLUDED. Known values are: "LicenseIncluded" and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar data_collection_options: Indicates user preferences for the various diagnostic collection
     options for the VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
    :ivar display_name: Display Name.
    :vartype display_name: str
    :ivar compute_nodes: The list of compute servers to be added to the cloud VM cluster.
    :vartype compute_nodes: list[str]
    """

    storage_size_in_gbs: Optional[int] = rest_field(name="storageSizeInGbs", visibility=["read", "update"])
    """The data disk group size to be allocated in GBs per VM."""
    file_system_configuration_details: Optional[List["_models.FileSystemConfigurationDetails"]] = rest_field(
        name="fileSystemConfigurationDetails", visibility=["read", "update"]
    )
    """Array of mount path and size."""
    data_storage_size_in_tbs: Optional[float] = rest_field(
        name="dataStorageSizeInTbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data disk group size to be allocated in TBs."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(
        name="dbNodeStorageSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The local node storage to be allocated in GBs."""
    memory_size_in_gbs: Optional[int] = rest_field(
        name="memorySizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The memory to be allocated in GBs."""
    cpu_core_count: Optional[int] = rest_field(
        name="cpuCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of CPU cores enabled on the cloud VM cluster."""
    ocpu_count: Optional[float] = rest_field(
        name="ocpuCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for
     the fractional part."""
    ssh_public_keys: Optional[List[str]] = rest_field(
        name="sshPublicKeys", visibility=["read", "create", "update", "delete", "query"]
    )
    """The public key portion of one or more key pairs used for SSH access to the cloud VM cluster."""
    license_model: Optional[Union[str, "_models.LicenseModel"]] = rest_field(
        name="licenseModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED.
     Known values are: \"LicenseIncluded\" and \"BringYourOwnLicense\"."""
    data_collection_options: Optional["_models.DataCollectionOptions"] = rest_field(
        name="dataCollectionOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates user preferences for the various diagnostic collection options for the VM
     cluster/Cloud VM cluster/VMBM DBCS."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display Name."""
    compute_nodes: Optional[List[str]] = rest_field(name="computeNodes", visibility=["update"])
    """The list of compute servers to be added to the cloud VM cluster."""

    @overload
    def __init__(
        self,
        *,
        storage_size_in_gbs: Optional[int] = None,
        file_system_configuration_details: Optional[List["_models.FileSystemConfigurationDetails"]] = None,
        data_storage_size_in_tbs: Optional[float] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        memory_size_in_gbs: Optional[int] = None,
        cpu_core_count: Optional[int] = None,
        ocpu_count: Optional[float] = None,
        ssh_public_keys: Optional[List[str]] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        data_collection_options: Optional["_models.DataCollectionOptions"] = None,
        display_name: Optional[str] = None,
        compute_nodes: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectionStringType(_Model):
    """Connection strings to connect to an Oracle Autonomous Database.

    :ivar all_connection_strings: Returns all connection strings that can be used to connect to the
     Autonomous Database.
    :vartype all_connection_strings: ~azure.mgmt.oracledatabase.models.AllConnectionStringType
    :ivar dedicated: The database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype dedicated: str
    :ivar high: The High database service provides the highest level of resources to each SQL
     statement resulting in the highest performance, but supports the fewest number of concurrent
     SQL statements.
    :vartype high: str
    :ivar low: The Low database service provides the least level of resources to each SQL
     statement, but supports the most number of concurrent SQL statements.
    :vartype low: str
    :ivar medium: The Medium database service provides a lower level of resources to each SQL
     statement potentially resulting a lower level of performance, but supports more concurrent SQL
     statements.
    :vartype medium: str
    :ivar profiles: A list of connection string profiles to allow clients to group, filter and
     select connection string values based on structured metadata.
    :vartype profiles: list[~azure.mgmt.oracledatabase.models.ProfileType]
    """

    all_connection_strings: Optional["_models.AllConnectionStringType"] = rest_field(
        name="allConnectionStrings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Returns all connection strings that can be used to connect to the Autonomous Database."""
    dedicated: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The database service provides the least level of resources to each SQL statement, but supports
     the most number of concurrent SQL statements."""
    high: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The High database service provides the highest level of resources to each SQL statement
     resulting in the highest performance, but supports the fewest number of concurrent SQL
     statements."""
    low: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Low database service provides the least level of resources to each SQL statement, but
     supports the most number of concurrent SQL statements."""
    medium: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Medium database service provides a lower level of resources to each SQL statement
     potentially resulting a lower level of performance, but supports more concurrent SQL
     statements."""
    profiles: Optional[List["_models.ProfileType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of connection string profiles to allow clients to group, filter and select connection
     string values based on structured metadata."""

    @overload
    def __init__(
        self,
        *,
        all_connection_strings: Optional["_models.AllConnectionStringType"] = None,
        dedicated: Optional[str] = None,
        high: Optional[str] = None,
        low: Optional[str] = None,
        medium: Optional[str] = None,
        profiles: Optional[List["_models.ProfileType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectionUrlType(_Model):
    """The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser
    from a Compute instance within your VCN or that has a direct connection to your VCN.

    :ivar apex_url: Oracle Application Express (APEX) URL.
    :vartype apex_url: str
    :ivar database_transforms_url: The URL of the Database Transforms for the Autonomous Database.
    :vartype database_transforms_url: str
    :ivar graph_studio_url: The URL of the Graph Studio for the Autonomous Database.
    :vartype graph_studio_url: str
    :ivar machine_learning_notebook_url: The URL of the Oracle Machine Learning (OML) Notebook for
     the Autonomous Database.
    :vartype machine_learning_notebook_url: str
    :ivar mongo_db_url: The URL of the MongoDB API for the Autonomous Database.
    :vartype mongo_db_url: str
    :ivar ords_url: The Oracle REST Data Services (ORDS) URL of the Web Access for the Autonomous
     Database.
    :vartype ords_url: str
    :ivar sql_dev_web_url: Oracle SQL Developer Web URL.
    :vartype sql_dev_web_url: str
    """

    apex_url: Optional[str] = rest_field(name="apexUrl", visibility=["read", "create", "update", "delete", "query"])
    """Oracle Application Express (APEX) URL."""
    database_transforms_url: Optional[str] = rest_field(
        name="databaseTransformsUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the Database Transforms for the Autonomous Database."""
    graph_studio_url: Optional[str] = rest_field(
        name="graphStudioUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the Graph Studio for the Autonomous Database."""
    machine_learning_notebook_url: Optional[str] = rest_field(
        name="machineLearningNotebookUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the Oracle Machine Learning (OML) Notebook for the Autonomous Database."""
    mongo_db_url: Optional[str] = rest_field(
        name="mongoDbUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the MongoDB API for the Autonomous Database."""
    ords_url: Optional[str] = rest_field(name="ordsUrl", visibility=["read", "create", "update", "delete", "query"])
    """The Oracle REST Data Services (ORDS) URL of the Web Access for the Autonomous Database."""
    sql_dev_web_url: Optional[str] = rest_field(
        name="sqlDevWebUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """Oracle SQL Developer Web URL."""

    @overload
    def __init__(
        self,
        *,
        apex_url: Optional[str] = None,
        database_transforms_url: Optional[str] = None,
        graph_studio_url: Optional[str] = None,
        machine_learning_notebook_url: Optional[str] = None,
        mongo_db_url: Optional[str] = None,
        ords_url: Optional[str] = None,
        sql_dev_web_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomerContact(_Model):
    """CustomerContact resource properties.

    :ivar email: The email address used by Oracle to send notifications regarding databases and
     infrastructure. Required.
    :vartype email: str
    """

    email: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The email address used by Oracle to send notifications regarding databases and infrastructure.
     Required."""

    @overload
    def __init__(
        self,
        *,
        email: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataCollectionOptions(_Model):
    """DataCollectionOptions resource properties.

    :ivar is_diagnostics_events_enabled: Indicates whether diagnostic collection is enabled for the
     VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype is_diagnostics_events_enabled: bool
    :ivar is_health_monitoring_enabled: Indicates whether health monitoring is enabled for the VM
     cluster / Cloud VM cluster / VMBM DBCS.
    :vartype is_health_monitoring_enabled: bool
    :ivar is_incident_logs_enabled: Indicates whether incident logs and trace collection are
     enabled for the VM cluster / Cloud VM cluster / VMBM DBCS.
    :vartype is_incident_logs_enabled: bool
    """

    is_diagnostics_events_enabled: Optional[bool] = rest_field(
        name="isDiagnosticsEventsEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether diagnostic collection is enabled for the VM cluster/Cloud VM cluster/VMBM
     DBCS."""
    is_health_monitoring_enabled: Optional[bool] = rest_field(
        name="isHealthMonitoringEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether health monitoring is enabled for the VM cluster / Cloud VM cluster / VMBM
     DBCS."""
    is_incident_logs_enabled: Optional[bool] = rest_field(
        name="isIncidentLogsEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether incident logs and trace collection are enabled for the VM cluster / Cloud VM
     cluster / VMBM DBCS."""

    @overload
    def __init__(
        self,
        *,
        is_diagnostics_events_enabled: Optional[bool] = None,
        is_health_monitoring_enabled: Optional[bool] = None,
        is_incident_logs_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DayOfWeek(_Model):
    """DayOfWeek resource properties.

    :ivar name: Name of the day of the week. Required. Known values are: "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
    """

    name: Union[str, "_models.DayOfWeekName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the day of the week. Required. Known values are: \"Monday\", \"Tuesday\",
     \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", and \"Sunday\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.DayOfWeekName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DayOfWeekUpdate(_Model):
    """DayOfWeek resource properties.

    :ivar name: Name of the day of the week. Required. Known values are: "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.DayOfWeekName
    """

    name: Union[str, "_models.DayOfWeekName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the day of the week. Required. Known values are: \"Monday\", \"Tuesday\",
     \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\", and \"Sunday\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.DayOfWeekName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbActionResponse(_Model):
    """ExascaleDbNode action response.

    :ivar provisioning_state: ExascaleDbNode provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    """

    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """ExascaleDbNode provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Provisioning\"."""

    @overload
    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbIormConfig(_Model):
    """DbIormConfig for cloud vm cluster.

    :ivar db_name: The database name. For the default DbPlan, the dbName is default.
    :vartype db_name: str
    :ivar flash_cache_limit: The flash cache limit for this database. This value is internally
     configured based on the share value assigned to the database.
    :vartype flash_cache_limit: str
    :ivar share: The relative priority of this database.
    :vartype share: int
    """

    db_name: Optional[str] = rest_field(name="dbName", visibility=["read", "create", "update", "delete", "query"])
    """The database name. For the default DbPlan, the dbName is default."""
    flash_cache_limit: Optional[str] = rest_field(
        name="flashCacheLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """The flash cache limit for this database. This value is internally configured based on the share
     value assigned to the database."""
    share: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The relative priority of this database."""

    @overload
    def __init__(
        self,
        *,
        db_name: Optional[str] = None,
        flash_cache_limit: Optional[str] = None,
        share: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbNode(ProxyResource):
    """The DbNode resource belonging to vmCluster.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbNodeProperties
    """

    properties: Optional["_models.DbNodeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DbNodeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbNodeAction(_Model):
    """DbNode action object.

    :ivar action: Db action. Required. Known values are: "Start", "Stop", "SoftReset", and "Reset".
    :vartype action: str or ~azure.mgmt.oracledatabase.models.DbNodeActionEnum
    """

    action: Union[str, "_models.DbNodeActionEnum"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Db action. Required. Known values are: \"Start\", \"Stop\", \"SoftReset\", and \"Reset\"."""

    @overload
    def __init__(
        self,
        *,
        action: Union[str, "_models.DbNodeActionEnum"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbNodeDetails(_Model):
    """Details of the ExaCS Db node. Applies to Exadata Database Service on Exascale Infrastructure
    only.

    :ivar db_node_id: Exascale DbNode Azure Resource ID. Required.
    :vartype db_node_id: str
    """

    db_node_id: str = rest_field(name="dbNodeId", visibility=["read", "create", "update", "delete", "query"])
    """Exascale DbNode Azure Resource ID. Required."""

    @overload
    def __init__(
        self,
        *,
        db_node_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbNodeProperties(_Model):
    """The properties of DbNodeResource.

    :ivar ocid: DbNode OCID. Required.
    :vartype ocid: str
    :ivar additional_details: Additional information about the planned maintenance.
    :vartype additional_details: str
    :ivar backup_ip_id: The OCID of the backup IP address associated with the database node.
    :vartype backup_ip_id: str
    :ivar backup_vnic2_id: The OCID of the second backup VNIC.
    :vartype backup_vnic2_id: str
    :ivar backup_vnic_id: The OCID of the backup VNIC.
    :vartype backup_vnic_id: str
    :ivar cpu_core_count: The number of CPU cores enabled on the Db node.
    :vartype cpu_core_count: int
    :ivar db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db node.
    :vartype db_node_storage_size_in_gbs: int
    :ivar db_server_id: The OCID of the Exacc Db server associated with the database node.
    :vartype db_server_id: str
    :ivar db_system_id: The OCID of the DB system. Required.
    :vartype db_system_id: str
    :ivar fault_domain: The name of the Fault Domain the instance is contained in.
    :vartype fault_domain: str
    :ivar host_ip_id: The OCID of the host IP address associated with the database node.
    :vartype host_ip_id: str
    :ivar hostname: The host name for the database node.
    :vartype hostname: str
    :ivar lifecycle_state: The current state of the database node. Required. Known values are:
     "Provisioning", "Available", "Updating", "Stopping", "Stopped", "Starting", "Terminating",
     "Terminated", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.DbNodeProvisioningState
    :ivar lifecycle_details: Lifecycle details of Db Node.
    :vartype lifecycle_details: str
    :ivar maintenance_type: The type of database node maintenance. "VmdbRebootMigration"
    :vartype maintenance_type: str or ~azure.mgmt.oracledatabase.models.DbNodeMaintenanceType
    :ivar memory_size_in_gbs: The allocated memory in GBs on the Db node.
    :vartype memory_size_in_gbs: int
    :ivar software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for
     the DB system. This attribute applies only for virtual machine DB systems.
    :vartype software_storage_size_in_gb: int
    :ivar time_created: The date and time that the database node was created. Required.
    :vartype time_created: ~datetime.datetime
    :ivar time_maintenance_window_end: End date and time of maintenance window.
    :vartype time_maintenance_window_end: ~datetime.datetime
    :ivar time_maintenance_window_start: Start date and time of maintenance window.
    :vartype time_maintenance_window_start: ~datetime.datetime
    :ivar vnic2_id: The OCID of the second VNIC.
    :vartype vnic2_id: str
    :ivar vnic_id: The OCID of the VNIC. Required.
    :vartype vnic_id: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    ocid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """DbNode OCID. Required."""
    additional_details: Optional[str] = rest_field(
        name="additionalDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information about the planned maintenance."""
    backup_ip_id: Optional[str] = rest_field(
        name="backupIpId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OCID of the backup IP address associated with the database node."""
    backup_vnic2_id: Optional[str] = rest_field(
        name="backupVnic2Id", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OCID of the second backup VNIC."""
    backup_vnic_id: Optional[str] = rest_field(
        name="backupVnicId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OCID of the backup VNIC."""
    cpu_core_count: Optional[int] = rest_field(
        name="cpuCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of CPU cores enabled on the Db node."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(
        name="dbNodeStorageSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocated local node storage in GBs on the Db node."""
    db_server_id: Optional[str] = rest_field(
        name="dbServerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The OCID of the Exacc Db server associated with the database node."""
    db_system_id: str = rest_field(name="dbSystemId", visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the DB system. Required."""
    fault_domain: Optional[str] = rest_field(
        name="faultDomain", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the Fault Domain the instance is contained in."""
    host_ip_id: Optional[str] = rest_field(name="hostIpId", visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the host IP address associated with the database node."""
    hostname: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The host name for the database node."""
    lifecycle_state: Union[str, "_models.DbNodeProvisioningState"] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the database node. Required. Known values are: \"Provisioning\",
     \"Available\", \"Updating\", \"Stopping\", \"Stopped\", \"Starting\", \"Terminating\",
     \"Terminated\", and \"Failed\"."""
    lifecycle_details: Optional[str] = rest_field(
        name="lifecycleDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Lifecycle details of Db Node."""
    maintenance_type: Optional[Union[str, "_models.DbNodeMaintenanceType"]] = rest_field(
        name="maintenanceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of database node maintenance. \"VmdbRebootMigration\""""
    memory_size_in_gbs: Optional[int] = rest_field(
        name="memorySizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocated memory in GBs on the Db node."""
    software_storage_size_in_gb: Optional[int] = rest_field(
        name="softwareStorageSizeInGb", visibility=["read", "create", "update", "delete", "query"]
    )
    """The size (in GB) of the block storage volume allocation for the DB system. This attribute
     applies only for virtual machine DB systems."""
    time_created: datetime.datetime = rest_field(
        name="timeCreated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time that the database node was created. Required."""
    time_maintenance_window_end: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceWindowEnd", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End date and time of maintenance window."""
    time_maintenance_window_start: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceWindowStart", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start date and time of maintenance window."""
    vnic2_id: Optional[str] = rest_field(name="vnic2Id", visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the second VNIC."""
    vnic_id: str = rest_field(name="vnicId", visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the VNIC. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        ocid: str,
        db_system_id: str,
        lifecycle_state: Union[str, "_models.DbNodeProvisioningState"],
        time_created: datetime.datetime,
        vnic_id: str,
        additional_details: Optional[str] = None,
        backup_ip_id: Optional[str] = None,
        backup_vnic2_id: Optional[str] = None,
        backup_vnic_id: Optional[str] = None,
        cpu_core_count: Optional[int] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        db_server_id: Optional[str] = None,
        fault_domain: Optional[str] = None,
        host_ip_id: Optional[str] = None,
        hostname: Optional[str] = None,
        lifecycle_details: Optional[str] = None,
        maintenance_type: Optional[Union[str, "_models.DbNodeMaintenanceType"]] = None,
        memory_size_in_gbs: Optional[int] = None,
        software_storage_size_in_gb: Optional[int] = None,
        time_maintenance_window_end: Optional[datetime.datetime] = None,
        time_maintenance_window_start: Optional[datetime.datetime] = None,
        vnic2_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbServer(ProxyResource):
    """DbServer resource model.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbServerProperties
    """

    properties: Optional["_models.DbServerProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DbServerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbServerPatchingDetails(_Model):
    """DbServer Patching Properties.

    :ivar estimated_patch_duration: Estimated Patch Duration.
    :vartype estimated_patch_duration: int
    :ivar patching_status: Patching Status. Known values are: "Scheduled", "MaintenanceInProgress",
     "Failed", and "Complete".
    :vartype patching_status: str or ~azure.mgmt.oracledatabase.models.DbServerPatchingStatus
    :ivar time_patching_ended: Time Patching Ended.
    :vartype time_patching_ended: ~datetime.datetime
    :ivar time_patching_started: Time Patching Started.
    :vartype time_patching_started: ~datetime.datetime
    """

    estimated_patch_duration: Optional[int] = rest_field(name="estimatedPatchDuration", visibility=["read"])
    """Estimated Patch Duration."""
    patching_status: Optional[Union[str, "_models.DbServerPatchingStatus"]] = rest_field(
        name="patchingStatus", visibility=["read"]
    )
    """Patching Status. Known values are: \"Scheduled\", \"MaintenanceInProgress\", \"Failed\", and
     \"Complete\"."""
    time_patching_ended: Optional[datetime.datetime] = rest_field(
        name="timePatchingEnded", visibility=["read"], format="rfc3339"
    )
    """Time Patching Ended."""
    time_patching_started: Optional[datetime.datetime] = rest_field(
        name="timePatchingStarted", visibility=["read"], format="rfc3339"
    )
    """Time Patching Started."""


class DbServerProperties(_Model):
    """DbServer resource properties.

    :ivar ocid: Db server name.
    :vartype ocid: str
    :ivar display_name: The name for the Db Server.
    :vartype display_name: str
    :ivar compartment_id: The OCID of the compartment.
    :vartype compartment_id: str
    :ivar exadata_infrastructure_id: The OCID of the Exadata infrastructure.
    :vartype exadata_infrastructure_id: str
    :ivar cpu_core_count: The number of CPU cores enabled on the Db server.
    :vartype cpu_core_count: int
    :ivar db_server_patching_details: dbServerPatching details of the Db server.
    :vartype db_server_patching_details: ~azure.mgmt.oracledatabase.models.DbServerPatchingDetails
    :ivar max_memory_in_gbs: The total memory available in GBs.
    :vartype max_memory_in_gbs: int
    :ivar db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db server.
    :vartype db_node_storage_size_in_gbs: int
    :ivar vm_cluster_ids: The OCID of the VM Clusters associated with the Db server.
    :vartype vm_cluster_ids: list[str]
    :ivar db_node_ids: The OCID of the Db nodes associated with the Db server.
    :vartype db_node_ids: list[str]
    :ivar lifecycle_details: Lifecycle details of dbServer.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: DbServer provisioning state. Known values are: "Creating", "Available",
     "Unavailable", "Deleting", "Deleted", and "MaintenanceInProgress".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.DbServerProvisioningState
    :ivar max_cpu_count: The total number of CPU cores available.
    :vartype max_cpu_count: int
    :ivar autonomous_vm_cluster_ids: The list of OCIDs of the Autonomous VM Clusters associated
     with the Db server.
    :vartype autonomous_vm_cluster_ids: list[str]
    :ivar autonomous_virtual_machine_ids: The list of OCIDs of the Autonomous Virtual Machines
     associated with the Db server.
    :vartype autonomous_virtual_machine_ids: list[str]
    :ivar max_db_node_storage_in_gbs: The total max dbNode storage in GBs.
    :vartype max_db_node_storage_in_gbs: int
    :ivar memory_size_in_gbs: The total memory size in GBs.
    :vartype memory_size_in_gbs: int
    :ivar shape: The shape of the Db server. The shape determines the amount of CPU, storage, and
     memory resources available.
    :vartype shape: str
    :ivar time_created: The date and time that the Db Server was created.
    :vartype time_created: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    :ivar compute_model: The compute model of the Exadata Infrastructure. Known values are: "ECPU"
     and "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    """

    ocid: Optional[str] = rest_field(visibility=["read"])
    """Db server name."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """The name for the Db Server."""
    compartment_id: Optional[str] = rest_field(name="compartmentId", visibility=["read"])
    """The OCID of the compartment."""
    exadata_infrastructure_id: Optional[str] = rest_field(name="exadataInfrastructureId", visibility=["read"])
    """The OCID of the Exadata infrastructure."""
    cpu_core_count: Optional[int] = rest_field(name="cpuCoreCount", visibility=["read"])
    """The number of CPU cores enabled on the Db server."""
    db_server_patching_details: Optional["_models.DbServerPatchingDetails"] = rest_field(
        name="dbServerPatchingDetails", visibility=["read"]
    )
    """dbServerPatching details of the Db server."""
    max_memory_in_gbs: Optional[int] = rest_field(name="maxMemoryInGbs", visibility=["read"])
    """The total memory available in GBs."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(name="dbNodeStorageSizeInGbs", visibility=["read"])
    """The allocated local node storage in GBs on the Db server."""
    vm_cluster_ids: Optional[List[str]] = rest_field(name="vmClusterIds", visibility=["read"])
    """The OCID of the VM Clusters associated with the Db server."""
    db_node_ids: Optional[List[str]] = rest_field(name="dbNodeIds", visibility=["read"])
    """The OCID of the Db nodes associated with the Db server."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Lifecycle details of dbServer."""
    lifecycle_state: Optional[Union[str, "_models.DbServerProvisioningState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """DbServer provisioning state. Known values are: \"Creating\", \"Available\", \"Unavailable\",
     \"Deleting\", \"Deleted\", and \"MaintenanceInProgress\"."""
    max_cpu_count: Optional[int] = rest_field(name="maxCpuCount", visibility=["read"])
    """The total number of CPU cores available."""
    autonomous_vm_cluster_ids: Optional[List[str]] = rest_field(name="autonomousVmClusterIds", visibility=["read"])
    """The list of OCIDs of the Autonomous VM Clusters associated with the Db server."""
    autonomous_virtual_machine_ids: Optional[List[str]] = rest_field(
        name="autonomousVirtualMachineIds", visibility=["read"]
    )
    """The list of OCIDs of the Autonomous Virtual Machines associated with the Db server."""
    max_db_node_storage_in_gbs: Optional[int] = rest_field(name="maxDbNodeStorageInGbs", visibility=["read"])
    """The total max dbNode storage in GBs."""
    memory_size_in_gbs: Optional[int] = rest_field(name="memorySizeInGbs", visibility=["read"])
    """The total memory size in GBs."""
    shape: Optional[str] = rest_field(visibility=["read"])
    """The shape of the Db server. The shape determines the amount of CPU, storage, and memory
     resources available."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """The date and time that the Db Server was created."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    compute_model: Optional[Union[str, "_models.ComputeModel"]] = rest_field(name="computeModel", visibility=["read"])
    """The compute model of the Exadata Infrastructure. Known values are: \"ECPU\" and \"OCPU\"."""


class DbSystemShape(ProxyResource):
    """DbSystemShape resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DbSystemShapeProperties
    """

    properties: Optional["_models.DbSystemShapeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DbSystemShapeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DbSystemShapeProperties(_Model):
    """DbSystemShape resource model.

    :ivar shape_family: The family of the shape used for the DB system.
    :vartype shape_family: str
    :ivar shape_name: The shape used for the DB system. Required.
    :vartype shape_name: str
    :ivar available_core_count: The maximum number of CPU cores that can be enabled on the DB
     system for this shape. Required.
    :vartype available_core_count: int
    :ivar minimum_core_count: The minimum number of CPU cores that can be enabled on the DB system
     for this shape.
    :vartype minimum_core_count: int
    :ivar runtime_minimum_core_count: The runtime minimum number of CPU cores that can be enabled
     on the DB system for this shape.
    :vartype runtime_minimum_core_count: int
    :ivar core_count_increment: The discrete number by which the CPU core count for this shape can
     be increased or decreased.
    :vartype core_count_increment: int
    :ivar min_storage_count: The minimum number of Exadata storage servers available for the
     Exadata infrastructure.
    :vartype min_storage_count: int
    :ivar max_storage_count: The maximum number of Exadata storage servers available for the
     Exadata infrastructure.
    :vartype max_storage_count: int
    :ivar available_data_storage_per_server_in_tbs: The maximum data storage available per storage
     server for this shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_data_storage_per_server_in_tbs: float
    :ivar available_memory_per_node_in_gbs: The maximum memory available per database node for this
     shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_memory_per_node_in_gbs: int
    :ivar available_db_node_per_node_in_gbs: The maximum Db Node storage available per database
     node for this shape. Only applicable to ExaCC Elastic shapes.
    :vartype available_db_node_per_node_in_gbs: int
    :ivar min_core_count_per_node: The minimum number of CPU cores that can be enabled per node for
     this shape.
    :vartype min_core_count_per_node: int
    :ivar available_memory_in_gbs: The maximum memory that can be enabled for this shape.
    :vartype available_memory_in_gbs: int
    :ivar min_memory_per_node_in_gbs: The minimum memory that need be allocated per node for this
     shape.
    :vartype min_memory_per_node_in_gbs: int
    :ivar available_db_node_storage_in_gbs: The maximum Db Node storage that can be enabled for
     this shape.
    :vartype available_db_node_storage_in_gbs: int
    :ivar min_db_node_storage_per_node_in_gbs: The minimum Db Node storage that need be allocated
     per node for this shape.
    :vartype min_db_node_storage_per_node_in_gbs: int
    :ivar available_data_storage_in_tbs: The maximum DATA storage that can be enabled for this
     shape.
    :vartype available_data_storage_in_tbs: int
    :ivar min_data_storage_in_tbs: The minimum data storage that need be allocated for this shape.
    :vartype min_data_storage_in_tbs: int
    :ivar minimum_node_count: The minimum number of database nodes available for this shape.
    :vartype minimum_node_count: int
    :ivar maximum_node_count: The maximum number of database nodes available for this shape.
    :vartype maximum_node_count: int
    :ivar available_core_count_per_node: The maximum number of CPU cores per database node that can
     be enabled for this shape. Only applicable to the flex Exadata shape and ExaCC Elastic shapes.
    :vartype available_core_count_per_node: int
    :ivar compute_model: The compute model of the Exadata Infrastructure. Known values are: "ECPU"
     and "OCPU".
    :vartype compute_model: str or ~azure.mgmt.oracledatabase.models.ComputeModel
    :ivar are_server_types_supported: Indicates if the shape supports database and storage server
     types.
    :vartype are_server_types_supported: bool
    :ivar display_name: The display name of the shape used for the DB system.
    :vartype display_name: str
    """

    shape_family: Optional[str] = rest_field(
        name="shapeFamily", visibility=["read", "create", "update", "delete", "query"]
    )
    """The family of the shape used for the DB system."""
    shape_name: str = rest_field(name="shapeName", visibility=["read", "create", "update", "delete", "query"])
    """The shape used for the DB system. Required."""
    available_core_count: int = rest_field(
        name="availableCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of CPU cores that can be enabled on the DB system for this shape. Required."""
    minimum_core_count: Optional[int] = rest_field(
        name="minimumCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum number of CPU cores that can be enabled on the DB system for this shape."""
    runtime_minimum_core_count: Optional[int] = rest_field(
        name="runtimeMinimumCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The runtime minimum number of CPU cores that can be enabled on the DB system for this shape."""
    core_count_increment: Optional[int] = rest_field(
        name="coreCountIncrement", visibility=["read", "create", "update", "delete", "query"]
    )
    """The discrete number by which the CPU core count for this shape can be increased or decreased."""
    min_storage_count: Optional[int] = rest_field(
        name="minStorageCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum number of Exadata storage servers available for the Exadata infrastructure."""
    max_storage_count: Optional[int] = rest_field(
        name="maxStorageCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of Exadata storage servers available for the Exadata infrastructure."""
    available_data_storage_per_server_in_tbs: Optional[float] = rest_field(
        name="availableDataStoragePerServerInTbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum data storage available per storage server for this shape. Only applicable to ExaCC
     Elastic shapes."""
    available_memory_per_node_in_gbs: Optional[int] = rest_field(
        name="availableMemoryPerNodeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum memory available per database node for this shape. Only applicable to ExaCC Elastic
     shapes."""
    available_db_node_per_node_in_gbs: Optional[int] = rest_field(
        name="availableDbNodePerNodeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum Db Node storage available per database node for this shape. Only applicable to
     ExaCC Elastic shapes."""
    min_core_count_per_node: Optional[int] = rest_field(
        name="minCoreCountPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum number of CPU cores that can be enabled per node for this shape."""
    available_memory_in_gbs: Optional[int] = rest_field(
        name="availableMemoryInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum memory that can be enabled for this shape."""
    min_memory_per_node_in_gbs: Optional[int] = rest_field(
        name="minMemoryPerNodeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum memory that need be allocated per node for this shape."""
    available_db_node_storage_in_gbs: Optional[int] = rest_field(
        name="availableDbNodeStorageInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum Db Node storage that can be enabled for this shape."""
    min_db_node_storage_per_node_in_gbs: Optional[int] = rest_field(
        name="minDbNodeStoragePerNodeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum Db Node storage that need be allocated per node for this shape."""
    available_data_storage_in_tbs: Optional[int] = rest_field(
        name="availableDataStorageInTbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum DATA storage that can be enabled for this shape."""
    min_data_storage_in_tbs: Optional[int] = rest_field(
        name="minDataStorageInTbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum data storage that need be allocated for this shape."""
    minimum_node_count: Optional[int] = rest_field(
        name="minimumNodeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum number of database nodes available for this shape."""
    maximum_node_count: Optional[int] = rest_field(
        name="maximumNodeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of database nodes available for this shape."""
    available_core_count_per_node: Optional[int] = rest_field(
        name="availableCoreCountPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of CPU cores per database node that can be enabled for this shape. Only
     applicable to the flex Exadata shape and ExaCC Elastic shapes."""
    compute_model: Optional[Union[str, "_models.ComputeModel"]] = rest_field(
        name="computeModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The compute model of the Exadata Infrastructure. Known values are: \"ECPU\" and \"OCPU\"."""
    are_server_types_supported: Optional[bool] = rest_field(
        name="areServerTypesSupported", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the shape supports database and storage server types."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name of the shape used for the DB system."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        shape_name: str,
        available_core_count: int,
        shape_family: Optional[str] = None,
        minimum_core_count: Optional[int] = None,
        runtime_minimum_core_count: Optional[int] = None,
        core_count_increment: Optional[int] = None,
        min_storage_count: Optional[int] = None,
        max_storage_count: Optional[int] = None,
        available_data_storage_per_server_in_tbs: Optional[float] = None,
        available_memory_per_node_in_gbs: Optional[int] = None,
        available_db_node_per_node_in_gbs: Optional[int] = None,
        min_core_count_per_node: Optional[int] = None,
        available_memory_in_gbs: Optional[int] = None,
        min_memory_per_node_in_gbs: Optional[int] = None,
        available_db_node_storage_in_gbs: Optional[int] = None,
        min_db_node_storage_per_node_in_gbs: Optional[int] = None,
        available_data_storage_in_tbs: Optional[int] = None,
        min_data_storage_in_tbs: Optional[int] = None,
        minimum_node_count: Optional[int] = None,
        maximum_node_count: Optional[int] = None,
        available_core_count_per_node: Optional[int] = None,
        compute_model: Optional[Union[str, "_models.ComputeModel"]] = None,
        are_server_types_supported: Optional[bool] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DefinedFileSystemConfiguration(_Model):
    """Predefined configurations for the file system.

    :ivar is_backup_partition: Checks if the data can be backed up.
    :vartype is_backup_partition: bool
    :ivar is_resizable: Checks if the mount path is resizable.
    :vartype is_resizable: bool
    :ivar min_size_gb: Minimum size of mount path in Gb.
    :vartype min_size_gb: int
    :ivar mount_point: Mount path for the file system.
    :vartype mount_point: str
    """

    is_backup_partition: Optional[bool] = rest_field(
        name="isBackupPartition", visibility=["read", "create", "update", "delete", "query"]
    )
    """Checks if the data can be backed up."""
    is_resizable: Optional[bool] = rest_field(
        name="isResizable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Checks if the mount path is resizable."""
    min_size_gb: Optional[int] = rest_field(
        name="minSizeGb", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum size of mount path in Gb."""
    mount_point: Optional[str] = rest_field(
        name="mountPoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount path for the file system."""

    @overload
    def __init__(
        self,
        *,
        is_backup_partition: Optional[bool] = None,
        is_resizable: Optional[bool] = None,
        min_size_gb: Optional[int] = None,
        mount_point: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DisasterRecoveryConfigurationDetails(_Model):
    """Configurations of a Disaster Recovery Details.

    :ivar disaster_recovery_type: Indicates the disaster recovery (DR) type of the Autonomous
     Database Serverless instance. Autonomous Data Guard (ADG) DR type provides business critical DR
     with a faster recovery time objective (RTO) during failover or switchover. Backup-based DR type
     provides lower cost DR with a slower RTO during failover or switchover. Known values are: "Adg"
     and "BackupBased".
    :vartype disaster_recovery_type: str or ~azure.mgmt.oracledatabase.models.DisasterRecoveryType
    :ivar time_snapshot_standby_enabled_till: Time and date stored as an RFC 3339 formatted
     timestamp string. For example, 2022-01-01T12:00:00.000Z would set a limit for the snapshot
     standby to be converted back to a cross-region standby database.
    :vartype time_snapshot_standby_enabled_till: ~datetime.datetime
    :ivar is_snapshot_standby: Indicates if user wants to convert to a snapshot standby. For
     example, true would set a standby database to snapshot standby database. False would set a
     snapshot standby database back to regular standby database.
    :vartype is_snapshot_standby: bool
    :ivar is_replicate_automatic_backups: If true, 7 days worth of backups are replicated across
     regions for Cross-Region ADB or Backup-Based DR between Primary and Standby. If false, the
     backups taken on the Primary are not replicated to the Standby database.
    :vartype is_replicate_automatic_backups: bool
    """

    disaster_recovery_type: Optional[Union[str, "_models.DisasterRecoveryType"]] = rest_field(
        name="disasterRecoveryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the disaster recovery (DR) type of the Autonomous Database Serverless instance.
     Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time
     objective (RTO) during failover or switchover. Backup-based DR type provides lower cost DR with
     a slower RTO during failover or switchover. Known values are: \"Adg\" and \"BackupBased\"."""
    time_snapshot_standby_enabled_till: Optional[datetime.datetime] = rest_field(
        name="timeSnapshotStandbyEnabledTill",
        visibility=["read", "create", "update", "delete", "query"],
        format="rfc3339",
    )
    """Time and date stored as an RFC 3339 formatted timestamp string. For example,
     2022-01-01T12:00:00.000Z would set a limit for the snapshot standby to be converted back to a
     cross-region standby database."""
    is_snapshot_standby: Optional[bool] = rest_field(
        name="isSnapshotStandby", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if user wants to convert to a snapshot standby. For example, true would set a standby
     database to snapshot standby database. False would set a snapshot standby database back to
     regular standby database."""
    is_replicate_automatic_backups: Optional[bool] = rest_field(
        name="isReplicateAutomaticBackups", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, 7 days worth of backups are replicated across regions for Cross-Region ADB or
     Backup-Based DR between Primary and Standby. If false, the backups taken on the Primary are not
     replicated to the Standby database."""

    @overload
    def __init__(
        self,
        *,
        disaster_recovery_type: Optional[Union[str, "_models.DisasterRecoveryType"]] = None,
        time_snapshot_standby_enabled_till: Optional[datetime.datetime] = None,
        is_snapshot_standby: Optional[bool] = None,
        is_replicate_automatic_backups: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsPrivateView(ProxyResource):
    """DnsPrivateView resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateViewProperties
    """

    properties: Optional["_models.DnsPrivateViewProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DnsPrivateViewProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsPrivateViewProperties(_Model):
    """Views resource model.

    :ivar ocid: The OCID of the view. Required.
    :vartype ocid: str
    :ivar display_name: The display name of the view resource. Required.
    :vartype display_name: str
    :ivar is_protected: A Boolean flag indicating whether or not parts of the resource are unable
     to be explicitly managed. Required.
    :vartype is_protected: bool
    :ivar lifecycle_state: Views lifecycleState. Required. Known values are: "Active", "Deleted",
     "Deleting", and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.DnsPrivateViewsLifecycleState
    :ivar self_property: The canonical absolute URL of the resource. Required.
    :vartype self_property: str
    :ivar time_created: views timeCreated. Required.
    :vartype time_created: ~datetime.datetime
    :ivar time_updated: views timeCreated. Required.
    :vartype time_updated: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    ocid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the view. Required."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """The display name of the view resource. Required."""
    is_protected: bool = rest_field(name="isProtected", visibility=["read", "create", "update", "delete", "query"])
    """A Boolean flag indicating whether or not parts of the resource are unable to be explicitly
     managed. Required."""
    lifecycle_state: Union[str, "_models.DnsPrivateViewsLifecycleState"] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Views lifecycleState. Required. Known values are: \"Active\", \"Deleted\", \"Deleting\", and
     \"Updating\"."""
    self_property: str = rest_field(name="self", visibility=["read", "create", "update", "delete", "query"])
    """The canonical absolute URL of the resource. Required."""
    time_created: datetime.datetime = rest_field(
        name="timeCreated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """views timeCreated. Required."""
    time_updated: datetime.datetime = rest_field(
        name="timeUpdated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """views timeCreated. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        ocid: str,
        display_name: str,
        is_protected: bool,
        lifecycle_state: Union[str, "_models.DnsPrivateViewsLifecycleState"],
        self_property: str,
        time_created: datetime.datetime,
        time_updated: datetime.datetime,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsPrivateZone(ProxyResource):
    """DnsPrivateZone resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.DnsPrivateZoneProperties
    """

    properties: Optional["_models.DnsPrivateZoneProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DnsPrivateZoneProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DnsPrivateZoneProperties(_Model):
    """Zones resource model.

    :ivar ocid: The OCID of the Zone. Required.
    :vartype ocid: str
    :ivar is_protected: A Boolean flag indicating whether or not parts of the resource are unable
     to be explicitly managed. Required.
    :vartype is_protected: bool
    :ivar lifecycle_state: Zones lifecycleState. Required. Known values are: "Active", "Creating",
     "Deleted", "Deleting", and "Updating".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.DnsPrivateZonesLifecycleState
    :ivar self_property: The canonical absolute URL of the resource. Required.
    :vartype self_property: str
    :ivar serial: The current serial of the zone. As seen in the zone's SOA record. Required.
    :vartype serial: int
    :ivar version: Version is the never-repeating, totally-orderable, version of the zone, from
     which the serial field of the zone's SOA record is derived. Required.
    :vartype version: str
    :ivar view_id: The OCID of the private view containing the zone. This value will be null for
     zones in the global DNS, which are publicly resolvable and not part of a private view.
    :vartype view_id: str
    :ivar zone_type: The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only
     supported for GLOBAL zones. Required. Known values are: "Primary" and "Secondary".
    :vartype zone_type: str or ~azure.mgmt.oracledatabase.models.ZoneType
    :ivar time_created: Zones timeCreated. Required.
    :vartype time_created: ~datetime.datetime
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.oracledatabase.models.ResourceProvisioningState
    """

    ocid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the Zone. Required."""
    is_protected: bool = rest_field(name="isProtected", visibility=["read", "create", "update", "delete", "query"])
    """A Boolean flag indicating whether or not parts of the resource are unable to be explicitly
     managed. Required."""
    lifecycle_state: Union[str, "_models.DnsPrivateZonesLifecycleState"] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Zones lifecycleState. Required. Known values are: \"Active\", \"Creating\", \"Deleted\",
     \"Deleting\", and \"Updating\"."""
    self_property: str = rest_field(name="self", visibility=["read", "create", "update", "delete", "query"])
    """The canonical absolute URL of the resource. Required."""
    serial: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The current serial of the zone. As seen in the zone's SOA record. Required."""
    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version is the never-repeating, totally-orderable, version of the zone, from which the serial
     field of the zone's SOA record is derived. Required."""
    view_id: Optional[str] = rest_field(name="viewId", visibility=["read", "create", "update", "delete", "query"])
    """The OCID of the private view containing the zone. This value will be null for zones in the
     global DNS, which are publicly resolvable and not part of a private view."""
    zone_type: Union[str, "_models.ZoneType"] = rest_field(
        name="zoneType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only supported for
     GLOBAL zones. Required. Known values are: \"Primary\" and \"Secondary\"."""
    time_created: datetime.datetime = rest_field(
        name="timeCreated", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Zones timeCreated. Required."""
    provisioning_state: Optional[Union[str, "_models.ResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        ocid: str,
        is_protected: bool,
        lifecycle_state: Union[str, "_models.DnsPrivateZonesLifecycleState"],
        self_property: str,
        serial: int,
        version: str,
        zone_type: Union[str, "_models.ZoneType"],
        time_created: datetime.datetime,
        view_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.oracledatabase.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.oracledatabase.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.oracledatabase.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EstimatedPatchingTime(_Model):
    """The estimated total time required in minutes for all patching operations (database server,
    storage server, and network switch patching).

    :ivar estimated_db_server_patching_time: The estimated time required in minutes for database
     server patching.
    :vartype estimated_db_server_patching_time: int
    :ivar estimated_network_switches_patching_time: The estimated time required in minutes for
     network switch patching.
    :vartype estimated_network_switches_patching_time: int
    :ivar estimated_storage_server_patching_time: The estimated time required in minutes for
     storage server patching.
    :vartype estimated_storage_server_patching_time: int
    :ivar total_estimated_patching_time: The estimated total time required in minutes for all
     patching operations.
    :vartype total_estimated_patching_time: int
    """

    estimated_db_server_patching_time: Optional[int] = rest_field(
        name="estimatedDbServerPatchingTime", visibility=["read"]
    )
    """The estimated time required in minutes for database server patching."""
    estimated_network_switches_patching_time: Optional[int] = rest_field(
        name="estimatedNetworkSwitchesPatchingTime", visibility=["read"]
    )
    """The estimated time required in minutes for network switch patching."""
    estimated_storage_server_patching_time: Optional[int] = rest_field(
        name="estimatedStorageServerPatchingTime", visibility=["read"]
    )
    """The estimated time required in minutes for storage server patching."""
    total_estimated_patching_time: Optional[int] = rest_field(name="totalEstimatedPatchingTime", visibility=["read"])
    """The estimated total time required in minutes for all patching operations."""


class ExadataIormConfig(_Model):
    """ExadataIormConfig for cloud vm cluster.

    :ivar db_plans: An array of IORM settings for all the database in the Exadata DB system.
    :vartype db_plans: list[~azure.mgmt.oracledatabase.models.DbIormConfig]
    :ivar lifecycle_details: Additional information about the current lifecycleState.
    :vartype lifecycle_details: str
    :ivar lifecycle_state: The current state of IORM configuration for the Exadata DB system. Known
     values are: "BootStrapping", "Enabled", "Disabled", "Updating", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.IormLifecycleState
    :ivar objective: The current value for the IORM objective. The default is AUTO. Known values
     are: "LowLatency", "HighThroughput", "Balanced", "Auto", and "Basic".
    :vartype objective: str or ~azure.mgmt.oracledatabase.models.Objective
    """

    db_plans: Optional[List["_models.DbIormConfig"]] = rest_field(
        name="dbPlans", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of IORM settings for all the database in the Exadata DB system."""
    lifecycle_details: Optional[str] = rest_field(
        name="lifecycleDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information about the current lifecycleState."""
    lifecycle_state: Optional[Union[str, "_models.IormLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of IORM configuration for the Exadata DB system. Known values are:
     \"BootStrapping\", \"Enabled\", \"Disabled\", \"Updating\", and \"Failed\"."""
    objective: Optional[Union[str, "_models.Objective"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current value for the IORM objective. The default is AUTO. Known values are:
     \"LowLatency\", \"HighThroughput\", \"Balanced\", \"Auto\", and \"Basic\"."""

    @overload
    def __init__(
        self,
        *,
        db_plans: Optional[List["_models.DbIormConfig"]] = None,
        lifecycle_details: Optional[str] = None,
        lifecycle_state: Optional[Union[str, "_models.IormLifecycleState"]] = None,
        objective: Optional[Union[str, "_models.Objective"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExadbVmCluster(TrackedResource):
    """ExadbVmCluster resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.ExadbVmClusterProperties
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    """

    properties: Optional["_models.ExadbVmClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ExadbVmClusterProperties"] = None,
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExadbVmClusterProperties(_Model):
    """ExadbVmCluster resource model.

    :ivar ocid: ExadbVmCluster ocid.
    :vartype ocid: str
    :ivar cluster_name: The cluster name for Exadata VM cluster on Exascale Infrastructure. The
     cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores
     (_) are not permitted. The cluster name can be no longer than 11 characters and is not case
     sensitive.
    :vartype cluster_name: str
    :ivar backup_subnet_cidr: Client OCI backup subnet CIDR, default is 192.168.252.0/22.
    :vartype backup_subnet_cidr: str
    :ivar nsg_url: HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure
     Interface.
    :vartype nsg_url: str
    :ivar provisioning_state: Exadata VM cluster on Exascale Infrastructure provisioning state.
     Known values are: "Succeeded", "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: CloudVmCluster lifecycle state. Known values are: "Provisioning",
     "Available", "Updating", "Terminating", "Terminated", "MaintenanceInProgress", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.ExadbVmClusterLifecycleState
    :ivar vnet_id: VNET for network connectivity. Required.
    :vartype vnet_id: str
    :ivar subnet_id: Client subnet. Required.
    :vartype subnet_id: str
    :ivar data_collection_options: Indicates user preferences for the various diagnostic collection
     options for the VM cluster/Cloud VM cluster/VMBM DBCS.
    :vartype data_collection_options: ~azure.mgmt.oracledatabase.models.DataCollectionOptions
    :ivar display_name: Display Name. Required.
    :vartype display_name: str
    :ivar domain: A domain name used for the Exadata VM cluster on Exascale Infrastructure.
    :vartype domain: str
    :ivar enabled_ecpu_count: The number of ECPUs to enable for an Exadata VM cluster on Exascale
     Infrastructure. Required.
    :vartype enabled_ecpu_count: int
    :ivar exascale_db_storage_vault_id: The Azure Resource ID of the Exadata Database Storage
     Vault. Required.
    :vartype exascale_db_storage_vault_id: str
    :ivar grid_image_ocid: Grid Setup will be done using this Grid Image OCID. Can be obtained
     using giMinorVersions API.
    :vartype grid_image_ocid: str
    :ivar grid_image_type: The type of Grid Image. Known values are: "ReleaseUpdate" and
     "CustomImage".
    :vartype grid_image_type: str or ~azure.mgmt.oracledatabase.models.GridImageType
    :ivar gi_version: Oracle Grid Infrastructure (GI) software version.
    :vartype gi_version: str
    :ivar hostname: The hostname for the  Exadata VM cluster on Exascale Infrastructure. Required.
    :vartype hostname: str
    :ivar license_model: The Oracle license model that applies to the Exadata VM cluster on
     Exascale Infrastructure. The default is LICENSE_INCLUDED. Known values are: "LicenseIncluded"
     and "BringYourOwnLicense".
    :vartype license_model: str or ~azure.mgmt.oracledatabase.models.LicenseModel
    :ivar memory_size_in_gbs: The memory that you want to be allocated in GBs. Memory is calculated
     based on 11 GB per VM core reserved.
    :vartype memory_size_in_gbs: int
    :ivar node_count: The number of nodes in the Exadata VM cluster on Exascale Infrastructure.
     Required.
    :vartype node_count: int
    :ivar nsg_cidrs: CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision
     the VM Cluster will be added by default.
    :vartype nsg_cidrs: list[~azure.mgmt.oracledatabase.models.NsgCidr]
    :ivar zone_ocid: The OCID of the zone the Exadata VM cluster on Exascale Infrastructure is
     associated with.
    :vartype zone_ocid: str
    :ivar private_zone_ocid: The OCID of the zone the Exadata VM cluster on Exascale Infrastructure
     is associated with.
    :vartype private_zone_ocid: str
    :ivar scan_listener_port_tcp: The TCP Single Client Access Name (SCAN) port. The default port
     is 1521.
    :vartype scan_listener_port_tcp: int
    :ivar scan_listener_port_tcp_ssl: The TCPS Single Client Access Name (SCAN) port. The default
     port is 2484.
    :vartype scan_listener_port_tcp_ssl: int
    :ivar listener_port: The port number configured for the listener on the Exadata VM cluster on
     Exascale Infrastructure.
    :vartype listener_port: int
    :ivar shape: The shape of the Exadata VM cluster on Exascale Infrastructure resource. Required.
    :vartype shape: str
    :ivar ssh_public_keys: The public key portion of one or more key pairs used for SSH access to
     the Exadata VM cluster on Exascale Infrastructure. Required.
    :vartype ssh_public_keys: list[str]
    :ivar system_version: Operating system version of the image.
    :vartype system_version: str
    :ivar time_zone: The time zone of the Exadata VM cluster on Exascale Infrastructure. For
     details, see `Exadata Infrastructure Time Zones </Content/Database/References/timezones.htm>`_.
    :vartype time_zone: str
    :ivar total_ecpu_count: The number of Total ECPUs for an Exadata VM cluster on Exascale
     Infrastructure. Required.
    :vartype total_ecpu_count: int
    :ivar vm_file_system_storage: Filesystem storage details. Required.
    :vartype vm_file_system_storage: ~azure.mgmt.oracledatabase.models.ExadbVmClusterStorageDetails
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated
     with the Exadata VM cluster on Exascale Infrastructure.
    :vartype scan_dns_name: str
    :ivar scan_ip_ids: The Single Client Access Name (SCAN) IP addresses associated with the
     Exadata VM cluster on Exascale Infrastructure. SCAN IP addresses are typically used for load
     balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the
     appropriate nodes in the cluster. **Note:** For a single-node DB system, this list is empty.
    :vartype scan_ip_ids: list[str]
    :ivar scan_dns_record_id: The OCID of the DNS record for the SCAN IP addresses that are
     associated with the Exadata VM cluster on Exascale Infrastructure.
    :vartype scan_dns_record_id: str
    :ivar snapshot_file_system_storage: Snapshot filesystem storage details.
    :vartype snapshot_file_system_storage:
     ~azure.mgmt.oracledatabase.models.ExadbVmClusterStorageDetails
    :ivar total_file_system_storage: Total file system storage details.
    :vartype total_file_system_storage:
     ~azure.mgmt.oracledatabase.models.ExadbVmClusterStorageDetails
    :ivar vip_ids: The virtual IP (VIP) addresses associated with the Exadata VM cluster on
     Exascale Infrastructure. The Cluster Ready Services (CRS) creates and maintains one VIP address
     for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the
     VIP is reassigned to another active node in the cluster. **Note:** For a single-node DB system,
     this list is empty.
    :vartype vip_ids: list[str]
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    :ivar iorm_config_cache: iormConfigCache details for Exadata VM cluster on Exascale
     Infrastructure.
    :vartype iorm_config_cache: ~azure.mgmt.oracledatabase.models.ExadataIormConfig
    :ivar backup_subnet_ocid: Cluster backup subnet ocid.
    :vartype backup_subnet_ocid: str
    :ivar subnet_ocid: Cluster subnet ocid.
    :vartype subnet_ocid: str
    """

    ocid: Optional[str] = rest_field(visibility=["read"])
    """ExadbVmCluster ocid."""
    cluster_name: Optional[str] = rest_field(name="clusterName", visibility=["read", "create"])
    """The cluster name for Exadata VM cluster on Exascale Infrastructure. The cluster name must begin
     with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted.
     The cluster name can be no longer than 11 characters and is not case sensitive."""
    backup_subnet_cidr: Optional[str] = rest_field(name="backupSubnetCidr", visibility=["read", "create"])
    """Client OCI backup subnet CIDR, default is 192.168.252.0/22."""
    nsg_url: Optional[str] = rest_field(name="nsgUrl", visibility=["read"])
    """HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure Interface."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Exadata VM cluster on Exascale Infrastructure provisioning state. Known values are:
     \"Succeeded\", \"Failed\", \"Canceled\", and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.ExadbVmClusterLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """CloudVmCluster lifecycle state. Known values are: \"Provisioning\", \"Available\",
     \"Updating\", \"Terminating\", \"Terminated\", \"MaintenanceInProgress\", and \"Failed\"."""
    vnet_id: str = rest_field(name="vnetId", visibility=["read", "create"])
    """VNET for network connectivity. Required."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create"])
    """Client subnet. Required."""
    data_collection_options: Optional["_models.DataCollectionOptions"] = rest_field(
        name="dataCollectionOptions", visibility=["read", "create"]
    )
    """Indicates user preferences for the various diagnostic collection options for the VM
     cluster/Cloud VM cluster/VMBM DBCS."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create"])
    """Display Name. Required."""
    domain: Optional[str] = rest_field(visibility=["read", "create"])
    """A domain name used for the Exadata VM cluster on Exascale Infrastructure."""
    enabled_ecpu_count: int = rest_field(name="enabledEcpuCount", visibility=["read", "create"])
    """The number of ECPUs to enable for an Exadata VM cluster on Exascale Infrastructure. Required."""
    exascale_db_storage_vault_id: str = rest_field(name="exascaleDbStorageVaultId", visibility=["read", "create"])
    """The Azure Resource ID of the Exadata Database Storage Vault. Required."""
    grid_image_ocid: Optional[str] = rest_field(name="gridImageOcid", visibility=["read", "create"])
    """Grid Setup will be done using this Grid Image OCID. Can be obtained using giMinorVersions API."""
    grid_image_type: Optional[Union[str, "_models.GridImageType"]] = rest_field(
        name="gridImageType", visibility=["read"]
    )
    """The type of Grid Image. Known values are: \"ReleaseUpdate\" and \"CustomImage\"."""
    gi_version: Optional[str] = rest_field(name="giVersion", visibility=["read"])
    """Oracle Grid Infrastructure (GI) software version."""
    hostname: str = rest_field(visibility=["read", "create"])
    """The hostname for the  Exadata VM cluster on Exascale Infrastructure. Required."""
    license_model: Optional[Union[str, "_models.LicenseModel"]] = rest_field(
        name="licenseModel", visibility=["read", "create"]
    )
    """The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The
     default is LICENSE_INCLUDED. Known values are: \"LicenseIncluded\" and \"BringYourOwnLicense\"."""
    memory_size_in_gbs: Optional[int] = rest_field(name="memorySizeInGbs", visibility=["read"])
    """The memory that you want to be allocated in GBs. Memory is calculated based on 11 GB per VM
     core reserved."""
    node_count: int = rest_field(name="nodeCount", visibility=["read", "create", "update"])
    """The number of nodes in the Exadata VM cluster on Exascale Infrastructure. Required."""
    nsg_cidrs: Optional[List["_models.NsgCidr"]] = rest_field(name="nsgCidrs", visibility=["read", "create"])
    """CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision the VM Cluster
     will be added by default."""
    zone_ocid: Optional[str] = rest_field(name="zoneOcid", visibility=["read"])
    """The OCID of the zone the Exadata VM cluster on Exascale Infrastructure is associated with."""
    private_zone_ocid: Optional[str] = rest_field(name="privateZoneOcid", visibility=["read", "create"])
    """The OCID of the zone the Exadata VM cluster on Exascale Infrastructure is associated with."""
    scan_listener_port_tcp: Optional[int] = rest_field(name="scanListenerPortTcp", visibility=["read", "create"])
    """The TCP Single Client Access Name (SCAN) port. The default port is 1521."""
    scan_listener_port_tcp_ssl: Optional[int] = rest_field(name="scanListenerPortTcpSsl", visibility=["read", "create"])
    """The TCPS Single Client Access Name (SCAN) port. The default port is 2484."""
    listener_port: Optional[int] = rest_field(name="listenerPort", visibility=["read"])
    """The port number configured for the listener on the Exadata VM cluster on Exascale
     Infrastructure."""
    shape: str = rest_field(visibility=["read", "create"])
    """The shape of the Exadata VM cluster on Exascale Infrastructure resource. Required."""
    ssh_public_keys: List[str] = rest_field(name="sshPublicKeys", visibility=["read", "create"])
    """The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster
     on Exascale Infrastructure. Required."""
    system_version: Optional[str] = rest_field(name="systemVersion", visibility=["read", "create"])
    """Operating system version of the image."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create"])
    """The time zone of the Exadata VM cluster on Exascale Infrastructure. For details, see `Exadata
     Infrastructure Time Zones </Content/Database/References/timezones.htm>`_."""
    total_ecpu_count: int = rest_field(name="totalEcpuCount", visibility=["read", "create"])
    """The number of Total ECPUs for an Exadata VM cluster on Exascale Infrastructure. Required."""
    vm_file_system_storage: "_models.ExadbVmClusterStorageDetails" = rest_field(
        name="vmFileSystemStorage", visibility=["read", "create"]
    )
    """Filesystem storage details. Required."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    scan_dns_name: Optional[str] = rest_field(name="scanDnsName", visibility=["read"])
    """The FQDN of the DNS record for the SCAN IP addresses that are associated with the Exadata VM
     cluster on Exascale Infrastructure."""
    scan_ip_ids: Optional[List[str]] = rest_field(name="scanIpIds", visibility=["read"])
    """The Single Client Access Name (SCAN) IP addresses associated with the Exadata VM cluster on
     Exascale Infrastructure. SCAN IP addresses are typically used for load balancing and are not
     assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in
     the cluster. **Note:** For a single-node DB system, this list is empty."""
    scan_dns_record_id: Optional[str] = rest_field(name="scanDnsRecordId", visibility=["read"])
    """The OCID of the DNS record for the SCAN IP addresses that are associated with the Exadata VM
     cluster on Exascale Infrastructure."""
    snapshot_file_system_storage: Optional["_models.ExadbVmClusterStorageDetails"] = rest_field(
        name="snapshotFileSystemStorage", visibility=["read"]
    )
    """Snapshot filesystem storage details."""
    total_file_system_storage: Optional["_models.ExadbVmClusterStorageDetails"] = rest_field(
        name="totalFileSystemStorage", visibility=["read"]
    )
    """Total file system storage details."""
    vip_ids: Optional[List[str]] = rest_field(name="vipIds", visibility=["read"])
    """The virtual IP (VIP) addresses associated with the Exadata VM cluster on Exascale
     Infrastructure. The Cluster Ready Services (CRS) creates and maintains one VIP address for each
     node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is
     reassigned to another active node in the cluster. **Note:** For a single-node DB system, this
     list is empty."""
    oci_url: Optional[str] = rest_field(name="ociUrl", visibility=["read"])
    """HTTPS link to OCI resources exposed to Azure Customer via Azure Interface."""
    iorm_config_cache: Optional["_models.ExadataIormConfig"] = rest_field(name="iormConfigCache", visibility=["read"])
    """iormConfigCache details for Exadata VM cluster on Exascale Infrastructure."""
    backup_subnet_ocid: Optional[str] = rest_field(name="backupSubnetOcid", visibility=["read"])
    """Cluster backup subnet ocid."""
    subnet_ocid: Optional[str] = rest_field(name="subnetOcid", visibility=["read"])
    """Cluster subnet ocid."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        vnet_id: str,
        subnet_id: str,
        display_name: str,
        enabled_ecpu_count: int,
        exascale_db_storage_vault_id: str,
        hostname: str,
        node_count: int,
        shape: str,
        ssh_public_keys: List[str],
        total_ecpu_count: int,
        vm_file_system_storage: "_models.ExadbVmClusterStorageDetails",
        cluster_name: Optional[str] = None,
        backup_subnet_cidr: Optional[str] = None,
        data_collection_options: Optional["_models.DataCollectionOptions"] = None,
        domain: Optional[str] = None,
        grid_image_ocid: Optional[str] = None,
        license_model: Optional[Union[str, "_models.LicenseModel"]] = None,
        nsg_cidrs: Optional[List["_models.NsgCidr"]] = None,
        private_zone_ocid: Optional[str] = None,
        scan_listener_port_tcp: Optional[int] = None,
        scan_listener_port_tcp_ssl: Optional[int] = None,
        system_version: Optional[str] = None,
        time_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExadbVmClusterStorageDetails(_Model):
    """Storage Details on the Exadata VM cluster.

    :ivar total_size_in_gbs: Total Capacity. Required.
    :vartype total_size_in_gbs: int
    """

    total_size_in_gbs: int = rest_field(
        name="totalSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total Capacity. Required."""

    @overload
    def __init__(
        self,
        *,
        total_size_in_gbs: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExadbVmClusterUpdate(_Model):
    """The type used for update operations of the ExadbVmCluster.

    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.ExadbVmClusterUpdateProperties
    """

    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.ExadbVmClusterUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ExadbVmClusterUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExadbVmClusterUpdateProperties(_Model):
    """The updatable properties of the ExadbVmCluster.

    :ivar node_count: The number of nodes in the Exadata VM cluster on Exascale Infrastructure.
    :vartype node_count: int
    """

    node_count: Optional[int] = rest_field(name="nodeCount", visibility=["read", "create", "update"])
    """The number of nodes in the Exadata VM cluster on Exascale Infrastructure."""

    @overload
    def __init__(
        self,
        *,
        node_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbNode(ProxyResource):
    """The DbNode resource belonging to ExadbVmCluster.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.ExascaleDbNodeProperties
    """

    properties: Optional["_models.ExascaleDbNodeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ExascaleDbNodeProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbNodeProperties(_Model):
    """The properties of DbNodeResource.

    :ivar ocid: DbNode OCID. Required.
    :vartype ocid: str
    :ivar additional_details: Additional information about the planned maintenance.
    :vartype additional_details: str
    :ivar cpu_core_count: The number of CPU cores enabled on the Db node.
    :vartype cpu_core_count: int
    :ivar db_node_storage_size_in_gbs: The allocated local node storage in GBs on the Db node.
    :vartype db_node_storage_size_in_gbs: int
    :ivar fault_domain: The name of the Fault Domain the instance is contained in.
    :vartype fault_domain: str
    :ivar hostname: The host name for the database node.
    :vartype hostname: str
    :ivar lifecycle_state: The current state of the database node. Known values are:
     "Provisioning", "Available", "Updating", "Stopping", "Stopped", "Starting", "Terminating",
     "Terminated", and "Failed".
    :vartype lifecycle_state: str or ~azure.mgmt.oracledatabase.models.DbNodeProvisioningState
    :ivar maintenance_type: The type of database node maintenance.
    :vartype maintenance_type: str
    :ivar memory_size_in_gbs: The allocated memory in GBs on the Db node.
    :vartype memory_size_in_gbs: int
    :ivar software_storage_size_in_gb: The size (in GB) of the block storage volume allocation for
     the DB system. This attribute applies only for virtual machine DB systems.
    :vartype software_storage_size_in_gb: int
    :ivar time_maintenance_window_end: End date and time of maintenance window.
    :vartype time_maintenance_window_end: ~datetime.datetime
    :ivar time_maintenance_window_start: Start date and time of maintenance window.
    :vartype time_maintenance_window_start: ~datetime.datetime
    :ivar total_cpu_core_count: The total number of CPU cores reserved on the Db node.
    :vartype total_cpu_core_count: int
    """

    ocid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """DbNode OCID. Required."""
    additional_details: Optional[str] = rest_field(
        name="additionalDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional information about the planned maintenance."""
    cpu_core_count: Optional[int] = rest_field(
        name="cpuCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of CPU cores enabled on the Db node."""
    db_node_storage_size_in_gbs: Optional[int] = rest_field(
        name="dbNodeStorageSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocated local node storage in GBs on the Db node."""
    fault_domain: Optional[str] = rest_field(
        name="faultDomain", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the Fault Domain the instance is contained in."""
    hostname: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The host name for the database node."""
    lifecycle_state: Optional[Union[str, "_models.DbNodeProvisioningState"]] = rest_field(
        name="lifecycleState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the database node. Known values are: \"Provisioning\", \"Available\",
     \"Updating\", \"Stopping\", \"Stopped\", \"Starting\", \"Terminating\", \"Terminated\", and
     \"Failed\"."""
    maintenance_type: Optional[str] = rest_field(
        name="maintenanceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of database node maintenance."""
    memory_size_in_gbs: Optional[int] = rest_field(
        name="memorySizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """The allocated memory in GBs on the Db node."""
    software_storage_size_in_gb: Optional[int] = rest_field(
        name="softwareStorageSizeInGb", visibility=["read", "create", "update", "delete", "query"]
    )
    """The size (in GB) of the block storage volume allocation for the DB system. This attribute
     applies only for virtual machine DB systems."""
    time_maintenance_window_end: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceWindowEnd", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End date and time of maintenance window."""
    time_maintenance_window_start: Optional[datetime.datetime] = rest_field(
        name="timeMaintenanceWindowStart", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Start date and time of maintenance window."""
    total_cpu_core_count: Optional[int] = rest_field(
        name="totalCpuCoreCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of CPU cores reserved on the Db node."""

    @overload
    def __init__(
        self,
        *,
        ocid: str,
        additional_details: Optional[str] = None,
        cpu_core_count: Optional[int] = None,
        db_node_storage_size_in_gbs: Optional[int] = None,
        fault_domain: Optional[str] = None,
        hostname: Optional[str] = None,
        lifecycle_state: Optional[Union[str, "_models.DbNodeProvisioningState"]] = None,
        maintenance_type: Optional[str] = None,
        memory_size_in_gbs: Optional[int] = None,
        software_storage_size_in_gb: Optional[int] = None,
        time_maintenance_window_end: Optional[datetime.datetime] = None,
        time_maintenance_window_start: Optional[datetime.datetime] = None,
        total_cpu_core_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbStorageDetails(_Model):
    """Exadata Database Storage Details.

    :ivar available_size_in_gbs: Available Capacity.
    :vartype available_size_in_gbs: int
    :ivar total_size_in_gbs: Total Capacity.
    :vartype total_size_in_gbs: int
    """

    available_size_in_gbs: Optional[int] = rest_field(
        name="availableSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Available Capacity."""
    total_size_in_gbs: Optional[int] = rest_field(
        name="totalSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total Capacity."""

    @overload
    def __init__(
        self,
        *,
        available_size_in_gbs: Optional[int] = None,
        total_size_in_gbs: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbStorageInputDetails(_Model):
    """Create exadata Database Storage Details model.

    :ivar total_size_in_gbs: Total Capacity. Required.
    :vartype total_size_in_gbs: int
    """

    total_size_in_gbs: int = rest_field(
        name="totalSizeInGbs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total Capacity. Required."""

    @overload
    def __init__(
        self,
        *,
        total_size_in_gbs: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbStorageVault(TrackedResource):
    """ExascaleDbStorageVault resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.ExascaleDbStorageVaultProperties
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    """

    properties: Optional["_models.ExascaleDbStorageVaultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ExascaleDbStorageVaultProperties"] = None,
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbStorageVaultProperties(_Model):
    """ExascaleDbStorageVault resource model.

    :ivar additional_flash_cache_in_percent: The size of additional Flash Cache in percentage of
     High Capacity database storage.
    :vartype additional_flash_cache_in_percent: int
    :ivar description: Exadata Database Storage Vault description.
    :vartype description: str
    :ivar display_name: The user-friendly name for the Exadata Database Storage Vault. The name
     does not need to be unique. Required.
    :vartype display_name: str
    :ivar high_capacity_database_storage_input: Create exadata Database Storage Details. Required.
    :vartype high_capacity_database_storage_input:
     ~azure.mgmt.oracledatabase.models.ExascaleDbStorageInputDetails
    :ivar high_capacity_database_storage: Response exadata Database Storage Details.
    :vartype high_capacity_database_storage:
     ~azure.mgmt.oracledatabase.models.ExascaleDbStorageDetails
    :ivar time_zone: The time zone that you want to use for the Exadata Database Storage Vault.
    :vartype time_zone: str
    :ivar provisioning_state: Exadata Database Storage Vault provisioning state. Known values are:
     "Succeeded", "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: Exadata Database Storage Vault lifecycle state. Known values are:
     "Provisioning", "Available", "Updating", "Terminating", "Terminated", and "Failed".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.ExascaleDbStorageVaultLifecycleState
    :ivar lifecycle_details: Additional information about the current lifecycle state.
    :vartype lifecycle_details: str
    :ivar vm_cluster_count: The number of Exadata VM clusters used the Exadata Database Storage
     Vault.
    :vartype vm_cluster_count: int
    :ivar ocid: The OCID of the Exadata Database Storage Vault.
    :vartype ocid: str
    :ivar oci_url: HTTPS link to OCI resources exposed to Azure Customer via Azure Interface.
    :vartype oci_url: str
    """

    additional_flash_cache_in_percent: Optional[int] = rest_field(
        name="additionalFlashCacheInPercent", visibility=["read", "create"]
    )
    """The size of additional Flash Cache in percentage of High Capacity database storage."""
    description: Optional[str] = rest_field(visibility=["read", "create"])
    """Exadata Database Storage Vault description."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create"])
    """The user-friendly name for the Exadata Database Storage Vault. The name does not need to be
     unique. Required."""
    high_capacity_database_storage_input: "_models.ExascaleDbStorageInputDetails" = rest_field(
        name="highCapacityDatabaseStorageInput", visibility=["create"]
    )
    """Create exadata Database Storage Details. Required."""
    high_capacity_database_storage: Optional["_models.ExascaleDbStorageDetails"] = rest_field(
        name="highCapacityDatabaseStorage", visibility=["read"]
    )
    """Response exadata Database Storage Details."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create"])
    """The time zone that you want to use for the Exadata Database Storage Vault."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Exadata Database Storage Vault provisioning state. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.ExascaleDbStorageVaultLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """Exadata Database Storage Vault lifecycle state. Known values are: \"Provisioning\",
     \"Available\", \"Updating\", \"Terminating\", \"Terminated\", and \"Failed\"."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state."""
    vm_cluster_count: Optional[int] = rest_field(name="vmClusterCount", visibility=["read"])
    """The number of Exadata VM clusters used the Exadata Database Storage Vault."""
    ocid: Optional[str] = rest_field(visibility=["read"])
    """The OCID of the Exadata Database Storage Vault."""
    oci_url: Optional[str] = rest_field(name="ociUrl", visibility=["read"])
    """HTTPS link to OCI resources exposed to Azure Customer via Azure Interface."""

    @overload
    def __init__(
        self,
        *,
        display_name: str,
        high_capacity_database_storage_input: "_models.ExascaleDbStorageInputDetails",
        additional_flash_cache_in_percent: Optional[int] = None,
        description: Optional[str] = None,
        time_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExascaleDbStorageVaultTagsUpdate(_Model):
    """The type used for updating tags in ExascaleDbStorageVault resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSystemConfigurationDetails(_Model):
    """File configuration options.

    :ivar mount_point: Mount path.
    :vartype mount_point: str
    :ivar file_system_size_gb: Size of the VM.
    :vartype file_system_size_gb: int
    """

    mount_point: Optional[str] = rest_field(
        name="mountPoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount path."""
    file_system_size_gb: Optional[int] = rest_field(
        name="fileSystemSizeGb", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of the VM."""

    @overload
    def __init__(
        self,
        *,
        mount_point: Optional[str] = None,
        file_system_size_gb: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FlexComponent(ProxyResource):
    """FlexComponent Resource Definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.FlexComponentProperties
    """

    properties: Optional["_models.FlexComponentProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FlexComponentProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FlexComponentProperties(_Model):
    """FlexComponent resource model.

    :ivar minimum_core_count: The minimum number of CPU cores that can be enabled on the DB Server
     for this Flex Component.
    :vartype minimum_core_count: int
    :ivar available_core_count: The maximum number of CPU cores that can be enabled on the DB
     Server for this Flex Component.
    :vartype available_core_count: int
    :ivar available_db_storage_in_gbs: The maximum storage that can be enabled on the Storage
     Server for this Flex Component.
    :vartype available_db_storage_in_gbs: int
    :ivar runtime_minimum_core_count: The runtime minimum number of CPU cores that can be enabled
     for this Flex Component.
    :vartype runtime_minimum_core_count: int
    :ivar shape: The name of the DB system shape for this Flex Component.
    :vartype shape: str
    :ivar available_memory_in_gbs: The maximum memory size that can be enabled on the DB Server for
     this Flex Component.
    :vartype available_memory_in_gbs: int
    :ivar available_local_storage_in_gbs: The maximum local storage that can be enabled on the DB
     Server for this Flex Component.
    :vartype available_local_storage_in_gbs: int
    :ivar compute_model: The compute model of the DB Server for this Flex Component.
    :vartype compute_model: str
    :ivar hardware_type: The hardware type of the DB (Compute) or Storage (Cell) Server for this
     Flex Component. Known values are: "COMPUTE" and "CELL".
    :vartype hardware_type: str or ~azure.mgmt.oracledatabase.models.HardwareType
    :ivar description_summary: The description summary for this Flex Component.
    :vartype description_summary: str
    """

    minimum_core_count: Optional[int] = rest_field(name="minimumCoreCount", visibility=["read"])
    """The minimum number of CPU cores that can be enabled on the DB Server for this Flex Component."""
    available_core_count: Optional[int] = rest_field(name="availableCoreCount", visibility=["read"])
    """The maximum number of CPU cores that can be enabled on the DB Server for this Flex Component."""
    available_db_storage_in_gbs: Optional[int] = rest_field(name="availableDbStorageInGbs", visibility=["read"])
    """The maximum storage that can be enabled on the Storage Server for this Flex Component."""
    runtime_minimum_core_count: Optional[int] = rest_field(name="runtimeMinimumCoreCount", visibility=["read"])
    """The runtime minimum number of CPU cores that can be enabled for this Flex Component."""
    shape: Optional[str] = rest_field(visibility=["read"])
    """The name of the DB system shape for this Flex Component."""
    available_memory_in_gbs: Optional[int] = rest_field(name="availableMemoryInGbs", visibility=["read"])
    """The maximum memory size that can be enabled on the DB Server for this Flex Component."""
    available_local_storage_in_gbs: Optional[int] = rest_field(name="availableLocalStorageInGbs", visibility=["read"])
    """The maximum local storage that can be enabled on the DB Server for this Flex Component."""
    compute_model: Optional[str] = rest_field(name="computeModel", visibility=["read"])
    """The compute model of the DB Server for this Flex Component."""
    hardware_type: Optional[Union[str, "_models.HardwareType"]] = rest_field(name="hardwareType", visibility=["read"])
    """The hardware type of the DB (Compute) or Storage (Cell) Server for this Flex Component. Known
     values are: \"COMPUTE\" and \"CELL\"."""
    description_summary: Optional[str] = rest_field(name="descriptionSummary", visibility=["read"])
    """The description summary for this Flex Component."""


class GenerateAutonomousDatabaseWalletDetails(_Model):
    """Autonomous Database Generate Wallet resource model.

    :ivar generate_type: The type of wallet to generate. Known values are: "Single" and "All".
    :vartype generate_type: str or ~azure.mgmt.oracledatabase.models.GenerateType
    :ivar is_regional: True when requesting regional connection strings in PDB connect info,
     applicable to cross-region DG only.
    :vartype is_regional: bool
    :ivar password: The password to encrypt the keys inside the wallet. Required.
    :vartype password: str
    """

    generate_type: Optional[Union[str, "_models.GenerateType"]] = rest_field(
        name="generateType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of wallet to generate. Known values are: \"Single\" and \"All\"."""
    is_regional: Optional[bool] = rest_field(
        name="isRegional", visibility=["read", "create", "update", "delete", "query"]
    )
    """True when requesting regional connection strings in PDB connect info, applicable to
     cross-region DG only."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password to encrypt the keys inside the wallet. Required."""

    @overload
    def __init__(
        self,
        *,
        password: str,
        generate_type: Optional[Union[str, "_models.GenerateType"]] = None,
        is_regional: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GiMinorVersion(ProxyResource):
    """The Oracle Grid Infrastructure (GI) minor version resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.GiMinorVersionProperties
    """

    properties: Optional["_models.GiMinorVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GiMinorVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GiMinorVersionProperties(_Model):
    """The Oracle Grid Infrastructure (GI) minor version properties.

    :ivar version: A valid Oracle Grid Infrastructure (GI) software version. Required.
    :vartype version: str
    :ivar grid_image_ocid: Grid Infrastructure Image Id.
    :vartype grid_image_ocid: str
    """

    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A valid Oracle Grid Infrastructure (GI) software version. Required."""
    grid_image_ocid: Optional[str] = rest_field(
        name="gridImageOcid", visibility=["read", "create", "update", "delete", "query"]
    )
    """Grid Infrastructure Image Id."""

    @overload
    def __init__(
        self,
        *,
        version: str,
        grid_image_ocid: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GiVersion(ProxyResource):
    """GiVersion resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.GiVersionProperties
    """

    properties: Optional["_models.GiVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GiVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GiVersionProperties(_Model):
    """GiVersion resource model.

    :ivar version: A valid Oracle Grid Infrastructure (GI) software version. Required.
    :vartype version: str
    """

    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A valid Oracle Grid Infrastructure (GI) software version. Required."""

    @overload
    def __init__(
        self,
        *,
        version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LongTermBackUpScheduleDetails(_Model):
    """Details for the long-term backup schedule.

    :ivar repeat_cadence: The frequency of the long-term backup schedule. Known values are:
     "OneTime", "Weekly", "Monthly", and "Yearly".
    :vartype repeat_cadence: str or ~azure.mgmt.oracledatabase.models.RepeatCadenceType
    :ivar time_of_backup: The timestamp for the long-term backup schedule. For a MONTHLY cadence,
     months having fewer days than the provided date will have the backup taken on the last day of
     that month.
    :vartype time_of_backup: ~datetime.datetime
    :ivar retention_period_in_days: Retention period, in days, for backups.
    :vartype retention_period_in_days: int
    :ivar is_disabled: Indicates if the long-term backup schedule should be deleted. The default
     value is ``FALSE``.
    :vartype is_disabled: bool
    """

    repeat_cadence: Optional[Union[str, "_models.RepeatCadenceType"]] = rest_field(
        name="repeatCadence", visibility=["read", "create", "update", "delete", "query"]
    )
    """The frequency of the long-term backup schedule. Known values are: \"OneTime\", \"Weekly\",
     \"Monthly\", and \"Yearly\"."""
    time_of_backup: Optional[datetime.datetime] = rest_field(
        name="timeOfBackup", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp for the long-term backup schedule. For a MONTHLY cadence, months having fewer
     days than the provided date will have the backup taken on the last day of that month."""
    retention_period_in_days: Optional[int] = rest_field(
        name="retentionPeriodInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """Retention period, in days, for backups."""
    is_disabled: Optional[bool] = rest_field(
        name="isDisabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the long-term backup schedule should be deleted. The default value is ``FALSE``."""

    @overload
    def __init__(
        self,
        *,
        repeat_cadence: Optional[Union[str, "_models.RepeatCadenceType"]] = None,
        time_of_backup: Optional[datetime.datetime] = None,
        retention_period_in_days: Optional[int] = None,
        is_disabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceWindow(_Model):
    """MaintenanceWindow resource properties.

    :ivar preference: The maintenance window scheduling preference. Known values are:
     "NoPreference" and "CustomPreference".
    :vartype preference: str or ~azure.mgmt.oracledatabase.models.Preference
    :ivar months: Months during the year when maintenance should be performed.
    :vartype months: list[~azure.mgmt.oracledatabase.models.Month]
    :ivar weeks_of_month: Weeks during the month when maintenance should be performed. Weeks start
     on the 1st, 8th, 15th, and 22nd days of the month, and have a duration of 7 days. Weeks start
     and end based on calendar dates, not days of the week. For example, to allow maintenance during
     the 2nd week of the month (from the 8th day to the 14th day of the month), use the value 2.
     Maintenance cannot be scheduled for the fifth week of months that contain more than 28 days.
     Note that this parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to
     allow you to specify specific days of the week and hours that maintenance will be performed.
    :vartype weeks_of_month: list[int]
    :ivar days_of_week: Days during the week when maintenance should be performed.
    :vartype days_of_week: list[~azure.mgmt.oracledatabase.models.DayOfWeek]
    :ivar hours_of_day: The window of hours during the day when maintenance should be performed.
     The window is a 4 hour slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 -
     represents time slot 4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 -
     represents time slot 12:00 - 15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 -
     represents time slot 20:00 - 23:59 UTC.
    :vartype hours_of_day: list[int]
    :ivar lead_time_in_weeks: Lead time window allows user to set a lead time to prepare for a down
     time. The lead time is in weeks and valid value is between 1 to 4.
    :vartype lead_time_in_weeks: int
    :ivar patching_mode: Cloud Exadata infrastructure node patching method. Known values are:
     "Rolling" and "NonRolling".
    :vartype patching_mode: str or ~azure.mgmt.oracledatabase.models.PatchingMode
    :ivar custom_action_timeout_in_mins: Determines the amount of time the system will wait before
     the start of each database server patching operation. Custom action timeout is in minutes and
     valid value is between 15 to 120 (inclusive).
    :vartype custom_action_timeout_in_mins: int
    :ivar is_custom_action_timeout_enabled: If true, enables the configuration of a custom action
     timeout (waiting period) between database server patching operations.
    :vartype is_custom_action_timeout_enabled: bool
    :ivar is_monthly_patching_enabled: is Monthly Patching Enabled.
    :vartype is_monthly_patching_enabled: bool
    """

    preference: Optional[Union[str, "_models.Preference"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The maintenance window scheduling preference. Known values are: \"NoPreference\" and
     \"CustomPreference\"."""
    months: Optional[List["_models.Month"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Months during the year when maintenance should be performed."""
    weeks_of_month: Optional[List[int]] = rest_field(
        name="weeksOfMonth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Weeks during the month when maintenance should be performed. Weeks start on the 1st, 8th, 15th,
     and 22nd days of the month, and have a duration of 7 days. Weeks start and end based on
     calendar dates, not days of the week. For example, to allow maintenance during the 2nd week of
     the month (from the 8th day to the 14th day of the month), use the value 2. Maintenance cannot
     be scheduled for the fifth week of months that contain more than 28 days. Note that this
     parameter works in conjunction with the  daysOfWeek and hoursOfDay parameters to allow you to
     specify specific days of the week and hours that maintenance will be performed."""
    days_of_week: Optional[List["_models.DayOfWeek"]] = rest_field(
        name="daysOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Days during the week when maintenance should be performed."""
    hours_of_day: Optional[List[int]] = rest_field(
        name="hoursOfDay", visibility=["read", "create", "update", "delete", "query"]
    )
    """The window of hours during the day when maintenance should be performed. The window is a 4 hour
     slot. Valid values are - 0 - represents time slot 0:00 - 3:59 UTC - 4 - represents time slot
     4:00 - 7:59 UTC - 8 - represents time slot 8:00 - 11:59 UTC - 12 - represents time slot 12:00 -
     15:59 UTC - 16 - represents time slot 16:00 - 19:59 UTC - 20 - represents time slot 20:00 -
     23:59 UTC."""
    lead_time_in_weeks: Optional[int] = rest_field(
        name="leadTimeInWeeks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Lead time window allows user to set a lead time to prepare for a down time. The lead time is in
     weeks and valid value is between 1 to 4."""
    patching_mode: Optional[Union[str, "_models.PatchingMode"]] = rest_field(
        name="patchingMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cloud Exadata infrastructure node patching method. Known values are: \"Rolling\" and
     \"NonRolling\"."""
    custom_action_timeout_in_mins: Optional[int] = rest_field(
        name="customActionTimeoutInMins", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines the amount of time the system will wait before the start of each database server
     patching operation. Custom action timeout is in minutes and valid value is between 15 to 120
     (inclusive)."""
    is_custom_action_timeout_enabled: Optional[bool] = rest_field(
        name="isCustomActionTimeoutEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, enables the configuration of a custom action timeout (waiting period) between database
     server patching operations."""
    is_monthly_patching_enabled: Optional[bool] = rest_field(
        name="isMonthlyPatchingEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """is Monthly Patching Enabled."""

    @overload
    def __init__(
        self,
        *,
        preference: Optional[Union[str, "_models.Preference"]] = None,
        months: Optional[List["_models.Month"]] = None,
        weeks_of_month: Optional[List[int]] = None,
        days_of_week: Optional[List["_models.DayOfWeek"]] = None,
        hours_of_day: Optional[List[int]] = None,
        lead_time_in_weeks: Optional[int] = None,
        patching_mode: Optional[Union[str, "_models.PatchingMode"]] = None,
        custom_action_timeout_in_mins: Optional[int] = None,
        is_custom_action_timeout_enabled: Optional[bool] = None,
        is_monthly_patching_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Month(_Model):
    """Month resource properties.

    :ivar name: Name of the month of the year. Required. Known values are: "January", "February",
     "March", "April", "May", "June", "July", "August", "September", "October", "November", and
     "December".
    :vartype name: str or ~azure.mgmt.oracledatabase.models.MonthName
    """

    name: Union[str, "_models.MonthName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the month of the year. Required. Known values are: \"January\", \"February\",
     \"March\", \"April\", \"May\", \"June\", \"July\", \"August\", \"September\", \"October\",
     \"November\", and \"December\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.MonthName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NsgCidr(_Model):
    """A rule for allowing inbound (INGRESS) IP packets.

    :ivar source: Conceptually, this is the range of IP addresses that a packet coming into the
     instance can come from. Required.
    :vartype source: str
    :ivar destination_port_range: Destination port range to specify particular destination ports
     for TCP rules.
    :vartype destination_port_range: ~azure.mgmt.oracledatabase.models.PortRange
    """

    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Conceptually, this is the range of IP addresses that a packet coming into the instance can come
     from. Required."""
    destination_port_range: Optional["_models.PortRange"] = rest_field(
        name="destinationPortRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Destination port range to specify particular destination ports for TCP rules."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        destination_port_range: Optional["_models.PortRange"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.oracledatabase.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.oracledatabase.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.oracledatabase.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OracleSubscription(ProxyResource):
    """OracleSubscription resource definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionProperties
    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.oracledatabase.models.Plan
    """

    properties: Optional["_models.OracleSubscriptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    plan: Optional["_models.Plan"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the resource plan."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.OracleSubscriptionProperties"] = None,
        plan: Optional["_models.Plan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OracleSubscriptionProperties(_Model):
    """Oracle Subscription resource model.

    :ivar provisioning_state: OracleSubscriptionProvisioningState provisioning state. Known values
     are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.OracleSubscriptionProvisioningState
    :ivar saas_subscription_id: SAAS subscription ID generated by Marketplace.
    :vartype saas_subscription_id: str
    :ivar cloud_account_id: Cloud Account Id.
    :vartype cloud_account_id: str
    :ivar cloud_account_state: Cloud Account provisioning state. Known values are: "Pending",
     "Provisioning", and "Available".
    :vartype cloud_account_state: str or
     ~azure.mgmt.oracledatabase.models.CloudAccountProvisioningState
    :ivar term_unit: Term Unit. P1Y, P3Y, etc, see Durations
     `https://en.wikipedia.org/wiki/ISO_8601 <https://en.wikipedia.org/wiki/ISO_8601>`_.
    :vartype term_unit: str
    :ivar product_code: Product code for the term unit.
    :vartype product_code: str
    :ivar intent: Intent for the update operation. Known values are: "Retain" and "Reset".
    :vartype intent: str or ~azure.mgmt.oracledatabase.models.Intent
    :ivar azure_subscription_ids: Azure subscriptions to be added.
    :vartype azure_subscription_ids: list[str]
    :ivar add_subscription_operation_state: State of the add Azure subscription operation on Oracle
     subscription. Known values are: "Succeeded", "Updating", and "Failed".
    :vartype add_subscription_operation_state: str or
     ~azure.mgmt.oracledatabase.models.AddSubscriptionOperationState
    :ivar last_operation_status_detail: Status details of the last operation on Oracle
     subscription.
    :vartype last_operation_status_detail: str
    """

    provisioning_state: Optional[Union[str, "_models.OracleSubscriptionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """OracleSubscriptionProvisioningState provisioning state. Known values are: \"Succeeded\",
     \"Failed\", and \"Canceled\"."""
    saas_subscription_id: Optional[str] = rest_field(name="saasSubscriptionId", visibility=["read"])
    """SAAS subscription ID generated by Marketplace."""
    cloud_account_id: Optional[str] = rest_field(name="cloudAccountId", visibility=["read"])
    """Cloud Account Id."""
    cloud_account_state: Optional[Union[str, "_models.CloudAccountProvisioningState"]] = rest_field(
        name="cloudAccountState", visibility=["read"]
    )
    """Cloud Account provisioning state. Known values are: \"Pending\", \"Provisioning\", and
     \"Available\"."""
    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read", "create"])
    """Term Unit. P1Y, P3Y, etc, see Durations `https://en.wikipedia.org/wiki/ISO_8601
     <https://en.wikipedia.org/wiki/ISO_8601>`_."""
    product_code: Optional[str] = rest_field(name="productCode", visibility=["update"])
    """Product code for the term unit."""
    intent: Optional[Union[str, "_models.Intent"]] = rest_field(visibility=["update"])
    """Intent for the update operation. Known values are: \"Retain\" and \"Reset\"."""
    azure_subscription_ids: Optional[List[str]] = rest_field(name="azureSubscriptionIds", visibility=["read"])
    """Azure subscriptions to be added."""
    add_subscription_operation_state: Optional[Union[str, "_models.AddSubscriptionOperationState"]] = rest_field(
        name="addSubscriptionOperationState", visibility=["read"]
    )
    """State of the add Azure subscription operation on Oracle subscription. Known values are:
     \"Succeeded\", \"Updating\", and \"Failed\"."""
    last_operation_status_detail: Optional[str] = rest_field(name="lastOperationStatusDetail", visibility=["read"])
    """Status details of the last operation on Oracle subscription."""

    @overload
    def __init__(
        self,
        *,
        term_unit: Optional[str] = None,
        product_code: Optional[str] = None,
        intent: Optional[Union[str, "_models.Intent"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OracleSubscriptionUpdate(_Model):
    """The type used for update operations of the OracleSubscription.

    :ivar plan: Details of the resource plan.
    :vartype plan: ~azure.mgmt.oracledatabase.models.PlanUpdate
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.OracleSubscriptionUpdateProperties
    """

    plan: Optional["_models.PlanUpdate"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the resource plan."""
    properties: Optional["_models.OracleSubscriptionUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        plan: Optional["_models.PlanUpdate"] = None,
        properties: Optional["_models.OracleSubscriptionUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OracleSubscriptionUpdateProperties(_Model):
    """The updatable properties of the OracleSubscription.

    :ivar product_code: Product code for the term unit.
    :vartype product_code: str
    :ivar intent: Intent for the update operation. Known values are: "Retain" and "Reset".
    :vartype intent: str or ~azure.mgmt.oracledatabase.models.Intent
    """

    product_code: Optional[str] = rest_field(name="productCode", visibility=["update"])
    """Product code for the term unit."""
    intent: Optional[Union[str, "_models.Intent"]] = rest_field(visibility=["update"])
    """Intent for the update operation. Known values are: \"Retain\" and \"Reset\"."""

    @overload
    def __init__(
        self,
        *,
        product_code: Optional[str] = None,
        intent: Optional[Union[str, "_models.Intent"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PeerDbDetails(_Model):
    """PeerDb Details.

    :ivar peer_db_id: The Azure resource ID of the Disaster Recovery peer database, which is
     located in a different region from the current peer database.
    :vartype peer_db_id: str
    :ivar peer_db_ocid: Ocid of the Disaster Recovery peer database, which is located in a
     different region from the current peer database.
    :vartype peer_db_ocid: str
    :ivar peer_db_location: The location of the Disaster Recovery peer database.
    :vartype peer_db_location: str
    """

    peer_db_id: Optional[str] = rest_field(name="peerDbId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure resource ID of the Disaster Recovery peer database, which is located in a different
     region from the current peer database."""
    peer_db_ocid: Optional[str] = rest_field(
        name="peerDbOcid", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ocid of the Disaster Recovery peer database, which is located in a different region from the
     current peer database."""
    peer_db_location: Optional[str] = rest_field(
        name="peerDbLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The location of the Disaster Recovery peer database."""

    @overload
    def __init__(
        self,
        *,
        peer_db_id: Optional[str] = None,
        peer_db_ocid: Optional[str] = None,
        peer_db_location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Plan(_Model):
    """Plan for the resource.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured. Required.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
     Required.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding. Required.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A user defined name of the 3rd Party Artifact that is being procured. Required."""
    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic. Required."""
    product: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID
     specified for the artifact at the time of Data Market onboarding. Required."""
    promotion_code: Optional[str] = rest_field(
        name="promotionCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A publisher provided promotion code as provisioned in Data Market for the said
     product/artifact."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the desired product/artifact."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlanUpdate(_Model):
    """ResourcePlanTypeUpdate model definition.

    :ivar name: A user defined name of the 3rd Party Artifact that is being procured.
    :vartype name: str
    :ivar publisher: The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic.
    :vartype publisher: str
    :ivar product: The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to
     the OfferID specified for the artifact at the time of Data Market onboarding.
    :vartype product: str
    :ivar promotion_code: A publisher provided promotion code as provisioned in Data Market for the
     said product/artifact.
    :vartype promotion_code: str
    :ivar version: The version of the desired product/artifact.
    :vartype version: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A user defined name of the 3rd Party Artifact that is being procured."""
    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic."""
    product: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID
     specified for the artifact at the time of Data Market onboarding."""
    promotion_code: Optional[str] = rest_field(
        name="promotionCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """A publisher provided promotion code as provisioned in Data Market for the said
     product/artifact."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the desired product/artifact."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PortRange(_Model):
    """Port Range to specify particular destination ports for TCP rules.

    :ivar min: The minimum port number, which must not be greater than the maximum port number.
     Required.
    :vartype min: int
    :ivar max: The maximum port number, which must not be less than the minimum port number. To
     specify a single port number, set both the min and max to the same value. Required.
    :vartype max: int
    """

    min: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The minimum port number, which must not be greater than the maximum port number. Required."""
    max: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The maximum port number, which must not be less than the minimum port number. To specify a
     single port number, set both the min and max to the same value. Required."""

    @overload
    def __init__(
        self,
        *,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateIpAddressesFilter(_Model):
    """Private Ip Addresses filter.

    :ivar subnet_id: Subnet OCID. Required.
    :vartype subnet_id: str
    :ivar vnic_id: VCN OCID. Required.
    :vartype vnic_id: str
    """

    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """Subnet OCID. Required."""
    vnic_id: str = rest_field(name="vnicId", visibility=["read", "create", "update", "delete", "query"])
    """VCN OCID. Required."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        vnic_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateIpAddressProperties(_Model):
    """PrivateIpAddress resource properties.

    :ivar display_name: PrivateIpAddresses displayName. Required.
    :vartype display_name: str
    :ivar hostname_label: PrivateIpAddresses hostnameLabel. Required.
    :vartype hostname_label: str
    :ivar ocid: PrivateIpAddresses Id. Required.
    :vartype ocid: str
    :ivar ip_address: PrivateIpAddresses ipAddress. Required.
    :vartype ip_address: str
    :ivar subnet_id: PrivateIpAddresses subnetId. Required.
    :vartype subnet_id: str
    """

    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """PrivateIpAddresses displayName. Required."""
    hostname_label: str = rest_field(name="hostnameLabel", visibility=["read", "create", "update", "delete", "query"])
    """PrivateIpAddresses hostnameLabel. Required."""
    ocid: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """PrivateIpAddresses Id. Required."""
    ip_address: str = rest_field(name="ipAddress", visibility=["read", "create", "update", "delete", "query"])
    """PrivateIpAddresses ipAddress. Required."""
    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """PrivateIpAddresses subnetId. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: str,
        hostname_label: str,
        ocid: str,
        ip_address: str,
        subnet_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProfileType(_Model):
    """The connection string profile to allow clients to group, filter and select connection string
    values based on structured metadata.

    :ivar consumer_group: Consumer group used by the connection. Known values are: "High",
     "Medium", "Low", "Tp", and "Tpurgent".
    :vartype consumer_group: str or ~azure.mgmt.oracledatabase.models.ConsumerGroup
    :ivar display_name: A user-friendly name for the connection. Required.
    :vartype display_name: str
    :ivar host_format: Host format used in connection string. Required. Known values are: "Fqdn"
     and "Ip".
    :vartype host_format: str or ~azure.mgmt.oracledatabase.models.HostFormatType
    :ivar is_regional: True for a regional connection string, applicable to cross-region DG only.
    :vartype is_regional: bool
    :ivar protocol: Protocol used by the connection. Required. Known values are: "TCP" and "TCPS".
    :vartype protocol: str or ~azure.mgmt.oracledatabase.models.ProtocolType
    :ivar session_mode: Specifies whether the listener performs a direct hand-off of the session,
     or redirects the session. Required. Known values are: "Direct" and "Redirect".
    :vartype session_mode: str or ~azure.mgmt.oracledatabase.models.SessionModeType
    :ivar syntax_format: Specifies whether the connection string is using the long (LONG), Easy
     Connect (EZCONNECT), or Easy Connect Plus (EZCONNECTPLUS) format. Required. Known values are:
     "Long", "Ezconnect", and "Ezconnectplus".
    :vartype syntax_format: str or ~azure.mgmt.oracledatabase.models.SyntaxFormatType
    :ivar tls_authentication: Specifies whether the TLS handshake is using one-way (SERVER) or
     mutual (MUTUAL) authentication. Known values are: "Server" and "Mutual".
    :vartype tls_authentication: str or ~azure.mgmt.oracledatabase.models.TlsAuthenticationType
    :ivar value: Connection string value. Required.
    :vartype value: str
    """

    consumer_group: Optional[Union[str, "_models.ConsumerGroup"]] = rest_field(
        name="consumerGroup", visibility=["read", "create", "update", "delete", "query"]
    )
    """Consumer group used by the connection. Known values are: \"High\", \"Medium\", \"Low\", \"Tp\",
     and \"Tpurgent\"."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """A user-friendly name for the connection. Required."""
    host_format: Union[str, "_models.HostFormatType"] = rest_field(
        name="hostFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Host format used in connection string. Required. Known values are: \"Fqdn\" and \"Ip\"."""
    is_regional: Optional[bool] = rest_field(
        name="isRegional", visibility=["read", "create", "update", "delete", "query"]
    )
    """True for a regional connection string, applicable to cross-region DG only."""
    protocol: Union[str, "_models.ProtocolType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protocol used by the connection. Required. Known values are: \"TCP\" and \"TCPS\"."""
    session_mode: Union[str, "_models.SessionModeType"] = rest_field(
        name="sessionMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the listener performs a direct hand-off of the session, or redirects the
     session. Required. Known values are: \"Direct\" and \"Redirect\"."""
    syntax_format: Union[str, "_models.SyntaxFormatType"] = rest_field(
        name="syntaxFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the connection string is using the long (LONG), Easy Connect (EZCONNECT), or
     Easy Connect Plus (EZCONNECTPLUS) format. Required. Known values are: \"Long\", \"Ezconnect\",
     and \"Ezconnectplus\"."""
    tls_authentication: Optional[Union[str, "_models.TlsAuthenticationType"]] = rest_field(
        name="tlsAuthentication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the TLS handshake is using one-way (SERVER) or mutual (MUTUAL)
     authentication. Known values are: \"Server\" and \"Mutual\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Connection string value. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: str,
        host_format: Union[str, "_models.HostFormatType"],
        protocol: Union[str, "_models.ProtocolType"],
        session_mode: Union[str, "_models.SessionModeType"],
        syntax_format: Union[str, "_models.SyntaxFormatType"],
        value: str,
        consumer_group: Optional[Union[str, "_models.ConsumerGroup"]] = None,
        is_regional: Optional[bool] = None,
        tls_authentication: Optional[Union[str, "_models.TlsAuthenticationType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemoveVirtualMachineFromExadbVmClusterDetails(_Model):  # pylint: disable=name-too-long
    """Details of removing Virtual Machines from the Exadata VM cluster on Exascale Infrastructure.
    Applies to Exadata Database Service on Exascale Infrastructure only.

    :ivar db_nodes: The list of ExaCS DB nodes for the Exadata VM cluster on Exascale
     Infrastructure to be removed. Required.
    :vartype db_nodes: list[~azure.mgmt.oracledatabase.models.DbNodeDetails]
    """

    db_nodes: List["_models.DbNodeDetails"] = rest_field(
        name="dbNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of ExaCS DB nodes for the Exadata VM cluster on Exascale Infrastructure to be removed.
     Required."""

    @overload
    def __init__(
        self,
        *,
        db_nodes: List["_models.DbNodeDetails"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreAutonomousDatabaseDetails(_Model):
    """Details to restore an Oracle Autonomous Database.

    :ivar timestamp: The time to restore the database to. Required.
    :vartype timestamp: ~datetime.datetime
    """

    timestamp: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time to restore the database to. Required."""

    @overload
    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SaasSubscriptionDetails(_Model):
    """SaaS Subscription Details model.

    :ivar id: Purchased SaaS subscription ID.
    :vartype id: str
    :ivar subscription_name: SaaS subscription name.
    :vartype subscription_name: str
    :ivar time_created: Creation Date and Time.
    :vartype time_created: ~datetime.datetime
    :ivar offer_id: Purchased offer ID.
    :vartype offer_id: str
    :ivar plan_id: Purchased offer's plan ID.
    :vartype plan_id: str
    :ivar saas_subscription_status: Indicates the status of the Subscription.
    :vartype saas_subscription_status: str
    :ivar publisher_id: Publisher ID.
    :vartype publisher_id: str
    :ivar purchaser_email_id: Purchaser Email ID.
    :vartype purchaser_email_id: str
    :ivar purchaser_tenant_id: Purchaser Tenant ID.
    :vartype purchaser_tenant_id: str
    :ivar term_unit: Purchase Term Unit.
    :vartype term_unit: str
    :ivar is_auto_renew: AutoRenew flag.
    :vartype is_auto_renew: bool
    :ivar is_free_trial: FreeTrial flag.
    :vartype is_free_trial: bool
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Purchased SaaS subscription ID."""
    subscription_name: Optional[str] = rest_field(name="subscriptionName", visibility=["read"])
    """SaaS subscription name."""
    time_created: Optional[datetime.datetime] = rest_field(name="timeCreated", visibility=["read"], format="rfc3339")
    """Creation Date and Time."""
    offer_id: Optional[str] = rest_field(name="offerId", visibility=["read"])
    """Purchased offer ID."""
    plan_id: Optional[str] = rest_field(name="planId", visibility=["read"])
    """Purchased offer's plan ID."""
    saas_subscription_status: Optional[str] = rest_field(name="saasSubscriptionStatus", visibility=["read"])
    """Indicates the status of the Subscription."""
    publisher_id: Optional[str] = rest_field(name="publisherId", visibility=["read"])
    """Publisher ID."""
    purchaser_email_id: Optional[str] = rest_field(name="purchaserEmailId", visibility=["read"])
    """Purchaser Email ID."""
    purchaser_tenant_id: Optional[str] = rest_field(name="purchaserTenantId", visibility=["read"])
    """Purchaser Tenant ID."""
    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read"])
    """Purchase Term Unit."""
    is_auto_renew: Optional[bool] = rest_field(name="isAutoRenew", visibility=["read"])
    """AutoRenew flag."""
    is_free_trial: Optional[bool] = rest_field(name="isFreeTrial", visibility=["read"])
    """FreeTrial flag."""


class ScheduledOperationsType(_Model):
    """The list of scheduled operations.

    :ivar day_of_week: Day of week. Required.
    :vartype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeek
    :ivar scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_start_time: str
    :ivar scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_stop_time: str
    """

    day_of_week: "_models.DayOfWeek" = rest_field(
        name="dayOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Day of week. Required."""
    scheduled_start_time: Optional[str] = rest_field(
        name="scheduledStartTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """auto start time. value must be of ISO-8601 format HH:mm."""
    scheduled_stop_time: Optional[str] = rest_field(
        name="scheduledStopTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """auto stop time. value must be of ISO-8601 format HH:mm."""

    @overload
    def __init__(
        self,
        *,
        day_of_week: "_models.DayOfWeek",
        scheduled_start_time: Optional[str] = None,
        scheduled_stop_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduledOperationsTypeUpdate(_Model):
    """The list of scheduled operations.

    :ivar day_of_week: Day of week. Required.
    :vartype day_of_week: ~azure.mgmt.oracledatabase.models.DayOfWeekUpdate
    :ivar scheduled_start_time: auto start time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_start_time: str
    :ivar scheduled_stop_time: auto stop time. value must be of ISO-8601 format HH:mm.
    :vartype scheduled_stop_time: str
    """

    day_of_week: "_models.DayOfWeekUpdate" = rest_field(
        name="dayOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Day of week. Required."""
    scheduled_start_time: Optional[str] = rest_field(
        name="scheduledStartTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """auto start time. value must be of ISO-8601 format HH:mm."""
    scheduled_stop_time: Optional[str] = rest_field(
        name="scheduledStopTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """auto stop time. value must be of ISO-8601 format HH:mm."""

    @overload
    def __init__(
        self,
        *,
        day_of_week: "_models.DayOfWeekUpdate",
        scheduled_start_time: Optional[str] = None,
        scheduled_stop_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.oracledatabase.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemVersion(ProxyResource):
    """SystemVersion resource Definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.SystemVersionProperties
    """

    properties: Optional["_models.SystemVersionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SystemVersionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemVersionProperties(_Model):
    """System Version Resource model.

    :ivar system_version: A valid Oracle System Version. Required.
    :vartype system_version: str
    """

    system_version: str = rest_field(name="systemVersion", visibility=["read", "create", "update", "delete", "query"])
    """A valid Oracle System Version. Required."""

    @overload
    def __init__(
        self,
        *,
        system_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkAddress(ProxyResource):
    """Virtual IP resource belonging to a vm cluster resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.oracledatabase.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.oracledatabase.models.VirtualNetworkAddressProperties
    """

    properties: Optional["_models.VirtualNetworkAddressProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualNetworkAddressProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualNetworkAddressProperties(_Model):
    """virtualNetworkAddress resource properties.

    :ivar ip_address: Virtual network Address address.
    :vartype ip_address: str
    :ivar vm_ocid: Virtual Machine OCID.
    :vartype vm_ocid: str
    :ivar ocid: Application VIP OCID.
    :vartype ocid: str
    :ivar domain: Virtual network address fully qualified domain name.
    :vartype domain: str
    :ivar lifecycle_details: Additional information about the current lifecycle state of the
     application virtual IP (VIP) address.
    :vartype lifecycle_details: str
    :ivar provisioning_state: Azure resource provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", and "Provisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.oracledatabase.models.AzureResourceProvisioningState
    :ivar lifecycle_state: virtual network address lifecycle state. Known values are:
     "Provisioning", "Available", "Terminating", "Terminated", and "Failed".
    :vartype lifecycle_state: str or
     ~azure.mgmt.oracledatabase.models.VirtualNetworkAddressLifecycleState
    :ivar time_assigned: The date and time when the create operation for the application virtual IP
     (VIP) address completed.
    :vartype time_assigned: ~datetime.datetime
    """

    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read", "create"])
    """Virtual network Address address."""
    vm_ocid: Optional[str] = rest_field(name="vmOcid", visibility=["read", "create"])
    """Virtual Machine OCID."""
    ocid: Optional[str] = rest_field(visibility=["read"])
    """Application VIP OCID."""
    domain: Optional[str] = rest_field(visibility=["read"])
    """Virtual network address fully qualified domain name."""
    lifecycle_details: Optional[str] = rest_field(name="lifecycleDetails", visibility=["read"])
    """Additional information about the current lifecycle state of the application virtual IP (VIP)
     address."""
    provisioning_state: Optional[Union[str, "_models.AzureResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Azure resource provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Provisioning\"."""
    lifecycle_state: Optional[Union[str, "_models.VirtualNetworkAddressLifecycleState"]] = rest_field(
        name="lifecycleState", visibility=["read"]
    )
    """virtual network address lifecycle state. Known values are: \"Provisioning\", \"Available\",
     \"Terminating\", \"Terminated\", and \"Failed\"."""
    time_assigned: Optional[datetime.datetime] = rest_field(name="timeAssigned", visibility=["read"], format="rfc3339")
    """The date and time when the create operation for the application virtual IP (VIP) address
     completed."""

    @overload
    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        vm_ocid: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
