use const_format::concatcp;
use iri_s::{iri_once, IriS};

pub const SH_STR: &str = "http://www.w3.org/ns/shacl#";
pub const SH_BLANKNODE_STR: &str = concatcp!(SH_STR, "BlankNode");
pub const SH_BLANK_NODE_OR_IRI_STR: &str = concatcp!(SH_STR, "BlankNodeOrIRI");
pub const SH_BLANK_NODE_OR_LITERAL_STR: &str = concatcp!(SH_STR, "BlankNodeOrLiteral");
pub const SH_INFO_STR: &str = concatcp!(SH_STR, "Info");
pub const SH_IRI_STR: &str = concatcp!(SH_STR, "IRI");
pub const SH_IRI_OR_LITERAL_STR: &str = concatcp!(SH_STR, "IRIOrLiteral");
pub const SH_LITERAL_STR: &str = concatcp!(SH_STR, "Literal");
pub const SH_NODE_SHAPE_STR: &str = concatcp!(SH_STR, "NodeShape");
pub const SH_PROPERTY_SHAPE_STR: &str = concatcp!(SH_STR, "PropertyShape");
pub const SH_SHAPE_STR: &str = concatcp!(SH_STR, "Shape");
pub const SH_SCHEMA_STR: &str = concatcp!(SH_STR, "Schema");
pub const SH_VALIDATION_REPORT_STR: &str = concatcp!(SH_STR, "ValidationReport");
pub const SH_VALIDATION_RESULT_STR: &str = concatcp!(SH_STR, "ValidationResult");
pub const SH_VIOLATION_STR: &str = concatcp!(SH_STR, "Violation");
pub const SH_WARNING_STR: &str = concatcp!(SH_STR, "Warning");
pub const SH_AND_STR: &str = concatcp!(SH_STR, "and");
pub const SH_CLASS_STR: &str = concatcp!(SH_STR, "class");
pub const SH_CLOSED_STR: &str = concatcp!(SH_STR, "closed");
pub const SH_CONFORMS_STR: &str = concatcp!(SH_STR, "conforms");
pub const SH_DATATYPE_STR: &str = concatcp!(SH_STR, "datatype");
pub const SH_DEACTIVATED_STR: &str = concatcp!(SH_STR, "deactivated");
pub const SH_DESCRIPTION_STR: &str = concatcp!(SH_STR, "description");
pub const SH_DISJOINT_STR: &str = concatcp!(SH_STR, "disjoint");
pub const SH_EQUALS_STR: &str = concatcp!(SH_STR, "equals");
pub const SH_ENTAILMENT_STR: &str = concatcp!(SH_STR, "entailment");
pub const SH_FLAGS_STR: &str = concatcp!(SH_STR, "flags");
pub const SH_FOCUS_NODE_STR: &str = concatcp!(SH_STR, "focusNode");
pub const SH_GROUP_STR: &str = concatcp!(SH_STR, "group");
pub const SH_HAS_VALUE_STR: &str = concatcp!(SH_STR, "hasValue");
pub const SH_IGNORED_PROPERTIES_STR: &str = concatcp!(SH_STR, "ignoredProperties");
pub const SH_IN_STR: &str = concatcp!(SH_STR, "in");
pub const SH_LANGUAGE_IN_STR: &str = concatcp!(SH_STR, "languageIn");
pub const SH_LESS_THAN_STR: &str = concatcp!(SH_STR, "lessThan");
pub const SH_LESS_THAN_OR_EQUALS_STR: &str = concatcp!(SH_STR, "lessThanOrEquals");
pub const SH_MIN_COUNT_STR: &str = concatcp!(SH_STR, "minCount");
pub const SH_MAX_COUNT_STR: &str = concatcp!(SH_STR, "maxCount");
pub const SH_MIN_INCLUSIVE_STR: &str = concatcp!(SH_STR, "minInclusive");
pub const SH_MIN_EXCLUSIVE_STR: &str = concatcp!(SH_STR, "minExclusive");
pub const SH_MAX_INCLUSIVE_STR: &str = concatcp!(SH_STR, "maxInclusive");
pub const SH_MAX_EXCLUSIVE_STR: &str = concatcp!(SH_STR, "maxExclusive");
pub const SH_MIN_LENGTH_STR: &str = concatcp!(SH_STR, "minLength");
pub const SH_MAX_LENGTH_STR: &str = concatcp!(SH_STR, "maxLength");
pub const SH_MESSAGE_STR: &str = concatcp!(SH_STR, "message");
pub const SH_NAME_STR: &str = concatcp!(SH_STR, "name");
pub const SH_NODE_KIND_STR: &str = concatcp!(SH_STR, "nodeKind");
pub const SH_NODE_STR: &str = concatcp!(SH_STR, "node");
pub const SH_NOT_STR: &str = concatcp!(SH_STR, "not");
pub const SH_OR_STR: &str = concatcp!(SH_STR, "or");
pub const SH_ORDER_STR: &str = concatcp!(SH_STR, "order");
pub const SH_PATH_STR: &str = concatcp!(SH_STR, "path");
pub const SH_PATTERN_STR: &str = concatcp!(SH_STR, "pattern");
pub const SH_PROPERTY_STR: &str = concatcp!(SH_STR, "property");
pub const SH_QUALIFIED_MIN_COUNT_STR: &str = concatcp!(SH_STR, "qualifiedMinCount");
pub const SH_QUALIFIED_MAX_COUNT_STR: &str = concatcp!(SH_STR, "qualifiedMaxCount");
pub const SH_QUALIFIED_VALUE_SHAPE_STR: &str = concatcp!(SH_STR, "qualifiedValueShape");
pub const SH_QUALIFIED_VALUE_SHAPES_DISJOINT_STR: &str =
    concatcp!(SH_STR, "qualifiedValueShapesDisjoint");
pub const SH_RESULT_STR: &str = concatcp!(SH_STR, "result");
pub const SH_RESULT_PATH_STR: &str = concatcp!(SH_STR, "resultPath");
pub const SH_RESULT_SEVERITY_STR: &str = concatcp!(SH_STR, "resultSeverity");
pub const SH_RESULT_MESSAGE_STR: &str = concatcp!(SH_STR, "resultMessage");
pub const SH_SHAPES_GRAPH_STR: &str = concatcp!(SH_STR, "shapesGraph");
pub const SH_SEVERITY_STR: &str = concatcp!(SH_STR, "severity");
pub const SH_SOURCE_CONSTRAINT_COMPONENT_STR: &str = concatcp!(SH_STR, "sourceConstraintComponent");
pub const SH_SOURCE_SHAPE_STR: &str = concatcp!(SH_STR, "sourceShape");
pub const SH_VALUE_STR: &str = concatcp!(SH_STR, "value");
pub const SH_TARGET_NODE_STR: &str = concatcp!(SH_STR, "targetNode");
pub const SH_TARGET_CLASS_STR: &str = concatcp!(SH_STR, "targetClass");
pub const SH_TARGET_SUBJECTS_OF_STR: &str = concatcp!(SH_STR, "targetSubjectsOf");
pub const SH_TARGET_OBJECTS_OF_STR: &str = concatcp!(SH_STR, "targetObjectsOf");
pub const SH_TEXT_STR: &str = concatcp!(SH_STR, "text");
pub const SH_UNIQUE_LANG_STR: &str = concatcp!(SH_STR, "uniqueLang");
pub const SH_XONE_STR: &str = concatcp!(SH_STR, "xone");
pub const SH_SOURCE_CONSTRAINT_STR: &str = concatcp!(SH_STR, "sourceConstraint");

iri_once!(sh, SH_STR);
iri_once!(sh_blanknode, SH_BLANKNODE_STR);
iri_once!(sh_blank_node_or_iri, SH_BLANK_NODE_OR_IRI_STR);
iri_once!(sh_blank_node_or_literal, SH_BLANK_NODE_OR_LITERAL_STR);
iri_once!(sh_info, SH_INFO_STR);
iri_once!(sh_iri, SH_IRI_STR);
iri_once!(sh_iri_or_literal, SH_IRI_OR_LITERAL_STR);
iri_once!(sh_literal, SH_LITERAL_STR);
iri_once!(sh_node_shape, SH_NODE_SHAPE_STR);
iri_once!(sh_property_shape, SH_PROPERTY_SHAPE_STR);
iri_once!(sh_shape, SH_SHAPE_STR);
iri_once!(sh_schema, SH_SCHEMA_STR);
iri_once!(sh_validation_report, SH_VALIDATION_REPORT_STR);
iri_once!(sh_validation_result, SH_VALIDATION_RESULT_STR);
iri_once!(sh_violation, SH_VIOLATION_STR);
iri_once!(sh_warning, SH_WARNING_STR);
iri_once!(sh_and, SH_AND_STR);
iri_once!(sh_class, SH_CLASS_STR);
iri_once!(sh_closed, SH_CLOSED_STR);
iri_once!(sh_conforms, SH_CONFORMS_STR);
iri_once!(sh_datatype, SH_DATATYPE_STR);
iri_once!(sh_deactivated, SH_DEACTIVATED_STR);
iri_once!(sh_description, SH_DESCRIPTION_STR);
iri_once!(sh_disjoint, SH_DISJOINT_STR);
iri_once!(sh_equals, SH_EQUALS_STR);
iri_once!(sh_entailment, SH_ENTAILMENT_STR);
iri_once!(sh_flags, SH_FLAGS_STR);
iri_once!(sh_focus_node, SH_FOCUS_NODE_STR);
iri_once!(sh_group, SH_GROUP_STR);
iri_once!(sh_has_value, SH_HAS_VALUE_STR);
iri_once!(sh_ignored_properties, SH_IGNORED_PROPERTIES_STR);
iri_once!(sh_in, SH_IN_STR);
iri_once!(sh_language_in, SH_LANGUAGE_IN_STR);
iri_once!(sh_less_than, SH_LESS_THAN_STR);
iri_once!(sh_less_than_or_equals, SH_LESS_THAN_OR_EQUALS_STR);
iri_once!(sh_min_count, SH_MIN_COUNT_STR);
iri_once!(sh_max_count, SH_MAX_COUNT_STR);
iri_once!(sh_min_inclusive, SH_MIN_INCLUSIVE_STR);
iri_once!(sh_min_exclusive, SH_MIN_EXCLUSIVE_STR);
iri_once!(sh_max_inclusive, SH_MAX_INCLUSIVE_STR);
iri_once!(sh_max_exclusive, SH_MAX_EXCLUSIVE_STR);
iri_once!(sh_min_length, SH_MIN_LENGTH_STR);
iri_once!(sh_max_length, SH_MAX_LENGTH_STR);
iri_once!(sh_message, SH_MESSAGE_STR);
iri_once!(sh_name, SH_NAME_STR);
iri_once!(sh_node_kind, SH_NODE_KIND_STR);
iri_once!(sh_node, SH_NODE_STR);
iri_once!(sh_not, SH_NOT_STR);
iri_once!(sh_or, SH_OR_STR);
iri_once!(sh_order, SH_ORDER_STR);
iri_once!(sh_path, SH_PATH_STR);
iri_once!(sh_pattern, SH_PATTERN_STR);
iri_once!(sh_property, SH_PROPERTY_STR);
iri_once!(sh_qualified_min_count, SH_QUALIFIED_MIN_COUNT_STR);
iri_once!(sh_qualified_max_count, SH_QUALIFIED_MAX_COUNT_STR);
iri_once!(sh_qualified_value_shape, SH_QUALIFIED_VALUE_SHAPE_STR);
iri_once!(
    sh_qualified_value_shapes_disjoint,
    SH_QUALIFIED_VALUE_SHAPES_DISJOINT_STR
);
iri_once!(sh_result, SH_RESULT_STR);
iri_once!(sh_result_path, SH_RESULT_PATH_STR);
iri_once!(sh_result_severity, SH_RESULT_SEVERITY_STR);
iri_once!(sh_result_message, SH_RESULT_MESSAGE_STR);
iri_once!(sh_shapes_graph, SH_SHAPES_GRAPH_STR);
iri_once!(sh_severity, SH_SEVERITY_STR);
iri_once!(
    sh_source_constraint_component,
    SH_SOURCE_CONSTRAINT_COMPONENT_STR
);
iri_once!(sh_source_shape, SH_SOURCE_SHAPE_STR);
iri_once!(sh_value, SH_VALUE_STR);
iri_once!(sh_target_node, SH_TARGET_NODE_STR);
iri_once!(sh_target_class, SH_TARGET_CLASS_STR);
iri_once!(sh_target_subjects_of, SH_TARGET_SUBJECTS_OF_STR);
iri_once!(sh_target_objects_of, SH_TARGET_OBJECTS_OF_STR);
iri_once!(sh_text, SH_TEXT_STR);
iri_once!(sh_unique_lang, SH_UNIQUE_LANG_STR);
iri_once!(sh_xone, SH_XONE_STR);
iri_once!(sh_source_constraint, SH_SOURCE_CONSTRAINT_STR);
