# 2022-06-14 Triage Log

A mixed week. I suppose it is best to focus on the fact we made some big
improvements to a large number of primary benchmarks, at the cost of some
smaller regressions to a smaller number of primary benchmarks.

Triage done by **@pnkfelix**.
Revision range: [bb55bd449e65e611da928560d948982d73e50027..edab34ab2abbafc16a78daedf71dbacd2eb0b7bf](https://perf.rust-lang.org/?start=bb55bd449e65e611da928560d948982d73e50027&end=edab34ab2abbafc16a78daedf71dbacd2eb0b7bf&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 1.6% | 35    |
| Regressions 😿 <br /> (secondary) | 2.1% | 8.1% | 23    |
| Improvements 🎉 <br /> (primary) | -0.8% | -3.5% | 72    |
| Improvements 🎉 <br /> (secondary) | -0.8% | -2.9% | 62    |
| All 😿🎉 (primary) | -0.4% | -3.5% | 107   |


4 Regressions, 3 Improvements, 5 Mixed; 4 of them in rollups
47 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#97825](https://github.com/rust-lang/rust/pull/97825) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=91cacb3faf987805675e39aca41859ec1fcabef3&end=7fe2c4b00dfbc33643e1af4b293eb057306a8339&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.2% | 0.3% | 4     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.2% | 0.3% | 4     |

* stm32f4-0.14.0 regressed for check+debug+opt on incr-patched: negate. diesel-1.4.8 regressed for check on incr-patched: println
* Given that all the regressions are to incremental, I'm assuming this is because of #97058
* skimming over the [perf details for stm32f4 check](https://perf.rust-lang.org/detailed-query.html?commit=7fe2c4b00dfbc33643e1af4b293eb057306a8339&base_commit=91cacb3faf987805675e39aca41859ec1fcabef3&benchmark=stm32f4-0.14.0-check&scenario=incr-patched:%20negate), it *seems* like the bulk of the time delta is coming from `expand_crate`. A total time delta of 0.66, and the biggest contributors to that delta are `expand_crate` (0.033), `incr_comp_load_dep_graph` (0.015), `misc_checking_1` (0.007), `hir_owner_nodes` (0.005), `generate_crate_metadata` (0.005), `incr_comp_encode_dep_graph` (0.004), and `wf_checking` (0.004). The remainder are <= 0.003, most of them <= 0.000.
* given the relatively small size and scope of the regression, and the fact that it was in a rollup, I do not think this is worth investigating further. marked as triaged.

Rollup of 6 pull requests [#97968](https://github.com/rust-lang/rust/pull/97968) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ec55c61305eaf385fc1b93ac9a78284b4d887fe5&end=b9f3bdf5ce37c50c71dd7cee969a14e15f14130a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.3% | 3     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.3% | 0.3% | 3     |

* diesel-1.4.8 regressed on check full, opt full, and check incr-full, by about 0.3% each time.
* rylev says that diesel has started to become more noisy in its behavior, perhaps since we turned on PGO.
* I do not think this is worth investigating further. marked as triaged.

Handle `def_ident_span` like `def_span`. [#95880](https://github.com/rust-lang/rust/pull/95880) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c08b235a5ce10167632bb0fddcd0c5d67f2d42e3&end=99930ac7f8cbb5d9b319b2e2e92794fd6f24f556&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 1.6% | 92    |
| Regressions 😿 <br /> (secondary) | 0.8% | 1.9% | 28    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.6% | 1.6% | 92    |

* [Already triaged by the PR author](https://github.com/rust-lang/rust/pull/95880#issuecomment-1152671967).
* "we encode more spans into metadata and invoke more queries, so the slight regression is to be expected."

Rollup of 5 pull requests [#98025](https://github.com/rust-lang/rust/pull/98025) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae2aa18d7467e212c4e961378b1061628abdb358&end=53305f15625756dc3ec62ddc0ec070dee412a547&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 5.5% | 7.9% | 6     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |

* All six regressions are variations of issue-88862: {opt,debug} x { incr-full, full, incr-unchanged }. The two incr-unchanged cases regressed by 0.94% and 1.72% . The full cases regressed by 7.13% and 7.57% . The incr-full cases regressed by 7.86% and 7.80%.
* None of these PRs strike me as something that would cause a problem for the code exercised by #88862. (I briefly thought it might be #98012, but issue-88862 doesn't exercise HKT's...)
* but also, given that issue-88862 is a canary that is trying to catch a catastrophic regression, I think we can accept a 7-8% regression here.

#### Improvements

Re-use the type op instead of calling the implied_outlives_bounds query directly [#97081](https://github.com/rust-lang/rust/pull/97081) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5435ed6916a59e8d5acba2149316a841c3905cbd&end=b17e9d76f2ad15022e0e69bc33745c4ef9025a8f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.6% | 22    |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.7% | 12    |
| All 😿🎉 (primary) | -0.3% | -0.6% | 22    |


Revert part of #94372 to improve performance [#97905](https://github.com/rust-lang/rust/pull/97905) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=75307c22f33cb47966466ba1daca08573a3c583e&end=c84594661c1b51feb539b479b58bb551fcf8e19a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.9% | 82    |
| Improvements 🎉 <br /> (secondary) | -0.5% | -1.0% | 39    |
| All 😿🎉 (primary) | -0.4% | -0.9% | 82    |


Tidy up miscellaneous bounds suggestions [#97778](https://github.com/rust-lang/rust/pull/97778) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e652caa679a304af11fc04f1f12452f255a82593&end=37a42258ffe02cfb7107380759e492c64500ab55&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 2     |
| Improvements 🎉 <br /> (secondary) | -0.7% | -0.8% | 6     |
| All 😿🎉 (primary) | -0.3% | -0.4% | 2     |


#### Mixed

Folding revamp [#97447](https://github.com/rust-lang/rust/pull/97447) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=47aee31b2a89cb7de97d779869a30b046632b6af&end=64a7aa7016de32f4d991c30bfa40d3911e18a213&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.6% | 6     |
| Regressions 😿 <br /> (secondary) | 0.4% | 0.7% | 5     |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.7% | 5     |
| Improvements 🎉 <br /> (secondary) | -0.8% | -2.1% | 23    |
| All 😿🎉 (primary) | 0.1% | -0.7% | 11    |

* [already triaged by its author](https://github.com/rust-lang/rust/pull/97447#issuecomment-1150497492)
* "The perf effects are fairly small and there are more improvements than regressions."

Make `Encodable` and `Encoder` infallible. [#94732](https://github.com/rust-lang/rust/pull/94732) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e45d9973b2665897a768312e971b82cc62633103&end=1a97162cb245b5e2c7458c28859e3df779908c02&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.8% | 16    |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.9% | 15    |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.5% | 25    |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.5% | 20    |
| All 😿🎉 (primary) | -0.1% | 0.8% | 41    |

* PR author [already investigated](https://github.com/rust-lang/rust/pull/94732#issuecomment-1154607616).
* "Good news: #97905 fixed the regressions here. That PR plus this PR combined gave a clear performance win."
* marked as triaged.

cleanup bound variable handling [#97648](https://github.com/rust-lang/rust/pull/97648) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b9f3bdf5ce37c50c71dd7cee969a14e15f14130a&end=75307c22f33cb47966466ba1daca08573a3c583e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.3% | 4     |
| Improvements 🎉 <br /> (primary) | -0.7% | -1.7% | 22    |
| Improvements 🎉 <br /> (secondary) | -0.5% | -0.6% | 16    |
| All 😿🎉 (primary) | -0.7% | -1.7% | 22    |


Rollup of 10 pull requests [#98066](https://github.com/rust-lang/rust/pull/98066) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=083721a1a7365d3afe1521cd2661b2201aac0450&end=ca122c7ebb3ab50149c9d3d24ddb59c252b32272&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.6% | 4     |
| Regressions 😿 <br /> (secondary) | 0.4% | 0.5% | 11    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 4     |
| All 😿🎉 (primary) | 0.5% | 0.6% | 4     |

* diesel-1.4.8 regressed by 0.5% for variations on check/debug/opt and incr-full/full. That's the only primary regression, and its within the noise level that we're currently associating with diesel, I think.
* The other regressions are wf-projection-stress-65510, projection-caching, regression-31157, and wg-grammar.
* wf-projection-stress-65510 and regression-31157 are canaries where we are trying to catch a *massive* regression, not a minor one like the ones presented here.
* given that this is a rollup and the remaining regressions are well under 0.5%, I think that's the limit to the amount of investigation I want to do here.

Remove RegionckMode in favor of calling new skip_region_resolution [#98041](https://github.com/rust-lang/rust/pull/98041) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2ecbf87cf355a121a62f0629ea5f880c9bf41fc&end=4e02a9281dd8c74cf5c04df044659b5e03b17571&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.2% | 0.2% | 1     |
| Regressions 😿 <br /> (secondary) | 1.0% | 1.2% | 3     |
| Improvements 🎉 <br /> (primary) | -0.9% | -3.7% | 35    |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 1     |
| All 😿🎉 (primary) | -0.8% | -3.7% | 36    |


* Skimming over the comparison (and even just from the table), it seems clear that the improvements far far far outweighed the gains here.
* Marking as triaged.

#### Untriaged Pull Requests

- [#98066 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/98066)
- [#98025 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/98025)
- [#97968 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/97968)
- [#97825 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/97825)
- [#97019 Transition to valtrees pt1](https://github.com/rust-lang/rust/pull/97019)
- [#97004 Proc macro tweaks](https://github.com/rust-lang/rust/pull/97004)
- [#96883 Add EarlyBinder](https://github.com/rust-lang/rust/pull/96883)
- [#96825  Retire `ItemLikeVisitor` trait](https://github.com/rust-lang/rust/pull/96825)
- [#96010 Implement `core::ptr::Unique` on top of `NonNull`](https://github.com/rust-lang/rust/pull/96010)
- [#95990 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95990)
- [#95899 rustc_metadata: Do not encode unnecessary module children](https://github.com/rust-lang/rust/pull/95899)
- [#95893 Respect -Z verify-llvm-ir and other flags that add extra passes when combined with -C no-prepopulate-passes in the new LLVM Pass Manager.](https://github.com/rust-lang/rust/pull/95893)
- [#95835 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/95835)
- [#95794 `parse_tt`: a few more tweaks](https://github.com/rust-lang/rust/pull/95794)
- [#95742 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/95742)
- [#95715 Shrink `Nonterminal`](https://github.com/rust-lang/rust/pull/95715)
- [#95706 rustdoc: Early doc link resolution fixes and refactorings](https://github.com/rust-lang/rust/pull/95706)
- [#95702 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/95702)
- [#95667 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/95667)
- [#95662 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/95662)
- [#95645 Fix intra doc link ICE when trying to get traits in scope for primitive](https://github.com/rust-lang/rust/pull/95645)
- [#95604 Generate synthetic object file to ensure all exported and used symbols participate in the linking](https://github.com/rust-lang/rust/pull/95604)
- [#95563 Move the extended lifetime resolution into typeck context](https://github.com/rust-lang/rust/pull/95563)
- [#95399 Faster parsing for lower numbers for radix up to 16 (cont.)](https://github.com/rust-lang/rust/pull/95399)
- [#95250 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/95250)
- [#94824 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/94824)
- [#94814 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94814)
- [#94732 Make `Encodable` and `Encoder` infallible.](https://github.com/rust-lang/rust/pull/94732)
- [#94527 Let CTFE to handle partially uninitialized unions without marking the entire value as uninitialized.](https://github.com/rust-lang/rust/pull/94527)
- [#94402 Revert "Auto merge of #92419 - erikdesjardins:coldland, r=nagisa"](https://github.com/rust-lang/rust/pull/94402)
