-- tkz_elements_functions_regular.lua
-- date 2025/06/15
-- version 4.15c
-- Copyright 2025  Alain Matthes
-- This work may be distributed and/or modified under the
-- conditions of the LaTeX Project Public License, either version 1.3
-- of this license or (at your option) any later version.
-- The latest version of this license is in
-- http://www.latex-project.org/lppl.txt
-- and version 1.3 or later is part of all distributions of LaTeX
-- version 2005/12/01 or later.
-- This work has the LPPL maintenance status “maintained”.
-- The Current Maintainer of this work is Alain Matthes.

---------------------------------------------------------------------------
--
---------------------------------------------------------------------------
function regular_(c, th, s)
	-- Center through side
	local dep = angle_normalize_(point.arg(th - c))
	local r = point.mod(th - c)
	local t = {}
	local angle_step = 2 * math.pi / s

	for i = 0, s - 1 do
		table.insert(t, c + point:polar(r, i * angle_step + dep))
	end
  
	return t
end
