// This file was generated with libtransmission/mime-types.js
// DO NOT EDIT MANUALLY

// This file Copyright © Mnemosyne LLC.
// It may be used under GPLv2 (SPDX: GPL-2.0-only), GPLv3 (SPDX: GPL-3.0-only),
// or any future license endorsed by Mnemosyne LLC.
// License text can be found in the licenses/ folder.

#pragma once

#include <array>
#include <string_view>

struct mime_type_suffix
{
    std::string_view suffix;
    std::string_view mime_type;
};

inline auto constexpr MimeTypeSuffixes = std::array<mime_type_suffix, 1239>{
    { { R"(123)", R"(application/vnd.lotus-1-2-3)" },
      { R"(1km)", R"(application/vnd.1000minds.decision-model+xml)" },
      { R"(210)", R"(model/step)" },
      { R"(3dml)", R"(text/vnd.in3d.3dml)" },
      { R"(3ds)", R"(image/x-3ds)" },
      { R"(3g2)", R"(video/3gpp2)" },
      { R"(3gp)", R"(video/3gpp)" },
      { R"(3gpp)", R"(audio/3gpp)" },
      { R"(3mf)", R"(model/3mf)" },
      { R"(7z)", R"(application/x-7z-compressed)" },
      { R"(aab)", R"(application/x-authorware-bin)" },
      { R"(aac)", R"(audio/aac)" },
      { R"(aam)", R"(application/x-authorware-map)" },
      { R"(aas)", R"(application/x-authorware-seg)" },
      { R"(abw)", R"(application/x-abiword)" },
      { R"(ac)", R"(application/pkix-attr-cert)" },
      { R"(acc)", R"(application/vnd.americandynamics.acc)" },
      { R"(ace)", R"(application/x-ace-compressed)" },
      { R"(acu)", R"(application/vnd.acucobol)" },
      { R"(acutc)", R"(application/vnd.acucorp)" },
      { R"(adp)", R"(audio/adpcm)" },
      { R"(adts)", R"(audio/aac)" },
      { R"(aep)", R"(application/vnd.audiograph)" },
      { R"(afm)", R"(application/x-font-type1)" },
      { R"(afp)", R"(application/vnd.ibm.modcap)" },
      { R"(age)", R"(application/vnd.age)" },
      { R"(ahead)", R"(application/vnd.ahead.space)" },
      { R"(ai)", R"(application/postscript)" },
      { R"(aif)", R"(audio/x-aiff)" },
      { R"(aifc)", R"(audio/x-aiff)" },
      { R"(aiff)", R"(audio/x-aiff)" },
      { R"(air)", R"(application/vnd.adobe.air-application-installer-package+zip)" },
      { R"(ait)", R"(application/vnd.dvb.ait)" },
      { R"(ami)", R"(application/vnd.amiga.ami)" },
      { R"(aml)", R"(application/automationml-aml+xml)" },
      { R"(amlx)", R"(application/automationml-amlx+zip)" },
      { R"(amr)", R"(audio/amr)" },
      { R"(apk)", R"(application/vnd.android.package-archive)" },
      { R"(apng)", R"(image/apng)" },
      { R"(appcache)", R"(text/cache-manifest)" },
      { R"(appinstaller)", R"(application/appinstaller)" },
      { R"(application)", R"(application/x-ms-application)" },
      { R"(appx)", R"(application/appx)" },
      { R"(appxbundle)", R"(application/appxbundle)" },
      { R"(apr)", R"(application/vnd.lotus-approach)" },
      { R"(arc)", R"(application/x-freearc)" },
      { R"(arj)", R"(application/x-arj)" },
      { R"(asc)", R"(application/pgp-keys)" },
      { R"(asf)", R"(video/x-ms-asf)" },
      { R"(asm)", R"(text/x-asm)" },
      { R"(aso)", R"(application/vnd.accpac.simply.aso)" },
      { R"(asx)", R"(video/x-ms-asf)" },
      { R"(atc)", R"(application/vnd.acucorp)" },
      { R"(atom)", R"(application/atom+xml)" },
      { R"(atomcat)", R"(application/atomcat+xml)" },
      { R"(atomdeleted)", R"(application/atomdeleted+xml)" },
      { R"(atomsvc)", R"(application/atomsvc+xml)" },
      { R"(atx)", R"(application/vnd.antix.game-component)" },
      { R"(au)", R"(audio/basic)" },
      { R"(avci)", R"(image/avci)" },
      { R"(avcs)", R"(image/avcs)" },
      { R"(avi)", R"(video/x-msvideo)" },
      { R"(avif)", R"(image/avif)" },
      { R"(aw)", R"(application/applixware)" },
      { R"(azf)", R"(application/vnd.airzip.filesecure.azf)" },
      { R"(azs)", R"(application/vnd.airzip.filesecure.azs)" },
      { R"(azv)", R"(image/vnd.airzip.accelerator.azv)" },
      { R"(azw)", R"(application/vnd.amazon.ebook)" },
      { R"(b16)", R"(image/vnd.pco.b16)" },
      { R"(bary)", R"(model/vnd.bary)" },
      { R"(bat)", R"(application/x-msdownload)" },
      { R"(bcpio)", R"(application/x-bcpio)" },
      { R"(bdf)", R"(application/x-font-bdf)" },
      { R"(bdm)", R"(application/vnd.syncml.dm+wbxml)" },
      { R"(bdo)", R"(application/vnd.nato.bindingdataobject+xml)" },
      { R"(bdoc)", R"(application/bdoc)" },
      { R"(bed)", R"(application/vnd.realvnc.bed)" },
      { R"(bh2)", R"(application/vnd.fujitsu.oasysprs)" },
      { R"(bin)", R"(application/octet-stream)" },
      { R"(blb)", R"(application/x-blorb)" },
      { R"(blend)", R"(application/x-blender)" },
      { R"(blorb)", R"(application/x-blorb)" },
      { R"(bmi)", R"(application/vnd.bmi)" },
      { R"(bmml)", R"(application/vnd.balsamiq.bmml+xml)" },
      { R"(bmp)", R"(image/bmp)" },
      { R"(book)", R"(application/vnd.framemaker)" },
      { R"(box)", R"(application/vnd.previewsystems.box)" },
      { R"(boz)", R"(application/x-bzip2)" },
      { R"(bpk)", R"(application/octet-stream)" },
      { R"(brush)", R"(application/vnd.procreate.brush)" },
      { R"(brushset)", R"(application/vnd.procrate.brushset)" },
      { R"(bsp)", R"(model/vnd.valve.source.compiled-map)" },
      { R"(btf)", R"(image/prs.btif)" },
      { R"(btif)", R"(image/prs.btif)" },
      { R"(buffer)", R"(application/octet-stream)" },
      { R"(bz)", R"(application/x-bzip)" },
      { R"(bz2)", R"(application/x-bzip2)" },
      { R"(c)", R"(text/x-c)" },
      { R"(c11amc)", R"(application/vnd.cluetrust.cartomobile-config)" },
      { R"(c11amz)", R"(application/vnd.cluetrust.cartomobile-config-pkg)" },
      { R"(c4d)", R"(application/vnd.clonk.c4group)" },
      { R"(c4f)", R"(application/vnd.clonk.c4group)" },
      { R"(c4g)", R"(application/vnd.clonk.c4group)" },
      { R"(c4p)", R"(application/vnd.clonk.c4group)" },
      { R"(c4u)", R"(application/vnd.clonk.c4group)" },
      { R"(cab)", R"(application/vnd.ms-cab-compressed)" },
      { R"(caf)", R"(audio/x-caf)" },
      { R"(cap)", R"(application/vnd.tcpdump.pcap)" },
      { R"(car)", R"(application/vnd.curl.car)" },
      { R"(cat)", R"(application/vnd.ms-pki.seccat)" },
      { R"(cb7)", R"(application/x-cbr)" },
      { R"(cba)", R"(application/x-cbr)" },
      { R"(cbr)", R"(application/x-cbr)" },
      { R"(cbt)", R"(application/x-cbr)" },
      { R"(cbz)", R"(application/x-cbr)" },
      { R"(cc)", R"(text/x-c)" },
      { R"(cco)", R"(application/x-cocoa)" },
      { R"(cct)", R"(application/x-director)" },
      { R"(ccxml)", R"(application/ccxml+xml)" },
      { R"(cdbcmsg)", R"(application/vnd.contact.cmsg)" },
      { R"(cdf)", R"(application/x-netcdf)" },
      { R"(cdfx)", R"(application/cdfx+xml)" },
      { R"(cdkey)", R"(application/vnd.mediastation.cdkey)" },
      { R"(cdmia)", R"(application/cdmi-capability)" },
      { R"(cdmic)", R"(application/cdmi-container)" },
      { R"(cdmid)", R"(application/cdmi-domain)" },
      { R"(cdmio)", R"(application/cdmi-object)" },
      { R"(cdmiq)", R"(application/cdmi-queue)" },
      { R"(cdx)", R"(chemical/x-cdx)" },
      { R"(cdxml)", R"(application/vnd.chemdraw+xml)" },
      { R"(cdy)", R"(application/vnd.cinderella)" },
      { R"(cer)", R"(application/pkix-cert)" },
      { R"(cfs)", R"(application/x-cfs-compressed)" },
      { R"(cgm)", R"(image/cgm)" },
      { R"(chat)", R"(application/x-chat)" },
      { R"(chm)", R"(application/vnd.ms-htmlhelp)" },
      { R"(chrt)", R"(application/vnd.kde.kchart)" },
      { R"(cif)", R"(chemical/x-cif)" },
      { R"(cii)", R"(application/vnd.anser-web-certificate-issue-initiation)" },
      { R"(cil)", R"(application/vnd.ms-artgalry)" },
      { R"(cjs)", R"(application/node)" },
      { R"(cla)", R"(application/vnd.claymore)" },
      { R"(class)", R"(application/java-vm)" },
      { R"(cld)", R"(model/vnd.cld)" },
      { R"(clkk)", R"(application/vnd.crick.clicker.keyboard)" },
      { R"(clkp)", R"(application/vnd.crick.clicker.palette)" },
      { R"(clkt)", R"(application/vnd.crick.clicker.template)" },
      { R"(clkw)", R"(application/vnd.crick.clicker.wordbank)" },
      { R"(clkx)", R"(application/vnd.crick.clicker)" },
      { R"(clp)", R"(application/x-msclip)" },
      { R"(cmc)", R"(application/vnd.cosmocaller)" },
      { R"(cmdf)", R"(chemical/x-cmdf)" },
      { R"(cml)", R"(chemical/x-cml)" },
      { R"(cmp)", R"(application/vnd.yellowriver-custom-menu)" },
      { R"(cmx)", R"(image/x-cmx)" },
      { R"(cod)", R"(application/vnd.rim.cod)" },
      { R"(coffee)", R"(text/coffeescript)" },
      { R"(com)", R"(application/x-msdownload)" },
      { R"(conf)", R"(text/plain)" },
      { R"(cpio)", R"(application/x-cpio)" },
      { R"(cpl)", R"(application/cpl+xml)" },
      { R"(cpp)", R"(text/x-c)" },
      { R"(cpt)", R"(application/mac-compactpro)" },
      { R"(crd)", R"(application/x-mscardfile)" },
      { R"(crl)", R"(application/pkix-crl)" },
      { R"(crt)", R"(application/x-x509-ca-cert)" },
      { R"(crx)", R"(application/x-chrome-extension)" },
      { R"(cryptonote)", R"(application/vnd.rig.cryptonote)" },
      { R"(csh)", R"(application/x-csh)" },
      { R"(csl)", R"(application/vnd.citationstyles.style+xml)" },
      { R"(csml)", R"(chemical/x-csml)" },
      { R"(csp)", R"(application/vnd.commonspace)" },
      { R"(css)", R"(text/css)" },
      { R"(cst)", R"(application/x-director)" },
      { R"(csv)", R"(text/csv)" },
      { R"(cu)", R"(application/cu-seeme)" },
      { R"(curl)", R"(text/vnd.curl)" },
      { R"(cwl)", R"(application/cwl)" },
      { R"(cww)", R"(application/prs.cww)" },
      { R"(cxt)", R"(application/x-director)" },
      { R"(cxx)", R"(text/x-c)" },
      { R"(dae)", R"(model/vnd.collada+xml)" },
      { R"(daf)", R"(application/vnd.mobius.daf)" },
      { R"(dart)", R"(application/vnd.dart)" },
      { R"(dataless)", R"(application/vnd.fdsn.seed)" },
      { R"(davmount)", R"(application/davmount+xml)" },
      { R"(dbf)", R"(application/vnd.dbf)" },
      { R"(dbk)", R"(application/docbook+xml)" },
      { R"(dcm)", R"(application/dicom)" },
      { R"(dcmp)", R"(application/vnd.dcmp+xml)" },
      { R"(dcr)", R"(application/x-director)" },
      { R"(dcurl)", R"(text/vnd.curl.dcurl)" },
      { R"(dd2)", R"(application/vnd.oma.dd2+xml)" },
      { R"(ddd)", R"(application/vnd.fujixerox.ddd)" },
      { R"(ddf)", R"(application/vnd.syncml.dmddf+xml)" },
      { R"(dds)", R"(image/vnd.ms-dds)" },
      { R"(deb)", R"(application/x-debian-package)" },
      { R"(def)", R"(text/plain)" },
      { R"(deploy)", R"(application/octet-stream)" },
      { R"(der)", R"(application/x-x509-ca-cert)" },
      { R"(dfac)", R"(application/vnd.dreamfactory)" },
      { R"(dgc)", R"(application/x-dgc-compressed)" },
      { R"(dib)", R"(image/bmp)" },
      { R"(dic)", R"(text/x-c)" },
      { R"(dir)", R"(application/x-director)" },
      { R"(dis)", R"(application/vnd.mobius.dis)" },
      { R"(disposition-notification)", R"(message/disposition-notification)" },
      { R"(dist)", R"(application/octet-stream)" },
      { R"(distz)", R"(application/octet-stream)" },
      { R"(djv)", R"(image/vnd.djvu)" },
      { R"(djvu)", R"(image/vnd.djvu)" },
      { R"(dll)", R"(application/x-msdownload)" },
      { R"(dmg)", R"(application/x-apple-diskimage)" },
      { R"(dmp)", R"(application/vnd.tcpdump.pcap)" },
      { R"(dms)", R"(application/octet-stream)" },
      { R"(dna)", R"(application/vnd.dna)" },
      { R"(dng)", R"(image/x-adobe-dng)" },
      { R"(doc)", R"(application/msword)" },
      { R"(docm)", R"(application/vnd.ms-word.document.macroenabled.12)" },
      { R"(docx)", R"(application/vnd.openxmlformats-officedocument.wordprocessingml.document)" },
      { R"(dot)", R"(application/msword)" },
      { R"(dotm)", R"(application/vnd.ms-word.template.macroenabled.12)" },
      { R"(dotx)", R"(application/vnd.openxmlformats-officedocument.wordprocessingml.template)" },
      { R"(dp)", R"(application/vnd.osgi.dp)" },
      { R"(dpg)", R"(application/vnd.dpgraph)" },
      { R"(dpx)", R"(image/dpx)" },
      { R"(dra)", R"(audio/vnd.dra)" },
      { R"(drle)", R"(image/dicom-rle)" },
      { R"(drm)", R"(application/vnd.procreate.dream)" },
      { R"(dsc)", R"(text/prs.lines.tag)" },
      { R"(dssc)", R"(application/dssc+der)" },
      { R"(dtb)", R"(application/x-dtbook+xml)" },
      { R"(dtd)", R"(application/xml-dtd)" },
      { R"(dts)", R"(audio/vnd.dts)" },
      { R"(dtshd)", R"(audio/vnd.dts.hd)" },
      { R"(dump)", R"(application/octet-stream)" },
      { R"(dvb)", R"(video/vnd.dvb.file)" },
      { R"(dvi)", R"(application/x-dvi)" },
      { R"(dwd)", R"(application/atsc-dwd+xml)" },
      { R"(dwf)", R"(model/vnd.dwf)" },
      { R"(dwg)", R"(image/vnd.dwg)" },
      { R"(dxf)", R"(image/vnd.dxf)" },
      { R"(dxp)", R"(application/vnd.spotfire.dxp)" },
      { R"(dxr)", R"(application/x-director)" },
      { R"(ear)", R"(application/java-archive)" },
      { R"(ecelp4800)", R"(audio/vnd.nuera.ecelp4800)" },
      { R"(ecelp7470)", R"(audio/vnd.nuera.ecelp7470)" },
      { R"(ecelp9600)", R"(audio/vnd.nuera.ecelp9600)" },
      { R"(ecma)", R"(application/ecmascript)" },
      { R"(edm)", R"(application/vnd.novadigm.edm)" },
      { R"(edx)", R"(application/vnd.novadigm.edx)" },
      { R"(efif)", R"(application/vnd.picsel)" },
      { R"(ei6)", R"(application/vnd.pg.osasli)" },
      { R"(elc)", R"(application/octet-stream)" },
      { R"(emf)", R"(image/emf)" },
      { R"(eml)", R"(message/rfc822)" },
      { R"(emma)", R"(application/emma+xml)" },
      { R"(emotionml)", R"(application/emotionml+xml)" },
      { R"(emz)", R"(application/x-msmetafile)" },
      { R"(eol)", R"(audio/vnd.digital-winds)" },
      { R"(eot)", R"(application/vnd.ms-fontobject)" },
      { R"(eps)", R"(application/postscript)" },
      { R"(epub)", R"(application/epub+zip)" },
      { R"(es3)", R"(application/vnd.eszigno3+xml)" },
      { R"(esa)", R"(application/vnd.osgi.subsystem)" },
      { R"(esf)", R"(application/vnd.epson.esf)" },
      { R"(et3)", R"(application/vnd.eszigno3+xml)" },
      { R"(etx)", R"(text/x-setext)" },
      { R"(eva)", R"(application/x-eva)" },
      { R"(evy)", R"(application/x-envoy)" },
      { R"(exe)", R"(application/x-msdownload)" },
      { R"(exi)", R"(application/exi)" },
      { R"(exp)", R"(application/express)" },
      { R"(exr)", R"(image/aces)" },
      { R"(ext)", R"(application/vnd.novadigm.ext)" },
      { R"(ez)", R"(application/andrew-inset)" },
      { R"(ez2)", R"(application/vnd.ezpix-album)" },
      { R"(ez3)", R"(application/vnd.ezpix-package)" },
      { R"(f)", R"(text/x-fortran)" },
      { R"(f4v)", R"(video/x-f4v)" },
      { R"(f77)", R"(text/x-fortran)" },
      { R"(f90)", R"(text/x-fortran)" },
      { R"(fbs)", R"(image/vnd.fastbidsheet)" },
      { R"(fbx)", R"(application/vnd.autodesk.fbx)" },
      { R"(fcdt)", R"(application/vnd.adobe.formscentral.fcdt)" },
      { R"(fcs)", R"(application/vnd.isac.fcs)" },
      { R"(fdf)", R"(application/fdf)" },
      { R"(fdt)", R"(application/fdt+xml)" },
      { R"(fe_launch)", R"(application/vnd.denovo.fcselayout-link)" },
      { R"(fg5)", R"(application/vnd.fujitsu.oasysgp)" },
      { R"(fgd)", R"(application/x-director)" },
      { R"(fh)", R"(image/x-freehand)" },
      { R"(fh4)", R"(image/x-freehand)" },
      { R"(fh5)", R"(image/x-freehand)" },
      { R"(fh7)", R"(image/x-freehand)" },
      { R"(fhc)", R"(image/x-freehand)" },
      { R"(fig)", R"(application/x-xfig)" },
      { R"(fits)", R"(image/fits)" },
      { R"(flac)", R"(audio/x-flac)" },
      { R"(fli)", R"(video/x-fli)" },
      { R"(flo)", R"(application/vnd.micrografx.flo)" },
      { R"(flv)", R"(video/x-flv)" },
      { R"(flw)", R"(application/vnd.kde.kivio)" },
      { R"(flx)", R"(text/vnd.fmi.flexstor)" },
      { R"(fly)", R"(text/vnd.fly)" },
      { R"(fm)", R"(application/vnd.framemaker)" },
      { R"(fnc)", R"(application/vnd.frogans.fnc)" },
      { R"(fo)", R"(application/vnd.software602.filler.form+xml)" },
      { R"(for)", R"(text/x-fortran)" },
      { R"(fpx)", R"(image/vnd.fpx)" },
      { R"(frame)", R"(application/vnd.framemaker)" },
      { R"(fsc)", R"(application/vnd.fsc.weblaunch)" },
      { R"(fst)", R"(image/vnd.fst)" },
      { R"(ftc)", R"(application/vnd.fluxtime.clip)" },
      { R"(fti)", R"(application/vnd.anser-web-funds-transfer-initiation)" },
      { R"(fvt)", R"(video/vnd.fvt)" },
      { R"(fxp)", R"(application/vnd.adobe.fxp)" },
      { R"(fxpl)", R"(application/vnd.adobe.fxp)" },
      { R"(fzs)", R"(application/vnd.fuzzysheet)" },
      { R"(g2w)", R"(application/vnd.geoplan)" },
      { R"(g3)", R"(image/g3fax)" },
      { R"(g3w)", R"(application/vnd.geospace)" },
      { R"(gac)", R"(application/vnd.groove-account)" },
      { R"(gam)", R"(application/x-tads)" },
      { R"(gbr)", R"(application/rpki-ghostbusters)" },
      { R"(gca)", R"(application/x-gca-compressed)" },
      { R"(gdl)", R"(model/vnd.gdl)" },
      { R"(gdoc)", R"(application/vnd.google-apps.document)" },
      { R"(gdraw)", R"(application/vnd.google-apps.drawing)" },
      { R"(ged)", R"(text/vnd.familysearch.gedcom)" },
      { R"(geo)", R"(application/vnd.dynageo)" },
      { R"(geojson)", R"(application/geo+json)" },
      { R"(gex)", R"(application/vnd.geometry-explorer)" },
      { R"(gform)", R"(application/vnd.google-apps.form)" },
      { R"(ggb)", R"(application/vnd.geogebra.file)" },
      { R"(ggs)", R"(application/vnd.geogebra.slides)" },
      { R"(ggt)", R"(application/vnd.geogebra.tool)" },
      { R"(ghf)", R"(application/vnd.groove-help)" },
      { R"(gif)", R"(image/gif)" },
      { R"(gim)", R"(application/vnd.groove-identity-message)" },
      { R"(gjam)", R"(application/vnd.google-apps.jam)" },
      { R"(glb)", R"(model/gltf-binary)" },
      { R"(gltf)", R"(model/gltf+json)" },
      { R"(gmap)", R"(application/vnd.google-apps.map)" },
      { R"(gml)", R"(application/gml+xml)" },
      { R"(gmx)", R"(application/vnd.gmx)" },
      { R"(gnumeric)", R"(application/x-gnumeric)" },
      { R"(gph)", R"(application/vnd.flographit)" },
      { R"(gpx)", R"(application/gpx+xml)" },
      { R"(gqf)", R"(application/vnd.grafeq)" },
      { R"(gqs)", R"(application/vnd.grafeq)" },
      { R"(gram)", R"(application/srgs)" },
      { R"(gramps)", R"(application/x-gramps-xml)" },
      { R"(gre)", R"(application/vnd.geometry-explorer)" },
      { R"(grv)", R"(application/vnd.groove-injector)" },
      { R"(grxml)", R"(application/srgs+xml)" },
      { R"(gscript)", R"(application/vnd.google-apps.script)" },
      { R"(gsf)", R"(application/x-font-ghostscript)" },
      { R"(gsheet)", R"(application/vnd.google-apps.spreadsheet)" },
      { R"(gsite)", R"(application/vnd.google-apps.site)" },
      { R"(gslides)", R"(application/vnd.google-apps.presentation)" },
      { R"(gtar)", R"(application/x-gtar)" },
      { R"(gtm)", R"(application/vnd.groove-tool-message)" },
      { R"(gtw)", R"(model/vnd.gtw)" },
      { R"(gv)", R"(text/vnd.graphviz)" },
      { R"(gxf)", R"(application/gxf)" },
      { R"(gxt)", R"(application/vnd.geonext)" },
      { R"(gz)", R"(application/gzip)" },
      { R"(h)", R"(text/x-c)" },
      { R"(h261)", R"(video/h261)" },
      { R"(h263)", R"(video/h263)" },
      { R"(h264)", R"(video/h264)" },
      { R"(hal)", R"(application/vnd.hal+xml)" },
      { R"(hbci)", R"(application/vnd.hbci)" },
      { R"(hbs)", R"(text/x-handlebars-template)" },
      { R"(hdd)", R"(application/x-virtualbox-hdd)" },
      { R"(hdf)", R"(application/x-hdf)" },
      { R"(heic)", R"(image/heic)" },
      { R"(heics)", R"(image/heic-sequence)" },
      { R"(heif)", R"(image/heif)" },
      { R"(heifs)", R"(image/heif-sequence)" },
      { R"(hej2)", R"(image/hej2k)" },
      { R"(held)", R"(application/atsc-held+xml)" },
      { R"(hh)", R"(text/x-c)" },
      { R"(hjson)", R"(application/hjson)" },
      { R"(hlp)", R"(application/winhlp)" },
      { R"(hpgl)", R"(application/vnd.hp-hpgl)" },
      { R"(hpid)", R"(application/vnd.hp-hpid)" },
      { R"(hps)", R"(application/vnd.hp-hps)" },
      { R"(hqx)", R"(application/mac-binhex40)" },
      { R"(htc)", R"(text/x-component)" },
      { R"(htke)", R"(application/vnd.kenameaapp)" },
      { R"(htm)", R"(text/html)" },
      { R"(html)", R"(text/html)" },
      { R"(hvd)", R"(application/vnd.yamaha.hv-dic)" },
      { R"(hvp)", R"(application/vnd.yamaha.hv-voice)" },
      { R"(hvs)", R"(application/vnd.yamaha.hv-script)" },
      { R"(i2g)", R"(application/vnd.intergeo)" },
      { R"(icc)", R"(application/vnd.iccprofile)" },
      { R"(ice)", R"(x-conference/x-cooltalk)" },
      { R"(icm)", R"(application/vnd.iccprofile)" },
      { R"(ico)", R"(image/vnd.microsoft.icon)" },
      { R"(ics)", R"(text/calendar)" },
      { R"(ief)", R"(image/ief)" },
      { R"(ifb)", R"(text/calendar)" },
      { R"(ifm)", R"(application/vnd.shana.informed.formdata)" },
      { R"(iges)", R"(model/iges)" },
      { R"(igl)", R"(application/vnd.igloader)" },
      { R"(igm)", R"(application/vnd.insors.igm)" },
      { R"(igs)", R"(model/iges)" },
      { R"(igx)", R"(application/vnd.micrografx.igx)" },
      { R"(iif)", R"(application/vnd.shana.informed.interchange)" },
      { R"(img)", R"(application/octet-stream)" },
      { R"(imp)", R"(application/vnd.accpac.simply.imp)" },
      { R"(ims)", R"(application/vnd.ms-ims)" },
      { R"(in)", R"(text/plain)" },
      { R"(ini)", R"(text/plain)" },
      { R"(ink)", R"(application/inkml+xml)" },
      { R"(inkml)", R"(application/inkml+xml)" },
      { R"(install)", R"(application/x-install-instructions)" },
      { R"(iota)", R"(application/vnd.astraea-software.iota)" },
      { R"(ipfix)", R"(application/ipfix)" },
      { R"(ipk)", R"(application/vnd.shana.informed.package)" },
      { R"(ipynb)", R"(application/x-ipynb+json)" },
      { R"(irm)", R"(application/vnd.ibm.rights-management)" },
      { R"(irp)", R"(application/vnd.irepository.package+xml)" },
      { R"(iso)", R"(application/x-iso9660-image)" },
      { R"(itp)", R"(application/vnd.shana.informed.formtemplate)" },
      { R"(its)", R"(application/its+xml)" },
      { R"(ivp)", R"(application/vnd.immervision-ivp)" },
      { R"(ivu)", R"(application/vnd.immervision-ivu)" },
      { R"(jad)", R"(text/vnd.sun.j2me.app-descriptor)" },
      { R"(jade)", R"(text/jade)" },
      { R"(jaii)", R"(image/jaii)" },
      { R"(jais)", R"(image/jais)" },
      { R"(jam)", R"(application/vnd.jam)" },
      { R"(jar)", R"(application/java-archive)" },
      { R"(jardiff)", R"(application/x-java-archive-diff)" },
      { R"(java)", R"(text/x-java-source)" },
      { R"(jfif)", R"(image/pjpeg)" },
      { R"(jhc)", R"(image/jphc)" },
      { R"(jisp)", R"(application/vnd.jisp)" },
      { R"(jls)", R"(image/jls)" },
      { R"(jlt)", R"(application/vnd.hp-jlyt)" },
      { R"(jng)", R"(image/x-jng)" },
      { R"(jnlp)", R"(application/x-java-jnlp-file)" },
      { R"(joda)", R"(application/vnd.joost.joda-archive)" },
      { R"(jp2)", R"(image/jp2)" },
      { R"(jpe)", R"(image/jpeg)" },
      { R"(jpeg)", R"(image/jpeg)" },
      { R"(jpf)", R"(image/jpx)" },
      { R"(jpg)", R"(image/jpeg)" },
      { R"(jpg2)", R"(image/jp2)" },
      { R"(jpgm)", R"(image/jpm)" },
      { R"(jpgv)", R"(video/jpeg)" },
      { R"(jph)", R"(image/jph)" },
      { R"(jpm)", R"(image/jpm)" },
      { R"(jpx)", R"(image/jpx)" },
      { R"(js)", R"(text/javascript)" },
      { R"(json)", R"(application/json)" },
      { R"(json5)", R"(application/json5)" },
      { R"(jsonld)", R"(application/ld+json)" },
      { R"(jsonml)", R"(application/jsonml+json)" },
      { R"(jsx)", R"(text/jsx)" },
      { R"(jt)", R"(model/jt)" },
      { R"(jxl)", R"(image/jxl)" },
      { R"(jxr)", R"(image/jxr)" },
      { R"(jxra)", R"(image/jxra)" },
      { R"(jxrs)", R"(image/jxrs)" },
      { R"(jxs)", R"(image/jxs)" },
      { R"(jxsc)", R"(image/jxsc)" },
      { R"(jxsi)", R"(image/jxsi)" },
      { R"(jxss)", R"(image/jxss)" },
      { R"(kar)", R"(audio/midi)" },
      { R"(karbon)", R"(application/vnd.kde.karbon)" },
      { R"(kdbx)", R"(application/x-keepass2)" },
      { R"(key)", R"(application/vnd.apple.keynote)" },
      { R"(kfo)", R"(application/vnd.kde.kformula)" },
      { R"(kia)", R"(application/vnd.kidspiration)" },
      { R"(kml)", R"(application/vnd.google-earth.kml+xml)" },
      { R"(kmz)", R"(application/vnd.google-earth.kmz)" },
      { R"(kne)", R"(application/vnd.kinar)" },
      { R"(knp)", R"(application/vnd.kinar)" },
      { R"(kon)", R"(application/vnd.kde.kontour)" },
      { R"(kpr)", R"(application/vnd.kde.kpresenter)" },
      { R"(kpt)", R"(application/vnd.kde.kpresenter)" },
      { R"(kpxx)", R"(application/vnd.ds-keypoint)" },
      { R"(ksp)", R"(application/vnd.kde.kspread)" },
      { R"(ktr)", R"(application/vnd.kahootz)" },
      { R"(ktx)", R"(image/ktx)" },
      { R"(ktx2)", R"(image/ktx2)" },
      { R"(ktz)", R"(application/vnd.kahootz)" },
      { R"(kwd)", R"(application/vnd.kde.kword)" },
      { R"(kwt)", R"(application/vnd.kde.kword)" },
      { R"(lasxml)", R"(application/vnd.las.las+xml)" },
      { R"(latex)", R"(application/x-latex)" },
      { R"(lbd)", R"(application/vnd.llamagraphics.life-balance.desktop)" },
      { R"(lbe)", R"(application/vnd.llamagraphics.life-balance.exchange+xml)" },
      { R"(les)", R"(application/vnd.hhe.lesson-player)" },
      { R"(less)", R"(text/less)" },
      { R"(lgr)", R"(application/lgr+xml)" },
      { R"(lha)", R"(application/x-lzh-compressed)" },
      { R"(link66)", R"(application/vnd.route66.link66+xml)" },
      { R"(list)", R"(text/plain)" },
      { R"(list3820)", R"(application/vnd.ibm.modcap)" },
      { R"(listafp)", R"(application/vnd.ibm.modcap)" },
      { R"(litcoffee)", R"(text/coffeescript)" },
      { R"(lnk)", R"(application/x-ms-shortcut)" },
      { R"(log)", R"(text/plain)" },
      { R"(lostxml)", R"(application/lost+xml)" },
      { R"(lottie)", R"(application/zip+dotlottie)" },
      { R"(lrf)", R"(application/octet-stream)" },
      { R"(lrm)", R"(application/vnd.ms-lrm)" },
      { R"(ltf)", R"(application/vnd.frogans.ltf)" },
      { R"(lua)", R"(text/x-lua)" },
      { R"(luac)", R"(application/x-lua-bytecode)" },
      { R"(lvp)", R"(audio/vnd.lucent.voice)" },
      { R"(lwp)", R"(application/vnd.lotus-wordpro)" },
      { R"(lzh)", R"(application/x-lzh-compressed)" },
      { R"(m13)", R"(application/x-msmediaview)" },
      { R"(m14)", R"(application/x-msmediaview)" },
      { R"(m1v)", R"(video/mpeg)" },
      { R"(m21)", R"(application/mp21)" },
      { R"(m2a)", R"(audio/mpeg)" },
      { R"(m2t)", R"(video/mp2t)" },
      { R"(m2ts)", R"(video/mp2t)" },
      { R"(m2v)", R"(video/mpeg)" },
      { R"(m3a)", R"(audio/mpeg)" },
      { R"(m3u)", R"(audio/x-mpegurl)" },
      { R"(m3u8)", R"(application/vnd.apple.mpegurl)" },
      { R"(m4a)", R"(audio/mp4)" },
      { R"(m4b)", R"(audio/mp4)" },
      { R"(m4p)", R"(application/mp4)" },
      { R"(m4s)", R"(video/iso.segment)" },
      { R"(m4u)", R"(video/vnd.mpegurl)" },
      { R"(m4v)", R"(video/x-m4v)" },
      { R"(ma)", R"(application/mathematica)" },
      { R"(mads)", R"(application/mads+xml)" },
      { R"(maei)", R"(application/mmt-aei+xml)" },
      { R"(mag)", R"(application/vnd.ecowin.chart)" },
      { R"(maker)", R"(application/vnd.framemaker)" },
      { R"(man)", R"(text/troff)" },
      { R"(manifest)", R"(text/cache-manifest)" },
      { R"(map)", R"(application/json)" },
      { R"(mar)", R"(application/octet-stream)" },
      { R"(markdown)", R"(text/markdown)" },
      { R"(mathml)", R"(application/mathml+xml)" },
      { R"(mb)", R"(application/mathematica)" },
      { R"(mbk)", R"(application/vnd.mobius.mbk)" },
      { R"(mbox)", R"(application/mbox)" },
      { R"(mc1)", R"(application/vnd.medcalcdata)" },
      { R"(mcd)", R"(application/vnd.mcd)" },
      { R"(mcurl)", R"(text/vnd.curl.mcurl)" },
      { R"(md)", R"(text/markdown)" },
      { R"(mdb)", R"(application/x-msaccess)" },
      { R"(mdi)", R"(image/vnd.ms-modi)" },
      { R"(mdx)", R"(text/mdx)" },
      { R"(me)", R"(text/troff)" },
      { R"(mesh)", R"(model/mesh)" },
      { R"(meta4)", R"(application/metalink4+xml)" },
      { R"(metalink)", R"(application/metalink+xml)" },
      { R"(mets)", R"(application/mets+xml)" },
      { R"(mfm)", R"(application/vnd.mfmp)" },
      { R"(mft)", R"(application/rpki-manifest)" },
      { R"(mgp)", R"(application/vnd.osgeo.mapguide.package)" },
      { R"(mgz)", R"(application/vnd.proteus.magazine)" },
      { R"(mht)", R"(message/rfc822)" },
      { R"(mhtml)", R"(message/rfc822)" },
      { R"(mid)", R"(audio/midi)" },
      { R"(midi)", R"(audio/midi)" },
      { R"(mie)", R"(application/x-mie)" },
      { R"(mif)", R"(application/vnd.mif)" },
      { R"(mime)", R"(message/rfc822)" },
      { R"(mj2)", R"(video/mj2)" },
      { R"(mjp2)", R"(video/mj2)" },
      { R"(mjs)", R"(text/javascript)" },
      { R"(mk3d)", R"(video/x-matroska)" },
      { R"(mka)", R"(audio/x-matroska)" },
      { R"(mkd)", R"(text/x-markdown)" },
      { R"(mks)", R"(video/x-matroska)" },
      { R"(mkv)", R"(video/x-matroska)" },
      { R"(mlp)", R"(application/vnd.dolby.mlp)" },
      { R"(mmd)", R"(application/vnd.chipnuts.karaoke-mmd)" },
      { R"(mmf)", R"(application/vnd.smaf)" },
      { R"(mml)", R"(text/mathml)" },
      { R"(mmr)", R"(image/vnd.fujixerox.edmics-mmr)" },
      { R"(mng)", R"(video/x-mng)" },
      { R"(mny)", R"(application/x-msmoney)" },
      { R"(mobi)", R"(application/x-mobipocket-ebook)" },
      { R"(mods)", R"(application/mods+xml)" },
      { R"(mov)", R"(video/quicktime)" },
      { R"(movie)", R"(video/x-sgi-movie)" },
      { R"(mp2)", R"(audio/mpeg)" },
      { R"(mp21)", R"(application/mp21)" },
      { R"(mp2a)", R"(audio/mpeg)" },
      { R"(mp3)", R"(audio/mpeg)" },
      { R"(mp4)", R"(application/mp4)" },
      { R"(mp4a)", R"(audio/mp4)" },
      { R"(mp4s)", R"(application/mp4)" },
      { R"(mp4v)", R"(video/mp4)" },
      { R"(mpc)", R"(application/vnd.mophun.certificate)" },
      { R"(mpd)", R"(application/dash+xml)" },
      { R"(mpe)", R"(video/mpeg)" },
      { R"(mpeg)", R"(video/mpeg)" },
      { R"(mpf)", R"(application/media-policy-dataset+xml)" },
      { R"(mpg)", R"(video/mpeg)" },
      { R"(mpg4)", R"(application/mp4)" },
      { R"(mpga)", R"(audio/mpeg)" },
      { R"(mpkg)", R"(application/vnd.apple.installer+xml)" },
      { R"(mpm)", R"(application/vnd.blueice.multipass)" },
      { R"(mpn)", R"(application/vnd.mophun.application)" },
      { R"(mpp)", R"(application/dash-patch+xml)" },
      { R"(mpt)", R"(application/vnd.ms-project)" },
      { R"(mpy)", R"(application/vnd.ibm.minipay)" },
      { R"(mqy)", R"(application/vnd.mobius.mqy)" },
      { R"(mrc)", R"(application/marc)" },
      { R"(mrcx)", R"(application/marcxml+xml)" },
      { R"(ms)", R"(text/troff)" },
      { R"(mscml)", R"(application/mediaservercontrol+xml)" },
      { R"(mseed)", R"(application/vnd.fdsn.mseed)" },
      { R"(mseq)", R"(application/vnd.mseq)" },
      { R"(msf)", R"(application/vnd.epson.msf)" },
      { R"(msg)", R"(application/vnd.ms-outlook)" },
      { R"(msh)", R"(model/mesh)" },
      { R"(msi)", R"(application/x-msdownload)" },
      { R"(msix)", R"(application/msix)" },
      { R"(msixbundle)", R"(application/msixbundle)" },
      { R"(msl)", R"(application/vnd.mobius.msl)" },
      { R"(msm)", R"(application/octet-stream)" },
      { R"(msp)", R"(application/octet-stream)" },
      { R"(msty)", R"(application/vnd.muvee.style)" },
      { R"(mtl)", R"(model/mtl)" },
      { R"(mts)", R"(model/vnd.mts)" },
      { R"(mus)", R"(application/vnd.musician)" },
      { R"(musd)", R"(application/mmt-usd+xml)" },
      { R"(musicxml)", R"(application/vnd.recordare.musicxml+xml)" },
      { R"(mvb)", R"(application/x-msmediaview)" },
      { R"(mvt)", R"(application/vnd.mapbox-vector-tile)" },
      { R"(mwf)", R"(application/vnd.mfer)" },
      { R"(mxf)", R"(application/mxf)" },
      { R"(mxl)", R"(application/vnd.recordare.musicxml)" },
      { R"(mxmf)", R"(audio/mobile-xmf)" },
      { R"(mxml)", R"(application/xv+xml)" },
      { R"(mxs)", R"(application/vnd.triscape.mxs)" },
      { R"(mxu)", R"(video/vnd.mpegurl)" },
      { R"(n-gage)", R"(application/vnd.nokia.n-gage.symbian.install)" },
      { R"(n3)", R"(text/n3)" },
      { R"(nb)", R"(application/mathematica)" },
      { R"(nbp)", R"(application/vnd.wolfram.player)" },
      { R"(nc)", R"(application/x-netcdf)" },
      { R"(ncx)", R"(application/x-dtbncx+xml)" },
      { R"(nfo)", R"(text/x-nfo)" },
      { R"(ngdat)", R"(application/vnd.nokia.n-gage.data)" },
      { R"(nitf)", R"(application/vnd.nitf)" },
      { R"(nlu)", R"(application/vnd.neurolanguage.nlu)" },
      { R"(nml)", R"(application/vnd.enliven)" },
      { R"(nnd)", R"(application/vnd.noblenet-directory)" },
      { R"(nns)", R"(application/vnd.noblenet-sealer)" },
      { R"(nnw)", R"(application/vnd.noblenet-web)" },
      { R"(npx)", R"(image/vnd.net-fpx)" },
      { R"(nq)", R"(application/n-quads)" },
      { R"(nsc)", R"(application/x-conference)" },
      { R"(nsf)", R"(application/vnd.lotus-notes)" },
      { R"(nt)", R"(application/n-triples)" },
      { R"(ntf)", R"(application/vnd.nitf)" },
      { R"(numbers)", R"(application/vnd.apple.numbers)" },
      { R"(nzb)", R"(application/x-nzb)" },
      { R"(oa2)", R"(application/vnd.fujitsu.oasys2)" },
      { R"(oa3)", R"(application/vnd.fujitsu.oasys3)" },
      { R"(oas)", R"(application/vnd.fujitsu.oasys)" },
      { R"(obd)", R"(application/x-msbinder)" },
      { R"(obgx)", R"(application/vnd.openblox.game+xml)" },
      { R"(obj)", R"(model/obj)" },
      { R"(oda)", R"(application/oda)" },
      { R"(odb)", R"(application/vnd.oasis.opendocument.database)" },
      { R"(odc)", R"(application/vnd.oasis.opendocument.chart)" },
      { R"(odf)", R"(application/vnd.oasis.opendocument.formula)" },
      { R"(odft)", R"(application/vnd.oasis.opendocument.formula-template)" },
      { R"(odg)", R"(application/vnd.oasis.opendocument.graphics)" },
      { R"(odi)", R"(application/vnd.oasis.opendocument.image)" },
      { R"(odm)", R"(application/vnd.oasis.opendocument.text-master)" },
      { R"(odp)", R"(application/vnd.oasis.opendocument.presentation)" },
      { R"(ods)", R"(application/vnd.oasis.opendocument.spreadsheet)" },
      { R"(odt)", R"(application/vnd.oasis.opendocument.text)" },
      { R"(oga)", R"(audio/ogg)" },
      { R"(ogex)", R"(model/vnd.opengex)" },
      { R"(ogg)", R"(audio/ogg)" },
      { R"(ogv)", R"(video/ogg)" },
      { R"(ogx)", R"(application/ogg)" },
      { R"(omdoc)", R"(application/omdoc+xml)" },
      { R"(one)", R"(application/onenote)" },
      { R"(onea)", R"(application/onenote)" },
      { R"(onepkg)", R"(application/onenote)" },
      { R"(onetmp)", R"(application/onenote)" },
      { R"(onetoc)", R"(application/onenote)" },
      { R"(onetoc2)", R"(application/onenote)" },
      { R"(opf)", R"(application/oebps-package+xml)" },
      { R"(opml)", R"(text/x-opml)" },
      { R"(oprc)", R"(application/vnd.palm)" },
      { R"(opus)", R"(audio/ogg)" },
      { R"(org)", R"(application/vnd.lotus-organizer)" },
      { R"(osf)", R"(application/vnd.yamaha.openscoreformat)" },
      { R"(osfpvg)", R"(application/vnd.yamaha.openscoreformat.osfpvg+xml)" },
      { R"(osm)", R"(application/vnd.openstreetmap.data+xml)" },
      { R"(otc)", R"(application/vnd.oasis.opendocument.chart-template)" },
      { R"(otf)", R"(font/otf)" },
      { R"(otg)", R"(application/vnd.oasis.opendocument.graphics-template)" },
      { R"(oth)", R"(application/vnd.oasis.opendocument.text-web)" },
      { R"(oti)", R"(application/vnd.oasis.opendocument.image-template)" },
      { R"(otp)", R"(application/vnd.oasis.opendocument.presentation-template)" },
      { R"(ots)", R"(application/vnd.oasis.opendocument.spreadsheet-template)" },
      { R"(ott)", R"(application/vnd.oasis.opendocument.text-template)" },
      { R"(ova)", R"(application/x-virtualbox-ova)" },
      { R"(ovf)", R"(application/x-virtualbox-ovf)" },
      { R"(owl)", R"(application/rdf+xml)" },
      { R"(oxps)", R"(application/oxps)" },
      { R"(oxt)", R"(application/vnd.openofficeorg.extension)" },
      { R"(p)", R"(text/x-pascal)" },
      { R"(p10)", R"(application/pkcs10)" },
      { R"(p12)", R"(application/x-pkcs12)" },
      { R"(p21)", R"(model/step)" },
      { R"(p7b)", R"(application/x-pkcs7-certificates)" },
      { R"(p7c)", R"(application/pkcs7-mime)" },
      { R"(p7m)", R"(application/pkcs7-mime)" },
      { R"(p7r)", R"(application/x-pkcs7-certreqresp)" },
      { R"(p7s)", R"(application/pkcs7-signature)" },
      { R"(p8)", R"(application/pkcs8)" },
      { R"(pac)", R"(application/x-ns-proxy-autoconfig)" },
      { R"(pages)", R"(application/vnd.apple.pages)" },
      { R"(pas)", R"(text/x-pascal)" },
      { R"(paw)", R"(application/vnd.pawaafile)" },
      { R"(pbd)", R"(application/vnd.powerbuilder6)" },
      { R"(pbm)", R"(image/x-portable-bitmap)" },
      { R"(pcap)", R"(application/vnd.tcpdump.pcap)" },
      { R"(pcf)", R"(application/x-font-pcf)" },
      { R"(pcl)", R"(application/vnd.hp-pcl)" },
      { R"(pclxl)", R"(application/vnd.hp-pclxl)" },
      { R"(pct)", R"(image/x-pict)" },
      { R"(pcurl)", R"(application/vnd.curl.pcurl)" },
      { R"(pcx)", R"(image/vnd.zbrush.pcx)" },
      { R"(pdb)", R"(application/vnd.palm)" },
      { R"(pde)", R"(text/x-processing)" },
      { R"(pdf)", R"(application/pdf)" },
      { R"(pem)", R"(application/x-x509-ca-cert)" },
      { R"(pfa)", R"(application/x-font-type1)" },
      { R"(pfb)", R"(application/x-font-type1)" },
      { R"(pfm)", R"(application/x-font-type1)" },
      { R"(pfr)", R"(application/font-tdpfr)" },
      { R"(pfx)", R"(application/x-pkcs12)" },
      { R"(pgm)", R"(image/x-portable-graymap)" },
      { R"(pgn)", R"(application/x-chess-pgn)" },
      { R"(pgp)", R"(application/pgp-encrypted)" },
      { R"(php)", R"(application/x-httpd-php)" },
      { R"(pic)", R"(image/x-pict)" },
      { R"(pkg)", R"(application/octet-stream)" },
      { R"(pki)", R"(application/pkixcmp)" },
      { R"(pkipath)", R"(application/pkix-pkipath)" },
      { R"(pkpass)", R"(application/vnd.apple.pkpass)" },
      { R"(pl)", R"(application/x-perl)" },
      { R"(plb)", R"(application/vnd.3gpp.pic-bw-large)" },
      { R"(plc)", R"(application/vnd.mobius.plc)" },
      { R"(plf)", R"(application/vnd.pocketlearn)" },
      { R"(pls)", R"(application/pls+xml)" },
      { R"(pm)", R"(application/x-perl)" },
      { R"(pml)", R"(application/vnd.ctc-posml)" },
      { R"(png)", R"(image/png)" },
      { R"(pnm)", R"(image/x-portable-anymap)" },
      { R"(portpkg)", R"(application/vnd.macports.portpkg)" },
      { R"(pot)", R"(application/vnd.ms-powerpoint)" },
      { R"(potm)", R"(application/vnd.ms-powerpoint.template.macroenabled.12)" },
      { R"(potx)", R"(application/vnd.openxmlformats-officedocument.presentationml.template)" },
      { R"(ppam)", R"(application/vnd.ms-powerpoint.addin.macroenabled.12)" },
      { R"(ppd)", R"(application/vnd.cups-ppd)" },
      { R"(ppm)", R"(image/x-portable-pixmap)" },
      { R"(pps)", R"(application/vnd.ms-powerpoint)" },
      { R"(ppsm)", R"(application/vnd.ms-powerpoint.slideshow.macroenabled.12)" },
      { R"(ppsx)", R"(application/vnd.openxmlformats-officedocument.presentationml.slideshow)" },
      { R"(ppt)", R"(application/vnd.ms-powerpoint)" },
      { R"(pptm)", R"(application/vnd.ms-powerpoint.presentation.macroenabled.12)" },
      { R"(pptx)", R"(application/vnd.openxmlformats-officedocument.presentationml.presentation)" },
      { R"(pqa)", R"(application/vnd.palm)" },
      { R"(prc)", R"(model/prc)" },
      { R"(pre)", R"(application/vnd.lotus-freelance)" },
      { R"(prf)", R"(application/pics-rules)" },
      { R"(provx)", R"(application/provenance+xml)" },
      { R"(ps)", R"(application/postscript)" },
      { R"(psb)", R"(application/vnd.3gpp.pic-bw-small)" },
      { R"(psd)", R"(image/vnd.adobe.photoshop)" },
      { R"(psf)", R"(application/x-font-linux-psf)" },
      { R"(pskcxml)", R"(application/pskc+xml)" },
      { R"(pti)", R"(image/prs.pti)" },
      { R"(ptid)", R"(application/vnd.pvi.ptid1)" },
      { R"(pub)", R"(application/x-mspublisher)" },
      { R"(pvb)", R"(application/vnd.3gpp.pic-bw-var)" },
      { R"(pwn)", R"(application/vnd.3m.post-it-notes)" },
      { R"(pya)", R"(audio/vnd.ms-playready.media.pya)" },
      { R"(pyo)", R"(model/vnd.pytha.pyox)" },
      { R"(pyox)", R"(model/vnd.pytha.pyox)" },
      { R"(pyv)", R"(video/vnd.ms-playready.media.pyv)" },
      { R"(qam)", R"(application/vnd.epson.quickanime)" },
      { R"(qbo)", R"(application/vnd.intu.qbo)" },
      { R"(qfx)", R"(application/vnd.intu.qfx)" },
      { R"(qps)", R"(application/vnd.publishare-delta-tree)" },
      { R"(qt)", R"(video/quicktime)" },
      { R"(qwd)", R"(application/vnd.quark.quarkxpress)" },
      { R"(qwt)", R"(application/vnd.quark.quarkxpress)" },
      { R"(qxb)", R"(application/vnd.quark.quarkxpress)" },
      { R"(qxd)", R"(application/vnd.quark.quarkxpress)" },
      { R"(qxl)", R"(application/vnd.quark.quarkxpress)" },
      { R"(qxt)", R"(application/vnd.quark.quarkxpress)" },
      { R"(ra)", R"(audio/x-pn-realaudio)" },
      { R"(ram)", R"(audio/x-pn-realaudio)" },
      { R"(raml)", R"(application/raml+yaml)" },
      { R"(rapd)", R"(application/route-apd+xml)" },
      { R"(rar)", R"(application/vnd.rar)" },
      { R"(ras)", R"(image/x-cmu-raster)" },
      { R"(rcprofile)", R"(application/vnd.ipunplugged.rcprofile)" },
      { R"(rdf)", R"(application/rdf+xml)" },
      { R"(rdz)", R"(application/vnd.data-vision.rdz)" },
      { R"(relo)", R"(application/p2p-overlay+xml)" },
      { R"(rep)", R"(application/vnd.businessobjects)" },
      { R"(res)", R"(application/x-dtbresource+xml)" },
      { R"(rgb)", R"(image/x-rgb)" },
      { R"(rif)", R"(application/reginfo+xml)" },
      { R"(rip)", R"(audio/vnd.rip)" },
      { R"(ris)", R"(application/x-research-info-systems)" },
      { R"(rl)", R"(application/resource-lists+xml)" },
      { R"(rlc)", R"(image/vnd.fujixerox.edmics-rlc)" },
      { R"(rld)", R"(application/resource-lists-diff+xml)" },
      { R"(rm)", R"(application/vnd.rn-realmedia)" },
      { R"(rmi)", R"(audio/midi)" },
      { R"(rmp)", R"(audio/x-pn-realaudio-plugin)" },
      { R"(rms)", R"(application/vnd.jcp.javame.midlet-rms)" },
      { R"(rmvb)", R"(application/vnd.rn-realmedia-vbr)" },
      { R"(rnc)", R"(application/relax-ng-compact-syntax)" },
      { R"(rng)", R"(application/xml)" },
      { R"(roa)", R"(application/rpki-roa)" },
      { R"(roff)", R"(text/troff)" },
      { R"(rp9)", R"(application/vnd.cloanto.rp9)" },
      { R"(rpm)", R"(application/x-redhat-package-manager)" },
      { R"(rpss)", R"(application/vnd.nokia.radio-presets)" },
      { R"(rpst)", R"(application/vnd.nokia.radio-preset)" },
      { R"(rq)", R"(application/sparql-query)" },
      { R"(rs)", R"(application/rls-services+xml)" },
      { R"(rsat)", R"(application/atsc-rsat+xml)" },
      { R"(rsd)", R"(application/rsd+xml)" },
      { R"(rsheet)", R"(application/urc-ressheet+xml)" },
      { R"(rss)", R"(application/rss+xml)" },
      { R"(rtf)", R"(application/rtf)" },
      { R"(rtx)", R"(text/richtext)" },
      { R"(run)", R"(application/x-makeself)" },
      { R"(rusd)", R"(application/route-usd+xml)" },
      { R"(s)", R"(text/x-asm)" },
      { R"(s3m)", R"(audio/s3m)" },
      { R"(saf)", R"(application/vnd.yamaha.smaf-audio)" },
      { R"(sass)", R"(text/x-sass)" },
      { R"(sbml)", R"(application/sbml+xml)" },
      { R"(sc)", R"(application/vnd.ibm.secure-container)" },
      { R"(scd)", R"(application/x-msschedule)" },
      { R"(scm)", R"(application/vnd.lotus-screencam)" },
      { R"(scq)", R"(application/scvp-cv-request)" },
      { R"(scs)", R"(application/scvp-cv-response)" },
      { R"(scss)", R"(text/x-scss)" },
      { R"(scurl)", R"(text/vnd.curl.scurl)" },
      { R"(sda)", R"(application/vnd.stardivision.draw)" },
      { R"(sdc)", R"(application/vnd.stardivision.calc)" },
      { R"(sdd)", R"(application/vnd.stardivision.impress)" },
      { R"(sdkd)", R"(application/vnd.solent.sdkm+xml)" },
      { R"(sdkm)", R"(application/vnd.solent.sdkm+xml)" },
      { R"(sdp)", R"(application/sdp)" },
      { R"(sdw)", R"(application/vnd.stardivision.writer)" },
      { R"(sea)", R"(application/x-sea)" },
      { R"(see)", R"(application/vnd.seemail)" },
      { R"(seed)", R"(application/vnd.fdsn.seed)" },
      { R"(sema)", R"(application/vnd.sema)" },
      { R"(semd)", R"(application/vnd.semd)" },
      { R"(semf)", R"(application/vnd.semf)" },
      { R"(senmlx)", R"(application/senml+xml)" },
      { R"(sensmlx)", R"(application/sensml+xml)" },
      { R"(ser)", R"(application/java-serialized-object)" },
      { R"(setpay)", R"(application/set-payment-initiation)" },
      { R"(setreg)", R"(application/set-registration-initiation)" },
      { R"(sfd-hdstx)", R"(application/vnd.hydrostatix.sof-data)" },
      { R"(sfs)", R"(application/vnd.spotfire.sfs)" },
      { R"(sfv)", R"(text/x-sfv)" },
      { R"(sgi)", R"(image/sgi)" },
      { R"(sgl)", R"(application/vnd.stardivision.writer-global)" },
      { R"(sgm)", R"(text/sgml)" },
      { R"(sgml)", R"(text/sgml)" },
      { R"(sh)", R"(application/x-sh)" },
      { R"(shar)", R"(application/x-shar)" },
      { R"(shex)", R"(text/shex)" },
      { R"(shf)", R"(application/shf+xml)" },
      { R"(shtml)", R"(text/html)" },
      { R"(sid)", R"(image/x-mrsid-image)" },
      { R"(sieve)", R"(application/sieve)" },
      { R"(sig)", R"(application/pgp-signature)" },
      { R"(sil)", R"(audio/silk)" },
      { R"(silo)", R"(model/mesh)" },
      { R"(sis)", R"(application/vnd.symbian.install)" },
      { R"(sisx)", R"(application/vnd.symbian.install)" },
      { R"(sit)", R"(application/x-stuffit)" },
      { R"(sitx)", R"(application/x-stuffitx)" },
      { R"(siv)", R"(application/sieve)" },
      { R"(skd)", R"(application/vnd.koan)" },
      { R"(skm)", R"(application/vnd.koan)" },
      { R"(skp)", R"(application/vnd.koan)" },
      { R"(skt)", R"(application/vnd.koan)" },
      { R"(sldm)", R"(application/vnd.ms-powerpoint.slide.macroenabled.12)" },
      { R"(sldx)", R"(application/vnd.openxmlformats-officedocument.presentationml.slide)" },
      { R"(slim)", R"(text/slim)" },
      { R"(slm)", R"(text/slim)" },
      { R"(sls)", R"(application/route-s-tsid+xml)" },
      { R"(slt)", R"(application/vnd.epson.salt)" },
      { R"(sm)", R"(application/vnd.stepmania.stepchart)" },
      { R"(smf)", R"(application/vnd.stardivision.math)" },
      { R"(smi)", R"(application/smil+xml)" },
      { R"(smil)", R"(application/smil+xml)" },
      { R"(smv)", R"(video/x-smv)" },
      { R"(smzip)", R"(application/vnd.stepmania.package)" },
      { R"(snd)", R"(audio/basic)" },
      { R"(snf)", R"(application/x-font-snf)" },
      { R"(so)", R"(application/octet-stream)" },
      { R"(spc)", R"(application/x-pkcs7-certificates)" },
      { R"(spdx)", R"(text/spdx)" },
      { R"(spf)", R"(application/vnd.yamaha.smaf-phrase)" },
      { R"(spl)", R"(application/x-futuresplash)" },
      { R"(spot)", R"(text/vnd.in3d.spot)" },
      { R"(spp)", R"(application/scvp-vp-response)" },
      { R"(spq)", R"(application/scvp-vp-request)" },
      { R"(spx)", R"(audio/ogg)" },
      { R"(sql)", R"(application/sql)" },
      { R"(src)", R"(application/x-wais-source)" },
      { R"(srt)", R"(application/x-subrip)" },
      { R"(sru)", R"(application/sru+xml)" },
      { R"(srx)", R"(application/sparql-results+xml)" },
      { R"(ssdl)", R"(application/ssdl+xml)" },
      { R"(sse)", R"(application/vnd.kodak-descriptor)" },
      { R"(ssf)", R"(application/vnd.epson.ssf)" },
      { R"(ssml)", R"(application/ssml+xml)" },
      { R"(st)", R"(application/vnd.sailingtracker.track)" },
      { R"(stc)", R"(application/vnd.sun.xml.calc.template)" },
      { R"(std)", R"(application/vnd.sun.xml.draw.template)" },
      { R"(step)", R"(model/step)" },
      { R"(stf)", R"(application/vnd.wt.stf)" },
      { R"(sti)", R"(application/vnd.sun.xml.impress.template)" },
      { R"(stk)", R"(application/hyperstudio)" },
      { R"(stl)", R"(model/stl)" },
      { R"(stp)", R"(model/step)" },
      { R"(stpnc)", R"(model/step)" },
      { R"(stpx)", R"(model/step+xml)" },
      { R"(stpxz)", R"(model/step-xml+zip)" },
      { R"(stpz)", R"(model/step+zip)" },
      { R"(str)", R"(application/vnd.pg.format)" },
      { R"(stw)", R"(application/vnd.sun.xml.writer.template)" },
      { R"(styl)", R"(text/stylus)" },
      { R"(stylus)", R"(text/stylus)" },
      { R"(sub)", R"(image/vnd.dvb.subtitle)" },
      { R"(sus)", R"(application/vnd.sus-calendar)" },
      { R"(susp)", R"(application/vnd.sus-calendar)" },
      { R"(sv4cpio)", R"(application/x-sv4cpio)" },
      { R"(sv4crc)", R"(application/x-sv4crc)" },
      { R"(svc)", R"(application/vnd.dvb.service)" },
      { R"(svd)", R"(application/vnd.svd)" },
      { R"(svg)", R"(image/svg+xml)" },
      { R"(svgz)", R"(image/svg+xml)" },
      { R"(swa)", R"(application/x-director)" },
      { R"(swf)", R"(application/x-shockwave-flash)" },
      { R"(swi)", R"(application/vnd.aristanetworks.swi)" },
      { R"(swidtag)", R"(application/swid+xml)" },
      { R"(sxc)", R"(application/vnd.sun.xml.calc)" },
      { R"(sxd)", R"(application/vnd.sun.xml.draw)" },
      { R"(sxg)", R"(application/vnd.sun.xml.writer.global)" },
      { R"(sxi)", R"(application/vnd.sun.xml.impress)" },
      { R"(sxm)", R"(application/vnd.sun.xml.math)" },
      { R"(sxw)", R"(application/vnd.sun.xml.writer)" },
      { R"(t)", R"(text/troff)" },
      { R"(t3)", R"(application/x-t3vm-image)" },
      { R"(t38)", R"(image/t38)" },
      { R"(taglet)", R"(application/vnd.mynfc)" },
      { R"(tao)", R"(application/vnd.tao.intent-module-archive)" },
      { R"(tap)", R"(image/vnd.tencent.tap)" },
      { R"(tar)", R"(application/x-tar)" },
      { R"(tcap)", R"(application/vnd.3gpp2.tcap)" },
      { R"(tcl)", R"(application/x-tcl)" },
      { R"(td)", R"(application/urc-targetdesc+xml)" },
      { R"(teacher)", R"(application/vnd.smart.teacher)" },
      { R"(tei)", R"(application/tei+xml)" },
      { R"(teicorpus)", R"(application/tei+xml)" },
      { R"(tex)", R"(application/x-tex)" },
      { R"(texi)", R"(application/x-texinfo)" },
      { R"(texinfo)", R"(application/x-texinfo)" },
      { R"(text)", R"(text/plain)" },
      { R"(tfi)", R"(application/thraud+xml)" },
      { R"(tfm)", R"(application/x-tex-tfm)" },
      { R"(tfx)", R"(image/tiff-fx)" },
      { R"(tga)", R"(image/x-tga)" },
      { R"(thmx)", R"(application/vnd.ms-officetheme)" },
      { R"(tif)", R"(image/tiff)" },
      { R"(tiff)", R"(image/tiff)" },
      { R"(tk)", R"(application/x-tcl)" },
      { R"(tmo)", R"(application/vnd.tmobile-livetv)" },
      { R"(toml)", R"(application/toml)" },
      { R"(torrent)", R"(application/x-bittorrent)" },
      { R"(tpl)", R"(application/vnd.groove-tool-template)" },
      { R"(tpt)", R"(application/vnd.trid.tpt)" },
      { R"(tr)", R"(text/troff)" },
      { R"(tra)", R"(application/vnd.trueapp)" },
      { R"(trig)", R"(application/trig)" },
      { R"(trm)", R"(application/x-msterminal)" },
      { R"(ts)", R"(video/mp2t)" },
      { R"(tsd)", R"(application/timestamped-data)" },
      { R"(tsv)", R"(text/tab-separated-values)" },
      { R"(ttc)", R"(font/collection)" },
      { R"(ttf)", R"(font/ttf)" },
      { R"(ttl)", R"(text/turtle)" },
      { R"(ttml)", R"(application/ttml+xml)" },
      { R"(twd)", R"(application/vnd.simtech-mindmapper)" },
      { R"(twds)", R"(application/vnd.simtech-mindmapper)" },
      { R"(txd)", R"(application/vnd.genomatix.tuxedo)" },
      { R"(txf)", R"(application/vnd.mobius.txf)" },
      { R"(txt)", R"(text/plain)" },
      { R"(u32)", R"(application/x-authorware-bin)" },
      { R"(u3d)", R"(model/u3d)" },
      { R"(u8dsn)", R"(message/global-delivery-status)" },
      { R"(u8hdr)", R"(message/global-headers)" },
      { R"(u8mdn)", R"(message/global-disposition-notification)" },
      { R"(u8msg)", R"(message/global)" },
      { R"(ubj)", R"(application/ubjson)" },
      { R"(udeb)", R"(application/x-debian-package)" },
      { R"(ufd)", R"(application/vnd.ufdl)" },
      { R"(ufdl)", R"(application/vnd.ufdl)" },
      { R"(ulx)", R"(application/x-glulx)" },
      { R"(umj)", R"(application/vnd.umajin)" },
      { R"(unityweb)", R"(application/vnd.unity)" },
      { R"(uo)", R"(application/vnd.uoml+xml)" },
      { R"(uoml)", R"(application/vnd.uoml+xml)" },
      { R"(uri)", R"(text/uri-list)" },
      { R"(uris)", R"(text/uri-list)" },
      { R"(urls)", R"(text/uri-list)" },
      { R"(usda)", R"(model/vnd.usda)" },
      { R"(usdz)", R"(model/vnd.usdz+zip)" },
      { R"(ustar)", R"(application/x-ustar)" },
      { R"(utz)", R"(application/vnd.uiq.theme)" },
      { R"(uu)", R"(text/x-uuencode)" },
      { R"(uva)", R"(audio/vnd.dece.audio)" },
      { R"(uvd)", R"(application/vnd.dece.data)" },
      { R"(uvf)", R"(application/vnd.dece.data)" },
      { R"(uvg)", R"(image/vnd.dece.graphic)" },
      { R"(uvh)", R"(video/vnd.dece.hd)" },
      { R"(uvi)", R"(image/vnd.dece.graphic)" },
      { R"(uvm)", R"(video/vnd.dece.mobile)" },
      { R"(uvp)", R"(video/vnd.dece.pd)" },
      { R"(uvs)", R"(video/vnd.dece.sd)" },
      { R"(uvt)", R"(application/vnd.dece.ttml+xml)" },
      { R"(uvu)", R"(video/vnd.uvvu.mp4)" },
      { R"(uvv)", R"(video/vnd.dece.video)" },
      { R"(uvva)", R"(audio/vnd.dece.audio)" },
      { R"(uvvd)", R"(application/vnd.dece.data)" },
      { R"(uvvf)", R"(application/vnd.dece.data)" },
      { R"(uvvg)", R"(image/vnd.dece.graphic)" },
      { R"(uvvh)", R"(video/vnd.dece.hd)" },
      { R"(uvvi)", R"(image/vnd.dece.graphic)" },
      { R"(uvvm)", R"(video/vnd.dece.mobile)" },
      { R"(uvvp)", R"(video/vnd.dece.pd)" },
      { R"(uvvs)", R"(video/vnd.dece.sd)" },
      { R"(uvvt)", R"(application/vnd.dece.ttml+xml)" },
      { R"(uvvu)", R"(video/vnd.uvvu.mp4)" },
      { R"(uvvv)", R"(video/vnd.dece.video)" },
      { R"(uvvx)", R"(application/vnd.dece.unspecified)" },
      { R"(uvvz)", R"(application/vnd.dece.zip)" },
      { R"(uvx)", R"(application/vnd.dece.unspecified)" },
      { R"(uvz)", R"(application/vnd.dece.zip)" },
      { R"(vbox)", R"(application/x-virtualbox-vbox)" },
      { R"(vbox-extpack)", R"(application/x-virtualbox-vbox-extpack)" },
      { R"(vcard)", R"(text/vcard)" },
      { R"(vcd)", R"(application/x-cdlink)" },
      { R"(vcf)", R"(text/x-vcard)" },
      { R"(vcg)", R"(application/vnd.groove-vcard)" },
      { R"(vcs)", R"(text/x-vcalendar)" },
      { R"(vcx)", R"(application/vnd.vcx)" },
      { R"(vdi)", R"(application/x-virtualbox-vdi)" },
      { R"(vds)", R"(model/vnd.sap.vds)" },
      { R"(vdx)", R"(application/vnd.ms-visio.viewer)" },
      { R"(vhd)", R"(application/x-virtualbox-vhd)" },
      { R"(vis)", R"(application/vnd.visionary)" },
      { R"(viv)", R"(video/vnd.vivo)" },
      { R"(vmdk)", R"(application/x-virtualbox-vmdk)" },
      { R"(vob)", R"(video/x-ms-vob)" },
      { R"(vor)", R"(application/vnd.stardivision.writer)" },
      { R"(vox)", R"(application/x-authorware-bin)" },
      { R"(vrml)", R"(model/vrml)" },
      { R"(vsd)", R"(application/vnd.visio)" },
      { R"(vsdx)", R"(application/vnd.visio)" },
      { R"(vsf)", R"(application/vnd.vsf)" },
      { R"(vss)", R"(application/vnd.visio)" },
      { R"(vst)", R"(application/vnd.visio)" },
      { R"(vsw)", R"(application/vnd.visio)" },
      { R"(vtf)", R"(image/vnd.valve.source.texture)" },
      { R"(vtt)", R"(text/vtt)" },
      { R"(vtu)", R"(model/vnd.vtu)" },
      { R"(vtx)", R"(application/vnd.visio)" },
      { R"(vxml)", R"(application/voicexml+xml)" },
      { R"(w3d)", R"(application/x-director)" },
      { R"(wad)", R"(application/x-doom)" },
      { R"(wadl)", R"(application/vnd.sun.wadl+xml)" },
      { R"(war)", R"(application/java-archive)" },
      { R"(wasm)", R"(application/wasm)" },
      { R"(wav)", R"(audio/x-wav)" },
      { R"(wax)", R"(audio/x-ms-wax)" },
      { R"(wbmp)", R"(image/vnd.wap.wbmp)" },
      { R"(wbs)", R"(application/vnd.criticaltools.wbs+xml)" },
      { R"(wbxml)", R"(application/vnd.wap.wbxml)" },
      { R"(wcm)", R"(application/vnd.ms-works)" },
      { R"(wdb)", R"(application/vnd.ms-works)" },
      { R"(wdp)", R"(image/vnd.ms-photo)" },
      { R"(weba)", R"(audio/webm)" },
      { R"(webapp)", R"(application/x-web-app-manifest+json)" },
      { R"(webm)", R"(video/webm)" },
      { R"(webmanifest)", R"(application/manifest+json)" },
      { R"(webp)", R"(image/webp)" },
      { R"(wg)", R"(application/vnd.pmi.widget)" },
      { R"(wgsl)", R"(text/wgsl)" },
      { R"(wgt)", R"(application/widget)" },
      { R"(wif)", R"(application/watcherinfo+xml)" },
      { R"(wks)", R"(application/vnd.ms-works)" },
      { R"(wm)", R"(video/x-ms-wm)" },
      { R"(wma)", R"(audio/x-ms-wma)" },
      { R"(wmd)", R"(application/x-ms-wmd)" },
      { R"(wmf)", R"(image/wmf)" },
      { R"(wml)", R"(text/vnd.wap.wml)" },
      { R"(wmlc)", R"(application/vnd.wap.wmlc)" },
      { R"(wmls)", R"(text/vnd.wap.wmlscript)" },
      { R"(wmlsc)", R"(application/vnd.wap.wmlscriptc)" },
      { R"(wmv)", R"(video/x-ms-wmv)" },
      { R"(wmx)", R"(video/x-ms-wmx)" },
      { R"(wmz)", R"(application/x-ms-wmz)" },
      { R"(woff)", R"(font/woff)" },
      { R"(woff2)", R"(font/woff2)" },
      { R"(wpd)", R"(application/vnd.wordperfect)" },
      { R"(wpl)", R"(application/vnd.ms-wpl)" },
      { R"(wps)", R"(application/vnd.ms-works)" },
      { R"(wqd)", R"(application/vnd.wqd)" },
      { R"(wri)", R"(application/x-mswrite)" },
      { R"(wrl)", R"(model/vrml)" },
      { R"(wsc)", R"(message/vnd.wfa.wsc)" },
      { R"(wsdl)", R"(application/wsdl+xml)" },
      { R"(wspolicy)", R"(application/wspolicy+xml)" },
      { R"(wtb)", R"(application/vnd.webturbo)" },
      { R"(wvx)", R"(video/x-ms-wvx)" },
      { R"(x_b)", R"(model/vnd.parasolid.transmit.binary)" },
      { R"(x_t)", R"(model/vnd.parasolid.transmit.text)" },
      { R"(x32)", R"(application/x-authorware-bin)" },
      { R"(x3d)", R"(model/x3d+xml)" },
      { R"(x3db)", R"(model/x3d+fastinfoset)" },
      { R"(x3dbz)", R"(model/x3d+binary)" },
      { R"(x3dv)", R"(model/x3d-vrml)" },
      { R"(x3dvz)", R"(model/x3d+vrml)" },
      { R"(x3dz)", R"(model/x3d+xml)" },
      { R"(xaml)", R"(application/xaml+xml)" },
      { R"(xap)", R"(application/x-silverlight-app)" },
      { R"(xar)", R"(application/vnd.xara)" },
      { R"(xav)", R"(application/xcap-att+xml)" },
      { R"(xbap)", R"(application/x-ms-xbap)" },
      { R"(xbd)", R"(application/vnd.fujixerox.docuworks.binder)" },
      { R"(xbm)", R"(image/x-xbitmap)" },
      { R"(xca)", R"(application/xcap-caps+xml)" },
      { R"(xcs)", R"(application/calendar+xml)" },
      { R"(xdcf)", R"(application/vnd.gov.sk.xmldatacontainer+xml)" },
      { R"(xdf)", R"(application/xcap-diff+xml)" },
      { R"(xdm)", R"(application/vnd.syncml.dm+xml)" },
      { R"(xdp)", R"(application/vnd.adobe.xdp+xml)" },
      { R"(xdssc)", R"(application/dssc+xml)" },
      { R"(xdw)", R"(application/vnd.fujixerox.docuworks)" },
      { R"(xel)", R"(application/xcap-el+xml)" },
      { R"(xenc)", R"(application/xenc+xml)" },
      { R"(xer)", R"(application/patch-ops-error+xml)" },
      { R"(xfdf)", R"(application/xfdf)" },
      { R"(xfdl)", R"(application/vnd.xfdl)" },
      { R"(xht)", R"(application/xhtml+xml)" },
      { R"(xhtm)", R"(application/vnd.pwg-xhtml-print+xml)" },
      { R"(xhtml)", R"(application/xhtml+xml)" },
      { R"(xhvml)", R"(application/xv+xml)" },
      { R"(xif)", R"(image/vnd.xiff)" },
      { R"(xla)", R"(application/vnd.ms-excel)" },
      { R"(xlam)", R"(application/vnd.ms-excel.addin.macroenabled.12)" },
      { R"(xlc)", R"(application/vnd.ms-excel)" },
      { R"(xlf)", R"(application/xliff+xml)" },
      { R"(xlm)", R"(application/vnd.ms-excel)" },
      { R"(xls)", R"(application/vnd.ms-excel)" },
      { R"(xlsb)", R"(application/vnd.ms-excel.sheet.binary.macroenabled.12)" },
      { R"(xlsm)", R"(application/vnd.ms-excel.sheet.macroenabled.12)" },
      { R"(xlsx)", R"(application/vnd.openxmlformats-officedocument.spreadsheetml.sheet)" },
      { R"(xlt)", R"(application/vnd.ms-excel)" },
      { R"(xltm)", R"(application/vnd.ms-excel.template.macroenabled.12)" },
      { R"(xltx)", R"(application/vnd.openxmlformats-officedocument.spreadsheetml.template)" },
      { R"(xlw)", R"(application/vnd.ms-excel)" },
      { R"(xm)", R"(audio/xm)" },
      { R"(xml)", R"(application/xml)" },
      { R"(xns)", R"(application/xcap-ns+xml)" },
      { R"(xo)", R"(application/vnd.olpc-sugar)" },
      { R"(xop)", R"(application/xop+xml)" },
      { R"(xpi)", R"(application/x-xpinstall)" },
      { R"(xpl)", R"(application/xproc+xml)" },
      { R"(xpm)", R"(image/x-xpixmap)" },
      { R"(xpr)", R"(application/vnd.is-xpr)" },
      { R"(xps)", R"(application/vnd.ms-xpsdocument)" },
      { R"(xpw)", R"(application/vnd.intercon.formnet)" },
      { R"(xpx)", R"(application/vnd.intercon.formnet)" },
      { R"(xsd)", R"(application/xml)" },
      { R"(xsf)", R"(application/prs.xsf+xml)" },
      { R"(xsl)", R"(application/xml)" },
      { R"(xslt)", R"(application/xslt+xml)" },
      { R"(xsm)", R"(application/vnd.syncml+xml)" },
      { R"(xspf)", R"(application/xspf+xml)" },
      { R"(xul)", R"(application/vnd.mozilla.xul+xml)" },
      { R"(xvm)", R"(application/xv+xml)" },
      { R"(xvml)", R"(application/xv+xml)" },
      { R"(xwd)", R"(image/x-xwindowdump)" },
      { R"(xyz)", R"(chemical/x-xyz)" },
      { R"(xz)", R"(application/x-xz)" },
      { R"(yaml)", R"(text/yaml)" },
      { R"(yang)", R"(application/yang)" },
      { R"(yin)", R"(application/yin+xml)" },
      { R"(yml)", R"(text/yaml)" },
      { R"(ymp)", R"(text/x-suse-ymp)" },
      { R"(z1)", R"(application/x-zmachine)" },
      { R"(z2)", R"(application/x-zmachine)" },
      { R"(z3)", R"(application/x-zmachine)" },
      { R"(z4)", R"(application/x-zmachine)" },
      { R"(z5)", R"(application/x-zmachine)" },
      { R"(z6)", R"(application/x-zmachine)" },
      { R"(z7)", R"(application/x-zmachine)" },
      { R"(z8)", R"(application/x-zmachine)" },
      { R"(zaz)", R"(application/vnd.zzazz.deck+xml)" },
      { R"(zip)", R"(application/zip)" },
      { R"(zir)", R"(application/vnd.zul)" },
      { R"(zirz)", R"(application/vnd.zul)" },
      { R"(zmm)", R"(application/vnd.handheld-entertainment+xml)" } }
};
