package functions

import (
	"fmt"
	"slices"
	"strings"
)

func Contains(args ...any) any {

	if len(args) != 2 {
		return false
	}

	container := args[0]
	itemToFind := args[1]

	switch cType := container.(type) {
	case string:
		switch iType := itemToFind.(type) {
		case string:
			return strings.Contains(strings.ToLower(cType), strings.ToLower(iType))
		case int, int32, int64, uint, uint32, uint64:
			return strings.Contains(strings.ToLower(cType), fmt.Sprintf("%d", iType))
		}
	case []any:
		return slices.Contains(cType, itemToFind)
	case map[string]any:
		for key := range cType {
			if key == itemToFind {
				return true
			}
		}
	}

	return false
}
