/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerInflaterRegistry;
import com.paterva.maltego.view.customization.api.Customizable;
import com.paterva.maltego.view.customization.api.CustomizableRegistry;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.CustomizableViewUpdater;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import yguard.A.A.E;
import yguard.A.A.Y;
import yguard.A.J.SA;

public class BallCustomizableView
implements CustomizableView {
    public static final String CUSTOMIZABLE_VIEW_ID = "BallView";
    private final GraphID _graphID;
    private String _viewlet = null;
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);

    public BallCustomizableView(GraphID graphID) {
        this._graphID = graphID;
    }

    public String getCustomizableViewID() {
        return CUSTOMIZABLE_VIEW_ID;
    }

    public String getActiveViewlet() {
        return this._viewlet;
    }

    public void setActiveViewlet(String name) {
        if (!Objects.equals(name, this._viewlet)) {
            this._viewlet = name;
            this.loadViewlet();
        }
    }

    public void reloadActiveViewlet() {
        if (this._viewlet != null) {
            this.loadViewlet();
        }
    }

    private void loadViewlet() {
        SA graph = (SA)MaltegoGraphManager.getWrapper((GraphID)this._graphID).getGraph();
        E nodes = graph.\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            this.update(node);
            nodes.next();
        }
        EntityRealizerInflaterRegistry.getDefault().getOrCreateInflater(this._graphID).deflateAll();
        this._changeSupport.fireChange();
        graph.\u0107();
    }

    public void update(Y node) {
        this.resetCustomizables(node);
        CustomizableViewUpdater.getDefault().update((CustomizableView)this, (Object)node);
    }

    private void resetCustomizables(Y node) {
        List customizables = CustomizableRegistry.getDefault().get(this.getCustomizableViewID());
        for (Customizable customizable : customizables) {
            if (!(customizable instanceof Customizable.Nodes)) continue;
            customizable.setDefault((Object)node);
        }
    }

    public void addViewletListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeViewletListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }
}

