/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.PropertyValueFormat;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.util.StringUtilities;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Converter {
    public static Class getPrimitiveType(Class type) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType.isPrimitive()) {
                return type;
            }
            if (componentType == Integer.class) {
                return int[].class;
            }
            if (componentType == Float.class) {
                return float[].class;
            }
            if (componentType == Double.class) {
                return double[].class;
            }
            if (componentType == Boolean.class) {
                return boolean[].class;
            }
        } else {
            if (type.isPrimitive()) {
                return type;
            }
            if (type == Integer.class) {
                return Integer.TYPE;
            }
            if (type == Double.class) {
                return Double.TYPE;
            }
            if (type == Float.class) {
                return Float.TYPE;
            }
            if (type == Byte.class) {
                return Byte.TYPE;
            }
            if (type == Boolean.class) {
                return Boolean.TYPE;
            }
            if (type == Short.class) {
                return Short.TYPE;
            }
            if (type == Long.class) {
                return Long.TYPE;
            }
            if (type == Character.class) {
                return Character.TYPE;
            }
        }
        return null;
    }

    public static Class getReferenceType(Class type) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (!componentType.isPrimitive()) {
                return componentType;
            }
            if (componentType == Integer.TYPE) {
                return Integer[].class;
            }
            if (componentType == Float.TYPE) {
                return Float[].class;
            }
            if (componentType == Double.TYPE) {
                return Double[].class;
            }
            if (componentType == Boolean.TYPE) {
                return Boolean[].class;
            }
            if (componentType == Long.TYPE) {
                return Long[].class;
            }
        } else {
            if (!type.isPrimitive()) {
                return type;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
        }
        return null;
    }

    public static boolean isAssignableFrom(Class clazz, Class from) {
        if (clazz == null || from == null) {
            return false;
        }
        Class refType1 = Converter.getReferenceType(clazz);
        Class refType2 = Converter.getReferenceType(from);
        return refType1.isAssignableFrom(refType2);
    }

    public static Object changeArrayType(Object objectArray, Class toComponentType) {
        return Converter.changeArrayType(objectArray, toComponentType, false);
    }

    public static Object changeArrayType(Object objectArray, Class toComponentType, boolean readingJson) {
        if (StringUtilities.isNullString((Object)objectArray)) {
            return null;
        }
        if (!objectArray.getClass().isArray()) {
            throw new IllegalArgumentException("objectArray parameter must be an array");
        }
        int length = Array.getLength(objectArray);
        Object values = Array.newInstance(toComponentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(objectArray, i);
            if (readingJson) {
                if (value == null) {
                    Array.set(values, i, null);
                    continue;
                }
                if (value instanceof Double && Float.TYPE == toComponentType) {
                    Array.set(values, i, Float.valueOf(((Double)value).floatValue()));
                    continue;
                }
                if (value instanceof Long && Date.class == toComponentType) {
                    try {
                        Array.set(values, i, new Date((Long)value));
                    }
                    catch (Exception ex) {
                        Array.set(values, i, null);
                    }
                    continue;
                }
                if (value instanceof String && Date.class == toComponentType) {
                    try {
                        Date date = null;
                        try {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                            date = df.parse((String)value);
                        }
                        catch (ParseException ex) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
                            try {
                                date = df.parse((String)value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (date == null) {
                            try {
                                long millis = Long.parseLong((String)value);
                                date = new Date(millis);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Array.set(values, i, date);
                    }
                    catch (Exception ex) {
                        Array.set(values, i, null);
                    }
                    continue;
                }
                if (BigInteger.class == toComponentType) {
                    if (value instanceof Integer) {
                        Array.set(values, i, BigInteger.valueOf(((Integer)value).intValue()));
                        continue;
                    }
                    if (value instanceof Long) {
                        Array.set(values, i, BigInteger.valueOf((Long)value));
                        continue;
                    }
                    Array.set(values, i, value);
                    continue;
                }
                Array.set(values, i, value);
                continue;
            }
            Array.set(values, i, value);
        }
        return values;
    }

    public static Object convertFrom(String value, Class toType) throws IllegalArgumentException {
        return Converter.descriptor(toType, PropertyValueFormat.getDefault()).convert(value);
    }

    public static String convertTo(Object value, Class fromType) throws IllegalArgumentException {
        return Converter.descriptor(fromType, PropertyValueFormat.getDefault()).convert(value);
    }

    public static Object convertFrom(String value, String toTypeName) throws IllegalArgumentException {
        return Converter.descriptor(toTypeName).convert(value);
    }

    public static String convertTo(Object value, String fromTypeName) throws IllegalArgumentException {
        return Converter.descriptor(fromTypeName).convert(value);
    }

    public static Class getClassForType(String typeName) throws IllegalArgumentException {
        return Converter.descriptor(typeName).getType();
    }

    public static Object convert(Object value, Class toType) {
        return Converter.convert(value, value.getClass(), toType);
    }

    public static Object convert(Object value, Class toType, PropertyValueFormat propertyValueFormat) {
        return Converter.convert(value, value.getClass(), toType, propertyValueFormat);
    }

    public static Object convert(Object value, Class fromType, Class toType) {
        return Converter.convert(value, fromType, toType, PropertyValueFormat.getDefault());
    }

    public static Object convert(Object value, Class fromType, Class toType, PropertyValueFormat propertyValueFormat) {
        Class fromTypePrimitive;
        if (toType.isPrimitive() || toType.isArray() && toType.getComponentType().isPrimitive()) {
            fromTypePrimitive = Converter.getPrimitiveType(fromType);
            if (fromTypePrimitive != null) {
                fromType = Converter.getPrimitiveType(fromType);
            }
        } else if ((BigInteger.class == toType || toType.isArray() && BigInteger.class == toType.getComponentType()) && (fromTypePrimitive = Converter.getPrimitiveType(fromType)) != null) {
            fromType = Converter.getPrimitiveType(fromType);
        }
        TypeDescriptor fromDesc = Converter.descriptor(fromType, propertyValueFormat);
        TypeDescriptor toDesc = Converter.descriptor(toType, propertyValueFormat);
        String temp = fromDesc.convert(value);
        return toDesc.convert(temp);
    }

    private static TypeDescriptor descriptor(String typeName) {
        TypeDescriptor td = TypeRegistry.getDefault().getType(typeName);
        if (td == null) {
            throw new IllegalArgumentException("No type descriptor found for type name " + typeName);
        }
        return td;
    }

    private static TypeDescriptor descriptor(Class type, PropertyValueFormat propertyValueFormat) {
        TypeDescriptor td = propertyValueFormat.equals((Object)PropertyValueFormat.getDefault()) ? TypeRegistry.getDefault().getType(type) : TypeRegistry.getDefault().getType(type, propertyValueFormat);
        if (td == null) {
            throw new IllegalArgumentException("No type descriptor found for type " + type + " and value format " + propertyValueFormat.name());
        }
        return td;
    }

    public static Object removeNullStringsFromArray(Object objectArray) {
        if (StringUtilities.isNullString((Object)objectArray)) {
            return null;
        }
        if (!objectArray.getClass().isArray()) {
            throw new IllegalArgumentException("objectArray parameter must be an array");
        }
        int length = Array.getLength(objectArray);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(objectArray, i);
            if (StringUtilities.isNullString((Object)value)) continue;
            values.add(value);
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray();
    }
}

