/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Evaluator {
    public static final Pattern PROPERTY_PATTERN = Evaluator.createPattern("property");
    private static final Logger LOG = Logger.getLogger(Evaluator.class.getName());
    private static final Pattern TRIM_PATTERN = Evaluator.createPattern("trim");
    private static final Pattern IPv4_PATTERN = Evaluator.createPattern("ipv4");
    private static final Pattern IPv6_PATTERN = Evaluator.createPattern("ipv6");

    public abstract String evaluate(String var1, DataSource var2);

    public abstract List<PropertyDescriptor> getLinkedProperties(String var1);

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    protected static String parse(String formula, Pattern pattern, BiConsumer<StringBuilder, String> formatter) {
        int start = 0;
        Matcher matcher = pattern.matcher(formula);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String pre = formula.substring(start, matcher.start());
            sb.append(pre);
            formatter.accept(sb, matcher.group(2));
            start = matcher.end();
        }
        String post = formula.substring(start, formula.length());
        sb.append(post);
        return sb.toString();
    }

    protected static Pattern createPattern(String functionName) {
        return Pattern.compile("(\\$" + functionName + "\\((.*?)\\))", 2);
    }

    public static class Replacement
    extends Evaluator {
        public static boolean isSuitableFor(String value) {
            return value != null && value.contains("$") && value.contains("(");
        }

        @Override
        public String evaluate(String formula, DataSource inputs) {
            formula = formula.replace("%", "%%");
            ArrayList<PropertyDescriptor> evaluators = new ArrayList<PropertyDescriptor>();
            String format = Replacement.parse(formula, evaluators);
            Object[] values = new Object[evaluators.size()];
            for (int i = 0; i < evaluators.size(); ++i) {
                Object val = inputs.getValue(evaluators.get(i));
                values[i] = val != null ? val : "";
            }
            String previous = null;
            String result = String.format(format, values);
            while (!result.equals(previous)) {
                previous = result;
                result = Replacement.parseTrim(result);
                result = Replacement.parseIPv4(result);
                result = Replacement.parseIPv6(result);
            }
            return result;
        }

        private static String parse(String formula, List<PropertyDescriptor> evaluators) {
            String placeholderStart = "%";
            String placeholderEnd = "$s";
            return Replacement.parse(formula, PROPERTY_PATTERN, (sb, innerStr) -> {
                evaluators.add(new PropertyDescriptor(String.class, (String)innerStr));
                sb.append("%");
                sb.append(evaluators.size());
                sb.append("$s");
            });
        }

        private static String parseTrim(String formula) {
            return Replacement.parse(formula, TRIM_PATTERN, (sb, innerStr) -> sb.append(Replacement.trimWhitespaceAndCommas(innerStr)));
        }

        private static String parseIPv4(String formula) {
            return Replacement.parse(formula, IPv4_PATTERN, (sb, innerStr) -> {
                String ipv4Str = innerStr;
                try {
                    IPAddressString ipStr = new IPAddressString(innerStr);
                    IPv4Address address = ipStr.getAddress().toIPv4();
                    ipv4Str = address.toCompressedString();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not convert to IPv4 string: {0}", innerStr);
                }
                sb.append(ipv4Str);
            });
        }

        private static String parseIPv6(String formula) {
            return Replacement.parse(formula, IPv6_PATTERN, (sb, innerStr) -> {
                String ipv6Str = innerStr;
                try {
                    IPAddressString ipStr = new IPAddressString(innerStr);
                    IPv6Address address = ipStr.getAddress().toIPv6();
                    ipv6Str = address.toCompressedString();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Could not convert to IPv6 string: {0}", innerStr);
                }
                sb.append(ipv6Str);
            });
        }

        private static String trimWhitespaceAndCommas(String text) {
            text = Pattern.compile("^[\\s,]*").matcher(text).replaceAll("");
            text = Pattern.compile("[\\s,]*$").matcher(text).replaceAll("");
            return text;
        }

        @Override
        public List<PropertyDescriptor> getLinkedProperties(String formula) {
            ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
            Replacement.parse(formula, descriptors);
            return descriptors;
        }

        @Override
        public String getName() {
            return "maltego.replace";
        }
    }
}

