/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.cases;

import com.maltego.cloud.data.Case;
import com.maltego.cloud.data.CaseMember;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.util.ui.table.IconText;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.openide.util.ImageUtilities;

public class CaseTableModel
extends RowTableModel<Case> {
    public static final String[] Columns = new String[]{"Name", "Access", "Type", "Date"};
    private static String email = null;
    private static boolean showInbox = true;
    private Icon fallbackCaseIcon;
    private Icon ownerCaseIcon;
    private Icon sharedOwnerCaseIcon;
    private Icon sharedContributorCaseIcon;
    private Icon encryptedIcon;

    public CaseTableModel(List<Case> cases, boolean showInbox) {
        super(Columns, CaseTableModel.getSortedSpecs(cases));
        CaseTableModel.showInbox = showInbox;
    }

    public void setCases(List<Case> cases) {
        this.setRows(CaseTableModel.getSortedSpecs(cases));
    }

    private static List<Case> getSortedSpecs(List<Case> cases) {
        ArrayList<Case> list = new ArrayList<Case>(CaseTableModel.getWriteableCases(cases));
        Collections.sort(list, new CaseDisplayNameComparator());
        return list;
    }

    private static List<Case> getWriteableCases(List<Case> cases) {
        ArrayList<Case> writeableCases = new ArrayList<Case>();
        email = new UserInfo().getEmail();
        if (email != null) {
            for (Case aCase : cases) {
                if (!showInbox && aCase.isInbox()) continue;
                boolean writeable = false;
                for (CaseMember member : aCase.getMembers()) {
                    if (!email.equalsIgnoreCase(member.getUserEmail())) continue;
                    CaseRole caseRole = CaseRole.READER;
                    try {
                        caseRole = CaseRole.valueOf(member.getRole());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    switch (caseRole) {
                        case OWNER: 
                        case CONTRIBUTOR: {
                            writeable = true;
                            break;
                        }
                    }
                    if (writeable) break;
                }
                if (!writeable) continue;
                writeableCases.add(aCase);
            }
        }
        return writeableCases;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 || columnIndex == 2) {
            return IconText.class;
        }
        return String.class;
    }

    public Object getValueFor(Case row, int column) {
        switch (column) {
            case 0: {
                return new IconText(this.getIcon(row.getMembers()), row.getName());
            }
            case 1: {
                return this.getAccess(row.getMembers()).getDisplayName();
            }
            case 2: {
                return new IconText(this.getEncryptedIcon(row.isEncrypted()), "Case ");
            }
            case 3: {
                return row.getUpdatedAt();
            }
        }
        return null;
    }

    private CaseRole getAccess(CaseMember[] caseMembers) {
        CaseRole role = CaseRole.OWNER;
        for (CaseMember member : caseMembers) {
            if (!email.equalsIgnoreCase(member.getUserEmail())) continue;
            try {
                role = CaseRole.valueOf(member.getRole());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            break;
        }
        return role;
    }

    private CaseIcon getCaseIcon(CaseMember[] caseMembers) {
        CaseIcon caseIcon = null;
        boolean shared = false;
        boolean owner = false;
        block6: for (CaseMember member : caseMembers) {
            CaseRole caseRole = CaseRole.READER;
            try {
                caseRole = CaseRole.valueOf(member.getRole());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            switch (caseRole) {
                case OWNER: {
                    if (email.equalsIgnoreCase(member.getUserEmail())) {
                        owner = true;
                    }
                }
                case CONTRIBUTOR: 
                case READER: {
                    if (email.equalsIgnoreCase(member.getUserEmail())) continue block6;
                    shared = true;
                    continue block6;
                }
            }
        }
        if (shared) {
            caseIcon = owner ? CaseIcon.SHARED_OWNER_ICON : CaseIcon.SHARED_CONTRIBUTOR_ICON;
        } else if (owner) {
            caseIcon = CaseIcon.OWNER_ICON;
        }
        return caseIcon;
    }

    private Icon getIcon(CaseMember[] caseMembers) {
        Icon icon;
        switch (this.getCaseIcon(caseMembers)) {
            case SHARED_OWNER_ICON: {
                if (this.sharedOwnerCaseIcon == null) {
                    this.sharedOwnerCaseIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/maltego/cloud/ui/cases/SharedCase24.png"));
                }
                icon = this.sharedOwnerCaseIcon;
                break;
            }
            case SHARED_CONTRIBUTOR_ICON: {
                if (this.sharedContributorCaseIcon == null) {
                    this.sharedContributorCaseIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/maltego/cloud/ui/cases/SharedCaseContributor24.png"));
                }
                icon = this.sharedContributorCaseIcon;
                break;
            }
            case OWNER_ICON: {
                if (this.ownerCaseIcon == null) {
                    this.ownerCaseIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/maltego/cloud/ui/cases/Case24.png"));
                }
                icon = this.ownerCaseIcon;
                break;
            }
            default: {
                if (this.fallbackCaseIcon == null) {
                    this.fallbackCaseIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/maltego/cloud/ui/cases/Case.png"));
                }
                icon = this.fallbackCaseIcon;
            }
        }
        return icon;
    }

    private Icon getEncryptedIcon(boolean encrypted) {
        Icon icon = null;
        if (encrypted) {
            if (this.encryptedIcon == null) {
                this.encryptedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/maltego/cloud/ui/cases/Key24.png"));
            }
            icon = this.encryptedIcon;
        }
        return icon;
    }

    private static class CaseDisplayNameComparator
    implements Comparator<Case>,
    Serializable {
        private CaseDisplayNameComparator() {
        }

        @Override
        public int compare(Case s1, Case s2) {
            return s1.getName().compareToIgnoreCase(s2.getName());
        }
    }

    private static enum CaseIcon {
        OWNER_ICON,
        SHARED_OWNER_ICON,
        SHARED_CONTRIBUTOR_ICON;

    }

    private static enum CaseRole {
        OWNER("Owner"),
        CONTRIBUTOR("Contributor"),
        READER("Reader");

        private final String displayName;

        private CaseRole(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

