/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.serializer.NeoJsonReader;
import com.maltego.cloud.ui.open.CloudGraphOpenAction;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class TestOpenFromCloudAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(TestOpenFromCloudAction.class.getName());

    public String getName() {
        return "Test Open From Cloud";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            String testGraphJson = this.getTestGraphJson();
            GraphID maltegoGraphID = GraphID.create();
            NeoJsonReader reader = new NeoJsonReader(maltegoGraphID, null, false, null);
            reader.readFromString(testGraphJson);
            SwingUtilities.invokeLater(() -> {
                try {
                    WindowUtil.showWaitCursor();
                    this.openGraph(reader);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getTestGraphJson() throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("L1-footprint.json"), (String)"UTF-8");
    }

    private void openGraph(NeoJsonReader reader) {
        GraphID maltegoGraphID = reader.getMaltegoGraphID();
        GraphID cloudGraphID = reader.getCloudGraphID();
        String graphName = reader.getGraphName();
        CloudGraphOpenAction openAction = (CloudGraphOpenAction)SystemAction.get(CloudGraphOpenAction.class);
        openAction.setGraph(maltegoGraphID, graphName);
        openAction.performAction();
        CloudGraph cloudgraph = new CloudGraph(maltegoGraphID, cloudGraphID, reader.getCloudGraphVersion(), graphName, Boolean.valueOf(reader.isEditable()), null);
        if (maltegoGraphID.equals((Object)cloudGraphID)) {
            CloudGraphRegistry.getDefault().addCloudGraph(cloudGraphID, cloudgraph);
            RecentCloudGraphs.getDefault().addCloudGraph(cloudGraphID.toString(), graphName);
        } else {
            CloudGraphRegistry.getDefault().addVersionOfCloudGraph(maltegoGraphID, cloudgraph);
        }
    }
}

