/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xsocket.ILifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestHandlerInfo {
    private boolean isRequestHandlerSynchronizedOnSession = false;
    private boolean isRequestHandlerInvokeOnMessageReceived = false;
    private boolean isRequestHandlerMultithreaded = true;
    private boolean isLifeCycle = false;
    private boolean isRequestTimoutHandler = false;
    private boolean isRequestTimoutHandlerMultithreaded = true;

    RequestHandlerInfo(Class clazz) {
        if (clazz == null) {
            return;
        }
        this.isLifeCycle = ILifeCycle.class.isAssignableFrom(clazz);
        if (IHttpRequestHandler.class.isAssignableFrom(clazz)) {
            this.isRequestHandlerMultithreaded = RequestHandlerInfo.isOnRequestMultithreaded(clazz);
            this.isRequestHandlerInvokeOnMessageReceived = RequestHandlerInfo.isOnRequestInvokeOnMessageReceived(clazz);
            this.isRequestHandlerSynchronizedOnSession = RequestHandlerInfo.isOnSession(clazz);
        }
        if (IHttpRequestTimeoutHandler.class.isAssignableFrom(clazz)) {
            this.isRequestTimoutHandler = true;
            this.isRequestTimoutHandlerMultithreaded = HttpUtils.isRequestTimeoutHandlerMultithreaded(clazz);
        }
    }

    static boolean isOnRequestMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
        boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(serverHandlerClass, true);
        return HttpUtils.isMethodMultithreaded(serverHandlerClass, "onRequest", isMultithreaded, IHttpExchange.class);
    }

    static boolean isOnRequestInvokeOnMessageReceived(Class<IHttpRequestHandler> handlerClass) {
        boolean invokeOnMessageReceived = HttpUtils.isInvokeOnMessageReceived(handlerClass, false);
        return HttpUtils.isInvokeOnMessageReceived(handlerClass, "onRequest", invokeOnMessageReceived, IHttpExchange.class);
    }

    static boolean isOnSession(Class<IHttpRequestHandler> handlerClass) {
        boolean isSynchronizedOnSession = HttpUtils.isSynchronizedOnSession(handlerClass, false);
        return HttpUtils.isSynchronizedOnSession(handlerClass, "onRequest", isSynchronizedOnSession, IHttpExchange.class);
    }

    public boolean isLifeCycle() {
        return this.isLifeCycle;
    }

    public boolean isRequestHandlerInvokeOnMessageReceived() {
        return this.isRequestHandlerInvokeOnMessageReceived;
    }

    public boolean isRequestHandlerSynchronizedOnSession() {
        return this.isRequestHandlerSynchronizedOnSession;
    }

    public boolean isRequestHandlerMultithreaded() {
        return this.isRequestHandlerMultithreaded;
    }

    public boolean isRequestTimeoutHandler() {
        return this.isRequestTimoutHandler;
    }

    public boolean isRequestTimeoutHandlerMultithreaded() {
        return this.isRequestTimoutHandlerMultithreaded;
    }
}

