/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder;

import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.entity.manager.palette.PaletteSupport;
import com.paterva.maltego.imgfactory.icons.IconExistInfo;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedInstaller;
import com.paterva.maltego.seeds.api.HubSeedRequests;
import com.paterva.maltego.seeds.api.HubSeedResources;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerFinder;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.finder.wizard.DiscoveryWizard;
import com.paterva.maltego.transform.finder.wizard.DuplicateTransformsInstalledPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchText;
import com.paterva.maltego.transform.protocol.v2api.messaging.V2ListTransformsCache;
import com.paterva.maltego.transform.protocol.v3.api.V3ListTransformsCache;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeStrategy;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class SeedDiscoveryManager
extends HubSeedInstaller {
    public static final String PROP_INSTALLING_SEED = "installingHubSeed";
    public static final String PROP_UNINSTALLING_SEED = "uninstallingHubSeed";
    public static final String PROP_UPDATING = "updating";
    private static final String PREF_LAST_UPDATE = "maltego.seeds.update.date";
    private static SeedDiscoveryManager _default;
    private static final Logger LOG;
    private final Object LOCK = new Object();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private boolean busyRefreshingHubWhiteList = false;

    public static synchronized SeedDiscoveryManager getDefault() {
        if (_default == null) {
            _default = (SeedDiscoveryManager)((Object)Lookup.getDefault().lookup(SeedDiscoveryManager.class));
        }
        return _default;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(HubSeedDescriptor hubSeed, List<TransformSeed> seeds) {
        WindowUtil.showWaitCursor();
        Object object = this.LOCK;
        synchronized (object) {
            this._changeSupport.firePropertyChange(PROP_INSTALLING_SEED, null, hubSeed);
            WindowUtil.hideWaitCursor();
            try {
                V2ListTransformsCache.clear();
                V3ListTransformsCache.clear();
                WizardDescriptor wizardDescriptor = DiscoveryWizard.install(hubSeed, seeds);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor);
                Boolean success = (Boolean)wizardDescriptor.getProperty("success");
                PaletteSupport.getPalette().refresh();
                if (success != null && success.booleanValue()) {
                    DiscoverySettings.setDiscoveryComplete(true);
                    this.refreshHubWhiteList();
                    HubSeedRequests.sendInstalled((HubSeedDescriptor)hubSeed);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this._changeSupport.firePropertyChange(PROP_INSTALLING_SEED, hubSeed, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall(HubSeedDescriptor hubSeed) {
        List seedUrls = hubSeed.getGrantedHubSeedUrls();
        WindowUtil.showWaitCursor();
        Object object = this.LOCK;
        synchronized (object) {
            for (HubSeedUrl hubSeedUrl : seedUrls) {
                this._changeSupport.firePropertyChange(PROP_UNINSTALLING_SEED, null, hubSeed);
                WindowUtil.hideWaitCursor();
                try {
                    TransformServerRegistry serverRegistry = TransformServerRegistry.getDefault();
                    String seedUrl = hubSeedUrl.getUrl();
                    serverRegistry.removeSeedUrl(seedUrl);
                    this.removeIcons(hubSeed);
                    HubSeedResources.getAll().forEach(resources -> resources.uninstall(seedUrl));
                    if (SwingUtilities.isEventDispatchThread()) {
                        PaletteSupport.getPalette().refresh();
                    }
                    this.refreshHubWhiteList();
                    HubSeedRequests.sendUninstalled((HubSeedDescriptor)hubSeed);
                }
                finally {
                    this._changeSupport.firePropertyChange(PROP_UNINSTALLING_SEED, hubSeed, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallAll() {
        WindowUtil.showWaitCursor();
        Object object = this.LOCK;
        synchronized (object) {
            try {
                HubSeedRegistry registry = HubSeedRegistry.getDefault();
                ArrayList seeds = new ArrayList(registry.getSeeds(false).getSeeds());
                ArrayList<HubSeedDescriptor> toRemove = new ArrayList<HubSeedDescriptor>();
                for (HubSeedDescriptor seed : seeds) {
                    if (seed.getGrantedHubSeedUrls().isEmpty() || !HubSeedSettings.getDefault().isInstalled(seed)) continue;
                    toRemove.add(seed);
                }
                for (HubSeedDescriptor seed : toRemove) {
                    try {
                        this.uninstall(seed);
                        HubSeedSettings.getDefault().setInstalled(seed, false);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                HubSeedRegistry.getDefault().removeSeeds(toRemove, true);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    public void updateInstalled(TransformSeed[] transformSeeds) {
        this.update(() -> transformSeeds);
    }

    public TransformSeed[] getAllowedTransformSeeds() {
        TransformSeedRepository repo = TransformSeedRepository.getDefault();
        TransformSeed[] seeds = repo.getEnabled();
        ArrayList<TransformSeed> allowedSeeds = new ArrayList<TransformSeed>(seeds.length);
        for (TransformSeed seed : seeds) {
            HubSeedDescriptor hubSeed = HubSeedRegistry.getDefault().getHubSeed(seed);
            com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
            boolean allowSeeds = false;
            if (licenseMode.W()) {
                if (!hubSeed.isCustom() || !MaltegoIdProductRestrictions.isProbablyFree((com.paterva.maltego.licensing.mode.A)licenseMode) || MaltegoIdProductRestrictions.internalUrlAllowed((com.paterva.maltego.licensing.mode.A)licenseMode, (String)seed.getUrl().toString())) {
                    allowSeeds = true;
                } else if (hubSeed.isCustom() && MaltegoIdProductRestrictions.allowInternalHubItem((com.paterva.maltego.licensing.mode.A)licenseMode) && MaltegoIdProductRestrictions.internalUrlAllowed((com.paterva.maltego.licensing.mode.A)licenseMode, (String)seed.getUrl().toString())) {
                    allowSeeds = true;
                }
            } else if (!hubSeed.isCustom() || A.C((com.paterva.maltego.licensing.mode.A)licenseMode, (String)seed.getUrl().toString())) {
                allowSeeds = true;
            }
            if (!allowSeeds) continue;
            allowedSeeds.add(seed);
        }
        return allowedSeeds.toArray(new TransformSeed[allowedSeeds.size()]);
    }

    public TransformSeed[] getCertAllowedTransformSeeds(boolean overrideBackoff) {
        LinkedList<TransformSeed> certAllowedSeeds = new LinkedList<TransformSeed>();
        TransformSeed[] allowedSeeds = this.getAllowedTransformSeeds();
        boolean stateAlreadyChosen = false;
        for (TransformSeed seed : allowedSeeds) {
            String seedUrl = seed.getUrl().toString();
            try {
                String accessToken = LicenseManager.A().H(seedUrl);
                if (stateAlreadyChosen || CertificateUtils.mustShowWizard((String)seedUrl, (boolean)overrideBackoff, (boolean)true, (boolean)false, (String)accessToken)) {
                    certAllowedSeeds.add(seed);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't fetch certificate for hub seed.", ex);
            }
            if (stateAlreadyChosen || !CertificateUtils.isProxyUsed()) continue;
            stateAlreadyChosen = true;
        }
        return certAllowedSeeds.toArray(new TransformSeed[certAllowedSeeds.size()]);
    }

    public void updateInstalledSeed(HubSeedDescriptor hubSeed) {
        this.update(() -> {
            List seeds = HubSeedRegistry.getDefault().getTransformSeeds(hubSeed);
            return (TransformSeed[])seeds.stream().toArray(TransformSeed[]::new);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire() {
        Object object = this.LOCK;
        synchronized (object) {
            this._changeSupport.firePropertyChange(PROP_UPDATING, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Supplier<TransformSeed[]> seeds) {
        Object object = this.LOCK;
        synchronized (object) {
            long time = System.currentTimeMillis();
            LOG.info("Discovering Transforms - Start");
            try {
                V2ListTransformsCache.clear();
                V3ListTransformsCache.clear();
                DiscoveryResults results = this.getListings(seeds.get());
                if (results != null && results.getServers() != null && results.getListings() != null) {
                    TransformServerListing[] data = (TransformServerListing[])results.getListings().getData();
                    TransformUpdater updater = TransformUpdater.getDefault();
                    updater.removeMissing(data);
                    updater.updateServers(data);
                    Exception[] errors = results.getServers().getErrors();
                    if (errors == null || errors.length == 0) {
                        updater.removeMissingServers((TransformServerReference[])results.getServers().getData());
                    }
                    Map<HubSeedDescriptor, Set<TransformDescriptor>> transformsBefore = this.getHubTransforms(false);
                    updater.update(null, data, DiscoveryMergingRules.getDefault());
                    UpdateFetchText urt = new UpdateFetchText();
                    LOG.info(urt.get(data));
                    Map<HubSeedDescriptor, Set<TransformDescriptor>> transformsAfter = this.getHubTransforms(false);
                    Map<TransformDescriptor, Set<HubSeedDescriptor>> newTransforms = this.getNewTransforms(transformsBefore, transformsAfter);
                    Map<HubSeedDescriptor, Set<TransformDescriptor>> duplicates = this.getMultiHubTransforms(newTransforms);
                    if (!duplicates.isEmpty()) {
                        SwingUtilities.invokeLater(new DuplicateTxNotificationRunnable(duplicates));
                    }
                    this.refreshHubWhiteList();
                }
                PaletteSupport.getPalette().refresh();
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            finally {
                LOG.log(Level.INFO, "Discovering Transforms - End ({0}ms).", System.currentTimeMillis() - time);
                this.updateLastUpdateDate();
                this._changeSupport.firePropertyChange(PROP_UPDATING, true, false);
            }
        }
    }

    public void refreshHubWhiteList() {
        if (!this.busyRefreshingHubWhiteList) {
            this.busyRefreshingHubWhiteList = true;
            ArrayList<String> hubWhiteList = new ArrayList<String>();
            Collection serverInfos = TransformServerRegistry.getDefault().getAll();
            for (HubSeedDescriptor hsd : this.getHubTransforms(false).keySet()) {
                if (hsd == null) continue;
                for (HubSeedUrl url : hsd.getGrantedHubSeedUrls()) {
                    if (url == null) continue;
                    try {
                        List<TransformServerInfo> installedServers = this.getInstalledServers(serverInfos, url.getUrl());
                        for (TransformServerInfo serverInfo : installedServers) {
                            String hostname = serverInfo.getUrl().getURL().getHost().toLowerCase();
                            if (hubWhiteList.contains(hostname)) continue;
                            hubWhiteList.add(hostname);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                }
            }
            PrivacyModeStrategy.refreshWhiteList(hubWhiteList);
            this.busyRefreshingHubWhiteList = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public Date getLastUpdateDate() {
        long date = this.getPrefs().getLong(PREF_LAST_UPDATE, Long.MIN_VALUE);
        return date > Long.MIN_VALUE ? new Date(date) : null;
    }

    private void updateLastUpdateDate() {
        this.getPrefs().putLong(PREF_LAST_UPDATE, new Date().getTime());
    }

    private List<TransformServerInfo> getInstalledServers(Collection<TransformServerInfo> serverInfos, String seedUrl) {
        ArrayList<TransformServerInfo> servers = new ArrayList<TransformServerInfo>();
        for (TransformServerInfo server : serverInfos) {
            if (!server.getSeedUrls().contains(seedUrl)) continue;
            servers.add(server);
        }
        return servers;
    }

    private Preferences getPrefs() {
        return NbPreferences.forModule(((Object)((Object)this)).getClass());
    }

    private DiscoveryResults getListings(TransformSeed[] seeds) throws DiscoveryException {
        DiscoveryResult listings = null;
        TransformServerFinder serverFinder = TransformServerFinder.getDefault();
        TransformFinder transformFinder = TransformFinder.getDefault();
        DiscoveryResult references = serverFinder.findServers(seeds);
        if (references.getData() == null || ((TransformServerReference[])references.getData()).length == 0) {
            LOG.info("No servers. ");
        } else {
            DiscoveryResult details = serverFinder.getDetails((TransformServerReference[])references.getData());
            if (details.getData() == null || ((TransformServerDetail[])details.getData()).length == 0) {
                LOG.info("No details. ");
            } else {
                listings = transformFinder.listTransforms((TransformServerDetail[])details.getData());
                if (listings.getData() == null || ((TransformServerListing[])listings.getData()).length == 0) {
                    LOG.info("No listings. ");
                    listings = null;
                }
            }
        }
        return listings == null ? null : new DiscoveryResults((DiscoveryResult<TransformServerReference>)references, listings);
    }

    private Map<HubSeedDescriptor, Set<TransformDescriptor>> getHubTransforms(boolean allHubItems) {
        HashMap<HubSeedDescriptor, Set<TransformDescriptor>> hubTransforms = new HashMap<HubSeedDescriptor, Set<TransformDescriptor>>();
        TransformRepository repository = TransformRepositoryRegistry.getDefault().getRepository("Remote");
        for (TransformDefinition transform : repository.getAll()) {
            List hubSeeds = allHubItems ? HubSeedRegistry.getDefault().getSeeds(false).getSeeds() : HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)transform);
            for (HubSeedDescriptor hubSeed : hubSeeds) {
                HashSet<TransformDefinition> transforms = (HashSet<TransformDefinition>)hubTransforms.get(hubSeed);
                if (transforms == null) {
                    transforms = new HashSet<TransformDefinition>();
                    hubTransforms.put(hubSeed, transforms);
                }
                transforms.add(transform);
            }
        }
        return hubTransforms;
    }

    private Map<TransformDescriptor, Set<HubSeedDescriptor>> getNewTransforms(Map<HubSeedDescriptor, Set<TransformDescriptor>> transformsBefore, Map<HubSeedDescriptor, Set<TransformDescriptor>> transformsAfter) {
        HashMap<TransformDescriptor, Set<HubSeedDescriptor>> newTx = new HashMap<TransformDescriptor, Set<HubSeedDescriptor>>();
        for (Map.Entry<HubSeedDescriptor, Set<TransformDescriptor>> entry : transformsAfter.entrySet()) {
            HubSeedDescriptor hubSeed = entry.getKey();
            Set<TransformDescriptor> newTransforms = entry.getValue();
            Set oldTransforms = transformsBefore.get(hubSeed);
            if (oldTransforms == null) {
                oldTransforms = Collections.EMPTY_SET;
            }
            for (TransformDescriptor newTransform : newTransforms) {
                if (oldTransforms.contains(newTransform)) continue;
                HashSet<HubSeedDescriptor> hubSeeds = (HashSet<HubSeedDescriptor>)newTx.get(newTransform);
                if (hubSeeds == null) {
                    hubSeeds = new HashSet<HubSeedDescriptor>();
                    newTx.put(newTransform, hubSeeds);
                }
                hubSeeds.add(hubSeed);
            }
        }
        return newTx;
    }

    private Map<HubSeedDescriptor, Set<TransformDescriptor>> getMultiHubTransforms(Map<TransformDescriptor, Set<HubSeedDescriptor>> newTransforms) {
        HashMap<HubSeedDescriptor, Set<TransformDescriptor>> multiHubTx = new HashMap<HubSeedDescriptor, Set<TransformDescriptor>>();
        for (Map.Entry<TransformDescriptor, Set<HubSeedDescriptor>> entry : newTransforms.entrySet()) {
            TransformDescriptor transform = entry.getKey();
            List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds(transform);
            if (hubSeeds.size() <= 1) continue;
            for (HubSeedDescriptor hubSeed : hubSeeds) {
                HashSet<TransformDescriptor> transforms = (HashSet<TransformDescriptor>)multiHubTx.get(hubSeed);
                if (transforms == null) {
                    transforms = new HashSet<TransformDescriptor>();
                    multiHubTx.put(hubSeed, transforms);
                }
                transforms.add(transform);
            }
        }
        return multiHubTx;
    }

    private void removeIcons(HubSeedDescriptor hubSeed) {
        IconExistInfo iconExistInfo = new IconExistInfo();
        String hubItemName = hubSeed.getName();
        IconRegistry iconRegistry = IconRegistry.getDefault();
        List icons = iconRegistry.getIcons();
        HashSet<String> categories = new HashSet<String>();
        for (RegistryIcon icon : icons) {
            Set iconHubItems = icon.getHubItems();
            if (!iconHubItems.contains(hubItemName) || iconExistInfo.isBuiltIn(icon)) continue;
            categories.add(icon.getCategory());
            try {
                iconRegistry.removeHubItem(icon, hubItemName);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (String category : categories) {
            if (!iconRegistry.getIcons(category).isEmpty()) continue;
            try {
                iconRegistry.removeCategory(category);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static {
        LOG = Logger.getLogger(SeedDiscoveryManager.class.getName());
    }

    private static class DiscoveryResults {
        private final DiscoveryResult<TransformServerReference> _servers;
        private final DiscoveryResult<TransformServerListing> _listings;

        public DiscoveryResults(DiscoveryResult<TransformServerReference> servers, DiscoveryResult<TransformServerListing> listings) {
            this._servers = servers;
            this._listings = listings;
        }

        public DiscoveryResult<TransformServerReference> getServers() {
            return this._servers;
        }

        public DiscoveryResult<TransformServerListing> getListings() {
            return this._listings;
        }
    }

    static class DuplicateTxNotificationListener
    implements ActionListener {
        private final Map<HubSeedDescriptor, Set<TransformDescriptor>> _duplicates;

        public DuplicateTxNotificationListener(Map<HubSeedDescriptor, Set<TransformDescriptor>> duplicates) {
            this._duplicates = duplicates;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DuplicateTransformsInstalledPanel panel = new DuplicateTransformsInstalledPanel();
            panel.setDuplicateTransforms(this._duplicates);
            panel.setPreferredSize(new Dimension(400, 300));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, "Duplicate Transforms Installed"));
        }
    }

    private static class DuplicateTxNotificationRunnable
    implements Runnable {
        private final Map<HubSeedDescriptor, Set<TransformDescriptor>> _duplicates;

        public DuplicateTxNotificationRunnable(Map<HubSeedDescriptor, Set<TransformDescriptor>> duplicates) {
            this._duplicates = duplicates;
        }

        @Override
        public void run() {
            String msg = "Click for details.";
            ImageIcon icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/transform/finder/DiscoverTransforms.png", (boolean)true);
            NotificationDisplayer.getDefault().notify("Duplicate Transforms Installed", (Icon)icon, msg, (ActionListener)new DuplicateTxNotificationListener(this._duplicates));
        }
    }
}

