/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.matching.MatchingRuleFactory;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.merging.MergeUtils;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityMerger {
    public static Map<MaltegoEntity, List<MaltegoEntity>> getMerged(TransformRunContext ctx, Iterable<MaltegoEntity> entities, MatchingRuleDescriptor ruleDescriptor) {
        MatchingRule rule = MatchingRuleFactory.createFrom((MatchingRuleDescriptor)ruleDescriptor);
        HashMap<MaltegoEntity, List<MaltegoEntity>> result = new HashMap<MaltegoEntity, List<MaltegoEntity>>();
        for (MaltegoEntity entity : entities) {
            MaltegoEntity existing = EntityMerger.find(ctx, result.keySet(), entity, rule);
            if (existing == null) {
                ArrayList<MaltegoEntity> list = new ArrayList<MaltegoEntity>();
                entity = entity.createClone();
                list.add(entity);
                result.put(entity, list);
                continue;
            }
            EntityMerger.merge(entity, existing);
            ((List)result.get(existing)).add(entity);
        }
        return result;
    }

    private static MaltegoEntity find(TransformRunContext ctx, Iterable<MaltegoEntity> entities, MaltegoEntity entity, MatchingRule rule) {
        EntityRegistry registry = ctx.getEntityRegistry();
        for (MaltegoEntity e : entities) {
            int result;
            if (rule == null) {
                rule = MatchingRule.Default;
            }
            if ((result = rule.getMatch((SpecRegistry)registry, (TypedPropertyBag)e, (TypedPropertyBag)entity)) != 1) continue;
            return e;
        }
        return null;
    }

    public static MaltegoEntity merge(MaltegoEntity src, MaltegoEntity dest) {
        MergeUtils.addMissingProperties((MaltegoPart)dest, (MaltegoPart)src);
        MergeUtils.mergePropertyValues((MaltegoPart)dest, (MaltegoPart)src, (boolean)true);
        MergeUtils.mergeSpecialPropertyMapping((MaltegoPart)dest, (MaltegoPart)src, (boolean)false);
        MergeUtils.mergeDisplayInformation((MaltegoPart)dest, (MaltegoPart)src, (boolean)true);
        MergeUtils.mergeNotes((MaltegoPart)dest, (MaltegoPart)src, (boolean)false);
        return dest;
    }
}

