/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.cloud.data.GraphLock;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GraphMetadata {
    private String id;
    private String name;
    private String ownerEmail;
    private String caseId;
    private boolean encrypted;
    private Date createdAt;
    private Date updatedAt;
    private GraphLock lock;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public GraphMetadata(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="ownerEmail") String ownerEmail, @JsonProperty(value="caseId", required=true) String caseId, @JsonProperty(value="encrypted", required=true) boolean encrypted, @JsonProperty(value="createdAt") Date createdAt, @JsonProperty(value="updatedAt") Date updatedAt, @JsonProperty(value="lock") GraphLock lock) {
        this.id = id;
        this.name = name;
        this.ownerEmail = ownerEmail;
        this.caseId = caseId;
        this.encrypted = encrypted;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lock = lock;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public GraphLock getLock() {
        return this.lock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphMetadata)) {
            return false;
        }
        GraphMetadata graph = (GraphMetadata)o;
        return this.encrypted == graph.encrypted && Objects.equals(this.id, graph.id) && Objects.equals(this.name, graph.name) && Objects.equals(this.ownerEmail, graph.ownerEmail) && Objects.equals(this.caseId, graph.caseId) && Objects.equals(this.createdAt, graph.createdAt) && Objects.equals(this.updatedAt, graph.updatedAt) && Objects.equals(this.lock, graph.lock);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.ownerEmail, this.caseId, this.encrypted, this.createdAt, this.updatedAt, this.lock);
    }

    public String toString() {
        return "GraphMetadata{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", ownerEmail='" + this.ownerEmail + '\'' + ", caseId='" + this.caseId + '\'' + ", encrypted=" + this.encrypted + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", lock=" + this.lock + '}';
    }
}

