/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.data.CloudAttachments;
import com.maltego.cloud.data.CloudGraphContent;
import com.maltego.cloud.data.Entity;
import com.maltego.cloud.data.Link;
import com.maltego.cloud.data.Property;
import com.maltego.cloud.serializer.NeoSpecialProperty;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityPropTypeMapping;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.serializers.map.PartMapReader;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NeoJsonReader {
    private final PartMapReader partMapReader = new PartMapReader();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<MaltegoEntity, CloudAttachments> attachmentProperties = new LinkedHashMap<MaltegoEntity, CloudAttachments>();
    private final GraphID maltegoGraphID;
    private final GraphID cloudGraphID;
    private final boolean editable;
    private final String cloudGraphVersion;
    private String graphName;

    public NeoJsonReader(GraphID maltegoGraphID, GraphID cloudGraphID, boolean editable, String cloudGraphVersion) {
        this.maltegoGraphID = maltegoGraphID;
        this.cloudGraphID = cloudGraphID;
        this.editable = editable;
        this.cloudGraphVersion = cloudGraphVersion;
    }

    public GraphID getCloudGraphID() {
        return this.cloudGraphID;
    }

    public GraphID getMaltegoGraphID() {
        return this.maltegoGraphID;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getCloudGraphVersion() {
        return this.cloudGraphVersion;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public Map<MaltegoEntity, CloudAttachments> getAttachmentProperties() {
        return this.attachmentProperties;
    }

    public void readFromString(String graphJson) throws Exception {
        this.readFromString(graphJson, null);
    }

    @Deprecated
    public Object[] readFromString(String graphJson, EntityFactory unitTestEntityFactory) throws Exception {
        CloudGraphContent graph = (CloudGraphContent)this.mapper.readValue(graphJson, CloudGraphContent.class);
        this.graphName = graph.getName();
        if (unitTestEntityFactory == null) {
            GraphFactory.getDefault().createGraph(this.maltegoGraphID, false, false);
        }
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        for (Entity entity : graph.getEntities()) {
            MaltegoEntity maltegoEntity = unitTestEntityFactory == null ? this.fromDto(entity, EntityFactory.getDefault()) : this.fromDto(entity, unitTestEntityFactory);
            entities.add(maltegoEntity);
        }
        if (unitTestEntityFactory == null) {
            GraphStoreWriter.initForCloud((GraphID)this.maltegoGraphID);
            GraphStoreWriter.addEntities((GraphID)this.maltegoGraphID, entities);
        }
        LinkedHashMap<MaltegoLink, LinkEntityIDs> links = new LinkedHashMap<MaltegoLink, LinkEntityIDs>();
        for (Link link : graph.getLinks()) {
            MaltegoLink maltegoLink = this.fromDto(link);
            EntityID from = EntityID.parse((String)link.getFromId());
            EntityID to = EntityID.parse((String)link.getToId());
            LinkEntityIDs entityIDs = new LinkEntityIDs(from, to);
            links.put(maltegoLink, entityIDs);
        }
        if (unitTestEntityFactory == null) {
            GraphStoreWriter.addLinks((GraphID)this.maltegoGraphID, links);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this.maltegoGraphID);
            graphStore.refresh();
            return null;
        }
        return new Object[]{entities, links};
    }

    private MaltegoEntity fromDto(Entity entity, EntityFactory entityFactory) throws Exception {
        EntityID entityId = EntityID.parse((String)entity.getId());
        String type = entity.getType();
        MaltegoEntity maltegoEntity = entityFactory.createInstance(type, false, entityId, false);
        List<Property> properties = entity.getProperties();
        for (Property property : properties) {
            if (NeoSpecialProperty.ATTACHMENTS.getId().equals(property.getType())) {
                Object value2 = property.getValue();
                CloudAttachments atts = (CloudAttachments)this.mapper.convertValue(value2, CloudAttachments.class);
                this.attachmentProperties.put(maltegoEntity, atts);
                continue;
            }
            if (this.isSpecialProperty(property, MaltegoEntity.class)) continue;
            DisplayDescriptor pd = this.fromDto(property);
            Object value3 = this.toClientValue((PropertyDescriptor)pd, property);
            maltegoEntity.setValue((PropertyDescriptor)pd, value3);
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.VALUE).map(prop -> (String)prop.getValue()).filter(Objects::nonNull).map(propId -> maltegoEntity.getProperties().get(propId)).ifPresent(value -> maltegoEntity.setValueProperty(value));
        this.getSpecialProperty(properties, NeoSpecialProperty.DISPLAY_VALUE).map(prop -> (String)prop.getValue()).filter(Objects::nonNull).ifPresent(value -> maltegoEntity.setDisplayValueExpression(value));
        this.getSpecialProperty(properties, NeoSpecialProperty.BOOKMARK).ifPresent(prop -> maltegoEntity.setBookmark(Integer.valueOf(((Number)prop.getValue()).intValue())));
        this.getSpecialProperty(properties, NeoSpecialProperty.NOTES).ifPresent(prop -> maltegoEntity.setNotes((String)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.SHOW_NOTES).ifPresent(prop -> maltegoEntity.setShowNotes((Boolean)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.WEIGHT).ifPresent(prop -> maltegoEntity.setWeight(Integer.valueOf(((Number)prop.getValue()).intValue())));
        this.getSpecialProperty(properties, NeoSpecialProperty.IMAGE).ifPresent(prop -> maltegoEntity.setImageExpression((String)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.DISPLAY_INFO).ifPresent(prop -> {
            DisplayInformationCollection displayInfo = new DisplayInformationCollection();
            ArrayList displayInfoData = (ArrayList)prop.getValue();
            for (LinkedHashMap entry : displayInfoData) {
                DisplayInformation info = new DisplayInformation((String)entry.get("name"), (String)entry.get("value"));
                displayInfo.add(info);
            }
            maltegoEntity.setDisplayInformation(displayInfo);
        });
        this.getSpecialProperty(properties, NeoSpecialProperty.OVERLAYS).ifPresent(prop -> {
            ArrayList overlays = (ArrayList)prop.getValue();
            overlays.forEach(overlay -> {
                String[] positionWords = ((String)overlay.get("position")).split("_");
                String positionCode = String.valueOf(positionWords[0].charAt(0));
                if (positionWords.length == 2) {
                    positionCode = positionCode + positionWords[1].charAt(0);
                }
                OverlayDescriptor overlayDescriptor = new OverlayDescriptor((String)overlay.get("propertyName"), positionCode, (String)overlay.get("type"));
                maltegoEntity.addOverlay(overlayDescriptor);
            });
        });
        return maltegoEntity;
    }

    private MaltegoLink fromDto(Link link) throws Exception {
        LinkID linkId = LinkID.parse((String)link.getId());
        List<Property> properties = link.getProperties();
        boolean isTransformLink = this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_ID).isPresent();
        String type = isTransformLink ? "maltego.link.transform-link" : "maltego.link.manual-link";
        MaltegoLink maltegoLink = LinkFactory.getDefault().createInstance(type, linkId, false);
        for (Property property : properties) {
            if (this.isSpecialProperty(property, MaltegoLink.class)) continue;
            DisplayDescriptor pd = this.fromDto(property);
            Object value = this.toClientValue((PropertyDescriptor)pd, property);
            maltegoLink.setValue((PropertyDescriptor)pd, value);
        }
        this.getSpecialProperty(properties, NeoSpecialProperty.COLOR).map(prop -> (Color)Converter.convert((Object)prop.getValue(), Color.class)).ifPresent(color -> maltegoLink.setColor(color));
        String labelPropertyId = isTransformLink ? "maltego.link.label" : "maltego.link.manual.type";
        this.getSpecialProperty(properties, NeoSpecialProperty.LABEL).ifPresent(prop -> this.setProperty(maltegoLink, labelPropertyId, prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.DESCRIPTION).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.manual.description", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.SHOW_LABEL).ifPresent(prop -> maltegoLink.setShowLabel(((Integer)prop.getValue()).intValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.STYLE).ifPresent(prop -> maltegoLink.setStyle((Integer)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.THICKNESS).ifPresent(prop -> maltegoLink.setThickness((Integer)prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_ID).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.name", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_NAME).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.display-name", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_VERSION).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.version", prop.getValue()));
        this.getSpecialProperty(properties, NeoSpecialProperty.TRANSFORM_DATE).ifPresent(prop -> this.setProperty(maltegoLink, "maltego.link.transform.run-date", prop.getValue()));
        return maltegoLink;
    }

    private boolean isSpecialProperty(Property property, Class target) {
        Optional<NeoSpecialProperty> prop = NeoSpecialProperty.get(property.getId());
        return prop.isPresent() && prop.get().getTarget().equals(target);
    }

    private Optional<Property> getSpecialProperty(List<Property> properties, NeoSpecialProperty specialProperty) {
        return this.getProperty(properties, specialProperty.getId());
    }

    private Optional<Property> getProperty(List<Property> properties, String propertyId) {
        return properties.stream().filter(prop -> prop.getId().equals(propertyId)).findAny();
    }

    private void setProperty(MaltegoLink link, String propertyId, Object value) {
        try {
            PropertyDescriptor property = link.getProperties().get(propertyId);
            value = this.toClientValue(property, value);
            link.setValue(property, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private DisplayDescriptor fromDto(Property property) {
        String id = property.getId();
        String displayName = property.getDisplayName();
        TypeDescriptor clientType = TypeRegistry.getDefault().getType(property.getType());
        if (clientType == null) {
            Object value = property.getValue();
            boolean isArray = value != null && value instanceof List;
            String v2PropType = EntityPropTypeMapping.getDefault().getV2PropTypeName(property.getType(), isArray, false, new Object[]{value});
            if (isArray) {
                v2PropType = v2PropType + "[]";
            }
            clientType = TypeRegistry.getDefault().getType(v2PropType);
        }
        Class type = clientType.getType();
        DisplayDescriptor result = new DisplayDescriptor(type, id, displayName);
        return result;
    }

    private Object toClientValue(PropertyDescriptor pd, Property property) throws Exception {
        Object value = property.getValue();
        return this.toClientValue(pd, value);
    }

    private Object toClientValue(PropertyDescriptor pd, Object value) throws Exception {
        TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
        if (value instanceof List) {
            List list = (List)value;
            Object[] valueArr = list.toArray();
            value = Converter.changeArrayType((Object)valueArr, type.getType().getComponentType(), (boolean)true);
        } else if (type != null && "date".equals(type.getTypeName())) {
            if (value == null) {
                value = null;
            } else if (value instanceof Long) {
                value = Long.toString((Long)value);
            }
        } else if (type != null && "url".equals(type.getTypeName())) {
            if (value == null) {
                return null;
            }
            if (value instanceof String && StringUtilities.isNullOrEmpty((String)((String)value))) {
                return "";
            }
        } else if (type != null && "datetime".equals(type.getTypeName())) {
            if (value == null) {
                value = null;
            } else if (value instanceof String) {
                value = StringUtilities.isNullOrEmpty((String)((String)value)) ? null : Long.valueOf(DateTime.parse((String)((String)value)).getTime());
            }
        }
        value = this.partMapReader.translatePropertyValue(type, value);
        return value;
    }
}

