/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.maltego.tx3.java.api.discovery.EntityDefinition;
import com.maltego.tx3.java.api.discovery.IconDefinition;
import com.maltego.tx3.java.api.discovery.MachineDefinition;
import com.maltego.tx3.java.api.discovery.TransformSetDefinition;
import com.maltego.tx3.java.api.discovery.V3SeedResponse;
import com.maltego.tx3.java.api.discovery.V3Transforms;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.maltego.tx3.java.api.execution.TransformRunRequest;
import com.maltego.tx3.java.api.execution.TransformRunResponse;
import com.paterva.maltego.certificates.BlacklistedCertificateException;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.api.TransformDiscoverySettings;
import com.paterva.maltego.transform.protocol.api.proxy.HttpProxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ExceptionResponse;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.transform.protocol.v3.api.EntityDefinitions;
import com.paterva.maltego.transform.protocol.v3.api.IconDefinitions;
import com.paterva.maltego.transform.protocol.v3.api.MachineDefinitions;
import com.paterva.maltego.transform.protocol.v3.api.TransformSetDefinitions;
import com.paterva.maltego.transform.protocol.v3.api.V3ListTransformsCache;
import com.paterva.maltego.transform.protocol.v3.api.V3ProtocolEnabledProcessor;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.transform.runner.api.TransformTimeout;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.TraceContextId;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;

public class V3HttpProxy
extends HttpProxy {
    private static final Logger LOG = Logger.getLogger(V3HttpProxy.class.getName());
    private static final String API_KEY_HEADER = "Maltego-API-Key";
    private static final ProtocolVersion DEFAULT_V3_PROTOCOL = ProtocolVersion.V3_1;
    private final ObjectMapper mapper = new ObjectMapper();

    public V3HttpProxy(String transformApplication, String protocolVersion) {
        super(transformApplication, protocolVersion);
        V3HttpProxy.configureObjectMapper(this.mapper);
    }

    public V3HttpProxy(String transformApplication) {
        super(transformApplication, DEFAULT_V3_PROTOCOL.toString());
        V3HttpProxy.configureObjectMapper(this.mapper);
    }

    public static void configureObjectMapper(ObjectMapper mapper) {
        JavaTimeModule module = new JavaTimeModule();
        mapper.registerModule((Module)module);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        mapper.enable(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
    }

    public V3Transforms listTransforms(boolean httpsOnly) throws ProxyException, CertificateNeedValidationException, RemoteTransformFindException {
        TraceContextId traceContextId = TraceContextId.create();
        String url = this.transformApp + "/transforms";
        V3Transforms listTransformsResponse = V3ListTransformsCache.get(url);
        if (listTransformsResponse == null) {
            try {
                String maltegeApiKey = null;
                String response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(response);
                }
                listTransformsResponse = (V3Transforms)this.mapper.readValue(response, V3Transforms.class);
            }
            catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
                LOG.log(Level.SEVERE, String.format("Certificate error during list transform operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new RemoteTransformFindException(new ExceptionResponse((Exception)ex));
            }
            catch (JsonProcessingException ex) {
                LOG.log(Level.SEVERE, String.format("Error during list transform operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)((Object)ex));
            }
            catch (ProxyException | GeneralSecurityException ex) {
                LOG.log(Level.SEVERE, String.format("Error during list transform operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new ProxyException("Failed to retrieve the list of transforms from " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)ex);
            }
            if (listTransformsResponse != null) {
                V3ListTransformsCache.put(url, listTransformsResponse);
            }
        }
        return listTransformsResponse;
    }

    public List<EntityDefinition> listEntityDefinitions(boolean httpsOnly) {
        String url = this.transformApp + "/assets/entities";
        TraceContextId traceContextId = TraceContextId.create();
        String maltegeApiKey = null;
        String response = null;
        try {
            response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
            EntityDefinitions arr = (EntityDefinitions)this.mapper.readValue(response, EntityDefinitions.class);
            return new ArrayList<EntityDefinition>(arr);
        }
        catch (JsonProcessingException | BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException | ProxyException | GeneralSecurityException ex) {
            try {
                TransformRunResponse errorResponse = (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
                LOG.log(Level.SEVERE, errorResponse.getStatus().getUiMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", ")));
                return new ArrayList<EntityDefinition>();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error during entity definition fetch operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new RuntimeException(ex);
            }
        }
    }

    public List<IconDefinition> listIcons(boolean httpsOnly) {
        String url = this.transformApp + "/assets/icons";
        TraceContextId traceContextId = TraceContextId.create();
        String maltegeApiKey = null;
        String response = null;
        try {
            response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
            IconDefinitions arr = (IconDefinitions)this.mapper.readValue(response, IconDefinitions.class);
            return new ArrayList<IconDefinition>(arr);
        }
        catch (JsonProcessingException | BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException | ProxyException | GeneralSecurityException ex) {
            try {
                TransformRunResponse errorResponse = (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
                LOG.log(Level.SEVERE, errorResponse.getStatus().getUiMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", ")));
                return new ArrayList<IconDefinition>();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error during icon fetch operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new RuntimeException(ex);
            }
        }
    }

    public List<TransformSetDefinition> listTransformSets(boolean httpsOnly) {
        String url = this.transformApp + "/assets/sets";
        TraceContextId traceContextId = TraceContextId.create();
        String maltegeApiKey = null;
        String response = null;
        try {
            response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
            TransformSetDefinitions arr = (TransformSetDefinitions)this.mapper.readValue(response, TransformSetDefinitions.class);
            return new ArrayList<TransformSetDefinition>(arr);
        }
        catch (JsonProcessingException | BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException | ProxyException | GeneralSecurityException ex) {
            try {
                TransformRunResponse errorResponse = (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
                LOG.log(Level.SEVERE, errorResponse.getStatus().getUiMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", ")));
                return new ArrayList<TransformSetDefinition>();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error during transform set fetch operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new RuntimeException(ex);
            }
        }
    }

    public List<MachineDefinition> listMachines(boolean httpsOnly) {
        String url = this.transformApp + "/assets/machines";
        TraceContextId traceContextId = TraceContextId.create();
        String maltegeApiKey = null;
        String response = null;
        try {
            response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
            MachineDefinitions arr = (MachineDefinitions)this.mapper.readValue(response, MachineDefinitions.class);
            return new ArrayList<MachineDefinition>(arr);
        }
        catch (JsonProcessingException | BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException | ProxyException | GeneralSecurityException ex) {
            try {
                TransformRunResponse errorResponse = (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
                LOG.log(Level.SEVERE, errorResponse.getStatus().getUiMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", ")));
                return new ArrayList<MachineDefinition>();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, String.format("Error during machines fetch operation for URL: %s with trace context id: %s", url, traceContextId));
                throw new RuntimeException(ex);
            }
        }
    }

    public V3SeedResponse getDiscoveryInfo(boolean httpsOnly) throws ProxyException, CertificateNeedValidationException, RemoteTransformFindException {
        String url = this.transformApp;
        TraceContextId traceContextId = TraceContextId.create();
        String maltegeApiKey = null;
        try {
            String response = this.doGet(url, maltegeApiKey, httpsOnly, TransformDiscoverySettings.getDiscoveryTimeout(), true, traceContextId);
            return (V3SeedResponse)this.mapper.readValue(response, V3SeedResponse.class);
        }
        catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.SEVERE, String.format("Certificate error during discovery operation operation for URL: %s with trace context id: %s", url, traceContextId));
            throw new RemoteTransformFindException(new ExceptionResponse((Exception)ex));
        }
        catch (ProxyException | GeneralSecurityException ex) {
            LOG.log(Level.SEVERE, String.format("Error during discovery operation for URL: %s with trace context id: %s", url, traceContextId));
            throw new ProxyException("Failed to fetch the discovery info for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)ex);
        }
        catch (JsonProcessingException ex) {
            LOG.log(Level.SEVERE, String.format("Error during discovery operation for URL: %s with trace context id: %s", url, traceContextId));
            throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)((Object)ex));
        }
    }

    private String doGet(String url, String key, boolean httpsOnly, int timeout, boolean retryRequest, TraceContextId traceContextId) throws ProxyException, CertificateNeedValidationException, BlacklistedCertificateException, NoTrustedCertificateChainFoundException, GeneralSecurityException {
        return this.doGet(url, key, httpsOnly, true, timeout, retryRequest, traceContextId);
    }

    private String doGet(String url, String key, boolean httpsOnly, boolean keepAlive, int timeout, boolean retryRequest, TraceContextId traceContextId) throws ProxyException, CertificateNeedValidationException, BlacklistedCertificateException, NoTrustedCertificateChainFoundException, GeneralSecurityException {
        HttpAgent agent = null;
        try {
            LOG.log(Level.FINE, "Get from {0}", url);
            agent = new HttpAgent(new URL(url));
            agent.setConnectTimeout(timeout);
            agent.setReadTimeout(timeout);
            if (V3ProtocolEnabledProcessor.V3_PROTOCOL_ENABLED) {
                agent.setAcceptContentType("application/json");
            }
            V3HttpProxy.createExceptionFromCertificateActionIfPresent((HttpAgent)agent, (String)url, (boolean)httpsOnly);
            this.setRequestAuth(agent, key, url);
            agent.setRequestHeader("traceparent", traceContextId.toString());
            agent.setRequestHeader("maltego-protocol-version", this.getProtocolVersion());
            agent.doGet(keepAlive, retryRequest);
            String string = this.readResponse(agent);
            return string;
        }
        catch (CertificateNeedValidationException ex) {
            throw ex;
        }
        catch (IOException ex) {
            String msg = "HTTP error for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId.toString();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                msg = String.format("%s Trace Context ID: %s", msg, traceContextId.toString());
            }
            throw new ProxyException(msg, (Exception)ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
    }

    public TransformRunResponse doTransform(String transformId, TransformRunRequest request, String key, TraceContextId traceContextId) throws ProxyException, JsonProcessingException, TransformRunException {
        String requestBody = this.mapper.writeValueAsString((Object)request);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Running V3 transform:\n{0}", requestBody);
        }
        String url = String.format("%s/transforms/%s/run", this.transformApp, transformId);
        try {
            String response = this.doPost(url, requestBody, key, true, traceContextId);
            return (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
        }
        catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.SEVERE, String.format("Certificate error during transform execution for transform: %s with trace context id: %s", transformId, traceContextId));
            throw new TransformRunException((Exception)ex);
        }
        catch (ProxyException | GeneralSecurityException ex) {
            LOG.log(Level.SEVERE, String.format("Error during transform execution for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId));
            throw new ProxyException("Failed to execute transform " + transformId + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)ex);
        }
        catch (JsonProcessingException ex) {
            LOG.log(Level.SEVERE, String.format("Error during transform execution for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId));
            throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)((Object)ex));
        }
    }

    public TransformRunResponse getTransformResults(long eventPointer, int eventLimit, String transformId, String runId, String key, TraceContextId traceContextId) throws ProxyException, TransformRunException {
        String url = String.format("%s/transforms/%s/run/%s/results?eventPointer=%s&eventLimit=%s", this.transformApp, transformId, runId, eventPointer, eventLimit);
        try {
            String response = this.doGet(url, key, true, true, TransformTimeout.getResultFetchTimeout(), true, traceContextId);
            return (TransformRunResponse)this.mapper.readValue(response, TransformRunResponse.class);
        }
        catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.SEVERE, String.format("Certificate error during transform result fetching for transform: %s with trace context id: %s", transformId, traceContextId));
            throw new TransformRunException((Exception)ex);
        }
        catch (ProxyException | GeneralSecurityException ex) {
            LOG.log(Level.SEVERE, String.format("Error fetching transform results for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId));
            throw new ProxyException("Failed to fetch transform results for transform " + transformId + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)ex);
        }
        catch (JsonProcessingException ex) {
            LOG.log(Level.SEVERE, String.format("Error during transform execution for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId));
            throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)((Object)ex));
        }
    }

    private String doPost(String url, String requestBody, String key, boolean httpsOnly, TraceContextId traceContextId) throws ProxyException, CertificateNeedValidationException, BlacklistedCertificateException, NoTrustedCertificateChainFoundException, GeneralSecurityException, TransformRunException {
        HttpAgent agent = null;
        try {
            LOG.log(Level.FINE, "POST to {0}", url);
            agent = new HttpAgent(new URL(url));
            agent.setConnectTimeout(TransformTimeout.getTimeout());
            agent.setReadTimeout(TransformTimeout.getTimeout());
            this.setRequestAuth(agent, key, url);
            agent.setRequestHeader("traceparent", traceContextId.toString());
            agent.setRequestHeader("maltego-protocol-version", this.getProtocolVersion());
            String msg = this.checkValidCertificate(agent);
            if (msg != null) {
                throw new TransformRunException(msg);
            }
            V3HttpProxy.createExceptionFromCertificateActionIfPresent((HttpAgent)agent, (String)url, (boolean)httpsOnly);
            agent.doPost("application/json", requestBody, true);
            String string = this.readResponse(agent);
            return string;
        }
        catch (CertificateNeedValidationException ex) {
            throw ex;
        }
        catch (IOException ex) {
            String msg = "HTTP error for " + url + ": " + ex.getMessage() + " Trace Context ID: " + traceContextId.toString();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
            }
            throw new ProxyException(msg, (Exception)ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
    }

    public void deleteTransformRun(String transformId, String runId, String maltegoApiKey, TraceContextId traceContextId, Boolean cancelledByUser) throws TransformRunException, ProxyException {
        String url = String.format("%s/transforms/%s/run/%s", this.transformApp, transformId, runId);
        try {
            this.doDelete(url, maltegoApiKey, true, traceContextId, cancelledByUser);
        }
        catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.SEVERE, String.format("Certificate error during transform delete request: %s with trace context id: %s", transformId, traceContextId));
            throw new TransformRunException((Exception)ex);
        }
        catch (ProxyException | GeneralSecurityException ex) {
            LOG.log(Level.SEVERE, String.format("Error deleting transform run for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId));
            throw new ProxyException("Failed to delete transform " + transformId + ": " + ex.getMessage() + ". Trace ID: " + traceContextId, (Exception)ex);
        }
    }

    void doDelete(String url, String key, boolean httpsOnly, TraceContextId traceContextId, Boolean cancelledByUser) throws GeneralSecurityException, NoTrustedCertificateChainFoundException, TransformRunException, CertificateNeedValidationException, BlacklistedCertificateException, ProxyException {
        HttpAgent agent = null;
        try {
            if (cancelledByUser.booleanValue()) {
                url = url.concat("?Cancelled=true");
            }
            LOG.log(Level.FINE, "DELETE to {0} with Trace ID: {1}", new Object[]{url, traceContextId.toString()});
            agent = new HttpAgent(new URL(url));
            agent.setConnectTimeout(TransformTimeout.getTimeout());
            agent.setReadTimeout(TransformTimeout.getTimeout());
            this.setRequestAuth(agent, key, url);
            agent.setRequestHeader("traceparent", traceContextId.toString());
            agent.setRequestHeader("maltego-protocol-version", this.getProtocolVersion());
            String msg = this.checkValidCertificate(agent);
            if (msg != null) {
                throw new TransformRunException(msg);
            }
            V3HttpProxy.createExceptionFromCertificateActionIfPresent((HttpAgent)agent, (String)url, (boolean)httpsOnly);
            agent.doDelete(false);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, String.format("Error deleting transform run URL: %s and Trace Context ID: %s", url, traceContextId));
            String msg = "HTTP error for " + url + ": " + ex.getMessage() + ". Trace Context ID: " + traceContextId;
            throw new ProxyException(msg, (Exception)ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
    }

    public void postPromptResponse(TransformRunPromptResponse response, String promptId, String transformId, String runId, String key, TraceContextId traceContextId) throws ProxyException, JsonProcessingException, TransformRunException {
        String requestBody = this.mapper.writeValueAsString((Object)response);
        String url = String.format("%s/transforms/%s/run/%s/prompts/%s", this.transformApp, transformId, runId, promptId);
        try {
            this.doPost(url, requestBody, key, true, traceContextId);
        }
        catch (BlacklistedCertificateException | CertificateNeedValidationException | NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.SEVERE, String.format("Certificate error whilst sending prompt response for transform: %s with trace context id: %s", transformId, traceContextId));
            throw new TransformRunException((Exception)ex);
        }
        catch (ProxyException | TransformRunException | GeneralSecurityException ex) {
            String errorMessage = String.format("Error posting prompt selection for Transform ID: %s and Trace Context ID: %s", transformId, traceContextId);
            LOG.log(Level.SEVERE, errorMessage);
            throw new ProxyException(errorMessage);
        }
    }

    private void setRequestAuth(HttpAgent agent, String key, String url) throws IOException {
        String accessToken = this.getAccessToken(url);
        if (!StringUtilities.isNullOrEmpty((String)accessToken)) {
            agent.setAccessToken(accessToken);
        } else if (key != null) {
            agent.setRequestHeader(API_KEY_HEADER, key);
        }
    }

    private String getAccessToken(String url) throws IOException {
        return LicenseManager.A().H(url);
    }
}

