/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.view;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.ui.view.CertificateDetailView;
import com.paterva.maltego.util.ui.components.HeadingTextAndIcon;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.components.ScrollablePanel;
import com.paterva.maltego.util.ui.look.Look;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CertificateTabbedView
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CertificateTabbedView.class.getName());
    private final ExplorerManager _explorer;
    private Node _boundItem;
    private PropertyChangeListener _listener;
    boolean _resize = true;
    private JPanel _basicInfoPane;
    private JPanel _contentPane;
    private HeadingTextAndIcon _headingTextIcon;
    public JPanel _infoPane;
    private JLabel _issuerCountryLabel;
    private JLabel _issuerCountryValue;
    private JLabel _issuerNameLabel;
    private JLabel _issuerNameValue;
    private JLabel _issuerOrgLabel;
    private JLabel _issuerOrgValue;
    private JPanel _issuerPanel;
    private JLabel _issuerValidFromLabel;
    private JLabel _issuerValidFromValue;
    private JLabel _issuerValidToLabel;
    private JLabel _issuerValidToValue;
    private JLabel _subjectCountryLabel;
    private JLabel _subjectCountryValue;
    private JLabel _subjectNameLabel;
    private JLabel _subjectNameValue;
    private JLabel _subjectOrgLabel;
    private JLabel _subjectOrgValue;
    private JPanel _subjectPanel;
    private JPanel jPanel2;
    private JTabbedPane jTabbedPane1;

    public CertificateTabbedView(X509Certificate cert, String message) {
        this.initComponents();
        this._explorer = null;
        this.initPanel(null, cert, message);
        if (cert != null) {
            CertificateRepository certRepo = CertificateRepository.getDefault();
            CertificateDefinition certDef = certRepo.get(cert);
            if (certDef == null) {
                certDef = new CertificateDefinition(cert);
            }
            try {
                this.bindCertificate(certDef);
            }
            catch (GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public CertificateTabbedView(ExplorerManager.Provider provider) {
        this.initComponents();
        this._explorer = provider.getExplorerManager();
        this.initPanel(provider, null, null);
        this.bindExplorer();
    }

    private void bindExplorer() {
        this._explorer.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = this._explorer.getSelectedNodes();
                this.bindItems(nodes);
            }
        });
    }

    public void bindItems(Node[] items) {
        if (items.length == 1) {
            if (this._boundItem != null) {
                this._boundItem.removePropertyChangeListener(this._listener);
            }
            this._boundItem = items[0];
            this._listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this._boundItem);
            this._boundItem.addPropertyChangeListener(this._listener);
            this.bindItem(this._boundItem);
        } else {
            this.setDefaultValues();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this._boundItem != null) {
            this.bindItem(this._boundItem);
        }
    }

    private void bindItem(Node item) {
        CertificateDefinition certDef = (CertificateDefinition)item.getLookup().lookup(CertificateDefinition.class);
        if (certDef != null) {
            try {
                this.bindCertificate(certDef);
            }
            catch (GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bindCertificate(CertificateDefinition certDef) throws GeneralSecurityException {
        X509Certificate cert = certDef.getCertificate();
        if (cert != null) {
            this._subjectNameValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getName()));
            this._subjectOrgValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getOrg()));
            this._subjectCountryValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getCountry()));
            this._issuerNameValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getName()));
            this._issuerOrgValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getOrg()));
            this._issuerCountryValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getCountry()));
            this._issuerValidFromValue.setText(CertificateUtils.getDisplayString((String)CertificateUtils.toDateString((Date)cert.getNotBefore())));
            this._issuerValidToValue.setText(CertificateUtils.getDisplayString((String)CertificateUtils.toDateString((Date)cert.getNotAfter())));
        }
    }

    private void setDefaultValues() {
        String defaultString = CertificateUtils.getDisplayString(null);
        this._subjectNameValue.setText(defaultString);
        this._subjectOrgValue.setText(defaultString);
        this._subjectCountryValue.setText(defaultString);
        this._issuerNameValue.setText(defaultString);
        this._issuerOrgValue.setText(defaultString);
        this._issuerCountryValue.setText(defaultString);
        this._issuerValidFromValue.setText(defaultString);
        this._issuerValidToValue.setText(defaultString);
    }

    private void initPanel(ExplorerManager.Provider provider, X509Certificate cert, String message) {
        Color basePanelBg = Look.getColor((String)"transform-manager-base-panel-bg");
        this._basicInfoPane.setBackground(basePanelBg);
        Color groupTitleColor = Look.getColor((String)"transform-manager-group-panel-title");
        ((TitledBorder)this._subjectPanel.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this._issuerPanel.getBorder()).setTitleColor(groupTitleColor);
        this._infoPane.setBorder(new LineBorder(basePanelBg, 10));
        if (message == null) {
            this._headingTextIcon.setVisible(false);
        } else {
            this._headingTextIcon.setText(message);
            Image image = ImageUtilities.loadImage((String)"com/paterva/maltego/certificates/ui/resources/Certificate48.png");
            this._headingTextIcon.addIcon((Object)image);
            this._headingTextIcon.setInsets(new Insets(0, 0, 6, 0));
        }
        this._contentPane.setBackground(basePanelBg);
        this._contentPane.setLayout(new BorderLayout());
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        CertificateDetailView detailView = provider != null ? new CertificateDetailView(provider) : new CertificateDetailView(cert);
        this._basicInfoPane.remove(this._infoPane);
        JScrollPane scrollPaneBasic = CertificateTabbedView.createScrollableView(this._infoPane);
        scrollPaneBasic.getViewport().setBackground(basePanelBg);
        this._infoPane.setBackground(basePanelBg);
        this._infoPane.setOpaque(true);
        this._basicInfoPane.add((Component)scrollPaneBasic, "Center");
        detailView.setBackground(laf.getColor("transform-manager-lowlight-bg"));
        detailView.setBorder(new LineBorder(basePanelBg, 5));
        JScrollPane scrollPaneDetail = CertificateTabbedView.createScrollableView(detailView);
        this._contentPane.add(scrollPaneDetail);
    }

    private static JScrollPane createScrollableView(JPanel panel) {
        JScrollPane scrollPane = new JScrollPane();
        ScrollablePanel scrollablePanel = new ScrollablePanel(new BorderLayout()){

            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 16;
            }

            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
            }
        };
        scrollablePanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        scrollablePanel.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.NONE);
        scrollablePanel.add((Component)panel, (Object)"Center");
        scrollPane.setViewportView((Component)scrollablePanel);
        return scrollPane;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int screenHeight = Utilities.getUsableScreenBounds().height;
        size.height = Math.min(size.height, screenHeight - 200);
        return size;
    }

    @Override
    public void doLayout() {
        super.doLayout();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this._basicInfoPane = new JPanel();
        this._headingTextIcon = new HeadingTextAndIcon();
        this._infoPane = new JPanel();
        this._subjectPanel = new JPanel();
        this._subjectCountryLabel = new JLabel();
        this._subjectCountryValue = new JLabel();
        this._subjectOrgLabel = new JLabel();
        this._subjectOrgValue = new JLabel();
        this._subjectNameLabel = new JLabel();
        this._subjectNameValue = new JLabel();
        this.jPanel2 = new JPanel();
        this._issuerPanel = new JPanel();
        this._issuerCountryLabel = new JLabel();
        this._issuerCountryValue = new JLabel();
        this._issuerOrgLabel = new JLabel();
        this._issuerOrgValue = new JLabel();
        this._issuerNameLabel = new JLabel();
        this._issuerNameValue = new JLabel();
        this._issuerValidFromLabel = new JLabel();
        this._issuerValidFromValue = new JLabel();
        this._issuerValidToLabel = new JLabel();
        this._issuerValidToValue = new JLabel();
        this._contentPane = new JPanel();
        this.setPreferredSize(new Dimension(600, 420));
        this.setLayout(new BorderLayout(0, 5));
        this._basicInfoPane.setLayout(new BorderLayout());
        this._basicInfoPane.add((Component)this._headingTextIcon, "North");
        this._infoPane.setOpaque(false);
        this._infoPane.setLayout(new BorderLayout(0, 5));
        this._subjectPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectPanel.border.title")));
        this._subjectPanel.setOpaque(false);
        this._subjectPanel.setLayout(new GridBagLayout());
        this._subjectCountryLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._subjectCountryLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectCountryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectCountryLabel, gridBagConstraints);
        this._subjectCountryValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._subjectCountryValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectCountryValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectCountryValue, gridBagConstraints);
        this._subjectOrgLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._subjectOrgLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectOrgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectOrgLabel, gridBagConstraints);
        this._subjectOrgValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._subjectOrgValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectOrgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectOrgValue, gridBagConstraints);
        this._subjectNameLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._subjectNameLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._subjectPanel.add((Component)this._subjectNameLabel, gridBagConstraints);
        this._subjectNameValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._subjectNameValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._subjectNameValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._subjectPanel.add((Component)this._subjectNameValue, gridBagConstraints);
        this._infoPane.add((Component)this._subjectPanel, "North");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BorderLayout());
        this._issuerPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerPanel.border.title")));
        this._issuerPanel.setOpaque(false);
        this._issuerPanel.setLayout(new GridBagLayout());
        this._issuerCountryLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._issuerCountryLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerCountryLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerCountryLabel, gridBagConstraints);
        this._issuerCountryValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._issuerCountryValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerCountryValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerCountryValue, gridBagConstraints);
        this._issuerOrgLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._issuerOrgLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerOrgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerOrgLabel, gridBagConstraints);
        this._issuerOrgValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._issuerOrgValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerOrgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerOrgValue, gridBagConstraints);
        this._issuerNameLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._issuerNameLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerNameLabel, gridBagConstraints);
        this._issuerNameValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._issuerNameValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerNameValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerNameValue, gridBagConstraints);
        this._issuerValidFromLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._issuerValidFromLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerValidFromLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidFromLabel, gridBagConstraints);
        this._issuerValidFromValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._issuerValidFromValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerValidFromValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidFromValue, gridBagConstraints);
        this._issuerValidToLabel.setForeground(Look.getColor((String)"certificate-manager-key-fg"));
        this._issuerValidToLabel.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerValidToLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidToLabel, gridBagConstraints);
        this._issuerValidToValue.setForeground(Look.getColor((String)"certificate-manager-value-fg"));
        this._issuerValidToValue.setText(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._issuerValidToValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidToValue, gridBagConstraints);
        this.jPanel2.add((Component)this._issuerPanel, "North");
        this._infoPane.add((Component)this.jPanel2, "Center");
        this._basicInfoPane.add((Component)this._infoPane, "Center");
        this.jTabbedPane1.addTab(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._basicInfoPane.TabConstraints.tabTitle"), this._basicInfoPane);
        GroupLayout _contentPaneLayout = new GroupLayout(this._contentPane);
        this._contentPane.setLayout(_contentPaneLayout);
        _contentPaneLayout.setHorizontalGroup(_contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 618, Short.MAX_VALUE));
        _contentPaneLayout.setVerticalGroup(_contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 391, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(CertificateTabbedView.class, (String)"CertificateTabbedView._contentPane.TabConstraints.tabTitle"), this._contentPane);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

