/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.table.ui.actions.TabularGraphOpenAction;
import com.paterva.maltego.graph.table.ui.wizard.ImportWizard;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.GraphMergerFactory;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class TabularGraphImportAction
extends SystemAction {
    public static final String ICON_RESOURCE = "com/paterva/maltego/graph/table/ui/resources/ImportTabularGraph.png";

    public String getName() {
        return "Import a 3rd Party Table";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            this.perform(Lookup.getDefault());
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void perform(Lookup lookup) throws GraphStoreException {
        WizardDescriptor wd = ImportWizard.create();
        if (WizardUtilities.runWizard((WizardDescriptor)wd)) {
            ImportWizard.setPreviousFile((File)wd.getProperty("selectedFile"));
            ImportWizard.setPreviousDir((String)wd.getProperty("browseDir"));
            GraphID graphID = (GraphID)wd.getProperty("importedGraphID");
            boolean newGraph = (Boolean)wd.getProperty("newGraph");
            if (newGraph) {
                List files = (List)wd.getProperty("files");
                this.openNewGraph(graphID, ((File)files.get(0)).getName());
            } else {
                MatchingRuleDescriptor entityRule = (MatchingRuleDescriptor)wd.getProperty("entityMatchingRule");
                MatchingRuleDescriptor linkRule = (MatchingRuleDescriptor)wd.getProperty("linkMatchingRule");
                this.mergeWithTopGraph(graphID, entityRule, linkRule);
                this.close(graphID);
            }
        }
    }

    private void newGraphOpened(GraphID memGraphID, GraphID graphID, String name) {
        try {
            int extensionStart = name.lastIndexOf(46);
            if (extensionStart > 0) {
                name = name.substring(0, extensionStart);
            }
            TabularGraphOpenAction openAction = (TabularGraphOpenAction)SystemAction.get(TabularGraphOpenAction.class);
            openAction.setGraph(graphID, name);
            openAction.performAction();
            this.close(memGraphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void openNewGraph(GraphID memGraphID, String name) throws GraphStoreException {
        WindowUtil.showWaitCursor();
        Thread thread = new Thread(() -> {
            try {
                GraphID graphID = GraphCopyHelper.copy((GraphID)memGraphID, (boolean)false);
                SwingUtilities.invokeLater(() -> this.newGraphOpened(memGraphID, graphID, name));
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(WindowUtil::hideWaitCursor);
        });
        thread.start();
    }

    private void close(GraphID memGraphID) throws GraphStoreException {
        GraphLifeCycleManager.getDefault().fireGraphClosing(memGraphID);
        GraphStore memGraphStore = GraphStoreRegistry.getDefault().forGraphID(memGraphID);
        memGraphStore.close(true);
        GraphLifeCycleManager.getDefault().fireGraphClosed(memGraphID);
    }

    private void mergeWithTopGraph(GraphID srcGraphID, MatchingRuleDescriptor entityRule, MatchingRuleDescriptor linkRule) {
        GraphMatchStrategy matchStrat = new GraphMatchStrategy(entityRule, linkRule);
        GraphMergeStrategy.PreferNew mergeStrat = new GraphMergeStrategy.PreferNew();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)srcGraphID);
        String entityDescription = GraphTransactionHelper.getDescriptionForEntitiesItr((GraphID)srcGraphID, (Iterable)entities, (boolean)true);
        String description = String.format("Tabular import %s", entityDescription);
        GraphView graphView = this.getTopGraphView();
        GraphMerger merger = GraphMergerFactory.getDefault().create(new SimilarStrings(description), matchStrat, (GraphMergeStrategy)mergeStrat, null, true, true, true);
        GraphID destGraphID = GraphViewManager.getDefault().getGraphID(graphView.getViewGraph());
        merger.setGraphs(destGraphID, srcGraphID, null);
        merger.append();
        graphView.doLayout();
    }

    private GraphView getTopGraphView() {
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null) {
            GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
            return cookie.getGraphView();
        }
        return null;
    }
}

