/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.FastURL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformSeed {
    private static final Logger LOG = Logger.getLogger(TransformSeed.class.getName());
    private String _displayName;
    private String _description;
    private FastURL _url;
    private boolean _enabled = true;
    private DisplayDescriptorCollection _globalTxProperties;
    private DataSources.Map _globalTxSettings;

    public TransformSeed(FastURL url, String displayName) {
        this(url, displayName, "", null, null);
    }

    public TransformSeed(FastURL url, String displayName, String description, DisplayDescriptorCollection globalTxProperties, DataSource globalTxSettings) {
        this._url = url;
        this._displayName = displayName;
        this._description = description;
        this._globalTxProperties = globalTxProperties;
        this._globalTxSettings = new DataSources.Map();
        if (globalTxProperties != null && globalTxSettings != null) {
            for (DisplayDescriptor property : globalTxProperties) {
                this._globalTxSettings.setValue((PropertyDescriptor)property, globalTxSettings.getValue((PropertyDescriptor)property));
            }
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public FastURL getUrl() {
        return this._url;
    }

    public void setUrl(FastURL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        this._url = url;
    }

    public DisplayDescriptorCollection getGlobalTxProperties() {
        return this._globalTxProperties;
    }

    public void setGlobalTxProperties(DisplayDescriptorCollection globalTxProperties) {
        this._globalTxProperties = globalTxProperties;
        this.updateGlobalTxSettingTypes();
    }

    public DataSources.Map getGlobalTxSettings() {
        return this._globalTxSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalTxSettingTypes() {
        DataSources.Map globalTxSettings = new DataSources.Map();
        for (Map.Entry entry : this._globalTxSettings.entrySet()) {
            PropertyDescriptor pd = (PropertyDescriptor)entry.getKey();
            DisplayDescriptor dd = this._globalTxProperties.get(pd.getName());
            if (dd != null) {
                Class fromType = pd.getType();
                Class toType = dd.getType();
                Object settingValue = entry.getValue();
                if (!fromType.equals(toType)) {
                    try {
                        if (settingValue == null) continue;
                        settingValue = Converter.convert(settingValue, (Class)fromType, (Class)toType);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.FINE, "Failed to convert the existing value of {0} for property {1} to type {2}", new Object[]{settingValue, dd.getName(), toType.getName()});
                        continue;
                    }
                    finally {
                        globalTxSettings.put((Object)new PropertyDescriptor(toType, pd.getName(), pd.getDisplayName()), settingValue);
                        continue;
                    }
                }
                globalTxSettings.put((Object)pd, settingValue);
                continue;
            }
            globalTxSettings.put(entry.getKey(), entry.getValue());
        }
        this._globalTxSettings = globalTxSettings;
    }

    public String toString() {
        return this.getDisplayName() + ": " + this.getUrl();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }
}

