/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IMessageWriter;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.WriteCompletionManager;
import org.xsocket.Execution;
import org.xsocket.IDataSink;
import org.xsocket.IDestroyable;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BodyDataSink
implements IDataSink,
IDestroyable,
Flushable,
Closeable,
WritableByteChannel,
GatheringByteChannel {
    private static final Logger LOG = Logger.getLogger(BodyDataSink.class.getName());
    private final NonBlockingStream nonBlockingStream = new NonBlockingStream();
    private final ArrayList<IBodyCloseListener> closeListeners = new ArrayList();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    private final AbstractHttpConnection httpConnection;
    private final String connectionId;
    private IMessageWriter messageWriter;
    private AtomicBoolean isOpen = new AtomicBoolean(true);
    private final WriteCompletionManager writeCompletionManager;
    private final Object writeCompletionGuard = new Object();

    BodyDataSink(AbstractHttpConnection httpConnection, AbstractHttpConnection.IMultimodeExecutor executor, IMessageWriter bodySerializer, String characterEncoding) throws IOException {
        this.httpConnection = httpConnection;
        this.executor = executor;
        this.messageWriter = bodySerializer;
        if (httpConnection != null) {
            this.httpConnection.setBodyDataSink(this);
            this.connectionId = httpConnection.getId();
        } else {
            this.connectionId = "<unset>";
        }
        this.writeCompletionManager = new WriteCompletionManager(this.connectionId);
        this.setFlushmode(IConnection.FlushMode.SYNC);
        this.setEncoding(characterEncoding);
    }

    String getId() {
        return this.connectionId;
    }

    IMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    void setMessageWriter(IMessageWriter bodyWriter) {
        this.messageWriter = bodyWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCloseListener(IBodyCloseListener closeListener) {
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.add(closeListener);
        }
    }

    boolean isNetworkEndpoint() {
        if (this.messageWriter == null) {
            return false;
        }
        return this.messageWriter.isNetworkEndpoint();
    }

    int getPendingWriteDataSize() {
        if (this.messageWriter == null) {
            return 0;
        }
        return this.messageWriter.getPendingWriteDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseListener(IBodyCloseListener closeListener) {
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            return this.closeListeners.remove(closeListener);
        }
    }

    @Override
    public void flush() throws IOException {
        this.nonBlockingStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.isOpen.set(false);
        if (this.httpConnection != null) {
            this.httpConnection.removeBodyDataSink(this);
        }
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.connectionId + "] error occured by flushing BodyDataSink " + e.toString());
            }
            throw new IOException(e.toString());
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.connectionId + "] closing body serializer " + this.messageWriter);
            }
            this.messageWriter.close();
            this.callCloseListener();
        }
    }

    public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.nonBlockingStream.write(buffers, writeCompletionHandler);
    }

    public long transferFrom(FileChannel source) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.transferFrom(source);
    }

    public long transferFrom(NonBlockingBodyDataSource source) throws IOException {
        return source.transferTo(this);
    }

    public long transferFrom(NonBlockingBodyDataSource source, int length) throws IOException {
        return source.transferTo(this, length);
    }

    public long transferFrom(BlockingBodyDataSource source) throws IOException {
        return source.transferTo(this);
    }

    public long transferFrom(BlockingBodyDataSource source, int length) throws IOException {
        return source.transferTo(this);
    }

    public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.transferFrom(source);
    }

    public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.transferFrom(source, chunkSize);
    }

    public int write(byte b) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(b);
    }

    public int write(byte ... bytes) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(bytes);
    }

    public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(bytes, offset, length);
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(buffer);
    }

    @Override
    public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(buffers);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.nonBlockingStream.write(srcs, offset, length);
    }

    public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
        return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public int write(int i) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(i);
    }

    public int write(short s) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(s);
    }

    public int write(long l) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(l);
    }

    public int write(double d) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(d);
    }

    public int write(String message) throws IOException, BufferOverflowException {
        return this.nonBlockingStream.write(message);
    }

    public final void setEncoding(String defaultEncoding) {
        this.nonBlockingStream.setEncoding(defaultEncoding);
    }

    public final String getEncoding() {
        return this.nonBlockingStream.getEncoding();
    }

    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.nonBlockingStream.setFlushmode(flushMode);
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.nonBlockingStream.getFlushmode();
    }

    public final void setAutoflush(boolean autoflush) {
        this.nonBlockingStream.setAutoflush(autoflush);
    }

    public final boolean isAutoflush() {
        return this.nonBlockingStream.isAutoflush();
    }

    public final void markWritePosition() {
        this.nonBlockingStream.markWritePosition();
    }

    public final boolean resetToWriteMark() {
        return this.nonBlockingStream.resetToWriteMark();
    }

    public final void removeWriteMark() {
        this.nonBlockingStream.removeWriteMark();
    }

    public final void setAttachment(Object obj) {
        this.nonBlockingStream.setAttachment(obj);
    }

    public final Object getAttachment() {
        return this.nonBlockingStream.getAttachment();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    void onUnderlyingHttpConnectionClosed() {
        if (this.isOpen.get()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.connectionId + "] underlying connection is closed. closing data source");
            }
            this.isOpen.set(false);
            this.messageWriter.destroy();
            this.callCloseListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callCloseListener() {
        ArrayList closeListenersCopy = null;
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            closeListenersCopy = (ArrayList)this.closeListeners.clone();
        }
        for (IBodyCloseListener bodyCloseListener : closeListenersCopy) {
            this.removeCloseListener(bodyCloseListener);
            this.callCloseListener(bodyCloseListener);
        }
    }

    private void callCloseListener(IBodyCloseListener listener) {
        CloseListenerCaller task = new CloseListenerCaller(listener);
        if (HttpUtils.isBodyCloseListenerMutlithreaded(listener)) {
            this.executor.processMultithreaded(task);
        } else {
            this.executor.processNonthreaded(task);
        }
    }

    public void destroy() {
        this.isOpen.set(false);
        this.messageWriter.destroy();
        this.callCloseListener();
    }

    public String toString() {
        return this.nonBlockingStream.toString();
    }

    private final class NonBlockingStream
    extends AbstractNonBlockingStream {
        private boolean isContentImmutable = true;

        private NonBlockingStream() {
        }

        public boolean isOpen() {
            return BodyDataSink.this.isOpen();
        }

        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            if (super.getFlushmode() == IConnection.FlushMode.SYNC) {
                this.isContentImmutable = false;
            }
            return super.write(buffer);
        }

        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            if (super.getFlushmode() == IConnection.FlushMode.SYNC) {
                this.isContentImmutable = false;
            }
            return super.write(buffers);
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (super.getFlushmode() == IConnection.FlushMode.SYNC) {
                this.isContentImmutable = false;
            }
            return super.write(srcs, offset, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            Object object = BodyDataSink.this.writeCompletionGuard;
            synchronized (object) {
                boolean isSuppressReuseBuffer = this.isSuppressReuseBufferWarning();
                this.setSuppressReuseBufferWarning(true);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyDataSink.this.connectionId + "] {" + buffers.hashCode() + "} Writing with completion handler. Register handler " + writeCompletionHandler);
                }
                BodyDataSink.this.writeCompletionManager.registerCompletionHandler(writeCompletionHandler, BodyDataSink.this.executor, buffers);
                this.write(buffers);
                this.setSuppressReuseBufferWarning(isSuppressReuseBuffer);
            }
        }

        protected boolean isDataWriteable() {
            return this.isOpen();
        }

        protected boolean isMoreInputDataExpected() {
            return false;
        }

        public void flush() throws IOException {
            super.removeWriteMark();
            boolean isImmutable = this.isContentImmutable;
            ByteBuffer[] dataToWrite = this.drainWriteQueue();
            this.isContentImmutable = true;
            WriteCompletionHandlerAdapter completionHandler = null;
            if (!BodyDataSink.this.writeCompletionManager.isPendingCompletionConfirmationsEmtpy()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyDataSink.this.connectionId + "] write completion handlers are registered. perform write with WriteCompletionHandlerAdapter");
                }
                completionHandler = new WriteCompletionHandlerAdapter(dataToWrite);
            }
            BodyDataSink.this.messageWriter.flush(dataToWrite, isImmutable, super.getFlushmode(), completionHandler);
        }

        private void onDataWritten(ByteBuffer[] data) {
            BodyDataSink.this.writeCompletionManager.onWritten(data, false);
        }

        private void onWriteException(IOException ioException, ByteBuffer[] data) {
            BodyDataSink.this.destroy();
            BodyDataSink.this.writeCompletionManager.onWriteException(ioException, data);
        }

        protected void onWriteDataInserted() throws IOException, ClosedChannelException {
            if (super.isAutoflush()) {
                try {
                    this.flush();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.setStackTrace(e.getStackTrace());
                    throw ioe;
                }
            }
        }

        public String toString() {
            return this.printWriteBuffer(super.getEncoding());
        }

        @Execution(value=0)
        private final class WriteCompletionHandlerAdapter
        implements IWriteCompletionHandler {
            private final ByteBuffer[] dataToWrite;

            public WriteCompletionHandlerAdapter(ByteBuffer[] dataToWrite) {
                this.dataToWrite = dataToWrite;
            }

            public void onWritten(int written) throws IOException {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyDataSink.this.connectionId + "]  {" + this.dataToWrite.hashCode() + "}  data (size=" + written + " bytes) has been written. notify registered WriteCompletionHandler (if exist)");
                }
                NonBlockingStream.this.onDataWritten(this.dataToWrite);
            }

            public void onException(IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyDataSink.this.connectionId + "]  {" + this.dataToWrite.hashCode() + "}   " + ioe.toString() + " error has been occured by writing data. notify registered WriteCompletionHandler (if exist)");
                }
                NonBlockingStream.this.onWriteException(ioe, this.dataToWrite);
            }
        }
    }

    private static final class CloseListenerCaller
    implements Runnable {
        private IBodyCloseListener listener = null;

        public CloseListenerCaller(IBodyCloseListener listener) {
            this.listener = listener;
        }

        public void run() {
            block2: {
                try {
                    this.listener.onClose();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling close listener " + this.listener + " " + ioe.toString());
                }
            }
        }
    }
}

