/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkMessageWriter;
import org.xlightweb.IHttpHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class FullMessageChunkedWriter
extends AbstractNetworkMessageWriter {
    private static final Logger LOG = Logger.getLogger(FullMessageChunkedWriter.class.getName());
    private boolean isHeaderWritten = false;
    private int writtenData;
    private final IHttpHeader header;

    FullMessageChunkedWriter(AbstractHttpConnection httpConnection, boolean destroyOnClose, IHttpHeader header) throws IOException {
        super(httpConnection, destroyOnClose);
        this.header = header;
    }

    private void writeChunk(ByteBuffer[] bodyData, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            con.setFlushmode(flushMode);
            int written = 0;
            if (!this.isHeaderWritten) {
                this.isHeaderWritten = true;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "]  sending header ");
                }
                written += con.write(this.header.toString() + "\r\n");
                con.incCountMessageSent();
            }
            int length = 0;
            if (bodyData != null) {
                for (ByteBuffer buffer : bodyData) {
                    length += buffer.remaining();
                }
            }
            if (length > 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] writing chunk (size=" + length + ")");
                }
                written += con.write(Integer.toHexString(length) + "\r\n");
                written = (int)((long)written + con.write(bodyData, completionHandler));
                written += con.write("\r\n");
                this.writtenData += length;
            }
            if (written > 0) {
                con.flush();
            }
        }
    }

    public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
        block3: {
            try {
                this.writeChunk(bodyData, flushMode, completionHandler);
            }
            catch (IOException ioe) {
                if (this.getConnection() == null) break block3;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing chunked data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
    }

    void onClose(boolean destroyOnClose) throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con == null) {
            return;
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] closing chunked body by writing termination chunk (body size=" + this.writtenData + ")");
            }
            con.write("0\r\n\r\n");
            con.flush();
            if (destroyOnClose) {
                con.destroy();
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] error occured by closing chunked data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
            }
            con.destroy();
            throw ioe;
        }
    }

    public boolean isNetworkEndpoint() {
        return true;
    }
}

