/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.event;

import java.util.Objects;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.implspi.SourceControl;
import org.netbeans.modules.parsing.implspi.SourceEnvironment;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Parameters;

public final class FileChangeSupport
extends FileChangeAdapter {
    private final SourceControl sourceControl;

    public FileChangeSupport(@NonNull SourceControl sourceControl) {
        Parameters.notNull((CharSequence)"sourceControl", (Object)sourceControl);
        this.sourceControl = sourceControl;
    }

    public void fileChanged(FileEvent fe) {
        this.sourceControl.sourceChanged(false);
        this.sourceControl.revalidate(SourceEnvironment.getReparseDelay(false));
    }

    public void fileRenamed(FileRenameEvent fe) {
        String newExt;
        String oldExt = fe.getExt();
        this.sourceControl.sourceChanged(!Objects.equals(oldExt, newExt = fe.getFile().getExt()));
        this.sourceControl.revalidate(SourceEnvironment.getReparseDelay(false));
    }
}

