/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run.v2.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphBuilder;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.BulkStatusDisplayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;

public class TabularTransformGraphBuilderV2
extends TabularGraphBuilder {
    private final List<TabularGraphLink> links;
    private final MaltegoEntity inputEntity;
    private final boolean reverse;
    private final EntityRegistry registry;
    private final BulkStatusDisplayer status = new BulkStatusDisplayer("%d rows processed", 500L);

    public TabularTransformGraphBuilderV2(GraphID graphID, TabularGraph tabularGraph, List<File> files, ProgressHandle handle, List<TabularGraphLink> links, MaltegoEntity inputEntity, boolean reverse) {
        super(graphID, tabularGraph, files, handle);
        Args.notNull((Object)graphID, (String)"graphID");
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        Args.notNullOrEmpty(files, (String)"files");
        Args.notNull((Object)handle, (String)"handle");
        Args.notNullOrEmpty(links, (String)"links");
        Args.notNull((Object)inputEntity, (String)"inputEntity");
        this.links = links;
        this.inputEntity = inputEntity;
        this.reverse = reverse;
        this.registry = EntityRegistry.forGraphID((GraphID)graphID);
    }

    public List<TabularGraphLink> getLinks() {
        return this.links;
    }

    public List<TabularGraphEntity> getEntities() {
        HashSet entities = new HashSet();
        this.links.forEach(link -> {
            entities.add(link.getSource());
            entities.add(link.getTarget());
        });
        return new ArrayList<TabularGraphEntity>(entities);
    }

    protected TabularGraphPartFactory createPartFactory() {
        return new TabularTransformPartFactory(this._types);
    }

    protected boolean processRow(TabularGraphIterator rowIterator) throws Exception {
        Args.notNull((Object)rowIterator, (String)"rowIterator");
        this.status.increment();
        return super.processRow(rowIterator);
    }

    protected void filterEntities(List<TabularGraphLightweightLink> lightLinks, List<TabularGraphLightweightEntity> lightEntities) {
        Args.notNull(lightLinks, (String)"lightLinks");
        Args.notNull(lightEntities, (String)"lightEntities");
        Iterator<TabularGraphLightweightEntity> itr = lightEntities.iterator();
        while (itr.hasNext()) {
            boolean found = false;
            TabularGraphLightweightEntity entity = itr.next();
            for (TabularGraphLightweightLink lightLink : lightLinks) {
                if (!entity.equals((Object)lightLink.sourceEntity) && !entity.equals((Object)lightLink.targetEntity)) continue;
                found = true;
                break;
            }
            if (found) continue;
            itr.remove();
        }
    }

    protected MaltegoEntity translate(TabularTranslator translator, TabularGraphLightweightEntity entity) throws TypeInstantiationException, TabularTranslator.RowImportException {
        Args.notNull((Object)translator, (String)"translator");
        Args.notNull((Object)entity, (String)"entity");
        boolean isOutputEntity = this.isOutputEntity(entity);
        if (!isOutputEntity) {
            for (TabularGraphLightweightEntity duplicate : entity.duplicates) {
                if (!this.isOutputEntity(duplicate)) continue;
                isOutputEntity = true;
                break;
            }
        }
        return isOutputEntity ? super.translate(translator, entity) : null;
    }

    protected Map<MaltegoLink, LinkEntityIDs> generateLinks(List<MaltegoEntity> entities) throws TabularTranslator.RowImportException {
        Args.notNull(entities, (String)"entities");
        return Collections.EMPTY_MAP;
    }

    private boolean isOutputEntity(TabularGraphLightweightEntity entity) {
        Args.notNull((Object)entity, (String)"entity");
        return this.links.stream().anyMatch(link -> {
            TabularGraphEntity tabularEntity = ((TabularGraphEntityType)entity.type).tabularEntity;
            TabularGraphEntity outputEntity = this.reverse ? link.getSource() : link.getTarget();
            return Arrays.equals(tabularEntity.getColumns(), outputEntity.getColumns());
        });
    }

    private class TabularTransformPartFactory
    extends TabularGraphPartFactory {
        public TabularTransformPartFactory(TabularGraphTypes types) {
            super(types);
        }

        protected boolean shouldAdd(TabularGraphLinkType type, TabularGraphLightweightLink lightLink) throws Exception {
            Args.notNull((Object)type, (String)"type");
            Args.notNull((Object)lightLink, (String)"lightLink");
            int index = type.tabularLink.getIndex();
            for (TabularGraphLink link : TabularTransformGraphBuilderV2.this.links) {
                TabularGraphLightweightEntity lightEntity;
                if (index != link.getIndex()) continue;
                TabularGraphLightweightEntity tabularGraphLightweightEntity = lightEntity = TabularTransformGraphBuilderV2.this.reverse ? lightLink.targetEntity : lightLink.sourceEntity;
                TabularTranslator translator = new TabularTranslator();
                MaltegoEntity entity = translator.translate(((TabularGraphEntityType)lightEntity.type).tabularEntity, lightLink.row);
                if (entity == null || MatchingRule.Default.getMatch((SpecRegistry)TabularTransformGraphBuilderV2.this.registry, (TypedPropertyBag)entity, (TypedPropertyBag)TabularTransformGraphBuilderV2.this.inputEntity) != 1) continue;
                return true;
            }
            return false;
        }
    }
}

