/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.protocol.v2api.V2MatchingRuleDescriptor;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transforms.tabular.TabularTransformGlobalPreferences;
import com.paterva.maltego.transforms.tabular.TabularTransformNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TabularTransformDefinitionFactory {
    private static final String TRANSFORM_ADAPTER = "com.paterva.maltego.tabular.transforms.run.TabularTransformAdapter";
    private final TabularTransformSource transformSource;

    public TabularTransformDefinitionFactory(TabularTransformSource transformSource) {
        Args.notNull((Object)((Object)transformSource), (String)"transformSource");
        this.transformSource = transformSource;
    }

    public List<TransformDefinition> createTransforms() {
        ArrayList<TransformDefinition> transforms = new ArrayList<TransformDefinition>();
        transforms.add(this.createGlobalSearchTransform());
        transforms.add(this.createSearchTransform());
        transforms.addAll(this.createNormalTransforms());
        return transforms;
    }

    private TransformDefinition createGlobalSearchTransform() {
        String name = TabularTransformNames.getGlobalSearchTransformName();
        String displayName = TabularTransformNames.getGlobalSearchTransformDisplayName();
        boolean favorite = TabularTransformGlobalPreferences.isGlobalSearchFavorited();
        TransformDefinition transform = this.createTransformDefinition(name, displayName, "maltego.Phrase", favorite);
        transform.setDefaultSets(new String[0]);
        return transform;
    }

    private TransformDefinition createSearchTransform() {
        String name = TabularTransformNames.getSearchTransformName(this.transformSource);
        String displayName = TabularTransformNames.getSearchTransformDisplayName(this.transformSource);
        boolean favorite = this.transformSource.isSearchFavorited();
        return this.createTransformDefinition(name, displayName, "maltego.Phrase", favorite);
    }

    private List<TransformDefinition> createNormalTransforms() {
        return this.transformSource.getTabularTransforms().stream().map(this::createTransform).collect(Collectors.toList());
    }

    private TransformDefinition createTransform(TabularTransform tabularTransform) {
        Args.notNull((Object)tabularTransform, (String)"tabularTransform");
        String name = TabularTransformNames.getTransformName(this.transformSource, tabularTransform);
        String displayName = TabularTransformNames.getTransformDisplayName(this.transformSource, tabularTransform);
        TabularGraph tabularGraph = MappingRegistry.getDefault().get(this.transformSource.getTabularGraphName());
        TabularGraphLink firstLink = tabularTransform.getLinks(tabularGraph).get(0);
        TabularGraphEntity entity = tabularTransform.isReverse() ? firstLink.getTarget() : firstLink.getSource();
        boolean favorite = tabularTransform.isFavorite();
        return this.createTransformDefinition(name, displayName, entity.getEntitySpecName(), favorite);
    }

    private TransformDefinition createTransformDefinition(String name, String displayName, String inputEntityType, boolean favorite) {
        TransformDescriptor transform = new TransformDescriptor(TRANSFORM_ADAPTER, name, null);
        transform.setDisplayName(displayName);
        transform.setInputConstraint((Constraint)new EntityConstraint(inputEntityType));
        transform.setDefaultSets(new String[]{this.transformSource.getDisplayName()});
        transform.setMatchingRule((MatchingRuleDescriptor)new V2MatchingRuleDescriptor());
        TransformDefinition transformDefinition = new TransformDefinition(transform, (TransformSettings)new ListMapTransformSettings());
        transformDefinition.setRepositoryName("Generated");
        transformDefinition.setFavorite(favorite);
        return transformDefinition;
    }
}

