/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.graph.undo.UndoRedoStackAction;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.undo.CannotRedoException;

public final class RedoStackAction
extends UndoRedoStackAction {
    @Override
    public String getName() {
        return "Redo";
    }

    @Override
    public String getDescription() {
        return "Redo the last action(s)";
    }

    @Override
    public String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/RedoTaskBar.png";
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        UndoRedoModel undoRedo = this.getUndoRedo();
        if (undoRedo != null && undoRedo.canRedo()) {
            this.redo(undoRedo);
        }
    }

    @Override
    protected Command[] getCommands() {
        return this.getUndoRedo().getRedoStack();
    }

    @Override
    protected ActionListener createActionListener(Command command) {
        return new RedoUpToActionListener(command);
    }

    @Override
    protected void updateEnabledState() {
        UndoRedoModel undoRedo = this.getUndoRedo();
        boolean isEnabled = false;
        if (undoRedo != null) {
            isEnabled = undoRedo.canRedo();
        }
        this.setEnabled(isEnabled);
    }

    private void redo(UndoRedoModel undoRedo) throws CannotRedoException {
        try {
            WindowUtil.showWaitCursor();
            undoRedo.redo();
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    private class RedoUpToActionListener
    implements ActionListener {
        private final Command _command;

        public RedoUpToActionListener(Command command) {
            this._command = command;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoRedoModel undoRedo = RedoStackAction.this.getUndoRedo();
            Command[] redoStack = undoRedo.getRedoStack();
            int undoCount = 0;
            boolean found = false;
            for (Command cmd : redoStack) {
                ++undoCount;
                if (!cmd.equals(this._command)) continue;
                found = true;
                break;
            }
            if (found) {
                for (int i = 0; i < undoCount; ++i) {
                    if (undoRedo.canRedo()) {
                        RedoStackAction.this.redo(undoRedo);
                        continue;
                    }
                    System.out.println("Wanted to undo but can't!");
                }
            }
        }
    }
}

