/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Property {
    private final Object value;
    private final String name;
    private final String displayName;
    private final PropertyType type;
    private final MatchingRule matchingRule;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Property(@JsonProperty(value="value", required=true) Object value, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="type", required=true) PropertyType type, @JsonProperty(value="matchingRule") MatchingRule matchingRule) {
        this.value = value;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.matchingRule = matchingRule;
    }

    public Property(Object value, String name, String displayName, PropertyType type) {
        this.value = value;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.matchingRule = null;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PropertyType getType() {
        return this.type;
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return Objects.equals(this.value, property.value) && Objects.equals(this.name, property.name) && Objects.equals(this.displayName, property.displayName) && this.type == property.type && this.matchingRule == property.matchingRule;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.name, this.displayName, this.type, this.matchingRule});
    }

    public static enum PropertyType {
        STRING,
        INT,
        DOUBLE,
        BOOLEAN,
        DATE,
        DATE_TIME,
        DATE_RANGE,
        TIME_SPAN,
        URL,
        COLOR;

    }

    public static enum MatchingRule {
        STRICT,
        LOOSE;

    }
}

