/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.CustomizableViewRegistry;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.ViewletRegistry;
import com.paterva.maltego.view.customization.ui.main.ViewletController;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public final class ViewletPopupAction
extends TopGraphAction
implements RibbonPresenter.Button {
    private static final String ICON_PATH = "com/paterva/maltego/view/customization/ui/resources/Customize.png";
    private static final String ACTION_NAME = "Manage View";
    private static final String NONE_VIEW = "<None>";
    private CustomizableView _view = null;
    private GraphID _graphID = null;
    private JCommandButton _viewletConfig = null;

    public ViewletPopupAction() {
        this.setIcon((Icon)ResizableIcons.fromResource((String)ICON_PATH));
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void actionPerformed(TopComponent tc) {
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    private void setView() {
        GraphCookie cookie;
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null) {
            this._graphID = cookie.getGraphID();
            this._view = CustomizableViewRegistry.getDefault().getView(this._graphID);
            return;
        }
        this._graphID = null;
        this._view = null;
    }

    public void perform() {
        this.setView();
        if (this._view != null) {
            ViewletController controller = new ViewletController(this._view);
            EditDialogDescriptor nd = new EditDialogDescriptor(ACTION_NAME, (WizardDescriptor.Panel)controller);
            if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                Set<Viewlet> viewlets = controller.getViewlets();
                Viewlet viewlet = controller.getViewlet();
                ViewletRegistry.getDefault().setAll(this._view.getCustomizableViewID(), viewlets);
                this._view.setActiveViewlet(viewlet == null ? null : viewlet.getName());
            }
        }
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._viewletConfig == null) {
            this._viewletConfig = new JCommandButton(ACTION_NAME, ResizableIcons.fromResource((String)ICON_PATH));
            this._viewletConfig.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            RichTooltip viewletConfigureTooltip = new RichTooltip(ACTION_NAME, "Manage the display of the views");
            viewletConfigureTooltip.setMainImage(ImageUtilities.loadImage((String)ICON_PATH.replace(".png", "48.png")));
            viewletConfigureTooltip.addFooterSection("Click the help button to get more help on Maltego features");
            viewletConfigureTooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._viewletConfig.setActionRichTooltip(viewletConfigureTooltip);
            this._viewletConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewletPopupAction.this.perform();
                }
            });
            this._viewletConfig.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    JCommandPopupMenu menu = new JCommandPopupMenu();
                    ViewletPopupAction.this.populateMenu(menu);
                    return menu;
                }
            });
        }
        this.setView();
        if (this._view == null) {
            this._viewletConfig.setEnabled(false);
        }
        return this._viewletConfig;
    }

    private void populateMenu(JCommandPopupMenu menu) {
        menu.removeAll();
        this.setView();
        if (this._view != null) {
            EntityPainter entityPainter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
            boolean mainActive = entityPainter != null && "Main".equals(entityPainter.getName());
            final ViewletAction noneAction = new ViewletAction(NONE_VIEW, NONE_VIEW);
            JCommandMenuButton noneButton = new JCommandMenuButton((String)noneAction.getValue("Name"), (ResizableIcon)new RadioButtonMenuIcon(this._view.getActiveViewlet() == null && !mainActive));
            noneButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            noneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    noneAction.actionPerformed(e);
                }
            });
            menu.addMenuButton(noneButton);
            final ViewletAction action = new ViewletAction("Graph View", "Main");
            JCommandMenuButton b1 = new JCommandMenuButton((String)action.getValue("Name"), (ResizableIcon)new RadioButtonMenuIcon("Main".equals(this._view.getActiveViewlet()) || mainActive));
            b1.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            b1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
            menu.addMenuButton(b1);
            ArrayList<Viewlet> viewlets = new ArrayList<Viewlet>(ViewletRegistry.getDefault().getAll(this._view.getCustomizableViewID()));
            Collections.sort(viewlets);
            for (Viewlet viewlet : viewlets) {
                if (!viewlet.isInMenu()) continue;
                final Action action2 = this.getViewletAction(viewlet);
                JCommandMenuButton b2 = new JCommandMenuButton((String)action2.getValue("Name"), (ResizableIcon)new RadioButtonMenuIcon(viewlet.getName().equals(this._view.getActiveViewlet())));
                b2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                b2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        action2.actionPerformed(e);
                    }
                });
                menu.addMenuButton(b2);
            }
            if (!viewlets.isEmpty()) {
                menu.addMenuSeparator();
            }
            JCommandMenuButton b3 = new JCommandMenuButton(ACTION_NAME, ResizableIcons.fromResource((String)ICON_PATH));
            b3.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            b3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewletPopupAction.this.perform();
                }
            });
            menu.addMenuButton(b3);
        }
    }

    private Action getViewletAction(Viewlet viewlet) {
        String name = viewlet.getName();
        return new ViewletAction(name, name);
    }

    private class ViewletAction
    extends AbstractAction {
        private String _viewletName;

        public ViewletAction(String actionName, String viewletName) {
            super(actionName);
            this._viewletName = ViewletPopupAction.NONE_VIEW;
            this._viewletName = viewletName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewletPopupAction.this.setView();
            if (ViewletPopupAction.this._view != null) {
                boolean noneView = ViewletPopupAction.NONE_VIEW.equals(this._viewletName);
                if (noneView) {
                    EntityPainterSettings.getDefault().setEntityPainter(ViewletPopupAction.this._graphID, "BallView");
                }
                ViewletPopupAction.this._view.setActiveViewlet(noneView ? null : this._viewletName);
            }
        }
    }

    private static class RadioButtonMenuIcon
    implements ResizableIcon {
        private int _size;
        private final boolean _isSelected;

        public RadioButtonMenuIcon(boolean isSelected) {
            this._isSelected = isSelected;
        }

        public int getIconWidth() {
            return this._size;
        }

        public int getIconHeight() {
            return this._size;
        }

        public void paintIcon(Component c, Graphics g, int xPos, int yPos) {
            GraphicsUtils.drawRadioButtonMenuItemIcon((Graphics)g, (boolean)this._isSelected, (boolean)true, (int)xPos, (int)yPos, (int)this.getIconWidth(), (int)this.getIconHeight());
        }

        public void setDimension(Dimension d) {
            this._size = Math.min(d.width, d.height);
        }
    }
}

