/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui.prompt;

import com.maltego.recovery.ui.BackupMetadata;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ui.outline.NodePropertySupport;
import java.awt.Color;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class BackupMetadataNode
extends AbstractNode
implements CheckableNode {
    public static final String PROPERTY_LAST_BACKUP_NAME = "last_backup";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    private final BackupMetadata metadata;

    public BackupMetadataNode(BackupMetadata metadata) {
        this(metadata, new InstanceContent());
    }

    protected BackupMetadataNode(BackupMetadata metadata, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)metadata);
        content.add((Object)this);
        this.metadata = metadata;
    }

    public String getDisplayName() {
        return this.metadata.getName();
    }

    public String getHtmlDisplayName() {
        return this.decorateDisplayName(this.getDisplayName());
    }

    public String getShortDescription() {
        return this.getDisplayName();
    }

    public boolean isCheckable() {
        return true;
    }

    public boolean isCheckEnabled() {
        return !this.metadata.isRecoveredSuccessfully();
    }

    public Boolean isSelected() {
        return this.metadata.isSelectedForRecovery();
    }

    public void setSelected(Boolean value) {
        this.metadata.setSelectedForRecovery(value);
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"/com/maltego/recovery/ui/prompt/recovered-graph.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new LastBackupTime((Node)this));
        sheet.put(set);
        return sheet;
    }

    private String decorateDisplayName(String displayName) {
        if (displayName != null) {
            displayName = displayName.replace("%", "%%");
        }
        StringBuilder sb = new StringBuilder(displayName);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (this.metadata.isRecoveredSuccessfully()) {
            Color recoveredColor = laf.getColor("7-black-green").brighter().brighter();
            String htmlColorTag = this.htmlColorTag(recoveredColor);
            sb.insert(0, htmlColorTag);
            sb.append("</font>");
            sb.insert(0, "<b>");
            sb.append("</b>");
        } else {
            Color color = laf.getColor("7-black");
            String htmlColorTag = this.htmlColorTag(color);
            sb.insert(0, htmlColorTag);
            sb.append("</font>");
        }
        sb.insert(0, "<html>");
        sb.append("</html>");
        return sb.toString();
    }

    private String htmlColorTag(Color color) {
        return "<font color=\"" + ColorUtilities.encode((Color)color) + "\">";
    }

    private class LastBackupTime
    extends NodePropertySupport.ReadOnly<String> {
        private final String dateString;

        public LastBackupTime(Node node) {
            super(node, BackupMetadataNode.PROPERTY_LAST_BACKUP_NAME, String.class, "Last Backup", "Last Backup");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.dateString = DATE_FORMAT.format(BackupMetadataNode.this.metadata.getLastBackupTime());
        }

        public String getDisplayName() {
            return this.dateString;
        }

        public String getHtmlDisplayName() {
            return BackupMetadataNode.this.decorateDisplayName(this.getDisplayName());
        }

        public String getShortDescription() {
            return this.dateString;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dateString;
        }
    }
}

