/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;

@ExportLibrary(value=ReflectionLibrary.class)
final class OtherContextGuestObject
implements TruffleObject {
    static final Object OTHER_VALUE = new Object();
    static final ReflectionLibrary OTHER_VALUE_UNCACHED = ReflectionLibrary.getFactory().getUncached(OTHER_VALUE);
    final PolyglotContextImpl receiverContext;
    final Object delegate;
    final PolyglotContextImpl delegateContext;
    static final int CACHE_LIMIT = 5;
    private static final Message IDENTICAL = Message.resolve(InteropLibrary.class, "isIdentical");

    OtherContextGuestObject(PolyglotContextImpl receiverContext, Object delegate, PolyglotContextImpl delegateContext) {
        assert (!(delegate instanceof OtherContextGuestObject)) : "recursive host foreign value found";
        assert (receiverContext != null && delegateContext != null) : "Must have associated contexts.";
        assert (receiverContext != delegateContext) : "no need for foreign value if contexts match";
        this.delegate = delegate;
        this.receiverContext = receiverContext;
        this.delegateContext = delegateContext;
    }

    static boolean canCache(PolyglotEngineImpl cachedEngine, PolyglotContextImpl context0, PolyglotContextImpl context1) {
        return cachedEngine == context0.engine && cachedEngine == context1.engine;
    }

    static PolyglotEngineImpl getCachedEngine(Node library) {
        RootNode root = library.getRootNode();
        if (root == null) {
            return null;
        }
        return (PolyglotEngineImpl)EngineAccessor.NODES.getPolyglotEngine(root);
    }

    static Object sendImpl(PolyglotEngineImpl engine, Object receiver, Message message, Object[] args, PolyglotContextImpl receiverContext, PolyglotContextImpl delegateContext, ReflectionLibrary delegateLibrary, BranchProfile seenOther, BranchProfile seenError) throws Exception {
        if (message.getLibraryClass() == InteropLibrary.class) {
            Object[] prev;
            try {
                prev = engine.enter(delegateContext);
            }
            catch (Throwable e) {
                throw OtherContextGuestObject.toHostException(receiverContext, e);
            }
            try {
                Object returnValue;
                Object[] migratedArgs = OtherContextGuestObject.migrateArgs(message, args, receiverContext, delegateContext);
                if (message == IDENTICAL && migratedArgs[0] instanceof OtherContextGuestObject) {
                    OtherContextGuestObject foreignCompare = (OtherContextGuestObject)migratedArgs[0];
                    assert (foreignCompare.delegateContext != delegateContext);
                    returnValue = Boolean.FALSE;
                } else {
                    returnValue = delegateLibrary.send(receiver, message, migratedArgs);
                }
                Object object = OtherContextGuestObject.migrateReturn(returnValue, receiverContext, delegateContext);
                return object;
            }
            catch (Exception e) {
                seenError.enter();
                throw OtherContextGuestObject.migrateException(receiverContext, e, delegateContext);
            }
            finally {
                try {
                    engine.leave(prev, delegateContext);
                }
                catch (Throwable e) {
                    throw OtherContextGuestObject.toHostException(receiverContext, e);
                }
            }
        }
        seenOther.enter();
        return OtherContextGuestObject.fallbackSend(message, args);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Exception> RuntimeException migrateException(PolyglotContextImpl receiverContext, T e, PolyglotContextImpl valueContext) throws T {
        if (e instanceof OtherContextException) {
            OtherContextException other = (OtherContextException)e;
            if (other.receiverContext == receiverContext && other.delegateContext == valueContext) {
                throw other;
            }
            throw new OtherContextException(receiverContext, other.delegate, other.delegateContext);
        }
        if (InteropLibrary.getUncached().isException(e)) {
            if (e instanceof AbstractTruffleException) {
                throw new OtherContextException(receiverContext, (AbstractTruffleException)e, valueContext);
            }
            throw new OtherContextException(receiverContext, e, valueContext);
        }
        throw e;
    }

    private static RuntimeException toHostException(PolyglotContextImpl context, Throwable e) {
        try {
            throw PolyglotImpl.engineToLanguageException(e);
        }
        catch (Throwable ex) {
            throw context.engine.host.toHostException(context.getHostContextImpl(), ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Object fallbackSend(Message message, Object[] args) throws Exception {
        return OTHER_VALUE_UNCACHED.send(OTHER_VALUE, message, args);
    }

    private static Object migrateReturn(Object arg, PolyglotContextImpl receiverContext, PolyglotContextImpl delegateContext) {
        if (arg instanceof TruffleObject) {
            return receiverContext.migrateValue(arg, delegateContext);
        }
        assert (InteropLibrary.isValidProtocolValue(arg)) : "unexpected interop primitive";
        return arg;
    }

    private static Object migrateArg(Object arg, PolyglotContextImpl receiverContext, PolyglotContextImpl delegateContext) {
        if (arg instanceof TruffleObject) {
            return delegateContext.migrateValue(arg, receiverContext);
        }
        if (arg instanceof Object[]) {
            return OtherContextGuestObject.migrateArgs(null, (Object[])arg, receiverContext, delegateContext);
        }
        if (arg instanceof InteropLibrary) {
            return InteropLibrary.getUncached();
        }
        assert (InteropLibrary.isValidProtocolValue(arg));
        return arg;
    }

    private static Object[] migrateArgs(Message message, Object[] args, PolyglotContextImpl receiverContext, PolyglotContextImpl delegateContext) {
        if (message != null) {
            return OtherContextGuestObject.migrateArgsExplode(message, args, receiverContext, delegateContext);
        }
        Object[] newArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = OtherContextGuestObject.migrateArg(args[i], receiverContext, delegateContext);
        }
        return newArgs;
    }

    @ExplodeLoop
    private static Object[] migrateArgsExplode(Message message, Object[] args, PolyglotContextImpl receiverContext, PolyglotContextImpl delegateContext) {
        int length = message.getParameterCount();
        Object[] newArgs = new Object[length - 1];
        for (int i = 0; i < length - 1; ++i) {
            newArgs[i] = OtherContextGuestObject.migrateArg(args[i], receiverContext, delegateContext);
        }
        return newArgs;
    }

    public String toString() {
        return "OtherContextGuestObject[targetContext=0x" + Integer.toHexString(System.identityHashCode(this.receiverContext)) + ", delegate=(" + this.delegate.getClass().getSimpleName() + "(0x" + Integer.toHexString(System.identityHashCode(this.delegate)) + "), delegateContext=0x" + Integer.toHexString(System.identityHashCode(this.delegateContext));
    }

    @ExportLibrary(value=ReflectionLibrary.class)
    static class OtherContextException
    extends AbstractTruffleException {
        final PolyglotContextImpl receiverContext;
        final Exception delegate;
        final PolyglotContextImpl delegateContext;

        OtherContextException(PolyglotContextImpl receiverContext, AbstractTruffleException delegate, PolyglotContextImpl delegateContext) {
            super(delegate);
            assert (!(delegate instanceof OtherContextException)) : "recursive host foreign value found";
            assert (receiverContext != null && delegateContext != null) : "Must have associated contexts.";
            assert (receiverContext != delegateContext) : "no need for foreign value if contexts match";
            this.delegate = delegate;
            this.receiverContext = receiverContext;
            this.delegateContext = delegateContext;
        }

        @CompilerDirectives.TruffleBoundary
        OtherContextException(PolyglotContextImpl thisContext, Exception delegate, PolyglotContextImpl delegateContext) {
            super(delegate.getMessage());
            assert (!(delegate instanceof OtherContextException)) : "recursive host foreign value found";
            assert (thisContext != null && delegateContext != null) : "Must have associated contexts.";
            assert (thisContext != delegateContext) : "no need for foreign value if contexts match";
            this.delegate = delegate;
            this.receiverContext = thisContext;
            this.delegateContext = delegateContext;
        }

        @ExportMessage
        @ImportStatic(value={OtherContextGuestObject.class})
        static class Send {
            Send() {
            }

            @Specialization(guards={"canCache(cachedEngine, receiver.receiverContext, receiver.delegateContext)"}, limit="1")
            static Object doCached(OtherContextException receiver, Message message, Object[] args, @CachedLibrary(value="receiver") ReflectionLibrary receiverLibrary, @Cached(value="getCachedEngine(receiverLibrary)") PolyglotEngineImpl cachedEngine, @CachedLibrary(limit="CACHE_LIMIT") ReflectionLibrary delegateLibrary, @Cached BranchProfile seenOther, @Cached BranchProfile seenError) throws Exception {
                return OtherContextGuestObject.sendImpl(cachedEngine, receiver.delegate, message, args, receiver.receiverContext, receiver.delegateContext, delegateLibrary, seenOther, seenError);
            }

            @CompilerDirectives.TruffleBoundary
            @Specialization(replaces={"doCached"})
            static Object doSlowPath(OtherContextException receiver, Message message, Object[] args) throws Exception {
                return OtherContextGuestObject.sendImpl(receiver.receiverContext.engine, receiver.delegate, message, args, receiver.receiverContext, receiver.delegateContext, ReflectionLibrary.getUncached(receiver.delegate), BranchProfile.getUncached(), BranchProfile.getUncached());
            }
        }
    }

    @ExportMessage
    @ImportStatic(value={OtherContextGuestObject.class})
    static class Send {
        Send() {
        }

        @Specialization(guards={"canCache(cachedEngine, receiver.receiverContext, receiver.delegateContext)"}, limit="1")
        static Object doCached(OtherContextGuestObject receiver, Message message, Object[] args, @CachedLibrary(value="receiver") ReflectionLibrary receiverLibrary, @Cached(value="getCachedEngine(receiverLibrary)") PolyglotEngineImpl cachedEngine, @CachedLibrary(limit="CACHE_LIMIT") ReflectionLibrary delegateLibrary, @Cached BranchProfile seenOther, @Cached BranchProfile seenError) throws Exception {
            return OtherContextGuestObject.sendImpl(cachedEngine, receiver.delegate, message, args, receiver.receiverContext, receiver.delegateContext, delegateLibrary, seenOther, seenError);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCached"})
        static Object doSlowPath(OtherContextGuestObject receiver, Message message, Object[] args) throws Exception {
            return OtherContextGuestObject.sendImpl(receiver.receiverContext.engine, receiver.delegate, message, args, receiver.receiverContext, receiver.delegateContext, ReflectionLibrary.getUncached(receiver.delegate), BranchProfile.getUncached(), BranchProfile.getUncached());
        }
    }
}

