/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.GenericLink;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.ExtensibleLinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecFactory;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import org.openide.util.Lookup;

public class LinkFactory
extends SpecFactory<MaltegoLinkSpec, MaltegoLink> {
    private static LinkFactory _default;
    private final GenericLink _templateManual = this.createTemplate(MaltegoLinkSpec.getManualSpec());
    private final GenericLink _templateTransform = this.createTemplate(MaltegoLinkSpec.getTransformSpec());

    public static synchronized LinkFactory getDefault() {
        if (_default == null && (_default = (LinkFactory)((Object)Lookup.getDefault().lookup(LinkFactory.class))) == null) {
            _default = new ExtensibleLinkFactory(LinkRegistry.getDefault(), null);
        }
        return _default;
    }

    public static synchronized LinkFactory forGraphID(GraphID graphID) {
        LinkRegistry registry = LinkRegistry.forGraphID(graphID);
        if (registry == null) {
            return null;
        }
        return new ExtensibleLinkFactory(registry, graphID);
    }

    public MaltegoLink createInstance(String typeName, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        return this.createInstanceInternal(typeName, null, decorate);
    }

    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        return this.createInstanceInternal(descriptor, null, decorate);
    }

    public MaltegoLink createInstance(String type, boolean decorate) {
        return this.createInstanceInternal(type, null, decorate);
    }

    public MaltegoLink createInstance(String type, LinkID id, boolean decorate) {
        return this.createInstanceInternal(type, id, decorate);
    }

    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, boolean decorate) {
        return this.createInstanceInternal(descriptor, null, decorate);
    }

    public MaltegoLink createInstance(MaltegoLinkSpec descriptor, LinkID id, boolean decorate) {
        return this.createInstanceInternal(descriptor, id, decorate);
    }

    protected MaltegoLink createInstanceInternal(LinkRegistry registry, String typeName, LinkID id, boolean decorate) {
        MaltegoLinkSpec spec = (MaltegoLinkSpec)registry.get(typeName);
        if (spec == null) {
            return new GenericLink(id, typeName);
        }
        return this.createInstanceInternal(spec, id, decorate);
    }

    protected MaltegoLink createInstanceInternal(String typeName, LinkID id, boolean decorate) {
        return this.createInstanceInternal(LinkRegistry.getDefault(), typeName, id, decorate);
    }

    protected MaltegoLink createInstanceInternal(MaltegoLinkSpec descriptor, LinkID id, boolean decorate) {
        if (id == null) {
            id = LinkID.create();
        }
        GenericLink template = descriptor.equals((Object)MaltegoLinkSpec.getManualSpec()) ? this._templateManual : this._templateTransform;
        GenericLink link = template.createCopy(id);
        return link;
    }

    protected GenericLink createTemplate(MaltegoLinkSpec descriptor) {
        GenericLink link = new GenericLink(LinkID.create(), descriptor.getTypeName());
        link.beginPropertyUpdating();
        if (descriptor.getProperties() != null) {
            for (DisplayDescriptor desc : descriptor.getProperties()) {
                link.addProperty((PropertyDescriptor)desc);
                link.setValue((PropertyDescriptor)desc, desc.getDefaultValue());
            }
            link.setDisplayValueExpression(descriptor.getDisplayValueExpression());
            link.setValueProperty((PropertyDescriptor)descriptor.getValueProperty());
            link.setShowLabelProperty((PropertyDescriptor)descriptor.getShowLabelProperty());
            link.setColorProperty((PropertyDescriptor)descriptor.getColorProperty());
            link.setStyleProperty((PropertyDescriptor)descriptor.getStyleProperty());
            link.setThicknessProperty((PropertyDescriptor)descriptor.getThicknessProperty());
        }
        link.endPropertyUpdating(false);
        return link;
    }

    public static class Registry
    extends LinkFactory {
        private LinkRegistry _registry;

        public Registry(LinkRegistry registry) {
            this._registry = registry;
        }

        @Override
        protected MaltegoLink createInstanceInternal(String typeName, LinkID id, boolean decorate) {
            return this.createInstanceInternal(this._registry, typeName, id, decorate);
        }
    }
}

