/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSTypeofIdenticalNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSTypeofIdenticalNode.class)
public final class JSTypeofIdenticalNodeGen
extends JSTypeofIdenticalNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile jSType_proxyBranch_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;

    private JSTypeofIdenticalNodeGen(JavaScriptNode childNode, JSTypeofIdenticalNode.Type type) {
        super(childNode, type);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        DynamicObject operandNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_2 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_2);
        }
        if ((state_0 & 2) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doNumber(operandNodeValue_3);
        }
        if ((state_0 & 4) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_4 = (SafeInteger)operandNodeValue;
            return this.doNumber(operandNodeValue_4);
        }
        if ((state_0 & 8) != 0 && operandNodeValue instanceof Long) {
            long operandNodeValue_5 = (Long)operandNodeValue;
            return this.doNumber(operandNodeValue_5);
        }
        if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x7800) >>> 11, operandNodeValue)) {
            double operandNodeValue_6 = JSTypesGen.asImplicitDouble((state_0 & 0x7800) >>> 11, operandNodeValue);
            return this.doNumber(operandNodeValue_6);
        }
        if ((state_0 & 0x20) != 0 && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_7 = (Symbol)operandNodeValue;
            return this.doSymbol(operandNodeValue_7);
        }
        if ((state_0 & 0x40) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_8 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_8);
        }
        if ((state_0 & 0x80) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0x38000) >>> 15, operandNodeValue)) {
            CharSequence operandNodeValue_9 = JSTypesGen.asImplicitCharSequence((state_0 & 0x38000) >>> 15, operandNodeValue);
            return this.doString(operandNodeValue_9);
        }
        if ((state_0 & 0x100) != 0 && JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSDynamicObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
            return this.doJSType(operandNodeValue_, this.jSType_proxyBranch_);
        }
        if ((state_0 & 0x600) != 0) {
            if ((state_0 & 0x200) != 0) {
                ForeignObject0Data s9_ = this.foreignObject0_cache;
                while (s9_ != null) {
                    if (s9_.interop_.accepts(operandNodeValue) && JSGuards.isForeignObject(operandNodeValue)) {
                        return this.doForeignObject(operandNodeValue, s9_.interop_);
                    }
                    s9_ = s9_.next_;
                }
            }
            if ((state_0 & 0x400) != 0 && JSGuards.isForeignObject(operandNodeValue)) {
                return this.foreignObject1Boundary(state_0, operandNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObject1Boundary(int state_0, Object operandNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue);
            Boolean bl = this.doForeignObject(operandNodeValue, foreignObject1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7FE) == 0 && (state_0 & 0x7FF) != 0) {
            return this.executeBoolean_boolean0(state_0, frameValue);
        }
        if ((state_0 & 0x7FD) == 0 && (state_0 & 0x7FF) != 0) {
            return this.executeBoolean_int1(state_0, frameValue);
        }
        if ((state_0 & 0x7F7) == 0 && (state_0 & 0x7FF) != 0) {
            return this.executeBoolean_long2(state_0, frameValue);
        }
        if ((state_0 & 0x7EF) == 0 && (state_0 & 0x7FF) != 0) {
            return this.executeBoolean_double3(state_0, frameValue);
        }
        return this.executeBoolean_generic4(state_0, frameValue);
    }

    private boolean executeBoolean_boolean0(int state_0, VirtualFrame frameValue) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private boolean executeBoolean_int1(int state_0, VirtualFrame frameValue) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.doNumber(operandNodeValue_);
    }

    private boolean executeBoolean_long2(int state_0, VirtualFrame frameValue) {
        long operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.doNumber(operandNodeValue_);
    }

    private boolean executeBoolean_double3(int state_0, VirtualFrame frameValue) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state_0 & 0x7000) == 0 && (state_0 & 0x7FF) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state_0 & 0x6800) == 0 && (state_0 & 0x7FF) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state_0 & 0x5800) == 0 && (state_0 & 0x7FF) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x7800) >>> 11, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        return this.doNumber(operandNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary0(int state_0, Object operandNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue_);
            boolean bl = this.doForeignObject(operandNodeValue_, foreignObject1_interop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    private boolean executeBoolean_generic4(int state_0, VirtualFrame frameValue) {
        DynamicObject operandNodeValue__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 1) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__2 = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__2);
        }
        if ((state_0 & 2) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__3 = (Integer)operandNodeValue_;
            return this.doNumber(operandNodeValue__3);
        }
        if ((state_0 & 4) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__4 = (SafeInteger)operandNodeValue_;
            return this.doNumber(operandNodeValue__4);
        }
        if ((state_0 & 8) != 0 && operandNodeValue_ instanceof Long) {
            long operandNodeValue__5 = (Long)operandNodeValue_;
            return this.doNumber(operandNodeValue__5);
        }
        if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x7800) >>> 11, operandNodeValue_)) {
            double operandNodeValue__6 = JSTypesGen.asImplicitDouble((state_0 & 0x7800) >>> 11, operandNodeValue_);
            return this.doNumber(operandNodeValue__6);
        }
        if ((state_0 & 0x20) != 0 && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__7 = (Symbol)operandNodeValue_;
            return this.doSymbol(operandNodeValue__7);
        }
        if ((state_0 & 0x40) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__8 = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__8);
        }
        if ((state_0 & 0x80) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0x38000) >>> 15, operandNodeValue_)) {
            CharSequence operandNodeValue__9 = JSTypesGen.asImplicitCharSequence((state_0 & 0x38000) >>> 15, operandNodeValue_);
            return this.doString(operandNodeValue__9);
        }
        if ((state_0 & 0x100) != 0 && JSTypes.isDynamicObject(operandNodeValue_) && JSGuards.isJSDynamicObject(operandNodeValue__ = (DynamicObject)operandNodeValue_)) {
            return this.doJSType(operandNodeValue__, this.jSType_proxyBranch_);
        }
        if ((state_0 & 0x600) != 0) {
            if ((state_0 & 0x200) != 0) {
                ForeignObject0Data s9_ = this.foreignObject0_cache;
                while (s9_ != null) {
                    if (s9_.interop_.accepts(operandNodeValue_) && JSGuards.isForeignObject(operandNodeValue_)) {
                        return this.doForeignObject(operandNodeValue_, s9_.interop_);
                    }
                    s9_ = s9_.next_;
                }
            }
            if ((state_0 & 0x400) != 0 && JSGuards.isForeignObject(operandNodeValue_)) {
                return this.foreignObject1Boundary0(state_0, operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            DynamicObject operandNodeValue_;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_2 = (Boolean)operandNodeValue;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doBoolean(operandNodeValue_2);
                return bl;
            }
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_3 = (Integer)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doNumber(operandNodeValue_3);
                return bl;
            }
            if (operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_4 = (SafeInteger)operandNodeValue;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doNumber(operandNodeValue_4);
                return bl;
            }
            if (operandNodeValue instanceof Long) {
                long operandNodeValue_5 = (Long)operandNodeValue;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doNumber(operandNodeValue_5);
                return bl;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_6 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                state_0 |= doubleCast0 << 11;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doNumber(operandNodeValue_6);
                return bl;
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_7 = (Symbol)operandNodeValue;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                boolean operandNodeValue_6 = this.doSymbol(operandNodeValue_7);
                return operandNodeValue_6;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_8 = (BigInt)operandNodeValue;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean operandNodeValue_6 = this.doBigInt(operandNodeValue_8);
                return operandNodeValue_6;
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(operandNodeValue);
            if (charSequenceCast0 != 0) {
                CharSequence operandNodeValue_9 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, operandNodeValue);
                state_0 |= charSequenceCast0 << 15;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doString(operandNodeValue_9);
                return bl;
            }
            if (JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSDynamicObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
                this.jSType_proxyBranch_ = BranchProfile.create();
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                boolean operandNodeValue_9 = this.doJSType(operandNodeValue_, this.jSType_proxyBranch_);
                return operandNodeValue_9;
            }
            if (exclude == 0) {
                int count9_ = 0;
                ForeignObject0Data s9_ = this.foreignObject0_cache;
                if ((state_0 & 0x200) != 0) {
                    while (!(s9_ == null || s9_.interop_.accepts(operandNodeValue) && JSGuards.isForeignObject(operandNodeValue))) {
                        s9_ = s9_.next_;
                        ++count9_;
                    }
                }
                if (s9_ == null && JSGuards.isForeignObject(operandNodeValue) && count9_ < 5) {
                    s9_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                    s9_.interop_ = (InteropLibrary)s9_.insertAccessor(INTEROP_LIBRARY_.create(operandNodeValue));
                    MemoryFence.storeStore();
                    this.foreignObject0_cache = s9_;
                    this.state_0_ = state_0 |= 0x200;
                }
                if (s9_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doForeignObject(operandNodeValue, s9_.interop_);
                    return bl;
                }
            }
            InteropLibrary foreignObject1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isForeignObject(operandNodeValue)) {
                    foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(operandNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.foreignObject0_cache = null;
                    state_0 &= 0xFFFFFDFF;
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doForeignObject(operandNodeValue, foreignObject1_interop__);
                    return bl;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ForeignObject0Data s9_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x7FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x7FF & (state_0 & 0x7FF) - 1) == 0 && ((s9_ = this.foreignObject0_cache) == null || s9_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[12];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSType";
        if ((state_0 & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.jSType_proxyBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObject0Data s9_ = this.foreignObject0_cache;
            while (s9_ != null) {
                cached.add(Arrays.asList(s9_.interop_));
                s9_ = s9_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSTypeofIdenticalNode create(JavaScriptNode childNode, JSTypeofIdenticalNode.Type type) {
        return new JSTypeofIdenticalNodeGen(childNode, type);
    }

    @GeneratedBy(value=JSTypeofIdenticalNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

