/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport;

import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.importexport.wizard.ex.ExportWizard;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class ExportAction
extends SystemAction {
    public String getName() {
        return "Export Configuration";
    }

    protected String iconResource() {
        return "com/paterva/maltego/importexport/resources/ExportConfig.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent e) {
        HashMap<String, String> descriptionAndIcons = new HashMap<String, String>();
        descriptionAndIcons.put("item_selection_description", "Select the configuration items you which to export to a Maltego archive file.");
        descriptionAndIcons.put("item_selection_icon", "com/paterva/maltego/importexport/resources/ExportConfig.png");
        descriptionAndIcons.put("progress_description", "The summary of the progress to export configurations to a Maltego archive file is shown below.");
        descriptionAndIcons.put("progress_icon", "com/paterva/maltego/importexport/resources/ExportConfig.png");
        descriptionAndIcons.put("file_description", "Choose the name and location on your file system to save the Maltego archive file. The file can optionally be encrypted by selecting the \"Encrypt (AES-128)\" checkbox.");
        descriptionAndIcons.put("file_icon", "com/paterva/maltego/importexport/resources/ExportConfig.png");
        descriptionAndIcons.put("main_selection_description", "Choose whether to export all the configuration items or a custom selection thereof.");
        descriptionAndIcons.put("main_selection_icon", "com/paterva/maltego/importexport/resources/ExportConfig.png");
        descriptionAndIcons.put("password_description", "Enter the password with which to encrypt the Maltego archive file.");
        descriptionAndIcons.put("password_icon", "com/paterva/maltego/importexport/resources/ExportConfig.png");
        this.perform(Lookup.getDefault(), descriptionAndIcons);
    }

    public void perform(Lookup lookup, Map<String, String> descriptionAndIcons) {
        ConfigExporter[] exporters = ConfigExporter.getAll(lookup);
        if (exporters.length == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen export operation is not available in this version of Maltego."));
        } else {
            WizardUtilities.runWizard((WizardDescriptor)ExportWizard.create(exporters, descriptionAndIcons));
        }
    }
}

