/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.cloud.data.KeyPair;
import com.maltego.cloud.data.SymmetricEncryptionConfig;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GraphKey {
    private final UUID id;
    private final String graphId;
    private final UUID caseKeyId;
    private final SymmetricEncryptionConfig encryptionConfig;
    private final String encryptedKey;

    public GraphKey(String graphId, UUID caseKeyId, SymmetricEncryptionConfig encryptionConfig, String encryptedKey) {
        this(null, graphId, caseKeyId, encryptionConfig, encryptedKey);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public GraphKey(@JsonProperty(value="id", required=true) UUID id, @JsonProperty(value="graphId") String graphId, @JsonProperty(value="caseKeyId", required=true) UUID caseKeyId, @JsonProperty(value="encryptionConfig", required=true) SymmetricEncryptionConfig encryptionConfig, @JsonProperty(value="encryptedKey", required=true) String encryptedKey) {
        this.id = id;
        this.graphId = graphId;
        this.caseKeyId = caseKeyId;
        this.encryptionConfig = encryptionConfig;
        this.encryptedKey = encryptedKey;
    }

    public UUID getId() {
        return this.id;
    }

    public String getGraphId() {
        return this.graphId;
    }

    public UUID getCaseKeyId() {
        return this.caseKeyId;
    }

    public SymmetricEncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyPair)) {
            return false;
        }
        GraphKey graphKey = (GraphKey)o;
        return Objects.equals(this.id, graphKey.id) && Objects.equals(this.graphId, graphKey.graphId) && Objects.equals(this.caseKeyId, graphKey.caseKeyId) && Objects.equals(this.encryptionConfig, graphKey.encryptionConfig) && Objects.equals(this.encryptedKey, graphKey.encryptedKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.graphId, this.caseKeyId, this.encryptionConfig, this.encryptedKey);
    }

    public String toString() {
        return "GraphKey{id=" + this.id + ", graphId=" + this.graphId + ", caseKeyId=" + this.caseKeyId + ", encryptionConfig=" + this.encryptionConfig + ", encryptedKey=" + this.encryptedKey + '}';
    }
}

