/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class CloseAllGraphsAction
extends CallableSystemAction {
    public CloseAllGraphsAction() {
        this.putProperty("noIconInMenu", Boolean.TRUE);
    }

    protected void initialize() {
        super.initialize();
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("opened".equals(evt.getPropertyName())) {
                    CloseAllGraphsAction.this.checkEnabled();
                }
            }
        });
        this.checkEnabled();
    }

    private void checkEnabled() {
        this.setEnabled(!GraphEditorRegistry.getDefault().getOpen().isEmpty());
    }

    public void performAction() {
        for (TopComponent tc : GraphEditorRegistry.getDefault().getOpen()) {
            tc.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
            tc.close();
        }
        this.checkEnabled();
    }

    public String getName() {
        return "Close All Graphs";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/New.png";
    }
}

